/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.time_series;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.time_series.TimeSeriesHead;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QTimeSeriesHeads;
import com.dataiku.gh.core.storage.sql.model.QTimeSeriesHeadsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.storage.time_series.ITimeSeriesHeadDAO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class TimeSeriesHeadDAO
extends AbstractPostgreSQLClient
implements ITimeSeriesHeadDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.time-series-head");
    @Autowired
    private IHistoryDataService historyDataService;

    @Override
    public String newId() throws IOException {
        try {
            SQLQuery sqlQuery = this.sqlQueryFactory.select((Expression)SQLExpressions.nextval((String)"time_series_seq"));
            long seq = this.querydslJdbcTemplate.queryForObject(sqlQuery, Long.class);
            return Long.toString(seq);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public boolean exists(String id) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QTimeSeriesHeads.timeSeriesHeads)).where((Predicate)QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadId.eq((Object)id));
            return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void create(TimeSeriesHead timeSeriesHead) throws IOException {
        try {
            SQLInsertClause insertQuery = (SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QTimeSeriesHeads.timeSeriesHeads).set(QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson, QueryBuilderUtils.toJsonb(timeSeriesHead));
            this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insertQuery);
            HistoryRevision revision = this.historyDataService.createRevision(RevisionType.ADD, EntityType.TIME_SERIES_HEAD);
            SQLInsertClause insertHistoryQuery = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QTimeSeriesHeadsHistory.timeSeriesHeadsHistory).set(QTimeSeriesHeadsHistory.timeSeriesHeadsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QTimeSeriesHeadsHistory.timeSeriesHeadsHistory.timeSeriesHeadJson, QueryBuilderUtils.toJsonb(timeSeriesHead));
            this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insertHistoryQuery);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public TimeSeriesHead get(String id) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson).from((Expression)QTimeSeriesHeads.timeSeriesHeads)).where((Predicate)QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadId.eq((Object)id));
            return this.querydslJdbcTemplate.queryForObject(query, new TimeSeriesHeadRowMapper());
        }
        catch (IncorrectResultSizeDataAccessException e) {
            throw new NotFoundException("Time Series Head does not exist: " + id);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public Stream<TimeSeriesHead> listTimeSeriesHeadStream(List<String> ids) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson).from((Expression)QTimeSeriesHeads.timeSeriesHeads)).where((Predicate)QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadId.in(ids));
            return this.querydslJdbcTemplate.queryForStream(query, new TimeSeriesHeadRowMapper());
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void deleteOwnersFromTimeSeriesHeads(String owner) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select((Expression)QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadId).from((Expression)QTimeSeriesHeads.timeSeriesHeads)).where((Predicate)QueryBuilderUtils.jsonString(QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson, new String[]{"owner"}).eq((Object)owner));
            Stream<String> queryStream = this.querydslJdbcTemplate.queryForStream(query, (rs, num) -> rs.getString(ColumnMetadata.getName((Path)QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadId)));
            SQLUpdateClause update = this.sqlQueryFactory.update((RelationalPath)QTimeSeriesHeads.timeSeriesHeads);
            SQLInsertClause insertHistory = this.sqlQueryFactory.insert((RelationalPath)QTimeSeriesHeadsHistory.timeSeriesHeadsHistory);
            AtomicBoolean hasAtLeastOneMatch = new AtomicBoolean(false);
            queryStream.forEach(id -> {
                HistoryRevision historyRevision;
                hasAtLeastOneMatch.set(true);
                ((SQLUpdateClause)((SQLUpdateClause)update.set(Collections.singletonList(QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson), Collections.singletonList(Expressions.template(Object.class, (String)"{0} - 'owner'", (Object[])new Object[]{QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson})))).where((Predicate)QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadId.eq(id))).addBatch();
                SQLQuery getNewJson = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson).from((Expression)QTimeSeriesHeads.timeSeriesHeads)).where((Predicate)QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadId.eq(id));
                try {
                    historyRevision = this.historyDataService.createRevision(RevisionType.UPDATE, EntityType.TIME_SERIES_HEAD);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                ((SQLInsertClause)((SQLInsertClause)insertHistory.set(QTimeSeriesHeadsHistory.timeSeriesHeadsHistory.timeSeriesHeadJson, (Object)getNewJson)).set(QTimeSeriesHeadsHistory.timeSeriesHeadsHistory._revisionJson, QueryBuilderUtils.toJsonb(historyRevision))).addBatch();
            });
            if (hasAtLeastOneMatch.get()) {
                this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)update);
                this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insertHistory);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    public static class TimeSeriesHeadRowMapper
    implements RowMapper<TimeSeriesHead> {
        public TimeSeriesHead mapRow(ResultSet rs, int rowNum) throws SQLException {
            return (TimeSeriesHead)JSON.parse((String)rs.getString(ColumnMetadata.getName(QTimeSeriesHeads.timeSeriesHeads.timeSeriesHeadJson)), TimeSeriesHead.class);
        }
    }
}

