/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.NoRemoteFutureService;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.BackendAPITicketService;
import com.dataiku.dip.server.SlowAndFailInterceptor;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.DebugTransactionRegistry;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DKUDebugUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.NamedRWLock;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.com.google.common.base.Stopwatch;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionKernelPool;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.futures.FutureThread;
import com.dataiku.gh.maintainance.GenericUsageSummaryReportsService;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.dataiku.gh.server.services.PubSubService;
import com.dataiku.gh.server.services.UsersService;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DebugController
extends DIPInternalControllerBase {
    private static DKULogger logger = DKULogger.getLogger((String)"debugging");
    @Autowired
    private MetaAuthService metaAuthService;
    @Autowired
    private UIAuthService uiAuthService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private NoRemoteFutureService futureService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private GenericUsageSummaryReportsService genericUsageSummaryReportsService;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private IPythonExecutionKernelPool pythonExecutionKernelPool;

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/kill-backend"})
    public void killBackend(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        System.err.println("********** Exiting on forced request");
        System.exit(1);
    }

    @AuditedCall(value={"msgType", "slow-transaction-simulate"})
    @RequestMapping(value={"/api/debugging/slow-transaction"})
    public void slowTransaction(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="20000") int durationMs, @RequestParam(defaultValue="false") boolean rw) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        if (rw) {
            try (RWTransaction t = this.transactionService.beginWriteAsDSS();){
                Thread.sleep(durationMs);
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            Thread.sleep(durationMs);
        }
        resp.setStatus(200);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-backend-stacks"})
    public void getBackendStacks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        DKUDebugUtils.printAllStacks((Writer)resp.getWriter());
    }

    @AuditedCall(value={"msgType", "fake-slow-code"})
    @RequestMapping(value={"/api/debugging/fake-slow-code"})
    public void markSlowCodeInTxn(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.uiAuthService.failIfNotAdminNoXSRF(req);
            PerfUtils.markSlowCode();
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-transactions-state"})
    public void dumpTransactionsState(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting transactions state dump");
        DebugTransactionRegistry dtr = (DebugTransactionRegistry)SpringUtils.getBean(DebugTransactionRegistry.class);
        String dump = dtr.getTransactionStateDump();
        logger.info((Object)dump);
        resp.getWriter().write("Currently running transactions\n");
        resp.getWriter().write(dump);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/debugging/slow-fail"})
    public void slowFail(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="fail", defaultValue="false", required=false) boolean fail, @RequestParam(value="delay", defaultValue="0", required=false) int delay) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        SlowAndFailInterceptor.callsDelay = delay;
        SlowAndFailInterceptor.failCalls = fail;
        if (fail) {
            resp.getWriter().write("From now on, all backend calls will return an HTTP 503 error.");
        } else if (delay > 0) {
            resp.getWriter().write("From now on, all backend calls will be slower. Delay: " + delay + " msec");
        } else {
            resp.getWriter().write("From now on, all backend calls will behave as normal (no additional delay or failure).");
        }
        resp.getWriter().flush();
    }

    @RequestMapping(value={"/api/debugging/read-and-write-slow-serialization"})
    @ResponseBody
    public SlowClass testSlowReadWrite(@RequestParam(defaultValue="{}") SlowClass input, HttpServletRequest req) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req, false);
        logger.info((Object)"Testing slow read write");
        return new SlowClass();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/generate-logs"})
    @ResponseBody
    public Long generateLotsOfLogs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"Starting log dump...");
        int nbThreads = 100;
        int nbLogsByThread = 500;
        int maxLogDelayMs = 20;
        ExecutorService executor = Executors.newFixedThreadPool(nbThreads);
        Stopwatch counter = Stopwatch.createStarted();
        for (int t = 0; t < nbThreads; ++t) {
            executor.submit(() -> {
                try {
                    for (int i = 1; i <= nbLogsByThread; ++i) {
                        Thread.sleep(ThreadLocalRandom.current().nextInt(0, maxLogDelayMs));
                        logger.debug((Object)("Mass generating logs " + i + "/" + nbLogsByThread));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        logger.info((Object)("Log dump took " + String.valueOf(counter.elapsed())));
        return counter.elapsed(TimeUnit.SECONDS);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/generate-audit"})
    @ResponseBody
    public Long generateLotsOfAudit(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="40") int nbThreads, @RequestParam(defaultValue="5000") int nbEventsPerThread, @RequestParam(defaultValue="2") int maxDelayBetweenEvents) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)("Starting audit flood with " + nbThreads + " threads"));
        ExecutorService executor = Executors.newFixedThreadPool(nbThreads);
        Stopwatch counter = Stopwatch.createStarted();
        AuditTrailService ats = (AuditTrailService)SpringUtils.getBean(AuditTrailService.class);
        int t = 0;
        while (t < nbThreads) {
            int tf = t++;
            executor.submit(() -> {
                logger.info((Object)("Thread " + tf + " starting to emit audit"));
                try {
                    for (int i = 1; i <= nbEventsPerThread; ++i) {
                        if (maxDelayBetweenEvents > 0) {
                            Thread.sleep(ThreadLocalRandom.current().nextInt(0, maxDelayBetweenEvents));
                        }
                        if (i % 2 == 0) {
                            ats.generic("fake-flooding-audit").with("projectKey", "A project").with("authCtx", "some-authctx").emit();
                            continue;
                        }
                        ats.emittable("allcalls", null).with("msgType", "fake-flooding-audit").with("projectKey", "A project").with("authCtx", "some-authctx").emit();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.info((Object)("Thread " + tf + " done emitting audit"));
            });
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.HOURS);
        logger.info((Object)("Audit generation took " + counter.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return counter.elapsed(TimeUnit.SECONDS);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-named-locks"})
    public void dumpNamedLocks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        NamedLock.LockInfo info;
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting named locks dump");
        Map map = NamedLock.dumpAcquiredLocksInfo();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            info = (NamedLock.LockInfo)entry.getValue();
            Object x = "";
            if (info.isLocked) {
                x = "[LOCK] " + name;
                Thread t = info.owner;
                x = (String)x + " owner=" + (t == null ? null : t.getName() + "(" + t.getId() + ")");
                if (t != null) {
                    x = (String)x + "\n";
                    StackTraceElement[] stackTraceElementArray = t.getStackTrace();
                    int n = stackTraceElementArray.length;
                    for (int i = 0; i < n; ++i) {
                        StackTraceElement elt = stackTraceElementArray[i];
                        x = (String)x + "\t" + elt.toString() + "\n";
                    }
                }
            } else {
                x = (String)x + "[FREE] " + name;
            }
            resp.getWriter().write((String)x + "\n");
            logger.info(x);
        }
        map = NamedRWLock.dumpAcquiredLocksInfo();
        for (Map.Entry entry : map.entrySet()) {
            String x = "[RWLOCK] " + (String)entry.getKey();
            info = (NamedRWLock.RWLockInfo)entry.getValue();
            Thread t = info.owner;
            x = x + " writeOwner=" + (t == null ? null : t.getName() + "(" + t.getId() + ")");
            x = x + " readersCount=" + info.readLockCount;
            x = x + " queueLength=" + info.queueLength;
            if (t != null) {
                x = x + "\n";
                for (StackTraceElement elt : t.getStackTrace()) {
                    x = x + "\t" + elt.toString() + "\n";
                }
            } else {
                x = x + " (FREE)";
            }
            resp.getWriter().write(x + "\n");
            logger.info((Object)x);
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-metrics"})
    public void dumpMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean gc) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting metrics dump");
        DKUDebugUtils.printMetrics((OutputStream)resp.getOutputStream(), (boolean)gc);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/clear-clearable-metrics"})
    public void clearClearableMetrics(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: clearing metrics");
        DSSMetrics.clearAllTimersAndMeters();
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-file-cache-inspection"})
    public void dumpFileCacheInspection(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting file cache inspection");
        this.transactionService.getCache().inspectionData((Appendable)resp.getWriter());
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-file-cache-item"})
    public void dumpFileCacheInspection(HttpServletRequest req, HttpServletResponse resp, @RequestParam String path) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting file cache inspection");
        resp.getWriter().write(this.transactionService.getCache().fullDumpItem(path));
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-api-tickets"})
    public void dumpTickets(HttpServletRequest req, HttpServletResponse resp) throws IOException, DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        logger.info((Object)"HTTP: requesting API tickets dump");
        BackendAPITicketService ticketService = (BackendAPITicketService)SpringUtils.getBean(BackendAPITicketService.class);
        resp.getWriter().write("Id\tCreation\tAuthCtx\n");
        for (APITicketService.Ticket ti : ticketService.getAllActiveTickets()) {
            resp.getWriter().write(ti.id);
            resp.getWriter().write("\t");
            resp.getWriter().write(DKUDateUtils.isoFormatLocal((long)ti.creationTime));
            resp.getWriter().write("\t");
            resp.getWriter().write(ti.getOriginalUser().toString());
            resp.getWriter().write("\n");
        }
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/run-fake-future"})
    public void fakeFuture(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam String payloadClassName, @RequestParam String payloadMethodName, @RequestParam boolean randomUser) throws Exception {
        FuturePayload payload;
        GHAuthCtx authCtx;
        Random random = new Random();
        try (Transaction t = this.transactionService.beginRead();){
            this.uiAuthService.failIfNotAdmin(req);
            authCtx = (GHAuthCtx)this.uiAuthService.getMandatoryUser(req);
            if (randomUser) {
                List<UsersDAO.User> users = this.usersService.listUsersInternalUnsafeEnabledOnly();
                int picked = random.nextInt(users.size());
                authCtx = GHAuthCtx.forUserLogin(users.get(picked));
            }
            Class<?> payloadClass = Class.forName(payloadClassName);
            Method payloadMethod = null;
            for (Method method : payloadClass.getDeclaredMethods()) {
                if (!method.getName().equals(payloadMethodName)) continue;
                payloadMethod = method;
                break;
            }
            ArrayList params = Lists.newArrayList();
            String[] parameterNames = null;
            try {
                StandardReflectionParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();
                parameterNames = discoverer.getParameterNames(payloadMethod);
            }
            catch (Throwable e) {
                logger.info((Object)"Cannot get method parameter names", e);
            }
            assert (payloadMethod != null);
            Class<?>[] parameterTypes = payloadMethod.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<FutureThread> parameterType = parameterTypes[i];
                String parameterName = parameterNames != null ? parameterNames[i] : "";
                logger.info((Object)("param " + parameterName + " of type " + parameterType.getCanonicalName()));
                FakeFutureThread param = null;
                if (parameterType.isAssignableFrom(FutureThread.class)) {
                    FuturePayload fakePayload = new FuturePayload();
                    fakePayload.displayName = "fake in fake";
                    param = new FakeFutureThread(authCtx, fakePayload);
                }
                params.add(param);
            }
            payload = (FuturePayload)payloadMethod.invoke(null, params.toArray(new Object[0]));
        }
        FakeFutureThread ft = new FakeFutureThread(authCtx, payload);
        FutureResponse fr = this.futureService.runFuture((FutureThreadBase)ft, 100L, (TypeToken)new TypeToken<FutureResponse<String>>(){});
        DebugController.writeJSON((HttpServletResponse)resp, (Object)fr);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/build-usage-summary-reports"})
    public void buildUsageSummaryReports(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.genericUsageSummaryReportsService.saveAll();
    }

    @RequestMapping(value={"/api/debugging/invalidate-in-memory-keys"})
    @ResponseBody
    public void clearInMemoryKeys(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.publicAPIKeysService.invalidateInMemoryAPIKeys();
    }

    @RequestMapping(value={"/api/debugging/list-in-memory-keys"})
    @ResponseBody
    public List<LegacyGlobalScopePublicAPIKey> listInMemoryKeys(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        return this.publicAPIKeysService.listInMemoryAPIKeys();
    }

    @RequestMapping(value={"/api/debugging/put-in-memory-key-in-the-past"})
    @ResponseBody
    public void putInMemoryKeyInThePast(HttpServletRequest req, HttpServletResponse resp, @RequestParam String keyId) throws DKUSecurityException {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.publicAPIKeysService.putInMemoryAPIKeyInThePast(keyId);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/set-global-log-level"})
    public void setGlobalLogLevel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String level) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        Logger.getRootLogger().setLevel(Level.toLevel((String)level));
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/set-logger-log-level"})
    public void setLoggerLogLevel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String logger, @RequestParam String level) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, true);
        Logger.getLogger((String)logger).setLevel(Level.toLevel((String)level));
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/dump-python-execution"})
    @ResponseBody
    public PythonExecutionDump dumpPythonExecution(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean full) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req, false);
        PythonExecutionDump dump = new PythonExecutionDump();
        dump.pythonExecutionPool = this.pythonExecutionKernelPool.dump(full);
        return dump;
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/kill-python-execution-kernels"})
    public void killPythonExecutionKernels(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.pythonExecutionKernelPool.killAllKernels(KernelPool.DeathReason.DEBUG);
    }

    @AuditedCall(value={"msgType", "internal-debug"})
    @RequestMapping(value={"/api/debugging/kill-python-execution-requests"})
    @ResponseBody
    public void killPythonExecutionRequests(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.metaAuthService.verifyDebugAccess_NT(req);
        this.pythonExecutionKernelPool.killAllRequests();
    }

    static {
        JSON.registerFactory((TypeAdapterFactory)new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getType() != SlowClass.class) {
                    return null;
                }
                final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, typeToken);
                return new TypeAdapter<T>(){

                    public void write(JsonWriter jsonWriter, T t) throws IOException {
                        logger.info((Object)"Will write SlowClass, starting to sleep");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        logger.info((Object)"Done writing SlowClass");
                        delegate.write(jsonWriter, t);
                    }

                    public T read(JsonReader jsonReader) throws IOException {
                        logger.info((Object)"Will read SlowClass, starting to sleep");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        logger.info((Object)"Done reading SlowClass");
                        return delegate.read(jsonReader);
                    }
                };
            }
        });
    }

    public static class SlowClass {
        int x = 4;
    }

    private static class FakeFutureThread
    extends FutureThread<String> {
        private final FuturePayload payload;

        FakeFutureThread(GHAuthCtx authCtx, FuturePayload payload) {
            super(authCtx);
            this.payload = payload;
        }

        public FuturePayload getPayload() {
            return this.payload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public String getResult() {
            return "done";
        }

        public void execute() throws Exception {
            try (FutureProgress.AutocloseableFutureProgressState state0 = FutureProgress.pushAutoCloseableState((String)"level 0", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.FILES);){
                for (int i0 = 0; i0 < 5; ++i0) {
                    try (FutureProgress.AutocloseableFutureProgressState state1 = FutureProgress.pushAutoCloseableState((String)"level 1", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.RECORDS);){
                        for (int i1 = 0; i1 < 5; ++i1) {
                            try (FutureProgress.AutocloseableFutureProgressState state2 = FutureProgress.pushAutoCloseableState((String)"level 2", (double)5000.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE);){
                                for (int i2 = 0; i2 < 5; ++i2) {
                                    try (FutureProgress.AutocloseableFutureProgressState state3 = FutureProgress.pushAutoCloseableState((String)"level 3", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                                        for (int i3 = 0; i3 < 5; ++i3) {
                                            Thread.sleep(50L);
                                            state3.increment(1.0);
                                        }
                                    }
                                    state2.increment(1000.0);
                                }
                            }
                            state1.increment(1.0);
                        }
                    }
                    state0.increment(1.0);
                }
            }
        }
    }

    public static class PythonExecutionDump {
        public KernelPool.PoolDump pythonExecutionPool;
    }
}

