/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.NoRemoteFutureService;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.ExternalUser;
import com.dataiku.dip.security.auth.FetchedUsersResponse;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.DkuUsersService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.futures.GovernActionSimpleFutureThread;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.futures.SimpleFutureThread;
import com.dataiku.gh.security.AuthCtxCreationService;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.server.services.GeneralSettingsService;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UsersController
extends DIPInternalControllerBase {
    private static final String OAUTH_2_FRONTEND_ROUTE = "/oauth2-callback";
    private static final String USER_STATE_PARAMETER = "userState";
    private static final String SUCCESS_PARAMETER = "success";
    private static final String MESSAGE_PARAMETER = "message";
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private UsersService service;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private SessionsDAO sessionsDAO;
    @Autowired
    private LicenseStatusService licenseService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private NoRemoteFutureService futureService;
    @Autowired
    private DkuUsersService usersService;
    @VisibleForTesting
    int syncUsersFutureWaitTime = 0;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.admin.security");

    @AuditedCall(value={"msgType", "security-users-list"})
    @RequestMapping(value={"/api/security/list-users"})
    public void listUsers(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String workspaceKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            List<UsersService.UIUser> users = this.service.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx);
            UsersController.writeJSON((HttpServletResponse)resp, users);
        }
    }

    @AuditedCall(value={"msgType", "security-groups-list-and-options"})
    @RequestMapping(value={"/api/security/list-groups-with-security-options"})
    public void listGroupsAndSecurityOptions(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean localOnly) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.listGroupNamesWithSecurity(authCtx, localOnly));
        }
    }

    @AuditedCall(value={"msgType", "security-groups-list"})
    @RequestMapping(value={"/api/security/list-groups"})
    public void listGroups(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean localOnly) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            UsersController.writeJSON((HttpServletResponse)resp, this.service.listGroupNames(authCtx, localOnly));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-groups-list"})
    @RequestMapping(value={"/api/security/list-groups-full"})
    public void listGroupsFull(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
            UsersController.writeJSON((HttpServletResponse)resp, this.service.listGroupsFull());
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-prepare-edit"})
    @RequestMapping(value={"/api/security/prepare-update-group"})
    public void prepareUpdateGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupData) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersDAO.Group group = (UsersDAO.Group)JSON.parse((String)groupData, UsersDAO.Group.class);
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareUpdateGroup_NT(group, u));
    }

    @AuditInline
    @RequestMapping(value={"/api/security/update-group"})
    @GovernAction(value=ActionType.GROUP_SAVE)
    public void updateGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(t.getUser());
            UsersDAO.Group group = (UsersDAO.Group)JSON.parse((String)groupData, UsersDAO.Group.class);
            GroupDiff groupDiff = this.service.updateGroup(group);
            t.commit("Updated user group " + group.name);
            this.auditTrailService.generic("security-admin-group-edit").with("group", group.name).withAll(groupDiff.getDiff()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-group-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-get", "group", "${groupName}"})
    @RequestMapping(value={"/api/security/get-group"})
    public void getGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.getGroup(groupName));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-prepare-delete", "group", "${groupName}"})
    @RequestMapping(value={"/api/security/prepare-delete-group"})
    public void prepareDeleteGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupName) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareDeleteGroup_NT(groupName, u));
    }

    @AuditedCall(value={"msgType", "security-admin-group-delete", "group", "${groupName}"})
    @RequestMapping(value={"/api/security/delete-group"})
    @GovernAction(value=ActionType.GROUP_DELETE)
    public void deleteGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
            this.service.deleteGroup(u, groupName);
            t.commit("Deleted user group " + groupName);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/security/create-group"})
    @GovernAction(value=ActionType.GROUP_CREATE)
    public void createGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam String groupData) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(t.getUser());
            UsersDAO.Group group = (UsersDAO.Group)JSON.parse((String)groupData, UsersDAO.Group.class);
            this.service.addGroup(group);
            t.commit("Created group " + group.name);
            this.auditTrailService.generic("security-admin-group-create").with("group", group.name).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-group-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/create"})
    @ResponseBody
    @GovernAction(value=ActionType.USER_CREATE)
    public InfoMessage.InfoMessages adminCreate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        try {
            AuthCtx authCtx = null;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.authService.failIfNotAdmin(req);
                this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            }
            UsersService.UIUser usr = (UsersService.UIUser)JSON.parse((String)user, UsersService.UIUser.class);
            InfoMessage.InfoMessages ret = this.service.addUserAdmin_NT(usr, authCtx);
            this.auditTrailService.generic("security-admin-user-create").with("user", usr.login).emit();
            return ret;
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-user-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "security-admin-users-list"})
    @RequestMapping(value={"/api/admin/users/list"})
    public void adminList(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean lastActivity) throws Exception {
        List<UsersService.UIUser> users;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            users = this.service.listUsers_RestrictionCheck_NoLeak(authCtx, null, true, true);
        }
        if (lastActivity) {
            Map<String, UserLastActivity> allActivity = this.service.getAllUsersActivity(true);
            for (UsersService.UIUser user : users) {
                user.activity = allActivity.getOrDefault(user.login, new UserLastActivity(user.login));
            }
        }
        UsersController.writeJSON((HttpServletResponse)resp, users);
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-edit"})
    @RequestMapping(value={"/api/admin/users/prepare-edit"})
    public void prepareEdit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersService.UIUser usr = (UsersService.UIUser)JSON.parse((String)user, UsersService.UIUser.class);
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareEditUser_NT(usr, u));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/edit"})
    @GovernAction(value=ActionType.USER_SAVE)
    public void adminEdit(HttpServletRequest req, HttpServletResponse resp, @RequestParam String user) throws Exception {
        UsersDAO.User oldUser;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            UsersService.UIUser usr = (UsersService.UIUser)JSON.parse((String)user, UsersService.UIUser.class);
            oldUser = this.usersDAO.getOrNull(usr.login);
            UserDiff userDiff = this.service.editUserFromUI_NoCheck(usr, authCtx);
            t.commit("Edited user " + usr.login);
            this.auditTrailService.generic("security-admin-user-edit").with("user", usr.login).withAll(userDiff.getDiff()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("security-admin-user-edit", (Throwable)e).emit();
            throw e;
        }
        this.usersService.sendWelcomeEmailWhenProfileChange((DkuUser)oldUser);
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-assign-groups"})
    @RequestMapping(value={"/api/admin/users/prepare-assign-groups"})
    public void prepareAssignUsersToGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> groupsToAdd, @RequestParam List<String> groupsToRemove, @RequestParam List<String> logins) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(u);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareAssignUsersToGroups_NT(logins, groupsToAdd, groupsToRemove, u));
    }

    @AuditedCall(value={"msgType", "security-admin-user-assign-groups", "groupsToAdd", "${groupsToAdd}", "groupsToRemove", "${groupsToRemove}", "users", "${logins}"})
    @RequestMapping(value={"/api/admin/users/assign-groups"})
    @GovernAction(value=ActionType.USERS_ASSIGN_GROUPS)
    public void assignUsersToGroup(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> groupsToAdd, @RequestParam List<String> groupsToRemove, @RequestParam List<String> logins) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.service.assignUsersToGroups(logins, groupsToAdd, groupsToRemove, authCtx);
            this.auditTrailService.generic("security-admin-assign-groups").with("users", String.join((CharSequence)",", logins)).with("groups-to-remove", String.join((CharSequence)",", groupsToRemove)).with("groups-to-add", String.join((CharSequence)",", groupsToAdd)).emit();
            t.commit("Added users to groups " + String.valueOf(groupsToAdd) + " and removed from groups " + String.valueOf(groupsToRemove));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-assign-profile", "users", "${logins}", "new-profile", "${newProfile}"})
    @RequestMapping(value={"/api/admin/users/assign-profile"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.USERS_ASSIGN_PROFILE)
    public void assignUsersToProfile(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins, @RequestParam String newProfile) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.service.assignUsersToProfile(logins, newProfile, authCtx);
            t.commit("Assigned users to profile " + newProfile);
        }
    }

    @AuditedCall(value={"msgType", "security-admin-user-get", "user", "${login}"})
    @RequestMapping(value={"/api/admin/users/get"})
    public void adminGet(HttpServletRequest req, HttpServletResponse resp, @RequestParam String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.getUserForUI_WithSensitive(login));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-delete", "users", "${logins}"})
    @RequestMapping(value={"/api/admin/users/prepare-delete"})
    public void prepareDelete(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareDeleteUsers_NT(logins, u));
    }

    @AuditedCall(value={"msgType", "security-admin-user-prepare-disable", "user", "${logins}"})
    @RequestMapping(value={"/api/admin/users/prepare-disable"})
    public void prepareDisable(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins) throws Exception {
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
        }
        UsersController.writeJSON((HttpServletResponse)resp, (Object)this.service.prepareDisableUsers_NT(logins, u));
    }

    @AuditedCall(value={"msgType", "security-admin-user-delete", "users", "${logins}"})
    @RequestMapping(value={"/api/admin/users/delete"})
    @GovernAction(value=ActionType.USER_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
            this.service.deleteUsersAdmin(logins, u);
            t.commit("Deleted users " + String.valueOf(logins));
        }
    }

    @AuditedCall(value={"msgType", "security-admin-user-enable-disable", "users", "${logins}", "enable", "${enable}"})
    @RequestMapping(value={"/api/admin/users/enable-or-disable"})
    @GovernAction(value=ActionType.USERS_ENABLE_DISABLE)
    public void enableOrDisable(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> logins, @RequestParam boolean enable) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(u);
            this.service.enableDisableUsersAdmin(logins, u, enable);
            if (!enable) {
                for (String login : logins) {
                    this.sessionsDAO.removeExistingSessionsForUser(login);
                }
            }
            t.commit((enable ? "Enabled" : "Disabled") + " users " + String.valueOf(logins));
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/sync"})
    @ResponseBody
    @GovernAction(value=ActionType.USERS_SYNC)
    public FutureResponse<InfoMessage.InfoMessages> syncUsers(HttpServletRequest req, HttpServletResponse resp, final @RequestParam(required=false) List<String> logins) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(admin);
        }
        return this.futureService.runFuture((FutureThreadBase)new GovernActionSimpleFutureThread<InfoMessage.InfoMessages>(admin, ActionType.USERS_SYNC){

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                return UsersController.this.userAuthenticationService.explicitOnDemandSync(logins);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"syncUsers", (String)"Sync users from external sources");
            }
        }, (long)this.syncUsersFutureWaitTime, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-user-get-syncable-source-types"})
    @RequestMapping(value={"/api/admin/users/get-syncable-source-types"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<String> getSyncableSourceTypes(HttpServletRequest req) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.userAuthenticationService.getOnDemandSyncableSourceTypes();
    }

    @AuditedCall(value={"msgType", "security-admin-user-get-fetchable-source-types"})
    @RequestMapping(value={"/api/admin/users/get-fetchable-source-types"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<String> getFetchableSourceTypes(HttpServletRequest req) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        return this.userAuthenticationService.getFetchableSourceTypes();
    }

    @AuditedCall(value={"msgType", "security-admin-fetch-users"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/admin/users/fetch"})
    @ResponseBody
    public FutureResponse<FetchedUsersResponse> fetchUsers(HttpServletRequest req, final @RequestParam UserSourceType userSourceType, final @RequestParam UserQueryFilter userQueryFilter) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
        }
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<FetchedUsersResponse>(admin){

            @Override
            protected FetchedUsersResponse compute() throws ServerAuthenticationFailure {
                return UsersController.this.userAuthenticationService.fetchUsers(userSourceType, userQueryFilter);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchUsers", (String)"Fetch users from external sources");
            }
        }, (long)this.syncUsersFutureWaitTime, (TypeToken)new TypeToken<FutureResponse<FetchedUsersResponse>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-fetch-groups"})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/admin/groups/fetch"})
    @ResponseBody
    public FutureResponse<List<String>> fetchGroups(HttpServletRequest req, final @RequestParam UserSourceType userSourceType) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
        }
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<List<String>>(admin){

            @Override
            protected List<String> compute() throws ServerAuthenticationFailure {
                return UsersController.this.userAuthenticationService.fetchGroups(userSourceType);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchGroups", (String)"Fetch groups from external sources");
            }
        }, (long)this.syncUsersFutureWaitTime, (TypeToken)new TypeToken<FutureResponse<List<String>>>(){});
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/users/provision"}, method={RequestMethod.POST})
    @ResponseBody
    @GovernAction(value=ActionType.USERS_PROVISION)
    public FutureResponse<InfoMessage.InfoMessages> provisionUsers(HttpServletRequest req, final @RequestParam UserSourceType userSourceType, final @RequestParam Set<ExternalUser> users) throws Exception {
        AuthCtx admin;
        try (Transaction t = this.transactionService.beginRead();){
            admin = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(admin);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(admin);
        }
        return this.futureService.runFuture((FutureThreadBase)new GovernActionSimpleFutureThread<InfoMessage.InfoMessages>(admin, ActionType.USERS_PROVISION){

            @Override
            protected InfoMessage.InfoMessages compute() throws InterruptedException {
                return UsersController.this.userAuthenticationService.provisionUsers(userSourceType, users.stream().filter(e -> e.status == ExternalUser.Status.NOT_PROVISIONED).map(u -> u.userAttributes).collect(Collectors.toSet()));
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"provisionUsers", (String)"Provision users from external sources");
            }
        }, (long)this.syncUsersFutureWaitTime, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "user-profile-get", "user", "${login}"})
    @RequestMapping(value={"/api/profile/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String login, @RequestParam(required=false) boolean includeProfileAndTrialComputation) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx usr = this.authService.getMandatoryUser(req);
            login = StringUtils.isBlank((String)login) ? usr.getAssociatedDSSUserMand() : login;
            UsersService.UIUser user = this.service.getUserForUI_RestrictionCheck_UserSensitive(usr, login, includeProfileAndTrialComputation);
            UsersController.writeJSON((HttpServletResponse)resp, (Object)user);
        }
    }
}

