/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers.admin;

import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.maintainance.ScheduledTasksService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ScheduledTasksController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ScheduledTasksService tasksService;
    private static final Logger logger = Logger.getLogger((String)"dku.admin.scheduled");

    @AuditedCall(value={"msgType", "admin-get-scheduled-tasks-status"})
    @RequestMapping(value={"/api/admin/scheduled-tasks/get-status"})
    public void getSchedulerState(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        ScheduledTasksController.writeJSON((HttpServletResponse)resp, (Object)this.tasksService.getSchedulerState());
    }

    @AuditedCall(value={"msgType", "admin-fire-scheduled-task", "jobGroup", "${jobGroup}", "jobName", "${jobName}"})
    @RequestMapping(value={"/api/admin/scheduled-tasks/fire"})
    public void fireNow(HttpServletRequest req, HttpServletResponse resp, @RequestParam String jobGroup, @RequestParam String jobName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        this.tasksService.fireNow(jobGroup, jobName);
    }
}

