/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.namemapping;

import com.google.common.base.Optional;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.namemapping.NameMapping;

public class ChainedNameMapping
implements NameMapping {
    private NameMapping[] nameMappings;

    public ChainedNameMapping(NameMapping ... nameMappings) {
        if (nameMappings == null) {
            throw new NullPointerException("Name mapping array must not be null");
        }
        for (NameMapping nameMapping : nameMappings) {
            if (nameMapping != null) continue;
            throw new NullPointerException("Name mapping array must not contain null element");
        }
        this.nameMappings = (NameMapping[])nameMappings.clone();
    }

    @Override
    public Optional<String> getColumnOverride(SchemaAndTable key, String column) {
        for (NameMapping nameMapping : this.nameMappings) {
            Optional<String> overriddenColumnName = nameMapping.getColumnOverride(key, column);
            if (!overriddenColumnName.isPresent()) continue;
            return overriddenColumnName;
        }
        return Optional.absent();
    }

    @Override
    public Optional<SchemaAndTable> getOverride(SchemaAndTable key) {
        for (NameMapping nameMapping : this.nameMappings) {
            Optional<SchemaAndTable> overridden = nameMapping.getOverride(key);
            if (!overridden.isPresent()) continue;
            return overridden;
        }
        return Optional.absent();
    }
}

