#' Get the path to the directory of a input managed folder partition
#'
#' @param name the name of the folder
#' @param partition the identifier of the partition
#' @return The path on disk to the directory representing the partition
#'
#' @export
#' @importFrom httr POST
dkuManagedFolderPartitionFolder <- function(name, partition=NULL) {
    getPathURL = dku_intercom__get_jek_or_backend_url("/managed-folders/get-partition-paths")
    ref = dku__resolve_smart_name(name)

    resp = POST(getPathURL,body = list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref), partition=partition),
        encode="form",  dku__get_auth_headers(), dku_intercom__get_httr_config())

    dku__check_api_error(resp, "Failed to get Box path")
    data <- content(resp)

    return(data$info$folder)
}
