#' Writes a data.frame's schema to Dataiku's Data Science Studio
#' 
#' @param df A data.frame. The schema of this data.frame will be written to DSS
#' @param name The name of the DSS dataset to write to
#' @return None
#'
#' @details
#'
#' This function writes a dataset's schema to Dataiku's Data Science Studio.  
#' 
#' @examples
#' \dontrun{
#' # write the iris dataset's schema 
#' # to Data Science Studio
#' write.dataset_schema(iris, "irisDataiku")
#' }
#' @export
dkuWriteDatasetSchema <- function (df,name) {

    if(!is.data.frame(df)) {
        stop("The first argument of dkuWriteDatasetSchema must be a dataframe")
    }

    jsonData = RJSONIO::toJSON(dataframe_to_dss_schema(df))
    parsedRSpec <- getDkuFlowSpec()
    if (is.null(parsedRSpec)) {
    # Notebook mode
        name <-  dku__resolve_smart_name(name)
    } else {
    # Flow mode
        for(out in parsedRSpec[["out"]]) {
            if(out[["fullName"]] == name || out[["smartName"]] == name) {
                name = out[["fullName"]]
                found = TRUE
            }
        }
        if(!found) {
            stop(paste0("The dataset ",name," is not declared as output"))
        }
    }
    setSchemaUrl = dku_intercom__get_jek_or_backend_url("/datasets/set-schema/")
    resp = POST(setSchemaUrl,
    body = list(fullDatasetName=name,schemaData=jsonData,origin="r"),
        encode="form", dku__get_auth_headers(), dku_intercom__get_httr_config())
    if(resp$status != 200) {
        parsed = content(resp)
        stop(paste("Failed to write dataset:",parsed$detailedMessage))
    }
}
