import contextvars

from notebook.base.handlers import IPythonHandler, APIHandler

handler_context_var = contextvars.ContextVar('handler')

class DKUIPythonHandler(IPythonHandler):

    async def _execute(self, *args, **kwargs):
        """
        put the handler into the context
        """
        handler_context_var.set(self)
        await super()._execute(*args, **kwargs)

class DKUAPIHandler(APIHandler):

    async def _execute(self, *args, **kwargs):
        """
        put the handler into the context
        """
        handler_context_var.set(self)
        await super()._execute(*args, **kwargs)
