(function() {
    "use strict";

    const addDatasetWorkflowContainer = {
        bindings: {
            emptyState: '<',
            alternativeButton: '<',
            hideOtherSection: '<'
        },
        templateUrl: 'static/dataiku/add-dataset-workflow/add-dataset-workflow-container/add-dataset-workflow-container.html',
        controller: function($element, $scope, AddDatasetWorkflowService) {
            const ctrl = this;
            ctrl.flowScope = $scope.$parent;
            ctrl.step = 0
            ctrl.datasetsMenus = [];
            ctrl.pinnedItems = AddDatasetWorkflowService.pinnedItems;
            ctrl.flowOthersItems = [];
            ctrl.recipesMenus = [];

            function onDropdownClassChanged(mutationsList) {
                /*
                    The version of boostrap dropdown we are using doesn't trigger the dropdown lifecycle events (see bower_components/bootstrap-less/js/bootstrap-dropdown.js).
                    So we need to check when the class open is removed from the dropdown to reset the dropdowns.
                 */
                for (var mutation of mutationsList) {
                    if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                        if (ctrl.dropdownElement[0]) {
                            const dropdownClasses = ctrl.dropdownElement[0].className;
                            if (!dropdownClasses.includes('open')) {
                                // When the dropdown closes, we reset the step so that the dropdown components get reset.
                                ctrl.step = 0;
                            }
                        }
                    }
                }
            }

            ctrl.$onInit = function() {
                AddDatasetWorkflowService.getMenuData(ctrl.flowScope)
                    .then(results => {
                        ctrl.datasetsMenus = results.datasetsMenus;
                        ctrl.flowOthersItems = results.flowOthersItems;
                        ctrl.recipesMenus = results.recipesMenus;

                        AddDatasetWorkflowService.getPinnedItems(ctrl.flowScope);
                    })
                    .catch(setErrorInScope.bind(ctrl.flowScope));

                ctrl.dropdownElement = $element.find('.dropdown');
                ctrl.observer = new MutationObserver(onDropdownClassChanged);
                // Start observing the dropdown element for class changes
                ctrl.observer.observe(ctrl.dropdownElement[0], {
                    attributes: true,
                    attributeFilter: ['class'] // Only watch the class attribute
                });
            }

            ctrl.$onDestroy = function() {
                if (ctrl.observer) {
                    ctrl.observer.disconnect();
                }
            };


            ctrl.moveToNextStep = function() {
                ctrl.step = 2;
            }
        }
    }


    angular.module("dataiku.addDatasetWorkflow").component("addDatasetWorkflowContainer", addDatasetWorkflowContainer);
})();