(function() {
    'use strict';
    const app = angular.module('dataiku.homepage');

    app.component('homepageEmptyStateProjectTile', { // homepage-empty-state-project-tile
        templateUrl: 'static/dataiku/homepage/empty-states/homepage-empty-state-project-tile/homepage-empty-state-project-tile.html',
        bindings: {
            icon: '@',
            animationData: '@',
        },
        transclude: true,
        controller: function($timeout, $element) {
            const ctrl = this;

            let animation;
            ctrl.updateAnimationObject = (a) => {
                animation = a;
            }

            ctrl.startAnimation = () => {
                animation && animation.goToAndPlay(0, true);
            }

            ctrl.stopAnimation = () => {
                animation && animation.pause();
            }

            // if mouse is already over the element as it's created, ng-mouseenter doesn't get triggered. this takes care of initial state.
            $timeout(() => {
                if ($element.is(':hover')) {
                    ctrl.startAnimation()
                }
            }, 100);
        }
    });

})();
