(function(){
    'use strict';

    const requestProject = {
        bindings: {
            request: '<',
            requester: '<',
            requestingUserGroups: '<',
            selectedPermission: '<',
            selectedUserOrGroup: '=',
            projectName: '<',
            closer: '<',
            onChange: '&'
        },
        templateUrl: '/static/dataiku/inbox/components/request-center/request/request-project/request-project.component.html',
        controller: function(DataikuAPI, $filter) {
            this.callback = () => {
                const response = { selectedUserOrGroup: this.selectedUserOrGroup, selectedPermission: this.selectedPermission, type: 'ProjectAccessResponse'}; // keep type in sync with backend
                this.onChange({response});
            };

            this.selectedPermissionOptions = [
                {value: "PROJECT_READ", label: "Read project content"},
                {value: "PROJECT_WRITE", label: "Write project content"},
            ];

            this.groupByFn = (userGroupItem) => {
                return $filter('capitalize')($filter('lowercase')(userGroupItem.type));
            };

            this.disabledFn = (item) => {
                if (!this.projectSummary) {
                    return false;
                }
                switch (item.value) {
                case 'PROJECT_READ':
                    return !this.projectSummary.canReadProjectContent;
                case 'PROJECT_WRITE':
                    return !this.projectSummary.canWriteProjectContent;
                }
            };

            this.tooltipFn = (item) => {
                switch (item.value) {
                case 'PROJECT_READ':
                    return this.disabledFn(item) ? 'You don\'t have read permission for this project' : '';
                case 'PROJECT_WRITE':
                    return this.disabledFn(item) ? 'You don\'t have write permission for this project' : '';
                }
            };

            this.$onInit = () => {
                this.callback(); // initialize the selection

                if (this.request.status === "PENDING") {
                    // for pending requests, we need to check which permissions the user is allowed to grant
                    // we disable the permissions they don't have themselves
                    DataikuAPI.projects.getSummary(this.request.objectProjectKey).success(data => {
                        this.projectSummary = data.object;
                        this.selectedPermissionOptions = this.selectedPermissionOptions.map((option) => ({
                            value: option.value,
                            label: option.label,
                            disabled: this.disabledFn(option),
                            tooltip: this.tooltipFn(option)
                        }));
                    });
                }
            }
        }
    }

    angular.module('dataiku.inbox')
    .component('requestProject', requestProject);
})();
