(function(){
    'use strict';

    const requestStatus = {
        bindings: {
            request: '<',
            closer: '<'
        },
        template: `
            <span ng-if="$ctrl.request.status ==='REJECTED'" class="label--important">REJECTED</span>
            <span ng-if="$ctrl.request.status ==='APPROVED'" class="label--success ">APPROVED</span>
            <div ng-if="$ctrl.request.closingUser && ['APPROVED', 'REJECTED'].includes($ctrl.request.status)" class="request__body__content__who">
                <a ui-sref="profile.user.view({userLogin: $ctrl.request.closingUser})" toggle="tooltip" title="{{$ctrl.closer.displayName || $ctrl.request.closingUser}} (@{{$ctrl.request.closingUser}})">
                    <span size="24" user-picture="$ctrl.request.closingUser"></span>
                </a>
                <p class="dku-tiny-text text-weak">{{ $ctrl.closer.displayName || $ctrl.request.closingUser }} (@{{$ctrl.request.closingUser}}) - {{ $ctrl.request.closedOn | friendlyTimeDeltaShort }}</p>
            </div>
            <div ng-if="!$ctrl.request.closingUser && ['APPROVED', 'REJECTED'].includes($ctrl.request.status)">
                <p class="dku-tiny-text text-weak">{{$ctrl.request.closingMessage}} - {{ $ctrl.request.closedOn | friendlyTimeDeltaShort }}</p>
            </div>
        `,
    }

    angular.module('dataiku.inbox')
    .component('requestStatus', requestStatus);
})();
