(function(){"use strict";angular.module("dataiku.charts",["dataiku.constants"]);angular.module("dataiku.directives.simple_report",["dataiku.charts","dataiku.shared"])})();(function(){"use strict";angular.module("dataiku.charts").component("axisRangeSubform",{templateUrl:"/static/dataiku/js/simple_report/components/axis-range-subform/axis-range-subform.component.html",bindings:{axis:"@",chartType:"<",customExtent:"=",includeZero:"=?",editModeDisabled:"<"},controller:function(ChartsStaticData,ChartAxesUtils,ChartFeatures,$scope,$element){const ctrl=this;let minInput,maxInput;const NG_INVALID="ng-invalid";ctrl.extentEditModes=ChartsStaticData.extentEditModes;ctrl.getZeroDisabledMessage=getZeroDisabledMessage;ctrl.isManualMode=isManualMode;ctrl.onEditModeChange=onEditModeChange;ctrl.onMaxChange=onMaxChange;ctrl.onMinChange=onMinChange;ctrl.setExtentMax=setExtentMax;ctrl.setExtentMin=setExtentMin;ctrl.canChartIncludeZero=canChartIncludeZero;function setExtentMin(){if(ctrl.customExtent.manualExtent[0]!==null){const currentMax=ChartAxesUtils.getManualExtentMax(ctrl.customExtent);ctrl.customExtent.manualExtent[0]=validateExtentMin(currentMax,ctrl.customExtent.manualExtent[0]);validateMinInput()}else{$scope.$broadcast("formatManualExtent")}}function setExtentMax(){if(ctrl.customExtent.manualExtent[1]!==null){const currentMin=ChartAxesUtils.getManualExtentMin(ctrl.customExtent);ctrl.customExtent.manualExtent[1]=validateExtentMax(currentMin,ctrl.customExtent.manualExtent[1]);validateMaxInput()}else{$scope.$broadcast("formatManualExtent")}}function onMinChange(newMin){const currentMax=ChartAxesUtils.getManualExtentMax(ctrl.customExtent);if(newMin!==null&&parseFloat(newMin)>parseFloat(currentMax)){invalidateMinInput()}else{validateMinInput()}}function onMaxChange(newMax){const currentMin=ChartAxesUtils.getManualExtentMin(ctrl.customExtent);if(newMax!==null&&parseFloat(newMax)<parseFloat(currentMin)){invalidateMaxInput()}else{validateMaxInput()}}function isManualMode(){return ChartAxesUtils.isManualMode(ctrl.customExtent)}function canChartIncludeZero(){return ChartFeatures.canIncludeZero(ctrl.chartType)}function getZeroDisabledMessage(){if(ctrl.isManualMode()){return"This option is ignored in manual range edition."}}function onEditModeChange(){if(ctrl.isManualMode()){$scope.$broadcast("formatManualExtent")}}function validateExtentMin(currentMax,newMin){const min=parseFloat(newMin)>parseFloat(currentMax)?currentMax:newMin;return parseFloat(min)}function validateExtentMax(currentMin,newMax){const max=parseFloat(newMax)<parseFloat(currentMin)?currentMin:newMax;return parseFloat(max)}const getMinInput=()=>{if(!minInput){minInput=$element.find("input[name='min']")}return minInput};const getMaxInput=()=>{if(!maxInput){maxInput=$element.find("input[name='max']")}return maxInput};const validateMinInput=()=>getMinInput().removeClass(NG_INVALID);const validateMaxInput=()=>getMaxInput().removeClass(NG_INVALID);const invalidateMinInput=()=>getMinInput().addClass(NG_INVALID);const invalidateMaxInput=()=>getMaxInput().addClass(NG_INVALID)}})})();(function(){"use strict";angular.module("dataiku.charts").component("dashboardPageMenu",{templateUrl:"/static/dataiku/js/simple_report/components/dashboard-page-menu/dashboard-page-menu.component.html",bindings:{canEdit:"<",urlToCopy:"<",onDuplicate:"&",onEdit:"&",onRemove:"&"},controller:function(DashboardUtils){const ctrl=this;ctrl.copyURL=()=>{DashboardUtils.copyToClipboard(ctrl.urlToCopy)}}})})();(function(){"use strict";angular.module("dataiku.charts").component("discreteColorMenu",{templateUrl:"static/dataiku/js/simple_report/components/discrete-color-menu/discrete-color-menu.component.html",bindings:{geoLayer:"<?",geoIndex:"<?",chartDef:"<",legends:"<",usableColumns:"<"},controller:function($scope,$timeout,ChartCustomColors,ChartColorSelection,CHART_TYPES,DKU_PALETTE_NAMES){let subscription;const ctrl=this;ctrl.getColorOptions=()=>{return angular.copy(ChartColorSelection.getOptions(ctrl.chartDef,ctrl.geoLayer))};ctrl.setColorOptions=()=>{return ChartColorSelection.setOptions(angular.copy(ctrl.colorOptions),ctrl.chartDef,ctrl.geoLayer)};ctrl.isMeaningPalette=()=>{return ctrl.colorOptions.colorPalette===DKU_PALETTE_NAMES.MEANING};ctrl.isCustomPalette=()=>{return ctrl.colorOptions.colorPalette===DKU_PALETTE_NAMES.CUSTOM};ctrl.$onInit=()=>{ctrl.colorOptions=ctrl.getColorOptions();let geoLayerId;if(!_.isNil($scope.geoIndex)){geoLayerId=`geo-${$scope.geoIndex}`}const{id,colorOptions$}=ChartColorSelection.getOrCreateCustomColorsOptions(geoLayerId);ctrl.id=id;subscription=colorOptions$.subscribe(newColorOptions=>{ctrl.colorOptions=angular.copy(newColorOptions);ctrl.setColorOptions();$timeout(()=>$scope.$apply())});ChartCustomColors.updateInputColorOptions(id,angular.copy(ctrl.colorOptions))};ctrl.$onDestroy=()=>{if(subscription){subscription.unsubscribe()}ChartColorSelection.removeCustomColorsOptions([ctrl.id])};ctrl.getColorDimensionOrMeasure=()=>{return ChartColorSelection.getColorDimensionOrMeasure(ctrl.chartDef,ctrl.geoLayer)};ctrl.onColorOptionsChange=value=>{ChartCustomColors.updateInputColorOptions(ctrl.id,angular.copy(value))};ctrl.getLegend=(legends,geometryIndex)=>{const chartDef=ctrl.chartDef;if(!legends){return}if(chartDef.type!==CHART_TYPES.GEOMETRY_MAP||chartDef.geoLayers.length<3&&geometryIndex===undefined){return legends[0]}else{return legends[geometryIndex]}}}})})();(function(){"use strict";angular.module("dataiku.charts").component("displayLabelSubform",{templateUrl:"/static/dataiku/js/simple_report/components/display-label-subform/display-label-subform.component.html",bindings:{measure:"<",dimension:"<",chartDef:"<",helperText:"<"},controller:function(ChartLabels,ChartDefinitionChangeHandler,$scope,translate){const ctrl=this;$scope.translate=translate;ctrl.placeholder="";ctrl.measureOrNumericalDimension=null;ctrl.$onChanges=function(){ctrl.measureOrNumericalDimension=ctrl.measure||ctrl.dimension;ctrl.type=ctrl.measure?"measure":"dimension";ctrl.updatePlaceholder(ctrl.measureOrNumericalDimension,ctrl.type);ctrl.updatePossibleDimensionSorts(ctrl.type)};ctrl.updatePlaceholder=function(measureOrNumericalDimension,type){if(!measureOrNumericalDimension){ctrl.placeholder="";return}let getPlaceholder;if(measureOrNumericalDimension.isA==="ua"){getPlaceholder=ChartLabels.getUaLabel}else{getPlaceholder=type==="measure"?ChartLabels.getLongMeasureLabel:ChartLabels.getDimensionLabel}ctrl.placeholder=getPlaceholder(measureOrNumericalDimension)};ctrl.updatePossibleDimensionSorts=function(type){if(ctrl.chartDef&&type==="measure"){ctrl.chartDef.possibleDimensionSorts=ChartDefinitionChangeHandler.getStdDimensionPossibleSorts(ctrl.chartDef)}}}})})();(function(){"use strict";angular.module("dataiku.charts").component("dropdownNumberFormattingButton",{templateUrl:"static/dataiku/js/simple_report/components/dropdown-number-formatting-button/dropdown-number-formatting-button.html",bindings:{openSection:"=",chartDefKey:"=",toggleContextualMenu:"=",listIndex:"="},controller:function(ChartFormattingPaneSections,CHART_FORMATTING_PANE_PROPERTIES,FormattingPaneValues,$scope,translate){$scope.translate=translate;const ctrl=this;ctrl.openFormattingPane=function(event){const{openSection,chartDefKey,listIndex,toggleContextualMenu}=ctrl;toggleContextualMenu(event);const measureOrDimensionId=FormattingPaneValues.computeMeasureOrDimensionUniqueId(chartDefKey,listIndex);openSection(ChartFormattingPaneSections.DATA_VALUES,{[CHART_FORMATTING_PANE_PROPERTIES.DATA_VALUES_SELECTED_MEASURE_DIMENSION_KEY]:measureOrDimensionId});if(chartDefKey==="genericMeasures"&&FormattingPaneValues.valuesDisplayed$.getValue()===false){openSection(ChartFormattingPaneSections.VALUES,{[CHART_FORMATTING_PANE_PROPERTIES.VALUES_DISPLAY_SELECTED_MEASURE_KEY]:measureOrDimensionId})}}}})})();(function(){angular.module("dataiku.charts").component("invalidChartPlaceholder",{templateUrl:"/static/dataiku/js/simple_report/components/invalid-chart-placeholder/invalid-chart-placeholder.component.html",bindings:{validity:"<",chartType:"<",chartVariant:"<",isInDashboard:"<",isInPredicted:"<",canEdit:"<",computeChartPreview:"<",computeChartOptionsPreview:"<",revertToLinoEngineAndReload:"<",forceExecute:"<",rebuildSampling:"<"},controller:function(){const ctrl=this;ctrl.canErrorBeDisplayedBothInChartsAndDashboards=false;ctrl.$onChanges=function(){if(!_.isNil(ctrl.validity)){ctrl.canErrorBeDisplayedBothInChartsAndDashboards=ctrl.validity.type==="PIVOT_TABLE_TOO_MUCH_DATA"||ctrl.validity.type==="CORRUPTED_LINO_CACHE"||ctrl.validity.type==="EMPTY_CUSTOM_BINS"}}}})})();(function(){"use strict";angular.module("dataiku.charts").component("kpiHolder",{templateUrl:"/static/dataiku/js/simple_report/components/kpi-holder/kpi-holder.component.html",bindings:{chartDef:"<",theme:"<",data:"<",loadedCallback:"&"},controller:function($scope,$element,$timeout,ChartDataWrapperFactory,ChartFormatting,ChartLabels,ChartsStaticData,ConditionalFormattingOptions,CHART_TYPES){const ctrl=this;const VALUE_SELECTOR="kpi-holder-measure__value";const LABEL_SELECTOR="kpi-holder-measure__label";const MEASURE_SELECTOR="kpi-holder-measure";const ROUNDING=.9;const VALUE_HEIGHT_OVERFLOW=.17;const MIN_FONT_BEFORE_HIDDING_LABEL=30;const MAX_MARGINS=4;let valuePadding=0;ctrl.el=$element[0];const init=(theme=ctrl.theme)=>{if(!ctrl.data||!ctrl.chartDef||ctrl.chartDef.type!==CHART_TYPES.KPI){return}const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(ctrl.data);ctrl.chartDef.colorMode="COLOR_GROUPS";let basedOnMeasureIndexCounter=ctrl.chartDef.genericMeasures.length-1;ctrl.colorGroupByMeasureId=ctrl.chartDef.colorGroups?ctrl.chartDef.colorGroups.filter(({appliedColumns})=>!!appliedColumns).reduce((acc,{appliedColumns,colorMeasure,rules})=>{let groupColorMeasure;if(colorMeasure&&colorMeasure.length>0){basedOnMeasureIndexCounter+=1;groupColorMeasure=colorMeasure[0]}appliedColumns.forEach(column=>acc[ConditionalFormattingOptions.getMeasureId(column)]={rules:rules,basedOnMeasure:groupColorMeasure,basedOnMeasureIndex:groupColorMeasure?basedOnMeasureIndexCounter:-1});return acc},{}):[];ctrl.colorRulesClasses=ctrl.chartDef.genericMeasures.map((m,i)=>{const colorGroup=ctrl.colorGroupByMeasureId[ConditionalFormattingOptions.getMeasureId(m)];if(!colorGroup){return ConditionalFormattingOptions.getColorRuleClass("",[],m,theme)}const measureRules=colorGroup.rules;const basedOnMeasureIndex=colorGroup.basedOnMeasureIndex>=0?colorGroup.basedOnMeasureIndex:i;const ruleBaseValue=chartData.getAggrExtent(basedOnMeasureIndex)[0];const colorMeasure=colorGroup.basedOnMeasure||m;return ConditionalFormattingOptions.getColorRuleClass(ruleBaseValue,measureRules,colorMeasure,theme)});ctrl.multipleKPIs=ctrl.chartDef.genericMeasures.length>1;if(ctrl.multipleKPIs){valuePadding=MAX_MARGINS*2}for(let i=0;i<ctrl.chartDef.genericMeasures.length;i++){ctrl.sanitizeKpi(i)}const dimensions=[];for(let i=0;i<ctrl.chartDef.genericMeasures.length;i++){dimensions[i]=ctrl.getKpiBoxSize(i)}const computeMinValue=(hideAllLabels=false)=>{let minValueFontSize=Number.MAX_VALUE;for(let i=0;i<ctrl.chartDef.genericMeasures.length;i++){const hideLabel=hideAllLabels||!ctrl.chartDef.genericMeasures[i].showDisplayLabel;minValueFontSize=Math.min(minValueFontSize,ctrl.applyKpiValue(i,dimensions[i],hideLabel))}return minValueFontSize};let minValueFontSize=computeMinValue();const hideAllLabels=minValueFontSize<=MIN_FONT_BEFORE_HIDDING_LABEL;if(hideAllLabels){minValueFontSize=computeMinValue(true)}for(let i=0;i<ctrl.chartDef.genericMeasures.length;i++){ctrl.applyKpiLabel(i,dimensions[i],hideAllLabels)}for(let i=0;i<ctrl.chartDef.genericMeasures.length;i++){ctrl.applyFontSize(ctrl.el.getElementsByClassName(VALUE_SELECTOR)[i],ctrl.chartDef.genericMeasures[i].kpiValueFontSizeMode==="RESPONSIVE"?minValueFontSize*ctrl.chartDef.genericMeasures[i].responsiveTextAreaFill/100:ctrl.chartDef.genericMeasures[i].kpiValueFontSize)}ctrl.loadedCallback()};$scope.$on("window-resized-kpi",(_,{theme})=>$timeout(()=>init(theme),0));$scope.$watch("$viewContentLoaded",()=>$timeout(()=>init(),0));this.sanitizeKpi=function(index){const container=ctrl.el.getElementsByClassName(MEASURE_SELECTOR)[index];if(ctrl.multipleKPIs){container.style.margin=`${MAX_MARGINS}px`;container.style.padding=`${MAX_MARGINS}px`}const valueDom=ctrl.el.getElementsByClassName(VALUE_SELECTOR)[index];valueDom.textContent=" ";valueDom.style.fontSize="1px";valueDom.style.lineHeight="1px";valueDom.style.width="";const labelDom=ctrl.el.getElementsByClassName(LABEL_SELECTOR)[index];labelDom.style.display="";labelDom.textContent=" ";labelDom.style.width=""};this.applyKpiValue=function(index,containerDim,hidelabel){const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(ctrl.data);const kpiValueDom=ctrl.el.getElementsByClassName(VALUE_SELECTOR)[index];kpiValueDom.textContent=ChartFormatting.getForIsolatedNumber(ctrl.chartDef.genericMeasures[index])(chartData.getAggrExtent(index)[0]);const labelFontSize=hidelabel?0:this.getRawLabelFontSize(index);return ctrl.fitKpiValueToContainer(kpiValueDom,containerDim,labelFontSize)};this.applyKpiLabel=function(index,containerDim,hideAllLabels){const measure=ctrl.chartDef.genericMeasures[index];const kpiLabelDom=ctrl.el.getElementsByClassName(LABEL_SELECTOR)[index];if(!measure.showDisplayLabel||hideAllLabels){kpiLabelDom.style.display="none";return}const kpiValueDom=ctrl.el.getElementsByClassName(VALUE_SELECTOR)[index];const boxWidth=Math.ceil(containerDim.width*(ROUNDING+.05))+"px";kpiLabelDom.style.width=boxWidth;kpiValueDom.style.width=boxWidth;kpiLabelDom.style.display="";if(measure.labelPosition===ChartsStaticData.LABEL_POSITIONS.BOTTOM.value){kpiLabelDom.parentNode.insertBefore(kpiValueDom,kpiLabelDom)}else{kpiValueDom.parentNode.insertBefore(kpiLabelDom,kpiValueDom)}kpiLabelDom.textContent=ChartLabels.getLongMeasureLabel(ctrl.chartDef.genericMeasures[index])};this.getKpiBoxSize=function(index){const kpiDiv=ctrl.el.getElementsByClassName(MEASURE_SELECTOR)[index];return{height:kpiDiv.clientHeight-valuePadding,width:kpiDiv.clientWidth-valuePadding}};this.fitKpiValueToContainer=function(kpiValue,containerDimensions,labelFontSize){let left=0;let right=500;let mid=0;while(left<=right){mid=right+left>>1;ctrl.applyFontSize(kpiValue,mid);const kpiSpanClientRect=kpiValue.getBoundingClientRect();if(kpiSpanClientRect.width<=containerDimensions.width*ROUNDING&&kpiSpanClientRect.height<=containerDimensions.height*ROUNDING-labelFontSize){left=mid+1}else{right=mid-1}}return mid};this.applyFontSize=function(kpiValue,size){kpiValue.style.fontSize=size+"px";kpiValue.style.lineHeight=Math.round(size+size*VALUE_HEIGHT_OVERFLOW)+"px"};this.getAlignmentClass=index=>{const measure=this.chartDef.genericMeasures[index];if(measure){switch(measure.kpiTextAlign){case"LEFT":return"kpi-holder-measure--left";case"RIGHT":return"kpi-holder-measure--right";default:return"kpi-holder-measure--center"}}};this.getRawValueFontSize=index=>{return this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length&&this.chartDef.genericMeasures[index]&&this.chartDef.genericMeasures[index].kpiValueFontSize};this.getRawLabelFontSize=index=>{return this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length&&this.chartDef.genericMeasures[index]&&this.chartDef.genericMeasures[index].labelTextFormatting&&this.chartDef.genericMeasures[index].labelTextFormatting.fontSize};this.getValueFontSize=index=>{return`${this.getRawValueFontSize(index)}px`};this.getLabelFontSize=index=>{return`${this.getRawLabelFontSize(index)}px`};this.getLabelFontColor=index=>{const hasMeasureConditionalFormatting=this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length&&ctrl.colorGroupByMeasureId&&ctrl.colorGroupByMeasureId[ConditionalFormattingOptions.getMeasureId(this.chartDef.genericMeasures[index])];return!hasMeasureConditionalFormatting&&this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length&&this.chartDef.genericMeasures[index]&&this.chartDef.genericMeasures[index].labelTextFormatting&&this.chartDef.genericMeasures[index].labelTextFormatting.fontColor}}})})();(function(){"use strict";angular.module("dataiku.charts").component("legendOptzone",{templateUrl:"/static/dataiku/js/simple_report/components/legend-optzone/legend-optzone.component.html",bindings:{canPlaceInSidebar:"<",legendPlacement:"=",legendFormatting:"=",displayLegendFormatting:"<",theme:"<"},controller:function($scope,$timeout,ColorUtils,translate,DSSVisualizationThemeUtils){const ctrl=this;$scope.translate=translate;ctrl.$onInit=()=>{ctrl.themeColors=ColorUtils.getThemeColorsWithBlackWhite(ctrl.theme);ctrl.foregroundColors=ColorUtils.generateThemePaletteColors(DSSVisualizationThemeUtils.getThemeOrDefault(ctrl.theme).colors,ctrl.themeColors.length>0).foregroundColors};$scope.$watch("$ctrl.theme",(newTheme,oldTheme)=>{if(!newTheme){return}ctrl.defaultFormatting={fontColor:newTheme.legendFormatting.fontColor,fontSize:newTheme.legendFormatting.fontSize};ctrl.themeColors=ColorUtils.getThemeColorsWithBlackWhite(newTheme);if(!ctrl.foregroundColors||!oldTheme||!_.isEqual(newTheme.colors,oldTheme.colors)){ctrl.themeColors=ColorUtils.getThemeColorsWithBlackWhite(newTheme);const paletteColors=ColorUtils.generateThemePaletteColors(newTheme.colors,ctrl.themeColors.length>0);if(paletteColors){ctrl.foregroundColors=paletteColors.foregroundColors}}});ctrl.categories={OUTER:["OUTER_RIGHT","OUTER_LEFT","OUTER_TOP","OUTER_BOTTOM"],INNER:["INNER_TOP_RIGHT","INNER_TOP_LEFT","INNER_BOTTOM_LEFT","INNER_BOTTOM_RIGHT"]};$scope.$watch("$ctrl.legendPlacementCategory",function(nv,ov){if(!nv){return}if(nv==="SIDEBAR"){ctrl.legendPlacement="SIDEBAR"}else{if(ctrl.categories[nv].indexOf(ctrl.legendPlacement)===-1){ctrl.legendPlacement=ctrl.categories[nv][0]}}});$scope.$watch("$ctrl.legendPlacement",function(nv,ov){if(!nv){return}if(nv==="SIDEBAR"){ctrl.legendPlacementCategory="SIDEBAR"}else{for(const cat in ctrl.categories){if(ctrl.categories[cat].indexOf(nv)>-1){ctrl.legendPlacementCategory=cat;break}}}});ctrl.onLegendFormattingChange=function(value){$timeout(()=>ctrl.legendFormatting=value)}}})})();(function(){"use strict";angular.module("dataiku.charts").component("numberFormattingSubform",{templateUrl:"/static/dataiku/js/simple_report/components/number-formatting-subform/number-formatting-subform.component.html",bindings:{shouldFormatInPercentage:"=",multiplier:"=",decimalPlaces:"=",hideTrailingZeros:"=",digitGrouping:"=",useParenthesesForNegativeValues:"=",prefix:"=",suffix:"=",computeMode:"<?"},controller:function(ChartsStaticData){const ctrl=this;ctrl.availableMultipliers=ChartsStaticData.availableMultipliers;ctrl.availableDigitGrouping=ChartsStaticData.availableDigitGrouping;ctrl.isComputedAsPercentage=()=>{return ctrl.computeMode==="PERCENTAGE"||ctrl.computeMode==="CUMULATIVE_PERCENTAGE"};ctrl.$onInit=function(){ctrl.multiplier=ctrl.multiplier||"Auto"}}})})();(function(){"use strict";angular.module("dataiku.charts").component("textAlignSubform",{templateUrl:"/static/dataiku/js/simple_report/components/text-align-subform/text-align-subform.component.html",bindings:{value:"="},controller:function($timeout,translate){const ctrl=this;this.translate=translate;ctrl.setAlignment=alignment=>{$timeout(()=>ctrl.value=alignment)}}})})();(function(){"use strict";const CHART_AXIS_TYPES={DIMENSION:"DIMENSION",MEASURE:"MEASURE",UNAGGREGATED:"UNAGGREGATED"};angular.module("dataiku.charts").constant("CHART_AXIS_TYPES",CHART_AXIS_TYPES)})();(function(){"use strict";const ECHART_AXIS_TYPES={CATEGORY:"category",VALUE:"value",TIME:"time",LOG:"log"};angular.module("dataiku.charts").constant("ECHART_AXIS_TYPES",ECHART_AXIS_TYPES)})();(function(){"use strict";const DKU_PALETTE_NAMES={MEANING:"__dku_meaning__",CUSTOM:"__dku_custom__",THEME:"default_theme"};angular.module("dataiku.charts").constant("DKU_PALETTE_NAMES",DKU_PALETTE_NAMES)})();(function(){"use strict";function buildDateDisplay(mainDateFormat,dateFormat,dateFilterOption,dateFilterOptionTimezone="UTC"){return{mainDateFormat:mainDateFormat,dateFormat:dateFormat,dateFilterOption:dateFilterOption,dateFilterOptionTimezone:dateFilterOptionTimezone,formatDateFn:function(timestamp,formatToApply){return d3.time.format.utc(formatToApply)(new Date(timestamp))}}}const CHART_DATES_LABELS={DATE_DISPLAY_UNIT_DEFAULT:buildDateDisplay(undefined,"%Y-%m-%d","MMM d, y"),DATE_DISPLAY_UNIT_DAY_AND_MINUTES:buildDateDisplay(undefined,"%Y-%m-%d %H:%M","MMM d, y HH:mm"),DATE_DISPLAY_UNIT_MINUTES:buildDateDisplay("%Y-%m-%d","%H:%M","HH:mm"),DATE_DISPLAY_UNIT_SECONDS:buildDateDisplay("%Y-%m-%d","%H:%M:%S","HH:mm:ss"),DATE_DISPLAY_UNIT_MILLISECONDS:buildDateDisplay("%Y-%m-%d","%H:%M:%S:%L","HH:mm:ss:sss")};const CHART_LABELS={SUBTOTAL_BIN_LABEL:"___dku_total_value___",NO_RECORDS:"No records"};angular.module("dataiku.charts").constant("CHART_DATES_LABELS",CHART_DATES_LABELS).constant("CHART_LABELS",CHART_LABELS)})();(function(){"use strict";const CHART_MODES={COLUMNS:"COLUMNS",POINTS:"POINTS"};angular.module("dataiku.charts").constant("CHART_MODES",CHART_MODES)})();(function(){"use strict";const CHART_SORT_TYPES={NATURAL:"NATURAL",AGGREGATION:"AGGREGATION"};angular.module("dataiku.charts").constant("CHART_SORT_TYPES",CHART_SORT_TYPES)})();(function(){"use strict";const CHART_VARIANTS={normal:"normal",stacked100:"stacked_100",binnedXYRectangle:"binned_xy_rect",binnedXYHexagon:"binned_xy_hex",filledMap:"filled_map",donut:"donut",colored:"colored",waterfall:"waterfall"};angular.module("dataiku.charts").constant("CHART_VARIANTS",CHART_VARIANTS)})();(function(){"use strict";window.dkuDragType=window.navigator.userAgent.indexOf("Trident")>=0?"Text":window.navigator.userAgent.indexOf("Edge")>=0?"text/plain":"json";const app=angular.module("dataiku.directives.simple_report");app.controller("ChartDragDropController",$scope=>{$scope.setDragActive=()=>{$(".chart-configuration-wrapper").addClass("drag-active")};$scope.setDragInactive=()=>{$(".chart-configuration-wrapper").removeClass("drag-active")};$scope.addClassHereAndThere=(element,clazz)=>{$(element).addClass(clazz);$(element).parent().parent().addClass(clazz)};$scope.removeClassHereAndThere=(element,clazz)=>{$(element).removeClass(clazz);$(element).parent().parent().removeClass(clazz)}})})();(function(){"use strict";const app=angular.module("dataiku.directives.simple_report");app.controller("ChartSliderController",function($scope,$timeout){$scope.slideEnd=function(){$timeout(function(){const filterData=$scope.filterTmpData[$scope.$index];const facetUiState=$scope.facetUiStates[$scope.$index];if(!filterData||!facetUiState){return}filterData.minValue=facetUiState.sliderModelMin;filterData.maxValue=facetUiState.sliderModelMax})}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("ColorSelectorController",function($scope,ChartColorSelection){$scope.getUaColor=function(measure){return ChartColorSelection.getUaColor($scope.chart.def,measure)};$scope.getColorMeasure=function(){return ChartColorSelection.getColorMeasure($scope.chart.def)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("ContinuousColorSelectorController",function($scope,ChartColorSelection){$scope.getColorOptions=function(geoLayer){return ChartColorSelection.getOptions($scope.chart.def,geoLayer)};$scope.getColorDimensionOrMeasure=function(geoLayer){return ChartColorSelection.getColorDimensionOrMeasure($scope.chart.def,geoLayer)}})})();(function(){"use strict";angular.module("dataiku.charts").controller("EditCustomPaletteModalController",EditCustomPaletteModalController);function EditCustomPaletteModalController($scope,DataikuAPI,$filter,$timeout,StateUtils,FutureProgressModal,ColorUtils,WT1,translate){let originalPalette;$scope.uiState={};$scope.exportOptions={};$scope.paletteInvalidMessage=translate("COMPONENT.COLOR_PALETTE.MODAL.INVALID_MESSAGE","Colors are required and must be valid hexadecimal, rgb(a) or CSS values.");$scope.noChangeMessage=translate("COMPONENT.COLOR_PALETTE.MODAL.NO_CHANGE_MESSAGE","No changes to be saved");$scope.init=function(palette,paletteType,specifyValuesEnabled=true){$scope.palette=angular.copy(palette);$scope.defaultColors=ColorUtils.getDiscretePaletteColors("dku_font");originalPalette=angular.copy(palette);$scope.paletteType=paletteType;$scope.specifyValuesEnabled=specifyValuesEnabled;$scope.isDirty=false;$scope.isPaletteColorsFormValid=true};$scope.save=function(){$scope.resolveModal($scope.palette)};$scope.$watch("palette",function(nv){$scope.isDirty=originalPalette&&!_.isEqual(nv,originalPalette)},_.isEqual);$scope.codeMirrorOptions={mode:"application/javascript",lineNumbers:false,readOnly:true,onLoad:function(instance){instance.on("focus",function(){instance.execCommand("selectAll")})}};$scope.handlePaletteChange=function(palette){$timeout(()=>{$scope.palette=palette})};$scope.handleValidityChange=function(validity){$timeout(()=>{$scope.isPaletteColorsFormValid=validity==="VALID"})};const getJsSnippet=function(type,id,name,colors,values){let clippedValues;if(values&&values.length){clippedValues=values.concat();clippedValues.length=colors.length}return"dkuColorPalettes.add"+$filter("capitalize")(type.toLowerCase())+"({"+'\n    "id": '+JSON.stringify(id)+","+'\n    "name": '+JSON.stringify(name)+","+'\n    "category": "Plugin palettes",'+'\n    "colors": '+JSON.stringify(colors)+(clippedValues?',\n    "values": '+JSON.stringify(clippedValues):"")+"\n});"};$scope.updateSnippet=function(){$scope.jsSnippet=getJsSnippet($scope.paletteType,$scope.exportOptions.paletteId,$scope.exportOptions.paletteName,$scope.palette.colors,$scope.palette.values)};$scope.prepareExport=function(){$scope.updateSnippet();$scope.uiState.exporting=true};$scope.export=function(){DataikuAPI.plugindev.create($scope.exportOptions.pluginId,"EMPTY").error(setErrorInScope.bind($scope)).success(function(data){FutureProgressModal.show($scope,data,"Creating plugin").then(function(result){if(result){WT1.event("plugin-dev-create");DataikuAPI.plugindev.createContent($scope.exportOptions.pluginId,"/js",true).error(setErrorInScope.bind($scope)).success(function(){DataikuAPI.plugindev.createContent($scope.exportOptions.pluginId,"/js/palette.js",false).error(setErrorInScope.bind($scope)).success(function(){DataikuAPI.plugindev.setContent($scope.exportOptions.pluginId,"/js/palette.js",$scope.jsSnippet).error(setErrorInScope.bind($scope)).success(function(){$scope.dismiss();StateUtils.go.pluginDefinition($scope.exportOptions.pluginId)})})})}})})}}})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("GeometryMapColorController",function($scope){$scope.geoLayers=[];$scope.onGeoLayerChange=function(index){$scope.index=index;$scope.geoLayer=$scope.chart.def.geoLayers[index]};$scope.hasColor=function(){return $scope.geoLayer.uaColor.length};$scope.$watch("chart.def.geoLayers",function(newValue){if(!_.isNil($scope.geoLayer)){const selectedGeoIndex=newValue.findIndex(layer=>_.isEqual(layer,$scope.geoLayer));if(selectedGeoIndex>=0){$scope.index=selectedGeoIndex}}else{const displayedLayerIndex=newValue.findIndex(geoLayer=>geoLayer.geometry&&geoLayer.geometry.length);if(displayedLayerIndex>=0){$scope.geoLayer=newValue[displayedLayerIndex];$scope.index=displayedLayerIndex}}const geoLayers=[];newValue.forEach((layer,index)=>{if(layer.geometry&&layer.geometry.length){let name=layer.geometry[0].column;if(layer.uaColor&&layer.uaColor.length){name+=` / ${layer.uaColor[0].column}`}geoLayers.push({id:index,name:name})}});$scope.geoLayers=geoLayers;$scope.hasGeoLayers=newValue&&newValue.some(geoLayer=>geoLayer.geometry&&geoLayer.geometry.length)},true)})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("SingleColorSelectorController",function($scope,ChartColorSelection){$scope.colors=["#F03334","#FF7703","#F6C762","#ECD941","#82D96B","#63E9C3","#69CEF0","#1EA8FC","#2678B1","#7638AF","#BE66BF","#EA3596","#000000","#8A8A8A","#BABBBB","#D2D2D2","#E8E8E8","#FFFFFF"];$scope.grayBlock=[0,1,2,3,4,5,6,7,8,9].map(function(x){const c=x/10*255;return d3.rgb(c,c,c).toString()});$scope.getColorOptions=function(geoLayer){return ChartColorSelection.getOptions($scope.chart.def,geoLayer)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("MapBackgroundPickerController",function($scope,BuiltinMapBackgrounds){$scope.backgrounds=BuiltinMapBackgrounds.getBackgrounds();$scope.categories={};$scope.backgrounds.forEach(function(background){if(!$scope.categories[background.category]){$scope.categories[background.category]=[background]}else{$scope.categories[background.category].push(background)}})})})();(function(){"use strict";const app=angular.module("dataiku.directives.simple_report");app.controller("StdAggregatedMeasureController",($scope,ChartLabels,ChartFeatures,ChartCustomMeasures,ColumnAvailability)=>{$scope.ChartFeatures=ChartFeatures;$scope.ChartLabels=ChartLabels;$scope.getAggregationDescription=ColumnAvailability.getAggregationDescription;$scope.countOfRecordsLabel=ChartLabels.COUNT_OF_RECORDS_LABEL;$scope.getAvailableAggregations=(measureType,chartType)=>ChartLabels.getAvailableAggregationsLabels(measureType,chartType,$scope.contextualMenuMeasureType);$scope.getCustomMeasure=ChartCustomMeasures.getCustomMeasure;$scope.getAvailableUnaggregatedModes=measure=>ChartLabels.getAvailableUnaggregatedModesLabels(measure,$scope.chart.def,$scope.contextualMenuMeasureType);$scope.onUnaggregatedChange=function(isMeasureUnaggregated,measure){if(isMeasureUnaggregated){const compatibleUaComputeModes=Object.keys($scope.getAvailableUnaggregatedModes(measure));if(!compatibleUaComputeModes.includes(measure.uaComputeMode)){measure.uaComputeMode=compatibleUaComputeModes[0]}}if(!$scope.$$phase){$scope.$apply()}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("AdminMapChartController",function($scope,ChartTypeChangeHandler){$scope.acceptGeo=function(data){return ChartTypeChangeHandler.acceptGeo(data)};$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("BinnedXYChartDefController",function($scope,ChartTypeChangeHandler,CHART_VARIANTS,ChartColumnTypeUtils){$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data)};$scope.acceptDimensionOrHierarchy=function(data){return ChartTypeChangeHandler.binnedXYAcceptDimensionOrHierarchy($scope.chart.def.variant,data)};$scope.hasSizeMenu=function(){return $scope.chart.def.variant===CHART_VARIANTS.binnedXYHexagon};$scope.getXDimList=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.xHierarchyDimension:$scope.chart.def.xDimension;$scope.getYDimList=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.yHierarchyDimension:$scope.chart.def.yDimension})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("BoxplotsChartDefController",function($scope,ChartTypeChangeHandler,ChartColumnTypeUtils){$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.boxplotsAcceptMeasure(data)};$scope.acceptBreakdownDimension=function(data){return ChartTypeChangeHandler.boxplotsAcceptBreakdown(data)};$scope.acceptColorDimension=function(data){return ChartTypeChangeHandler.boxplotsAcceptColorDimension(data)};$scope.getBreakdownDimList=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.boxplotBreakdownHierarchyDimension:$scope.chart.def.boxplotBreakdownDim})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("Density2DChartDefController",function($scope,ChartTypeChangeHandler){$scope.accept=function(data){return ChartTypeChangeHandler.density2dAccept(data)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("DensityHeatMapChartController",function($scope,ChartTypeChangeHandler){$scope.acceptGeo=function(data){return ChartTypeChangeHandler.acceptGeo(data)};$scope.acceptScaleMeasure=function(data){return ChartTypeChangeHandler.densityMapAcceptScaleMeasure(data)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("GeometryMapChartController",function($scope,ChartTypeChangeHandler,ChartColorSelection,ChartsStaticData){$scope.$watch("chart.def.geoLayers",function(newValue){const lastGeoLayer=newValue[newValue.length-1];$scope.generateEmptyPlaceholder(lastGeoLayer);prepareGeoLayers(newValue)},true);$scope.acceptMeasure=data=>ChartTypeChangeHandler.scatterAccept(data);$scope.acceptGeo=data=>ChartTypeChangeHandler.acceptGeo(data);$scope.getUaColor=measure=>ChartColorSelection.getUaColor($scope.chart.def,measure);$scope.removeGeometry=function(index){if(!isLastGeoLayer(index)){$scope.chart.def.geoLayers.splice(index,1)}};$scope.sortableOptions={update:function(e,ui){const sortableElement=ui.item.sortable;preventTheLastItemFromMoving(sortableElement)},handle:".handle"};$scope.isEmptyPlaceholder=index=>isLastGeoLayer(index);function isLastGeoLayer(index){return index===$scope.chart.def.geoLayers.length-1}function preventTheLastItemFromMoving(sortableElement){const lastItemIndex=sortableElement.sourceModel.length-1;if(sortableElement.index===lastItemIndex||sortableElement.dropindex===lastItemIndex){sortableElement.cancel()}}function isLayerEmpty(geoLayer){return geoLayer.geometry.length===0&&geoLayer.uaColor.length===0}$scope.generateEmptyPlaceholder=function(lastGeoLayer){if(!isLayerEmpty(lastGeoLayer)){$scope.chart.def.geoLayers.push(ChartTypeChangeHandler.newEmptyGeoPlaceholder($scope.chart.def.geoLayers.length))}};function prepareGeoLayers(geoLayers){for(let i=0;i<geoLayers.length-1;++i){if(isLayerEmpty(geoLayers[i])){geoLayers.splice(i,1)}else{autoCompleteGeoLayers(geoLayers[i])}}}function autoCompleteGeoLayers(geoLayer){if(geoLayer.geometry.length>0){ChartTypeChangeHandler.autocompleteUA(geoLayer.geometry[0])}if(geoLayer.uaColor.length>0){ChartTypeChangeHandler.autocompleteUA(geoLayer.uaColor[0]);if(geoLayer.geometry.length>0){geoLayer.geometry[0].aggregationFunction=ChartsStaticData.GEOM_AGGREGATIONS.DEFAULT}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("KpiChartDefController",function($scope,ChartTypeChangeHandler){$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasureWithAlphanumResults(data)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("PivotChartDefController",function($scope,ChartTypeChangeHandler,ChartColumnTypeUtils){$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasureWithAlphanumResults(data)};$scope.acceptDimensionOrHierarchy=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data)};$scope.acceptColor=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data)};$scope.getXDimList=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.xHierarchyDimension:$scope.chart.def.xDimension;$scope.getYDimList=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.yHierarchyDimension:$scope.chart.def.yDimension})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("ScatterChartController",function($scope,ChartTypeChangeHandler){$scope.scatterAcceptDrop=function(data){return ChartTypeChangeHandler.scatterAccept(data)};$scope.scatterAcceptScaleMeasure=function(data){return ChartTypeChangeHandler.scatterAcceptScaleMeasure(data)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("ScatterMapChartController",function($scope,ChartTypeChangeHandler){$scope.acceptGeo=function(data){return ChartTypeChangeHandler.acceptGeo(data)};$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.scatterAccept(data)};$scope.acceptScaleMeasure=function(data){return ChartTypeChangeHandler.scatterAcceptScaleMeasure(data)}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("ScatterMultiplePairsChartController",function($scope,ChartTypeChangeHandler,ChartUADimension,ChartAxesUtils,ChartsStaticData,translate){$scope.dimensionPairs=_.clone($scope.chart.def.uaDimensionPair);const lastPair=$scope.dimensionPairs[$scope.dimensionPairs.length-1];generateEmptyPlaceholder(lastPair);$scope.$watch("dimensionPairs",function(newValue){let lastPair=newValue[newValue.length-1];generateEmptyPlaceholder(lastPair);newValue.forEach((pair,i)=>{autocompletePair(pair);if(ChartUADimension.isPairEmpty(pair)&&!isLastPair(i)){$scope.dimensionPairs.splice(i,1)}});const lastIndex=$scope.dimensionPairs.length-1;lastPair=$scope.dimensionPairs[lastIndex];const newDimensionPairs=ChartUADimension.isPairEmpty(lastPair)?$scope.dimensionPairs.slice(0,lastIndex):$scope.dimensionPairs;const yAxesFormatting=[];const pairIds=ChartUADimension.createUaDimPairIds(newDimensionPairs);newDimensionPairs.forEach((pair,index)=>{pair.id=pairIds[index];if(pair.id){let formatting=$scope.chart.def.yAxesFormatting.find(v=>v.id===pair.id);if(!formatting){formatting=ChartAxesUtils.initYAxesFormatting(pair.id)}yAxesFormatting.push(formatting)}});const basicChartsFormatting=$scope.chart.def.yAxesFormatting.filter(v=>v.id===ChartsStaticData.LEFT_AXIS_ID||v.id===ChartsStaticData.RIGHT_AXIS_ID);$scope.chart.def.uaDimensionPair=[...newDimensionPairs];$scope.chart.def.yAxesFormatting=[...basicChartsFormatting,...yAxesFormatting]},true);$scope.scatterAcceptUaXDrop=function(data,pairIndex){return ChartTypeChangeHandler.scatterMPAccept(data,$scope.chart.def,"x",pairIndex)};$scope.scatterAcceptUaYDrop=function(data,pairIndex){return ChartTypeChangeHandler.scatterMPAccept(data,$scope.chart.def,"y",pairIndex)};$scope.getXDropzonePlaceholder=function(pairIndex){const pair=$scope.dimensionPairs[pairIndex];if(pair.uaYDimension&&pair.uaYDimension.length){const uaXDimension=ChartUADimension.getPairUaXDimension($scope.dimensionPairs,pair);if(uaXDimension&&uaXDimension.length){return uaXDimension[0].column}}return translate("CHARTS.DEFINITION.SHARED.X_AXIS","Drop to set the X axis")};$scope.sortableOptions={handle:".handle"};function generateEmptyPlaceholder(lastPair){if((!lastPair||!ChartUADimension.isPairEmpty(lastPair))&&$scope.dimensionPairs.length<5){$scope.dimensionPairs.push({uaXDimension:[],uaYDimension:[]})}}function autocompletePair(pair){if(pair.uaXDimension.length){ChartTypeChangeHandler.autocompleteUA(pair.uaXDimension[0])}if(pair.uaYDimension.length){ChartTypeChangeHandler.autocompleteUA(pair.uaYDimension[0])}}$scope.removePair=function(index){$scope.dimensionPairs.splice(index,1)};$scope.isEmptyPlaceholder=index=>ChartUADimension.isPairEmpty($scope.dimensionPairs[index]);function isLastPair(index){return index===$scope.dimensionPairs.length-1}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("StdAggregatedChartDefController",function($scope,ChartTypeChangeHandler,ChartColumnTypeUtils,ChartFeatures){$scope.ChartFeatures=ChartFeatures;$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data)};$scope.acceptDimensionOrHierarchy=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data)};$scope.acceptDimension=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptDimension(data)};$scope.getAxisNameForRadar=function(data){return data.axesDef["axis"]===0?"axis":"polygon"};$scope.getDim0List=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.genericHierarchyDimension:$scope.chart.def.genericDimension0})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("StdGroupedChartDefController",function($scope,ChartTypeChangeHandler,ChartColumnTypeUtils){$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data)};$scope.acceptDimensionOrHierarchy=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data)};$scope.getGroupDimList=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.groupHierarchyDimension:$scope.chart.def.groupDimension})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.controller("TreemapChartDefController",function($scope,ChartTypeChangeHandler,ChartColumnTypeUtils){$scope.acceptMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data)};$scope.acceptDimensionOrHierarchy=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data)};$scope.getYDimList=data=>ChartColumnTypeUtils.isHierarchy(data)?$scope.chart.def.yHierarchyDimension:$scope.chart.def.yDimension})})();(function(){"use strict";angular.module("dataiku.charts").directive("animatedChartSlider",animatedChartSlider);function animatedChartSlider(ChartDimension,ChartUADimension){return{scope:{labels:"=",currentFrame:"=",dimension:"="},template:'<div class="horizontal-flex animated-chart-slider" style="align-items: center;">'+'<div class="noflex">{{firstValue}}</div>'+'<div class="progress flex">'+'<div class="current" style="left:{{cursorLeft}}%; width: {{cursorWidth}}%;" ng-mousedown="startSliding($event)" ng-mouseup="stopSliding()"></div>'+"</div>"+'<div class="noflex">{{lastValue}}</div>'+"</div>",link:function($scope,$el){let labelPositions;const findClosestIdx=function(x,arr){const indexArr=arr.map(function(k){return Math.abs(k.center-x)});const min=Math.min.apply(Math,indexArr);return indexArr.indexOf(min)};$scope.$watch("labels",function(nv){if(!nv){return}if(ChartDimension.isUngroupedNumerical($scope.dimension)){$scope.firstValue=$scope.labels[0].sortValue;$scope.lastValue=$scope.labels[$scope.labels.length-1].sortValue;const scale=d3.scale.linear().domain([$scope.labels[0].sortValue,$scope.labels[$scope.labels.length-1].sortValue]).range([0,100]);labelPositions=$scope.labels.map(function(label){return{center:scale(label.sortValue),start:scale(label.sortValue)-1,width:2}})}else if(ChartDimension.isGroupedNumerical($scope.dimension)){$scope.firstValue=$scope.labels[0].min;$scope.lastValue=$scope.labels[$scope.labels.length-1].max;const linearScale=d3.scale.linear().domain([$scope.labels[0].min,$scope.labels[$scope.labels.length-1].max]).range([0,100]);labelPositions=$scope.labels.map(function(label){return{center:linearScale(label.sortValue),start:linearScale(label.min),width:linearScale(label.max)-linearScale(label.min)}})}else if(ChartDimension.isAlphanumLike($scope.dimension)||ChartUADimension.isDiscreteDate($scope.dimension)){$scope.firstValue=null;$scope.lastValue=null;const ordinalScale=d3.scale.ordinal().domain($scope.labels.map(function(d,i){return i})).rangeBands([0,100]);labelPositions=$scope.labels.map(function(label,i){return{start:ordinalScale(i),width:ordinalScale.rangeBand(),center:ordinalScale(i)+ordinalScale.rangeBand()/2}})}if($scope.currentFrame!==null){$scope.cursorLeft=labelPositions[$scope.currentFrame].start;$scope.cursorWidth=labelPositions[$scope.currentFrame].width}});const slideCursor=function($evt){$evt.preventDefault();const sliderPosition=$el.offset().left;const xPosition=($evt.pageX-sliderPosition)/$el.width()*100;$scope.$apply(function(){$scope.currentFrame=findClosestIdx(xPosition,labelPositions)})};$scope.startSliding=function($evt){$scope.sliding=true;$(window).on("mouseup.chart-animation."+$scope.$id,$scope.stopSliding);$(window).on("mousemove.chart-animation"+$scope.$id,slideCursor);$("body").css("cursor","move")};$scope.stopSliding=function(){$scope.sliding=false;$(window).off("mouseup.chart-animation."+$scope.$id);$(window).off("mousemove.chart-animation"+$scope.$id);$("body").css("cursor","auto")};$scope.$watch("currentFrame",function(nv){if(nv==null){return}$scope.cursorLeft=labelPositions[nv].start;$scope.cursorWidth=labelPositions[nv].width})}}}})();(function(){"use strict";const app=angular.module("dataiku.directives.simple_report");app.directive("chartConfiguration",function(MonoFuture,Debounce,DataikuAPI,translate,ChartDimension,ChartLabels,ChartRequestComputer,$state,$timeout,PluginsService,Logger,ActivityIndicator,ChartTypeChangeHandler,ChartDefinitionChangeHandler,ChartUADimension,_MapCharts,ChartsStaticData,ChartConfigurationCopyPaste,DetectUtils,ChartIconUtils,ChartSetErrorInScope,ChartFeatures,PolygonSources,ChartAxesUtils,ChartZoomControlAdapter,ChartDataUtils,WT1,CHART_TYPES,CHART_VARIANTS,ChartStoreFactory,ColorUtils,$rootScope,$stateParams,ChartsAvailableTypes,RegressionTypes,ChartFilterUtils,ChartFormattingPane,ChartFormattingPaneSections,DataGroupingMode,ChartColorSelection,ConditionalFormattingOptions,ChartDataWrapperFactory,DSSVisualizationThemeUtils,ChartDrilldown,ChartHierarchyDimension,ChartHierarchies,DRILL_UP_SOURCE,localStorageService,ChartActivityIndicator,DashboardUtils){return{restrict:"AE",templateUrl:"/static/dataiku/js/simple_report/directives/chart-configuration/chart-configuration.directive.html",link:function(scope,element,attrs){scope.$watch(attrs["dropdownMaxHeightPx"],function(newVal){scope.dropdownMaxHeightPx=newVal});scope.chartActivityIndicator=ChartActivityIndicator.buildDefaultActivityIndicator();scope.canHaveZoomControls=ChartFeatures.canHaveZoomControls;scope.canDisplayLegend=ChartFeatures.canDisplayLegend;scope.isStackedLegend=ChartFeatures.isStackedLegend;ChartSetErrorInScope.defineInScope(scope);scope.isInAnalysis=$state.current.name.indexOf("analysis")!=-1;scope.isInPredicted=$state.current.name.indexOf("predicted")!=-1;scope.isInInsight=$state.current.name.indexOf("insight")!=-1;scope.isInNoteBooks=$state.current.name.indexOf("notebooks")!=-1;scope.canConfigureMaxOneChart=scope.isInInsight||scope.isInNoteBooks;scope.shouldDisplaySamplingStatus=shouldDisplaySamplingStatus;scope.RegressionTypes=RegressionTypes;scope.PolygonSources=PolygonSources;scope.hierarchyDimsInChart=[];scope.breadcrumbs=[];scope.breadcrumbTooltips={};scope.hasLegacyBadge=ChartFeatures.hasLegacyBadge;scope.hasBetaBadge=ChartFeatures.hasBetaBadge;scope.legacyBadge={tooltip:translate("CHARTS.HEADER.BADGE.LEGACY.TOOLTIP","You are using the legacy engine. Click to go back to the new one.")};scope.editingTitle=false;scope.warningBadge=ChartsStaticData.WARNING_BADGE;scope.chartTypePickerOptions={chartVariant:scope.chart.def.variant,chartType:scope.chart.def.type,webappType:scope.chart.def.webAppType};scope.availableChartTypes=ChartsAvailableTypes.getAvailableChartTypes();scope.chartTypePickerOptions={...scope.chartTypePickerOptions,chartTypes:scope.availableChartTypes};if(!scope.isInPredicted&&!scope.isInAnalysis&&!scope.isInNoteBooks){DataikuAPI.explores.listPluginChartDescs($stateParams.projectKey).success(data=>{scope.webapps=parseWebapps(data);ChartConfigurationCopyPaste.setWebApps(scope.webapps);scope.chartTypePickerOptions={...scope.chartTypePickerOptions,webappTypes:scope.webapps}}).error(setErrorInScope.bind(scope))}if(!scope.chartBottomOffset){scope.chartBottomOffset=0}scope.optionsFolds={legend:true,chartMode:true,showTopBar:true};scope.PluginsService=PluginsService;scope.getPivotResponseOptions=()=>({projectKey:$stateParams.projectKey,dataSpec:scope.getDataSpec(),requestedSampleId:scope.chart.summary.requiredSampleId,onError:onPivotRequestError(scope),visualAnalysisFullModelId:$stateParams.fullModelId});Mousetrap.bind("s h h",function(){scope.$apply(function(){scope.bigChartSwitch()})});Mousetrap.bind("s v",function(){scope.$apply(function(){scope.switchCharts()})});scope.$on("$destroy",function(){Mousetrap.unbind("s h h");Mousetrap.unbind("s v")});scope.switchCharts=function(){if(ChartFeatures.hasEChartsDefinition(scope.chart.def.type)&&ChartFeatures.hasD3Definition(scope.chart.def.type)){if(ChartFeatures.hasDefaultEChartsDisplay(scope.chart.def.type)){scope.chart.def.displayWithEChartsByDefault=!scope.chart.def.displayWithEChartsByDefault}else{scope.chart.def.displayWithECharts=!scope.chart.def.displayWithECharts}}else if(!ChartFeatures.hasD3Definition(scope.chart.def.type)){Logger.warn("No d3 definition for this chart")}else{Logger.warn("No echarts definition for this chart")}};scope.openSection=function(section,properties){const readOnly=$state.current.name==="projects.project.dashboards.insights.insight.view";if(!readOnly&&!(section===ChartFormattingPaneSections.MISC&&scope.isInPredicted)){ChartFormattingPane.open(section,true,true);if(properties&&typeof properties==="object"){Object.keys(properties).forEach(propertyName=>{ChartFormattingPane.setData(propertyName,properties[propertyName])})}}};scope.onFoldableSectionLoaded=function(section){let sections=[];if($stateParams.sections){sections=JSON.parse($stateParams.sections)}sections.forEach(sectionId=>{if(section.getId()===sectionId){section.open();setTimeout(()=>section.scrollIntoView())}})};scope._MapCharts=_MapCharts;const addBigChartClass=addClass=>{if(addClass){$(".charts-container").addClass("big-chart")}else{$(".charts-container").removeClass("big-chart")}};scope.fixupCurrentChart=function(){ChartTypeChangeHandler.fixupChart(scope.chart.def,scope.chart.theme)};addBigChartClass(false);scope.bigChart=false;scope.chartHeaderLabel=translate("CHARTS.HEADER.EXPAND","Expand chart");scope.bigChartSwitch=function(){scope.bigChart=!scope.bigChart;scope.chartHeaderLabel=scope.bigChart?translate("CHARTS.HEADER.REDUCE","Reduce chart"):translate("CHARTS.HEADER.EXPAND","Expand chart");scope.isBigChartSwitch=true;$(".graphWrapper").fadeTo(0,0);addBigChartClass(scope.bigChart);$timeout(function(){if(scope.chart.def.type==CHART_TYPES.BINNED_XY&&scope.chart.def.variant==CHART_VARIANTS.binnedXYHexagon){scope.recomputeAndUpdateData();scope.executeIfValid()}else{scope.redraw()}$(".graphWrapper").fadeTo(0,1)},250)};scope.chartSpecific={};scope.droppedData=[];scope.ChartTypeChangeHandler=ChartTypeChangeHandler;scope.ChartsStaticData=ChartsStaticData;scope.ChartFormattingPane=ChartFormattingPane;scope.ChartFormattingPaneSections=ChartFormattingPaneSections;let frontImportantChangeTimeoutId;let noRedrawDelayedChangeTimeoutId;let invalidChangeTimeoutId;let themeChangeTimeoutId;const resizeObserver=new ResizeObserver(function(entries){const newHeight=entries[0].contentRect.height;const newWidth=entries[0].contentRect.width;const deltaHeight=Math.abs(scope.chartParamBarHeight-newHeight);const deltaWidth=Math.abs(scope.chartParamBarWidth-newWidth);if((scope.chartParamBarHeight||scope.chartParamBarWidth)&&Math.max(deltaHeight,deltaWidth)>30){if(!scope.isBigChartSwitch){handleResize(scope)}else{scope.isBigChartSwitch=false}}scope.chartParamBarHeight=newHeight;scope.chartParamBarWidth=newWidth});const unregister=scope.$watch("chart",function(nv){if(nv==null){return}unregister();scope.executedOnce=false;if(angular.isUndefined(scope.chart.def)){Logger.warn("!! BAD CHART !!")}scope.fixupCurrentChart();scope.staticData={};scope.chartTypes=[{type:CHART_TYPES.GROUPED_COLUMNS,title:"Grouped columns",description:"Use to create a grouped bar chart.<br/> Break down once to create one group of bars per category. Measures provide bars.<br/> Break down twice to create one group of bars per category and one bar for each subcategory."},{type:CHART_TYPES.STACKED_COLUMNS,title:"Stacked columns",description:"Use to display data that can be summed.<br/> Break down once with several measures to stack the measures.<br/>  Break down twice to create one stack element per value of the second dimension."},{type:CHART_TYPES.STACKED_AREA,title:"Stacked area",description:"Use to display data that can be summed.<br/> Break down once with several measures to stack the measures.<br/>  Break down twice to create one stack element per value of the second dimension."},{type:CHART_TYPES.LINES,title:"Lines",description:"Use to compare evolutions.<br/> Break down once with several measures to create one line per measure.<br/>  Break down twice to create one line per value of the second dimension."},{type:CHART_TYPES.SCATTER,title:"Scatter plot",description:"Scatterize"}];if(PluginsService.isPluginLoaded("geoadmin")){scope.chartTypes.push({type:CHART_TYPES.MAP,title:"World map (BETA)",description:"Use to plot and aggregate geo data"})}else{scope.chartTypes.push({type:CHART_TYPES.MAP,title:"World map (BETA)",description:"Use to plot and aggregate geo data",disabled:true,disabledReason:"You need to install the 'geoadmin' plugin. Please see documentation"})}scope.dataGroupingModes=DataGroupingMode;scope.dataGroupingLabels=ChartLabels.DATA_GROUPING_LABELS;scope.allYAxisModes={NORMAL:{value:"NORMAL",label:"Normal",shortLabel:"Normal"},LOG:{value:"LOG",label:"Logarithmic scale",shortLabel:"Log"},PERCENTAGE_STACK:{value:"PERCENTAGE_STACK",label:"Normalize stacks at 100%",shortLabel:"100% stack"}};scope.allXAxisModes={NORMAL:{value:"NORMAL",label:"Normal",shortLabel:"Normal"},CUMULATIVE:{value:"CUMULATIVE",label:"Cumulative values",shortLabel:"Cumulative"},DIFFERENCE:{value:"DIFFERENCE",label:"Difference (replace each value by the diff to the previous one)",shortLabel:"Difference"}};scope.allComputeModes={NONE:{value:"NONE",label:"No computation",shortLabel:"None"},LIFT_AVG:{value:"LIFT_AVG",shortLabel:"Ratio to AVG",label:"Compute ratio of each value relative to average of values"},AB_RATIO:{value:"AB_RATIO",shortLabel:"a/b ratio",label:"Compute ratio of measure 1 / measure 2"},AB_RATIO_PCT:{value:"AB_RATIO_PCT",shortLabel:"a/b ratio (%)",label:"Compute ratio of measure 1 / measure 2, as percentage"}};scope.initChartCommonScopeConfig(scope);scope.graphError={error:null};scope.dateFilterParts=ChartFilterUtils.getDateChartFilterParts();scope.dateFilterTypes=ChartFilterUtils.getDateFilterTypes();scope.temporalBinningModes=ChartsStaticData.dateModes.concat(ChartsStaticData.UNBINNED_TREAT_AS_ALPHANUM);scope.familyToTypeMap={basic:[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.LINES,CHART_TYPES.STACKED_AREA,CHART_TYPES.PIE],table:[CHART_TYPES.PIVOT_TABLE],scatter:[CHART_TYPES.SCATTER,CHART_TYPES.GROUPED_XY,CHART_TYPES.BINNED_XY],map:[CHART_TYPES.SCATTER_MAP,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.GRID_MAP,CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.DENSITY_HEAT_MAP],other:[CHART_TYPES.BOXPLOTS,CHART_TYPES.LIFT,CHART_TYPES.DENSITY_2D,CHART_TYPES.TREEMAP,CHART_TYPES.KPI,CHART_TYPES.RADAR,CHART_TYPES.SANKEY,CHART_TYPES.GAUGE],webapp:[CHART_TYPES.WEBAPP]};scope.canExportToExcel=ChartFeatures.canExportToExcel;scope.canExportToImage=ChartFeatures.canExportToImage;scope.appVersion=$rootScope.appConfig.version.product_version;scope.getDownloadDisabledReason=function(){return ChartFeatures.getExportDisabledReason(scope.chart.def)};scope.canDownloadChart=function(){return scope.validity.valid&&(scope.canExportToExcel(scope.chart.def)||scope.canExportToImage(scope.chart.def))};scope.typeAndVariantToImageMap=ChartIconUtils.typeAndVariantToImageMap;scope.computeChartOptionsPreview=function(){const macos=DetectUtils.getOS()==="macos";return macos?"/static/dataiku/images/charts/previews/cp_cmd.svg":"/static/dataiku/images/charts/previews/cp_ctrl.svg"};scope.computeChartPreview=function(type,variant){let imageName="";if(typeof variant==="undefined"){variant="normal"}if(typeof scope.typeAndVariantToImageMap[type]!=="undefined"&&typeof scope.typeAndVariantToImageMap[type][variant]!=="undefined"&&typeof scope.typeAndVariantToImageMap[type][variant].preview!=="undefined"){imageName=scope.typeAndVariantToImageMap[type][variant].preview}if(imageName!=""){return"/static/dataiku/images/charts/previews/"+imageName+".png"}return false};scope.request={};scope.ChartDimension=ChartDimension;scope.isGroupedNumericalDimension=ChartDimension.isGroupedNumerical.bind(ChartDimension);scope.isTimelineable=ChartDimension.isTimelineable.bind(ChartDimension);scope.isUngroupedNumericalDimension=ChartDimension.isUngroupedNumerical.bind(ChartDimension);scope.isAlphanumLikeDimension=ChartDimension.isAlphanumLike.bind(ChartDimension);scope.isNumericalDimension=ChartDimension.isTrueNumerical.bind(ChartDimension);scope.ChartUADimension=ChartUADimension;scope.setDimensionSort=(dimension,newSortId)=>{dimension.sort=angular.copy(scope.chart.def.possibleDimensionSorts.find(sort=>sort.sortId===newSortId))};scope.acceptStdAggrTooltipMeasure=function(data){return ChartTypeChangeHandler.stdAggregatedAcceptMeasureWithAlphanumResults(data)};scope.acceptUaTooltip=function(data){return ChartTypeChangeHandler.uaTooltipAccept(data)};scope.acceptFilter=function(data){const ret=ChartTypeChangeHandler.stdAggregatedAcceptDimension(data);if(!ret.accept||!data){return ret}if(data.type=="GEOMETRY"||data.type=="GEOPOINT"){return{accept:false,message:"Cannot filter on Geo dimensions"}}return ret};scope.dimensionBinDescription=function(dimension){return ChartDimension.getDimensionBinDescription(dimension,scope.chart.def)};scope.dateModeSuffix=function(mode){return`(${ChartDimension.getDateModeDescription(mode)})`};scope.geoDimDescription=function(dim){for(let i=0;i<ChartsStaticData.mapAdminLevels.length;i++){if(dim.adminLevel==ChartsStaticData.mapAdminLevels[i][0]){return ChartsStaticData.mapAdminLevels[i][2]}}return translate("CHARTS.DROPPED_DIMENSION.UNKNOWN","Unknown")};scope.isDateRangeFilter=ChartFilterUtils.isDateRangeFilter.bind(ChartFilterUtils);scope.isDatePartFilter=ChartFilterUtils.isDatePartFilter.bind(ChartFilterUtils);scope.filterTmpDataWatchDeregister=null;scope.onResponse=function(){scope.setValidity({valid:true});scope.uiDisplayState=scope.uiDisplayState||{};scope.uiDisplayState.chartTopRightLabel=ChartDataUtils.computeRecordsStatusLabel(scope.response.result.pivotResponse.beforeFilterRecords,scope.response.result.pivotResponse.afterFilterRecords,ChartDimension.getComputedMainAutomaticBinningModeLabel(scope.response.result.pivotResponse,scope.chart.def),undefined,scope.chart.def.type);scope.uiDisplayState.chartRecordsFinalCountTooltip=ChartDataUtils.getRecordsFinalCountTooltip(scope.chart.def.type,scope.response.result.pivotResponse.afterFilterRecords,scope.response.result.pivotResponse.axesPairs,undefined);scope.uiDisplayState.samplingSummaryMessage=ChartDataUtils.getSamplingSummaryMessage(scope.response.result.pivotResponse,scope.chart.def.type,scope.readOnly?null:translate("CHARTS.HEADER.DATA_SAMPLING.CLICK_TO_OPEN","Click to open sampling settings"),undefined);if(scope.chart.summary&&scope.response.result.updatedSampleId){scope.chart.summary.requiredSampleId=scope.response.result.updatedSampleId}const responseFacetsStack=scope.response.result.pivotResponse.filterFacets.reverse();scope.filterFacets=scope.chart.def.filters.map(filter=>{if(filter.useMinimalUi){return null}return responseFacetsStack.pop()});scope.samplingParams={engineType:scope.chart.engineType||"LINO",refreshableSelection:angular.copy(scope.chart.refreshableSelection)};scope.recordsMetadata=ChartFeatures.getRecordsMetadata(scope.chart.def,scope.response.result.pivotResponse.sampleMetadata,scope.response.result.pivotResponse.beforeFilterRecords,scope.response.result.pivotResponse.afterFilterRecords);scope.display0Warning=ChartFeatures.shouldDisplay0Warning(scope.chart.def.type,scope.response.result.pivotResponse);scope.colorColumn=ChartColorSelection.getColorDimensionOrMeasure(scope.chart.def,scope.chart.def.geoLayers[0]);const axesDef=ChartDimension.getAxesDef(scope.chart.def,ChartDimension.getChartDimensions(scope.chart.def));scope.chartData=ChartDataWrapperFactory.chartTensorDataWrapper(scope.response.result.pivotResponse,axesDef)};scope.resetResponseErrorsInScope();const executePivotRequest=MonoFuture(scope).wrap(scope.getExecutePromise);scope.executeIfValid=function(){const validity=ChartTypeChangeHandler.getValidity(scope.chart);scope.setValidity(validity);scope.previousResponseHadResult=scope.response&&scope.response.hasResult;scope.response=null;if(validity.valid){Logger.info("Chart is OK, executing");scope.execute()}else{scope.resetResponseErrorsInScope();Logger.info("Chart is NOK, not executing",scope.validity)}};scope.execute=Debounce().withDelay(1,300).withScope(scope).withSpinner(true).wrap(function(){Logger.info("Debounced, executing");scope.executedOnce=true;let request=null;try{const wrapper=element.find(".chart-zone");const width=wrapper.width();const height=wrapper.height();scope.chartSpecific={...scope.chartSpecific,datasetProjectKey:scope.getDataSpec().datasetProjectKey,datasetName:scope.getDataSpec().datasetName,context:scope.getCurrentChartsContext()};request=ChartRequestComputer.compute(scope.chart.def,width,height,scope.chartSpecific);request.useLiveProcessingIfAvailable=scope.chart.def.useLiveProcessingIfAvailable;Logger.info("Request is",request);scope.graphError.error=null}catch(error){Logger.info("Not executing, chart is not ready",error);scope.graphError.error=error}if(!scope.chart.def.userEditedName){const newName=ChartTypeChangeHandler.computeAutoName(scope.chart.def);if(newName.length>0){scope.chart.def.name=newName}}scope.filter={query:undefined};resetErrorInScope(scope);scope.excelExportableChart=undefined;const chartDefCopy=angular.copy(scope.chart.def);executePivotRequest(request,undefined,false).update(function(data){scope.request=request;scope.response=data}).success(function(data){scope.excelExportableChart={pivotResponse:data.result.pivotResponse,chartDef:chartDefCopy};scope.request=request;scope.response=data;scope.resetResponseErrorsInScope();scope.onResponse()}).error(function(data,status,headers){onPivotRequestError(scope)(data,status,headers)})});function getChangedDefinitionMessage(changedDefinition){const{name,nv,ov}=changedDefinition;return`${name} \nbefore: ${JSON.stringify(ov)} \nafter: ${JSON.stringify(nv)}`}function onChartImportantDefinitionChanged(changedDefinition,newChartDef){Logger.info(`Chart important change: ${getChangedDefinitionMessage(changedDefinition)}`);if(newChartDef){const oldChartDef=angular.copy(scope.chart.def);scope.recomputeAndUpdateData(changedDefinition);const newImportantChangedDefinition=ChartDefinitionChangeHandler.getRecomputeChange(formatDefinition(scope.chart.def),formatDefinition(oldChartDef));if(newImportantChangedDefinition){Logger.info("Data has been modified, not executing --\x3e will execute at next cycle");return}Logger.info("Triggering executeIfValid");scope.executeIfValid()}}function onChartFrontImportantDefinitionChanged(changedDefinition,newChartDef){Logger.info(`Chart front important change: ${getChangedDefinitionMessage(changedDefinition)}`);if(newChartDef){if(!scope.insight){scope.saveChart()}scope.redraw({updateThumbnail:true})}}function onChartFrontImportantNoRedrawDefinitionChanged(changedDefinition,newChartDef){Logger.info(`Chart front important no redraw change: ${getChangedDefinitionMessage(changedDefinition)}`);if(newChartDef&&!scope.insight){scope.saveChart()}}function formatDefinition(chartDef){if(chartDef.type===CHART_TYPES.GEOMETRY_MAP){const flattenedChartDef=angular.copy(chartDef);const listPropertiesToFlatten=["geometry","uaColor"];for(const property of listPropertiesToFlatten){flattenedChartDef[property]=[];for(const geoLayer of chartDef.geoLayers){flattenedChartDef[property].push(getFirstValue(geoLayer[property]))}}flattenedChartDef["colorOptions"]=[];for(const geoLayer of chartDef.geoLayers){flattenedChartDef["colorOptions"].push(geoLayer["colorOptions"])}return flattenedChartDef}return chartDef}function getFirstValue(array){if(array.length>0){return array[0]}return{}}scope.$watch("reusableDimensions.length",()=>{scope.updateHierarchyMissingColumns()});scope.$watch("chart.theme",(nv,ov)=>{Logger.info("Chart theme change");scope.immutableTheme=nv?angular.copy(nv):undefined;$timeout.cancel(themeChangeTimeoutId);if(!scope.insight){themeChangeTimeoutId=$timeout(()=>{scope.saveChart()},600)}if(nv&&(!ov||!angular.equals(nv.themePalettes,ov.themePalettes))){scope.redraw({updateThumbnail:true})}if(scope.chart&&scope.chart.theme&&scope.chart.theme.generalFormatting&&scope.chart.theme.generalFormatting.fontFamily){element.css("--visualization-font-family",scope.chart.theme.generalFormatting.fontFamily);element.css("--visualization-font-color",scope.chart.theme.generalFormatting.fontColor)}});const ignoredChartDefFields=["thumbnailData"];scope.$watch(()=>_.omit(scope.chart.def,ignoredChartDefFields),function(nv,ov){if(!nv){return}if(!ov){onChartImportantDefinitionChanged({name:"initial",nv:nv,ov:ov},nv)}if(nv.tooltipOptions&&nv.tooltipOptions.display==false&&ov.tooltipOptions.display==true){$rootScope.$emit("unfixTooltip")}$timeout.cancel(invalidChangeTimeoutId);const invalidMessage=ChartDefinitionChangeHandler.getInvalidChangeMessage(nv);if(invalidMessage!==null){invalidChangeTimeoutId=$timeout(()=>{ActivityIndicator.hide();ActivityIndicator.warning("Not refreshing: "+invalidMessage)},ChartsStaticData.SAVE_DEBOUNCE_DURATION);return}scope.immutableChartDef=angular.copy(nv);const newValue=formatDefinition(nv);const oldValue=formatDefinition(ov);const broadCastUpdateChartPromptSuggestions=()=>{if($rootScope.appConfig.aiText2ChartEnabled&&newValue.type!="webapp"&&(scope.createAndPinInsight||scope.isInAnalysis||scope.isInNoteBooks)&&$rootScope.featureFlagEnabled("chartAssistant")){$rootScope.$broadcast("updateChartPromptSuggestions")}};const importantChangedDefinition=ChartDefinitionChangeHandler.getRecomputeChange(newValue,oldValue);if(importantChangedDefinition){broadCastUpdateChartPromptSuggestions();$timeout.cancel(themeChangeTimeoutId);$timeout.cancel(frontImportantChangeTimeoutId);onChartImportantDefinitionChanged(importantChangedDefinition,newValue);if(importantChangedDefinition.name==="filters"){$rootScope.$broadcast("chartFiltersUpdate",nv?.id)}return}const frontChangedDefinition=ChartDefinitionChangeHandler.getFrontImportantChange(newValue,oldValue);if(frontChangedDefinition){broadCastUpdateChartPromptSuggestions();$timeout.cancel(themeChangeTimeoutId);$timeout.cancel(frontImportantChangeTimeoutId);onChartFrontImportantDefinitionChanged(frontChangedDefinition,newValue);return}const delayedChangedDefinition=ChartDefinitionChangeHandler.getDelayedFrontImportantChange(newValue,oldValue);if(delayedChangedDefinition){broadCastUpdateChartPromptSuggestions();$timeout.cancel(themeChangeTimeoutId);$timeout.cancel(frontImportantChangeTimeoutId);frontImportantChangeTimeoutId=$timeout(()=>{onChartFrontImportantDefinitionChanged(delayedChangedDefinition,newValue)},ChartsStaticData.SAVE_DEBOUNCE_DURATION);return}const noRedrawChangedDefinition=ChartDefinitionChangeHandler.getNoRedrawChange(newValue,oldValue);if(noRedrawChangedDefinition){$timeout.cancel(themeChangeTimeoutId);$timeout.cancel(noRedrawDelayedChangeTimeoutId);onChartFrontImportantNoRedrawDefinitionChanged(noRedrawChangedDefinition,newValue);return}const noRedrawDelayedChangedDefinition=ChartDefinitionChangeHandler.getDelayedNoRedrawChange(newValue,oldValue);if(noRedrawDelayedChangedDefinition){$timeout.cancel(themeChangeTimeoutId);$timeout.cancel(noRedrawDelayedChangeTimeoutId);noRedrawDelayedChangeTimeoutId=$timeout(()=>{onChartFrontImportantNoRedrawDefinitionChanged(noRedrawDelayedChangedDefinition,newValue)},ChartsStaticData.SAVE_DEBOUNCE_DURATION);return}},true);const resetImmutableChartDef=function(nv,ov){if(!angular.equals(nv,ov)){scope.immutableChartDef=angular.copy(scope.chart.def)}};scope.$watch("chart.summary",()=>{scope.chartUsableColumns=angular.copy(scope.chart.summary?scope.chart.summary.usableColumns:[])});scope.$watch("chart.def.$axisSpecs",resetImmutableChartDef);scope.$watch("chart.def.xCustomExtent.$autoExtent",resetImmutableChartDef);scope.$watch("chart.def.yAxesFormatting[0].customExtent.$autoExtent",resetImmutableChartDef);scope.$watch("chart.def.$zoomControlInstanceId",resetImmutableChartDef);scope.$watch("chart.def.thumbnailData",function(nv,ov){if(nv!==ov&&!scope.insight){scope.saveChart(true)}});$(window).on("resize.chart_logic",function(e){if(e.detail&&e.detail.skipInCharts){return}handleResize(scope)});scope.$on("$destroy",function(){$(window).off("resize.chart_logic");resizeObserver.disconnect()});const chartParamBar=document.querySelector(".chart-param-bar");scope.chartParamBarHeight=chartParamBar.offsetHeight;scope.chartParamBarWidth=chartParamBar.offsetWidth;resizeObserver.observe(chartParamBar);scope.forceExecute=function(options){if(options!==undefined){const{store,id}=ChartStoreFactory.getOrCreate(scope.chart.def.$chartStoreId);scope.chart.def.$chartStoreId=id;store.setRequestOptions(options)}scope.recomputeAndUpdateData();scope.executeIfValid()};scope.rebuildSampling=function(){const refreshTrigger=(new Date).getTime();if(scope.chart.copySelectionFromScript){scope.shaker.explorationSampling._refreshTrigger=refreshTrigger}else{scope.chart.refreshableSelection._refreshTrigger=refreshTrigger}scope.$emit("chartSamplingChanged",{chart:scope.chart})};scope.$on("forceExecuteChart",function(){scope.forceExecute()});scope.$emit("listeningToForceExecuteChart");scope.redraw=function(options){scope.$broadcast("redraw",options)};scope.revertToLinoEngineAndReload=function(){scope.chart.engineType="LINO";scope.forceExecute()};scope.craftBinningFormChart=function(params){$rootScope.globallyOpenContextualMenu=undefined;scope.$emit("craftBinningFormChart",{dimension:angular.copy(params.dimension),dimensionRef:params.dimension,isEditMode:params.isEditMode,hideOneTickPerBin:params.hideOneTickPerBin,customBinningOnly:params.customBinningOnly})};scope.createReusableDimensionFromChart=function(params){$rootScope.globallyOpenContextualMenu=undefined;scope.$emit("createReusableDimensionFromChart",{...params,dimension:angular.copy(params.dimension),dimensionRef:params.dimension})};scope.recomputeAndUpdateData=function(changedDefinition){const{store,id}=ChartStoreFactory.getOrCreate(scope.chart.def.$chartStoreId);scope.chart.def.$chartStoreId=id;ChartTypeChangeHandler.fixupSpec(scope.chart,scope.chart.theme,changedDefinition);scope.canHasTooltipMeasures=[CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.GRID_MAP,CHART_TYPES.LINES,CHART_TYPES.STACKED_AREA,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.PIE,CHART_TYPES.BINNED_XY].includes(scope.chart.def.type);scope.canAnimate=ChartFeatures.canAnimate(scope.chart.def.type);scope.canFacet=ChartFeatures.canFacet(scope.chart.def.type,scope.chart.def.webAppType);scope.canFilter=ChartFeatures.canFilter(scope.chart.def.type,scope.chart.def.webAppType);scope.updateHierarchyInfo();return};scope.setChartType=function(chartId){let newChartType;if(scope.availableChartTypes||scope.webapps){newChartType=[...scope.availableChartTypes||[],...scope.webapps||[]].find(item=>item.id===chartId)}if(!newChartType){return}WT1.event("chart-type-change",{chartId:`${$stateParams.projectKey.dkuHashCode()}.${getWT1ContextName().dkuHashCode()}.${scope.chart.def.name.dkuHashCode()}`,chartType:newChartType.type,chartVariant:newChartType.variant});const oldChartType=scope.chart.def.type;element.find(".pivot-charts .mainzone").remove();Logger.info("Set chart type");ChartTypeChangeHandler.onChartTypeChange(scope.chart.def,newChartType.type,newChartType.variant,newChartType.webappType);Logger.info("AFTER chart type",scope.chart.def);scope.chart.def.type=newChartType.type;scope.chart.def.variant=newChartType.variant;scope.chart.def.webAppType=newChartType.webappType;if(!scope.validity.valid){DSSVisualizationThemeUtils.applyToChart({chart:scope.chart.def,theme:scope.chart.theme})}if(scope.chart.def.$zoomControlInstanceId){ChartZoomControlAdapter.clear(scope.chart.def.$zoomControlInstanceId);scope.chart.def.$zoomControlInstanceId=null}onChartImportantDefinitionChanged({name:"type",nv:newChartType.type,ov:oldChartType},scope.chart.def);if(!scope.$$phase){scope.$apply()}}});scope.exportToImage=function(){scope.$broadcast("export-chart");WT1.event("chart-download",{chartId:`${$stateParams.projectKey.dkuHashCode()}.${getWT1ContextName().dkuHashCode()}.${scope.chart.def.name.dkuHashCode()}`,format:"image",chartType:scope.chart.def.type,chartVariant:scope.chart.def.variant});if(scope.displayChartOptionsMenu){scope.toggleChartOptionsMenu()}};scope.exportToExcel=function(){if(scope.excelExportableChart){let animationFrameIdx;const chartDef=scope.chart.def;const colorMapsArray=scope.getColorMap();const pivotResponse=scope.excelExportableChart.pivotResponse;if(chartDef.animationDimension.length){animationFrameIdx=scope.animation.currentFrame}DataikuAPI.shakers.charts.exportToExcel(chartDef,pivotResponse,animationFrameIdx,colorMapsArray).success(data=>{WT1.event("chart-download",{chartId:`${$stateParams.projectKey.dkuHashCode()}.${getWT1ContextName().dkuHashCode()}.${scope.chart.def.name.dkuHashCode()}`,format:"excel",chartType:chartDef.type,chartVariant:chartDef.variant});downloadURL(DataikuAPI.shakers.charts.downloadExcelUrl(data.id))}).error(setErrorInScope.bind(scope));if(scope.displayChartOptionsMenu){scope.switchchartOptionsMenu()}}};scope.getColorMap=function(){const colorMapsArray=[];if(scope.chart.def.colorMode==="COLOR_GROUPS"){scope.getColorFromConditionalFormatting(colorMapsArray)}else{scope.getColorFromColorScale(colorMapsArray)}return colorMapsArray},scope.getColorFromColorScale=function(colorMapArray){const pivotResponse=scope.excelExportableChart.pivotResponse;if(scope.chart.def.colorMeasure.length&&pivotResponse.aggregations.length>1){const colorScale=scope.legendsWrapper.getLegend(0).scale;const backgroundColorMap={};const fontColorMap={};pivotResponse.aggregations[pivotResponse.aggregations.length-1].tensor.forEach((value,index)=>{const color=colorScale(value,index);if(!(value in backgroundColorMap)&&color){backgroundColorMap[value]=ColorUtils.toHex(color);fontColorMap[value]=ColorUtils.getFontContrastColor(color,scope.chart.theme&&scope.chart.theme.generalFormatting.fontColor)}});colorMapArray.push({backgroundColorMap:backgroundColorMap,fontColorMap:fontColorMap})}},scope.getColorFromConditionalFormatting=function(colorMapsArray){scope.chart.def.genericMeasures.forEach((measure,measureIndex)=>{colorMapsArray.push(scope.retrieveColorMaps(scope.chart.def.colorGroups,measure,measureIndex))});return colorMapsArray},scope.retrieveColorMaps=function(colorGroups,measure,measureIndex){const backgroundColorMap={};const fontColorMap={};const pivotResponse=scope.excelExportableChart.pivotResponse;const measureId=ConditionalFormattingOptions.getMeasureId(measure);const measureGroup=colorGroups.find(group=>group.appliedColumns&&group.appliedColumns.map(column=>ConditionalFormattingOptions.getMeasureId(column)).includes(measureId));pivotResponse.aggregations[measureIndex].tensor.forEach((value,valueIndex)=>{if(!_.isNil(measureGroup)){value=scope.chartData.getNonNullCount(valueIndex,measureIndex)>0?value:"";const ruleClass=ConditionalFormattingOptions.getColorRuleClass(value,measureGroup.rules,measure,scope.chart.theme);const colorFormattingClass=ruleClass.class;let fontColor="#000000";let backgroundColor="#FFFFFF";if(colorFormattingClass.includes("text")){fontColor=ConditionalFormattingOptions.getStripeColor(colorFormattingClass,{})}else if(colorFormattingClass.includes("background")){fontColor="#FFFFFF";backgroundColor=ConditionalFormattingOptions.getStripeColor(colorFormattingClass,{})}else if(colorFormattingClass.includes("custom")){fontColor=ruleClass.customColors.customFontColor||fontColor;backgroundColor=ruleClass.customColors.customBackgroundColor||backgroundColor}scope.retrieveColor(fontColorMap,fontColor,value);scope.retrieveColor(backgroundColorMap,backgroundColor,value)}});return{backgroundColorMap:backgroundColorMap,fontColorMap:fontColorMap}};scope.retrieveColor=function(colorMap,color,measureValue){if(!(measureValue in colorMap&&color)){colorMap[measureValue]=color}},scope.openPasteModalFromKeydown=function(data){!scope.readOnly&&ChartConfigurationCopyPaste.pasteChartFromClipboard({valid:scope.validity.valid,isInInsight:scope.isInInsight},data).then(res=>scope.pasteChart(res,scope.currentChart.index))};scope.keydownCopy=function(){if(window.getSelection().toString()===""){ChartConfigurationCopyPaste.copyChartToClipboard(scope.chart.def,scope.appVersion,scope.chart.theme)}};scope.deleteCurrentChart=function(){scope.deleteChart(scope.currentChart.index)};scope.duplicateChart=function(){scope.addChart({chart:{...scope.chart,def:{...scope.chart.def,id:window.crypto.getRandomValues(new Uint32Array(1))[0].toString(16)}},index:scope.currentChart.index,copyOfName:true,wt1Event:"chart-duplicate"})};scope.displayChartOptionsMenu=false;scope.toggleChartOptionsMenu=function(){scope.displayChartOptionsMenu=!scope.displayChartOptionsMenu;if(scope.displayChartOptionsMenu){$timeout(function(){$(window).on("click",scope.switchChartOptionsMenuOnClick)})}else{$(window).off("click",scope.switchChartOptionsMenuOnClick)}};scope.switchChartOptionsMenuOnClick=function(e){const clickedEl=e.target;if($(clickedEl).closest(".chart-options-wrapper").length<=0&&scope.displayChartOptionsMenu){scope.toggleChartOptionsMenu();scope.$apply()}};scope.blurElement=function(inputId){$timeout(function(){$(inputId).blur()})};scope.blurTitleEdition=function(){scope.editingTitle=false;scope.chart.def.userEditedName=true;$timeout(scope.saveChart);if(scope.excelExportableChart){scope.excelExportableChart.chartDef.name=scope.chart.def.name}};scope.editChartTitle=function(){scope.editingTitle=!(scope.isInInsight&&$rootScope.topNav.tab==="view")};scope.openChartSamplingTab=function(){$rootScope.$broadcast("tabSelect","sampling-engine")};function getWT1ContextName(){const context=scope.analysisCoreParams||scope.insight||scope.dataset||{name:"unknown"};return context.name}function shouldDisplaySamplingStatus(){const pivotResponse=scope.response&&scope.response.result&&scope.response.result.pivotResponse;const sampleMetadata=pivotResponse&&pivotResponse.sampleMetadata;return sampleMetadata&&!sampleMetadata.sampleIsWholeDataset}scope.shouldDisplayPointRangeWarning=()=>{return scope.chart.def.type===CHART_TYPES.SCATTER&&scope.uiDisplayState?.lowPointSizeRangeWarning};scope.hasBetaFormattingPane=function(chartType){const charts=[CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.STACKED_AREA,CHART_TYPES.PIVOT_TABLE,CHART_TYPES.SCATTER,CHART_TYPES.SCATTER_MULTIPLE_PAIRS,CHART_TYPES.LINES,CHART_TYPES.TREEMAP,CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.SCATTER_MAP,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.GRID_MAP,CHART_TYPES.DENSITY_HEAT_MAP,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.PIE,CHART_TYPES.SANKEY,CHART_TYPES.GROUPED_XY,CHART_TYPES.BINNED_XY,CHART_TYPES.LIFT,CHART_TYPES.BOXPLOTS,CHART_TYPES.DENSITY_2D,CHART_TYPES.RADAR,CHART_TYPES.KPI,CHART_TYPES.GAUGE];return charts.includes(chartType)};scope.assignToChartDef=function(propertyPath,value,merge){let assignedValue=value;if(merge){assignedValue=_.assign(_.get(scope.chart.def,propertyPath),value)}_.set(scope.chart.def,propertyPath,assignedValue);$timeout(()=>scope.$apply())};scope.onChartDefPropertyChange=function(event){if(event.id){scope.updateYAxisFormatting(event.key,event.value,event.id)}else{scope.assignToChartDef(event.key,event.value,event.merge)}};scope.onFormattingPaneTabChange=function(){$rootScope.$broadcast("reflow")};scope.onFetchColumnsSummaryForPalette=function(){if($rootScope.fetchColumnsSummaryForCurrentChart){$rootScope.fetchColumnsSummaryForCurrentChart(true).then($rootScope.redraw)}else{$rootScope.fetchColumnsSummary().then($rootScope.redraw)}};scope.updateYAxisFormatting=(key,value,id)=>{const yAxesFormatting=_.clone(scope.chart.def.yAxesFormatting);const axisFormatting=ChartAxesUtils.getFormattingForYAxis(yAxesFormatting,id);_.set(axisFormatting,key,value);scope.assignToChartDef("yAxesFormatting",yAxesFormatting)};scope.headerDrillUp=dimension=>{ChartDrilldown.handleDrillUp(scope.chart.def,dimension,DRILL_UP_SOURCE.CHART_HEADER)};scope.updateHierarchyInfo=()=>{scope.hierarchiesInChart=ChartHierarchyDimension.getHierarchyDimensionsForChartType(scope.chart.def)||[];scope.updateHierarchyMissingColumns();scope.hierarchyDimsInChart=ChartHierarchyDimension.getHierarchyDimensionsForChartType(scope.chart.def).map(hierarchy=>hierarchy.dimensions[hierarchy.level]);scope.breadcrumbs=ChartDrilldown.getBreadcrumbs(scope.chart.def);scope.breadcrumbTooltips={};scope.hierarchyDimsInChart.forEach(dimension=>{scope.breadcrumbTooltips[dimension.hierarchyId]=ChartDrilldown.getBreadcrumbTooltipForHierarchyDim(scope.breadcrumbs,dimension)})};scope.updateHierarchyMissingColumns=()=>{const{store,id}=ChartStoreFactory.getOrCreate(scope.chart.def.$chartStoreId);scope.chart.def.$chartStoreId=id;scope.hierarchiesMissingColumns=ChartHierarchies.getHierarchiesMissingColumns(scope.hierarchiesInChart,scope.usableColumns,scope.reusableDimensions);store.setHierarchyMissingColumns(scope.hierarchiesMissingColumns)};scope.canDimensionDrillUp=dimension=>{return ChartHierarchyDimension.canDimensionDrillUp(scope.chart.def,dimension)};scope.resetResponseErrorsInScope=()=>{scope.allFilteredOut=false;scope.display0Warning=false;scope.hasUnusableHierarchy=false};scope.aiText2ChartEnabled=$rootScope.appConfig.aiText2ChartEnabled;scope.chartsAIAssistantVisible=scope.aiText2ChartEnabled&&!scope.readOnly&&localStorageService.get("chartsAIAssistantVisible")!=="false"?true:false;scope.toggleAIAssistant=function(value){if(typeof value==="boolean"&&value!==scope.chartsAIAssistantVisible){scope.chartsAIAssistantVisible=value;localStorageService.set("chartsAIAssistantVisible",scope.chartsAIAssistantVisible);scope.redraw()}};scope.setHasOngoingLLMRequest=function(hasOngoingLLMRequest){scope.hasOngoingLLMRequest=hasOngoingLLMRequest;if(!scope.$$phase){scope.$apply()}};scope.LLMUpdateChartDef=function(newChartDef){scope.charts[scope.currentChart.index].def=newChartDef;scope.chartTypePickerOptions={...scope.chartTypePickerOptions,chartVariant:newChartDef.variant,chartType:newChartDef.type};if(!scope.$$phase){scope.$apply()}};scope.LLMRevertChartDef=function(prevChartDef){scope.charts[scope.currentChart.index].def=prevChartDef;scope.chartTypePickerOptions={...scope.chartTypePickerOptions,chartVariant:prevChartDef.variant,chartType:prevChartDef.type};if(!scope.$$phase){scope.$apply()}}}};function onPivotRequestError(scope){return(data,status,headers)=>{scope.response=undefined;scope.resetResponseErrorsInScope();if(data.code==="FILTERED_OUT"){scope.allFilteredOut=true}else if(data.code==="CANNOT_DISPLAY_WITH_EMPTY_AXES"){scope.display0Warning=true}else if((data.code==="MISSING_COLUMN"||data.errorType==="com.dataiku.dip.exceptions.PivotMissingColumnException")&&!_.isEmpty(scope.hierarchiesMissingColumns)){const canDisplayChart=scope.hierarchiesInChart.every(hierarchy=>ChartHierarchyDimension.hasHierarchyUsableColumns(scope.chart.def.$chartStoreId,hierarchy));if(canDisplayChart){scope.hierarchiesInChart.forEach(hierarchy=>ChartHierarchyDimension.resetHierarchyToUsableDimension(scope.chart.def.$chartStoreId,hierarchy))}else{scope.hasUnusableHierarchy=true}}else{if(ChartTypeChangeHandler.hasRequestResponseWarning(scope.chart.def,data)){scope.setValidity(ChartTypeChangeHandler.getRequestResponseWarning(scope.chart.def,data))}else if(ChartDataUtils.isPivotRequestAborted(data)){}else{scope.chartSetErrorInScope(data,status,headers)}}}}function parseWebapps(data){const webapps=[];data.forEach(w=>{webapps.push({id:w.desc.id,displayName:w.desc.meta.label||w.desc.id,type:CHART_TYPES.WEBAPP,variant:CHART_VARIANTS.normal,webappType:w.webappType,isWebapp:true})});if(webapps){webapps.sort((a,b)=>a.webappType.localeCompare(b.webappType))}return webapps}function handleResize(scope){const debouncedRedrawAfterResize=Debounce().withDelay(1,300).withScope(scope).withSpinner(false).wrap(f=>{Logger.debug("Redrawing chart after resize (debounced)");scope.redraw()});Logger.debug("Window was resized, will redraw chart a bit later");if(scope.chart.def.type==CHART_TYPES.BINNED_XY&&scope.chart.def.variant==CHART_VARIANTS.binnedXYHexagon){scope.recomputeAndUpdateData();scope.executeIfValid()}else{debouncedRedrawAfterResize()}scope.$apply()}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("contextualMenu",function($rootScope,$window,$compile,$timeout,CHART_FILTERS,ChartStoreFactory,ChartFeatures,ChartAxesUtils,ChartsStaticData){let isCurrentlyEdited=false;function getContextualMenuClassName(axis){return`${axis}-axis-contextual-menu qa_charts_${axis}-axis-contextual-menu`}function targetIsSelectInput(e){return e.target.closest(".bootstrap-select")!==null}function targetShouldNotCloseInput(e){return e.target.closest(".no-global-contextual-menu-close")!==null}$($window).on("click",function(e){if(targetIsSelectInput(e)||targetShouldNotCloseInput(e)||isCurrentlyEdited){e.stopPropagation();isCurrentlyEdited=false}else if(!e.isDefaultPrevented()&&!e.target.hasAttribute("no-global-contextual-menu-close")){$rootScope.globallyOpenContextualMenu=undefined;$rootScope.$apply()}});return{scope:true,compile:function(element,attrs){const popoverTemplate=element.find(".contextualMenu").detach();return function($scope,element,attrs){let popover=null;let popoverScope=null;$scope.contextualMenu=false;$scope.ChartFeatures=ChartFeatures;$scope.getXAxisTitle=ChartAxesUtils.getXAxisTitle;$scope.getYAxisTitle=ChartAxesUtils.getYAxisTitle;$scope.COLUMN_TYPES=CHART_FILTERS.COLUMN_TYPES;$scope.getXAxisHint=()=>{return ChartFeatures.hasMultipleXDim($scope.chart.def.type)?"(settings will be common to all X dimensions)":""};function hide(){if(popover){if(popoverScope){popoverScope.$destroy();popoverScope=null}popover.hide().remove();popover=null}}function show(){if(popover===null){popoverScope=$scope.$new();popoverScope.$contextScope=$scope;popover=$compile(popoverTemplate.get(0).cloneNode(true))(popoverScope)}popover.appendTo("body");const position=attrs.cepPosition||"align-left-bottom";const mainZone=element;const mzOff=element.offset();if(element.parent().parent().hasClass("chartdef-dropped")){mzOff.top-=4;mzOff.left-=10}switch(position){case"align-left-bottom":popover.css({left:mzOff.left,top:mzOff.top+mainZone.height()});break;case"align-right-bottom":popover.css({top:mzOff.top+mainZone.height(),left:mzOff.left+mainZone.innerWidth()-popover.innerWidth()});break;case"align-right-top":popover.css({top:mzOff.top,left:mzOff.left+mainZone.innerWidth()});break;case"smart":var offset={left:"auto",right:"auto",top:"auto",bottom:"auto"};if(mzOff.left*2<window.innerWidth){offset.left=mzOff.left}else{offset.right=window.innerWidth-mzOff.left-mainZone.innerWidth()}if(mzOff.top*2<window.innerHeight){offset.top=mzOff.top+mainZone.height()}else{offset.bottom=window.innerHeight-mzOff.top}popover.css(offset);break;case"smart-left-bottom":$timeout(function(){const offset={left:mzOff.left,right:"auto",top:"auto",bottom:"auto"};if(mzOff.top+mainZone.height()+popover.outerHeight()>window.innerHeight){offset.bottom=window.innerHeight-mzOff.top}else{offset.top=mzOff.top+mainZone.height()}popover.css(offset)});break}if(attrs.cepWidth==="fit-main"){popover.css("width",mainZone.innerWidth())}popover.show();popover.on("click",function(e){isCurrentlyEdited=false;if(!targetIsSelectInput(e)){e.stopPropagation()}});popover.on("mouseleave",function(e){if(isLeftClickPressed(e)){isCurrentlyEdited=true}})}$scope.$watch("contextualMenu",function(nv,ov){if(nv){show()}else{hide()}});$scope.toggleContextualMenu=function(e){if($scope.globallyOpenContextualMenu&&$scope.globallyOpenContextualMenu[0]===element[0]){$rootScope.globallyOpenContextualMenu=undefined}else{$rootScope.globallyOpenContextualMenu=element}e.preventDefault()};$scope.getMeasureClassName=function(chartType){const measureAxis=chartType==="stacked_bars"?"x":"y";return getContextualMenuClassName(measureAxis)};$scope.getDimensionClassName=function(chartType){const dimensionAxis=chartType==="stacked_bars"?"y":"x";return getContextualMenuClassName(dimensionAxis)};$scope.$on("$destroy",function(){hide()});const globallyOpenContextualMenuWatcherUnsubscribe=$rootScope.$watch("globallyOpenContextualMenu",function(nv,ov){$scope.contextualMenu=$rootScope.globallyOpenContextualMenu&&$rootScope.globallyOpenContextualMenu[0]===element[0]});$scope.$on("$destroy",globallyOpenContextualMenuWatcherUnsubscribe);$scope.getYAxisFormatting=function(formatting,id){return ChartAxesUtils.getFormattingForYAxis(formatting,id)};if($scope.chart){const{id,store}=ChartStoreFactory.getOrCreate($scope.chart.def.$chartStoreId);$scope.chart.def.$chartStoreId=id;$scope.$watch(()=>store.get("axisSpecs"),(axisSpecs,oldAxisSpecs)=>{if(axisSpecs!=null&&(!angular.equals(axisSpecs,oldAxisSpecs)||_.isNil($scope.xAxisSpec)||_.isNil($scope.yAxisSpec))){const isXAxisPercentScale=!!(axisSpecs.xSpec&&axisSpecs.xSpec.isPercentScale);const isYAxisPercentScale=!!(axisSpecs.ySpec&&axisSpecs.ySpec.isPercentScale);$scope.xAxisComputeMode=isXAxisPercentScale?"PERCENTAGE":"NORMAL";$scope.yAxisComputeMode=isYAxisPercentScale?"PERCENTAGE":"NORMAL";$scope.ySpecId=attrs.ySpecId;$scope.xAxisSpec=store.getAxisSpec("x");$scope.yAxisSpec=store.getAxisSpec($scope.ySpecId||ChartsStaticData.LEFT_AXIS_ID);if($scope.yAxisSpec){$scope.yAxisFormatting=$scope.getYAxisFormatting($scope.chart.def.yAxesFormatting,$scope.yAxisSpec.id)}}})}}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("chartDragCopySource",()=>{return{controller:"ChartDragDropController",link:function($scope,element,attrs){const el=element[0];$scope.$watch(attrs.chartDragDisable,function(nv){element[0].draggable=nv!==true});el.addEventListener("dragstart",function(e){$scope.$apply(function(){$scope.activeDragDrop.active=true;$scope.setDragActive();$scope.activeDragDrop.data=$scope.$eval(attrs.chartDragCopySource)});e.dataTransfer.effectAllowed="copy";e.dataTransfer.setData(window.dkuDragType,JSON.stringify($scope.activeDragDrop.data));this.classList.add("dragging");return false},false);el.addEventListener("dragend",function(e){this.classList.remove("dragging");return false},false)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("chartDragDropListItem",()=>{let shouldBeDragged=true;return{controller:"ChartDragDropController",link:function($scope,element,attrs){$(element).attr("draggable","true");const specifyDragTrigger=attrs.specifyDragTrigger!==undefined;if(specifyDragTrigger){element[0].addEventListener("mousedown",function(e){let node=e.target;while(node){if(node.hasAttribute("trigger-drag")){shouldBeDragged=true;break}if(node.hasAttribute("specify-drag-trigger")){shouldBeDragged=false;break}node=node.parentElement}})}element[0].addEventListener("dragstart",function(e){if(specifyDragTrigger&&!shouldBeDragged){e.preventDefault();return}const draggedElement=$(e.target);$scope.$apply(function(){$scope.activeDragDrop.active=true;$scope.setDragActive();$scope.activeDragDrop.moveFromList=$scope.$eval(attrs.chartDragDropListItem);$scope.activeDragDrop.moveFromListIndex=draggedElement.index();$scope.activeDragDrop.data=$scope.activeDragDrop.moveFromList[$scope.activeDragDrop.moveFromListIndex];$scope.activeDragDrop.draggedElementToHide=draggedElement});e.dataTransfer.effectAllowed="move";e.dataTransfer.setData(window.dkuDragType,JSON.stringify($scope.activeDragDrop.data));this.classList.add("dragging");return false},false);element[0].addEventListener("dragend",function(e){this.classList.remove("dragging");return false},false)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("chartDragDropListReplace",function($parse,Assert){return{scope:true,controller:"ChartDragDropController",link:function($scope,element,attrs){let acceptFunc=function(data){return{accept:true,message:"Drop here"}};if(attrs.acceptDrop){const parsed=$parse(attrs.acceptDrop);acceptFunc=function(data){return parsed($scope.$parent||$scope,{data:data})}}const parsed=attrs.getChartDragDropListReplace&&$parse(attrs.getChartDragDropListReplace);$scope.getChartDragDropListReplace=function(data){const parsedFn=parsed&&parsed($scope.$parent||$scope);if(!parsedFn){return $scope.$eval(attrs.chartDragDropListReplace)}return parsedFn(data)};const onDragOverOrEnter=function(e){this.classList.add("over");$(this).parent().parent().addClass("over");if($scope.activeDragDrop.draggedElementToHide){$scope.activeDragDrop.draggedElementToHide.hide()}const accepted=acceptFunc($scope.activeDragDrop.data);if(accepted.accept){e.dataTransfer.dropEffect="copyMove";e.preventDefault()}else{$scope.$apply(function(){$scope.validity.tempError={};$scope.validity.tempError.type="MEASURE_REJECTED";$scope.validity.tempError.message=accepted.message})}};element[0].addEventListener("dragover",onDragOverOrEnter,false);element[0].addEventListener("dragenter",onDragOverOrEnter,false);element[0].addEventListener("dragleave",function(e){this.classList.remove("over");$(this).parent().parent().removeClass("over");$scope.$apply(function(){delete $scope.validity.tempError});return false},false);$scope.$watch("activeDragDrop.active",function(nv,ov){if(nv){const accepted=acceptFunc($scope.activeDragDrop.data);if(accepted.accept){$scope.addClassHereAndThere(element,"drop-accepted")}else{$scope.addClassHereAndThere(element,"drop-rejected")}}else{$scope.removeClassHereAndThere(element,"drop-accepted");$scope.removeClassHereAndThere(element,"drop-rejected")}},true);element[0].addEventListener("drop",function(e){Assert.trueish($scope.activeDragDrop.active,"no active drag and drop");if(e.stopPropagation){e.stopPropagation()}this.classList.remove("over");$(this).parent().parent().removeClass("over");$scope.$apply(function($scope){const newData=angular.copy($scope.activeDragDrop.data);const targetList=$scope.getChartDragDropListReplace(newData);delete newData.$$hashKey;newData.__justDragDropped=true;if($scope.activeDragDrop.moveFromList&&$scope.activeDragDrop.moveFromList===targetList){}else if($scope.activeDragDrop.moveFromList){targetList.splice(0,targetList.length);targetList.push(newData);$scope.activeDragDrop.moveFromList.splice($scope.activeDragDrop.moveFromListIndex,1)}else{targetList.splice(0,targetList.length);targetList.push(newData)}element.removeClass("drop-accepted");element.removeClass("drop-rejected");$scope.onDragEnd(newData);$scope.$emit("dragDropSuccess")});return false},false)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("chartDragDropList",function($parse,Assert){return{scope:true,controller:"ChartDragDropController",link:function($scope,element,attrs){let acceptFunc=function(data){return{accept:true,message:"Drop here"}};if(attrs.acceptDrop){const parsed=$parse(attrs.acceptDrop);acceptFunc=function(data){return parsed($scope.$parent||$scope,{data:data})}}const parsed=attrs.getChartDragDropList&&$parse(attrs.getChartDragDropList);$scope.getChartDragDropList=function(data){const parsedFn=parsed&&parsed($scope.$parent||$scope);if(!parsedFn){return $scope.$eval(attrs.chartDragDropList)}return parsedFn(data)};const placeholderPos=attrs.placeholderPos||"end";const direction=attrs.direction||"horizontal";const placeholder=$('<li class="sortable-placeholder" />');let placeholderAttachedOnce=false;const onDragOverOrEnter=function(e){this.classList.add("over");$scope.addClassHereAndThere(this,"over");const dropLi=$(e.target).closest("li");if($scope.activeDragDrop.draggedElementToHide){$scope.activeDragDrop.draggedElementToHide.hide()}const accepted=acceptFunc($scope.activeDragDrop.data);if(accepted.accept){e.dataTransfer.dropEffect="copyMove";if(dropLi.length!==0){if(direction==="horizontal"){const mouseX=e.clientX;const dropLiWidth=dropLi.outerWidth();const dropLiLeft=dropLi.offset().left;const isLeft=mouseX<dropLiLeft+dropLiWidth/2;if(isLeft){dropLi.before(placeholder)}else{dropLi.after(placeholder)}}else{const mouseY=e.clientY;const dropLiTop=dropLi.offset().top;const dropLiHeight=dropLi.outerHeight();const isTop=mouseY<dropLiTop+dropLiHeight/2;if(isTop){dropLi.before(placeholder)}else{dropLi.after(placeholder)}}}e.preventDefault()}else{$scope.$apply(function(){$scope.validity.tempError={};$scope.validity.tempError.type="MEASURE_REJECTED";$scope.validity.tempError.message=accepted.message})}};element[0].addEventListener("dragover",onDragOverOrEnter,false);element[0].addEventListener("dragenter",onDragOverOrEnter,false);element[0].addEventListener("dragleave",function(e){$scope.removeClassHereAndThere(this,"over");$scope.$apply(function(){if($scope.validity&&$scope.validity.tempError){delete $scope.validity.tempError}});return false},false);$scope.$watch("activeDragDrop.active",function(nv,ov){if(nv){const accepted=acceptFunc($scope.activeDragDrop.data);if(accepted.accept){$scope.addClassHereAndThere(element,"drop-accepted");window.setTimeout(function(){const listElement=element[0].tagName==="UL"?element:element.find("ul").first();if(placeholderPos=="end"){listElement.append(placeholder)}else{listElement.prepend(placeholder)}placeholderAttachedOnce=true},10)}else{$scope.addClassHereAndThere(element,"drop-rejected")}}else{$scope.removeClassHereAndThere(element,"drop-accepted");$scope.removeClassHereAndThere(element,"drop-rejected");if(placeholderAttachedOnce){window.setTimeout(function(){placeholder.detach()},10)}}},true);element[0].addEventListener("drop",function(e){Assert.trueish($scope.activeDragDrop.active,"no active drag and drop");if(e.stopPropagation){e.stopPropagation()}$scope.removeClassHereAndThere(this,"over");let dropIndex=$(e.target).index();if($(e.target).is("ul")){dropIndex=Array.from(e.target.children).findIndex(item=>item===placeholder[0]);if(dropIndex===-1){dropIndex=e.target.children.length}}$scope.$apply(function($scope){const newData=angular.copy($scope.activeDragDrop.data);delete newData.$$hashKey;newData.__justDragDropped=true;const targetList=$scope.getChartDragDropList(newData);if($scope.activeDragDrop.moveFromList&&$scope.activeDragDrop.moveFromList===targetList){const oldIdx=$scope.activeDragDrop.moveFromListIndex;if(dropIndex>oldIdx&&dropIndex>0){dropIndex--}targetList.splice(dropIndex,0,targetList.splice(oldIdx,1)[0])}else if($scope.activeDragDrop.moveFromList){targetList.splice(dropIndex,0,newData);if($scope.activeDragDrop.moveFromList){$scope.activeDragDrop.moveFromList.splice($scope.activeDragDrop.moveFromListIndex,1)}}else{targetList.splice(dropIndex,0,newData)}$scope.removeClassHereAndThere(element,"drop-accepted");$scope.removeClassHereAndThere(element,"drop-rejected");placeholder.detach();$scope.onDragEnd(newData);$scope.$emit("dragDropSuccess")});return false},false)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("chartMultiDragDropZones",function(translate,ChartColumnTypeUtils,WT1){return{controller:"ChartDragDropController",link:function($scope,element){$scope.activeDragDrop={};$scope.translate=translate;$scope.onDragEnd=function(data){if($scope.activeDragDrop.draggedElementToHide){$scope.activeDragDrop.draggedElementToHide.show()}clear($scope.activeDragDrop);$scope.setDragInactive();const currentChartIndex=$scope.currentChart&&$scope.currentChart.index;if(ChartColumnTypeUtils.isHierarchy(data)&&!_.isNil(currentChartIndex)){const chartType=$scope.charts&&$scope.charts[currentChartIndex]&&$scope.charts[currentChartIndex].def.type;WT1.event("hierarchy-added-to-chart",{chartType:chartType})}};element[0].addEventListener("dragend",function(e){$scope.$apply($scope.onDragEnd)})}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("aggregatedGeoZone",function($parse,ChartsStaticData,translate,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/aggregated-geo-zone/aggregated-geo-zone.directive.html",scope:true,link:function($scope,element,attrs){const defaultAggregationOptions=[{value:ChartsStaticData.GEOM_AGGREGATIONS.DEFAULT,label:translate("CHARTS.DROPPED_DIMENSION.KEEP_DUPLICATES","Keep duplicates")},{value:ChartsStaticData.GEOM_AGGREGATIONS.DISTINCT,label:translate("CHARTS.DROPPED_DIMENSION.MAKE_UNIQUE","Make unique")}];$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.aggregationOptions=defaultAggregationOptions;$scope.$watch(attrs.uaColor,function(newUaColor){$scope.showAggregate=newUaColor.length===0;if($scope.showAggregate){$scope.aggregationOptions=defaultAggregationOptions}else{$scope.aggregationOptions=[]}},true);$scope.getLabel=function(aggregationFunction){if(aggregationFunction===ChartsStaticData.GEOM_AGGREGATIONS.DISTINCT){return translate("CHARTS.DROPPED_DIMENSION.UNIQUE","(UNIQUE)")}else{return""}};$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("geoAdminZone",function($parse,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/geo-admin-zone/geo-admin-zone.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.id=attrs.id;$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("geoNoOptsZone",function($parse){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/geo-no-opts-zone/geo-no-opts-zone.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.acceptCallback=$parse(attrs.acceptCallback)($scope)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("monoUaZoneNoOpts",function($parse){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/mono-ua-zone-no-opts/mono-ua-zone-no-opts.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.acceptCallback=$parse(attrs.acceptCallback)($scope)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("monoUaZone",function($parse,ChartFeatures,ChartLabels,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/mono-ua-zone/mono-ua-zone.directive.html",scope:true,link:function($scope,_element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.ChartFeatures=ChartFeatures;$scope.ChartLabels=ChartLabels;$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("monovaluedStdAggrDimensionZoneNoOpts",function($parse){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/monovalued-std-aggr-dimension-zone-no-opts/monovalued-std-aggr-dimension-zone-no-opts.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.acceptCallback=$parse(attrs.acceptCallback)($scope)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("monovaluedStdAggrDimensionZone",function($parse,ChartsStaticData,ChartLabels,ChartColumnTypeUtils,ChartHierarchyDimension,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/monovalued-std-aggr-dimension-zone/monovalued-std-aggr-dimension-zone.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.getList=$parse(attrs.getList)($scope);attrs.$observe("chartStoreId",nv=>{$scope.chartStoreId=nv});attrs.$observe("chartDefKey",nv=>{$scope.chartDefKey=nv});attrs.$observe("axisName",nv=>{$scope.axisName=nv});$scope.isSecondDimension=$parse(attrs.isSecondDimension)($scope);$scope.hideOneTickPerBin=$scope.isSecondDimension;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.dateModes=ChartsStaticData.dateModes;$scope.ChartLabels=ChartLabels;$scope.isHierarchy=ChartColumnTypeUtils.isHierarchy;$scope.hasHierarchyWarning=ChartHierarchyDimension.hasHierarchyMissingColumns;$scope.getHierarchyWarningTooltip=ChartHierarchyDimension.getMissingColumnsTooltipForHierarchy;$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("monovaluedStdAggrMeasureZone",function($parse,ChartFeatures,ChartLabels,ChartCustomMeasures,ColorUtils,DefaultDSSVisualizationTheme,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/monovalued-std-aggr-measure-zone/monovalued-std-aggr-measure-zone.directive.html",scope:true,controller:"StdAggregatedMeasureController",link:function($scope,_element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.foregroundColors=[];$scope.themeColors=[];$scope.$watch(attrs.theme,(nv,ov)=>{$scope.theme=nv;$scope.themeColors=ColorUtils.getThemeColorsWithBlackWhite($scope.theme);if(nv&&(!ov||!_.isEqual(nv.colors,ov.colors)||!$scope.foregroundColors.length)){const paletteColors=ColorUtils.generateThemePaletteColors(nv.colors,$scope.themeColors.length>0);if(paletteColors){$scope.foregroundColors=paletteColors.foregroundColors}}else if(!nv){$scope.foregroundColors=ColorUtils.generateThemePaletteColors(DefaultDSSVisualizationTheme.colors,false).foregroundColors}$scope.defaultFormatting=$scope.theme?{fontColor:$scope.theme.generalFormatting.fontColor}:{}});$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("multiUaZoneNoOpts",function($parse){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/multi-ua-zone-no-opts/multi-ua-zone-no-opts.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.acceptCallback=$parse(attrs.acceptCallback)($scope)}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("multiUaZone",function($parse,ChartLabels,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/multi-ua-zone/multi-ua-zone.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.ChartLabels=ChartLabels;$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("multivaluedStdAggrDimensionZone",function($parse,ChartsStaticData,ChartLabels,ChartColumnTypeUtils,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/multivalued-std-aggr-dimension-zone/multivalued-std-aggr-dimension-zone.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.getList=$parse(attrs.getList)($scope);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.dateModes=ChartsStaticData.dateModes;$scope.ChartLabels=ChartLabels;$scope.isHierarchy=ChartColumnTypeUtils.isHierarchy;$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("multivaluedStdAggrMeasureZone",function($parse,ChartFeatures,Ng2MenuOrchestratorService,ChartColorUtils){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/multivalued-std-aggr-measure-zone/multivalued-std-aggr-measure-zone.directive.html",scope:true,controller:"StdAggregatedMeasureController",link:function($scope,_element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.direction=attrs.direction;$scope.shouldDisplayMultiPlotDisplayMode=function(measure){return ChartFeatures.canSetMultiPlotDisplayMode($scope.chart.def.type)&&measure&&measure.displayType==="line"&&$scope.chart.def.genericMeasures.some(m=>m.displayType==="column")&&!!ChartColorUtils.getColorDimensionOrMeasure($scope.chart.def)};$scope.$watch(attrs.theme,nv=>{$scope.theme=nv});$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("scatterAxisZone",function($parse,ChartLabels,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/scatter-axis-zone/scatter-axis-zone.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.ChartLabels=ChartLabels;$scope.pairIndex=attrs.pairIndex;$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("scatterDetailZone",function($parse,ChartLabels,ChartUADimension,Ng2MenuOrchestratorService){return{templateUrl:"/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/scatter-detail-zone/scatter-detail-zone.directive.html",scope:true,link:function($scope,element,attrs){$scope.$watch(attrs.list,newList=>$scope.list=newList);$scope.chartDefKey=attrs.chartDefKey;$scope.acceptCallback=$parse(attrs.acceptCallback)($scope);$scope.ChartLabels=ChartLabels;$scope.dateModes=ChartUADimension.getDateModes().map(({value,label})=>[value,label]);$scope.openMatMenu=function(menuIdx,event){Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey,menuIdx,event)}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.directive("extentFormatter",function(){return{restrict:"A",require:"ngModel",scope:{defaultExtentValue:"<"},link:function($scope,_element,attrs,ngModelController){if($scope.defaultExtentValue===null){return}const formatExtent=newValue=>{return newValue===null?$scope.defaultExtentValue:newValue};ngModelController.$formatters.push(formatExtent);$scope.$on("formatManualExtent",()=>{let viewValue=ngModelController.$modelValue;ngModelController.$formatters.forEach(formatter=>{viewValue=formatter(viewValue)});ngModelController.$viewValue=viewValue;ngModelController.$render()})}}})})();(function(){"use strict";angular.module("dataiku.charts").directive("continuousColorLegend",continuousColorLegend);function continuousColorLegend(Fn,D3ChartAxes){return{scope:true,templateUrl:"/static/dataiku/js/simple_report/directives/legends/continuous-color-legend/continuous-color-legend.directive.html",link:function($scope,element,attrs){const placement=element.closest(".pivot-charts").attr("legend-placement");$scope.gradientError=false;$scope.$watch(attrs.legend,function(nv,ov){$scope.draw($scope.$eval(attrs.legend))});const svg=d3.select(element[0]).select("svg"),$svg=element.find("svg"),gradient=svg.select("linearGradient");let vertical,orient,barWidth=Math.max(0,$svg.width()-10),barHeight=Math.max(0,$svg.height()-20),axisX=5,axisY=10,rectX=0;switch(placement){case"OUTER_RIGHT":vertical=true;barWidth=15;axisX=15;orient="right";break;case"OUTER_LEFT":vertical=true;barWidth=15;orient="left";break;case"OUTER_TOP":case"OUTER_BOTTOM":default:vertical=false;$svg.height(45);orient="bottom";axisY=15;barHeight=15;break}if(vertical){gradient.attr("x2","0%").attr("y2","100%")}svg.select("rect").attr("width",barWidth).attr("height",barHeight).attr("y",vertical?10:0).attr("x",vertical?0:5);const setStyle=function(style,ticks){const fontSize=style&&style.fontSize?`${style.fontSize}px`:"13px";const fontColor=style&&style.fontColor?style.fontColor:"inherit";ticks.forEach(tick=>{tick.style.fontSize=fontSize;tick.style.fill=fontColor})};$scope.draw=function(legend){if(!legend){if(svg.select("rect").attr("width")==0){$scope.gradientError=true}return}$scope.gradientError=false;const isCondFormatting=legend.type==="CONDITIONAL_FORMATTING";if(isCondFormatting){barWidth=185;svg.select("rect").attr("width",barWidth).attr("height",10)}const axisScale=legend.scale.innerScale.copy();if(legend.scale.diverging){axisScale.domain([axisScale.invert(0),axisScale.invert(1)]).range([0,1])}axisScale.range(axisScale.range().map(x=>vertical?barHeight-x*barHeight:x*barWidth)).interpolate(d3.interpolate);const axis=d3.svg.axis().orient(orient).scale(axisScale);const pixelDivisor=50;axis.tickValues(axisScale.ticks(Math.min(10,vertical?barHeight/pixelDivisor:barWidth/pixelDivisor)).concat(axisScale.domain()));axis.tickFormat(legend.formatter);const axisG=svg.select("g.axis");axisG.selectAll("*").remove();axisG.call(axis).select("path.domain").remove();const ticks=axisG.selectAll("g.tick")[0];ticks.sort((a,b)=>a.__data__-b.__data__);setStyle($scope.chart?$scope.chart.def.legendFormatting:{},ticks);if(!vertical){d3.select(ticks[0]).select("text").style("text-anchor","start");d3.select(ticks[ticks.length-1]).select("text").style("text-anchor","end")}if(isCondFormatting){ticks.length>1&&ticks.slice(1,-1).forEach(tick=>tick.remove());d3.select(ticks[0]).select("line").remove();d3.select(ticks[0]).select("text").text("Min");d3.select(ticks[ticks.length-1]).select("line").remove();d3.select(ticks[ticks.length-1]).select("text").text("Max")}else{D3ChartAxes.sanitizeTicksDisplay(ticks)}const colors=legend.scale.outerScale.range();const colorStops=[];const numStops=legend.scale.quantizationMode==="NONE"?colors.length-1:colors.length;if(legend.scale.quantizationMode!=="QUANTILES"){colors.forEach(function(c,i){colorStops.push({color:c,offset:i*100/numStops});if(legend.scale.quantizationMode!=="NONE"){colorStops.push({color:c,offset:(i+1)*(100/numStops)})}})}else{const thresholds=legend.scale.outerScale.quantiles();colors.forEach(function(c,i){colorStops.push({color:c,offset:i===0?0:thresholds[i-1]*100});colorStops.push({color:c,offset:i===colors.length-1?100:thresholds[i]*100})})}if(vertical){colorStops.forEach(function(stop){stop.offset=100-stop.offset});colorStops.reverse()}const padding=5;const margin=15;gradient[0][0].replaceChildren([]);gradient.selectAll("stop").data(colorStops).enter().append("stop").attr("offset",stop=>stop.offset+"%").attr("stop-color",Fn.prop("color")).attr("stop-opacity",1);if(vertical){const maxWidth=d3.max(axisG.selectAll("g.tick")[0].map(function(itm){return itm.getBoundingClientRect().width}))||0;$svg.css("width",maxWidth+margin)}else{const collapsedColorGroupHeight=22;const defaultHeight=isCondFormatting?collapsedColorGroupHeight:0;const maxHeight=d3.max(axisG.selectAll("g.tick")[0].map(function(itm){return itm.getBoundingClientRect().height}))||defaultHeight;$svg.css("height",maxHeight+margin+padding);$svg.css("background-color","rgb(255, 255, 255, 0.6)")}if(placement=="OUTER_LEFT"){rectX=$svg.width()-15;axisX=rectX}const axisGY=vertical||isCondFormatting?axisY:axisY+padding;const svgY=vertical?0:padding;axisG.attr("transform","translate("+axisX+","+axisGY+")");svg.select("rect").attr("transform","translate("+rectX+", "+svgY+")")}}}}})();(function(){"use strict";angular.module("dataiku.charts").directive("discreteColorLegend",discreteColorLegend);function discreteColorLegend(){return{scope:true,templateUrl:"/static/dataiku/js/simple_report/directives/legends/discrete-color-legend/discrete-color-legend.directive.html",link:function($scope,element,attrs){$scope.$watch(attrs.legend,function(nv,ov){$scope.legend=$scope.$eval(attrs.legend)});const defaultMaxValue=101;$scope.maxValues=angular.isDefined(attrs.maxValues)?$scope.$eval(attrs.maxValues):defaultMaxValue;const setStyle=function(style){const lineHeightRatio=1.3;const defaultFontSize=style&&style.fontSize?`${style.fontSize}px`:"13px";const defaultHeight=style&&style.fontSize?`${Math.round(style.fontSize*lineHeightRatio)}px`:"13px";const defaultStyle={height:defaultHeight,lineHeight:defaultHeight,fontSize:defaultFontSize};$scope.itemStyle={minHeight:defaultHeight};$scope.legendShapeStyle={...defaultStyle,width:defaultHeight,minWidth:defaultHeight};$scope.legendStyle={...defaultStyle,color:style&&style.fontColor?style.fontColor:"inherit"}};setStyle($scope.chart.def.legendFormatting);$scope.hasFocused=false;$scope.showMore=function(more=defaultMaxValue){$scope.maxValues+=more};const unfocusAll=function(){if($scope.tooltips.resetColors){$scope.tooltips.resetColors()}if($scope.legend.unfocusFnList){$scope.legend.unfocusFnList.forEach(currentUnFocusFn=>currentUnFocusFn())}$scope.legend.items.forEach(function(it){if(it.focused&&it.unfocusFn){it.unfocusFn()}it.focused=false})};let lastHoveredIndex=null;$scope.onLegendMouseMove=function($event){const hoveredEl=document.elementFromPoint($event.clientX,$event.clientY);const legendItemEl=hoveredEl?.closest("[data-legend-index]");if(!legendItemEl){return}const index=parseInt(legendItemEl.getAttribute("data-legend-index"));if(index===lastHoveredIndex){return}lastHoveredIndex=index;unfocusAll();const item=$scope.legend.items[index];if($scope.tooltips.focusColor){$scope.tooltips.focusColor(index)}item.focused=true;item.focusFn?.();$scope.legend.focusFnList?.forEach(currentFocusFn=>currentFocusFn(index,{displayPoints:false}));$scope.hasFocused=true};$scope.clearLegendFocus=function(){lastHoveredIndex=null;unfocusAll();$scope.hasFocused=false;if($scope.tooltips.resetColors){$scope.tooltips.resetColors()}}}}}})();(function(){"use strict";const THUMBNAIL_WIDTH=120;const THUMBNAIL_HEIGHT=80;const app=angular.module("dataiku.directives.insights",["dataiku.filters","dataiku.charts"]);app.directive("pivotChartResult",function($timeout,$q,$state,CHART_TYPES,DKUPivotCharts,Logger,ChartFeatures,ChartDimension,ChartZoomControlAdapter,CanvasUtils,EChartsManager,Fn,ChartStoreFactory,ChartFormattingPane,ChartFormattingPaneSections,ChartDefinitionChangeHandler,DSSVisualizationThemeUtils,ChartDrilldown,DRILL_UP_SOURCE,ChartPropertiesService){return{templateUrl:"/static/dataiku/js/simple_report/directives/pivot-chart-result/pivot-chart-result.directive.html",scope:true,link:function(scope,element){scope.canHaveZoomControls=ChartFeatures.canHaveZoomControls;scope.hasScatterZoomControlActivated=ChartFeatures.hasScatterZoomControlActivated;scope.isEChart=ChartFeatures.isEChart;scope.canDisplayLegend=ChartFeatures.canDisplayLegend;scope.openSection=function(section){const readOnly=$state.current.name==="projects.project.dashboards.insights.insight.view";if(!readOnly&&!(section===ChartFormattingPaneSections.MISC&&scope.isInPredicted)){ChartFormattingPane.open(section,true,true)}};scope.breadcrumbDrillUp=targetDimension=>{ChartDrilldown.handleMultiLevelDrillUp(scope.chart.def,targetDimension,DRILL_UP_SOURCE.BREADCRUMB)};scope.disableLazyLoading=getCookie("dku_unattended")==="true";const loadChart=function(axesDef,echartDef,d3Chart,chartActivityIndicator,hideLegend=false){if(ChartFeatures.isEChart(scope.chart.def)){element.find(".mainzone").remove();const data=scope.response.result.pivotResponse;if(scope.chart.theme&&!DSSVisualizationThemeUtils.isThemeFontLoaded(scope.chart.theme)){DSSVisualizationThemeUtils.loadThemeFont(scope.chart.theme).finally(()=>EChartsManager.initEcharts(scope,element,data,axesDef,echartDef,chartActivityIndicator,hideLegend,scope.chart.theme))}else{EChartsManager.initEcharts(scope,element,data,axesDef,echartDef,chartActivityIndicator,hideLegend,scope.chart.theme)}}else{EChartsManager.disposeEcharts(scope);d3Chart(element.find(".pivot-charts").css("display",""),scope.chart.def,scope,axesDef,scope.response.result.pivotResponse)}};const redrawChart=function(){scope.uiDisplayState=scope.uiDisplayState||{};scope.uiDisplayState.displayBrush=false;scope.uiDisplayState.brushData={};ChartDefinitionChangeHandler.clearAllPrivateMembers(scope.chart.def);scope.chart.def.hasEchart=ChartFeatures.hasEChartsDefinition(scope.chart.def.type);scope.chart.def.hasD3=ChartFeatures.hasD3Definition(scope.chart.def.type);if(ChartFeatures.isEChart(scope.chart.def)){scope.onChartInit=EChartsManager.onInit(scope,element);scope.onMetaChartInit=EChartsManager.onMetaInit()}else{scope.onChartInit=null;scope.onMetaChartInit=null;EChartsManager.disposeEcharts(scope)}if(!scope.echart&&!scope.chart.def.type===CHART_TYPES.ADMINISTRATIVE_MAP){element.find(".legend-zone").remove()}if(scope.chart.def.$zoomControlInstanceId){ChartZoomControlAdapter.clear(scope.chart.def.$zoomControlInstanceId);scope.chart.def.$zoomControlInstanceId=null}const{store,id}=ChartStoreFactory.getOrCreate(scope.chart.def.$chartStoreId);scope.chart.def.$chartStoreId=id;const displayBreadcrumb=ChartFeatures.canDisplayBreadcrumb(scope.chart.def.type)&&scope.breadcrumbs&&scope.breadcrumbs.some(b=>!!b.elements.length)&&ChartPropertiesService.showBreadcrumb(scope.chart.def.drilldownOptions,scope.chartTileProperties);if(displayBreadcrumb){element.find("[data-qa-chart-breadcrumb]").css("display","")}const rootElement=getRootElement(scope.chart.def);const dims=ChartDimension.getChartDimensions(scope.chart.def);const axesDef=ChartDimension.getAxesDef(scope.chart.def,dims,store);if(rootElement&&scope.chart&&scope.chart.theme&&scope.chart.theme.generalFormatting&&scope.chart.theme.generalFormatting.fontFamily){element.css("--visualization-font-family",scope.chart.theme.generalFormatting.fontFamily)}switch(scope.chart.def.type){case CHART_TYPES.GROUPED_COLUMNS:{DKUPivotCharts.GroupedColumnsChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.MULTI_COLUMNS_LINES:{DKUPivotCharts.MultiplotChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.STACKED_COLUMNS:{DKUPivotCharts.StackedColumnsChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.LINES:{DKUPivotCharts.LinesChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse,scope.getExecutePromise,scope.uiDisplayState,scope.chartActivityIndicator);break}case CHART_TYPES.STACKED_BARS:{DKUPivotCharts.StackedBarsChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.STACKED_AREA:{DKUPivotCharts.StackedAreaChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.BINNED_XY:{DKUPivotCharts.BinnedXYChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.GROUPED_XY:{DKUPivotCharts.GroupedXYChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.PIE:{loadChart(axesDef,DKUPivotCharts.PieEChartDef,DKUPivotCharts.PieChart,scope.chartActivityIndicator);break}case CHART_TYPES.LIFT:{DKUPivotCharts.LiftChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.SCATTER:{DKUPivotCharts.ScatterPlotChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse,scope.uiDisplayState);break}case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:{DKUPivotCharts.ScatterPlotMultiplePairsChart.create(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse,scope.uiDisplayState);break}case CHART_TYPES.PIVOT_TABLE:{DKUPivotCharts.PivotTableChart(rootElement,scope.chart.def,scope,axesDef,scope.response.result.pivotResponse);break}case CHART_TYPES.BOXPLOTS:{rootElement.show();DKUPivotCharts.BoxplotsChart(rootElement,scope.chart.def,scope.response.result.pivotResponse,scope,axesDef);break}case CHART_TYPES.ADMINISTRATIVE_MAP:{DKUPivotCharts.AdministrativeMapChart(rootElement,scope.chart.def,scope.response.result.pivotResponse,scope);break}case CHART_TYPES.GRID_MAP:{DKUPivotCharts.GridMapChart(rootElement,scope.chart.def,scope.response.result.pivotResponse,scope);break}case CHART_TYPES.SCATTER_MAP:{DKUPivotCharts.ScatterMapChart(rootElement,scope.chart.def,scope.response.result.pivotResponse,scope);break}case CHART_TYPES.DENSITY_HEAT_MAP:{DKUPivotCharts.DensityHeatMapChart(rootElement,scope.chart.def,scope.response.result.pivotResponse,scope);break}case CHART_TYPES.GEOMETRY_MAP:{DKUPivotCharts.GeometryMapChart(rootElement,scope.chart.def,scope.response.result.pivotResponse,scope);break}case CHART_TYPES.DENSITY_2D:{rootElement.show();DKUPivotCharts.Density2DChart(rootElement.get(0),scope.chart.def,scope.response.result.pivotResponse,scope);break}case CHART_TYPES.KPI:{rootElement.show();DKUPivotCharts.KpiChart(rootElement.get(0),scope,scope.chart.def,scope.getChartTheme());break}case CHART_TYPES.RADAR:{loadChart(axesDef,DKUPivotCharts.RadarEChartDef,Fn.NOOP,scope.chartActivityIndicator);break}case CHART_TYPES.SANKEY:{loadChart(axesDef,DKUPivotCharts.SankeyEChartDef,Fn.NOOP,scope.chartActivityIndicator,true);break}case CHART_TYPES.GAUGE:{loadChart(axesDef,DKUPivotCharts.GaugeEChartDef,Fn.NOOP,scope.chartActivityIndicator);break}case CHART_TYPES.WEBAPP:{rootElement.show();DKUPivotCharts.WebappChart(rootElement,scope.chart.def,scope.response.result.pivotResponse,scope);break}case CHART_TYPES.TREEMAP:{loadChart(axesDef,DKUPivotCharts.TreemapEChartDef,Fn.NOOP,scope.chartActivityIndicator,true);break}default:throw new Error("Unknown chart type: "+scope.chart.def.type)}};function getRootElement(def){switch(def.type){case CHART_TYPES.GROUPED_COLUMNS:case CHART_TYPES.MULTI_COLUMNS_LINES:case CHART_TYPES.STACKED_COLUMNS:case CHART_TYPES.LINES:case CHART_TYPES.STACKED_BARS:case CHART_TYPES.STACKED_AREA:case CHART_TYPES.BINNED_XY:case CHART_TYPES.GROUPED_XY:case CHART_TYPES.LIFT:case CHART_TYPES.SCATTER:case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:case CHART_TYPES.ADMINISTRATIVE_MAP:case CHART_TYPES.GRID_MAP:case CHART_TYPES.SCATTER_MAP:case CHART_TYPES.DENSITY_HEAT_MAP:case CHART_TYPES.GEOMETRY_MAP:return element.find(".pivot-charts").css("display","");case CHART_TYPES.PIE:case CHART_TYPES.RADAR:case CHART_TYPES.SANKEY:case CHART_TYPES.GAUGE:case CHART_TYPES.TREEMAP:return element;case CHART_TYPES.PIVOT_TABLE:return element.find(".pivot-table-container").css("display","");case CHART_TYPES.BOXPLOTS:return element.find(".boxplots-container");case CHART_TYPES.DENSITY_2D:return element.find(".direct-svg");case CHART_TYPES.KPI:return element.find(".kpi-container");case CHART_TYPES.WEBAPP:return element.find(".webapp-charts-container");default:throw new Error("Unknown chart type: "+scope.chart.def.type)}}function subscribeThumbnailToRedraw(){if(scope.abortThumbnail){scope.abortThumbnail()}const previousLoadedCallback=scope.loadedCallback;const controller=new AbortController;scope.abortThumbnail=()=>{controller.abort();scope.loadedCallback=previousLoadedCallback};scope.loadedCallback=()=>{window.requestAnimationFrame(()=>scope.updateThumbnail(controller.signal));scope.loadedCallback=previousLoadedCallback;if(typeof previousLoadedCallback==="function"){previousLoadedCallback()}}}function redraw(options={}){if(!scope.response||!scope.response.hasResult||!scope.isInitialDrawReady){return}element.children().children().each(function(){if(this.tagName!=="ACTIVITY-INDICATOR"){$(this).hide()}});if(scope.validity&&!scope.validity.valid){scope.validity.valid=true}element.attr("chart-type",scope.chart.def.type);if(scope.timing){scope.timing.drawStart=(new Date).getTime()}try{Logger.info("Start draw chart",scope.chart.def.type);if(options.updateThumbnail){subscribeThumbnailToRedraw()}redrawChart()}catch(err){if(err instanceof ChartIAE){Logger.warn("CHART IAE",err);if(scope.validity){scope.validity.valid=false;scope.validity.type="DRAW_ERROR";scope.validity.message=err.message}}else{throw err}}}function getChartElementThumbnail(){return $q(resolve=>{let setup;let canvas;if(!scope.isEChart(scope.chart.def)){const canvasParent=document.querySelector("foreignObject");let margins;switch(scope.chart.def.type){case CHART_TYPES.BOXPLOTS:return scope.exportBoxPlots(true).then(canvas=>resolve({canvas:CanvasUtils.resize(canvas,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT)}));case CHART_TYPES.SCATTER:case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:margins={x:canvasParent?.getAttribute("x"),y:canvasParent?.getAttribute("y")};return resolve({canvas:CanvasUtils.resize(document.querySelector(".chart-svg canvas"),THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT,false,document.querySelectorAll(".chart-svg .reference-line"),margins)});case CHART_TYPES.GEOMETRY_MAP:case CHART_TYPES.SCATTER_MAP:case CHART_TYPES.ADMINISTRATIVE_MAP:case CHART_TYPES.GRID_MAP:return resolve({canvas:CanvasUtils.resize(document.querySelector("canvas.leaflet-zoom-animated"),THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT)});case CHART_TYPES.DENSITY_2D:return resolve({svg:document.querySelector("svg.direct-svg")});case CHART_TYPES.LIFT:case CHART_TYPES.LINES:case CHART_TYPES.MULTI_COLUMNS_LINES:setup=clonedSvg=>clonedSvg.querySelectorAll("path.visible").forEach(line=>line.setAttribute("stroke-width",line.getAttribute("stroke-width")*3));default:canvas=document.querySelector("canvas");if(canvas){return resolve({canvas:CanvasUtils.resize(canvas,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT)})}else{return resolve({svg:document.querySelector("svg.chart-svg"),setup:setup})}}}else if(scope.echart&&scope.echart.echartDefInstance){const thumbnailOptions=scope.echart.echartDefInstance.getThumbnailOptions(scope.echart.options);return EChartsManager.getThumbnailCanvasUrl(thumbnailOptions,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT).then(canvasURL=>resolve({canvasURL:canvasURL}))}})}const isTooSmall=()=>{const chart=document.querySelector(".chart-wrapper")||document.querySelector(".pivot-chart");if(chart){const ratio=chart.clientHeight/chart.clientWidth;return chart.clientWidth<150||chart.clientHeight<150||ratio<.2||ratio>1.8}return false};scope.getThumbnailForWebgl=origCanvas=>{if(ChartFeatures.canHaveThumbnail(scope.chart.def)&&!scope.noThumbnail){if(isTooSmall()){return}return CanvasUtils.resize(origCanvas,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT).toDataURL()}};scope.updateThumbnailWithData=dataURL=>{if(dataURL){scope.chart.def.thumbnailData=dataURL}else{delete scope.chart.def.thumbnailData}};scope.updateThumbnail=signal=>$q(resolve=>{if(ChartFeatures.canHaveThumbnail(scope.chart.def)&&!scope.noThumbnail){Logger.info("Computing thumbnail");const isAborted=()=>signal&&signal.aborted;if(isAborted()||isTooSmall()){return resolve()}getChartElementThumbnail().then(({canvas,svg,setup,canvasURL})=>{if(svg&&!isAborted()){return CanvasUtils.svgToCanvas(svg,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT,{filters:["text",".axis",".hlines",".vlines",".legend",".background"],setup:setup})}else if(canvasURL&&(scope.chart.def.displayWithECharts||scope.chart.def.displayWithEChartsByDefault)){scope.updateThumbnailWithData(canvasURL);return}return canvas}).then(canvas=>{if(canvas&&!isAborted()){scope.chart.def.thumbnailData=canvas.toDataURL();Logger.info("Thumbnail Done")}resolve()})}else{delete scope.chart.def.thumbnailData;resolve()}});scope.$on("resize",()=>redraw());scope.$on("redraw",(e,opts)=>redraw(opts));scope.$on("export-chart",function(){scope.export()});scope.$on("$destroy",function(){if(scope.chart.def.$zoomControlInstanceId){ChartZoomControlAdapter.clear(scope.chart.def.$zoomControlInstanceId);scope.chart.def.$zoomControlInstanceId=null}});scope.export=function(){if(scope.chart.def.type===CHART_TYPES.BOXPLOTS){scope.exportBoxPlots().then(function(canvas){CanvasUtils.downloadCanvas(canvas,scope.chart.def.name+".png")});return}let width;let height;let $svg;if(scope.chart.def.type===CHART_TYPES.DENSITY_2D){$svg=element.find("svg.direct-svg")}else{$svg=element.find("svg.chart-svg")}if($svg.length){width=$svg.width();height=$svg.height()}else{const echart=element.find("div.main-echarts-zone");width=echart.width();height=echart.height()}scope.exportData(width,height).then(function(canvas){CanvasUtils.downloadCanvas(canvas,scope.chart.def.name+".png")})};function getChartStyleRules(forCanvg){const svgNS="http://www.w3.org/2000/svg";const style=document.createElementNS(svgNS,"style");for(let i=0;i<document.styleSheets.length;i++){const str=document.styleSheets[i].href;if(str!=null&&str.substr(str.length-10)==="charts.css"){const rules=document.styleSheets[i].cssRules;for(let j=0;j<rules.length;j++){style.textContent+=rules[j].cssText;style.textContent+="\n"}break}}if(forCanvg){style.textContent=`<![CDATA[ .totallyFakeClassBecauseCanvgParserIsBuggy  {}\n${style.textContent}{]]>`}return style}function addTitleToCanvas(canvas,title,titleHeight,scale){const ctx=canvas.getContext("2d");ctx.textAlign="center";ctx.textBaseline="middle";ctx.font="normal normal 100 "+18*scale+"px sans-serif";ctx.fillStyle="#777";ctx.fillText(title,canvas.width/2,titleHeight*scale/2)}function getCoeffToHD(w,h){const nbPixelsHD=921600;const multiplier=Math.sqrt(nbPixelsHD/(w*h));return multiplier}scope.exportData=function(w,h,simplified,svgEl,noTitle){function generateCanvas(w,h){const canvas=document.createElement("canvas");canvas.setAttribute("width",w);canvas.setAttribute("height",h);return canvas}function getChartSVG(){let svg;if(angular.isDefined(svgEl)){svg=svgEl.get(0)}else if(scope.chart.def.type===CHART_TYPES.DENSITY_2D){svg=element.find("svg.direct-svg").get(0)}else{svg=element.find("svg.chart-svg").get(0)}return svg}function cloneSVG(svg){const clonedSVG=svg.cloneNode(true);const $clonedSVG=$(clonedSVG);const $svg=$(svg);$clonedSVG.width($svg.width());$clonedSVG.height($svg.height());const customFontFamily=getComputedStyle(svg).getPropertyValue("--visualization-font-family");if(customFontFamily){$clonedSVG.css("font-family",`${customFontFamily}, 'SourceSansPro'`)}return clonedSVG}function fillOldCanvasInNewCanvas(oldCanvas,newCanvas,horizontalOffset,verticalOffset){const context=newCanvas.getContext("2d");const oldWidth=oldCanvas.width;const oldHeight=oldCanvas.height;const proportion=oldWidth/oldHeight;const availableWidth=newCanvas.width-horizontalOffset;const availableHeight=newCanvas.height-verticalOffset;const shouldScaleWidth=availableWidth/oldWidth>availableHeight/oldHeight;const newWidth=shouldScaleWidth?availableHeight*proportion:availableWidth;const newHeight=shouldScaleWidth?availableHeight:availableWidth/proportion;context.drawImage(oldCanvas,0,0,oldWidth,oldHeight,horizontalOffset,verticalOffset,newWidth,newHeight);return newCanvas}function addInnerCanvasToCanvas(svg,canvas,scale,horizontalOffset,verticalOffset){const $svg=$(svg);const $foreignObject=$svg.find("foreignObject"),x=parseFloat($foreignObject.attr("x")),y=parseFloat($foreignObject.attr("y")),width=parseFloat($foreignObject.attr("width")),height=parseFloat($foreignObject.attr("height"));const origCanvas=$foreignObject.find(".canvas-export").get(0);canvas.getContext("2d").drawImage(origCanvas,(x+horizontalOffset)*scale,(y+verticalOffset)*scale,width*scale,height*scale)}function addLegendToCanvas(chartElement,canvas,scale,verticalOffset){const d=$q.defer();const $legendDiv=element.find(".legend-zone");if($legendDiv.size()===0||$legendDiv.width()===0){d.resolve()}else{const legendOffset=$legendDiv.offset();const wrapperOffset=element.offset();const legendX=legendOffset.left-wrapperOffset.left;const legendY=legendOffset.top-wrapperOffset.top;const legendHeight=$legendDiv[0].clientHeight;let chartHorizontalOffset=legendX*scale;let chartVerticalOffset=legendY*scale;switch(scope.chart.def.legendPlacement){case"OUTER_RIGHT":chartHorizontalOffset=chartElement.clientWidth*scale;chartVerticalOffset=verticalOffset*scale/2;break;case"OUTER_BOTTOM":chartVerticalOffset=(chartElement.clientHeight+verticalOffset)*scale;break;case"OUTER_LEFT":chartVerticalOffset=verticalOffset*scale/2;break;case"OUTER_TOP":chartVerticalOffset=(verticalOffset+legendHeight)*scale/2;break;case"INNER_BOTTOM_LEFT":chartVerticalOffset=(legendY+verticalOffset*scale/2)*scale;break;case"INNER_BOTTOM_RIGHT":chartVerticalOffset=(legendY+verticalOffset*scale/2)*scale;break;case"INNER_TOP_LEFT":chartVerticalOffset=(legendY+verticalOffset*scale/2)*scale;break;case"INNER_TOP_RIGHT":chartVerticalOffset=(legendY+verticalOffset*scale/2)*scale;break}CanvasUtils.htmlToCanvas($legendDiv,scale).then(function(legendCanvas){canvas.getContext("2d").drawImage(legendCanvas,chartHorizontalOffset,chartVerticalOffset,legendCanvas.width,legendCanvas.height);d.resolve()})}return d.promise}const deferred=$q.defer();const chartTitle=simplified?false:scope.chart.def.name;const titleHeight=52;const horizontalOffset=0;const verticalOffset=chartTitle?titleHeight:0;let verticalOffsetWithLegends=verticalOffset;let horizontalOffsetWithLegends=horizontalOffset;let legendWidth=0;let legendHeight=0;const hasLegend=!simplified&&scope.chart.def.legendPlacement!=="SIDEBAR"&&ChartFeatures.canDisplayLegend(scope.chart.def.type);if(hasLegend){const $legendDiv=element.find(".legend-zone");switch(scope.chart.def.legendPlacement){case"OUTER_LEFT":legendWidth=$legendDiv[0].clientWidth;horizontalOffsetWithLegends+=legendWidth;break;case"OUTER_RIGHT":legendWidth=$legendDiv[0].clientWidth;break;case"OUTER_TOP":legendHeight=$legendDiv[0].clientHeight;verticalOffsetWithLegends+=legendHeight;break;case"OUTER_BOTTOM":legendHeight=$legendDiv[0].clientHeight;break}}const isScatter=scope.chart.def.type===CHART_TYPES.SCATTER||scope.chart.def.type===CHART_TYPES.SCATTER_MULTIPLE_PAIRS;let referenceLines;const dimensions={w:w+horizontalOffset+legendWidth+5,h:h+verticalOffset+legendHeight+5};const scale=getCoeffToHD(dimensions.w,dimensions.h);let canvas=generateCanvas(dimensions.w*scale,dimensions.h*scale);if(!simplified){CanvasUtils.fill(canvas,"white")}const svg=getChartSVG();const oldCanvas=document.getElementsByTagName("canvas")[0];const clonedSVG=svg?cloneSVG(svg):undefined;if(!svg){canvas=fillOldCanvasInNewCanvas(oldCanvas,canvas,horizontalOffsetWithLegends*scale,verticalOffsetWithLegends*scale)}else{clonedSVG.insertBefore(getChartStyleRules(true),clonedSVG.firstChild);if(isScatter){referenceLines=d3.select(clonedSVG).selectAll(".reference-line");referenceLines.remove()}clonedSVG.setAttribute("transform","scale("+scale+")");if(simplified){d3.select(clonedSVG).selectAll("text").remove();d3.select(clonedSVG).selectAll(".axis").remove();d3.select(clonedSVG).selectAll(".hlines").remove();d3.select(clonedSVG).selectAll(".vlines").remove();d3.select(clonedSVG).selectAll(".legend").remove()}const svgText=(new XMLSerializer).serializeToString(clonedSVG);canvg(canvas,svgText,{offsetY:verticalOffsetWithLegends,offsetX:horizontalOffsetWithLegends,ignoreDimensions:true,ignoreClear:true,renderCallback:function(){$timeout(canvas.svg.stop)}})}if(isScatter&&svg){addInnerCanvasToCanvas(svg,canvas,scale,horizontalOffsetWithLegends,verticalOffsetWithLegends);if(clonedSVG&&referenceLines&&referenceLines.size()>0){d3.select(clonedSVG).selectAll("g.chart").remove();d3.select(clonedSVG).selectAll("foreignObject").remove();referenceLines.forEach(referenceLine=>clonedSVG.appendChild(referenceLine[0]));const svgText=(new XMLSerializer).serializeToString(clonedSVG);canvg(canvas,svgText,{offsetY:verticalOffsetWithLegends,offsetX:horizontalOffsetWithLegends,ignoreDimensions:true,ignoreClear:true,renderCallback:function(){$timeout(canvas.svg.stop)}})}}if(chartTitle&&!noTitle){addTitleToCanvas(canvas,chartTitle,titleHeight,scale)}if(hasLegend){addLegendToCanvas(svg||oldCanvas,canvas,scale,verticalOffset).then(()=>deferred.resolve(canvas))}else{deferred.resolve(canvas)}return deferred.promise};scope.exportBoxPlots=thumbnail=>$q(resolve=>{const container=element.find(".boxplots-container");const svg1=container.find("svg.noflex");const svg2=container.find("div.flex.oa > svg");const title=scope.chart.def.name;const titleHeight=52;let verticalOffset=title?titleHeight:0;const options={setup:cloneSvg=>{if(thumbnail){cloneSvg.style.strokeWidth=6}else{cloneSvg.insertBefore(getChartStyleRules(),cloneSvg.firstChild)}},filters:thumbnail?[".axis",".hline"]:null};const allCanvas=[CanvasUtils.svgToCanvas(svg1.get(0),svg1.width(),svg1.height(),options)];if(scope.chart.def.boxplotBreakdownDim.length||scope.chart.def.boxplotBreakdownHierarchyDimension.length){allCanvas.push(CanvasUtils.svgToCanvas(svg2.get(0),svg2.width(),svg2.height(),options))}$q.all(allCanvas).then(subcanvas=>{const canvas=document.createElement("canvas");let horizontalOffset=0;let legendWidth=0;let legendHeight=0;const legendOffset={top:0,left:0};const hasLegend=scope.chart.def.legendPlacement!=="SIDEBAR"&&ChartFeatures.canDisplayLegend(scope.chart.def.type)&&!thumbnail;function getCanvasProps(canvasToCheck,prop){if(canvasToCheck==null){return 0}return canvasToCheck[prop]}if(hasLegend){const $legendDiv=container.find(".legend-zone");switch(scope.chart.def.legendPlacement){case"OUTER_LEFT":horizontalOffset+=$legendDiv[0].clientWidth;legendOffset.top=verticalOffset;break;case"OUTER_RIGHT":legendWidth=$legendDiv[0].clientWidth;legendOffset.left=subcanvas[0].width+getCanvasProps(subcanvas[1],"width");legendOffset.top=verticalOffset;break;case"OUTER_TOP":legendOffset.top=verticalOffset;verticalOffset+=$legendDiv[0].clientHeight;break;case"OUTER_BOTTOM":legendHeight=$legendDiv[0].clientHeight;legendOffset.top=subcanvas[0].height+verticalOffset;break;case"INNER_BOTTOM_LEFT":legendOffset.top=subcanvas[0].height-$legendDiv[0].clientHeight;legendOffset.left=30;break;case"INNER_BOTTOM_RIGHT":legendOffset.top=subcanvas[0].height-$legendDiv[0].clientHeight;legendOffset.left=subcanvas[0].width+getCanvasProps(subcanvas[1],"width")-$legendDiv[0].clientWidth;break;case"INNER_TOP_RIGHT":legendOffset.top=verticalOffset;legendOffset.left=subcanvas[0].width+getCanvasProps(subcanvas[1],"width")-$legendDiv[0].clientWidth;break;case"INNER_TOP_LEFT":legendOffset.top=verticalOffset;legendOffset.left=30;break}}const dimensions={w:subcanvas[0].width+getCanvasProps(subcanvas[1],"width")+horizontalOffset+legendWidth,h:subcanvas[0].height+verticalOffset+legendHeight};const scale=getCoeffToHD(dimensions.w,dimensions.h);canvas.setAttribute("width",dimensions.w);canvas.setAttribute("height",dimensions.h);if(!thumbnail){CanvasUtils.fill(canvas,"white")}const ctx=canvas.getContext("2d");ctx.drawImage(subcanvas[0],horizontalOffset,verticalOffset);if(subcanvas.length>1){ctx.drawImage(subcanvas[1],subcanvas[0].width+horizontalOffset-14,verticalOffset+scale)}if(title&&!thumbnail){addTitleToCanvas(canvas,title,titleHeight,1)}if(hasLegend){CanvasUtils.htmlToCanvas(container.find(".legend-zone"),1).then(function(legendCanvas){canvas.getContext("2d").drawImage(legendCanvas,legendOffset.left,legendOffset.top,legendCanvas.width,legendCanvas.height);resolve(canvas)})}else{resolve(canvas)}})});scope.$watch("response",function(nv){if(nv==null){return}if(!scope.response.hasResult){return}$timeout(()=>{scope.isInitialDrawReady=true;redraw({updateThumbnail:true})})})}}})})();(function(){"use strict";const app=angular.module("dataiku.directives.simple_report");app.directive("selectAll",function(){return{restrict:"A",link:function(scope,element){element.on("keydown",function(event){if((event.ctrlKey||event.metaKey)&&event.which===65){event.preventDefault();if(event.target){event.target.select()}scope.$apply()}});scope.$on("$destroy",function(){element.off("keydown")})}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.filter("longReadableNumber",function(NumberFormatter){return NumberFormatter.longReadableNumberFilter()});app.filter("longSmartNumber",function(NumberFormatter){return NumberFormatter.longSmartNumberFilter()});app.filter("smartNumber",function(NumberFormatter){return NumberFormatter.smartNumberFilter()});app.filter("percentageNumber",NumberFormatter=>{return NumberFormatter.percentageNumberFilter()})})();(function(){"use strict";angular.module("dataiku.charts").factory("AnimatedChartsUtils",AnimatedChartsUtils);function AnimatedChartsUtils($interval,ChartFormatting){const unwatchers={},intervals={};return{initAnimation:function(chartHandler,chartData,chartDef,drawFrame,ignoreLabels=new Set){if(unwatchers[chartHandler.$id]){unwatchers[chartHandler.$id]();delete unwatchers[chartHandler.$id]}if(intervals[chartHandler.$id]){$interval.cancel(intervals[chartHandler.$id]);delete intervals[chartHandler.$id]}const animation=chartHandler.animation;animation.labelify=function(label){return ChartFormatting.getForOrdinalAxis(label)};animation.labels=chartData.getAxisLabels("animation",ignoreLabels);animation.playing=false;animation.drawFrame=function(frameIdx){animation.currentFrame=animation.currentFrame>=animation.labels.length?0:frameIdx};animation.chartData=chartData;animation.hasNext=function(){return animation.currentFrame<animation.labels.length-1};animation.play=function(){if(animation.playing){return}if(animation.currentFrame===animation.labels.length-1){animation.currentFrame=0}animation.playing=true;intervals[chartHandler.$id]=$interval(function(){animation.drawFrame((animation.currentFrame+1)%animation.labels.length);if(!chartDef.animationRepeat&&!animation.hasNext()){animation.pause()}},chartDef.animationFrameDuration||3e3)};animation.dimension=chartDef.animationDimension[0];animation.pause=function(){animation.playing=false;$interval.cancel(intervals[chartHandler.$id])};unwatchers[chartHandler.$id]=chartHandler.$watch("animation.currentFrame",function(nv){if(nv==null){return}drawFrame(animation.labels[nv].$tensorIndex)});chartHandler.$watch("chart.def.animationFrameDuration",function(nv){if(!nv){return}if(animation.playing){animation.pause();animation.play()}})},unregisterAnimation:function(chartHandler){if(unwatchers[chartHandler.$id]){unwatchers[chartHandler.$id]();delete unwatchers[chartHandler.$id]}if(intervals[chartHandler.$id]){$interval.cancel(intervals[chartHandler.$id]);delete intervals[chartHandler.$id]}},getAnimationCoord(animation){return animation.labels?animation.labels[animation.currentFrame].$tensorIndex:animation.currentFrame},getAnimationContext:function(animationDimension,animation){return{animation:animationDimension&&animation.currentFrame||0,numberOfFrames:animationDimension&&animation.labels.length||1}}}}})();(function(){"use strict";angular.module("dataiku.directives.simple_report").factory("ChartAxesUtils",chartAxesUtils);function chartAxesUtils(ChartDataUtils,ChartUADimension,ChartDimension,ChartsStaticData,ChartFeatures,ChartYAxisPosition,AxisTicksConfigMode,AxisTicksFormatting,AxisTitleFormatting,ColumnAvailability,translate,CHART_VARIANTS){const AUTO_EXTENT_MODE="AUTO";const MANUAL_EXTENT_MODE="MANUAL";function getManualExtentAtIndex(customExtent,index){if(customExtent==null||customExtent.$autoExtent===undefined||index<0&&index>1){return null}return customExtent.manualExtent[index]===null?customExtent.$autoExtent[index]:customExtent.manualExtent[index]}function getManualExtentMin(customExtent){return getManualExtentAtIndex(customExtent,0)}function getManualExtentMax(customExtent){return getManualExtentAtIndex(customExtent,1)}function getManualExtent(customExtent){return[getManualExtentMin(customExtent),getManualExtentMax(customExtent)]}const isCroppedExtent=axesFormatting=>{const isCropped=axesFormatting.some(formatting=>{if(formatting.customExtent.$autoExtent&&formatting.customExtent.editMode===MANUAL_EXTENT_MODE){const manualExtent=getManualExtent(formatting.customExtent);return formatting.customExtent.$autoExtent[0]<manualExtent[0]||formatting.customExtent.$autoExtent[1]>manualExtent[1]}});return isCropped};const svc={shouldIncludeZero(chartDef,yAxisId){const yAxisFormatting=this.getFormattingForYAxis(chartDef.yAxesFormatting,yAxisId);return ChartFeatures.canIncludeZero(chartDef.type)&&yAxisFormatting&&!svc.isManualMode(yAxisFormatting.customExtent)&&yAxisFormatting.includeZero},isNumerical(axisSpec){return axisSpec.dimension&&axisSpec.dimension.isA==="ua"?ChartUADimension.isTrueNumerical(axisSpec.dimension):ChartDimension.isTrueNumerical(axisSpec.dimension)},isContinuousDate(axisSpec){return axisSpec.dimension&&axisSpec.dimension.isA==="ua"?ChartUADimension.isDate(axisSpec.dimension):ChartDimension.isTimeline(axisSpec.dimension)},initCustomAxisExtent:function(customExtent,initialExtent,isPercentScale){const coeff=isPercentScale?100:1;if(_.isFinite(initialExtent[0])&&_.isFinite(initialExtent[1])){customExtent.$autoExtent=[initialExtent[0]*coeff,initialExtent[1]*coeff]}if(customExtent.editMode===ChartsStaticData.AUTO_EXTENT_MODE){customExtent.manualExtent=[null,null];return initialExtent}else{const manualExtent=getManualExtent(customExtent);return[manualExtent[0]/coeff,manualExtent[1]/coeff]}},getDimensionExtent(chartData,axisSpec,ignoreLabels){let extent=axisSpec.extent;if(!extent){if(axisSpec.type==="UNAGGREGATED"){extent=axisSpec.extent||ChartDataUtils.getUnaggregatedAxisExtent(axisSpec.dimension,axisSpec.data)}else{extent=ChartDataUtils.getAxisExtent(chartData,axisSpec.name,axisSpec.dimension,{ignoreLabels:ignoreLabels,initialExtent:axisSpec.customExtent&&axisSpec.customExtent.$autoExtent})}}if(axisSpec.customExtent){const transientExtent=svc.initCustomAxisExtent(axisSpec.customExtent,[extent.min,extent.max],axisSpec.isPercentScale);extent=Object.assign(extent,{min:transientExtent[0],max:transientExtent[1]})}if(axisSpec.initialInterval){extent.min=axisSpec.initialInterval.min;extent.max=axisSpec.initialInterval.max}return extent},getMeasureExtent(chartData,axisSpec,isLogScale,includeZero,computePercentScale,otherAxesIndexes=[]){let extent=axisSpec.extent;if(!extent){if(axisSpec.measureIdx===undefined){return null}extent=ChartDataUtils.getMeasureExtent(chartData,axisSpec.measureIdx,true,null,axisSpec.measure[0]?.function,otherAxesIndexes)}if(extent[0]==Infinity){return null}if(axisSpec.customExtent){extent=svc.initCustomAxisExtent(axisSpec.customExtent,extent,computePercentScale?axisSpec.isPercentScale:false)}if(includeZero){const isZeroInRange=extent[0]>0!=extent[1]>0;if(!isZeroInRange){extent[0]=Math.min(extent[0],0);extent[1]=Math.max(extent[1],0)}}if(isLogScale){const logScaleExtent=svc.fixNumericalLogScaleExtent(axisSpec,{min:extent[0]},includeZero);extent[0]=logScaleExtent.min}return extent},getProperMinValueWhenInLogScale(axisSpec,includeZero,currentMinValue){const shouldReplace=!svc.isManualMode(axisSpec.customExtent)&&includeZero&&currentMinValue===0;return shouldReplace?1:currentMinValue},fixNumericalLogScaleExtent(axisSpec,extent,includeZero){extent.min=svc.getProperMinValueWhenInLogScale(axisSpec,includeZero,extent.min);if(extent.min<=0){throw new ChartIAE("Cannot represent value 0 nor negative values on a log scale. Please disable log scale.")}return extent},fixUnbinnedNumericalExtent(axisSpec,extent){if(ChartDimension.isUngroupedNumerical(axisSpec.dimension)||axisSpec.type==="UNAGGREGATED"){const nbVals=extent.values.length;const interval=extent.max-extent.min;const additionalPct=nbVals>10?5:10;extent.min=extent.min-interval*additionalPct/100;extent.max=extent.max+interval*additionalPct/100}return extent},includeZero(extent){extent.min=Math.min(extent.min,0);extent.max=Math.max(extent.max,0);return extent},computeYAxisID(orientation="left",index=0,dimension){let id=`y_${orientation}_${index}`;if(dimension){id+=`_${dimension}`}return id},getFormattingForYAxis(yAxesFormatting,id=ChartsStaticData.LEFT_AXIS_ID){return yAxesFormatting.find(v=>v.id===id)},isYAxisLogScale(yAxesFormatting,id=ChartsStaticData.LEFT_AXIS_ID){const formatting=this.getFormattingForYAxis(yAxesFormatting,id);return(formatting||{}).isLogScale},getYAxisNumberFormatting(yAxesFormatting,id=ChartsStaticData.LEFT_AXIS_ID){const formatting=this.getFormattingForYAxis(yAxesFormatting,id);return((formatting||{}).axisValuesFormatting||{}).numberFormatting},getYAxisCustomExtent(yAxesFormatting,id=ChartsStaticData.LEFT_AXIS_ID){const formatting=this.getFormattingForYAxis(yAxesFormatting,id);return(formatting||{}).customExtent},setYAxisCustomExtent(yAxesFormatting,newCustomExtent,id=ChartsStaticData.LEFT_AXIS_ID){const index=yAxesFormatting.map(x=>x.id).indexOf(id);yAxesFormatting[index].customExtent=newCustomExtent},contatenateMeasuresNames(measures){return measures.map(m=>ColumnAvailability.getAggregatedLabel(m)).join(", ")},getXAxisTitle:function(xAxisSpec,chartDef){if(!xAxisSpec||!chartDef||!ChartFeatures.canShowXAxisTitle(chartDef)){return}let titleText=null;if(!!chartDef.xAxisFormatting.axisTitle&&chartDef.xAxisFormatting.axisTitle.length>0){titleText=chartDef.xAxisFormatting.axisTitle}else if(xAxisSpec.dimension!==undefined){titleText=xAxisSpec.dimension.column}else if(xAxisSpec.measure!==undefined){return this.contatenateMeasuresNames(xAxisSpec.measure)}else if(chartDef.genericDimension0.length===1||chartDef.genericHierarchyDimension.length===1){titleText=(ChartDimension.getGenericDimension(chartDef)||{}).column}return titleText},getYAxisTitle:function(yAxisSpec,chartDef,axisFormatting){if(!yAxisSpec){return}let titleText=null;if(axisFormatting&&!_.isNil(axisFormatting.axisTitle)&&axisFormatting.axisTitle.length>0){titleText=axisFormatting.axisTitle}else if(yAxisSpec.dimension!==undefined){titleText=yAxisSpec.dimension.column}else if(yAxisSpec.measure!==undefined){return ColumnAvailability.getAggregatedLabel(yAxisSpec.measure[0])}else if(chartDef!=null){const measuresOnAxis=svc.getMeasuresDisplayedOnAxis(yAxisSpec.position,chartDef.genericMeasures);if(measuresOnAxis.length>=1){return this.contatenateMeasuresNames(measuresOnAxis)}}return titleText},getMeasuresDisplayedOnAxis:function(axisPosition,measures){const displayAxis=axisPosition===ChartYAxisPosition.LEFT?"axis1":"axis2";return measures.filter(measure=>measure.displayAxis===displayAxis)},getYAxisSpecs:function(axisSpecs){const ySpecs=axisSpecs&&Object.keys(axisSpecs).filter(key=>key.toLowerCase().includes("y")).reduce((object,key)=>{return Object.assign(object,{[key]:axisSpecs[key]})},{});return ySpecs},getYAxisName:function(id){if(id.includes("right")){return translate("CHARTS.SHARED.RIGHT_AXIS","Right axis")}else{return translate("CHARTS.SHARED.LEFT_AXIS","Left axis")}},isAxisDisplayed:function(genericMeasures,id){const isAxisDisplayed=id.includes("right")?svc.isRightAxisDisplayed:svc.isLeftAxisDisplayed;return id!=null?isAxisDisplayed(genericMeasures):false},isLeftAxisDisplayed:function(genericMeasures){return genericMeasures!=null&&genericMeasures.some(measure=>measure.displayAxis==="axis1")},isRightAxisDisplayed:function(genericMeasures){return genericMeasures!=null&&genericMeasures.some(measure=>measure.displayAxis==="axis2")},setNumberOfBinsToDimensions:function(chartData,chartDef,axisSpecs){const possibleAxes={x:"x",y:"y_left_0"};for(const[dataId,specId]of Object.entries(possibleAxes)){const axisLabels=chartData.getAxisLabels(dataId);if(axisLabels&&axisSpecs[specId]&&axisSpecs[specId].dimension){axisSpecs[specId].dimension.$numberOfBins=axisLabels.length;axisSpecs[specId].dimension.$isInteractiveChart=ChartDimension.isInteractiveChart(chartDef);axisSpecs[specId].dimension.$forceOneTickPerBin=chartDef.variant===CHART_VARIANTS.waterfall}}},isCroppedChart:function(chartDef){return isCroppedExtent(chartDef.yAxesFormatting)||isCroppedExtent([chartDef.xAxisFormatting])},getCustomExtentRatio:function(customExtent){const activeExtent=customExtent.$autoExtent&&customExtent.$initialExtent?customExtent.$initialExtent:customExtent.$autoExtent;if(activeExtent){const initialExtentWidth=activeExtent[1]-activeExtent[0];if(customExtent.editMode===ChartsStaticData.MANUAL_EXTENT_MODE){const manualExtent=getManualExtent(customExtent);const manualExtentWidth=manualExtent[1]-manualExtent[0];return parseFloat(""+initialExtentWidth/manualExtentWidth)}else if(customExtent.$autoExtent&&customExtent.$initialExtent){const autoExtentWidth=customExtent.$autoExtent[1]-customExtent.$autoExtent[0];return parseFloat(""+initialExtentWidth/autoExtentWidth)}}return 1},isCustomExtentValid:function(axesFormatting){return axesFormatting.every(formatting=>{if(formatting.customExtent&&formatting.customExtent.editMode===MANUAL_EXTENT_MODE){const[min,max]=getManualExtent(formatting.customExtent);return min<=max}return true})},resetCustomExtents:function(axesFormatting){if(!axesFormatting){return}axesFormatting.forEach(formatting=>{if(formatting&&formatting.customExtent){formatting.customExtent.editMode=AUTO_EXTENT_MODE}})},isManualMode:function(customExtent){return customExtent&&customExtent.editMode&&customExtent.editMode===ChartsStaticData.MANUAL_EXTENT_MODE},getLeftYAxis:function(yAxes){const leftAxis=yAxes.filter(axis=>svc.isLeftYAxis(axis));return leftAxis.length?leftAxis[0]:null},getRightYAxis:function(yAxes){const rightAxis=yAxes.filter(axis=>svc.isRightYAxis(axis));return rightAxis.length?rightAxis[0]:null},isLeftYAxis:function(axis){return!!axis&&axis.position===ChartYAxisPosition.LEFT},isRightYAxis:function(axis){return!!axis&&axis.position===ChartYAxisPosition.RIGHT},initYAxesFormatting:function(id){return{id:id,axisTitleFormatting:{...AxisTitleFormatting},showAxisTitle:true,displayAxis:true,axisValuesFormatting:{axisTicksFormatting:{...AxisTicksFormatting},numberFormatting:{...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}},ticksConfig:{mode:AxisTicksConfigMode.INTERVAL},customExtent:{...ChartsStaticData.DEFAULT_CUSTOM_EXTENT},isLogScale:false}},getManualExtentMin:getManualExtentMin,getManualExtentMax:getManualExtentMax,getManualExtent:getManualExtent};return svc}})();(function(){"use strict";angular.module("dataiku.directives.simple_report").factory("ChartFeatures",chartFeatures);function chartFeatures(WebAppsService,ChartStoreFactory,ChartDimension,ChartsStaticData,ChartUADimension,ChartTypeChangeUtils,D3ChartZoomControl,CHART_TYPES,CHART_VARIANTS,CHART_AXIS_TYPES,NumberFormatter,AxisTicksConfigMode,VALUES_DISPLAY_MODES,translate,$rootScope){function isChartTypeInList(chartType,chartTypeList){return chartTypeList.includes(chartType)}function canDisplayTotalValues(chartDef){return chartDef.type===CHART_TYPES.STACKED_COLUMNS&&chartDef.variant!==CHART_VARIANTS.stacked100}const canSetCustomAxisRange=chartDef=>chartDef&&chartDef.variant!==CHART_VARIANTS.binnedXYHexagon;const axisTicksModes=[{label:translate("CHARTS.SETTINGS.FORMAT.AXIS_TICKS.NUMBER","Number"),value:AxisTicksConfigMode.NUMBER},{label:translate("CHARTS.SETTINGS.FORMAT.AXIS_TICKS.INTERVAL","Interval"),value:AxisTicksConfigMode.INTERVAL}];const svc={canDisplayTotalValues:canDisplayTotalValues,canExportToExcel:chartDef=>{if(chartDef.facetDimension.length){return false}if(chartDef.type===CHART_TYPES.GROUPED_COLUMNS){return chartDef.variant!==CHART_VARIANTS.waterfall}return isChartTypeInList(chartDef.type,[CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_AREA,CHART_TYPES.LINES,CHART_TYPES.PIVOT_TABLE,CHART_TYPES.GROUPED_XY,CHART_TYPES.KPI])},canExportToImage:chartDef=>{if(chartDef.facetDimension.length){return false}return!isChartTypeInList(chartDef.type,[CHART_TYPES.PIVOT_TABLE,CHART_TYPES.KPI,CHART_TYPES.SCATTER_MAP,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.GRID_MAP,CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.WEBAPP,CHART_TYPES.DENSITY_HEAT_MAP])},isMap:chartType=>{return isChartTypeInList(chartType,[CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.GRID_MAP,CHART_TYPES.SCATTER_MAP,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.DENSITY_HEAT_MAP])},canDisplayDimensionValuesInChart:chartType=>{return chartType===CHART_TYPES.TREEMAP},getExportDisabledReason:chartDef=>{if(chartDef.facetDimension.length){return"Download is not available for subcharts."}},canDrillHierarchy:chartType=>isChartTypeInList(chartType,[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.RADAR,CHART_TYPES.LINES,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.PIE,CHART_TYPES.STACKED_AREA,CHART_TYPES.BOXPLOTS,CHART_TYPES.BINNED_XY,CHART_TYPES.GROUPED_XY,CHART_TYPES.LIFT,CHART_TYPES.PIVOT_TABLE,CHART_TYPES.TREEMAP]),canDisplayBreadcrumb:chartType=>svc.canDrillHierarchy(chartType)&&chartType!==CHART_TYPES.PIVOT_TABLE,canAnimate:chartType=>isChartTypeInList(chartType,[CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.LINES,CHART_TYPES.STACKED_AREA,CHART_TYPES.PIE,CHART_TYPES.BINNED_XY,CHART_TYPES.GROUPED_XY,CHART_TYPES.LIFT]),canFacet:(chartType,webAppType)=>{if(chartType===CHART_TYPES.WEBAPP){const loadedDesc=WebAppsService.getWebAppLoadedDesc(webAppType)||{};const pluginChartDesc=loadedDesc.desc&&loadedDesc.desc.chart||{};return pluginChartDesc.canFacet===true}else{return isChartTypeInList(chartType,[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.LINES,CHART_TYPES.STACKED_AREA,CHART_TYPES.PIE,CHART_TYPES.BINNED_XY,CHART_TYPES.GROUPED_XY,CHART_TYPES.LIFT])}},canSetSubchartsCommonXAxis:chartType=>chartType!==CHART_TYPES.PIE,canFilter:(chartType,webAppType)=>{if(chartType===CHART_TYPES.WEBAPP){const loadedDesc=WebAppsService.getWebAppLoadedDesc(webAppType)||{};const pluginChartDesc=loadedDesc.desc&&loadedDesc.desc.chart||{};return pluginChartDesc.canFilter===true}else{return true}},canHaveZoomControls:(chartDef,zoomControlInstanceId)=>{return!_.isNil(chartDef)&&!_.isNil(zoomControlInstanceId)&&(svc.canHaveEChartsZoomControls(chartDef)||svc.hasScatterZoomControlEnabled(chartDef.type,zoomControlInstanceId)||svc.canHaveMapsZoomControls(chartDef))},canHaveEChartsZoomControls:chartDef=>chartDef.type===CHART_TYPES.TREEMAP&&!!ChartDimension.getYDimensions(chartDef).length&&!!chartDef.genericMeasures.length,canHaveMapsZoomControls:chartDef=>svc.isMap(chartDef.type)&&(chartDef.geometry.length>0||chartDef.geoLayers.length>1),isScatterZoomed:(chartType,zoomControlInstanceId)=>{return svc.isUnaggregated(chartType)&&D3ChartZoomControl.isZoomed(zoomControlInstanceId)},isUnaggregated:chartType=>{return chartType===CHART_TYPES.SCATTER||chartType===CHART_TYPES.SCATTER_MULTIPLE_PAIRS},hasScatterZoomControlEnabled:(chartType,zoomControlInstanceId)=>{return svc.isUnaggregated(chartType)&&D3ChartZoomControl.isEnabled(zoomControlInstanceId)},hasScatterZoomControlActivated:(chartType,zoomControlInstanceId)=>{return svc.isUnaggregated(chartType)&&D3ChartZoomControl.isActivated(zoomControlInstanceId)},canSmooth:chartType=>isChartTypeInList(chartType,[CHART_TYPES.LINES,CHART_TYPES.STACKED_AREA,CHART_TYPES.MULTI_COLUMNS_LINES]),canSetStrokeWidth:chartType=>isChartTypeInList(chartType,[CHART_TYPES.LINES,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.GEOMETRY_MAP]),canSetFillOpacity:chartDef=>{return chartDef.type===CHART_TYPES.GEOMETRY_MAP||chartDef.type===CHART_TYPES.ADMINISTRATIVE_MAP&&chartDef.variant===CHART_VARIANTS.filledMap},canHideXAxis:chartType=>chartType===CHART_TYPES.STACKED_BARS,canDisplayValuesInChart:chartType=>isChartTypeInList(chartType,[CHART_TYPES.GAUGE,CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.PIE,CHART_TYPES.RADAR,CHART_TYPES.SANKEY,CHART_TYPES.STACKED_BARS,CHART_TYPES.TREEMAP]),canDisplayBrush:chartDef=>{return chartDef&&chartDef.linesZoomOptions&&chartDef.linesZoomOptions.enabled&&ChartDimension.isInteractiveChart(chartDef)},canDrawIdentityLine:chartDef=>{const yAxisFormatting=chartDef.yAxesFormatting.find(formatting=>formatting.id===ChartsStaticData.LEFT_AXIS_ID);return chartDef&&chartDef.type===CHART_TYPES.SCATTER&&!(chartDef.xAxisFormatting.isLogScale||yAxisFormatting&&yAxisFormatting.isLogScale)},canCustomizeValuesInChart:chartDef=>{return isChartTypeInList(chartDef.type,[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.RADAR,CHART_TYPES.SANKEY,CHART_TYPES.GAUGE,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.TREEMAP])||chartDef.type===CHART_TYPES.PIE&&svc.isEChart(chartDef)},canCustomizeLabelsInChart:chartDef=>chartDef.type===CHART_TYPES.PIE&&svc.isEChart(chartDef),canCustomizeValuesInChartOverlap:chartDef=>isChartTypeInList(chartDef.type,[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.RADAR,CHART_TYPES.SANKEY,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS])&&svc.canCustomizeValuesInChart(chartDef),canAddMeasuresToLabelsInChart:chartDef=>isChartTypeInList(chartDef.type,[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.PIE,CHART_TYPES.RADAR,CHART_TYPES.SANKEY,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.TREEMAP,CHART_TYPES.LINES,CHART_TYPES.MULTI_COLUMNS_LINES])&&chartDef.variant!==CHART_VARIANTS.stacked100,shouldDisplayTotalValues:chartDef=>canDisplayTotalValues(chartDef)&&chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayValues&&chartDef.valuesInChartDisplayOptions.displayMode===VALUES_DISPLAY_MODES.VALUES_AND_TOTALS,shouldDisplay0Warning:(chartType,pivotResponse)=>[CHART_TYPES.SANKEY,CHART_TYPES.TREEMAP].includes(chartType)&&(pivotResponse&&pivotResponse.aggregations.every(agg=>agg.tensor.every(el=>el===0))),canDisplayLabelsInChart:chartType=>isChartTypeInList(chartType,[CHART_TYPES.PIE,CHART_TYPES.GAUGE]),shouldDrawRegressionLine:chartDef=>{return ChartUADimension.areAllNumericalOrDate(chartDef)&&chartDef.type===CHART_TYPES.SCATTER&&chartDef.scatterOptions&&chartDef.scatterOptions.regression&&chartDef.scatterOptions.regression.show},canSelectPivotRowOrColumnDisplayMode:chartDef=>chartDef!=null&&chartDef.type===CHART_TYPES.PIVOT_TABLE&&!!ChartDimension.getYDimensions(chartDef).length&&!!ChartDimension.getXDimensions(chartDef).length,canCustomizePivotFormatting:chartDef=>chartDef!=null&&chartDef.type===CHART_TYPES.PIVOT_TABLE&&(!!ChartDimension.getYDimensions(chartDef).length||!!ChartDimension.getXDimensions(chartDef).length)&&(chartDef.genericMeasures&&chartDef.genericMeasures.length),canCustomizePivotRowHeaders:chartDef=>svc.canCustomizePivotFormatting(chartDef)&&!!ChartDimension.getYDimensions(chartDef).length||chartDef.genericMeasures&&chartDef.genericMeasures.length>1,isColoredPivotTable:chartDef=>chartDef!=null&&chartDef.type===CHART_TYPES.PIVOT_TABLE&&(chartDef.colorMeasure&&chartDef.colorMeasure.length||chartDef.colorMode==="COLOR_GROUPS"),canSetMeasureColumnsTooltips:chartType=>isChartTypeInList(chartType,[CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.STACKED_AREA,CHART_TYPES.GRID_MAP,CHART_TYPES.LINES,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.PIE,CHART_TYPES.BINNED_XY]),canSetUnaggregatedColumnsTooltips:chartType=>isChartTypeInList(chartType,[CHART_TYPES.SCATTER,CHART_TYPES.SCATTER_MULTIPLE_PAIRS,CHART_TYPES.SCATTER_MAP,CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.DENSITY_HEAT_MAP]),canDisplayTooltips:chartType=>!isChartTypeInList(chartType,[CHART_TYPES.KPI,CHART_TYPES.GAUGE,CHART_TYPES.DENSITY_2D,CHART_TYPES.WEBAPP]),canHandleEmptyBins:chartType=>isChartTypeInList(chartType,[CHART_TYPES.LINES,CHART_TYPES.MULTI_COLUMNS_LINES]),canSetAxisTextColor:chartType=>chartType!==CHART_TYPES.SCATTER_MULTIPLE_PAIRS,chartSupportOneTickPerBin:chartDef=>!(isChartTypeInList(chartDef.type,[CHART_TYPES.PIE,CHART_TYPES.PIVOT_TABLE,CHART_TYPES.RADAR,CHART_TYPES.SANKEY,CHART_TYPES.TREEMAP,CHART_TYPES.SCATTER,CHART_TYPES.SCATTER_MULTIPLE_PAIRS,CHART_TYPES.BOXPLOTS,CHART_TYPES.GROUPED_XY])||chartDef.hexbin)&&chartDef.variant!==CHART_VARIANTS.binnedXYHexagon,chartOnlySupportsOneTickPerBin:chartDef=>{return chartDef?.type===CHART_TYPES.GROUPED_COLUMNS&&chartDef?.variant===CHART_VARIANTS.waterfall},canModifyAxisRange:(chartDef,axis)=>{if(!canSetCustomAxisRange(chartDef)){return false}let dimensionsAndMeasures;if(axis==="x"){dimensionsAndMeasures=ChartTypeChangeUtils.takeAllInX(chartDef)}else if(axis==="y"){dimensionsAndMeasures=ChartTypeChangeUtils.takeAllInY(chartDef)}else{return false}const hasOneTickPerBin=svc.hasOneTickPerBinSelected(chartDef.$chartStoreId,axis);return dimensionsAndMeasures.some(([firstOne])=>firstOne&&(firstOne.isA==="measure"||ChartDimension.isTrueNumerical(firstOne)&&!hasOneTickPerBin))},canIncludeZero:chartType=>isChartTypeInList(chartType,[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.LINES,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.GROUPED_XY]),isPivotTableWithNoDimension:chartDef=>{return chartDef.type===CHART_TYPES.PIVOT_TABLE&&!ChartDimension.getXDimensions(chartDef).length&&!ChartDimension.getYDimensions(chartDef).length},canHaveConditionalFormatting:chartType=>isChartTypeInList(chartType,[CHART_TYPES.PIVOT_TABLE,CHART_TYPES.KPI]),hasLogarithmicRegressionWarning:chartDef=>{if(chartDef==null){return false}const areValuesLessOrEqual0=chartDef.xAxisFormatting&&chartDef.xAxisFormatting.customExtent&&chartDef.xAxisFormatting.customExtent.$autoExtent&&chartDef.xAxisFormatting.customExtent.$autoExtent[0]<=0;const isAxisMinAbove0=chartDef.xAxisFormatting&&chartDef.xAxisFormatting.customExtent&&chartDef.xAxisFormatting.customExtent.manualExtent&&chartDef.xAxisFormatting.customExtent.manualExtent[0]>0;return areValuesLessOrEqual0&&!isAxisMinAbove0&&chartDef.type===CHART_TYPES.SCATTER},hasExponentialRegressionWarning:(chartDef,yAxisID=ChartsStaticData.LEFT_AXIS_ID)=>{if(chartDef==null){return false}const yAxisFormatting=chartDef.yAxesFormatting.find(v=>v.id===yAxisID);const areValuesLessOrEqual0=yAxisFormatting&&yAxisFormatting.customExtent&&yAxisFormatting.customExtent.$autoExtent&&yAxisFormatting.customExtent.$autoExtent[0]<=0;const isAxisMinAbove0=yAxisFormatting&&yAxisFormatting.customExtent&&yAxisFormatting.customExtent.manualExtent&&yAxisFormatting.customExtent.manualExtent[0]>0;return areValuesLessOrEqual0&&!isAxisMinAbove0&&chartDef.type===CHART_TYPES.SCATTER},canEditAxisRange:chartDef=>{return chartDef!=null&&!(ChartUADimension.areAllNumericalOrDate(chartDef)&&chartDef.type===CHART_TYPES.SCATTER&&chartDef.scatterOptions&&chartDef.scatterOptions.equalScales)},canShowXAxisTitle:chartDef=>{const pairs=chartDef.uaDimensionPair.filter(pair=>pair.uaXDimension&&pair.uaXDimension.length&&pair.uaXDimension[0].column&&pair.uaYDimension&&pair.uaYDimension.length&&pair.uaYDimension[0].column);return!(chartDef.type===CHART_TYPES.SCATTER_MULTIPLE_PAIRS&&pairs.length>1||chartDef.type===CHART_TYPES.BOXPLOTS)},canShowYAxisTitle:chartType=>{return svc.canDisplayAxes(chartType)&&!isChartTypeInList(chartType,[CHART_TYPES.DENSITY_2D,CHART_TYPES.BOXPLOTS])},hasMultipleXDim:chartType=>chartType===CHART_TYPES.SCATTER_MULTIPLE_PAIRS,canSetLogScale:(chartDef,axisName,id)=>{if(chartDef==null){return false}switch(axisName){case"x":if(chartDef.type===CHART_TYPES.SCATTER){return ChartUADimension.isTrueNumerical(chartDef.uaXDimension[0])}else if(chartDef.type===CHART_TYPES.SCATTER_MULTIPLE_PAIRS){return chartDef.uaDimensionPair.every(pair=>pair.uaXDimension&&ChartUADimension.isTrueNumerical(pair.uaXDimension[0]))}return chartDef.type===CHART_TYPES.STACKED_BARS&&chartDef.variant!==CHART_VARIANTS.stacked100;case"y":if(chartDef.type===CHART_TYPES.SCATTER){return ChartUADimension.isTrueNumerical(chartDef.uaYDimension[0])}else if(chartDef.type===CHART_TYPES.BINNED_XY){return chartDef.variant!==CHART_VARIANTS.binnedXYHexagon&&chartDef.yDimension[0]&&!ChartDimension.hasOneTickPerBin(chartDef.yDimension[0])&&ChartDimension.isTrueNumerical(chartDef.yDimension[0])}else if(chartDef.type===CHART_TYPES.SCATTER_MULTIPLE_PAIRS){const axisPair=chartDef.uaDimensionPair.find(pair=>pair.id===id);return axisPair&&ChartUADimension.isTrueNumerical(axisPair.uaYDimension[0])}return chartDef.type!==CHART_TYPES.STACKED_BARS&&chartDef.variant!==CHART_VARIANTS.stacked100&&chartDef.variant!==CHART_VARIANTS.waterfall;default:return false}},canSetLeftRightYAxes:chartType=>isChartTypeInList(chartType,[CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.LINES]),canSelectGridlinesAxis:chartType=>svc.canSetLeftRightYAxes(chartType)||chartType===CHART_TYPES.SCATTER_MULTIPLE_PAIRS,canHaveVerticalGridlines:chartDef=>!(chartDef.facetDimension.length&&chartDef.singleXAxis)&&!(chartDef.type===CHART_TYPES.BOXPLOTS&&!chartDef.boxplotBreakdownDim.length&&!chartDef.boxplotBreakdownHierarchyDimension.length),getVLinesDisabledTooltip:chartType=>chartType===CHART_TYPES.BOXPLOTS?translate("CHARTS.SETTINGS.FORMAT.GRIDLINES.NO_X_DIMENSION","Add an X dimension to be able to display vertical gridlines"):translate("CHARTS.SETTINGS.FORMAT.GRIDLINES.COMMON_X_AXIS_NOT_SUPPORTED","Vertical gridlines cannot be drawn on subcharts using the common X axis option."),canSetMultiPlotDisplayMode:chartType=>chartType===CHART_TYPES.MULTI_COLUMNS_LINES,isKPIChart:chartType=>chartType===CHART_TYPES.KPI,canUseUnaggregatedMeasures:(chartDef,column,measureType,measureDisplayType,contextualMenuMeasureType)=>{return!!column&&([CHART_TYPES.GROUPED_COLUMNS].includes(chartDef.type)||chartDef.type===CHART_TYPES.MULTI_COLUMNS_LINES&&measureDisplayType==="column"||chartDef.type===CHART_TYPES.STACKED_COLUMNS&&chartDef.variant!==CHART_VARIANTS.stacked100)&&measureType==="NUMERICAL"&&(!contextualMenuMeasureType||contextualMenuMeasureType==="generic"||contextualMenuMeasureType==="valuesInChart"||contextualMenuMeasureType==="tooltip")},isGaugeChart:chartType=>chartType===CHART_TYPES.GAUGE,isKPILikeChart:chartType=>isChartTypeInList(chartType,[CHART_TYPES.KPI,CHART_TYPES.GAUGE]),canShowTextFormattingFromDropdown:chartType=>isChartTypeInList(chartType,[CHART_TYPES.GAUGE]),canDisplayNumberFormatting:measure=>{return!(measure.type==="CUSTOM"&&measure.inferredType!=="NUMERICAL"||measure.type==="DATE"&&!ChartsStaticData.ANY_AND_NUMERICAL_RESULT_AGGREGATION.includes(measure.function)||ChartsStaticData.ALPHANUM_AND_ALPHANUMERICAL_RESULT_AGGREGATION.includes(measure.function))},canHaveThumbnail:chartDef=>{if(chartDef.facetDimension.length){return false}return!isChartTypeInList(chartDef.type,[CHART_TYPES.PIVOT_TABLE,CHART_TYPES.KPI,CHART_TYPES.WEBAPP])},getMeasureComputationModes:chartDef=>{const measureComputationModes=[];function addMeasureComputationMode(str){measureComputationModes.push(ChartsStaticData.stdAggrMeasureComputeModes[str])}addMeasureComputationMode("NORMAL");const nbGDims=chartDef.genericDimension0.length+chartDef.genericHierarchyDimension.length+chartDef.genericDimension1.length;switch(chartDef.type){case CHART_TYPES.GROUPED_COLUMNS:case CHART_TYPES.LINES:case CHART_TYPES.MULTI_COLUMNS_LINES:addMeasureComputationMode("PERCENTAGE");addMeasureComputationMode("AVG_RATIO");addMeasureComputationMode("CUMULATIVE");addMeasureComputationMode("CUMULATIVE_PERCENTAGE");if(nbGDims===1){addMeasureComputationMode("DIFFERENCE")}break;case CHART_TYPES.STACKED_COLUMNS:case CHART_TYPES.STACKED_BARS:case CHART_TYPES.STACKED_AREA:addMeasureComputationMode("PERCENTAGE");addMeasureComputationMode("CUMULATIVE");addMeasureComputationMode("CUMULATIVE_PERCENTAGE");break;case CHART_TYPES.PIVOT_TABLE:if(ChartDimension.getXDimensions(chartDef).length<=1&&ChartDimension.getYDimensions(chartDef).length<=1){addMeasureComputationMode("PERCENTAGE");addMeasureComputationMode("AVG_RATIO");addMeasureComputationMode("CUMULATIVE");addMeasureComputationMode("CUMULATIVE_PERCENTAGE");addMeasureComputationMode("DIFFERENCE")}break;case CHART_TYPES.PIE:addMeasureComputationMode("PERCENTAGE");break;case CHART_TYPES.TREEMAP:if(ChartDimension.getYDimensions(chartDef).length<=2){addMeasureComputationMode("PERCENTAGE")}break}return measureComputationModes},canSetAlongDimension:function(chartDef,computeMode){const genericDimension0=ChartDimension.getGenericDimension(chartDef);const xDimension=ChartDimension.getXDimension(chartDef);const yDimensions=ChartDimension.getYDimensions(chartDef);if((genericDimension0&&chartDef.genericDimension1.length||xDimension&&yDimensions.length||chartDef.type==CHART_TYPES.TREEMAP&&yDimensions.length==2)&&(computeMode=="PERCENTAGE"||computeMode=="AVG_RATIO"||computeMode=="CUMULATIVE_PERCENTAGE")){return true}return false},getDimensionsForComputeAlong:chartDef=>{if(chartDef.type===CHART_TYPES.PIVOT_TABLE){const xDimension=ChartDimension.getXDimension(chartDef);const yDimension=ChartDimension.getYDimension(chartDef);if(!xDimension||!yDimension){return[]}return[[0,xDimension.column],[1,yDimension.column]]}if(chartDef.type===CHART_TYPES.SANKEY||chartDef.type===CHART_TYPES.TREEMAP){const yDimensions=ChartDimension.getYDimensions(chartDef);if(yDimensions.length<2){return[]}return[[0,yDimensions[0].column],[1,yDimensions[1].column]]}const genericDimension=ChartDimension.getGenericDimension(chartDef);if(!genericDimension||!chartDef.genericDimension1||!chartDef.genericDimension1[0]){return[]}return[[0,genericDimension.column],[1,chartDef.genericDimension1[0].column]]},isEChart:chartDef=>{const displayEchartsByDefault=svc.hasDefaultEChartsDisplay(chartDef.type)&&chartDef.displayWithEChartsByDefault;const displayEchartsByFeatureFlag=!svc.hasDefaultEChartsDisplay(chartDef.type)&&chartDef.displayWithECharts;return svc.hasEChartsDefinition(chartDef.type)&&(displayEchartsByDefault||displayEchartsByFeatureFlag||!svc.hasD3Definition(chartDef.type))},isAxisNumericalAndFormattable:function(chartDef,axisId){if(chartDef&&chartDef.$chartStoreId&&axisId){const chartStore=ChartStoreFactory.get(chartDef.$chartStoreId);const axisType=chartStore.getAxisType(axisId);if(axisType===CHART_AXIS_TYPES.MEASURE){return true}else{const dimensionType=chartStore.getAxisDimensionOrUADimensionType(axisId);const numParamsMode=chartStore.getAxisDimensionOrUADimensionNumParamsMode(axisId);return dimensionType==="NUMERICAL"&&numParamsMode!=="TREAT_AS_ALPHANUM"}}return false},getAxisTicksModes:()=>{return axisTicksModes},getAxisTicksDisabledMessage:(type,zoomControlInstanceId)=>{if(svc.isScatterZoomed(type,zoomControlInstanceId)){return translate("CHARTS.SETTINGS.FORMAT.AXIS_TICKS.SCATTER_ZOOMED_TOOLTIP","Option is disabled as it is not compatible with the current zoom state of the chart. To enable it, reset the zoom state.")}else{return translate("CHARTS.SETTINGS.FORMAT.AXIS_TICKS.DEFAULT_DISABLED_TOOLTIP",'Option is disabled as "{{generate_one_tick_per_bin}}" is selected in the dimension',{generate_one_tick_per_bin:translate("CHARTS.SHARED.GENERATE_ONE_TICK_PER_BIN","Generate one tick per bin")})}},canSetTicksConfig:(axisFormatting,chartDef,axisId)=>{return axisFormatting&&axisFormatting.displayAxis&&svc.isAxisNumericalAndFormattable(chartDef,axisId)},hasOneTickPerBinSelected:(chartStoreId,axisId)=>{if(chartStoreId){const chartStore=ChartStoreFactory.get(chartStoreId);const axisSpec=chartStore.getAxisSpec(axisId);return ChartDimension.hasOneTickPerBin(axisSpec&&axisSpec.dimension)||false}},supportSorting:(dimension,chartDef,isSecondDimension)=>{if(!dimension){return false}if(ChartDimension.isTrueNumerical(dimension)){return false}if(svc.chartSupportOneTickPerBin(chartDef)){return!ChartDimension.supportOneTickPerBin(dimension)||ChartDimension.isAlphanumLike(dimension)||ChartDimension.isSortableDateDimension(dimension,isSecondDimension)}return true},shouldRemoveOverlappingTicks:(axisFormatting,chartDef,axisId)=>{const ticksConfig=axisFormatting.ticksConfig;return ticksConfig.number!==undefined&&!svc.hasOneTickPerBinSelected(chartDef&&chartDef.$chartStoreId,axisId)&&svc.canSetTicksConfig(axisFormatting,chartDef,axisId)},canRealiasMeasuresAndDimensions:chartDef=>{return chartDef.type!=="boxplots"},canHaveBinningOptions:chartDef=>{return chartDef.variant!==CHART_VARIANTS.binnedXYHexagon},hasDefaultEChartsDisplay:chartType=>{return chartType!=null&&[CHART_TYPES.PIE].includes(chartType)},hasEChartsDefinition:chartType=>{return chartType!=null&&[CHART_TYPES.GAUGE,CHART_TYPES.PIE,CHART_TYPES.RADAR,CHART_TYPES.SANKEY,CHART_TYPES.TREEMAP].includes(chartType)},hasD3Definition:chartType=>{return chartType!=null&&[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.LINES,CHART_TYPES.STACKED_AREA,CHART_TYPES.PIVOT_TABLE,CHART_TYPES.SCATTER,CHART_TYPES.GROUPED_XY,CHART_TYPES.BINNED_XY,CHART_TYPES.DENSITY_2D,CHART_TYPES.SCATTER_MAP,CHART_TYPES.DENSITY_HEAT_MAP,CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.GRID_MAP,CHART_TYPES.BOXPLOTS,CHART_TYPES.PIE,CHART_TYPES.LIFT,CHART_TYPES.WEBAPP].includes(chartType)},hasLegacyBadge:(chartType,isEChartsToggled)=>{return svc.hasEChartsDefinition(chartType)&&svc.hasD3Definition(chartType)&&svc.hasDefaultEChartsDisplay(chartType)&&isEChartsToggled===false},hasBetaBadge:(chartType,isEChartsToggled)=>{return svc.hasEChartsDefinition(chartType)&&svc.hasD3Definition(chartType)&&!svc.hasDefaultEChartsDisplay(chartType)&&!!isEChartsToggled},canDisplayLegend:chartType=>{return!isChartTypeInList(chartType,[CHART_TYPES.PIVOT_TABLE,CHART_TYPES.LIFT,CHART_TYPES.DENSITY_2D,CHART_TYPES.KPI,CHART_TYPES.GAUGE,CHART_TYPES.SANKEY,CHART_TYPES.DENSITY_HEAT_MAP])},isStackedLegend:chartDef=>{return chartDef.type===CHART_TYPES.GEOMETRY_MAP&&chartDef.geoLayers.length>2},shouldComputeLegend:chartType=>{return svc.canDisplayLegend(chartType)||isChartTypeInList(chartType,[CHART_TYPES.PIVOT_TABLE,CHART_TYPES.SANKEY])},canConfigureForceLastPositionOthers:(chartType,dimension)=>{return isChartTypeInList(chartType,[CHART_TYPES.DONUT,CHART_TYPES.PIE])&&ChartDimension.isAlphanumLike(dimension)&&dimension.generateOthersCategory},canDisplayAxes:chartType=>{return!isChartTypeInList(chartType,[CHART_TYPES.PIE,CHART_TYPES.PIVOT_TABLE,CHART_TYPES.KPI,CHART_TYPES.GAUGE,CHART_TYPES.TREEMAP,CHART_TYPES.SANKEY,CHART_TYPES.RADAR,CHART_TYPES.SCATTER_MAP,CHART_TYPES.DENSITY_HEAT_MAP,CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.ADMINISTRATIVE_MAP,CHART_TYPES.GRID_MAP])},canHideAxes:chartType=>{return svc.canDisplayAxes(chartType)&&chartType!==CHART_TYPES.DENSITY_2D},canUseSQL:chartDef=>{return!chartDef.hexbin},canShowTooltips:chartType=>{return!isChartTypeInList(chartType,[CHART_TYPES.GAUGE,CHART_TYPES.KPI])},canPinTooltip:chartType=>{return chartType!==CHART_TYPES.SCATTER&&chartType!==CHART_TYPES.SCATTER_MULTIPLE_PAIRS},canFilterInTooltip:chartDef=>{return![CHART_TYPES.SCATTER,CHART_TYPES.SCATTER_MULTIPLE_PAIRS].includes(chartDef.type)},canIgnoreEmptyBinsForColorDimension:chartDef=>{return[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.MULTI_COLUMNS_LINES].includes(chartDef.type)&&chartDef.variant!==CHART_VARIANTS.waterfall},getRecordsMetadata:(chartDef,sampleMetadata,beforeFilterRecords,afterFilterRecords)=>{if([CHART_TYPES.SCATTER,CHART_TYPES.SCATTER_MULTIPLE_PAIRS].includes(chartDef.type)){const datasetRecordCount=sampleMetadata?sampleMetadata.datasetRecordCount:beforeFilterRecords;const sampleRecordCount=sampleMetadata?sampleMetadata.sampleRecordCount:beforeFilterRecords;const scatterOptions=chartDef.type===CHART_TYPES.SCATTER?chartDef.scatterOptions:chartDef.scatterMPOptions;const numberOfRecords=scatterOptions.numberOfRecords||1e6;const numberOfRecordsPerPair=Math.floor(numberOfRecords/(chartDef.uaDimensionPair.length||1));let hasLessRecordsThanSampling=numberOfRecordsPerPair<datasetRecordCount;if(datasetRecordCount<0){hasLessRecordsThanSampling=numberOfRecordsPerPair<sampleRecordCount}if(afterFilterRecords<numberOfRecordsPerPair){hasLessRecordsThanSampling=false}return{hasLessRecordsThanSampling:hasLessRecordsThanSampling,message:translate("CHARTS.HEADER.BADGE.TRUNCATED.TOOLTIP",`${NumberFormatter.longSmartNumberFilter()(numberOfRecords)} points limit reached. You can modify the limit in the "Misc" section of your chart.`,{maxNbPoints:NumberFormatter.longSmartNumberFilter()(numberOfRecords)})}}else{return null}},shouldHideFormatTab:(chartType,readOnly)=>{return readOnly},canUseSecondGenericDimension:chartDef=>{return!!chartDef.genericDimension0?.length||!!chartDef.genericHierarchyDimension?.length||!!chartDef.genericDimension1?.length},canSupportMultipleGenericMeasures:chartDef=>{return[CHART_TYPES.STACKED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.LINES,CHART_TYPES.STACKED_AREA].includes(chartDef.type)&&!chartDef.genericDimension1?.length||chartDef.type===CHART_TYPES.GROUPED_COLUMNS&&chartDef.variant!==CHART_VARIANTS.waterfall&&!chartDef.genericDimension1?.length||[CHART_TYPES.KPI,CHART_TYPES.RADAR,CHART_TYPES.MULTI_COLUMNS_LINES,CHART_TYPES.PIVOT_TABLE].includes(chartDef.type)},canUseNonGroupingMode:(chartDef,dimensionChartDefKey)=>{if(chartDef.type!==CHART_TYPES.GROUPED_COLUMNS||chartDef.variant!==CHART_VARIANTS.waterfall){return true}if(["genericDimension0","genericDimension1","genericHierarchyDimension"].includes(dimensionChartDefKey)){return false}return true}};return svc}})();(function(){"use strict";const app=angular.module("dataiku.directives.simple_report");app.factory("ChartIconUtils",function(WebAppsService,AssetsUtils){const ret={computeChartIcon:function(type,variant,isInAnalysis,webAppType){if(!ret.typeAndVariantToImageMap){return""}if(typeof type!=="undefined"){if(type=="webapp"){const loadedDesc=WebAppsService.getWebAppLoadedDesc(webAppType)||{};return loadedDesc&&loadedDesc.desc&&loadedDesc.desc.meta&&loadedDesc.desc.meta.icon?loadedDesc.desc.meta.icon:"icon-puzzle-piece"}let imageName="basic_graphs";if(typeof variant==="undefined"){variant="normal"}if(typeof ret.typeAndVariantToImageMap[type]!=="undefined"&&typeof ret.typeAndVariantToImageMap[type][variant]!=="undefined"&&typeof ret.typeAndVariantToImageMap[type][variant].icon!=="undefined"){imageName=ret.typeAndVariantToImageMap[type][variant].icon}let uri="/static/dataiku/images/charts/icons/";if(isInAnalysis){uri+="Chart_Icon_Analysis_"}else{uri+="Chart_Icon_Dataset_"}return AssetsUtils.appendAssetsHash(uri+imageName+".svg")}},computeScatterLegendIcon(type){return AssetsUtils.appendAssetsHash(`/static/dataiku/images/charts/icons/scatter-legend/symbol_${type}.svg`)},typeAndVariantToImageMap:{grouped_columns:{normal:{icon:"vertical_bars",preview:"grouped_columns"},waterfall:{icon:"waterfall",preview:"waterfall"}},stacked_bars:{normal:{icon:"horizontal_stacked_bars",preview:"bar_graph"},stacked_100:{icon:"bar_stacked_100",preview:"bar_graph"}},stacked_columns:{normal:{icon:"stacked_color",preview:"stacked_columns"},stacked_100:{icon:"stacked_100",preview:"stacked_columns"}},multi_columns_lines:{normal:{icon:"column__lines",preview:"column__lines"}},lines:{normal:{icon:"lines",preview:"lines"}},stacked_area:{normal:{icon:"stacked_areas",preview:"stacked_areas"},stacked_100:{icon:"stacked_areas_100",preview:"stacked_areas_100"}},pivot_table:{normal:{icon:"table",preview:"table"}},scatter:{normal:{icon:"scatter",preview:"scatter"}},scatter_multiple_pairs:{normal:{icon:"scatter_multiple_pairs",preview:"scatter_multiple_pairs"}},grouped_xy:{normal:{icon:"grouped_scatter",preview:"grouped_scatter"}},binned_xy:{normal:{icon:"bubble",preview:"bubble"},binned_xy_rect:{icon:"rectangles",preview:"rectangles"},binned_xy_hex:{icon:"hexagons",preview:"hexagons"}},density_2d:{normal:{icon:"heatmap",preview:"heatmap"}},kpi:{normal:{icon:"kpi",preview:"kpi"}},radar:{normal:{icon:"radar_web",preview:"radar_web"}},gauge:{normal:{icon:"gauge",preview:"gauge"}},sankey:{normal:{icon:"sankey",preview:"sankey"}},scatter_map:{normal:{icon:"scatter_map",preview:"scatter_map"}},density_heat_map:{normal:{icon:"density_heat_map",preview:"density_heat_map"}},geom_map:{normal:{icon:"geom_map",preview:"geom_map"}},admin_map:{normal:{icon:"administrative_map",preview:"administrative_map"},filled_map:{icon:"administrative_map",preview:"administrative_map"}},grid_map:{normal:{icon:"grid_map",preview:"grid_map"}},treemap:{normal:{icon:"tree_map",preview:"tree_map"}},boxplots:{normal:{icon:"box_plot",preview:"box_plot"}},pie:{normal:{icon:"pie",preview:"pie"},donut:{icon:"donut",preview:"donut"}},lift:{normal:{icon:"diminishing_return_charts",preview:"diminishing-reduction"}}}};return ret})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("ChartManager",function(ChartDimension,ChartTooltips,ChartContextualMenu,AnimatedChartsUtils,$timeout,ChartLegendUtils,ChartFormatting,ChartColorScales,D3ChartAxes,ChartStoreFactory,ChartAxesUtils,ChartColorUtils,CHART_AXIS_TYPES,ChartPropertiesService){const svc={};const createSVGs=function($container,chartData,chartDef,isInteractiveChart,chartTileProperties,ignoreLabels=new Set){$container.find(".mainzone").remove();const mainzone=$('<div class="mainzone" data-qa-screenshot-scope__chart>').prependTo($container);if(isInteractiveChart&&ChartPropertiesService.showBrush(chartDef.linesZoomOptions,chartTileProperties)&&chartDef.linesZoomOptions.enabled){if(chartDef.legendPlacement==="OUTER_TOP"||chartDef.legendPlacement==="OUTER_BOTTOM"){mainzone.addClass("mainzone--with-brush-and-horizontal-legend")}else{mainzone.addClass("mainzone--with-brush")}}const $chartsContainer=$('<div class="charts">').appendTo(mainzone),isFacetted=chartData.axesDef.facet!=undefined,facetLabels=chartData.getAxisLabels("facet",ignoreLabels)||[null];if(isFacetted){$chartsContainer.addClass("facetted");$chartsContainer.height(facetLabels.length*(1+chartDef.chartHeight)-1)}let $svgs=$();const $chartsTable=$('<div class="charts-table">').appendTo($chartsContainer);facetLabels.forEach(function(facetLabel){const $div=$('<div class="chart">');$div.appendTo($chartsTable);if(facetLabel){const $facetInfo=$('<div class="facet-info">').appendTo($div);$("<h2>").text(ChartFormatting.getForOrdinalAxis(facetLabel.label)).appendTo($facetInfo)}const $wrapper=$('<div class="chart-wrapper">').appendTo($div);if(isFacetted){$wrapper.css("height",chartDef.chartHeight)}$svgs=$svgs.add($('<svg style="width: 100%; height: 100%;" class="chart-svg">').appendTo($wrapper))});return $svgs};svc.initChart=function(chartDef,chartHandler,chartData,$container,drawFrame,axisSpecs,colorSpec,zoomContext,initLinesZoom,ignoreLabels=new Set){const chartStoreMeta=ChartStoreFactory.getOrCreate(chartDef.$chartStoreId);chartDef.$chartStoreId=chartStoreMeta.id;chartStoreMeta.store.setAxisSpecs(axisSpecs);chartDef.$axisSpecs=axisSpecs;let chartBase={};const colorContext={chartData:chartData,colorOptions:ChartColorUtils.getChartColorOptions(chartDef),defaultLegendDimension:ChartColorUtils.getDefaultLegendDimension(chartDef,chartData),colorSpec:colorSpec,chartHandler:chartHandler,ignoreLabels:ignoreLabels,theme:chartHandler.getChartTheme()};const colorScale=ChartColorScales.createColorScale(colorContext);chartBase.isPercentChart=chartDef.variant&&chartDef.variant.endsWith("_100");const ySpecs=ChartAxesUtils.getYAxisSpecs(axisSpecs);const xAxis=D3ChartAxes.createAxis(chartData,axisSpecs?.["x"],chartBase.isPercentChart,chartDef.xAxisFormatting.isLogScale,undefined,chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting,chartDef,ignoreLabels,axisSpecs?.["x"]?.type===CHART_AXIS_TYPES.MEASURE&&Object.keys(ySpecs||[]).map((_,i)=>i+1));const yAxes=[];ySpecs&&Object.keys(ySpecs).forEach(key=>{const spec=ySpecs[key];const includeZero=ChartAxesUtils.shouldIncludeZero(chartDef,key);const yAxis=D3ChartAxes.createAxis(chartData,spec,chartBase.isPercentChart,ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,spec.id),includeZero,ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,spec.id),chartDef,ignoreLabels,spec?.type===CHART_AXIS_TYPES.MEASURE&&[0]);if(yAxis){yAxes.push(yAxis)}});ChartLegendUtils.createLegend($container,chartDef,chartData,chartHandler,colorSpec,colorScale,{ignoreLabels:ignoreLabels}).then(function(){$timeout(()=>{const $svgs=createSVGs($container,chartData,chartDef,zoomContext&&ChartDimension.isInteractiveChart(chartDef),chartHandler.chartTileProperties,ignoreLabels);if($container.data("previous-tooltip")){$container.data("previous-tooltip").destroy()}const yAxesOptions=[];yAxes.forEach(axis=>{yAxesOptions.push({id:axis.id,tickValues:axis&&axis.tickValues(),tickFormat:axis&&axis.tickFormat()})});const axisOptions={x:{tickValues:xAxis&&xAxis.tickValues(),tickFormat:xAxis&&xAxis.tickFormat()},y:yAxesOptions};const yAxesColors=chartData.getYAxesColors(ySpecs,chartDef,chartHandler.getChartTheme());const d3DrawContext={$svgs:$svgs,chartDef:chartDef,chartHandler:chartHandler,ySpecs:ySpecs,xAxis:xAxis,yAxes:yAxes,axisOptions:axisOptions,yAxesColors:yAxesColors};const{margins,vizWidth,vizHeight}=D3ChartAxes.drawAxes(d3DrawContext);ChartLegendUtils.adjustLegendPlacement(chartDef,$container,margins);const measureFormatters=ChartFormatting.createMeasureFormatters(chartDef,chartData,Math.max(vizHeight,vizWidth));const tooltips=ChartTooltips.create($container,chartHandler,chartData,chartDef,measureFormatters,undefined,ignoreLabels);const{store,id}=ChartStoreFactory.getOrCreate(chartDef.$chartStoreId);chartDef.$chartStoreId=id;const contextualMenu=ChartContextualMenu.create(chartData,chartDef,store,chartHandler.animation);chartBase={$svgs:$svgs,colorScale:colorScale,margins:margins,vizWidth:vizWidth,vizHeight:vizHeight,xAxis:xAxis,yAxes:yAxes,axisOptions:axisOptions,tooltips:tooltips,contextualMenu:contextualMenu,measureFormatters:measureFormatters,chartData:chartData,xSpec:axisSpecs&&axisSpecs["x"],ySpecs:ySpecs,colorSpec:colorSpec};$container.data("previous-tooltip",tooltips);angular.extend(chartHandler.tooltips,tooltips);if(chartData.axesDef.animation!=undefined){AnimatedChartsUtils.initAnimation(chartHandler,chartData,chartDef,function(frameIdx){chartBase.tooltips.setAnimationFrame(frameIdx);return drawFrame(frameIdx,chartBase)},ignoreLabels)}else{AnimatedChartsUtils.unregisterAnimation(chartHandler)}if(zoomContext&&initLinesZoom){zoomContext={...zoomContext,chartBase:chartBase,svgs:chartBase.$svgs,xAxis:xAxis};chartDef.$zoomControlInstanceId=initLinesZoom(zoomContext)}$svgs.on("click",function(evt){if(evt.target.hasAttribute("data-legend")||evt.target.hasAttribute("tooltip-el")){return}chartBase.tooltips.resetColors();chartBase.tooltips.unfix()});if(chartData.axesDef.animation!=undefined){chartHandler.animation.drawFrame(chartHandler.animation.currentFrame||0,chartBase);if(chartHandler.chartTileProperties&&chartHandler.chartTileProperties.autoPlayAnimation){chartHandler.animation.play()}}else{drawFrame(0,chartBase)}if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}},100)});return chartBase};return svc})})();(function(){"use strict";angular.module("dataiku.charts").service("ChartStoreFactory",chartStoreFactory);function ChartSpecs(){}ChartSpecs.prototype.insert=function(frameIndex,facetIndex,key,value){if(!this[frameIndex]){this[frameIndex]={}}if(!this[frameIndex][facetIndex]){this[frameIndex][facetIndex]={}}this[frameIndex][facetIndex][key]=value;return this[frameIndex][facetIndex][key]};ChartSpecs.prototype.get=function(frameIndex,facetIndex,key){return this[frameIndex]&&this[frameIndex][facetIndex]&&this[frameIndex][facetIndex][key]};ChartSpecs.prototype.remove=function(frameIndex,facetIndex,key){if(this[frameIndex]&&this[frameIndex][facetIndex]&&this[frameIndex][facetIndex][key]){delete this[frameIndex][facetIndex][key];return true}return false};ChartSpecs.prototype.flatten=function(){return Object.entries(this).reduce((accByFrames,frameEntry)=>{return Object.entries(frameEntry[1]).reduce((accByFacets,facetEntry)=>{const value=facetEntry[1];value.frame=frameEntry[0];value.facet=facetEntry[0];accByFacets.push(value);return accByFacets},accByFrames)},[])};function chartStore(CHART_AXIS_TYPES){const chartSpecs=new ChartSpecs;return{get:function(key,frameIndex=0,facetIndex=0){return chartSpecs.get(frameIndex,facetIndex,key)},set:function(key,value,frameIndex=0,facetIndex=0){chartSpecs.insert(frameIndex,facetIndex,key,value)},setAxisSpecs:function(axisSpecs,frameIndex=0,facetIndex=0){chartSpecs.insert(frameIndex,facetIndex,"axisSpecs",axisSpecs)},getAxisSpecs:function(frameIndex=0,facetIndex=0){return chartSpecs.get(frameIndex,facetIndex,"axisSpecs")},getAxisSpec:function(axisId,frameIndex=0,facetIndex=0){const axisSpecs=chartSpecs.get(frameIndex,facetIndex,"axisSpecs");return axisSpecs&&axisSpecs[axisId]},getDimensionId(dimension,frameIndex=0,facetIndex=0){let dimensionDefToId=chartSpecs.get(frameIndex,facetIndex,"dimensionDefToId");if(dimensionDefToId===undefined){dimensionDefToId=chartSpecs.insert(frameIndex,facetIndex,"dimensionDefToId",new Map)}return dimensionDefToId.get(dimension)},setDimensionId(dimension,id,frameIndex=0,facetIndex=0){let dimensionDefToId=chartSpecs.get(frameIndex,facetIndex,"dimensionDefToId");if(dimensionDefToId===undefined){dimensionDefToId=chartSpecs.insert(frameIndex,facetIndex,"dimensionDefToId",new Map)}dimensionDefToId.set(dimension,id)},purgeDimensionIds(frameIndex=0,facetIndex=0){chartSpecs.remove(frameIndex,facetIndex,"dimensionDefToId")},getMeasureId(measure,frameIndex=0,facetIndex=0){let measureDefToId=chartSpecs.get(frameIndex,facetIndex,"measureDefToId");if(measureDefToId===undefined){measureDefToId=chartSpecs.insert(frameIndex,facetIndex,"measureDefToId",new Map)}return measureDefToId.get(measure)},setMeasureId(measure,id,frameIndex=0,facetIndex=0){let measureDefToId=chartSpecs.get(frameIndex,facetIndex,"measureDefToId");if(measureDefToId===undefined){measureDefToId=chartSpecs.insert(frameIndex,facetIndex,"measureDefToId",new Map)}measureDefToId.set(measure,id)},purgeMeasureIds(frameIndex=0,facetIndex=0){chartSpecs.remove(frameIndex,facetIndex,"measureDefToId")},getAppliedDashboardFilters:function(frameIndex=0,facetIndex=0){let dashboardFilters=chartSpecs.get(frameIndex,facetIndex,"dashboardFilters");if(dashboardFilters===undefined){dashboardFilters=chartSpecs.insert(frameIndex,facetIndex,"dashboardFilters",{})}return dashboardFilters},setAppliedDashboardFilters:function(dashboardFilters,frameIndex=0,facetIndex=0){chartSpecs.insert(frameIndex,facetIndex,"dashboardFilters",dashboardFilters)},getGridApi:function(frameIndex=0,facetIndex=0){let gridApi=chartSpecs.get(frameIndex,facetIndex,"gridApi");if(gridApi===undefined){gridApi=chartSpecs.insert(frameIndex,facetIndex,"gridApi",null)}return gridApi},setGridApi:function(gridApi,frameIndex=0,facetIndex=0){chartSpecs.insert(frameIndex,facetIndex,"gridApi",gridApi)},setHierarchyMissingColumns:function(hierarchyMissingColumns,frameIndex=0,facetIndex=0){chartSpecs.insert(frameIndex,facetIndex,"hierarchyMissingColumns",hierarchyMissingColumns)},getHierarchyMissingColumns:function(frameIndex=0,facetIndex=0){let hierarchyMissingColumns=chartSpecs.get(frameIndex,facetIndex,"hierarchyMissingColumns");if(hierarchyMissingColumns===undefined){hierarchyMissingColumns=chartSpecs.insert(frameIndex,facetIndex,"hierarchyMissingColumns",{})}return hierarchyMissingColumns},getRequestOptions:function(frameIndex=0,facetIndex=0){let requestOptions=chartSpecs.get(frameIndex,facetIndex,"requestOptions");if(requestOptions===undefined){requestOptions=chartSpecs.insert(frameIndex,facetIndex,"requestOptions",{})}return requestOptions},setRequestOptions:function(requestOptions,frameIndex=0,facetIndex=0){const currentRequestOptions=chartSpecs.get(frameIndex,facetIndex,"requestOptions")||{};chartSpecs.insert(frameIndex,facetIndex,"requestOptions",{...currentRequestOptions,...requestOptions})},getAllAxisSpecs:function(axisId){const axisSpecs=chartSpecs.flatten().filter(chartSpec=>chartSpec.axisSpecs).map(chartSpec=>chartSpec.axisSpecs);return axisSpecs&&axisSpecs.map(axisSpec=>axisSpec[axisId])},getAxisType:function(axisId){const axisSpecs=this.getAllAxisSpecs(axisId);const uniqueAxisTypes=Array.from(new Set(axisSpecs.map(spec=>spec&&spec.type)));return uniqueAxisTypes.length===1?uniqueAxisTypes[0]:null},getAxisDimensionOrUADimensionType:function(axisId){const axisSpecs=this.getAllAxisSpecs(axisId);const uniqueDimensionTypes=Array.from(new Set(axisSpecs.map(spec=>spec&&spec.dimension&&spec.dimension.type)));return uniqueDimensionTypes.length===1?uniqueDimensionTypes[0]:null},getAxisDimensionOrUADimensionNumParamsMode:function(axisId){const axisSpecs=this.getAllAxisSpecs(axisId);const uniqueNumParamsMode=Array.from(new Set(axisSpecs.map(spec=>spec&&spec.dimension&&spec.dimension.type&&spec.dimension.numParams&&spec.dimension.numParams.mode)));return uniqueNumParamsMode.length===1?uniqueNumParamsMode[0]:null},updateChartStoreMeasureIDsAndDimensionIDs(chartDef){this.purgeMeasureIds();this.purgeDimensionIds();chartDef.genericMeasures.forEach((measure,i)=>this.setMeasureId(measure,this.getMeasureUniqueId(measure,i)));chartDef.yDimension.forEach((yDim,i)=>this.setDimensionId(yDim,this.getDimensionUniqueId(yDim,i,"yDimension")));chartDef.xDimension.forEach((xDim,i)=>this.setDimensionId(xDim,this.getDimensionUniqueId(xDim,i,"xDimension")));if(chartDef.xHierarchyDimension&&chartDef.xHierarchyDimension.length){chartDef.xHierarchyDimension[0].dimensions.forEach((dim,i)=>this.setDimensionId(dim,this.getDimensionUniqueId(dim,i,"xHierarchyDimension")))}if(chartDef.yHierarchyDimension&&chartDef.yHierarchyDimension.length){chartDef.yHierarchyDimension[0].dimensions.forEach((dim,i)=>this.setDimensionId(dim,this.getDimensionUniqueId(dim,i,"yHierarchyDimension")))}},getDimensionUniqueId(dimension,index,type){return`${type}_${index}_${dimension.column}`.replace(".","_")},getMeasureUniqueId(measure,index){return`measure_${index}_${measure.column}`.replace(".","_")}}}function chartStoreFactory(CHART_AXIS_TYPES){let latestId=1;const chartStores={};const generateId=()=>{return latestId++};const svc={create:()=>{const id=generateId();const store=chartStore(CHART_AXIS_TYPES);if(!chartStores[id]){chartStores[id]=store}else{throw new Error(`${id} already exists, cannot create chart store`)}return{id:id,store:store}},get:id=>{return chartStores[id]},getOrCreate:id=>{if(id&&chartStores[id]){return{id:id,store:svc.get(id)}}return svc.create()}};return svc}})();(function(){"use strict";angular.module("dataiku.charts").factory("ChartTypeChangeHandler",chartTypeChangeHandler);function chartTypeChangeHandler(Assert,LoggerProvider,ChartsStaticData,ChartAxesUtils,ChartTypeChangeUtils,ChartColumnTypeUtils,ChartColorUtils,VALUES_DISPLAY_MODES,DKU_PALETTE_NAMES,translate,ChartDimension,ChartUADimension,ChartFeatures,ChartMeasure,WebAppsService,PluginConfigUtils,ChartLabels,$rootScope,CHART_TYPES,CHART_VARIANTS,ChartColorSelection,ValuesInChartPlacementMode,ChartHierarchyDimension,TotalBarDisplayModes,ChartFilters,RegressionTypes,ValuesInChartOverlappingStrategy,PolygonSources,LineStyleTypes,AxisTicksConfigMode,AxisTicksFormatting,AxisTitleFormatting,GridlinesAxisType,ValueType,DSSVisualizationThemeUtils,ChartDefinitionChangeHandler){const Logger=LoggerProvider.getLogger("charts");const COLUMN_TYPE_ORDER={color:["colorMeasure","uaColor"],size:["sizeMeasure","uaSize"],tooltip:["tooltipMeasures","uaTooltip"]};const DEFAULT_FONT_FORMATTING={fontSize:11,fontColor:"#333",hasBackground:false};const DEFAULT_TABLE_HEADER_FONT_FORMATTING={...DEFAULT_FONT_FORMATTING,fontSize:12};const DEFAULT_AUTO_FONT_FORMATTING={fontSize:11,fontColor:"AUTO"};const DEFAULT_VALUES_DISPLAY_IN_CHART_TEXT_FORMATTING={...DEFAULT_AUTO_FONT_FORMATTING,hasBackground:false,backgroundColor:"#D9D9D9BF"};const DEFAULT_GAUGE_MIN_MAX={sourceType:ValueType.Constant,aggregatedColumn:null,datasetColumn:null,customAggregation:null,aggregation:null};const accept=function(message){return{accept:true,message:message}};const reject=function(message){return{accept:false,message:message}};function setSingleIfHasEnough(srcArr,tgtArr,srcIdx){tgtArr.length=0;if(srcArr.length>srcIdx){tgtArr.push(srcArr[srcIdx])}}function retrieveGeoFromGeomMap(chartDef){if(chartDef.geometry.length===0&&chartDef.geoLayers&&chartDef.geoLayers.length>1){chartDef.geometry=angular.copy(chartDef.geoLayers[0].geometry)}}function migrateToGeomMap(chartDef){const uaColor=angular.copy(chartDef.uaColor);const colorOptions=angular.copy(chartDef.colorOptions);if(chartDef.geometry.length>0){chartDef.geoLayers.unshift({geometry:angular.copy(chartDef.geometry),uaColor:uaColor,colorOptions:colorOptions});chartDef.geometry=[]}else{chartDef.geoLayers[0].colorOptions=colorOptions;chartDef.geoLayers[0].uaColor=uaColor}}function retrieveOptionsFromGeomMap(chartDef){if(chartDef.geoLayers&&chartDef.geoLayers.length>0){chartDef.colorOptions=angular.copy(chartDef.geoLayers[0].colorOptions);if(chartDef.geoLayers[0].uaColor){chartDef.uaColor=angular.copy(chartDef.geoLayers[0].uaColor)}}}function computeGenericMeasureInitialValuesInChartDisplayTextFormattingOptions(chartDef){const commonProperties={};const properties=["fontSize","fontColor","hasBackground","backgroundColor"];if(chartDef.genericMeasures){chartDef.genericMeasures.filter(m=>m.isA==="measure").forEach(m=>{const initializedProperties=Object.keys(commonProperties);properties.forEach(prop=>{if(commonProperties[prop]!==null&&m.valuesInChartDisplayOptions&&m.valuesInChartDisplayOptions.displayValues&&m.valuesInChartDisplayOptions.textFormatting&&!_.isNil(m.valuesInChartDisplayOptions.textFormatting[prop])){if(!initializedProperties.includes(prop)){commonProperties[prop]=m.valuesInChartDisplayOptions.textFormatting[prop]}else if(commonProperties[prop]!==m.valuesInChartDisplayOptions.textFormatting[prop]){commonProperties[prop]=null}}})})}return{...DEFAULT_VALUES_DISPLAY_IN_CHART_TEXT_FORMATTING,..._.omitBy(commonProperties,_.isNil)}}function computeGenericMeasureInitialValuesInChartDisplayOptions(chartDef){const properties=["placementMode","spacing"];const commonProperties={};if(!chartDef.genericMeasures){return commonProperties}for(const measure of chartDef.genericMeasures){if(measure.isA!=="measure"||!measure.valuesInChartDisplayOptions){continue}for(const prop of properties){const value=measure.valuesInChartDisplayOptions[prop];if(_.isNil(value)){continue}if(!(prop in commonProperties)){commonProperties[prop]=value}else if(commonProperties[prop]!==value){commonProperties[prop]=null}}}return _.omitBy(commonProperties,_.isNil)}function getAttributeAndRemove(chartDefAttributes,chartDefAttributeNames=[],multiple=false){if(Array.isArray(chartDefAttributes)&&Array.isArray(chartDefAttributeNames)){const response=[];const indexes=[];for(const chartDefAttributeName of chartDefAttributeNames){for(const[index,column]of chartDefAttributes.entries()){if(column&&column.chartDefAttributeName===chartDefAttributeName){response.push(column);indexes.push(index);if(!multiple){break}}}}indexes.sort(descendingNumericSort).forEach(index=>chartDefAttributes.splice(index,1));return response}return[]}function autocompleteUA(ua){if(ua.isA!=="ua"){ua.sortBy="NATURAL";ua.isA="ua";ua.multiplier=ChartsStaticData.DEFAULT_MULTIPLIER;if(ua.type==="DATE"){ua.dateMode="RANGE"}if(ua.type==="NUMERICAL"){ua.digitGrouping=ChartsStaticData.DEFAULT_DIGIT_GROUPING;ua.useParenthesesForNegativeValues=false;ua.shouldFormatInPercentage=false;ua.hideTrailingZeros=getDefaultTrailingZeros(ua)}}if(!ua.$id){ua.$id=generateUniqueId()}}function newColorOptions(index){const colorOptions=getDefaultColorOption(index);initializeColorPalettes(colorOptions);return colorOptions}function getDefaultColorOption(index){const circularColorPalette=window.dkuColorPalettes.discrete[0].sample;return{singleColor:circularColorPalette[index%circularColorPalette.length],transparency:.75}}function initializeColorPalettes(colorOptions){colorOptions.customPalette=ChartColorUtils.getDefaultCustomPalette();colorOptions.ccScaleMode="NORMAL";colorOptions.paletteType="CONTINUOUS";colorOptions.quantizationMode="NONE";colorOptions.numQuantizeSteps=5;colorOptions.paletteMiddleValue=0;if(colorOptions.paletteMiddleValue<=0&&colorOptions.paletteType==="DIVERGING"&&colorOptions.ccScaleMode==="LOG"){colorOptions.paletteMiddleValue=1}colorOptions.customColors={}}function fixupAxes(chartDef,theme){if(_.isNil(chartDef.xAxisFormatting)||!Object.keys(chartDef.xAxisFormatting).length){chartDef.xAxisFormatting={axisTitleFormatting:{...AxisTitleFormatting},customExtent:{...ChartsStaticData.DEFAULT_CUSTOM_EXTENT}};if(theme){DSSVisualizationThemeUtils.applyAxisTitleFormatting(theme,chartDef.xAxisFormatting.axisTitleFormatting)}}if(_.isNil(chartDef.xAxisFormatting.displayAxis)){chartDef.xAxisFormatting.displayAxis=true}if(_.isNil(chartDef.xAxisFormatting.showAxisTitle)){chartDef.xAxisFormatting.showAxisTitle=true}if(_.isNil(chartDef.xAxisFormatting.axisValuesFormatting)){chartDef.xAxisFormatting.axisValuesFormatting={axisTicksFormatting:{...AxisTicksFormatting},numberFormatting:{...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}};if(theme){DSSVisualizationThemeUtils.applyAxisValueFormatting(theme,chartDef.xAxisFormatting.axisValuesFormatting)}}if(_.isNil(chartDef.xAxisFormatting.axisValuesFormatting.axisTicksFormatting)){chartDef.xAxisFormatting.axisValuesFormatting.axisTicksFormatting={...AxisTicksFormatting};if(theme){DSSVisualizationThemeUtils.applyAxisValueFormatting(theme,chartDef.xAxisFormatting.axisValuesFormatting)}}if(_.isNil(chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting)){chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting={...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}}if(_.isNil(chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.digitGrouping)){chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.digitGrouping=ChartsStaticData.DEFAULT_DIGIT_GROUPING}if(_.isNil(chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.useParenthesesForNegativeValues)){chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.useParenthesesForNegativeValues=false}if(_.isNil(chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.shouldFormatInPercentage)){chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.shouldFormatInPercentage=false}if(_.isNil(chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.hideTrailingZeros)){chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting.hideTrailingZeros=getDefaultTrailingZeros(chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting)}if(_.isNil(chartDef.xAxisFormatting.axisTitleFormatting)){chartDef.xAxisFormatting.axisTitleFormatting={...AxisTitleFormatting};if(theme){DSSVisualizationThemeUtils.applyAxisTitleFormatting(theme,chartDef.xAxisFormatting.axisTitleFormatting)}}if(_.isNil(chartDef.xAxisFormatting.ticksConfig)){chartDef.xAxisFormatting.ticksConfig={mode:AxisTicksConfigMode.INTERVAL,number:null}}if(_.isNil(chartDef.xAxisFormatting.customExtent)||!Object.keys(chartDef.xAxisFormatting.customExtent).length){chartDef.xAxisFormatting.customExtent={...ChartsStaticData.DEFAULT_CUSTOM_EXTENT}}if(_.isNil(chartDef.yAxesFormatting)||!chartDef.yAxesFormatting.length){chartDef.yAxesFormatting=[]}const leftAxisFormatting=chartDef.yAxesFormatting.find(formatting=>formatting.id===ChartsStaticData.LEFT_AXIS_ID||_.isNil(formatting.id));const rightAxisFormatting=chartDef.yAxesFormatting.find(formatting=>formatting.id===ChartsStaticData.RIGHT_AXIS_ID);if(!leftAxisFormatting||!Object.keys(leftAxisFormatting).length){chartDef.yAxesFormatting.push({id:ChartsStaticData.LEFT_AXIS_ID})}if(!rightAxisFormatting||!Object.keys(rightAxisFormatting).length){chartDef.yAxesFormatting.push({id:ChartsStaticData.RIGHT_AXIS_ID})}chartDef.yAxesFormatting.forEach(axisFormatting=>{if(_.isNil(axisFormatting.id)){axisFormatting.id=ChartsStaticData.LEFT_AXIS_ID}if(_.isNil(axisFormatting.displayAxis)){axisFormatting.displayAxis=true}if(_.isNil(axisFormatting.showAxisTitle)){axisFormatting.showAxisTitle=true}if(_.isNil(axisFormatting.axisValuesFormatting)){axisFormatting.axisValuesFormatting={axisTicksFormatting:{...AxisTicksFormatting},numberFormatting:{...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}};if(theme){DSSVisualizationThemeUtils.applyAxisValueFormatting(theme,axisFormatting.axisValuesFormatting)}}if(_.isNil(axisFormatting.axisValuesFormatting.axisTicksFormatting)){axisFormatting.axisValuesFormatting.axisTicksFormatting={...AxisTicksFormatting};if(theme){DSSVisualizationThemeUtils.applyAxisValueFormatting(theme,axisFormatting.axisValuesFormatting)}}if(_.isNil(axisFormatting.axisValuesFormatting.numberFormatting)){axisFormatting.axisValuesFormatting.numberFormatting={...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}}if(_.isNil(axisFormatting.axisValuesFormatting.numberFormatting.digitGrouping)){axisFormatting.axisValuesFormatting.numberFormatting.digitGrouping=ChartsStaticData.DEFAULT_DIGIT_GROUPING}if(_.isNil(axisFormatting.axisValuesFormatting.numberFormatting.useParenthesesForNegativeValues)){axisFormatting.axisValuesFormatting.numberFormatting.useParenthesesForNegativeValues=false}if(_.isNil(axisFormatting.axisValuesFormatting.numberFormatting.shouldFormatInPercentage)){axisFormatting.axisValuesFormatting.numberFormatting.shouldFormatInPercentage=false}if(_.isNil(axisFormatting.axisValuesFormatting.numberFormatting.hideTrailingZeros)){axisFormatting.axisValuesFormatting.numberFormatting.hideTrailingZeros=getDefaultTrailingZeros(axisFormatting.axisValuesFormatting.numberFormatting)}if(_.isNil(axisFormatting.axisTitleFormatting)){axisFormatting.axisTitleFormatting={...AxisTitleFormatting};if(theme){DSSVisualizationThemeUtils.applyAxisTitleFormatting(theme,axisFormatting.axisTitleFormatting)}}if(_.isNil(axisFormatting.ticksConfig)){axisFormatting.ticksConfig={mode:AxisTicksConfigMode.INTERVAL,number:null}}if(_.isNil(axisFormatting.customExtent)||!Object.keys(axisFormatting.customExtent).length){axisFormatting.customExtent={...ChartsStaticData.DEFAULT_CUSTOM_EXTENT}}if(_.isNil(axisFormatting.includeZero)){axisFormatting.includeZero=true}});if(!chartDef.radialAxisFormatting||!chartDef.radialAxisFormatting.axisValuesFormatting||!chartDef.radialAxisFormatting.axisValuesFormatting.axisTicksFormatting){const legacyFormatting=chartDef.radialAxisFormatting&&chartDef.radialAxisFormatting.axisTitleFormatting&&_.cloneDeep(chartDef.radialAxisFormatting.axisTitleFormatting);chartDef.radialAxisFormatting={axisValuesFormatting:{axisTicksFormatting:{...AxisTitleFormatting,...legacyFormatting||{}}}};if(theme&&!legacyFormatting){DSSVisualizationThemeUtils.applyAxisValueFormatting(theme,chartDef.radialAxisFormatting.axisValuesFormatting)}}if(_.isNil(chartDef.tooltipOptions)){chartDef.tooltipOptions={display:true}}if(_.isNil(chartDef.gaugeOptions)){chartDef.gaugeOptions={min:{...DEFAULT_GAUGE_MIN_MAX},max:{...DEFAULT_GAUGE_MIN_MAX},displayPointer:false}}if(_.isNil(chartDef.gaugeOptions.min)){chartDef.gaugeOptions.min={...DEFAULT_GAUGE_MIN_MAX}}if(_.isNil(chartDef.gaugeOptions.max)){chartDef.gaugeOptions.max={...DEFAULT_GAUGE_MIN_MAX}}if(_.isNil(chartDef.gaugeOptions.min.aggregatedColumn)){chartDef.gaugeOptions.min.aggregatedColumn=null}if(_.isNil(chartDef.gaugeOptions.min.datasetColumn)){chartDef.gaugeOptions.min.datasetColumn=null}if(_.isNil(chartDef.gaugeOptions.min.customAggregation)){chartDef.gaugeOptions.min.customAggregation=null}if(_.isNil(chartDef.gaugeOptions.min.aggregation)){chartDef.gaugeOptions.min.aggregation=null}if(_.isNil(chartDef.gaugeOptions.max.aggregatedColumn)){chartDef.gaugeOptions.max.aggregatedColumn=null}if(_.isNil(chartDef.gaugeOptions.max.datasetColumn)){chartDef.gaugeOptions.max.datasetColumn=null}if(_.isNil(chartDef.gaugeOptions.max.customAggregation)){chartDef.gaugeOptions.max.customAggregation=null}if(_.isNil(chartDef.gaugeOptions.max.aggregation)){chartDef.gaugeOptions.max.aggregation=null}if(_.isNil(chartDef.gaugeOptions.axis)){chartDef.gaugeOptions.axis={ticksConfig:{mode:AxisTicksConfigMode.INTERVAL,number:null},axisValuesFormatting:{axisTicksFormatting:{...AxisTicksFormatting,fontSize:16},numberFormatting:{...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}},thickness:30};if(theme){DSSVisualizationThemeUtils.applyAxisValueFormatting(theme,chartDef.gaugeOptions.axis?.axisValuesFormatting)}}if(_.isNil(chartDef.gaugeOptions.axis.ticksConfig)){chartDef.gaugeOptions.axis.ticksConfig={mode:AxisTicksConfigMode.INTERVAL,number:null}}if(_.isNil(chartDef.gaugeOptions.axis.ticksConfigMode)){chartDef.gaugeOptions.axis.ticksConfigMode=AxisTicksConfigMode.INTERVAL}if(_.isNil(chartDef.gaugeOptions.axis.axisValuesFormatting)){chartDef.gaugeOptions.axis.axisValuesFormatting={axisTicksFormatting:{...AxisTicksFormatting,fontSize:12},numberFormatting:{...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}};if(theme){DSSVisualizationThemeUtils.applyAxisValueFormatting(theme,chartDef.gaugeOptions.axis.axisValuesFormatting)}}if(_.isNil(chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting)){chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting={...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS}}if(_.isNil(chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.digitGrouping)){chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.digitGrouping=ChartsStaticData.DEFAULT_DIGIT_GROUPING}if(_.isNil(chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.useParenthesesForNegativeValues)){chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.useParenthesesForNegativeValues=false}if(_.isNil(chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.shouldFormatInPercentage)){chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.shouldFormatInPercentage=false}if(_.isNil(chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.hideTrailingZeros)){chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting.hideTrailingZeros=getDefaultTrailingZeros(chartDef.gaugeOptions.axis.axisValuesFormatting.numberFormatting)}}function fixupNumberFormatting(formattableOptions){if(!_.isNil(formattableOptions)){formattableOptions.forEach(formattableOption=>{if(_.isNil(formattableOption.numberFormatting)){formattableOption.numberFormatting={...ChartsStaticData.DEFAULT_REFERENCE_LINES_NUMBER_FORMATTING_OPTIONS}}if(!_.isNil(formattableOption.prefix)){formattableOption.numberFormatting.prefix=formattableOption.prefix;delete formattableOption.prefix}if(!_.isNil(formattableOption.suffix)){formattableOption.numberFormatting.suffix=formattableOption.suffix;delete formattableOption.suffix}if(!_.isNil(formattableOption.multiplier)){formattableOption.numberFormatting.multiplier=formattableOption.multiplier;delete formattableOption.multiplier}})}}function ensureReferenceLinesCompatibility(chartType,chartVariant,referenceLines){if(!_.isNil(referenceLines)){referenceLines.forEach(referenceLine=>{if((chartType===CHART_TYPES.SCATTER||chartType===CHART_TYPES.SCATTER_MULTIPLE_PAIRS||chartVariant===CHART_VARIANTS.waterfall)&&referenceLine.sourceType===ValueType.AggregatedColumn){referenceLine.sourceType=ValueType.Constant;referenceLine.constantValue=undefined}})}}function fixupReferenceLines(chartDef){fixupNumberFormatting(chartDef.referenceLines)}function fixupGaugeTargets(chartDef){fixupNumberFormatting(chartDef.gaugeOptions.targets)}function fixupDynamicMeasure(dynamicMeasure){if(!dynamicMeasure){return}dynamicMeasure.aggregatedColumn&&fixPercentile(dynamicMeasure.aggregatedColumn);dynamicMeasure.datasetColumn&&fixPercentile(dynamicMeasure.datasetColumn);dynamicMeasure.customAggregation&&fixPercentile(dynamicMeasure.customAggregation)}function fixPercentile(value){if(_.isNil(value.percentile)||value.percentile===0){value.percentile=50}}function fixupPivotTableFormatting(tableFormatting,theme){if(!_.isNil(tableFormatting.rowSubheaders)){return}if(!_.isNil(tableFormatting.rowHeaders)){tableFormatting.rowSubheaders={...tableFormatting.rowHeaders};tableFormatting.freezeRowHeaders=false}else{tableFormatting.rowSubheaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor};tableFormatting.freezeRowHeaders=true}if(!_.isNil(tableFormatting.columnSubheaders)){return}if(!_.isNil(tableFormatting.columnHeaders)){tableFormatting.columnMainHeaders={...tableFormatting.columnHeaders};tableFormatting.columnSubheaders={...tableFormatting.columnHeaders}}else{tableFormatting.rowMainHeaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor};tableFormatting.columnMainHeaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor};tableFormatting.columnSubheaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor}}}function getDefaultTrailingZeros(numberFormattingOptions){return!_.isNil(numberFormattingOptions.decimalPlaces)&&numberFormattingOptions.decimalPlaces>0?false:true}function autocompleteGenericMeasure({contextualMenuMeasureType,chartDef,defaultTextFormatting,theme},measure,index,array){const chartType=chartDef.type;if(!ChartLabels.aggregationIsSupported(measure.function,measure.type,chartType,contextualMenuMeasureType)){measure.function="COUNT"}if(measure.isUnaggregated&&!ChartFeatures.canUseUnaggregatedMeasures(chartDef,measure.column,measure.type,measure.displayType,contextualMenuMeasureType)){measure.isUnaggregated=false}if(measure.isA!=="measure"){Assert.trueish(measure.type,"no measure type");const col=measure.column;const type=measure.type;const measureFn=measure.function;const measureInferredType=measure.inferredType;clear(measure);if(col==="__COUNT__"){measure.column=null;measure.function="COUNT"}else if(type==="ALPHANUM"){measure.column=col;measure.function="COUNTD"}else if(type==="DATE"){measure.column=col;measure.function="COUNT"}else if(type==="CUSTOM"){measure.column=col;measure.function="CUSTOM";measure.customFunction=measureFn;measure.inferredType=measureInferredType}else{measure.column=col;measure.function=chartDef.variant===CHART_VARIANTS.waterfall?"SUM":"AVG"}measure.type=type;measure.displayed=true;measure.displayAxis="axis1";measure.displayType=chartDef.type==CHART_TYPES.MULTI_COLUMNS_LINES&&array.some(m=>m.displayType==="column")?"line":"column";measure.isA="measure";measure.percentile=50;measure.valueTextFormatting={...DEFAULT_FONT_FORMATTING};measure.labelTextFormatting={fontColor:"#333333",fontSize:15};measure.prefix="";measure.suffix="";measure.decimalPlaces=null;measure.digitGrouping=ChartsStaticData.DEFAULT_DIGIT_GROUPING;measure.useParenthesesForNegativeValues=false;measure.shouldFormatInPercentage=false;measure.hideTrailingZeros=getDefaultTrailingZeros(measure);measure.multiplier=ChartsStaticData.DEFAULT_MULTIPLIER;const textFormatting=defaultTextFormatting||computeGenericMeasureInitialValuesInChartDisplayTextFormattingOptions(chartDef);let spacing=12;switch(chartDef.type){case CHART_TYPES.GROUPED_COLUMNS:spacing=2;break;case CHART_TYPES.MULTI_COLUMNS_LINES:spacing=5;break;case CHART_TYPES.LINES:spacing=12;break;default:break}const otherComputedProperties=computeGenericMeasureInitialValuesInChartDisplayOptions(chartDef);measure.valuesInChartDisplayOptions={displayValues:chartType!==CHART_TYPES.TREEMAP,textFormatting:textFormatting,additionalMeasures:[],addDetails:false,placementMode:ValuesInChartPlacementMode.AUTO,spacing:spacing,...otherComputedProperties};if(theme){DSSVisualizationThemeUtils.applyToMeasure(chartType,measure,theme)}}if(_.isNil(measure.isUnaggregated)){measure.isUnaggregated=chartDef.type===CHART_TYPES.GROUPED_COLUMNS&&chartDef.variant===CHART_VARIANTS.waterfall}const availableModes=Object.keys(ChartLabels.getAvailableUnaggregatedModesLabels(measure,chartDef,contextualMenuMeasureType));if(_.isNil(measure.uaComputeMode)||availableModes.length>0&&!availableModes.includes(measure.uaComputeMode)){measure.uaComputeMode=availableModes[0]}if(!measure.$id){measure.$id=generateUniqueId()}fixPercentile(measure);const measureComputationModes=ChartFeatures.getMeasureComputationModes(chartDef);const modeEnabled=measureComputationModes.some(m=>m[0]===measure.computeMode);if(!modeEnabled){measure.computeMode="NORMAL"}}function fixupStackedColumnsOptions(chartDef,theme){if(ChartFeatures.canDisplayTotalValues(chartDef)){if(_.isNil(chartDef.stackedColumnsOptions)){chartDef.stackedColumnsOptions={totalsInChartDisplayOptions:{textFormatting:chartDef.valuesInChartDisplayOptions.textFormatting,additionalMeasures:[],addDetails:false}}}if(_.isNil(chartDef.stackedColumnsOptions.totalsInChartDisplayOptions)){chartDef.stackedColumnsOptions.totalsInChartDisplayOptions={textFormatting:chartDef.valuesInChartDisplayOptions.textFormatting,additionalMeasures:[],addDetails:false}}if(_.isNil(chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.additionalMeasures)){chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.additionalMeasures=[]}if(_.isNil(chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.spacing)){chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.spacing=5}chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.additionalMeasures.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"valuesInChart",chartDef:chartDef,defaultTextFormatting:chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.textFormatting,theme:theme}))}}function autocompleteHierarchyDimensions(chartDef,hierarchy,listKey){if(!hierarchy.id){hierarchy.id=_.uniqueId(`${Date.now().toString()}_`)}if(_.isNil(hierarchy.level)){hierarchy.level=ChartHierarchyDimension.getHierarchyFirstUsableDimensionIdx(chartDef.$chartStoreId,hierarchy)}if(!hierarchy.selectedValues){hierarchy.selectedValues={}}if(!hierarchy.filterIds){hierarchy.filterIds={}}hierarchy.dimensions.forEach(dimension=>{dimension.hierarchyId=hierarchy.id;autocompleteGenericDimension(chartDef,dimension,listKey)})}function clearGenericOrHierarchyDimension(chartDef,changedDefinition,dimensionPropName,hierarchyPropName){if(changedDefinition&&changedDefinition.name===dimensionPropName&&changedDefinition.nv.length){chartDef[hierarchyPropName]=[]}if(changedDefinition&&changedDefinition.name===hierarchyPropName&&changedDefinition.nv.length){chartDef[dimensionPropName]=[]}}function purgeHierarchyFilters(chartDef){const hierarchyProps=ChartsStaticData.HIERARCHY_DIMENSIONS_PROPERTIES;let existingHierarchyFilters=[];hierarchyProps.forEach(prop=>{chartDef[prop].forEach(hierarchy=>{const hierarchyFilters=Object.keys(hierarchy.filterIds).map(key=>hierarchy.filterIds[key]);existingHierarchyFilters=[...existingHierarchyFilters,...hierarchyFilters]})});chartDef.filters=chartDef.filters.filter(filter=>!filter.hierarchyId||existingHierarchyFilters.includes(filter.id))}function autocompleteGenericDimension(chartDef,dimension,listKey){if(dimension.isA!=="dimension"){Assert.trueish(dimension.column,"no dimension column");Assert.trueish(dimension.type,"no dimension type");const col=dimension.column;const type=dimension.type;const maxValues=dimension.maxValues;const dateParams=dimension.dateParams;clear(dimension);dimension.column=col;dimension.type=type;if(dimension.type==="DATE"){dimension.numParams={emptyBinsMode:"AVERAGE"};dimension.dateParams={mode:ChartsStaticData.defaultDateMode.value,...dateParams}}else if(dimension.type==="NUMERICAL"){const cdt=chartDef.type;const isMainDimension=[CHART_TYPES.GROUPED_COLUMNS,CHART_TYPES.STACKED_BARS,CHART_TYPES.STACKED_COLUMNS].includes(cdt)&&(dimension===chartDef.genericDimension0[0]||chartDef.genericHierarchyDimension[0]&&chartDef.genericHierarchyDimension[0].dimensions.includes(dimension));const nbBins=ChartDimension.getNumericalBinNumber(cdt,isMainDimension);dimension.numParams={mode:"FIXED_NB",nbBins:nbBins,binSize:100,emptyBinsMode:"ZEROS"};dimension.maxValues=100}else if(dimension.type==="ALPHANUM"){dimension.numParams={emptyBinsMode:"ZEROS"};dimension.maxValues=maxValues?maxValues:20}dimension.generateOthersCategory=true;dimension.filters=[];dimension.isA="dimension";if(dimension.type==="GEOPOINT"&&chartDef.type.find("_map")<0){chartDef.type=CHART_TYPES.GRID_MAP}if(dimension.type==="GEOMETRY"&&chartDef.type.find("_map")<0){chartDef.type=CHART_TYPES.GRID_MAP}if(listKey==="genericDimension1"&&ChartFeatures.canIgnoreEmptyBinsForColorDimension(chartDef)&&(chartDef.genericDimension0.length===1||chartDef.genericHierarchyDimension.length===1)&&ChartDimension.getGenericDimension(chartDef).column===dimension.column){dimension.ignoreEmptyBins=true}dimension.digitGrouping=ChartsStaticData.DEFAULT_DIGIT_GROUPING;dimension.useParenthesesForNegativeValues=false;dimension.shouldFormatInPercentage=false;dimension.hideTrailingZeros=getDefaultTrailingZeros(dimension);dimension.multiplier=ChartsStaticData.DEFAULT_MULTIPLIER;dimension.oneTickPerBin="AUTO";dimension.useLastValueAsTotal=false}if(ChartDimension.isUngroupedNumerical(dimension)&&!ChartFeatures.canUseNonGroupingMode(chartDef,listKey)){dimension.numParams.mode="FIXED_NB"}if(!dimension.$id){dimension.$id=generateUniqueId()}}const svc={autocompleteUA:autocompleteUA,autocompleteGenericDimension:autocompleteGenericDimension,onChartTypeChange:function(chartDef,newType,newVariant,newWebAppType){Logger.info("Start type change:"+JSON.stringify(chartDef));let existingMeasures;let existingDimensions;let existingPrimaryDimensions;let existingSecondaryDimensions;let allMeasures;let allDimensions;let allUA;const oldType=chartDef.type;ChartAxesUtils.resetCustomExtents([chartDef.xAxisFormatting]);ChartAxesUtils.resetCustomExtents(chartDef.yAxesFormatting);if(oldType===CHART_TYPES.GEOMETRY_MAP){retrieveOptionsFromGeomMap(chartDef);retrieveGeoFromGeomMap(chartDef);chartDef.geoLayers=[svc.newEmptyGeoPlaceholder(0)]}ensureReferenceLinesCompatibility(newType,newVariant,chartDef.referenceLines);switch(newType){case CHART_TYPES.MULTI_COLUMNS_LINES:case CHART_TYPES.GROUPED_COLUMNS:case CHART_TYPES.STACKED_COLUMNS:case CHART_TYPES.STACKED_BARS:case CHART_TYPES.LINES:case CHART_TYPES.STACKED_AREA:existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["genericDimension0","genericHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions);existingDimensions=[...existingPrimaryDimensions,...existingSecondaryDimensions];if(existingDimensions.length&&ChartFeatures.canUseSecondGenericDimension({...chartDef,type:newType,variant:newVariant,webAppType:newWebAppType})){chartDef.genericDimension1=existingDimensions.splice(0,1)}existingMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);chartDef.tooltipMeasures=getAttributeAndRemove(existingMeasures,COLUMN_TYPE_ORDER.tooltip,true);if(has(chartDef.genericDimension0)||has(chartDef.genericHierarchyDimension)){if(ChartFeatures.canSupportMultipleGenericMeasures({...chartDef,type:newType,variant:newVariant,webAppType:newWebAppType})){chartDef.genericMeasures=existingMeasures}else{chartDef.genericMeasures=existingMeasures.slice(0,1)}}break;case CHART_TYPES.PIE:existingMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);if(existingMeasures.length>=1){chartDef.genericMeasures=existingMeasures.slice(0,1)}ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["genericDimension0","genericHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions);break;case CHART_TYPES.SCATTER:case CHART_TYPES.HEATMAP:existingDimensions=ChartTypeChangeUtils.takeAllExistingDimensions(chartDef);setSingleIfHasEnough(existingDimensions,chartDef.uaXDimension,0);setSingleIfHasEnough(existingDimensions,chartDef.uaYDimension,1);ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);allUA=ChartTypeChangeUtils.takeAllUAWithMeasures(chartDef);if([CHART_TYPES.SCATTER,CHART_TYPES.HEATMAP].includes(chartDef.type)){chartDef.uaColor=getAttributeAndRemove(allUA,COLUMN_TYPE_ORDER.color);chartDef.uaSize=getAttributeAndRemove(allUA,COLUMN_TYPE_ORDER.size);chartDef.uaTooltip=allUA}else{const acceptedScaleFirst=allUA.sort((a,b)=>svc.scatterAcceptScaleMeasure(b).accept-svc.scatterAcceptScaleMeasure(a).accept);if(acceptedScaleFirst.length&&svc.scatterAcceptScaleMeasure(acceptedScaleFirst[0]).accept){setSingleIfHasEnough(acceptedScaleFirst,chartDef.uaSize,0);setSingleIfHasEnough(acceptedScaleFirst,chartDef.uaColor,1)}else{setSingleIfHasEnough(allUA,chartDef.uaColor,0)}chartDef.uaTooltip=allUA.slice(2)}break;case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:existingDimensions=ChartTypeChangeUtils.takeAllExistingDimensions(chartDef);if(existingDimensions.length){chartDef.uaDimensionPair=[{uaXDimension:[],uaYDimension:[]}];const possibleXDimensions=existingDimensions.filter(d=>svc.scatterMPAccept(d,chartDef,"x",0).accept);const possibleYDimensions=existingDimensions.filter(d=>svc.scatterMPAccept(d,chartDef,"y",0).accept&&(!possibleXDimensions[0]||possibleXDimensions[0].column!==d.column));setSingleIfHasEnough(possibleXDimensions,chartDef.uaDimensionPair[0].uaXDimension,0);setSingleIfHasEnough(possibleYDimensions,chartDef.uaDimensionPair[0].uaYDimension,0)}ChartTypeChangeUtils.takeAllUAWithMeasures(chartDef);ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.GROUPED_XY:existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["groupDimension","groupHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions);allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);setSingleIfHasEnough(allMeasures,chartDef.xMeasure,0);setSingleIfHasEnough(allMeasures,chartDef.yMeasure,1);setSingleIfHasEnough(allMeasures,chartDef.sizeMeasure,2);setSingleIfHasEnough(allMeasures,chartDef.colorMeasure,3);break;case CHART_TYPES.BINNED_XY:existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef).filter(d=>svc.binnedXYAcceptDimensionOrHierarchy(newVariant,d).accept);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef).filter(d=>svc.binnedXYAcceptDimensionOrHierarchy(newVariant,d).accept);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["xDimension","xHierarchyDimension"],["yDimension","yHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions,newVariant!==CHART_VARIANTS.binnedXYHexagon);allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);if(newType===oldType){chartDef.colorMeasure=getAttributeAndRemove(allMeasures,COLUMN_TYPE_ORDER.color);chartDef.sizeMeasure=getAttributeAndRemove(allMeasures,COLUMN_TYPE_ORDER.size);chartDef.tooltipMeasures=allMeasures}else{setSingleIfHasEnough(allMeasures,chartDef.colorMeasure,0);setSingleIfHasEnough(allMeasures,chartDef.sizeMeasure,1);chartDef.tooltipMeasures=allMeasures.slice(2)}break;case CHART_TYPES.PIVOT_TABLE:existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["xDimension","xHierarchyDimension"],["yDimension","yHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions);allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasureWithAlphanumResults(m).accept);chartDef.genericMeasures=allMeasures;break;case CHART_TYPES.SCATTER_MAP:case CHART_TYPES.DENSITY_HEAT_MAP:case CHART_TYPES.HEATMAP_MAP:allUA=ChartTypeChangeUtils.takeAllUAWithMeasures(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);if([CHART_TYPES.SCATTER_MAP,CHART_TYPES.DENSITY_HEAT_MAP,CHART_TYPES.HEATMAP_MAP,CHART_TYPES.GEOMETRY_MAP,CHART_TYPES.GRID_MAP].includes(oldType)){chartDef.uaColor=getAttributeAndRemove(allUA,COLUMN_TYPE_ORDER.color);chartDef.uaSize=getAttributeAndRemove(allUA,COLUMN_TYPE_ORDER.size);chartDef.uaTooltip=allUA}else{setSingleIfHasEnough(allUA,chartDef.uaSize,0);setSingleIfHasEnough(allUA,chartDef.uaColor,1);chartDef.uaTooltip=allUA.slice(2)}ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.GEOMETRY_MAP:allUA=ChartTypeChangeUtils.takeAllUAWithMeasures(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);chartDef.uaColor=getAttributeAndRemove(allUA,COLUMN_TYPE_ORDER.color);chartDef.uaSize=getAttributeAndRemove(allUA,COLUMN_TYPE_ORDER.size);chartDef.uaTooltip=allUA;migrateToGeomMap(chartDef);ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.GROUPED_SCATTER_MAP:if(!has(chartDef.groupDimension)){allDimensions=ChartTypeChangeUtils.takeAllExistingDimensions(chartDef);setSingleIfHasEnough(allDimensions,chartDef.groupDimension,0)}allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);if(newType===oldType){chartDef.colorMeasure=getAttributeAndRemove(allMeasures,COLUMN_TYPE_ORDER.color);chartDef.sizeMeasure=getAttributeAndRemove(allMeasures,COLUMN_TYPE_ORDER.size);chartDef.tooltipMeasures=allMeasures}else{setSingleIfHasEnough(allMeasures,chartDef.sizeMeasure,0);setSingleIfHasEnough(allMeasures,chartDef.colorMeasure,1);chartDef.tooltipMeasures=allMeasures.slice(2)}ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.GRID_MAP:allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);setSingleIfHasEnough(allMeasures,chartDef.colorMeasure,0);chartDef.tooltipMeasures=allMeasures.slice(1);ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.ADMINISTRATIVE_MAP:allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);if(newType===oldType){chartDef.colorMeasure=getAttributeAndRemove(allMeasures,COLUMN_TYPE_ORDER.color);chartDef.sizeMeasure=getAttributeAndRemove(allMeasures,COLUMN_TYPE_ORDER.size);chartDef.tooltipMeasures=allMeasures}else{setSingleIfHasEnough(allMeasures,chartDef.sizeMeasure,0);setSingleIfHasEnough(allMeasures,chartDef.colorMeasure,1);chartDef.tooltipMeasures=allMeasures.slice(2)}ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.TREEMAP:allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasure(m).accept);setSingleIfHasEnough(allMeasures,chartDef.genericMeasures,0);setSingleIfHasEnough(allMeasures,chartDef.colorMeasure,1);existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["yDimension","yHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions,true,true);break;case CHART_TYPES.DENSITY_2D:existingDimensions=ChartTypeChangeUtils.takeAllExistingDimensions(chartDef).filter(d=>svc.density2dAccept(d).accept);setSingleIfHasEnough(existingDimensions,chartDef.xDimension,0);setSingleIfHasEnough(existingDimensions,chartDef.yDimension,1);ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.GAUGE:ChartTypeChangeUtils.takeAllExistingDimensions(chartDef);existingMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef);existingMeasures=existingMeasures.filter(m=>svc.stdAggregatedAcceptMeasureWithAlphanumResults(m).accept);setSingleIfHasEnough(existingMeasures,chartDef.genericMeasures,0);ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.KPI:ChartTypeChangeUtils.takeAllExistingDimensions(chartDef);existingMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef);chartDef.genericMeasures=existingMeasures.filter(m=>svc.stdAggregatedAcceptMeasureWithAlphanumResults(m).accept);ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.RADAR:existingMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasureWithAlphanumResults(m).accept);chartDef.genericMeasures=existingMeasures;existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["genericDimension0","genericHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions);break;case CHART_TYPES.SANKEY:existingMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasureWithAlphanumResults(m).accept);setSingleIfHasEnough(existingMeasures,chartDef.genericMeasures,0);existingDimensions=ChartTypeChangeUtils.takeAllExistingDimensions(chartDef);chartDef.yDimension=existingDimensions;ChartTypeChangeUtils.takeAllExistingHierarchies(chartDef);break;case CHART_TYPES.BOXPLOTS:existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["boxplotBreakdownDim","boxplotBreakdownHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions);existingDimensions=[...existingPrimaryDimensions,...existingSecondaryDimensions];if(existingDimensions.length){chartDef.genericDimension1=existingDimensions.splice(0,1)}allUA=ChartTypeChangeUtils.takeAllUAWithMeasures(chartDef).filter(m=>svc.boxplotsAcceptMeasure(m).accept);setSingleIfHasEnough(allUA,chartDef.boxplotValue,0);break;case CHART_TYPES.LIFT:existingPrimaryDimensions=ChartTypeChangeUtils.takeAllExistingPrimaryDimensions(chartDef);existingSecondaryDimensions=ChartTypeChangeUtils.takeAllExistingSecondaryDimensions(chartDef);ChartTypeChangeUtils.setDimensionsOrHierarachies(chartDef,[["groupDimension","groupHierarchyDimension"]],existingPrimaryDimensions,existingSecondaryDimensions);allMeasures=ChartTypeChangeUtils.takeAllMeasuresWithUA(chartDef).filter(m=>svc.stdAggregatedAcceptMeasureWithAlphanumResults(m).accept);setSingleIfHasEnough(allMeasures,chartDef.xMeasure,0);setSingleIfHasEnough(allMeasures,chartDef.yMeasure,1);break;case CHART_TYPES.WEBAPP:break;case CHART_TYPES.NUMERICAL_HEATMAP:default:throw Error("unimplemented chart type : "+newType)}if(!ChartFeatures.canAnimate(newType)){chartDef.animationDimension.length=0}if(!ChartFeatures.canFacet(newType,newWebAppType)){chartDef.facetDimension.length=0}},stdAggregatedAcceptDimensionOrHierarchy:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isCount(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NO_AGGR_ON_COUNT_REC)}if(ChartColumnTypeUtils.isGeoColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.GEO_DATA)}if(ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_CUSTOM_COL)}return accept()},stdAggregatedAcceptDimension:function(data){if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}return svc.stdAggregatedAcceptDimensionOrHierarchy(data)},stdAggregatedAcceptMeasure:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}if(ChartColumnTypeUtils.isRBND(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_RBND)}if(ChartColumnTypeUtils.isGeoColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.GEO_DATA)}if(ChartColumnTypeUtils.isDateColumnType(data.type)){return accept()}if(ChartColumnTypeUtils.isCustomMeasureAndNonNumerical(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_NUM_CUSTOM_COL)}if(!ChartColumnTypeUtils.isNumericalColumnType(data.type)&&!ChartColumnTypeUtils.isAlphanumColumnType(data.type)&&!ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_NUM_ALPHA)}return accept()},stdAggregatedAcceptMeasureWithAlphanumResults:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}if(ChartColumnTypeUtils.isRBND(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_RBND)}if(ChartColumnTypeUtils.isGeoColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.GEO_DATA)}if(ChartColumnTypeUtils.isDateColumnType(data.type)){return accept()}if(!ChartColumnTypeUtils.isNumericalColumnType(data.type)&&!ChartColumnTypeUtils.isAlphanumColumnType(data.type)&&!ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_NUM_ALPHA)}if(ChartMeasure.isRealUnaggregatedMeasure(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_AGGR_MEASURE)}return accept()},uaTooltipAccept:function(data){if(ChartColumnTypeUtils.isCount(data)){return reject(`${ChartLabels.CHART_ERROR_MESSAGES.COUNT_REC} in tooltips`)}if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}if(ChartColumnTypeUtils.isRBND(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_RBND)}if(ChartColumnTypeUtils.isGeoColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.GEO_DATA)}if(ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_CUSTOM_COL)}return accept()},scatterAccept:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}if(ChartColumnTypeUtils.isRBND(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_RBND)}if(ChartColumnTypeUtils.isCount(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.COUNT_REC)}if(ChartColumnTypeUtils.isGeoColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.GEO_DATA)}if(ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_CUSTOM_COL)}return accept()},scatterMPAccept:function(data,chartDef,dimension,pairIndex){const index=parseInt(pairIndex);const{firstXDim,firstXDimIndex}=svc.getScatterFirstXDims(chartDef.uaDimensionPair,index);if(dimension==="x"){if(!_.isNil(firstXDim)&&firstXDimIndex!==index){const sameType=ChartColumnTypeUtils.isSameColumnType(data,firstXDim);if(!sameType){return reject(ChartLabels.CHART_ERROR_MESSAGES.COL_TYPE_X)}}if(ChartColumnTypeUtils.isAlphanumColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.SCATTER_MP_ALPHANUM_X)}return svc.scatterAccept(data)}return svc.scatterAccept(data)},scatterAcceptScaleMeasure:function(data){if(ChartColumnTypeUtils.isAlphanumColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.SCATTER_SCALE_NON_NUM)}return svc.scatterAccept(data)},densityMapAcceptScaleMeasure:function(data){return svc.scatterAcceptScaleMeasure(data)},acceptGeo:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isGeoColumnType(data.type)){return accept()}else{return reject(ChartLabels.CHART_ERROR_MESSAGES.ONLY_GEO)}},density2dAccept:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}if(ChartColumnTypeUtils.isRBND(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_RBND)}if(ChartColumnTypeUtils.isCount(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.COUNT_REC)}if(ChartColumnTypeUtils.isNumericalColumnType(data.type)||ChartColumnTypeUtils.isDateColumnType(data.type)){return accept()}else{return reject(ChartLabels.CHART_ERROR_MESSAGES.DENSITY_NUM_OR_DATE)}},boxplotsAcceptBreakdown:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isCount(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.COUNT_REC)}if(ChartColumnTypeUtils.isGeoColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.GEO_DATA)}if(ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_CUSTOM_COL)}if(ChartColumnTypeUtils.isRBND(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_RBND)}return accept()},boxplotsAcceptColorDimension:function(data){if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}return svc.boxplotsAcceptBreakdown(data)},boxplotsAcceptMeasure:function(data){if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}if(ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_CUSTOM_COL)}if(!ChartColumnTypeUtils.isNumericalColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_NUM_COL)}if(ChartColumnTypeUtils.isCount(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.COUNT_REC)}if(ChartColumnTypeUtils.isRBND(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_RBND)}return accept()},binnedXYAcceptDimensionOrHierarchy:function(chartVariant,data){Assert.trueish(chartVariant,"no chartDef variant");if(ChartColumnTypeUtils.isNonColumnData(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_COL_DATA)}if(chartVariant===CHART_VARIANTS.binnedXYHexagon&&ChartColumnTypeUtils.isHierarchy(data)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HIERARCHY)}if(chartVariant===CHART_VARIANTS.binnedXYHexagon&&!ChartColumnTypeUtils.isNumericalColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.HEX_BINNING_DIM)}if(ChartColumnTypeUtils.isCustomColumnType(data.type)){return reject(ChartLabels.CHART_ERROR_MESSAGES.NON_CUSTOM_COL)}return svc.stdAggregatedAcceptDimensionOrHierarchy(data)},getScatterFirstXDims(pairs,pairIndex){let firstXDim;let firstXDimIndex;for(let i=0;i<pairs.length;i++){if(i!==pairIndex){if(pairs[i].uaXDimension&&pairs[i].uaXDimension.length&&_.isNil(firstXDim)){firstXDim=pairs[i].uaXDimension[0];firstXDimIndex=i}if(!_.isNil(firstXDim)){return{firstXDim:firstXDim,firstXDimIndex:firstXDimIndex}}}}return{firstXDim:firstXDim,firstXDimIndex:firstXDimIndex}},computeAutoName:function(chartDef){function getAutoNameMeasureLabel(measure){return measure.function==="COUNT"?"Count":ChartLabels.getShortMeasureLabel(measure,false)}function addGM0L(){if(has(chartDef.genericMeasures)){newName+=getAutoNameMeasureLabel(chartDef.genericMeasures[0])}}function sdl(d){return d.column}function sml(m){return getAutoNameMeasureLabel(m[0])}let dimensionPairs;let newName="";let genericDimension,xDimension,yDimension,groupDimension,breakdownDimension;switch(chartDef.type){case CHART_TYPES.MULTI_COLUMNS_LINES:case CHART_TYPES.GROUPED_COLUMNS:case CHART_TYPES.STACKED_COLUMNS:case CHART_TYPES.STACKED_BARS:case CHART_TYPES.LINES:case CHART_TYPES.STACKED_AREA:case CHART_TYPES.PIE:genericDimension=ChartDimension.getGenericDimension(chartDef);if(genericDimension&&!has(chartDef.genericDimension1)){addGM0L();newName+=" by ";newName+=ChartLabels.getDimensionLabel(genericDimension,false)}else if(genericDimension&&has(chartDef.genericDimension1)){addGM0L();newName+=" by ";newName+=ChartLabels.getDimensionLabel(genericDimension,false);newName+=" and ";newName+=ChartLabels.getDimensionLabel(chartDef.genericDimension1[0],false)}break;case CHART_TYPES.PIVOT_TABLE:xDimension=ChartDimension.getXDimension(chartDef,"x");yDimension=ChartDimension.getYDimension(chartDef,"y");if((xDimension||yDimension)&&has(chartDef.genericMeasures)){addGM0L();let i=0;[xDimension,yDimension].forEach(dimension=>{if(dimension){newName+=[" by "," and "][i];newName+=sdl(dimension);i++}})}break;case CHART_TYPES.RADAR:genericDimension=ChartDimension.getGenericDimension(chartDef);if(genericDimension&&has(chartDef.genericMeasures)){chartDef.genericMeasures.forEach((dim,i)=>{newName+=dim.column;if(i===chartDef.genericMeasures.length-2){newName+=" and "}else if(i<chartDef.genericMeasures.length-1){newName+=", "}});newName+=" by "+ChartLabels.getDimensionLabel(genericDimension,false)}break;case CHART_TYPES.TREEMAP:yDimension=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"y");yDimension=yDimension?[yDimension]:has(chartDef.yDimension)?chartDef.yDimension:[];if(yDimension.length&&has(chartDef.genericMeasures)){addGM0L();newName+=" by ";yDimension.forEach((dim,i)=>{newName+=dim.column;if(i===yDimension.length-2){newName+=" and "}else if(i<yDimension.length-1){newName+=", "}})}break;case CHART_TYPES.BINNED_XY:xDimension=ChartDimension.getXDimension(chartDef);yDimension=ChartDimension.getYDimension(chartDef);if(xDimension&&yDimension){newName+=sdl(xDimension)+" vs "+sdl(yDimension)+" (aggregated)"}break;case CHART_TYPES.GROUPED_XY:groupDimension=ChartDimension.getGroupDimension(chartDef);if(has(chartDef.xMeasure)&&has(chartDef.yMeasure)&&groupDimension){newName+=sml(chartDef.xMeasure)+" / "+sml(chartDef.yMeasure)+" by "+sdl(groupDimension)}break;case CHART_TYPES.SCATTER:newName=`${sdl(chartDef.uaXDimension[0])} vs ${sdl(chartDef.uaYDimension[0])}`;break;case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:dimensionPairs=ChartUADimension.getDisplayableDimensionPairs(chartDef.uaDimensionPair);newName=`${sdl(ChartUADimension.getPairUaXDimension(dimensionPairs,dimensionPairs[0])[0])} vs ${sdl(dimensionPairs[0].uaYDimension[0])}`;break;case CHART_TYPES.GAUGE:case CHART_TYPES.KPI:addGM0L();break;case CHART_TYPES.WEBAPP:newName=chartDef.$loadedDesc.desc.meta.label||CHART_TYPES.WEBAPP;break;case CHART_TYPES.BOXPLOTS:newName+=ChartLabels.getDimensionLabel(chartDef.boxplotValue[0],false);breakdownDimension=ChartDimension.getBreakdownDimension(chartDef);if(breakdownDimension&&!has(chartDef.genericDimension1)){newName+=" by ";newName+=ChartLabels.getDimensionLabel(breakdownDimension,false)}else if(breakdownDimension&&has(chartDef.genericDimension1)){addGM0L();newName+=" by ";newName+=ChartLabels.getDimensionLabel(breakdownDimension,false);newName+=" and ";newName+=ChartLabels.getDimensionLabel(chartDef.genericDimension1[0],false)}break}return newName},getValidity:function(chart){const chartDef=chart.def;function ok(){return{valid:true}}function incomplete(message){return{valid:false,type:"INCOMPLETE",message:message}}function invalid(message){return{valid:false,type:"INVALID",message:message}}function isGeometryMapComplete(geoLayers){return geoLayers.some(geoLayer=>geoLayer.geometry&&geoLayer.geometry.length>0)}switch(chartDef.type){case CHART_TYPES.MULTI_COLUMNS_LINES:case CHART_TYPES.GROUPED_COLUMNS:case CHART_TYPES.STACKED_COLUMNS:case CHART_TYPES.STACKED_BARS:case CHART_TYPES.LINES:case CHART_TYPES.STACKED_AREA:case CHART_TYPES.PIE:if(!has(chartDef.genericDimension0)&&!has(chartDef.genericHierarchyDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_GROUP)}if(!has(chartDef.genericMeasures)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.WHAT_TO_SHOW)}if(chartDef.type===CHART_TYPES.STACKED_COLUMNS||chartDef.type===CHART_TYPES.STACKED_BARS){if(chartDef.variant==="stacked_100"){if(!has(chartDef.genericDimension1)&&chartDef.genericMeasures.length===1){return invalid(ChartLabels.CHART_ERROR_MESSAGES.STACKED_100_COLS)}}}return ok();case CHART_TYPES.PIVOT_TABLE:if(!has(chartDef.genericMeasures)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.WHAT_TO_SHOW)}return ok();case CHART_TYPES.BINNED_XY:if(!has(chartDef.xDimension)&&!has(chartDef.xHierarchyDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_X_AXIS)}if(!has(chartDef.yDimension)&&!has(chartDef.yHierarchyDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_Y_AXIS)}if(chartDef.variant===CHART_VARIANTS.binnedXYHexagon){if(!ChartDimension.isTrueNumerical(chartDef.xDimension[0])||!ChartDimension.isTrueNumerical(chartDef.yDimension[0])){return invalid(ChartLabels.CHART_ERROR_MESSAGES.HEX_BINNING_DIM)}if(!ChartDimension.isTrueNumerical(chartDef.xDimension[0])||!ChartDimension.isTrueNumerical(chartDef.yDimension[0])){return invalid(ChartLabels.CHART_ERROR_MESSAGES.HEX_BINNING_DIM)}}return ok();case CHART_TYPES.GROUPED_XY:case CHART_TYPES.LIFT:if(!has(chartDef.groupDimension)&&!has(chartDef.groupHierarchyDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_GROUP)}if(!has(chartDef.xMeasure)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.LIFT_GIVE_X_AXIS)}if(!has(chartDef.yMeasure)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.LIFT_GIVE_Y_AXIS)}return ok();case CHART_TYPES.DENSITY_2D:if(!has(chartDef.xDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_X_AXIS)}if(!has(chartDef.yDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_Y_AXIS)}return ok();case CHART_TYPES.SCATTER:if(!has(chartDef.uaXDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_X_AXIS)}if(!has(chartDef.uaYDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_Y_AXIS)}return ok();case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:if(!ChartUADimension.getDisplayableDimensionPairs(chartDef.uaDimensionPair).length){if(!chartDef.uaDimensionPair||!chartDef.uaDimensionPair.length||!has(chartDef.uaDimensionPair[0].uaXDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_X_AXIS)}if(!has(chartDef.uaDimensionPair[0].uaYDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_Y_AXIS)}}return ok();case CHART_TYPES.BOXPLOTS:if(!has(chartDef.boxplotValue)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.WHAT_TO_SHOW)}return ok();case CHART_TYPES.GAUGE:if(!has(chartDef.genericMeasures)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.WHAT_TO_SHOW)}if(chartDef.genericMeasures.length>1){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GAUGE_ONLY_ONE)}return ok();case CHART_TYPES.KPI:if(!has(chartDef.genericMeasures)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.WHAT_TO_SHOW)}return ok();case CHART_TYPES.RADAR:if(!has(chartDef.genericDimension0)&&!has(chartDef.genericHierarchyDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_GROUP)}if(!has(chartDef.genericMeasures)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.WHAT_TO_SHOW)}return ok();case CHART_TYPES.SANKEY:if(!has(chartDef.yDimension)||chartDef.yDimension.length<2){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.TWO_LEVELS)}if(!has(chartDef.genericMeasures)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.SANKEY_GIVE_COL)}return ok();case CHART_TYPES.SCATTER_MAP:case CHART_TYPES.DENSITY_HEAT_MAP:case CHART_TYPES.ADMINISTRATIVE_MAP:case CHART_TYPES.GRID_MAP:if(!has(chartDef.geometry)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_GEO_COL)}return ok();case CHART_TYPES.GEOMETRY_MAP:if(!isGeometryMapComplete(chartDef.geoLayers)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_GEO_COL)}return ok();case CHART_TYPES.TREEMAP:if(!has(chartDef.yDimension)&&!has(chartDef.yHierarchyDimension)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.GIVE_GROUP)}if(!has(chartDef.genericMeasures)){return incomplete(ChartLabels.INCOMPLETE_CHART_LABELS.TREEMAP_GIVE_NUM_COL)}return ok();case CHART_TYPES.WEBAPP:return ok();default:throw Error("unimplemented handling of "+chartDef.type)}},hasPivotTableReachThreshold:function(chartDef,data){return chartDef.type===CHART_TYPES.PIVOT_TABLE&&data&&data.errorType==="com.dataiku.dip.pivot.backend.model.SecurityAbortedException"},hasCorruptedLinoCacheWarning:function(data){return data&&data.errorType==="com.dataiku.dip.pivot.backend.model.CorruptedDataException"},hasEmptyCustomBins:function(data){return data&&data.errorType==="com.dataiku.dip.pivot.backend.model.EmptyCustomBinsException"},hasRequestResponseWarning:function(chartDef,data){return this.hasPivotTableReachThreshold(chartDef,data)||this.hasCorruptedLinoCacheWarning(data)||this.hasEmptyCustomBins(data)},getRequestResponseWarning:function(chartDef,data){if(this.hasPivotTableReachThreshold(chartDef,data)){return{valid:false,type:"PIVOT_TABLE_TOO_MUCH_DATA",message:data.message}}else if(this.hasCorruptedLinoCacheWarning(data)){return{valid:false,type:"CORRUPTED_LINO_CACHE",message:data.message}}else if(this.hasEmptyCustomBins(data)){return{valid:false,type:"EMPTY_CUSTOM_BINS",message:data.message}}},fixupSpec:function(chart,theme,changedDefinition){const chartDef=chart.def;const usableColumns=chart.summary&&chart.summary.usableColumns;Logger.info("Fixing up the spec: "+JSON.stringify(chartDef));if(chartDef.type===CHART_TYPES.WEBAPP){chartDef.webAppConfig=chartDef.webAppConfig||{};chartDef.$loadedDesc=WebAppsService.getWebAppLoadedDesc(chartDef.webAppType)||{};chartDef.$pluginDesc=WebAppsService.getOwnerPluginDesc(chartDef.webAppType);chartDef.$pluginChartDesc=chartDef.$loadedDesc.desc.chart;PluginConfigUtils.setDefaultValues(chartDef.$pluginChartDesc.leftBarParams,chartDef.webAppConfig);PluginConfigUtils.setDefaultValues(chartDef.$pluginChartDesc.topBarParams,chartDef.webAppConfig)}else{chartDef.$loadedDesc=null;chartDef.$pluginDesc=null;chartDef.$pluginChartDesc=null;if(chartDef.variant===CHART_VARIANTS.waterfall&&(!!chartDef.waterfallOptions?.useSemanticWatertfallColors||!chartDef.genericDimension1?.length)){chartDef.colorOptions.colorPalette="dku_waterfall_palette";chartDef.colorOptions.customColors={...ChartColorUtils.getWaterfallDefaultColors(),...chartDef.colorOptions.customColors}}else if(chartDef.colorOptions&&chartDef.colorOptions.colorPalette==="dku_waterfall_palette"){chartDef.colorOptions.colorPalette=theme.palettes.discrete??ChartsStaticData.DEFAULT_DISCRETE_PALETTE}}if(ChartFeatures.canDisplayDimensionValuesInChart(chartDef.type)){const hierarchyDimensions=(chartDef.yHierarchyDimension[0]||{}).dimensions||[];[...chartDef.yDimension,...hierarchyDimensions].forEach((dim,i)=>{if(dim.showDimensionValuesInChart!==false){dim.showDimensionValuesInChart=true}if(chartDef.yDimension.length-1===i||dim.hierarchyId){dim.$canChangeShowValuesInChart=false;dim.showDimensionValuesInChart=true}else{dim.$canChangeShowValuesInChart=true}if(!dim.textFormatting){dim.textFormatting={...DEFAULT_FONT_FORMATTING}}})}const valuesDisplayMode=chartDef.valuesInChartDisplayOptions.displayMode;if(chartDef.type===CHART_TYPES.STACKED_COLUMNS&&(valuesDisplayMode===VALUES_DISPLAY_MODES.LABELS||valuesDisplayMode===VALUES_DISPLAY_MODES.VALUES_AND_LABELS)||chartDef.type===CHART_TYPES.PIE&&valuesDisplayMode===VALUES_DISPLAY_MODES.VALUES_AND_TOTALS){chartDef.valuesInChartDisplayOptions.displayMode=VALUES_DISPLAY_MODES.VALUES}if(chartDef.xAxisFormatting.isLogScale&&!ChartFeatures.canSetLogScale(chartDef,"x")){chartDef.xAxisFormatting.isLogScale=false}chartDef.yAxesFormatting.forEach(axisFormatting=>{if(axisFormatting.isLogScale&&!ChartFeatures.canSetLogScale(chartDef,"y")){axisFormatting.isLogScale=false}});if(chartDef.gridlinesOptions.$default){const isOnlyRightAxis=chartDef.genericMeasures&&chartDef.genericMeasures.length===1&&chartDef.genericMeasures[0].displayAxis==="axis2";chartDef.gridlinesOptions.vertical.show=chartDef.type===CHART_TYPES.STACKED_BARS;chartDef.gridlinesOptions.horizontal.show=![CHART_TYPES.SCATTER,CHART_TYPES.SCATTER_MULTIPLE_PAIRS,CHART_TYPES.BINNED_XY,CHART_TYPES.STACKED_BARS].includes(chartDef.type);chartDef.gridlinesOptions.horizontal.displayAxis.type=isOnlyRightAxis?GridlinesAxisType.RIGHT_Y_AXIS:GridlinesAxisType.LEFT_Y_AXIS}clearGenericOrHierarchyDimension(chartDef,changedDefinition,"genericDimension0","genericHierarchyDimension");clearGenericOrHierarchyDimension(chartDef,changedDefinition,"xDimension","xHierarchyDimension");clearGenericOrHierarchyDimension(chartDef,changedDefinition,"yDimension","yHierarchyDimension");clearGenericOrHierarchyDimension(chartDef,changedDefinition,"groupDimension","groupHierarchyDimension");clearGenericOrHierarchyDimension(chartDef,changedDefinition,"boxplotBreakdownDim","boxplotBreakdownHierarchyDimension");chartDef.genericDimension0.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension,"genericDimension0"));chartDef.genericDimension1.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension,"genericDimension1"));chartDef.facetDimension.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension));chartDef.animationDimension.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension));chartDef.boxplotBreakdownDim.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension));chartDef.xDimension.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension));chartDef.yDimension.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension));chartDef.groupDimension.forEach(dimension=>autocompleteGenericDimension(chartDef,dimension));chartDef.genericHierarchyDimension.forEach(hierarchy=>autocompleteHierarchyDimensions(chartDef,hierarchy,"genericHierarchyDimension"));chartDef.xHierarchyDimension.forEach(hierarchy=>autocompleteHierarchyDimensions(chartDef,hierarchy));chartDef.yHierarchyDimension.forEach(hierarchy=>autocompleteHierarchyDimensions(chartDef,hierarchy));chartDef.groupHierarchyDimension.forEach(hierarchy=>autocompleteHierarchyDimensions(chartDef,hierarchy));chartDef.boxplotBreakdownHierarchyDimension.forEach(hierarchy=>autocompleteHierarchyDimensions(chartDef,hierarchy));if(areAllEmpty(ChartTypeChangeUtils.takeAllInX(chartDef))){ChartAxesUtils.resetCustomExtents([chartDef.xAxisFormatting])}if(areAllEmpty(ChartTypeChangeUtils.takeAllInY(chartDef))){ChartAxesUtils.resetCustomExtents(chartDef.yAxesFormatting)}if(!chartDef.filters){chartDef.filters=[]}chartDef.filters.forEach(filter=>ChartFilters.autocompleteFilter(filter,usableColumns,false));purgeHierarchyFilters(chartDef,changedDefinition);chartDef.genericMeasures.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"generic",chartDef:chartDef,theme:theme}));chartDef.genericMeasures.forEach(measure=>{if(measure.valuesInChartDisplayOptions&&measure.valuesInChartDisplayOptions.additionalMeasures){measure.valuesInChartDisplayOptions.additionalMeasures.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"valuesInChart",chartDef:chartDef,defaultTextFormatting:measure.valuesInChartDisplayOptions.textFormatting,theme:theme}))}});chartDef.sizeMeasure.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"size",chartDef:chartDef,theme:theme}));chartDef.colorMeasure.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"color",chartDef:chartDef,theme:theme}));if(Array.isArray(chartDef.colorGroups)){chartDef.colorGroups.forEach(colorGroup=>{if(_.isNil(colorGroup.colorMeasure)){colorGroup.colorMeasure=[]}else{colorGroup.colorMeasure.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"colorGroup",chartDef:chartDef,theme:theme}))}if(chartDef.type===CHART_TYPES.KPI){colorGroup.colorGroupMode="RULES"}})}else{chartDef.colorGroups=[]}chartDef.tooltipMeasures.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"tooltip",chartDef:chartDef,theme:theme}));chartDef.xMeasure.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"x",chartDef:chartDef,theme:theme}));chartDef.yMeasure.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"y",chartDef:chartDef,theme:theme}));chartDef.uaXDimension.forEach(autocompleteUA);chartDef.uaYDimension.forEach(autocompleteUA);chartDef.uaDimensionPair.forEach(pair=>{pair.uaXDimension.forEach(autocompleteUA);pair.uaYDimension.forEach(autocompleteUA)});chartDef.uaYDimension.forEach(autocompleteUA);chartDef.uaSize.forEach(autocompleteUA);chartDef.uaColor.forEach(autocompleteUA);chartDef.uaTooltip.forEach(autocompleteUA);chartDef.geometry.forEach(autocompleteUA);chartDef.boxplotValue.forEach(autocompleteUA);const possibleStdDimensionSorts=ChartDefinitionChangeHandler.getStdDimensionPossibleSorts(chartDef);chartDef.genericDimension0.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef));chartDef.facetDimension.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef));chartDef.animationDimension.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef));chartDef.xDimension.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef));chartDef.yDimension.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef));chartDef.groupDimension.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef));chartDef.genericHierarchyDimension.forEach(hierarchy=>hierarchy.dimensions.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef)));chartDef.xHierarchyDimension.forEach(hierarchy=>hierarchy.dimensions.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef)));chartDef.yHierarchyDimension.forEach(hierarchy=>hierarchy.dimensions.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef)));chartDef.groupHierarchyDimension.forEach(hierarchy=>hierarchy.dimensions.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef)));if(chartDef.type===CHART_TYPES.BOXPLOTS){const boxplotPossibleSorts=[{type:"ORIGINAL",sortId:"ORIGINAL",label:translate("CHARTS.SORTING_METHOD.NO_ORDERING","No sorting"),sortAscending:true},{type:"NATURAL",sortId:"NATURAL",label:translate("CHARTS.SORTING_METHOD.NATURAL_ORDERING","Natural ordering"),sortAscending:true},{type:"COUNT",sortId:"count desc",label:ChartLabels.DESCENDING_COUNT_OF_RECORDS_LABEL,sortAscending:false},{type:"COUNT",sortId:"count asc",label:ChartLabels.ASCENDING_COUNT_OF_RECORDS_LABEL,sortAscending:true},{type:"CUSTOM",sortId:"CUSTOM",label:translate("CHARTS.SORTING_METHOD.CUSTOM","Custom"),sortAscending:true}];chartDef.possibleDimensionSorts=boxplotPossibleSorts;chartDef.boxplotBreakdownDim.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,boxplotPossibleSorts,chartDef));chartDef.boxplotBreakdownHierarchyDimension.forEach(hierarchy=>hierarchy.dimensions.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,boxplotPossibleSorts,chartDef)));chartDef.genericDimension1.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,boxplotPossibleSorts,chartDef))}else{chartDef.possibleDimensionSorts=possibleStdDimensionSorts;chartDef.genericDimension1.forEach(dim=>ChartDefinitionChangeHandler.handleDimensionSort(dim,possibleStdDimensionSorts,chartDef))}let colorColumnData;const currColorColumn=ChartColorSelection.getColorDimensionOrMeasure(chartDef,chartDef.geoLayers[0]);if(usableColumns&&currColorColumn){colorColumnData=usableColumns.find(c=>c.column===currColorColumn.column)}if((!colorColumnData||!colorColumnData.meaningInfo)&&chartDef.colorOptions.colorPalette===DKU_PALETTE_NAMES.MEANING){chartDef.colorOptions.colorPalette="default"}let resetAllColumns=false;let indexChanged=-1;if(changedDefinition&&chartDef.type==CHART_TYPES.MULTI_COLUMNS_LINES){if(changedDefinition.name==="genericMeasures"&&chartDef.genericDimension1.length){indexChanged=changedDefinition.nv.findIndex((v,index)=>!_.isEqual(v,changedDefinition.ov[index]))}if(changedDefinition.name==="genericDimension1"&&changedDefinition.nv.length){resetAllColumns=true}}let columnFound=false;chartDef.genericMeasures.forEach((gm,index,array)=>{if(gm.displayed&&gm.displayAxis==null){gm.displayAxis="axis1"}if(gm.displayed&&gm.displayType==null){gm.displayType=chartDef.type==CHART_TYPES.MULTI_COLUMNS_LINES&&array.length>1?"line":"column"}if(!gm.labelPosition){gm.labelPosition=ChartsStaticData.LABEL_POSITIONS.BOTTOM.value}if(gm.showDisplayLabel===undefined){gm.showDisplayLabel=true}if(gm.showValue===undefined){gm.showValue=true}if(!gm.colorRules){gm.colorRules=[]}if(!gm.kpiTextAlign){gm.kpiTextAlign="CENTER"}if(!gm.labelTextFormatting){gm.labelTextFormatting={fontColor:"#333333",fontSize:15}}if(gm.labelFontSize){gm.labelTextFormatting.fontSize=gm.labelFontSize;delete gm.labelFontSize}if(!gm.kpiValueFontSizeMode){gm.kpiValueFontSizeMode=ChartsStaticData.availableFontSizeModes.RESPONSIVE.value}if(!gm.kpiValueFontSize){gm.kpiValueFontSize=32}if(!gm.responsiveTextAreaFill){gm.responsiveTextAreaFill=100}if(resetAllColumns&&columnFound){gm.displayType="line"}if(gm.displayType==="column"){columnFound=true}if(indexChanged==index&&gm.displayType==="column"){for(let oi=0;oi<array.length;oi++){if(oi===indexChanged){continue}if(array[oi].displayType==="column"){array[oi].displayType="line"}}}});if((has(chartDef.genericDimension0)||has(chartDef.genericHierarchyDimension))&&has(chartDef.genericDimension1)&&chartDef.type!==CHART_TYPES.MULTI_COLUMNS_LINES){chartDef.genericMeasures.splice(1,chartDef.genericMeasures.length-1).forEach(function(x){chartDef.tooltipMeasures.push(x)})}if(chartDef.type===CHART_TYPES.GROUPED_COLUMNS){chartDef.genericMeasures.forEach(function(m){m.displayType="column"})}if(chartDef.type===CHART_TYPES.SCATTER&&chartDef.scatterOptions&&chartDef.scatterOptions.equalScales){chartDef.xAxisFormatting.customExtent={...ChartsStaticData.DEFAULT_CUSTOM_EXTENT};ChartAxesUtils.setYAxisCustomExtent(chartDef.yAxesFormatting,{...ChartsStaticData.DEFAULT_CUSTOM_EXTENT});chartDef.xAxisFormatting.customExtent.editMode=ChartsStaticData.AUTO_EXTENT_MODE}if(!chartDef.mapOptions){chartDef.mapOptions={tilesLayer:"cartodb-positron"}}if(!chartDef.mapGridOptions){chartDef.mapGridOptions={}}if(_.isNil(chartDef.mapGridOptions.gridLonDeg)){chartDef.mapGridOptions.gridLonDeg=.5}if(_.isNil(chartDef.mapGridOptions.gridLatDeg)){chartDef.mapGridOptions.gridLatDeg=.5}if(changedDefinition&&(changedDefinition.name==="genericMeasures"&&changedDefinition.nv[0]&&changedDefinition.ov[0]&&(changedDefinition.nv[0].column!==changedDefinition.ov[0].column||changedDefinition.nv[0].function!==changedDefinition.ov[0].function)||changedDefinition.name==="type")){chartDef.gaugeOptions={...chartDef.gaugeOptions,min:{...DEFAULT_GAUGE_MIN_MAX},max:{...DEFAULT_GAUGE_MIN_MAX}}}if(chartDef.type===CHART_TYPES.TREEMAP&&chartDef.valuesInChartDisplayOptions&&!_.isNil(chartDef.valuesInChartDisplayOptions.displayValues)&&!!chartDef.genericMeasures&&chartDef.genericMeasures.length>0&&chartDef.genericMeasures[0].valuesInChartDisplayOptions&&!_.isNil(chartDef.genericMeasures[0].valuesInChartDisplayOptions.displayValues)){if(chartDef.valuesInChartDisplayOptions.displayValues===false){chartDef.genericMeasures[0].valuesInChartDisplayOptions.displayValues=false}chartDef.valuesInChartDisplayOptions.displayValues=true}if(chartDef.type===CHART_TYPES.PIVOT_TABLE&&changedDefinition&&changedDefinition.name==="yDimension"&&chartDef.yDimension.length>1){chartDef.pivotTableOptions.tableFormatting.showRowHeaders=true}if(chartDef.type!==CHART_TYPES.SCATTER_MULTIPLE_PAIRS){chartDef.yAxesFormatting=chartDef.yAxesFormatting.filter(v=>[ChartsStaticData.LEFT_AXIS_ID,ChartsStaticData.RIGHT_AXIS_ID].includes(v.id))}fixupStackedColumnsOptions(chartDef,theme);Logger.info("ChartSpec fixup done",chartDef)},fixupChart:function(chartDef,theme){chartDef.hasEchart=ChartFeatures.hasEChartsDefinition(chartDef.type);chartDef.hasD3=ChartFeatures.hasD3Definition(chartDef.type);if(ChartFeatures.hasEChartsDefinition(chartDef.type)&&chartDef.displayWithECharts===undefined&&$rootScope.featureFlagEnabled("echarts")){chartDef.displayWithECharts=$rootScope.featureFlagEnabled("echarts")}if(chartDef.displayWithEChartsByDefault===null||chartDef.displayWithEChartsByDefault===undefined){chartDef.displayWithEChartsByDefault=true}if(!chartDef.id){chartDef.id=window.crypto.getRandomValues(new Uint32Array(1))[0].toString(16)}if(!chartDef.hexbinRadius){chartDef.hexbinRadius=20}if(!chartDef.hexbinRadiusMode){chartDef.hexbinRadiusMode="NUM_HEXAGONS"}if(!chartDef.hexbinNumber){chartDef.hexbinNumber=20}if(!chartDef.yAxisMode){chartDef.yAxisMode="NORMAL"}if(!chartDef.xAxisMode){chartDef.xAxisMode="NORMAL"}if(!chartDef.computeMode){chartDef.computeMode="NONE"}if(chartDef.smoothing===undefined){chartDef.smoothing=true}if(!chartDef.strokeWidth){chartDef.strokeWidth=ChartsStaticData.DEFAULT_STROKE_WIDTH}if(!chartDef.fillOpacity){chartDef.fillOpacity=ChartsStaticData.DEFAULT_FILL_OPACITY}if(!chartDef.chartHeight){chartDef.chartHeight=200}if(_.isNil(chartDef.legendFormatting)){chartDef.legendFormatting={...DEFAULT_FONT_FORMATTING};if(theme){DSSVisualizationThemeUtils.applyToLegend(theme,chartDef.legendFormatting)}}if(chartDef.colorPaletteType===undefined){chartDef.colorPaletteType="LINEAR"}if(chartDef.colorMode===undefined){chartDef.colorMode="UNIQUE_SCALE"}fixupAxes(chartDef,theme);fixupReferenceLines(chartDef);fixupGaugeTargets(chartDef);fixupDynamicMeasure(chartDef.gaugeOptions.range);fixupDynamicMeasure(chartDef.gaugeOptions.min);fixupDynamicMeasure(chartDef.gaugeOptions.max);chartDef.gaugeOptions.targets?.map(dynMeasure=>fixupDynamicMeasure(dynMeasure));chartDef.referenceLines?.map(dynMeasure=>fixupDynamicMeasure(dynMeasure));if(chartDef.singleXAxis===undefined){chartDef.singleXAxis=true}if(!chartDef.animationFrameDuration){chartDef.animationFrameDuration=3e3}if(!chartDef.legendPlacement){chartDef.legendPlacement="OUTER_RIGHT"}if(!chartDef.gridlinesOptions){chartDef.gridlinesOptions={$default:true,vertical:{lineFormatting:{type:"FILLED",size:"1",color:"#d9d9d9"}},horizontal:{displayAxis:{},lineFormatting:{type:"FILLED",size:"1",color:"#d9d9d9"}}}}if(chartDef.type===CHART_TYPES.PIVOT_TABLE&&chartDef.variant===CHART_VARIANTS.colored){chartDef.variant=undefined;if(chartDef.colorMeasure.length===0&&chartDef.genericMeasures.length>0){chartDef.colorMeasure.push(chartDef.genericMeasures[0])}}if(_.isNil(chartDef.valuesInChartDisplayOptions)){chartDef.valuesInChartDisplayOptions={}}if(_.isNil(chartDef.valuesInChartDisplayOptions.displayValues)){chartDef.valuesInChartDisplayOptions.displayValues=false}if(_.isNil(chartDef.valuesInChartDisplayOptions.displayPieLabelsOrValues)){chartDef.valuesInChartDisplayOptions.displayPieLabelsOrValues=true}if(_.isNil(chartDef.valuesInChartDisplayOptions.displayMode)){chartDef.valuesInChartDisplayOptions.displayMode=VALUES_DISPLAY_MODES.LABELS}if(_.isNil(chartDef.valuesInChartDisplayOptions.overlappingStrategy)){chartDef.valuesInChartDisplayOptions.overlappingStrategy=ValuesInChartOverlappingStrategy.AUTO}if(_.isNil(chartDef.valuesInChartDisplayOptions.textFormatting)){chartDef.valuesInChartDisplayOptions.textFormatting=DEFAULT_VALUES_DISPLAY_IN_CHART_TEXT_FORMATTING}fixupStackedColumnsOptions(chartDef,theme);if(!_.isNil(chartDef.valuesInChartDisplayOptions.placementMode)&&!_.isNil(chartDef.genericMeasures)&&chartDef.genericMeasures.length>0&&chartDef.valuesInChartDisplayOptions.placementMode!==ValuesInChartPlacementMode.AUTO){chartDef.genericMeasures.forEach(m=>{if(!_.isNil(m.valuesInChartDisplayOptions)){m.valuesInChartDisplayOptions.placementMode=chartDef.valuesInChartDisplayOptions.placementMode}});chartDef.valuesInChartDisplayOptions.placementMode=null}if(!_.isNil(chartDef.valuesInChartDisplayOptions.spacing)&&!_.isNil(chartDef.genericMeasures)&&chartDef.genericMeasures.length>0){chartDef.genericMeasures.forEach(m=>{if(!_.isNil(m.valuesInChartDisplayOptions)){m.valuesInChartDisplayOptions.spacing=chartDef.valuesInChartDisplayOptions.spacing}});if(ChartFeatures.canDisplayTotalValues(chartDef)){chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.spacing=chartDef.valuesInChartDisplayOptions.spacing}chartDef.valuesInChartDisplayOptions.spacing=null}if(_.isNil(chartDef.pivotTableOptions)||_.isEmpty(chartDef.pivotTableOptions)){chartDef.pivotTableOptions={measureDisplayMode:ChartsStaticData.pivotTableMeasureDisplayMode.ROWS,displayEmptyValues:false,showSidebar:true,areRowsExpandedByDefault:true,areColumnExpandedByDefault:true,rowIdByCustomExpandedStatus:{},columnIdByCustomExpandedStatus:{},columnIdByCustomWidth:{},displayTotals:angular.copy(ChartsStaticData.defaultPivotDisplayTotals)}}if(_.isNil(chartDef.pivotTableOptions.measureDisplayMode)){chartDef.pivotTableOptions.measureDisplayMode=ChartsStaticData.pivotTableMeasureDisplayMode.ROWS}if(_.isNil(chartDef.pivotTableOptions.displayTotals)){chartDef.pivotTableOptions.displayTotals=angular.copy(ChartsStaticData.defaultPivotDisplayTotals)}if(_.isNil(chartDef.pivotTableOptions.showSidebar)){chartDef.pivotTableOptions.showSidebar=true}if(_.isNil(chartDef.pivotTableOptions.tableFormatting)){chartDef.pivotTableOptions.tableFormatting={showRowHeaders:true,showRowMainHeaders:true,rowMainHeaders:{...DEFAULT_TABLE_HEADER_FONT_FORMATTING},rowSubheaders:{...DEFAULT_TABLE_HEADER_FONT_FORMATTING},freezeRowHeaders:true,showColumnHeaders:true,showColumnMainHeaders:true,columnMainHeaders:{...DEFAULT_TABLE_HEADER_FONT_FORMATTING},columnSubheaders:{...DEFAULT_TABLE_HEADER_FONT_FORMATTING},values:{...DEFAULT_FONT_FORMATTING},rowHeaders:{...DEFAULT_TABLE_HEADER_FONT_FORMATTING},columnHeaders:{...DEFAULT_TABLE_HEADER_FONT_FORMATTING}};if(theme){DSSVisualizationThemeUtils.applyToTableFormatting(theme,chartDef.pivotTableOptions.tableFormatting)}}else{fixupPivotTableFormatting(chartDef.pivotTableOptions.tableFormatting,theme)}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.showRowHeaders)){chartDef.pivotTableOptions.tableFormatting.showRowHeaders=true}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders)){chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders=true}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.rowMainHeaders)){chartDef.pivotTableOptions.tableFormatting.rowMainHeaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor}}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.rowSubheaders)){chartDef.pivotTableOptions.tableFormatting.rowSubheaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor}}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders)){chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders=true}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.showColumnHeaders)){chartDef.pivotTableOptions.tableFormatting.showColumnHeaders=true}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.showColumnMainHeaders)){chartDef.pivotTableOptions.tableFormatting.showColumnMainHeaders=true}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.columnMainHeaders)){chartDef.pivotTableOptions.tableFormatting.columnMainHeaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor}}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.columnSubheaders)){chartDef.pivotTableOptions.tableFormatting.columnSubheaders={...DEFAULT_TABLE_HEADER_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_TABLE_HEADER_FONT_FORMATTING.fontColor}}if(_.isNil(chartDef.pivotTableOptions.tableFormatting.values)){chartDef.pivotTableOptions.tableFormatting.values={...DEFAULT_FONT_FORMATTING,fontColor:theme?theme.generalFormatting.fontColor:DEFAULT_FONT_FORMATTING.fontColor}}if(!chartDef.genericDimension0){chartDef.genericDimension0=[]}if(!chartDef.genericDimension1){chartDef.genericDimension1=[]}if(!chartDef.facetDimension){chartDef.facetDimension=[]}if(!chartDef.animationDimension){chartDef.animationDimension=[]}if(!chartDef.genericMeasures){chartDef.genericMeasures=[]}if(!chartDef.xDimension){chartDef.xDimension=[]}if(!chartDef.yDimension){chartDef.yDimension=[]}if(!chartDef.groupDimension){chartDef.groupDimension=[]}if(!chartDef.uaXDimension){chartDef.uaXDimension=[]}if(!chartDef.uaYDimension){chartDef.uaYDimension=[]}if(!chartDef.uaDimensionPair){chartDef.uaDimensionPair=[]}if(!chartDef.genericHierarchyDimension){chartDef.genericHierarchyDimension=[]}if(!chartDef.xHierarchyDimension){chartDef.xHierarchyDimension=[]}if(!chartDef.yHierarchyDimension){chartDef.yHierarchyDimension=[]}if(!chartDef.groupHierarchyDimension){chartDef.groupHierarchyDimension=[]}if(!chartDef.boxplotBreakdownHierarchyDimension){chartDef.boxplotBreakdownHierarchyDimension=[]}if(!chartDef.xMeasure){chartDef.xMeasure=[]}if(!chartDef.yMeasure){chartDef.yMeasure=[]}if(!chartDef.sizeMeasure){chartDef.sizeMeasure=[]}if(!chartDef.colorMeasure){chartDef.colorMeasure=[]}if(!chartDef.tooltipMeasures){chartDef.tooltipMeasures=[]}if(!chartDef.uaSize){chartDef.uaSize=[]}if(!chartDef.uaColor){chartDef.uaColor=[]}if(!chartDef.uaShape){chartDef.uaShape=[]}if(!chartDef.uaTooltip){chartDef.uaTooltip=[]}if(!chartDef.boxplotBreakdownDim){chartDef.boxplotBreakdownDim=[]}if(!chartDef.boxplotValue){chartDef.boxplotValue=[]}if(!chartDef.geometry){chartDef.geometry=[]}if(!chartDef.colorOptions){chartDef.colorOptions=ChartsStaticData.DEFAULT_COLOR_OPTIONS}if(!chartDef.colorOptions.colorPalette){chartDef.colorOptions.colorPalette=theme.palettes.discrete??ChartsStaticData.DEFAULT_DISCRETE_PALETTE}if(!chartDef.colorOptions.customPalette){chartDef.colorOptions.customPalette=ChartColorUtils.getDefaultCustomPalette()}if(!chartDef.colorOptions.ccScaleMode){chartDef.colorOptions.ccScaleMode="NORMAL"}if(!chartDef.colorOptions.paletteType){chartDef.colorOptions.paletteType="CONTINUOUS"}if(!chartDef.colorOptions.quantizationMode){chartDef.colorOptions.quantizationMode="NONE"}if(!chartDef.colorOptions.numQuantizeSteps){chartDef.colorOptions.numQuantizeSteps=5}if(!chartDef.colorOptions.paletteMiddleValue){chartDef.colorOptions.paletteMiddleValue=0}if(chartDef.colorOptions.paletteMiddleValue<=0&&chartDef.colorOptions.paletteType==="DIVERGING"&&chartDef.colorOptions.ccScaleMode==="LOG"){chartDef.colorOptions.paletteMiddleValue=1}if(!chartDef.colorOptions.customColors){chartDef.colorOptions.customColors={}}if(!chartDef.geoLayers){chartDef.geoLayers=[{geometry:angular.copy(chartDef.geometry),uaColor:angular.copy(chartDef.uaColor),colorOptions:angular.copy(chartDef.colorOptions)}]}if(!chartDef.bubblesOptions){chartDef.bubblesOptions={defaultRadius:5,singleShape:"FILLED_CIRCLE"}}if(!chartDef.pieOptions){chartDef.pieOptions={donutHoleSize:54}}const defaultConnectPointsOpts={enabled:false,lineFormatting:{size:1}};if(!chartDef.scatterOptions){chartDef.scatterOptions={regression:{show:false,type:RegressionTypes.LINEAR,lineFormatting:{size:1,color:"#000"},labelPosition:"INSIDE_END",displayFormula:false,textFormatting:{...DEFAULT_FONT_FORMATTING,backgroundColor:"#D9D9D9BF"}}};if(theme){DSSVisualizationThemeUtils.applyToScatterOptions(theme,chartDef.scatterOptions)}}if(!chartDef.scatterOptions.connectPoints){chartDef.scatterOptions.connectPoints=angular.copy(defaultConnectPointsOpts)}if(!chartDef.sankeyOptions){chartDef.sankeyOptions={linkColorVariant:"GRADIENT",curveness:.5}}if(!chartDef.sankeyOptions.nodeLabelFormatting){chartDef.sankeyOptions={...chartDef.sankeyOptions,nodeLabelFormatting:{...DEFAULT_AUTO_FONT_FORMATTING,hasBackground:false,backgroundColor:"#D9D9D9BF"}};if(theme){DSSVisualizationThemeUtils.applyToSankeyNodeLabels(theme,chartDef.sankeyOptions.nodeLabelFormatting)}}if(!chartDef.scatterMPOptions){chartDef.scatterMPOptions={pairColorOptions:{transparency:.75,colorPalette:theme&&theme.palettes?theme.palettes.discrete:DKU_PALETTE_NAMES.THEME,customPalette:ChartColorUtils.getDefaultCustomPalette(),customColors:{}}}}if(!chartDef.scatterMPOptions.connectPoints){chartDef.scatterMPOptions.connectPoints=angular.copy(defaultConnectPointsOpts)}if(!chartDef.radarOptions){chartDef.radarOptions={filled:false,polygonsSource:PolygonSources.MEASURES,lineStyle:{width:2,type:LineStyleTypes.SOLID}}}if(!chartDef.waterfallOptions){chartDef.waterfallOptions={totalBarDisplayMode:TotalBarDisplayModes.RIGHT,useSemanticWatertfallColors:true,totalBarLabel:""}}if(!chartDef.gaugeOptions){chartDef.gaugeOptions={min:null,max:null,displayPointer:false}}if(!chartDef.scatterZoomOptions){chartDef.scatterZoomOptions={enabled:true,persisted:true,scale:[1,1],translate:[0,0]}}if(!chartDef.linesZoomOptions){chartDef.linesZoomOptions={enabled:true,persisted:true,displayBrush:true}}if(!chartDef.drilldownOptions){chartDef.drilldownOptions={displayBreadcrumb:true}}if(chartDef.type===CHART_TYPES.WEBAPP){chartDef.webAppConfig=chartDef.webAppConfig||{};chartDef.$loadedDesc=WebAppsService.getWebAppLoadedDesc(chartDef.webAppType)||{};chartDef.$pluginDesc=WebAppsService.getOwnerPluginDesc(chartDef.webAppType);chartDef.$pluginChartDesc=chartDef.$loadedDesc.desc.chart;PluginConfigUtils.setDefaultValues(chartDef.$pluginChartDesc.leftBarParams,chartDef.webAppConfig);PluginConfigUtils.setDefaultValues(chartDef.$pluginChartDesc.topBarParams,chartDef.webAppConfig)}else{chartDef.$loadedDesc=null;chartDef.$pluginDesc=null;chartDef.$pluginChartDesc=null}chartDef.genericMeasures.forEach(measure=>{if(!measure.valuesInChartDisplayOptions){measure.valuesInChartDisplayOptions={displayValues:true,textFormatting:chartDef.valuesInChartDisplayOptions.textFormatting,additionalMeasures:[],addDetails:false}}if(!measure.valuesInChartDisplayOptions.additionalMeasures){measure.valuesInChartDisplayOptions.additionalMeasures=[]}measure.valuesInChartDisplayOptions.additionalMeasures.forEach(autocompleteGenericMeasure.bind(this,{contextualMenuMeasureType:"valuesInChart",chartDef:chartDef,defaultTextFormatting:measure.valuesInChartDisplayOptions.textFormatting,theme:theme}))});const formattableMeasuresAndDimensions=["genericMeasures","colorMeasure","uaColor","uaSize","uaShape","boxplotValue","uaTooltip","tooltipMeasures","genericDimension0","genericDimension1","facetDimension","animationDimension","xDimension","yDimension","uaXDimension","uaYDimension","groupDimension"];const getFormattableMeasureOrDimensionDefaultsByName=measureOrDimensionName=>{if(measureOrDimensionName==="genericMeasures"){return{labelPosition:ChartsStaticData.LABEL_POSITIONS.BOTTOM.value,showDisplayLabel:true}}return{}};for(const measureOrDimension of formattableMeasuresAndDimensions){if(chartDef[measureOrDimension]){chartDef[measureOrDimension]=chartDef[measureOrDimension].map(measureOrDimensionDef=>({...ChartsStaticData.DEFAULT_NUMBER_FORMATTING_OPTIONS,hideTrailingZeros:getDefaultTrailingZeros(measureOrDimensionDef),...getFormattableMeasureOrDimensionDefaultsByName(measureOrDimension),...measureOrDimensionDef}))}}$rootScope.$emit("chart-fixed-up");return chartDef},defaultNewChart:function(themeToBeUsed){const theme=DSSVisualizationThemeUtils.getThemeOrDefault(themeToBeUsed?themeToBeUsed:$rootScope.appConfig.selectedDSSVisualizationTheme);const newChart=this.fixupChart({name:"Chart",type:CHART_TYPES.GROUPED_COLUMNS,variant:"normal"},theme);DSSVisualizationThemeUtils.applyToChart({chart:newChart,theme:theme});return newChart},newEmptyGeoPlaceholder:function(index){return{geometry:[],uaColor:[],colorOptions:newColorOptions(index)}},rejectMeasureOrDimension:reject,acceptMeasureOrDimension:accept};return svc}})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("ChartTypeChangeUtils",function(CHART_TYPES,ChartsStaticData){const service={isUsableAsUA:measure=>{return measure.column!=null&&measure.type!=="CUSTOM"},isUsableAsMeasure:ua=>{return ua.type==="NUMERICAL"},measureToUA:measure=>{return{column:measure.column,type:measure.type,chartDefAttributeName:measure.chartDefAttributeName}},uaToMeasure:ua=>{return{column:ua.column,type:ua.type,function:"AVG",chartDefAttributeName:ua.chartDefAttributeName}},uaDimToDim:ua=>{return{column:ua.column,type:ua.type,chartDefAttributeName:ua.chartDefAttributeName}},uaPairToDim:uaPair=>{const ret=[];if(uaPair.uaXDimension.length){ret.push({column:uaPair.uaXDimension[0].column,type:uaPair.uaXDimension[0].type,chartDefAttributeName:"uaXDimension"})}if(uaPair.uaYDimension.length){ret.push({column:uaPair.uaYDimension[0].column,type:uaPair.uaYDimension[0].type,chartDefAttributeName:"uaYDimension"})}return ret},takeAllAndEmpty:(object,keys)=>{if(!object){return[]}let response=[];for(const key of keys){if(!object[key]){continue}response=[...response,...object[key].map(v=>({...v,chartDefAttributeName:key}))];object[key]=[]}return response},takeAllMeasures:chartDef=>{return service.takeAllAndEmpty(chartDef,ChartsStaticData.MEASURES_PROPERTIES)},takeAllUA:chartDef=>{return service.takeAllAndEmpty(chartDef,["uaSize","uaColor","uaTooltip","boxplotValue"])},takeAllMeasuresWithUA:chartDef=>{return service.takeAllMeasures(chartDef).concat(service.takeAllUA(chartDef).filter(service.isUsableAsMeasure).map(service.uaToMeasure))},takeAllUAWithMeasures:chartDef=>{return service.takeAllUA(chartDef).concat(service.takeAllMeasures(chartDef).filter(service.isUsableAsUA).map(service.measureToUA))},takeAllExistingDimensions:chartDef=>{const dimensions=service.takeAllAndEmpty(chartDef,[...ChartsStaticData.PRIMARY_DIMENSIONS_PROPERTIES,ChartsStaticData.SECONDARY_DIMENSIONS_PROPERTIES]);return[...dimensions,...service.takeAllAndEmpty(chartDef,["uaXDimension","uaYDimension"]).map(service.uaDimToDim),...service.takeAllAndEmpty(chartDef,["uaDimensionPair"]).map(service.uaPairToDim).flat()]},takeAllExistingPrimaryDimensions:chartDef=>{const dimensions=service.takeAllAndEmpty(chartDef,ChartsStaticData.PRIMARY_DIMENSIONS_PROPERTIES);return[...dimensions,...service.takeAllAndEmpty(chartDef,["uaXDimension","uaYDimension"]).map(service.uaDimToDim),...[].concat(...service.takeAllAndEmpty(chartDef,["uaDimensionPair"]).map(service.uaPairToDim))]},takeAllExistingSecondaryDimensions:chartDef=>{return service.takeAllAndEmpty(chartDef,ChartsStaticData.SECONDARY_DIMENSIONS_PROPERTIES)},setDimensionsOrHierarachies:(chartDef,propertyPairs,existingPrimaryDimensions,existingSecondaryDimensions,canUseHierarchies=true,canSetMultiple=false)=>{const existingHierarchies=service.takeAllExistingHierarchies(chartDef);for(const pair of propertyPairs){const[dimensionProp,hierarchyProp]=pair;const primaryDimToUse=canSetMultiple?[...existingPrimaryDimensions]:existingPrimaryDimensions.splice(0,1);if(primaryDimToUse.length){chartDef[dimensionProp]=primaryDimToUse;continue}if(canUseHierarchies){const hierarchyToUse=canSetMultiple?[...existingHierarchies]:existingHierarchies.splice(0,1);if(hierarchyToUse.length){chartDef[hierarchyProp]=hierarchyToUse;continue}}const secondaryDimToUse=canSetMultiple?[...existingSecondaryDimensions]:existingSecondaryDimensions.splice(0,1);if(secondaryDimToUse.length){chartDef[dimensionProp]=secondaryDimToUse}}},takeAllExistingHierarchies:chartDef=>{return service.takeAllAndEmpty(chartDef,ChartsStaticData.HIERARCHY_DIMENSIONS_PROPERTIES)},takeAllInX:chartDef=>{switch(chartDef.type){case CHART_TYPES.STACKED_BARS:return[chartDef.genericMeasures,chartDef.xMeasure,chartDef.uaXDimension,chartDef.xDimension];case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:return chartDef.uaDimensionPair.reduce((acc,pair)=>{if(pair.uaXDimension&&pair.uaXDimension.length){acc.push(pair.uaXDimension)}return acc},[]);default:return[chartDef.genericDimension0,chartDef.xMeasure,chartDef.uaXDimension,chartDef.xDimension]}},takeAllInY:chartDef=>{switch(chartDef.type){case CHART_TYPES.BOXPLOTS:return[chartDef.boxplotValue];case CHART_TYPES.STACKED_BARS:return[chartDef.genericDimension0,chartDef.yMeasure,chartDef.uaYDimension,chartDef.yDimension];case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:return chartDef.uaDimensionPair.reduce((acc,pair)=>{if(pair.uaYDimension&&pair.uaYDimension.length){acc.push(pair.uaYDimension)}return acc},[]);default:return[chartDef.genericMeasures,chartDef.yMeasure,chartDef.uaYDimension,chartDef.yDimension]}}};return service})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("ChartsAvailableTypes",function(CHART_TYPES,CHART_VARIANTS,PluginsService,translate,$rootScope){const svc={};const ENGLISH_KEYWORDS={ADMINISTRATIVE:"administrative",AGGREGATION:"aggregation",ASSOCIATIONS:"associations",BARS:"bars",BINNED:"binned",CHANGE:"change",COMPARISON:"comparison",CURVES:"curves",DISTRIBUTION:"distribution",DONUTS:"donuts",DOUGHNUT:"doughnut",FLOW:"flow",GEOGRAPHICAL:"geographical",GROUP:"group",HIERARCHY:"hierarchy",HISTOGRAM:"histogram",LEARNING:"learning",LINES:"lines",LOCATION:"location",MACHINE:"machine",MAGNITUDE:"magnitude",MAPS:"maps",METRIC:"metric",MODELS:"models",PART:"part",PATTERNS:"patterns",PERCENTAGE:"percentage",PIES:"pies",PROPORTION:"proportion",RANGE:"range",RELATIONSHIPS:"relationships",SCATTERS:"scatters",SPEEDOMETER:"speedometer",SPIDER:"spider",SUMMARY:"summary",TABLES:"tables",TIME:"time",WEB:"web"};const KEYWORDS=Object.entries(ENGLISH_KEYWORDS).reduce((acc,[key,value])=>{const keywords=[value];const translated=translate(`CHARTS.TYPE_PICKER.KEYWORD.${key}`,value);if(translated!==value){keywords.push(translated)}acc[key]=keywords;return acc},{});const ENGLISH_DISPLAY_NAMES={VERTICAL_BARS:"Vertical bars",WATERFALL:"Waterfall",VERTICAL_STACKED_BARS:"Vertical stacked bars",VERTICAL_STACKED_BARS_100:"Vertical stacked_bars 100%",HORIZONTAL_STACKED_BARS:"Horizontal stacked bars",HORIZONTAL_STACKED_BARS_100:"Horizontal stacked bars 100%",LINES:"Lines",STACKED_AREAS:"Stacked_areas",STACKED_AREAS_100:"Stacked areas 100%",PIE:"Pie",DONUT:"Donut",MIX:"Mix",PIVOT_TABLE:"Pivot table",KPIS:"KPIs",RADAR:"Radar",GAUGE:"Gauge",SANKEY:"Sankey",TREEMAP:"Treemap",SCATTER_PLOT:"Scatter plot",SCATTER_MULTI_PAIR:"Scatter multi-pair",GEOMETRY_MAP:"Geometry map",GRID_MAP:"Grid map",SCATTER_MAP:"Scatter map",ADMINISTRATIVE_MAP_FILLED:"Administrative map (filled)",ADMINISTRATIVE_MAP_BUBBLES:"Administrative map (bubbles)",DENSITY_MAP:"Density map",GROUPED_BUBBLES:"Grouped bubbles",BINNED_BUBBLES:"Binned bubbles",BINNED_HEXAGONS:"Binned hexagons",BINNED_RECTANGLES:"Binned rectangles",BOXPLOT:"Boxplot","2D_DISTRIBUTION":"2D distribution",LIFT_CHART:"Lift chart"};const ENGLISH_DISPLAY_NAME_KEYWORDS=Object.entries(ENGLISH_DISPLAY_NAMES).reduce((acc,[key,value])=>{acc[key]=splitToKeywords(value);return acc},{});function splitToKeywords(phrase){return phrase.trim().toLowerCase().split(/[, ]+/)}svc.getAvailableChartTypes=function(){return[{id:"qa_charts_histogram-chart-type",type:CHART_TYPES.GROUPED_COLUMNS,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.VERTICAL_BARS",ENGLISH_DISPLAY_NAMES.VERTICAL_BARS),get keywords(){return[...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PATTERNS,...KEYWORDS.PROPORTION,...KEYWORDS.HISTOGRAM,...KEYWORDS.BARS,...ENGLISH_DISPLAY_NAME_KEYWORDS.VERTICAL_BARS,...splitToKeywords(this.displayName)]},similar:["qa_charts_stacked-chart-type","qa_charts_stacked-100-chart-type","qa_charts_bars-chart-type","qa_charts_bars-100-chart-type","qa_charts_waterfall-chart-type","qa_charts_pivot-chart-type","qa_charts_treemap-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.VERTICAL_BARS","Compares values across grouped items or within a subgroup vertically")},{id:"qa_charts_waterfall-chart-type",type:CHART_TYPES.GROUPED_COLUMNS,variant:CHART_VARIANTS.waterfall,displayName:translate("CHARTS.TYPE_PICKER.NAME.WATERFALL","Waterfall chart"),get keywords(){return[...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PATTERNS,...KEYWORDS.HISTOGRAM,...KEYWORDS.BARS,...ENGLISH_DISPLAY_NAME_KEYWORDS.WATERFALL,...splitToKeywords(this.displayName)]},similar:["qa_charts_histogram-chart-type","qa_charts_stacked-chart-type","qa_charts_stacked-100-chart-type","qa_charts_bars-chart-type","qa_charts_bars-100-chart-type","qa_charts_pivot-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.WATERFALL","Shows how negative and positive changes affect a starting value, leading to the final value")},{id:"qa_charts_stacked-chart-type",type:CHART_TYPES.STACKED_COLUMNS,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.VERTICAL_STACKED_BARS",ENGLISH_DISPLAY_NAMES.VERTICAL_STACKED_BARS),get keywords(){return[...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PATTERNS,...KEYWORDS.PROPORTION,...KEYWORDS.BARS,...ENGLISH_DISPLAY_NAME_KEYWORDS.VERTICAL_STACKED_BARS]},similar:["qa_charts_histogram-chart-type","qa_charts_stacked-100-chart-type","qa_charts_bars-chart-type","qa_charts_bars-100-chart-type","qa_charts_pivot-chart-type","qa_charts_treemap-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.VERTICAL_STACKED_BARS","Shows part-to-whole relationship within a group vertically")},{id:"qa_charts_stacked-100-chart-type",type:CHART_TYPES.STACKED_COLUMNS,variant:CHART_VARIANTS.stacked100,displayName:translate("CHARTS.TYPE_PICKER.NAME.VERTICAL_STACKED_BARS_100",ENGLISH_DISPLAY_NAMES.VERTICAL_STACKED_BARS_100),get keywords(){return[...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PATTERNS,...KEYWORDS.PROPORTION,...KEYWORDS.PERCENTAGE,...KEYWORDS.BARS,...ENGLISH_DISPLAY_NAME_KEYWORDS.VERTICAL_STACKED_BARS_100,...splitToKeywords(this.displayName)]},similar:["qa_charts_histogram-chart-type","qa_charts_stacked-chart-type","qa_charts_bars-chart-type","qa_charts_bars-100-chart-type","qa_charts_pivot-chart-type","qa_charts_treemap-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.VERTICAL_STACKED_BARS_100","Highlights the relative difference among values in each group - each bar is always 100%")},{id:"qa_charts_bars-chart-type",type:CHART_TYPES.STACKED_BARS,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.HORIZONTAL_STACKED_BARS",ENGLISH_DISPLAY_NAMES.HORIZONTAL_STACKED_BARS),get keywords(){return[...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PATTERNS,...KEYWORDS.PROPORTION,...KEYWORDS.BARS,...ENGLISH_DISPLAY_NAME_KEYWORDS.HORIZONTAL_STACKED_BARS,...splitToKeywords(this.displayName)]},similar:["qa_charts_histogram-chart-type","qa_charts_stacked-chart-type","qa_charts_stacked-100-chart-type","qa_charts_bars-100-chart-type","qa_charts_pivot-chart-type","qa_charts_treemap-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.HORIZONTAL_STACKED_BARS","Compares values across grouped items or within a subgroup horizontally")},{id:"qa_charts_bars-100-chart-type",type:CHART_TYPES.STACKED_BARS,variant:CHART_VARIANTS.stacked100,displayName:translate("CHARTS.TYPE_PICKER.NAME.HORIZONTAL_STACKED_BARS_100",ENGLISH_DISPLAY_NAMES.HORIZONTAL_STACKED_BARS_100),get keywords(){return[...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PATTERNS,...KEYWORDS.PROPORTION,...KEYWORDS.PERCENTAGE,...KEYWORDS.BARS,...ENGLISH_DISPLAY_NAME_KEYWORDS.HORIZONTAL_STACKED_BARS_100,...splitToKeywords(this.displayName)]},similar:["qa_charts_histogram-chart-type","qa_charts_stacked-chart-type","qa_charts_stacked-100-chart-type","qa_charts_bars-chart-type","qa_charts_pivot-chart-type","qa_charts_treemap-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.HORIZONTAL_STACKED_BARS_100","Highlights the relative difference among values in each group - each bar is always 100%")},{id:"qa_charts_lines-chart-type",type:CHART_TYPES.LINES,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.LINES",ENGLISH_DISPLAY_NAMES.LINES),get keywords(){return[...KEYWORDS.CHANGE,...KEYWORDS.TIME,...KEYWORDS.PATTERNS,...KEYWORDS.LINES,...KEYWORDS.CURVES,...ENGLISH_DISPLAY_NAME_KEYWORDS.LINES,...splitToKeywords(this.displayName)]},similar:["qa_charts_mix-chart-type","qa_charts_stacked-area-chart-type","qa_charts_stacked-area-100-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.LINES","Display quantitative values over a continuous interval or time period")},{id:"qa_charts_stacked-area-chart-type",type:CHART_TYPES.STACKED_AREA,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.STACKED_AREAS",ENGLISH_DISPLAY_NAMES.STACKED_AREAS),get keywords(){return[...KEYWORDS.CHANGE,...KEYWORDS.TIME,...KEYWORDS.PATTERNS,...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PROPORTION,...KEYWORDS.PERCENTAGE,...KEYWORDS.LINES,...KEYWORDS.CURVES,...ENGLISH_DISPLAY_NAME_KEYWORDS.STACKED_AREAS,...splitToKeywords(this.displayName)]},similar:["qa_charts_stacked-area-100-chart-type","qa_charts_lines-chart-type","qa_charts_mix-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.STACKED_AREAS","Shows how values evolve over a continuous interval or time period")},{id:"qa_charts_stacked-area-100-chart-type",type:CHART_TYPES.STACKED_AREA,variant:CHART_VARIANTS.stacked100,displayName:translate("CHARTS.TYPE_PICKER.NAME.STACKED_AREAS_100",ENGLISH_DISPLAY_NAMES.STACKED_AREAS_100),get keywords(){return[...KEYWORDS.CHANGE,...KEYWORDS.TIME,...KEYWORDS.PATTERNS,...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PROPORTION,...KEYWORDS.PERCENTAGE,...KEYWORDS.LINES,...KEYWORDS.CURVES,...ENGLISH_DISPLAY_NAME_KEYWORDS.STACKED_AREAS_100,...splitToKeywords(this.displayName)]},similar:["qa_charts_stacked-area-chart-type","qa_charts_lines-chart-type","qa_charts_mix-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.STACKED_AREAS_100","Highlights the relative difference among values evolving over a continuous time period")},{id:"qa_charts_pie-chart-type",type:CHART_TYPES.PIE,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.PIE",ENGLISH_DISPLAY_NAMES.PIE),get keywords(){return[...KEYWORDS.PART,...KEYWORDS.PROPORTION,...KEYWORDS.PIES,...KEYWORDS.DONUTS,...ENGLISH_DISPLAY_NAME_KEYWORDS.PIE,...splitToKeywords(this.displayName)]},similar:["qa_charts_donut-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.PIE","Shows a quick part-to-whole comparison")},{id:"qa_charts_donut-chart-type",type:CHART_TYPES.PIE,variant:CHART_VARIANTS.donut,displayName:translate("CHARTS.TYPE_PICKER.NAME.DONUT",ENGLISH_DISPLAY_NAMES.DONUT),get keywords(){return[...KEYWORDS.PART,...KEYWORDS.PROPORTION,...KEYWORDS.PIES,...KEYWORDS.DONUTS,...KEYWORDS.DOUGHNUT,...ENGLISH_DISPLAY_NAME_KEYWORDS.DONUT,...splitToKeywords(this.displayName)]},similar:["qa_charts_pie-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.DONUT","Shows a quick part-to-whole comparison with a hole inside")},{id:"qa_charts_mix-chart-type",type:CHART_TYPES.MULTI_COLUMNS_LINES,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.MIX",ENGLISH_DISPLAY_NAMES.MIX),get keywords(){return[...KEYWORDS.CHANGE,...KEYWORDS.TIME,...KEYWORDS.MAGNITUDE,...KEYWORDS.COMPARISON,...KEYWORDS.PATTERNS,...KEYWORDS.PROPORTION,...KEYWORDS.PERCENTAGE,...KEYWORDS.BARS,...KEYWORDS.LINES,...KEYWORDS.CURVES,...ENGLISH_DISPLAY_NAME_KEYWORDS.MIX,...splitToKeywords(this.displayName)]},similar:["qa_charts_lines-chart-type","qa_charts_stacked-area-chart-type","qa_charts_stacked-area-100-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.MIX","Shows a direct comparison between two sets of values with separate axes")},{id:"qa_charts_pivot-chart-type",type:CHART_TYPES.PIVOT_TABLE,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.PIVOT_TABLE",ENGLISH_DISPLAY_NAMES.PIVOT_TABLE),get keywords(){return[...KEYWORDS.SUMMARY,...KEYWORDS.GROUP,...KEYWORDS.AGGREGATION,...KEYWORDS.HIERARCHY,...KEYWORDS.TABLES,...ENGLISH_DISPLAY_NAME_KEYWORDS.PIVOT_TABLE,...splitToKeywords(this.displayName)]},similar:["qa_charts_histogram-chart-type","qa_charts_stacked-chart-type","qa_charts_stacked-100-chart-type","qa_charts_bars-chart-type","qa_charts_bars-100-chart-type","qa_charts_treemap-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.PIVOT_TABLE","Displays aggregated values in a table grouped across several dimensions")},{id:"qa_charts_kpi-chart-type",type:CHART_TYPES.KPI,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.KPI",ENGLISH_DISPLAY_NAMES.KPIS),get keywords(){return[...KEYWORDS.METRIC,...ENGLISH_DISPLAY_NAME_KEYWORDS.KPIS,...splitToKeywords(this.displayName)]},similar:["qa_charts_gauge-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.KPI","Displays a simple value visualization for single or multiple aggregations")},{id:"qa_charts_radar-chart-type",type:CHART_TYPES.RADAR,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.RADAR",ENGLISH_DISPLAY_NAMES.RADAR),get keywords(){return[...KEYWORDS.WEB,...KEYWORDS.SPIDER,...ENGLISH_DISPLAY_NAME_KEYWORDS.RADAR,...splitToKeywords(this.displayName)]},tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.RADAR","Displays data in a radial axis, where the radii represents the performance of values")},{id:"qa_charts_gauge-chart-type",type:CHART_TYPES.GAUGE,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.GAUGE",ENGLISH_DISPLAY_NAMES.GAUGE),get keywords(){return[...KEYWORDS.SPEEDOMETER,...ENGLISH_DISPLAY_NAME_KEYWORDS.GAUGE,...splitToKeywords(this.displayName)]},similar:["qa_charts_kpi-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.GAUGE","Displays how a value performs in a semi-circular scale")},{id:"qa_charts_sankey-chart-type",type:CHART_TYPES.SANKEY,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.SANKEY",ENGLISH_DISPLAY_NAMES.SANKEY),get keywords(){return[...KEYWORDS.FLOW,...ENGLISH_DISPLAY_NAME_KEYWORDS.SANKEY,...splitToKeywords(this.displayName)]},tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.SANKEY","Displays a weighted flow of resources")},{id:"qa_charts_treemap-chart-type",type:CHART_TYPES.TREEMAP,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.TREEMAP",ENGLISH_DISPLAY_NAMES.TREEMAP),get keywords(){return[...KEYWORDS.HIERARCHY,...KEYWORDS.COMPARISON,...KEYWORDS.PROPORTION,...KEYWORDS.PART,...ENGLISH_DISPLAY_NAME_KEYWORDS.TREEMAP,...splitToKeywords(this.displayName)]},similar:["qa_charts_pivot-chart-type","qa_charts_histogram-chart-type","qa_charts_stacked-chart-type","qa_charts_stacked-100-chart-type","qa_charts_bars-chart-type","qa_charts_bars-100-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.TREEMAP","Displays hierarchical data as nested rectangles with proportional sizes")},{id:"qa_charts_scatter-plot-chart-type",type:CHART_TYPES.SCATTER,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.SCATTER_PLOT",ENGLISH_DISPLAY_NAMES.SCATTER_PLOT),get keywords(){return[...KEYWORDS.ASSOCIATIONS,...KEYWORDS.PATTERNS,...KEYWORDS.RELATIONSHIPS,...KEYWORDS.SCATTERS,...ENGLISH_DISPLAY_NAME_KEYWORDS.SCATTER_PLOT,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-plot-multiple-pairs-chart-type","qa_charts_bubble-chart-type","qa_charts_rectangle-chart-type","qa_charts_hexagon-chart-type","qa_charts_grouped-bubbles-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.SCATTER_PLOT","Shows the relationships between numerical variables drawn on the axes")},{id:"qa_charts_scatter-plot-multiple-pairs-chart-type",type:CHART_TYPES.SCATTER_MULTIPLE_PAIRS,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.SCATTER_MULTI_PAIR",ENGLISH_DISPLAY_NAMES.SCATTER_MULTI_PAIR),get keywords(){return[...KEYWORDS.ASSOCIATIONS,...KEYWORDS.PATTERNS,...KEYWORDS.RELATIONSHIPS,...KEYWORDS.SCATTERS,...ENGLISH_DISPLAY_NAME_KEYWORDS.SCATTER_MULTI_PAIR,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-plot-chart-type","qa_charts_bubble-chart-type","qa_charts_rectangle-chart-type","qa_charts_hexagon-chart-type","qa_charts_grouped-bubbles-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.SCATTER_MULTI_PAIR","Shows the relationships between numerical variables drawn on the axes (with multiple pairs)")},{id:"qa_charts_geo-map-chart-type",type:CHART_TYPES.GEOMETRY_MAP,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.GEOMETRY_MAP",ENGLISH_DISPLAY_NAMES.GEOMETRY_MAP),get keywords(){return[...KEYWORDS.GEOGRAPHICAL,...KEYWORDS.LOCATION,...KEYWORDS.SCATTERS,...KEYWORDS.MAPS,...ENGLISH_DISPLAY_NAME_KEYWORDS.GEOMETRY_MAP,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-map-chart-type","qa_charts_bubble-map-chart-type","qa_charts_filled-map-chart-type","qa_charts_grid-map-chart-type","qa_charts_density-map-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.GEOMETRY_MAP","Shows geometries as areas on a map")},{id:"qa_charts_grid-map-chart-type",type:CHART_TYPES.GRID_MAP,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.GRID_MAP",ENGLISH_DISPLAY_NAMES.GRID_MAP),get keywords(){return[...KEYWORDS.GEOGRAPHICAL,...KEYWORDS.LOCATION,...KEYWORDS.BINNED,...KEYWORDS.MAPS,...ENGLISH_DISPLAY_NAME_KEYWORDS.GRID_MAP,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-map-chart-type","qa_charts_bubble-map-chart-type","qa_charts_filled-map-chart-type","qa_charts_geo-map-chart-type","qa_charts_density-map-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.GRID_MAP","Shows geographical data at administrative level on a map as a grid")},{id:"qa_charts_scatter-map-chart-type",type:CHART_TYPES.SCATTER_MAP,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.SCATTER_MAP",ENGLISH_DISPLAY_NAMES.SCATTER_MAP),get keywords(){return[...KEYWORDS.GEOGRAPHICAL,...KEYWORDS.LOCATION,...KEYWORDS.SCATTERS,...KEYWORDS.MAPS,...ENGLISH_DISPLAY_NAME_KEYWORDS.SCATTER_MAP,...splitToKeywords(this.displayName)]},similar:["qa_charts_bubble-map-chart-type","qa_charts_filled-map-chart-type","qa_charts_geo-map-chart-type","qa_charts_grid-map-chart-type","qa_charts_density-map-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.SCATTER_MAP","Shows geographical data as points on a map")},{id:"qa_charts_filled-map-chart-type",type:CHART_TYPES.ADMINISTRATIVE_MAP,variant:CHART_VARIANTS.filledMap,displayName:translate("CHARTS.TYPE_PICKER.NAME.ADMINISTRATIVE_MAP_FILLED",ENGLISH_DISPLAY_NAMES.ADMINISTRATIVE_MAP_FILLED),get keywords(){return[...KEYWORDS.GEOGRAPHICAL,...KEYWORDS.LOCATION,...KEYWORDS.ADMINISTRATIVE,...KEYWORDS.MAPS,...ENGLISH_DISPLAY_NAME_KEYWORDS.ADMINISTRATIVE_MAP_FILLED,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-map-chart-type","qa_charts_bubble-map-chart-type","qa_charts_geo-map-chart-type","qa_charts_grid-map-chart-type","qa_charts_density-map-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.ADMINISTRATIVE_MAP_FILLED","Draws the boundary of geographic data at administrative level as a filled shaped)"),requiredPluginId:"geoadmin",isRequiredPluginInstalled:PluginsService.isPluginLoaded("geoadmin")},{id:"qa_charts_bubble-map-chart-type",type:CHART_TYPES.ADMINISTRATIVE_MAP,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.ADMINISTRATIVE_MAP_BUBBLES",ENGLISH_DISPLAY_NAMES.ADMINISTRATIVE_MAP_BUBBLES),get keywords(){return[...KEYWORDS.GEOGRAPHICAL,...KEYWORDS.LOCATION,...KEYWORDS.ADMINISTRATIVE,...KEYWORDS.MAPS,...ENGLISH_DISPLAY_NAME_KEYWORDS.ADMINISTRATIVE_MAP_BUBBLES,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-map-chart-type","qa_charts_filled-map-chart-type","qa_charts_geo-map-chart-type","qa_charts_grid-map-chart-type","qa_charts_density-map-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.ADMINISTRATIVE_MAP_BUBBLES","Shows geographical data at administrative level on the map as a circle"),requiredPluginId:"geoadmin",isRequiredPluginInstalled:PluginsService.isPluginLoaded("geoadmin")},{id:"qa_charts_density-map-chart-type",type:CHART_TYPES.DENSITY_HEAT_MAP,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.DENSITY_MAP",ENGLISH_DISPLAY_NAMES.DENSITY_MAP),get keywords(){return[...KEYWORDS.GEOGRAPHICAL,...KEYWORDS.LOCATION,...KEYWORDS.SCATTERS,...KEYWORDS.MAPS,...ENGLISH_DISPLAY_NAME_KEYWORDS.DENSITY_MAP,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-map-chart-type","qa_charts_bubble-map-chart-type","qa_charts_filled-map-chart-type","qa_charts_geo-map-chart-type","qa_charts_grid-map-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.DENSITY_MAP","Shows where points are concentrated on a map by their spatial proximity")},{id:"qa_charts_grouped-bubbles-chart-type",type:CHART_TYPES.GROUPED_XY,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.GROUPED_BUBBLES",ENGLISH_DISPLAY_NAMES.GROUPED_BUBBLES),get keywords(){return[...KEYWORDS.ASSOCIATIONS,...KEYWORDS.PATTERNS,...KEYWORDS.RELATIONSHIPS,...KEYWORDS.SCATTERS,...ENGLISH_DISPLAY_NAME_KEYWORDS.GROUPED_BUBBLES,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-plot-chart-type","qa_charts_scatter-plot-multiple-pairs-chart-type","qa_charts_bubble-chart-type","qa_charts_rectangle-chart-type","qa_charts_hexagon-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.GROUPED_BUBBLES","Shows the relationships among continuous numerical variables across a shared dimension")},{id:"qa_charts_bubble-chart-type",type:CHART_TYPES.BINNED_XY,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.BINNED_BUBBLES",ENGLISH_DISPLAY_NAMES.BINNED_BUBBLES),get keywords(){return[...KEYWORDS.ASSOCIATIONS,...KEYWORDS.PATTERNS,...KEYWORDS.RELATIONSHIPS,...KEYWORDS.SCATTERS,...KEYWORDS.BINNED,...ENGLISH_DISPLAY_NAME_KEYWORDS.BINNED_BUBBLES,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-plot-chart-type","qa_charts_scatter-plot-multiple-pairs-chart-type","qa_charts_rectangle-chart-type","qa_charts_hexagon-chart-type","qa_charts_grouped-bubbles-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.BINNED_BUBBLES","Shows the relationships between categorical or binned numerical variables on the axes")},{id:"qa_charts_hexagon-chart-type",type:CHART_TYPES.BINNED_XY,variant:CHART_VARIANTS.binnedXYHexagon,displayName:translate("CHARTS.TYPE_PICKER.NAME.BINNED_HEXAGONS",ENGLISH_DISPLAY_NAMES.BINNED_HEXAGONS),get keywords(){return[...KEYWORDS.ASSOCIATIONS,...KEYWORDS.PATTERNS,...KEYWORDS.RELATIONSHIPS,...KEYWORDS.SCATTERS,...KEYWORDS.BINNED,...ENGLISH_DISPLAY_NAME_KEYWORDS.BINNED_HEXAGONS,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-plot-chart-type","qa_charts_scatter-plot-multiple-pairs-chart-type","qa_charts_bubble-chart-type","qa_charts_rectangle-chart-type","qa_charts_grouped-bubbles-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.BINNED_HEXAGONS","Shows a regular array of hexagons to show density for large datasets")},{id:"qa_charts_rectangle-chart-type",type:CHART_TYPES.BINNED_XY,variant:CHART_VARIANTS.binnedXYRectangle,displayName:translate("CHARTS.TYPE_PICKER.NAME.BINNED_RECTANGLES",ENGLISH_DISPLAY_NAMES.BINNED_RECTANGLES),get keywords(){return[...KEYWORDS.ASSOCIATIONS,...KEYWORDS.PATTERNS,...KEYWORDS.RELATIONSHIPS,...KEYWORDS.SCATTERS,...KEYWORDS.BINNED,...ENGLISH_DISPLAY_NAME_KEYWORDS.BINNED_RECTANGLES,...splitToKeywords(this.displayName)]},similar:["qa_charts_scatter-plot-chart-type","qa_charts_scatter-plot-multiple-pairs-chart-type","qa_charts_bubble-chart-type","qa_charts_hexagon-chart-type","qa_charts_grouped-bubbles-chart-type"],tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.BINNED_RECTANGLES","Shows the relationships between categorical or binned numerical variables")},{id:"qa_charts_boxplot-chart-type",type:CHART_TYPES.BOXPLOTS,variant:CHART_VARIANTS.normal,get keywords(){return[...KEYWORDS.DISTRIBUTION,...KEYWORDS.RANGE,...ENGLISH_DISPLAY_NAME_KEYWORDS.BOXPLOT,...splitToKeywords(this.displayName)]},displayName:translate("CHARTS.TYPE_PICKER.NAME.BOXPLOT",ENGLISH_DISPLAY_NAMES.BOXPLOT),tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.BOXPLOT","Displays the distribution of data showing minimum, Q1, median, Q3 and maximum")},{id:"qa_charts_density-2d-chart-type",type:CHART_TYPES.DENSITY_2D,variant:CHART_VARIANTS.normal,get keywords(){return[...KEYWORDS.DISTRIBUTION,...ENGLISH_DISPLAY_NAME_KEYWORDS["2D_DISTRIBUTION"],...splitToKeywords(this.displayName)]},displayName:translate("CHARTS.TYPE_PICKER.NAME.2D_DISTRIBUTION",ENGLISH_DISPLAY_NAMES["2D_DISTRIBUTION"]),tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.2D_DISTRIBUTION","Shows the bivariate distribution of two fields")},{id:"qa_charts_lift-chart-type",type:CHART_TYPES.LIFT,variant:CHART_VARIANTS.normal,displayName:translate("CHARTS.TYPE_PICKER.NAME.LIFT",ENGLISH_DISPLAY_NAMES.LIFT_CHART),get keywords(){return[...KEYWORDS.MACHINE,...KEYWORDS.LEARNING,...KEYWORDS.MODELS,...ENGLISH_DISPLAY_NAME_KEYWORDS.LIFT_CHART,...splitToKeywords(this.displayName)]},tooltip:translate("CHARTS.TYPE_PICKER.TOOLTIP.LIFT","Measures the effectiveness of models between results with and without a model")}].filter(chartType=>!!chartType)};return svc})})();(function(){"use strict";angular.module("dataiku.charts").service("ChartColorScales",ChartColorScales);function ChartColorScales(ChartUADimension,ChartDataUtils,StringNormalizer,ColorUtils,ChartColorUtils,ChartsStaticData,DKU_PALETTE_NAMES,CHART_AXIS_TYPES){const svc={createColorScale:function(colorContext){if(!colorContext.colorSpec){return null}let colorScale;switch(colorContext.colorSpec.type){case CHART_AXIS_TYPES.DIMENSION:colorScale=svc.discreteColorScale(colorContext.colorOptions,colorContext.defaultLegendDimension,colorContext.chartData,colorContext.colorSpec.withRgba,ChartColorUtils.getColorMeaningInfo(colorContext.colorSpec.dimension,colorContext.chartHandler),colorContext.chartData.getAxisLabels(colorContext.colorSpec.name),colorContext.theme,colorContext.uaColorIndex,colorContext.ignoreLabels,colorContext.colorSpec.ignoreColorDim);if(colorScale.domain){if(colorContext.chartData.getAxisIdx(colorContext.colorSpec.name)!=undefined){colorScale.domain(colorContext.chartData.getAxisLabels(colorContext.colorSpec.name).map(function(d,i){return i}))}else{colorScale.domain(colorContext.defaultLegendDimension.map(function(d,i){return i}))}}break;case CHART_AXIS_TYPES.MEASURE:if(!colorContext.colorSpec.extent){if(colorContext.colorSpec.measureIdx===undefined||colorContext.colorSpec.measureIdx<0){return null}colorContext.colorSpec.extent=ChartDataUtils.getMeasureExtent(colorContext.chartData,colorContext.colorSpec.measureIdx,true,colorContext.colorSpec.binsToInclude,colorContext.colorSpec.colorAggrFn)}if(!colorContext.colorSpec.values){if(colorContext.colorSpec.measureIdx===undefined||colorContext.colorSpec.measureIdx<0){return null}colorContext.colorSpec.values=ChartDataUtils.getMeasureValues(colorContext.chartData.data,colorContext.colorSpec.measureIdx,colorContext.colorSpec.binsToInclude)}colorScale=svc.continuousColorScale(colorContext.colorOptions,colorContext.colorSpec.extent[0],colorContext.colorSpec.extent[1],colorContext.colorSpec.values,!colorContext.colorSpec.withRgba,colorContext.theme,colorContext.colorSpec.binsToInclude);break;case CHART_AXIS_TYPES.UNAGGREGATED:if(!colorContext.colorSpec.dimension){return null}var extent=ChartDataUtils.getUnaggregatedAxisExtent(colorContext.colorSpec.dimension,colorContext.colorSpec.data,colorContext.chartData.data.afterFilterRecords);if(ChartUADimension.isTrueNumerical(colorContext.colorSpec.dimension)||ChartUADimension.isDateRange(colorContext.colorSpec.dimension)){colorScale=svc.continuousColorScale(colorContext.colorOptions,extent.min,extent.max,extent.values,!colorContext.colorSpec.withRgba,colorContext.theme);colorScale.isContinuous=true}else{colorScale=svc.discreteColorScale(colorContext.colorOptions,colorContext.defaultLegendDimension,colorContext.chartData,colorContext.colorSpec.withRgba,ChartColorUtils.getColorMeaningInfo(colorContext.colorSpec.dimension,colorContext.chartHandler),colorContext.colorSpec.data.str.sortedMapping,colorContext.theme,colorContext.uaColorIndex);if(colorScale.domain){colorScale.domain(extent.values.map((v,i)=>i))}}break;case"CUSTOM":{const measures=colorContext.colorSpec.buildGenericMeasures(colorContext.defaultLegendDimension,colorContext.chartData.getAxisLabels(colorContext.colorSpec.name)||[]);colorScale=svc.discreteColorScale(colorContext.colorOptions,measures,colorContext.chartData,colorContext.colorSpec.withRgba,ChartColorUtils.getColorMeaningInfo(colorContext.colorSpec.dimension,colorContext.chartHandler),colorContext.chartData.getAxisLabels(colorContext.colorSpec.name),colorContext.theme,colorContext.uaColorIndex,colorContext.ignoreLabels,colorContext.colorSpec.ignoreColorDim);if(colorScale.domain){colorScale.domain(measures.map(function(d,i){return i}));colorScale.customHandle=colorContext.colorSpec.handle}break}default:throw new Error("Unknown scale type: "+colorContext.colorSpec.type)}if(colorScale){colorScale.type=colorContext.colorSpec.type}return colorScale},continuousColorScale:function(colorOptions,domainMin,domainMax,domainValues,noRgba,theme,binsToInclude){const isDiverging=colorOptions.paletteType==="DIVERGING";let p=ChartColorUtils.getContinuousPalette(colorOptions.colorPalette,colorOptions.customPalette,isDiverging,theme);if(!p){const defaultDivergingPalette=theme?.palettes.diverging??ChartsStaticData.DEFAULT_DIVERGING_PALETTE;const defaultContinuousPalette=theme?.palettes.continuous??ChartsStaticData.DEFAULT_CONTINUOUS_PALETTE;const defaultPaletteId=isDiverging?defaultDivergingPalette:defaultContinuousPalette;colorOptions.colorPalette=defaultPaletteId;p=ChartColorUtils.getContinuousPalette(colorOptions.colorPalette,colorOptions.customPalette,isDiverging,theme)}function d3_interpolateRgbRound(a,b){const transparency=!isNaN(colorOptions.transparency)?colorOptions.transparency:1;a=d3.rgb(a);b=d3.rgb(b);const ar=a.r,ag=a.g,ab=a.b,br=b.r-ar,bg=b.g-ag,bb=b.b-ab;return function(t){const tr=Math.round(ar+br*t);const tg=Math.round(ag+bg*t);const tb=Math.round(ab+bb*t);if(!noRgba){return["rgba(",tr,",",tg,",",tb,",",transparency,")"].join("")}else{return["rgb(",tr,",",tg,",",tb,")"].join("")}}}if(p.d3Scale){return p.d3Scale}let innerScale;if(colorOptions.quantizationMode!=="QUANTILES"){if(colorOptions.ccScaleMode=="LOG"){innerScale=d3.scale.log();domainMin++;domainMax++;innerScale.mode="LOG"}else if(colorOptions.ccScaleMode=="SQRT"){innerScale=d3.scale.sqrt();innerScale.mode="SQRT"}else if(colorOptions.ccScaleMode=="SQUARE"){innerScale=d3.scale.pow().exponent(2);innerScale.mode="SQUARE"}else{innerScale=d3.scale.linear();innerScale.mode="LINEAR"}}else{innerScale=d3.scale.linear();innerScale.mode="LINEAR"}switch(colorOptions.paletteType){case"DIVERGING":var mid=colorOptions.paletteMiddleValue||0;if(Math.abs(domainMax-mid)>Math.abs(domainMin-mid)){innerScale.domain([mid,domainMax]).range([.5,1])}else{innerScale.domain([domainMin,mid]).range([0,.5])}break;case"CONTINUOUS":default:if(p.fixedValues){const domain=[],range=[];p.values.forEach(function(value,i){if(i>p.colors.length-1){return}if(value==null){if(i==0){domain.push(domainMin);range.push(0)}else if(i==p.colors.length-1){domain.push(domainMax);range.push(1)}}else{domain.push(value);range.push(i/(p.colors.length-1))}});innerScale.domain(domain).range(range)}else{innerScale.domain([domainMin,domainMax]).range([0,1])}break}let outerScale;switch(colorOptions.quantizationMode){case"LINEAR":case"QUANTILES":var numSteps=colorOptions.numQuantizeSteps;var colors=p[numSteps]||p.colors;var numColors=colors.length;var linearScale=d3.scale.linear().domain(Array(numColors).fill().map(function(d,i){return i/(numColors-1)})).range(colors).interpolate(d3_interpolateRgbRound);var steps=Array(numSteps).fill().map(function(d,i){return linearScale(i/(numSteps-1))});if(colorOptions.quantizationMode==="LINEAR"){outerScale=d3.scale.quantize().domain([0,1]).range(steps)}else{outerScale=d3.scale.quantile().domain(domainValues.map(innerScale)).range(steps)}break;case"NONE":default:outerScale=d3.scale.linear().domain(Array(p.colors.length).fill().map(function(d,i){return i/(p.colors.length-1)})).range(p.colors).interpolate(d3_interpolateRgbRound);break}const ret=function(d,bin){if(binsToInclude&&!binsToInclude.has(bin)){return undefined}return outerScale(innerScale(d))};ret.outerScale=outerScale;ret.innerScale=innerScale;ret.quantizationMode=colorOptions.quantizationMode;ret.diverging=colorOptions.paletteType==="DIVERGING";return ret},discreteColorScale:function(colorOptions,defaultLegendDimension,chartData,withRgba,meaningInfo,colorLabels,theme,uaColorIndex,ignoreLabels,ignoreColorDim){if(!colorOptions.colorPalette){colorOptions.colorPalette=theme?.palettes?.discrete??ChartsStaticData.DEFAULT_DISCRETE_PALETTE}if(colorOptions.colorPalette===DKU_PALETTE_NAMES.MEANING){return svc.meaningColorScale(colorOptions,withRgba,meaningInfo,colorLabels)}let p=ChartColorUtils.getDiscretePalette(colorOptions.colorPalette,colorOptions.customPalette,theme);if(!p){colorOptions.colorPalette=theme?.palettes?.discrete??ChartsStaticData.DEFAULT_DISCRETE_PALETTE;p=ChartColorUtils.getDiscretePalette(colorOptions.colorPalette,colorOptions.customPalette,theme)}if(p.d3Scale){return p.d3Scale}else{let colorScale=d3.scale.ordinal().range(p.colors);if(colorOptions.customColors&&Object.keys(colorOptions.customColors).length){colorScale=svc.customColorScale(colorOptions,defaultLegendDimension,chartData,colorScale,uaColorIndex,ignoreLabels,ignoreColorDim)}return withRgba?convertToRgbaColorScale(colorScale,colorOptions.transparency):colorScale}},meaningColorScale:function(colorOptions,withRgba,meaningInfo,colorLabels){const normalizer=StringNormalizer.get(meaningInfo.normalizationMode);const ret=function(idx){if(withRgba){return ColorUtils.toRgba(meaningInfo.colorMap[normalizer(colorLabels[idx].label)]||"grey",colorOptions.transparency)}else{return meaningInfo.colorMap[normalizer(colorLabels[idx].label)]||"grey"}};ret.domain=function(){return Array.from(Array(colorLabels.length).keys())};return ret},customColorScale:function(colorOptions,dimension,chartData,colorScale,uaColorIndex,ignoreLabels,ignoreColorDim){const colorScaleProxy=index=>{const customColors=colorOptions.customColors;const id=ChartColorUtils.getColorId(dimension,chartData,index,uaColorIndex,ignoreLabels,ignoreColorDim&&ignoreColorDim(index,dimension));if(id in customColors){return customColors[id]}return colorScale(index)};colorScaleProxy.range=colorScale.range;colorScaleProxy.domain=colorScale.domain;return colorScaleProxy},getColor:function(uaColor,color,i,colorScale,colorCache){let cacheKey,rgb;if(ChartUADimension.isTrueNumerical(uaColor[0])){cacheKey=color.num.data[i]}else if(ChartUADimension.isDateRange(uaColor[0])){cacheKey=color.ts.data[i]}else{cacheKey=color.str.data[i]}if(colorCache[cacheKey]){rgb=colorCache[cacheKey]}else{rgb=colorScale(cacheKey);colorCache[cacheKey]=rgb}return rgb}};function convertToRgbaColorScale(colorScale,transparency){const rgbaColorScale=index=>{const color=colorScale(index);return ColorUtils.toRgba(color,transparency)};rgbaColorScale.range=colorScale.range;rgbaColorScale.domain=colorScale.domain;return rgbaColorScale}function createSamples(){$.each(window.dkuColorPalettes.continuous,function(idx,p){if(!p.sample){const scale=svc.continuousColorScale({colorPalette:p.id,transparency:1},0,100);p.sample=$.map([0,20,40,60,80,100],scale);p.sample2=$.map([0,10,20,30,40,50,60,70,80,90,100],scale)}});$.each(window.dkuColorPalettes.discrete,function(idx,p){if(!p.sample){const scale=svc.discreteColorScale({colorPalette:p.id,transparency:1});p.sample=$.map([0,1,2,3,4],scale)}})}createSamples();return svc}})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("ChartColorSelection",function(ChartCustomColors,ChartColorUtils,CHART_TYPES){const customColorsOptions={id:null,colorOptions$:null,listeners:0};const geoLayerCustomColorsOptions={};function getGeomMapUaColor(chartDef,geoLayer){if(chartDef.geoLayers.length<3&&geoLayer===undefined){return chartDef.geoLayers[0].uaColor}else{return geoLayer.uaColor}}return{getOptions:function(chartDef,geoLayer){if(chartDef.type!==CHART_TYPES.GEOMETRY_MAP){return chartDef.colorOptions}else if(chartDef.geoLayers.length<3&&geoLayer===undefined){return chartDef.geoLayers[0].colorOptions}else{return geoLayer.colorOptions}},setOptions:function(colorOptions,chartDef,geoLayer){if(chartDef.type!==CHART_TYPES.GEOMETRY_MAP){chartDef.colorOptions=colorOptions}else if(chartDef.geoLayers.length<3&&geoLayer===undefined){chartDef.geoLayers[0].colorOptions=colorOptions}else{geoLayer.colorOptions=colorOptions}},getUaColor:function(chartDef,geoLayer){if(chartDef.type!==CHART_TYPES.GEOMETRY_MAP){return chartDef.uaColor}else{return getGeomMapUaColor(chartDef,geoLayer)}},getColorMeasure:function(chartDef){return chartDef.colorMeasure},getColorDimensionOrMeasure:function(chartDef,geoLayer){if(chartDef.type!==CHART_TYPES.GEOMETRY_MAP){return ChartColorUtils.getColorDimensionOrMeasure(chartDef)}else{return getGeomMapUaColor(chartDef,geoLayer)[0]}},getOrCreateCustomColorsOptions(geoLayerId){if(geoLayerId){if(_.isNil(geoLayerCustomColorsOptions[geoLayerId])){const{colorOptions$}=ChartCustomColors.createColorOptions();geoLayerCustomColorsOptions[geoLayerId]=colorOptions$}return{id:geoLayerId,colorOptions$:geoLayerCustomColorsOptions[geoLayerId]}}else{if(_.isNil(customColorsOptions.id)){const{id,colorOptions$}=ChartCustomColors.createColorOptions();customColorsOptions.id=id;customColorsOptions.colorOptions$=colorOptions$}customColorsOptions.listeners++;return customColorsOptions}},removeCustomColorsOptions(ids){(ids||[]).forEach(id=>{if(id.startsWith("geo")){delete customColorsOptions[id];ChartCustomColors.removeColorOptions([id])}else if(customColorsOptions.id===id){customColorsOptions.listeners--;if(customColorsOptions.listeners===0){customColorsOptions.id=null;customColorsOptions.colorOptions$=null;ChartCustomColors.removeColorOptions([id])}}else{throw new Error("Ids not found")}})}}})})();(function(){"use strict";angular.module("dataiku.charts").service("ChartContextualMenu",ChartContextualMenu);function ChartContextualMenu($rootScope,$stateParams,ChartFilters,ContextualMenu,AnimatedChartsUtils,DashboardFilters,DashboardUtils,ChartDrilldown,ChartFeatures,ChartHierarchyDimension,ChartDimension,ChartDrilldownType,translate,DRILL_UP_SOURCE,DRILL_DOWN_SOURCE){const svc={create:function(chartData,chartDef,chartStore,animation={}){const isInDashboard=DashboardUtils.isInDashboard();const contextualMenu={open:function({event,filteringOptions={filterableElements:[]},hierarchyDrillableElements=[],nativeDrillableElements=[],customActions=[],type="measure"}){let canFilter,canDrillHierarchy,canDrillNative,menu;const newScope=$rootScope.$new();newScope.customActions=customActions;newScope.ChartDrilldownType=ChartDrilldownType;switch(type){case"measure":canFilter=(!isInDashboard||DashboardFilters.canCrossFilter($stateParams.pageId))&&filteringOptions.filterableElements.length>0;canDrillHierarchy=ChartFeatures.canDrillHierarchy(chartDef.type)&&!!hierarchyDrillableElements.length&&hierarchyDrillableElements.some(el=>el.drilldown||el.drillup);canDrillNative=!isInDashboard&&!!nativeDrillableElements.length&&nativeDrillableElements.some(el=>el.elements.length);if(canFilter||canDrillHierarchy||canDrillNative||customActions.length){menu=new ContextualMenu({contextual:false,template:"/templates/simple_report/contextual-menu/chart-contextual-menu.html"});const data={canFilter:canFilter,canHierarchyDrillDown:canDrillHierarchy&&hierarchyDrillableElements.some(el=>el.drilldown),canHierarchyDrillUp:canDrillHierarchy&&hierarchyDrillableElements.some(el=>el.drillup),disableMultiDimensionalFiltering:filteringOptions.disableMultiDimensionalFiltering,filterableElements:filteringOptions.filterableElements,hierarchyDrillupElements:hierarchyDrillableElements.filter(el=>el.drillup),hierarchyDrilldownElements:hierarchyDrillableElements.filter(el=>el.drilldown),nativeDrillableElements:nativeDrillableElements,canDrillNative:canDrillNative,drillDownHierarchy:contextualMenu.drillDownHierarchy,drillUpHierarchy:contextualMenu.drillUpHierarchy,drillDownNative:contextualMenu.drillDownNative,includeOnly:contextualMenu.includeOnly,exclude:contextualMenu.exclude,getHierarchyName:contextualMenu.getHierarchyName};newScope.data=angular.copy(data)}break;case"pivotTableHeader":menu=new ContextualMenu({contextual:false,template:"/templates/simple_report/contextual-menu/pivot-table-header-contextual-menu.html"});break;case"background":menu=new ContextualMenu({contextual:false,template:"/templates/simple_report/contextual-menu/chart-contextual-menu.html"});break}if(!menu){return}menu.scope=newScope;menu.openAtXY(event.pageX,event.pageY);menu.$menu.addClass("chart-contextual-menu")},includeOnly:filterableElements=>{if(isInDashboard){const filters=filterableElements.map(filterableElement=>{const{dimension,axisElt,value}=filterableElement;return ChartFilters.createFilter({column:dimension.column,columnType:dimension.type,isAGlobalFilter:true,excludeOtherValues:true,label:`ONLY ${dimension.column}: ${value}`,useMinimalUi:true,includeEmptyValues:false},{dimension:dimension,axisElt:axisElt})});$rootScope.$emit("crossFiltersAdded",{filters:filters,wt1Args:{from:"chart",action:"contextual_menu",chartType:chartDef.type,filterType:"include"}})}else{let filters=chartDef.filters;filterableElements.forEach(filterableElement=>{const{dimension,axisElt}=filterableElement;const{oldFilter,newFilter}=ChartFilters.getIncludeOnly1DFilter(dimension,axisElt,filters);if(!ChartFilters.areFiltersEqual(oldFilter,newFilter)){filters=ChartFilters.updateOrAddFilter(filters,newFilter,oldFilter)}});chartDef.filters=filters}},exclude:filterableElements=>{const filter=ChartFilters.getExcludeNDFilter(filterableElements);if(isInDashboard){filter.isAGlobalFilter=true;$rootScope.$emit("crossFiltersAdded",{filters:[filter],wt1Args:{from:"chart",action:"contextual_menu",chartType:chartDef.type,filterType:"exclude"}})}else if(!chartDef.filters.some(f=>ChartFilters.areFiltersEqual(f,filter))){chartDef.filters=ChartFilters.updateOrAddFilter(chartDef.filters,filter)}},drillDownHierarchy:drillableElement=>{ChartDrilldown.handleDrillDown(chartDef,drillableElement.dimension,DRILL_DOWN_SOURCE.CONTEXTUAL_MENU,drillableElement.axisElt)},drillUpHierarchy:drillableElement=>{ChartDrilldown.handleDrillUp(chartDef,drillableElement.dimension,DRILL_UP_SOURCE.CONTEXTUAL_MENU)},drillDownNative:drillableElement=>{const{updatedFilters,newDateRange}=ChartDrilldown.getUpdateForNativeDrillDown(chartDef,drillableElement.axisElt,drillableElement.dimension);if(newDateRange){_.set(chartDef,`${drillableElement.propertyName}.dateParams.mode`,newDateRange)}chartDef.filters=updatedFilters},showForCoords:(coords,event,customActions,type)=>{const finalCoords={...coords,animation:AnimatedChartsUtils.getAnimationCoord(animation)};const filteringOptions=ChartFilters.getFilterableOptions(chartStore,chartData,finalCoords,chartDef);const hierarchyDrillableElements=ChartDrilldown.getDrillableElements(chartStore,chartDef,chartData,finalCoords);const binDrillableElements=filteringOptions.filterableElements.filter(el=>ChartDimension.isDrillableForElement(chartDef,el.dimension,el.axisElt)&&ChartDimension.isGroupedNumerical(el.dimension));const dateDrillableElements=filteringOptions.filterableElements.filter(el=>ChartDimension.isDrillableForElement(chartDef,el.dimension,el.axisElt)&&!ChartDimension.isGroupedNumerical(el.dimension));const nativeDrillableElements=[{drilldownType:ChartDrilldownType.BIN,actionLabel:translate("CHARTS.CONTEXTUAL_MENU.DRILL_DOWN.BIN","Drill down on bin"),elements:binDrillableElements},{drilldownType:ChartDrilldownType.DATE,actionLabel:translate("CHARTS.CONTEXTUAL_MENU.DRILL_DOWN.DATE","Drill down on date"),elements:dateDrillableElements}];contextualMenu.open({event:event,filteringOptions:filteringOptions,hierarchyDrillableElements:hierarchyDrillableElements,nativeDrillableElements:nativeDrillableElements,customActions:customActions,type:type})},addContextualMenuHandler:(domElement,coords,customActions,type)=>{d3.select(domElement).on("contextmenu.contextualmenu",()=>{d3.event.preventDefault();contextualMenu.showForCoords(coords,d3.event,customActions,type)})},removeContextualMenuHandler:el=>{d3.select(el).on("contextmenu",null)},addChartContextualMenuHandler:(chart,getTargetElementProperties,getCustomActions)=>{d3.select(chart).on("contextmenu.contextualmenu",function(){const target=d3.event.target;const properties=getTargetElementProperties&&getTargetElementProperties(target);const customActions=getCustomActions?getCustomActions(properties):[];if(!_.isNil(properties)){d3.event.preventDefault();contextualMenu.showForCoords(properties.coords,d3.event,customActions)}else if(ChartFeatures.canDrillHierarchy(chartDef.type)&&customActions.length&&target.classList.contains("chart-contextual-menu-anchor")){d3.event.preventDefault();contextualMenu.open({event:d3.event,customActions:customActions,type:"background"})}})},removeChartContextualMenuHandler:chart=>{d3.select(chart).on("contextmenu",null)},getAnimationContext:function(){return AnimatedChartsUtils.getAnimationContext(chartDef.animationDimension[0],animation)},getHierarchyName:function(dimension){return ChartHierarchyDimension.getDimensionHierarchyName(chartDef,dimension)}};return contextualMenu}};return svc}})();(function(){"use strict";angular.module("dataiku.charts").service("D3ChartAxes",D3ChartAxes);const SCALE_TYPES={ORDINAL:"ORDINAL",LINEAR:"LINEAR",LOG:"LOG",TIME:"TIME"};function D3ChartAxes(d3Utils,CHART_AXIS_TYPES,CHART_TYPES,CHART_MODES,ChartDimension,ChartUADimension,ChartAxesUtils,AxisTicksConfigMode,ChartFeatures,ChartFormatting,ChartsStaticData,AxisTicksConfiguration,ChartYAxisPosition,ChartFormattingPaneSections,GridlinesAxisType,ChartDataUtils,ChartLabels,ChartMeasure,CHART_VARIANTS,ValuesInChartPlacementMode,ChartPropertiesService){const addFormatterToBinnedAxis=(axis,tickExtents,formattingOptions)=>{axis.tickFormat(ChartFormatting.getForBinnedAxis(tickExtents,formattingOptions))};const addFormatterToCustomBinnedAxis=(axis,tickExtents,formattingOptions)=>{axis.tickFormat(ChartFormatting.getForCustomBinnedAxis(tickExtents,formattingOptions))};const addFormatterToOrdinalAxis=(axis,tickExtents,formattingOptions)=>{axis.tickFormat((_d,i)=>{const value=tickExtents[i];return ChartFormatting.getForOrdinalAxis(value,formattingOptions)})};const addFormatterToPercentageAxis=(axis,formattingOptions={})=>{const scale=axis.scale()instanceof Function?axis.scale():axis.scale;const minValue=(Math.min(...scale.domain())||0)*100;const maxValue=(Math.max(...scale.domain())||0)*100;const numValues=axis.tickValues()?axis.tickValues().length:axis.ticks()[0];axis.tickFormat(ChartFormatting.getForAxis(minValue,maxValue,numValues,formattingOptions,true))};const getTicksForGridlines=(axisG,axisToCheck,chartG)=>{const ticks=axisG.selectAll("g.tick")[0];return ticks&&ticks.filter(tick=>{const tickTranslate=tick.getAttribute("transform");const tickTranslateValue=tickTranslate.match(/translate\(([^,]+),([^,]+)\)/);if(axisToCheck==="x"){const axisG=chartG.select("g.x.axis")[0][0];const axisTranslate=axisG&&axisG.getAttribute("transform");const axisTranslateValue=axisTranslate?axisTranslate.match(/translate\(([^,]+),([^,]+)\)/):"0";return tickTranslateValue[2]!==axisTranslateValue[2]}else if(axisToCheck==="y"){return tickTranslateValue[1]!=="0"}})};const adjustAxisPadding=function(axis,extent,axisSize,valuesFontSize,addPaddingToStart,addPaddingToEnd){if(!addPaddingToStart&&!addPaddingToEnd){return}const diff=extent[1]-extent[0];const domainPadding=valuesFontSize/((axisSize-valuesFontSize)/diff);const paddedDomain=[extent[0]-(addPaddingToStart?domainPadding:0),extent[1]+(addPaddingToEnd?domainPadding:0)];axis.scale().domain(paddedDomain)};const computeTextHeightFromFontSize=svgs=>fontSize=>{let result=fontSize;const textElement=d3.select(svgs.get(0)).append("text").attr("class","measureInChartTempText").attr("opacity",0).attr("font-size",`${fontSize}px`).text("0");if(textElement){const textHeight=textElement.node()?.getBBox().height;textElement.remove();if(textHeight){result=textHeight}}return result};const svc={scaleTypes:Object.freeze(SCALE_TYPES),createAxis:function(chartData,axisSpec,isPercentScale,isLogScale,includeZero,formattingOptions,chartDef,ignoreLabels,otherAxesIndexes=[]){if(!axisSpec||!formattingOptions){return null}let axis;switch(axisSpec.type){case CHART_AXIS_TYPES.DIMENSION:case CHART_AXIS_TYPES.UNAGGREGATED:axis=svc.createDimensionAxis(chartData,axisSpec,isLogScale,includeZero,formattingOptions,chartDef,ignoreLabels);break;case CHART_AXIS_TYPES.MEASURE:axis=svc.createMeasureAxis(chartData,axisSpec,isPercentScale,isLogScale,includeZero,formattingOptions,otherAxesIndexes);break;default:throw new Error("Unknown axis type: "+axisSpec.type)}if(axis){axis.type=axisSpec.type;axis.position=axisSpec.position;axis.id=axisSpec.id}return axis},createDimensionAxis:function(chartData,axisSpec,isLogScale,includeZero,formattingOptions,chartDef,ignoreLabels){const isNumerical=ChartAxesUtils.isNumerical(axisSpec);const isDualAxis=!!chartData.hasDualDimensionAxis?.(axisSpec.name);let extent=ChartAxesUtils.getDimensionExtent(chartData,axisSpec,ignoreLabels);if(!isLogScale&&!ChartAxesUtils.isManualMode(axisSpec.customExtent)){extent=ChartAxesUtils.fixUnbinnedNumericalExtent(axisSpec,extent)}if(includeZero&&isNumerical){extent=ChartAxesUtils.includeZero(extent)}const linearScale=d3.scale.linear().domain([extent.min,extent.max]);const ordinalScale=d3.scale.ordinal().domain(extent.values.map(function(d,i){return i}));let timeScale;let logScale;let axis;if(isLogScale&&isNumerical){extent=ChartAxesUtils.fixNumericalLogScaleExtent(axisSpec,extent,includeZero);logScale=d3.scale.log().domain([extent.min,extent.max])}const createNumericAxis=()=>{let axis;if(logScale){axis=d3.svg.axis().scale(logScale);axis.scaleType=SCALE_TYPES.LOG;svc.setLogAxisTicks(axis,extent.min,extent.max)}else{axis=d3.svg.axis().scale(linearScale);axis.scaleType=SCALE_TYPES.LINEAR}svc.addNumberFormatterToAxis(axis,formattingOptions);return axis};const createOrdinalAxis=(isGroupedNumerical=false,isCustomBinning=false)=>{const axis=d3.svg.axis().scale(ordinalScale);if(isCustomBinning){addFormatterToCustomBinnedAxis(axis,extent.values,formattingOptions)}else if(isGroupedNumerical){addFormatterToBinnedAxis(axis,extent.values,formattingOptions)}else{addFormatterToOrdinalAxis(axis,extent.values,formattingOptions)}axis.scaleType=SCALE_TYPES.ORDINAL;return axis};const createTimeAxis=()=>{timeScale=d3.time.scale.utc().domain([extent.min,extent.max]);const timeAxis=d3.svg.axis().scale(timeScale);timeAxis.scaleType=SCALE_TYPES.TIME;return timeAxis};if(chartDef.type===CHART_TYPES.BOXPLOTS){axis=createOrdinalAxis(ChartDimension.isGroupedNumerical(axisSpec.dimension))}else{if(ChartDimension.isTimeline(axisSpec.dimension)||axisSpec.type===CHART_AXIS_TYPES.UNAGGREGATED&&ChartUADimension.isDate(axisSpec.dimension)){axis=(extent.min!==extent.max?createTimeAxis():createNumericAxis()).tickFormat(d=>ChartFormatting.getForDate()(d))}else if(ChartDimension.isUngroupedNumerical(axisSpec.dimension)){axis=createNumericAxis()}else if(ChartDimension.isGroupedNumerical(axisSpec.dimension)||axisSpec.type===CHART_AXIS_TYPES.UNAGGREGATED&&ChartUADimension.isTrueNumerical(axisSpec.dimension)){if(ChartDimension.hasOneTickPerBin(axisSpec.dimension)&&ChartFeatures.chartSupportOneTickPerBin(chartDef)){axis=createOrdinalAxis(!isDualAxis)}else{axis=createNumericAxis()}}else{axis=createOrdinalAxis()}}axis.ordinalScale=ordinalScale;axis.linearScale=linearScale;axis.setScaleRange=function(range){(logScale||timeScale||linearScale).range(range);const numColumns=ordinalScale.domain().length;const step=range[range.length-1]/numColumns;const padding=svc.getColumnPadding(numColumns);const axisPadding=axisSpec.padding??.5;switch(axisSpec.mode){case CHART_MODES.POINTS:if(step>=1){ordinalScale.rangeRoundPoints(range,axisPadding,0)}else{ordinalScale.rangePoints(range,axisPadding,0)}break;case CHART_MODES.COLUMNS:{if(step>=1){ordinalScale.rangeRoundBands(range,padding,padding/2)}else{ordinalScale.rangeBands(range,padding,padding/2)}break}default:throw new Error("Unknown scale type: "+axisSpec.mode)}return axis};svc.fixUpAxis(axis);axis.dimension=axisSpec.dimension;return axis},getColumnPadding:function(numColumns){if(numColumns>20){return.1}else{return.45-numColumns/20*.35}},createMeasureAxis:function(chartData,axisSpec,isPercentScale,isLogScale,includeZero,formattingOptions,otherAxesIndexes=[]){axisSpec.extent=ChartAxesUtils.getMeasureExtent(chartData,axisSpec,isLogScale,includeZero,true,otherAxesIndexes);if(axisSpec.extent===null){return null}const scale=isLogScale?d3.scale.log():d3.scale.linear(),axis=d3.svg.axis().scale(scale).orient("left");scale.domain(axisSpec.extent);if(isPercentScale||axisSpec.isPercentScale){addFormatterToPercentageAxis(axis,formattingOptions)}else{svc.addNumberFormatterToAxis(axis,formattingOptions)}if(isLogScale){svc.setLogAxisTicks(axis,axisSpec.extent[0],axisSpec.extent[1])}axis.setScaleRange=function(range){scale.range(range)};svc.fixUpAxis(axis);axis.measure=axisSpec.measure;return axis},setLogAxisTicks:function(axis,minVal,maxVal){const maxValLog=Math.floor(log10(maxVal));const minValLog=Math.ceil(log10(minVal));const arr=[];for(let i=minValLog;i<=maxValLog;i++){arr.push(Math.pow(10,i))}axis.tickValues(arr)},sanitizeTicksDisplay:function(sortedTicks,forceLastTickDisplay=false,onlyRemoveLabel=false){let left=0;let right=1;const overlappingTicks=[];const length=forceLastTickDisplay?sortedTicks.length:sortedTicks.length-1;while(right<length){if(sortedTicks[left].textContent===sortedTicks[right].textContent||areBboxOverlapping(sortedTicks[left].getBoundingClientRect(),sortedTicks[right].getBoundingClientRect())){overlappingTicks.push(sortedTicks[right]);right++}else{left=right++}}while(!forceLastTickDisplay&&left>=0&&areBboxOverlapping(sortedTicks[left].getBoundingClientRect(),sortedTicks[sortedTicks.length-1].getBoundingClientRect())){overlappingTicks.push(sortedTicks[left--])}overlappingTicks.forEach(tick=>{if(onlyRemoveLabel){const labelDom=tick.querySelector("text");labelDom&&labelDom.remove()}else{tick.remove()}});return overlappingTicks},fixUpAxis:function(axis){const scale=axis.scale();if(scale.domain().length==2&&scale.domain()[0]==scale.domain()[1]){axis.tickValues([scale.domain()[0]]);scale.domain([scale.domain()[0]-1,scale.domain()[0]+1])}},adjustBottomMargin:function(axisTicksFormatting,margins,$svg,xAxis,forceRotation=0){const chartHeight=$svg.height(),chartWidth=$svg.width(),svg=d3.select($svg.get(0));let labels,usedBand;if(xAxis.type===CHART_AXIS_TYPES.MEASURE||xAxis.scaleType===SCALE_TYPES.LINEAR||xAxis.scaleType===SCALE_TYPES.TIME){const ticks=xAxis.tickValues()||xAxis.scale().ticks();labels=xAxis.tickFormat()?ticks.map(xAxis.tickFormat()):ticks;usedBand=(chartWidth-margins.left-margins.right)/(labels.length+1)}else{const ticks=xAxis.tickValues()||xAxis.ordinalScale.domain();labels=xAxis.tickFormat()?ticks.map(xAxis.tickFormat()):ticks;if(xAxis.ordinalScale.rangeBand()>0){usedBand=xAxis.ordinalScale.rangeBand()}else{usedBand=(chartWidth-margins.left-margins.right)/(labels.length+1)}}if(labels.length==0){return margins}svg.selectAll(".tempText").data(labels).enter().append("text").attr("class","tempText").text(function(d){return ChartFormatting.getForOrdinalAxis(d)});const maxLabelWidth=d3.max(svg.selectAll(".tempText")[0].map(function(itm){return itm.getBoundingClientRect().width}));const labelHeight=axisTicksFormatting.fontSize;const hasLongLabels=!svg.selectAll(".tempText").filter(function(){return this.getBoundingClientRect().width>usedBand}).empty();svg.selectAll(".tempText").remove();if(forceRotation){xAxis.labelAngle=forceRotation}else{xAxis.labelAngle=hasLongLabels?Math.atan(labelHeight*2/usedBand):0}if(xAxis.labelAngle>Math.PI/3){xAxis.labelAngle=Math.PI/2}margins.bottom=Math.min(chartHeight/4,margins.bottom+Math.sin(xAxis.labelAngle)*maxLabelWidth+Math.cos(xAxis.labelAngle)*labelHeight);return margins},getHorizontalMarginsAndAxesWidth:function(margins,$svg,chartDef,yAxes,chartTileProperties){const axesWidth=[];margins[ChartYAxisPosition.LEFT]=ChartsStaticData.CHART_BASE_MARGIN;margins[ChartYAxisPosition.RIGHT]=ChartsStaticData.CHART_BASE_MARGIN;yAxes.forEach(axis=>{const tempMargins={[ChartYAxisPosition.LEFT]:0,[ChartYAxisPosition.RIGHT]:0};const side=axis.position;const axisFormatting=ChartAxesUtils.getFormattingForYAxis(chartDef.yAxesFormatting,axis.id);if(axis&&ChartPropertiesService.showYAxis(axisFormatting,chartTileProperties)){let labels;if(axis.type===CHART_AXIS_TYPES.MEASURE||axis.scaleType===SCALE_TYPES.LINEAR||axis.scaleType===SCALE_TYPES.TIME){labels=axis.scale().ticks()}else{labels=axis.ordinalScale.domain()}const manualTicks=axis.tickValues();if(manualTicks){labels=manualTicks}labels=axis.tickFormat()?labels.map(axis.tickFormat()):labels;const svg=d3.select($svg.get(0));svg.selectAll(".tempText").data(labels).enter().append("text").attr("class","tempText").attr("font-size",`${axisFormatting.axisValuesFormatting.axisTicksFormatting.fontSize}px`).text(function(d){return d});const maxLabelWidth=d3.max(svg.selectAll(".tempText")[0].map(function(itm){return itm.getBoundingClientRect().width}))||0;tempMargins[side]+=maxLabelWidth+ChartsStaticData.AXIS_WIDTH;svg.selectAll(".tempText").remove()}const canHaveAxisTitle=!_.isNil(axisFormatting.axisTitle)&&axisFormatting.axisTitle.length>0||axis&&(axis.dimension!==undefined||axis.measure!==undefined)||ChartAxesUtils.getMeasuresDisplayedOnAxis(axis.position,chartDef.genericMeasures).length>=1;if(canHaveAxisTitle&&ChartPropertiesService.showYAxisTitle(axisFormatting,chartTileProperties)){tempMargins[side]+=ChartsStaticData.AXIS_MARGIN+axisFormatting.axisTitleFormatting.fontSize}margins.left+=tempMargins.left;margins.right+=tempMargins.right;axesWidth.push({id:axis.id,width:tempMargins[side]})});const leftYAxesNb=yAxes.filter(axis=>ChartAxesUtils.isLeftYAxis(axis)).length;if(leftYAxesNb>1){margins.left+=(leftYAxesNb-1)*ChartsStaticData.AXIS_Y_SPACING}return{updatedMargins:margins,axesWidth:axesWidth}},getMarginsAndAxesWidth:function(chartHandler,chartDef,$svg,xAxis,yAxes){let margins={top:ChartsStaticData.CHART_BASE_MARGIN,bottom:ChartsStaticData.CHART_BASE_MARGIN};if(ChartFeatures.canDisplayAxes(chartDef.type)){if(ChartPropertiesService.showXAxis(chartDef.xAxisFormatting,chartHandler.chartTileProperties)){margins.bottom+=ChartsStaticData.AXIS_WIDTH}const canHaveAxisTitle=ChartFeatures.canShowXAxisTitle(chartDef)&&(!_.isNil(chartDef.xAxisFormatting.axisTitle)&&chartDef.xAxisFormatting.axisTitle.length>0||xAxis&&(xAxis.dimension!==undefined||xAxis.measure!==undefined)||ChartDimension.getGenericDimensions(chartDef).length===1);if(canHaveAxisTitle&&ChartPropertiesService.showXAxisTitle(chartDef.xAxisFormatting,chartHandler.chartTileProperties)){margins.bottom+=ChartsStaticData.AXIS_MARGIN+chartDef.xAxisFormatting.axisTitleFormatting.fontSize}}const{updatedMargins,axesWidth}=svc.getHorizontalMarginsAndAxesWidth(margins,$svg,chartDef,yAxes,chartHandler.chartTileProperties);margins=updatedMargins;const yAxesWidth=axesWidth;return{margins:margins,yAxesWidth:yAxesWidth}},alignAndSetYTickValues:function(axes,axisOptions,yAxesFormatting){const axesMins=[];const availableAxesMins=[];const axesMaxes=[];const availableAxesMaxes=[];const axesRes=[];const isAxisCompatible=axis=>{const isAxisLogScale=(yAxesFormatting.find(v=>v.id===axis.id)||{}).isLogScale;const[axisMin]=axis&&svc.getCurrentAxisExtent(axis)||[];const isZeroInRange=axisMin<=0;return(!axis.dimension||ChartAxesUtils.isNumerical({dimension:axis.dimension}))&&!isAxisLogScale&&isZeroInRange};const availableAxes=axes.filter(axis=>isAxisCompatible(axis));axes.forEach(axis=>{const[axisMin,axisMax]=axis&&svc.getCurrentAxisExtent(axis)||[];axesMins.push(axisMin);axesMaxes.push(axisMax);if(isAxisCompatible(axis)){availableAxesMins.push(axisMin);availableAxesMaxes.push(axisMax)}axesRes.push({min:axisMin,max:axisMax})});if(availableAxes.length>1&&availableAxesMins.some(v=>v<0)&&availableAxesMaxes.some(v=>v>0)){const minFactors=[];const maxFactors=[];const axesAbsolutes=[];availableAxes.forEach(axis=>{const index=axes.indexOf(axis);const axisAbsolute=Math.max(Math.abs(axesMins[index]),Math.abs(axesMaxes[index]));axesAbsolutes.push(axisAbsolute);minFactors.push(Math.abs(Math.min(0,axesMins[index])/axisAbsolute));maxFactors.push(Math.abs(Math.max(0,axesMaxes[index])/axisAbsolute))});const maxAxisFactor=Math.max(...maxFactors);const minAxisFactor=Math.max(...minFactors);availableAxes.forEach((axis,i)=>{const index=axes.indexOf(axis);axesRes[index].min=-axesAbsolutes[i]*minAxisFactor;axesRes[index].max=axesAbsolutes[i]*maxAxisFactor;axis.scale().domain([axesRes[index].min,axesRes[index].max])})}axes.forEach((axis,i)=>{const axisFormatting=yAxesFormatting.find(v=>v.id===axis.id);if(_.isNil(axisFormatting.ticksConfig.number)){axis.tickValues(axisOptions[i].tickValues);axis.tickFormat(axisOptions[i].tickFormat)}else{svc.setNumberOfTicks(axis,axesRes[i],axisFormatting.ticksConfig,axisFormatting.numberFormatting)}})},alignAndSetXTickValues:function(xAxis,axisOptions,xAxisFormatting){const[axisMin,axisMax]=xAxis&&svc.getCurrentAxisExtent(xAxis)||[];const axisRes={min:axisMin,max:axisMax};if(xAxisFormatting.ticksConfig.number==null){xAxis.tickValues(axisOptions.tickValues);xAxis.tickFormat(axisOptions.tickFormat);return}svc.setNumberOfTicks(xAxis,axisRes,xAxisFormatting.ticksConfig,xAxisFormatting.numberFormatting)},setNumberOfTicks:(axis,resAxis,ticksConfig,numberFormatting)=>{const maxTicksDisplayed=500;if(svc.canSetNumberOfTicks(axis)){const axisTicks=Math.min(maxTicksDisplayed,ticksConfig.mode===AxisTicksConfigMode.NUMBER?Math.floor(ticksConfig.number+1):(resAxis.max-resAxis.min)/ticksConfig.number);resAxis.interval=(resAxis.max-resAxis.min)/axisTicks;const values=Array.from({length:axisTicks+1},(_,i)=>resAxis.min+i*resAxis.interval);axis.tickValues(values);axis.tickFormat(ChartFormatting.getForAxis(resAxis.min,resAxis.max,values,numberFormatting))}},canSetNumberOfTicks:axis=>{if(!axis){return false}else if(axis.scaleType){return[SCALE_TYPES.LINEAR,SCALE_TYPES.LOG].includes(axis.scaleType)}else{return axis.type===CHART_AXIS_TYPES.MEASURE}},equalizeScales:function(chartDef,xScale,yScale){const compatibleAxes=ChartUADimension.areAllNumericalOrDate(chartDef);if(compatibleAxes){const axisMin=Math.min(xScale.domain()[0],yScale.domain()[0]);const axisMax=Math.max(xScale.domain()[1],yScale.domain()[1]);const extent=function(v){return Math.abs(v[1]-v[0])};const diff=Math.abs(extent(yScale.range())-extent(xScale.range()));if(extent(yScale.range())>extent(xScale.range())){yScale.range([xScale.range()[1]+diff,xScale.range()[0]+diff])}else{xScale.range([yScale.range()[1],yScale.range()[0]])}xScale.domain([axisMin,axisMax]);yScale.domain([axisMin,axisMax])}chartDef.compatibleAxes=compatibleAxes},clearAxes:function(g){g.selectAll(".x.axis").remove();g.selectAll(".y.axis").remove()},drawGridlines:function(axisG,axisName,formattingOptions,position,chartG){const isYAxis=axisName==="y";const ticks=getTicksForGridlines(axisG,isYAxis?"x":"y",chartG);svc.appendGridlines(d3.selectAll(ticks),position,formattingOptions,isYAxis?"hline":"vline")},appendGridlines(el,position,formattingOptions,className){const{x1,x2,y1,y2}=position;const isDashed=formattingOptions.type==="DASHED";el.append("line").attr("class",className).attr("stroke",formattingOptions.color).attr("stroke-width",formattingOptions.size).attr("stroke-dasharray",isDashed?12:0).attr("x1",x1).attr("x2",x2).attr("y1",y1).attr("y2",y2)},shouldDrawGridlinesForAxis:(chartType,axis,displayAxis)=>{if(!ChartFeatures.canSelectGridlinesAxis(chartType)){return true}switch(displayAxis.type){case GridlinesAxisType.CUSTOM_Y_AXIS:return axis.id===displayAxis.axisId;case GridlinesAxisType.LEFT_Y_AXIS:return axis.position===ChartYAxisPosition.LEFT;case GridlinesAxisType.RIGHT_Y_AXIS:return axis.position===ChartYAxisPosition.RIGHT;default:return true}},drawAxes:function(d3DrawContext){if(!d3DrawContext){return}const{$svgs,chartDef,chartHandler,ySpecs,xAxis,yAxes,axisOptions,handleZoom,yAxesColors}=d3DrawContext;if(ChartFeatures.canDisplayAxes(chartDef.type)){const xOptions=axisOptions.x;const yOptions=[...axisOptions.y];let xTicksConfig=chartDef.xAxisFormatting.ticksConfig;let yAxesFormatting=chartDef.yAxesFormatting.map(v=>{return{id:v.id,ticksConfig:v.ticksConfig,numberFormatting:v.axisValuesFormatting.numberFormatting,isLogScale:v.isLogScale}});if(ChartFeatures.isScatterZoomed(chartDef.type,chartDef.$zoomControlInstanceId)){xTicksConfig={...xTicksConfig,number:null};yAxesFormatting=yAxesFormatting.map(v=>{return{...v,ticksConfig:{...v.ticksConfig,number:null}}})}const yAxesOneTickPerBin=Object.keys(ySpecs).some(key=>ChartFeatures.hasOneTickPerBinSelected(chartDef&&chartDef.$chartStoreId,key));!handleZoom&&!ChartFeatures.hasOneTickPerBinSelected(chartDef&&chartDef.$chartStoreId,"x")&&svc.alignAndSetXTickValues(xAxis,xOptions,{ticksConfig:xTicksConfig,numberFormatting:chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting});!yAxesOneTickPerBin&&svc.alignAndSetYTickValues(yAxes,yOptions,yAxesFormatting)}const $svg=$svgs.eq(0),width=$svg.width(),height=$svg.height();let{margins,yAxesWidth}=svc.getMarginsAndAxesWidth(chartHandler,chartDef,$svg,xAxis,yAxes);const vizWidth=width-margins.left-margins.right;if(xAxis){xAxis.setScaleRange([0,vizWidth])}if(xAxis&&ChartPropertiesService.showXAxis(chartDef.xAxisFormatting,chartHandler.chartTileProperties)){margins=svc.adjustBottomMargin(chartDef.xAxisFormatting.axisValuesFormatting.axisTicksFormatting,margins,$svg,xAxis,chartHandler.forceRotation)}let allNegative=true;let allPositive=true;yAxes.forEach(yAxis=>{const currentYExtent=svc.getCurrentAxisExtent(yAxis);if(currentYExtent&&currentYExtent[1]>=0){allNegative=false}if(currentYExtent&&currentYExtent[0]<0){allPositive=false}});if(xAxis&&chartDef.singleXAxis&&chartDef.facetDimension.length){margins.axisHeight=margins.bottom;margins.bottom=allPositive?0:.2*height;margins.top=allNegative?0:.2*height}if(chartDef.xAxisFormatting.isLogScale&&ChartFeatures.isUnaggregated(chartDef.type)&&!ChartFeatures.isScatterZoomed(chartDef.type,chartDef.$zoomControlInstanceId)){svc.adjustScatterPlotAxisPadding(xAxis,vizWidth)}let vizHeight=height-margins.top-margins.bottom;yAxes.forEach((axis,i)=>{if(i===0&&ChartAxesUtils.isLeftYAxis(axis)){if(ySpecs[axis.id].ascendingDown){axis.setScaleRange([0,vizHeight])}else{axis.setScaleRange([vizHeight,0])}if(chartDef.facetDimension.length===0&&axis.type==="DIMENSION"&&ySpecs[axis.id].minRangeBand>0&&axis.ordinalScale.rangeBand()<ySpecs[axis.id].minRangeBand){const numLabels=axis.ordinalScale.domain().length;const padding=svc.getColumnPadding(numLabels);const range=d3Utils.getRangeForGivenRangeBand(ySpecs[axis.id].minRangeBand,numLabels,padding,padding/2);if(ySpecs[axis.id].ascendingDown){axis.setScaleRange([0,range])}else{axis.setScaleRange([range,0])}vizHeight=range;const svgHeight=vizHeight+margins.top+margins.bottom;$svgs.height(svgHeight)}}else{axis.setScaleRange([vizHeight,0])}if(ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,axis.id)&&ChartFeatures.isUnaggregated(chartDef.type)&&!ChartFeatures.isScatterZoomed(chartDef.type,chartDef.$zoomControlInstanceId)){svc.adjustScatterPlotAxisPadding(axis,vizHeight)}if(chartDef.valuesInChartDisplayOptions.displayValues&&chartDef.type===CHART_TYPES.GROUPED_COLUMNS){svc.adjustVerticalBarsYAxisPadding(axis,vizHeight,ChartLabels.getMeasureValueInChartMaxHeight(chartDef,true,false,2,computeTextHeightFromFontSize($svgs)),true,chartDef)}if(chartDef.valuesInChartDisplayOptions.displayValues&&ChartFeatures.canDisplayTotalValues(chartDef)&&!chartDef.genericMeasures.some(m=>ChartMeasure.isRealUnaggregatedMeasure(m))){svc.adjustVerticalBarsYAxisPadding(axis,vizHeight,ChartLabels.getMeasureValueInChartMaxHeight(chartDef,false,true,5,computeTextHeightFromFontSize($svgs)),true)}if(chartDef.valuesInChartDisplayOptions.displayValues&&chartDef.type===CHART_TYPES.LINES){svc.adjustLinesYAxisPadding(axis,vizHeight,ChartLabels.getMeasureValueInChartMaxHeight(chartDef,true,false,12,computeTextHeightFromFontSize($svgs)))}if(chartDef.valuesInChartDisplayOptions.displayValues&&chartDef.type===CHART_TYPES.MULTI_COLUMNS_LINES){svc.adjustVerticalBarsYAxisPadding(axis,vizHeight,ChartLabels.getMeasureValueInChartMaxHeight(chartDef,true,false,5,computeTextHeightFromFontSize($svgs)),false)}});if(chartDef.type===CHART_TYPES.SCATTER&&chartDef.scatterOptions&&chartDef.scatterOptions.equalScales){svc.equalizeScales(chartDef,xAxis.scale(),yAxes[0].scale())}const updatedMargins=_.cloneDeep(margins);let $xAxisSvgs=$svgs;if(xAxis&&chartDef.singleXAxis&&chartDef.facetDimension.length){$xAxisSvgs=$('<svg class="x-axis-svg" xmlns="http://www.w3.org/2000/svg">');$('<div class="x-axis noflex">').css("height",updatedMargins.axisHeight).append($xAxisSvgs).appendTo($svgs.eq(0).closest(".mainzone"));d3.select($xAxisSvgs.get(0)).append("g").attr("class","chart").attr("transform","translate("+($svgs.closest(".chart").find("h2").outerWidth()+updatedMargins.left)+", -1)")}$svgs.each(function(){const svg=d3.select(this);const g=svg.select("g.chart");if(!g[0][0]){svg.append("g").attr("class","chart")}});if(xAxis){xAxis.orient("bottom");$xAxisSvgs.each(function(){const g=d3.select(this).select("g");const xAxisG=g.append("g").attr("class","x axis qa_charts_x-axis-column-label-text");if(!chartDef.singleXAxis||!chartDef.facetDimension.length){if(!allNegative){xAxisG.attr("transform","translate(0,"+vizHeight+")");xAxis.orient("bottom")}else{xAxis.orient("top");const bottomMargin=updatedMargins.bottom;updatedMargins.bottom=updatedMargins.top;updatedMargins.top=bottomMargin}}if(ChartPropertiesService.showXAxis(chartDef.xAxisFormatting,chartHandler.chartTileProperties)){xAxisG.call(xAxis);const axisScale=yAxes[0].scale()(0);if(!allNegative&&!allPositive&&xAxis.type!==CHART_AXIS_TYPES.UNAGGREGATED&&axisScale){xAxisG.select("path.domain").attr("transform","translate(0,"+(axisScale-vizHeight)+")")}if(xAxis.labelAngle){if(!allNegative){xAxisG.selectAll("text").attr("transform",(xAxis.labelAngle==Math.PI/2?"translate(-13, 9)":"translate(-10, 0)")+" rotate("+xAxis.labelAngle*-180/Math.PI+", 0, 0)").style("text-anchor","end")}else{xAxisG.selectAll("text").attr("transform","translate(10, 0) rotate("+xAxis.labelAngle*-180/Math.PI+", 0, 0)").style("text-anchor","start")}}if(xAxisG){const ticksFormatting=chartDef.xAxisFormatting.axisValuesFormatting.axisTicksFormatting;ticksFormatting&&xAxisG.selectAll(".tick text").attr("fill",ticksFormatting.fontColor).attr("font-size",`${ticksFormatting.fontSize}px`);if(ChartFeatures.shouldRemoveOverlappingTicks(chartDef.xAxisFormatting,chartDef,"x")){xAxisG.selectAll(".tick").forEach(ticks=>{ticks.sort((a,b)=>a.__data__-b.__data__);const overlappingTicks=svc.sanitizeTicksDisplay(ticks,true,true);AxisTicksConfiguration.setXTicksAreOverlapping(overlappingTicks.length>0)})}else{AxisTicksConfiguration.setXTicksAreOverlapping(false)}}if(!xAxis.labelAngle){const lastTick=xAxisG.select(".tick:last-of-type");const domainWidth=xAxisG.select(".domain").node()?.getBBox()?.width||0;if(lastTick){const lastTickTransform=lastTick.attr("transform");const lastTickText=lastTick.select("text");if(lastTickTransform){const translateMatch=lastTickTransform.match(/translate\(([^,]+),([^)]+)\)/);const lastTickX=translateMatch?parseFloat(translateMatch[1]):0;const lastTextWidth=lastTickText.node()?.getBBox()?.width||0;if(lastTickX+lastTextWidth/2>domainWidth+updatedMargins.right){lastTickText.attr("x",-(lastTickX+lastTextWidth/2-domainWidth))}}}}}svc.addTitleToXAxis(xAxisG,xAxis,chartDef,chartHandler,updatedMargins,vizWidth)})}$svgs.each(function(){const g=d3.select(this).select("g");g.attr("transform","translate("+updatedMargins.left+","+updatedMargins.top+")");if(xAxis&&chartDef.gridlinesOptions.vertical.show&&ChartFeatures.canHaveVerticalGridlines(chartDef)){const gridlinesPosition={x1:0,x2:0,y1:0,y2:allNegative?vizHeight:-vizHeight};svc.drawGridlines(g.select("g.x.axis"),"x",chartDef.gridlinesOptions.vertical.lineFormatting,gridlinesPosition,g)}yAxes.forEach((axis,index)=>{const axisColor=yAxesColors[axis.id]||"#000";const axisFormatting=ChartAxesUtils.getFormattingForYAxis(chartDef.yAxesFormatting,axis.id);axis.orient(axis.position);if(vizHeight<300){axis.ticks(svc.optimizeTicksNumber(vizHeight))}const yAxisG=g.append("g").attr("class",`y y${index+1} axis`);let remainingAxesWidth=0;if(ChartAxesUtils.isRightYAxis(axis)){yAxisG.attr("transform","translate("+vizWidth+",0)")}else{remainingAxesWidth=yAxesWidth.slice(index+1).reduce((acc,val)=>{const isLeftAxis=ChartAxesUtils.isLeftYAxis(yAxes.find(axis=>axis.id===val.id));if(isLeftAxis&&val.width>0){acc+=val.width+ChartsStaticData.AXIS_Y_SPACING}return acc},0);yAxisG.attr("transform",`translate(${-remainingAxesWidth},0)`)}if(ChartPropertiesService.showYAxis(axisFormatting,chartHandler.chartTileProperties)){yAxisG.call(axis);if(chartDef.gridlinesOptions.horizontal.show&&svc.shouldDrawGridlinesForAxis(chartDef.type,axis,chartDef.gridlinesOptions.horizontal.displayAxis)){const gridlinesPosition={x1:remainingAxesWidth,x2:ChartAxesUtils.isRightYAxis(axis)?-vizWidth:vizWidth,y1:0,y2:0};svc.drawGridlines(yAxisG,"y",chartDef.gridlinesOptions.horizontal.lineFormatting,gridlinesPosition,g)}if(xAxis&&chartDef.singleXAxis&&chartDef.facetDimension.length&&!index){yAxisG.select(".domain").attr("d","M0,-100V1000");if(allPositive&&(axis.type===CHART_AXIS_TYPES.MEASURE||axis.scaleType===SCALE_TYPES.LINEAR)){yAxisG.select(".tick").remove()}}const axisG=g.select(`.y${index+1}`);const ticksFormatting=axisFormatting.axisValuesFormatting.axisTicksFormatting;axisG.selectAll(".tick text").attr("fill",ChartFeatures.canSetAxisTextColor(chartDef.type)?ticksFormatting.fontColor:axisColor).attr("font-size",`${ticksFormatting.fontSize}px`)}const axisG=g.select(`.y${index+1}`);svc.addTitleToYAxis(axisG,axis,chartDef,chartHandler,margins,vizHeight,yAxesWidth[index].width,axisColor);if(ChartFeatures.shouldRemoveOverlappingTicks(axisFormatting,chartDef,axisFormatting.id)){g.selectAll(`g.y${index+1}.axis`).selectAll("g.tick").forEach(ticks=>{ticks.sort((a,b)=>a.__data__-b.__data__);const overlappingTicks=svc.sanitizeTicksDisplay(ticks,true,true);AxisTicksConfiguration.setYTicksAreOverlapping(overlappingTicks.length>0)})}else{AxisTicksConfiguration.setYTicksAreOverlapping(false)}const domain=yAxisG.selectAll(".domain, .tick");domain.style("stroke",axisColor)})});return{margins:margins,updatedMargins:updatedMargins,vizWidth:vizWidth,vizHeight:vizHeight}},formatAxisTitle:function(labelElement,title,maxTextWidth){if(maxTextWidth>0){let textLength=labelElement.node().getComputedTextLength();let displayedText=title;while(textLength>0&&displayedText&&displayedText.length&&textLength>maxTextWidth){displayedText=displayedText.substring(0,displayedText.length-1);labelElement.text(`${displayedText}...`);textLength=labelElement.node().getComputedTextLength()}}},addDateToTitle:function(title,axis){let finalTitle=title;if(title&&axis.dimension&&ChartUADimension.isDate(axis.dimension)&&axis.scaleType===SCALE_TYPES.TIME){const extent=svc.getCurrentAxisExtent(axis);const computedDateDisplayUnit=ChartDataUtils.computeDateDisplayUnit(extent[0],extent[1]);if(computedDateDisplayUnit.formattedMainDate){finalTitle+=` (${computedDateDisplayUnit.formattedMainDate})`}}return finalTitle},addTitleToXAxis:function(axisG,xAxis,chartDef,chartHandler,margins,chartWidth){let titleText=ChartAxesUtils.getXAxisTitle(xAxis,chartDef);titleText=svc.addDateToTitle(titleText,xAxis);const titleStyle=chartDef.xAxisFormatting.axisTitleFormatting;const axisTitleMaxWidth=chartWidth-margins.right;if(titleText&&ChartPropertiesService.showXAxisTitle(chartDef.xAxisFormatting,chartHandler.chartTileProperties)){const rect=axisG.append("rect");const labelElement=axisG.append("text").attr("x",chartWidth/2).attr("y",xAxis.orient()=="bottom"?margins.bottom-titleStyle.fontSize-ChartsStaticData.AXIS_MARGIN:titleStyle.fontSize+ChartsStaticData.AXIS_MARGIN-margins.top).attr("text-anchor","middle").attr("dominant-baseline","middle").attr("fill",titleStyle.fontColor).attr("class","axis-title x qa_charts_x-axis-title").style("font-size",`${titleStyle.fontSize}px`).text(titleText);this.formatAxisTitle(labelElement,titleText,axisTitleMaxWidth);if(!chartHandler.noClickableAxisLabels){labelElement.attr("no-global-contextual-menu-close",true).on("click",function(){chartHandler.openSection(ChartFormattingPaneSections.X_AXIS)});chartHandler.$on("$destroy",()=>{labelElement.on("click",null)})}const bbox=labelElement.node().getBoundingClientRect();rect.attr("x",chartWidth/2-bbox.width/2).attr("y",xAxis.orient()=="bottom"?margins.bottom-15-bbox.height/2:15-margins.top-bbox.height/2).attr("width",bbox.width).attr("height",bbox.height).attr("fill","none").attr("class","chart-wrapper__x-axis-title").attr("stroke","none")}},getCurrentAxisExtent(axis){const extent=axis.scale().domain();return[Math.min(...extent),Math.max(...extent)]},addTitleToYAxis:function(axisG,yAxis,chartDef,chartHandler,margins,chartHeight,axisWidth,axisColor){const axisFormatting=ChartAxesUtils.getFormattingForYAxis(chartDef.yAxesFormatting,yAxis.id);const titleStyle=axisFormatting.axisTitleFormatting;const xPosition=ChartAxesUtils.isLeftYAxis(yAxis)?-axisWidth:axisWidth;const axisTitleMaxWidth=chartHeight-margins.top;let titleText=ChartAxesUtils.getYAxisTitle(yAxis,chartDef,axisFormatting);titleText=svc.addDateToTitle(titleText,yAxis);if(titleText&&ChartPropertiesService.showYAxisTitle(axisFormatting,chartHandler.chartTileProperties)){const labelElement=axisG.append("text").attr("x",xPosition).attr("y",(chartHeight-margins.top)/2).attr("text-anchor","middle").attr("dominant-baseline",ChartAxesUtils.isLeftYAxis(yAxis)?"middle":"text-top").attr("class","axis-title y qa_charts_y-axis-title").attr("fill",ChartFeatures.canSetAxisTextColor(chartDef.type)?titleStyle.fontColor:axisColor).style("font-size",`${titleStyle.fontSize}px`).attr("transform","rotate(-90, "+xPosition+","+(chartHeight-margins.top)/2+")").text(titleText);this.formatAxisTitle(labelElement,titleText,axisTitleMaxWidth);if(!chartHandler.noClickableAxisLabels){labelElement.attr("no-global-contextual-menu-close",true).on("click",function(){chartHandler.openSection(ChartFormattingPaneSections.Y_AXIS)});chartHandler.$on("$destroy",()=>{labelElement.on("click",null)})}}},adjustScatterPlotAxisPadding:(axis,axisHeight,paddingPct=.05)=>{const extent=axis.originalDomain||svc.getCurrentAxisExtent(axis);const logMin=Math.log(extent[0]);const logMax=Math.log(extent[1]);const logDifference=logMax-logMin;const paddingPx=axisHeight*paddingPct;const axisHeightMinusPadding=axisHeight-paddingPx*2;const logPadding=logDifference/axisHeightMinusPadding*paddingPx;const paddedDomain=[Math.exp(logMin-logPadding),Math.exp(logMax+logPadding)];axis.originalDomain=axis.originalDomain||[...axis.scale().domain()];axis.scale().domain(paddedDomain);return axis},adjustVerticalBarsYAxisPadding:(axis,axisHeight,valuesFontSize,addNegativeExtent,chartDef)=>{const extent=svc.getCurrentAxisExtent(axis);if(chartDef?.variant===CHART_VARIANTS.waterfall&&chartDef.genericMeasures.length>0){const valuePlacement=chartDef.genericMeasures[0].valuesInChartDisplayOptions?.placementMode;switch(valuePlacement){case ValuesInChartPlacementMode.BELOW:adjustAxisPadding(axis,extent,axisHeight,valuesFontSize,true,false);break;case ValuesInChartPlacementMode.ABOVE:adjustAxisPadding(axis,extent,axisHeight,valuesFontSize,false,true);break;case ValuesInChartPlacementMode.AUTO:adjustAxisPadding(axis,extent,axisHeight,valuesFontSize,extent[0]<0,extent[1]>0);break;default:break}}else{adjustAxisPadding(axis,extent,axisHeight,valuesFontSize,extent[0]<0&&addNegativeExtent,extent[1]>0)}return axis},adjustLinesYAxisPadding:(axis,axisHeight,valuesFontSize)=>{const extent=svc.getCurrentAxisExtent(axis);adjustAxisPadding(axis,extent,axisHeight,valuesFontSize,true,true);return axis},optimizeTicksNumber:function(axisSize){return Math.floor(Math.max(axisSize/30,2))},addNumberFormatterToAxis(axis,formattingOptions={}){const scale=axis.scale()instanceof Function?axis.scale():axis.scale;const minValue=Math.min(...scale.domain());const maxValue=Math.max(...scale.domain());const numValues=axis.tickValues()?axis.tickValues().length:axis.ticks()[0];axis.tickFormat(ChartFormatting.getForAxis(minValue,maxValue,numValues,formattingOptions))}};return svc}})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("d3Utils",function(){return{getOrdinalScaleRangeStep:function(ordinalScale){if(ordinalScale.range().length<2){return 100}return Math.abs(ordinalScale.range()[1]-ordinalScale.range()[0])},endAll:function(transition,globalCallback,perItemCallback){if(transition.size()===0&&globalCallback){globalCallback()}let n=0;transition.each(function(){++n}).each("end",function(){if(perItemCallback){perItemCallback.apply(this,arguments)}if(!--n){globalCallback.apply(this,arguments)}})},getRangeForGivenRangeBand:function(rangeBand,domainLength,padding,outerPadding){const step=rangeBand/(1-padding);return rangeBand*domainLength+step*padding*(domainLength-1)+2*step*outerPadding}}})})();(function(){"use strict";angular.module("dataiku.charts").service("ChartDataUtils",ChartDataUtils);function ChartDataUtils(ChartDimension,ChartMeasure,ChartUADimension,Fn,$filter,CHART_DATES_LABELS,ChartLabels,CHART_TYPES,ChartsStaticData,translate){function isElementInTimestampRange(elementIndex,axisLabelElements,timestampRange){if(!timestampRange){return true}const labelElementIndex=getLabelIndexForTensorIndex(elementIndex,axisLabelElements.length);const isOthersCategoryIndex=labelElementIndex===undefined;if(isOthersCategoryIndex){return false}const axisLabelElementTimestamp=axisLabelElements[labelElementIndex].tsValue;const lowestRangeBound=timestampRange[0];const highestRangeBound=timestampRange[1];return axisLabelElementTimestamp>=lowestRangeBound&&axisLabelElementTimestamp<=highestRangeBound}function getLabelIndexForTensorIndex(tensorElementIndex,numberOfAxisLabelElements){const numberOfElementsInFacet=numberOfAxisLabelElements+1;const labelElementIndex=tensorElementIndex%numberOfElementsInFacet;const isOthersCategoryElementIndex=labelElementIndex===numberOfAxisLabelElements;if(isOthersCategoryElementIndex){return undefined}return labelElementIndex}function filterTensorOnTimestampRange(tensor,axisLabelElements,counts,timestampRange,includeEmptyBins){return tensor.filter((value,index)=>{const isEmptyBin=counts[index]===0;return isElementInTimestampRange(index,axisLabelElements,timestampRange)&&(!isEmptyBin||includeEmptyBins)})}function buildDefaultExtent(){return{extent:[Infinity,-Infinity],onlyPercent:true}}function getDateDisplayUnit(minTimestamp,maxTimestamp){if(minTimestamp===undefined||maxTimestamp===undefined){return CHART_DATES_LABELS.DATE_DISPLAY_UNIT_DEFAULT}const minDate=new Date(minTimestamp);const maxDate=new Date(maxTimestamp);const minDateWrapper=moment(minDate).utc();const maxDateWrapper=moment(maxDate).utc();const isDomainLessThan24Hours=maxDateWrapper.diff(minDateWrapper,"hours",true)<=24;if(!isDomainLessThan24Hours){return CHART_DATES_LABELS.DATE_DISPLAY_UNIT_DEFAULT}const isDomainInSameDay=minDateWrapper.year()===maxDateWrapper.year()&&minDateWrapper.dayOfYear()===maxDateWrapper.dayOfYear();if(!isDomainInSameDay){return CHART_DATES_LABELS.DATE_DISPLAY_UNIT_DAY_AND_MINUTES}const isDomainLessThan2Minutes=maxDateWrapper.diff(minDateWrapper,"minutes",true)<=2;if(!isDomainLessThan2Minutes){return CHART_DATES_LABELS.DATE_DISPLAY_UNIT_MINUTES}const isDomainLessThan2Seconds=maxDateWrapper.diff(minDateWrapper,"seconds",true)<=2;if(!isDomainLessThan2Seconds){return CHART_DATES_LABELS.DATE_DISPLAY_UNIT_SECONDS}return CHART_DATES_LABELS.DATE_DISPLAY_UNIT_MILLISECONDS}function getLabelForRecordsCount(beforeFiltersCount,afterFiltersCount,visibleCountMap,chartType){let actualCount=afterFiltersCount;if(afterFiltersCount===beforeFiltersCount&&afterFiltersCount===0){return ChartLabels.getNoRecordLabel()}if([CHART_TYPES.SCATTER_MULTIPLE_PAIRS,CHART_TYPES.SCATTER].includes(chartType)){actualCount=visibleCountMap&&visibleCountMap.size&&Math.max(...visibleCountMap.values())||0}if(actualCount<beforeFiltersCount){return`${actualCount} / ${beforeFiltersCount} ${translate("CHARTS.HEADER.RECORDS","records")}`}else{return`${beforeFiltersCount} ${beforeFiltersCount!==1?translate("CHARTS.HEADER.RECORDS","records"):translate("CHARTS.HEADER.RECORD","record")}`}}const cartesian=(...a)=>a.reduce((a,b)=>a.flatMap(d=>b.map(e=>[d,e].flat())));const longSmartNumber=$filter("longSmartNumber");const svc={getMeasureExtents:function(chartDef,chartData,mainAxisName,timestampRange,includeEmptyBins){const result={[ChartsStaticData.LEFT_AXIS_ID]:buildDefaultExtent(),[ChartsStaticData.RIGHT_AXIS_ID]:buildDefaultExtent(),recordsCount:0,pointsCount:0};const countsTensor=chartData.data.counts.tensor;const mainAxisLabels=chartData.getAxisLabels(mainAxisName);chartDef.genericMeasures.forEach(function(measure,measureIndex){let measureExtent=[];const measureData=chartData.data.aggregations[measureIndex];if(ChartMeasure.isRealUnaggregatedMeasure(measure)){const filterTensor=t=>filterTensorOnTimestampRange(t,mainAxisLabels,countsTensor,timestampRange,includeEmptyBins);measureExtent=ChartMeasure.getUaMeasureExtent(measureData,filterTensor)}else{const filteredTensor=filterTensorOnTimestampRange(measureData.tensor,mainAxisLabels,countsTensor,timestampRange,includeEmptyBins);measureExtent=d3.extent(filteredTensor)}const axis=measure.displayAxis==="axis1"?ChartsStaticData.LEFT_AXIS_ID:ChartsStaticData.RIGHT_AXIS_ID;result[axis].onlyPercent=result[axis].onlyPercent&&ChartDimension.isPercentScale([measure]);result[axis].extent[0]=_.isFinite(measureExtent[0])?Math.min(measureExtent[0],result[axis].extent[0]):result[axis].extent[0];result[axis].extent[1]=_.isFinite(measureExtent[1])?Math.max(measureExtent[1],result[axis].extent[1]):result[axis].extent[1]});const countsTensorInRange=filterTensorOnTimestampRange(countsTensor,mainAxisLabels,countsTensor,timestampRange,includeEmptyBins);result.recordsCount=countsTensorInRange.reduce((currentCount,countInBin)=>currentCount+countInBin,0);result.pointsCount=countsTensorInRange.length;return result},getValuesForLines:function(binIndexes,chartData,ignoreLabels){const valuesForLines=binIndexes.reduce((bins,binValue,binIndex)=>{bins.push(chartData.data.axisLabels[binIndex].reduce((acc,cV,cI)=>{if(ignoreLabels.has(cV.label)){return acc}if(binValue!==undefined){acc.push(binValue)}else{acc.push(cI)}return acc},[]));return bins},[]);return cartesian(...valuesForLines)},getValuesForColumns:function(binIndexes,chartData,ignoreLabels){const valuesForColumns=binIndexes.reduce((bins,binValue,binIndex)=>{bins.push(chartData.data.axisLabels[binIndex].reduce((acc,cV,cI)=>{if(ignoreLabels.has(cV.label)){return acc}acc.push(cI);return acc},[]));return bins},[]);return cartesian(...valuesForColumns)},getMeasureExtentsForMixColored:function(chartDef,chartData,includeEmptyBins,ignoreLabels=new Set,binIndexes=[],ignoreForMeasure){const result={[ChartsStaticData.LEFT_AXIS_ID]:buildDefaultExtent(),[ChartsStaticData.RIGHT_AXIS_ID]:buildDefaultExtent(),recordsCount:0,pointsCount:0};const mainAxisLabel=chartData.data.axisLabels[0];const countsTensor=chartData.data.counts.tensor;const valuesToCheckForLines=this.getValuesForLines(binIndexes,chartData,ignoreLabels);const valuesToCheckForColumns=this.getValuesForColumns(binIndexes,chartData,ignoreLabels);chartDef.genericMeasures.forEach((measure,measureIndex)=>{const tensorValues=ignoreForMeasure&&ignoreForMeasure(measure)?this.retrieveAggrData(chartData,valuesToCheckForColumns,measureIndex):this.retrieveAggrData(chartData,valuesToCheckForLines,measureIndex);let measureExtent=[];if(ChartMeasure.isRealUnaggregatedMeasure(measure)){measureExtent=ChartMeasure.getUaMeasureExtent(this.retrieveUnaggrExtents(chartData,ignoreForMeasure&&ignoreForMeasure(measure)?valuesToCheckForColumns:valuesToCheckForLines,measureIndex))}else{measureExtent=d3.extent(tensorValues)}const axis=measure.displayAxis==="axis1"?ChartsStaticData.LEFT_AXIS_ID:ChartsStaticData.RIGHT_AXIS_ID;result[axis].onlyPercent=result[axis].onlyPercent&&ChartDimension.isPercentScale([measure]);result[axis].extent[0]=Math.min(measureExtent[0],result[axis].extent[0]);result[axis].extent[1]=Math.max(measureExtent[1],result[axis].extent[1])});const countsTensorInRange=filterTensorOnTimestampRange(countsTensor,mainAxisLabel,countsTensor,undefined,includeEmptyBins);result.recordsCount=countsTensorInRange.reduce((currentCount,countInBin)=>currentCount+countInBin,0);result.pointsCount=countsTensorInRange.length;return result},retrieveAggrData:function(chartData,coordsArray,measureIndex){return coordsArray.reduce((acc,coords)=>{acc.push(chartData.getPoint(chartData.data.aggregations[measureIndex],Array.isArray(coords)?coords:[coords]));return acc},[])},retrieveUnaggrExtents:function(chartData,coordsArray,measureIndex){return coordsArray.reduce((acc,coords)=>{const extents=chartData.getPointExtents(chartData.data.aggregations[measureIndex],Array.isArray(coords)?coords:[coords]);acc.uaDataNegativeExtent.push(extents[0]);acc.uaDataPositiveExtent.push(extents[1]);return acc},{uaDataNegativeExtent:[],uaDataPositiveExtent:[]})},getMeasureExtent:function(chartData,mIdx,ignoreEmptyBins,binsToInclude=null,aggrFn=null,axesIdx=[]){const allMeasureIndexes=axesIdx.concat(mIdx);const data=chartData.data;if(allMeasureIndexes.every(mIdx=>!data.aggregations[mIdx])){return null}let accessor=Fn.SELF;if(ignoreEmptyBins){accessor=function(d,i){const hasNonNullElement=allMeasureIndexes.some(mIdx=>chartData.getNonNullCount(i,mIdx)>0);if(hasNonNullElement||chartData.isBinMeaningful(aggrFn,i,mIdx)){return!binsToInclude||binsToInclude.has(i)?d:null}return null}}return d3.extent(data.aggregations[mIdx].tensor,accessor)},getMeasureValues:function(data,mIdx,binsToInclude){if(!data.aggregations[mIdx]){return null}return data.aggregations[mIdx].tensor.filter(function(d,i){if(data.aggregations[mIdx].nonNullCounts){return data.aggregations[mIdx].nonNullCounts[i]>0}else{return data.counts.tensor[i]>0?!binsToInclude||binsToInclude.has(i)?true:false:false}})},getAxisExtent:function(chartData,axisName,dimension,extraOptions={}){const ignoreLabels=extraOptions.ignoreLabels||new Set;const initialExtent=extraOptions.initialExtent||[Infinity,-Infinity];const labels=chartData.getCustomAxisLabels(axisName)??chartData.getAxisLabels(axisName);const isDualAxis=!!chartData.hasDualDimensionAxis?.(axisName);let min=initialExtent[0];let max=initialExtent[1];const values=labels.filter(label=>!ignoreLabels.has(label.label)).map(function(label){if(isDualAxis){return label.label}if(ChartDimension.isTimelineable(dimension)){min=Math.min(min,label.min);max=Math.max(max,label.max)}else if(ChartDimension.isTrueNumerical(dimension)){if(ChartDimension.isUngroupedNumerical(dimension)||label.min==null){min=Math.min(min,label.sortValue);max=Math.max(max,label.sortValue)}else{min=Math.min(min,label.min);max=Math.max(max,label.max);return[label.min,label.max]}}return label.label});return{values:values,min:min,max:max}},getUnaggregatedAxisExtentByType:function(uaDimensionType,axisData,afterFilterRecords){switch(uaDimensionType){case"str":return{values:angular.copy(axisData.str.sortedMapping).sort(function(a,b){return d3.ascending(a.sortOrder,b.sortOrder)}).map(Fn.prop("label"))};case"num":case"ts":return{values:axisData[uaDimensionType].data.filter((d,i)=>i<afterFilterRecords),min:axisData[uaDimensionType].min,max:axisData[uaDimensionType].max};default:throw new Error("Unhandled dimension type: "+uaDimensionType)}},getUnaggregatedAxisExtent:function(dimension,axisData,afterFilterRecords){const uaDimensionType=ChartUADimension.getUnaggregatedDimensionType(dimension);return svc.getUnaggregatedAxisExtentByType(uaDimensionType,axisData,afterFilterRecords)},getUnaggregatedMultipleAxisExtent:function(axes,afterFilterRecords){const finalExtent={min:undefined,max:undefined,values:[]};axes.forEach(axis=>{const uaDimensionType=ChartUADimension.getUnaggregatedDimensionType(axis.dimension);const extent=svc.getUnaggregatedAxisExtentByType(uaDimensionType,axis.data,afterFilterRecords);if(_.isNil(finalExtent.min)||extent.min<finalExtent.min){finalExtent.min=extent.min}if(_.isNil(finalExtent.max)||extent.max>finalExtent.max){finalExtent.max=extent.max}finalExtent.values=[...finalExtent.values,...extent.values]});return finalExtent},getSamplingSummaryMessage:function(pivotResponse,chartType,clickActionMessage,visibleCountMap){const sampleMetadata=pivotResponse.sampleMetadata;if(!sampleMetadata){return}let samplingSummaryMessage=`<i class="dku-icon-warning-fill-16 tooltip-icon"></i> ${translate("CHARTS.HEADER.DATA_SAMPLING_NOT_REPRESENTATIVE","Data sampling can be misrepresentative")}</br>`;if(clickActionMessage){samplingSummaryMessage+=`${clickActionMessage}</br>`}if(chartType===CHART_TYPES.SCATTER_MULTIPLE_PAIRS){return samplingSummaryMessage+svc.getScatterMPRecordsSummary(pivotResponse.axesPairs,visibleCountMap)}else if(sampleMetadata.datasetRecordCount>-1){samplingSummaryMessage+=translate("CHARTS.HEADER.DATA_SAMPLING.ROWS_OUT_OF","<strong>{{beforeFilterRecords}}</strong> rows out of {datasetRecordCount}} {{estimated ? '(estimated)' : ''",{beforeFilterRecords:longSmartNumber(pivotResponse.beforeFilterRecords),datasetRecordCount:longSmartNumber(sampleMetadata.datasetRecordCount),estimated:sampleMetadata.recordCountIsApproximate})}else{samplingSummaryMessage+=translate("CHARTS.HEADER.DATA_SAMPLING.ROWS","<strong>{{beforeFilterRecords}}</strong> rows",{beforeFilterRecords:longSmartNumber(pivotResponse.beforeFilterRecords)})}return samplingSummaryMessage},getScatterMPRecordsSummary(axesPairs,visibleCountMap){return(axesPairs||[]).map((axisPair,index)=>{const value=visibleCountMap?visibleCountMap.get(index)||0:axisPair.afterFilterRecords;return translate("CHARTS.HEADER.DATA_SAMPLING.SCATTER","<strong>Pair {{index}}</strong>: {{value}} record{{ value !== 1 ? 's' : ''}} after filtering",{index:index+1,value:value})}).join("</br>")},getSampleMetadataAndSummaryMessage:(pivotResponse,chartType,clickActionMessage)=>{const sampleMetadata=pivotResponse&&pivotResponse.sampleMetadata;if(sampleMetadata){return{sampleMetadata:sampleMetadata,summaryMessage:!sampleMetadata.sampleIsWholeDataset?svc.getSamplingSummaryMessage(pivotResponse,chartType):null,clickableSummaryMessage:!sampleMetadata.sampleIsWholeDataset&&clickActionMessage?svc.getSamplingSummaryMessage(pivotResponse,chartType,clickActionMessage):null}}return{sampleMetadata:null,summaryMessage:null,clickableSummaryMessage:null}},getRecordsFinalCountTooltip:function(chartType,afterFilterRecords,axisPairs,visibleCountMap){if(chartType===CHART_TYPES.SCATTER_MULTIPLE_PAIRS){return svc.getScatterMPRecordsSummary(axisPairs,visibleCountMap)}else{return`<strong>${afterFilterRecords}</strong> ${translate("CHARTS.HEADER.RECORDS_REMAIN","records remain after applying filtering")}`}},computeRecordsStatusLabel:function(beforeFilterRecords,afterFilterRecords,computedMainAutomaticBinningModeDescription,visibleCountMap,chartType){const result=[];const labelForRecordsCount=getLabelForRecordsCount(beforeFilterRecords,afterFilterRecords,visibleCountMap,chartType);if(labelForRecordsCount){result.push(labelForRecordsCount)}if(computedMainAutomaticBinningModeDescription&&labelForRecordsCount!==ChartLabels.getNoRecordLabel()){result.push(computedMainAutomaticBinningModeDescription)}return result.length===0?undefined:result.join(" ")},computeNoRecordsTopRightLabel:function(){return this.computeRecordsStatusLabel(0,0,undefined)},computeDateDisplayUnit:function(minTimestamp,maxTimestamp){const dateDisplayUnit=getDateDisplayUnit(minTimestamp,maxTimestamp);if(minTimestamp!==undefined&&dateDisplayUnit.mainDateFormat!==undefined){return{...dateDisplayUnit,formattedMainDate:dateDisplayUnit.formatDateFn(minTimestamp,dateDisplayUnit.mainDateFormat)}}return dateDisplayUnit},isSameDay(minTimestamp,maxTimestamp){if(minTimestamp===undefined||maxTimestamp===undefined){return false}const minDateWrapper=moment.utc(minTimestamp);const maxDateWrapper=moment.utc(maxTimestamp);return minDateWrapper.year()===maxDateWrapper.year()&&minDateWrapper.dayOfYear()===maxDateWrapper.dayOfYear()},isPivotRequestAborted:errorData=>errorData&&errorData.hasResult&&errorData.aborted};return svc}})();(function(){"use strict";const app=angular.module("dataiku.charts");app.service("ChartRequestComputer",function(ChartDimension,LoggerProvider,BinnedXYUtils,_GeometryCommon,ChartColorUtils,ChartStoreFactory,CHART_TYPES,CHART_VARIANTS,ChartUADimension,MultiplotUtils,ChartUsableColumns,ChartCustomMeasures,ColumnAvailability,ChartFeatures,ColorMode,ChartHierarchyDimension){const Logger=LoggerProvider.getLogger("chartrequest");const has=function(array){return array&&array.length>0};const makeAggregatedAxis=function(dim,chartDef,isMainInteractiveDateAxis=false){dim=angular.copy(dim);const axis={column:dim.column,type:dim.type,sortPrune:{},name:dim.name,isRBND:dim.isRBND};if(dim.type=="NUMERICAL"&&dim.numParams.mode!="TREAT_AS_ALPHANUM"){axis.numParams=dim.numParams}else if(dim.type=="NUMERICAL"&&dim.numParams.mode=="TREAT_AS_ALPHANUM"){dim.type="ALPHANUM";axis.type=dim.type}else if(dim.type==="DATE"&&dim.dateParams.mode!="TREAT_AS_ALPHANUM"){axis.dateParams=ChartDimension.buildDateParamsForAxis(dim,chartDef.type,isMainInteractiveDateAxis)}else if(dim.type==="DATE"&&dim.dateParams.mode=="TREAT_AS_ALPHANUM"){dim.type="ALPHANUM";axis.type=dim.type}if(dim.type=="ALPHANUM"||ChartDimension.isUngroupedNumerical(dim)){axis.sortPrune.maxValues=dim.maxValues}axis.sortPrune.sortType=dim.sort.type;if(dim.sort.type=="AGGREGATION"){axis.sortPrune.aggregationSortId=dim.sort.measureIdx;axis.sortPrune.sortAscending=dim.sort.sortAscending}else if(dim.sort.type=="COUNT"){axis.sortPrune.sortAscending=dim.sort.sortAscending}else if(dim.sort.type=="CUSTOM"){axis.sortPrune.sortAscending=true;axis.sortPrune.customSortingValues=dim.customSortingValues}else{axis.sortPrune.sortAscending=true}axis.sortPrune.generateOthersCategory=dim.generateOthersCategory;axis.sortPrune.filters=dim.filters;if(!ChartFeatures.supportSorting(dim,chartDef,!isMainInteractiveDateAxis)){axis.sortPrune={sortType:"NATURAL",sortAscending:true}}return axis};const measureToAggregation=function(measure,id){const ret={..._.pick(measure,["column","type","isUnaggregated","uaComputeMode","function","computeModeDim","customFunction","percentile"]),computeMode:measure.computeMode||"NORMAL",id:id};return ret};const addAggregations=function(request,chartDef,colorMeasures){const chartWrapperElts=angular.element(document.querySelector(".chart-wrapper-zone"));const chartWrapperHeight=chartWrapperElts?.[0]?.offsetHeight;request.aggregations=chartDef.genericMeasures.map(m=>{const res=measureToAggregation(m);if(m.isUnaggregated&&chartWrapperHeight){res.maxUAValuesPerTensorElement=Math.floor(chartWrapperHeight)}return res}).concat(chartDef.tooltipMeasures.map(measureToAggregation)).concat(colorMeasures).concat(ChartFeatures.canDisplayTotalValues(chartDef)&&chartDef.stackedColumnsOptions&&chartDef.stackedColumnsOptions.totalsInChartDisplayOptions&&chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.additionalMeasures?chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.additionalMeasures.map(measureToAggregation):[]).concat(_.flatten(chartDef.genericMeasures.map(m=>m.valuesInChartDisplayOptions&&m.valuesInChartDisplayOptions.additionalMeasures?m.valuesInChartDisplayOptions.additionalMeasures.map(measureToAggregation):[])));request.count=true};const addUa=function(request,ua,id){const ret={id:id,column:ua.column,type:ua.type};if(ua.treatAsAlphanum&&ua.type=="NUMERICAL"){ret.type="ALPHANUM"}else if(ua.type=="DATE"){ret.dateMode=ua.dateMode}request.columns.push(ret)};const addFilters=function(request,chartDef){request.filters=angular.copy(chartDef.filters).map(filter=>{if(filter.selectedValues){filter.selectedValues=Object.keys(filter.selectedValues)}if(filter.excludedValues){filter.excludedValues=Object.keys(filter.excludedValues)}return filter})};const clipLeaflet=function(chartSpecific,request){if(chartSpecific.leafletMap){const bounds=chartSpecific.leafletMap.getBounds();request.minLon=bounds.getWest();request.maxLon=bounds.getEast();request.minLat=bounds.getSouth();request.maxLat=bounds.getNorth()}};const getScatterAxis=function(dim){const ret={column:dim.column,type:dim.type};if(dim.treatAsAlphanum&&dim.type=="NUMERICAL"){ret.type="ALPHANUM"}if(ret.type=="ALPHANUM"){ret.sortPrune={sortType:dim.sortBy||"COUNT"};if(dim.sortBy=="COUNT"){ret.sortPrune.sortAscending=false}else{ret.sortPrune.sortAscending=true}}else if(ret.type=="DATE"){ret.dateMode=dim.dateMode}return ret};const computeScatter=function(chartDef,chartSpecific){Logger.info("Compute scatter request for",chartDef);const request={};request.type="SCATTER_NON_AGGREGATED";request.maxRows=!_.isNil(chartDef.scatterOptions.numberOfRecords)?chartDef.scatterOptions.numberOfRecords:1e6;request.xAxis=getScatterAxis(chartDef.uaXDimension[0]);request.yAxis=getScatterAxis(chartDef.uaYDimension[0]);request.columns=[];if(has(chartDef.uaSize)){addUa(request,chartDef.uaSize[0],"size")}if(has(chartDef.uaColor)){addUa(request,chartDef.uaColor[0],"color")}if(has(chartDef.uaShape)){chartDef.uaShape[0].type="ALPHANUM";addUa(request,chartDef.uaShape[0],"shape")}chartDef.uaTooltip.forEach(function(ua,idx){addUa(request,ua,"tooltip_"+idx)});addFilters(request,chartDef);addSideRequests(chartDef,request,[chartDef.uaXDimension[0],chartDef.uaYDimension[0]],chartSpecific);return request};const computeScatterMultiplePairs=function(chartDef,chartSpecific){Logger.info("Compute scatter request for",chartDef);const request={};request.type="SCATTER_MULTIPLE_PAIRS_NON_AGGREGATED";request.maxRows=!_.isNil(chartDef.scatterMPOptions.numberOfRecords)?chartDef.scatterMPOptions.numberOfRecords:1e6;request.axisPairs=[];request.columns=[];const displayablePairs=ChartUADimension.getDisplayableDimensionPairs(chartDef.uaDimensionPair);const usedDimensions=[];displayablePairs.forEach(function(pair){const uaXDimension=ChartUADimension.getPairUaXDimension(displayablePairs,pair);const xAxis=getScatterAxis(uaXDimension[0]);const yAxis=getScatterAxis(pair.uaYDimension[0]);const axisPair={xAxis:xAxis,yAxis:yAxis};request.axisPairs.push(axisPair);usedDimensions.push(uaXDimension[0]);usedDimensions.push(pair.uaYDimension[0])});chartDef.uaTooltip.forEach(function(ua,idx){addUa(request,ua,"tooltip_"+idx)});addFilters(request,chartDef);addSideRequests(chartDef,request,usedDimensions,chartSpecific);return request};const computeAdminMap=function(chartDef,chartSpecific){const request={};const dim0=chartDef.geometry[0];request.type="AGGREGATED_GEO_ADMIN";request.geoColumn=dim0.column;if(!dim0.adminLevel){dim0.adminLevel=2}request.adminLevel=dim0.adminLevel;request.filled=chartDef.variant=="filled_map";clipLeaflet(chartSpecific,request);request.aggregations=[];if(has(chartDef.colorMeasure)){const a=measureToAggregation(chartDef.colorMeasure[0]);a.id="color";request.aggregations.push(a)}if(has(chartDef.sizeMeasure)){const a=measureToAggregation(chartDef.sizeMeasure[0]);a.id="size";request.aggregations.push(a)}request.aggregations=request.aggregations.concat(chartDef.tooltipMeasures.map(measureToAggregation));request.count=true;addFilters(request,chartDef);return request};const computeGridMap=function(chartDef,chartSpecific){const request={};const dim0=chartDef.geometry[0];request.type="AGGREGATED_GEO_GRID";request.geoColumn=dim0.column;clipLeaflet(chartSpecific,request);request.lonRadiusDeg=chartDef.mapGridOptions.gridLonDeg;request.latRadiusDeg=chartDef.mapGridOptions.gridLatDeg;request.aggregations=[];if(has(chartDef.colorMeasure)){const a=measureToAggregation(chartDef.colorMeasure[0]);a.id="color";request.aggregations.push(a)}if(has(chartDef.sizeMeasure)){const a=measureToAggregation(chartDef.sizeMeasure[0]);a.id="size";request.aggregations.push(a)}chartDef.tooltipMeasures.forEach(function(measure,idx){const a=measureToAggregation(measure);a.id="tooltip_"+idx;request.aggregations.push(a)});request.count=true;addFilters(request,chartDef);return request};const _handleStandardSubchartsAndAnimation=function(chartDef,request){if(has(chartDef.facetDimension)){request.axes.push(makeAggregatedAxis(chartDef.facetDimension[0],chartDef));request.postPruneLimits.push({limit:200,axesToCheck:[request.axes.length-1],template:"Too many subcharts: %d, limit %d"})}if(has(chartDef.animationDimension)){request.axes.push(makeAggregatedAxis(chartDef.animationDimension[0],chartDef));request.postPruneLimits.push({limit:1e3,axesToCheck:[request.axes.length-1],template:"Too many animation steps: %d, limit %d"})}};const getSideRequestsFromMeasures=function(chartDef,measures){const sideRequests=[];const withFilters=measures.filter(m=>!m.ignoreExistingFilters);const withoutFilters=measures.filter(m=>m.ignoreExistingFilters);withFilters.length&&sideRequests.push(computeKpi({...chartDef,genericMeasures:withFilters}));withoutFilters.length&&sideRequests.push(computeKpi({...chartDef,genericMeasures:withoutFilters},false));return sideRequests};const addRequestsFromSource=function(chartDef,request,source_key,source,usedColumns,customMeasures,allMeasures){const DATASET_COLUMN="DatasetColumn";const CUSTOM_AGG="CustomAggregation";if(source&&!source.length){source=[source]}const sourceMeasures=source&&source.filter(measure=>[DATASET_COLUMN,CUSTOM_AGG].includes(measure.sourceType)).map(measure=>{const measureMeta=ColumnAvailability.getDynamicMeasureMeta(measure,allMeasures,usedColumns,customMeasures);return{measure:measure,measureMeta:measureMeta}}).filter(({measureMeta})=>measureMeta.index!==-1).map(({measure,measureMeta})=>({...measureMeta.measure,function:measure.sourceType===CUSTOM_AGG?"CUSTOM":measure.aggregation,percentile:measure.percentile,ignoreExistingFilters:measure.ignoreExistingFilters}))||[];if(sourceMeasures.length){request.sideRequests={...request.sideRequests,[source_key]:getSideRequestsFromMeasures(chartDef,sourceMeasures)}}};const addSideRequests=function(chartDef,request,usedColumns,chartSpecific){const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(chartSpecific.datasetProjectKey,chartSpecific.datasetName,chartSpecific.context);const allMeasures=ChartUsableColumns.getUsableColumns(chartSpecific.datasetProjectKey,chartSpecific.datasetName,chartSpecific.context);const sideRequestsSources={REFERENCE_LINES:chartDef.referenceLines,GAUGE_MAX:chartDef.gaugeOptions.max,GAUGE_MIN:chartDef.gaugeOptions.min,GAUGE_TARGETS:chartDef.gaugeOptions.targets,GAUGE_RANGES:chartDef.gaugeOptions.ranges};Object.entries(sideRequestsSources).forEach(([source_key,source])=>addRequestsFromSource(chartDef,request,source_key,source,usedColumns,customMeasures,allMeasures))};const computeStdAggregated=function(chartDef,chartSpecific,computeSubTotals,chartHeight){const request={type:"AGGREGATED_ND",axes:[],postPruneLimits:[]};request.postPruneLimits.push({limit:1e5});let interactiveDateDimension;if(has(chartDef.genericDimension0)&&has(chartDef.genericHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard dimension")}if(has(chartDef.genericDimension0)||has(chartDef.genericHierarchyDimension)){const dimension=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef)||chartDef.genericDimension0[0];if(ChartDimension.isCandidateForInteractivity(dimension)){interactiveDateDimension=dimension}request.axes.push(makeAggregatedAxis(dimension,chartDef,true));if(chartDef.type!=CHART_TYPES.STACKED_BARS){request.postPruneLimits.push({axesToCheck:[0],limit:1e4,template:"Too many elements in axis: %d, limit %d"})}}if(has(chartDef.genericDimension1)){const dimension=chartDef.genericDimension1[0];request.axes.push(makeAggregatedAxis(dimension,chartDef,false))}_handleStandardSubchartsAndAnimation(chartDef,request);if(chartDef.genericMeasures.length===0){throw new Error("To finish your chart, please select what you want to display and drop it in the 'Show' section")}addAggregations(request,chartDef,[],chartHeight);addFilters(request,chartDef);if(interactiveDateDimension&&chartSpecific.zoomUtils&&!chartSpecific.zoomUtils.disableZoomFiltering){request.filters.push(ChartDimension.buildZoomRuntimeFilter(interactiveDateDimension,chartSpecific.zoomUtils))}if(chartSpecific.zoomUtils&&chartSpecific.zoomUtils.sequenceId){request.sequenceId=chartSpecific.zoomUtils.sequenceId}request.computeSubTotals=computeSubTotals;addSideRequests(chartDef,request,chartDef.genericMeasures,chartSpecific);return request};const computeHierarchical=function(chartDef){const request={type:"AGGREGATED_ND",axes:[],postPruneLimits:[]};if(has(chartDef.xDimension)&&has(chartDef.xHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard x dimension")}if(has(chartDef.yDimension)&&has(chartDef.yHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard y dimension")}if(has(chartDef.xHierarchyDimension)){request.axes.push(makeAggregatedAxis(ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"x"),chartDef))}if(has(chartDef.xDimension)){request.axes.push(...chartDef.xDimension.map(xDim=>makeAggregatedAxis(xDim,chartDef)))}if(has(chartDef.yHierarchyDimension)){request.axes.push(makeAggregatedAxis(ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"y"),chartDef))}if(has(chartDef.yDimension)){request.axes.push(...chartDef.yDimension.map(yDim=>makeAggregatedAxis(yDim,chartDef)))}request.aggregations=[];let colorAggs=[];if((!ChartFeatures.canHaveConditionalFormatting(chartDef.type)||chartDef.colorMode===ColorMode.UNIQUE_SCALE)&&has(chartDef.colorMeasure)){colorAggs=measureToAggregation(chartDef.colorMeasure[0],"color")}else if(chartDef.colorMode===ColorMode.COLOR_GROUPS){colorAggs=chartDef.colorGroups.filter(group=>has(group.colorMeasure)).map((group,i)=>measureToAggregation(group.colorMeasure[0],`color_${i}`))}addAggregations(request,chartDef,colorAggs);addFilters(request,chartDef);request.computeSubTotals=true;const{store,id}=ChartStoreFactory.getOrCreate(chartDef.$chartStoreId);chartDef.$chartStoreId=id;const requestOptions=store.getRequestOptions();if(!requestOptions.removePivotTableLimitations){request.postPruneLimits.push({limit:2e5})}return request};const computeBinnedXY=function(chartDef,width,height){const request={type:"AGGREGATED_ND",aggregations:[],postPruneLimits:[]};request.postPruneLimits.push({limit:1e5});if(has(chartDef.xDimension)&&has(chartDef.xHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard dimension on the X axis")}if(has(chartDef.yDimension)&&has(chartDef.yHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard dimension on the Y axis")}const xDimension=ChartDimension.getXDimension(chartDef);const yDimension=ChartDimension.getYDimension(chartDef);request.axes=[makeAggregatedAxis(xDimension,chartDef),request.yAxis=makeAggregatedAxis(yDimension,chartDef)];if(has(chartDef.sizeMeasure)){request.aggregations.push(measureToAggregation(chartDef.sizeMeasure[0],"size"))}if(has(chartDef.colorMeasure)){request.aggregations.push(measureToAggregation(chartDef.colorMeasure[0],"color"))}chartDef.tooltipMeasures.forEach(function(measure){request.aggregations.push(measureToAggregation(measure,"tooltip"))});_handleStandardSubchartsAndAnimation(chartDef,request);addFilters(request,chartDef);if(chartDef.variant==CHART_VARIANTS.binnedXYHexagon){request.hexbin=true;const margins={top:10,right:50,bottom:50,left:50};const chartWidth=width-margins.left-margins.right;const chartHeight=height-margins.top-margins.bottom;const radius=BinnedXYUtils.getRadius(chartDef,chartWidth,chartHeight);request.hexbinXHexagons=Math.floor(chartWidth/(2*Math.cos(Math.PI/6)*radius));request.hexbinYHexagons=Math.floor(chartHeight/(1.5*radius));request.$expectedVizWidth=chartWidth;request.$expectedVizHeight=chartHeight}return request};const computeGroupedXY=function(chartDef){if(has(chartDef.groupDimension)&&has(chartDef.groupHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard group dimension")}const request={type:"AGGREGATED_ND",axes:[makeAggregatedAxis(ChartDimension.getGroupDimension(chartDef),chartDef)],postPruneLimits:[]};request.postPruneLimits.push({limit:1e5});_handleStandardSubchartsAndAnimation(chartDef,request);request.aggregations=[measureToAggregation(chartDef.xMeasure[0]),measureToAggregation(chartDef.yMeasure[0])];if(has(chartDef.sizeMeasure)){request.aggregations.push(measureToAggregation(chartDef.sizeMeasure[0],"size"))}if(has(chartDef.colorMeasure)){request.aggregations.push(measureToAggregation(chartDef.colorMeasure[0],"color"))}addFilters(request,chartDef);return request};const computeLift=function(chartDef){if(has(chartDef.groupDimension)&&has(chartDef.groupHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard group dimension")}const request={type:"AGGREGATED_ND",axes:[makeAggregatedAxis(ChartDimension.getGroupDimension(chartDef),chartDef)],postPruneLimits:[]};request.postPruneLimits.push({limit:1e4});_handleStandardSubchartsAndAnimation(chartDef,request);request.aggregations=[measureToAggregation(chartDef.xMeasure[0]),measureToAggregation(chartDef.yMeasure[0])];addFilters(request,chartDef);return request};const computeBoxplots=function(chartDef){const request={type:"BOXPLOTS",axes:[]};if(has(chartDef.boxplotBreakdownDim)&&has(chartDef.boxplotBreakdownHierarchyDimension)){throw new Error("The request cannot include both a hierarchy dimension and a standard breakdown dimension")}const breakdownDimension=ChartDimension.getBreakdownDimension(chartDef);if(breakdownDimension){request.axes.push(makeAggregatedAxis(breakdownDimension,chartDef))}if(breakdownDimension&&has(chartDef.genericDimension1)){request.axes.push(makeAggregatedAxis(chartDef.genericDimension1[0],chartDef))}request.column={column:chartDef.boxplotValue[0].column,type:chartDef.boxplotValue[0].type};addFilters(request,chartDef);return request};const computeDensity2D=function(chartDef){const request={};request.type="DENSITY_2D";request.xColumn=chartDef.xDimension[0].column;request.yColumn=chartDef.yDimension[0].column;addFilters(request,chartDef);return request};const computeKpi=function(chartDef,withFilters=true){const request={};request.type="NO_PIVOT_AGGREGATED";const colorAggs=chartDef.colorGroups.filter(group=>has(group.colorMeasure)).map((group,i)=>measureToAggregation(group.colorMeasure[0],`color_${i}`));addAggregations(request,chartDef,colorAggs);withFilters&&addFilters(request,chartDef);return request};const computeGauge=function(chartDef,chartSpecific){const request={};request.type="NO_PIVOT_AGGREGATED";addAggregations(request,chartDef,[]);addFilters(request,chartDef);let rangesAndTargetsList=[];if(chartDef.gaugeOptions.targets){rangesAndTargetsList=rangesAndTargetsList.concat(chartDef.gaugeOptions.targets)}if(chartDef.gaugeOptions.ranges){rangesAndTargetsList=rangesAndTargetsList.concat(chartDef.gaugeOptions.ranges)}const usedDimensions=[chartDef.gaugeOptions.min,chartDef.gaugeOptions.max,...rangesAndTargetsList];addSideRequests(chartDef,request,usedDimensions,chartSpecific);return request};const computeScatterMap=function(chartDef,chartSpecific){const request={};request.type="MAP_SCATTER_NON_AGGREGATED";request.maxRows=1e5;request.geoColumn=chartDef.geometry[0].column;clipLeaflet(chartSpecific,request);request.columns=[];if(has(chartDef.uaSize)){addUa(request,chartDef.uaSize[0],"size")}if(has(chartDef.uaColor)){addUa(request,chartDef.uaColor[0],"color")}chartDef.uaTooltip.forEach(function(ua,idx){addUa(request,ua,"tooltip_"+idx)});addFilters(request,chartDef);return request};const computeDensityHeatMap=function(chartDef,chartSpecific){return computeScatterMap(chartDef,chartSpecific)};const computeGeometryMap=function(chartDef,chartSpecific){const request={};request.type="RAW_GEOMETRY";request.maxRows=1e5;request.geoColumns=[];request.columns=[];const displayedGeoLayers=_GeometryCommon.getDisplayableLayers(chartDef.geoLayers);displayedGeoLayers.forEach(function(geoLayer,index){const geometry=geoLayer.geometry[0];const geoColumn={column:geometry.column};if(geometry.aggregationFunction){geoColumn.aggregationFunction=geometry.aggregationFunction}request.geoColumns.push(geoColumn);if(has(geoLayer.uaColor)&&geoLayer.uaColor[0].column){addUa(request,geoLayer.uaColor[0],ChartColorUtils.getPaletteName(index))}});chartDef.uaTooltip.forEach(function(ua,idx){addUa(request,ua,"tooltip_"+idx)});addFilters(request,chartDef);return request};const computeWebapp=function(chartDef,chartSpecific){const request={};request.type="WEBAPP";request.columns=[];addFilters(request,chartDef);return request};const computeFilters=function(chartDef){const request={type:"FILTERS",columns:[]};addFilters(request,chartDef);return request};const svc={addFilters:addFilters,compute:function(chartDef,width,height,chartSpecific){if(chartDef.facetDimension&&chartDef.facetDimension.length){height=chartDef.chartHeight}switch(chartDef.type){case CHART_TYPES.GROUPED_COLUMNS:case CHART_TYPES.STACKED_COLUMNS:case CHART_TYPES.STACKED_BARS:case CHART_TYPES.LINES:case CHART_TYPES.STACKED_AREA:case CHART_TYPES.RADAR:case CHART_TYPES.PIE:return computeStdAggregated(chartDef,chartSpecific,false,height);case CHART_TYPES.MULTI_COLUMNS_LINES:{const computeSubTotals=MultiplotUtils.shouldSubtotalsBeCalculated(chartDef);const modifiedChartDef=MultiplotUtils.shouldTakeColorDimensionInAccount(chartDef)?chartDef:{...chartDef,genericDimension1:[]};return computeStdAggregated(modifiedChartDef,chartSpecific,computeSubTotals,height)}case CHART_TYPES.PIVOT_TABLE:if(!has(chartDef.xDimension)&&!has(chartDef.xHierarchyDimension)&&!has(chartDef.yDimension)&&!has(chartDef.yHierarchyDimension)){return computeKpi(chartDef)}return computeHierarchical(chartDef);case CHART_TYPES.SANKEY:case CHART_TYPES.TREEMAP:return computeHierarchical(chartDef);case CHART_TYPES.BINNED_XY:return computeBinnedXY(chartDef,width,height);case CHART_TYPES.GROUPED_XY:return computeGroupedXY(chartDef);case CHART_TYPES.SCATTER:return computeScatter(chartDef,chartSpecific);case CHART_TYPES.SCATTER_MULTIPLE_PAIRS:return computeScatterMultiplePairs(chartDef,chartSpecific);case CHART_TYPES.ADMINISTRATIVE_MAP:return computeAdminMap(chartDef,chartSpecific);case CHART_TYPES.GRID_MAP:return computeGridMap(chartDef,chartSpecific);case CHART_TYPES.SCATTER_MAP:return computeDensityHeatMap(chartDef,chartSpecific);case CHART_TYPES.DENSITY_HEAT_MAP:return computeScatterMap(chartDef,chartSpecific);case CHART_TYPES.GEOMETRY_MAP:return computeGeometryMap(chartDef,chartSpecific);case CHART_TYPES.BOXPLOTS:return computeBoxplots(chartDef);case CHART_TYPES.DENSITY_2D:return computeDensity2D(chartDef);case CHART_TYPES.GAUGE:return computeGauge(chartDef,chartSpecific);case CHART_TYPES.KPI:return computeKpi(chartDef);case CHART_TYPES.LIFT:var req=computeLift(chartDef);req.diminishingReturns=true;return req;case CHART_TYPES.WEBAPP:return computeWebapp(chartDef,chartSpecific);case CHART_TYPES.FILTERS:return computeFilters(chartDef);default:Logger.error("Unhandled chart type",chartDef);throw new Error("unknown chart type",chartDef)}}};return svc})})();(function(){"use strict";const app=angular.module("dataiku.directives.simple_report");app.service("ChartSetErrorInScope",function(){function buildErrorValidityObject(message,showRevertEngineButton){return{message:message,showRevertEngineButton:showRevertEngineButton,valid:false,type:"COMPUTE_ERROR"}}function buildValidityForKnownError(data,status,headers){const errorDetails=getErrorDetails(data,status,headers);if(errorDetails.errorType==="com.dataiku.dip.pivot.backend.model.SecurityAbortedException"){return buildErrorValidityObject("Too many elements to draw. Please adjust chart settings ("+errorDetails.message+")",false)}else if(errorDetails.errorType==="ApplicativeException"){return buildErrorValidityObject(errorDetails.message,false)}else if(errorDetails.errorType==="com.dataiku.dip.exceptions.EngineNotAvailableException"){return buildErrorValidityObject(errorDetails.message,true)}return undefined}const svc={buildValidityForKnownError:buildValidityForKnownError,defineInScope:function(scope){if("chartSetErrorInScope"in scope){return}scope.validity={valid:true};scope.setValidity=function(validity){scope.validity=validity};scope.chartSetErrorInScope=function(data,status,headers){const validity=buildValidityForKnownError(data,status,headers);if(validity){scope.validity=validity}else{setErrorInScope.bind(scope)(data,status,headers)}}}};return svc})})();function ChartIAE(message){this.message=message;this.name="ChartIAE"}ChartIAE.prototype=new Error;(function(){"use strict";angular.module("dataiku.charts").factory("_GeometryCommon",GeometryCommon);function GeometryCommon(ColorUtils,ChartColorScales,UaChartsCommon){const svc={hasUAColor:function(geoLayer){return geoLayer.uaColor.length>0&&geoLayer.uaColor[0].column},makeColorScale:function(geoLayer,data,chartHandler,geometryIndex){const uaColor=geoLayer.uaColor[0];const colorTokenName="color_"+geometryIndex;const chartData={data:data};const colorSpec={type:"UNAGGREGATED",dimension:uaColor,data:data.values[colorTokenName],withRgba:true};const colorContext={chartData:chartData,colorOptions:geoLayer.colorOptions,defaultLegendDimension:[],colorSpec:colorSpec,chartHandler:chartHandler,uaColorIndex:geometryIndex,theme:chartHandler.getChartTheme()};return ChartColorScales.createColorScale(colorContext)},makeSingleColor:function(geoLayer){return ColorUtils.toRgba(geoLayer.colorOptions.singleColor,geoLayer.colorOptions.transparency)},makeColor:function(geoLayer,data,i,colorScale,resultingColor,colorCache,geometryIndex){if(svc.hasUAColor(geoLayer)){const color=data.values["color_"+geometryIndex];return ChartColorScales.getColor(geoLayer.uaColor,color,i,colorScale,colorCache)}else{return resultingColor}},formattedColorVal:function(chartDef,data,i,paletteName,geometryIndex){let uaColor;if(typeof geometryIndex==="undefined"){uaColor=chartDef.uaColor[0]}else{uaColor=chartDef.geoLayers[geometryIndex].uaColor[0]}paletteName=paletteName||"color";return UaChartsCommon.formattedVal(data.values[paletteName],uaColor,i)},getDisplayableLayers:function(geoLayers){let isLayerDisplayable;const displayableGeoLayers=[];for(const geoLayer of geoLayers.slice(0,-1)){isLayerDisplayable=geoLayer.geometry&&geoLayer.geometry.length&&geoLayer.geometry[0].column;if(isLayerDisplayable){displayableGeoLayers.push(geoLayer)}}return displayableGeoLayers}};return svc}})();(function(){"use strict";angular.module("dataiku.charts").factory("ChartLegendUtils",ChartLegendUtils);function ChartLegendUtils(CreateCustomElementFromTemplate,$q,$timeout,ColorUtils,ChartColorUtils,ChartLabels,ChartDimension,ChartDataUtils,ChartFeatures,ChartFormatting,ChartUADimension,CHART_TYPES,CHART_AXIS_TYPES,ChartIconUtils){const that={initLegend:function(chartDef,chartData,legendsWrapper,colorScale,options){if(!colorScale||!ChartFeatures.shouldComputeLegend(chartDef.type)){legendsWrapper.deleteLegends();return}if(chartDef.colorMode==="COLOR_GROUPS"&&ChartFeatures.canHaveConditionalFormatting(chartDef.type)){const legend=that.createContinuousLegend(ChartColorUtils.getColorDimensionOrMeasure(chartDef),colorScale);legendsWrapper.pushLegend(legend);return}switch(colorScale.type){case CHART_AXIS_TYPES.DIMENSION:return that.initDimensionLegend(chartDef,chartData,legendsWrapper,colorScale,options);case CHART_AXIS_TYPES.MEASURE:return that.initMeasureLegend(chartDef,legendsWrapper,colorScale);case CHART_AXIS_TYPES.UNAGGREGATED:if(colorScale.isContinuous){return that.initMeasureLegend(chartDef,legendsWrapper,colorScale)}return;case"CUSTOM":return that.initCustomLegend(chartDef,chartData,legendsWrapper,colorScale,options);default:throw new Error("Unknown scale type: "+colorScale.type)}},initDimensionLegend:function(chartDef,chartData,legendsWrapper,colorScale,options={hideLegend:false,ignoreLabels:new Set}){const{hideLegend,ignoreLabels}=options;const colorDimensionLabels=chartData.getAxisLabels("color");const defaultLegendDimension=ChartColorUtils.getDefaultLegendDimension(chartDef,chartData);const colorLabels=chartData.getLegendColorLabels(colorDimensionLabels,defaultLegendDimension);const colorDimension=ChartColorUtils.getColorDimensionOrMeasure(chartDef);const items=colorLabels.filter(colorLabel=>!ignoreLabels||!ignoreLabels.has(colorLabel.label)).map(function(colorOrMeasure,c){const color=colorScale(c);return{label:{colorId:ChartColorUtils.getColorId(defaultLegendDimension,chartData,c,undefined,ignoreLabels,!!chartData.ignoreColorDimension),label:colorOrMeasure.label||chartData.getColorMeasureOrDimensionLabel(colorOrMeasure,chartDef.uaDimensionPair),min:colorOrMeasure.min,max:colorOrMeasure.max,sortValue:colorOrMeasure.sortValue,tsValue:colorOrMeasure.tsValue},color:color,desaturatedColor:ColorUtils.desaturate(color),rgbaColor:ColorUtils.toRgba(colorScale(c),ChartColorUtils.getTransparency(chartDef)),focused:false,unfocusFn:function(){},focusFn:function(){},id:c,elements:d3.select()}});legendsWrapper.deleteLegends();legendsWrapper.pushLegend({type:"COLOR_DISCRETE",minValue:chartData.getMinValue("color"),maxValue:chartData.getMaxValue("color"),numValues:chartData.getNumValues("color"),numberFormattingOptions:colorDimension&&ChartDimension.getNumberFormattingOptions(colorDimension),items:items,hideLegend:hideLegend})},initMeasureLegend:function(chartDef,legendsWrapper,colorScale){legendsWrapper.deleteLegends();const legend=that.createContinuousLegend(ChartColorUtils.getColorDimensionOrMeasure(chartDef),colorScale);legendsWrapper.pushLegend(legend)},initCustomLegend:function(chartDef,chartData,legendsWrapper,colorScale,options={hideLegend:false,ignoreLabels:new Set}){const{hideLegend,ignoreLabels}=options;const colorDimensionLabels=chartData.getAxisLabels("color",ignoreLabels)||[];const genericMeasures=chartDef.genericMeasures.filter(colorScale.customHandle);const colorLabels=colorDimensionLabels.concat(genericMeasures.filter(colorLabel=>!ignoreLabels.has(colorLabel.label)));const colorDimension=ChartColorUtils.getColorDimensionOrMeasure(chartDef);const items=colorLabels.map(function(colorOrMeasure,c){const color=colorScale(c);return{label:{colorId:ChartColorUtils.getColorId(colorLabels,chartData,c,undefined,ignoreLabels,colorOrMeasure.isA==="measure"),label:colorOrMeasure.label||ChartLabels.getLongMeasureLabel(colorOrMeasure),min:colorOrMeasure.min,max:colorOrMeasure.max,sortValue:colorOrMeasure.sortValue,tsValue:colorOrMeasure.tsValue},color:color,desaturatedColor:ColorUtils.desaturate(color),rgbaColor:ColorUtils.toRgba(colorScale(c),chartDef.colorOptions.transparency),focused:false,unfocusFn:function(){},focusFn:function(){},id:c,elements:d3.select()}});legendsWrapper.deleteLegends();legendsWrapper.pushLegend({type:"COLOR_DISCRETE",minValue:chartData.getMinValue("color"),maxValue:chartData.getMaxValue("color"),numValues:items.length,numberFormattingOptions:colorDimension&&ChartDimension.getNumberFormattingOptions(colorDimension),items:items,hideLegend:hideLegend})},drawLegend:function(chartDef,chartHandler,$container){const deferred=$q.defer();const $legendZone=$container.find(".legend-zone");if(chartDef.legendPlacement==="SIDEBAR"){$legendZone.empty();$container.attr("legend-placement",chartDef.legendPlacement);deferred.resolve();return deferred.promise}CreateCustomElementFromTemplate("/templates/simple_report/legend/legend-zone.html",chartHandler,null,function(){$timeout(deferred.resolve)},function($el){$container.attr("legend-placement",chartDef.legendPlacement);if($legendZone.length){$el.css({"min-width":$legendZone.outerWidth(),overflow:"hidden"});$timeout(()=>{$legendZone.replaceWith($el);$el.removeAttr("style")})}else{$el.appendTo($container)}});return deferred.promise},createLegend:($container,chartDef,chartData,chartHandler,colorSpec,colorScale,extraOptions)=>{that.initLegend(chartDef,chartData,chartHandler.legendsWrapper,colorScale,extraOptions);if(chartDef.type===CHART_TYPES.SCATTER){that.createScatterLegend(chartDef,chartHandler,chartData,colorScale)}if(chartHandler.legendsWrapper.hasLegends()&&chartHandler.legendsWrapper.getLegend(0).type==="COLOR_CONTINUOUS"&&ChartFeatures.canDisplayLegend(chartDef.type)){const colorUaOrMeasure=chartDef.type===CHART_TYPES.SCATTER?chartDef.uaColor[0]:chartDef.colorMeasure[0];if(colorSpec.type==="UNAGGREGATED"){if(ChartUADimension.isAlphanumLike(colorUaOrMeasure)||ChartUADimension.isDiscreteDate(colorUaOrMeasure)){}else if(ChartUADimension.isDateRange(colorUaOrMeasure)){chartHandler.legendsWrapper.getLegend(0).formatter=ChartFormatting.getForDate()}else{chartHandler.legendsWrapper.getLegend(0).formatter=ChartFormatting.getForLegend(colorUaOrMeasure,colorScale.innerScale.domain())}}else{const extent=colorSpec.extent||ChartDataUtils.getMeasureExtent(chartData,colorSpec.measureIdx,true);chartHandler.legendsWrapper.getLegend(0).formatter=ChartFormatting.getForLegend(colorUaOrMeasure,extent)}}return that.drawLegend(chartDef,chartHandler,$container)},adjustLegendPlacement:function(chartDef,$container,margins){const $legendZone=$container.find(".legend-zone");const getEffectiveLeftMargin=function(){if(chartDef.facetDimension.length){return $(".facet-info").width()+margins.left}else{return margins.left}};const setMaxSize=function(){$legendZone.css("max-height","calc(100% - "+(margins.top+margins.bottom)+"px)").css("max-width","25%").css("visibility","visible")};switch(chartDef.legendPlacement){case"INNER_TOP_LEFT":$legendZone.css("left",getEffectiveLeftMargin()).css("top",margins.top);setMaxSize();break;case"INNER_TOP_RIGHT":$legendZone.css("right",margins.right).css("top",margins.top);setMaxSize();break;case"INNER_BOTTOM_LEFT":$legendZone.css("left",getEffectiveLeftMargin()).css("bottom",margins.bottom);setMaxSize();break;case"INNER_BOTTOM_RIGHT":$legendZone.css("right",margins.right).css("bottom",margins.bottom);setMaxSize();break;default:break}},createContinuousLegend:function(colorDimension,colorScale){const numberFormattingOptions=colorDimension&&ChartDimension.getNumberFormattingOptions(colorDimension);colorScale.type="MEASURE";return{type:"COLOR_CONTINUOUS",scale:colorScale,numberFormattingOptions:numberFormattingOptions}},getSingleColorLegend:function(singleColor,label){return{type:"COLOR_DISCRETE",label:label,items:[{color:singleColor}]}},createScatterLegend:function(chartDef,chartHandler,chartData,colorScale){const hasUAColor=chartData.hasUAColor(chartDef);const hasUAShape=chartData.hasUAShape(chartDef);const shapeScale=chartData.makeShapeScale();const hasColorLegend=hasUAColor&&(ChartUADimension.isAlphanumLike(chartDef.uaColor[0])||ChartUADimension.isDiscreteDate(chartDef.uaColor[0]));if(hasUAShape||hasColorLegend){const legend={type:"COLOR_DISCRETE",items:[]};if(hasColorLegend){colorScale.domain().forEach(v=>{const item={label:{colorId:ChartColorUtils.getColorId(chartDef.genericMeasures,chartData,v),...chartData.data.values.color.str.sortedMapping[v]},color:colorScale(v),focused:false};legend.items.push(item)})}if(hasUAShape&&hasColorLegend){legend.items.push({separator:true})}if(hasUAShape){Object.values(chartData.data.values.shape.str.sortedMapping).forEach((v,index)=>{const shapeType=shapeScale(index).type;const item={label:v,shape:{svgSrc:ChartIconUtils.computeScatterLegendIcon(shapeType)},focused:false};legend.items.push(item)})}chartHandler.legendsWrapper.deleteLegends();chartHandler.legendsWrapper.pushLegend(legend)}else if(hasUAColor){}else{chartHandler.legendsWrapper.deleteLegends()}}};return that}})();(function(){"use strict";angular.module("dataiku.charts").factory("BarChartUtils",BarChartUtils);function BarChartUtils(ChartDimension,SVGUtils,ValuesInChartOverlappingStrategy){return{getTranslateFunctions:function(axisName,axis,labels,thickness){const dimension=axis.dimension;const hasOneTickPerBin=ChartDimension.hasOneTickPerBin(dimension);let translate;if(!hasOneTickPerBin&&ChartDimension.isTimeline(dimension)){translate=i=>axis.scale()((labels[i].min+labels[i].max)/2)-thickness/2}else if(!hasOneTickPerBin&&ChartDimension.isTrueNumerical(dimension)){translate=i=>axis.scale()(labels[i].sortValue)-thickness/2}else{translate=i=>axis.ordinalScale(i)}switch(axisName){case"x":return{x:(d,i)=>translate(i),y:()=>0};case"y":return{x:()=>0,y:(d,i)=>translate(i)};default:return null}},translate:function(axisName,axis,labels,thickness){if(["x","y"].includes(axisName)){const transformations=this.getTranslateFunctions(axisName,axis,labels,thickness);return(d,i)=>`translate(${transformations.x(d,i)}, ${transformations.y(d,i)})`}return null},drawLabels(drawContext){drawContext.transform=this.translate(drawContext.axisName,drawContext.axis,drawContext.labels,drawContext.thickness);drawContext.transformations=this.getTranslateFunctions(drawContext.axisName,drawContext.axis,drawContext.labels,drawContext.thickness);SVGUtils.drawLabels(drawContext,"bars")},getExtraData(d,i,d3Context,chartBase,mainLabelDetectionHandler,labelDetectionHandlersByColor,colorScaleIndex,getLabelXPosition,getLabelYPosition,overlappingStrategy,defaultFontSize,onHoverMode){const hideOverlaps=overlappingStrategy===ValuesInChartOverlappingStrategy.AUTO;const labelPosition={x:getLabelXPosition(d,i),y:getLabelYPosition(d)};const overlappingKey=onHoverMode?"isOverlapAlt":"isOverlap";let overlapStatus=false;const getCurrentColorLabelCollisionDetectionHandler=()=>{if(!labelDetectionHandlersByColor[colorScaleIndex]){labelDetectionHandlersByColor[colorScaleIndex]=SVGUtils.initLabelCollisionDetection(chartBase)}return labelDetectionHandlersByColor[colorScaleIndex]};const labelDetectionHandler=onHoverMode?getCurrentColorLabelCollisionDetectionHandler():mainLabelDetectionHandler;let translate={x:0,y:0};if(d3Context&&d3Context.parentNode){const parentNode=d3Context.parentNode;const parentData=d3.select(parentNode).datum();if(parentData.translate){translate=parentData.translate}}const labelRectangles=SVGUtils.getRectanglesFromPosition(labelPosition,d,defaultFontSize).map(rectangle=>({...rectangle,x:rectangle.x+translate.x,y:rectangle.y+translate.y}));if(!hideOverlaps||!labelDetectionHandler.checkOverlaps(labelRectangles)){const isDisplayed=!!d.valuesInChartDisplayOptions?.displayValues;if(isDisplayed){labelDetectionHandler.addBoundingBoxesToQuadTree(labelRectangles)}}else{overlapStatus=true}d[overlappingKey]=overlapStatus;return{labelPosition:labelPosition}},shouldDisplayBarLabel(binCount,barValue){return binCount!==0||barValue!==0}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("GroupedColumnsChart",GroupedColumnsChart);function GroupedColumnsChart(ChartManager,ChartDataUtils,ChartDataWrapperFactory,GroupedColumnsDrawer,GroupedColumnsUtils,ReferenceLines,ColumnAvailability,ChartUsableColumns,ChartYAxisPosition,ChartAxesUtils,ChartCustomMeasures,SVGUtils,ChartDimension,CHART_VARIANTS){return function($container,chartDef,chartHandler,axesDef,data){const chartData=ChartDataWrapperFactory.chartGroupedColumnsDataWrapper(data,axesDef,chartDef);const dataSpec=chartHandler.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));const xSpec={type:"DIMENSION",mode:"COLUMNS",dimension:ChartDimension.getGenericDimension(chartDef),name:"x",customExtent:chartDef.xAxisFormatting.customExtent};ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);const yExtents=ChartDataUtils.getMeasureExtents(chartDef,chartData,"x"),leftYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT),rightYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT),isLeftYPercentScale=yExtents[leftYAxisID].onlyPercent,isRightYPercentScale=yExtents[rightYAxisID].onlyPercent;const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,xSpec,undefined),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,chartDef.genericMeasures,customMeasures),referenceLinesExtents=ReferenceLines.getReferenceLinesExtents(displayedReferenceLines,referenceLinesValues,{[leftYAxisID]:{isPercentScale:isLeftYPercentScale},[rightYAxisID]:{isPercentScale:isRightYPercentScale}});ReferenceLines.mutateDimensionSpecForReferenceLine(ChartDataUtils.getAxisExtent(chartData,"x",xSpec.dimension),referenceLinesExtents.x,xSpec);const animationData=GroupedColumnsUtils.prepareData(chartDef,chartData);const firstMeasure=chartDef.genericMeasures[0];if(chartDef.variant===CHART_VARIANTS.waterfall&&firstMeasure){yExtents[firstMeasure.displayAxis==="axis1"?leftYAxisID:rightYAxisID].extent=[animationData.minTotal,animationData.maxTotal]}const leftYExtent=ReferenceLines.getExtentWithReferenceLines(yExtents[leftYAxisID].extent,referenceLinesExtents[leftYAxisID]),rightYExtent=ReferenceLines.getExtentWithReferenceLines(yExtents[rightYAxisID].extent,referenceLinesExtents[rightYAxisID]);const drawFrame=function(frameIdx,chartBase){ReferenceLines.removeReferenceLines($container[0]);chartData.fixAxis("animation",frameIdx);animationData.frames[frameIdx].facets.forEach(function(facetData,f){const labelCollisionDetectionHandler=SVGUtils.initLabelCollisionDetection(chartBase);const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));GroupedColumnsDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",f),chartBase,facetData.groups,f,labelCollisionDetectionHandler)})};const leftYCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,leftYAxisID);const rightYCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,rightYAxisID);const ySpecs={[leftYAxisID]:{id:leftYAxisID,type:"MEASURE",extent:leftYExtent,isPercentScale:isLeftYPercentScale,customExtent:leftYCustomExtent,position:ChartYAxisPosition.LEFT},[rightYAxisID]:{id:rightYAxisID,type:"MEASURE",extent:rightYExtent,isPercentScale:isRightYPercentScale,customExtent:rightYCustomExtent,position:ChartYAxisPosition.RIGHT}};const availableAxes=ReferenceLines.getAvailableAxesForReferenceLines(chartDef);const axisSpecs={x:xSpec,...ySpecs};ChartAxesUtils.setNumberOfBinsToDimensions(chartData,chartDef,axisSpecs);ReferenceLines.updateAvailableAxisOptions([{axis:"LEFT_Y_AXIS",isDisplayed:availableAxes["LEFT_Y_AXIS"],isNumerical:true,isPercentScale:ySpecs[leftYAxisID].isPercentScale},{axis:"RIGHT_Y_AXIS",isDisplayed:availableAxes["RIGHT_Y_AXIS"],isNumerical:true,isPercentScale:ySpecs[rightYAxisID].isPercentScale},{axis:"X_AXIS",isDisplayed:true,isNumerical:ChartAxesUtils.isNumerical(xSpec)&&!ChartDimension.hasOneTickPerBin(xSpec.dimension),isContinuousDate:ChartAxesUtils.isContinuousDate(xSpec)}]);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,axisSpecs,{type:"DIMENSION",name:"color",dimension:chartDef.genericDimension1[0],ignoreColorDim:()=>!!chartData.ignoreColorDimension})}}})();(function(){"use strict";angular.module("dataiku.charts").factory("GroupedColumnsDrawer",GroupedColumnsDrawer);function GroupedColumnsDrawer(ChartDimension,Fn,BarChartUtils,SVGUtils,ChartAxesUtils,ReferenceLines,ColumnAvailability,ChartColorUtils,ChartCustomMeasures,ChartUsableColumns,ColorFocusHandler,CHART_TYPES,HierarchicalChartsUtils,ChartDrilldown,ChartHierarchyDimension,ValuesInChartPlacementMode,CHART_VARIANTS){const backgroundXMargin=4;return function(g,chartDef,chartHandler,chartData,chartBase,groupsData,f,labelCollisionDetectionHandler,drawReferenceLines=true){const xDimension=ChartDimension.getGenericDimension(chartDef),xLabels=chartData.getCustomAxisLabels("x")??chartData.getAxisLabels("x"),xAxis=chartBase.xAxis,rightAxis=ChartAxesUtils.getRightYAxis(chartBase.yAxes),leftAxis=ChartAxesUtils.getLeftYAxis(chartBase.yAxes),getScale=function(d){return chartDef.genericMeasures[d.measure].displayAxis=="axis1"?leftAxis.scale():rightAxis.scale()},getRectValue=function(d){return chartData.aggr(d.measure).get(chartData.getFinalCoords(d))};const nbMaxColumns=Math.max(...groupsData.map(group=>group.columns.filter(c=>!_.isNil(c.nonEmptyIdx)).length));let groupWidth=ChartDimension.isUngroupedNumerical(xDimension)?10:Math.max(1,xAxis.ordinalScale.rangeBand());groupWidth=Math.max(groupWidth*ChartAxesUtils.getCustomExtentRatio(chartDef.xAxisFormatting.customExtent),1);let barWidth=groupWidth;if(groupsData.length){if(HierarchicalChartsUtils.shouldIgnoreEmptyBinsForColorDimension(chartDef)){barWidth=nbMaxColumns?groupWidth/nbMaxColumns:0}else{barWidth=groupWidth/groupsData[0].columns.length}}let wrapper=g.selectAll("g.group-wrapper");if(wrapper.empty()){g.append("g").attr("class","group-wrapper");wrapper=g.selectAll("g.group-wrapper")}const groups=wrapper.selectAll("g.group-bars").data(groupsData);groups.enter().append("g").attr("class","group-bars");groups.exit().remove();groups.attr("transform",BarChartUtils.translate("x",xAxis,xLabels,groupWidth));const positionBarWrappers=function(barWrappers){return barWrappers.attr("transform",function(d,i){if(chartDef.variant===CHART_VARIANTS.waterfall){return undefined}let xTranslate=barWidth*i;if(HierarchicalChartsUtils.shouldIgnoreEmptyBinsForColorDimension(chartDef)){xTranslate=_.isNil(d.nonEmptyIdx)||_.isNil(d.nbNonEmptyBins)?0:barWidth*d.nonEmptyIdx+groupWidth/2-barWidth*d.nbNonEmptyBins/2}return"translate("+xTranslate+")"})};const positionRects=function(rects){return rects.attr("height",function(d){const yScale=getScale(d);return Math.max(chartDef.variant===CHART_VARIANTS.waterfall?1:0,Math.abs(yScale(d.base)-yScale(d.top)))}).attr("y",function(d){const yScale=getScale(d);return yScale(Math.max(d.base,d.top))})};const hasColorDim=ChartColorUtils.getColorDimensionOrMeasure(chartDef)!==undefined;const labelCollisionDetectionHandlersByColorScaleIndex={};const barWrappers=groups.selectAll(".bar-wrapper").data(Fn.prop("columns"));barWrappers.enter().append("g").attr("class","bar-wrapper").call(positionBarWrappers);barWrappers.exit().remove();const rects=barWrappers.selectAll("rect").data(Fn.prop("data"));rects.enter().append("rect").attr("fill",function(d){return chartBase.colorScale(ChartColorUtils.getColorIndex(d,hasColorDim))}).attr("opacity",function(d){return d.transparent?0:chartDef.colorOptions.transparency}).each(function(d){chartBase.tooltips.registerEl(this,angular.extend({},d,{facet:f}),"fill",undefined,undefined,hasColorDim);chartBase.contextualMenu.addContextualMenuHandler(this,angular.extend({},d,{facet:f}))});rects.exit().remove();rects.attr("width",barWidth).attr("stroke-width",function(d){return d.isUnaggregated?.5:0}).attr("stroke",function(d){return chartHandler.legendsWrapper.getLegend(0).items[ChartColorUtils.getColorIndex(d,hasColorDim)].desaturatedColor}).attr("x",0).interrupt("updateColumns").transition("updateColumns").ease("easeOutQuad").call(positionRects);if(chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayValues){const getLabelYPosition=d=>{if(!d.textsElements.length){return getScale(d)(0)}const rectValue=getRectValue(d);const defaultSpacing=chartDef.type===CHART_TYPES.MULTI_COLUMNS_LINES?5:2;const spacing=d.valuesInChartDisplayOptions.spacing??defaultSpacing;const yScale=getScale(d);const scaleValue=yScale(rectValue);if(chartDef.variant===CHART_VARIANTS.waterfall){const placementMode=d.valuesInChartDisplayOptions.placementMode;const data=d.data[0];switch(placementMode){case ValuesInChartPlacementMode.BELOW:return rectValue<0?yScale(data.top)+spacing:yScale(data.base)+spacing;case ValuesInChartPlacementMode.ABOVE:return rectValue<0?yScale(data.base)-spacing-d.height:yScale(data.top)-spacing-d.height;default:return rectValue<0?yScale(data.top)+spacing:yScale(data.top)-spacing-d.height}}const endBarY=isNaN(scaleValue)?0:scaleValue-(rectValue>=0?spacing:-spacing);if(rectValue<0){return endBarY}return endBarY-d.height};const getLabelXPosition=(d,i)=>{if(chartDef.variant===CHART_VARIANTS.waterfall){return barWidth*.5}if(HierarchicalChartsUtils.shouldIgnoreEmptyBinsForColorDimension(chartDef)){const xPos=_.isNil(d.nonEmptyIdx)||_.isNil(d.nbNonEmptyBins)?0:barWidth*(d.nonEmptyIdx+.5)+groupWidth/2-barWidth*d.nbNonEmptyBins/2;return xPos}return barWidth*(i+.5)};const getBackgroundXPosition=(d,i)=>{if(chartDef.variant===CHART_VARIANTS.waterfall){return barWidth*.5-d.width/2-backgroundXMargin}if(HierarchicalChartsUtils.shouldIgnoreEmptyBinsForColorDimension(chartDef)){const xPos=_.isNil(d.nonEmptyIdx)||_.isNil(d.nbNonEmptyBins)?0:barWidth*(d.nonEmptyIdx+.5)+groupWidth/2-barWidth*d.nbNonEmptyBins/2-d.width/2-backgroundXMargin;return xPos}return barWidth*(i+.5)-d.width/2-backgroundXMargin};const getBackgroundYPosition=d=>{const y=getLabelYPosition(d);return SVGUtils.getSubTextYPosition(d,y)};const getLabelText=d=>{const finalCoords=chartData.getFinalCoords(d);const value=chartData.aggr(finalCoords.aggregationIndex).get(finalCoords);return BarChartUtils.shouldDisplayBarLabel(chartData.getCount(finalCoords),getRectValue(finalCoords))?chartBase.measureFormatters[finalCoords.aggregationIndex](value):""};const labelsDrawContext={node:wrapper,data:groupsData.map(d=>d.columns),axisName:"x",axis:xAxis,labels:xLabels,thickness:groupWidth,opacity:chartDef.colorOptions.transparency,overlappingStrategy:chartDef.valuesInChartDisplayOptions.overlappingStrategy,colorScale:chartBase.colorScale,getExtraData:function(d,i,n,onHoverMode){const extraData=BarChartUtils.getExtraData(d,i,this,chartBase,labelCollisionDetectionHandler,labelCollisionDetectionHandlersByColorScaleIndex,ChartColorUtils.getColorIndex(d,hasColorDim),getLabelXPosition,getLabelYPosition,chartDef.valuesInChartDisplayOptions.overlappingStrategy,chartDef.valuesInChartDisplayOptions.textFormatting.fontSize,onHoverMode);return{labelPosition:extraData.labelPosition}},getLabelXPosition:d=>{return d.labelPosition.x},getLabelYPosition:d=>{return d.labelPosition.y},getLabelText:getLabelText,getBackgroundXPosition:getBackgroundXPosition,getBackgroundYPosition:getBackgroundYPosition,backgroundXMargin:backgroundXMargin,theme:chartHandler.getChartTheme()};BarChartUtils.drawLabels(labelsDrawContext)}SVGUtils.clipPaths(chartBase,g,wrapper);if(drawReferenceLines){const isPercentScaleOnLeftYAxis=chartDef.genericMeasures.some(measure=>measure.displayAxis==="axis1"&&ChartDimension.isPercentScale([measure]));const isPercentScaleOnRightYAxis=chartDef.genericMeasures.some(measure=>measure.displayAxis!=="axis1"&&ChartDimension.isPercentScale([measure]));const d3RightYAxis=ChartAxesUtils.getRightYAxis(chartBase.yAxes);const d3LeftYAxis=ChartAxesUtils.getLeftYAxis(chartBase.yAxes);const leftYFormattingOptions=d3LeftYAxis&&ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,d3LeftYAxis.id);const rightYFormattingOptions=d3RightYAxis&&ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,d3RightYAxis.id);const refLinesXAxis={...chartBase.xAxis,isPercentScale:false,formattingOptions:chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting};const refLinesYAxes=[];if(d3LeftYAxis){refLinesYAxes.push({...d3LeftYAxis,isPercentScale:isPercentScaleOnLeftYAxis,formattingOptions:leftYFormattingOptions})}if(d3RightYAxis){refLinesYAxes.push({...d3RightYAxis,isPercentScale:isPercentScaleOnRightYAxis,formattingOptions:rightYFormattingOptions})}const dataSpec=chartHandler.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,chartDef.$axisSpecs&&chartDef.$axisSpecs.x,undefined),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,chartDef.genericMeasures,customMeasures,chartDef.variant!=="waterfall");ReferenceLines.drawReferenceLines(wrapper,chartBase.vizWidth,chartBase.vizHeight,refLinesXAxis,refLinesYAxes,displayedReferenceLines,referenceLinesValues)}if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}const colorFocusHandler=ColorFocusHandler.create(chartDef,chartHandler,wrapper,d3,g);ColorFocusHandler.appendFocusUnfocusMecanismToLegend(chartHandler.legendsWrapper.getLegend(0),colorFocusHandler)}}})();(function(){"use strict";angular.module("dataiku.charts").factory("GroupedColumnsUtils",GroupedColumnsUtils);function GroupedColumnsUtils(SVGUtils,ChartMeasure,ChartAxesUtils,ChartsStaticData,CHART_VARIANTS,UnaggregatedMeasureComputeModes,CHART_LABELS){const computeUAValueData=function(genericData,chartData,measure,measureIndex,hasLogScale){const getBarBase=total=>{if(total===0&&hasLogScale){return 1}return total};const result={...genericData,isUnaggregated:true,uaComputeMode:measure.uaComputeMode};const uaValues=chartData.aggr(measureIndex).get();if(measure.uaComputeMode===UnaggregatedMeasureComputeModes.STACK){let positiveTotal=0;let negativeTotal=0;result.data=uaValues.map(function(uaValue,idx){let base=uaValue>=0?positiveTotal:negativeTotal;let top=base+uaValue;if(uaValue>=0){base=getBarBase(base);top=getBarBase(top);positiveTotal=top}else{negativeTotal=top}return{isUnaggregated:true,isStacked:true,...genericData,base:base,top:top,uaValueIdx:idx}})}else{const positiveData=[];const negativeData=[];uaValues.forEach(function(uaValue,idx){const commonData={isUnaggregated:true,base:hasLogScale?1:0,top:uaValue,...genericData,uaValueIdx:idx};if(uaValue>=0){positiveData.push(commonData)}else{negativeData.push(commonData)}});result.data=[...positiveData.map(function(data,idx){return{...data,transparent:idx>0}}),...negativeData.reverse().map(function(data,idx){return{...data,transparent:idx>0}})]}return result};const computeWaterfallTotals=function(chartData,animationLabels,facetLabels){animationLabels.forEach(function(_,a){chartData.fixAxis("animation",a);facetLabels.forEach(function(_,f){chartData.fixAxis("facet",f);const isLastIteration=a===animationLabels.length-1&&f===facetLabels.length-1;chartData.computeTotals(a,f,isLastIteration)})})};return{prepareData:function(chartDef,chartData,measureFilter,ignoreLabels=new Set){const xLabels=chartData.getAxisLabels("x");const colorLabels=chartData.getAxisLabels("color")||[null];const facetLabels=chartData.getAxisLabels("facet")||[null];const animationLabels=chartData.getAxisLabels("animation")||[null];const hasLogScale=chartDef.xAxisFormatting.isLogScale||ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,ChartsStaticData.LEFT_AXIS_ID);const getBarBase=total=>{if(total===0&&hasLogScale){return 1}return total};if(chartDef.variant===CHART_VARIANTS.waterfall){computeWaterfallTotals(chartData,animationLabels,facetLabels)}const animationData={frames:[],maxTotal:0,minTotal:0};animationLabels.forEach(function(animationLabel,a){chartData.fixAxis("animation",a);const frameData={facets:[],maxTotal:0,minTotal:0};facetLabels.forEach(function(facetLabel,f){chartData.fixAxis("facet",f);const facetData={groups:[],maxTotal:0,minTotal:0};let runningTotal=0;xLabels.forEach(function(xLabel,x){chartData.fixAxis("x",x);const columns=[];if(xLabel&&ignoreLabels.has(xLabel.label)){return}let cIndex=0;let nonEmptyIdx=0;colorLabels.forEach(function(colorLabel,c){chartData.fixAxis("color",c);if(colorLabel&&ignoreLabels.has(colorLabel.label)){return}const isTotalBar=!!chartData.isTotalBar?.(c,x);if(isTotalBar){runningTotal=0}chartDef.genericMeasures.forEach(function(measure,measureIndex){if(measureFilter&&!measureFilter(measure)){return}const measureData={color:chartData.getColorOfValue(c,x),measure:measureIndex,x:x,tooltipOverrides:chartData.getTooltipOverrides(cIndex,x),colorScaleIndex:chartData.getColorOfValue(cIndex,x)};let subTextElementsData=[];if(chartData.isBinMeaningful(measure.function,null,measureIndex)){if(ChartMeasure.isRealUnaggregatedMeasure(measure)){Object.assign(measureData,computeUAValueData(measureData,chartData,measure,measureIndex,hasLogScale))}else{subTextElementsData=SVGUtils.getLabelSubTexts(chartDef,measureIndex,measure.valuesInChartDisplayOptions,false).map(function(subTextElementData){return{...subTextElementData,...measureData}});const value=chartData.aggr(measureIndex).get({x:x,c:c});const newRunningTotal=runningTotal+value;measureData.data=[{...measureData,base:getBarBase(runningTotal),top:getBarBase(newRunningTotal)}];facetData.maxTotal=Math.max(facetData.maxTotal,newRunningTotal);facetData.minTotal=Math.min(facetData.minTotal,newRunningTotal);runningTotal=chartData.shouldRestartFrom0(c,x)?0:newRunningTotal}measureData.nonEmptyIdx=nonEmptyIdx;nonEmptyIdx+=1}else{measureData.data=[{...measureData,base:getBarBase(runningTotal),top:getBarBase(runningTotal)}]}columns.push({...measureData,textsElements:subTextElementsData,valuesInChartDisplayOptions:measure.valuesInChartDisplayOptions})});cIndex++});const nbNonEmptyBins=nonEmptyIdx;columns.forEach(col=>{col.nbNonEmptyBins=nbNonEmptyBins});facetData.groups.push({x:x,columns:columns,nbNonEmptyBins:nbNonEmptyBins})});frameData.facets.push(facetData);frameData.maxTotal=Math.max(frameData.maxTotal,facetData.maxTotal);frameData.minTotal=Math.min(frameData.minTotal,facetData.minTotal)});animationData.frames.push(frameData);animationData.maxTotal=Math.max(animationData.maxTotal,frameData.maxTotal);animationData.minTotal=Math.min(animationData.minTotal,frameData.minTotal)});if(chartDef.variant===CHART_VARIANTS.waterfall){const customXLabels=chartData.getCustomAxisLabels("x");if(customXLabels){for(let index=0;index<animationData.frames.length;index++){const frameData=animationData.frames[index];const frameFacets=frameData.facets;frameFacets.forEach(facetData=>{const facetGroups=facetData.groups;const finalGroupColumns=new Array(customXLabels.length).fill(null);facetGroups.forEach(groupData=>{groupData.columns.forEach(col=>{const position=customXLabels.findIndex(lbl=>lbl?.coordinates?.x===col.x&&lbl?.coordinates?.color===col.tooltipOverrides.color);if(position>=0){finalGroupColumns[position]={x:col.x,columns:[col],nbNonEmptyBins:col.nbNonEmptyBins}}})});facetData.groups=finalGroupColumns})}}}return animationData}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("StackedBarsChart",StackedBarsChart);function StackedBarsChart(ChartManager,ChartDimension,ChartDataWrapperFactory,Fn,StackedChartUtils,BarChartUtils,SVGUtils,ChartAxesUtils,ReferenceLines,ColumnAvailability,ChartYAxisPosition,ChartCustomMeasures,ChartUsableColumns,ColorFocusHandler,ChartDataUtils,ChartDrilldown,ChartHierarchyDimension){return function($container,chartDef,chartHandler,axesDef,data){const backgroundXMargin=4;const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef);const dataSpec=chartHandler.getDataSpec();const isPercentScale=ChartDimension.isPercentScale(chartDef.genericMeasures)||chartDef.variant=="stacked_100";const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);const yDimension=ChartDimension.getGenericDimension(chartDef);const ySpec={id:yAxisID,type:"DIMENSION",mode:"COLUMNS",dimension:yDimension,minRangeBand:18,ascendingDown:true,customExtent:ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID),position:ChartYAxisPosition.LEFT,name:"y"};const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,undefined,{[yAxisID]:ySpec}),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,chartDef.genericMeasures,customMeasures),referenceLinesExtents=ReferenceLines.getReferenceLinesExtents(displayedReferenceLines,referenceLinesValues,{x:{isPercentScale:isPercentScale},[yAxisID]:{isPercentScale:false}});ReferenceLines.mutateDimensionSpecForReferenceLine(ChartDataUtils.getAxisExtent(chartData,"y",ySpec.dimension),referenceLinesExtents[yAxisID],ySpec);const animationData=StackedChartUtils.prepareData(chartDef,chartData,"y"),yLabels=chartData.getAxisLabels("y"),xExtent=ReferenceLines.getExtentWithReferenceLines([animationData.minTotal,animationData.maxTotal],referenceLinesExtents.x);const drawFrame=function(frameIdx,chartBase){ReferenceLines.removeReferenceLines($container[0]);animationData.frames[frameIdx].facets.forEach(function(facetData,f){const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));StackedBarsChartDrawer(g,facetData,chartBase,f)})};if(chartDef.xAxisFormatting.isLogScale){xExtent[0]=1}const xSpec={type:"MEASURE",extent:xExtent,isPercentScale:isPercentScale,measure:chartDef.genericMeasures,customExtent:chartDef.xAxisFormatting.customExtent};const axisSpecs={x:xSpec,[yAxisID]:ySpec};ChartAxesUtils.setNumberOfBinsToDimensions(chartData,chartDef,axisSpecs);ReferenceLines.updateAvailableAxisOptions([{axis:"X_AXIS",isDisplayed:["X_AXIS"],isNumerical:true,isPercentScale:isPercentScale},{axis:"LEFT_Y_AXIS",isDisplayed:["LEFT_Y_AXIS"],isNumerical:ChartAxesUtils.isNumerical(ySpec)&&!ChartDimension.hasOneTickPerBin(ySpec.dimension),isPercentScale:false,isContinuousDate:ChartAxesUtils.isContinuousDate(ySpec)}]);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,axisSpecs,{type:"DIMENSION",name:"color",dimension:chartDef.genericDimension1[0]});function StackedBarsChartDrawer(g,stacksData,chartBase,f){const percentFormatter=d3.format(".0%");let barHeight=ChartDimension.isUngroupedNumerical(yDimension)?10:Math.max(1,chartBase.yAxes[0].ordinalScale.rangeBand());const yAxisCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,chartBase.yAxes[0].id);barHeight=Math.max(barHeight*ChartAxesUtils.getCustomExtentRatio(yAxisCustomExtent),1);const stacks=g.selectAll(".stack-bars").data(stacksData.stacks);stacks.enter().append("g").attr("class","stack-bars");stacks.exit().remove();stacks.attr("transform",BarChartUtils.translate("y",chartBase.yAxes[0],yLabels,barHeight));const rects=stacks.selectAll("rect").data(Fn.prop("data"));const getFinalColorScaleIndex=d=>d.color+d.measure;rects.enter().append("rect").attr("height",barHeight).attr("y",0).attr("fill",function(d){return chartBase.colorScale(getFinalColorScaleIndex(d))}).attr("opacity",chartDef.colorOptions.transparency).each(function(d){chartBase.tooltips.registerEl(this,{measure:d.measure,y:d.y,color:d.color,facet:f},"fill");chartBase.contextualMenu.addContextualMenuHandler(this,{y:d.y,color:d.color,facet:f})});if(chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayValues){const xScale=chartBase.xAxis.scale();const getLabelYPosition=d=>{return barHeight/2-d.height/2};const getLabelXPosition=(d,i)=>{return xScale((d.top+d.base)/2)};const globalLabelCollisionDetectionHandler=SVGUtils.initLabelCollisionDetection(chartBase);const labelCollisionDetectionHandlersByColorScaleIndex={};const labelsDrawContext={node:g,data:stacksData.stacks.map(stack=>stack.data),axisName:"y",axis:chartBase.yAxes[0],labels:yLabels,thickness:barHeight,opacity:chartDef.colorOptions.transparency,overlappingStrategy:chartDef.valuesInChartDisplayOptions.overlappingStrategy,colorScale:chartBase.colorScale,getLabelXPosition:getLabelXPosition,getLabelYPosition:getLabelYPosition,getLabelText:d=>{if(BarChartUtils.shouldDisplayBarLabel(d.count,d.value)){if(chartDef.variant==="stacked_100"){return percentFormatter(d.value)}else{return chartBase.measureFormatters[d.aggregationIndex](chartData.aggr(d.aggregationIndex).get(d))}}else{return""}},getExtraData:function(d,i,n,onHoverMode){const extraData=BarChartUtils.getExtraData(d,i,this,chartBase,globalLabelCollisionDetectionHandler,labelCollisionDetectionHandlersByColorScaleIndex,getFinalColorScaleIndex,getLabelXPosition,getLabelYPosition,chartDef.valuesInChartDisplayOptions.overlappingStrategy,chartDef.valuesInChartDisplayOptions.textFormatting.fontSize,onHoverMode);return{labelPosition:extraData.labelPosition}},getBackgroundXPosition:d=>{return getLabelXPosition(d)-d.width/2-backgroundXMargin},getBackgroundYPosition:d=>{const y=getLabelYPosition(d);return SVGUtils.getSubTextYPosition(d,y)},backgroundXMargin:backgroundXMargin,hasBackground:true,theme:chartHandler.getChartTheme()};BarChartUtils.drawLabels(labelsDrawContext)}rects.interrupt("updateBars").transition("updateBars").attr("width",function(d){return Math.abs(chartBase.xAxis.scale()(d.top)-chartBase.xAxis.scale()(d.base))}).attr("x",function(d){return chartBase.xAxis.scale()(Math.min(d.base,d.top))});ChartAxesUtils.isCroppedChart(chartDef)&&SVGUtils.clipPaths(chartBase,g,stacks);const xAxis=chartBase.xAxis?{...chartBase.xAxis,isPercentScale:isPercentScale,formattingOptions:chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting}:null;const yAxis=chartBase.yAxes[0]?{...chartBase.yAxes[0],formattingOptions:chartDef.yAxesFormatting[0]&&chartDef.yAxesFormatting[0].axisValuesFormatting.numberFormatting}:null;ReferenceLines.drawReferenceLines(g,chartBase.vizWidth,chartBase.vizHeight,xAxis,[yAxis],displayedReferenceLines,referenceLinesValues);if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}const colorFocusHandler=ColorFocusHandler.create(chartDef,chartHandler,stacks,d3,g);ColorFocusHandler.appendFocusUnfocusMecanismToLegend(chartHandler.legendsWrapper.getLegend(0),colorFocusHandler)}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("StackedChartUtils",StackedChartUtils);function StackedChartUtils(ChartAxesUtils,ChartsStaticData,SVGUtils,ChartMeasure,UnaggregatedMeasureComputeModes,CHART_VARIANTS){const computeBaseAndTop=(value,positiveTotal,negativeTotal)=>{const base=value>=0?positiveTotal:negativeTotal;const top=base+value;return{base:base,top:top}};const computeUAValueData=function(genericData,chartData,measure,measureIndex,positiveTotal,negativeTotal){const result={...genericData,isUnaggregated:true,uaComputeMode:measure.uaComputeMode};let newPositiveTotal=positiveTotal;let newNegativeTotal=negativeTotal;const uaValues=chartData.aggr(measureIndex).get();if(measure.uaComputeMode===UnaggregatedMeasureComputeModes.STACK){result.data=uaValues.map(function(uaValue,idx){const{base,top}=computeBaseAndTop(uaValue,newPositiveTotal,newNegativeTotal);if(uaValue>=0){newPositiveTotal=top}else{newNegativeTotal=top}return{isUnaggregated:true,isStacked:true,...genericData,base:base,top:top,uaValueIdx:idx}})}else{const positiveData=[];const negativeData=[];uaValues.forEach(function(uaValue,idx){const{base,top}=computeBaseAndTop(uaValue,positiveTotal,negativeTotal);const commonData={isUnaggregated:true,base:base,top:top,...genericData,uaValueIdx:idx};if(uaValue>=0){positiveData.push(commonData);newPositiveTotal=Math.max(newPositiveTotal,commonData.top)}else{negativeData.push(commonData);newNegativeTotal=Math.min(newNegativeTotal,commonData.top)}});result.data=[...positiveData.map(function(data,idx){return{...data,transparent:idx>0}}),...negativeData.reverse().map(function(data,idx){return{...data,transparent:idx>0}})]}return{...result,positiveTotal:newPositiveTotal,negativeTotal:newNegativeTotal}};return{prepareData:function(chartDef,chartData,axis="x"){const colorLabels=chartData.getAxisLabels("color")||[null],facetLabels=chartData.getAxisLabels("facet")||[null],animationLabels=chartData.getAxisLabels("animation")||[null],mainAxisLabels=chartData.getAxisLabels(axis),hasLogScale=chartDef.xAxisFormatting.isLogScale||ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,ChartsStaticData.LEFT_AXIS_ID);const getBarExtremity=total=>{if(total===0&&hasLogScale){return 1}return total};const animationData={frames:[],maxTotal:0,minTotal:0};animationLabels.forEach(function(animationLabel,a){chartData.fixAxis("animation",a);const frameData={facets:[],maxTotal:0,minTotal:0};facetLabels.forEach(function(facetLabel,f){chartData.fixAxis("facet",f);const facetData={stacks:[],maxTotal:0,minTotal:0};mainAxisLabels.forEach(function(_,val){chartData.fixAxis(axis,val);let positiveTotal=0;let negativeTotal=0;let count=0;const stackData=[];const totalSubTextElementsData=SVGUtils.getLabelSubTexts(chartDef,undefined,chartDef.stackedColumnsOptions?chartDef.stackedColumnsOptions.totalsInChartDisplayOptions:chartDef.valuesInChartDisplayOptions,true).map(function(subTextElementData){const res={...subTextElementData,aggregationTotal:positiveTotal+negativeTotal};res[axis]=val;return res});colorLabels.forEach(function(colorLabel,c){chartData.fixAxis("color",c);totalSubTextElementsData.forEach(function(subTextElementData){if(subTextElementData.aggregationIndex!==undefined){const d=chartData.aggr(subTextElementData.aggregationIndex).get();subTextElementData.aggregationTotal+=d}});chartDef.genericMeasures.forEach(function(measure,m){const d=chartData.aggr(m).get();if(chartDef.variant==CHART_VARIANTS.stacked100&&d<0){throw new ChartIAE("Cannot represent negative values on a 100% Stacked chart. Please use another chart.")}let subTextElementsData=[];let data=[];const commonData={color:c,measure:m,facet:f,animation:a,count:chartData.getNonNullCount({},m),value:d,[axis]:val};if(ChartMeasure.isRealUnaggregatedMeasure(measure)){if(chartDef.variant==CHART_VARIANTS.stacked100){throw new ChartIAE("Cannot represent unaggregated values on a 100% Stacked chart. Please use another chart.")}const{data:uaData,positiveTotal:newPositiveTotal,negativeTotal:newNegativeTotal}=computeUAValueData(commonData,chartData,measure,m,positiveTotal,negativeTotal);data=uaData;positiveTotal=newPositiveTotal;negativeTotal=newNegativeTotal}else{commonData.base=d>=0?positiveTotal:negativeTotal;commonData.top=commonData.base+d;if(d>=0){commonData.base=getBarExtremity(commonData.base);commonData.top=getBarExtremity(commonData.top);positiveTotal=commonData.top}else{negativeTotal=commonData.top}subTextElementsData=SVGUtils.getLabelSubTexts(chartDef,m,measure.valuesInChartDisplayOptions,false).map(function(subTextElementData){return{...subTextElementData,...commonData}});data=[commonData]}const point={...commonData,data:data,textsElements:subTextElementsData,valuesInChartDisplayOptions:measure.valuesInChartDisplayOptions};stackData.push(point);count+=chartData.getNonNullCount({},m)})});if(chartDef.variant==CHART_VARIANTS.stacked100&&positiveTotal>0){let totalPercent=0;stackData.forEach(function(point,p){const update={value:point.value/positiveTotal,base:totalPercent,top:point.value/positiveTotal+totalPercent};Object.assign(point,update);point.textsElements.forEach(function(subTextElementData){Object.assign(subTextElementData,update)});point.data.forEach(function(dataElement){Object.assign(dataElement,update)});totalPercent+=point.value});positiveTotal=1}const totalData={data:stackData,total:positiveTotal+negativeTotal,positiveTotal:positiveTotal,negativeTotal:negativeTotal,count:count,spacing:chartDef.stackedColumnsOptions?.totalsInChartDisplayOptions?.spacing};facetData.stacks.push({...totalData,textsElements:totalSubTextElementsData.map(function(subTextElementData){return{...subTextElementData,...totalData}})});facetData.maxTotal=Math.max(facetData.maxTotal,positiveTotal);facetData.minTotal=Math.min(facetData.minTotal,negativeTotal)});frameData.maxTotal=Math.max(frameData.maxTotal,facetData.maxTotal);frameData.minTotal=Math.min(frameData.minTotal,facetData.minTotal);frameData.facets.push(facetData)});animationData.maxTotal=Math.max(animationData.maxTotal,frameData.maxTotal);animationData.minTotal=Math.min(animationData.minTotal,frameData.minTotal);animationData.frames.push(frameData)});return animationData}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("StackedColumnsChart",StackedColumnsChart);function StackedColumnsChart(ChartManager,ChartDimension,ChartFeatures,ChartDataWrapperFactory,Fn,StackedChartUtils,BarChartUtils,SVGUtils,ChartAxesUtils,ReferenceLines,ColumnAvailability,ChartYAxisPosition,ChartCustomMeasures,ChartUsableColumns,ColorFocusHandler,ValuesInChartOverlappingStrategy,ChartDataUtils,ChartHierarchyDimension,ChartDrilldown,ChartColorUtils,ChartMeasure,CHART_VARIANTS){return function($container,chartDef,chartHandler,axesDef,data){const backgroundXMargin=4;const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef);const dataSpec=chartHandler.getDataSpec();const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);const isPercentScale=ChartDimension.isPercentScale(chartDef.genericMeasures)||chartDef.variant=="stacked_100";const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));const xDimension=ChartDimension.getGenericDimension(chartDef);const xSpec={type:"DIMENSION",mode:"COLUMNS",dimension:xDimension,name:"x",customExtent:chartDef.xAxisFormatting.customExtent};ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,xSpec,undefined),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,chartDef.genericMeasures,customMeasures),referenceLinesExtents=ReferenceLines.getReferenceLinesExtents(displayedReferenceLines,referenceLinesValues,{[yAxisID]:{isPercentScale:isPercentScale}});ReferenceLines.mutateDimensionSpecForReferenceLine(ChartDataUtils.getAxisExtent(chartData,"x",xSpec.dimension),referenceLinesExtents.x,xSpec);const xLabels=chartData.getAxisLabels("x"),animationData=StackedChartUtils.prepareData(chartDef,chartData),yExtent=ReferenceLines.getExtentWithReferenceLines([animationData.minTotal,animationData.maxTotal],referenceLinesExtents[yAxisID]);const drawFrame=function(frameIdx,chartBase){ReferenceLines.removeReferenceLines($container[0]);animationData.frames[frameIdx].facets.forEach(function(facetData,f){const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));StackedColumnChartDrawer(g,facetData,chartBase)})};if(ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting)){yExtent[0]=1}const ySpecs={[yAxisID]:{id:yAxisID,type:"MEASURE",extent:yExtent,isPercentScale:isPercentScale,customExtent:ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID),position:ChartYAxisPosition.LEFT}};const axisSpecs={x:xSpec,...ySpecs};ChartAxesUtils.setNumberOfBinsToDimensions(chartData,chartDef,axisSpecs);ReferenceLines.updateAvailableAxisOptions([{axis:"LEFT_Y_AXIS",isDisplayed:true,isNumerical:true,isPercentScale:isPercentScale},{axis:"X_AXIS",isDisplayed:true,isNumerical:ChartAxesUtils.isNumerical(xSpec)&&!ChartDimension.hasOneTickPerBin(xSpec.dimension),isContinuousDate:ChartAxesUtils.isContinuousDate(xSpec)}]);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,axisSpecs,{type:"DIMENSION",name:"color",dimension:chartDef.genericDimension1[0]});function StackedColumnChartDrawer(g,stacksData,chartBase){const xAxis=chartBase.xAxis,yAxis=chartBase.yAxes[0],yScale=yAxis.scale(),percentFormatter=d3.format(".0%");let barWidth=ChartDimension.isUngroupedNumerical(xDimension)?10:Math.max(1,xAxis.ordinalScale.rangeBand());barWidth=Math.max(barWidth*ChartAxesUtils.getCustomExtentRatio(chartDef.xAxisFormatting.customExtent),1);let wrapper=g.selectAll("g.stack-wrapper");if(wrapper.empty()){g.append("g").attr("class","stack-wrapper");wrapper=g.selectAll("g.stack-wrapper")}const stacks=wrapper.selectAll(".stack-bars").data(stacksData.stacks);stacks.enter().append("g").attr("class","stack-bars");stacks.exit().remove();stacks.attr("transform",BarChartUtils.translate("x",xAxis,xLabels,barWidth));const rects=stacks.selectAll("rect").data(d=>_.flatten(d.data.map(e=>e.data)));const hasColorDim=ChartColorUtils.getColorDimensionOrMeasure(chartDef)!==undefined;const getFinalColorScaleIndex=d=>ChartColorUtils.getColorIndex(d,hasColorDim);rects.enter().append("rect").attr("width",barWidth).attr("x",0).attr("fill",function(d,i){return chartBase.colorScale(getFinalColorScaleIndex(d,i))}).attr("opacity",function(d){return d.transparent?0:chartDef.colorOptions.transparency}).each(function(d){chartBase.tooltips.registerEl(this,_.pick(d,["measure","x","color","facet","isUnaggregated","uaValueIdx"]),"fill");chartBase.contextualMenu.addContextualMenuHandler(this,_.pick(d,["x","color","facet","isUnaggregated","uaValueIdx"]),"fill")});rects.exit().remove();if(chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayValues){const labelCollisionDetectionHandler=SVGUtils.initLabelCollisionDetection(chartBase);const getLabelXPosition=()=>{return barWidth/2};const commonDrawContext={node:wrapper,axisName:"x",axis:xAxis,labels:xLabels,thickness:barWidth,opacity:chartDef.colorOptions.transparency,colorScale:chartBase.colorScale,getLabelXPosition:getLabelXPosition,getBackgroundXPosition:(d,i)=>{return getLabelXPosition(d,i)-d.width/2-backgroundXMargin},backgroundXMargin:backgroundXMargin};const drawValuesLabels=()=>{const getLabelYPosition=function(d){return yScale((d.top+d.base)/2)-d.height/2};const getLabelText=d=>{if(BarChartUtils.shouldDisplayBarLabel(d.count,d.value)){if(chartDef.variant===CHART_VARIANTS.stacked100){return percentFormatter(d.value)}else{return chartBase.measureFormatters[d.aggregationIndex](chartData.aggr(d.aggregationIndex).get(d))}}else{return""}};const overlappingStrategyForValues=[ValuesInChartOverlappingStrategy.AUTO_WITH_VALUES,ValuesInChartOverlappingStrategy.AUTO].includes(chartDef.valuesInChartDisplayOptions.overlappingStrategy)?ValuesInChartOverlappingStrategy.AUTO:ValuesInChartOverlappingStrategy.ALL;const labelCollisionDetectionHandlersByColorScaleIndex={};const labelsDrawContext={...commonDrawContext,data:stacksData.stacks.map(stack=>stack.data),getLabelYPosition:getLabelYPosition,getExtraData:function(d,i,n,onHoverMode){const extraData=BarChartUtils.getExtraData(d,i,this,chartBase,labelCollisionDetectionHandler,labelCollisionDetectionHandlersByColorScaleIndex,getFinalColorScaleIndex,getLabelXPosition,getLabelYPosition,overlappingStrategyForValues,chartDef.valuesInChartDisplayOptions.textFormatting.fontSize,onHoverMode);return{labelPosition:extraData.labelPosition}},getLabelText:getLabelText,getBackgroundYPosition:d=>{const y=getLabelYPosition(d);return SVGUtils.getSubTextYPosition(d,y)},hasBackground:true,overlappingStrategy:overlappingStrategyForValues,theme:chartHandler.getChartTheme()};BarChartUtils.drawLabels(labelsDrawContext)};const drawTotalsLabels=()=>{if(ChartFeatures.shouldDisplayTotalValues(chartDef)&&!chartDef.genericMeasures.some(m=>ChartMeasure.isRealUnaggregatedMeasure(m))){const getLabelText=d=>{const text=d.aggregationIndex===undefined?chartBase.measureFormatters[0](d.total):chartBase.measureFormatters[d.aggregationIndex](d.aggregationTotal);return BarChartUtils.shouldDisplayBarLabel(d.count,d.total)?text:""};const getLabelYPosition=d=>{const spacing=d.spacing||5;if(d.total<0){return yScale(d.negativeTotal)+spacing}else{return yScale(d.positiveTotal)-spacing-d.height}};const overlappingStrategyForTotals=[ValuesInChartOverlappingStrategy.AUTO_WITH_TOTALS,ValuesInChartOverlappingStrategy.AUTO].includes(chartDef.valuesInChartDisplayOptions.overlappingStrategy)?ValuesInChartOverlappingStrategy.AUTO:ValuesInChartOverlappingStrategy.ALL;const labelCollisionDetectionHandlersByColorScaleIndex={};const totalLabelsDrawContext={...commonDrawContext,data:stacksData.stacks,getLabelYPosition:getLabelYPosition,getExtraData:function(d,i,n,onHoverMode){const extraData=BarChartUtils.getExtraData(d,i,this,chartBase,labelCollisionDetectionHandler,labelCollisionDetectionHandlersByColorScaleIndex,getFinalColorScaleIndex,getLabelXPosition,getLabelYPosition,overlappingStrategyForTotals,chartDef.valuesInChartDisplayOptions.textFormatting.fontSize,onHoverMode);return{labelPosition:extraData.labelPosition}},getBackgroundYPosition:d=>{const y=getLabelYPosition(d);return SVGUtils.getSubTextYPosition(d,y)},getLabelText:getLabelText,hasBackground:false,isTotals:true,overlappingStrategy:overlappingStrategyForTotals,theme:chartHandler.getChartTheme()};BarChartUtils.drawLabels(totalLabelsDrawContext)}};if(chartDef.valuesInChartDisplayOptions.overlappingStrategy===ValuesInChartOverlappingStrategy.AUTO_WITH_VALUES){drawTotalsLabels();drawValuesLabels()}else{drawValuesLabels();drawTotalsLabels()}}rects.attr("stroke-width",function(d){return d.isUnaggregated?.5:0}).attr("stroke",function(d){return chartHandler.legendsWrapper.getLegend(0).items[getFinalColorScaleIndex(d)].desaturatedColor}).interrupt("updateColumns").transition("updateColumns").attr("height",function(d){return Math.max(0,Math.abs(yScale(d.base)-yScale(d.top)))}).attr("y",function(d){return yScale(Math.max(d.base,d.top))});ChartAxesUtils.isCroppedChart(chartDef)&&SVGUtils.clipPaths(chartBase,g,wrapper);ReferenceLines.drawReferenceLines(wrapper,chartBase.vizWidth,chartBase.vizHeight,xAxis,yAxis?[{...yAxis,isPercentScale:isPercentScale,formattingOptions:ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,yAxis.id)}]:[],displayedReferenceLines,referenceLinesValues);if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}const colorFocusHandler=ColorFocusHandler.create(chartDef,chartHandler,wrapper,d3,g);ColorFocusHandler.appendFocusUnfocusMecanismToLegend(chartHandler.legendsWrapper.getLegend(0),colorFocusHandler)}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("LinesBrushDrawer",LinesBrushDrawer);function LinesBrushDrawer(LinesUtils,ChartAxesUtils,ChartYAxisPosition,ChartDimension,ReferenceLines){return function(g,chartDef,chartData,chartBase,linesData,facetIndex,brushAxes,referenceLinesValues=undefined){const xDimension=ChartDimension.getGenericDimension(chartDef);const emptyBinsMode=xDimension.numParams.emptyBinsMode;const xLabels=chartData.getAxisLabels("x");const leftYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);const rightYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT);const xAxis=brushAxes.x;const leftYAxis=brushAxes[leftYAxisID];const rightYAxis=brushAxes[rightYAxisID];const wrappers=LinesUtils.drawWrappers(chartDef,chartBase,linesData,g,false,false,"brush-wrapper");LinesUtils.drawPoints(chartDef,chartBase,chartData,facetIndex,wrappers,xAxis,xLabels,leftYAxis,rightYAxis,xDimension,emptyBinsMode,1);const[,lineGs,lineDashGs]=LinesUtils.configureLines(chartDef,chartData,facetIndex,wrappers,undefined,xAxis,leftYAxis,rightYAxis,xDimension,xLabels,emptyBinsMode);LinesUtils.drawPaths(chartDef,chartBase,chartData,facetIndex,lineGs,xDimension,xLabels,xAxis,leftYAxis,rightYAxis,emptyBinsMode,false,false,1,lineDashGs);if(referenceLinesValues){const yAxes=[];if(leftYAxis){const isPercentScaleOnYAxis=chartDef.genericMeasures.some(measure=>measure.displayAxis==="axis1"&&ChartDimension.isPercentScale([measure]));const leftYFormattingOptions=ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,leftYAxis.id);yAxes.push({...leftYAxis,isPercentScale:isPercentScaleOnYAxis,formattingOptions:leftYFormattingOptions})}if(rightYAxis){const isPercentScaleOnY2Axis=chartDef.genericMeasures.some(measure=>measure.displayAxis!=="axis1"&&ChartDimension.isPercentScale([measure]));const rightYFormattingOptions=ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,rightYAxis.id);yAxes.push({...rightYAxis,isPercentScale:isPercentScaleOnY2Axis,formattingOptions:rightYFormattingOptions})}const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,chartDef.$axisSpecs&&chartDef.$axisSpecs.x,chartDef.$axisSpecs&&chartDef.$axisSpecs.y);ReferenceLines.drawReferenceLines(d3.select(wrappers[0][wrappers[0].length-1]),chartBase.vizWidth,chartBase.vizHeight,xAxis,yAxes,displayedReferenceLines,referenceLinesValues,null,true)}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("LinesChart",LinesChart);function LinesChart(ChartManager,ChartDataWrapperFactory,LinesDrawer,LinesUtils,ChartDataUtils,MonoFuture,ChartDimension,ReferenceLines,ColumnAvailability,ChartYAxisPosition,ChartAxesUtils,ChartCustomMeasures,ChartUsableColumns,ChartZoomControlAdapter,CHART_ZOOM_CONTROL_TYPES,LinesBrushDrawer,ChartStoreFactory){return function($container,chartDef,chartHandler,axesDef,data,pivotRequest,uiDisplayState,chartActivityIndicator){recomputeAndRedraw($container,chartDef,chartHandler,axesDef,data,pivotRequest,null,uiDisplayState,chartActivityIndicator)};function recomputeAndRedraw($container,chartDef,chartHandler,axesDef,data,pivotRequest,displayInterval,uiDisplayState,chartActivityIndicator){const initialChartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef);const pivotRequestCallback=MonoFuture().wrap(pivotRequest);const dataSpec=chartHandler.getDataSpec();const xDimension=ChartDimension.getGenericDimension(chartDef);const includeEmptyBins=LinesUtils.hasEmptyBinsToIncludeAsZero(xDimension,initialChartData);const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);const xSpec={type:"DIMENSION",mode:"POINTS",dimension:xDimension,name:"x",customExtent:chartDef.xAxisFormatting.customExtent};const facetLabels=initialChartData.getAxisLabels("facet")||[null],yExtents=ChartDataUtils.getMeasureExtents(chartDef,initialChartData,"x",undefined,includeEmptyBins),leftYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT),rightYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT),isLeftYPercentScale=yExtents[leftYAxisID].onlyPercent,isRightYPercentScale=yExtents[rightYAxisID].onlyPercent;const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,xSpec,undefined),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,initialChartData,allMeasures,chartDef.genericMeasures,customMeasures),referenceLinesExtents=ReferenceLines.getReferenceLinesExtents(displayedReferenceLines,referenceLinesValues,{[leftYAxisID]:{isPercentScale:isLeftYPercentScale},[rightYAxisID]:{isPercentScale:isRightYPercentScale}});const leftYExtent=ReferenceLines.getExtentWithReferenceLines(yExtents[leftYAxisID].extent,referenceLinesExtents[leftYAxisID]),rightYExtent=ReferenceLines.getExtentWithReferenceLines(yExtents[rightYAxisID].extent,referenceLinesExtents[rightYAxisID]);ReferenceLines.mutateDimensionSpecForReferenceLine(ChartDataUtils.getAxisExtent(initialChartData,"x",xSpec.dimension),referenceLinesExtents.x,xSpec);const linesData=LinesUtils.prepareData(chartDef,initialChartData);const isInteractive=ChartDimension.isInteractiveChart(chartDef);let zoomContext,initLinesZoom;const drawFrame=function(frameIdx,chartBase,redraw,chartData=initialChartData){ReferenceLines.removeReferenceLines($container[0]);chartData.fixAxis("animation",frameIdx);if(isInteractive&&!_.isNil(chartDef.$zoomControlInstanceId)){const zoomControlInstance=ChartZoomControlAdapter.get(chartDef.$zoomControlInstanceId);zoomControlInstance.setZoomUtils({...zoomControlInstance.getZoomUtils(),frameIndex:frameIdx})}facetLabels.forEach(function(facetLabel,facetIndex){const g=d3.select(chartBase.$svgs.eq(facetIndex).find("g.chart").get(0));LinesDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",facetIndex),chartBase,linesData,facetIndex,redraw,isInteractive)})};const cleanFrame=function(chartBase){facetLabels.forEach(function(facetLabel,facetIndex){const g=d3.select(chartBase.$svgs.eq(facetIndex).find("g.chart").get(0));LinesUtils.cleanChart(g,chartBase)})};const drawBrush=function(chartBase,g,brushAxes){const isAnimated=chartBase.chartData.axesDef.animation!==undefined;const hasSubcharts=facetLabels&&facetLabels.length>1;if(isAnimated||hasSubcharts){return}LinesBrushDrawer(g,chartDef,initialChartData,chartBase,linesData,0,brushAxes,referenceLinesValues)};if(isInteractive){zoomContext={d3:d3,chartContainer:$container,chartDef:chartDef,chartHandler:chartHandler,drawFrame:drawFrame,drawBrush:drawBrush,axesDef:axesDef,chartActivityIndicator:chartActivityIndicator,cleanFrame:cleanFrame,pivotRequestCallback:pivotRequestCallback,linesChartCallback:recomputeAndRedraw,uiDisplayState:uiDisplayState};initLinesZoom=zoomContext=>{let previousZoomUtils={};if(!_.isNil(chartDef.$zoomControlInstanceId)){const zoomControlInstance=ChartZoomControlAdapter.get(chartDef.$zoomControlInstanceId);previousZoomUtils=zoomControlInstance.getZoomUtils()}zoomContext={...zoomContext,zoomUtils:previousZoomUtils};const id=ChartZoomControlAdapter.create(CHART_ZOOM_CONTROL_TYPES.LINES,zoomContext);ChartZoomControlAdapter.init(CHART_ZOOM_CONTROL_TYPES.LINES,id);return id};chartHandler.forceRotation=.5}else{chartHandler.forceRotation=undefined}const leftYCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,leftYAxisID);const rightYCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,rightYAxisID);const ySpecs={[leftYAxisID]:{id:leftYAxisID,type:"MEASURE",extent:leftYExtent,isPercentScale:isLeftYPercentScale,customExtent:leftYCustomExtent,position:ChartYAxisPosition.LEFT},[rightYAxisID]:{id:rightYAxisID,type:"MEASURE",extent:rightYExtent,isPercentScale:isRightYPercentScale,customExtent:rightYCustomExtent,position:ChartYAxisPosition.RIGHT}};if(displayInterval&&_.isFinite(displayInterval[0])&&_.isFinite(displayInterval[1])){xSpec.initialInterval={min:displayInterval[0],max:displayInterval[1]}}if(!isInteractive){xSpec.customExtent=chartDef.xAxisFormatting.customExtent}const availableAxes=ReferenceLines.getAvailableAxesForReferenceLines(chartDef);const axisSpecs={x:xSpec,...ySpecs};ChartAxesUtils.setNumberOfBinsToDimensions(initialChartData,chartDef,axisSpecs);ReferenceLines.updateAvailableAxisOptions([{axis:"LEFT_Y_AXIS",isDisplayed:availableAxes["LEFT_Y_AXIS"],isNumerical:true,isPercentScale:ySpecs[leftYAxisID].isPercentScale},{axis:"RIGHT_Y_AXIS",isDisplayed:availableAxes["RIGHT_Y_AXIS"],isNumerical:true,isPercentScale:ySpecs[rightYAxisID].isPercentScale},{axis:"X_AXIS",isDisplayed:true,isNumerical:ChartAxesUtils.isNumerical(xSpec)&&!ChartDimension.hasOneTickPerBin(xSpec.dimension),isContinuousDate:ChartAxesUtils.isContinuousDate(xSpec)}]);ChartManager.initChart(chartDef,chartHandler,initialChartData,$container,drawFrame,axisSpecs,{type:"DIMENSION",name:"color",dimension:chartDef.genericDimension1[0]},zoomContext,initLinesZoom)}}})();(function(){"use strict";angular.module("dataiku.charts").factory("LinesDrawer",LinesDrawer);function LinesDrawer(Fn,LinesUtils,ChartDimension,ChartAxesUtils,ReferenceLines,ColumnAvailability,ChartCustomMeasures,ChartUsableColumns){return function(g,chartDef,chartHandler,chartData,chartBase,linesData,facetIndex,redraw,isInteractive,iLabelsBoundingBoxes,getRefLineValuesOverride,refLinesContainer){const xDimension=ChartDimension.getGenericDimension(chartDef);const emptyBinsMode=xDimension.numParams.emptyBinsMode;const xLabels=chartData.getAxisLabels("x");const rightYAxis=ChartAxesUtils.getRightYAxis(chartBase.yAxes);const leftYAxis=ChartAxesUtils.getLeftYAxis(chartBase.yAxes);let xAxis=chartBase.xAxis;chartBase.DOMUtils=chartBase.DOMUtils||{};chartBase.DOMUtils[facetIndex]=chartBase.DOMUtils[facetIndex]||{};const wrappers=LinesUtils.drawWrappers(chartDef,chartBase,linesData,g,isInteractive,redraw,"wrapper");if(!redraw){chartBase.DOMUtils[facetIndex].points=LinesUtils.drawPoints(chartDef,chartBase,chartData,facetIndex,wrappers,xAxis,xLabels,leftYAxis,rightYAxis,xDimension,emptyBinsMode);LinesUtils.addTooltipAndHighlightAndContextualMenuHandlers(chartDef,chartHandler,chartBase,facetIndex,g,wrappers);chartBase.DOMUtils[facetIndex].labels=LinesUtils.drawLabels(chartDef,chartBase,chartData,chartHandler.getChartTheme(),facetIndex,wrappers,xAxis,xLabels,leftYAxis,rightYAxis,xDimension,emptyBinsMode,iLabelsBoundingBoxes)}else if(isInteractive&&!chartBase.DOMUtils[facetIndex].pointsHaveBeenRemoved){if(chartBase.DOMUtils[facetIndex].points){chartBase.DOMUtils[facetIndex].points.remove()}if(chartBase.DOMUtils[facetIndex].labels){chartBase.DOMUtils[facetIndex].labels.remove()}chartBase.DOMUtils[facetIndex].pointsHaveBeenRemoved=true}const[lineGenerator,lineGs,lineDashGs]=LinesUtils.configureLines(chartDef,chartData,facetIndex,wrappers,chartBase.DOMUtils[facetIndex].lineGenerator,xAxis,leftYAxis,rightYAxis,xDimension,xLabels,emptyBinsMode);chartBase.DOMUtils[facetIndex].lineGenerator=lineGenerator;[lineGs,lineDashGs].forEach(lineGs=>{let hiddenLines=lineGs.selectAll("path.masked");if(!redraw){hiddenLines=hiddenLines.data(function(d){return[d]});hiddenLines.enter().insert("path").attr("class","line masked").attr("fill","none").attr("stroke-width","10").attr("stroke","transparent");hiddenLines.exit().remove()}hiddenLines.attr("d",Fn.SELF)});LinesUtils.drawPaths(chartDef,chartBase,chartData,facetIndex,lineGs,xDimension,xLabels,xAxis,leftYAxis,rightYAxis,emptyBinsMode,redraw,!isInteractive,chartDef.strokeWidth,lineDashGs);const isPercentScaleOnYAxis=chartDef.genericMeasures.some(measure=>measure.displayAxis==="axis1"&&ChartDimension.isPercentScale([measure]));const isPercentScaleOnY2Axis=chartDef.genericMeasures.some(measure=>measure.displayAxis!=="axis1"&&ChartDimension.isPercentScale([measure]));const leftYFormattingOptions=leftYAxis&&ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,leftYAxis.id);const rightYFormattingOptions=rightYAxis&&ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,rightYAxis.id);const dataSpec=chartHandler.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,xAxis,undefined),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,chartDef.genericMeasures,customMeasures,true,getRefLineValuesOverride);const yAxes=[];if(leftYAxis){yAxes.push({...leftYAxis,isPercentScale:isPercentScaleOnYAxis,formattingOptions:leftYFormattingOptions})}if(rightYAxis){yAxes.push({...rightYAxis,isPercentScale:isPercentScaleOnY2Axis,formattingOptions:rightYFormattingOptions})}xAxis={...xAxis,formattingOptions:xAxis&&chartDef.xAxisFormatting};ReferenceLines.drawReferenceLines(wrappers[0].length?d3.select(wrappers[0][wrappers[0].length-1]):refLinesContainer,chartBase.vizWidth,chartBase.vizHeight,xAxis,yAxes,displayedReferenceLines,referenceLinesValues);if(!redraw){const isInteractive=ChartDimension.isInteractiveChart(chartDef);const isCroppedChart=ChartAxesUtils.isCroppedChart(chartDef);(isInteractive||isCroppedChart)&&LinesUtils.clipPaths(chartBase,chartDef,g,wrappers)}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("LinesUtils",LinesUtils);const CLIP_PATH_ID="lines-chart-clip-path";function LinesUtils(ChartDimension,Fn,ChartAxesUtils,CHART_TYPES,ColorFocusHandler,SVGUtils,ValuesInChartOverlappingStrategy,ValuesInChartPlacementMode,ChartDrilldown,ChartHierarchyDimension,ChartColorUtils){const svc={drawPaths:function(chartDef,chartBase,chartData,facetIndex,lineGs,xDimension,xLabels,xAxis,leftYAxis,rightYAxis,emptyBinsMode,redraw,transition,strokeWidth,lineDashGs){const paths=lineGs.selectAll("path.visible").data(function(d){return[d]});paths.enter().insert("path").attr("class","line visible").attr("fill","none").attr("stroke-width",strokeWidth).attr("opacity",chartDef.colorOptions.transparency);paths.exit().remove();const dashPaths=lineDashGs.selectAll("path.visible").data(function(d){return[d]});dashPaths.enter().insert("path").attr("class","line visible").attr("fill","none").attr("stroke-dasharray",12).attr("stroke-width",strokeWidth);dashPaths.exit().remove();dashPaths.attr("d",Fn.SELF);if(!transition){paths.attr("d",Fn.SELF).each(function(){const path=d3.select(this);const wrapper=d3.select(this.parentNode.parentNode);svc.drawPath(path,wrapper,emptyBinsMode,redraw,chartBase,svc.xCoord,svc.yCoord,chartData,chartDef,xDimension,xLabels,xAxis,leftYAxis,rightYAxis)})}else{paths.interrupt("updateLines").transition("updateLines").attr("d",Fn.SELF).each("end",function(){const path=d3.select(this);const wrapper=d3.select(this.parentNode.parentNode);svc.drawPath(path,wrapper,emptyBinsMode,redraw,chartBase,svc.xCoord,svc.yCoord,chartData,chartDef,xDimension,xLabels,xAxis,leftYAxis,rightYAxis)})}},configureLines:function(chartDef,chartData,facetIndex,wrappers,lineGenerator,xAxis,leftYAxis,rightYAxis,xDimension,xLabels,emptyBinsMode){if(!lineGenerator){lineGenerator=d3.svg.line().x(d=>svc.xCoord(xDimension,xLabels,xAxis)(d)).y(d=>svc.yCoord(d,chartDef,chartData,leftYAxis,rightYAxis)).defined(x=>emptyBinsMode==="ZEROS"||svc.nonZeroCountFilter(x,facetIndex,chartData));if(chartDef.smoothing){lineGenerator.interpolate("monotone")}}const lineGs=wrappers.selectAll("g.line").data(function(d){d.filteredPointsData=d.pointsData.filter(d=>svc.nonZeroCountFilter(d,facetIndex,chartData));const data=emptyBinsMode==="ZEROS"||emptyBinsMode=="DASHED"?d.pointsData:d.filteredPointsData;return[lineGenerator(data)]});const lineDashGs=wrappers.selectAll("g.dashedline").data(function(d){if(emptyBinsMode==="DASHED"){const data=svc.getEmptySegments(d.pointsData).flatMap(s=>[s[0],s[1],null]);const segmentGenerator=d3.svg.line().x(d=>svc.xCoord(xDimension,xLabels,xAxis)(d)).y(d=>svc.yCoord(d,chartDef,chartData,leftYAxis,rightYAxis)).defined(d=>d!=null);return[segmentGenerator(data)]}return[]});lineGs.enter().insert("g",":first-child").attr("class","line");lineGs.exit().remove();lineDashGs.enter().insert("g",":first-child").attr("class","dashedline");lineDashGs.exit().remove();return[lineGenerator,lineGs,lineDashGs]},drawPoints:function(chartDef,chartBase,chartData,facetIndex,wrappers,xAxis,xLabels,leftYAxis,rightYAxis,xDimension,emptyBinsMode,pointsRadius){let points=wrappers.selectAll("circle.point");points=points.data(function(d){return emptyBinsMode==="ZEROS"?d.pointsData:d.filteredPointsData=d.pointsData.filter(d=>svc.nonZeroCountFilter(d,facetIndex,chartData))},Fn.prop("x"));points.enter().append("circle").attr("class","point point--masked").attr("r",function(d){return pointsRadius||(chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayValues&&d.valuesInChartDisplayOptions.displayValues?Math.round(chartDef.strokeWidth/2)+1:5)}).attr("fill",function(d){return chartBase.colorScale(d.colorScaleIndex)}).attr("opacity",function(d){return chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayValues&&d.valuesInChartDisplayOptions.displayValues?chartDef.colorOptions.transparency:0});points.exit().remove();points.interrupt("movePoints").transition("movePoints").duration(200).ease("easeOutQuad").attr("cx",d=>svc.xCoord(xDimension,xLabels,xAxis)(d)).attr("cy",d=>svc.yCoord(d,chartDef,chartData,leftYAxis,rightYAxis));wrappers.selectAll("circle.lonely").remove();return points},drawLabels:function(chartDef,chartBase,chartData,theme,facetIndex,wrappers,xAxis,xLabels,leftYAxis,rightYAxis,xDimension,emptyBinsMode,labelCollisionDetectionHandler){const selectionNodes=[];if(chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayValues){const backgroundXMargin=3;const mainLabelCollisionDetectionHandler=labelCollisionDetectionHandler||SVGUtils.initLabelCollisionDetection(chartBase);const labelCollisionDetectionHandlersByColorScaleIndex={};const getCurrentColorLabelCollisionDetectionHandler=d=>{const colorScaleIndex=d.colorScaleIndex;if(!labelCollisionDetectionHandlersByColorScaleIndex[colorScaleIndex]){labelCollisionDetectionHandlersByColorScaleIndex[colorScaleIndex]=SVGUtils.initLabelCollisionDetection(chartBase)}return labelCollisionDetectionHandlersByColorScaleIndex[colorScaleIndex]};const getPointPosition=d=>({x:d?svc.xCoord(xDimension,xLabels,xAxis)(d):null,y:d?svc.yCoord(d,chartDef,chartData,leftYAxis,rightYAxis):null});const isEqualPosition=(point1,point2)=>{return point1.x===point2.x&&point1.y===point2.y};const checkBoundaries=(position,textElement)=>{const textElementWidth=textElement.width;const rectangleHeight=textElement.height;const newPosition={x:position.x,y:position.y};const minVizX=0;const maxVizX=chartBase.vizWidth;const minVizY=-chartBase.margins.top;const maxVizY=chartBase.vizHeight;let isOutside=false;if(position.x-textElementWidth/2<minVizX){newPosition.x+=minVizX-(position.x-textElementWidth/2);isOutside=true}else if(position.x+textElementWidth/2>maxVizX){newPosition.x-=position.x+textElementWidth/2-maxVizX;isOutside=true}if(position.y<minVizY){newPosition.y+=minVizY-position.y;isOutside=true}else if(position.y+rectangleHeight>maxVizY){newPosition.y-=position.y+rectangleHeight-maxVizY;isOutside=true}return{newPosition:newPosition,isOutside:isOutside}};const findFinalPosition=(possiblePositions,textElement,onHoverMode,adjustForBoundaries)=>{let finalPosition;let finalRectangles;let isOverlap=false;let isOverlapAlt=false;const fittedPositions=[];const labelDetectionHandler=onHoverMode?getCurrentColorLabelCollisionDetectionHandler(textElement):mainLabelCollisionDetectionHandler;for(let idx=0;idx<possiblePositions.length;idx+=1){const position=possiblePositions[idx];if(adjustForBoundaries){const boundariesCheck=checkBoundaries(position,textElement);if(boundariesCheck.isOutside){fittedPositions.push(boundariesCheck.newPosition);continue}}const rectangles=SVGUtils.getRectanglesFromPosition(position,textElement,chartDef.valuesInChartDisplayOptions.textFormatting.fontSize);if(!labelDetectionHandler.checkOverlaps(rectangles)){finalPosition=position;finalRectangles=rectangles;break}}if(!finalPosition){for(let idx=0;idx<fittedPositions.length;idx+=1){const position=fittedPositions[idx];const rectangles=SVGUtils.getRectanglesFromPosition(position,textElement,chartDef.valuesInChartDisplayOptions.textFormatting.fontSize);if(!labelDetectionHandler.checkOverlaps(rectangles)){finalPosition=position;finalRectangles=rectangles;break}}if(!finalPosition){finalPosition=fittedPositions[0]||possiblePositions[0];finalRectangles=SVGUtils.getRectanglesFromPosition(finalPosition,textElement,chartDef.valuesInChartDisplayOptions.textFormatting.fontSize);if(onHoverMode){isOverlapAlt=true}else{isOverlap=true}}}return{labelPosition:finalPosition,labelRectangles:finalRectangles,isOverlap:isOverlap,isOverlapAlt:isOverlapAlt}};const getLabelCoordinates=(previousPoint,currentPoint,nextPoint,currentElement,onHoverMode)=>{if(!currentPoint){return null}const defaultSpacing=chartDef.type===CHART_TYPES.MULTI_COLUMNS_LINES?5:12;const distanceFromDataPoint=currentElement.valuesInChartDisplayOptions.spacing??defaultSpacing;const placementMode=currentElement.valuesInChartDisplayOptions.placementMode;const adjustBoundaries=!placementMode||placementMode===ValuesInChartPlacementMode.AUTO;const overlappingKey=onHoverMode?"isOverlapAlt":"isOverlap";const labelDetectionHandler=onHoverMode?getCurrentColorLabelCollisionDetectionHandler(currentElement):mainLabelCollisionDetectionHandler;const computeCoordinatesFromAngle=(angle,unitVector)=>{const tmpRotatedVector={x:unitVector.x*Math.cos(angle)+unitVector.y*Math.sin(angle),y:-unitVector.x*Math.sin(angle)+unitVector.y*Math.cos(angle)};const angleFromXAxis=Math.atan2(tmpRotatedVector.y,tmpRotatedVector.x);const counterclockwiseAngle=Math.PI-angleFromXAxis;const boundaryDistance=Math.min(currentElement.width/2/Math.abs(Math.cos(counterclockwiseAngle)),currentElement.height/2/Math.abs(Math.sin(counterclockwiseAngle)));const distanceToBboxCenter=distanceFromDataPoint+boundaryDistance;const labelCoordinates={x:currentPoint.x+distanceToBboxCenter*tmpRotatedVector.x,y:currentPoint.y+distanceToBboxCenter*tmpRotatedVector.y-currentElement.height/2};return labelCoordinates};let belowLinePosition={x:currentPoint.x,y:currentPoint.y+distanceFromDataPoint};let aboveLinePosition={x:currentPoint.x,y:currentPoint.y-(distanceFromDataPoint+currentElement.height)};let possiblePositions=[belowLinePosition,aboveLinePosition];if(previousPoint&&nextPoint){const dotProduct=(previousPoint.x-currentPoint.x)*(nextPoint.x-currentPoint.x)+(previousPoint.y-currentPoint.y)*(nextPoint.y-currentPoint.y);const magnitude1=Math.sqrt(Math.pow(previousPoint.x-currentPoint.x,2)+Math.pow(previousPoint.y-currentPoint.y,2));const magnitude2=Math.sqrt(Math.pow(nextPoint.x-currentPoint.x,2)+Math.pow(nextPoint.y-currentPoint.y,2));const angleCosinus=dotProduct/(magnitude1*magnitude2);const curveAngle=Math.acos(Math.max(-1,Math.min(1,angleCosinus)));const crossProduct=(previousPoint.x-currentPoint.x)*(nextPoint.y-currentPoint.y)-(previousPoint.y-currentPoint.y)*(nextPoint.x-currentPoint.x);const unitVector={x:(previousPoint.x-currentPoint.x)/magnitude1,y:(previousPoint.y-currentPoint.y)/magnitude1};const rotationAngle=(2*Math.PI-curveAngle)/2*(crossProduct>0?1:-1);const alternativeAngle1=curveAngle/2*(crossProduct>0?-1:1);const alternativeAngle2=(rotationAngle+alternativeAngle1)/2;const alternativeAngle3=alternativeAngle2+Math.PI;const preferredPosition=computeCoordinatesFromAngle(rotationAngle,unitVector);const alternativePosition1=computeCoordinatesFromAngle(alternativeAngle1,unitVector);const alternativePosition2=computeCoordinatesFromAngle(alternativeAngle2,unitVector);const alternativePosition3=computeCoordinatesFromAngle(alternativeAngle3,unitVector);possiblePositions=[preferredPosition,alternativePosition1,alternativePosition2,alternativePosition3];aboveLinePosition=crossProduct<=0?preferredPosition:alternativePosition1;belowLinePosition=crossProduct<=0?alternativePosition1:preferredPosition}else if(nextPoint||previousPoint){let unitVector;if(nextPoint){const magnitude=Math.sqrt(Math.pow(nextPoint.x-currentPoint.x,2)+Math.pow(nextPoint.y-currentPoint.y,2));unitVector={x:(currentPoint.x-nextPoint.x)/magnitude,y:(currentPoint.y-nextPoint.y)/magnitude}}else{const magnitude=Math.sqrt(Math.pow(currentPoint.x-previousPoint.x,2)+Math.pow(currentPoint.y-previousPoint.y,2));unitVector={x:(previousPoint.x-currentPoint.x)/magnitude,y:(previousPoint.y-currentPoint.y)/magnitude}}const rotationAngle=Math.PI/2;const alternativeAngle1=-(Math.PI/2);const alternativeAngle2=(rotationAngle+alternativeAngle1)/2;const alternativeAngle3=alternativeAngle2+Math.PI;belowLinePosition=computeCoordinatesFromAngle(rotationAngle,unitVector);aboveLinePosition=computeCoordinatesFromAngle(alternativeAngle1,unitVector);const alternativePosition2=computeCoordinatesFromAngle(alternativeAngle2,unitVector);const alternativePosition3=computeCoordinatesFromAngle(alternativeAngle3,unitVector);possiblePositions=[belowLinePosition,aboveLinePosition,alternativePosition2,alternativePosition3]}if(aboveLinePosition&&placementMode===ValuesInChartPlacementMode.ABOVE){possiblePositions=[aboveLinePosition]}else if(belowLinePosition&&placementMode===ValuesInChartPlacementMode.BELOW){possiblePositions=[belowLinePosition]}const result=findFinalPosition(possiblePositions,currentElement,onHoverMode,adjustBoundaries);const hideOverlaps=chartDef.valuesInChartDisplayOptions.overlappingStrategy===ValuesInChartOverlappingStrategy.AUTO;const isDisplayed=!!currentElement.valuesInChartDisplayOptions?.displayValues;if((!hideOverlaps||!result[overlappingKey])&&isDisplayed&&result.labelRectangles){labelDetectionHandler.addBoundingBoxesToQuadTree(result.labelRectangles)}return result};wrappers.each(function(){const wrapper=d3.select(this);const datum=wrapper.datum();const data=emptyBinsMode==="ZEROS"?datum.pointsData:datum.filteredPointsData=datum.pointsData.filter(d=>svc.nonZeroCountFilter(d,facetIndex,chartData));const finalData=data.filter(d=>d.valuesInChartDisplayOptions&&d.valuesInChartDisplayOptions.displayValues&&d.valuesInChartDisplayOptions.textFormatting);const getExtraData=(d,idx,onHoverMode)=>{const currentPosition=getPointPosition(d);const minVizX=0;const maxVizX=chartBase.vizWidth;const minVizY=-chartBase.margins.top;const maxVizY=chartBase.vizHeight;if(currentPosition.x<minVizX||currentPosition.x>maxVizX||currentPosition.y<minVizY||currentPosition.y>maxVizY){return{isInvalid:true}}let previousPosition=null;let nextPosition=null;let prevIndex=idx-1;while(prevIndex>=0&&!previousPosition){const position=getPointPosition(finalData[prevIndex]);if(!isEqualPosition(position,currentPosition)){previousPosition=position}prevIndex-=1}let nextIndex=idx+1;while(nextIndex<finalData.length&&!nextPosition){const position=getPointPosition(finalData[nextIndex]);if(!isEqualPosition(position,currentPosition)){nextPosition=position}nextIndex+=1}return getLabelCoordinates(previousPosition,currentPosition,nextPosition,d,onHoverMode)};const labelsDrawContext={node:wrapper,data:finalData,opacity:chartDef.colorOptions.transparency,textFormatting:chartDef.valuesInChartDisplayOptions.textFormatting,overlappingStrategy:chartDef.valuesInChartDisplayOptions.overlappingStrategy,colorScale:chartBase.colorScale,getExtraData:(d,_,idx,onHoverMode)=>{return getExtraData(d,idx,onHoverMode)},getLabelXPosition:d=>{return d.isInvalid?0:d.labelPosition.x},getLabelYPosition:d=>{return d.isInvalid?0:d.labelPosition.y},getLabelText:d=>{return chartBase.measureFormatters[d.aggregationIndex](chartData.aggr(d.aggregationIndex).get(d))},getBackgroundXPosition:d=>{if(d.isInvalid){return 0}const{x}=d.labelPosition;return x-d.width/2-backgroundXMargin},getBackgroundYPosition:d=>{if(d.isInvalid){return 0}const{y}=d.labelPosition;return SVGUtils.getSubTextYPosition(d,y)},backgroundXMargin:backgroundXMargin,theme:theme};const hasColorDim=ChartColorUtils.getColorDimensionOrMeasure(chartDef)!==undefined;const labelsSelection=SVGUtils.drawLabels(labelsDrawContext,"lines",hasColorDim);selectionNodes.push(...labelsSelection?.[0]??[])})}return d3.selectAll(selectionNodes)},drawWrappers:function(chartDef,chartBase,linesData,g,isInteractive,redraw,className){let wrappers=g.selectAll("g."+className);if(!redraw){wrappers=wrappers.data(linesData,d=>d.id);wrappers.enter().append("g").attr("class",className).attr("stroke",function(d){return chartBase.colorScale(d.colorScaleIndex)});wrappers.exit().remove()}return wrappers},computeTooltipCoords:(datum,facetIndex)=>({measure:datum.measure,x:datum.xCoord,color:datum.color,facet:facetIndex,colorScaleIndex:datum.colorScaleIndex}),getTooltipTargetElementProperties:(domElement,facetIndex)=>{if(domElement.classList.contains("point")){const element=d3.select(domElement);element.attr("tooltip-el",true);const datum=d3.select(domElement).datum();if(datum==null){return null}return{coords:svc.computeTooltipCoords(datum,facetIndex),measure:datum.measure!=null?datum.measure:0,showTooltip:true}}else if(domElement.classList.contains("line")){const datum=d3.select(domElement.parentNode.parentNode).datum();if(datum==null){return null}return{coords:svc.computeTooltipCoords(datum,facetIndex),measure:datum.measure!=null?datum.measure:0,showTooltip:false}}return null},computeContextualMenuCoords:(datum,facetIndex)=>({x:datum.xCoord,color:datum.color,facet:facetIndex}),getContextualMenuTargetElementProperties:(domElement,facetIndex)=>{if(domElement.classList.contains("point")){const element=d3.select(domElement);element.attr("tooltip-el",true);const datum=d3.select(domElement).datum();return{coords:svc.computeContextualMenuCoords(datum,facetIndex)}}return null},addTooltipAndHighlightAndContextualMenuHandlers:function(chartDef,chartHandler,chartBase,facetIndex,g,wrappers){const colorFocusHandler=ColorFocusHandler.create(chartDef,chartHandler,wrappers,d3,g);ColorFocusHandler.appendFocusUnfocusMecanismToLegend(chartHandler.legendsWrapper.getLegend(0),colorFocusHandler);const tooltipOptions={displayColorTooltip:chartDef.type!==CHART_TYPES.MULTI_COLUMNS_LINES};chartBase.tooltips.addChartTooltipAndHighlightHandlers(g.node(),domElement=>svc.getTooltipTargetElementProperties(domElement,facetIndex),colorFocusHandler,tooltipOptions);const getTargetElementProperties=domElement=>svc.getContextualMenuTargetElementProperties(domElement,facetIndex);let getCustomActions;if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);getCustomActions=properties=>properties?[]:ChartDrilldown.getDrillupActions(chartDef);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),getTargetElementProperties,getCustomActions)}chartBase.contextualMenu.addChartContextualMenuHandler(g.node(),getTargetElementProperties,getCustomActions)},drawPath:function(path,wrapper,emptyBinsMode,redraw,chartBase,xCoord,yCoord,chartData,chartDef,xDimension,xLabels,xAxis,leftYAxis,rightYAxis){const lineData=wrapper.data()[0];let lonelyPoints=[];if(lineData.filteredPointsData.length===1){lonelyPoints=[lineData.filteredPointsData[0]]}if(emptyBinsMode==="DASHED"&&!redraw){const emptySegments=svc.getEmptySegments(lineData.pointsData);if(lineData.filteredPointsData.length>1){emptySegments.forEach(function(seg,i){if(i===0){if(seg[0].$idx===0){lonelyPoints.push(seg[0])}}else if(i===emptySegments.length-1&&seg[1].$idx===lineData.filteredPointsData[lineData.filteredPointsData.length-1].$idx){lonelyPoints.push(seg[1])}if(emptySegments[i+1]&&emptySegments[i][1]===emptySegments[i+1][0]){lonelyPoints.push(emptySegments[i][1])}})}}const lonelyCircles=wrapper.selectAll("circle.lonely").data(lonelyPoints,Fn.prop("x"));lonelyCircles.remove();lonelyCircles.enter().append("circle").attr("opacity",chartDef.colorOptions.transparency).attr("class","lonely").attr("fill",function(d){return chartBase.colorScale(d.colorScaleIndex)}).style("pointer-events","none");if(emptyBinsMode==="DASHED"){lonelyCircles.attr("r",2.5).attr("cy",chartBase.yAxes[0].scale()(0))}else{lonelyCircles.attr("r",4).attr("opacity",chartDef.colorOptions.transparency)}lonelyCircles.exit().remove();lonelyCircles.attr("cx",d=>xCoord(xDimension,xLabels,xAxis)(d)).attr("cy",d=>yCoord(d,chartDef,chartData,leftYAxis,rightYAxis))},clipPaths:function(chartBase,chartDef,g,wrappers){const displayedValuesFontSizes=chartDef.genericMeasures.filter(m=>m.valuesInChartDisplayOptions&&m.valuesInChartDisplayOptions.textFormatting).map(m=>m.valuesInChartDisplayOptions.textFormatting.fontSize);const extraPadding=displayedValuesFontSizes.length?Math.max(...displayedValuesFontSizes)+20:10;const defs=g.append("defs");const clipPathUniqueId=CLIP_PATH_ID+generateUniqueId();defs.append("clipPath").attr("id",clipPathUniqueId).append("rect").attr("width",chartBase.vizWidth).attr("y",-extraPadding).attr("height",chartBase.vizHeight+extraPadding);wrappers.attr("clip-path","url(#"+clipPathUniqueId+")");wrappers.style("-webkit-clip-path","url(#"+clipPathUniqueId+")")},nonZeroCountFilter:function(d,facetIndex,chartData){d.$filtered=chartData.getNonNullCount({x:d.xCoord,color:d.color,facet:facetIndex},d.measure)===0;return!d.$filtered},xCoord:function(xDimension,xLabels,xAxis){return svc.getXCoord(xDimension,xAxis,xAxis.ordinalScale,xLabels)},yCoord:function(d,chartDef,chartData,leftYAxis,rightYAxis){let val=chartData.aggr(d.measure).get({x:d.xCoord,color:d.color});const displayAxis=chartDef.genericMeasures[d.measure].displayAxis==="axis1"?leftYAxis:rightYAxis;if(ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,displayAxis.id)&&val==0){val=1}return displayAxis.scale()(val)},cleanChart:function(g,chartBase){const wrappers=$("g.wrapper");const bgAnchor=g.select(".chart-contextual-menu-anchor");chartBase.tooltips.removeChartTooltipHandlers(g.node());chartBase.contextualMenu.removeChartContextualMenuHandler(g.node());!bgAnchor.empty()&&chartBase.contextualMenu.removeChartContextualMenuHandler(bgAnchor);wrappers.off()},prepareData:function(chartDef,chartData,measureFilter,ignoreLabels=new Set,useColorDimension=true){const xLabels=chartData.getAxisLabels("x");const axisColorLabels=chartData.getAxisLabels("color");const colorLabelsLength=(axisColorLabels||[null]).length;const colorLabels=useColorDimension&&axisColorLabels||[axisColorLabels&&axisColorLabels.length?chartData.getSubtotalLabelIndex("color"):0];const linesData=[];colorLabels.forEach(function(colorLabel,colorIndex){let mIndex=0;chartDef.genericMeasures.forEach(function(measure,measureIndex){if(measureFilter&&!measureFilter(measure)){return}const newColorIndex=useColorDimension?colorIndex:colorLabel;const colorScaleIndex=(useColorDimension?newColorIndex:colorLabelsLength-1)+(axisColorLabels?mIndex:measureIndex);linesData.push({id:_.uniqueId("line_"),color:newColorIndex,measure:measureIndex,colorScaleIndex:colorScaleIndex,valuesInChartDisplayOptions:measure.valuesInChartDisplayOptions,pointsData:xLabels.reduce(function(result,xLabel,xIndex){if(ignoreLabels.has(xLabel.label)){return result}const measureData={x:result.length,color:newColorIndex,colorScaleIndex:colorScaleIndex,measure:measureIndex,filtered:true,xCoord:xIndex};const subTextElementsData=SVGUtils.getLabelSubTexts(chartDef,measureIndex,measure.valuesInChartDisplayOptions,false).map(function(subTextElementData){return{...subTextElementData,...measureData}});result.push({...measureData,textsElements:subTextElementsData,valuesInChartDisplayOptions:measure.valuesInChartDisplayOptions});return result},[])});mIndex++})});return linesData},getXCoord:function(dimension,xAxis,ordinalXScale,labels){if(ChartDimension.isTimeline(dimension)){return function(d){return xAxis.scale()(labels[d.x].tsValue)}}else if(ChartDimension.isGroupedNumerical(dimension)&&!ChartDimension.hasOneTickPerBin(dimension)||ChartDimension.isUngroupedNumerical(dimension)){return function(d){return xAxis.scale()(labels[d.x].sortValue)}}else{return function(d){return ordinalXScale(d.x)+ordinalXScale.rangeBand()/2}}},getEmptySegments:function(labels){const emptySegments=[];let segment=[];let inSegment=false;let inLine=false;labels.forEach(function(label,i){label.$idx=i;if(inLine&&label.$filtered){inSegment=true}else{inLine=true;if(inSegment){segment[1]=label;emptySegments.push(segment);segment=[label]}else{segment=[label]}inSegment=false}});return emptySegments},hasEmptyBinsToIncludeAsZero:function(dimension,chartData){return dimension.numParams&&dimension.numParams.emptyBinsMode==="ZEROS"&&chartData.hasEmptyBins}};return svc}})();(function(){"use strict";angular.module("dataiku.charts").factory("LinesZoomHelper",LinesZoomHelper);const CLIP_PATH_ID="lines-chart-clip-path";function LinesZoomHelper(ChartDataUtils,D3ChartAxes,ChartAxesUtils,LinesUtils,ReferenceLines,ChartYAxisPosition,ChartUsableColumns,ChartCustomMeasures,ChartZoomLoader,ChartSetErrorInScope,Logger,ChartDimension,ChartActivityIndicator,ChartsStaticData,ChartPropertiesService){const svc={createMissingDataArea(g){const clipPathUniqueId=CLIP_PATH_ID+generateUniqueId();const area=g.append("rect").attr("opacity","0.6").attr("class","missing-data-area").attr("x","0").attr("width","0").attr("y","0").attr("height","0").attr("clip-path","url(#"+clipPathUniqueId+")").style("-webkit-clip-path","url(#"+clipPathUniqueId+")").style("pointer-events","none");return area},updateMissingDataAreas(chartBase,zoomUtils){if(zoomUtils.displayIntervalBeforeInteraction&&zoomUtils.displayIntervalBeforeInteraction!==zoomUtils.dataInterval){const dataIntervalMin=zoomUtils.dataInterval[0];const dataIntervalMax=zoomUtils.dataInterval[1];const displayIntervalBeforeInteractionMin=zoomUtils.displayIntervalBeforeInteraction[0];const displayIntervalBeforeInteractionMax=zoomUtils.displayIntervalBeforeInteraction[1];if(displayIntervalBeforeInteractionMin>dataIntervalMin){const scaledDataIntervalMin=chartBase.xAxis.scale()(dataIntervalMin);const scaledIntervalBeforeInteractionMin=chartBase.xAxis.scale()(displayIntervalBeforeInteractionMin);zoomUtils.leftMissingDataAreas.forEach(area=>{area.attr("x",scaledDataIntervalMin).attr("width",scaledIntervalBeforeInteractionMin-scaledDataIntervalMin).attr("height",chartBase.vizHeight)})}if(displayIntervalBeforeInteractionMax<dataIntervalMax){const scaledDataIntervalMax=chartBase.xAxis.scale()(dataIntervalMax);const scaledIntervalBeforeInteractionMax=chartBase.xAxis.scale()(displayIntervalBeforeInteractionMax);zoomUtils.rightMissingDataAreas.forEach(area=>{area.attr("x",scaledIntervalBeforeInteractionMax).attr("width",scaledDataIntervalMax-scaledIntervalBeforeInteractionMax).attr("height",chartBase.vizHeight)})}}},cleanMissingDataAreas(zoomUtils){zoomUtils.leftMissingDataAreas.forEach(area=>{area.attr("x","0").attr("y","0").attr("width","0").attr("height","0")});zoomUtils.rightMissingDataAreas.forEach(area=>{area.attr("x","0").attr("y","0").attr("width","0").attr("height","0")})},cleanZoomListeners(zoom){zoom&&zoom.on("zoomstart",null);zoom&&zoom.on("zoom",null);zoom&&zoom.on("zoomend",null);zoom=null},updateTicksFormat(chartDef,container,xAxis){const xExtent=D3ChartAxes.getCurrentAxisExtent(xAxis);const xMin=xExtent[0];const xMax=xExtent[1];if(!isFinite(xMin)||!isFinite(xMax)){return}const computedDateDisplayUnit=ChartDataUtils.computeDateDisplayUnit(xMin,xMax);xAxis.tickFormat(date=>{return computedDateDisplayUnit.formatDateFn(date,computedDateDisplayUnit.dateFormat)})},getYExtentsForInterval(chartBase,chartDef,chartHandler,interval){const xMin=interval[0];const xMax=interval[1];const chartData=chartBase.chartData;const results={};const includeEmptyBins=LinesUtils.hasEmptyBinsToIncludeAsZero(ChartDimension.getGenericDimension(chartDef),chartData);const yExtents=ChartDataUtils.getMeasureExtents(chartDef,chartData,"x",[xMin,xMax],includeEmptyBins);results.recordsCount=yExtents.recordsCount;results.pointsCount=yExtents.pointsCount;const leftAxis=chartBase.yAxes.filter(axis=>axis.position===ChartYAxisPosition.LEFT),rightAxis=chartBase.yAxes.filter(axis=>axis.position===ChartYAxisPosition.RIGHT),leftYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT),rightYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT);const dataSpec=chartHandler.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,dataSpec.context).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,chartBase.xAxis,undefined),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,chartDef.genericMeasures,customMeasures),referenceLinesExtents=ReferenceLines.getReferenceLinesExtents(displayedReferenceLines,referenceLinesValues,{[leftYAxisID]:{isPercentScale:yExtents[leftYAxisID].onlyPercent},[rightYAxisID]:{isPercentScale:yExtents[rightYAxisID].onlyPercent}});if(leftAxis&&leftAxis.length){results[leftYAxisID]=ReferenceLines.getExtentWithReferenceLines(yExtents[leftYAxisID].extent,referenceLinesExtents[leftYAxisID])}if(rightAxis&&rightAxis.length){results[rightYAxisID]=ReferenceLines.getExtentWithReferenceLines(yExtents[rightYAxisID].extent,referenceLinesExtents[rightYAxisID])}return results},hasValidYExtents(leftYExtent,rightYExtent){const isLeftYExtentFinite=leftYExtent&&isFinite(leftYExtent[0])&&isFinite(leftYExtent[1]);const isRightYExtentFinite=rightYExtent&&isFinite(rightYExtent[0])&&isFinite(rightYExtent[1]);const isLeftYExtentValid=!leftYExtent||isLeftYExtentFinite&&leftYExtent[0]!==leftYExtent[1];const isRightY2ExtentValid=!rightYExtent||isRightYExtentFinite&&rightYExtent[0]!==rightYExtent[1];return isLeftYExtentValid&&isRightY2ExtentValid},updateZoomUtils(zoomUtils,inspectedZoom){zoomUtils.displayInterval=inspectedZoom.displayInterval;const isDisplayIntervalValid=inspectedZoom.yExtents.pointsCount>1&&svc.hasValidYExtents(inspectedZoom.yExtents[ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT)],inspectedZoom.yExtents[ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT)])&&inspectedZoom.displayInterval[0]!==inspectedZoom.displayInterval[1];if(isDisplayIntervalValid){zoomUtils.lastValidDisplayInterval=inspectedZoom.displayInterval}zoomUtils={...zoomUtils,...inspectedZoom.yExtents};zoomUtils.disableZoomFiltering=inspectedZoom.disableZoomFiltering;zoomUtils.previousZoomEvent=d3.event;return zoomUtils},redrawChart(chartBase,chartDef,zoomUtils,containerSelection,xAxis,drawFrame,chartTileProperties){const leftYAxis=ChartAxesUtils.getLeftYAxis(chartBase.yAxes);const rightYAxis=ChartAxesUtils.getRightYAxis(chartBase.yAxes);svc.updateAxes(containerSelection,chartDef,xAxis,leftYAxis,rightYAxis,zoomUtils,chartBase.vizHeight,chartBase.vizWidth,chartTileProperties);drawFrame(zoomUtils.frameIndex,chartBase,true);svc.updateMissingDataAreas(chartBase,zoomUtils)},buildChartInteractionErrorMessage(data,status,headers){const knownError=ChartSetErrorInScope.buildValidityForKnownError(data,status,headers);if(knownError!==undefined){return knownError.message}else if(data.message){return data.message}return"An unknown error occurred while interacting with the chart."},computePivotRequest(pivotRequestCallback,linesChartCallback,chartDef,chartBase,zoomUtils,chartHandler,cleanFrame,uiDisplayState,chartActivityIndicator,request,chartContainer){pivotRequestCallback(request,false,true).success(function(data){if(data.result.pivotResponse.axisLabels[0]&&data.result.pivotResponse.axisLabels[0].length===1){Logger.info("Not enough data in the result: chart won't be refreshed.");svc.cleanOfflineFeedbacks(zoomUtils);return}const responseSequenceId=data.result.pivotResponse.sequenceId;if(responseSequenceId===zoomUtils.sequenceId){Logger.info("Sequence ids match ("+responseSequenceId+"). Deactivate offline zoom and refresh the chart.");svc.cleanAll(chartBase,cleanFrame,zoomUtils);zoomUtils.preventThumbnailUpdate=true;zoomUtils.offlineZoomDisabled=true;linesChartCallback(chartContainer,chartDef,chartHandler,zoomUtils.axesDef,data.result.pivotResponse,pivotRequestCallback,zoomUtils.displayInterval,uiDisplayState,chartActivityIndicator);uiDisplayState.chartTopRightLabel=ChartDataUtils.computeRecordsStatusLabel(data.result.pivotResponse.beforeFilterRecords,data.result.pivotResponse.afterFilterRecords,ChartDimension.getComputedMainAutomaticBinningModeLabel(data.result.pivotResponse,chartDef),chartDef.type);uiDisplayState.samplingSummaryMessage=ChartDataUtils.getSamplingSummaryMessage(data.result.pivotResponse,chartDef.type);uiDisplayState.chartRecordsFinalCountTooltip=ChartDataUtils.getRecordsFinalCountTooltip(chartDef.type,data.result.pivotResponse.afterFilterRecords,[],undefined)}else{Logger.info("Sequence ids do not match ("+responseSequenceId+", "+zoomUtils.sequenceId+"): chart won't be refreshed.")}}).error(function(data,status,headers){Logger.info("An error occurred during zoom pivot request");ChartActivityIndicator.displayBackendError(chartActivityIndicator,svc.buildChartInteractionErrorMessage(data,status,headers));uiDisplayState.chartTopRightLabel=ChartDataUtils.computeNoRecordsTopRightLabel();uiDisplayState.chartRecordsFinalCountTooltip=ChartDataUtils.getRecordsFinalCountTooltip(chartDef.type,0);uiDisplayState.samplingSummaryMessage=data.result&&ChartDataUtils.getSamplingSummaryMessage(data.result.pivotResponse,chartDef.type);svc.cleanOfflineFeedbacks(zoomUtils)})},getUpdatedYDomain(chartDef,yAxis,yExtent){if(!yExtent){return}let yMin=yExtent[0];let yMax=yExtent[1];const{customExtent,includeZero}=ChartAxesUtils.getFormattingForYAxis(chartDef.yAxesFormatting,yAxis.id);const shouldIncludeZero=customExtent.editMode===ChartsStaticData.AUTO_EXTENT_MODE&&includeZero;if(shouldIncludeZero){if(yMin>0){yMin=0}else if(yMax<0){yMax=0}}else if(customExtent.editMode===ChartsStaticData.MANUAL_EXTENT_MODE){const customAxisExtent=ChartAxesUtils.getManualExtent(customExtent);yMin=customAxisExtent[0];yMax=customAxisExtent[1]}return[yMin,yMax]},cleanAll(chartBase,cleanFrame,zoomUtils){svc.cleanOfflineFeedbacks(zoomUtils);svc.cleanZoomListeners(zoomUtils.zoom);cleanFrame(chartBase)},cleanOfflineFeedbacks(zoomUtils){ChartZoomLoader.displayLoader(false,zoomUtils.instanceId);svc.cleanMissingDataAreas(zoomUtils)},computeBrushDimensions(chartBase){return{paddingLeft:chartBase.margins.left,width:chartBase.vizWidth}},onBrushInit(chartBase,chartDef,drawBrush,zoomUtils){return function(brushContentG,brushContentHeight,brushContentWidth){const xAxisLogScale=chartBase.xSpec&&chartBase.xSpec.type=="MEASURE"&&chartDef.xAxisFormatting.isLogScale;const xAxis=D3ChartAxes.createAxis(chartBase.chartData,chartBase.xSpec,chartBase.isPercentChart,xAxisLogScale,undefined,chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting,chartDef);const yAxes=[];for(const key in chartBase.ySpecs){const yAxisLogScale=ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,key);const yAxisFormatting=ChartAxesUtils.getFormattingForYAxis(chartDef.yAxesFormatting,key);const axis=D3ChartAxes.createAxis(chartBase.chartData,chartBase.ySpecs[key],chartBase.isPercentChart,yAxisLogScale,yAxisFormatting.includeZero,yAxisFormatting.axisValuesFormatting.numberFormatting,chartDef);axis&&yAxes.push(axis)}xAxis.setScaleRange([0,brushContentWidth]);const leftAxis=ChartAxesUtils.getLeftYAxis(yAxes);const rightAxis=ChartAxesUtils.getRightYAxis(yAxes);if(leftAxis){if(chartBase.ySpecs[ChartsStaticData.LEFT_AXIS_ID].ascendingDown){leftAxis.setScaleRange([0,brushContentHeight])}else{leftAxis.setScaleRange([brushContentHeight,0])}}if(rightAxis){rightAxis.setScaleRange([brushContentHeight,0])}const brushAxes={x:xAxis,[ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT)]:leftAxis,[ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT)]:rightAxis};drawBrush(chartBase,brushContentG,brushAxes);zoomUtils.hasBrushBeenDrawn=true}},updateAxes(containerSelection,chartDef,xAxis,leftYAxis,rightYAxis,zoomUtils,vizHeight,vizWidth,chartTileProperties){svc.updateXAxis(containerSelection,chartDef,xAxis,vizHeight,[leftYAxis,rightYAxis],chartTileProperties);svc.updateYAxes(containerSelection,chartDef,leftYAxis,rightYAxis,zoomUtils,vizWidth,chartTileProperties)},updateXAxis(containerSelection,chartDef,xAxis,vizHeight,yAxes,chartTileProperties){if(!ChartPropertiesService.showXAxis(chartDef.xAxisFormatting,chartTileProperties)){return}const allNegative=!yAxes.filter(yAxis=>yAxis).some(yAxis=>{const currentYExtent=D3ChartAxes.getCurrentAxisExtent(yAxis);return currentYExtent&&currentYExtent[1]>=0});svc.updateTicksFormat(chartDef,containerSelection.node(),xAxis);const xAxisSelection=[...containerSelection.selectAll(".chart-svg .x.axis")][0];xAxisSelection.forEach(xG=>{xG=d3.select(xG);xG.call(xAxis);xG.selectAll(".tick text").attr("transform",function(){const labelAngle=.5;const translateValue="-33, 15";const rotateValue=labelAngle*-180/Math.PI;return`translate(${translateValue}), rotate(${rotateValue}, 0, 0)`});const gridlinesPosition={x1:0,x2:0,y1:0,y2:allNegative?vizHeight:-vizHeight};if(chartDef.gridlinesOptions.vertical.show){D3ChartAxes.drawGridlines(xG,"x",chartDef.gridlinesOptions.vertical.lineFormatting,gridlinesPosition,containerSelection)}})},updateYAxes(containerSelection,chartDef,leftAxis,rightAxis,zoomUtils,vizWidth,chartTileProperties){if(leftAxis){svc.updateYAxis(containerSelection,chartDef,leftAxis,zoomUtils,".y1.axis",vizWidth,chartTileProperties)}if(rightAxis){svc.updateYAxis(containerSelection,chartDef,rightAxis,zoomUtils,".y2.axis",vizWidth,chartTileProperties)}},updateYAxis(containerSelection,chartDef,yAxis,zoomUtils,selector,vizWidth,chartTileProperties){const axisFormatting=ChartAxesUtils.getFormattingForYAxis(chartDef.yAxesFormatting,yAxis);if(!axisFormatting||!ChartPropertiesService.showYAxis(axisFormatting,chartTileProperties)){return}const[yMin,yMax]=svc.getUpdatedYDomain(chartDef,yAxis,zoomUtils[yAxis.id]);yAxis.scale().domain([yMin,yMax]);[...containerSelection.selectAll(selector)[0]].forEach(yG=>{d3.select(yG).call(yAxis);if(chartDef.gridlinesOptions.horizontal.show&&D3ChartAxes.shouldDrawGridlinesForAxis(chartDef.type,yAxis,chartDef.gridlinesOptions.horizontal.displayAxis)){const gridlinesPosition={x1:0,x2:ChartAxesUtils.isRightYAxis(yAxis)?-vizWidth:vizWidth,y1:0,y2:0};D3ChartAxes.drawGridlines(d3.select(yG),"y",chartDef.gridlinesOptions.horizontal.lineFormatting,gridlinesPosition,containerSelection)}})}};return svc}})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("MultiplotChart",function(ChartManager,ChartDataWrapperFactory,GroupedColumnsDrawer,GroupedColumnsUtils,LinesDrawer,LinesUtils,ChartDataUtils,ReferenceLines,ChartUsableColumns,ChartYAxisPosition,ChartAxesUtils,CHART_LABELS,MultiplotUtils,ChartCustomMeasures,SVGUtils,ChartDimension){return function($container,chartDef,chartHandler,axesDef,data){const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef);const ignoreLabels=new Set([CHART_LABELS.SUBTOTAL_BIN_LABEL]);const genericDimension=ChartDimension.getGenericDimension(chartDef);const includeEmptyBins=LinesUtils.hasEmptyBinsToIncludeAsZero(genericDimension,chartData);const subtotals=Array.from({length:chartData.numAxes});const isDisplayedAsColumn=MultiplotUtils.isColumn;const hasSubtotals=MultiplotUtils.shouldSubtotalsBeCalculated(chartDef);let getRefLineValuesOverride;if(hasSubtotals){subtotals[chartData.axesDef.color]=chartData.subtotalCoords[chartData.axesDef.color];getRefLineValuesOverride=(measure,measureIdx)=>{const dataIndices=MultiplotUtils.isColumn(measure)?ChartDataUtils.getValuesForColumns(subtotals,chartData,ignoreLabels):ChartDataUtils.getValuesForLines(subtotals,chartData,ignoreLabels);return ChartDataUtils.retrieveAggrData(chartData,dataIndices,measureIdx)}}const leftYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);const rightYAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT);const facetLabels=chartData.getAxisLabels("facet",ignoreLabels)||[{$tensorIndex:0}];const dataSpec=chartHandler.getDataSpec();const xSpec={type:"DIMENSION",mode:"COLUMNS",dimension:genericDimension,name:"x",customExtent:chartDef.xAxisFormatting.customExtent};const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));const yExtents=hasSubtotals?ChartDataUtils.getMeasureExtentsForMixColored(chartDef,chartData,includeEmptyBins,ignoreLabels,subtotals,isDisplayedAsColumn):ChartDataUtils.getMeasureExtents(chartDef,chartData,"x",undefined,includeEmptyBins);const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,xSpec,undefined),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,chartDef.genericMeasures,customMeasures,true,getRefLineValuesOverride),referenceLinesExtents=ReferenceLines.getReferenceLinesExtents(displayedReferenceLines,referenceLinesValues,{[leftYAxisID]:{isPercentScale:yExtents[leftYAxisID].onlyPercent},[rightYAxisID]:{isPercentScale:yExtents[rightYAxisID].onlyPercent}});const leftYExtent=ReferenceLines.getExtentWithReferenceLines(yExtents[leftYAxisID].extent,referenceLinesExtents[leftYAxisID]),rightYExtent=ReferenceLines.getExtentWithReferenceLines(yExtents[rightYAxisID].extent,referenceLinesExtents[rightYAxisID]);ReferenceLines.mutateDimensionSpecForReferenceLine(ChartDataUtils.getAxisExtent(chartData,"x",xSpec.dimension),referenceLinesExtents.x,xSpec);const animationData=GroupedColumnsUtils.prepareData(chartDef,chartData,isDisplayedAsColumn,ignoreLabels),linesData=LinesUtils.prepareData(chartDef,chartData,measure=>!isDisplayedAsColumn(measure),ignoreLabels,false);const hasColumns=chartDef.genericMeasures.some(isDisplayedAsColumn);const drawFrame=(frameIdx,chartBase)=>{chartData.fixAxis("animation",frameIdx);facetLabels.forEach((facetLabel,f)=>{const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));const labelCollisionDetectionHandler=SVGUtils.initLabelCollisionDetection(chartBase);const columnsData=animationData.frames[frameIdx].facets[facetLabel.$tensorIndex].groups;GroupedColumnsDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",facetLabel.$tensorIndex),chartBase,columnsData,facetLabel.$tensorIndex,labelCollisionDetectionHandler,false);LinesDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",facetLabel.$tensorIndex),chartBase,linesData,facetLabel.$tensorIndex,false,false,labelCollisionDetectionHandler,getRefLineValuesOverride,hasColumns?g.select(".group-wrapper"):null)})};const leftYCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,leftYAxisID);const rightYCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,rightYAxisID);const ySpecs={[leftYAxisID]:{id:leftYAxisID,type:"MEASURE",extent:leftYExtent,customExtent:leftYCustomExtent,position:ChartYAxisPosition.LEFT},[rightYAxisID]:{id:rightYAxisID,type:"MEASURE",extent:rightYExtent,customExtent:rightYCustomExtent,position:ChartYAxisPosition.RIGHT}};const availableAxes=ReferenceLines.getAvailableAxesForReferenceLines(chartDef);const colorSpec=hasSubtotals?{type:"CUSTOM",name:"color",handle:measure=>!isDisplayedAsColumn(measure),buildGenericMeasures:(measures,colorLabels)=>{const trimmeredColorlabels=colorLabels.filter(label=>!ignoreLabels.has(label.label));const linesMeasures=measures.filter(measure=>!isDisplayedAsColumn(measure));return[...trimmeredColorlabels,...linesMeasures]},ignoreColorDim:(index,measuresOrColors)=>measuresOrColors[index].isA==="measure"}:{type:"DIMENSION",name:"color"};const axisSpecs={x:xSpec,...ySpecs};ChartAxesUtils.setNumberOfBinsToDimensions(chartData,chartDef,axisSpecs);ReferenceLines.updateAvailableAxisOptions([{axis:"LEFT_Y_AXIS",isDisplayed:availableAxes["LEFT_Y_AXIS"],isNumerical:true,isPercentScale:ySpecs[leftYAxisID].isPercentScale},{axis:"RIGHT_Y_AXIS",isDisplayed:availableAxes["RIGHT_Y_AXIS"],isNumerical:true,isPercentScale:ySpecs[rightYAxisID].isPercentScale},{axis:"X_AXIS",isDisplayed:true,isNumerical:ChartAxesUtils.isNumerical(xSpec)&&!ChartDimension.hasOneTickPerBin(xSpec.dimension),isContinuousDate:ChartAxesUtils.isContinuousDate(xSpec)}]);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,axisSpecs,colorSpec,undefined,undefined,ignoreLabels)}})})();(function(){"use strict";angular.module("dataiku.charts").factory("StackedAreaChart",function(ChartManager,ChartDimension,ChartDataWrapperFactory,SVGUtils,StackedChartUtils,LinesUtils,ColorUtils,ChartAxesUtils,ChartYAxisPosition,ChartHierarchyDimension,ChartDrilldown){return function($container,chartDef,chartHandler,axesDef,data){let currentAnimationFrame=0;const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef),xDimension=ChartDimension.getGenericDimension(chartDef),xLabels=chartData.getAxisLabels("x"),animationData=StackedChartUtils.prepareData(chartDef,chartData),yExtent=[0,animationData.maxTotal];const drawFrame=function(frameIdx,chartBase){animationData.frames[frameIdx].facets.forEach(function(facetData,f){const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));StackedAreaChartDrawer(g,facetData,chartBase,f)});currentAnimationFrame=frameIdx};if(ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting)){yExtent[0]=1}const isPercentScale=ChartDimension.isPercentScale(chartDef.genericMeasures)||chartDef.variant=="stacked_100";const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,{x:{type:"DIMENSION",mode:"POINTS",dimension:xDimension,name:"x",customExtent:chartDef.xAxisFormatting.customExtent},[yAxisID]:{id:yAxisID,type:"MEASURE",extent:yExtent,isPercentScale:isPercentScale,customExtent:ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID),position:ChartYAxisPosition.LEFT}},{type:"DIMENSION",name:"color",dimension:chartDef.genericDimension1[0]});function StackedAreaChartDrawer(g,stacksData,chartBase,f){const yAxis=chartBase.yAxes[0],yScale=yAxis.scale(),xCoord=LinesUtils.getXCoord(xDimension,chartBase.xAxis,chartBase.xAxis.ordinalScale,xLabels,"x"),yCoord=function(d){return yScale(d.top)};const wrappers=g.selectAll("g.wrapper").data(stacksData.stacks[0].data,function(d,i){return d.color+"-"+d.measure});wrappers.enter().append("g").attr("class","wrapper").attr("fill",function(d,i){return chartBase.colorScale(i)}).attr("opacity",chartDef.colorOptions.transparency).each(function(d){chartBase.tooltips.registerEl(this,{measure:d.measure,x:d.x,color:d.color,animation:currentAnimationFrame,facet:f},"fill",true)});wrappers.exit().remove();const points=wrappers.selectAll("circle.point").data(function(d,i){return stacksData.stacks.map(function(stack){return stack.data[i]})},function(d){return d.x+"-"+d.measure+"-"+d.color});points.enter().append("circle").attr("class","point").attr("r",5).attr("fill",function(d){return ColorUtils.darken(chartBase.colorScale(d.color+d.measure))}).attr("opacity",0).each(function(d){chartBase.tooltips.registerEl(this,{measure:d.measure,x:d.x,color:d.color,animation:currentAnimationFrame,facet:f},"fill");chartBase.contextualMenu.addContextualMenuHandler(this,{x:d.x,color:d.color,animation:currentAnimationFrame,facet:f})});points.exit().remove();points.interrupt("movePoints").transition("movePoints").attr("cx",xCoord).attr("cy",yCoord);const area=d3.svg.area().x(xCoord).y0(function(d){return yScale(d.base)}).y1(function(d){return yScale(d.top)});if(chartDef.smoothing){area.interpolate("monotone")}const path=wrappers.selectAll("path.area").data(function(d,i){return[stacksData.stacks.map(function(stack){return stack.data[i]})]});path.enter().insert("path",":first-child").attr("class","area");path.exit().remove();path.interrupt("updateArea").transition("updateArea").attr("d",area);wrappers.on("mouseover.area",function(d){this.parentNode.insertBefore(this,$(this.parentNode).find("g.legend")[0]);d3.select(this).selectAll(".wrapper circle").interrupt("fade").transition("fade").attr("opacity",1)}).on("mouseout.area",function(d){d3.select(this).selectAll(".wrapper circle").interrupt("fade").transition("fade").attr("opacity",0)});if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}ChartAxesUtils.isCroppedChart(chartDef)&&SVGUtils.clipPaths(chartBase,g,wrappers)}}})})();(function(){"use strict";angular.module("dataiku.charts").factory("DKUPivotCharts",function(GroupedColumnsChart,StackedColumnsChart,StackedAreaChart,LinesChart,MultiplotChart,StackedBarsChart,ScatterPlotChart,ScatterPlotMultiplePairsChart,BinnedXYChart,GroupedXYChart,LiftChart,AdministrativeMapChart,ScatterMapChart,DensityHeatMapChart,GridMapChart,BoxplotsChart,KpiChart,PivotTableChart,Density2DChart,PieChart,GeometryMapChart,WebappChart,GaugeEChartDef,PieEChartDef,RadarEChartDef,SankeyEChartDef,TreemapEChartDef){return{GroupedColumnsChart:GroupedColumnsChart,StackedColumnsChart:StackedColumnsChart,StackedAreaChart:StackedAreaChart,LinesChart:LinesChart,MultiplotChart:MultiplotChart,StackedBarsChart:StackedBarsChart,PivotTableChart:PivotTableChart,ScatterPlotChart:ScatterPlotChart,ScatterPlotMultiplePairsChart:ScatterPlotMultiplePairsChart,BinnedXYChart:BinnedXYChart,GroupedXYChart:GroupedXYChart,LiftChart:LiftChart,AdministrativeMapChart:AdministrativeMapChart,ScatterMapChart:ScatterMapChart,DensityHeatMapChart:DensityHeatMapChart,GridMapChart:GridMapChart,BoxplotsChart:BoxplotsChart,Density2DChart:Density2DChart,KpiChart:KpiChart,PieEChartDef:PieEChartDef,GeometryMapChart:GeometryMapChart,WebappChart:WebappChart,GaugeEChartDef:GaugeEChartDef,PieChart:PieChart,RadarEChartDef:RadarEChartDef,SankeyEChartDef:SankeyEChartDef,TreemapEChartDef:TreemapEChartDef}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("AdministrativeMapChart",function($timeout,CHART_VARIANTS,ChartFormatting,ChartPropertiesService,_MapCharts,ChartLegendUtils,ColorUtils,ChartColorScales,ChartLabels){return function($container,chartDef,data,chartHandler){const geo=JSON.parse(data.geoJson);const aggrVals=function(aggregId){let feat,featIdx;const arr=[];for(featIdx in geo.features){feat=geo.features[featIdx];if(!_.isNil(feat.properties[aggregId])){arr.push(feat.properties[aggregId])}}return arr};const aggrBounds=function(aggregId){const arr=aggrVals(aggregId);return[d3.min(arr),d3.max(arr)]};let colorScale,singleColor;if(chartDef.colorMeasure.length){colorScale=ChartColorScales.continuousColorScale(chartDef.colorOptions,aggrBounds("color")[0],aggrBounds("color")[1],aggrVals("color"),false,chartHandler.getChartTheme());colorScale.type="MEASURE"}else{singleColor=ColorUtils.toRgba(chartDef.colorOptions.singleColor,chartDef.colorOptions.transparency)}ChartLegendUtils.initLegend(chartDef,null,chartHandler.legendsWrapper,colorScale);if(colorScale){chartHandler.legendsWrapper.getLegend(0).formatter=ChartFormatting.getForLegend(chartDef.colorMeasure[0],colorScale.innerScale.domain())}ChartLegendUtils.drawLegend(chartDef,chartHandler,$container).then(function(){_MapCharts.adjustLegendPlacement(chartDef,$container);$timeout(()=>{const elt=_MapCharts.getOrCreateMapContainer($container);const map=_MapCharts.createMapIfNeeded(elt,chartHandler.chartSpecific,chartDef);if(elt.data("leaflet-data-layer")){map.removeLayer(elt.data("leaflet-data-layer"))}_MapCharts.repositionMap(map,elt,data);const sizeScale=d3.scale.sqrt().range([chartDef.bubblesOptions.defaultRadius,chartDef.bubblesOptions.defaultRadius*5]).domain(aggrBounds("size"));function onEachFeature(feature,layer){if(!ChartPropertiesService.showTooltip(chartDef.tooltipOptions,chartHandler.chartTileProperties)){return}let html="<h4>"+feature.properties.label+"</h4>";if(!_.isNil(feature.properties.color)){html+=sanitize(ChartLabels.getLongMeasureLabel(chartDef.colorMeasure[0]));html+=": <strong>";html+=sanitize(ChartFormatting.getForIsolatedNumber(chartDef.colorMeasure[0])(feature.properties.color))+"</strong><br />"}if(!_.isNil(feature.properties.size)){html+=sanitize(ChartLabels.getLongMeasureLabel(chartDef.sizeMeasure[0]));html+=": <strong>";html+=sanitize(ChartFormatting.getForIsolatedNumber(chartDef.sizeMeasure[0])(feature.properties.size))+"</strong><br />"}if(!_.isNil(feature.properties.count)){html+="Value count"+": <strong>";html+=ChartFormatting.getForIsolatedNumber()(feature.properties.count)+"</strong><br />"}if(chartDef.tooltipMeasures.length>0){html+="<hr/>"}chartDef.tooltipMeasures.forEach(function(measure,j){const tooltipFormatter=ChartFormatting.getForIsolatedNumber(measure);html+=sanitize(ChartLabels.getLongMeasureLabel(measure))+": <strong>"+sanitize(tooltipFormatter(feature.properties[j]))+"</strong><br/>"});layer.bindPopup(html,{className:"qa-chart-tooltip"})}let layer;if(chartDef.variant==CHART_VARIANTS.filledMap){chartDef.sizeMeasure=[];const myStyle=function(feature){return{color:singleColor||colorScale(feature.properties["color"]),fillColor:singleColor||colorScale(feature.properties["color"]),fillOpacity:chartDef.fillOpacity,weight:1,opacity:1}};layer=L.geoJson(geo.features,{style:myStyle,onEachFeature:onEachFeature});map.addLayer(layer)}else{layer=L.geoJson(geo.features,{pointToLayer:function(feature,latlng){const size=feature.properties["size"]!=null?sizeScale(feature.properties["size"]):chartDef.bubblesOptions.defaultRadius;const color=singleColor||(feature.properties["color"]!=null?colorScale(feature.properties["color"]):"#666");return L.circleMarker(latlng,{radius:size,color:color,fillColor:color,opacity:.85,fillOpacity:.85})},onEachFeature:onEachFeature});map.addLayer(layer)}elt.data("leaflet-data-layer",layer)})}).finally(function(){if(typeof chartHandler.loadedCallback==="function"){$timeout(()=>{chartHandler.loadedCallback()})}})}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("DensityHeatMapChart",function(ChartFormatting,ChartUADimension,_MapCharts,ChartLabels,UaChartsCommon,ChartLegendUtils,ChartColorScales,DKU_PALETTE_NAMES){return function($container,chartDef,data,chartHandler){const elt=_MapCharts.getOrCreateMapContainer($container);chartHandler.legendsWrapper.deleteLegends();chartDef.colorOptions.paletteType="CONTINUOUS";ChartLegendUtils.drawLegend(chartDef,chartHandler,$container,ChartColorScales).then(function(){_MapCharts.adjustLegendPlacement(chartDef,$container);const layerGroup=L.layerGroup();const map=_MapCharts.createMapIfNeeded(elt,chartHandler.chartSpecific,chartDef);_MapCharts.repositionMap(map,elt,data);if(elt.data("leaflet-data-layer")){map.removeLayer(elt.data("leaflet-data-layer"))}let existingHeatMapLayer;map.eachLayer(function(layer){if(layer.options&&layer.options.id){if(layer.options.id==="heatmap"){existingHeatMapLayer=layer}}});if(existingHeatMapLayer){map.removeLayer(existingHeatMapLayer)}const colorOptions={colorPalette:chartDef.colorOptions.colorPalette,transparency:1,customPalette:chartDef.colorOptions.customPalette};let scale=ChartColorScales.continuousColorScale(colorOptions,0,1,undefined,undefined,chartHandler.getChartTheme());if(colorOptions.colorPalette===DKU_PALETTE_NAMES.CUSTOM&&colorOptions.customPalette.colors.length===0){scale=bin=>"rgba(0, 0, 0, 1)"}const gradient={};for(let i=0;i<=9;i++){gradient[i/10]=scale(i/10)}const uaLFn=ChartLabels.getUaLabel;const hasUAColor=false;const makeIntensityScale=function(chartDef,data){if(ChartUADimension.isTrueNumerical(chartDef.uaSize[0])){return d3.scale.sqrt().range([0,1]).domain([data.values.size.num.min,data.values.size.num.max])}else if(ChartUADimension.isDateRange(chartDef.uaSize[0])){return d3.scale.sqrt().range([0,1]).domain([data.values.size.ts.min,data.values.size.ts.max])}else{throw new ChartIAE("Cannot use ALPHANUM as size scale")}};const hasUASize=UaChartsCommon.hasUASize(chartDef);let intensityScale;let getScaleWeight;if(hasUASize){intensityScale=makeIntensityScale(chartDef,data);getScaleWeight=function(chartDef,data,i,sizeScale){if(chartDef.uaSize.length){let sizeValue;if(ChartUADimension.isTrueNumerical(chartDef.uaSize[0])){sizeValue=data.values.size.num.data[i]}else if(ChartUADimension.isDateRange(chartDef.uaSize[0])){sizeValue=data.values.size.ts.data[i]}return sizeScale(sizeValue)}else{return 1}}}const radiusRangeMultiplier=40;const geopoints=[];data.xAxis.num.data.forEach(function(x,i){const y=data.yAxis.num.data[i];let r;if(hasUASize){r=getScaleWeight(chartDef,data,i,intensityScale)}else{r=1}geopoints.push([y,x,r*chartDef.colorOptions.heatDensityMapIntensity])});if(chartDef.colorOptions.heatDensityMapRadius!==0){const heatMapLayer=L.heatLayer(geopoints,{radius:chartDef.colorOptions.heatDensityMapRadius*radiusRangeMultiplier,id:"heatmap",gradient:gradient});heatMapLayer.addTo(map)}const options={stroke:false,color:"rgb(0,0,0)",opacity:1,fill:false,fillColor:"rgb(255,0,0)",fillOpacity:1,radius:5};data.xAxis.num.data.forEach(function(x,i){const y=data.yAxis.num.data[i];const pointLayer=L.circleMarker([y,x],options);let html="";html+="Lon: <strong>"+ChartFormatting.getForIsolatedNumber()(x)+"</strong><br />";html+="Lat: <strong>"+ChartFormatting.getForIsolatedNumber()(y)+"</strong><br />";if(hasUASize&&(!hasUAColor||(chartDef.uaSize[0].column!==chartDef.uaColor[0].column||chartDef.uaColor[0].dateMode!=="RANGE"))){html+=uaLFn(chartDef.uaSize[0])+": <strong>"+UaChartsCommon.formattedSizeVal(chartDef,data,i)+"</strong><br />"}if(chartDef.uaTooltip.length>0){html+="<hr/>"}chartDef.uaTooltip.forEach(function(ua,j){html+=uaLFn(ua)+": <strong>"+UaChartsCommon.formattedVal(data.values["tooltip_"+j],ua,i)+"</strong><br/>"});pointLayer.bindPopup(html,{className:"qa-chart-tooltip"});pointLayer.on("mouseover",function(e){this.setStyle({stroke:true,fill:true});this.openPopup()});pointLayer.on("mouseout",function(e){this.setStyle({stroke:false,fill:false});this.closePopup()});layerGroup.addLayer(pointLayer)});layerGroup.addTo(map);elt.data("leaflet-data-layer",layerGroup)}).finally(function(){if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}})}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("GeometryMapChart",function(ChartFormatting,_MapCharts,ChartLegendUtils,ChartPropertiesService,ColorUtils,ChartColorUtils,UaChartsCommon,_GeometryCommon,ChartLabels,ChartUADimension,$timeout,BuiltinMapBackgrounds){return function($container,chartDef,data,chartHandler){const elt=_MapCharts.getOrCreateMapContainer($container);const geoJsons=data.geoJsons.map(unparsedGeo=>JSON.parse(unparsedGeo));const layers={};const colorCaches={};const colorScales={};const singleColors={};chartHandler.legendsWrapper.deleteLegends();const displayableGeoLayers=_GeometryCommon.getDisplayableLayers(chartDef.geoLayers);for(let geometryIndex=0;geometryIndex<displayableGeoLayers.length;geometryIndex++){const geoLayer=displayableGeoLayers[geometryIndex];const geometry=geoLayer.geometry[0];colorCaches[geometryIndex]={};const hasUAColor=_GeometryCommon.hasUAColor(geoLayer);if(hasUAColor){colorScales[geometryIndex]=_GeometryCommon.makeColorScale(geoLayer,data,chartHandler,geometryIndex)}else{singleColors[geometryIndex]=_GeometryCommon.makeSingleColor(geoLayer)}const isLegendDiscrete=ChartUADimension.isAlphanumLike(geoLayer.uaColor[0])||ChartUADimension.isDiscreteDate(geoLayer.uaColor[0]);if(hasUAColor&&isLegendDiscrete){const baseFadeColor=BuiltinMapBackgrounds.getBackgrounds().find(b=>b.id===chartDef.mapOptions.tilesLayer).fadeColor||"#333";const fadeColor=ColorUtils.toRgba(baseFadeColor,.5*geoLayer.colorOptions.transparency);const colorTokenName=ChartColorUtils.getPaletteName(geometryIndex);const legend={type:"COLOR_DISCRETE",label:geometry.column,items:data.values[colorTokenName].str.sortedMapping.map(function(_,rowIndex){const color=colorScales[geometryIndex](rowIndex);return{label:{...data.values[colorTokenName].str.sortedMapping[rowIndex],colorId:ChartColorUtils.getColorId(geoLayer.genericMeasures,{data:data},rowIndex,geometryIndex)},color:color,focusFn:function(){layers[geometryIndex].setStyle(function(feature){if(data.values[colorTokenName].str.data[feature.properties.idx]===rowIndex){return{color:color,opacity:1,weight:chartDef.strokeWidth}}else{return{color:fadeColor,opacity:1,weight:chartDef.strokeWidth}}})},unfocusFn:function(){layers[geometryIndex].setStyle(function(feature){const c=singleColors[geometryIndex]||_GeometryCommon.makeColor(geoLayer,data,feature.properties.idx,colorScales[geometryIndex],singleColors[geometryIndex],colorCaches[geometryIndex],geometryIndex);return{color:c,opacity:1,weight:chartDef.strokeWidth}})},focused:false}})};chartHandler.legendsWrapper.pushLegend(legend)}else if(colorScales[geometryIndex]){const legend=ChartLegendUtils.createContinuousLegend(geoLayer.uaColor[0],colorScales[geometryIndex]);legend.label=geometry.column;if(ChartUADimension.isDateRange(geoLayer.uaColor[0])){legend.formatter=ChartFormatting.getForDate()}else{legend.formatter=ChartFormatting.getForLegend(geoLayer.uaColor[0],colorScales[geometryIndex].innerScale.domain())}chartHandler.legendsWrapper.pushLegend(legend)}else{if(chartDef.geoLayers.length<3){chartHandler.legendsWrapper.deleteLegends()}else{const legend=ChartLegendUtils.getSingleColorLegend(singleColors[geometryIndex],geometry.column);chartHandler.legendsWrapper.pushLegend(legend)}}}ChartLegendUtils.drawLegend(chartDef,chartHandler,$container).then(function(){_MapCharts.adjustLegendPlacement(chartDef,$container);const map=_MapCharts.createMapIfNeeded(elt,chartHandler.chartSpecific,chartDef);if(elt.data("leaflet-data-layer")){map.removeLayer(elt.data("leaflet-data-layer"))}_MapCharts.repositionMap(map,elt,data);function onEachFeatureClosure(geometryIndex,geoLayer){return function onEachFeature(feature,layer){if(!ChartPropertiesService.showTooltip(chartDef.tooltipOptions,chartHandler.chartTileProperties)){return}let html="";if(_GeometryCommon.hasUAColor(geoLayer)){const colorTokenName=ChartColorUtils.getPaletteName(geometryIndex);if(colorTokenName in data.values){html+=sanitize(ChartLabels.getUaLabel(geoLayer.uaColor[0]))+": <strong>"+sanitize(_GeometryCommon.formattedColorVal(chartDef,data,feature.properties.idx,colorTokenName,geometryIndex))+"</strong><br />"}}chartDef.uaTooltip.forEach(function(ua,j){html+=sanitize(ChartLabels.getUaLabel(ua))+": <strong>"+sanitize(UaChartsCommon.formattedVal(data.values["tooltip_"+j],ua,feature.properties.idx))+"</strong><br/>"});if(html.length){layer.bindPopup(html,{className:"qa-chart-tooltip"})}}}function getLayer(geoJsons,geoLayer,geometryIndex){const layerSingleColor=_GeometryCommon.makeSingleColor(geoLayer);return L.geoJson(geoJsons.features,{style:function(feature){const c=_GeometryCommon.makeColor(geoLayer,data,feature.properties.idx,colorScales[geometryIndex],layerSingleColor,colorCaches[geometryIndex],geometryIndex);return{color:c,opacity:1,weight:chartDef.strokeWidth,fillOpacity:chartDef.fillOpacity}},onEachFeature:onEachFeatureClosure(geometryIndex,geoLayer),pointToLayer:function(feature,latlng){const c=_GeometryCommon.makeColor(geoLayer,data,feature.properties.idx,colorScales[geometryIndex],layerSingleColor,colorCaches[geometryIndex],geometryIndex);const geojsonMarkerOptions={radius:5,fillColor:c,color:c,weight:chartDef.strokeWidth,opacity:1,fillOpacity:1};return L.circleMarker(latlng,geojsonMarkerOptions)}})}function plot(geometryIndex){map.addLayer(layers[geometryIndex]);if(map.$justCreated){$timeout(function(){map.fitBounds(layers[geometryIndex])})}elt.data("leaflet-data-layer",layers[geometryIndex])}for(const displayedGeo of chartHandler.displayedGeometries){map.removeLayer(displayedGeo.geoJsonLayer)}const newGeometries=[];for(let geometryIndex=0;geometryIndex<displayableGeoLayers.length;geometryIndex++){const newGeoLayer=displayableGeoLayers[geometryIndex];layers[geometryIndex]=getLayer(geoJsons[geometryIndex],newGeoLayer,geometryIndex);plot(geometryIndex);newGeometries[geometryIndex]={geometry:angular.copy(newGeoLayer[geometryIndex]),geoJsonLayer:layers[geometryIndex]}}chartHandler.displayedGeometries=newGeometries}).finally(function(){if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}})}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("GridMapChart",function(ChartFormatting,ChartPropertiesService,_MapCharts,ChartLabels,UaChartsCommon,ChartLegendUtils,ChartColorScales){return function($container,chartDef,data,chartHandler){const elt=_MapCharts.getOrCreateMapContainer($container);const map=_MapCharts.createMapIfNeeded(elt,chartHandler.chartSpecific,chartDef);if(elt.data("leaflet-data-layer")){map.removeLayer(elt.data("leaflet-data-layer"))}_MapCharts.repositionMap(map,elt,data);const hasColor=chartDef.colorMeasure.length;let colorScale,resultingColor;if(hasColor){colorScale=ChartColorScales.continuousColorScale(chartDef.colorOptions,data.aggregations.color.min,data.aggregations.color.max,data.aggregations.color.tensor,undefined,chartHandler.getChartTheme());colorScale.type="MEASURE"}else{resultingColor=UaChartsCommon.makeSingleColor(chartDef)}ChartLegendUtils.initLegend(chartDef,null,chartHandler.legendsWrapper,colorScale);if(colorScale){chartHandler.legendsWrapper.getLegend(0).formatter=ChartFormatting.getForLegend(chartDef.colorMeasure[0],colorScale.innerScale.domain())}ChartLegendUtils.drawLegend(chartDef,chartHandler,$container).then(function(){_MapCharts.adjustLegendPlacement(chartDef,$container);const layerGroup=L.layerGroup();data.cellMinLat.forEach(function(x,i){const minLat=data.cellMinLat[i];const minLon=data.cellMinLon[i];const maxLat=minLat+data.gridLatDeg;const maxLon=minLon+data.gridLonDeg;const c=hasColor?colorScale(data.aggregations.color.tensor[i]):resultingColor;const rect=L.rectangle([[minLat,minLon],[maxLat,maxLon]],{stroke:false,fill:true,fillColor:c,fillOpacity:1});if(ChartPropertiesService.showTooltip(chartDef.tooltipOptions,chartHandler.chartTileProperties)){let html="";html+="Lon: <strong>"+ChartFormatting.getForIsolatedNumber()(minLon+(maxLon-minLon)/2)+"</strong><br />";html+="Lat: <strong>"+ChartFormatting.getForIsolatedNumber()(minLat+(maxLat-minLat)/2)+"</strong><br />";if(hasColor){const colorFormatter=ChartFormatting.getForIsolatedNumber(chartDef.colorMeasure[0]);html+=ChartLabels.getShortMeasureLabel(chartDef.colorMeasure[0])+": <strong>"+sanitize(colorFormatter(data.aggregations.color.tensor[i]))+"</strong>"}if(chartDef.tooltipMeasures.length>0){html+="<hr/>"}chartDef.tooltipMeasures.forEach(function(measure,j){const tooltipFormatter=ChartFormatting.getForIsolatedNumber(measure);html+=`${ChartLabels.getLongMeasureLabel(measure)}: <strong>${sanitize(tooltipFormatter(data.aggregations["tooltip_"+j].tensor[i]))}</strong><br/>`});rect.bindPopup(html,{className:"qa-chart-tooltip"})}layerGroup.addLayer(rect)});layerGroup.addTo(map);elt.data("leaflet-data-layer",layerGroup)}).finally(function(){if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}})}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("ScatterMapChart",function(ChartFormatting,ChartPropertiesService,ChartUADimension,_MapCharts,ChartLabels,UaChartsCommon,ChartLegendUtils,ColorUtils,ChartColorUtils,BuiltinMapBackgrounds){return function($container,chartDef,data,chartHandler){const elt=_MapCharts.getOrCreateMapContainer($container);let layerGroup,colorScale;const hasUAColor=UaChartsCommon.hasUAColor(chartDef);if(hasUAColor){colorScale=UaChartsCommon.makeColorScale(chartDef,data,chartHandler)}else{var resultingColor=UaChartsCommon.makeSingleColor(chartDef)}if(hasUAColor&&(ChartUADimension.isAlphanumLike(chartDef.uaColor[0])||ChartUADimension.isDiscreteDate(chartDef.uaColor[0]))){const baseFadeColor=BuiltinMapBackgrounds.getBackgrounds().find(b=>b.id===chartDef.mapOptions.tilesLayer).fadeColor||"#333";const fadeColor=ColorUtils.toRgba(baseFadeColor,.5*chartDef.colorOptions.transparency);const legend={type:"COLOR_DISCRETE",items:data.values.color.str.sortedMapping.map(function(_,v){return{label:{...data.values.color.str.sortedMapping[v],colorId:ChartColorUtils.getColorId(chartDef.genericMeasures,{data:data},v)},color:colorScale(v),focusFn:function(){layerGroup.getLayers().forEach(function(layer){const opts=layer.options;if(!opts.actualFillColor){opts.actualFillColor=opts.fillColor}if(opts.colorIdx!==v){opts.fillColor=fadeColor}else{opts.fillColor=opts.actualFillColor}layer.setStyle(opts)})},unfocusFn:function(){layerGroup.getLayers().forEach(function(layer){const opts=layer.options;opts.fillColor=opts.actualFillColor;layer.setStyle(opts)})},focused:false}})};chartHandler.legendsWrapper.deleteLegends();chartHandler.legendsWrapper.pushLegend(legend)}else{if(colorScale){colorScale.type="MEASURE"}ChartLegendUtils.initLegend(chartDef,null,chartHandler.legendsWrapper,colorScale);if(colorScale){if(ChartUADimension.isDateRange(chartDef.uaColor[0])){chartHandler.legendsWrapper.getLegend(0).formatter=ChartFormatting.getForDate()}else{chartHandler.legendsWrapper.getLegend(0).formatter=ChartFormatting.getForLegend(chartDef.uaColor[0],colorScale.innerScale.domain())}}}ChartLegendUtils.drawLegend(chartDef,chartHandler,$container).then(function(){_MapCharts.adjustLegendPlacement(chartDef,$container);const map=_MapCharts.createMapIfNeeded(elt,chartHandler.chartSpecific,chartDef);if(elt.data("leaflet-data-layer")){map.removeLayer(elt.data("leaflet-data-layer"))}_MapCharts.repositionMap(map,elt,data);const hasUASize=UaChartsCommon.hasUASize(chartDef);if(hasUASize){var sizeScale=UaChartsCommon.makeSizeScale(chartDef.bubblesOptions.defaultRadius,chartDef.uaSize[0],data,1)}const uaLFn=ChartLabels.getUaLabel;layerGroup=L.layerGroup();const colorCache={};data.xAxis.num.data.forEach(function(x,i){const y=data.yAxis.num.data[i];let radius=UaChartsCommon.makeSize(chartDef,data,i,sizeScale);const color=UaChartsCommon.makeColor(chartDef,data,i,colorScale,resultingColor,colorCache);if(radius<0){radius=0}const options={radius:radius,fillOpacity:1};if(ChartUADimension.isAlphanumLike(chartDef.uaColor[0])||ChartUADimension.isDiscreteDate(chartDef.uaColor[0])){options.colorIdx=data.values.color.str.data[i]}if(chartDef.bubblesOptions.singleShape=="EMPTY_CIRCLE"){options.stroke=true;options.fill=false;options.color=color}else{options.stroke=false;options.fill=true;options.fillColor=color}const pointLayer=L.circleMarker([y,x],options);if(ChartPropertiesService.showTooltip(chartDef.tooltipOptions,chartHandler.chartTileProperties)){let html="";html+="Lon: <strong>"+ChartFormatting.getForIsolatedNumber()(x)+"</strong><br />";html+="Lat: <strong>"+ChartFormatting.getForIsolatedNumber()(y)+"</strong><br />";if(hasUAColor){html+=sanitize(uaLFn(chartDef.uaColor[0]))+": <strong>"+sanitize(UaChartsCommon.formattedColorVal(chartDef,data,i))+"</strong><br />"}if(hasUASize&&(!hasUAColor||(chartDef.uaSize[0].column!==chartDef.uaColor[0].column||chartDef.uaColor[0].dateMode!=="RANGE"))){html+=sanitize(uaLFn(chartDef.uaSize[0]))+": <strong>"+sanitize(UaChartsCommon.formattedSizeVal(chartDef,data,i))+"</strong><br />"}if(chartDef.uaTooltip.length>0){html+="<hr/>"}chartDef.uaTooltip.forEach(function(ua,j){html+=sanitize(uaLFn(ua))+": <strong>"+sanitize(UaChartsCommon.formattedVal(data.values["tooltip_"+j],ua,i))+"</strong><br/>"});pointLayer.bindPopup(html,{className:"qa-chart-tooltip"})}layerGroup.addLayer(pointLayer)});layerGroup.addTo(map);elt.data("leaflet-data-layer",layerGroup)}).finally(function(){if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}})}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("_MapCharts",function(Assert,Logger,ChartLegendUtils,localStorageService,$state,$stateParams,ChartZoomControlAdapter,CHART_ZOOM_CONTROL_TYPES,BuiltinMapBackgrounds){function getLSKey(elt){let lsKey="DSSMapPosition.";const mapScope=angular.element(elt).scope();if($state.current.name.startsWith("projects.project.datasets.dataset.visualize")){lsKey+="explore."+$stateParams.projectKey+"."+$stateParams.datasetName+"."+mapScope.currentChart.index}else if($state.current.name.startsWith("projects.project.analyses.analysis")){lsKey+="analysis."+$stateParams.projectKey+"."+$stateParams.analysisId+"."+mapScope.currentChart.index}else if($state.current.name.startsWith("projects.project.dashboards.insights.insight")){lsKey+="insight."+$stateParams.projectKey+"."+$stateParams.insightId}else if($state.current.name.startsWith("projects.project.dashboards.dashboard")){lsKey+="insight."+$stateParams.projectKey+"."+mapScope.insight.id}else{lsKey+="other."+$state.current.name}return lsKey}const svc={createMapIfNeeded:function(elt,chartSpecific,chartDef){let map=elt.data("leaflet-map");if(!map){Logger.info("Creating map");map=L.map(elt[0],{zoomControl:false}).setView([20,0],2);chartSpecific.leafletMap=map;elt.data("leaflet-map",map);map.$justCreated=true}else{map.$justCreated=false}const prevLayerId=elt.data("leaflet-tile-layer-id");let layerId="cartodb-positron";if(chartDef.mapOptions&&chartDef.mapOptions.tilesLayer){layerId=chartDef.mapOptions.tilesLayer}let foundLayer=BuiltinMapBackgrounds.getBackgrounds().find(b=>b.id===layerId);if(!foundLayer){layerId="cartodb-positron";foundLayer=BuiltinMapBackgrounds.getBackgrounds().find(b=>b.id===layerId)}Logger.info("New layer",layerId,"Previous layer",prevLayerId);if(prevLayerId&&layerId!=prevLayerId){Logger.info("Removing previous layer");const prevLayer=elt.data("leaflet-tile-layer");map.removeLayer(prevLayer)}if(!prevLayerId||layerId!=prevLayerId){Logger.info("Adding layer");Assert.trueish(foundLayer,"layer not found");const layer=foundLayer.getTileLayer();map.addLayer(layer);elt.data("leaflet-tile-layer-id",layerId);elt.data("leaflet-tile-layer",layer)}svc.configureZoom(map,chartDef,elt);return map},repositionMap:function(map,elt,data){if(!elt.data("leaflet-map-positioned")&&data.minLat>-90){elt.data("leaflet-map-positioned",1);const previousPosition=localStorageService.get(getLSKey(elt));if(previousPosition){map.setView(previousPosition.center,previousPosition.zoom)}else{map.fitBounds([[data.minLat,data.minLon],[data.maxLat,data.maxLon]],{padding:[10,10]})}}},getOrCreateMapContainer:function($container){let elt=$container.find(".map-container");if(!elt.length){$container.find(".mainzone").remove();elt=$('<div class="map-container mainzone w100 h100" data-qa-screenshot-scope__chart>').appendTo($container)}return elt},adjustLegendPlacement:function(chartDef,$container){const legendZone=$container.find(".legend-zone");if(legendZone){legendZone.css("z-index",1)}const margins={top:5,bottom:5,left:5,right:5};switch(chartDef.legendPlacement){case"INNER_TOP_LEFT":margins.top=10;margins.left=45;break;case"INNER_BOTTOM_RIGHT":margins.bottom=20;break}return ChartLegendUtils.adjustLegendPlacement(chartDef,$container,margins)},configureZoom:function(map,chartDef,elt){chartDef.$zoomControlInstanceId=ChartZoomControlAdapter.create(CHART_ZOOM_CONTROL_TYPES.LEAFLET,map,()=>{localStorageService.set(getLSKey(elt),{center:map.getCenter(),zoom:map.getZoom()})})}};return svc})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("BoxplotsChart",function(ChartAxesUtils,D3ChartAxes,ChartsStaticData,ChartDataWrapperFactory,ChartColorUtils,ChartColorScales,ChartLegendUtils,$timeout,ChartContextualMenu,ChartFormatting,ChartStoreFactory,ChartTooltips,ChartLabels,ChartYAxisPosition,CHART_MODES,ChartDimension,SVGUtils,ChartDrilldown,ChartHierarchyDimension,ChartPropertiesService){return function(element,chartDef,data,chartHandler,axesDef){function prepareData(chartDef,chartData,measureFilter){const xLabels=chartData.getAxisLabels("x")||[];const colorLabels=chartData.getAxisLabels("color")||[null];const groupsData=[];let numberOfBins=0;xLabels.forEach(function(xLabel,x){const boxplots=[];colorLabels.forEach(function(colorLabel,c){chartDef.boxplotValue.forEach(function(measure,m){if(measureFilter&&!measureFilter(measure)){return}numberOfBins++;boxplots.push({color:c,measure:m,x:x})})});groupsData.push({x:x,boxplots:boxplots})});return{groupsData:groupsData,numberOfBins:numberOfBins}}const BOX_WIDTH=40;const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef);const{groupsData,numberOfBins}=prepareData(chartDef,chartData);const xLabels=(chartData.getAxisLabels("x")||[]).map(v=>({...v,label:ChartFormatting.getForOrdinalAxis(v.label)}));const colorLabels=chartData.getAxisLabels("color")||[];const hasColorDimension=ChartColorUtils.getColorDimensionOrMeasure(chartDef)!==undefined;const colorSpec={type:"DIMENSION",name:"color",dimension:chartDef.genericDimension1[0]};const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);const yExtent=ChartAxesUtils.initCustomAxisExtent(ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,ChartsStaticData.LEFT_AXIS_ID),[data.global.min,data.global.max]);const breakdownDimension=ChartDimension.getBreakdownDimension(chartDef);const xSpec={type:"DIMENSION",dimension:breakdownDimension,name:"x",customExtent:chartDef.xAxisFormatting.customExtent,mode:CHART_MODES.COLUMNS};const ySpec={id:yAxisID,type:"MEASURE",extent:yExtent,name:"y",customExtent:ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID),position:ChartYAxisPosition.LEFT};const colorScale=ChartColorScales.createColorScale({chartData:chartData,colorOptions:chartDef.colorOptions,defaultLegendDimension:chartDef.boxplotValue,colorSpec:colorSpec,chartHandler:chartHandler,theme:chartHandler.getChartTheme()});$(element).children().remove();const div=$(d3.selectAll(element).append("div")[0][0]);div.addClass("mainzone");const mainZone=$('<div style="width:100%; height: 100%;" />');$(div).append(mainZone);mainZone.addClass("horizontal-flex chart-wrapper");const globalSVG=d3.selectAll(mainZone).append("svg").attr("class","noflex")[0][0];const scrollableDiv=$(d3.selectAll(mainZone).append("div")[0][0]);scrollableDiv.addClass("flex");scrollableDiv.addClass("oa");const axisSpecs={x:xSpec,[yAxisID]:ySpec};chartDef.$axisSpecs=axisSpecs;const xAxis=xSpec.dimension?D3ChartAxes.createAxis(chartData,xSpec,false,chartDef.xAxisFormatting.isLogScale,undefined,chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting,chartDef):null;const includeZero=ChartAxesUtils.shouldIncludeZero(chartDef,yAxisID);const yAxis=D3ChartAxes.createAxis(chartData,ySpec,false,ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,ySpec.id),includeZero,ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,ySpec.id),chartDef);const yAxes=[yAxis];const{store,id}=ChartStoreFactory.getOrCreate(chartDef.$chartStoreId);chartDef.$chartStoreId=id;store.setAxisSpecs(axisSpecs);ChartLegendUtils.createLegend(element,chartDef,chartData,chartHandler,colorSpec,colorScale).then(()=>{$timeout(()=>{const mainSVG=d3.selectAll(scrollableDiv).append("svg")[0][0];const $svg=$(globalSVG);const BOX_PADDING=15;const INTER_BIN_PADDING=40;const BOX_TOTAL_WIDTH=BOX_WIDTH+2*BOX_PADDING;const leftAxisFormatting=chartDef.yAxesFormatting[0];const fontSize=ChartPropertiesService.showYAxis(leftAxisFormatting,chartHandler.chartTileProperties)?leftAxisFormatting.axisValuesFormatting.axisTicksFormatting.fontSize:0;let{margins}=D3ChartAxes.getMarginsAndAxesWidth(chartHandler,chartDef,$svg,xAxis,yAxes);const mAxisWidth=(BOX_WIDTH+BOX_PADDING)*numberOfBins+(BOX_PADDING+INTER_BIN_PADDING)*numberOfBins/(colorLabels.length||1);if(xAxis){xAxis.ordinalScale.rangeBands([0,mAxisWidth]);if(ChartPropertiesService.showXAxis(chartDef.xAxisFormatting,chartHandler.chartTileProperties)){margins=D3ChartAxes.adjustBottomMargin(chartDef.xAxisFormatting.axisValuesFormatting.axisTicksFormatting,margins,$svg,xAxis)}}const $mainZone=$(mainZone);margins.left=Math.min(margins.left,$mainZone.width()/6);margins.bottom+=ChartsStaticData.CHART_BASE_MARGIN;const globalBoxplotWidth=margins.left+BOX_TOTAL_WIDTH+ChartsStaticData.CHART_BASE_MARGIN;const availableHeight=$mainZone.height()-margins.bottom-margins.top;const globalG=d3.select(globalSVG).style("width",globalBoxplotWidth+"px").append("g").attr("transform",`translate(${margins.left}, ${margins.top})`);const mChartWidth=mAxisWidth+margins.left;const mainG=d3.select(mainSVG).style("width",mChartWidth+"px").append("g").attr("transform",`translate(${ChartsStaticData.CHART_BASE_MARGIN}, ${margins.top})`);const dataZoneHeight=availableHeight;const measureFormatters=ChartFormatting.createMeasureFormatters(chartDef,chartData,Math.max(availableHeight,mChartWidth));const tooltips=ChartTooltips.create(element,chartHandler,chartData,chartDef,measureFormatters);if(element.data("previous-tooltip")){element.data("previous-tooltip").destroy()}element.data("previous-tooltip",tooltips);angular.extend(chartHandler.tooltips,tooltips);mainZone.on("click",function(evt){if(evt.target.hasAttribute("data-legend")||evt.target.hasAttribute("tooltip-el")){return}tooltips.resetColors();tooltips.unfix()});const contextualMenu=ChartContextualMenu.create(chartData,chartDef,store);const yscale=yAxes[0].scale();yscale.range([dataZoneHeight,0]).domain(yExtent);function drawBoxplot(g,boxplot,yscale,plotMin,plotMax,color="#FFF",opacity=1,coords){g.selectAll("line.center").data([boxplot]).enter().append("line").attr("class","center").attr("y1",function(d){return yscale(d.lowWhisker)}).attr("x1",BOX_WIDTH/2).attr("y2",function(d){return yscale(d.highWhisker)}).attr("x2",BOX_WIDTH/2).style("opacity",1).style("stroke","#666");g.selectAll("rect.box").data([boxplot]).enter().append("rect").attr("class","box").attr("x",0).attr("width",BOX_WIDTH).attr("y",function(d){return yscale(d.pc75)}).attr("height",function(d){return Math.max(yscale(d.pc25)-yscale(d.pc75),0)}).attr("fill",color).attr("stroke","#666").style("opacity",opacity).each(function(){const chartDefPath="boxplotValue[0]";tooltips.registerEl(this,coords?angular.extend({},coords):undefined,coords?"fill":null,undefined,{additionalMeasures:[{displayLabel:ChartLabels.COUNT_OF_RECORDS_LABEL,value:boxplot.nbVAlid,chartDefPath:chartDefPath},{displayLabel:"Mean",value:boxplot.mean,chartDefPath:chartDefPath},{displayLabel:"Std. dev.",value:boxplot.stddev,chartDefPath:chartDefPath},{displayLabel:"Min",value:boxplot.min,chartDefPath:chartDefPath},{displayLabel:"1st quartile",value:boxplot.pc25,chartDefPath:chartDefPath},{displayLabel:"Median",value:boxplot.median,chartDefPath:chartDefPath},{displayLabel:"3rd quartile",value:boxplot.pc75,chartDefPath:chartDefPath},{displayLabel:"Max",value:boxplot.max,chartDefPath:chartDefPath}]});contextualMenu.addContextualMenuHandler(this,angular.extend({},coords))});g.selectAll("line.median").data([boxplot]).enter().append("line").attr("class","median").attr("val",boxplot.median).attr("x1",0).attr("y1",yscale(boxplot.median)).attr("x2",BOX_WIDTH).attr("y2",yscale(boxplot.median)).style("opacity",1).style("stroke","#666");g.selectAll("line.whisker").data([boxplot.lowWhisker,boxplot.highWhisker]).enter().append("svg:line").attr("class","whisker").attr("val",function(d){return d}).attr("x1",BOX_WIDTH*.3).attr("y1",function(d){return yscale(d)}).attr("x2",BOX_WIDTH*.7).attr("y2",function(d){return yscale(d)}).style("stroke","#666");if(plotMin!==undefined&&plotMax!==undefined){g.selectAll("circle.minmax").data([plotMin,plotMax]).enter().append("circle").attr("class","minmax").attr("transform",function(d){return"translate("+BOX_WIDTH/2+","+yscale(d)+")"}).attr("r",2).attr("fill","#999")}}drawBoxplot(globalG.append("g").attr("transform",`translate(${BOX_PADDING}, 0)`),data.global,yscale,data.global.min,data.global.max);let xAxisG;const allNegative=yAxes.every(yAxis=>{const currentYExtent=D3ChartAxes.getCurrentAxisExtent(yAxis);return!currentYExtent||currentYExtent[1]<0});if(xLabels.length){if(ChartPropertiesService.showXAxis(chartDef.xAxisFormatting,chartHandler.chartTileProperties)){xAxisG=mainG.insert("g",":first-child");xAxisG.attr("class","x axis").attr("transform",`translate(0, ${dataZoneHeight+ChartsStaticData.CHART_BASE_MARGIN})`);xAxis.orient("bottom");xAxisG.call(xAxis);if(xAxisG){xAxisG.selectAll(".tick text").attr("fill",chartDef.xAxisFormatting.axisValuesFormatting.axisTicksFormatting.fontColor).attr("font-size",chartDef.xAxisFormatting.axisValuesFormatting.axisTicksFormatting.fontSize)}if(xAxis.labelAngle){if(!allNegative){xAxisG.selectAll("text").attr("transform",(xAxis.labelAngle==Math.PI/2?"translate(-13, 9)":"translate(-10, 0)")+" rotate("+xAxis.labelAngle*-180/Math.PI+", 0, 0)").style("text-anchor","end")}else{xAxisG.selectAll("text").attr("transform","translate(10, 0) rotate("+xAxis.labelAngle*-180/Math.PI+", 0, 0)").style("text-anchor","start")}}}}groupsData.forEach(function(group){group.boxplots.forEach(coords=>{const bp=chartData.aggr(coords.measure).get(coords);const start=xAxis.scale().range()[coords.x]+INTER_BIN_PADDING/2;const g=mainG.append("g").attr("transform","translate("+(start+BOX_PADDING+coords.color*(BOX_WIDTH+BOX_PADDING))+", 0)");if(bp!=null){bp.label=xLabels[coords.x].label;if(hasColorDimension){bp.labelColor=colorLabels[coords.color].label}drawBoxplot(g,bp,yscale,bp.min,bp.max,colorScale(coords.color),chartDef.colorOptions.transparency,coords)}})});if(ChartPropertiesService.showYAxis(leftAxisFormatting,chartHandler.chartTileProperties)){const yAxis=yAxes[0];yAxis.orient("left");globalG.insert("g",":first-child").attr("class","y axis").call(yAxis);const yAxisG=d3.select(globalSVG).select("g.y.axis");if(yAxisG){yAxisG.selectAll(".tick text").attr("fill",leftAxisFormatting.axisValuesFormatting.axisTicksFormatting.fontColor).attr("font-size",fontSize);if(chartDef.gridlinesOptions.horizontal.show&&D3ChartAxes.shouldDrawGridlinesForAxis(chartDef.type,yAxis,chartDef.gridlinesOptions.horizontal.displayAxis)){let gridlinesPosition={x1:0,x2:ChartsStaticData.CHART_BASE_MARGIN+BOX_TOTAL_WIDTH,y1:0,y2:0};D3ChartAxes.drawGridlines(yAxisG,"y",chartDef.gridlinesOptions.horizontal.lineFormatting,gridlinesPosition,mainG);const linesG=d3.select(mainSVG).insert("g",":first-child");linesG.attr("transform",`translate(0, ${margins.top})`);gridlinesPosition={x1:0,x2:mChartWidth,y1:function(d){return yscale(d)},y2:function(d){return yscale(d)}};D3ChartAxes.appendGridlines(linesG.selectAll(".hline").data(yscale.ticks()).enter(),gridlinesPosition,chartDef.gridlinesOptions.horizontal.lineFormatting,"hline")}}}if(chartDef.gridlinesOptions.vertical.show&&xAxisG){const currentYExtent=D3ChartAxes.getCurrentAxisExtent(yAxes[0]);const allNegative=currentYExtent&&currentYExtent[1]<0;const gridlinesPosition={x1:0,x2:0,y1:0,y2:allNegative?dataZoneHeight+margins.top:-(dataZoneHeight+margins.top)};D3ChartAxes.drawGridlines(xAxisG,"x",chartDef.gridlinesOptions.vertical.lineFormatting,gridlinesPosition,mainG)}ChartLegendUtils.adjustLegendPlacement(chartDef,element,{top:margins.top,bottom:margins.bottom,left:BOX_WIDTH,right:ChartsStaticData.CHART_BASE_MARGIN});if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(mainG,mAxisWidth,dataZoneHeight);contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}})})}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("Density2DChart",function(ChartColorScales){const getUpdatedGByClass=function(svg,margins){d3.select(svg).selectAll("defs").remove();d3.select(svg).append("defs");d3.select(svg).selectAll("g").remove();return d3.select(svg).append("g").attr("class","chart").attr("transform","translate("+margins.left+","+margins.top+")")};return function(svg,chartDef,data,chartHandler){const width=$(svg).width();const height=$(svg).height();const margins={top:10,right:50,bottom:50,left:50};const chartWidth=width-margins.left-margins.right;const chartHeight=height-margins.top-margins.bottom;const g=getUpdatedGByClass(svg,margins);const xScale=d3.scale.linear().domain([data.xMin,data.xMax]).range([0,chartWidth]);const yScale=d3.scale.linear().domain([data.yMin,data.yMax]).range([chartHeight,0]);const xAxis=d3.svg.axis().scale(xScale).orient("bottom");const yAxis=d3.svg.axis().scale(yScale).orient("left");const colorScale=ChartColorScales.continuousColorScale(chartDef.colorOptions,data.minDensity,data.maxDensity,data.density,undefined,chartHandler.getChartTheme());const rectWidth=chartWidth/data.xSteps;const rectHeight=chartHeight/data.ySteps;g.selectAll(".densityrect").data(data.density).enter().append("rect").attr("class","densityrect").attr("yc",function(d,i){return Math.floor(i/data.xSteps)}).attr("yv",function(d,i){const yc=Math.floor(i/data.xSteps)+1;const yv=data.yMin+yc*(data.yMax-data.yMin)/data.ySteps;return yv}).attr("x",function(d,i){const xc=i%data.xSteps;const xv=data.xMin+xc*(data.xMax-data.xMin)/data.xSteps;return xScale(xv)}).attr("y",function(d,i){const yc=Math.floor(i/data.xSteps)+1;const yv=data.yMin+yc*(data.yMax-data.yMin)/data.ySteps;return yScale(yv)}).attr("width",rectWidth).attr("height",rectHeight).attr("fill",function(d){return colorScale(d)}).attr("stroke",function(d){return colorScale(d)});g.append("g").attr("class","x axis").style("fill","#999").style("stroke","#999").attr("transform","translate(0,"+chartHeight+")").call(xAxis);const xAxisG=g.select("g.x.axis");if(xAxisG){xAxisG.selectAll(".tick text").attr("fill","#333").attr("font-size",11)}g.append("g").attr("class","y axis").style("fill","#999").style("stroke","#999").call(yAxis);const yAxisG=g.select("g.y.axis");if(yAxisG){yAxisG.selectAll(".tick text").attr("fill","#333").attr("font-size",11)}chartHandler.legendsWrapper.deleteLegends();if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("KpiChart",function(ChartCustomMeasures,ChartUsableColumns,ColumnAvailability){return function(element,scope,chartDef,theme){const dataSpec=scope.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,scope.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,scope.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);scope.$broadcast("window-resized-kpi",{theme:theme})}})})();(function(){"use strict";angular.module("dataiku.charts").factory("LiftChart",LiftChart);function LiftChart(ChartManager,ChartDataWrapperFactory,ColorUtils,ChartDataUtils,SVGUtils,ChartAxesUtils,ChartYAxisPosition,ChartHierarchyDimension,ChartDrilldown){return function($container,chartDef,chartHandler,axesDef,data){const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef),facetLabels=chartData.getAxisLabels("facet")||[null],xExtent=ChartDataUtils.getMeasureExtent(chartData,0),yExtent=ChartDataUtils.getMeasureExtent(chartData,1),color=ColorUtils.toRgba(chartDef.colorOptions.singleColor,chartDef.colorOptions.transparency);xExtent[0]=0;yExtent[0]=0;const lineData=["ORIGIN"].concat(chartData.getAxisLabels("group"));const drawFrame=function(frameIdx,chartBase){chartData.fixAxis("animation",frameIdx);facetLabels.forEach(function(facetLabel,f){const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));LiftChartDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",f),chartBase,f)})};const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,{x:{type:"MEASURE",extent:xExtent,measure:chartDef.xMeasure,customExtent:chartDef.xAxisFormatting.customExtent},[yAxisID]:{id:yAxisID,type:"MEASURE",extent:yExtent,measure:chartDef.yMeasure,customExtent:ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID),position:ChartYAxisPosition.LEFT}});function LiftChartDrawer(g,chartDef,chartHandler,chartData,chartBase,f){const xCoord=function(d,i){const v=d==="ORIGIN"?0:chartData.aggr(0).get({group:i-1});return chartBase.xAxis.scale()(v)};const yCoord=function(d,i){const v=d==="ORIGIN"?0:chartData.aggr(1).get({group:i-1});return chartBase.yAxes[0].scale()(v)};const line=d3.svg.line().interpolate("monotone").x(xCoord).y(yCoord);const lineWrapper=g.selectAll("g.wrapper").data([null]);const newWrapper=lineWrapper.enter().append("g").attr("class","wrapper");newWrapper.append("path").attr("class","visible").attr("stroke",color).attr("stroke-width","1.5").attr("fill","none");newWrapper.append("path").attr("stroke-width","20").attr("stroke","transparent").attr("fill","none");const medianLine=lineWrapper.selectAll("line.median").data([null]);medianLine.enter().append("line").attr("class","median").attr("x1",xCoord("ORIGIN",0)).attr("y1",yCoord("ORIGIN",0)).style("stroke","#333");medianLine.interrupt("updateMedianLine").transition("updateMedianLine").attr("x2",xCoord(null,lineData.length-1)).attr("y2",yCoord(null,lineData.length-1));const points=lineWrapper.selectAll("circle.point").data(lineData);points.enter().append("circle").attr("class","point").attr("r",5).attr("fill",color).attr("opacity",0).each(function(d,i){if(i===0){return 0}else{chartBase.tooltips.addTooltipHandlers(this,{group:i-1,facet:f},color);chartBase.contextualMenu.addContextualMenuHandler(this,{group:i-1,facet:f});return 1}});points.interrupt("movePoints").transition("movePoints").attr("cx",xCoord).attr("cy",yCoord);lineWrapper.selectAll("path").datum(lineData).interrupt("updatePath").transition("updatePath").attr("d",line);lineWrapper.on("mouseover.path",function(d){lineWrapper.select("path.visible").attr("stroke-width",3);points.interrupt("fade").transition("fade").attr("opacity",function(d,i){return i===0?0:1})}).on("mouseout.path",function(d){lineWrapper.select("path.visible").attr("stroke-width",1.5);points.interrupt("fade").transition("fade").attr("opacity",0)});ChartAxesUtils.isCroppedChart(chartDef)&&SVGUtils.clipPaths(chartBase,g,lineWrapper);if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}}chartHandler.legendsWrapper.deleteLegends()}}})();(function(){"use strict";angular.module("dataiku.charts").factory("PieChartDrawer",PieChartDrawer);function PieChartDrawer(PieChartUtils,d3Utils,ChartLabels,VALUES_DISPLAY_MODES,ChartHierarchyDimension,SVGUtils,ChartDrilldown){return function(g,chartDef,chartBase,facetData,numberFormattingOptions){const displayValuesOrLabels=chartDef.valuesInChartDisplayOptions&&chartDef.valuesInChartDisplayOptions.displayPieLabelsOrValues;let outerR=Math.min(chartBase.vizWidth,chartBase.vizHeight)/2;let r=displayValuesOrLabels?outerR-40:outerR;const center={x:chartBase.vizWidth/2,y:chartBase.vizHeight/2};const viz=g.selectAll("g.viz").data([null]);viz.enter().append("g").attr("class","viz");viz.attr("transform","translate("+center.x+","+center.y+")");const arc=d3.svg.arc().outerRadius(r);const wrappers=viz.selectAll("g.wrapper").data(facetData.pie||[],function(d){return d.data.color+"-"+d.data.measure});const newWrappers=wrappers.enter().append("g").attr("class","wrapper");const drawHole=function(){const hole=g.selectAll("circle.hole").data([null]);if(chartDef.variant==="donut"){let holeRadius=r/2;if(chartDef.pieOptions&&chartDef.pieOptions.donutHoleSize&&0<chartDef.pieOptions.donutHoleSize&&chartDef.pieOptions.donutHoleSize<100){holeRadius=r*chartDef.pieOptions.donutHoleSize/100}hole.enter().append("circle").attr("class","hole").attr("cx",center.x).attr("cy",center.y).attr("r",holeRadius).style("fill","white");hole.attr("r",holeRadius)}else{hole.remove()}};if(displayValuesOrLabels){const colorDimensionMin=chartBase.chartData.getMinValue("color");const colorDimensionMax=chartBase.chartData.getMaxValue("color");const colorDimensionNumValues=chartBase.chartData.getNumValues("color");const outerArc=d3.svg.arc().innerRadius(r).outerRadius(outerR);const svgBoundingBox=$(g.node()).closest("svg").get(0).getBoundingClientRect();let maxOverflow=0;const transformLabels=function(sel){return sel.attr("transform",function(d){return"translate("+outerArc.centroid(d)+")"})};newWrappers.append("text").attr("class","pie-chart-label").call(transformLabels);const texts=wrappers.select("text.pie-chart-label");texts.text(function(d){let text="";switch(chartDef.valuesInChartDisplayOptions.displayMode){case VALUES_DISPLAY_MODES.VALUES_AND_LABELS:text+=ChartLabels.getFormattedLabel(chartBase.chartData.getAxisLabels("color")[d.data.color],numberFormattingOptions,colorDimensionMin,colorDimensionMax,colorDimensionNumValues);text+=" - "+chartBase.measureFormatters[d.data.measure](d.data.value);break;case VALUES_DISPLAY_MODES.LABELS:text+=ChartLabels.getFormattedLabel(chartBase.chartData.getAxisLabels("color")[d.data.color],numberFormattingOptions,colorDimensionMin,colorDimensionMax,colorDimensionNumValues);break;case VALUES_DISPLAY_MODES.VALUES:text+=chartBase.measureFormatters[d.data.measure](d.data.value);break}return text}).attr("text-anchor",function(d){const middleAngle=d.startAngle+(d.endAngle-d.startAngle)/2;if(middleAngle>Math.PI){return"end"}else{return"start"}}).attr("fill","#666").style("display",function(d){return d.data.value>0?"block":"none"}).interrupt("updateLabels").transition("updateLabels").call(transformLabels).call(d3Utils.endAll,function(){if(maxOverflow>0){outerR=Math.max(75,outerR-maxOverflow);r=outerR-40;arc.outerRadius(r);outerArc.innerRadius(r).outerRadius(outerR)}texts.call(transformLabels);PieChartUtils.hideOverlappingLabels(wrappers[0],(facetData.pie||[]).map(function(d){return d.data.value}),facetData.total);drawHole()},function(d,i){if(d.data.value===0){return}const boundingBox=this.getBoundingClientRect();maxOverflow=Math.max(maxOverflow,svgBoundingBox.left-boundingBox.left,boundingBox.right-svgBoundingBox.right)})}else{drawHole()}const noData=viz.selectAll("text.no-data").data([null]);noData.enter().append("text").attr("class","no-data").attr("text-anchor","middle").style("pointer-events","none").style("font-size","20px").text("No data");newWrappers.append("path").attr("class","slice").each(function(d){this._current=d}).attr("fill",function(d){return chartBase.colorScale(d.data.color+d.data.measure)}).attr("opacity",chartDef.colorOptions.transparency).each(function(d){chartBase.tooltips.registerEl(this,{measure:d.data.measure,color:d.data.color,animation:d.data.animation,facet:d.data.facet},"fill");chartBase.contextualMenu.addContextualMenuHandler(this,{color:d.data.color,animation:d.data.animation,facet:d.data.facet})});const slices=wrappers.select("path.slice");function arcTween(a){const i=d3.interpolate(this._current,a);this._current=i(0);return function(t){return arc(i(t))}}if(facetData.total>0){wrappers.style("pointer-events","none").interrupt("fade").transition("fade").attr("opacity",1);slices.style("pointer-events","all").interrupt("fade").transition("fade").attrTween("d",arcTween);noData.interrupt("fade").transition("fade").attr("opacity",0)}else{noData.interrupt("fade").transition("fade").attr("opacity",1);wrappers.exit().style("pointer-events","none").interrupt("fade").transition("fade").attr("opacity",0)}drawHole();if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("PieChartUtils",PieChartUtils);function PieChartUtils($filter){const that={prepareData:function(chartDef,chartData){const colorLabels=chartData.getAxisLabels("color")||[null],facetLabels=chartData.getAxisLabels("facet")||[null],animationLabels=chartData.getAxisLabels("animation")||[null],pie=d3.layout.pie().value(function(d){return d.value});const animationData={frames:[]};animationLabels.forEach(function(animationLabel,a){chartData.fixAxis("animation",a);const frameData={facets:[]};facetLabels.forEach(function(facetLabel,f){chartData.fixAxis("facet",f);const facetData={slices:[],total:0};colorLabels.forEach(function(colorLabel,c){chartData.fixAxis("color",c);chartDef.genericMeasures.forEach(function(measure,m){const d=chartData.aggr(m).get();if(d<0){throw new ChartIAE("Cannot represent negative values on a pie chart. Please use another chart.")}facetData.slices.push({color:c,measure:m,facet:f,animation:a,count:chartData.getCount(),valuesInChartDisplayOptions:measure.valuesInChartDisplayOptions,value:d});facetData.total+=d});if(facetData.total>0){facetData.slices=$filter("orderBy")(facetData.slices,"value",true);facetData.pie=pie(facetData.slices)}});frameData.facets.push(facetData)});animationData.frames.push(frameData)});return animationData},hideOverlappingLabels:function(slices,values,total){if(slices.length<2){return}const displayedLabelSlices=[];const displayedLabelValues=[];slices.forEach(function(slice,i){if($(slice).find("text").css("display")!=="none"){const sliceValue=values[i];const nextSliceIndex=i===slices.length-1?0:i+1;const nextSlice=slices[nextSliceIndex];if(that.slicesOverlap(slice,nextSlice)){const nextSliceValue=values[nextSliceIndex];const diff=sliceValue>=nextSliceValue?sliceValue-nextSliceValue:nextSliceValue-sliceValue;const diffAngle=360*diff/total;if(diffAngle<5){$(slice).find("text").hide();$(nextSlice).find("text").hide()}else{const smallerSlice=sliceValue>nextSliceValue?nextSlice:slice;$(smallerSlice).find("text").hide();if(sliceValue>nextSliceValue){displayedLabelSlices.push(slice);displayedLabelValues.push(sliceValue)}}}else{displayedLabelSlices.push(slice);displayedLabelValues.push(sliceValue)}}});if(slices.length!==displayedLabelSlices.length){that.hideOverlappingLabels(displayedLabelSlices,displayedLabelValues)}},slicesOverlap:function(slice1,slice2){const top1=$(slice1).find("text").offset().top;const left1=$(slice1).find("text").offset().left;const bottom1=top1+$(slice1).find("text")[0].getBoundingClientRect().height;const right1=left1+$(slice1).find("text")[0].getBoundingClientRect().width;const top2=$(slice2).find("text").offset().top;const left2=$(slice2).find("text").offset().left;const bottom2=top2+$(slice2).find("text")[0].getBoundingClientRect().height;const right2=left2+$(slice2).find("text")[0].getBoundingClientRect().width;let hOverlapping;if(left1<=left2){hOverlapping=right1>=left2}else{hOverlapping=right2>=left1}let vOverlapping;if(top1<=top2){vOverlapping=bottom1>=top2}else{vOverlapping=bottom2>=top1}return hOverlapping&&vOverlapping}};return that}})();(function(){"use strict";angular.module("dataiku.charts").factory("PieChart",PieChart);function PieChart(ChartManager,ChartDataWrapperFactory,PieChartUtils,PieChartDrawer,ChartDimension,ChartColorUtils){return function($container,chartDef,chartHandler,axesDef,data){const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef);const colorDimension=ChartColorUtils.getColorDimensionOrMeasure(chartDef);const animationData=PieChartUtils.prepareData(chartDef,chartData);const numberFormattingOptions=ChartDimension.getNumberFormattingOptions(colorDimension);const drawFrame=function(frameIdx,chartBase){animationData.frames[frameIdx].facets.forEach(function(facetData,f){const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));PieChartDrawer(g,chartDef,chartBase,facetData,numberFormattingOptions)})};ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,null,{type:"DIMENSION",name:"color",dimension:colorDimension})}}})();(function(){"use strict";angular.module("dataiku.charts").factory("BinnedXYChart",BinnedXYChart);function BinnedXYChart(ChartManager,ChartDataWrapperFactory,BinnedXYUtils,d3Utils,D3ChartAxes,ChartDataUtils,ChartAxesUtils,SVGUtils,ChartYAxisPosition,ChartHierarchyDimension,ChartDimension,ChartDrilldown){return function($container,chartDef,chartHandler,axesDef,data){const xDimension=ChartDimension.getXDimension(chartDef);const yDimension=ChartDimension.getYDimension(chartDef);const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef),facetLabels=chartData.getAxisLabels("facet")||[null],pointsData=BinnedXYUtils.prepareData(chartData),yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT),yCustomExtent=ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID);const sizeMeasure=chartDef.sizeMeasure.length?0:-1,colorMeasure=chartDef.colorMeasure.length&&chartDef.sizeMeasure.length?1:chartDef.colorMeasure.length?0:-1;let sizeScale=null,colorScale=null;if(sizeMeasure>=0){if(chartDef.variant=="binned_xy_hex"){sizeScale=d3.scale.pow().exponent(.5).domain(ChartDataUtils.getMeasureExtent(chartData,sizeMeasure,true)).range([10,chartDef.hexbinRadius])}else{sizeScale=d3.scale.sqrt().domain(ChartDataUtils.getMeasureExtent(chartData,sizeMeasure,true))}chartDef.sizeMeasure.$mIdx=sizeMeasure}if(colorMeasure>=0){chartDef.colorMeasure.$mIdx=colorMeasure}if(chartDef.variant==="binned_xy_hex"){ChartAxesUtils.resetCustomExtents([chartDef.xAxisFormatting]);ChartAxesUtils.resetCustomExtents(chartDef.yAxesFormatting)}const drawFrame=function(frameIdx,chartBase){chartData.fixAxis("animation",frameIdx);facetLabels.forEach(function(facetLabel,f){const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));if(chartDef.variant=="binned_xy_hex"){HexBinnedXYChartDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",f),chartBase,pointsData,f)}else if(chartDef.variant==="binned_xy_rect"){RectBinnedXYChartDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",f),chartBase,pointsData,f)}else{BinnedXYChartDrawer(g,chartDef,chartHandler,chartData.fixAxis("facet",f),chartBase,pointsData,f)}})};ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,{x:{type:"DIMENSION",mode:"POINTS",padding:1,dimension:xDimension,name:"x",customExtent:chartDef.xAxisFormatting.customExtent},[yAxisID]:{id:yAxisID,type:"DIMENSION",mode:"POINTS",padding:1,dimension:yDimension,name:"y",customExtent:yCustomExtent,position:ChartYAxisPosition.LEFT}},{type:"MEASURE",measureIdx:colorMeasure});function getPointColor(d){if(colorScale){return colorScale(chartData.aggr(colorMeasure).get(d))}else{return chartDef.colorOptions.singleColor}}function getCustomExtentFraction(chartDef,yAxisID){const yFraction=ChartAxesUtils.getCustomExtentRatio(ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID));const xFraction=ChartAxesUtils.getCustomExtentRatio(chartDef.xAxisFormatting.customExtent);return Math.min(yFraction,xFraction)}function addBackgroundContextualMenuHandler(g,chartBase){const xHierarchyLevel=ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef,"x");const yHierarchyLevel=ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef,"y");if(xHierarchyLevel>0||yHierarchyLevel>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}}function getRangeStep(axisName,axis,chartData){if(axis.scaleType!==D3ChartAxes.scaleTypes.ORDINAL){const labels=chartData.getAxisLabels(axisName);if(labels.length){const label=axis.scaleType===D3ChartAxes.scaleTypes.LOG?labels[labels.length-1]:labels[0];if(label&&label.min!==label.max){const scale=axis.scale();return Math.abs(scale(label.min)-scale(label.max))}}}return d3Utils.getOrdinalScaleRangeStep(axis.ordinalScale)}function getPosition(axisName,axis,chartData,value){if(axis.scaleType!==D3ChartAxes.scaleTypes.ORDINAL){const axisLabel=chartData.getAxisLabels(axisName)[value];if(axisLabel.tsValue){return axis.scale()((axisLabel.min+axisLabel.max)/2)}return axis.scale()(axisLabel.sortValue)}return axis.ordinalScale(value)}function BinnedXYChartDrawer(g,chartDef,chartHandler,chartData,chartBase,pointsData,f){const xStep=getRangeStep("x",chartBase.xAxis,chartData);const yStep=getRangeStep("y",chartBase.yAxes[0],chartData);const radius=Math.min(xStep/3.5,yStep/3.5);if(sizeMeasure>=0){sizeScale.range([1,Math.min(xStep/2,yStep/2)])}if(colorMeasure>=0){colorScale=chartBase.colorScale}let wrapper=g.selectAll("g.points-wrapper");if(wrapper.empty()){g.append("g").attr("class","points-wrapper");wrapper=g.selectAll("g.points-wrapper")}const points=wrapper.selectAll("circle.point").data(pointsData,function(d){return d.x+"-"+d.y});points.enter().append("circle").attr("class","point").attr("transform",function(d){return"translate("+getPosition("x",chartBase.xAxis,chartData,d.x)+","+getPosition("y",chartBase.yAxes[0],chartData,d.y)+")"}).attr("fill",getPointColor).attr("opacity",chartDef.colorOptions.transparency).each(function(d){chartBase.tooltips.addTooltipHandlers(this,angular.extend({},d,{facet:f}),getPointColor(d));chartBase.contextualMenu.addContextualMenuHandler(this,angular.extend({},d,{facet:f}))});points.interrupt("updateCircles").transition("updateCircles").attr("r",function(d){if(chartData.getCount(d)>0){if(sizeScale){return Math.max(0,Math.ceil(sizeScale(chartData.aggr(sizeMeasure).get(d))*getCustomExtentFraction(chartDef,chartBase.yAxes[0].id)))}else{return radius}}else{return 0}}).attr("fill",getPointColor);ChartAxesUtils.isCroppedChart(chartDef)&&SVGUtils.clipPaths(chartBase,g,wrapper);addBackgroundContextualMenuHandler(g,chartBase)}function RectBinnedXYChartDrawer(g,chartDef,chartHandler,chartData,chartBase,pointsData,f){const xStep=getRangeStep("x",chartBase.xAxis,chartData);const yStep=getRangeStep("y",chartBase.yAxes[0],chartData);let widthScale,heightScale;if(sizeMeasure>=0){widthScale=sizeScale.copy().range([.1*xStep,xStep]);heightScale=sizeScale.copy().range([.1*yStep,yStep])}if(colorMeasure>=0){colorScale=chartBase.colorScale}const rectWidth=function(d){if(chartData.getCount(d)>0){if(widthScale){return Math.max(0,Math.ceil(widthScale(chartData.aggr(sizeMeasure).get(d))*getCustomExtentFraction(chartDef,chartBase.yAxes[0].id)))}else{return xStep}}else{return 0}};const rectHeight=function(d){if(chartData.getCount(d)>0){if(heightScale){return Math.max(0,Math.ceil(heightScale(chartData.aggr(sizeMeasure).get(d))*getCustomExtentFraction(chartDef,chartBase.yAxes[0].id)))}else{return yStep}}else{return 0}};const points=g.selectAll("rect.point").data(pointsData,function(d){return d.x+"-"+d.y});points.enter().append("rect").attr("class","point").attr("fill",getPointColor).attr("opacity",chartDef.colorOptions.transparency).each(function(d){chartBase.tooltips.addTooltipHandlers(this,angular.extend({},d,{facet:f}),getPointColor(d));chartBase.contextualMenu.addContextualMenuHandler(this,angular.extend({},d,{facet:f}))});points.interrupt("updateRectangles").transition("updateRectangles").attr("x",function(d){const x=getPosition("x",chartBase.xAxis,chartData,d.x);return x-rectWidth(d)/2}).attr("y",function(d){const y=getPosition("y",chartBase.yAxes[0],chartData,d.y);return y-rectHeight(d)/2}).attr("width",rectWidth).attr("height",rectHeight).attr("fill",getPointColor);ChartAxesUtils.isCroppedChart(chartDef)&&SVGUtils.clipPaths(chartBase,g,points);addBackgroundContextualMenuHandler(g,chartBase)}function HexBinnedXYChartDrawer(g,chartDef,chartHandler,chartData,chartBase,pointsData,f){if(colorMeasure>=0){colorScale=chartBase.colorScale}const radius=BinnedXYUtils.getRadius(chartDef,chartHandler.request.$expectedVizWidth,chartHandler.request.$expectedVizHeight);if(sizeScale){sizeScale.range([3,radius])}function hexagon(radius){const d3_hexbinAngles=d3.range(0,2*Math.PI,Math.PI/3);let x0=0,y0=0;return d3_hexbinAngles.map(function(angle){const x1=Math.sin(angle)*radius,y1=-Math.cos(angle)*radius,dx=x1-x0,dy=y1-y0;x0=x1;y0=y1;return[dx,dy]})}function hexagonPath(radius){return"m"+hexagon(radius).join("l")+"z"}const mainZone={g:g.selectAll("g.mainzone").data([null]),width:chartBase.vizWidth,height:chartBase.vizHeight,x:0,y:chartHandler.request.$expectedVizHeight-chartBase.vizHeight,getScaleX(){return chartBase.vizWidth/chartHandler.request.$expectedVizWidth},getScaleY(){return this.height/chartHandler.request.$expectedVizHeight}};mainZone.g.enter().append("g").attr("class","mainzone");mainZone.g.attr("transform","scale("+mainZone.getScaleX()+", "+mainZone.getScaleY()+") translate("+mainZone.x+", "+mainZone.y+")");const hexagons=mainZone.g.selectAll("path.hexagon").data(pointsData,function(d){return d.x+"-"+d.y});function formatHexagons(sel){return sel.attr("transform",function(d){let hexagonX=d.x*radius*2*Math.sin(Math.PI/3);const hexagonY=mainZone.height-d.y*radius*1.5;if(d.y%2==1){hexagonX+=Math.sin(Math.PI/3)*radius}return"translate("+(hexagonX+parseInt(radius))+","+(hexagonY-parseInt(radius))+")"}).attr("d",function(d){if(chartData.getCount(d)>0){if(sizeScale){return hexagonPath(sizeScale(chartData.aggr(sizeMeasure).get(d)))}else{return hexagonPath(radius)}}else{return"m0,0z"}}).attr("fill",getPointColor)}hexagons.enter().append("path").attr("class","hexagon").call(formatHexagons).attr("opacity",chartDef.colorOptions.transparency).each(function(d){chartBase.tooltips.addTooltipHandlers(this,angular.extend({},d,{facet:f}),getPointColor(d));chartBase.contextualMenu.addContextualMenuHandler(this,angular.extend({},d,{facet:f}))});hexagons.exit().remove();hexagons.interrupt("updateHexagons").transition("updateHexagons").call(formatHexagons)}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("BinnedXYUtils",BinnedXYUtils);function BinnedXYUtils(){return{prepareData:function(chartData){const xLabels=chartData.getAxisLabels("x"),yLabels=chartData.getAxisLabels("y"),points=[];xLabels.forEach(function(xLabel,x){yLabels.forEach(function(yLabel,y){points.push({x:x,y:y})})});return points},getRadius:function(chartDef,chartWidth,chartHeight){switch(chartDef.hexbinRadiusMode){case"ABSOLUTE":return chartDef.hexbinRadius;case"NUM_HEXAGONS":if(chartWidth<chartHeight){const hexWidth=Math.floor(chartWidth/chartDef.hexbinNumber);return hexWidth/(2*Math.cos(Math.PI/6))}else{const hexHeight=Math.floor(chartHeight/chartDef.hexbinNumber);return hexHeight/1.5}default:throw new Error("Unknown hexBinRadiusMode: "+chartDef.hexbinRadiusMode)}}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("GroupedXYChart",GroupedXYChart);function GroupedXYChart(ChartManager,ChartDataWrapperFactory,ColorUtils,ChartDataUtils,SVGUtils,ChartAxesUtils,ChartYAxisPosition,ChartHierarchyDimension,ChartDrilldown){return function($container,chartDef,chartHandler,axesDef,data){const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef),facetLabels=chartData.getAxisLabels("facet")||[null];const xMeasure=0,yMeasure=1,sizeMeasure=chartDef.sizeMeasure.length?2:-1,colorMeasure=chartDef.colorMeasure.length&&chartDef.sizeMeasure.length?3:chartDef.colorMeasure.length?2:-1,color=ColorUtils.toRgba(chartDef.colorOptions.singleColor,chartDef.colorOptions.transparency);let sizeScale;if(sizeMeasure>=0){sizeScale=d3.scale.sqrt().domain(ChartDataUtils.getMeasureExtent(chartData,sizeMeasure,true)).range([Math.min(10,chartDef.bubblesOptions.defaultRadius),Math.max(10,chartDef.bubblesOptions.defaultRadius)]);chartDef.sizeMeasure.$mIdx=sizeMeasure}if(colorMeasure>=0){chartDef.colorMeasure.$mIdx=colorMeasure}const drawFrame=function(frameIdx,chartBase){chartData.fixAxis("animation",frameIdx);facetLabels.forEach(function(facetLabel,f){const g=d3.select(chartBase.$svgs.eq(f).find("g.chart").get(0));GroupedXYChartDrawer(g,chartDef,chartData.fixAxis("facet",f),chartBase,f)});if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}};const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,{x:{type:"MEASURE",measureIdx:xMeasure,measure:chartDef.xMeasure,customExtent:chartDef.xAxisFormatting.customExtent},[yAxisID]:{id:yAxisID,type:"MEASURE",measureIdx:yMeasure,measure:chartDef.yMeasure,customExtent:ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID),position:ChartYAxisPosition.LEFT}},{type:"MEASURE",measureIdx:colorMeasure,measure:chartDef.colorMeasure,withRgba:true});function GroupedXYChartDrawer(g,chartDef,chartData,chartBase,f){function getBubbleColor(d){if(colorMeasure>=0){return chartBase.colorScale(chartData.aggr(colorMeasure).get({group:d.$i}))}else{return color}}const bubbleNonNullCounts=[];const bubbles=g.selectAll("circle").data(chartData.getAxisLabels("group"),(_,i)=>{const coords={group:i,facet:f};bubbleNonNullCounts.push(chartDef.xMeasure?.some(axis=>chartData.isBinMeaningful(axis.function,coords,0))||chartDef.yMeasure?.some(axis=>chartData.isBinMeaningful(axis.function,coords,1)));return i});bubbles.enter().append("circle").attr("fill",getBubbleColor).each(function(d,i){const coords={group:i,facet:f};d.$i=i;chartBase.tooltips.addTooltipHandlers(this,coords,getBubbleColor(d,i));chartBase.contextualMenu.addContextualMenuHandler(this,coords)});bubbles.filter(d=>!bubbleNonNullCounts[d.$i]).interrupt("fadeOutNullCountBubbles").transition("fadeOutNullCountBubbles").duration((chartDef.animationFrameDuration||3e3)/2).attr("opacity",0).attr("cx",null).attr("cy",null).attr("r",null);bubbles.filter(d=>!!bubbleNonNullCounts[d.$i]).interrupt("fadeInNonNullCountBubbles").transition("fadeInNonNullCountBubbles").duration((chartDef.animationFrameDuration||3e3)/2).attr("opacity",1).attr("cx",function(d){return chartBase.xAxis.scale()(chartData.aggr(xMeasure).get({group:d.$i}))}).attr("cy",function(d){return chartBase.yAxes[0].scale()(chartData.aggr(yMeasure).get({group:d.$i}))}).attr("r",function(d){if(sizeScale){return sizeScale(chartData.aggr(sizeMeasure).get({group:d.$i}))}else{return chartDef.bubblesOptions.defaultRadius}}).attr("fill",getBubbleColor);ChartAxesUtils.isCroppedChart(chartDef)&&SVGUtils.clipPaths(chartBase,g,bubbles);if(ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef)>0){const anchor=SVGUtils.addPlotAreaContextMenuAnchor(g,chartBase.vizWidth,chartBase.vizHeight);chartBase.contextualMenu.addChartContextualMenuHandler(anchor.node(),undefined,()=>ChartDrilldown.getDrillupActions(chartDef))}}}}})();(function(){"use strict";angular.module("dataiku.charts").factory("ScatterPlotChartDrawerWebGl",ScatterPlotChartDrawerWebGl);function ScatterPlotChartDrawerWebGl(UaChartsCommon,ColorUtils,ChartDataUtils,ChartDimension,ChartColorUtils,ChartFeatures,ChartUADimension,D3ChartAxes,ReferenceLines,RegressionLine,ChartZoomControlAdapter,CHART_ZOOM_CONTROL_TYPES,CHART_TYPES,ChartAxesUtils,ChartUsableColumns,ChartsStaticData,ChartCustomMeasures,ScatterUtils,$timeout,ChartIconUtils,ConnectPointsSplitOptions,Logger,ChartPropertiesService){return function(container,chartDef,chartHandler,chartData,chartBase,uiDisplayState){const g=d3.select(chartBase.$svgs.get(0));const multiple=chartDef.type===CHART_TYPES.SCATTER_MULTIPLE_PAIRS;const visibleCountMap=new Map;const axisPairs=chartData.prepareAxisPairs(chartDef,chartHandler.getChartTheme());const kdbushs=new Array(axisPairs.length);const foreignObject=g.append("foreignObject").attr("x",chartBase.margins.left).attr("y",chartBase.margins.top).attr("width",chartBase.vizWidth).attr("height",chartBase.vizHeight);const $body=$("<div>").css("height","100%").css("width","100%").appendTo(foreignObject.node());const loading=document.createElement("p");loading.className="scatter-loading-indicator";loading.setAttribute("style","position: relative; top: 50%; text-align: center");loading.innerText="Loading points, please wait";$body.append(loading);const thumbnailState={shouldUpdate:false};const series=[];let highlightPointSerie;let tooltipHighlight=false;function isTooltipsReady(){return kdbushs.filter(index=>index).length===axisPairs.length}function updateSamplingInfo(){series.forEach((serie,index)=>{const xDomain=serie.xScale().domain();const yDomain=serie.yScale().domain();visibleCountMap.set(index,kdbushs[index].range(xDomain[0],yDomain[0],xDomain[xDomain.length-1],yDomain[yDomain.length-1]).length)});uiDisplayState.chartTopRightLabel=ChartDataUtils.computeRecordsStatusLabel(chartData.getBeforeFilterRecords(),chartData.getAfterFilterRecords(),ChartDimension.getComputedMainAutomaticBinningModeLabel(chartData.getData(),chartDef,chartBase.zoomUtils&&chartBase.zoomUtils.disableChartInteractivityGlobally),visibleCountMap,chartDef.type);uiDisplayState.chartRecordsFinalCountTooltip=ChartDataUtils.getRecordsFinalCountTooltip(chartDef.type,chartData.getAfterFilterRecords(),chartData.data.axesPairs,visibleCountMap);uiDisplayState.samplingSummaryMessage=ChartDataUtils.getSamplingSummaryMessage(chartData.getData(),chartDef.type,undefined,visibleCountMap)}const getIndexBuilder=()=>{const worker=new Worker("/static/dataiku/js/scatterplot-tooltips.worker.js");return worker};const buildTooltipsIndex=(axesDef,axisPairs)=>{const workers=[];axisPairs.forEach((pair,pairIndex)=>{chartHandler.uiDisplayState.isBuildingTooltips=true;const axisDef=axesDef[pairIndex];const xType=ChartUADimension.getUnaggregatedDimensionType(axisDef.xDim);const yType=ChartUADimension.getUnaggregatedDimensionType(axisDef.yDim);const worker=getIndexBuilder();worker.postMessage({pair:pair,pairDef:{x:xType,y:yType}});worker.onmessage=e=>{kdbushs[pairIndex]=KDBush.from(e.data);if(isTooltipsReady()){chartHandler.uiDisplayState.isBuildingTooltips=false;updateSamplingInfo()}worker.terminate()};workers.push(worker)})};const getDataAxesPairs=data=>{if(multiple){return data.axesPairs}return[{afterFilterRecords:data.afterFilterRecords,values:data.values,xAxis:data.xAxis,yAxis:data.yAxis}]};const createCanvas=(id,className,use2dCanvas=false)=>{const canvas=document.createElement("d3fc-canvas");canvas.setAttribute("id",id);canvas.setAttribute("use-device-pixel-ratio","");if(!use2dCanvas){canvas.setAttribute("set-webgl-viewport","")}canvas.className=typedPlotArea(className);canvas.style.height="100%";canvas.style.width="100%";return canvas};buildTooltipsIndex(axisPairs,getDataAxesPairs(chartData.data));const xScale=ScatterUtils.convertScale(chartBase.xAxis);const yScale=ScatterUtils.convertScale(chartBase.yAxes[0]);const xRangeSize=Math.abs(xScale.range()[0]-xScale.range()[1]);const yRangeSize=Math.abs(yScale.range()[0]-yScale.range()[1]);const typedPlotArea=type=>`${type}-plot-area plot-area`;const group=document.createElement("d3fc-group");group.setAttribute("auto-resize",true);group.setAttribute("id","d3fc-group-scatter");if(chartDef.scatterOptions.equalScales){$(group).css("width",`${xRangeSize}px`);$(group).css("height",`${yRangeSize}px`)}const exportCanvas=document.createElement("canvas");let webglCanvas=createCanvas("scatter-canvas-gl","webgl");const highlightCanvas=createCanvas("scatter-hlight-canvas","hlight",true);const canvas=createCanvas("scatter-canvas","canvas",true);const svg=document.createElement("d3fc-svg");svg.setAttribute("id","scatter-svg");svg.className=typedPlotArea("svg");svg.style.height="100%";svg.style.width="100%";exportCanvas.className="canvas-export";exportCanvas.style.display="none";exportCanvas.style.height="100%";exportCanvas.style.width="100%";exportCanvas.style.position="absolute";group.append(webglCanvas);group.append(exportCanvas);group.append(highlightCanvas);group.append(canvas);group.append(svg);$body.append(group);let glCanvas=webglCanvas.firstElementChild;const canvasHLight=highlightCanvas.firstElementChild;const scatterCanvas=d3.select(canvas.firstElementChild);const canvas2d=canvas.firstElementChild;const scatterSvg=d3.select(svg.firstElementChild);const d3fcGroup=d3.select(group);let shouldDrawRegressionLine=ChartFeatures.shouldDrawRegressionLine(chartDef);let contextLost=false;$timeout(()=>{const pxlr=window.devicePixelRatio;let context=null;const colorCache={};let modifiedMargins=chartBase.margins;let drawTooltipHighlight=false;let isChartRendered=false;const pairColorOptions=chartDef.scatterMPOptions.pairColorOptions;let sizeScale,colorScale,shapeScale,resultingColor,resultingColors,cacheKey,sizeAvg;let computedRegression;const scatterOptions=multiple?chartDef.scatterMPOptions:chartDef.scatterOptions;const hasBlending=scatterOptions.optimizeRendering!==true;const connectPoints=scatterOptions.connectPoints;const hasUAColor=chartData.hasUAColor(chartDef);const hasUASize=chartData.hasUASize(chartDef);if(hasUASize){sizeScale=UaChartsCommon.makeSizeScale(5,chartDef.uaSize[0],chartData.getData());sizeAvg=chartData.getSizeAvg(chartDef.uaSize[0])}const hasUAShape=chartData.hasUAShape(chartDef);if(hasUAShape){shapeScale=chartData.makeShapeScale()}if(hasUAColor){colorScale=chartBase.colorScale}else if(multiple){resultingColors=pairColorOptions}else{resultingColor=UaChartsCommon.makeSingleColor(chartDef)}const getSize=dataIndex=>{const radius=chartData.hasUASize(chartDef)?UaChartsCommon.makeSize(chartDef,chartData.getData(),dataIndex,sizeScale):chartDef.bubblesOptions.defaultRadius*pxlr/2;if(hasUAShape){return Math.max(1,Math.round(Math.PI*Math.pow(radius,1.5)))}return Math.max(1,Math.round(Math.PI*Math.pow(radius,2)))};let firstDraw=true;const seriesColorCache=new Map;const xPositionScale=function(d){return chartBase.xAxis.scale()(d)*pxlr};const yPositionScale=function(d,pairIndex=0){return chartBase.yAxes[pairIndex].scale()(d)*pxlr};const getColorForSerie=pairIndex=>index=>{const c=getColor(hasUAColor,chartData,chartDef,index,colorCache,colorScale,multiple,resultingColors,axisPairs[pairIndex],resultingColor,cacheKey,chartHandler.getChartTheme());return c};const getWebGLContext=canvas=>{const context=canvas.getContext("webgl");if(hasBlending){context.enable(context.BLEND);context.blendEquation(context.FUNC_ADD);context.blendFunc(context.ONE,context.ONE_MINUS_SRC_ALPHA)}return context};const gl=getWebGLContext(glCanvas);const pointSizeRange=gl.getParameter(gl.ALIASED_POINT_SIZE_RANGE);uiDisplayState.lowPointSizeRangeWarning=pointSizeRange[1]<255&&(chartData.hasUASize(chartDef)||chartDef.bubblesOptions.defaultRadius>25);context=canvas2d.getContext("2d");context.scale(pxlr,pxlr);const reshapeDataPerPairs=[];const series=[];const createSeries=axisPairs=>{series.length=0;reshapeDataPerPairs.length=0;axisPairs.forEach(pair=>{const reshapedData=chartData.hasDiscreteUAColor(chartDef)||chartData.hasUAShape(chartDef)?ScatterUtils.reshapeData(chartData,pair,chartDef,connectPoints):null;reshapeDataPerPairs.push(reshapedData);pair.length=pair.afterFilterRecords;visibleCountMap.set(pair.pairIndex,pair.afterFilterRecords);const yScale=ScatterUtils.convertScale(chartBase.yAxes[pair.pairIndex]);let serie=ScatterUtils.createSerie(getSize,chartData,pair,chartDef,getColorForSerie(pair.pairIndex),seriesColorCache,reshapedData,hasBlending,chartDef.xAxisFormatting.isLogScale,ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,pair.id),connectPoints);if(connectPoints.enabled){serie=ScatterUtils.addLineSerie(serie,chartData,pair,chartDef,reshapedData,connectPoints,getColorForSerie(pair.pairIndex),seriesColorCache,chartDef.xAxisFormatting.isLogScale,ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,pair.id))}serie.xScale(xScale);serie.yScale(yScale);serie.context(gl);series.push(serie);serie.$highlighting=true})};createSeries(axisPairs);const onContextLost=event=>{event.preventDefault();contextLost=true;exportCanvas.style.display="block";addEvents(exportCanvas);Logger.info(`webglcontextlost for: "${chartDef?.name}"`);series.forEach(serie=>serie.context(null));removeContextListener(glCanvas);group.removeChild(webglCanvas);glCanvas=null};const onContextRestored=(log=true)=>{contextLost=false;if(log){Logger.info(`webglcontextrestored for: "${chartDef?.name}"`)}exportCanvas.style.display="none";removeEvents(exportCanvas);webglCanvas=createCanvas("scatter-canvas-gl","webgl");group.prepend(webglCanvas);glCanvas=webglCanvas.firstElementChild;attachContextListener(glCanvas);const newContext=getWebGLContext(glCanvas);series.forEach(serie=>{serie.context(newContext);serie(chartData.getData())})};const attachContextListener=canvas=>{canvas.addEventListener("webglcontextlost",onContextLost,false);canvas.addEventListener("webglcontextrestored",onContextRestored,false)};const removeContextListener=canvas=>{canvas.removeEventListener("webglcontextlost",onContextLost);canvas.removeEventListener("webglcontextrestored",onContextRestored)};attachContextListener(glCanvas);d3fcGroup.on("draw",()=>{drawChart(modifiedMargins)});function getMousePos(rect,evt){return{x:evt.clientX-rect.left,y:evt.clientY-rect.top}}function removeEvents(...elements){elements.forEach(element=>{element.removeEventListener("mousemove",onMouseMove);element.removeEventListener("mouseup",onMouseUp);element.removeEventListener("mousedown",onMouseDown)})}function addEvents(...elements){elements.forEach(element=>{element.addEventListener("mousemove",onMouseMove);element.addEventListener("mouseup",onMouseUp);element.addEventListener("mousedown",onMouseDown)})}addEvents(svg,canvas);chartHandler.$on("$destroy",()=>{group.disconnectedCallback();$body.remove(group);removeContextListener(glCanvas);removeEvents(svg,canvas,exportCanvas);d3fcGroup.on("draw",null);ChartZoomControlAdapter.clear(chartDef.$zoomControlInstanceId)});const cachedSortedMapping={};function getValueForMousePos(axis,scale,position,axisData){if(axis.scaleType===D3ChartAxes.scaleTypes.TIME){return scale.invert(position).getTime()}if(axis.scaleType===D3ChartAxes.scaleTypes.ORDINAL){const rangePoints=axis.scale().range();if(rangePoints[rangePoints.length-1]<rangePoints[0]){rangePoints.reverse()}let indexInRange=d3.bisect(rangePoints,position);const radius=chartData.hasUASize(chartDef)?sizeAvg:chartDef.bubblesOptions.defaultRadius/2;const isHoveringAtIndex=index=>{return position>=rangePoints[index]-radius&&position<=rangePoints[index]+radius};let hoveredIndex;if(indexInRange===0||indexInRange===rangePoints.length){indexInRange=indexInRange===rangePoints.length?indexInRange-1:indexInRange;if(isHoveringAtIndex(indexInRange)){hoveredIndex=indexInRange}else{return-1}}else{const indexBefore=indexInRange-1;if(isHoveringAtIndex(indexBefore)){hoveredIndex=indexBefore}else if(isHoveringAtIndex(indexInRange)){hoveredIndex=indexInRange}else{return-1}}let sortedMapping;if(cachedSortedMapping[axis.id]){sortedMapping=cachedSortedMapping[axis.id]}else{sortedMapping=axisData.str.sortedMapping.toSorted((a,b)=>a.sortOrder-b.sortOrder);const range=scale.range();if(range[1]<range[0]){sortedMapping.reverse()}cachedSortedMapping[axis.id]=sortedMapping}return sortedMapping[hoveredIndex].sortOrder}return scale.invert(position)}function getRadiusInDomainFromMousePos(axis,value,scale,position){if(axis.scaleType===D3ChartAxes.scaleTypes.ORDINAL){return 0}let radius;if(chartData.hasUASize(chartDef)){radius=sizeScale(sizeAvg)}else{radius=chartDef.bubblesOptions.defaultRadius/2}if(chartData.hasUAShape(chartDef)&&radius>=10){radius*=.5}return Math.abs(value-scale.invert(position-radius))}function onMouseMove(evt){if(!isTooltipsReady()||!ChartPropertiesService.showTooltip(chartDef.tooltipOptions,chartHandler.chartTileProperties)){return}if(ChartZoomControlAdapter.isZooming(chartDef.$zoomControlInstanceId)||ChartZoomControlAdapter.isBrushing(chartDef.$zoomControlInstanceId)){hideTooltip()}else{const rect=evt.target.getBoundingClientRect();const mousePos=getMousePos(rect,evt);const bests=[];series.forEach((serie,serieIdx)=>{const serieXscale=serie.xScale();const serieYscale=serie.yScale();const x=getValueForMousePos(chartBase.xAxis,serieXscale,mousePos.x,multiple?chartData.data.axesPairs[serieIdx].xAxis:chartData.data.xAxis);const y=getValueForMousePos(chartBase.yAxes[serieIdx],serieYscale,mousePos.y,multiple?chartData.data.axesPairs[serieIdx].yAxis:chartData.data.yAxis);if(x!==-1&&y!==-1){const radiusX=getRadiusInDomainFromMousePos(chartBase.xAxis,x,serieXscale,mousePos.x);const radiusY=getRadiusInDomainFromMousePos(chartBase.yAxes[serieIdx],y,serieYscale,mousePos.y);bests.push(kdbushs[serieIdx].range(x-radiusX,y-radiusY,x+radiusX,y+radiusY))}});if(bests.some(best=>best.length)){const pairIndex=bests.findIndex(best=>best.length);const i=bests[pairIndex][0];const color=getColorForSerie(pairIndex)(i);chartBase.tooltips.showForCoords(0,{x:i,y:i,color:i,extras:{shape:i,size:i,pair:pairIndex}},{pageX:mousePos.x+rect.left,pageY:mousePos.y+rect.top,target:canvas},color);updateTooltipHighlightSerie(pairIndex,i);tooltipHighlight=true;redrawTooltipHighlight()}else{hideTooltip()}}}function onMouseUp(){canvas.classList.remove("panning")}function onMouseDown(){if(ChartZoomControlAdapter.isEnabled(chartDef.$zoomControlInstanceId)){canvas.classList.add("panning")}}function hideTooltip(){chartBase.tooltips.hide();if(tooltipHighlight){tooltipHighlight=false;redrawTooltipHighlight()}}function updateTooltipHighlightSerie(pairIndex,dataIndex){const color=getColorForSerie(pairIndex)(dataIndex);highlightPointSerie=ScatterUtils.createHighlightSerie(dataIndex,chartData,axisPairs[pairIndex],getSize,color,multiple?null:chartData.getShapeVal(chartDef.uaShape[0],dataIndex));const xScale=ScatterUtils.convertScale(chartBase.xAxis);const yScale=ScatterUtils.convertScale(chartBase.yAxes[pairIndex]);xScale.range([xScale.range()[0]*pxlr,xScale.range()[1]*pxlr]);if(chartBase.xAxis.scaleType==="ORDINAL"){const extent=chartBase.xAxis.scale().rangeExtent();xScale.range([0,extent[extent.length-1]*pxlr])}yScale.range([yScale.range()[0]*pxlr,yScale.range()[1]*pxlr]);if(chartBase.yAxes[pairIndex].scaleType==="ORDINAL"){const extent=chartBase.yAxes[pairIndex].scale().rangeExtent();yScale.range([extent[extent.length-1]*pxlr,0])}highlightPointSerie.xScale(xScale);highlightPointSerie.yScale(yScale);const context=canvasHLight.getContext("2d");context.scale(pxlr,pxlr);highlightPointSerie.context(context)}function redrawChart(){drawTooltipHighlight=false;isChartRendered=false;if(contextLost){onContextRestored(false)}group.requestRedraw()}function redrawTooltipHighlight(){drawTooltipHighlight=true;group.requestRedraw()}function clearCanvas(){if(context){context.clearRect(0,0,canvas.width,canvas.height)}const width=canvas.width;const height=canvas.height;canvas.width=width;canvas.height=height}function drawIdentityLine(){if(ChartUADimension.areAllNumericalOrDate(chartDef)&&chartDef.scatterOptions&&chartDef.scatterOptions.identityLine&&!multiple){const xAxisExtent=D3ChartAxes.getCurrentAxisExtent(chartBase.xAxis);const yAxisExtent=D3ChartAxes.getCurrentAxisExtent(chartBase.yAxes[0]);const start=Math.min(xAxisExtent[0],yAxisExtent[0]);const end=Math.max(xAxisExtent[1],yAxisExtent[1]);if(end<start){return}context.strokeStyle="#777";context.beginPath();context.moveTo(xPositionScale(start),yPositionScale(start));context.lineTo(xPositionScale(end),yPositionScale(end));context.closePath();context.stroke()}}const dataSpec=chartHandler.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allDimensions=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));const displayablePairs=ChartUADimension.getDisplayableDimensionPairs(chartDef.uaDimensionPair);const allUsedDimensions=multiple?displayablePairs.flatMap(pair=>{const uaXDimension=ChartUADimension.getPairUaXDimension(displayablePairs,pair);return[uaXDimension,pair.uaYDimension[0]]}):[chartDef.uaXDimension[0],chartDef.uaYDimension[0]];const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,chartBase.xSpec,chartBase.ySpecs),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartBase.chartData,allDimensions,allUsedDimensions,customMeasures,false);function*getPoints(chartData){for(const pair of axisPairs){for(let i=0;i<pair.afterFilterRecords;i++){yield[chartData.uaRawAxisVal(pair.xDim,"x",i,pair.pairIndex),chartData.uaRawAxisVal(pair.yDim,"y",i,pair.pairIndex)]}}}function drawChart(margins){if(!drawTooltipHighlight||!isChartRendered){axisPairs.forEach(pair=>{const serie=series[pair.pairIndex];const reshapedData=reshapeDataPerPairs[pair.pairIndex];if(serie.$highlighting){if(!_.isNil(serie.$highlightingColorIndex)||!_.isNil(serie.$highlightingShapeIndex)){const splitBy=connectPoints.enabled?connectPoints.splitBy:ConnectPointsSplitOptions.COLOR;const highlightingInnerSeries=chartData.hasDiscreteUAColor(chartDef)&&chartData.hasUAShape(chartDef)&&(!_.isNil(serie.$highlightingColorIndex)&&splitBy!==ConnectPointsSplitOptions.COLOR||!_.isNil(serie.$highlightingShapeIndex)&&splitBy!==ConnectPointsSplitOptions.SHAPE);const highlightingIndex=!_.isNil(serie.$highlightingColorIndex)?serie.$highlightingColorIndex:serie.$highlightingShapeIndex;const colorOrShapeSeries=serie.series();const highlightedLineSerie=highlightingInnerSeries?null:ScatterUtils.getLineSeries(colorOrShapeSeries[highlightingIndex]);if(highlightingInnerSeries){colorOrShapeSeries.forEach((outerSerie,outerIndex)=>{const highlightedInnerSerie=(connectPoints.enabled?ScatterUtils.getMultiSeries(outerSerie):outerSerie).series()[highlightingIndex];highlightedInnerSerie&&highlightedInnerSerie(reshapedData.get(outerIndex).innerValues[highlightingIndex])})}else if(chartData.hasDiscreteUAColor(chartDef)&&chartData.hasUAShape(chartDef)){const highlighedMultiSeries=connectPoints.enabled?ScatterUtils.getMultiSeries(colorOrShapeSeries[highlightingIndex]):colorOrShapeSeries[highlightingIndex];highlighedMultiSeries.series().forEach((innerSerie,innerIndex)=>{innerSerie(reshapedData.get(highlightingIndex).innerValues[innerIndex])})}else{const highlightedPointSeries=connectPoints.enabled?ScatterUtils.getPointSeries(colorOrShapeSeries[highlightingIndex]):colorOrShapeSeries[highlightingIndex];highlightedPointSeries(reshapedData.get(highlightingIndex).values)}highlightedLineSerie&&highlightedLineSerie(reshapedData.get(highlightingIndex).values)}else{serie(pair)}}highlightPointSerie&&highlightPointSerie([])});isChartRendered=true;const xAxis=chartBase.xAxis?{...chartBase.xAxis,formattingOptions:chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting}:null;const yAxes=[];if(chartBase.yAxes){chartBase.yAxes.forEach(axis=>{if(axis){const formatting=ChartAxesUtils.getFormattingForYAxis(chartDef.yAxesFormatting,axis.id);yAxes.push({...axis,formattingOptions:formatting.axisValuesFormatting.numberFormatting})}})}ReferenceLines.drawReferenceLines(g,chartBase.vizWidth,chartBase.vizHeight,xAxis,yAxes,displayedReferenceLines,referenceLinesValues,{left:margins.left,top:margins.top})}else{if(tooltipHighlight){highlightPointSerie([1])}else{highlightPointSerie&&highlightPointSerie([])}}if(ChartFeatures.canDrawIdentityLine(chartDef)){drawIdentityLine()}if(shouldDrawRegressionLine){if(!computedRegression){computedRegression=RegressionLine.computeRegression(()=>getPoints(chartData),chartDef.scatterOptions.regression,chartDef.xAxisFormatting.customExtent,ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,chartBase.yAxes[0].id))}RegressionLine.drawRegression(computedRegression,context,chartDef.scatterOptions.regression,xPositionScale,yPositionScale,chartHandler.getChartTheme())}if(firstDraw){loading.remove();firstDraw=false}if(thumbnailState.shouldUpdate){const glOrigCanvas=glCanvas;exportCanvas.width=glOrigCanvas.width;exportCanvas.height=glOrigCanvas.height;const ctx=exportCanvas.getContext("2d");ctx.drawImage(glOrigCanvas,0,0);ctx.drawImage(canvas2d,0,0);thumbnailState.shouldUpdate=false;chartHandler.updateThumbnail()}}function clearChart(){clearCanvas();ReferenceLines.removeReferenceLines(container)}function toggleZoomableClass(canvas,isEnabled){if(isEnabled){canvas.classList.add("zoomable")}else{canvas.classList.remove("zoomable")}}function updateAxisWithZoom(isLogScale,chartData,spec,axis,axisOptions,axisNumberFormatting,min,max,pairIndex){if(isLogScale){D3ChartAxes.setLogAxisTicks(axis,min,max);axisOptions.tickValues=axis.tickValues()}else if(ChartUADimension.isTrueNumerical(spec.dimension)){axis.scale().domain([min,max]);D3ChartAxes.addNumberFormatterToAxis(axis,axisNumberFormatting);axisOptions.tickFormat=axis.tickFormat()}else if(ChartUADimension.isDate(spec.dimension)&&axis.scaleType===D3ChartAxes.scaleTypes.TIME){axis.scale().domain([min,max]);const computedDateDisplayUnit=ChartDataUtils.computeDateDisplayUnit(min,max);axisOptions.tickFormat=date=>computedDateDisplayUnit.formatDateFn(date,computedDateDisplayUnit.dateFormat);chartData.setExtent(pairIndex,min,max)}}function configureZoom(d3canvas,d3svg){const weakD3Canvas=new WeakRef(d3canvas);chartDef.$zoomControlInstanceId=ChartZoomControlAdapter.create(CHART_ZOOM_CONTROL_TYPES.D3,d3,d3canvas,chartBase.xAxis,chartBase.yAxes,g.node().clientWidth,d3svg);if(ChartZoomControlAdapter.isActivated(chartDef.$zoomControlInstanceId)){modifiedMargins=chartBase.margins;const onZoom=()=>{D3ChartAxes.clearAxes(g);clearChart();if(ChartFeatures.shouldDrawRegressionLine(chartDef)){shouldDrawRegressionLine=false}const xExtent=D3ChartAxes.getCurrentAxisExtent(chartBase.xAxis);const xMin=xExtent[0];const xMax=xExtent[1];updateAxisWithZoom(chartDef.xAxisFormatting.isLogScale,chartBase.chartData,chartBase.xSpec,chartBase.xAxis,chartBase.axisOptions.x,chartDef.xAxisFormatting.axisValuesFormatting&&chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting?chartDef.xAxisFormatting.axisValuesFormatting.numberFormatting:{},xMin,xMax);axisPairs.forEach(pair=>{const yAxis=chartBase.yAxes.find(v=>v.id===(pair.id||ChartsStaticData.LEFT_AXIS_ID));const yAxisSpec=chartBase.ySpecs[pair.id||ChartsStaticData.LEFT_AXIS_ID];const yExtent=D3ChartAxes.getCurrentAxisExtent(yAxis);const yMin=yExtent[0];const yMax=yExtent[1];const yAxisOpts=chartBase.axisOptions.y.find(v=>v.id===yAxis.id);const isLogScale=ChartAxesUtils.isYAxisLogScale(chartDef.yAxesFormatting,pair.id);updateAxisWithZoom(isLogScale,chartBase.chartData,yAxisSpec,yAxis,yAxisOpts,ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting,pair.id),yMin,yMax,pair.pairIndex)});const yAxesColors=chartData.getYAxesColors(chartBase.ySpecs,chartDef,chartHandler.getChartTheme());const d3DrawContext={$svgs:chartBase.$svgs,chartDef:chartDef,chartHandler:chartHandler,ySpecs:chartBase.ySpecs,xAxis:chartBase.xAxis,yAxes:chartBase.yAxes,axisOptions:chartBase.axisOptions,yAxesColors:yAxesColors};const{updatedMargins,vizWidth,vizHeight}=D3ChartAxes.drawAxes(d3DrawContext);modifiedMargins=updatedMargins;chartBase.vizWidth=vizWidth;chartBase.vizHeight=vizHeight;const newXScale=ScatterUtils.convertScale(chartBase.xAxis);series.forEach((serie,index)=>{const newYScale=ScatterUtils.convertScale(chartBase.yAxes[index]);serie.yScale(newYScale);serie.xScale(newXScale)});redrawChart()};const onZoomEnd=()=>{g.select("foreignObject").attr("width",chartBase.vizWidth).attr("height",chartBase.vizHeight);g.select("foreignObject").attr("x",modifiedMargins.left).attr("y",modifiedMargins.top);if(isTooltipsReady()){updateSamplingInfo()}shouldDrawRegressionLine=ChartFeatures.shouldDrawRegressionLine(chartDef);thumbnailState.shouldUpdate=true;clearChart();redrawChart()};const onEnabledChange=value=>{const canvasRef=weakD3Canvas.deref();if(canvasRef){toggleZoomableClass(canvasRef.node(),value)}};ChartZoomControlAdapter.init(CHART_ZOOM_CONTROL_TYPES.D3,chartDef.$zoomControlInstanceId,{hasRectangleSelection:true,...chartDef.scatterZoomOptions},{onZoom:onZoom,onZoomEnd:onZoomEnd,onEnabledChange:onEnabledChange})}else{thumbnailState.shouldUpdate=true;d3svg[0][0].parentElement.remove();redrawChart()}}const hasColorLegend=hasUAColor&&(ChartUADimension.isAlphanumLike(chartDef.uaColor[0])||ChartUADimension.isDiscreteDate(chartDef.uaColor[0]));if(hasUAShape||hasColorLegend){const legend={type:"COLOR_DISCRETE",items:[]};if(hasColorLegend){colorScale.domain().forEach(function(v,idx){const item={label:{colorId:ChartColorUtils.getColorId(chartDef.genericMeasures,chartData,v),...chartData.getColorData().str.sortedMapping[v]},color:colorScale(v),focusFn:function(){clearChart();series.forEach(serie=>{serie.$highlightingColorIndex=idx});redrawChart()},unfocusFn:function(){clearCanvas();series.forEach(serie=>{serie.$highlightingColorIndex=null});redrawChart()}};legend.items.push(item)})}if(hasUAShape&&hasColorLegend){legend.items.push({separator:true})}if(hasUAShape){chartData.getShapeData().str.sortedMapping.map((v,idx)=>{const shapeType=shapeScale(idx).type;const item={label:chartData.getShapeData().str.sortedMapping[idx],shape:{svgSrc:ChartIconUtils.computeScatterLegendIcon(shapeType)},focusFn:function(){clearChart();series.forEach(serie=>{serie.$highlightingShapeIndex=idx});redrawChart()},unfocusFn:function(){clearCanvas();series.forEach(serie=>{serie.$highlightingShapeIndex=null});redrawChart()}};legend.items.push(item)})}chartHandler.legendsWrapper.deleteLegends();chartHandler.legendsWrapper.pushLegend(legend)}else if(multiple&&chartHandler.legendsWrapper.hasLegends()){chartHandler.legendsWrapper.getLegend(0).items.forEach((item,index)=>{item.focusFn=function(){clearChart();series.forEach((serie,serieIdx)=>{serie.$highlighting=index===serieIdx});redrawChart()};item.unfocusFn=function(){clearChart();chartData.$highlighting=true;series.forEach(serie=>{serie.$highlighting=true});redrawChart()}})}else if(!hasUAColor&&!hasUAShape){chartHandler.legendsWrapper.deleteLegends()}configureZoom(scatterCanvas,scatterSvg)})};function getColor(hasUAColor,chartData,chartDef,i,colorCache,colorScale,multiple,resultingColors,pair,resultingColor,cacheKey,theme){let c;if(hasUAColor){let rgb;const colorData=chartData.getColorData();if(chartDef.uaColor[0].type=="NUMERICAL"&&!chartDef.uaColor[0].treatAsAlphanum){cacheKey=colorData.num.data[i]}else if(chartDef.uaColor[0].type=="DATE"&&chartDef.uaColor[0].dateMode=="RANGE"){cacheKey=colorData.ts.data[i]}else{cacheKey=colorData.str.data[i]}if(colorCache[cacheKey]){rgb=colorCache[cacheKey]}else{rgb=colorScale(cacheKey);colorCache[cacheKey]=rgb}c=rgb}else if(multiple){const colors=ChartColorUtils.getColors(resultingColors.colorPalette,resultingColors.customPalette,theme);const assignedColor=ChartColorUtils.getColor(resultingColors,colors,pair.colorInfo.id,pair.pairIndex);if(colorCache[assignedColor]){return colorCache[assignedColor]}c=colorCache[assignedColor]=ColorUtils.toRgba(assignedColor,chartDef.scatterMPOptions.pairColorOptions.transparency)}else{c=resultingColor}return c}}})();(function(){"use strict";angular.module("dataiku.charts").factory("ScatterPlotChart",ScatterPlotChart);function ScatterPlotChart(ChartManager,ChartDataWrapperFactory,ScatterPlotChartDrawerWebGl,ChartDataUtils,ChartAxesUtils,ReferenceLines,ColumnAvailability,ChartUsableColumns,ChartYAxisPosition,ChartCustomMeasures){return function($container,chartDef,chartHandler,axesDef,data,uiDisplayState){const chartData=ChartDataWrapperFactory.chartScatterDataWrapper(data,axesDef);const drawFrame=function(frameIdx,chartBase){ReferenceLines.removeReferenceLines($container[0]);ScatterPlotChartDrawerWebGl($container[0],chartDef,chartHandler,chartData,chartBase,uiDisplayState)};const xDimension=chartDef.uaXDimension[0];const xData=data.xAxis;const yDimension=chartDef.uaYDimension[0];const yData=data.yAxis;const xExtent=ChartDataUtils.getUnaggregatedAxisExtent(xDimension,xData);const yExtent=ChartDataUtils.getUnaggregatedAxisExtent(yDimension,yData);const xSpec={type:"UNAGGREGATED",mode:"POINTS",extent:xExtent,dimension:xDimension,customExtent:chartDef.xAxisFormatting.customExtent};const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);const ySpecs={[yAxisID]:{id:yAxisID,type:"UNAGGREGATED",mode:"POINTS",extent:yExtent,dimension:yDimension,customExtent:ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting,yAxisID),position:ChartYAxisPosition.LEFT}};const dataSpec=chartHandler.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));ColumnAvailability.updateAvailableColumns([xDimension,yDimension],allMeasures,customMeasures);const displayedReferenceLines=ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines,xSpec,ySpecs),referenceLinesValues=ReferenceLines.getReferenceLinesValues(displayedReferenceLines,chartData,allMeasures,[xDimension,yDimension],customMeasures,false),referenceLinesExtents=ReferenceLines.getReferenceLinesExtents(displayedReferenceLines,referenceLinesValues);if(!_.isNil(xExtent.min)&&!_.isNil(xExtent.max)){const xExtentWithReferenceLines=ReferenceLines.getExtentWithReferenceLines([xExtent.min,xExtent.max],referenceLinesExtents.x);xSpec.extent.min=xExtentWithReferenceLines[0];xSpec.extent.max=xExtentWithReferenceLines[1]}if(!_.isNil(yExtent.min)&&!_.isNil(yExtent.max)){const yAxisID=ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);const yExtentWithReferenceLines=ReferenceLines.getExtentWithReferenceLines([yExtent.min,yExtent.max],referenceLinesExtents[yAxisID]);ySpecs[yAxisID].extent.min=yExtentWithReferenceLines[0];ySpecs[yAxisID].extent.max=yExtentWithReferenceLines[1]}ReferenceLines.updateAvailableAxisOptions([{axis:"X_AXIS",isDisplayed:true,isContinuousDate:ChartAxesUtils.isContinuousDate(xSpec),isNumerical:ChartAxesUtils.isNumerical(xSpec),isPercentScale:false},{axis:"LEFT_Y_AXIS",isDisplayed:true,isContinuousDate:ChartAxesUtils.isContinuousDate(ySpecs[yAxisID]),isNumerical:ChartAxesUtils.isNumerical(ySpecs[yAxisID]),isPercentScale:false}]);ChartManager.initChart(chartDef,chartHandler,chartData,$container,drawFrame,{x:xSpec,...ySpecs},{type:"UNAGGREGATED",dimension:chartDef.uaColor[0],data:data.values.color,withRgba:true})}}})();(function(){"use strict";angular.module("dataiku.charts").factory("AgGridConverter",function(ChartLabels,HierarchicalChartsUtils,ChartFormatting,ChartColorScales,ChartLegendUtils,ExpandCollapseToolPanel,DisplayTotalsToolPanel,LinkedList,ChartDimension,PivotTableUtils,ChartFeatures,ChartsStaticData,ClipboardUtils,ConditionalFormattingOptions,ColorUtils,ChartHierarchyDimension,translate){const LIGHT_GREY_COLUMN="#ededed";const LIGHT_GREY_ROW="#f2f7fa";const SUBTOTAL_LEAF_ROW_KEY="__Subtotal__Leaf__Row__";const DEFAULT_ROW_HEIGHT=25;const CHEVRON_OFFSET_WIDTH=32;const ROW_OFFSET_WIDTH=12;const AUTOGROUP_COLUMN_KEY="ag-Grid-AutoColumn";const COLOR_FLAG_KEY="__Color__Flag__";const GRAND_TOTAL_KEY="__Grand__Total__";const GRAND_TOTAL_LABEL="Grand Total";const SUB_COLUMN_SEPARATOR="__";const MEASURE_COLUMN_KEY="__MEASURE__LIST__";const MEASURE_COLUMN_LABEL="Value";const UNIQUE_ROW_KEY="__UNIQUE__ROW__";const DEFAULT_FONT_SIZE="12px";const DEFAULT_FONT_COLOR="#333";const SUBTOTAL_COLUMN_STYLE={backgroundColor:LIGHT_GREY_COLUMN,padding:0};const SUB_TOTAL_ROW_STYLE={backgroundColor:LIGHT_GREY_ROW,padding:0};const LEAF_ROW_STYLE={padding:0};const GRAND_TOTAL_COLUMN_STYLE={backgroundColor:LIGHT_GREY_COLUMN,fontWeight:"bold",padding:0};const GRAND_TOTAL_ROW_STYLE={backgroundColor:LIGHT_GREY_ROW,fontWeight:"bold",padding:0};const MEASURE_COLUMN_STYLE={padding:0};class AbstractAGGridPivotTableChartConverter{constructor(chartDef,chartStore,chartData,data,chartHandler,tooltips,contextualMenu,$rootElement){this.chartDef=chartDef;this.chartStore=chartStore;this.chartData=chartData;this.data=data;this.chartHandler=chartHandler;this.tooltips=tooltips;this.contextualMenu=contextualMenu;this.$rootElement=$rootElement;this.endColumns=[];this.subtotalColumns=[];this.grandTotalColumnMaxCellWidth=new Map;this.mapGroupColumnCellIdToHeaderName=new Map;this.initializedRowNode=new Set;const yHierarchyDimension=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"y");this.yDimensions=yHierarchyDimension?[yHierarchyDimension]:this.chartDef.yDimension;const xHierarchyDimension=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"x");this.xDimensions=xHierarchyDimension?[xHierarchyDimension]:this.chartDef.xDimension;const cellFormatterProperties=HierarchicalChartsUtils.computeFormatterProperties(this.chartDef);this.cellFormatters=cellFormatterProperties.cellFormatters;this.isPercentageOnly=cellFormatterProperties.isPercentageOnly;this.colorGroupByMeasureId={};if(chartDef.colorMode==="COLOR_GROUPS"){this.chartHandler.legendsWrapper.deleteLegends();let basedOnMeasureIndexCounter=chartDef.genericMeasures.length-1;this.colorGroupByMeasureId=chartDef.colorGroups?chartDef.colorGroups.filter(({appliedColumns})=>!!appliedColumns).reduce((acc,{appliedColumns,rules,colorOptions,colorGroupMode,colorMeasure})=>{let groupColorMeasure;if(colorMeasure&&colorMeasure.length>0){basedOnMeasureIndexCounter+=1;groupColorMeasure=colorMeasure[0]}appliedColumns.forEach(column=>{const columnAggIndex=ConditionalFormattingOptions.getColorColumnIndex(column,chartDef.genericMeasures,chartDef.colorMode);const currColorScaleColumnIndex=groupColorMeasure?basedOnMeasureIndexCounter:columnAggIndex;const hasColorProperties=colorOptions&&currColorScaleColumnIndex<this.chartData.data.aggregations.length;const colorScale=hasColorProperties?this.computeColorTableProperties(colorOptions,currColorScaleColumnIndex,groupColorMeasure||chartDef.genericMeasures[currColorScaleColumnIndex]).colorScale:undefined;acc[ConditionalFormattingOptions.getMeasureId(column)]={rules:rules,colorGroupMode:colorGroupMode,colorProperties:hasColorProperties?{getColorScale:()=>colorScale,getBin:cellCoords=>this.chartData.getAggrLoc(currColorScaleColumnIndex,cellCoords)}:undefined,basedOnMeasure:groupColorMeasure,basedOnMeasureIndex:groupColorMeasure?basedOnMeasureIndexCounter:-1}});return acc},{}):{}}else{const colorProperties=this.computeColorTableProperties(chartDef.colorOptions);this.hasColorMeasure=colorProperties.hasColorMeasure;this.colorMeasureIndex=colorProperties.colorMeasureIndex;this.colorScale=colorProperties.colorScale}this.rowDimensionId=new Set;this.yDimensions.map(dimension=>this.rowDimensionId.add(this.chartStore.getDimensionId(dimension)));const{rowMainHeaders,rowSubheaders,columnMainHeaders,columnSubheaders,values}=this.chartDef.pivotTableOptions.tableFormatting;const defaultFontFamily="SourceSansPro";const theme=this.chartHandler.getChartTheme();const fontFamily=theme&&theme.generalFormatting&&theme.generalFormatting.fontFamily?`${theme.generalFormatting.fontFamily}, ${defaultFontFamily}`:defaultFontFamily;this.rowMainHeadersFormatting={fontFamily:fontFamily,fontSize:rowMainHeaders?`${rowMainHeaders.fontSize}px`:DEFAULT_FONT_SIZE,color:rowMainHeaders?rowMainHeaders.fontColor:DEFAULT_FONT_COLOR};this.rowSubheadersFormatting={fontFamily:fontFamily,fontSize:rowSubheaders?`${rowSubheaders.fontSize}px`:DEFAULT_FONT_SIZE,color:rowSubheaders?rowSubheaders.fontColor:DEFAULT_FONT_COLOR};this.columnMainHeadersFormatting={fontFamily:fontFamily,fontSize:`${columnMainHeaders.fontSize}px`,color:columnMainHeaders.fontColor};this.columnSubheadersFormatting={fontFamily:fontFamily,fontSize:`${columnSubheaders.fontSize}px`,color:columnSubheaders.fontColor};this.valuesFormatting={fontFamily:fontFamily,fontSize:`${values.fontSize}px`,color:ChartFeatures.isColoredPivotTable(chartDef)?DEFAULT_FONT_COLOR:values.fontColor}}cellWithChevronRenderer(params){const container=document.createElement("div");if(params.value!==undefined){let node=params.node;for(let i=0;i<params.value.depth;i++){node=node.parent}return this.buildCellWithChevron(params,node)}return container}buildCellWithChevron(params,node){const value=params.value;const container=document.createElement("div");container.classList.add("pivot-table__group");const span=document.createElement("span");span.classList.add("pivot-table__group-content");span.innerText=value.label;const hasChevron=value.depth>0||value.depth==0&&node.hasChildren();if(hasChevron){container.classList.add("pivot-table__group--with-chevron");const chevronContainer=document.createElement("span");const chevron=document.createElement("span");chevronContainer.appendChild(chevron);if(node.expanded){chevronContainer.className="ag-group-expanded pivot-table__chevron-container";chevron.className="ag-icon ag-icon-tree-open"}else{chevronContainer.className="ag-group-contracted pivot-table__chevron-container";chevron.className="ag-icon ag-icon-contracted"}if(!this.initializedRowNode.has(node)){this.initializedRowNode.add(node);node.setExpanded(this.computeRowExpandedStatus(node.id))}container.appendChild(chevronContainer);container.addEventListener("click",()=>this.switchFoldStatus(node));container.addEventListener("dblclick",()=>this.switchFoldStatus(node))}if(value.hasOffset){container.classList.add("pivot-table__cell--total-label")}container.classList.add(PivotTableUtils.ROW_SUBHEADER_CLASSNAME);this.contextualMenu.addContextualMenuHandler(container,undefined,PivotTableUtils.getRowHeaderContextualMenuActions(this.chartDef,PivotTableUtils.getToggleRowHeadersCallbacks(this.chartDef,this.chartHandler.openSection),value.label),"pivotTableHeader");container.appendChild(span);return container}switchFoldStatus(node){const expanded=!node.expanded;node.setExpanded(expanded);if(expanded!=this.chartDef.pivotTableOptions.areRowsExpandedByDefault){this.chartDef.pivotTableOptions.rowIdByCustomExpandedStatus[node.id]=expanded}else{delete this.chartDef.pivotTableOptions.rowIdByCustomExpandedStatus[node.id]}}convert(){const columnTree=this.buildColumnTree();const rowTree=this.buildRowTree();const{rowData,subtotalRowData,grandTotalRowData}=this.filterRowTreeAndConvertToRowData(rowTree);const{columnDefs,grandTotalColumnDef}=this.filterColumnTreeAndConvertToColumnDefs(columnTree);const fullRowData=[...rowData];if(this.chartDef.pivotTableOptions.displayTotals.subTotals.rows){fullRowData.push(...subtotalRowData)}if(grandTotalRowData&&this.chartDef.pivotTableOptions.displayTotals.grandTotal.row){fullRowData.push(grandTotalRowData)}if(grandTotalColumnDef){columnDefs.push(grandTotalColumnDef)}return{defaultColDef:{sortable:false,resizable:true,filter:false},treeData:this.chartDef.pivotTableOptions.tableFormatting.showRowHeaders?true:false,icons:{groupExpanded:" ",groupContracted:" "},debug:false,rowHeight:this.getRowHeight(),groupHeaderHeight:this.getGroupHeaderHeight(),headerHeight:this.getHeaderHeight(),enableCellTextSelection:true,suppressFieldDotNotation:true,rowData:fullRowData,columnDefs:columnDefs,columnTypes:{rowNavigationColumn:{suppressHeaderMenuButton:true,cellRenderer:"cellWithChevronRenderer",cellRendererParams:{tooltips:this.tooltips,contextualMenu:this.contextualMenu,genericMeasures:this.chartDef.genericMeasures,colorGroupByMeasureId:this.colorGroupByMeasureId,colorMode:this.chartDef.colorMode,rowHeadersCallbacks:PivotTableUtils.getToggleRowHeadersCallbacks(this.chartDef,this.chartHandler.openSection)},cellStyle:this.rowSubheadersFormatting},subtotalColumn:{suppressHeaderMenuButton:true,cellStyle:{...SUBTOTAL_COLUMN_STYLE,...this.valuesFormatting},cellRenderer:"cellWithTooltipRenderer",cellRendererParams:{tooltips:this.tooltips,contextualMenu:this.contextualMenu,rowDimensionId:this.rowDimensionId,colorGroupByMeasureId:this.colorGroupByMeasureId,theme:this.chartHandler.getChartTheme(),chartDef:this.chartDef}},grandTotalGroupColumn:{suppressHeaderMenuButton:true},grandTotalColumn:{suppressHeaderMenuButton:true,cellRenderer:"cellWithTooltipRenderer",cellRendererParams:{tooltips:this.tooltips,contextualMenu:this.contextualMenu,rowDimensionId:this.rowDimensionId,colorGroupByMeasureId:this.colorGroupByMeasureId,theme:this.chartHandler.getChartTheme(),chartDef:this.chartDef},cellStyle:{...GRAND_TOTAL_COLUMN_STYLE,...this.valuesFormatting}},dimensionLabelColumn:{suppressHeaderMenuButton:true,cellStyle:{...this.columnSubheadersFormatting}},groupAggregationColumn:{suppressHeaderMenuButton:true,cellStyle:{...this.valuesFormatting}},leafAggregationColumn:{suppressHeaderMenuButton:true,cellRenderer:"cellWithTooltipRenderer",cellRendererParams:{tooltips:this.tooltips,contextualMenu:this.contextualMenu,rowDimensionId:this.rowDimensionId,colorGroupByMeasureId:this.colorGroupByMeasureId,theme:this.chartHandler.getChartTheme(),chartDef:this.chartDef},cellStyle:{...LEAF_ROW_STYLE,...this.valuesFormatting}},measureLabelColumn:{suppressHeaderMenuButton:true,cellRenderer:"cellWithTooltipRenderer",cellRendererParams:{tooltips:this.tooltips,contextualMenu:this.contextualMenu,rowDimensionId:this.rowDimensionId,colorGroupByMeasureId:this.colorGroupByMeasureId,canHideHeaders:this.yDimensions.length<=1,rowHeadersCallbacks:PivotTableUtils.getToggleRowHeadersCallbacks(this.chartDef,this.chartHandler.openSection),theme:this.chartHandler.getChartTheme(),chartDef:this.chartDef},cellStyle:{...MEASURE_COLUMN_STYLE,...this.rowSubheadersFormatting}}},suppressContextMenu:true,getRowId:row=>{if(row!=null&&row.data!=null){return row.data.id}},sideBar:{toolPanels:[{id:ExpandCollapseToolPanel.id,labelDefault:ExpandCollapseToolPanel.label,labelKey:ExpandCollapseToolPanel.id,iconKey:"",toolPanel:ExpandCollapseToolPanel,toolPanelParams:{$rootElement:this.$rootElement,chartDef:this.chartDef}},{id:DisplayTotalsToolPanel.id,labelDefault:DisplayTotalsToolPanel.label,labelKey:DisplayTotalsToolPanel.id,iconKey:"",toolPanel:DisplayTotalsToolPanel,toolPanelParams:{$rootElement:this.$rootElement,pivotDisplayTotals:this.chartDef.pivotTableOptions.displayTotals,hasSubtotalRows:this.yDimensions.length>1,hasSubtotalColumns:this.xDimensions.length>1,hasGrandTotalRow:grandTotalRowData!==undefined&&!ChartFeatures.isPivotTableWithNoDimension(this.chartDef),hasGrandTotalColumn:grandTotalColumnDef!==undefined,subtotalColumnType:"subtotalColumn",rowData:rowData,subtotalRowData:subtotalRowData,grandTotalRowData:grandTotalRowData,grandTotalColumnDef:grandTotalColumnDef,recomputeColorScale:()=>{const colorProperties=this.computeColorTableProperties(this.chartDef.colorOptions);this.colorScale=colorProperties.colorScale}}}]},getDataPath:row=>row[this.getRowGroupKey()],autoGroupColumnDef:{showRowGroup:"",headerName:this.chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders?ChartLabels.getDimensionLabel(this.yDimensions[0]):"",headerComponentParams:{formatting:this.rowMainHeadersFormatting,isRowMainHeader:true},lockPosition:true,cellRendererParams:{suppressCount:true,suppressPadding:true,tooltips:this.tooltips,contextualMenu:this.contextualMenu,innerRenderer:"cellWithChevronRenderer"},cellStyle:this.rowSubheadersFormatting,width:this.getRowDimensionsColumnWidth(AUTOGROUP_COLUMN_KEY,ChartLabels.getDimensionLabel(this.yDimensions[0]),fullRowData.map(row=>{const autoGroupColumnCellContent=this.switchRowPathIdToAutoGroupColumnCellContent(row);return autoGroupColumnCellContent?autoGroupColumnCellContent.label:""}),this.yDimensions.length>1?CHEVRON_OFFSET_WIDTH+ROW_OFFSET_WIDTH:ROW_OFFSET_WIDTH),pinned:this.chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders?"left":null,valueGetter:params=>{return this.switchRowPathIdToAutoGroupColumnCellContent(params.data)}},components:{cellWithTooltipRenderer:CellWithTooltipRenderer,cellWithChevronRenderer:params=>this.cellWithChevronRenderer(params),agColumnGroupHeader:CustomHeader,agColumnHeader:CustomHeader},onRowGroupOpened:e=>{return this.toggleSubTotalDisplayOnParentRow(e)},getRowStyle:params=>{return this.addSubtotalRowStyle(params)},onColumnResized:params=>{if(_.isNil(params.columns)||!params.finished||params.source!=="uiColumnResized"){return}params.columns.forEach(column=>{const newCustomWidth=parseInt(column.getActualWidth());const colId=column.getId();if(!_.isNil(colId)&&!_.isNil(newCustomWidth)&&this.chartDef.pivotTableOptions.columnIdByCustomWidth[colId]!==newCustomWidth){this.chartDef.pivotTableOptions.columnIdByCustomWidth[colId]=newCustomWidth}})},ensureDomOrder:true,sendToClipboard:()=>{ClipboardUtils.copyToClipboard((getSelection()||"").toString())},groupHideOpenParents:true}}computeColorTableProperties(colorOptions,colorMeasureIndex=-1,measure=undefined){let hasColorMeasure=false;let colorScale;let extentFormatter;if(this.data.aggregations.length>0&&(this.chartDef.colorMeasure.length>0||colorMeasureIndex>=0)&&!ChartFeatures.isPivotTableWithNoDimension(this.chartDef)){hasColorMeasure=true;if(colorMeasureIndex<0){colorMeasureIndex=this.data.aggregations.length-1}else{extentFormatter=ChartFormatting.getForIsolatedNumber(measure)}const yDimensionIds=this.yDimensions.map(yDim=>this.chartStore.getDimensionId(yDim));const xDimensionIds=this.xDimensions.map(xDim=>this.chartStore.getDimensionId(xDim));const colorContext={chartData:this.chartData,colorOptions:colorOptions,defaultLegendDimension:this.chartDef.genericMeasures,colorSpec:{type:"MEASURE",measureIdx:colorMeasureIndex,withRgba:true,colorAggrFn:HierarchicalChartsUtils.getColorMeasureAggFunction(this.chartDef,colorMeasureIndex),binsToInclude:HierarchicalChartsUtils.getBinsToIncludeInColorScale(this.chartData,xDimensionIds,yDimensionIds,colorMeasureIndex,this.chartDef,this.chartDef.pivotTableOptions.displayTotals.subTotals.rows,this.chartDef.pivotTableOptions.displayTotals.subTotals.columns)},theme:this.chartHandler.getChartTheme()};colorScale=ChartColorScales.createColorScale(colorContext);colorScale.extentFormatter=extentFormatter;ChartLegendUtils.initLegend(this.chartDef,this.chartData,this.chartHandler.legendsWrapper,colorScale);this.chartDef.colorMeasure["$mIdx"]=colorMeasureIndex}return{hasColorMeasure:hasColorMeasure,colorMeasureIndex:colorMeasureIndex,colorScale:colorScale}}filterColumnTreeAndConvertToColumnDefs(columnTree){const columnDefs=[];const queue=new LinkedList(columnTree.map(column=>column));while(queue.length){const curr=queue.shift();if(!curr.isEmpty){if(curr.parent===null){columnDefs.push(curr.agGridColumn)}else{if(curr.parent.agGridColumn.children===undefined){curr.parent.agGridColumn.children=[]}curr.parent.agGridColumn.children.push(curr.agGridColumn)}if(curr.children&&curr.children.length){curr.children.forEach(child=>{if(!child.isEmpty){queue.push(child)}})}}}if(this.hasGrandTotalColumn()){return{columnDefs:columnDefs,grandTotalColumnDef:this.getGrandTotalColumn()}}else{return{columnDefs:columnDefs}}}addSubtotalRowStyle(params){const isSubtotalRow=params.data[COLOR_FLAG_KEY];const rowPath=params.data[this.getRowGroupKey()];let isGrandTotalRow=false;if(rowPath&&rowPath.length>0){isGrandTotalRow=rowPath[0]===GRAND_TOTAL_KEY}if(isGrandTotalRow){return{...GRAND_TOTAL_ROW_STYLE,...this.valuesFormatting}}else if(isSubtotalRow){return{...SUB_TOTAL_ROW_STYLE,...this.valuesFormatting}}}switchRowPathIdToAutoGroupColumnCellContent(row){const nodePath=row[this.getRowGroupKey()];if(this.mapGroupColumnCellIdToHeaderName.has(nodePath)){return this.mapGroupColumnCellIdToHeaderName.get(nodePath)}}toggleSubTotalDisplayOnParentRow(e){for(const key in e.node.data){if(Object.hasOwnProperty.call(e.node.data,key)){if(typeof e.node.data[key]==="object"){e.node.data[key].hidden=e.node.expanded}}}e.node.setData(e.node.data)}buildRowTree(){const[head,...tail]=this.yDimensions;const headIndex=0;const stack=[];const rowTree=[];const dimensionId=this.chartStore.getDimensionId(head);const axisLabels=this.chartData.getAxisLabels(dimensionId);const minValue=this.chartData.getMinValue(dimensionId);const maxValue=this.chartData.getMaxValue(dimensionId);const numValues=this.chartData.getNumValues(dimensionId);const numberFormattingOptions=ChartDimension.getNumberFormattingOptions(head);for(let i=0;i<axisLabels.length;i++){const axisLabel=axisLabels[i];if(i!==this.chartData.getSubtotalLabelIndex(dimensionId)){const yCoordDict={};yCoordDict[dimensionId]=i;const rowData={rowPath:[dimensionId+SUB_COLUMN_SEPARATOR+axisLabel.label],parent:null,children:[],isFirstChild:i===0,depth:0,headerName:ChartLabels.getFormattedLabel(axisLabel,numberFormattingOptions,minValue,maxValue,numValues),isEmpty:true,yCoordDict:yCoordDict,head:head,tail:tail,headIndex:headIndex};rowTree.push(rowData);stack.push(rowData)}}while(stack.length!==0){const curr=stack.pop();curr.agGridRow={id:curr.rowPath.join(SUB_COLUMN_SEPARATOR)};this.fillRowNavigationColumnsInRow(curr);if(curr.tail&&curr.tail.length>0){this.fillSubTotalsInRow(curr,true);this.fillGrandTotalsInRow(curr);const[childHead,...childTail]=curr.tail;const childHeadIndex=curr.headIndex+1;const childDimensionId=this.chartStore.getDimensionId(childHead);const childValues=this.chartData.getAxisLabels(childDimensionId);const childMinValue=this.chartData.getMinValue(childDimensionId);const childMaxValue=this.chartData.getMaxValue(childDimensionId);const childNumValues=this.chartData.getNumValues(childDimensionId);const childNumberFormattingOptions=ChartDimension.getNumberFormattingOptions(childHead);for(let j=0;j<childValues.length;j++){const childValue=childValues[j];if(j!==this.chartData.getSubtotalLabelIndex(childDimensionId)){const childYCoordDict={...curr.yCoordDict};childYCoordDict[childDimensionId]=j;const childRowData={rowPath:[...curr.rowPath,childDimensionId+SUB_COLUMN_SEPARATOR+childValue.label],parent:curr,children:[],yCoordDict:childYCoordDict,tail:childTail,head:childHead,headIndex:childHeadIndex,headerName:ChartLabels.getFormattedLabel(childValue,childNumberFormattingOptions,childMinValue,childMaxValue,childNumValues),isFirstChild:j===0,depth:curr.depth+1,isEmpty:true};curr.children.push(childRowData);stack.push(childRowData)}}}else{const isEmpty=this.fillMeasuresInRow(curr);if(!isEmpty){this.fillSubTotalsInRow(curr,false);this.fillGrandTotalsInRow(curr)}}}return rowTree}setNotEmptyFlagsToRowBranch(rowData){rowData.isEmpty=false;let parent=rowData.parent;while(parent&&parent.isEmpty){parent.isEmpty=false;parent=parent.parent}}setNotEmptyFlagsToColumnBranch(columnData){columnData.isEmpty=false;let parent=columnData.parent;while(parent&&parent.isEmpty){parent.isEmpty=false;parent=parent.parent}}filterRowTreeAndConvertToRowData(rowTree){const rowData=[];const subtotalRowData=[];const stack=[...rowTree.reverse()];while(stack.length){const curr=stack.pop();if(!curr.isEmpty){rowData.push(curr.agGridRow);this.fillRowNavigationColumnsInRow(curr);if(curr.children.length){let hasFoundFirstNotEmpty=false;curr.children.map(child=>{if(!child.isEmpty){if(!hasFoundFirstNotEmpty){child.isFirstChild=true;hasFoundFirstNotEmpty=true}stack.unshift(child)}});subtotalRowData.push(this.getSubtotalLeafRow(curr))}}}if(this.hasGrandTotalRow()){return{rowData:rowData,subtotalRowData:subtotalRowData,grandTotalRowData:this.getGrandTotalRow()}}else{return{rowData:rowData,subtotalRowData:subtotalRowData}}}fillRowNavigationColumnsInRow(currentRow){const isSubtotalRow=currentRow.rowPath[currentRow.rowPath.length-1]===SUBTOTAL_LEAF_ROW_KEY;if(isSubtotalRow){return}currentRow.agGridRow[this.getRowGroupKey()]=currentRow.rowPath;const cellContent={label:currentRow.headerName,depth:0};if(this.yDimensions[0]===currentRow.head){this.mapGroupColumnCellIdToHeaderName.set(currentRow.rowPath,cellContent)}else{currentRow.agGridRow[this.chartStore.getDimensionId(currentRow.head)]=cellContent}if(currentRow.isFirstChild&&currentRow.headIndex>0){let currParent=currentRow.parent;let currDepth=1;let currRowDimIndex=currentRow.headIndex-1;let currDimensionId=this.chartStore.getDimensionId(this.yDimensions[currRowDimIndex]);while(currRowDimIndex>=0&&currParent&&currParent.agGridRow){if(currRowDimIndex===0&&this.mapGroupColumnCellIdToHeaderName.has(currParent.rowPath)){const parentCellContent=this.mapGroupColumnCellIdToHeaderName.get(currParent.rowPath);this.mapGroupColumnCellIdToHeaderName.set(currentRow.rowPath,{label:parentCellContent.label,depth:currDepth})}else{currentRow.agGridRow[currDimensionId]={label:currParent.agGridRow[currDimensionId].label,depth:currDepth}}--currRowDimIndex;currDepth++;if(currParent&&!currParent.isFirstChild){break}currParent=currParent.parent;currDimensionId=this.chartStore.getDimensionId(this.yDimensions[currRowDimIndex])}}}fillMeasuresInRow(currentRow){throw new Error("Method not implemented")}getSubtotalLeafRow(currentRow){const deepCopy=Object.keys(currentRow.agGridRow).filter(colId=>!this.rowDimensionId.has(colId)).reduce((acc,key)=>{if(typeof currentRow.agGridRow[key]==="object"){acc[key]={...currentRow.agGridRow[key]}}else{acc[key]=currentRow.agGridRow[key]}return acc},{});const aggridSubtotalLeafRow=deepCopy;const parentRowPath=currentRow.agGridRow[this.getRowGroupKey()];const subtotalLeafRowPath=[...parentRowPath,SUBTOTAL_LEAF_ROW_KEY];aggridSubtotalLeafRow[this.getRowGroupKey()]=subtotalLeafRowPath;aggridSubtotalLeafRow.id=subtotalLeafRowPath.join(SUB_COLUMN_SEPARATOR);if(currentRow.head===this.yDimensions[0]){this.mapGroupColumnCellIdToHeaderName.set(subtotalLeafRowPath,{label:this.chartDef.pivotTableOptions.tableFormatting.showRowHeaders?"Total "+currentRow.headerName:"",depth:0,hasOffset:true})}else{aggridSubtotalLeafRow[this.chartStore.getDimensionId(currentRow.head)]={label:this.chartDef.pivotTableOptions.tableFormatting.showRowHeaders?"Total "+currentRow.headerName:"",depth:0,hasOffset:true}}currentRow.agGridRow[COLOR_FLAG_KEY]=true;return aggridSubtotalLeafRow}fillSubTotalsInRow(currrentRow,isGroupRow){throw new Error("Method not implemented")}fillGrandTotalsInRow(currrentRow){throw new Error("Method not implemented")}hasGrandTotalRow(){return this.chartDef.genericMeasures.filter(measure=>measure.computeMode==="NORMAL").length>0}getGrandTotalRow(){throw new Error("Method not implemented")}buildColumnTree(){const columnTree=[...this.getRowNavigationColumns()];const[head,...tail]=this.xDimensions;const headIndex=0;const stack=[];const isMeasureTreatedAsColumn=this.chartDef.pivotTableOptions.measureDisplayMode!==ChartsStaticData.pivotTableMeasureDisplayMode.ROWS&&PivotTableUtils.hasRows(this.chartDef)&&PivotTableUtils.hasColumns(this.chartDef);const parentDimensionId=this.chartStore.getDimensionId(head);const minValue=this.chartData.getMinValue(parentDimensionId);const maxValue=this.chartData.getMaxValue(parentDimensionId);const numValues=this.chartData.getNumValues(parentDimensionId);const numberFormattingOptions=ChartDimension.getNumberFormattingOptions(head);const showColumnHeaders=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders;const showColumnMainHeaders=showColumnHeaders&&this.chartDef.pivotTableOptions.tableFormatting.showColumnMainHeaders;const dimensionLabelHeaderName=ChartLabels.getDimensionLabel(head);const dimensionLabelColumnData={agGridColumn:{groupId:parentDimensionId,type:"dimensionLabelColumn",headerName:dimensionLabelHeaderName,headerGroupComponentParams:{formatting:this.columnMainHeadersFormatting,isColumnMainHeader:true},columnGroupShow:"open",children:[],width:this.computeColumnWidth(dimensionLabelHeaderName,this.columnMainHeadersFormatting)},parent:null,isEmpty:false,children:[]};if(showColumnMainHeaders){columnTree.push(dimensionLabelColumnData)}const axisLabels=this.chartData.getAxisLabels(parentDimensionId);const headerComponentConfig={headerComponentParams:{formatting:this.columnSubheadersFormatting}};for(let i=0;i<axisLabels.length;i++){const axisLabel=axisLabels[i];if(i!==this.chartData.getSubtotalLabelIndex(parentDimensionId)){const headerName=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders?ChartLabels.getFormattedLabel(axisLabel,numberFormattingOptions,minValue,maxValue,numValues):"";const xCoordDict={};xCoordDict[parentDimensionId]=i;const groupId=`${dimensionLabelColumnData.agGridColumn.groupId}-${xCoordDict[parentDimensionId]}`;const columnData={parent:showColumnMainHeaders?dimensionLabelColumnData:null,isEmpty:true,xCoordDict:xCoordDict,head:head,tail:tail,headIndex:headIndex,agGridColumn:{groupId:groupId,headerName:headerName,columnGroupShow:"open",openByDefault:this.computeColumnExpandedStatus(groupId),type:"groupAggregationColumn",width:this.computeColumnWidth(headerName,this.columnMainHeadersFormatting,!!tail.length)},children:[]};const isLeafColumn=!isMeasureTreatedAsColumn&&tail.length===0;if(isLeafColumn){columnData.agGridColumn={...columnData.agGridColumn,...headerComponentConfig}}else{columnData.agGridColumn={...columnData.agGridColumn,headerGroupComponentParams:{...headerComponentConfig.headerComponentParams,hasChevron:!!tail.length,chartDef:this.chartDef}}}stack.push(columnData);if(showColumnMainHeaders){dimensionLabelColumnData.children.push(columnData)}else{columnTree.push(columnData)}}}while(stack.length!==0){const curr=stack.pop();const dimensionId=this.chartStore.getDimensionId(curr.head);if(curr.tail&&curr.tail.length>0){curr.agGridColumn.cellStyle=SUBTOTAL_COLUMN_STYLE;const[childHead,...childTail]=curr.tail;const childHeadIndex=curr.headIndex+1;const childDimensionId=this.chartStore.getDimensionId(childHead);const childMinValue=this.chartData.getMinValue(childDimensionId);const childMaxValue=this.chartData.getMaxValue(childDimensionId);const childNumValues=this.chartData.getNumValues(childDimensionId);const childNumberFormattingOptions=ChartDimension.getNumberFormattingOptions(childHead);const childValues=this.chartData.getAxisLabels(childDimensionId);const subDimensionLabelHeaderName=ChartLabels.getDimensionLabel(childHead);const groupId=curr.agGridColumn.groupId+SUB_COLUMN_SEPARATOR+childDimensionId;const subDimensionLabelColumnData={agGridColumn:{groupId:groupId,headerName:subDimensionLabelHeaderName,type:"dimensionLabelColumn",columnGroupShow:"open",children:[],width:this.computeColumnWidth(subDimensionLabelHeaderName,this.columnMainHeadersFormatting),headerGroupComponentParams:{formatting:this.columnMainHeadersFormatting,isColumnMainHeader:true}},parent:showColumnMainHeaders?curr:null,isEmpty:true,xCoordDict:curr.xCoordDict,head:curr.head,tail:curr.tail,headIndex:childHeadIndex,children:[]};if(showColumnHeaders&&showColumnMainHeaders){curr.children.push(subDimensionLabelColumnData)}for(let j=0;j<childValues.length;j++){const childValue=childValues[j];if(j!==this.chartData.getSubtotalLabelIndex(childDimensionId)){const childXCoordDict={...curr.xCoordDict};childXCoordDict[childDimensionId]=j;const childHeaderName=showColumnHeaders?ChartLabels.getFormattedLabel(childValue,childNumberFormattingOptions,childMinValue,childMaxValue,childNumValues):"";const groupId=`${curr.agGridColumn.groupId}-${childXCoordDict[childDimensionId]}`;const childColumnData={isEmpty:true,parent:showColumnHeaders&&showColumnMainHeaders?subDimensionLabelColumnData:curr,xCoordDict:childXCoordDict,head:childHead,tail:childTail,headIndex:childHeadIndex,agGridColumn:{groupId:groupId,headerName:childHeaderName,columnGroupShow:"open",openByDefault:this.computeColumnExpandedStatus(groupId),type:"groupAggregationColumn",width:this.computeColumnWidth(childHeaderName,this.columnSubheadersFormatting,!!childTail.length)},children:[]};const isLeafColumn=!isMeasureTreatedAsColumn&&childTail.length===0;if(isLeafColumn){childColumnData.agGridColumn={...childColumnData.agGridColumn,...headerComponentConfig}}else{childColumnData.agGridColumn={...childColumnData.agGridColumn,headerGroupComponentParams:{formatting:this.columnSubheadersFormatting,hasChevron:!!childTail.length,chartDef:this.chartDef}}}if(showColumnHeaders&&showColumnMainHeaders){subDimensionLabelColumnData.children.push(childColumnData)}else{curr.children.push(childColumnData)}stack.push(childColumnData)}}this.addSubTotalParentColumnsInColumnTree(curr,dimensionId)}else{this.addMeasuresInColumnTree(curr)}}return columnTree}getRowNavigationColumns(){const columns=[];this.yDimensions.map((dimension,i)=>{if(i>0){const headerName=this.chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders?ChartLabels.getDimensionLabel(dimension):"";const dimensionId=this.chartStore.getDimensionId(dimension);const numberFormattingOptions=ChartDimension.getNumberFormattingOptions(dimension);const minValue=this.chartData.getMinValue(dimensionId);const maxValue=this.chartData.getMaxValue(dimensionId);const numValues=this.chartData.getNumValues(dimensionId);const labels=this.chartData.getAxisLabels(dimensionId).filter((_,i)=>i!==this.chartData.getSubtotalLabelIndex(dimensionId)).map(labelObj=>ChartLabels.getFormattedLabel(labelObj,numberFormattingOptions,minValue,maxValue,numValues));const isLast=i===this.yDimensions.length-1;const colId=dimensionId;const width=this.getRowDimensionsColumnWidth(colId,headerName,labels,isLast?0:CHEVRON_OFFSET_WIDTH);columns.push({parent:null,isEmpty:false,agGridColumn:{colId:colId,field:colId,headerName:headerName,headerComponentParams:{formatting:this.rowMainHeadersFormatting,isRowMainHeader:true},type:"rowNavigationColumn",width:width,lockPosition:true,pinned:this.chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders?"left":null}})}});return columns}addMeasuresInColumnTree(currColumn){throw new Error("Method not implemented")}addSubTotalParentColumnsInColumnTree(currColumn,dimensionId){throw new Error("Method not implemented")}hasGrandTotalColumn(){return this.chartDef.genericMeasures.filter(measure=>measure.computeMode==="NORMAL").length>0}getGrandTotalColumn(){throw new Error("Method not implemented")}getLeafColumnId(parentColumnId,measureId){return parentColumnId===""?measureId:parentColumnId+SUB_COLUMN_SEPARATOR+measureId}getMeasureLabel(measure){return ChartLabels.getLongMeasureLabel(measure)}getRowGroupKey(){return this.chartStore.getDimensionId(this.yDimensions[0])}getRowHeight(){return DEFAULT_ROW_HEIGHT}getHeaderHeight(){const showColumnHeaders=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders;const showRowHeaders=this.chartDef.pivotTableOptions.tableFormatting.showRowHeaders;const showRowMainHeaders=this.chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders;const noRowMainHeaders=!showRowHeaders||!showRowMainHeaders;const noColumnMainHeaders=!this.chartDef.pivotTableOptions.tableFormatting.showColumnMainHeaders;const noRowDimension=this.yDimensions.length===0;const noColumnDimension=this.xDimensions.length===0;const onlyOneMeasure=this.chartDef.genericMeasures.length===1;switch(showColumnHeaders){case false:if(noRowDimension&&onlyOneMeasure||noRowMainHeaders){return 0}break;case true:if(noColumnDimension&&noColumnMainHeaders&&noRowMainHeaders){return 0}break}}getGroupHeaderHeight(){if(!this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders&&this.chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders){return 0}}computeCellValue(aggregationIndex,measure,cellCoords,isSubOrGrandTotal,hasTooltipAndContextualMenu=true){if(measure.computeMode!=="NORMAL"&&isSubOrGrandTotal){return{value:"NA",originalValue:"",cellCoords:cellCoords,colorMeasureValue:"",colorMeasureOriginalValue:"",hasTooltipAndContextualMenu:false}}let value=this.chartData.getSubtotalPoint(aggregationIndex,cellCoords);let colorMeasureValue;let colorMeasureOriginalValue;const colorGroup=this.colorGroupByMeasureId?this.colorGroupByMeasureId[ConditionalFormattingOptions.getMeasureId(measure)]:undefined;const groupColorMeasure=colorGroup?colorGroup.basedOnMeasure:undefined;const groupColorMeasureAggregationIndex=colorGroup?colorGroup.basedOnMeasureIndex:undefined;if(groupColorMeasure&&groupColorMeasureAggregationIndex<this.chartData.data.aggregations.length){const displayEmpty=this.chartDef.pivotTableOptions&&this.chartDef.pivotTableOptions.displayEmptyValues;const formatter=ChartFormatting.getForIsolatedNumber({...groupColorMeasure,displayEmpty:displayEmpty});colorMeasureOriginalValue=this.chartData.getSubtotalPoint(groupColorMeasureAggregationIndex,cellCoords);if(!this.chartData.isBinMeaningful(colorGroup.basedOnMeasure.function,cellCoords,groupColorMeasureAggregationIndex)){colorMeasureOriginalValue=""}colorMeasureValue=formatter(colorMeasureOriginalValue)}const count=isSubOrGrandTotal||measure.computeMode==="DIFFERENCE"?1:this.chartData.getNonNullCount(cellCoords,aggregationIndex);const formattedValue=this.cellFormatters[aggregationIndex]?this.cellFormatters[aggregationIndex](value,count):value;value=count>0?value:"";return{value:formattedValue,originalValue:value,colorMeasureValue:colorMeasureValue,colorMeasureOriginalValue:colorMeasureOriginalValue,cellCoords:cellCoords,hasTooltipAndContextualMenu:hasTooltipAndContextualMenu}}computeCellColorProperties(cellCoords,isSubTotal=false,aggrIdx=[]){let measure;if(this.hasColorMeasure){if(isSubTotal){measure=this.chartData.getSubtotalPoint(this.colorMeasureIndex,cellCoords)}else if(!PivotTableUtils.hasCellValueForCoords(this.chartData,aggrIdx,cellCoords,this.chartDef.pivotTableOptions.displayEmptyValues)){return undefined}else{measure=this.chartData.getAggrPoint(this.colorMeasureIndex,cellCoords)}return{getColorScale:()=>this.colorScale,measure:measure,bin:this.chartData.getAggrLoc(this.colorMeasureIndex,cellCoords)}}else{return undefined}}computeColumnExpandedStatus(columnGroupId){return!_.isNil(this.chartDef.pivotTableOptions.columnIdByCustomExpandedStatus)&&!_.isNil(this.chartDef.pivotTableOptions.columnIdByCustomExpandedStatus[columnGroupId])?this.chartDef.pivotTableOptions.columnIdByCustomExpandedStatus[columnGroupId]:this.chartDef.pivotTableOptions.areColumnExpandedByDefault}computeRowExpandedStatus(rowId){return!_.isNil(this.chartDef.pivotTableOptions.rowIdByCustomExpandedStatus)&&!_.isNil(this.chartDef.pivotTableOptions.rowIdByCustomExpandedStatus[rowId])?this.chartDef.pivotTableOptions.rowIdByCustomExpandedStatus[rowId]:this.chartDef.pivotTableOptions.areRowsExpandedByDefault}computeColumnWidth(label,formatting,hasChevron=false){const labelWidth=PivotTableUtils.getTextWidth(label,formatting.fontSize,formatting.fontFamily);return hasChevron?labelWidth+CHEVRON_OFFSET_WIDTH:labelWidth}hasCustomWidth(colId){return!_.isNil(colId)&&!_.isNil(this.chartDef.pivotTableOptions.columnIdByCustomWidth)&&!_.isNil(this.chartDef.pivotTableOptions.columnIdByCustomWidth[colId])}getCustomWidth(colId){return this.chartDef.pivotTableOptions.columnIdByCustomWidth[colId]}adjustColumnWidthFromCell(cellValue,columnData){if(this.hasCustomWidth(columnData.agGridColumn.colId)){return}let width=this.computeColumnWidth(cellValue,this.valuesFormatting);let currCol=columnData;while(currCol){if(currCol.agGridColumn.width>width){width=currCol.agGridColumn.width}currCol=currCol.parent}columnData.agGridColumn.width=width}adjustGrandTotalColumnWidthFromCell(cellValue,colId){if(this.hasCustomWidth(colId)){return}const textWidth=PivotTableUtils.getTextWidth(cellValue,this.valuesFormatting.fontSize,this.valuesFormatting.fontFamily);if(this.grandTotalColumnMaxCellWidth.has(colId)){this.grandTotalColumnMaxCellWidth.set(colId,Math.max(this.grandTotalColumnMaxCellWidth.get(colId),textWidth))}else{this.grandTotalColumnMaxCellWidth.set(colId,textWidth)}}getRowDimensionsColumnWidth(colId,label,cellLabels,offset=0){if(this.hasCustomWidth(colId)){return this.getCustomWidth(colId)}let width=this.computeColumnWidth(label,this.rowMainHeadersFormatting);width=cellLabels.reduce((acc,label)=>Math.max(acc,PivotTableUtils.getTextWidth(label,this.rowSubheadersFormatting.fontSize,this.rowSubheadersFormatting.fontFamily)),width);return width+offset}getLeafColumnCustomOrAutoSizedWidth(colId,label,formatting){if(this.hasCustomWidth(colId)){return this.getCustomWidth(colId)}else{return this.computeColumnWidth(label,formatting)}}getGrandTotalColumnCustomOrAutoSizedWidth(colId,leafColumnLabel=""){if(this.hasCustomWidth(colId)){return this.getCustomWidth(colId)}else{return Math.max(this.computeColumnWidth(GRAND_TOTAL_LABEL,this.columnSubheadersFormatting),this.computeColumnWidth(leafColumnLabel,this.columnSubheadersFormatting),this.grandTotalColumnMaxCellWidth.get(colId))}}}class RowAndColumnDimensionsWithMeasureAsRowConverter extends AbstractAGGridPivotTableChartConverter{filterRowTreeAndConvertToRowData(rowTree){const{rowData,subtotalRowData,grandTotalRowData}=super.filterRowTreeAndConvertToRowData(rowTree);this.addMeasureLabelsInMeasureColumn([...rowData,...subtotalRowData,grandTotalRowData]);return{rowData:rowData,subtotalRowData:subtotalRowData,grandTotalRowData:grandTotalRowData}}addMeasureLabelsInMeasureColumn(rowTree){const measureLabels=this.chartDef.genericMeasures.map(measure=>{return{value:this.getMeasureLabel(measure)}});for(let i=0;i<rowTree.length;i++){const row=rowTree[i];if(row){row[MEASURE_COLUMN_KEY]={measures:measureLabels,isMeasureColumn:true}}}}fillMeasuresInRow(currentRow){let isEmpty=true;currentRow.agGridRow.group=false;if(this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length>0){this.endColumns.map(endColumn=>{const cellCoords={...endColumn.xCoordDict,...currentRow.yCoordDict};const measures=this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const cellValue=this.computeCellValue(aggregationIndex,measure,cellCoords,false);const isTupleExistingInDataset=this.chartData.getCount(cellCoords)!==0;if(isTupleExistingInDataset){isEmpty=false;this.adjustColumnWidthFromCell(cellValue.value,endColumn.columnData);this.setNotEmptyFlagsToColumnBranch(endColumn.columnData)}return cellValue});currentRow.agGridRow[endColumn.id]={measures:measures,cellCoords:cellCoords,colorProperties:this.computeCellColorProperties(cellCoords,false,this.chartDef.genericMeasures.map((_,aggrIdx)=>aggrIdx))}})}if(!isEmpty){this.setNotEmptyFlagsToRowBranch(currentRow)}return isEmpty}fillSubTotalsInRow(currentRow,isGroupRow){this.subtotalColumns.map(subtotalColumn=>{const cellCoords={...subtotalColumn.xCoordDict,...currentRow.yCoordDict};const measures=this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const cellValue=this.computeCellValue(aggregationIndex,measure,cellCoords,true);this.adjustColumnWidthFromCell(cellValue.value,subtotalColumn.columnData);return cellValue});currentRow.agGridRow[subtotalColumn.id]={measures:measures,cellCoords:cellCoords,colorProperties:this.computeCellColorProperties(cellCoords,true)}});if(isGroupRow){this.endColumns.forEach(endColumn=>{const cellCoords={...endColumn.xCoordDict,...currentRow.yCoordDict};const measures=this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const cellValue=this.computeCellValue(aggregationIndex,measure,cellCoords,true);this.adjustColumnWidthFromCell(cellValue.value,endColumn.columnData);return cellValue});currentRow.agGridRow[endColumn.id]={measures:measures,cellCoords:cellCoords,colorProperties:this.computeCellColorProperties(cellCoords,true)}});currentRow.agGridRow[COLOR_FLAG_KEY]=true}}fillGrandTotalsInRow(currentRow){if(this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length>0){const measures=[];this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const hasTooltipAndContextualMenu=Object.keys(currentRow.yCoordDict).length>0;const cellContent=this.computeCellValue(aggregationIndex,measure,currentRow.yCoordDict,true,hasTooltipAndContextualMenu);this.adjustGrandTotalColumnWidthFromCell(cellContent.value,GRAND_TOTAL_KEY);measures.push(cellContent)});currentRow.agGridRow[GRAND_TOTAL_KEY]={measures:measures}}}getGrandTotalRow(){const grandTotalRow={};const rowPath=[GRAND_TOTAL_KEY];this.mapGroupColumnCellIdToHeaderName.set(rowPath,{label:this.chartDef.pivotTableOptions.tableFormatting.showRowHeaders?GRAND_TOTAL_LABEL:"",depth:0});grandTotalRow[this.getRowGroupKey()]=rowPath;grandTotalRow.id=rowPath.join(SUB_COLUMN_SEPARATOR);grandTotalRow.group=false;this.endColumns.forEach(endColumn=>{const measures=this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{if(endColumn.dimensionId!==undefined){const cellContent=this.computeCellValue(aggregationIndex,measure,endColumn.xCoordDict,true);this.adjustColumnWidthFromCell(cellContent.value,endColumn.columnData);return cellContent}});grandTotalRow[endColumn.id]={measures:measures}});const grandTotalMeasureColId=GRAND_TOTAL_KEY;const grandTotalMeasures=this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const cellContent=this.computeCellValue(aggregationIndex,measure,{},true,false);this.adjustGrandTotalColumnWidthFromCell(cellContent.value,GRAND_TOTAL_KEY);return cellContent});grandTotalRow[grandTotalMeasureColId]={measures:grandTotalMeasures};this.subtotalColumns.forEach(subtotalColumn=>{const measures=this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const cellContent=this.computeCellValue(aggregationIndex,measure,subtotalColumn.xCoordDict,true);this.adjustColumnWidthFromCell(cellContent.value,subtotalColumn.columnData);return cellContent});grandTotalRow[subtotalColumn.id]={measures:measures}});grandTotalRow[COLOR_FLAG_KEY]=true;return grandTotalRow}buildColumnTree(){const columnTree=super.buildColumnTree();if(this.chartDef.genericMeasures.length>1){const colId=MEASURE_COLUMN_KEY;const width=this.getRowDimensionsColumnWidth(colId,MEASURE_COLUMN_LABEL,this.chartDef.genericMeasures.map(measure=>this.getMeasureLabel(measure)));columnTree.splice(this.yDimensions.length-1,0,{isEmpty:false,parent:null,agGridColumn:{colId:colId,field:colId,headerName:this.chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders?MEASURE_COLUMN_LABEL:"",pinned:this.chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders?"left":null,type:"measureLabelColumn",width:width,lockPosition:true,headerComponentParams:{formatting:this.rowMainHeadersFormatting,isRowMainHeader:true}}})}return columnTree}addMeasuresInColumnTree(currColumn){const dimensionId=this.chartStore.getDimensionId(currColumn.head);this.endColumns.push({id:currColumn.agGridColumn.groupId,xCoordDict:currColumn.xCoordDict,dimensionId:dimensionId,columnData:currColumn});const colId=currColumn.agGridColumn.groupId;currColumn.agGridColumn.colId=colId;currColumn.agGridColumn.field=colId;currColumn.agGridColumn.cellRenderer="cellWithTooltipRenderer";currColumn.agGridColumn.cellRendererParams={tooltips:this.tooltips,contextualMenu:this.contextualMenu,colorGroupByMeasureId:this.colorGroupByMeasureId,chartDef:this.chartDef,theme:this.chartHandler.getChartTheme()};currColumn.agGridColumn.width=this.getLeafColumnCustomOrAutoSizedWidth(colId,currColumn.agGridColumn.headerName,this.columnSubheadersFormatting)}addSubTotalParentColumnsInColumnTree(currColumn,dimensionId){const colId=currColumn.agGridColumn.groupId+"__Total";const headerName=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders?"Total "+currColumn.agGridColumn.headerName:"";const subtotalColumnData={isEmpty:false,parent:currColumn,agGridColumn:{colId:colId,field:colId,type:"subtotalColumn",columnGroupShow:this.chartDef.pivotTableOptions.displayTotals.subTotals.columns?undefined:"closed",headerName:headerName,width:this.getLeafColumnCustomOrAutoSizedWidth(colId,headerName,this.columnSubheadersFormatting),headerComponentParams:{formatting:this.columnSubheadersFormatting}}};this.subtotalColumns.push({id:colId,xCoordDict:currColumn.xCoordDict,dimensionId:dimensionId,columnData:subtotalColumnData});currColumn.children.push(subtotalColumnData)}getGrandTotalColumn(){const grandTotalColumn={};const headerName=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders?GRAND_TOTAL_LABEL:"";grandTotalColumn.colId=GRAND_TOTAL_KEY;grandTotalColumn.field=GRAND_TOTAL_KEY;grandTotalColumn.headerName=headerName;grandTotalColumn.type="grandTotalColumn";grandTotalColumn.headerComponentParams={formatting:this.columnSubheadersFormatting};grandTotalColumn.initialHide=!this.chartDef.pivotTableOptions.displayTotals.grandTotal.column;grandTotalColumn.width=this.getGrandTotalColumnCustomOrAutoSizedWidth(GRAND_TOTAL_KEY);grandTotalColumn.suppressMovable=true;return grandTotalColumn}getRowHeight(){return this.chartDef.genericMeasures?this.chartDef.genericMeasures.length*DEFAULT_ROW_HEIGHT:DEFAULT_ROW_HEIGHT}}class OnlyColumnDimensionWithMeasureAsRowConverter extends RowAndColumnDimensionsWithMeasureAsRowConverter{convert(){const gridOptions=super.convert();return{...gridOptions,treeData:false}}buildRowTree(){const uniqueRowData={rowPath:[],yCoordDict:{},headerName:"",isEmpty:false,agGridRow:{id:UNIQUE_ROW_KEY}};return[uniqueRowData]}filterRowTreeAndConvertToRowData(rowTree){const uniqueAgGridRow=rowTree[0].agGridRow;uniqueAgGridRow[this.getRowGroupKey()]=[""];this.fillMeasuresInRow(rowTree[0]);this.fillSubTotalsInRow(rowTree[0],false);this.fillGrandTotalsInRow(rowTree[0]);this.addMeasureLabelsInMeasureColumn([uniqueAgGridRow]);return{rowData:[uniqueAgGridRow],subtotalRowData:[]}}hasGrandTotalRow(){return false}hasGrandTotalColumn(){return true}}class RowAndColumnDimensionsWithMeasureAsColumnConverter extends AbstractAGGridPivotTableChartConverter{fillMeasuresInRow(currentRow){let isEmpty=true;currentRow.agGridRow.group=false;if(this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length>0){this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const measureId=this.chartStore.getMeasureId(measure);this.endColumns.forEach(endColumn=>{const cellCoords={...endColumn.xCoordDict,...currentRow.yCoordDict};const cellValue=this.computeCellValue(aggregationIndex,measure,cellCoords,false);const isTupleExistingInDataset=this.chartData.getCount(cellCoords)!=0;if(isTupleExistingInDataset){isEmpty=false;this.adjustColumnWidthFromCell(cellValue.value,endColumn.columnData);this.setNotEmptyFlagsToColumnBranch(endColumn.columnData)}currentRow.agGridRow[this.getLeafColumnId(endColumn.id,measureId)]={measure:cellValue,measureIndex:aggregationIndex,cellCoords:cellCoords,colorProperties:this.computeCellColorProperties(cellCoords,false,[aggregationIndex])}})})}if(!isEmpty){this.setNotEmptyFlagsToRowBranch(currentRow)}return isEmpty}fillSubTotalsInRow(currentRow,isGroupRow){this.subtotalColumns.map(subtotalColumn=>{const cellCoords={...subtotalColumn.xCoordDict,...currentRow.yCoordDict};const cellValue=this.computeCellValue(subtotalColumn.aggregationIndex,subtotalColumn.measure,cellCoords,true);this.adjustColumnWidthFromCell(cellValue.value,subtotalColumn.columnData);currentRow.agGridRow[subtotalColumn.id]={measure:cellValue,measureIndex:subtotalColumn.aggregationIndex,cellCoords:cellCoords,colorProperties:this.computeCellColorProperties(cellCoords,true)}});if(isGroupRow){this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{this.endColumns.forEach(endColumn=>{const cellCoords={...endColumn.xCoordDict,...currentRow.yCoordDict};const measureId=this.chartStore.getMeasureId(measure);const cellValue=this.computeCellValue(aggregationIndex,measure,cellCoords,true);this.adjustColumnWidthFromCell(cellValue.value,endColumn.columnData);currentRow.agGridRow[this.getLeafColumnId(endColumn.id,measureId)]={measure:cellValue,measureIndex:aggregationIndex,cellCoords:cellCoords,colorProperties:this.computeCellColorProperties(cellCoords,true)}})});currentRow.agGridRow[COLOR_FLAG_KEY]=true}}fillGrandTotalsInRow(currentRow){if(this.chartDef.genericMeasures&&this.chartDef.genericMeasures.length>0){this.chartDef.genericMeasures.map((measure,aggregationIndex)=>{const measureId=this.chartStore.getMeasureId(measure);const grandTotalMeasureColId=this.getLeafColumnId(GRAND_TOTAL_KEY,measureId);const cellContent=this.computeCellValue(aggregationIndex,measure,currentRow.yCoordDict,true);this.adjustGrandTotalColumnWidthFromCell(cellContent.value,grandTotalMeasureColId);currentRow.agGridRow[grandTotalMeasureColId]={measure:cellContent,measureIndex:aggregationIndex}})}}getGrandTotalRow(){const grandTotalRow={};const rowPath=[GRAND_TOTAL_KEY];this.mapGroupColumnCellIdToHeaderName.set(rowPath,{label:GRAND_TOTAL_LABEL,depth:0});grandTotalRow[this.getRowGroupKey()]=rowPath;grandTotalRow.group=false;grandTotalRow.id=rowPath.join(SUB_COLUMN_SEPARATOR);this.endColumns.forEach(endColumn=>{this.chartDef.genericMeasures.forEach((measure,aggregationIndex)=>{const measureId=this.chartStore.getMeasureId(measure);if(endColumn.dimensionId!==undefined){const cellContent={measure:this.computeCellValue(aggregationIndex,measure,endColumn.xCoordDict,true),measureIndex:aggregationIndex};grandTotalRow[this.getLeafColumnId(endColumn.id,measureId)]=cellContent;this.adjustColumnWidthFromCell(cellContent.measure.value,endColumn.columnData)}const grandTotalMeasureColId=this.getLeafColumnId(GRAND_TOTAL_KEY,measureId);const grandTotalValue={measure:this.computeCellValue(aggregationIndex,measure,{},true,false),measureIndex:aggregationIndex};if(endColumn.id===""){grandTotalRow[this.getLeafColumnId(endColumn.id,measureId)]=grandTotalValue;this.adjustColumnWidthFromCell(grandTotalValue.measure.value,endColumn.columnData)}else{grandTotalRow[grandTotalMeasureColId]=grandTotalValue;this.adjustGrandTotalColumnWidthFromCell(grandTotalValue.measure.value,this.getLeafColumnId(GRAND_TOTAL_KEY,measureId))}})});this.subtotalColumns.forEach(subtotalColumn=>{const subtotalValue={measure:this.computeCellValue(subtotalColumn.aggregationIndex,subtotalColumn.measure,subtotalColumn.xCoordDict,true),measureIndex:subtotalColumn.aggregationIndex};grandTotalRow[subtotalColumn.id]=subtotalValue;this.adjustColumnWidthFromCell(subtotalValue.measure.value,subtotalColumn.columnData)});grandTotalRow[COLOR_FLAG_KEY]=true;return grandTotalRow}addMeasuresInColumnTree(currColumn){const dimensionId=this.chartStore.getDimensionId(currColumn.head);const areMeasuresTreatedAsRows=this.chartDef.pivotTableOptions.measureDisplayMode===ChartsStaticData.pivotTableMeasureDisplayMode.ROWS;currColumn.children=this.chartDef.genericMeasures.map((measure,i)=>{const measureId=this.chartStore.getMeasureId(measure);const colId=this.getLeafColumnId(currColumn.agGridColumn.groupId,measureId);let headerName="";if(areMeasuresTreatedAsRows&&this.chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders||this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders){headerName=this.getMeasureLabel(measure)}const leafColumnData={isEmpty:true,parent:currColumn,agGridColumn:{colId:colId,field:colId,headerName:headerName,type:"leafAggregationColumn",width:this.getLeafColumnCustomOrAutoSizedWidth(colId,this.getMeasureLabel(measure),this.columnSubheadersFormatting),headerComponentParams:{formatting:this.columnSubheadersFormatting}}};this.endColumns.push({id:currColumn.agGridColumn.groupId,xCoordDict:currColumn.xCoordDict,dimensionId:dimensionId,aggregationIndex:i,columnData:leafColumnData});return leafColumnData})}addSubTotalParentColumnsInColumnTree(currColumn,dimensionId){this.chartDef.genericMeasures.map((measure,i)=>{const colId=currColumn.agGridColumn.groupId+this.chartStore.getMeasureId(measure)+"__Total";const headerName=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders?this.getMeasureLabel(measure):"";const subtotalColumnData={isEmpty:false,parent:currColumn,agGridColumn:{colId:colId,field:colId,type:"subtotalColumn",headerName:headerName,columnGroupShow:this.chartDef.pivotTableOptions.displayTotals.subTotals.columns?undefined:"closed",width:this.getLeafColumnCustomOrAutoSizedWidth(colId,headerName,this.columnSubheadersFormatting),headerComponentParams:{formatting:this.columnSubheadersFormatting}}};this.subtotalColumns.push({id:colId,xCoordDict:currColumn.xCoordDict,dimensionId:dimensionId,aggregationIndex:i,measure:measure,columnData:subtotalColumnData});currColumn.children&&currColumn.children.push(subtotalColumnData)})}getGrandTotalColumn(){const grandTotalColumn={};const headerName=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders?GRAND_TOTAL_LABEL:"";grandTotalColumn.colId=GRAND_TOTAL_KEY;grandTotalColumn.field=GRAND_TOTAL_KEY;grandTotalColumn.headerName=headerName;grandTotalColumn.initialHide=!this.chartDef.pivotTableOptions.displayTotals.grandTotal.column;grandTotalColumn.type="grandTotalGroupColumn";grandTotalColumn.headerGroupComponentParams={formatting:this.columnSubheadersFormatting};grandTotalColumn.suppressMovable=true;grandTotalColumn.children=[];this.chartDef.genericMeasures.map(measure=>{const grandTotalLeaf={};const leafLabel=this.getMeasureLabel(measure);const measureId=this.chartStore.getMeasureId(measure);const colId=this.getLeafColumnId(grandTotalColumn.colId,measureId);grandTotalLeaf.colId=colId;grandTotalLeaf.field=colId;grandTotalLeaf.initialHide=!this.chartDef.pivotTableOptions.displayTotals.grandTotal.column;grandTotalLeaf.headerName=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders?this.getMeasureLabel(measure):"";grandTotalLeaf.type="grandTotalColumn";grandTotalLeaf.suppressMovable=true;grandTotalLeaf.headerComponentParams={formatting:this.columnSubheadersFormatting};grandTotalLeaf.width=this.getGrandTotalColumnCustomOrAutoSizedWidth(colId,leafLabel);grandTotalColumn.children.push(grandTotalLeaf)});return grandTotalColumn}}class OnlyRowDimensionWithMeasureAsColumnConverter extends RowAndColumnDimensionsWithMeasureAsColumnConverter{buildColumnTree(){const columnTree=[];columnTree.push(...this.getRowNavigationColumns());this.chartDef.genericMeasures.forEach(measure=>{const headerName=this.chartDef.pivotTableOptions.tableFormatting.showColumnHeaders&&this.chartDef.pivotTableOptions.tableFormatting.showColumnMainHeaders?this.getMeasureLabel(measure):"";const colId=this.chartStore.getMeasureId(measure);const leafData={parent:null,isEmpty:false,agGridColumn:{colId:colId,field:colId,headerName:headerName,type:"leafAggregationColumn",width:this.getLeafColumnCustomOrAutoSizedWidth(colId,headerName,this.columnMainHeadersFormatting),lockPosition:true,headerComponentParams:{formatting:this.columnMainHeadersFormatting}}};this.endColumns.push({id:"",xCoordDict:{},columnData:leafData});columnTree.push(leafData)});return columnTree}hasGrandTotalRow(){return true}hasGrandTotalColumn(){return false}}class NoDimensionWithMeasureOnlyConverter extends OnlyRowDimensionWithMeasureAsColumnConverter{buildRowTree(){return[]}getGrandTotalRow(){this.chartDef.pivotTableOptions.displayTotals.grandTotal.row=true;const grandTotalRow={};const rowPath=[GRAND_TOTAL_KEY];this.mapGroupColumnCellIdToHeaderName.set(rowPath,{label:GRAND_TOTAL_LABEL,depth:0});grandTotalRow[this.getRowGroupKey()]=rowPath;grandTotalRow.group=false;this.chartDef.genericMeasures.forEach((measure,aggregationIndex)=>{const measureId=this.chartStore.getMeasureId(measure);const value=this.chartData.data.aggregations[aggregationIndex].tensor[0];const formattedValue=this.cellFormatters[aggregationIndex]?this.cellFormatters[aggregationIndex](value,1):value;this.adjustColumnWidthFromCell(formattedValue,this.endColumns[aggregationIndex].columnData);const grandTotalValue={measure:{value:formattedValue,originalValue:value,cellCoords:{}},measureIndex:aggregationIndex};grandTotalRow[this.getLeafColumnId("",measureId)]=grandTotalValue});return grandTotalRow}hasGrandTotalColumn(){return false}}class CustomHeader{init(agParams){this.agParams=agParams;this.formatting=this.agParams.formatting;this.eGui=document.createElement("div");this.eGui.classList.add("pivot-table-header");if(this.agParams.displayName){const span=document.createElement("span");span.classList.add("pivot-table-header__label");span.innerText=this.agParams.displayName;if(this.formatting){span.style.fontSize=this.formatting.fontSize;span.style.color=this.formatting.color}this.eGui.appendChild(span);if(this.agParams.hasChevron){this.eGui.classList.add("pivot-table-header--with-chevron");const chevronContainer=document.createElement("span");chevronContainer.classList.add("ag-header-icon","ag-header-expand-icon","ag-ltr");const chevron=document.createElement("span");chevronContainer.appendChild(chevron);this.eGui.appendChild(chevronContainer);this.switchFoldStatusEventListener=this.switchFoldStatus.bind(this);this.eGui.addEventListener("click",this.switchFoldStatusEventListener);this.eGui.addEventListener("dblclick",this.switchFoldStatusEventListener);this.updateChevronState()}if(this.agParams.isColumnMainHeader){this.eGui.classList.add(PivotTableUtils.COLUMN_MAIN_HEADER_CLASSNAME)}else if(this.agParams.isRowMainHeader){this.eGui.classList.add(PivotTableUtils.ROW_MAIN_HEADER_CLASSNAME)}else{this.eGui.classList.add(PivotTableUtils.COLUMN_SUBHEADER_CLASSNAME)}}}updateChevronState(){const isExpanded=this.agParams.columnGroup.isExpanded();if(this.eGui==null){return}const chevronContainer=this.eGui.querySelector(".ag-header-icon.ag-header-expand-icon.ag-ltr");if(chevronContainer==null){return}const chevron=chevronContainer.querySelector("span");if(chevron==null){return}if(isExpanded){chevronContainer.classList.remove("ag-header-expand-icon-expanded-collapsed");chevronContainer.classList.add("ag-header-expand-icon-expanded");chevron.className="ag-icon ag-icon-expanded"}else{chevronContainer.classList.remove("ag-header-expand-icon-expanded");chevronContainer.classList.add("ag-header-expand-icon-expanded-collapsed");chevron.className="ag-icon ag-icon-contracted"}}switchFoldStatus(){const isExpanded=!this.agParams.columnGroup.isExpanded();const groupId=this.agParams.columnGroup.groupId;this.agParams.api.setColumnGroupOpened(groupId,isExpanded);if(isExpanded!=this.agParams.chartDef.pivotTableOptions.areColumnExpandedByDefault){this.agParams.chartDef.pivotTableOptions.columnIdByCustomExpandedStatus[groupId]=isExpanded}else{delete this.agParams.chartDef.pivotTableOptions.columnIdByCustomExpandedStatus[groupId]}this.updateChevronState()}getGui(){return this.eGui}destroy(){if(this.switchFoldStatusEventListener&&this.eGui){this.eGui.removeEventListener("click",this.switchFoldStatusEventListener);this.eGui.removeEventListener("dblclick",this.switchFoldStatusEventListener)}}}class CellWithTooltipRenderer{init(params){const{colorMode,genericMeasures}=params.chartDef;this.eGui=document.createElement("div");this.eGui.classList.add("pivot-table__cell");if(params.value==null||params.value.hidden){return}const colType=params.colDef&&params.colDef.type&&typeof params.colDef.type==="string"&&params.colDef.type||"";const canApplyColors=!["grandTotalColumn","rowNavigationColumn","measureLabelColumn"].includes(colType)&&![MEASURE_COLUMN_KEY,GRAND_TOTAL_KEY].includes(params.node.id||"");const colorProperties=params.value.colorProperties;const hasColorDim=colorProperties!==undefined;const isUsingColorGroups=colorMode==="COLOR_GROUPS";this.contextualMenu=params.contextualMenu;this.tooltips=params.tooltips;this.theme=params.theme;this.chartDef=params.chartDef;let color;if(!params.value.isMeasureColumn){this.eGui.classList.add("pivot-table__cell--numerical")}if(params.value.measure!=null&&params.value.measureIndex!=null){const measure=params.value.measure;const genericMeasure=genericMeasures[params.value.measureIndex];const measureId=ConditionalFormattingOptions.getMeasureId(genericMeasure);const shouldApplyGroupColors=canApplyColors&&params.colorGroupByMeasureId&&measureId in params.colorGroupByMeasureId&&isUsingColorGroups;const colorGroupDetails=params.colorGroupByMeasureId[measureId];const measureElement=document.createElement("div");measureElement.classList.add("pivot-table__cell-content");this.eGui&&this.eGui.appendChild(measureElement);if(shouldApplyGroupColors&&colorGroupDetails.colorGroupMode==="RULES"){const measureRules=colorGroupDetails.rules;const ruleBaseValue=measure.colorMeasureOriginalValue!==undefined?measure.colorMeasureOriginalValue:measure.originalValue;const colorMeasure=colorGroupDetails.basedOnMeasure||genericMeasure;const ruleClass=ConditionalFormattingOptions.getColorRuleClass(ruleBaseValue,measureRules,colorMeasure,this.theme);ruleClass.class&&measureElement.classList.add(ruleClass.class);measureElement.style.backgroundColor=ruleClass.customColors&&ruleClass.customColors.customBackgroundColor||"";measureElement.style.color=ruleClass.customColors&&ruleClass.customColors.customFontColor||""}if(hasColorDim||shouldApplyGroupColors&&colorGroupDetails.colorGroupMode!=="RULES"){measureElement.classList.add("colored-content-wrapper");let colorScale;let colorMeasureValue;let bin;if(!isUsingColorGroups){colorScale=colorProperties.getColorScale();colorMeasureValue=colorProperties.measure;bin=colorProperties.bin}else if(shouldApplyGroupColors&&colorGroupDetails.colorGroupMode!=="RULES"&&colorGroupDetails&&colorGroupDetails.colorProperties){colorScale=colorGroupDetails.colorProperties.getColorScale();colorMeasureValue=measure.colorMeasureOriginalValue!==undefined?measure.colorMeasureOriginalValue:measure.originalValue;bin=colorGroupDetails.colorProperties.getBin(params.value.cellCoords)}if(!colorScale){this.fillElementWithMeasure(measureElement,measure);return}color={value:colorScale(colorMeasureValue,bin),measure:colorMeasureValue};measureElement.style.backgroundColor=color.value;measureElement.style.color=ColorUtils.getFontContrastColor(color.value,this.theme&&this.theme.generalFormatting.fontColor)}this.fillElementWithMeasure(measureElement,measure,color)}else{let colorMeasureValue;if(hasColorDim){this.eGui.classList.add("colored-content-wrapper");const colorScale=colorProperties.getColorScale();colorMeasureValue=colorProperties.measure;color={value:colorScale(colorMeasureValue,colorProperties.bin),measure:colorMeasureValue}}params.value.measures.forEach((measure,i)=>{const measureElement=document.createElement("div");measureElement.classList.add("pivot-table__cell-content");let shouldApplyGroupColors=false;let measureId;let genericMeasure;if(i<genericMeasures.length){genericMeasure=genericMeasures[i];measureId=ConditionalFormattingOptions.getMeasureId(genericMeasure);shouldApplyGroupColors=canApplyColors&&params.colorGroupByMeasureId&&measureId in params.colorGroupByMeasureId&&isUsingColorGroups}let colorGroupDetails;if(shouldApplyGroupColors){colorGroupDetails=params.colorGroupByMeasureId[measureId];if(colorGroupDetails.colorGroupMode==="RULES"){const measureRules=colorGroupDetails.rules;const ruleBaseValue=measure.colorMeasureOriginalValue!==undefined?measure.colorMeasureOriginalValue:measure.originalValue;const colorMeasure=colorGroupDetails.basedOnMeasure||genericMeasure;const ruleClass=ConditionalFormattingOptions.getColorRuleClass(ruleBaseValue,measureRules,colorMeasure,this.theme);ruleClass.class&&measureElement.classList.add(ruleClass.class);measureElement.style.backgroundColor=ruleClass.customColors&&ruleClass.customColors.customBackgroundColor||"";measureElement.style.color=ruleClass.customColors&&ruleClass.customColors.customFontColor||""}}if(hasColorDim||shouldApplyGroupColors&&colorGroupDetails.colorGroupMode!=="RULES"){let cellColor;if(!isUsingColorGroups){cellColor=color}else if(shouldApplyGroupColors&&colorGroupDetails.colorGroupMode!=="RULES"&&colorGroupDetails&&colorGroupDetails.colorProperties){const colorScale=colorGroupDetails.colorProperties.getColorScale();colorMeasureValue=measure.colorMeasureOriginalValue!==undefined?measure.colorMeasureOriginalValue:measure.originalValue;const bin=colorGroupDetails.colorProperties.getBin(params.value.cellCoords);cellColor={value:colorScale(colorMeasureValue,bin),measure:colorMeasureValue}}if(cellColor){measureElement.style.backgroundColor=cellColor.value;measureElement.style.color=ColorUtils.getFontContrastColor(cellColor.value,this.theme&&this.theme.generalFormatting.fontColor)}}if(colType==="measureLabelColumn"){measureElement.classList.add(PivotTableUtils.ROW_SUBHEADER_CLASSNAME);this.contextualMenu.addContextualMenuHandler(measureElement,undefined,PivotTableUtils.getRowHeaderContextualMenuActions(this.chartDef,params.canHideHeaders,params.rowHeadersCallbacks,measure.value),"pivotTableHeader")}this.fillElementWithMeasure(measureElement,measure,color);this.eGui&&this.eGui.appendChild(measureElement)})}}refresh(){return false}fillElementWithMeasure(el,measure,color){const label=`${measure.value||""}`;const labelElement=document.createElement("div");el.appendChild(labelElement);labelElement.classList.add("pivot-table__cell-content-measure");labelElement.innerHTML=label!==""?window.sanitize(label):"&nbsp;";if(measure.cellCoords!=null){el.classList.add("tar");if(measure.hasTooltipAndContextualMenu){this.tooltips.addTooltipHandlers(el,measure.cellCoords,color);const copyAction={label:translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.COPY_TO_CLIPBOARD","Copy to clipboard"),icon:"dku-icon-copy-step-16",onMouseDown:()=>{const selectedText=(getSelection()||"").toString();ClipboardUtils.copyToClipboard(selectedText===""?label:selectedText)}};this.contextualMenu.addContextualMenuHandler(el,measure.cellCoords,[copyAction])}}}destroy(){if(this.eGui&&this.tooltips&&this.contextualMenu){const measureElements=this.eGui.querySelectorAll(".pivot-table__cell-content");if(measureElements&&measureElements.length){measureElements.forEach(element=>{this.contextualMenu.removeContextualMenuHandler(element);this.tooltips.removeTooltipsHandlers(element)})}else{this.contextualMenu.removeContextualMenuHandler(this.eGui);this.tooltips.removeTooltipsHandlers(this.eGui)}}}getGui(){return this.eGui}}function getAgGridConverter(chartDef,chartStore,chartData,data,chartHandler,tooltips,contextualMenu,$rootElement){const isMeasureTreatedAsRow=chartDef.pivotTableOptions.measureDisplayMode==="ROWS";let Converter;if(PivotTableUtils.hasRows(chartDef)&&PivotTableUtils.hasColumns(chartDef)){Converter=isMeasureTreatedAsRow?RowAndColumnDimensionsWithMeasureAsRowConverter:RowAndColumnDimensionsWithMeasureAsColumnConverter}else if(!PivotTableUtils.hasRows(chartDef)&&PivotTableUtils.hasColumns(chartDef)){Converter=OnlyColumnDimensionWithMeasureAsRowConverter}else if(PivotTableUtils.hasRows(chartDef)&&!PivotTableUtils.hasColumns(chartDef)){Converter=OnlyRowDimensionWithMeasureAsColumnConverter}else{Converter=NoDimensionWithMeasureOnlyConverter}return new Converter(chartDef,chartStore,chartData,data,chartHandler,tooltips,contextualMenu,$rootElement)}return{getAgGridConverter:getAgGridConverter}})})();(function(){"use strict";angular.module("dataiku.charts").factory("DisplayTotalsToolPanel",function(){const DISPLAY_TOTALS_TOOL_PANEL_LABEL="Display totals";const TOTALS_ID="toggle-totals";const TOTALS_ROWS_ID="toggle-total-rows";const TOTALS_COLUMNS_ID="toggle-total-columns";const GRAND_TOTALS_ID="toggle-grand-totals";const GRAND_TOTALS_ROWS_ID="toggle-grand-total-rows";const GRAND_TOTALS_COLUMNS_ID="toggle-grand-total-columns";class DisplayTotalsToolPanel{constructor(){this.gridApi=null;this.rowData;this.subtotalColumnType;this.subtotalRowData;this.grandTotalRowData;this.grandTotalColumnDef;this.hasSubtotalRows;this.hasSubtotalColumns;this.hasGrandTotalRow;this.hasGrandTotalColumn;this.disableState;this.checkedState;this.pivotDisplayTotals;this.recomputeColorScale;this._actions={};this._actions[TOTALS_ID]={label:"Totals",callback:()=>this.toggleTotals(),childActions:[TOTALS_ROWS_ID,TOTALS_COLUMNS_ID]};this._actions[TOTALS_ROWS_ID]={label:"Rows",callback:()=>this.toggleTotalRows(),parentId:TOTALS_ID};this._actions[TOTALS_COLUMNS_ID]={label:"Columns",callback:()=>this.toggleTotalColumns(),parentId:TOTALS_ID};this._actions[GRAND_TOTALS_ID]={label:"Grand Total",callback:()=>this.toggleGrandTotals(),childActions:[GRAND_TOTALS_ROWS_ID,GRAND_TOTALS_COLUMNS_ID]};this._actions[GRAND_TOTALS_ROWS_ID]={label:"Row",callback:()=>this.toggleGrandTotalRows(),parentId:GRAND_TOTALS_ID};this._actions[GRAND_TOTALS_COLUMNS_ID]={label:"Column",callback:()=>this.toggleGrandTotalColumns(),parentId:GRAND_TOTALS_ID};this.$rootElement}refresh(){}destroy(){delete this.rowData;delete this.subtotalRowData;delete this.grandTotalRowData;this.clearClickListeners()}setCheckboxState(id,newState){this.checkedState[id]=newState;if(this._actions[id].childActions){this._actions[id].childActions.map(childId=>this.checkedState[childId]=newState)}else{const parentId=this._actions[id].parentId;let switchParentState=true;this._actions[parentId].childActions.map(childId=>{if(this.checkedState[childId]!==newState&&!this.disableState[childId]){switchParentState=false}});if(switchParentState){this.checkedState[parentId]=newState}}this.renderTemplate()}toggleTotals(){const shouldDisplay=!this.checkedState[TOTALS_ID];if(shouldDisplay!==this.checkedState[TOTALS_ROWS_ID]&&!this.disableState[TOTALS_ROWS_ID]){this.toggleTotalRows(true)}if(shouldDisplay!==this.checkedState[TOTALS_COLUMNS_ID]&&!this.disableState[TOTALS_COLUMNS_ID]){this.toggleTotalColumns(true)}this.updateRows()}updateRows(){this.recomputeColorScale();this.gridApi.redrawRows()}toggleTotalRows(skipRowUpdate=false){const shouldDisplay=!this.checkedState[TOTALS_ROWS_ID];if(shouldDisplay){const rowData=[...this.rowData,...this.subtotalRowData];if(this.hasGrandTotalRow&&this.checkedState[GRAND_TOTALS_ROWS_ID]){rowData.push(this.grandTotalRowData)}this.gridApi.setGridOption("rowData",rowData)}else{const rowData=[...this.rowData];if(this.hasGrandTotalRow&&this.checkedState[GRAND_TOTALS_ROWS_ID]){rowData.push(this.grandTotalRowData)}this.gridApi.setGridOption("rowData",rowData)}this.pivotDisplayTotals.subTotals.rows=shouldDisplay;this.setCheckboxState(TOTALS_ROWS_ID,shouldDisplay);if(!skipRowUpdate){this.updateRows()}}toggleTotalColumns(skipRowUpdate=false){const shouldDisplay=!this.checkedState[TOTALS_COLUMNS_ID];let columnGroupShow="closed";if(shouldDisplay){columnGroupShow=undefined}this.gridApi.getColumns().filter(col=>col.getUserProvidedColDef().type===this.subtotalColumnType).forEach(col=>{col.setColDef({...col.getColDef(),columnGroupShow:columnGroupShow},{colId:col.getColId()})});this.gridApi.setGridOption("columnDefs",this.gridApi.getColumnDefs());this.pivotDisplayTotals.subTotals.columns=shouldDisplay;this.setCheckboxState(TOTALS_COLUMNS_ID,shouldDisplay);if(!skipRowUpdate){this.updateRows()}}toggleGrandTotals(){const display=!this.checkedState[GRAND_TOTALS_ID];if(display!==this.checkedState[GRAND_TOTALS_ROWS_ID]&&!this.disableState[GRAND_TOTALS_ROWS_ID]){this.toggleGrandTotalRows()}if(display!==this.checkedState[GRAND_TOTALS_COLUMNS_ID]&&!this.disableState[GRAND_TOTALS_COLUMNS_ID]){this.toggleGrandTotalColumns()}}toggleGrandTotalRows(){const shouldDisplay=!this.checkedState[GRAND_TOTALS_ROWS_ID];if(shouldDisplay){this.gridApi.applyTransaction({add:[this.grandTotalRowData]})}else{const grandTotalRowNode=this.gridApi.getRowNode(this.grandTotalRowData.id);this.gridApi.applyTransaction({remove:[grandTotalRowNode]})}this.setCheckboxState(GRAND_TOTALS_ROWS_ID,shouldDisplay);this.pivotDisplayTotals.grandTotal.row=shouldDisplay}toggleGrandTotalColumns(){const shouldDisplay=!this.checkedState[GRAND_TOTALS_COLUMNS_ID];if(this.grandTotalColumnDef.children){this.grandTotalColumnDef.children.forEach(childCol=>this.gridApi.setColumnsVisible([childCol.field],shouldDisplay))}this.gridApi.setColumnsVisible([this.grandTotalColumnDef.field],shouldDisplay);this.pivotDisplayTotals.grandTotal.column=shouldDisplay;this.setCheckboxState(GRAND_TOTALS_COLUMNS_ID,shouldDisplay)}getDisableState(hasSubtotalRows,hasSubtotalColumns,hasGrandTotalRow,hasGrandTotalColumn){const disableState={};disableState[TOTALS_ID]=!hasSubtotalRows&&!hasSubtotalColumns;disableState[TOTALS_ROWS_ID]=!hasSubtotalRows;disableState[TOTALS_COLUMNS_ID]=!hasSubtotalColumns;disableState[GRAND_TOTALS_ID]=!hasGrandTotalRow&&!hasGrandTotalColumn;disableState[GRAND_TOTALS_ROWS_ID]=!hasGrandTotalRow;disableState[GRAND_TOTALS_COLUMNS_ID]=!hasGrandTotalColumn;return disableState}getInitCheckedState(hasSubtotalRows,hasSubtotalColumns,hasGrandTotalRow,hasGrandTotalColumn){const checkedState={};checkedState[TOTALS_ID]=(!hasSubtotalRows||this.pivotDisplayTotals.subTotals.rows)&&(!hasSubtotalColumns||this.pivotDisplayTotals.subTotals.columns);checkedState[TOTALS_ROWS_ID]=this.pivotDisplayTotals.subTotals.rows;checkedState[TOTALS_COLUMNS_ID]=this.pivotDisplayTotals.subTotals.columns;checkedState[GRAND_TOTALS_ID]=(!hasGrandTotalRow||this.pivotDisplayTotals.grandTotal.row)&&(!hasGrandTotalColumn||this.pivotDisplayTotals.grandTotal.column);checkedState[GRAND_TOTALS_ROWS_ID]=this.pivotDisplayTotals.grandTotal.row;checkedState[GRAND_TOTALS_COLUMNS_ID]=this.pivotDisplayTotals.grandTotal.column;return checkedState}init(params){this.setParams(params);this.eGui=document.createElement("div");this.eGui.classList.add("expand-collapse-tool-panel");const renderPanel=()=>{this.renderTemplate();this.setToolPanelButtonIcon()};this.gridApi.addEventListener("gridReady",renderPanel)}setParams(params){this.pivotDisplayTotals=params.pivotDisplayTotals;this.checkedState=this.getInitCheckedState(params.hasSubtotalRows,params.hasSubtotalColumns,params.hasGrandTotalRow,params.hasGrandTotalColumn);this.disableState=this.getDisableState(params.hasSubtotalRows,params.hasSubtotalColumns,params.hasGrandTotalRow,params.hasGrandTotalColumn);this.subtotalColumnType=params.subtotalColumnType;this.$rootElement=params.$rootElement;this.gridApi=params.api;this.rowData=params.rowData;this.subtotalRowData=params.subtotalRowData;this.grandTotalRowData=params.grandTotalRowData;this.grandTotalColumnDef=params.grandTotalColumnDef;this.hasSubtotalRows=params.hasSubtotalRows;this.hasSubtotalColumns=params.hasSubtotalColumns;this.hasGrandTotalRow=params.hasGrandTotalRow;this.hasGrandTotalColumn=params.hasGrandTotalColumn;this.recomputeColorScale=params.recomputeColorScale}customRefresh(params){this.setParams(params);this.renderTemplate()}getGui(){return this.eGui}setListeners(){this.clearClickListeners();for(const id in this._actions){if(Object.hasOwnProperty.call(this._actions,id)){const action=this._actions[id];this.$rootElement.find(`.${this.getActionClassFromId(id)}`).on("change",e=>{e.stopPropagation();action.callback()})}}}setToolPanelButtonIcon(){const toolPanelButtons=this.$rootElement.find(".ag-side-button").toArray();const displayTotalsButton=toolPanelButtons.filter(element=>element.textContent.includes(DISPLAY_TOTALS_TOOL_PANEL_LABEL))[0];const iconElement=displayTotalsButton.querySelector(".ag-icon");iconElement.classList.remove("ag-icon","ag-icon-");iconElement.classList.add("dku-icon-plus-16")}clearClickListeners(){Object.keys(this._actions).forEach(id=>this.$rootElement.find(`.${this.getActionClassFromId(id)}`).off("click"))}getActionClassFromId(id){return`pivot-table-display-totals-tool-panel__input-checkbox-${id}`}renderTemplate(){this.eGui.innerHTML=Object.keys(this._actions).filter(id=>this._actions[id].childActions!==undefined).map(id=>`
                            <ul class="pivot-table-display-totals-tool-panel__list-item ${this.getActionClassFromId(id)}">
                                <div class="df aic">
                                    <div class="pivot-table-display-totals-tool-panel__chevron-icon">
                                        <i class="dku-icon-chevron-right-12 dibvam"></i>
                                    </div>
                                    <div>
                                        <input class="pivot-table-display-totals-tool-panel__input-checkbox" type="checkbox" ${this.checkedState[id]&&!this.disableState[id]?"checked":""} ${this.disableState[id]?"disabled":""}>
                                            ${this._actions[id].label}
                                        </input>
                                    </div>
                                </div>
                                ${this._actions[id].childActions.map(childId=>`
                                <li class="pivot-table-display-totals-tool-panel__item ${this.getActionClassFromId(childId)}">
                                    <input class="pivot-table-display-totals-tool-panel__input-checkbox" type="checkbox" ${this.checkedState[childId]&&!this.disableState[childId]?"checked":""}  ${this.disableState[childId]?"disabled":""}>
                                        ${this._actions[childId].label}
                                    </input>
                                </li>
                                `).join("")}
                            </ul>`).join("");this.setListeners()}}DisplayTotalsToolPanel.label=DISPLAY_TOTALS_TOOL_PANEL_LABEL;DisplayTotalsToolPanel.id="displayTotals";return DisplayTotalsToolPanel})})();(function(){"use strict";angular.module("dataiku.charts").factory("ExpandCollapseToolPanel",function(LinkedList,ChartStoreFactory,$rootScope){const EXPAND_COLLAPSE_TOOL_PANEL_LABEL="Expand/Collapse | Resize";class ExpandCollapseToolPanel{constructor(){this._sections=[{label:"Expand",id:"expand-section",actions:[{label:"Expand rows",id:"expand-rows",callback:params=>this.expandRows(params)},{label:"Expand columns",id:"expand-columns",callback:params=>this.expandColumns(params)},{label:"Expand all",id:"expand-all",callback:params=>this.expandAll(params)}]},{label:"Collapse",id:"collapse-section",actions:[{label:"Collapse rows",id:"collapse-rows",callback:params=>this.collapseRows(params)},{label:"Collapse columns",id:"collapse-columns",callback:params=>this.collapseColumns(params)},{label:"Collapse all",id:"collapse-all",callback:params=>this.collapseAll(params)}]},{label:"Column size",id:"column-size-section",actions:[{label:"Auto-size all columns",id:"auto-size-all",callback:()=>this.autoSizeAllColumns()}]}];this.$rootElement;this.chartDef}refresh(){}destroy(){this.clearClickListeners()}expandRows(params){this.setRowsOpened(params,true)}collapseRows(params){this.setRowsOpened(params,false)}collapseAll(params){this.collapseRows(params);this.collapseColumns(params)}expandAll(params){this.expandRows(params);this.expandColumns(params)}expandColumns(params){this.setColumnsOpened(params,true)}collapseColumns(params){this.setColumnsOpened(params,false)}setColumnsOpened(params,newValue){this.chartDef.pivotTableOptions.areColumnExpandedByDefault=newValue;this.chartDef.pivotTableOptions.rowIdByCustomExpandedStatus={};const columnGroups=params.api.getAllDisplayedColumnGroups();const queue=new LinkedList;columnGroups.forEach(group=>queue.push(group.getDefinition()));while(queue.length){const columnDef=queue.shift();const groupId=columnDef&&columnDef.groupId;if(groupId){if(columnDef.children){columnDef.children.forEach(child=>queue.push(child))}params.api.setColumnGroupOpened(groupId,newValue)}}params.api.refreshHeader()}setRowsOpened(params,newValue){this.chartDef.pivotTableOptions.areRowsExpandedByDefault=newValue;this.chartDef.pivotTableOptions.rowIdByCustomExpandedStatus={};const queue=new LinkedList;params.api.forEachNode(node=>queue.push(node));while(queue.length){const row=queue.shift();if(row.hasChildren()){if(row.childrenAfterGroup){row.childrenAfterGroup.forEach(child=>queue.push(child))}row.setExpanded(newValue)}}}autoSizeAllColumns(){this.chartDef.pivotTableOptions.columnIdByCustomWidth={};const store=ChartStoreFactory.get(this.chartDef.$chartStoreId);store.setGridApi(null);$rootScope.$broadcast("redraw")}init(params){this.setParams(params);this.eGui=document.createElement("div");this.eGui.classList.add("pivot-table-expand-collapse-tool-panel");const renderPanel=()=>{this.eGui.innerHTML=this.createTemplate();this.initClickListeners(params);this.setToolPanelButtonIcon()};params.api.addEventListener("gridReady",renderPanel)}setParams(params){this.$rootElement=params.$rootElement;this.chartDef=params.chartDef}customRefresh(params){this.setParams(params);this.clearClickListeners();this.eGui.innerHTML=this.createTemplate();this.initClickListeners(params)}getGui(){return this.eGui}initClickListeners(params){for(const{actions}of this._sections){actions.forEach(({id,callback})=>this.$rootElement.find(`.${this.getActionClassFromId(id)}`).on("click",()=>callback(params)))}}setToolPanelButtonIcon(){const toolPanelButtons=this.$rootElement.find(".ag-side-button").toArray();const expandCollapseButton=toolPanelButtons.filter(element=>element.textContent.includes(EXPAND_COLLAPSE_TOOL_PANEL_LABEL))[0];const iconElement=expandCollapseButton.querySelector(".ag-icon");iconElement.classList.remove("ag-icon","ag-icon-");iconElement.classList.add("dku-icon-chevron-double-down-16")}clearClickListeners(){for(const{actions}of this._sections){actions.forEach(({id})=>this.$rootElement.find(`.${this.getActionClassFromId(id)}`).off("click"))}}getActionClassFromId(id){return`pivot-table-expand-collapse-tool-panel__${id}`}createTemplate(){return this._sections.map(section=>{return`
                            <div class="pivot-table-expand-collapse-tool-panel__section-title">${section.label}</div>
                            <ul>
                                ${section.actions.map(({label,id})=>`<li><button class="${this.getActionClassFromId(id)}">${label}</button></li>`).join("")}
                            </ul>`}).join("")}}ExpandCollapseToolPanel.label=EXPAND_COLLAPSE_TOOL_PANEL_LABEL;ExpandCollapseToolPanel.id="expandCollapse";return ExpandCollapseToolPanel})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("PivotTableChart",function(ChartFormatting,ChartDataWrapperFactory,ChartTooltips,ChartCustomMeasures,ChartContextualMenu,ChartStoreFactory,ChartUsableColumns,ColumnAvailability,AgGridLoader,AgGridConverter,ChartDrilldown,PivotTableUtils,ChartFormattingPaneSections,ChartDimension,ChartHierarchyDimension){let $rootElement;let $container;let lastAxesDefDisplayed;const MEASURE_COLUMN_KEY="__MEASURE__LIST__";let contextualMenu;let defaultTopHeadersMenuListener;let defaultBackgroundMenuListener;let topRowHeadersMenuListener;let instanceChartHandler;let AgGrid;function initContainer($rootElement){$rootElement.empty();$rootElement.addClass("ag-theme-balham");const $container=$('<div class="h100 table-pivot-table chart-wrapper" />');$rootElement.append($container);return $container}function initTooltips($rootElement,$container,chartData,chartDef,chartHandler){const tooltipFormatters=ChartFormatting.createMeasureFormatters(chartDef,chartData,1e3);const tooltips=ChartTooltips.create($rootElement,chartHandler,chartData,chartDef,tooltipFormatters);$container.on("click",function(evt){if(evt.target.closest("[data-legend], [tooltip-el]")){return}tooltips.unfix()});$container.addClass("has-tooltip");return tooltips}function generateGridOptions(chartDef,axesDef,data,chartHandler,$element,$container){const chartData=ChartDataWrapperFactory.chartTensorDataWrapper(data,axesDef);const chartStore=ChartStoreFactory.get(chartDef.$chartStoreId);const tooltips=initTooltips($element,$container,chartData,chartDef,chartHandler);contextualMenu=ChartContextualMenu.create(chartData,chartDef,chartStore);const agGridConverter=AgGridConverter.getAgGridConverter(chartDef,chartStore,chartData,data,chartHandler,tooltips,contextualMenu,$element);return agGridConverter.convert()}function updateColumnVisibilities(gridApi,chartDef,store){const show=chartDef.pivotTableOptions.tableFormatting.showRowHeaders;chartDef.yDimension.forEach(dimension=>{gridApi.setColumnsVisible([store.getDimensionId(dimension)],show)});const yHierarchyDimension=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"y");if(yHierarchyDimension){gridApi.setColumnVisible(store.getDimensionId(yHierarchyDimension),show)}gridApi.setColumnsVisible([MEASURE_COLUMN_KEY],show)}function showRowMainHeaderContextualMenu(event,cellValue,chartDef,mainHeader){const rowHeadersCallbacks=PivotTableUtils.getToggleRowHeadersCallbacks(chartDef,instanceChartHandler.openSection);const actions=PivotTableUtils.getRowHeaderContextualMenuActions(chartDef,rowHeadersCallbacks,cellValue,mainHeader);event.preventDefault();contextualMenu.open({event:event,customActions:actions,type:"pivotTableHeader"})}function showBackgroundContextualMenu(event,chartDef){const actions=ChartDrilldown.getDrillupActions(chartDef);event.preventDefault();contextualMenu.open({event:event,customActions:actions,type:"background"})}function showColumnHeaderContextualMenu(event,cellValue,chartDef,mainHeader){event.preventDefault();const columnHeadersCallbacks={openFormatTableSection:()=>{instanceChartHandler.openSection(ChartFormattingPaneSections.TABLE)}};contextualMenu.open({event:event,customActions:PivotTableUtils.getColumnHeaderActions(chartDef,cellValue,mainHeader,columnHeadersCallbacks),type:"pivotTableHeader"})}function updateTopHeadersContextualMenuListeners(chartDef){removeTopHeadersContextualMenuListeners();addTopHeadersContextualMenuListeners(chartDef)}function updateBackgroundContextualMenuListener(chartDef){removeBackgroundContextualMenuListener();addBackgroundContextualMenuListener(chartDef)}function removeTopHeadersContextualMenuListeners(){const defaulTopHeaders=$container[0].querySelector(".ag-header-viewport");const topRowHeaders=$container[0].querySelector(".ag-pinned-left-header");if(defaulTopHeaders){defaulTopHeaders.removeEventListener("contextmenu",defaultTopHeadersMenuListener)}if(topRowHeaders){topRowHeaders.removeEventListener("contextmenu",topRowHeadersMenuListener)}}function removeBackgroundContextualMenuListener(){const gridBody=$container[0].querySelector(".ag-body");if(gridBody){gridBody.removeEventListener("contextmenu",defaultBackgroundMenuListener)}}function removeRowSubheadersContextualMenuListeners(){const rowSubheaders=$container[0].querySelectorAll("."+PivotTableUtils.ROW_SUBHEADER_CLASSNAME);if(rowSubheaders&&rowSubheaders.length){rowSubheaders.forEach(subheader=>{contextualMenu.removeContextualMenuHandler(subheader)})}}function addTopHeadersContextualMenuListeners(chartDef){const defaulTopHeaders=$container[0].querySelector(".ag-header-viewport");const areRowHeadersFrozen=chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders;if(areRowHeadersFrozen){const rowHeaders=$container[0].querySelector(".ag-pinned-left-header");topRowHeadersMenuListener=event=>{const rowMainHeader=event.target.closest("."+PivotTableUtils.ROW_MAIN_HEADER_CLASSNAME)||event.target.querySelector("."+PivotTableUtils.ROW_MAIN_HEADER_CLASSNAME);if(rowMainHeader){showRowMainHeaderContextualMenu(event,rowMainHeader.innerText,chartDef,true)}};rowHeaders.addEventListener("contextmenu",topRowHeadersMenuListener)}defaultTopHeadersMenuListener=event=>{const rowMainHeader=event.target.closest("."+PivotTableUtils.ROW_MAIN_HEADER_CLASSNAME)||event.target.querySelector("."+PivotTableUtils.ROW_MAIN_HEADER_CLASSNAME);const columnMainHeader=event.target.closest("."+PivotTableUtils.COLUMN_MAIN_HEADER_CLASSNAME)||event.target.querySelector("."+PivotTableUtils.COLUMN_MAIN_HEADER_CLASSNAME);const columnSubheader=event.target.closest("."+PivotTableUtils.COLUMN_SUBHEADER_CLASSNAME)||event.target.querySelector("."+PivotTableUtils.COLUMN_SUBHEADER_CLASSNAME);if(rowMainHeader){showRowMainHeaderContextualMenu(event,rowMainHeader.innerText,chartDef,true)}else if(columnMainHeader){showColumnHeaderContextualMenu(event,columnMainHeader.innerText,chartDef,true)}else if(columnSubheader){showColumnHeaderContextualMenu(event,columnSubheader.innerText,chartDef)}};defaulTopHeaders.addEventListener("contextmenu",defaultTopHeadersMenuListener)}function addBackgroundContextualMenuListener(chartDef){const xHierarchyLevel=ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef,"x");const yHierarchyLevel=ChartHierarchyDimension.getCurrentHierarchyLevel(chartDef,"y");if(xHierarchyLevel>0||yHierarchyLevel>0){const gridBody=$container[0].querySelector(".ag-body");defaultBackgroundMenuListener=event=>{const isBackgroundClick=(event.target.closest(".ag-body")||event.target.querySelector(".ag-body"))&&!event.target.closest(".ag-center-cols-container");if(isBackgroundClick){showBackgroundContextualMenu(event,chartDef)}};gridBody.addEventListener("contextmenu",defaultBackgroundMenuListener)}}function initGrid($container,gridOptions,chartDef,store){const gridApi=AgGrid.createGrid($container[0],gridOptions);store.setGridApi(gridApi);updateColumnVisibilities(gridApi,chartDef,store);chartDef.pivotTableOptions.showSidebar?gridApi.setSideBarVisible(true):gridApi.setSideBarVisible(false);addTopHeadersContextualMenuListeners(chartDef);addBackgroundContextualMenuListener(chartDef)}function updateGridOptions(newGridOptions,chartDef){const store=ChartStoreFactory.get(chartDef.$chartStoreId);const gridApi=store.getGridApi();removeRowSubheadersContextualMenuListeners();updateTopHeadersContextualMenuListeners(chartDef);updateBackgroundContextualMenuListener(chartDef);const{sideBar,columnDefs,...newGridOptionsWithoutColumnDefsAndSideBar}=newGridOptions;if(chartDef.pivotTableOptions.showSidebar&&typeof newGridOptions.sideBar!=="string"&&typeof newGridOptions.sideBar!=="boolean"){gridApi.getSideBar().toolPanels.forEach((toolpanel,i)=>{const instance=gridApi.getToolPanelInstance(toolpanel.id);instance.customRefresh({...sideBar.toolPanels[i].toolPanelParams,api:gridApi})});gridApi.setSideBarVisible(true)}else{gridApi.setSideBarVisible(false)}gridApi.setGridOption("columnDefs",columnDefs,{maintainColumnOrder:false});gridApi.updateGridOptions(newGridOptionsWithoutColumnDefsAndSideBar);gridApi.resetColumnState();updateColumnVisibilities(gridApi,chartDef,store)}function isNewRootElement($element){return $rootElement===undefined||$element[0]!==$rootElement[0]}function hasChangedAxesDefinition(axesDef){return lastAxesDefDisplayed&&!angular.equals(Object.keys(axesDef),Object.keys(lastAxesDefDisplayed))}function canRefreshView($element,chartDef,axesDef){const store=ChartStoreFactory.get(chartDef.$chartStoreId);const gridApi=store.getGridApi();if(gridApi==null){return false}const shouldRebuildTreeData=chartDef.pivotTableOptions.tableFormatting.showRowHeaders&&gridApi.getGridOption("treeData")===false;return!shouldRebuildTreeData&&!isNewRootElement($element)&&!hasChangedAxesDefinition(axesDef)}function purgeAgGrid(chartDef){const store=ChartStoreFactory.get(chartDef.$chartStoreId);const gridApi=store.getGridApi();if($container&&$container[0]){removeTopHeadersContextualMenuListeners();removeRowSubheadersContextualMenuListeners();removeBackgroundContextualMenuListener()}if(gridApi!=null&&gridApi.destroy){gridApi.destroy()}store.setGridApi(null)}function purgeExpandedStatus(chartDef){chartDef.pivotTableOptions.areColumnExpandedByDefault=true;chartDef.pivotTableOptions.areRowsExpandedByDefault=true;chartDef.pivotTableOptions.rowIdByCustomExpandedStatus={};chartDef.pivotTableOptions.columnIdByCustomExpandedStatus={}}function convertColorTableToPivotTable(chartDef,data){chartDef.variant=undefined;if(chartDef.colorMeasure.length===0&&chartDef.genericMeasures.length>0){chartDef.colorMeasure.push(chartDef.genericMeasures[0]);data.aggregations.push(data.aggregations[0])}}function PivotTableChart($element,chartDef,chartHandler,axesDef,data){const{store,id}=ChartStoreFactory.getOrCreate(chartDef.$chartStoreId);chartDef.$chartStoreId=id;store.updateChartStoreMeasureIDsAndDimensionIDs(chartDef);instanceChartHandler=chartHandler;const dataSpec=chartHandler.getDataSpec();const customMeasures=ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext());const allMeasures=ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey,dataSpec.datasetName,chartHandler.getCurrentChartsContext()).filter(m=>["NUMERICAL","ALPHANUM","DATE"].includes(m.type));ColumnAvailability.updateAvailableColumns(chartDef.genericMeasures,allMeasures,customMeasures);if(PivotTableUtils.isColoredTable(chartDef)){convertColorTableToPivotTable(chartDef,data)}if(hasChangedAxesDefinition(axesDef)){purgeExpandedStatus(chartDef)}if(canRefreshView($element,chartDef,axesDef)){const newGridOptions=generateGridOptions(chartDef,axesDef,data,chartHandler,$element,$container);updateGridOptions(newGridOptions,chartDef)}else{$rootElement=$element;purgeAgGrid(chartDef);$container=initContainer($element);const gridOptions=generateGridOptions(chartDef,axesDef,data,chartHandler,$element,$container);const requestOptions=store.getRequestOptions();if(requestOptions&&_.isNil(requestOptions.removePivotTableLimitations)){store.setRequestOptions({removePivotTableLimitations:false})}initGrid($container,gridOptions,chartDef,store)}lastAxesDefDisplayed=axesDef;if(typeof chartHandler.loadedCallback==="function"){chartHandler.loadedCallback()}chartHandler.$on("$destroy",function(){purgeAgGrid(chartDef)})}return($element,chartDef,chartHandler,axesDef,data,theme)=>{AgGridLoader.load().then(loaded=>AgGrid=loaded).then(()=>PivotTableChart($element,chartDef,chartHandler,axesDef,data,theme))}})})();(function(){"use strict";angular.module("dataiku.charts").factory("PivotTableUtils",function(CHART_VARIANTS,StringUtils,DashboardUtils,ClipboardUtils,ChartFormattingPaneSections,$state,translate,ChartHierarchyDimension,ChartDrilldown){const PIVOT_TABLE_FONT="13px";const PIVOT_TABLE_CELL_OFFSET=16;const FORMAT_HEADERS_LABEL=translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.FORMAT_TABLE_HEADERS","Format table headers");const FORMAT_HEADERS_ICON="dku-icon-paint-bucket-16";const COPY_TO_CLIPBOARD_LABEL=translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.COPY_TO_CLIPBOARD","Copy to clipboard");const COPY_TO_CLIPBOARD_ICON="dku-icon-copy-step-16";const HIDE_HEADER_ICON="dku-icon-eye-off-16";const COLUMN_MAX_WIDTH=280;const canvas=document.createElement("canvas");const PIVOT_TABLE_SAFETY_OFFSET=2;return{COLUMN_MAIN_HEADER_CLASSNAME:"pivot-table-column-main-header",COLUMN_SUBHEADER_CLASSNAME:"pivot-table-column-subheader",ROW_MAIN_HEADER_CLASSNAME:"pivot-table-row-main-header",ROW_SUBHEADER_CLASSNAME:"pivot-table-row-subheader",hasRows(chartDef){return chartDef.yDimension.length>0||chartDef.yHierarchyDimension.length>0},hasColumns(chartDef){return chartDef.xDimension.length>0||chartDef.xHierarchyDimension.length>0},isColoredTable(chartDef){return chartDef.variant==CHART_VARIANTS.colored},getTextWidth(text,fontSize=PIVOT_TABLE_FONT,fontFamily="SourceSansPro"){const width=StringUtils.getTextWidth(text,`bold ${fontSize} ${fontFamily}, SourceSansPro`,canvas);return Math.min(width+PIVOT_TABLE_CELL_OFFSET+PIVOT_TABLE_SAFETY_OFFSET,COLUMN_MAX_WIDTH)},hasCellValueForCoords(chartData,aggrIdx,coords,displayEmptyValues){return displayEmptyValues||aggrIdx.some(idx=>{return chartData.getNonNullCount(coords,idx)>0})},getColumnHeaderActions(chartDef,cellValue,mainHeader,callbacks){const actions=[];const tableFormatting=chartDef.pivotTableOptions.tableFormatting;actions.push(...ChartDrilldown.getDrillupActions(chartDef));actions.push({label:COPY_TO_CLIPBOARD_LABEL,icon:COPY_TO_CLIPBOARD_ICON,onMouseDown:()=>{const selectedText=(getSelection()||"").toString();ClipboardUtils.copyToClipboard(selectedText===""?cellValue:selectedText)}});if(DashboardUtils.isInDashboard()){return actions}actions.unshift({label:translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.HIDE_COLUMN_HEADERS","Hide column headers"),icon:HIDE_HEADER_ICON,onMouseDown:()=>{tableFormatting.showColumnHeaders=false}});if(mainHeader){actions.unshift({label:translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.HIDE_COLUMN_MAIN_HEADERS","Hide column main headers"),icon:HIDE_HEADER_ICON,onMouseDown:()=>{tableFormatting.showColumnMainHeaders=false}})}const isReadOnly=$state.current.name==="projects.project.dashboards.insights.insight.view";if(!isReadOnly){actions.unshift({label:FORMAT_HEADERS_LABEL,icon:FORMAT_HEADERS_ICON,onMouseDown:()=>{callbacks.openFormatTableSection()}})}return actions},getRowHeaderContextualMenuActions(chartDef,callbacks,cellValue,mainHeader){const actions=[];const tableFormatting=chartDef.pivotTableOptions.tableFormatting;const yHierarchyDimension=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"y");const yDimensions=yHierarchyDimension?[yHierarchyDimension]:chartDef.yDimension;const canHideHeaders=yDimensions.length<=1;actions.push(...ChartDrilldown.getDrillupActions(chartDef));actions.push({label:COPY_TO_CLIPBOARD_LABEL,icon:COPY_TO_CLIPBOARD_ICON,onMouseDown:()=>{const selectedText=(getSelection()||"").toString();ClipboardUtils.copyToClipboard(selectedText===""?cellValue:selectedText)}});if(DashboardUtils.isInDashboard()){return actions}const areRowHeadersFrozen=tableFormatting.freezeRowHeaders;actions.unshift({label:areRowHeadersFrozen?translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.UNFREEZE_ROW_HEADERS","Unfreeze row headers"):translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.FREEZE_ROW_HEADERS","Freeze row headers"),icon:areRowHeadersFrozen?"dku-icon-filter-position-top-16":"dku-icon-filter-position-left-16",onMouseDown:()=>{callbacks.toggleFreezeHeaders()}});if(canHideHeaders){actions.unshift({label:translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.HIDE_ROW_HEADERS","Hide row headers"),icon:HIDE_HEADER_ICON,onMouseDown:()=>{callbacks.toggleShowHeaders()}})}if(mainHeader){actions.unshift({label:translate("CHARTS.CONTEXTUAL_MENU.PIVOT_TABLE.HIDE_ROW_MAIN_HEADERS","Hide row main headers"),icon:HIDE_HEADER_ICON,onMouseDown:()=>{callbacks.toggleShowMainHeaders()}})}const isReadOnly=$state.current.name==="projects.project.dashboards.insights.insight.view";if(!isReadOnly){actions.unshift({label:FORMAT_HEADERS_LABEL,icon:FORMAT_HEADERS_ICON,onMouseDown:()=>{callbacks.openFormatTableSection()}})}return actions},getToggleRowHeadersCallbacks(chartDef,openSection){return{toggleShowHeaders:()=>{chartDef.pivotTableOptions.tableFormatting.showRowHeaders=!chartDef.pivotTableOptions.tableFormatting.showRowHeaders},toggleShowMainHeaders:()=>{chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders=!chartDef.pivotTableOptions.tableFormatting.showRowMainHeaders},toggleFreezeHeaders:()=>{chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders=!chartDef.pivotTableOptions.tableFormatting.freezeRowHeaders},openFormatTableSection:()=>{openSection(ChartFormattingPaneSections.TABLE)}}}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("CanvasUtils",function($q,$timeout){const utils={fill:function(canvas,color){const ctx=canvas.getContext("2d");ctx.fillStyle=color;ctx.fillRect(0,0,canvas.getAttribute("width"),canvas.getAttribute("height"))},downloadCanvas:function(canvas,filename){const a=document.createElement("a");a.href=canvas.toDataURL("image/png").replace("image/png","image/octet-stream");a.download=filename;a.style.display="none";document.body.appendChild(a);$timeout(function(){a.click();a.remove()})},htmlToCanvas:function($el,scale){const deferred=$q.defer();scale=angular.isDefined(scale)?scale:1;html2canvas_latest($el[0],{backgroundColor:null,scale:scale,logging:false}).then(function(canvas){deferred.resolve(canvas)});return deferred.promise},svgToCanvas:function(svgEl,width,height,options){const bbox=svgEl.getBBox();const bounds={height:svgEl.clientHeight,width:svgEl.clientWidth,x:bbox.x<0?0:bbox.x,y:bbox.y<0?0:bbox.y};const clonedSvg=svgEl.cloneNode(true);if(options){if(options.filters){options.filters.forEach(filter=>d3.select(clonedSvg).selectAll(filter).remove())}if(typeof options.setup==="function"){options.setup(clonedSvg)}}clonedSvg.setAttribute("width",bounds.width+bounds.x);clonedSvg.setAttribute("height",bounds.height+bounds.y);const svgText=(new XMLSerializer).serializeToString(clonedSvg);const blob=new Blob([svgText],{type:"image/svg+xml;charset=utf-8"});return $q((resolve,reject)=>{const image=new Image;image.onload=()=>{const canvas=document.createElement("canvas");canvas.width=width;canvas.height=height;const ctx=canvas.getContext("2d");const ratio=Math.min(canvas.width/bounds.width,canvas.height/bounds.height);const offsetX=(canvas.width-bounds.width*ratio)/2;const offsetY=(canvas.height-bounds.height*ratio)/2;ctx.drawImage(image,bounds.x,bounds.y,bounds.width,bounds.height,offsetX,offsetY,bounds.width*ratio,bounds.height*ratio);resolve(canvas)};image.onerror=reject;image.src=URL.createObjectURL(blob)})},resize:function(canvas,width,height,crop,refLines,margins){if(canvas){const newCanvas=document.createElement("canvas");newCanvas.setAttribute("width",width);newCanvas.setAttribute("height",height);const ctx=newCanvas.getContext("2d");if(crop){const ratio=Math.min(canvas.width/width,canvas.height/height);ctx.drawImage(canvas,0,0,width*ratio,height*ratio,0,0,width,height)}else{ctx.drawImage(canvas,0,0,width,height)}if(refLines&&refLines.length>0){const xScale=width/canvas.width*window.devicePixelRatio;const yScale=height/canvas.height*window.devicePixelRatio;refLines.forEach(line=>{const x1=(parseFloat(line.getAttribute("x1"))-(margins.x||0))*xScale;const x2=(parseFloat(line.getAttribute("x2"))-(margins.x||0))*xScale;const y1=(parseFloat(line.getAttribute("y1"))-(margins.y||0))*yScale;const y2=(parseFloat(line.getAttribute("y2"))-(margins.y||0))*yScale;ctx.beginPath();line.getAttribute("stroke-dasharray")?ctx.setLineDash([8,8]):ctx.setLineDash([8,0]);ctx.moveTo(x1,y1);ctx.lineTo(x2,y2);ctx.strokeStyle=line.style.stroke;ctx.lineWidth=line.style.strokeWidth/4;ctx.stroke()})}return newCanvas}return null},inlineAllStyles:function(sel){if(sel.size()===0){return}let svg_style;for(let i=0;i<=document.styleSheets.length-1;i++){try{svg_style=document.styleSheets[i].rules||document.styleSheets[i].cssRules||[]}catch(e){if(e.name!="SecurityError"){throw e}}for(let j=0;j<svg_style.length;j++){if(svg_style[j].type==1){try{sel.selectAll(svg_style[j].selectorText).style(utils._makeStyleObject(svg_style[j]))}catch(e){}}}}},_makeStyleObject:function(rule){const styleDec=rule.style;const output={};let s;for(s=0;s<styleDec.length;s++){output[styleDec[s]]=styleDec[styleDec[s]];if(styleDec[styleDec[s]]===undefined){output[styleDec[s]]=styleDec.getPropertyValue(styleDec[s])}}return output}};return utils})})();(function(){"use strict";angular.module("dataiku.charts").factory("HierarchicalChartsUtils",function(ChartFormatting,ChartFeatures,ChartDimension){return{computeFormatterProperties(chartDef){let isPercentageOnly=true;const cellFormatters=[];const displayEmpty=chartDef.pivotTableOptions&&chartDef.pivotTableOptions.displayEmptyValues;for(let i=0;i<chartDef.genericMeasures.length;i++){const measure=chartDef.genericMeasures[i];cellFormatters.push(ChartFormatting.getForIsolatedNumber({...measure,displayEmpty:displayEmpty}));if(isPercentageOnly&&measure.computeMode!=="PERCENTAGE"){isPercentageOnly=false}}for(let i=0;i<chartDef.genericMeasures.length;i++){const measure=chartDef.genericMeasures[i];if(measure.valuesInChartDisplayOptions&&measure.valuesInChartDisplayOptions.additionalMeasures){measure.valuesInChartDisplayOptions.additionalMeasures.forEach(additionalMeasure=>{cellFormatters.push(ChartFormatting.getForIsolatedNumber({...additionalMeasure,displayEmpty:displayEmpty}))})}}return{cellFormatters:cellFormatters,isPercentageOnly:isPercentageOnly}},visitAggregationTree:function(chartData,dimensionIds,visitSubtotals,visitCallback){if(!chartData.hasSubtotalCoords()){throw new Error("Option `computeSubTotals` must be enabled to fetch subtotals in the tensor request")}const[headDimId,...tailDimIds]=dimensionIds;const stack=[];chartData.getAxisLabels(headDimId).forEach((axisLabel,index)=>{if(index===chartData.getSubtotalLabelIndex(headDimId)){return}const coordDict={};coordDict[headDimId]=index;stack.push({coordDict:coordDict,tailDimIds:tailDimIds})});while(stack.length){const current=stack.pop();const isSubTotal=current.tailDimIds.length>0;if(!isSubTotal||visitSubtotals){visitCallback(current.coordDict)}if(current.tailDimIds&&current.tailDimIds.length){const[childHeadDimId,...childTailDimIds]=current.tailDimIds;chartData.getAxisLabels(childHeadDimId).forEach((axisLabel,index)=>{if(index===chartData.getSubtotalLabelIndex(childHeadDimId)){return}const coordDict={...current.coordDict};coordDict[childHeadDimId]=index;stack.push({coordDict:coordDict,tailDimIds:childTailDimIds})})}}},getBinsToIncludeInColorScale:function(chartData,xDimensionIds,yDimensionIds,colorAggrIdx,chartDef,hasSubtotalXDim,hasSubtotalYDim){const binsToInclude=new Set;const aggregation=chartData.data.aggregations[colorAggrIdx];const colorMeasureFn=this.getColorMeasureAggFunction(chartDef,colorAggrIdx);if(xDimensionIds.length&&yDimensionIds.length){const xCoordsList=[];this.visitAggregationTree(chartData,xDimensionIds,hasSubtotalXDim,coordDict=>xCoordsList.push(coordDict));xCoordsList.forEach(xCoords=>{this.visitAggregationTree(chartData,yDimensionIds,hasSubtotalYDim,yCoords=>{const tensorSubtotalIndex=chartData.getCoordsLoc(aggregation,chartData.getSubTotalCoordsArray({...xCoords,...yCoords}));if(chartData.isBinMeaningful(colorMeasureFn,tensorSubtotalIndex,colorAggrIdx)){binsToInclude.add(tensorSubtotalIndex)}})})}else{const dimensionIds=xDimensionIds.length?xDimensionIds:yDimensionIds;const hasSubtotals=xDimensionIds.length?hasSubtotalXDim:hasSubtotalYDim;this.visitAggregationTree(chartData,dimensionIds,hasSubtotals,coords=>{const tensorSubtotalIndex=chartData.getCoordsLoc(aggregation,chartData.getSubTotalCoordsArray(coords));if(chartData.isBinMeaningful(colorMeasureFn,coords,colorAggrIdx)){binsToInclude.add(tensorSubtotalIndex)}})}return binsToInclude},shouldIgnoreEmptyBinsForColorDimension:function(chartDef){if(!ChartFeatures.canIgnoreEmptyBinsForColorDimension(chartDef)){return false}return ChartDimension.getGenericDimensions(chartDef).length===1&&chartDef.genericDimension1.length===1&&chartDef.genericDimension1[0].ignoreEmptyBins},getColorMeasureAggFunction:function(chartDef,colorMeasureIndex){if(chartDef.colorMode!=="COLOR_GROUPS"||!ChartFeatures.canHaveConditionalFormatting(chartDef.type)){return chartDef.colorMeasure[0].function}if(colorMeasureIndex<chartDef.genericMeasures.length){return chartDef.genericMeasures[colorMeasureIndex].function}const group_index=colorMeasureIndex-chartDef.genericMeasures.length;return chartDef.colorGroups[group_index].colorMeasure[0].function}}})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("SVGUtils",function(D3ChartAxes,ColorUtils,ValuesInChartOverlappingStrategy,MATCH_CHART_COLOR,ChartFeatures,CHART_COLOR_AUTO,ChartColorUtils){class LabelCollisionDetectionHandler{constructor(chartBase){this.maxLabelWidth=0;this.maxLabelHeight=0;this.bboxes=[];this.quadtree=d3.geom.quadtree().x(d=>d.x).y(d=>d.y).extent([[-chartBase.margins.top,-chartBase.margins.left],[chartBase.vizWidth+chartBase.margins.right,chartBase.vizHeight+chartBase.margins.bottom]])([])}_addBoundingBoxToQuadTree(bbox){if(!bbox.width||!bbox.height){return}try{this.quadtree.add(bbox)}catch(error){return}this.bboxes.push(bbox);this.maxLabelWidth=Math.max(this.maxLabelWidth,bbox.width);this.maxLabelHeight=Math.max(this.maxLabelHeight,bbox.height)}_isOverlapping(rect1,rect2){return!(rect1.x+rect1.width<rect2.x||rect2.x+rect2.width<rect1.x||rect1.y+rect1.height<rect2.y||rect2.y+rect2.height<rect1.y)}_checkOverlaps(newRect){let overlaps=false;this.quadtree.visit((node,x0,y0,x1,y1)=>{if(overlaps){return true}if(!node.length){do{const d=node.point;if(d&&this._isOverlapping(d,newRect)){overlaps=true;return true}}while(node=node.next)}return x0>newRect.x+newRect.width||x1+this.maxLabelWidth<newRect.x||y0>newRect.y+newRect.height||y1+this.maxLabelHeight<newRect.y});return overlaps}checkOverlaps(rectangles){return rectangles.some(rect=>this._checkOverlaps(rect))}addBoundingBoxesToQuadTree(bboxes){bboxes.forEach(bbox=>this._addBoundingBoxToQuadTree(bbox))}colorBoundingBoxes(svgNode){this.bboxes.forEach(bbox=>{svgNode.append("rect").attr("fill","blue").attr("opacity",.2).attr("x",bbox.x).attr("y",bbox.y).attr("width",bbox.width).attr("height",bbox.height)})}}const computeMatchChartColor=(color,chartColor,opacity)=>{if(color!==MATCH_CHART_COLOR){return color}const hexChartColor=ColorUtils.isValidHexColor(chartColor)?chartColor:ColorUtils.RGBAToHex(ColorUtils.strToRGBA(chartColor));return _.isNil(opacity)?chartColor:ColorUtils.getHexWithAlpha(hexChartColor,opacity)};function getTextNodeContentFromSubText(i){const parent=d3.select(this.parentNode);let parentContent=parent.datum();let parentColumnIdx=i;if(Array.isArray(parentContent)&&i!==undefined){parentColumnIdx=0;let nbTexts=0;for(let index=0;index<parentContent.length&&nbTexts<=i;index++){const columnData=parentContent[index];nbTexts+=columnData.textsElements.length;if(nbTexts>i){parentColumnIdx=index}}parentContent=parentContent[parentColumnIdx]}return{parentContent:parentContent,parentColumnIdx:parentColumnIdx}}const utils={clipPaths:function(chartBase,g,wrappers){const defs=g.append("defs");const CLIP_PATH_ID="chart-clip-path-"+generateUniqueId();const isAllNegativeRange=!D3ChartAxes.getCurrentAxisExtent(chartBase.yAxes[0]).find(val=>val>0);const yPosition=isAllNegativeRange?0:-chartBase.margins.top;defs.append("clipPath").attr("id",CLIP_PATH_ID).append("rect").attr("y",yPosition).attr("width",chartBase.vizWidth).attr("height",chartBase.vizHeight+chartBase.margins.top);wrappers.attr("clip-path","url(#"+CLIP_PATH_ID+")");wrappers.style("-webkit-clip-path","url(#"+CLIP_PATH_ID+")")},drawLabels(drawContext,chartPrefix,hasColorDim=false){const labelGroups=this.drawLabelsRaw(drawContext,chartPrefix,false,hasColorDim);this.drawLabelsRaw(drawContext,chartPrefix,true,hasColorDim);return labelGroups},drawLabelsRaw(drawContext,chartPrefix,onHoverMode=false,hasColorDim=false){if(!drawContext.overlappingStrategy){return}let labelClass=drawContext.isTotals?"total":"value";if(onHoverMode){labelClass=`${labelClass}-alt`}const labelGroupsClassNames=[`${chartPrefix}-labels`,"chart-value-labels"];const labelGroups=drawContext.node.selectAll(`g.${labelGroupsClassNames.join(".")}`).data(drawContext.data);labelGroups.enter().append("g").attr("class",labelGroupsClassNames.join(" "));if(drawContext.transform){labelGroups.attr("transform",drawContext.transform);if(drawContext.transformations){labelGroups.each(function(d,i){d.translate={x:drawContext.transformations.x(d,i),y:drawContext.transformations.y(d,i)}})}}labelGroups.exit().remove();const rectTexts=labelGroups.selectAll(`text.${labelClass}`).data(function(d){return Array.isArray(d)?[...d]:[d]});rectTexts.enter().append("text").attr("class",labelClass).attr("text-anchor","middle").attr("dominant-baseline","middle").style("pointer-events","none");rectTexts.exit().remove();if(onHoverMode){rectTexts.attr("opacity",0)}const subTexts=rectTexts.selectAll(`tspan.${labelClass}`).data(function(d){return d.textsElements});subTexts.enter().append("tspan").attr("class",labelClass);subTexts.exit().remove();subTexts.text(function(d){const text=drawContext.getLabelText(d);return text}).attr("fill",function(d){const formattingOptions=d.valuesInChartDisplayOptions.textFormatting;const chartColor=drawContext.colorScale(ChartColorUtils.getColorIndex(d,hasColorDim));const backgroundColor=drawContext.hasBackground?chartColor:"#fff";let fontColor=computeMatchChartColor(formattingOptions.fontColor,chartColor,drawContext.opacity);if(fontColor===CHART_COLOR_AUTO){const foregroundColor=formattingOptions.hasBackground?computeMatchChartColor(formattingOptions.backgroundColor,chartColor,drawContext.opacity):null;const blendColor=ColorUtils.getBlendedColor(foregroundColor,backgroundColor);fontColor=ColorUtils.getFontContrastColor(blendColor,drawContext.theme&&drawContext.theme.generalFormatting.fontColor)}return fontColor}).style("font-size",function(d){const formattingOptions=d.valuesInChartDisplayOptions.textFormatting;return`${formattingOptions.fontSize}px`}).each(function(d){const bbox=this.getBoundingClientRect();d.width=bbox.width;d.height=bbox.height}).attr("dy",function(d){if(!this.previousSibling){return 0}const previousNodeDatum=d3.select(this.previousSibling).datum();const previousNodeFontSize=previousNodeDatum.valuesInChartDisplayOptions.textFormatting.fontSize;const currentNodefontSize=d.valuesInChartDisplayOptions.textFormatting.fontSize;return previousNodeFontSize/2+d.height-currentNodefontSize/2});rectTexts.filter(function(d){return!d.isInvalid}).each(function(d,i,n){d.height=d.textsElements.reduce((acc,b)=>acc+b.height,0);d.width=d.textsElements.reduce((acc,b)=>Math.max(acc,b.width),0);if(drawContext.getExtraData){const extraData=drawContext.getExtraData.bind(this)(d,i,n,onHoverMode);if(extraData){Object.assign(d,extraData)}}const isOverlap=onHoverMode?d.isOverlapAlt:d.isOverlap;if(d.valuesInChartDisplayOptions&&!d.valuesInChartDisplayOptions.displayValues||drawContext.overlappingStrategy===ValuesInChartOverlappingStrategy.AUTO&&isOverlap||d.isInvalid){d3.select(this).attr("visibility","hidden");d.width=0;d.height=0;d.textsElements.forEach(t=>{t.width=0;t.height=0})}else{d3.select(this).attr("visibility",null)}}).interrupt("updateLabels").transition("updateLabels").duration(200).ease("easeOutQuad").attr("x",function(d,i){const x=drawContext.getLabelXPosition(d,i);d.textX=x;return x}).attr("y",function(d,i){let y=drawContext.getLabelYPosition(d,i);const firstSubText=d.textsElements[0];if(!firstSubText){return y}const firstSubTextHeight=firstSubText.height||0;const firstSubTextFontSize=firstSubText.valuesInChartDisplayOptions.textFormatting.fontSize;const offset=firstSubTextHeight/2+(firstSubTextHeight-firstSubTextFontSize)/2;y+=offset;d.textY=y;return y});subTexts.attr("x",function(){const parentX=d3.select(this.parentNode).datum().textX;return parentX});if(drawContext.isTotals){subTexts.attr("font-weight",500)}this.drawLabelsBackground(labelGroups,subTexts,drawContext.getBackgroundXPosition,drawContext.getBackgroundYPosition,drawContext.backgroundXMargin,drawContext.colorScale,labelClass,drawContext.opacity,onHoverMode,hasColorDim);return labelGroups},drawLabelsBackground(labelGroups,subTexts,getBackgroundXPosition,getBackgroundYPosition,xMargin,colorScale,labelClass,opacity,onHoverMode,hasColorDim){const rectBackgrounds=labelGroups.selectAll(`rect.background-${labelClass}`).data(function(d){return Array.isArray(d)?_.flatten(d.map(d=>d.textsElements)):d.textsElements});rectBackgrounds.enter().insert("rect",`text.${labelClass}`).attr("class",function(d){const backgroundClasses=[`background-${labelClass}`,`aggregation-${d.aggregationIndex}`];return backgroundClasses.join(" ")}).attr("fill",function(d){const formattingOptions=d.valuesInChartDisplayOptions.textFormatting;const chartColor=colorScale(ChartColorUtils.getColorIndex(d,hasColorDim));return computeMatchChartColor(formattingOptions.backgroundColor,chartColor,opacity)}).style("pointer-events","none");rectBackgrounds.exit().remove();if(onHoverMode){rectBackgrounds.attr("opacity",0)}rectBackgrounds.attr("stroke-width",0).each(function(d){const formattingOptions=d.valuesInChartDisplayOptions.textFormatting;if(!formattingOptions.hasBackground){d3.select(this).attr("visibility","hidden");d.hideBackground=true}else{d3.select(this).attr("visibility",null);d.hideBackground=false}}).interrupt("updateLabelsBackground").transition("updateLabelsBackground").duration(200).ease("easeOutQuad").attr("x",function(d,i){const{parentContent,parentColumnIdx}=getTextNodeContentFromSubText.bind(this)(i);return getBackgroundXPosition({...parentContent,...d},parentColumnIdx)}).attr("y",function(d,i){const{parentContent,parentColumnIdx}=getTextNodeContentFromSubText.bind(this)(i);return getBackgroundYPosition({...parentContent,aggregationIndex:d.aggregationIndex},parentColumnIdx)}).attr("width",function(d){if(!d.width||d.hideBackground){return 0}return d.width+xMargin*2}).attr("height",function(d){if(!d.height||d.hideBackground){return 0}return d.height})},initLabelCollisionDetection(chartBase){return new LabelCollisionDetectionHandler(chartBase)},getLabelSubTexts(chartDef,measureIdx,valuesInChartDisplayOptions,isTotal){const result=[];if(!valuesInChartDisplayOptions||!valuesInChartDisplayOptions.addDetails||!valuesInChartDisplayOptions.additionalMeasures||!valuesInChartDisplayOptions.additionalMeasures.length||chartDef.variant==="stacked_100"){result.push({aggregationIndex:measureIdx,valuesInChartDisplayOptions:valuesInChartDisplayOptions||chartDef.valuesInChartDisplayOptions})}else{const additionalMeasures=valuesInChartDisplayOptions.additionalMeasures;if(isTotal){const offsetIdx=chartDef.genericMeasures.length+chartDef.tooltipMeasures.length;additionalMeasures.forEach((additionalMeasure,idx)=>{const finalIdx=offsetIdx+idx;result.push({aggregationIndex:finalIdx,valuesInChartDisplayOptions:additionalMeasure.valuesInChartDisplayOptions||valuesInChartDisplayOptions||chartDef.valuesInChartDisplayOptions})})}else{const hasTotalsAdditionalMeasures=ChartFeatures.canDisplayTotalValues(chartDef)&&!!chartDef.stackedColumnsOptions&&!!chartDef.stackedColumnsOptions.totalsInChartDisplayOptions&&!!chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.additionalMeasures;const offsetIdx=chartDef.genericMeasures.length+chartDef.tooltipMeasures.length+(hasTotalsAdditionalMeasures?chartDef.stackedColumnsOptions.totalsInChartDisplayOptions.additionalMeasures.length:0)+chartDef.genericMeasures.slice(0,measureIdx).reduce((acc,measure)=>acc+measure.valuesInChartDisplayOptions&&measure.valuesInChartDisplayOptions.additionalMeasures?measure.valuesInChartDisplayOptions.additionalMeasures.length:0,0);additionalMeasures.forEach((additionalMeasure,idx)=>{const finalIdx=offsetIdx+idx;result.push({aggregationIndex:finalIdx,valuesInChartDisplayOptions:additionalMeasure.valuesInChartDisplayOptions||valuesInChartDisplayOptions||chartDef.valuesInChartDisplayOptions})})}}return result},getRectanglesFromPosition(position,textElement,defaultFontSize){let currentYPosition=position.y;const res=[];textElement.textsElements.forEach(t=>{let fontSize=defaultFontSize;if(t.valuesInChartDisplayOptions&&t.valuesInChartDisplayOptions.textFormatting){fontSize=t.valuesInChartDisplayOptions.textFormatting.fontSize}else if(textElement.valuesInChartDisplayOptions&&textElement.valuesInChartDisplayOptions.textFormatting){fontSize=textElement.valuesInChartDisplayOptions.textFormatting.fontSize}const subTextElementTop=currentYPosition;currentYPosition+=(t.height-fontSize)/2;res.push({x:position.x-t.width/2,y:currentYPosition,width:t.width,height:fontSize});currentYPosition=subTextElementTop+t.height});return res},getSubTextYPosition(d,parentTextTopYPosition){let y=parentTextTopYPosition;for(let index=0;index<d.textsElements.length&&d.textsElements[index].aggregationIndex!==d.aggregationIndex;index++){const textElem=d.textsElements[index];y+=textElem.height}return y},addPlotAreaContextMenuAnchor(chart,plotWidth,plotHeight){let bg=chart.select(".chart-contextual-menu-anchor");if(bg.empty()){bg=chart.insert("rect",":first-child").attr("class","chart-contextual-menu-anchor").attr("x",0).attr("y",0).attr("width",plotWidth).attr("height",plotHeight).style("fill","transparent").style("pointer-events","all")}return bg}};return utils})})();(function(){"use strict";const app=angular.module("dataiku.charts");app.factory("WebappChart",function(DataikuAPI,$stateParams,VirtualWebApp,SmartId){return function($container,chartDef,data,$scope){$scope.chartDef=chartDef;$scope.uiDisplayState=$scope.uiDisplayState||{};$scope.storedWebAppId=$scope.chartDef.$storedWebAppId;const datasetSmartName=SmartId.create(data.datasetName,data.projectKey);if($scope.chartDef.$pluginChartDesc.datasetParamName){$scope.chartDef.webAppConfig[$scope.chartDef.$pluginChartDesc.datasetParamName]=datasetSmartName}const hooks={webAppConfigPreparation:function(chartDef){const strippedChartDef=angular.copy(chartDef);Object.keys($scope.chartDef).filter(function(k){return k.startsWith("$")}).forEach(function(k){delete strippedChartDef[k]});return strippedChartDef},stopFunction:function(){return $scope.chartDef.type!="webapp"},handleError:$scope.chartSetErrorInScope,webAppReady:function(webAppId){$scope.chartDef.$storedWebAppId=webAppId}};$scope.uiDisplayState.skinWebApp={noConfigWatch:true};VirtualWebApp.update($scope,$container,"chartDef.webAppType","chartDef",DataikuAPI.explores.getOrCreatePluginChart.bind($scope,$stateParams.projectKey,datasetSmartName,chartDef),$scope.uiDisplayState.skinWebApp,hooks)}})})();(function(){"use strict";angular.module("dataiku.charts").service("ChartTooltipsUtils",ChartTooltipsUtils);function ChartTooltipsUtils(LoggerProvider,$q,$templateRequest,$timeout,$compile){let globalTooltipId=0;const Logger=LoggerProvider.getLogger("charts");const tooltipDisappear=function(tooltip){tooltip.interrupt("fade").transition("fade").duration(100).style("opacity",0);tooltip.style("pointer-events","none");return tooltip};const svc={create:function(parentScope,type,chart){const deferred=$q.defer();let tooltipScope,tooltip;const location="/templates/simple_report/tooltips/"+type+".html";$templateRequest(location).then(function(template){if(parentScope.noTooltips){deferred.resolve([null,{$apply:function(){},noTooltips:true}]);return}if(angular.isArray(template)){template=template[1]}else if(angular.isObject(template)){template=template.data}globalTooltipId++;const newDOMElt=$(template);newDOMElt.addClass("ng-cloak");newDOMElt.attr("g-tooltip-id",globalTooltipId);$("body").append(newDOMElt);Logger.info("Create tooltip: "+globalTooltipId+", now have in DOM: "+$("[g-tooltip-id]").length);tooltip=d3.selectAll(newDOMElt.toArray());tooltip.style("top",0).style("left","-50%");$timeout(function(){$compile(newDOMElt)(parentScope);tooltipScope=angular.element(newDOMElt).scope();tooltipScope.$on("$destroy",function(){Logger.info("Destroying tooltip: "+tooltip.attr("g-tooltip-id"));tooltip.remove()});deferred.resolve([tooltip,tooltipScope])});tooltip.on("mouseenter",function(){tooltipScope.mouseOnTooltip=true;tooltipScope.$apply()}).on("mouseleave",function(){tooltipScope.mouseOnTooltip=false;if(!tooltipScope.mouseOnElement){tooltipDisappear(tooltip)}tooltipScope.$apply()});svc.flagTooltipAndRemoveOrphans(chart,tooltip)});return deferred.promise},createWithStdAggr1DBehaviour:function(parentScope,type,chart){return svc.create(parentScope,type,chart).then(function(x){return x})},appear:function(tooltip,color,event,element,xOffset){if(!tooltip){return}let tooltipX=event.pageX+3+(xOffset?xOffset:0);let tooltipY=event.pageY-28;const eventSvgX=event.pageX-$(element).offset().left;const eventSvgY=event.pageY-$(element).offset().top;if(eventSvgX>$(element).outerWidth()/2){tooltipX=event.pageX-tooltip.node().getBoundingClientRect().width-3-(xOffset?xOffset:0)}if(eventSvgY>$(element).outerHeight()/2){tooltipY=event.pageY-tooltip.node().getBoundingClientRect().height+28}tooltip.interrupt("fade").transition("fade").duration(300).style("opacity",1).style("left",tooltipX+"px").style("top",tooltipY+"px");tooltip.style("pointer-events","none");return tooltip},handleMouseOverElement:function(tooltipScope){if(!tooltipScope||tooltipScope.noTooltips){return}tooltipScope.mouseOnElement=true;tooltipScope.tooltipIsPersistent=false},handleMouseOutElement:function(tooltip,tooltipScope,digestInProgress){if(tooltipScope.noTooltips){return}tooltipScope.mouseOnElement=false;if(!tooltipScope.tooltipIsPersistent){tooltipDisappear(tooltip)}else{$timeout(function(){if(!tooltipScope.mouseOnTooltip){tooltipDisappear(tooltip);tooltipScope.tooltipIsPersistent=false;if(!digestInProgress){tooltipScope.$apply()}}},150)}if(!digestInProgress){tooltipScope.$apply()}},handleClickElement:function(tooltip,tooltipScope){if(tooltipScope.noTooltips){return}if(tooltipScope.tooltipIsPersistent){tooltip.style("pointer-events","none")}else{tooltip.style("pointer-events","auto")}tooltipScope.tooltipIsPersistent=!tooltipScope.tooltipIsPersistent;tooltipScope.$apply()},flagTooltipAndRemoveOrphans:function(chart,tooltip){const flagChartAndTooltipTogether=function(chart,tooltip){const id=Date.now();$(chart).parents(".pivot-chart").attr("data-tooltip-id",id);tooltip.attr("data-tooltip-id",id)};const removeOrphanTooltips=function(){$(".chart-tooltip").each(function(index,element){const id=$(element).data("tooltipId");if($('.pivot-chart[data-tooltip-id="'+id+'"]').length<=0){$(element).remove()}})};flagChartAndTooltipTogether(chart,tooltip);removeOrphanTooltips()}};return svc}})();(function(){"use strict";angular.module("dataiku.charts").service("ChartTooltips",ChartTooltips);function ChartTooltips($templateRequest,$compile,$rootScope,ChartFilters,ChartFormatting,ChartColorScales,ChartLabels,ChartDimension,ChartColorUtils,AnimatedChartsUtils,CHART_TYPES,ChartStoreFactory,ChartFeatures,Logger,ChartUADimension,$stateParams,DKU_OTHERS_VALUE,DashboardFilters,DashboardUtils,HierarchicalChartsUtils,ConditionalFormattingOptions,ChartDrilldown,ChartHierarchyDimension,DKU_TOTAL_VALUE,DRILL_UP_SOURCE,DRILL_DOWN_SOURCE,ChartPropertiesService){const DASHBOARD_TOOLTIPS_CONTAINER_SELECTOR=".dashboard-tile__chart-tooltips-container";const DASHBOARD_TOOLTIP_CONTAINER_CLASS="dashboard-tile__chart-tooltip-container";const DASHBOARD_TOOLTIP_CONTAINER_SELECTOR=`.${DASHBOARD_TOOLTIP_CONTAINER_CLASS}`;const DASHBOARD_TILE_SELECTOR=".dashboard-tile";const ECHARTS_CHART_CONTAINER_SELECTOR=".main-echarts-zone > .chart";const D3_CHART_CONTAINER_SELECTOR=".mainzone > .charts";const CHART_WRAPPER_SELECTOR=".chart-wrapper";const DEFAULT_COLOR_TRANSITION_DURATION=300;let globalTooltipScopes=0;let resetColorsTimeout=null;function getTooltipContainers(element,from,isEChart){if(from!=="container"&&from!=="tooltip"){Logger.error(`Incorrect parameter encountered while trying to get tooltip container: from = ${from}`);return $()}if(DashboardUtils.isInDashboard()){const chartsContainerSelector=isEChart?ECHARTS_CHART_CONTAINER_SELECTOR:D3_CHART_CONTAINER_SELECTOR;const chartsContainer=(from==="container"?element.find(chartsContainerSelector):element.closest(chartsContainerSelector)).get(0);if(chartsContainer){const isChartsContainerScrollable=chartsContainer.scrollHeight>chartsContainer.clientHeight;if(!isChartsContainerScrollable){return element.closest(DASHBOARD_TILE_SELECTOR).find(DASHBOARD_TOOLTIP_CONTAINER_SELECTOR)}}}if(from==="container"){return element.find(CHART_WRAPPER_SELECTOR)}else if(from==="tooltip"){return element.closest(CHART_WRAPPER_SELECTOR)}}function createDashboardTooltipContainers(element,facets,forceSingleContainer){const dashboardContainers=element.closest(DASHBOARD_TILE_SELECTOR).find(DASHBOARD_TOOLTIPS_CONTAINER_SELECTOR);const numbersOfContainersToCreate=forceSingleContainer?1:facets.length;dashboardContainers.empty();let cumulatedHeight=0;for(let i=0;i<numbersOfContainersToCreate;i++){const chartContainerHeight=$(element.find(CHART_WRAPPER_SELECTOR).get(i)).outerHeight(true);const newTooltipContainer=$(`<div class="${DASHBOARD_TOOLTIP_CONTAINER_CLASS}"></div>`);newTooltipContainer.css("top",cumulatedHeight);newTooltipContainer.height(chartContainerHeight);cumulatedHeight+=chartContainerHeight;dashboardContainers.append(newTooltipContainer)}}function exclude(chartDef,filterableElements){const filter=ChartFilters.getExcludeNDFilter(filterableElements);if(DashboardUtils.isInDashboard()){filter.isAGlobalFilter=true;$rootScope.$emit("crossFiltersAdded",{filters:[filter],wt1Args:{from:"chart",action:"tooltip",chartType:chartDef.type,filterType:"exclude"}})}else if(!chartDef.filters.some(f=>ChartFilters.areFiltersEqual(f,filter))){chartDef.filters=ChartFilters.updateOrAddFilter(chartDef.filters,filter)}}function includeOnly(chartDef,filterableElements){if(DashboardUtils.isInDashboard()){const filters=filterableElements.map(filterableElement=>{const{dimension,axisElt,value}=filterableElement;return ChartFilters.createFilter({column:dimension.column,columnType:dimension.type,isAGlobalFilter:true,excludeOtherValues:true,label:`ONLY ${dimension.column}: ${value}`,useMinimalUi:true,includeEmptyValues:false},{dimension:dimension,axisElt:axisElt})});$rootScope.$emit("crossFiltersAdded",{filters:filters,wt1Args:{from:"chart",action:"tooltip",chartType:chartDef.type,filterType:"include"}})}else{let filters=chartDef.filters;filterableElements.forEach(filterableElement=>{const{dimension,axisElt}=filterableElement;const{oldFilter,newFilter}=ChartFilters.getIncludeOnly1DFilter(dimension,axisElt,filters);if(!ChartFilters.areFiltersEqual(oldFilter,newFilter)){filters=ChartFilters.updateOrAddFilter(filters,newFilter,oldFilter)}});chartDef.filters=filters}}const createTooltip=($container,template,chartHandler,chartData,chartDef,defaultTooltipState,ignoreLabels)=>{let $tooltip;const tooltipScopes={};const facets=chartData.getAxisLabels("facet",ignoreLabels)||[{$tensorIndex:0}];const isInDashboard=DashboardUtils.isInDashboard();const isEChart=ChartFeatures.isEChart(chartDef);if(isInDashboard){createDashboardTooltipContainers($container,facets,isEChart)}const containers=getTooltipContainers($container,"container",isEChart);facets.forEach((facet,index)=>{const facetIndex=facet&&facet.$tensorIndex||index;const tooltipScope=chartHandler.$new();tooltipScope.ChartFeatures=ChartFeatures;tooltipScope.chartData=chartData;tooltipScope.chartDef=chartDef;tooltipScope.facetIndex=index;tooltipScope.tooltipState={...defaultTooltipState};tooltipScope.dimensionEntries=[];tooltipScope.getDimensionLabel=ChartLabels.getDimensionLabel;tooltipScope.getDimensionNumberFormattingOptions=ChartDimension.getNumberFormattingOptions.bind(ChartDimension);tooltipScope.isInDashboard=isInDashboard;if(ChartFeatures.canHaveConditionalFormatting(chartDef.type)){const getValueFormatter=(measure,measureIdx)=>coords=>{if(!chartData.isBinMeaningful(measure.function,coords,measureIdx)){return ChartFormatting.getForIsolatedNumber(measure)(ChartLabels.NO_VALUE)}const cellValue=chartData.aggr(measureIdx).get(coords);return ChartFormatting.getForIsolatedNumber(measure)(cellValue)};const defaultValueTooltips=chartDef.genericMeasures.map((measure,i)=>({cellMeasure:measure,genericMeasureIndex:i,cellValueFormatter:getValueFormatter(measure,i)}));const chartStore=ChartStoreFactory.get(chartDef.$chartStoreId),xDimensionIds=chartDef.xDimension.map(xDim=>chartStore.getDimensionId(xDim)).filter(dim=>dim!==undefined),yDimensionIds=chartDef.yDimension.map(yDim=>chartStore.getDimensionId(yDim)).filter(dim=>dim!==undefined);const currentHierarchyXDim=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"x");const currentHierarchyYDim=ChartHierarchyDimension.getCurrentHierarchyDimension(chartDef,"y");if(currentHierarchyXDim){xDimensionIds.push(chartStore.getDimensionId(currentHierarchyXDim))}if(currentHierarchyYDim){yDimensionIds.push(chartStore.getDimensionId(currentHierarchyYDim))}const getColorContext=(colorOptions,colorMeasureIndex)=>({chartData:chartData,colorOptions:colorOptions,defaultLegendDimension:chartDef.genericMeasures,colorSpec:{type:"MEASURE",measureIdx:colorMeasureIndex,withRgba:true,colorAggrFn:HierarchicalChartsUtils.getColorMeasureAggFunction(chartDef,colorMeasureIndex),binsToInclude:xDimensionIds.length>0&&yDimensionIds.length>0?HierarchicalChartsUtils.getBinsToIncludeInColorScale(chartData,xDimensionIds,yDimensionIds,colorMeasureIndex,chartDef,chartDef.pivotTableOptions.displayTotals.subTotals.rows,chartDef.pivotTableOptions.displayTotals.subTotals.columns):null}});let basedOnMeasureIndexCounter=chartDef.genericMeasures.length-1;tooltipScope.tooltipColorGroupValues=chartDef.colorGroups.filter(({appliedColumns})=>appliedColumns).reduce((acc,{appliedColumns,rules,colorOptions,colorGroupMode,colorMeasure})=>{let groupColorMeasure;if(colorMeasure&&colorMeasure.length>0){groupColorMeasure=colorMeasure[0];basedOnMeasureIndexCounter+=1}appliedColumns.forEach(column=>{const columnAggIndex=ConditionalFormattingOptions.getColorColumnIndex(column,chartDef.genericMeasures,chartDef.colorMode);if(columnAggIndex<0){return}let currColorColumnIndex;let cellColorMeasure;if(groupColorMeasure){currColorColumnIndex=basedOnMeasureIndexCounter;cellColorMeasure=groupColorMeasure}else{currColorColumnIndex=columnAggIndex;cellColorMeasure=chartDef.genericMeasures[columnAggIndex]}const hasColorProperties=colorOptions&&currColorColumnIndex>=0&&currColorColumnIndex<chartData.data.aggregations.length;const colorContext=hasColorProperties?getColorContext(colorOptions,currColorColumnIndex):{};colorContext.theme=chartHandler.getChartTheme();acc=acc.filter(tooltip=>tooltip.genericMeasureIndex!==columnAggIndex);acc.push({rules:rules,colorGroupMode:colorGroupMode,colorProperties:hasColorProperties?{getColorScale:()=>ChartColorScales.createColorScale(colorContext),getBin:cellCoords=>chartData.getAggrLoc(currColorColumnIndex,cellCoords)}:undefined,basedOnMeasure:cellColorMeasure,basedOnMeasureIndex:currColorColumnIndex,colorValueFormatter:getValueFormatter(cellColorMeasure,currColorColumnIndex),cellValueFormatter:getValueFormatter(chartDef.genericMeasures[columnAggIndex],columnAggIndex),cellMeasure:chartDef.genericMeasures[columnAggIndex],genericMeasureIndex:columnAggIndex})});return acc},defaultValueTooltips);tooltipScope.tooltipColorGroupValues.sort((a,b)=>a.genericMeasureIndex-b.genericMeasureIndex)}tooltipScope.canMultiDimensionalFilter=false;tooltipScope.canFilter=false;tooltipScope.coords=function(){return angular.extend({},tooltipScope.tooltipState.coords,{facet:facetIndex})};tooltipScope.exclude=function(){const{filterableElements}=ChartFilters.getFilterableOptions(ChartStoreFactory.get(chartDef.$chartStoreId),chartData,tooltipScope.coords(),chartDef);exclude(chartDef,filterableElements)};tooltipScope.includeOnly=function(){const{filterableElements}=ChartFilters.getFilterableOptions(ChartStoreFactory.get(chartDef.$chartStoreId),chartData,tooltipScope.coords(),chartDef);includeOnly(chartDef,filterableElements)};let $div=$(containers.get(index));if(isEChart){$div=$(containers.get(0))}$tooltip=$(template).appendTo($div);tooltipScopes[facetIndex]=tooltipScope;globalTooltipScopes++;tooltipScope.$on("$destroy",function(){globalTooltipScopes--;Logger.debug("Destroying tooltipScope: "+tooltipScopes.$id+" - new total "+globalTooltipScopes);tooltipScopes[facetIndex]=null;delete tooltipScopes[facetIndex];if(tooltipScope.unregisterUnfixTooltipEvent){tooltipScope.unregisterUnfixTooltipEvent()}});$compile($tooltip)(tooltipScope)});return{tooltipScopes:tooltipScopes}};const hasUaDimensions=chartDef=>{return chartDef.type===CHART_TYPES.SCATTER};const getScatterMPDimensions=(chartDef,coords)=>{const pairIndex=coords.extras.pair;const displayablePairs=ChartUADimension.getDisplayableDimensionPairs(chartDef.uaDimensionPair);const uaXDimension=ChartUADimension.getPairUaXDimension(displayablePairs,displayablePairs[pairIndex]);return[{isDisplayed:!!displayablePairs[pairIndex]&&!!uaXDimension[0],dimension:uaXDimension[0],axisName:"x"},{isDisplayed:!!displayablePairs[pairIndex]&&!!displayablePairs[pairIndex].uaYDimension[0],dimension:displayablePairs[pairIndex].uaYDimension[0],axisName:"y"}]};const unfocusElement=function(desaturatedColor){const d3Elem=d3.select(this);if(d3Elem.datum().transparent){d3Elem.interrupt("updateFocus").transition("updateFocus").duration(DEFAULT_COLOR_TRANSITION_DURATION).attr("opacity",0)}else{d3Elem.interrupt("updateFocus").transition("updateFocus").duration(DEFAULT_COLOR_TRANSITION_DURATION).attr(this._colorAttr,desaturatedColor)}};const focusElement=function(color,chartTransparency){const d3Elem=d3.select(this);if(d3Elem.datum().transparent){d3Elem.interrupt("updateFocus").transition("updateFocus").duration(DEFAULT_COLOR_TRANSITION_DURATION).attr("opacity",chartTransparency).attr(this._colorAttr,color)}else{d3Elem.transition(DEFAULT_COLOR_TRANSITION_DURATION).attr(this._colorAttr,color)}};const resetElementColor=function(color){const d3Elem=d3.select(this);if(d3Elem.datum().transparent){d3Elem.interrupt("updateFocus").transition("updateFocus").duration(DEFAULT_COLOR_TRANSITION_DURATION).attr("opacity",0).attr(this._colorAttr,color)}else{d3Elem.interrupt("updateFocus").transition("updateFocus").duration(DEFAULT_COLOR_TRANSITION_DURATION).attr(this._colorAttr,color)}};return{create:function($container,chartHandler,chartData,chartDef,measureFormatters,colorScale,ignoreLabels=new Set){const tooltipContainer=getTooltipContainers($container,"container",ChartFeatures.isEChart(chartDef));const $oldTooltips=tooltipContainer.find(".svg-tooltip.pivot-chart-tooltip");$oldTooltips.remove();function isColorDimensionDisplayed(chartDef,chartData,options={}){if(chartData.axesDef.color!==undefined){if(chartDef.type===CHART_TYPES.MULTI_COLUMNS_LINES){return options.displayColorTooltip!==false}return![CHART_TYPES.TREEMAP,CHART_TYPES.RADAR].includes(chartDef.type)}return false}function getDimensionTooltipEntry(chartDef,chartData,coords,dimension,axisName,colored){if(!coords||!axisName){return{}}let label=ChartLabels.getDimensionLabel(dimension);let axisElt={};if(!ChartFeatures.canHaveBinningOptions(chartDef)){axisElt.min=null;axisElt.max=null}const dimensionTooltipId=`qa_charts_tooltip-dimension-${(dimension.column||"").replace(/\s/g,"_")}`;let value,filterValue,isTotalBin;if(chartDef.type===CHART_TYPES.SCATTER||chartDef.type===CHART_TYPES.SCATTER_MULTIPLE_PAIRS){label=ChartLabels.getUaLabel(dimension);value=chartData.uaFormattedVal(dimension,coords,axisName);filterValue=value}else if(chartDef.type===CHART_TYPES.RADAR){const radarDimension=ChartDimension.getGenericDimension(chartDef);label=dimension.isA==="measure"?ChartLabels.getLongMeasureLabel(dimension):ChartLabels.getFormattedLabel(dimension,ChartDimension.getNumberFormattingOptions(radarDimension),dimension.min,dimension.max);const formattingOptions=ChartDimension.getNumberFormattingOptions({...chartDef.genericMeasures[chartData.shouldDrawPolygonsFromMeasures()?coords.measure:dimension.index],type:"NUMERICAL"});value=ChartLabels.getFormattedLabel(dimension.value,formattingOptions);filterValue=ChartLabels.getFormattedLabel({label:dimension.label},dimension.isA==="measure"?formattingOptions:{});axisElt=dimension;dimension=radarDimension}else{const finalCoord=coords.tooltipOverrides?.[axisName]??coords[axisName];axisElt=chartData.getAxisLabels(axisName)[finalCoord];isTotalBin=chartData.isComputedTotal?.(axisName,coords);value=ChartLabels.getAxisEltFormattedLabel({chartDef:chartDef,chartData:chartData,dimension:dimension,axisName:axisName,axisElt:axisElt});filterValue=value}const canChartTypeBeFiltered=ChartFeatures.canFilterInTooltip(chartDef);const isInDashboard=DashboardUtils.isInDashboard();const isRadarChartMeasure=chartDef.type===CHART_TYPES.RADAR&&axisElt.isA==="measure";const isInReusableDimensionPreview=chartDef.$isInReusableDimensionPreview;const isOthersBin=axisElt.label===DKU_OTHERS_VALUE;const canAddEmptyFilter=canChartTypeBeFiltered&&!isRadarChartMeasure&&!isInReusableDimensionPreview;const canFilter=canChartTypeBeFiltered&&!isRadarChartMeasure&&!isOthersBin&&!isTotalBin&&(!isInDashboard||DashboardFilters.canCrossFilter($stateParams.pageId))&&!isInReusableDimensionPreview;const isDrillable=canFilter&&!isInDashboard&&ChartDimension.isDrillableForElement(chartDef,dimension,axisElt);const nativeDrilldownType=isDrillable?ChartDimension.isGroupedNumerical(dimension)?"NUMERICAL":"DATE":null;const isHierarchyDrillable=dimension&&!isTotalBin&&ChartFeatures.canDrillHierarchy(chartDef.type)&&dimension.hierarchyId&&!isOthersBin&&!isRadarChartMeasure;const isHierarchyDrillableDown=isHierarchyDrillable&&ChartHierarchyDimension.canDimensionDrillDown(chartDef,dimension);const isHierarchyDrillableUp=isHierarchyDrillable&&ChartHierarchyDimension.canDimensionDrillUp(chartDef,dimension);const hierarchyName=!isRadarChartMeasure&&ChartHierarchyDimension.getDimensionHierarchyName(chartDef,dimension);const previousHierarchyDimension=ChartHierarchyDimension.getDimensionHierarchyPreviousDimensionName(chartDef,dimension);const nextHierarchyDimension=ChartHierarchyDimension.getDimensionHierarchyNextDimensionName(chartDef,dimension);const tooltipLabel=`${ChartLabels.getDimensionLabel(dimension)} - ${filterValue}`;const chartTheme=chartHandler.getChartTheme();return{label:label,value:value,labelId:`${dimensionTooltipId}-name`,valueId:`${dimensionTooltipId}-value`,drillDownActionId:`${dimensionTooltipId}-drill-down`,drillUpActionId:`${dimensionTooltipId}-drill-up`,colored:colored,tooltipLabel:tooltipLabel,filterValue:filterValue,isDrillable:isDrillable,nativeDrilldownType:nativeDrilldownType,isHierarchyDrillableDown:isHierarchyDrillableDown,isHierarchyDrillableUp:isHierarchyDrillableUp,canFilter:canFilter,hierarchyName:hierarchyName,previousHierarchyDimension:previousHierarchyDimension,nextHierarchyDimension:nextHierarchyDimension,hasActions:canFilter||canAddEmptyFilter&&!isInDashboard||isHierarchyDrillableDown||isHierarchyDrillableUp,canAddEmptyFilter:canAddEmptyFilter,isOthersBin:isOthersBin,chartTheme:chartTheme,isTotalBin:isTotalBin,addEmptyFilter:()=>{const newFilter=ChartFilters.createFilter({column:dimension.column,columnType:dimension.type,excludeOtherValues:false});chartDef.filters=ChartFilters.updateOrAddFilter(chartDef.filters,newFilter)},drill:()=>{const{updatedFilters,newDateRange}=ChartDrilldown.getUpdateForNativeDrillDown(chartDef,axisElt,dimension);if(newDateRange){dimension.dateParams.mode=newDateRange}chartDef.filters=updatedFilters},hierarchyDrillDown:()=>{ChartDrilldown.handleDrillDown(chartDef,dimension,DRILL_DOWN_SOURCE.TOOLTIP,axisElt)},hierarchyDrillUp:()=>{ChartDrilldown.handleDrillUp(chartDef,dimension,DRILL_UP_SOURCE.TOOLTIP)},includeOnly:()=>{includeOnly(chartDef,[{axisElt:axisElt,dimension:dimension,value:filterValue}])},exclude:()=>{exclude(chartDef,[{axisElt:axisElt,dimension:dimension,value:filterValue}])}}}function isColored(chartDef){return chartDef.type===CHART_TYPES.SCATTER||chartDef.type===CHART_TYPES.BOXPLOTS}function getDimensionEntries(coords,options){const chartStore=ChartStoreFactory.get(chartDef.$chartStoreId);const dimensionDefs=[{isDisplayed:isColorDimensionDisplayed(chartDef,chartData,options)&&!!coords,dimension:ChartColorUtils.getColorDimensionOrMeasure(chartDef),axisName:"color",colored:isColored(chartDef)},{isDisplayed:!!chartDef.uaXDimension[0]&&hasUaDimensions(chartDef),dimension:chartDef.uaXDimension[0],axisName:"x"},{isDisplayed:!!chartDef.uaYDimension[0]&&hasUaDimensions(chartDef),dimension:chartDef.uaYDimension[0],axisName:"y"},{isDisplayed:!!chartDef.uaShape[0]&&hasUaDimensions(chartDef),dimension:chartDef.uaShape[0],axisName:"shape"},{isDisplayed:!!chartDef.uaSize[0]&&hasUaDimensions(chartDef),dimension:chartDef.uaSize[0],axisName:"size"},{isDisplayed:chartDef.genericDimension0.length&&![CHART_TYPES.PIE,CHART_TYPES.RADAR,CHART_TYPES.GAUGE,CHART_TYPES.SANKEY].includes(chartDef.type),dimension:chartDef.genericDimension0[0],axisName:chartDef.type===CHART_TYPES.STACKED_BARS?"y":"x"},{isDisplayed:chartDef.groupDimension.length,dimension:chartDef.groupDimension[0],axisName:"group"},{isDisplayed:chartData.axesDef&&chartData.axesDef.facet,dimension:chartDef.facetDimension[0],axisName:"facet"},{isDisplayed:chartData.axesDef&&chartData.axesDef.animation,dimension:chartDef.animationDimension[0],axisName:"animation"},{isDisplayed:chartDef.xDimension.length&&!ChartDimension.hasCustomDimId(chartDef.type),dimension:chartDef.xDimension[0],axisName:"x"},{isDisplayed:chartDef.yDimension.length&&!ChartDimension.hasCustomDimId(chartDef.type),dimension:chartDef.yDimension[0],axisName:"y"},{isDisplayed:chartDef.boxplotBreakdownDim.length&&coords,dimension:chartDef.boxplotBreakdownDim[0],axisName:"x"},...chartDef.genericHierarchyDimension.length&&![CHART_TYPES.PIE,CHART_TYPES.RADAR,CHART_TYPES.SANKEY].includes(chartDef.type)?chartDef.genericHierarchyDimension[0].dimensions.map(dim=>getHierarchyDimensionDef(dim,chartDef.type===CHART_TYPES.STACKED_BARS?"y":"x",coords)):[],...chartDef.xHierarchyDimension.length&&!ChartDimension.hasCustomDimId(chartDef.type)?chartDef.xHierarchyDimension[0].dimensions.map(dim=>getHierarchyDimensionDef(dim,"x",coords)):[],...chartDef.yHierarchyDimension.length&&!ChartDimension.hasCustomDimId(chartDef.type)?chartDef.yHierarchyDimension[0].dimensions.map(dim=>getHierarchyDimensionDef(dim,"y",coords)):[],...chartDef.groupHierarchyDimension.length?chartDef.groupHierarchyDimension[0].dimensions.map(dim=>getHierarchyDimensionDef(dim,"group",coords)):[],...chartDef.boxplotBreakdownHierarchyDimension.length?chartDef.boxplotBreakdownHierarchyDimension[0].dimensions.map(dim=>getHierarchyDimensionDef(dim,"x",coords)):[],...chartDef.type===CHART_TYPES.SCATTER_MULTIPLE_PAIRS?getScatterMPDimensions(chartDef,coords):[],chartDef.type===CHART_TYPES.RADAR&&{isDisplayed:true,dimension:{...chartData.getAxisLabels("polygon")[coords.measure],label:ChartLabels.getLongMeasureLabel(chartData.getAxisLabels("polygon")[coords.measure])},axisName:"radarAxis",colored:true},...chartDef.type===CHART_TYPES.RADAR?chartData.aggr(coords.measure).get().slice(0,chartData.getAxisLabels("axis").length).map((value,index)=>({isDisplayed:true,dimension:{...chartData.getAxisLabels("axis")[index],value:{sortValue:value},index:index},axisName:"radarSeries"})):[],...ChartDimension.hasCustomDimId(chartDef.type)?chartDef.xDimension.map(xDimension=>{return getCustomDimensionDef(chartStore,coords,xDimension)}):[],...ChartDimension.hasCustomDimId(chartDef.type)?chartDef.yDimension.map(yDimension=>{const yDimensionId=chartStore.getDimensionId(yDimension);return{isDisplayed:coords[yDimensionId]!==undefined&&coords[yDimensionId]!==chartData.getSubtotalLabelIndex(yDimensionId),dimension:yDimension,axisName:yDimensionId}}):[],...ChartDimension.hasCustomDimId(chartDef.type)&&chartDef.xHierarchyDimension&&chartDef.xHierarchyDimension.length?chartDef.xHierarchyDimension[0].dimensions.map(dimension=>{return getHierarchyDimensionDef(dimension,chartStore.getDimensionId(dimension),coords)}):[],...ChartDimension.hasCustomDimId(chartDef.type)&&chartDef.yHierarchyDimension&&chartDef.yHierarchyDimension.length?chartDef.yHierarchyDimension[0].dimensions.map(dimension=>{return getHierarchyDimensionDef(dimension,chartStore.getDimensionId(dimension),coords)}):[]];return dimensionDefs.filter(({isDisplayed})=>isDisplayed).map(({dimension,axisName,colored})=>getDimensionTooltipEntry(chartDef,chartData,coords,dimension,axisName,colored))}const getCustomDimensionDef=(chartStore,coords,dimension)=>{const dimensionId=chartStore.getDimensionId(dimension);return{isDisplayed:coords[dimensionId]!==undefined,dimension:dimension,axisName:dimensionId}};const getHierarchyDimensionDef=(dimension,dimensionId,coords)=>{const dimensionLevel=ChartHierarchyDimension.getDimensionLevel(chartDef,dimension);const hierarchyLevel=ChartHierarchyDimension.getDimensionHierarchyLevel(chartDef,dimension);return{isDisplayed:coords&&dimensionLevel===hierarchyLevel&&!_.isNil(coords[dimensionId]),dimension:dimension,axisName:dimensionId}};const renderTooltipScopes=(tooltipScopes,callback)=>{angular.forEach(tooltipScopes,(tooltipScope,tooltipScopeIndex)=>{const facetIndex=parseInt(tooltipScopeIndex);callback(tooltipScope,facetIndex,tooltipScopes)});if(!$rootScope.$$phase){$rootScope.$apply()}};let tooltipScopes={};const defaultTooltipState={shown:false,formatters:measureFormatters,canPinTooltip:ChartFeatures.canPinTooltip(chartDef.type)};const templateUrl="/templates/simple_report/tooltips/std-aggr-nd.html";$templateRequest(templateUrl).then(function(template){if(angular.isArray(template)){template=template[1]}else if(angular.isObject(template)){template=template.data}const tooltipOptions=createTooltip($container,template,chartHandler,chartData,chartDef,defaultTooltipState,ignoreLabels);tooltipScopes=tooltipOptions.tooltipScopes});const ret={colorScale:colorScale,destroy:function(){angular.forEach(tooltipScopes,function(tooltipScope){tooltipScope.$destroy()})},showForCoords:function(measure,coords,event,color,options){if(!ChartPropertiesService.showTooltip(chartDef.tooltipOptions,chartHandler.chartTileProperties,ret.fixed)){return}const currentFacetIndex=coords&&coords.facet||0;if(coords){coords.animation=AnimatedChartsUtils.getAnimationCoord(chartHandler.animation)}color=(typeof color==="string"?color:color&&color.value)||"transparent";const updateTooltipContent=(tooltipScope,facetIndex)=>{tooltipScope.shown=true;const canPinTooltip=ChartFeatures.canPinTooltip(chartDef.type);tooltipScope.dimensionEntries=getDimensionEntries(coords?{...coords,facet:facetIndex}:undefined,options);const canDisplayTooltipMeasures=tooltipScope.dimensionEntries.every(entry=>!entry.isTotalBin);tooltipScope.additionalMeasures=options&&options.additionalMeasures!==null?options.additionalMeasures:[];const hasFilterableAxisElts=tooltipScope.dimensionEntries.some(entry=>entry.canFilter);tooltipScope.canMultiDimensionalFilter=tooltipScope.dimensionEntries.every(entry=>entry.canFilter);tooltipScope.canFilter=ChartFeatures.canFilterInTooltip(chartDef)&&hasFilterableAxisElts;tooltipScope.tooltipState={...tooltipScope.tooltipState,shown:true,measure:measure,coords:coords,color:color,canPinTooltip:canPinTooltip,canDisplayTooltipMeasures:canDisplayTooltipMeasures}};const getTooltipPosition=(tooltipScopes,facetIndex)=>{const tooltipScopeFacetIndex=tooltipScopes[facetIndex].facetIndex;const $wrapper=getTooltipContainers($(event.target),"tooltip",ChartFeatures.isEChart(chartDef));const $tooltips=$wrapper.find(".svg-tooltip.pivot-chart-tooltip");const tooltip=$tooltips.length>1?$tooltips.get(tooltipScopeFacetIndex):$tooltips.get(0);const tooltipHeight=tooltip.clientHeight;let left="auto",right="auto",top=0;const wrapperOffset=$wrapper.offset();if(!wrapperOffset){return}const wrapperWidth=$wrapper.width();const wrapperHeight=$wrapper.height();const offsetX=event.pageX-wrapperOffset.left;const offsetY=event.pageY-wrapperOffset.top;const tooltipMargin=20;if(offsetX<wrapperWidth/2){left=offsetX+10+"px"}else{right=wrapperWidth-offsetX+10+"px"}const maxTooltipTop=wrapperHeight-tooltipHeight-tooltipMargin;const centeredTooltipTop=offsetY-tooltipHeight/2;top=Math.max(0,Math.min(maxTooltipTop,centeredTooltipTop))+"px";if(chartDef.displayWithECharts||chartDef.displayWithEChartsByDefault){const tooltipScopeTop=chartDef.chartHeight*tooltipScopeFacetIndex;const hoveredTooltipScopeTop=chartDef.chartHeight*tooltipScopes[currentFacetIndex].facetIndex;top=Math.max(0,Math.min(maxTooltipTop,tooltipScopeTop-hoveredTooltipScopeTop+centeredTooltipTop))+"px";const numberOfFacets=Object.keys(tooltipScopes||[]).length;if(numberOfFacets>1&&chartDef.multiTooltips){const lastFacetIndex=numberOfFacets-1;const lastTooltipScopeTop=chartDef.chartHeight*lastFacetIndex;const lastCenteredTooltipTop=lastTooltipScopeTop-hoveredTooltipScopeTop+centeredTooltipTop;const lastTooltipTopGap=lastCenteredTooltipTop-maxTooltipTop;top=Math.max(0,tooltipScopeTop-hoveredTooltipScopeTop+centeredTooltipTop-lastTooltipTopGap)+"px"}}return{left:left,right:right,top:top}};const updateTooltipPosition=(tooltipScope,facetIndex,tooltipScopes)=>{const{left,right,top}=getTooltipPosition(tooltipScopes,facetIndex);tooltipScope.tooltipState={...tooltipScope.tooltipState,left:left,right:right,top:top}};if(!chartDef.multiTooltips){updateTooltipContent(tooltipScopes[currentFacetIndex],currentFacetIndex,tooltipScopes);tooltipScopes[currentFacetIndex].$apply();updateTooltipPosition(tooltipScopes[currentFacetIndex],currentFacetIndex,tooltipScopes);tooltipScopes[currentFacetIndex].$apply();renderTooltipScopes(tooltipScopes,(tooltipScope,facetIndex)=>{if(facetIndex!==currentFacetIndex){tooltipScope.shown=false;tooltipScope.tooltipState.shown=false}})}else{renderTooltipScopes(tooltipScopes,updateTooltipContent);renderTooltipScopes(tooltipScopes,updateTooltipPosition)}},hide:function(){renderTooltipScopes(tooltipScopes,function(tooltipScope){if(tooltipScope.tooltipState.persistent){return}tooltipScope.shown=false;tooltipScope.tooltipState.shown=false;tooltipScope.dimensionEntries=[]})},fix:function(){if(!ChartPropertiesService.showTooltip(chartDef.tooltipOptions,chartHandler.chartTileProperties)){return}if(ret.fixed){ret.unfix();ret.resetColors()}else{renderTooltipScopes(tooltipScopes,tooltipScope=>{tooltipScope.unregisterUnfixTooltipEvent=$rootScope.$on("unfixTooltip",ret.unfix);if(tooltipScope.tooltipState.shown){ret.fixed=true;tooltipScope.tooltipState.persistent=true}})}},unfix:function(){if(!ret.fixed){return ret.hide()}ret.fixed=false;renderTooltipScopes(tooltipScopes,tooltipScope=>{if(tooltipScope.unregisterUnfixTooltipEvent){tooltipScope.unregisterUnfixTooltipEvent()}tooltipScope.shown=false;tooltipScope.tooltipState.shown=false;tooltipScope.tooltipState.persistent=false})},handleChartMouseOver:function(getTargetElementProperties,colorFocusHandler){const target=d3.event.target;const properties=getTargetElementProperties(target);if(!_.isNil(properties)&&!_.isNil(colorFocusHandler)){const colorIndex=ChartColorUtils.getColorIndex(properties.coords,colorFocusHandler.hasColorDim);if(colorFocusHandler.focusColor&&!ret.fixed&&colorIndex!=null){ret.focusColor(colorIndex)}}},handleChartMouseOut:function(getTargetElementProperties,colorFocusHandler){if(!ret.fixed){ret.hide()}const properties=d3.event.relatedTarget&&getTargetElementProperties(d3.event.relatedTarget);if(!_.isNil(colorFocusHandler)){if(!_.isNil(properties)){const colorIndex=ChartColorUtils.getColorIndex(properties.coords,colorFocusHandler.hasColorDim);if(colorFocusHandler.focusColor&&!ret.fixed&&colorIndex!=null){ret.focusColor(colorIndex)}}else{ret.resetColors()}}},handleChartMouseMove:function(getTargetElementProperties,colorFocusHandler,tooltipOptions){const target=d3.event.target;const properties=getTargetElementProperties(target);if(!_.isNil(properties)){const measure=properties.measure;const coords=properties.coords;const colorIndex=ChartColorUtils.getColorIndex(coords,colorFocusHandler.hasColorDim);if(properties.showTooltip){const color=colorIndex==null?undefined:chartHandler.legendsWrapper.getLegend(0).items[colorIndex].rgbaColor||chartHandler.legendsWrapper.getLegend(0).items[colorIndex].color;ret.showForCoords(measure,coords,d3.event,color,tooltipOptions)}}},handleChartClick:function(getTargetElementProperties){const properties=getTargetElementProperties(d3.event.target);if(properties!=null){d3.event.stopPropagation();if(ret.fixed){ret.unfix()}else{ret.fix();const unfixTooltip=()=>{document.removeEventListener("click",unfixTooltip);ret.unfix();ret.resetColors()};document.addEventListener("click",unfixTooltip)}}},handleChartContextMenu:function(getTargetElementProperties){const target=d3.event.target;const properties=getTargetElementProperties(target);if(properties!=null){d3.event.preventDefault()}ret.unfix();ret.resetColors()},addChartTooltipAndHighlightHandlers:function(chart,getTargetElementProperties,colorFocusHandler,tooltipOptions){const element=d3.select(chart);element.on("mouseover",()=>ret.handleChartMouseOver(getTargetElementProperties,colorFocusHandler)).on("mouseout",()=>ret.handleChartMouseOut(getTargetElementProperties,colorFocusHandler));if(!chartHandler.chartTileProperties||chartHandler.chartTileProperties.showTooltips){element.on("mousemove",()=>ret.handleChartMouseMove(getTargetElementProperties,colorFocusHandler,tooltipOptions)).on("click",()=>ret.handleChartClick(getTargetElementProperties)).on("contextmenu.tooltip",()=>ret.handleChartContextMenu(getTargetElementProperties))}},removeChartTooltipHandlers:function(chart){d3.select(chart).on("mouseover",null).on("mouseout",null).on("mousemove",null).on("click",null).on("contextmenu.tooltip",null)},setAnimationFrame:function(frameIdx){angular.forEach(tooltipScopes,tooltipScope=>{if(tooltipScope.tooltipState.coords){tooltipScope.tooltipState.coords.animation=frameIdx}})},registerEl:function(el,coords,colorAttr,noTooltip,options,hasColorDim=false){if(chartHandler.chartTileProperties&&!chartHandler.chartTileProperties.showTooltips){return}el._colorAttr=colorAttr;const c=coords?ChartColorUtils.getColorIndex(coords,hasColorDim):null;if(colorAttr){chartHandler.legendsWrapper.getLegend(0).items[c].elements[0].push(el)}d3.select(el).attr("tooltip-el",true).on("mousemove",function(){if(!noTooltip){ret.showForCoords(coords?coords.measure:0,coords,d3.event,c==null?undefined:chartHandler.legendsWrapper.getLegend(0).items[c].rgbaColor||chartHandler.legendsWrapper.getLegend(0).items[c].color,options)}}).on("mouseleave",function(){if(!ret.fixed){if(!noTooltip){ret.hide()}if(colorAttr){ret.resetColors()}}}).on("click",function(){if(!noTooltip){ret.fix()}}).on("contextmenu.tooltip",function(){d3.event.preventDefault();ret.unfix();if(colorAttr){ret.resetColors()}}).on("mouseenter",function(elemData){if(colorAttr&&!ret.fixed){ret.focusColor(c,elemData)}})},unregisterEl:function(el){d3.select(el).on("mousemove",null).on("mouseleave",null).on("click",null).on("contextmenu.tooltip",null).on("mouseenter",null)},addTooltipHandlers:function(el,coords,color){if(chartHandler.chartTileProperties&&!chartHandler.chartTileProperties.showTooltips){return}d3.select(el).attr("tooltip-el",true).on("mousemove.tooltip",function(){ret.showForCoords(-1,coords,d3.event,color)}).on("mouseleave.tooltip",ret.hide).on("click",ret.fix).on("contextmenu.tooltip",function(){d3.event.preventDefault();ret.unfix()})},removeTooltipsHandlers:function(el){d3.select(el).on("mousemove.tooltip",null).on("mouseleave.tooltip",null).on("click",null).on("contextmenu.tooltip",null)},focusColor:function(colorIndex,focusedElementData){if(resetColorsTimeout){clearTimeout(resetColorsTimeout);resetColorsTimeout=null}setTimeout(()=>{const legend=chartHandler.legendsWrapper.getLegend(0);if(!_.isNil(legend)){if(legend.focusFnList){legend.focusFnList.forEach(currentFocusColorFn=>currentFocusColorFn(colorIndex))}if(!_.isNil(legend.items)){legend.items.forEach(function(item,i){if(i!=colorIndex){if(item.elements){item.elements.each(function(){unfocusElement.call(this,item.desaturatedColor)})}}else if(item.elements){item.elements.each(function(elementData){if(focusedElementData){if(focusedElementData.isUnaggregated&&elementData!==focusedElementData){return unfocusElement.call(this,item.desaturatedColor)}return focusElement.call(this,item.color,chartDef.colorOptions.transparency)}return resetElementColor.call(this,item.color)})}})}}})},resetColors:function(){if(resetColorsTimeout){clearTimeout(resetColorsTimeout)}resetColorsTimeout=setTimeout(()=>{const legend=chartHandler.legendsWrapper.getLegend(0);if(!_.isNil(legend)){if(legend.unfocusFnList){legend.unfocusFnList.forEach(currentUnfocusFn=>currentUnfocusFn())}if(!_.isNil(legend.items)){legend.items.forEach(function(item){if(item.elements){item.elements.each(function(){resetElementColor.call(this,item.color)})}})}}},5)},getAnimationContext:function(){return AnimatedChartsUtils.getAnimationContext(chartDef.animationDimension[0],chartHandler.animation)}};return ret}}}})();(function(){"use strict";const ColorPaletteCategory={BUILT_IN:"BUILT_IN",COLOR_BREWER:"COLOR_BREWER",USER_DEFINED:"USER_DEFINED"};const commonDkuColors=["#737373","#999999","#BFBFBF","#D9D9D9","#E6E6E6","#F2F2F2","#FFFFFF","#FFCAD6","#FF868F","#FFB867","#F8E774","#B9D666","#66D6AA","#66DAEB","#668DBB","#9F7EAF","#CB98D3","#FFA6BA","#FF3545","#FF8901","#F4D717","#8ABA00","#00BA71","#00C2DE","#00418D","#5F2879","#A854B6","#CC8595","#CC2A37","#CC6E01","#C3AC12","#6E9500","#00955A","#009BB2","#003471","#4C2061","#864392","#996470","#992029","#995201","#92810E","#537000","#007044","#007485","#002755","#391849","#65326D"];window.dkuColorPalettes={continuous:[{id:"default",name:"DSS Original",colors:["#9999CC","#00003c"],category:ColorPaletteCategory.BUILT_IN},{id:"default_rev",name:"DSS Original (rev)",colors:["#00003c","#9999CC"],category:ColorPaletteCategory.BUILT_IN},{id:"ryg1",name:"Red-green",colors:["#EA1111","#EEEE11","#11CA11"],category:ColorPaletteCategory.BUILT_IN},{id:"gyr1",name:"Green-red",colors:["#11CA11","#EEEE11","#EA1111"],category:ColorPaletteCategory.BUILT_IN},{id:"viridis",name:"Viridis",colors:["#440154","#440256","#450457","#450559","#46075a","#46085c","#460a5d","#460b5e","#470d60","#470e61","#471063","#471164","#471365","#481467","#481668","#481769","#48186a","#481a6c","#481b6d","#481c6e","#481d6f","#481f70","#482071","#482173","#482374","#482475","#482576","#482677","#482878","#482979","#472a7a","#472c7a","#472d7b","#472e7c","#472f7d","#46307e","#46327e","#46337f","#463480","#453581","#453781","#453882","#443983","#443a83","#443b84","#433d84","#433e85","#423f85","#424086","#424186","#414287","#414487","#404588","#404688","#3f4788","#3f4889","#3e4989","#3e4a89","#3e4c8a","#3d4d8a","#3d4e8a","#3c4f8a","#3c508b","#3b518b","#3b528b","#3a538b","#3a548c","#39558c","#39568c","#38588c","#38598c","#375a8c","#375b8d","#365c8d","#365d8d","#355e8d","#355f8d","#34608d","#34618d","#33628d","#33638d","#32648e","#32658e","#31668e","#31678e","#31688e","#30698e","#306a8e","#2f6b8e","#2f6c8e","#2e6d8e","#2e6e8e","#2e6f8e","#2d708e","#2d718e","#2c718e","#2c728e","#2c738e","#2b748e","#2b758e","#2a768e","#2a778e","#2a788e","#29798e","#297a8e","#297b8e","#287c8e","#287d8e","#277e8e","#277f8e","#27808e","#26818e","#26828e","#26828e","#25838e","#25848e","#25858e","#24868e","#24878e","#23888e","#23898e","#238a8d","#228b8d","#228c8d","#228d8d","#218e8d","#218f8d","#21908d","#21918c","#20928c","#20928c","#20938c","#1f948c","#1f958b","#1f968b","#1f978b","#1f988b","#1f998a","#1f9a8a","#1e9b8a","#1e9c89","#1e9d89","#1f9e89","#1f9f88","#1fa088","#1fa188","#1fa187","#1fa287","#20a386","#20a486","#21a585","#21a685","#22a785","#22a884","#23a983","#24aa83","#25ab82","#25ac82","#26ad81","#27ad81","#28ae80","#29af7f","#2ab07f","#2cb17e","#2db27d","#2eb37c","#2fb47c","#31b57b","#32b67a","#34b679","#35b779","#37b878","#38b977","#3aba76","#3bbb75","#3dbc74","#3fbc73","#40bd72","#42be71","#44bf70","#46c06f","#48c16e","#4ac16d","#4cc26c","#4ec36b","#50c46a","#52c569","#54c568","#56c667","#58c765","#5ac864","#5cc863","#5ec962","#60ca60","#63cb5f","#65cb5e","#67cc5c","#69cd5b","#6ccd5a","#6ece58","#70cf57","#73d056","#75d054","#77d153","#7ad151","#7cd250","#7fd34e","#81d34d","#84d44b","#86d549","#89d548","#8bd646","#8ed645","#90d743","#93d741","#95d840","#98d83e","#9bd93c","#9dd93b","#a0da39","#a2da37","#a5db36","#a8db34","#aadc32","#addc30","#b0dd2f","#b2dd2d","#b5de2b","#b8de29","#bade28","#bddf26","#c0df25","#c2df23","#c5e021","#c8e020","#cae11f","#cde11d","#d0e11c","#d2e21b","#d5e21a","#d8e219","#dae319","#dde318","#dfe318","#e2e418","#e5e419","#e7e419","#eae51a","#ece51b","#efe51c","#f1e51d","#f4e61e","#f6e620","#f8e621","#fbe723","#fde725"],category:ColorPaletteCategory.BUILT_IN},{id:"viridis_rev",name:"Viridis (rev)",colors:["#fde725","#fbe723","#f8e621","#f6e620","#f4e61e","#f1e51d","#efe51c","#ece51b","#eae51a","#e7e419","#e5e419","#e2e418","#dfe318","#dde318","#dae319","#d8e219","#d5e21a","#d2e21b","#d0e11c","#cde11d","#cae11f","#c8e020","#c5e021","#c2df23","#c0df25","#bddf26","#bade28","#b8de29","#b5de2b","#b2dd2d","#b0dd2f","#addc30","#aadc32","#a8db34","#a5db36","#a2da37","#a0da39","#9dd93b","#9bd93c","#98d83e","#95d840","#93d741","#90d743","#8ed645","#8bd646","#89d548","#86d549","#84d44b","#81d34d","#7fd34e","#7cd250","#7ad151","#77d153","#75d054","#73d056","#70cf57","#6ece58","#6ccd5a","#69cd5b","#67cc5c","#65cb5e","#63cb5f","#60ca60","#5ec962","#5cc863","#5ac864","#58c765","#56c667","#54c568","#52c569","#50c46a","#4ec36b","#4cc26c","#4ac16d","#48c16e","#46c06f","#44bf70","#42be71","#40bd72","#3fbc73","#3dbc74","#3bbb75","#3aba76","#38b977","#37b878","#35b779","#34b679","#32b67a","#31b57b","#2fb47c","#2eb37c","#2db27d","#2cb17e","#2ab07f","#29af7f","#28ae80","#27ad81","#26ad81","#25ac82","#25ab82","#24aa83","#23a983","#22a884","#22a785","#21a685","#21a585","#20a486","#20a386","#1fa287","#1fa187","#1fa188","#1fa088","#1f9f88","#1f9e89","#1e9d89","#1e9c89","#1e9b8a","#1f9a8a","#1f998a","#1f988b","#1f978b","#1f968b","#1f958b","#1f948c","#20938c","#20928c","#20928c","#21918c","#21908d","#218f8d","#218e8d","#228d8d","#228c8d","#228b8d","#238a8d","#23898e","#23888e","#24878e","#24868e","#25858e","#25848e","#25838e","#26828e","#26828e","#26818e","#27808e","#277f8e","#277e8e","#287d8e","#287c8e","#297b8e","#297a8e","#29798e","#2a788e","#2a778e","#2a768e","#2b758e","#2b748e","#2c738e","#2c728e","#2c718e","#2d718e","#2d708e","#2e6f8e","#2e6e8e","#2e6d8e","#2f6c8e","#2f6b8e","#306a8e","#30698e","#31688e","#31678e","#31668e","#32658e","#32648e","#33638d","#33628d","#34618d","#34608d","#355f8d","#355e8d","#365d8d","#365c8d","#375b8d","#375a8c","#38598c","#38588c","#39568c","#39558c","#3a548c","#3a538b","#3b528b","#3b518b","#3c508b","#3c4f8a","#3d4e8a","#3d4d8a","#3e4c8a","#3e4a89","#3e4989","#3f4889","#3f4788","#404688","#404588","#414487","#414287","#424186","#424086","#423f85","#433e85","#433d84","#443b84","#443a83","#443983","#453882","#453781","#453581","#463480","#46337f","#46327e","#46307e","#472f7d","#472e7c","#472d7b","#472c7a","#472a7a","#482979","#482878","#482677","#482576","#482475","#482374","#482173","#482071","#481f70","#481d6f","#481c6e","#481b6d","#481a6c","#48186a","#481769","#481668","#481467","#471365","#471164","#471063","#470e61","#470d60","#460b5e","#460a5d","#46085c","#46075a","#450559","#450457","#440256","#440154"],category:ColorPaletteCategory.BUILT_IN},{id:"magma",name:"Magma",colors:["#000004","#010005","#010106","#010108","#020109","#02020b","#02020d","#03030f","#030312","#040414","#050416","#060518","#06051a","#07061c","#08071e","#090720","#0a0822","#0b0924","#0c0926","#0d0a29","#0e0b2b","#100b2d","#110c2f","#120d31","#130d34","#140e36","#150e38","#160f3b","#180f3d","#19103f","#1a1042","#1c1044","#1d1147","#1e1149","#20114b","#21114e","#221150","#241253","#251255","#271258","#29115a","#2a115c","#2c115f","#2d1161","#2f1163","#311165","#331067","#341069","#36106b","#38106c","#390f6e","#3b0f70","#3d0f71","#3f0f72","#400f74","#420f75","#440f76","#451077","#471078","#491078","#4a1079","#4c117a","#4e117b","#4f127b","#51127c","#52137c","#54137d","#56147d","#57157e","#59157e","#5a167e","#5c167f","#5d177f","#5f187f","#601880","#621980","#641a80","#651a80","#671b80","#681c81","#6a1c81","#6b1d81","#6d1d81","#6e1e81","#701f81","#721f81","#732081","#752181","#762181","#782281","#792282","#7b2382","#7c2382","#7e2482","#802582","#812581","#832681","#842681","#862781","#882781","#892881","#8b2981","#8c2981","#8e2a81","#902a81","#912b81","#932b80","#942c80","#962c80","#982d80","#992d80","#9b2e7f","#9c2e7f","#9e2f7f","#a02f7f","#a1307e","#a3307e","#a5317e","#a6317d","#a8327d","#aa337d","#ab337c","#ad347c","#ae347b","#b0357b","#b2357b","#b3367a","#b5367a","#b73779","#b83779","#ba3878","#bc3978","#bd3977","#bf3a77","#c03a76","#c23b75","#c43c75","#c53c74","#c73d73","#c83e73","#ca3e72","#cc3f71","#cd4071","#cf4070","#d0416f","#d2426f","#d3436e","#d5446d","#d6456c","#d8456c","#d9466b","#db476a","#dc4869","#de4968","#df4a68","#e04c67","#e24d66","#e34e65","#e44f64","#e55064","#e75263","#e85362","#e95462","#ea5661","#eb5760","#ec5860","#ed5a5f","#ee5b5e","#ef5d5e","#f05f5e","#f1605d","#f2625d","#f2645c","#f3655c","#f4675c","#f4695c","#f56b5c","#f66c5c","#f66e5c","#f7705c","#f7725c","#f8745c","#f8765c","#f9785d","#f9795d","#f97b5d","#fa7d5e","#fa7f5e","#fa815f","#fb835f","#fb8560","#fb8761","#fc8961","#fc8a62","#fc8c63","#fc8e64","#fc9065","#fd9266","#fd9467","#fd9668","#fd9869","#fd9a6a","#fd9b6b","#fe9d6c","#fe9f6d","#fea16e","#fea36f","#fea571","#fea772","#fea973","#feaa74","#feac76","#feae77","#feb078","#feb27a","#feb47b","#feb67c","#feb77e","#feb97f","#febb81","#febd82","#febf84","#fec185","#fec287","#fec488","#fec68a","#fec88c","#feca8d","#fecc8f","#fecd90","#fecf92","#fed194","#fed395","#fed597","#fed799","#fed89a","#fdda9c","#fddc9e","#fddea0","#fde0a1","#fde2a3","#fde3a5","#fde5a7","#fde7a9","#fde9aa","#fdebac","#fcecae","#fceeb0","#fcf0b2","#fcf2b4","#fcf4b6","#fcf6b8","#fcf7b9","#fcf9bb","#fcfbbd","#fcfdbf"],category:ColorPaletteCategory.BUILT_IN},{id:"magma_rev",name:"Magma (rev)",colors:["#fcfdbf","#fcfbbd","#fcf9bb","#fcf7b9","#fcf6b8","#fcf4b6","#fcf2b4","#fcf0b2","#fceeb0","#fcecae","#fdebac","#fde9aa","#fde7a9","#fde5a7","#fde3a5","#fde2a3","#fde0a1","#fddea0","#fddc9e","#fdda9c","#fed89a","#fed799","#fed597","#fed395","#fed194","#fecf92","#fecd90","#fecc8f","#feca8d","#fec88c","#fec68a","#fec488","#fec287","#fec185","#febf84","#febd82","#febb81","#feb97f","#feb77e","#feb67c","#feb47b","#feb27a","#feb078","#feae77","#feac76","#feaa74","#fea973","#fea772","#fea571","#fea36f","#fea16e","#fe9f6d","#fe9d6c","#fd9b6b","#fd9a6a","#fd9869","#fd9668","#fd9467","#fd9266","#fc9065","#fc8e64","#fc8c63","#fc8a62","#fc8961","#fb8761","#fb8560","#fb835f","#fa815f","#fa7f5e","#fa7d5e","#f97b5d","#f9795d","#f9785d","#f8765c","#f8745c","#f7725c","#f7705c","#f66e5c","#f66c5c","#f56b5c","#f4695c","#f4675c","#f3655c","#f2645c","#f2625d","#f1605d","#f05f5e","#ef5d5e","#ee5b5e","#ed5a5f","#ec5860","#eb5760","#ea5661","#e95462","#e85362","#e75263","#e55064","#e44f64","#e34e65","#e24d66","#e04c67","#df4a68","#de4968","#dc4869","#db476a","#d9466b","#d8456c","#d6456c","#d5446d","#d3436e","#d2426f","#d0416f","#cf4070","#cd4071","#cc3f71","#ca3e72","#c83e73","#c73d73","#c53c74","#c43c75","#c23b75","#c03a76","#bf3a77","#bd3977","#bc3978","#ba3878","#b83779","#b73779","#b5367a","#b3367a","#b2357b","#b0357b","#ae347b","#ad347c","#ab337c","#aa337d","#a8327d","#a6317d","#a5317e","#a3307e","#a1307e","#a02f7f","#9e2f7f","#9c2e7f","#9b2e7f","#992d80","#982d80","#962c80","#942c80","#932b80","#912b81","#902a81","#8e2a81","#8c2981","#8b2981","#892881","#882781","#862781","#842681","#832681","#812581","#802582","#7e2482","#7c2382","#7b2382","#792282","#782281","#762181","#752181","#732081","#721f81","#701f81","#6e1e81","#6d1d81","#6b1d81","#6a1c81","#681c81","#671b80","#651a80","#641a80","#621980","#601880","#5f187f","#5d177f","#5c167f","#5a167e","#59157e","#57157e","#56147d","#54137d","#52137c","#51127c","#4f127b","#4e117b","#4c117a","#4a1079","#491078","#471078","#451077","#440f76","#420f75","#400f74","#3f0f72","#3d0f71","#3b0f70","#390f6e","#38106c","#36106b","#341069","#331067","#311165","#2f1163","#2d1161","#2c115f","#2a115c","#29115a","#271258","#251255","#241253","#221150","#21114e","#20114b","#1e1149","#1d1147","#1c1044","#1a1042","#19103f","#180f3d","#160f3b","#150e38","#140e36","#130d34","#120d31","#110c2f","#100b2d","#0e0b2b","#0d0a29","#0c0926","#0b0924","#0a0822","#090720","#08071e","#07061c","#06051a","#060518","#050416","#040414","#030312","#03030f","#02020d","#02020b","#020109","#010108","#010106","#010005","#000004"],category:ColorPaletteCategory.BUILT_IN}],quantile:[{id:"default",name:"Deciles 1",colors:["#3288bd","#66c2a5","#abdda4","#e6f598","#ffffbf","#fee08b","#fdae61","#f46d43","#d53e4f"],category:ColorPaletteCategory.BUILT_IN}],discrete:[{id:"default",name:"DSS Original",colors:d3.scale.category20().range().concat(d3.scale.category20b().range()),category:ColorPaletteCategory.BUILT_IN},{id:"dku_black_and_white",name:"Black and white",hidden:true,colors:["#FFFFFF","#F2F2F2","#E6E6E6","#D9D9D9","#BFBFBF","#999999","#737373","#4D4D4D","#333333","#000000"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_font",name:"Font",hidden:true,colors:["#000000","#333333","#4D4D4D",...commonDkuColors],category:ColorPaletteCategory.BUILT_IN},{id:"dku_text_background",name:"Text background",hidden:true,colors:["#FFFFFF00","#000000","#333333",...commonDkuColors],category:ColorPaletteCategory.BUILT_IN},{id:"dku_dss_next",name:"DSS 2015",colors:["#00AEDB","#8CC63F","#FFC425","#F37735","#D11141","#91268F","#194BA3","#00B159"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_pastel1",name:"Pastel",colors:["#EC6547","#FDC665","#95C37B","#75C2CC","#694A82","#538BC8","#65B890","#A874A0"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_corpo1",name:"Corporate",colors:["#0075B2","#818991","#EA9423","#A4C2DB","#EF3C39","#009D4B","#CFD6D3","#231F20"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_deuteranopia1",name:"Deuteranopia",colors:["#193C81","#7EA0F9","#211924","#757A8D","#D6C222","#776A37","#AE963A","#655E5D"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_tritanopia1",name:"Tritanopia",colors:["#CA0849","#0B4D61","#E4B2BF","#3F6279","#F24576","#7D8E98","#9C4259","#2B2A2E"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_pastel2",name:"Pastel 2",colors:["#f06548","#fdc766","#7bc9a6","#4ec5da","#548ecb","#97668f","#5e2974"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_explore",name:"Explore",hidden:true,colors:["","#000000","#333333",...commonDkuColors],category:ColorPaletteCategory.BUILT_IN},{id:"dku_waterfall_palette",name:"The waterfall palette",hidden:true,colors:["#000000","#333333","#4D4D4D",...commonDkuColors],category:ColorPaletteCategory.BUILT_IN}],diverging:[{id:"dku_red_to_green",name:"Red to green",colors:["#BF2E07","#CF3F30","#D3443A","#E38883","#F3B9B6","#B6EBAD","#99CC6D","#5EAE4E","#179347","#05802F"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_green_to_red",name:"Green to red",colors:["#05802F","#179347","#5EAE4E","#99CC6D","#B6EBAD","#F3B9B6","#E38883","#D3443A","#CF3F30","#BF2E07"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_red_to_blue",name:"Red to blue",colors:["#BF2E07","#CF3F30","#D3443A","#E38883","#F3B9B6","#C7E2F5","#ADCCF0","#7EA6E5","#4472CD","#1E48A2"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_blue_to_red",name:"Blue to red",colors:["#1E48A2","#4472CD","#7EA6E5","#ADCCF0","#C7E2F5","#F3B9B6","#E38883","#D3443A","#CF3F30","#BF2E07"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_purple_to_green",name:"Purple to green",colors:["#682B9A","#8A58B3","#B489D8","#D0B2EB","#DBC3F1","#B6EBAD","#99CC6D","#5EAE4E","#179347","#05802F"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_green_to_purple",name:"Green to purple",colors:["#05802F","#179347","#5EAE4E","#99CC6D","#B6EBAD","#DBC3F1","#D0B2EB","#B489D8","#8A58B3","#682B9A"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_purple_to_blue",name:"Purple to blue",colors:["#682B9A","#8A58B3","#B489D8","#D0B2EB","#DBC3F1","#C7E2F5","#ADCCF0","#7EA6E5","#4472CD","#1E48A2"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_blue_to_purple",name:"Blue to purple",colors:["#1E48A2","#4472CD","#7EA6E5","#ADCCF0","#C7E2F5","#DBC3F1","#D0B2EB","#B489D8","#8A58B3","#682B9A"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_red_orange_green",name:"Red orange green",colors:["#BF2E07","#D14F0B","#E16B0E","#F28811","#EE9615","#CD9A1E","#9E9F2B","#66A63B","#20AF4F","#1E9B50"],category:ColorPaletteCategory.BUILT_IN},{id:"dku_green_orange_red",name:"Green orange red",colors:["#1E9B50","#20AF4F","#66A63B","#9E9F2B","#CD9A1E","#EE9615","#F28811","#E16B0E","#D14F0B","#BF2E07"],category:ColorPaletteCategory.BUILT_IN}],addDiscrete:function(palette){if(window.dkuColorPalettes.discrete.find(p=>p.id===palette.id)){console.warn("Discrete color palette '"+palette.id+"' already exists, it will be overriden.");window.dkuColorPalettes.discrete=window.dkuColorPalettes.discrete.filter(p=>p.id!==palette.id)}window.dkuColorPalettes.discrete.push(palette)},addContinuous:function(palette){if(window.dkuColorPalettes.continuous.find(p=>p.id===palette.id)){console.warn("Continuous color palette '"+palette.id+"' already exists, it will be overriden.");window.dkuColorPalettes.continuous=window.dkuColorPalettes.continuous.filter(p=>p.id!==palette.id)}window.dkuColorPalettes.continuous.push(palette)},addDiverging:function(palette){if(window.dkuColorPalettes.diverging.find(p=>p.id===palette.id)){console.warn("Diverging color palette '"+palette.id+"' already exists, it will be overriden.");window.dkuColorPalettes.diverging=window.dkuColorPalettes.diverging.filter(p=>p.id!==palette.id)}window.dkuColorPalettes.diverging.push(palette)}}})();(function(){"use strict";window.DKUCharts={basicChart:function(width,height,margins){if(margins==null){margins={top:20,right:20,bottom:50,left:50}}const chartWidth=width-margins.left-margins.right;const chartHeight=height-margins.top-margins.bottom;return{width:width-margins.left-margins.right,height:height-margins.top-margins.bottom,xscale:d3.scale.linear().range([0,chartWidth]),yscale:d3.scale.linear().range([chartHeight,0]),makeTopG:function(sel){return sel.style("width",width).style("height",height).append("g").attr("transform","translate("+margins.left+","+margins.top+")")}}},drawGrid:function(g,xscale,yscale,width,height,lastY){const xticks=xscale.ticks();const lastX=xticks[xticks.length-1];const yticks=yscale.ticks();lastY=lastY==null?yticks[yticks.length-1]:lastY;g.append("g").attr("class","vlines").selectAll(".xline").data(xticks).enter().append("line").attr("class","xline").attr("x1",function(d){return xscale(d)}).attr("x2",function(d){return xscale(d)}).attr("y1",height).attr("y2",yscale(lastY)).attr("stroke","#cecece").attr("opacity",.4);g.append("g").attr("class","hlines").selectAll(".hline").data(yticks).enter().append("line").attr("class","hline").attr("y1",function(d){return yscale(d)}).attr("y2",function(d){return yscale(d)}).attr("x1",0).attr("x2",xscale(lastX)).attr("stroke","#cecece").attr("opacity",.4)},nicePrecision:function(val,p){if(val==undefined){return undefined}if(val<Math.pow(10,p)){if(Math.round(val)==val){return val.toFixed(0)}else{return val.toPrecision(p)}}else{return val.toFixed(0)}}}})();
//# sourceMappingURL=chartspack.js.map