(function() {
    'use strict';

    const app = angular.module('dataiku.dashboards.insights');

    app.constant('StaticFileInsightHandler', {
        name: 'Static insight',
        desc: 'Insight generated from code',
        i18nNameKey: 'INSIGHTS.STATIC_FILE.NAME',
        i18nDescKey: 'INSIGHTS.STATIC_FILE.DESC',
        icon: 'icon-file-alt',
        color: '',

        getSourceId: function(insight) {
            return insight.params.objectSmartId;
        },
        getSourceType: function(insight) {
            return insight.params.objectType;
        },
        hasEditTab: false,
        defaultTileParams: {
            numDisplayedComments: 5
        },
        defaultTileDimensions: [15, 9]
    });



    app.controller('StaticFileInsightViewCommon', function($scope, $controller, $sce, DataikuAPI, $stateParams, $timeout) {
        $scope.getLoadingPromise = function() {
            return DataikuAPI.dashboards.insights.viewStaticFile($scope.insight.projectKey, $scope.insight.id);
        };

        $scope.setStaticFileInsightContent = data => {
            $scope.staticFileInsightContent = data;
        };

        $scope.download = function() {
            const insightContentURL = '/dip/api/dashboards/insights/view-static-file?'
            + 'projectKey=' + $scope.insight.projectKey
            + '&insightId=' + $scope.insight.id
            +'&download=true';
            downloadURL(insightContentURL);
        };
    });

    app.directive('staticFileInsightTile', function($controller, $timeout, TileLoadingState, DashboardUtils) {
        return {
            templateUrl: '/templates/dashboards/insights/static_file/tile.html',
            scope: {
                insight: '=',
                tile: '=',
                hook: '='
            },
            link: function($scope, element, attrs) {
                $controller('StaticFileInsightViewCommon', { $scope: $scope });

                $scope.loading = false;
                $scope.loaded = false;
                $scope.error = null;
                $scope.load = function(resolve, reject) {
                    $scope.loading = true;
                    const loadingPromise = $scope.getLoadingPromise().noSpinner();
                    loadingPromise
                        .then(function(resp) {
                            DashboardUtils.setLoaded.bind([$scope, resolve])();
                            $scope.setStaticFileInsightContent(resp.data);
                        }, DashboardUtils.setError.bind([$scope, reject]));
                };
                $scope.hook.loadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.reloadPromises[$scope.tile.$tileId] = $scope.load;

                if ($scope.tile.autoLoad) {
                    $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.WAITING;
                }
            }
        };
    });


    app.directive('staticFileInsightTileParams', function() {
        return {
            templateUrl: '/templates/dashboards/insights/static_file/tile_params.html',
            scope: {
                tileParams: '='
            },
            link: function($scope, element, attrs) {
            // No params
            }
        };
    });

    app.directive('staticFileInsightCreateForm', function() {
        return {
            templateUrl: '/templates/dashboards/insights/static_file/create_form.html',
            scope: true,
            link: function($scope, element, attrs) {
            // Can't create static file insight from new insight modal
            }
        };
    });

    app.directive('staticFileInsightView', function($controller) {
        return {
            templateUrl: '/templates/dashboards/insights/static_file/view.html',
            scope: true,
            link: function($scope, element, attrs) {
                $controller('StaticFileInsightViewCommon', { $scope: $scope });
                const loadingPromise = $scope.getLoadingPromise();
                loadingPromise.then(resp => {
                    $scope.setStaticFileInsightContent(resp.data);
                }, setErrorInScope.bind($scope));
            }
        };
    });

    app.directive('staticFileInsightEdit', function($controller, DataikuAPI, $rootScope) {
        return {
            templateUrl: '/templates/dashboards/insights/static_file/edit.html',
            scope: {
                insight: '='
            },
            link: function($scope, element, attrs) {
                $controller('ChartInsightViewCommon', { $scope: $scope });

                $scope.currentInsight = $scope.insight;

                $scope.bigChart = false;

                $scope.saveChart = function() {
                    DataikuAPI.dashboards.insights.save($scope.insight)
                        .error(setErrorInScope.bind($scope));
                };

                const unregisterChartSamplingChangedEvent = $rootScope.$on('chartSamplingChanged', function() {
                    $scope.summary = null;
                    $scope.fetchColumnsSummary();
                    $scope.saveChart();
                });

                $scope.fetchColumnsSummary();

                $scope.$on('$destroy', () => {
                    unregisterChartSamplingChangedEvent();
                });
            }
        };
    });

})();
