(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):global.CodeMirror=factory()})(this,function(){"use strict";var userAgent=navigator.userAgent;var platform=navigator.platform;var gecko=/gecko\/\d/i.test(userAgent);var ie_upto10=/MSIE \d/.test(userAgent);var ie_11up=/Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(userAgent);var edge=/Edge\/(\d+)/.exec(userAgent);var ie=ie_upto10||ie_11up||edge;var ie_version=ie&&(ie_upto10?document.documentMode||6:+(edge||ie_11up)[1]);var webkit=!edge&&/WebKit\//.test(userAgent);var qtwebkit=webkit&&/Qt\/\d+\.\d+/.test(userAgent);var chrome=!edge&&/Chrome\//.test(userAgent);var presto=/Opera\//.test(userAgent);var safari=/Apple Computer/.test(navigator.vendor);var mac_geMountainLion=/Mac OS X 1\d\D([8-9]|\d\d)\D/.test(userAgent);var phantom=/PhantomJS/.test(userAgent);var ios=!edge&&/AppleWebKit/.test(userAgent)&&/Mobile\/\w+/.test(userAgent);var android=/Android/.test(userAgent);var mobile=ios||android||/webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(userAgent);var mac=ios||/Mac/.test(platform);var chromeOS=/\bCrOS\b/.test(userAgent);var windows=/win/i.test(platform);var presto_version=presto&&userAgent.match(/Version\/(\d*\.\d*)/);if(presto_version){presto_version=Number(presto_version[1])}if(presto_version&&presto_version>=15){presto=false;webkit=true}var flipCtrlCmd=mac&&(qtwebkit||presto&&(presto_version==null||presto_version<12.11));var captureRightClick=gecko||ie&&ie_version>=9;function classTest(cls){return new RegExp("(^|\\s)"+cls+"(?:$|\\s)\\s*")}var rmClass=function(node,cls){var current=node.className;var match=classTest(cls).exec(current);if(match){var after=current.slice(match.index+match[0].length);node.className=current.slice(0,match.index)+(after?match[1]+after:"")}};function removeChildren(e){for(var count=e.childNodes.length;count>0;--count){e.removeChild(e.firstChild)}return e}function removeChildrenAndAdd(parent,e){return removeChildren(parent).appendChild(e)}function elt(tag,content,className,style){var e=document.createElement(tag);if(className){e.className=className}if(style){e.style.cssText=style}if(typeof content=="string"){e.appendChild(document.createTextNode(content))}else if(content){for(var i=0;i<content.length;++i){e.appendChild(content[i])}}return e}function eltP(tag,content,className,style){var e=elt(tag,content,className,style);e.setAttribute("role","presentation");return e}var range;if(document.createRange){range=function(node,start,end,endNode){var r=document.createRange();r.setEnd(endNode||node,end);r.setStart(node,start);return r}}else{range=function(node,start,end){var r=document.body.createTextRange();try{r.moveToElementText(node.parentNode)}catch(e){return r}r.collapse(true);r.moveEnd("character",end);r.moveStart("character",start);return r}}function contains(parent,child){if(child.nodeType==3){child=child.parentNode}if(parent.contains){return parent.contains(child)}do{if(child.nodeType==11){child=child.host}if(child==parent){return true}}while(child=child.parentNode)}function activeElt(){var activeElement;try{activeElement=document.activeElement}catch(e){activeElement=document.body||null}while(activeElement&&activeElement.shadowRoot&&activeElement.shadowRoot.activeElement){activeElement=activeElement.shadowRoot.activeElement}return activeElement}function addClass(node,cls){var current=node.className;if(!classTest(cls).test(current)){node.className+=(current?" ":"")+cls}}function joinClasses(a,b){var as=a.split(" ");for(var i=0;i<as.length;i++){if(as[i]&&!classTest(as[i]).test(b)){b+=" "+as[i]}}return b}var selectInput=function(node){node.select()};if(ios){selectInput=function(node){node.selectionStart=0;node.selectionEnd=node.value.length}}else if(ie){selectInput=function(node){try{node.select()}catch(_e){}}}function bind(f){var args=Array.prototype.slice.call(arguments,1);return function(){return f.apply(null,args)}}function copyObj(obj,target,overwrite){if(!target){target={}}for(var prop in obj){if(obj.hasOwnProperty(prop)&&(overwrite!==false||!target.hasOwnProperty(prop))){target[prop]=obj[prop]}}return target}function countColumn(string,end,tabSize,startIndex,startValue){if(end==null){end=string.search(/[^\s\u00a0]/);if(end==-1){end=string.length}}for(var i=startIndex||0,n=startValue||0;;){var nextTab=string.indexOf("\t",i);if(nextTab<0||nextTab>=end){return n+(end-i)}n+=nextTab-i;n+=tabSize-n%tabSize;i=nextTab+1}}var Delayed=function(){this.id=null};Delayed.prototype.set=function(ms,f){clearTimeout(this.id);this.id=setTimeout(f,ms)};function indexOf(array,elt){for(var i=0;i<array.length;++i){if(array[i]==elt){return i}}return-1}var scrollerGap=30;var Pass={toString:function(){return"CodeMirror.Pass"}};var sel_dontScroll={scroll:false};var sel_mouse={origin:"*mouse"};var sel_move={origin:"+move"};function findColumn(string,goal,tabSize){for(var pos=0,col=0;;){var nextTab=string.indexOf("\t",pos);if(nextTab==-1){nextTab=string.length}var skipped=nextTab-pos;if(nextTab==string.length||col+skipped>=goal){return pos+Math.min(skipped,goal-col)}col+=nextTab-pos;col+=tabSize-col%tabSize;pos=nextTab+1;if(col>=goal){return pos}}}var spaceStrs=[""];function spaceStr(n){while(spaceStrs.length<=n){spaceStrs.push(lst(spaceStrs)+" ")}return spaceStrs[n]}function lst(arr){return arr[arr.length-1]}function map(array,f){var out=[];for(var i=0;i<array.length;i++){out[i]=f(array[i],i)}return out}function insertSorted(array,value,score){var pos=0,priority=score(value);while(pos<array.length&&score(array[pos])<=priority){pos++}array.splice(pos,0,value)}function nothing(){}function createObj(base,props){var inst;if(Object.create){inst=Object.create(base)}else{nothing.prototype=base;inst=new nothing}if(props){copyObj(props,inst)}return inst}var nonASCIISingleCaseWordChar=/[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;function isWordCharBasic(ch){return/\w/.test(ch)||ch>""&&(ch.toUpperCase()!=ch.toLowerCase()||nonASCIISingleCaseWordChar.test(ch))}function isWordChar(ch,helper){if(!helper){return isWordCharBasic(ch)}if(helper.source.indexOf("\\w")>-1&&isWordCharBasic(ch)){return true}return helper.test(ch)}function isEmpty(obj){for(var n in obj){if(obj.hasOwnProperty(n)&&obj[n]){return false}}return true}var extendingChars=/[\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u065e\u0670\u06d6-\u06dc\u06de-\u06e4\u06e7\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0900-\u0902\u093c\u0941-\u0948\u094d\u0951-\u0955\u0962\u0963\u0981\u09bc\u09be\u09c1-\u09c4\u09cd\u09d7\u09e2\u09e3\u0a01\u0a02\u0a3c\u0a41\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a70\u0a71\u0a75\u0a81\u0a82\u0abc\u0ac1-\u0ac5\u0ac7\u0ac8\u0acd\u0ae2\u0ae3\u0b01\u0b3c\u0b3e\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b57\u0b62\u0b63\u0b82\u0bbe\u0bc0\u0bcd\u0bd7\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0cbc\u0cbf\u0cc2\u0cc6\u0ccc\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0d3e\u0d41-\u0d44\u0d4d\u0d57\u0d62\u0d63\u0dca\u0dcf\u0dd2-\u0dd4\u0dd6\u0ddf\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0f18\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86\u0f87\u0f90-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039\u103a\u103d\u103e\u1058\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085\u1086\u108d\u109d\u135f\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193b\u1a17\u1a18\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80\u1b81\u1ba2-\u1ba5\u1ba8\u1ba9\u1c2c-\u1c33\u1c36\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1dc0-\u1de6\u1dfd-\u1dff\u200c\u200d\u20d0-\u20f0\u2cef-\u2cf1\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua66f-\ua672\ua67c\ua67d\ua6f0\ua6f1\ua802\ua806\ua80b\ua825\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\uaa29-\uaa2e\uaa31\uaa32\uaa35\uaa36\uaa43\uaa4c\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uabe5\uabe8\uabed\udc00-\udfff\ufb1e\ufe00-\ufe0f\ufe20-\ufe26\uff9e\uff9f]/;function isExtendingChar(ch){return ch.charCodeAt(0)>=768&&extendingChars.test(ch)}function skipExtendingChars(str,pos,dir){while((dir<0?pos>0:pos<str.length)&&isExtendingChar(str.charAt(pos))){pos+=dir}return pos}function findFirst(pred,from,to){for(;;){if(Math.abs(from-to)<=1){return pred(from)?from:to}var mid=Math.floor((from+to)/2);if(pred(mid)){to=mid}else{from=mid}}}function Display(place,doc,input){var d=this;this.input=input;d.scrollbarFiller=elt("div",null,"CodeMirror-scrollbar-filler");d.scrollbarFiller.setAttribute("cm-not-content","true");d.gutterFiller=elt("div",null,"CodeMirror-gutter-filler");d.gutterFiller.setAttribute("cm-not-content","true");d.lineDiv=eltP("div",null,"CodeMirror-code");d.selectionDiv=elt("div",null,null,"position: relative; z-index: 1");d.cursorDiv=elt("div",null,"CodeMirror-cursors");d.measure=elt("div",null,"CodeMirror-measure");d.lineMeasure=elt("div",null,"CodeMirror-measure");d.lineSpace=eltP("div",[d.measure,d.lineMeasure,d.selectionDiv,d.cursorDiv,d.lineDiv],null,"position: relative; outline: none");var lines=eltP("div",[d.lineSpace],"CodeMirror-lines");d.mover=elt("div",[lines],null,"position: relative");d.sizer=elt("div",[d.mover],"CodeMirror-sizer");d.sizerWidth=null;d.heightForcer=elt("div",null,null,"position: absolute; height: "+scrollerGap+"px; width: 1px;");d.gutters=elt("div",null,"CodeMirror-gutters");d.lineGutter=null;d.scroller=elt("div",[d.sizer,d.heightForcer,d.gutters],"CodeMirror-scroll");d.scroller.setAttribute("tabIndex","-1");d.wrapper=elt("div",[d.scrollbarFiller,d.gutterFiller,d.scroller],"CodeMirror");if(ie&&ie_version<8){d.gutters.style.zIndex=-1;d.scroller.style.paddingRight=0}if(!webkit&&!(gecko&&mobile)){d.scroller.draggable=true}if(place){if(place.appendChild){place.appendChild(d.wrapper)}else{place(d.wrapper)}}d.viewFrom=d.viewTo=doc.first;d.reportedViewFrom=d.reportedViewTo=doc.first;d.view=[];d.renderedView=null;d.externalMeasured=null;d.viewOffset=0;d.lastWrapHeight=d.lastWrapWidth=0;d.updateLineNumbers=null;d.nativeBarWidth=d.barHeight=d.barWidth=0;d.scrollbarsClipped=false;d.lineNumWidth=d.lineNumInnerWidth=d.lineNumChars=null;d.alignWidgets=false;d.cachedCharWidth=d.cachedTextHeight=d.cachedPaddingH=null;d.maxLine=null;d.maxLineLength=0;d.maxLineChanged=false;d.wheelDX=d.wheelDY=d.wheelStartX=d.wheelStartY=null;d.shift=false;d.selForContextMenu=null;d.activeTouch=null;input.init(d)}function getLine(doc,n){n-=doc.first;if(n<0||n>=doc.size){throw new Error("There is no line "+(n+doc.first)+" in the document.")}var chunk=doc;while(!chunk.lines){for(var i=0;;++i){var child=chunk.children[i],sz=child.chunkSize();if(n<sz){chunk=child;break}n-=sz}}return chunk.lines[n]}function getBetween(doc,start,end){var out=[],n=start.line;doc.iter(start.line,end.line+1,function(line){var text=line.text;if(n==end.line){text=text.slice(0,end.ch)}if(n==start.line){text=text.slice(start.ch)}out.push(text);++n});return out}function getLines(doc,from,to){var out=[];doc.iter(from,to,function(line){out.push(line.text)});return out}function updateLineHeight(line,height){var diff=height-line.height;if(diff){for(var n=line;n;n=n.parent){n.height+=diff}}}function lineNo(line){if(line.parent==null){return null}var cur=line.parent,no=indexOf(cur.lines,line);for(var chunk=cur.parent;chunk;cur=chunk,chunk=chunk.parent){for(var i=0;;++i){if(chunk.children[i]==cur){break}no+=chunk.children[i].chunkSize()}}return no+cur.first}function lineAtHeight(chunk,h){var n=chunk.first;outer:do{for(var i$1=0;i$1<chunk.children.length;++i$1){var child=chunk.children[i$1],ch=child.height;if(h<ch){chunk=child;continue outer}h-=ch;n+=child.chunkSize()}return n}while(!chunk.lines);var i=0;for(;i<chunk.lines.length;++i){var line=chunk.lines[i],lh=line.height;if(h<lh){break}h-=lh}return n+i}function isLine(doc,l){return l>=doc.first&&l<doc.first+doc.size}function lineNumberFor(options,i){return String(options.lineNumberFormatter(i+options.firstLineNumber))}function Pos(line,ch,sticky){if(sticky===void 0)sticky=null;if(!(this instanceof Pos)){return new Pos(line,ch,sticky)}this.line=line;this.ch=ch;this.sticky=sticky}function cmp(a,b){return a.line-b.line||a.ch-b.ch}function equalCursorPos(a,b){return a.sticky==b.sticky&&cmp(a,b)==0}function copyPos(x){return Pos(x.line,x.ch)}function maxPos(a,b){return cmp(a,b)<0?b:a}function minPos(a,b){return cmp(a,b)<0?a:b}function clipLine(doc,n){return Math.max(doc.first,Math.min(n,doc.first+doc.size-1))}function clipPos(doc,pos){if(pos.line<doc.first){return Pos(doc.first,0)}var last=doc.first+doc.size-1;if(pos.line>last){return Pos(last,getLine(doc,last).text.length)}return clipToLen(pos,getLine(doc,pos.line).text.length)}function clipToLen(pos,linelen){var ch=pos.ch;if(ch==null||ch>linelen){return Pos(pos.line,linelen)}else if(ch<0){return Pos(pos.line,0)}else{return pos}}function clipPosArray(doc,array){var out=[];for(var i=0;i<array.length;i++){out[i]=clipPos(doc,array[i])}return out}var sawReadOnlySpans=false;var sawCollapsedSpans=false;function seeReadOnlySpans(){sawReadOnlySpans=true}function seeCollapsedSpans(){sawCollapsedSpans=true}function MarkedSpan(marker,from,to){this.marker=marker;this.from=from;this.to=to}function getMarkedSpanFor(spans,marker){if(spans){for(var i=0;i<spans.length;++i){var span=spans[i];if(span.marker==marker){return span}}}}function removeMarkedSpan(spans,span){var r;for(var i=0;i<spans.length;++i){if(spans[i]!=span){(r||(r=[])).push(spans[i])}}return r}function addMarkedSpan(line,span){line.markedSpans=line.markedSpans?line.markedSpans.concat([span]):[span];span.marker.attachLine(line)}function markedSpansBefore(old,startCh,isInsert){var nw;if(old){for(var i=0;i<old.length;++i){var span=old[i],marker=span.marker;var startsBefore=span.from==null||(marker.inclusiveLeft?span.from<=startCh:span.from<startCh);if(startsBefore||span.from==startCh&&marker.type=="bookmark"&&(!isInsert||!span.marker.insertLeft)){var endsAfter=span.to==null||(marker.inclusiveRight?span.to>=startCh:span.to>startCh);(nw||(nw=[])).push(new MarkedSpan(marker,span.from,endsAfter?null:span.to))}}}return nw}function markedSpansAfter(old,endCh,isInsert){var nw;if(old){for(var i=0;i<old.length;++i){var span=old[i],marker=span.marker;var endsAfter=span.to==null||(marker.inclusiveRight?span.to>=endCh:span.to>endCh);if(endsAfter||span.from==endCh&&marker.type=="bookmark"&&(!isInsert||span.marker.insertLeft)){var startsBefore=span.from==null||(marker.inclusiveLeft?span.from<=endCh:span.from<endCh);(nw||(nw=[])).push(new MarkedSpan(marker,startsBefore?null:span.from-endCh,span.to==null?null:span.to-endCh))}}}return nw}function stretchSpansOverChange(doc,change){if(change.full){return null}var oldFirst=isLine(doc,change.from.line)&&getLine(doc,change.from.line).markedSpans;var oldLast=isLine(doc,change.to.line)&&getLine(doc,change.to.line).markedSpans;if(!oldFirst&&!oldLast){return null}var startCh=change.from.ch,endCh=change.to.ch,isInsert=cmp(change.from,change.to)==0;var first=markedSpansBefore(oldFirst,startCh,isInsert);var last=markedSpansAfter(oldLast,endCh,isInsert);var sameLine=change.text.length==1,offset=lst(change.text).length+(sameLine?startCh:0);if(first){for(var i=0;i<first.length;++i){var span=first[i];if(span.to==null){var found=getMarkedSpanFor(last,span.marker);if(!found){span.to=startCh}else if(sameLine){span.to=found.to==null?null:found.to+offset}}}}if(last){for(var i$1=0;i$1<last.length;++i$1){var span$1=last[i$1];if(span$1.to!=null){span$1.to+=offset}if(span$1.from==null){var found$1=getMarkedSpanFor(first,span$1.marker);if(!found$1){span$1.from=offset;if(sameLine){(first||(first=[])).push(span$1)}}}else{span$1.from+=offset;if(sameLine){(first||(first=[])).push(span$1)}}}}if(first){first=clearEmptySpans(first)}if(last&&last!=first){last=clearEmptySpans(last)}var newMarkers=[first];if(!sameLine){var gap=change.text.length-2,gapMarkers;if(gap>0&&first){for(var i$2=0;i$2<first.length;++i$2){if(first[i$2].to==null){(gapMarkers||(gapMarkers=[])).push(new MarkedSpan(first[i$2].marker,null,null))}}}for(var i$3=0;i$3<gap;++i$3){newMarkers.push(gapMarkers)}newMarkers.push(last)}return newMarkers}function clearEmptySpans(spans){for(var i=0;i<spans.length;++i){var span=spans[i];if(span.from!=null&&span.from==span.to&&span.marker.clearWhenEmpty!==false){spans.splice(i--,1)}}if(!spans.length){return null}return spans}function removeReadOnlyRanges(doc,from,to){var markers=null;doc.iter(from.line,to.line+1,function(line){if(line.markedSpans){for(var i=0;i<line.markedSpans.length;++i){var mark=line.markedSpans[i].marker;if(mark.readOnly&&(!markers||indexOf(markers,mark)==-1)){(markers||(markers=[])).push(mark)}}}});if(!markers){return null}var parts=[{from:from,to:to}];for(var i=0;i<markers.length;++i){var mk=markers[i],m=mk.find(0);for(var j=0;j<parts.length;++j){var p=parts[j];if(cmp(p.to,m.from)<0||cmp(p.from,m.to)>0){continue}var newParts=[j,1],dfrom=cmp(p.from,m.from),dto=cmp(p.to,m.to);if(dfrom<0||!mk.inclusiveLeft&&!dfrom){newParts.push({from:p.from,to:m.from})}if(dto>0||!mk.inclusiveRight&&!dto){newParts.push({from:m.to,to:p.to})}parts.splice.apply(parts,newParts);j+=newParts.length-3}}return parts}function detachMarkedSpans(line){var spans=line.markedSpans;if(!spans){return}for(var i=0;i<spans.length;++i){spans[i].marker.detachLine(line)}line.markedSpans=null}function attachMarkedSpans(line,spans){if(!spans){return}for(var i=0;i<spans.length;++i){spans[i].marker.attachLine(line)}line.markedSpans=spans}function extraLeft(marker){return marker.inclusiveLeft?-1:0}function extraRight(marker){return marker.inclusiveRight?1:0}function compareCollapsedMarkers(a,b){var lenDiff=a.lines.length-b.lines.length;if(lenDiff!=0){return lenDiff}var aPos=a.find(),bPos=b.find();var fromCmp=cmp(aPos.from,bPos.from)||extraLeft(a)-extraLeft(b);if(fromCmp){return-fromCmp}var toCmp=cmp(aPos.to,bPos.to)||extraRight(a)-extraRight(b);if(toCmp){return toCmp}return b.id-a.id}function collapsedSpanAtSide(line,start){var sps=sawCollapsedSpans&&line.markedSpans,found;if(sps){for(var sp=void 0,i=0;i<sps.length;++i){sp=sps[i];if(sp.marker.collapsed&&(start?sp.from:sp.to)==null&&(!found||compareCollapsedMarkers(found,sp.marker)<0)){found=sp.marker}}}return found}function collapsedSpanAtStart(line){return collapsedSpanAtSide(line,true)}function collapsedSpanAtEnd(line){return collapsedSpanAtSide(line,false)}function conflictingCollapsedRange(doc,lineNo$$1,from,to,marker){var line=getLine(doc,lineNo$$1);var sps=sawCollapsedSpans&&line.markedSpans;if(sps){for(var i=0;i<sps.length;++i){var sp=sps[i];if(!sp.marker.collapsed){continue}var found=sp.marker.find(0);var fromCmp=cmp(found.from,from)||extraLeft(sp.marker)-extraLeft(marker);var toCmp=cmp(found.to,to)||extraRight(sp.marker)-extraRight(marker);if(fromCmp>=0&&toCmp<=0||fromCmp<=0&&toCmp>=0){continue}if(fromCmp<=0&&(sp.marker.inclusiveRight&&marker.inclusiveLeft?cmp(found.to,from)>=0:cmp(found.to,from)>0)||fromCmp>=0&&(sp.marker.inclusiveRight&&marker.inclusiveLeft?cmp(found.from,to)<=0:cmp(found.from,to)<0)){return true}}}}function visualLine(line){var merged;while(merged=collapsedSpanAtStart(line)){line=merged.find(-1,true).line}return line}function visualLineEnd(line){var merged;while(merged=collapsedSpanAtEnd(line)){line=merged.find(1,true).line}return line}function visualLineContinued(line){var merged,lines;while(merged=collapsedSpanAtEnd(line)){line=merged.find(1,true).line;(lines||(lines=[])).push(line)}return lines}function visualLineNo(doc,lineN){var line=getLine(doc,lineN),vis=visualLine(line);if(line==vis){return lineN}return lineNo(vis)}function visualLineEndNo(doc,lineN){if(lineN>doc.lastLine()){return lineN}var line=getLine(doc,lineN),merged;if(!lineIsHidden(doc,line)){return lineN}while(merged=collapsedSpanAtEnd(line)){line=merged.find(1,true).line}return lineNo(line)+1}function lineIsHidden(doc,line){var sps=sawCollapsedSpans&&line.markedSpans;if(sps){for(var sp=void 0,i=0;i<sps.length;++i){sp=sps[i];if(!sp.marker.collapsed){continue}if(sp.from==null){return true}if(sp.marker.widgetNode){continue}if(sp.from==0&&sp.marker.inclusiveLeft&&lineIsHiddenInner(doc,line,sp)){return true}}}}function lineIsHiddenInner(doc,line,span){if(span.to==null){var end=span.marker.find(1,true);return lineIsHiddenInner(doc,end.line,getMarkedSpanFor(end.line.markedSpans,span.marker))}if(span.marker.inclusiveRight&&span.to==line.text.length){return true}for(var sp=void 0,i=0;i<line.markedSpans.length;++i){sp=line.markedSpans[i];if(sp.marker.collapsed&&!sp.marker.widgetNode&&sp.from==span.to&&(sp.to==null||sp.to!=span.from)&&(sp.marker.inclusiveLeft||span.marker.inclusiveRight)&&lineIsHiddenInner(doc,line,sp)){return true}}}function heightAtLine(lineObj){lineObj=visualLine(lineObj);var h=0,chunk=lineObj.parent;for(var i=0;i<chunk.lines.length;++i){var line=chunk.lines[i];if(line==lineObj){break}else{h+=line.height}}for(var p=chunk.parent;p;chunk=p,p=chunk.parent){for(var i$1=0;i$1<p.children.length;++i$1){var cur=p.children[i$1];if(cur==chunk){break}else{h+=cur.height}}}return h}function lineLength(line){if(line.height==0){return 0}var len=line.text.length,merged,cur=line;while(merged=collapsedSpanAtStart(cur)){var found=merged.find(0,true);cur=found.from.line;len+=found.from.ch-found.to.ch}cur=line;while(merged=collapsedSpanAtEnd(cur)){var found$1=merged.find(0,true);len-=cur.text.length-found$1.from.ch;cur=found$1.to.line;len+=cur.text.length-found$1.to.ch}return len}function findMaxLine(cm){var d=cm.display,doc=cm.doc;d.maxLine=getLine(doc,doc.first);d.maxLineLength=lineLength(d.maxLine);d.maxLineChanged=true;doc.iter(function(line){var len=lineLength(line);if(len>d.maxLineLength){d.maxLineLength=len;d.maxLine=line}})}function iterateBidiSections(order,from,to,f){if(!order){return f(from,to,"ltr")}var found=false;for(var i=0;i<order.length;++i){var part=order[i];if(part.from<to&&part.to>from||from==to&&part.to==from){f(Math.max(part.from,from),Math.min(part.to,to),part.level==1?"rtl":"ltr");found=true}}if(!found){f(from,to,"ltr")}}var bidiOther=null;function getBidiPartAt(order,ch,sticky){var found;bidiOther=null;for(var i=0;i<order.length;++i){var cur=order[i];if(cur.from<ch&&cur.to>ch){return i}if(cur.to==ch){if(cur.from!=cur.to&&sticky=="before"){found=i}else{bidiOther=i}}if(cur.from==ch){if(cur.from!=cur.to&&sticky!="before"){found=i}else{bidiOther=i}}}return found!=null?found:bidiOther}var bidiOrdering=function(){var lowTypes="bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN";var arabicTypes="nnnnnnNNr%%r,rNNmmmmmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmmmnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmnNmmmmmmrrmmNmmmmrr1111111111";function charType(code){if(code<=247){return lowTypes.charAt(code)}else if(1424<=code&&code<=1524){return"R"}else if(1536<=code&&code<=1785){return arabicTypes.charAt(code-1536)}else if(1774<=code&&code<=2220){return"r"}else if(8192<=code&&code<=8203){return"w"}else if(code==8204){return"b"}else{return"L"}}var bidiRE=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/;var isNeutral=/[stwN]/,isStrong=/[LRr]/,countsAsLeft=/[Lb1n]/,countsAsNum=/[1n]/;function BidiSpan(level,from,to){this.level=level;this.from=from;this.to=to}return function(str,direction){var outerType=direction=="ltr"?"L":"R";if(str.length==0||direction=="ltr"&&!bidiRE.test(str)){return false}var len=str.length,types=[];for(var i=0;i<len;++i){types.push(charType(str.charCodeAt(i)))}for(var i$1=0,prev=outerType;i$1<len;++i$1){var type=types[i$1];if(type=="m"){types[i$1]=prev}else{prev=type}}for(var i$2=0,cur=outerType;i$2<len;++i$2){var type$1=types[i$2];if(type$1=="1"&&cur=="r"){types[i$2]="n"}else if(isStrong.test(type$1)){cur=type$1;if(type$1=="r"){types[i$2]="R"}}}for(var i$3=1,prev$1=types[0];i$3<len-1;++i$3){var type$2=types[i$3];if(type$2=="+"&&prev$1=="1"&&types[i$3+1]=="1"){types[i$3]="1"}else if(type$2==","&&prev$1==types[i$3+1]&&(prev$1=="1"||prev$1=="n")){types[i$3]=prev$1}prev$1=type$2}for(var i$4=0;i$4<len;++i$4){var type$3=types[i$4];if(type$3==","){types[i$4]="N"}else if(type$3=="%"){var end=void 0;for(end=i$4+1;end<len&&types[end]=="%";++end){}var replace=i$4&&types[i$4-1]=="!"||end<len&&types[end]=="1"?"1":"N";for(var j=i$4;j<end;++j){types[j]=replace}i$4=end-1}}for(var i$5=0,cur$1=outerType;i$5<len;++i$5){var type$4=types[i$5];if(cur$1=="L"&&type$4=="1"){types[i$5]="L"}else if(isStrong.test(type$4)){cur$1=type$4}}for(var i$6=0;i$6<len;++i$6){if(isNeutral.test(types[i$6])){var end$1=void 0;for(end$1=i$6+1;end$1<len&&isNeutral.test(types[end$1]);++end$1){}var before=(i$6?types[i$6-1]:outerType)=="L";var after=(end$1<len?types[end$1]:outerType)=="L";var replace$1=before==after?before?"L":"R":outerType;for(var j$1=i$6;j$1<end$1;++j$1){types[j$1]=replace$1}i$6=end$1-1}}var order=[],m;for(var i$7=0;i$7<len;){if(countsAsLeft.test(types[i$7])){var start=i$7;for(++i$7;i$7<len&&countsAsLeft.test(types[i$7]);++i$7){}order.push(new BidiSpan(0,start,i$7))}else{var pos=i$7,at=order.length;for(++i$7;i$7<len&&types[i$7]!="L";++i$7){}for(var j$2=pos;j$2<i$7;){if(countsAsNum.test(types[j$2])){if(pos<j$2){order.splice(at,0,new BidiSpan(1,pos,j$2))}var nstart=j$2;for(++j$2;j$2<i$7&&countsAsNum.test(types[j$2]);++j$2){}order.splice(at,0,new BidiSpan(2,nstart,j$2));pos=j$2}else{++j$2}}if(pos<i$7){order.splice(at,0,new BidiSpan(1,pos,i$7))}}}if(order[0].level==1&&(m=str.match(/^\s+/))){order[0].from=m[0].length;order.unshift(new BidiSpan(0,0,m[0].length))}if(lst(order).level==1&&(m=str.match(/\s+$/))){lst(order).to-=m[0].length;order.push(new BidiSpan(0,len-m[0].length,len))}return direction=="rtl"?order.reverse():order}}();function getOrder(line,direction){var order=line.order;if(order==null){order=line.order=bidiOrdering(line.text,direction)}return order}function moveCharLogically(line,ch,dir){var target=skipExtendingChars(line.text,ch+dir,dir);return target<0||target>line.text.length?null:target}function moveLogically(line,start,dir){var ch=moveCharLogically(line,start.ch,dir);return ch==null?null:new Pos(start.line,ch,dir<0?"after":"before")}function endOfLine(visually,cm,lineObj,lineNo,dir){if(visually){var order=getOrder(lineObj,cm.doc.direction);if(order){var part=dir<0?lst(order):order[0];var moveInStorageOrder=dir<0==(part.level==1);var sticky=moveInStorageOrder?"after":"before";var ch;if(part.level>0){var prep=prepareMeasureForLine(cm,lineObj);ch=dir<0?lineObj.text.length-1:0;var targetTop=measureCharPrepared(cm,prep,ch).top;ch=findFirst(function(ch){return measureCharPrepared(cm,prep,ch).top==targetTop},dir<0==(part.level==1)?part.from:part.to-1,ch);if(sticky=="before"){ch=moveCharLogically(lineObj,ch,1)}}else{ch=dir<0?part.to:part.from}return new Pos(lineNo,ch,sticky)}}return new Pos(lineNo,dir<0?lineObj.text.length:0,dir<0?"before":"after")}function moveVisually(cm,line,start,dir){var bidi=getOrder(line,cm.doc.direction);if(!bidi){return moveLogically(line,start,dir)}if(start.ch>=line.text.length){start.ch=line.text.length;start.sticky="before"}else if(start.ch<=0){start.ch=0;start.sticky="after"}var partPos=getBidiPartAt(bidi,start.ch,start.sticky),part=bidi[partPos];if(cm.doc.direction=="ltr"&&part.level%2==0&&(dir>0?part.to>start.ch:part.from<start.ch)){return moveLogically(line,start,dir)}var mv=function(pos,dir){return moveCharLogically(line,pos instanceof Pos?pos.ch:pos,dir)};var prep;var getWrappedLineExtent=function(ch){if(!cm.options.lineWrapping){return{begin:0,end:line.text.length}}prep=prep||prepareMeasureForLine(cm,line);return wrappedLineExtentChar(cm,line,prep,ch)};var wrappedLineExtent=getWrappedLineExtent(start.sticky=="before"?mv(start,-1):start.ch);if(cm.doc.direction=="rtl"||part.level==1){var moveInStorageOrder=part.level==1==dir<0;var ch=mv(start,moveInStorageOrder?1:-1);if(ch!=null&&(!moveInStorageOrder?ch>=part.from&&ch>=wrappedLineExtent.begin:ch<=part.to&&ch<=wrappedLineExtent.end)){var sticky=moveInStorageOrder?"before":"after";return new Pos(start.line,ch,sticky)}}var searchInVisualLine=function(partPos,dir,wrappedLineExtent){var getRes=function(ch,moveInStorageOrder){return moveInStorageOrder?new Pos(start.line,mv(ch,1),"before"):new Pos(start.line,ch,"after")};for(;partPos>=0&&partPos<bidi.length;partPos+=dir){var part=bidi[partPos];var moveInStorageOrder=dir>0==(part.level!=1);var ch=moveInStorageOrder?wrappedLineExtent.begin:mv(wrappedLineExtent.end,-1);if(part.from<=ch&&ch<part.to){return getRes(ch,moveInStorageOrder)}ch=moveInStorageOrder?part.from:mv(part.to,-1);if(wrappedLineExtent.begin<=ch&&ch<wrappedLineExtent.end){return getRes(ch,moveInStorageOrder)}}};var res=searchInVisualLine(partPos+dir,dir,wrappedLineExtent);if(res){return res}var nextCh=dir>0?wrappedLineExtent.end:mv(wrappedLineExtent.begin,-1);if(nextCh!=null&&!(dir>0&&nextCh==line.text.length)){res=searchInVisualLine(dir>0?0:bidi.length-1,dir,getWrappedLineExtent(nextCh));if(res){return res}}return null}var noHandlers=[];var on=function(emitter,type,f){if(emitter.addEventListener){emitter.addEventListener(type,f,false)}else if(emitter.attachEvent){emitter.attachEvent("on"+type,f)}else{var map$$1=emitter._handlers||(emitter._handlers={});map$$1[type]=(map$$1[type]||noHandlers).concat(f)}};function getHandlers(emitter,type){return emitter._handlers&&emitter._handlers[type]||noHandlers}function off(emitter,type,f){if(emitter.removeEventListener){emitter.removeEventListener(type,f,false)}else if(emitter.detachEvent){emitter.detachEvent("on"+type,f)}else{var map$$1=emitter._handlers,arr=map$$1&&map$$1[type];if(arr){var index=indexOf(arr,f);if(index>-1){map$$1[type]=arr.slice(0,index).concat(arr.slice(index+1))}}}}function signal(emitter,type){var handlers=getHandlers(emitter,type);if(!handlers.length){return}var args=Array.prototype.slice.call(arguments,2);for(var i=0;i<handlers.length;++i){handlers[i].apply(null,args)}}function signalDOMEvent(cm,e,override){if(typeof e=="string"){e={type:e,preventDefault:function(){this.defaultPrevented=true}}}signal(cm,override||e.type,cm,e);return e_defaultPrevented(e)||e.codemirrorIgnore}function signalCursorActivity(cm){var arr=cm._handlers&&cm._handlers.cursorActivity;if(!arr){return}var set=cm.curOp.cursorActivityHandlers||(cm.curOp.cursorActivityHandlers=[]);for(var i=0;i<arr.length;++i){if(indexOf(set,arr[i])==-1){set.push(arr[i])}}}function hasHandler(emitter,type){return getHandlers(emitter,type).length>0}function eventMixin(ctor){ctor.prototype.on=function(type,f){on(this,type,f)};ctor.prototype.off=function(type,f){off(this,type,f)}}function e_preventDefault(e){if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}function e_stopPropagation(e){if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}}function e_defaultPrevented(e){return e.defaultPrevented!=null?e.defaultPrevented:e.returnValue==false}function e_stop(e){e_preventDefault(e);e_stopPropagation(e)}function e_target(e){return e.target||e.srcElement}function e_button(e){var b=e.which;if(b==null){if(e.button&1){b=1}else if(e.button&2){b=3}else if(e.button&4){b=2}}if(mac&&e.ctrlKey&&b==1){b=3}return b}var dragAndDrop=function(){if(ie&&ie_version<9){return false}var div=elt("div");return"draggable"in div||"dragDrop"in div}();var zwspSupported;function zeroWidthElement(measure){if(zwspSupported==null){var test=elt("span","​");removeChildrenAndAdd(measure,elt("span",[test,document.createTextNode("x")]));if(measure.firstChild.offsetHeight!=0){zwspSupported=test.offsetWidth<=1&&test.offsetHeight>2&&!(ie&&ie_version<8)}}var node=zwspSupported?elt("span","​"):elt("span"," ",null,"display: inline-block; width: 1px; margin-right: -1px");node.setAttribute("cm-text","");return node}var badBidiRects;function hasBadBidiRects(measure){if(badBidiRects!=null){return badBidiRects}var txt=removeChildrenAndAdd(measure,document.createTextNode("AخA"));var r0=range(txt,0,1).getBoundingClientRect();var r1=range(txt,1,2).getBoundingClientRect();removeChildren(measure);if(!r0||r0.left==r0.right){return false}return badBidiRects=r1.right-r0.right<3}var splitLinesAuto="\n\nb".split(/\n/).length!=3?function(string){var pos=0,result=[],l=string.length;while(pos<=l){var nl=string.indexOf("\n",pos);if(nl==-1){nl=string.length}var line=string.slice(pos,string.charAt(nl-1)=="\r"?nl-1:nl);var rt=line.indexOf("\r");if(rt!=-1){result.push(line.slice(0,rt));pos+=rt+1}else{result.push(line);pos=nl+1}}return result}:function(string){return string.split(/\r\n?|\n/)};var hasSelection=window.getSelection?function(te){try{return te.selectionStart!=te.selectionEnd}catch(e){return false}}:function(te){var range$$1;try{range$$1=te.ownerDocument.selection.createRange()}catch(e){}if(!range$$1||range$$1.parentElement()!=te){return false}return range$$1.compareEndPoints("StartToEnd",range$$1)!=0};var hasCopyEvent=function(){var e=elt("div");if("oncopy"in e){return true}e.setAttribute("oncopy","return;");return typeof e.oncopy=="function"}();var badZoomedRects=null;function hasBadZoomedRects(measure){if(badZoomedRects!=null){return badZoomedRects}var node=removeChildrenAndAdd(measure,elt("span","x"));var normal=node.getBoundingClientRect();var fromRange=range(node,0,1).getBoundingClientRect();return badZoomedRects=Math.abs(normal.left-fromRange.left)>1}var modes={};var mimeModes={};function defineMode(name,mode){if(arguments.length>2){mode.dependencies=Array.prototype.slice.call(arguments,2)}modes[name]=mode}function defineMIME(mime,spec){mimeModes[mime]=spec}function resolveMode(spec){if(typeof spec=="string"&&mimeModes.hasOwnProperty(spec)){spec=mimeModes[spec]}else if(spec&&typeof spec.name=="string"&&mimeModes.hasOwnProperty(spec.name)){var found=mimeModes[spec.name];if(typeof found=="string"){found={name:found}}spec=createObj(found,spec);spec.name=found.name}else if(typeof spec=="string"&&/^[\w\-]+\/[\w\-]+\+xml$/.test(spec)){return resolveMode("application/xml")}else if(typeof spec=="string"&&/^[\w\-]+\/[\w\-]+\+json$/.test(spec)){return resolveMode("application/json")}if(typeof spec=="string"){return{name:spec}}else{return spec||{name:"null"}}}function getMode(options,spec){spec=resolveMode(spec);var mfactory=modes[spec.name];if(!mfactory){return getMode(options,"text/plain")}var modeObj=mfactory(options,spec);if(modeExtensions.hasOwnProperty(spec.name)){var exts=modeExtensions[spec.name];for(var prop in exts){if(!exts.hasOwnProperty(prop)){continue}if(modeObj.hasOwnProperty(prop)){modeObj["_"+prop]=modeObj[prop]}modeObj[prop]=exts[prop]}}modeObj.name=spec.name;if(spec.helperType){modeObj.helperType=spec.helperType}if(spec.modeProps){for(var prop$1 in spec.modeProps){modeObj[prop$1]=spec.modeProps[prop$1]}}return modeObj}var modeExtensions={};function extendMode(mode,properties){var exts=modeExtensions.hasOwnProperty(mode)?modeExtensions[mode]:modeExtensions[mode]={};copyObj(properties,exts)}function copyState(mode,state){if(state===true){return state}if(mode.copyState){return mode.copyState(state)}var nstate={};for(var n in state){var val=state[n];if(val instanceof Array){val=val.concat([])}nstate[n]=val}return nstate}function innerMode(mode,state){var info;while(mode.innerMode){info=mode.innerMode(state);if(!info||info.mode==mode){break}state=info.state;mode=info.mode}return info||{mode:mode,state:state}}function startState(mode,a1,a2){return mode.startState?mode.startState(a1,a2):true}var StringStream=function(string,tabSize,lineOracle){this.pos=this.start=0;this.string=string;this.tabSize=tabSize||8;this.lastColumnPos=this.lastColumnValue=0;this.lineStart=0;this.lineOracle=lineOracle};StringStream.prototype.eol=function(){return this.pos>=this.string.length};StringStream.prototype.sol=function(){return this.pos==this.lineStart};StringStream.prototype.peek=function(){return this.string.charAt(this.pos)||undefined};StringStream.prototype.next=function(){if(this.pos<this.string.length){return this.string.charAt(this.pos++)}};StringStream.prototype.eat=function(match){var ch=this.string.charAt(this.pos);var ok;if(typeof match=="string"){ok=ch==match}else{ok=ch&&(match.test?match.test(ch):match(ch))}if(ok){++this.pos;return ch}};StringStream.prototype.eatWhile=function(match){var start=this.pos;while(this.eat(match)){}return this.pos>start};StringStream.prototype.eatSpace=function(){var this$1=this;var start=this.pos;while(/[\s\u00a0]/.test(this.string.charAt(this.pos))){++this$1.pos}return this.pos>start};StringStream.prototype.skipToEnd=function(){this.pos=this.string.length};StringStream.prototype.skipTo=function(ch){var found=this.string.indexOf(ch,this.pos);if(found>-1){this.pos=found;return true}};StringStream.prototype.backUp=function(n){this.pos-=n};StringStream.prototype.column=function(){if(this.lastColumnPos<this.start){this.lastColumnValue=countColumn(this.string,this.start,this.tabSize,this.lastColumnPos,this.lastColumnValue);this.lastColumnPos=this.start}return this.lastColumnValue-(this.lineStart?countColumn(this.string,this.lineStart,this.tabSize):0)};StringStream.prototype.indentation=function(){return countColumn(this.string,null,this.tabSize)-(this.lineStart?countColumn(this.string,this.lineStart,this.tabSize):0)};StringStream.prototype.match=function(pattern,consume,caseInsensitive){if(typeof pattern=="string"){var cased=function(str){return caseInsensitive?str.toLowerCase():str};var substr=this.string.substr(this.pos,pattern.length);if(cased(substr)==cased(pattern)){if(consume!==false){this.pos+=pattern.length}return true}}else{var match=this.string.slice(this.pos).match(pattern);if(match&&match.index>0){return null}if(match&&consume!==false){this.pos+=match[0].length}return match}};StringStream.prototype.current=function(){return this.string.slice(this.start,this.pos)};StringStream.prototype.hideFirstChars=function(n,inner){this.lineStart+=n;try{return inner()}finally{this.lineStart-=n}};StringStream.prototype.lookAhead=function(n){var oracle=this.lineOracle;return oracle&&oracle.lookAhead(n)};var SavedContext=function(state,lookAhead){this.state=state;this.lookAhead=lookAhead};var Context=function(doc,state,line,lookAhead){this.state=state;this.doc=doc;this.line=line;this.maxLookAhead=lookAhead||0};Context.prototype.lookAhead=function(n){var line=this.doc.getLine(this.line+n);if(line!=null&&n>this.maxLookAhead){this.maxLookAhead=n}return line};Context.prototype.nextLine=function(){this.line++;if(this.maxLookAhead>0){this.maxLookAhead--}};Context.fromSaved=function(doc,saved,line){if(saved instanceof SavedContext){return new Context(doc,copyState(doc.mode,saved.state),line,saved.lookAhead)}else{return new Context(doc,copyState(doc.mode,saved),line)}};Context.prototype.save=function(copy){var state=copy!==false?copyState(this.doc.mode,this.state):this.state;return this.maxLookAhead>0?new SavedContext(state,this.maxLookAhead):state};function highlightLine(cm,line,context,forceToEnd){var st=[cm.state.modeGen],lineClasses={};runMode(cm,line.text,cm.doc.mode,context,function(end,style){return st.push(end,style)},lineClasses,forceToEnd);var state=context.state;var loop=function(o){var overlay=cm.state.overlays[o],i=1,at=0;context.state=true;runMode(cm,line.text,overlay.mode,context,function(end,style){var start=i;while(at<end){var i_end=st[i];if(i_end>end){st.splice(i,1,end,st[i+1],i_end)}i+=2;at=Math.min(end,i_end)}if(!style){return}if(overlay.opaque){st.splice(start,i-start,end,"overlay "+style);i=start+2}else{for(;start<i;start+=2){var cur=st[start+1];st[start+1]=(cur?cur+" ":"")+"overlay "+style}}},lineClasses)};for(var o=0;o<cm.state.overlays.length;++o)loop(o);context.state=state;return{styles:st,classes:lineClasses.bgClass||lineClasses.textClass?lineClasses:null}}function getLineStyles(cm,line,updateFrontier){if(!line.styles||line.styles[0]!=cm.state.modeGen){var context=getContextBefore(cm,lineNo(line));var resetState=line.text.length>cm.options.maxHighlightLength&&copyState(cm.doc.mode,context.state);var result=highlightLine(cm,line,context);if(resetState){context.state=resetState}line.stateAfter=context.save(!resetState);line.styles=result.styles;if(result.classes){line.styleClasses=result.classes}else if(line.styleClasses){line.styleClasses=null}if(updateFrontier===cm.doc.highlightFrontier){cm.doc.modeFrontier=Math.max(cm.doc.modeFrontier,++cm.doc.highlightFrontier)}}return line.styles}function getContextBefore(cm,n,precise){var doc=cm.doc,display=cm.display;if(!doc.mode.startState){return new Context(doc,true,n)}var start=findStartLine(cm,n,precise);var saved=start>doc.first&&getLine(doc,start-1).stateAfter;var context=saved?Context.fromSaved(doc,saved,start):new Context(doc,startState(doc.mode),start);doc.iter(start,n,function(line){processLine(cm,line.text,context);var pos=context.line;line.stateAfter=pos==n-1||pos%5==0||pos>=display.viewFrom&&pos<display.viewTo?context.save():null;context.nextLine()});if(precise){doc.modeFrontier=context.line}return context}function processLine(cm,text,context,startAt){var mode=cm.doc.mode;var stream=new StringStream(text,cm.options.tabSize,context);stream.start=stream.pos=startAt||0;if(text==""){callBlankLine(mode,context.state)}while(!stream.eol()){readToken(mode,stream,context.state);stream.start=stream.pos}}function callBlankLine(mode,state){if(mode.blankLine){return mode.blankLine(state)}if(!mode.innerMode){return}var inner=innerMode(mode,state);if(inner.mode.blankLine){return inner.mode.blankLine(inner.state)}}function readToken(mode,stream,state,inner){for(var i=0;i<10;i++){if(inner){inner[0]=innerMode(mode,state).mode}var style=mode.token(stream,state);if(stream.pos>stream.start){return style}}throw new Error("Mode "+mode.name+" failed to advance stream.")}var Token=function(stream,type,state){this.start=stream.start;this.end=stream.pos;this.string=stream.current();this.type=type||null;this.state=state};function takeToken(cm,pos,precise,asArray){var doc=cm.doc,mode=doc.mode,style;pos=clipPos(doc,pos);var line=getLine(doc,pos.line),context=getContextBefore(cm,pos.line,precise);var stream=new StringStream(line.text,cm.options.tabSize,context),tokens;if(asArray){tokens=[]}while((asArray||stream.pos<pos.ch)&&!stream.eol()){stream.start=stream.pos;style=readToken(mode,stream,context.state);if(asArray){tokens.push(new Token(stream,style,copyState(doc.mode,context.state)))}}return asArray?tokens:new Token(stream,style,context.state)}function extractLineClasses(type,output){if(type){for(;;){var lineClass=type.match(/(?:^|\s+)line-(background-)?(\S+)/);if(!lineClass){break}type=type.slice(0,lineClass.index)+type.slice(lineClass.index+lineClass[0].length);var prop=lineClass[1]?"bgClass":"textClass";if(output[prop]==null){output[prop]=lineClass[2]}else if(!new RegExp("(?:^|s)"+lineClass[2]+"(?:$|s)").test(output[prop])){output[prop]+=" "+lineClass[2]}}}return type}function runMode(cm,text,mode,context,f,lineClasses,forceToEnd){var flattenSpans=mode.flattenSpans;if(flattenSpans==null){flattenSpans=cm.options.flattenSpans}var curStart=0,curStyle=null;var stream=new StringStream(text,cm.options.tabSize,context),style;var inner=cm.options.addModeClass&&[null];if(text==""){extractLineClasses(callBlankLine(mode,context.state),lineClasses)}while(!stream.eol()){if(stream.pos>cm.options.maxHighlightLength){flattenSpans=false;if(forceToEnd){processLine(cm,text,context,stream.pos)}stream.pos=text.length;style=null}else{style=extractLineClasses(readToken(mode,stream,context.state,inner),lineClasses)}if(inner){var mName=inner[0].name;if(mName){style="m-"+(style?mName+" "+style:mName)}}if(!flattenSpans||curStyle!=style){while(curStart<stream.start){curStart=Math.min(stream.start,curStart+5e3);f(curStart,curStyle)}curStyle=style}stream.start=stream.pos}while(curStart<stream.pos){var pos=Math.min(stream.pos,curStart+5e3);f(pos,curStyle);curStart=pos}}function findStartLine(cm,n,precise){var minindent,minline,doc=cm.doc;var lim=precise?-1:n-(cm.doc.mode.innerMode?1e3:100);for(var search=n;search>lim;--search){if(search<=doc.first){return doc.first}var line=getLine(doc,search-1),after=line.stateAfter;if(after&&(!precise||search+(after instanceof SavedContext?after.lookAhead:0)<=doc.modeFrontier)){return search}var indented=countColumn(line.text,null,cm.options.tabSize);if(minline==null||minindent>indented){minline=search-1;minindent=indented}}return minline}function retreatFrontier(doc,n){doc.modeFrontier=Math.min(doc.modeFrontier,n);if(doc.highlightFrontier<n-10){return}var start=doc.first;for(var line=n-1;line>start;line--){var saved=getLine(doc,line).stateAfter;if(saved&&(!(saved instanceof SavedContext)||line+saved.lookAhead<n)){start=line+1;break}}doc.highlightFrontier=Math.min(doc.highlightFrontier,start)}var Line=function(text,markedSpans,estimateHeight){this.text=text;attachMarkedSpans(this,markedSpans);this.height=estimateHeight?estimateHeight(this):1};Line.prototype.lineNo=function(){return lineNo(this)};eventMixin(Line);function updateLine(line,text,markedSpans,estimateHeight){line.text=text;if(line.stateAfter){line.stateAfter=null}if(line.styles){line.styles=null}if(line.order!=null){line.order=null}detachMarkedSpans(line);attachMarkedSpans(line,markedSpans);var estHeight=estimateHeight?estimateHeight(line):1;if(estHeight!=line.height){updateLineHeight(line,estHeight)}}function cleanUpLine(line){line.parent=null;detachMarkedSpans(line)}var styleToClassCache={};var styleToClassCacheWithMode={};function interpretTokenStyle(style,options){if(!style||/^\s*$/.test(style)){return null}var cache=options.addModeClass?styleToClassCacheWithMode:styleToClassCache;return cache[style]||(cache[style]=style.replace(/\S+/g,"cm-$&"))}function buildLineContent(cm,lineView){var content=eltP("span",null,null,webkit?"padding-right: .1px":null);var builder={pre:eltP("pre",[content],"CodeMirror-line"),content:content,col:0,pos:0,cm:cm,trailingSpace:false,splitSpaces:(ie||webkit)&&cm.getOption("lineWrapping")};lineView.measure={};for(var i=0;i<=(lineView.rest?lineView.rest.length:0);i++){var line=i?lineView.rest[i-1]:lineView.line,order=void 0;builder.pos=0;builder.addToken=buildToken;if(hasBadBidiRects(cm.display.measure)&&(order=getOrder(line,cm.doc.direction))){builder.addToken=buildTokenBadBidi(builder.addToken,order)}builder.map=[];var allowFrontierUpdate=lineView!=cm.display.externalMeasured&&lineNo(line);insertLineContent(line,builder,getLineStyles(cm,line,allowFrontierUpdate));if(line.styleClasses){if(line.styleClasses.bgClass){builder.bgClass=joinClasses(line.styleClasses.bgClass,builder.bgClass||"")}if(line.styleClasses.textClass){builder.textClass=joinClasses(line.styleClasses.textClass,builder.textClass||"")}}if(builder.map.length==0){builder.map.push(0,0,builder.content.appendChild(zeroWidthElement(cm.display.measure)))}if(i==0){lineView.measure.map=builder.map;lineView.measure.cache={}}else{(lineView.measure.maps||(lineView.measure.maps=[])).push(builder.map);(lineView.measure.caches||(lineView.measure.caches=[])).push({})}}if(webkit){var last=builder.content.lastChild;if(/\bcm-tab\b/.test(last.className)||last.querySelector&&last.querySelector(".cm-tab")){builder.content.className="cm-tab-wrap-hack"}}signal(cm,"renderLine",cm,lineView.line,builder.pre);if(builder.pre.className){builder.textClass=joinClasses(builder.pre.className,builder.textClass||"")}return builder}function defaultSpecialCharPlaceholder(ch){var token=elt("span","•","cm-invalidchar");token.title="\\u"+ch.charCodeAt(0).toString(16);token.setAttribute("aria-label",token.title);return token}function buildToken(builder,text,style,startStyle,endStyle,title,css){if(!text){return}var displayText=builder.splitSpaces?splitSpaces(text,builder.trailingSpace):text;var special=builder.cm.state.specialChars,mustWrap=false;var content;if(!special.test(text)){builder.col+=text.length;content=document.createTextNode(displayText);builder.map.push(builder.pos,builder.pos+text.length,content);if(ie&&ie_version<9){mustWrap=true}builder.pos+=text.length}else{content=document.createDocumentFragment();var pos=0;while(true){special.lastIndex=pos;var m=special.exec(text);var skipped=m?m.index-pos:text.length-pos;if(skipped){var txt=document.createTextNode(displayText.slice(pos,pos+skipped));if(ie&&ie_version<9){content.appendChild(elt("span",[txt]))}else{content.appendChild(txt)}builder.map.push(builder.pos,builder.pos+skipped,txt);builder.col+=skipped;builder.pos+=skipped}if(!m){break}pos+=skipped+1;var txt$1=void 0;if(m[0]=="\t"){var tabSize=builder.cm.options.tabSize,tabWidth=tabSize-builder.col%tabSize;txt$1=content.appendChild(elt("span",spaceStr(tabWidth),"cm-tab"));txt$1.setAttribute("role","presentation");txt$1.setAttribute("cm-text","\t");builder.col+=tabWidth}else if(m[0]=="\r"||m[0]=="\n"){txt$1=content.appendChild(elt("span",m[0]=="\r"?"␍":"␤","cm-invalidchar"));txt$1.setAttribute("cm-text",m[0]);builder.col+=1}else{txt$1=builder.cm.options.specialCharPlaceholder(m[0]);txt$1.setAttribute("cm-text",m[0]);if(ie&&ie_version<9){content.appendChild(elt("span",[txt$1]))}else{content.appendChild(txt$1)}builder.col+=1}builder.map.push(builder.pos,builder.pos+1,txt$1);builder.pos++}}builder.trailingSpace=displayText.charCodeAt(text.length-1)==32;if(style||startStyle||endStyle||mustWrap||css){var fullStyle=style||"";if(startStyle){fullStyle+=startStyle}if(endStyle){fullStyle+=endStyle}var token=elt("span",[content],fullStyle,css);if(title){token.title=title}return builder.content.appendChild(token)}builder.content.appendChild(content)}function splitSpaces(text,trailingBefore){if(text.length>1&&!/  /.test(text)){return text}var spaceBefore=trailingBefore,result="";for(var i=0;i<text.length;i++){var ch=text.charAt(i);if(ch==" "&&spaceBefore&&(i==text.length-1||text.charCodeAt(i+1)==32)){ch=" "}result+=ch;spaceBefore=ch==" "}return result}function buildTokenBadBidi(inner,order){return function(builder,text,style,startStyle,endStyle,title,css){style=style?style+" cm-force-border":"cm-force-border";var start=builder.pos,end=start+text.length;for(;;){var part=void 0;for(var i=0;i<order.length;i++){part=order[i];if(part.to>start&&part.from<=start){break}}if(part.to>=end){return inner(builder,text,style,startStyle,endStyle,title,css)}inner(builder,text.slice(0,part.to-start),style,startStyle,null,title,css);startStyle=null;text=text.slice(part.to-start);start=part.to}}}function buildCollapsedSpan(builder,size,marker,ignoreWidget){var widget=!ignoreWidget&&marker.widgetNode;if(widget){builder.map.push(builder.pos,builder.pos+size,widget)}if(!ignoreWidget&&builder.cm.display.input.needsContentAttribute){if(!widget){widget=builder.content.appendChild(document.createElement("span"))}widget.setAttribute("cm-marker",marker.id)}if(widget){builder.cm.display.input.setUneditable(widget);builder.content.appendChild(widget)}builder.pos+=size;builder.trailingSpace=false}function insertLineContent(line,builder,styles){var spans=line.markedSpans,allText=line.text,at=0;if(!spans){for(var i$1=1;i$1<styles.length;i$1+=2){builder.addToken(builder,allText.slice(at,at=styles[i$1]),interpretTokenStyle(styles[i$1+1],builder.cm.options))}return}var len=allText.length,pos=0,i=1,text="",style,css;var nextChange=0,spanStyle,spanEndStyle,spanStartStyle,title,collapsed;for(;;){if(nextChange==pos){spanStyle=spanEndStyle=spanStartStyle=title=css="";collapsed=null;nextChange=Infinity;var foundBookmarks=[],endStyles=void 0;for(var j=0;j<spans.length;++j){var sp=spans[j],m=sp.marker;if(m.type=="bookmark"&&sp.from==pos&&m.widgetNode){foundBookmarks.push(m)}else if(sp.from<=pos&&(sp.to==null||sp.to>pos||m.collapsed&&sp.to==pos&&sp.from==pos)){if(sp.to!=null&&sp.to!=pos&&nextChange>sp.to){nextChange=sp.to;spanEndStyle=""}if(m.className){spanStyle+=" "+m.className}if(m.css){css=(css?css+";":"")+m.css}if(m.startStyle&&sp.from==pos){spanStartStyle+=" "+m.startStyle}if(m.endStyle&&sp.to==nextChange){(endStyles||(endStyles=[])).push(m.endStyle,sp.to)}if(m.title&&!title){title=m.title}if(m.collapsed&&(!collapsed||compareCollapsedMarkers(collapsed.marker,m)<0)){collapsed=sp}}else if(sp.from>pos&&nextChange>sp.from){nextChange=sp.from}}if(endStyles){for(var j$1=0;j$1<endStyles.length;j$1+=2){if(endStyles[j$1+1]==nextChange){spanEndStyle+=" "+endStyles[j$1]}}}if(!collapsed||collapsed.from==pos){for(var j$2=0;j$2<foundBookmarks.length;++j$2){buildCollapsedSpan(builder,0,foundBookmarks[j$2])}}if(collapsed&&(collapsed.from||0)==pos){buildCollapsedSpan(builder,(collapsed.to==null?len+1:collapsed.to)-pos,collapsed.marker,collapsed.from==null);if(collapsed.to==null){return}if(collapsed.to==pos){collapsed=false}}}if(pos>=len){break}var upto=Math.min(len,nextChange);while(true){if(text){var end=pos+text.length;if(!collapsed){var tokenText=end>upto?text.slice(0,upto-pos):text;builder.addToken(builder,tokenText,style?style+spanStyle:spanStyle,spanStartStyle,pos+tokenText.length==nextChange?spanEndStyle:"",title,css)}if(end>=upto){text=text.slice(upto-pos);pos=upto;break}pos=end;spanStartStyle=""}text=allText.slice(at,at=styles[i++]);style=interpretTokenStyle(styles[i++],builder.cm.options)}}}function LineView(doc,line,lineN){this.line=line;this.rest=visualLineContinued(line);this.size=this.rest?lineNo(lst(this.rest))-lineN+1:1;this.node=this.text=null;this.hidden=lineIsHidden(doc,line)}function buildViewArray(cm,from,to){var array=[],nextPos;for(var pos=from;pos<to;pos=nextPos){var view=new LineView(cm.doc,getLine(cm.doc,pos),pos);nextPos=pos+view.size;array.push(view)}return array}var operationGroup=null;function pushOperation(op){if(operationGroup){operationGroup.ops.push(op)}else{op.ownsGroup=operationGroup={ops:[op],delayedCallbacks:[]}}}function fireCallbacksForOps(group){var callbacks=group.delayedCallbacks,i=0;do{for(;i<callbacks.length;i++){callbacks[i].call(null)}for(var j=0;j<group.ops.length;j++){var op=group.ops[j];if(op.cursorActivityHandlers){while(op.cursorActivityCalled<op.cursorActivityHandlers.length){op.cursorActivityHandlers[op.cursorActivityCalled++].call(null,op.cm)}}}}while(i<callbacks.length)}function finishOperation(op,endCb){var group=op.ownsGroup;if(!group){return}try{fireCallbacksForOps(group)}finally{operationGroup=null;endCb(group)}}var orphanDelayedCallbacks=null;function signalLater(emitter,type){var arr=getHandlers(emitter,type);if(!arr.length){return}var args=Array.prototype.slice.call(arguments,2),list;if(operationGroup){list=operationGroup.delayedCallbacks}else if(orphanDelayedCallbacks){list=orphanDelayedCallbacks}else{list=orphanDelayedCallbacks=[];setTimeout(fireOrphanDelayed,0)}var loop=function(i){list.push(function(){return arr[i].apply(null,args)})};for(var i=0;i<arr.length;++i)loop(i)}function fireOrphanDelayed(){var delayed=orphanDelayedCallbacks;orphanDelayedCallbacks=null;for(var i=0;i<delayed.length;++i){delayed[i]()}}function updateLineForChanges(cm,lineView,lineN,dims){for(var j=0;j<lineView.changes.length;j++){var type=lineView.changes[j];if(type=="text"){updateLineText(cm,lineView)}else if(type=="gutter"){updateLineGutter(cm,lineView,lineN,dims)}else if(type=="class"){updateLineClasses(cm,lineView)}else if(type=="widget"){updateLineWidgets(cm,lineView,dims)}}lineView.changes=null}function ensureLineWrapped(lineView){if(lineView.node==lineView.text){lineView.node=elt("div",null,null,"position: relative");if(lineView.text.parentNode){lineView.text.parentNode.replaceChild(lineView.node,lineView.text)}lineView.node.appendChild(lineView.text);if(ie&&ie_version<8){lineView.node.style.zIndex=2}}return lineView.node}function updateLineBackground(cm,lineView){var cls=lineView.bgClass?lineView.bgClass+" "+(lineView.line.bgClass||""):lineView.line.bgClass;if(cls){cls+=" CodeMirror-linebackground"}if(lineView.background){if(cls){lineView.background.className=cls}else{lineView.background.parentNode.removeChild(lineView.background);lineView.background=null}}else if(cls){var wrap=ensureLineWrapped(lineView);lineView.background=wrap.insertBefore(elt("div",null,cls),wrap.firstChild);cm.display.input.setUneditable(lineView.background)}}function getLineContent(cm,lineView){var ext=cm.display.externalMeasured;if(ext&&ext.line==lineView.line){cm.display.externalMeasured=null;lineView.measure=ext.measure;return ext.built}return buildLineContent(cm,lineView)}function updateLineText(cm,lineView){var cls=lineView.text.className;var built=getLineContent(cm,lineView);if(lineView.text==lineView.node){lineView.node=built.pre}lineView.text.parentNode.replaceChild(built.pre,lineView.text);lineView.text=built.pre;if(built.bgClass!=lineView.bgClass||built.textClass!=lineView.textClass){lineView.bgClass=built.bgClass;lineView.textClass=built.textClass;updateLineClasses(cm,lineView)}else if(cls){lineView.text.className=cls}}function updateLineClasses(cm,lineView){updateLineBackground(cm,lineView);if(lineView.line.wrapClass){ensureLineWrapped(lineView).className=lineView.line.wrapClass}else if(lineView.node!=lineView.text){lineView.node.className=""}var textClass=lineView.textClass?lineView.textClass+" "+(lineView.line.textClass||""):lineView.line.textClass;lineView.text.className=textClass||""}function updateLineGutter(cm,lineView,lineN,dims){if(lineView.gutter){lineView.node.removeChild(lineView.gutter);lineView.gutter=null}if(lineView.gutterBackground){lineView.node.removeChild(lineView.gutterBackground);lineView.gutterBackground=null}if(lineView.line.gutterClass){var wrap=ensureLineWrapped(lineView);lineView.gutterBackground=elt("div",null,"CodeMirror-gutter-background "+lineView.line.gutterClass,"left: "+(cm.options.fixedGutter?dims.fixedPos:-dims.gutterTotalWidth)+"px; width: "+dims.gutterTotalWidth+"px");cm.display.input.setUneditable(lineView.gutterBackground);wrap.insertBefore(lineView.gutterBackground,lineView.text)}var markers=lineView.line.gutterMarkers;if(cm.options.lineNumbers||markers){var wrap$1=ensureLineWrapped(lineView);var gutterWrap=lineView.gutter=elt("div",null,"CodeMirror-gutter-wrapper","left: "+(cm.options.fixedGutter?dims.fixedPos:-dims.gutterTotalWidth)+"px");cm.display.input.setUneditable(gutterWrap);wrap$1.insertBefore(gutterWrap,lineView.text);if(lineView.line.gutterClass){gutterWrap.className+=" "+lineView.line.gutterClass}if(cm.options.lineNumbers&&(!markers||!markers["CodeMirror-linenumbers"])){lineView.lineNumber=gutterWrap.appendChild(elt("div",lineNumberFor(cm.options,lineN),"CodeMirror-linenumber CodeMirror-gutter-elt","left: "+dims.gutterLeft["CodeMirror-linenumbers"]+"px; width: "+cm.display.lineNumInnerWidth+"px"))}if(markers){for(var k=0;k<cm.options.gutters.length;++k){var id=cm.options.gutters[k],found=markers.hasOwnProperty(id)&&markers[id];if(found){gutterWrap.appendChild(elt("div",[found],"CodeMirror-gutter-elt","left: "+dims.gutterLeft[id]+"px; width: "+dims.gutterWidth[id]+"px"))}}}}}function updateLineWidgets(cm,lineView,dims){if(lineView.alignable){lineView.alignable=null}for(var node=lineView.node.firstChild,next=void 0;node;node=next){next=node.nextSibling;if(node.className=="CodeMirror-linewidget"){lineView.node.removeChild(node)}}insertLineWidgets(cm,lineView,dims)}function buildLineElement(cm,lineView,lineN,dims){var built=getLineContent(cm,lineView);lineView.text=lineView.node=built.pre;if(built.bgClass){lineView.bgClass=built.bgClass}if(built.textClass){lineView.textClass=built.textClass}updateLineClasses(cm,lineView);updateLineGutter(cm,lineView,lineN,dims);insertLineWidgets(cm,lineView,dims);return lineView.node}function insertLineWidgets(cm,lineView,dims){insertLineWidgetsFor(cm,lineView.line,lineView,dims,true);if(lineView.rest){for(var i=0;i<lineView.rest.length;i++){insertLineWidgetsFor(cm,lineView.rest[i],lineView,dims,false)}}}function insertLineWidgetsFor(cm,line,lineView,dims,allowAbove){if(!line.widgets){return}var wrap=ensureLineWrapped(lineView);for(var i=0,ws=line.widgets;i<ws.length;++i){var widget=ws[i],node=elt("div",[widget.node],"CodeMirror-linewidget");if(!widget.handleMouseEvents){node.setAttribute("cm-ignore-events","true")}positionLineWidget(widget,node,lineView,dims);cm.display.input.setUneditable(node);if(allowAbove&&widget.above){wrap.insertBefore(node,lineView.gutter||lineView.text)}else{wrap.appendChild(node)}signalLater(widget,"redraw")}}function positionLineWidget(widget,node,lineView,dims){if(widget.noHScroll){(lineView.alignable||(lineView.alignable=[])).push(node);var width=dims.wrapperWidth;node.style.left=dims.fixedPos+"px";if(!widget.coverGutter){width-=dims.gutterTotalWidth;node.style.paddingLeft=dims.gutterTotalWidth+"px"}node.style.width=width+"px"}if(widget.coverGutter){node.style.zIndex=5;node.style.position="relative";if(!widget.noHScroll){node.style.marginLeft=-dims.gutterTotalWidth+"px"}}}function widgetHeight(widget){if(widget.height!=null){return widget.height}var cm=widget.doc.cm;if(!cm){return 0}if(!contains(document.body,widget.node)){var parentStyle="position: relative;";if(widget.coverGutter){parentStyle+="margin-left: -"+cm.display.gutters.offsetWidth+"px;"}if(widget.noHScroll){parentStyle+="width: "+cm.display.wrapper.clientWidth+"px;"}removeChildrenAndAdd(cm.display.measure,elt("div",[widget.node],null,parentStyle))}return widget.height=widget.node.parentNode.offsetHeight}function eventInWidget(display,e){for(var n=e_target(e);n!=display.wrapper;n=n.parentNode){if(!n||n.nodeType==1&&n.getAttribute("cm-ignore-events")=="true"||n.parentNode==display.sizer&&n!=display.mover){return true}}}function paddingTop(display){return display.lineSpace.offsetTop}function paddingVert(display){return display.mover.offsetHeight-display.lineSpace.offsetHeight}function paddingH(display){if(display.cachedPaddingH){return display.cachedPaddingH}var e=removeChildrenAndAdd(display.measure,elt("pre","x"));var style=window.getComputedStyle?window.getComputedStyle(e):e.currentStyle;var data={left:parseInt(style.paddingLeft),right:parseInt(style.paddingRight)};if(!isNaN(data.left)&&!isNaN(data.right)){display.cachedPaddingH=data}return data}function scrollGap(cm){return scrollerGap-cm.display.nativeBarWidth}function displayWidth(cm){return cm.display.scroller.clientWidth-scrollGap(cm)-cm.display.barWidth}function displayHeight(cm){return cm.display.scroller.clientHeight-scrollGap(cm)-cm.display.barHeight}function ensureLineHeights(cm,lineView,rect){var wrapping=cm.options.lineWrapping;var curWidth=wrapping&&displayWidth(cm);if(!lineView.measure.heights||wrapping&&lineView.measure.width!=curWidth){var heights=lineView.measure.heights=[];if(wrapping){lineView.measure.width=curWidth;var rects=lineView.text.firstChild.getClientRects();for(var i=0;i<rects.length-1;i++){var cur=rects[i],next=rects[i+1];if(Math.abs(cur.bottom-next.bottom)>2){heights.push((cur.bottom+next.top)/2-rect.top)}}}heights.push(rect.bottom-rect.top)}}function mapFromLineView(lineView,line,lineN){if(lineView.line==line){return{map:lineView.measure.map,cache:lineView.measure.cache}}for(var i=0;i<lineView.rest.length;i++){if(lineView.rest[i]==line){return{map:lineView.measure.maps[i],cache:lineView.measure.caches[i]}}}for(var i$1=0;i$1<lineView.rest.length;i$1++){if(lineNo(lineView.rest[i$1])>lineN){return{map:lineView.measure.maps[i$1],cache:lineView.measure.caches[i$1],before:true}}}}function updateExternalMeasurement(cm,line){line=visualLine(line);var lineN=lineNo(line);var view=cm.display.externalMeasured=new LineView(cm.doc,line,lineN);view.lineN=lineN;var built=view.built=buildLineContent(cm,view);view.text=built.pre;removeChildrenAndAdd(cm.display.lineMeasure,built.pre);return view}function measureChar(cm,line,ch,bias){return measureCharPrepared(cm,prepareMeasureForLine(cm,line),ch,bias)}function findViewForLine(cm,lineN){if(lineN>=cm.display.viewFrom&&lineN<cm.display.viewTo){return cm.display.view[findViewIndex(cm,lineN)]}var ext=cm.display.externalMeasured;if(ext&&lineN>=ext.lineN&&lineN<ext.lineN+ext.size){return ext}}function prepareMeasureForLine(cm,line){var lineN=lineNo(line);var view=findViewForLine(cm,lineN);if(view&&!view.text){view=null}else if(view&&view.changes){updateLineForChanges(cm,view,lineN,getDimensions(cm));cm.curOp.forceUpdate=true}if(!view){view=updateExternalMeasurement(cm,line)}var info=mapFromLineView(view,line,lineN);return{line:line,view:view,rect:null,map:info.map,cache:info.cache,before:info.before,hasHeights:false}}function measureCharPrepared(cm,prepared,ch,bias,varHeight){if(prepared.before){ch=-1}var key=ch+(bias||""),found;if(prepared.cache.hasOwnProperty(key)){found=prepared.cache[key]}else{if(!prepared.rect){prepared.rect=prepared.view.text.getBoundingClientRect()}if(!prepared.hasHeights){ensureLineHeights(cm,prepared.view,prepared.rect);prepared.hasHeights=true}found=measureCharInner(cm,prepared,ch,bias);if(!found.bogus){prepared.cache[key]=found}}return{left:found.left,right:found.right,top:varHeight?found.rtop:found.top,bottom:varHeight?found.rbottom:found.bottom}}var nullRect={left:0,right:0,top:0,bottom:0};function nodeAndOffsetInLineMap(map$$1,ch,bias){var node,start,end,collapse,mStart,mEnd;for(var i=0;i<map$$1.length;i+=3){mStart=map$$1[i];mEnd=map$$1[i+1];if(ch<mStart){start=0;end=1;collapse="left"}else if(ch<mEnd){start=ch-mStart;end=start+1}else if(i==map$$1.length-3||ch==mEnd&&map$$1[i+3]>ch){end=mEnd-mStart;start=end-1;if(ch>=mEnd){collapse="right"}}if(start!=null){node=map$$1[i+2];if(mStart==mEnd&&bias==(node.insertLeft?"left":"right")){collapse=bias}if(bias=="left"&&start==0){while(i&&map$$1[i-2]==map$$1[i-3]&&map$$1[i-1].insertLeft){node=map$$1[(i-=3)+2];collapse="left"}}if(bias=="right"&&start==mEnd-mStart){while(i<map$$1.length-3&&map$$1[i+3]==map$$1[i+4]&&!map$$1[i+5].insertLeft){node=map$$1[(i+=3)+2];collapse="right"}}break}}return{node:node,start:start,end:end,collapse:collapse,coverStart:mStart,coverEnd:mEnd}}function getUsefulRect(rects,bias){var rect=nullRect;if(bias=="left"){for(var i=0;i<rects.length;i++){if((rect=rects[i]).left!=rect.right){break}}}else{for(var i$1=rects.length-1;i$1>=0;i$1--){if((rect=rects[i$1]).left!=rect.right){break}}}return rect}function measureCharInner(cm,prepared,ch,bias){var place=nodeAndOffsetInLineMap(prepared.map,ch,bias);var node=place.node,start=place.start,end=place.end,collapse=place.collapse;var rect;if(node.nodeType==3){for(var i$1=0;i$1<4;i$1++){while(start&&isExtendingChar(prepared.line.text.charAt(place.coverStart+start))){--start}while(place.coverStart+end<place.coverEnd&&isExtendingChar(prepared.line.text.charAt(place.coverStart+end))){++end}if(ie&&ie_version<9&&start==0&&end==place.coverEnd-place.coverStart){rect=node.parentNode.getBoundingClientRect()}else{rect=getUsefulRect(range(node,start,end).getClientRects(),bias)}if(rect.left||rect.right||start==0){break}end=start;start=start-1;collapse="right"}if(ie&&ie_version<11){rect=maybeUpdateRectForZooming(cm.display.measure,rect)}}else{if(start>0){collapse=bias="right"}var rects;if(cm.options.lineWrapping&&(rects=node.getClientRects()).length>1){rect=rects[bias=="right"?rects.length-1:0]}else{rect=node.getBoundingClientRect()}}if(ie&&ie_version<9&&!start&&(!rect||!rect.left&&!rect.right)){var rSpan=node.parentNode.getClientRects()[0];if(rSpan){rect={left:rSpan.left,right:rSpan.left+charWidth(cm.display),top:rSpan.top,bottom:rSpan.bottom}}else{rect=nullRect}}var rtop=rect.top-prepared.rect.top,rbot=rect.bottom-prepared.rect.top;var mid=(rtop+rbot)/2;var heights=prepared.view.measure.heights;var i=0;for(;i<heights.length-1;i++){if(mid<heights[i]){break}}var top=i?heights[i-1]:0,bot=heights[i];var result={left:(collapse=="right"?rect.right:rect.left)-prepared.rect.left,right:(collapse=="left"?rect.left:rect.right)-prepared.rect.left,top:top,bottom:bot};if(!rect.left&&!rect.right){result.bogus=true}if(!cm.options.singleCursorHeightPerLine){result.rtop=rtop;result.rbottom=rbot}return result}function maybeUpdateRectForZooming(measure,rect){if(!window.screen||screen.logicalXDPI==null||screen.logicalXDPI==screen.deviceXDPI||!hasBadZoomedRects(measure)){return rect}var scaleX=screen.logicalXDPI/screen.deviceXDPI;var scaleY=screen.logicalYDPI/screen.deviceYDPI;return{left:rect.left*scaleX,right:rect.right*scaleX,top:rect.top*scaleY,bottom:rect.bottom*scaleY}}function clearLineMeasurementCacheFor(lineView){if(lineView.measure){lineView.measure.cache={};lineView.measure.heights=null;if(lineView.rest){for(var i=0;i<lineView.rest.length;i++){lineView.measure.caches[i]={}}}}}function clearLineMeasurementCache(cm){cm.display.externalMeasure=null;removeChildren(cm.display.lineMeasure);for(var i=0;i<cm.display.view.length;i++){clearLineMeasurementCacheFor(cm.display.view[i])}}function clearCaches(cm){clearLineMeasurementCache(cm);cm.display.cachedCharWidth=cm.display.cachedTextHeight=cm.display.cachedPaddingH=null;if(!cm.options.lineWrapping){cm.display.maxLineChanged=true}cm.display.lineNumChars=null}function pageScrollX(){if(chrome&&android){return-(document.body.getBoundingClientRect().left-parseInt(getComputedStyle(document.body).marginLeft))}return window.pageXOffset||(document.documentElement||document.body).scrollLeft}function pageScrollY(){if(chrome&&android){return-(document.body.getBoundingClientRect().top-parseInt(getComputedStyle(document.body).marginTop))}return window.pageYOffset||(document.documentElement||document.body).scrollTop}function intoCoordSystem(cm,lineObj,rect,context,includeWidgets){if(!includeWidgets&&lineObj.widgets){for(var i=0;i<lineObj.widgets.length;++i){if(lineObj.widgets[i].above){var size=widgetHeight(lineObj.widgets[i]);rect.top+=size;rect.bottom+=size}}}if(context=="line"){return rect}if(!context){context="local"}var yOff=heightAtLine(lineObj);if(context=="local"){yOff+=paddingTop(cm.display)}else{yOff-=cm.display.viewOffset}if(context=="page"||context=="window"){var lOff=cm.display.lineSpace.getBoundingClientRect();yOff+=lOff.top+(context=="window"?0:pageScrollY());var xOff=lOff.left+(context=="window"?0:pageScrollX());rect.left+=xOff;rect.right+=xOff}rect.top+=yOff;rect.bottom+=yOff;return rect}function fromCoordSystem(cm,coords,context){if(context=="div"){return coords}var left=coords.left,top=coords.top;if(context=="page"){left-=pageScrollX();top-=pageScrollY()}else if(context=="local"||!context){var localBox=cm.display.sizer.getBoundingClientRect();left+=localBox.left;top+=localBox.top}var lineSpaceBox=cm.display.lineSpace.getBoundingClientRect();return{left:left-lineSpaceBox.left,top:top-lineSpaceBox.top}}function charCoords(cm,pos,context,lineObj,bias){if(!lineObj){lineObj=getLine(cm.doc,pos.line)}return intoCoordSystem(cm,lineObj,measureChar(cm,lineObj,pos.ch,bias),context)}function cursorCoords(cm,pos,context,lineObj,preparedMeasure,varHeight){lineObj=lineObj||getLine(cm.doc,pos.line);if(!preparedMeasure){preparedMeasure=prepareMeasureForLine(cm,lineObj)}function get(ch,right){var m=measureCharPrepared(cm,preparedMeasure,ch,right?"right":"left",varHeight);if(right){m.left=m.right}else{m.right=m.left}return intoCoordSystem(cm,lineObj,m,context)}var order=getOrder(lineObj,cm.doc.direction),ch=pos.ch,sticky=pos.sticky;if(ch>=lineObj.text.length){ch=lineObj.text.length;sticky="before"}else if(ch<=0){ch=0;sticky="after"}if(!order){return get(sticky=="before"?ch-1:ch,sticky=="before")}function getBidi(ch,partPos,invert){var part=order[partPos],right=part.level%2!=0;return get(invert?ch-1:ch,right!=invert)}var partPos=getBidiPartAt(order,ch,sticky);var other=bidiOther;var val=getBidi(ch,partPos,sticky=="before");if(other!=null){val.other=getBidi(ch,other,sticky!="before")}return val}function estimateCoords(cm,pos){var left=0;pos=clipPos(cm.doc,pos);if(!cm.options.lineWrapping){left=charWidth(cm.display)*pos.ch}var lineObj=getLine(cm.doc,pos.line);var top=heightAtLine(lineObj)+paddingTop(cm.display);return{left:left,right:left,top:top,bottom:top+lineObj.height}}function PosWithInfo(line,ch,sticky,outside,xRel){var pos=Pos(line,ch,sticky);pos.xRel=xRel;if(outside){pos.outside=true}return pos}function coordsChar(cm,x,y){var doc=cm.doc;y+=cm.display.viewOffset;if(y<0){return PosWithInfo(doc.first,0,null,true,-1)}var lineN=lineAtHeight(doc,y),last=doc.first+doc.size-1;if(lineN>last){return PosWithInfo(doc.first+doc.size-1,getLine(doc,last).text.length,null,true,1)}if(x<0){x=0}var lineObj=getLine(doc,lineN);for(;;){var found=coordsCharInner(cm,lineObj,lineN,x,y);var merged=collapsedSpanAtEnd(lineObj);var mergedPos=merged&&merged.find(0,true);if(merged&&(found.ch>mergedPos.from.ch||found.ch==mergedPos.from.ch&&found.xRel>0)){lineN=lineNo(lineObj=mergedPos.to.line)}else{return found}}}function wrappedLineExtent(cm,lineObj,preparedMeasure,y){var measure=function(ch){return intoCoordSystem(cm,lineObj,measureCharPrepared(cm,preparedMeasure,ch),"line")};var end=lineObj.text.length;var begin=findFirst(function(ch){return measure(ch-1).bottom<=y},end,0);end=findFirst(function(ch){return measure(ch).top>y},begin,end);return{begin:begin,end:end}}function wrappedLineExtentChar(cm,lineObj,preparedMeasure,target){var targetTop=intoCoordSystem(cm,lineObj,measureCharPrepared(cm,preparedMeasure,target),"line").top;return wrappedLineExtent(cm,lineObj,preparedMeasure,targetTop)}function coordsCharInner(cm,lineObj,lineNo$$1,x,y){y-=heightAtLine(lineObj);var begin=0,end=lineObj.text.length;var preparedMeasure=prepareMeasureForLine(cm,lineObj);var pos;var order=getOrder(lineObj,cm.doc.direction);if(order){if(cm.options.lineWrapping){var assign;assign=wrappedLineExtent(cm,lineObj,preparedMeasure,y),begin=assign.begin,end=assign.end,assign}pos=new Pos(lineNo$$1,Math.floor(begin+(end-begin)/2));var beginLeft=cursorCoords(cm,pos,"line",lineObj,preparedMeasure).left;var dir=beginLeft<x?1:-1;var prevDiff,diff=beginLeft-x,prevPos;var steps=Math.ceil((end-begin)/4);outer:do{prevDiff=diff;prevPos=pos;var i=0;for(;i<steps;++i){var prevPos$1=pos;pos=moveVisually(cm,lineObj,pos,dir);if(pos==null||pos.ch<begin||end<=(pos.sticky=="before"?pos.ch-1:pos.ch)){pos=prevPos$1;break outer}}diff=cursorCoords(cm,pos,"line",lineObj,preparedMeasure).left-x;if(steps>1){var diff_change_per_step=Math.abs(diff-prevDiff)/steps;steps=Math.min(steps,Math.ceil(Math.abs(diff)/diff_change_per_step));dir=diff<0?1:-1}}while(diff!=0&&(steps>1||dir<0!=diff<0&&Math.abs(diff)<=Math.abs(prevDiff)));if(Math.abs(diff)>Math.abs(prevDiff)){if(diff<0==prevDiff<0){throw new Error("Broke out of infinite loop in coordsCharInner")}pos=prevPos}}else{var ch=findFirst(function(ch){var box=intoCoordSystem(cm,lineObj,measureCharPrepared(cm,preparedMeasure,ch),"line");if(box.top>y){end=Math.min(ch,end);return true}else if(box.bottom<=y){return false}else if(box.left>x){return true}else if(box.right<x){return false}else{return x-box.left<box.right-x}},begin,end);ch=skipExtendingChars(lineObj.text,ch,1);pos=new Pos(lineNo$$1,ch,ch==end?"before":"after")}var coords=cursorCoords(cm,pos,"line",lineObj,preparedMeasure);if(y<coords.top||coords.bottom<y){pos.outside=true}pos.xRel=x<coords.left?-1:x>coords.right?1:0;return pos}var measureText;function textHeight(display){if(display.cachedTextHeight!=null){return display.cachedTextHeight}if(measureText==null){measureText=elt("pre");for(var i=0;i<49;++i){measureText.appendChild(document.createTextNode("x"));measureText.appendChild(elt("br"))}measureText.appendChild(document.createTextNode("x"))}removeChildrenAndAdd(display.measure,measureText);var height=measureText.offsetHeight/50;if(height>3){display.cachedTextHeight=height}removeChildren(display.measure);return height||1}function charWidth(display){if(display.cachedCharWidth!=null){return display.cachedCharWidth}var anchor=elt("span","xxxxxxxxxx");var pre=elt("pre",[anchor]);removeChildrenAndAdd(display.measure,pre);var rect=anchor.getBoundingClientRect(),width=(rect.right-rect.left)/10;if(width>2){display.cachedCharWidth=width}return width||10}function getDimensions(cm){var d=cm.display,left={},width={};var gutterLeft=d.gutters.clientLeft;for(var n=d.gutters.firstChild,i=0;n;n=n.nextSibling,++i){left[cm.options.gutters[i]]=n.offsetLeft+n.clientLeft+gutterLeft;width[cm.options.gutters[i]]=n.clientWidth}return{fixedPos:compensateForHScroll(d),gutterTotalWidth:d.gutters.offsetWidth,gutterLeft:left,gutterWidth:width,wrapperWidth:d.wrapper.clientWidth}}function compensateForHScroll(display){return display.scroller.getBoundingClientRect().left-display.sizer.getBoundingClientRect().left}function estimateHeight(cm){var th=textHeight(cm.display),wrapping=cm.options.lineWrapping;var perLine=wrapping&&Math.max(5,cm.display.scroller.clientWidth/charWidth(cm.display)-3);return function(line){if(lineIsHidden(cm.doc,line)){return 0}var widgetsHeight=0;if(line.widgets){for(var i=0;i<line.widgets.length;i++){if(line.widgets[i].height){widgetsHeight+=line.widgets[i].height}}}if(wrapping){return widgetsHeight+(Math.ceil(line.text.length/perLine)||1)*th}else{return widgetsHeight+th}}}function estimateLineHeights(cm){var doc=cm.doc,est=estimateHeight(cm);doc.iter(function(line){var estHeight=est(line);if(estHeight!=line.height){updateLineHeight(line,estHeight)}})}function posFromMouse(cm,e,liberal,forRect){var display=cm.display;if(!liberal&&e_target(e).getAttribute("cm-not-content")=="true"){return null}var x,y,space=display.lineSpace.getBoundingClientRect();try{x=e.clientX-space.left;y=e.clientY-space.top}catch(e){return null}var coords=coordsChar(cm,x,y),line;if(forRect&&coords.xRel==1&&(line=getLine(cm.doc,coords.line).text).length==coords.ch){var colDiff=countColumn(line,line.length,cm.options.tabSize)-line.length;coords=Pos(coords.line,Math.max(0,Math.round((x-paddingH(cm.display).left)/charWidth(cm.display))-colDiff))}return coords}function findViewIndex(cm,n){if(n>=cm.display.viewTo){return null}n-=cm.display.viewFrom;if(n<0){return null}var view=cm.display.view;for(var i=0;i<view.length;i++){n-=view[i].size;if(n<0){return i}}}function updateSelection(cm){cm.display.input.showSelection(cm.display.input.prepareSelection())}function prepareSelection(cm,primary){var doc=cm.doc,result={};var curFragment=result.cursors=document.createDocumentFragment();var selFragment=result.selection=document.createDocumentFragment();for(var i=0;i<doc.sel.ranges.length;i++){if(primary===false&&i==doc.sel.primIndex){continue}var range$$1=doc.sel.ranges[i];if(range$$1.from().line>=cm.display.viewTo||range$$1.to().line<cm.display.viewFrom){continue}var collapsed=range$$1.empty();if(collapsed||cm.options.showCursorWhenSelecting){drawSelectionCursor(cm,range$$1.head,curFragment)}if(!collapsed){drawSelectionRange(cm,range$$1,selFragment)}}return result}function drawSelectionCursor(cm,head,output){var pos=cursorCoords(cm,head,"div",null,null,!cm.options.singleCursorHeightPerLine);var cursor=output.appendChild(elt("div"," ","CodeMirror-cursor"));cursor.style.left=pos.left+"px";cursor.style.top=pos.top+"px";cursor.style.height=Math.max(0,pos.bottom-pos.top)*cm.options.cursorHeight+"px";if(pos.other){var otherCursor=output.appendChild(elt("div"," ","CodeMirror-cursor CodeMirror-secondarycursor"));otherCursor.style.display="";otherCursor.style.left=pos.other.left+"px";otherCursor.style.top=pos.other.top+"px";otherCursor.style.height=(pos.other.bottom-pos.other.top)*.85+"px"}}function drawSelectionRange(cm,range$$1,output){var display=cm.display,doc=cm.doc;var fragment=document.createDocumentFragment();var padding=paddingH(cm.display),leftSide=padding.left;var rightSide=Math.max(display.sizerWidth,displayWidth(cm)-display.sizer.offsetLeft)-padding.right;function add(left,top,width,bottom){if(top<0){top=0}top=Math.round(top);bottom=Math.round(bottom);fragment.appendChild(elt("div",null,"CodeMirror-selected","position: absolute; left: "+left+"px;\n                             top: "+top+"px; width: "+(width==null?rightSide-left:width)+"px;\n                             height: "+(bottom-top)+"px"))}function drawForLine(line,fromArg,toArg){var lineObj=getLine(doc,line);var lineLen=lineObj.text.length;var start,end;function coords(ch,bias){return charCoords(cm,Pos(line,ch),"div",lineObj,bias)}iterateBidiSections(getOrder(lineObj,doc.direction),fromArg||0,toArg==null?lineLen:toArg,function(from,to,dir){var leftPos=coords(from,"left"),rightPos,left,right;if(from==to){rightPos=leftPos;left=right=leftPos.left}else{rightPos=coords(to-1,"right");if(dir=="rtl"){var tmp=leftPos;leftPos=rightPos;rightPos=tmp}left=leftPos.left;right=rightPos.right}if(fromArg==null&&from==0){left=leftSide}if(rightPos.top-leftPos.top>3){add(left,leftPos.top,null,leftPos.bottom);left=leftSide;if(leftPos.bottom<rightPos.top){add(left,leftPos.bottom,null,rightPos.top)}}if(toArg==null&&to==lineLen){right=rightSide}if(!start||leftPos.top<start.top||leftPos.top==start.top&&leftPos.left<start.left){start=leftPos}if(!end||rightPos.bottom>end.bottom||rightPos.bottom==end.bottom&&rightPos.right>end.right){end=rightPos}if(left<leftSide+1){left=leftSide}add(left,rightPos.top,right-left,rightPos.bottom)});return{start:start,end:end}}var sFrom=range$$1.from(),sTo=range$$1.to();if(sFrom.line==sTo.line){drawForLine(sFrom.line,sFrom.ch,sTo.ch)}else{var fromLine=getLine(doc,sFrom.line),toLine=getLine(doc,sTo.line);var singleVLine=visualLine(fromLine)==visualLine(toLine);var leftEnd=drawForLine(sFrom.line,sFrom.ch,singleVLine?fromLine.text.length+1:null).end;var rightStart=drawForLine(sTo.line,singleVLine?0:null,sTo.ch).start;if(singleVLine){if(leftEnd.top<rightStart.top-2){add(leftEnd.right,leftEnd.top,null,leftEnd.bottom);add(leftSide,rightStart.top,rightStart.left,rightStart.bottom)}else{add(leftEnd.right,leftEnd.top,rightStart.left-leftEnd.right,leftEnd.bottom)}}if(leftEnd.bottom<rightStart.top){add(leftSide,leftEnd.bottom,null,rightStart.top)}}output.appendChild(fragment)}function restartBlink(cm){if(!cm.state.focused){return}var display=cm.display;clearInterval(display.blinker);var on=true;display.cursorDiv.style.visibility="";if(cm.options.cursorBlinkRate>0){display.blinker=setInterval(function(){return display.cursorDiv.style.visibility=(on=!on)?"":"hidden"},cm.options.cursorBlinkRate)}else if(cm.options.cursorBlinkRate<0){display.cursorDiv.style.visibility="hidden"}}function ensureFocus(cm){if(!cm.state.focused){cm.display.input.focus();onFocus(cm)}}function delayBlurEvent(cm){cm.state.delayingBlurEvent=true;setTimeout(function(){if(cm.state.delayingBlurEvent){cm.state.delayingBlurEvent=false;onBlur(cm)}},100)}function onFocus(cm,e){if(cm.state.delayingBlurEvent){cm.state.delayingBlurEvent=false}if(cm.options.readOnly=="nocursor"){return}if(!cm.state.focused){signal(cm,"focus",cm,e);cm.state.focused=true;addClass(cm.display.wrapper,"CodeMirror-focused");if(!cm.curOp&&cm.display.selForContextMenu!=cm.doc.sel){cm.display.input.reset();if(webkit){setTimeout(function(){return cm.display.input.reset(true)},20)}}cm.display.input.receivedFocus()}restartBlink(cm)}function onBlur(cm,e){if(cm.state.delayingBlurEvent){return}if(cm.state.focused){signal(cm,"blur",cm,e);cm.state.focused=false;rmClass(cm.display.wrapper,"CodeMirror-focused")}clearInterval(cm.display.blinker);setTimeout(function(){if(!cm.state.focused){cm.display.shift=false}},150)}function updateHeightsInViewport(cm){var display=cm.display;var prevBottom=display.lineDiv.offsetTop;for(var i=0;i<display.view.length;i++){var cur=display.view[i],height=void 0;if(cur.hidden){continue}if(ie&&ie_version<8){var bot=cur.node.offsetTop+cur.node.offsetHeight;height=bot-prevBottom;prevBottom=bot}else{var box=cur.node.getBoundingClientRect();height=box.bottom-box.top}var diff=cur.line.height-height;if(height<2){height=textHeight(display)}if(diff>.005||diff<-.005){updateLineHeight(cur.line,height);updateWidgetHeight(cur.line);if(cur.rest){for(var j=0;j<cur.rest.length;j++){updateWidgetHeight(cur.rest[j])}}}}}function updateWidgetHeight(line){if(line.widgets){for(var i=0;i<line.widgets.length;++i){line.widgets[i].height=line.widgets[i].node.parentNode.offsetHeight}}}function visibleLines(display,doc,viewport){var top=viewport&&viewport.top!=null?Math.max(0,viewport.top):display.scroller.scrollTop;top=Math.floor(top-paddingTop(display));var bottom=viewport&&viewport.bottom!=null?viewport.bottom:top+display.wrapper.clientHeight;var from=lineAtHeight(doc,top),to=lineAtHeight(doc,bottom);if(viewport&&viewport.ensure){var ensureFrom=viewport.ensure.from.line,ensureTo=viewport.ensure.to.line;if(ensureFrom<from){from=ensureFrom;to=lineAtHeight(doc,heightAtLine(getLine(doc,ensureFrom))+display.wrapper.clientHeight)}else if(Math.min(ensureTo,doc.lastLine())>=to){from=lineAtHeight(doc,heightAtLine(getLine(doc,ensureTo))-display.wrapper.clientHeight);to=ensureTo}}return{from:from,to:Math.max(to,from+1)}}function alignHorizontally(cm){var display=cm.display,view=display.view;if(!display.alignWidgets&&(!display.gutters.firstChild||!cm.options.fixedGutter)){return}var comp=compensateForHScroll(display)-display.scroller.scrollLeft+cm.doc.scrollLeft;var gutterW=display.gutters.offsetWidth,left=comp+"px";for(var i=0;i<view.length;i++){if(!view[i].hidden){if(cm.options.fixedGutter){if(view[i].gutter){view[i].gutter.style.left=left}if(view[i].gutterBackground){view[i].gutterBackground.style.left=left}}var align=view[i].alignable;if(align){for(var j=0;j<align.length;j++){align[j].style.left=left}}}}if(cm.options.fixedGutter){display.gutters.style.left=comp+gutterW+"px"}}function maybeUpdateLineNumberWidth(cm){if(!cm.options.lineNumbers){return false}var doc=cm.doc,last=lineNumberFor(cm.options,doc.first+doc.size-1),display=cm.display;if(last.length!=display.lineNumChars){var test=display.measure.appendChild(elt("div",[elt("div",last)],"CodeMirror-linenumber CodeMirror-gutter-elt"));var innerW=test.firstChild.offsetWidth,padding=test.offsetWidth-innerW;display.lineGutter.style.width="";display.lineNumInnerWidth=Math.max(innerW,display.lineGutter.offsetWidth-padding)+1;display.lineNumWidth=display.lineNumInnerWidth+padding;display.lineNumChars=display.lineNumInnerWidth?last.length:-1;display.lineGutter.style.width=display.lineNumWidth+"px";updateGutterSpace(cm);return true}return false}function maybeScrollWindow(cm,rect){if(signalDOMEvent(cm,"scrollCursorIntoView")){return}var display=cm.display,box=display.sizer.getBoundingClientRect(),doScroll=null;if(rect.top+box.top<0){doScroll=true}else if(rect.bottom+box.top>(window.innerHeight||document.documentElement.clientHeight)){doScroll=false}if(doScroll!=null&&!phantom){var scrollNode=elt("div","​",null,"position: absolute;\n                         top: "+(rect.top-display.viewOffset-paddingTop(cm.display))+"px;\n                         height: "+(rect.bottom-rect.top+scrollGap(cm)+display.barHeight)+"px;\n                         left: "+rect.left+"px; width: "+Math.max(2,rect.right-rect.left)+"px;");cm.display.lineSpace.appendChild(scrollNode);scrollNode.scrollIntoView(doScroll);cm.display.lineSpace.removeChild(scrollNode)}}function scrollPosIntoView(cm,pos,end,margin){if(margin==null){margin=0}var rect;if(!cm.options.lineWrapping&&pos==end){pos=pos.ch?Pos(pos.line,pos.sticky=="before"?pos.ch-1:pos.ch,"after"):pos;end=pos.sticky=="before"?Pos(pos.line,pos.ch+1,"before"):pos}for(var limit=0;limit<5;limit++){var changed=false;var coords=cursorCoords(cm,pos);var endCoords=!end||end==pos?coords:cursorCoords(cm,end);rect={left:Math.min(coords.left,endCoords.left),top:Math.min(coords.top,endCoords.top)-margin,right:Math.max(coords.left,endCoords.left),bottom:Math.max(coords.bottom,endCoords.bottom)+margin};var scrollPos=calculateScrollPos(cm,rect);var startTop=cm.doc.scrollTop,startLeft=cm.doc.scrollLeft;if(scrollPos.scrollTop!=null){updateScrollTop(cm,scrollPos.scrollTop);if(Math.abs(cm.doc.scrollTop-startTop)>1){changed=true}}if(scrollPos.scrollLeft!=null){setScrollLeft(cm,scrollPos.scrollLeft);if(Math.abs(cm.doc.scrollLeft-startLeft)>1){changed=true}}if(!changed){break}}return rect}function scrollIntoView(cm,rect){var scrollPos=calculateScrollPos(cm,rect);if(scrollPos.scrollTop!=null){updateScrollTop(cm,scrollPos.scrollTop)}if(scrollPos.scrollLeft!=null){setScrollLeft(cm,scrollPos.scrollLeft)}}function calculateScrollPos(cm,rect){var display=cm.display,snapMargin=textHeight(cm.display);if(rect.top<0){rect.top=0}var screentop=cm.curOp&&cm.curOp.scrollTop!=null?cm.curOp.scrollTop:display.scroller.scrollTop;var screen=displayHeight(cm),result={};if(rect.bottom-rect.top>screen){rect.bottom=rect.top+screen}var docBottom=cm.doc.height+paddingVert(display);var atTop=rect.top<snapMargin,atBottom=rect.bottom>docBottom-snapMargin;if(rect.top<screentop){result.scrollTop=atTop?0:rect.top}else if(rect.bottom>screentop+screen){var newTop=Math.min(rect.top,(atBottom?docBottom:rect.bottom)-screen);if(newTop!=screentop){result.scrollTop=newTop}}var screenleft=cm.curOp&&cm.curOp.scrollLeft!=null?cm.curOp.scrollLeft:display.scroller.scrollLeft;var screenw=displayWidth(cm)-(cm.options.fixedGutter?display.gutters.offsetWidth:0);var tooWide=rect.right-rect.left>screenw;if(tooWide){rect.right=rect.left+screenw}if(rect.left<10){result.scrollLeft=0}else if(rect.left<screenleft){result.scrollLeft=Math.max(0,rect.left-(tooWide?0:10))}else if(rect.right>screenw+screenleft-3){result.scrollLeft=rect.right+(tooWide?0:10)-screenw}return result}function addToScrollTop(cm,top){if(top==null){return}resolveScrollToPos(cm);cm.curOp.scrollTop=(cm.curOp.scrollTop==null?cm.doc.scrollTop:cm.curOp.scrollTop)+top}function ensureCursorVisible(cm){resolveScrollToPos(cm);var cur=cm.getCursor();cm.curOp.scrollToPos={from:cur,to:cur,margin:cm.options.cursorScrollMargin}}function scrollToCoords(cm,x,y){if(x!=null||y!=null){resolveScrollToPos(cm)}if(x!=null){cm.curOp.scrollLeft=x}if(y!=null){cm.curOp.scrollTop=y}}function scrollToRange(cm,range$$1){resolveScrollToPos(cm);cm.curOp.scrollToPos=range$$1}function resolveScrollToPos(cm){var range$$1=cm.curOp.scrollToPos;if(range$$1){cm.curOp.scrollToPos=null;var from=estimateCoords(cm,range$$1.from),to=estimateCoords(cm,range$$1.to);scrollToCoordsRange(cm,from,to,range$$1.margin)}}function scrollToCoordsRange(cm,from,to,margin){var sPos=calculateScrollPos(cm,{left:Math.min(from.left,to.left),top:Math.min(from.top,to.top)-margin,right:Math.max(from.right,to.right),bottom:Math.max(from.bottom,to.bottom)+margin});scrollToCoords(cm,sPos.scrollLeft,sPos.scrollTop)}function updateScrollTop(cm,val){if(Math.abs(cm.doc.scrollTop-val)<2){return}if(!gecko){updateDisplaySimple(cm,{top:val})}setScrollTop(cm,val,true);if(gecko){updateDisplaySimple(cm)}startWorker(cm,100)}function setScrollTop(cm,val,forceScroll){val=Math.min(cm.display.scroller.scrollHeight-cm.display.scroller.clientHeight,val);if(cm.display.scroller.scrollTop==val&&!forceScroll){return}cm.doc.scrollTop=val;cm.display.scrollbars.setScrollTop(val);if(cm.display.scroller.scrollTop!=val){cm.display.scroller.scrollTop=val}}function setScrollLeft(cm,val,isScroller,forceScroll){val=Math.min(val,cm.display.scroller.scrollWidth-cm.display.scroller.clientWidth);if((isScroller?val==cm.doc.scrollLeft:Math.abs(cm.doc.scrollLeft-val)<2)&&!forceScroll){return}cm.doc.scrollLeft=val;alignHorizontally(cm);if(cm.display.scroller.scrollLeft!=val){cm.display.scroller.scrollLeft=val}cm.display.scrollbars.setScrollLeft(val)}function measureForScrollbars(cm){var d=cm.display,gutterW=d.gutters.offsetWidth;var docH=Math.round(cm.doc.height+paddingVert(cm.display));return{clientHeight:d.scroller.clientHeight,viewHeight:d.wrapper.clientHeight,scrollWidth:d.scroller.scrollWidth,clientWidth:d.scroller.clientWidth,viewWidth:d.wrapper.clientWidth,barLeft:cm.options.fixedGutter?gutterW:0,docHeight:docH,scrollHeight:docH+scrollGap(cm)+d.barHeight,nativeBarWidth:d.nativeBarWidth,gutterWidth:gutterW}}var NativeScrollbars=function(place,scroll,cm){this.cm=cm;var vert=this.vert=elt("div",[elt("div",null,null,"min-width: 1px")],"CodeMirror-vscrollbar");var horiz=this.horiz=elt("div",[elt("div",null,null,"height: 100%; min-height: 1px")],"CodeMirror-hscrollbar");place(vert);place(horiz);on(vert,"scroll",function(){if(vert.clientHeight){scroll(vert.scrollTop,"vertical")}});on(horiz,"scroll",function(){if(horiz.clientWidth){scroll(horiz.scrollLeft,"horizontal")}});this.checkedZeroWidth=false;if(ie&&ie_version<8){this.horiz.style.minHeight=this.vert.style.minWidth="18px"}};NativeScrollbars.prototype.update=function(measure){var needsH=measure.scrollWidth>measure.clientWidth+1;var needsV=measure.scrollHeight>measure.clientHeight+1;var sWidth=measure.nativeBarWidth;if(needsV){this.vert.style.display="block";this.vert.style.bottom=needsH?sWidth+"px":"0";var totalHeight=measure.viewHeight-(needsH?sWidth:0);this.vert.firstChild.style.height=Math.max(0,measure.scrollHeight-measure.clientHeight+totalHeight)+"px"}else{this.vert.style.display="";this.vert.firstChild.style.height="0"}if(needsH){this.horiz.style.display="block";this.horiz.style.right=needsV?sWidth+"px":"0";this.horiz.style.left=measure.barLeft+"px";var totalWidth=measure.viewWidth-measure.barLeft-(needsV?sWidth:0);this.horiz.firstChild.style.width=Math.max(0,measure.scrollWidth-measure.clientWidth+totalWidth)+"px"}else{this.horiz.style.display="";this.horiz.firstChild.style.width="0"}if(!this.checkedZeroWidth&&measure.clientHeight>0){if(sWidth==0){this.zeroWidthHack()}this.checkedZeroWidth=true}return{right:needsV?sWidth:0,bottom:needsH?sWidth:0}};NativeScrollbars.prototype.setScrollLeft=function(pos){if(this.horiz.scrollLeft!=pos){this.horiz.scrollLeft=pos}if(this.disableHoriz){this.enableZeroWidthBar(this.horiz,this.disableHoriz,"horiz")}};NativeScrollbars.prototype.setScrollTop=function(pos){if(this.vert.scrollTop!=pos){this.vert.scrollTop=pos}if(this.disableVert){this.enableZeroWidthBar(this.vert,this.disableVert,"vert")}};NativeScrollbars.prototype.zeroWidthHack=function(){var w=mac&&!mac_geMountainLion?"12px":"18px";this.horiz.style.height=this.vert.style.width=w;this.horiz.style.pointerEvents=this.vert.style.pointerEvents="none";this.disableHoriz=new Delayed;this.disableVert=new Delayed};NativeScrollbars.prototype.enableZeroWidthBar=function(bar,delay,type){bar.style.pointerEvents="auto";function maybeDisable(){var box=bar.getBoundingClientRect();var elt$$1=type=="vert"?document.elementFromPoint(box.right-1,(box.top+box.bottom)/2):document.elementFromPoint((box.right+box.left)/2,box.bottom-1);if(elt$$1!=bar){bar.style.pointerEvents="none"}else{delay.set(1e3,maybeDisable)}}delay.set(1e3,maybeDisable)};NativeScrollbars.prototype.clear=function(){var parent=this.horiz.parentNode;parent.removeChild(this.horiz);parent.removeChild(this.vert)};var NullScrollbars=function(){};NullScrollbars.prototype.update=function(){return{bottom:0,right:0}};NullScrollbars.prototype.setScrollLeft=function(){};NullScrollbars.prototype.setScrollTop=function(){};NullScrollbars.prototype.clear=function(){};function updateScrollbars(cm,measure){if(!measure){measure=measureForScrollbars(cm)}var startWidth=cm.display.barWidth,startHeight=cm.display.barHeight;updateScrollbarsInner(cm,measure);for(var i=0;i<4&&startWidth!=cm.display.barWidth||startHeight!=cm.display.barHeight;i++){if(startWidth!=cm.display.barWidth&&cm.options.lineWrapping){updateHeightsInViewport(cm)}updateScrollbarsInner(cm,measureForScrollbars(cm));startWidth=cm.display.barWidth;startHeight=cm.display.barHeight}}function updateScrollbarsInner(cm,measure){var d=cm.display;var sizes=d.scrollbars.update(measure);d.sizer.style.paddingRight=(d.barWidth=sizes.right)+"px";d.sizer.style.paddingBottom=(d.barHeight=sizes.bottom)+"px";d.heightForcer.style.borderBottom=sizes.bottom+"px solid transparent";if(sizes.right&&sizes.bottom){d.scrollbarFiller.style.display="block";d.scrollbarFiller.style.height=sizes.bottom+"px";d.scrollbarFiller.style.width=sizes.right+"px"}else{d.scrollbarFiller.style.display=""}if(sizes.bottom&&cm.options.coverGutterNextToScrollbar&&cm.options.fixedGutter){d.gutterFiller.style.display="block";d.gutterFiller.style.height=sizes.bottom+"px";d.gutterFiller.style.width=measure.gutterWidth+"px"}else{d.gutterFiller.style.display=""}}var scrollbarModel={native:NativeScrollbars,null:NullScrollbars};function initScrollbars(cm){if(cm.display.scrollbars){cm.display.scrollbars.clear();if(cm.display.scrollbars.addClass){rmClass(cm.display.wrapper,cm.display.scrollbars.addClass)}}cm.display.scrollbars=new scrollbarModel[cm.options.scrollbarStyle](function(node){cm.display.wrapper.insertBefore(node,cm.display.scrollbarFiller);on(node,"mousedown",function(){if(cm.state.focused){setTimeout(function(){return cm.display.input.focus()},0)}});node.setAttribute("cm-not-content","true")},function(pos,axis){if(axis=="horizontal"){setScrollLeft(cm,pos)}else{updateScrollTop(cm,pos)}},cm);if(cm.display.scrollbars.addClass){addClass(cm.display.wrapper,cm.display.scrollbars.addClass)}}var nextOpId=0;function startOperation(cm){cm.curOp={cm:cm,viewChanged:false,startHeight:cm.doc.height,forceUpdate:false,updateInput:null,typing:false,changeObjs:null,cursorActivityHandlers:null,cursorActivityCalled:0,selectionChanged:false,updateMaxLine:false,scrollLeft:null,scrollTop:null,scrollToPos:null,focus:false,id:++nextOpId};pushOperation(cm.curOp)}function endOperation(cm){var op=cm.curOp;finishOperation(op,function(group){for(var i=0;i<group.ops.length;i++){group.ops[i].cm.curOp=null}endOperations(group)})}function endOperations(group){var ops=group.ops;for(var i=0;i<ops.length;i++){endOperation_R1(ops[i])}for(var i$1=0;i$1<ops.length;i$1++){endOperation_W1(ops[i$1])}for(var i$2=0;i$2<ops.length;i$2++){endOperation_R2(ops[i$2])}for(var i$3=0;i$3<ops.length;i$3++){endOperation_W2(ops[i$3])}for(var i$4=0;i$4<ops.length;i$4++){endOperation_finish(ops[i$4])}}function endOperation_R1(op){var cm=op.cm,display=cm.display;maybeClipScrollbars(cm);if(op.updateMaxLine){findMaxLine(cm)}op.mustUpdate=op.viewChanged||op.forceUpdate||op.scrollTop!=null||op.scrollToPos&&(op.scrollToPos.from.line<display.viewFrom||op.scrollToPos.to.line>=display.viewTo)||display.maxLineChanged&&cm.options.lineWrapping;op.update=op.mustUpdate&&new DisplayUpdate(cm,op.mustUpdate&&{top:op.scrollTop,ensure:op.scrollToPos},op.forceUpdate)}function endOperation_W1(op){op.updatedDisplay=op.mustUpdate&&updateDisplayIfNeeded(op.cm,op.update)}function endOperation_R2(op){var cm=op.cm,display=cm.display;if(op.updatedDisplay){updateHeightsInViewport(cm)}op.barMeasure=measureForScrollbars(cm);if(display.maxLineChanged&&!cm.options.lineWrapping){op.adjustWidthTo=measureChar(cm,display.maxLine,display.maxLine.text.length).left+3;cm.display.sizerWidth=op.adjustWidthTo;op.barMeasure.scrollWidth=Math.max(display.scroller.clientWidth,display.sizer.offsetLeft+op.adjustWidthTo+scrollGap(cm)+cm.display.barWidth);op.maxScrollLeft=Math.max(0,display.sizer.offsetLeft+op.adjustWidthTo-displayWidth(cm))}if(op.updatedDisplay||op.selectionChanged){op.preparedSelection=display.input.prepareSelection(op.focus)}}function endOperation_W2(op){var cm=op.cm;if(op.adjustWidthTo!=null){cm.display.sizer.style.minWidth=op.adjustWidthTo+"px";if(op.maxScrollLeft<cm.doc.scrollLeft){setScrollLeft(cm,Math.min(cm.display.scroller.scrollLeft,op.maxScrollLeft),true)}cm.display.maxLineChanged=false}var takeFocus=op.focus&&op.focus==activeElt()&&(!document.hasFocus||document.hasFocus());if(op.preparedSelection){cm.display.input.showSelection(op.preparedSelection,takeFocus)}if(op.updatedDisplay||op.startHeight!=cm.doc.height){updateScrollbars(cm,op.barMeasure)}if(op.updatedDisplay){setDocumentHeight(cm,op.barMeasure)}if(op.selectionChanged){restartBlink(cm)}if(cm.state.focused&&op.updateInput){cm.display.input.reset(op.typing)}if(takeFocus){ensureFocus(op.cm)}}function endOperation_finish(op){var cm=op.cm,display=cm.display,doc=cm.doc;if(op.updatedDisplay){postUpdateDisplay(cm,op.update)}if(display.wheelStartX!=null&&(op.scrollTop!=null||op.scrollLeft!=null||op.scrollToPos)){display.wheelStartX=display.wheelStartY=null}if(op.scrollTop!=null){setScrollTop(cm,op.scrollTop,op.forceScroll)}if(op.scrollLeft!=null){setScrollLeft(cm,op.scrollLeft,true,true)}if(op.scrollToPos){var rect=scrollPosIntoView(cm,clipPos(doc,op.scrollToPos.from),clipPos(doc,op.scrollToPos.to),op.scrollToPos.margin);maybeScrollWindow(cm,rect)}var hidden=op.maybeHiddenMarkers,unhidden=op.maybeUnhiddenMarkers;if(hidden){for(var i=0;i<hidden.length;++i){if(!hidden[i].lines.length){signal(hidden[i],"hide")}}}if(unhidden){for(var i$1=0;i$1<unhidden.length;++i$1){if(unhidden[i$1].lines.length){signal(unhidden[i$1],"unhide")}}}if(display.wrapper.offsetHeight){doc.scrollTop=cm.display.scroller.scrollTop}if(op.changeObjs){signal(cm,"changes",cm,op.changeObjs)}if(op.update){op.update.finish()}}function runInOp(cm,f){if(cm.curOp){return f()}startOperation(cm);try{return f()}finally{endOperation(cm)}}function operation(cm,f){return function(){if(cm.curOp){return f.apply(cm,arguments)}startOperation(cm);try{return f.apply(cm,arguments)}finally{endOperation(cm)}}}function methodOp(f){return function(){if(this.curOp){return f.apply(this,arguments)}startOperation(this);try{return f.apply(this,arguments)}finally{endOperation(this)}}}function docMethodOp(f){return function(){var cm=this.cm;if(!cm||cm.curOp){return f.apply(this,arguments)}startOperation(cm);try{return f.apply(this,arguments)}finally{endOperation(cm)}}}function regChange(cm,from,to,lendiff){if(from==null){from=cm.doc.first}if(to==null){to=cm.doc.first+cm.doc.size}if(!lendiff){lendiff=0}var display=cm.display;if(lendiff&&to<display.viewTo&&(display.updateLineNumbers==null||display.updateLineNumbers>from)){display.updateLineNumbers=from}cm.curOp.viewChanged=true;if(from>=display.viewTo){if(sawCollapsedSpans&&visualLineNo(cm.doc,from)<display.viewTo){resetView(cm)}}else if(to<=display.viewFrom){if(sawCollapsedSpans&&visualLineEndNo(cm.doc,to+lendiff)>display.viewFrom){resetView(cm)}else{display.viewFrom+=lendiff;display.viewTo+=lendiff}}else if(from<=display.viewFrom&&to>=display.viewTo){resetView(cm)}else if(from<=display.viewFrom){var cut=viewCuttingPoint(cm,to,to+lendiff,1);if(cut){display.view=display.view.slice(cut.index);display.viewFrom=cut.lineN;display.viewTo+=lendiff}else{resetView(cm)}}else if(to>=display.viewTo){var cut$1=viewCuttingPoint(cm,from,from,-1);if(cut$1){display.view=display.view.slice(0,cut$1.index);display.viewTo=cut$1.lineN}else{resetView(cm)}}else{var cutTop=viewCuttingPoint(cm,from,from,-1);var cutBot=viewCuttingPoint(cm,to,to+lendiff,1);if(cutTop&&cutBot){display.view=display.view.slice(0,cutTop.index).concat(buildViewArray(cm,cutTop.lineN,cutBot.lineN)).concat(display.view.slice(cutBot.index));display.viewTo+=lendiff}else{resetView(cm)}}var ext=display.externalMeasured;if(ext){if(to<ext.lineN){ext.lineN+=lendiff}else if(from<ext.lineN+ext.size){display.externalMeasured=null}}}function regLineChange(cm,line,type){cm.curOp.viewChanged=true;var display=cm.display,ext=cm.display.externalMeasured;if(ext&&line>=ext.lineN&&line<ext.lineN+ext.size){display.externalMeasured=null}if(line<display.viewFrom||line>=display.viewTo){return}var lineView=display.view[findViewIndex(cm,line)];if(lineView.node==null){return}var arr=lineView.changes||(lineView.changes=[]);if(indexOf(arr,type)==-1){arr.push(type)}}function resetView(cm){cm.display.viewFrom=cm.display.viewTo=cm.doc.first;cm.display.view=[];cm.display.viewOffset=0}function viewCuttingPoint(cm,oldN,newN,dir){var index=findViewIndex(cm,oldN),diff,view=cm.display.view;if(!sawCollapsedSpans||newN==cm.doc.first+cm.doc.size){return{index:index,lineN:newN}}var n=cm.display.viewFrom;for(var i=0;i<index;i++){n+=view[i].size}if(n!=oldN){if(dir>0){if(index==view.length-1){return null}diff=n+view[index].size-oldN;index++}else{diff=n-oldN}oldN+=diff;newN+=diff}while(visualLineNo(cm.doc,newN)!=newN){if(index==(dir<0?0:view.length-1)){return null}newN+=dir*view[index-(dir<0?1:0)].size;index+=dir}return{index:index,lineN:newN}}function adjustView(cm,from,to){var display=cm.display,view=display.view;if(view.length==0||from>=display.viewTo||to<=display.viewFrom){display.view=buildViewArray(cm,from,to);display.viewFrom=from}else{if(display.viewFrom>from){display.view=buildViewArray(cm,from,display.viewFrom).concat(display.view)}else if(display.viewFrom<from){display.view=display.view.slice(findViewIndex(cm,from))}display.viewFrom=from;if(display.viewTo<to){display.view=display.view.concat(buildViewArray(cm,display.viewTo,to))}else if(display.viewTo>to){display.view=display.view.slice(0,findViewIndex(cm,to))}}display.viewTo=to}function countDirtyView(cm){var view=cm.display.view,dirty=0;for(var i=0;i<view.length;i++){var lineView=view[i];if(!lineView.hidden&&(!lineView.node||lineView.changes)){++dirty}}return dirty}function startWorker(cm,time){if(cm.doc.highlightFrontier<cm.display.viewTo){cm.state.highlight.set(time,bind(highlightWorker,cm))}}function highlightWorker(cm){var doc=cm.doc;if(doc.highlightFrontier>=cm.display.viewTo){return}var end=+new Date+cm.options.workTime;var context=getContextBefore(cm,doc.highlightFrontier);var changedLines=[];doc.iter(context.line,Math.min(doc.first+doc.size,cm.display.viewTo+500),function(line){if(context.line>=cm.display.viewFrom){var oldStyles=line.styles;var resetState=line.text.length>cm.options.maxHighlightLength?copyState(doc.mode,context.state):null;var highlighted=highlightLine(cm,line,context,true);if(resetState){context.state=resetState}line.styles=highlighted.styles;var oldCls=line.styleClasses,newCls=highlighted.classes;if(newCls){line.styleClasses=newCls}else if(oldCls){line.styleClasses=null}var ischange=!oldStyles||oldStyles.length!=line.styles.length||oldCls!=newCls&&(!oldCls||!newCls||oldCls.bgClass!=newCls.bgClass||oldCls.textClass!=newCls.textClass);for(var i=0;!ischange&&i<oldStyles.length;++i){ischange=oldStyles[i]!=line.styles[i]}if(ischange){changedLines.push(context.line)}line.stateAfter=context.save();context.nextLine()}else{if(line.text.length<=cm.options.maxHighlightLength){processLine(cm,line.text,context)}line.stateAfter=context.line%5==0?context.save():null;context.nextLine()}if(+new Date>end){startWorker(cm,cm.options.workDelay);return true}});doc.highlightFrontier=context.line;doc.modeFrontier=Math.max(doc.modeFrontier,context.line);if(changedLines.length){runInOp(cm,function(){for(var i=0;i<changedLines.length;i++){regLineChange(cm,changedLines[i],"text")}})}}var DisplayUpdate=function(cm,viewport,force){var display=cm.display;this.viewport=viewport;this.visible=visibleLines(display,cm.doc,viewport);this.editorIsHidden=!display.wrapper.offsetWidth;this.wrapperHeight=display.wrapper.clientHeight;this.wrapperWidth=display.wrapper.clientWidth;this.oldDisplayWidth=displayWidth(cm);this.force=force;this.dims=getDimensions(cm);this.events=[]};DisplayUpdate.prototype.signal=function(emitter,type){if(hasHandler(emitter,type)){this.events.push(arguments)}};DisplayUpdate.prototype.finish=function(){var this$1=this;for(var i=0;i<this.events.length;i++){signal.apply(null,this$1.events[i])}};function maybeClipScrollbars(cm){var display=cm.display;if(!display.scrollbarsClipped&&display.scroller.offsetWidth){display.nativeBarWidth=display.scroller.offsetWidth-display.scroller.clientWidth;display.heightForcer.style.height=scrollGap(cm)+"px";display.sizer.style.marginBottom=-display.nativeBarWidth+"px";display.sizer.style.borderRightWidth=scrollGap(cm)+"px";display.scrollbarsClipped=true}}function selectionSnapshot(cm){if(cm.hasFocus()){return null}var active=activeElt();if(!active||!contains(cm.display.lineDiv,active)){return null}var result={activeElt:active};if(window.getSelection){var sel=window.getSelection();if(sel.anchorNode&&sel.extend&&contains(cm.display.lineDiv,sel.anchorNode)){result.anchorNode=sel.anchorNode;result.anchorOffset=sel.anchorOffset;result.focusNode=sel.focusNode;result.focusOffset=sel.focusOffset}}return result}function restoreSelection(snapshot){if(!snapshot||!snapshot.activeElt||snapshot.activeElt==activeElt()){return}snapshot.activeElt.focus();if(snapshot.anchorNode&&contains(document.body,snapshot.anchorNode)&&contains(document.body,snapshot.focusNode)){var sel=window.getSelection(),range$$1=document.createRange();range$$1.setEnd(snapshot.anchorNode,snapshot.anchorOffset);range$$1.collapse(false);sel.removeAllRanges();sel.addRange(range$$1);sel.extend(snapshot.focusNode,snapshot.focusOffset)}}function updateDisplayIfNeeded(cm,update){var display=cm.display,doc=cm.doc;if(update.editorIsHidden){resetView(cm);return false}if(!update.force&&update.visible.from>=display.viewFrom&&update.visible.to<=display.viewTo&&(display.updateLineNumbers==null||display.updateLineNumbers>=display.viewTo)&&display.renderedView==display.view&&countDirtyView(cm)==0){return false}if(maybeUpdateLineNumberWidth(cm)){resetView(cm);update.dims=getDimensions(cm)}var end=doc.first+doc.size;var from=Math.max(update.visible.from-cm.options.viewportMargin,doc.first);var to=Math.min(end,update.visible.to+cm.options.viewportMargin);if(display.viewFrom<from&&from-display.viewFrom<20){from=Math.max(doc.first,display.viewFrom)}if(display.viewTo>to&&display.viewTo-to<20){to=Math.min(end,display.viewTo)}if(sawCollapsedSpans){from=visualLineNo(cm.doc,from);to=visualLineEndNo(cm.doc,to)}var different=from!=display.viewFrom||to!=display.viewTo||display.lastWrapHeight!=update.wrapperHeight||display.lastWrapWidth!=update.wrapperWidth;adjustView(cm,from,to);display.viewOffset=heightAtLine(getLine(cm.doc,display.viewFrom));cm.display.mover.style.top=display.viewOffset+"px";var toUpdate=countDirtyView(cm);if(!different&&toUpdate==0&&!update.force&&display.renderedView==display.view&&(display.updateLineNumbers==null||display.updateLineNumbers>=display.viewTo)){return false}var selSnapshot=selectionSnapshot(cm);if(toUpdate>4){display.lineDiv.style.display="none"}patchDisplay(cm,display.updateLineNumbers,update.dims);if(toUpdate>4){display.lineDiv.style.display=""}display.renderedView=display.view;restoreSelection(selSnapshot);removeChildren(display.cursorDiv);removeChildren(display.selectionDiv);display.gutters.style.height=display.sizer.style.minHeight=0;if(different){display.lastWrapHeight=update.wrapperHeight;display.lastWrapWidth=update.wrapperWidth;startWorker(cm,400)}display.updateLineNumbers=null;return true}function postUpdateDisplay(cm,update){var viewport=update.viewport;for(var first=true;;first=false){if(!first||!cm.options.lineWrapping||update.oldDisplayWidth==displayWidth(cm)){if(viewport&&viewport.top!=null){viewport={top:Math.min(cm.doc.height+paddingVert(cm.display)-displayHeight(cm),viewport.top)}}update.visible=visibleLines(cm.display,cm.doc,viewport);if(update.visible.from>=cm.display.viewFrom&&update.visible.to<=cm.display.viewTo){break}}if(!updateDisplayIfNeeded(cm,update)){break}updateHeightsInViewport(cm);var barMeasure=measureForScrollbars(cm);updateSelection(cm);updateScrollbars(cm,barMeasure);setDocumentHeight(cm,barMeasure);update.force=false}update.signal(cm,"update",cm);if(cm.display.viewFrom!=cm.display.reportedViewFrom||cm.display.viewTo!=cm.display.reportedViewTo){update.signal(cm,"viewportChange",cm,cm.display.viewFrom,cm.display.viewTo);cm.display.reportedViewFrom=cm.display.viewFrom;cm.display.reportedViewTo=cm.display.viewTo}}function updateDisplaySimple(cm,viewport){var update=new DisplayUpdate(cm,viewport);if(updateDisplayIfNeeded(cm,update)){updateHeightsInViewport(cm);postUpdateDisplay(cm,update);var barMeasure=measureForScrollbars(cm);updateSelection(cm);updateScrollbars(cm,barMeasure);setDocumentHeight(cm,barMeasure);update.finish()}}function patchDisplay(cm,updateNumbersFrom,dims){var display=cm.display,lineNumbers=cm.options.lineNumbers;var container=display.lineDiv,cur=container.firstChild;function rm(node){var next=node.nextSibling;if(webkit&&mac&&cm.display.currentWheelTarget==node){node.style.display="none"}else{node.parentNode.removeChild(node)}return next}var view=display.view,lineN=display.viewFrom;for(var i=0;i<view.length;i++){var lineView=view[i];if(lineView.hidden){}else if(!lineView.node||lineView.node.parentNode!=container){var node=buildLineElement(cm,lineView,lineN,dims);container.insertBefore(node,cur)}else{while(cur!=lineView.node){cur=rm(cur)}var updateNumber=lineNumbers&&updateNumbersFrom!=null&&updateNumbersFrom<=lineN&&lineView.lineNumber;if(lineView.changes){if(indexOf(lineView.changes,"gutter")>-1){updateNumber=false}updateLineForChanges(cm,lineView,lineN,dims)}if(updateNumber){removeChildren(lineView.lineNumber);lineView.lineNumber.appendChild(document.createTextNode(lineNumberFor(cm.options,lineN)))}cur=lineView.node.nextSibling}lineN+=lineView.size}while(cur){cur=rm(cur)}}function updateGutterSpace(cm){var width=cm.display.gutters.offsetWidth;cm.display.sizer.style.marginLeft=width+"px"}function setDocumentHeight(cm,measure){cm.display.sizer.style.minHeight=measure.docHeight+"px";cm.display.heightForcer.style.top=measure.docHeight+"px";cm.display.gutters.style.height=measure.docHeight+cm.display.barHeight+scrollGap(cm)+"px"}function updateGutters(cm){var gutters=cm.display.gutters,specs=cm.options.gutters;removeChildren(gutters);var i=0;for(;i<specs.length;++i){var gutterClass=specs[i];var gElt=gutters.appendChild(elt("div",null,"CodeMirror-gutter "+gutterClass));if(gutterClass=="CodeMirror-linenumbers"){cm.display.lineGutter=gElt;gElt.style.width=(cm.display.lineNumWidth||1)+"px"}}gutters.style.display=i?"":"none";updateGutterSpace(cm)}function setGuttersForLineNumbers(options){var found=indexOf(options.gutters,"CodeMirror-linenumbers");if(found==-1&&options.lineNumbers){options.gutters=options.gutters.concat(["CodeMirror-linenumbers"])}else if(found>-1&&!options.lineNumbers){options.gutters=options.gutters.slice(0);options.gutters.splice(found,1)}}var wheelSamples=0;var wheelPixelsPerUnit=null;if(ie){wheelPixelsPerUnit=-.53}else if(gecko){wheelPixelsPerUnit=15}else if(chrome){wheelPixelsPerUnit=-.7}else if(safari){wheelPixelsPerUnit=-1/3}function wheelEventDelta(e){var dx=e.wheelDeltaX,dy=e.wheelDeltaY;if(dx==null&&e.detail&&e.axis==e.HORIZONTAL_AXIS){dx=e.detail}if(dy==null&&e.detail&&e.axis==e.VERTICAL_AXIS){dy=e.detail}else if(dy==null){dy=e.wheelDelta}return{x:dx,y:dy}}function wheelEventPixels(e){var delta=wheelEventDelta(e);delta.x*=wheelPixelsPerUnit;delta.y*=wheelPixelsPerUnit;return delta}function onScrollWheel(cm,e){var delta=wheelEventDelta(e),dx=delta.x,dy=delta.y;var display=cm.display,scroll=display.scroller;var canScrollX=scroll.scrollWidth>scroll.clientWidth;var canScrollY=scroll.scrollHeight>scroll.clientHeight;if(!(dx&&canScrollX||dy&&canScrollY)){return}if(dy&&mac&&webkit){outer:for(var cur=e.target,view=display.view;cur!=scroll;cur=cur.parentNode){for(var i=0;i<view.length;i++){if(view[i].node==cur){cm.display.currentWheelTarget=cur;break outer}}}}if(dx&&!gecko&&!presto&&wheelPixelsPerUnit!=null){if(dy&&canScrollY){updateScrollTop(cm,Math.max(0,scroll.scrollTop+dy*wheelPixelsPerUnit))}setScrollLeft(cm,Math.max(0,scroll.scrollLeft+dx*wheelPixelsPerUnit));if(!dy||dy&&canScrollY){e_preventDefault(e)}display.wheelStartX=null;return}if(dy&&wheelPixelsPerUnit!=null){var pixels=dy*wheelPixelsPerUnit;var top=cm.doc.scrollTop,bot=top+display.wrapper.clientHeight;if(pixels<0){top=Math.max(0,top+pixels-50)}else{bot=Math.min(cm.doc.height,bot+pixels+50)}updateDisplaySimple(cm,{top:top,bottom:bot})}if(wheelSamples<20){if(display.wheelStartX==null){display.wheelStartX=scroll.scrollLeft;display.wheelStartY=scroll.scrollTop;display.wheelDX=dx;display.wheelDY=dy;setTimeout(function(){if(display.wheelStartX==null){return}var movedX=scroll.scrollLeft-display.wheelStartX;var movedY=scroll.scrollTop-display.wheelStartY;var sample=movedY&&display.wheelDY&&movedY/display.wheelDY||movedX&&display.wheelDX&&movedX/display.wheelDX;display.wheelStartX=display.wheelStartY=null;if(!sample){return}wheelPixelsPerUnit=(wheelPixelsPerUnit*wheelSamples+sample)/(wheelSamples+1);++wheelSamples},200)}else{display.wheelDX+=dx;display.wheelDY+=dy}}}var Selection=function(ranges,primIndex){this.ranges=ranges;this.primIndex=primIndex};Selection.prototype.primary=function(){return this.ranges[this.primIndex]};Selection.prototype.equals=function(other){var this$1=this;if(other==this){return true}if(other.primIndex!=this.primIndex||other.ranges.length!=this.ranges.length){return false}for(var i=0;i<this.ranges.length;i++){var here=this$1.ranges[i],there=other.ranges[i];if(!equalCursorPos(here.anchor,there.anchor)||!equalCursorPos(here.head,there.head)){return false}}return true};Selection.prototype.deepCopy=function(){var this$1=this;var out=[];for(var i=0;i<this.ranges.length;i++){out[i]=new Range(copyPos(this$1.ranges[i].anchor),copyPos(this$1.ranges[i].head))}return new Selection(out,this.primIndex)};Selection.prototype.somethingSelected=function(){var this$1=this;for(var i=0;i<this.ranges.length;i++){if(!this$1.ranges[i].empty()){return true}}return false};Selection.prototype.contains=function(pos,end){var this$1=this;if(!end){end=pos}for(var i=0;i<this.ranges.length;i++){var range=this$1.ranges[i];if(cmp(end,range.from())>=0&&cmp(pos,range.to())<=0){return i}}return-1};var Range=function(anchor,head){this.anchor=anchor;this.head=head};Range.prototype.from=function(){return minPos(this.anchor,this.head)};Range.prototype.to=function(){return maxPos(this.anchor,this.head)};Range.prototype.empty=function(){return this.head.line==this.anchor.line&&this.head.ch==this.anchor.ch};function normalizeSelection(ranges,primIndex){var prim=ranges[primIndex];ranges.sort(function(a,b){return cmp(a.from(),b.from())});primIndex=indexOf(ranges,prim);for(var i=1;i<ranges.length;i++){var cur=ranges[i],prev=ranges[i-1];if(cmp(prev.to(),cur.from())>=0){var from=minPos(prev.from(),cur.from()),to=maxPos(prev.to(),cur.to());var inv=prev.empty()?cur.from()==cur.head:prev.from()==prev.head;if(i<=primIndex){--primIndex}ranges.splice(--i,2,new Range(inv?to:from,inv?from:to))}}return new Selection(ranges,primIndex)}function simpleSelection(anchor,head){return new Selection([new Range(anchor,head||anchor)],0)}function changeEnd(change){if(!change.text){return change.to}return Pos(change.from.line+change.text.length-1,lst(change.text).length+(change.text.length==1?change.from.ch:0))}function adjustForChange(pos,change){if(cmp(pos,change.from)<0){return pos}if(cmp(pos,change.to)<=0){return changeEnd(change)}var line=pos.line+change.text.length-(change.to.line-change.from.line)-1,ch=pos.ch;if(pos.line==change.to.line){ch+=changeEnd(change).ch-change.to.ch}return Pos(line,ch)}function computeSelAfterChange(doc,change){var out=[];for(var i=0;i<doc.sel.ranges.length;i++){var range=doc.sel.ranges[i];out.push(new Range(adjustForChange(range.anchor,change),adjustForChange(range.head,change)))}return normalizeSelection(out,doc.sel.primIndex)}function offsetPos(pos,old,nw){if(pos.line==old.line){return Pos(nw.line,pos.ch-old.ch+nw.ch)}else{return Pos(nw.line+(pos.line-old.line),pos.ch)}}function computeReplacedSel(doc,changes,hint){var out=[];var oldPrev=Pos(doc.first,0),newPrev=oldPrev;for(var i=0;i<changes.length;i++){var change=changes[i];var from=offsetPos(change.from,oldPrev,newPrev);var to=offsetPos(changeEnd(change),oldPrev,newPrev);oldPrev=change.to;newPrev=to;if(hint=="around"){var range=doc.sel.ranges[i],inv=cmp(range.head,range.anchor)<0;out[i]=new Range(inv?to:from,inv?from:to)}else{out[i]=new Range(from,from)}}return new Selection(out,doc.sel.primIndex)}function loadMode(cm){cm.doc.mode=getMode(cm.options,cm.doc.modeOption);resetModeState(cm)}function resetModeState(cm){cm.doc.iter(function(line){if(line.stateAfter){line.stateAfter=null}if(line.styles){line.styles=null}});cm.doc.modeFrontier=cm.doc.highlightFrontier=cm.doc.first;startWorker(cm,100);cm.state.modeGen++;if(cm.curOp){regChange(cm)}}function isWholeLineUpdate(doc,change){return change.from.ch==0&&change.to.ch==0&&lst(change.text)==""&&(!doc.cm||doc.cm.options.wholeLineUpdateBefore)}function updateDoc(doc,change,markedSpans,estimateHeight$$1){function spansFor(n){return markedSpans?markedSpans[n]:null}function update(line,text,spans){updateLine(line,text,spans,estimateHeight$$1);signalLater(line,"change",line,change)}function linesFor(start,end){var result=[];for(var i=start;i<end;++i){result.push(new Line(text[i],spansFor(i),estimateHeight$$1))}return result}var from=change.from,to=change.to,text=change.text;var firstLine=getLine(doc,from.line),lastLine=getLine(doc,to.line);var lastText=lst(text),lastSpans=spansFor(text.length-1),nlines=to.line-from.line;if(change.full){doc.insert(0,linesFor(0,text.length));doc.remove(text.length,doc.size-text.length)}else if(isWholeLineUpdate(doc,change)){var added=linesFor(0,text.length-1);update(lastLine,lastLine.text,lastSpans);if(nlines){doc.remove(from.line,nlines)}if(added.length){doc.insert(from.line,added)}}else if(firstLine==lastLine){if(text.length==1){update(firstLine,firstLine.text.slice(0,from.ch)+lastText+firstLine.text.slice(to.ch),lastSpans)}else{var added$1=linesFor(1,text.length-1);added$1.push(new Line(lastText+firstLine.text.slice(to.ch),lastSpans,estimateHeight$$1));update(firstLine,firstLine.text.slice(0,from.ch)+text[0],spansFor(0));doc.insert(from.line+1,added$1)}}else if(text.length==1){update(firstLine,firstLine.text.slice(0,from.ch)+text[0]+lastLine.text.slice(to.ch),spansFor(0));doc.remove(from.line+1,nlines)}else{update(firstLine,firstLine.text.slice(0,from.ch)+text[0],spansFor(0));update(lastLine,lastText+lastLine.text.slice(to.ch),lastSpans);var added$2=linesFor(1,text.length-1);if(nlines>1){doc.remove(from.line+1,nlines-1)}doc.insert(from.line+1,added$2)}signalLater(doc,"change",doc,change)}function linkedDocs(doc,f,sharedHistOnly){function propagate(doc,skip,sharedHist){if(doc.linked){for(var i=0;i<doc.linked.length;++i){var rel=doc.linked[i];if(rel.doc==skip){continue}var shared=sharedHist&&rel.sharedHist;if(sharedHistOnly&&!shared){continue}f(rel.doc,shared);propagate(rel.doc,doc,shared)}}}propagate(doc,null,true)}function attachDoc(cm,doc){if(doc.cm){throw new Error("This document is already in use.")}cm.doc=doc;doc.cm=cm;estimateLineHeights(cm);loadMode(cm);setDirectionClass(cm);if(!cm.options.lineWrapping){findMaxLine(cm)}cm.options.mode=doc.modeOption;regChange(cm)}function setDirectionClass(cm){(cm.doc.direction=="rtl"?addClass:rmClass)(cm.display.lineDiv,"CodeMirror-rtl")}function directionChanged(cm){runInOp(cm,function(){setDirectionClass(cm);regChange(cm)})}function History(startGen){this.done=[];this.undone=[];this.undoDepth=Infinity;this.lastModTime=this.lastSelTime=0;this.lastOp=this.lastSelOp=null;this.lastOrigin=this.lastSelOrigin=null;this.generation=this.maxGeneration=startGen||1}function historyChangeFromChange(doc,change){var histChange={from:copyPos(change.from),to:changeEnd(change),text:getBetween(doc,change.from,change.to)};attachLocalSpans(doc,histChange,change.from.line,change.to.line+1);linkedDocs(doc,function(doc){return attachLocalSpans(doc,histChange,change.from.line,change.to.line+1)},true);return histChange}function clearSelectionEvents(array){while(array.length){var last=lst(array);if(last.ranges){array.pop()}else{break}}}function lastChangeEvent(hist,force){if(force){clearSelectionEvents(hist.done);return lst(hist.done)}else if(hist.done.length&&!lst(hist.done).ranges){return lst(hist.done)}else if(hist.done.length>1&&!hist.done[hist.done.length-2].ranges){hist.done.pop();return lst(hist.done)}}function addChangeToHistory(doc,change,selAfter,opId){var hist=doc.history;hist.undone.length=0;var time=+new Date,cur;var last;if((hist.lastOp==opId||hist.lastOrigin==change.origin&&change.origin&&(change.origin.charAt(0)=="+"&&doc.cm&&hist.lastModTime>time-doc.cm.options.historyEventDelay||change.origin.charAt(0)=="*"))&&(cur=lastChangeEvent(hist,hist.lastOp==opId))){last=lst(cur.changes);if(cmp(change.from,change.to)==0&&cmp(change.from,last.to)==0){last.to=changeEnd(change)}else{cur.changes.push(historyChangeFromChange(doc,change))}}else{var before=lst(hist.done);if(!before||!before.ranges){pushSelectionToHistory(doc.sel,hist.done)}cur={changes:[historyChangeFromChange(doc,change)],generation:hist.generation};hist.done.push(cur);while(hist.done.length>hist.undoDepth){hist.done.shift();if(!hist.done[0].ranges){hist.done.shift()}}}hist.done.push(selAfter);hist.generation=++hist.maxGeneration;hist.lastModTime=hist.lastSelTime=time;hist.lastOp=hist.lastSelOp=opId;hist.lastOrigin=hist.lastSelOrigin=change.origin;if(!last){signal(doc,"historyAdded")}}function selectionEventCanBeMerged(doc,origin,prev,sel){var ch=origin.charAt(0);return ch=="*"||ch=="+"&&prev.ranges.length==sel.ranges.length&&prev.somethingSelected()==sel.somethingSelected()&&new Date-doc.history.lastSelTime<=(doc.cm?doc.cm.options.historyEventDelay:500)}function addSelectionToHistory(doc,sel,opId,options){var hist=doc.history,origin=options&&options.origin;if(opId==hist.lastSelOp||origin&&hist.lastSelOrigin==origin&&(hist.lastModTime==hist.lastSelTime&&hist.lastOrigin==origin||selectionEventCanBeMerged(doc,origin,lst(hist.done),sel))){hist.done[hist.done.length-1]=sel}else{pushSelectionToHistory(sel,hist.done)}hist.lastSelTime=+new Date;hist.lastSelOrigin=origin;hist.lastSelOp=opId;if(options&&options.clearRedo!==false){clearSelectionEvents(hist.undone)}}function pushSelectionToHistory(sel,dest){var top=lst(dest);if(!(top&&top.ranges&&top.equals(sel))){dest.push(sel)}}function attachLocalSpans(doc,change,from,to){var existing=change["spans_"+doc.id],n=0;doc.iter(Math.max(doc.first,from),Math.min(doc.first+doc.size,to),function(line){if(line.markedSpans){(existing||(existing=change["spans_"+doc.id]={}))[n]=line.markedSpans}++n})}function removeClearedSpans(spans){if(!spans){return null}var out;for(var i=0;i<spans.length;++i){if(spans[i].marker.explicitlyCleared){if(!out){out=spans.slice(0,i)}}else if(out){out.push(spans[i])}}return!out?spans:out.length?out:null}function getOldSpans(doc,change){var found=change["spans_"+doc.id];if(!found){return null}var nw=[];for(var i=0;i<change.text.length;++i){nw.push(removeClearedSpans(found[i]))}return nw}function mergeOldSpans(doc,change){var old=getOldSpans(doc,change);var stretched=stretchSpansOverChange(doc,change);if(!old){return stretched}if(!stretched){return old}for(var i=0;i<old.length;++i){var oldCur=old[i],stretchCur=stretched[i];if(oldCur&&stretchCur){spans:for(var j=0;j<stretchCur.length;++j){var span=stretchCur[j];for(var k=0;k<oldCur.length;++k){if(oldCur[k].marker==span.marker){continue spans}}oldCur.push(span)}}else if(stretchCur){old[i]=stretchCur}}return old}function copyHistoryArray(events,newGroup,instantiateSel){var copy=[];for(var i=0;i<events.length;++i){var event=events[i];if(event.ranges){copy.push(instantiateSel?Selection.prototype.deepCopy.call(event):event);continue}var changes=event.changes,newChanges=[];copy.push({changes:newChanges});for(var j=0;j<changes.length;++j){var change=changes[j],m=void 0;newChanges.push({from:change.from,to:change.to,text:change.text});if(newGroup){for(var prop in change){if(m=prop.match(/^spans_(\d+)$/)){if(indexOf(newGroup,Number(m[1]))>-1){lst(newChanges)[prop]=change[prop];delete change[prop]}}}}}}return copy}function extendRange(range,head,other,extend){if(extend){var anchor=range.anchor;if(other){var posBefore=cmp(head,anchor)<0;if(posBefore!=cmp(other,anchor)<0){anchor=head;head=other}else if(posBefore!=cmp(head,other)<0){head=other}}return new Range(anchor,head)}else{return new Range(other||head,head)}}function extendSelection(doc,head,other,options,extend){if(extend==null){extend=doc.cm&&(doc.cm.display.shift||doc.extend)}setSelection(doc,new Selection([extendRange(doc.sel.primary(),head,other,extend)],0),options)}function extendSelections(doc,heads,options){var out=[];var extend=doc.cm&&(doc.cm.display.shift||doc.extend);for(var i=0;i<doc.sel.ranges.length;i++){out[i]=extendRange(doc.sel.ranges[i],heads[i],null,extend)}var newSel=normalizeSelection(out,doc.sel.primIndex);setSelection(doc,newSel,options)}function replaceOneSelection(doc,i,range,options){var ranges=doc.sel.ranges.slice(0);ranges[i]=range;setSelection(doc,normalizeSelection(ranges,doc.sel.primIndex),options)}function setSimpleSelection(doc,anchor,head,options){setSelection(doc,simpleSelection(anchor,head),options)}function filterSelectionChange(doc,sel,options){var obj={ranges:sel.ranges,update:function(ranges){var this$1=this;this.ranges=[];for(var i=0;i<ranges.length;i++){this$1.ranges[i]=new Range(clipPos(doc,ranges[i].anchor),clipPos(doc,ranges[i].head))}},origin:options&&options.origin};signal(doc,"beforeSelectionChange",doc,obj);if(doc.cm){signal(doc.cm,"beforeSelectionChange",doc.cm,obj)}if(obj.ranges!=sel.ranges){return normalizeSelection(obj.ranges,obj.ranges.length-1)}else{return sel}}function setSelectionReplaceHistory(doc,sel,options){var done=doc.history.done,last=lst(done);if(last&&last.ranges){done[done.length-1]=sel;setSelectionNoUndo(doc,sel,options)}else{setSelection(doc,sel,options)}}function setSelection(doc,sel,options){setSelectionNoUndo(doc,sel,options);addSelectionToHistory(doc,doc.sel,doc.cm?doc.cm.curOp.id:NaN,options)}function setSelectionNoUndo(doc,sel,options){if(hasHandler(doc,"beforeSelectionChange")||doc.cm&&hasHandler(doc.cm,"beforeSelectionChange")){sel=filterSelectionChange(doc,sel,options)}var bias=options&&options.bias||(cmp(sel.primary().head,doc.sel.primary().head)<0?-1:1);setSelectionInner(doc,skipAtomicInSelection(doc,sel,bias,true));if(!(options&&options.scroll===false)&&doc.cm){ensureCursorVisible(doc.cm)}}function setSelectionInner(doc,sel){if(sel.equals(doc.sel)){return}doc.sel=sel;if(doc.cm){doc.cm.curOp.updateInput=doc.cm.curOp.selectionChanged=true;signalCursorActivity(doc.cm)}signalLater(doc,"cursorActivity",doc)}function reCheckSelection(doc){setSelectionInner(doc,skipAtomicInSelection(doc,doc.sel,null,false))}function skipAtomicInSelection(doc,sel,bias,mayClear){var out;for(var i=0;i<sel.ranges.length;i++){var range=sel.ranges[i];var old=sel.ranges.length==doc.sel.ranges.length&&doc.sel.ranges[i];var newAnchor=skipAtomic(doc,range.anchor,old&&old.anchor,bias,mayClear);var newHead=skipAtomic(doc,range.head,old&&old.head,bias,mayClear);if(out||newAnchor!=range.anchor||newHead!=range.head){if(!out){out=sel.ranges.slice(0,i)}out[i]=new Range(newAnchor,newHead)}}return out?normalizeSelection(out,sel.primIndex):sel}function skipAtomicInner(doc,pos,oldPos,dir,mayClear){var line=getLine(doc,pos.line);if(line.markedSpans){for(var i=0;i<line.markedSpans.length;++i){var sp=line.markedSpans[i],m=sp.marker;if((sp.from==null||(m.inclusiveLeft?sp.from<=pos.ch:sp.from<pos.ch))&&(sp.to==null||(m.inclusiveRight?sp.to>=pos.ch:sp.to>pos.ch))){if(mayClear){signal(m,"beforeCursorEnter");if(m.explicitlyCleared){if(!line.markedSpans){break}else{--i;continue}}}if(!m.atomic){continue}if(oldPos){var near=m.find(dir<0?1:-1),diff=void 0;if(dir<0?m.inclusiveRight:m.inclusiveLeft){near=movePos(doc,near,-dir,near&&near.line==pos.line?line:null)}if(near&&near.line==pos.line&&(diff=cmp(near,oldPos))&&(dir<0?diff<0:diff>0)){return skipAtomicInner(doc,near,pos,dir,mayClear)}}var far=m.find(dir<0?-1:1);if(dir<0?m.inclusiveLeft:m.inclusiveRight){far=movePos(doc,far,dir,far.line==pos.line?line:null)}return far?skipAtomicInner(doc,far,pos,dir,mayClear):null}}}return pos}function skipAtomic(doc,pos,oldPos,bias,mayClear){var dir=bias||1;var found=skipAtomicInner(doc,pos,oldPos,dir,mayClear)||!mayClear&&skipAtomicInner(doc,pos,oldPos,dir,true)||skipAtomicInner(doc,pos,oldPos,-dir,mayClear)||!mayClear&&skipAtomicInner(doc,pos,oldPos,-dir,true);if(!found){doc.cantEdit=true;return Pos(doc.first,0)}return found}function movePos(doc,pos,dir,line){if(dir<0&&pos.ch==0){if(pos.line>doc.first){return clipPos(doc,Pos(pos.line-1))}else{return null}}else if(dir>0&&pos.ch==(line||getLine(doc,pos.line)).text.length){if(pos.line<doc.first+doc.size-1){return Pos(pos.line+1,0)}else{return null}}else{return new Pos(pos.line,pos.ch+dir)}}function selectAll(cm){cm.setSelection(Pos(cm.firstLine(),0),Pos(cm.lastLine()),sel_dontScroll)}function filterChange(doc,change,update){var obj={canceled:false,from:change.from,to:change.to,text:change.text,origin:change.origin,cancel:function(){return obj.canceled=true}};if(update){obj.update=function(from,to,text,origin){if(from){obj.from=clipPos(doc,from)}if(to){obj.to=clipPos(doc,to)}if(text){obj.text=text}if(origin!==undefined){obj.origin=origin}}}signal(doc,"beforeChange",doc,obj);if(doc.cm){signal(doc.cm,"beforeChange",doc.cm,obj)}if(obj.canceled){return null}return{from:obj.from,to:obj.to,text:obj.text,origin:obj.origin}}function makeChange(doc,change,ignoreReadOnly){if(doc.cm){if(!doc.cm.curOp){return operation(doc.cm,makeChange)(doc,change,ignoreReadOnly)}if(doc.cm.state.suppressEdits){return}}if(hasHandler(doc,"beforeChange")||doc.cm&&hasHandler(doc.cm,"beforeChange")){change=filterChange(doc,change,true);if(!change){return}}var split=sawReadOnlySpans&&!ignoreReadOnly&&removeReadOnlyRanges(doc,change.from,change.to);if(split){for(var i=split.length-1;i>=0;--i){makeChangeInner(doc,{from:split[i].from,to:split[i].to,text:i?[""]:change.text})}}else{makeChangeInner(doc,change)}}function makeChangeInner(doc,change){if(change.text.length==1&&change.text[0]==""&&cmp(change.from,change.to)==0){return}var selAfter=computeSelAfterChange(doc,change);addChangeToHistory(doc,change,selAfter,doc.cm?doc.cm.curOp.id:NaN);makeChangeSingleDoc(doc,change,selAfter,stretchSpansOverChange(doc,change));var rebased=[];linkedDocs(doc,function(doc,sharedHist){if(!sharedHist&&indexOf(rebased,doc.history)==-1){rebaseHist(doc.history,change);rebased.push(doc.history)}makeChangeSingleDoc(doc,change,null,stretchSpansOverChange(doc,change))})}function makeChangeFromHistory(doc,type,allowSelectionOnly){if(doc.cm&&doc.cm.state.suppressEdits&&!allowSelectionOnly){return}var hist=doc.history,event,selAfter=doc.sel;var source=type=="undo"?hist.done:hist.undone,dest=type=="undo"?hist.undone:hist.done;var i=0;for(;i<source.length;i++){event=source[i];if(allowSelectionOnly?event.ranges&&!event.equals(doc.sel):!event.ranges){break}}if(i==source.length){return}hist.lastOrigin=hist.lastSelOrigin=null;for(;;){event=source.pop();if(event.ranges){pushSelectionToHistory(event,dest);if(allowSelectionOnly&&!event.equals(doc.sel)){setSelection(doc,event,{clearRedo:false});return}selAfter=event}else{break}}var antiChanges=[];pushSelectionToHistory(selAfter,dest);dest.push({changes:antiChanges,generation:hist.generation});hist.generation=event.generation||++hist.maxGeneration;var filter=hasHandler(doc,"beforeChange")||doc.cm&&hasHandler(doc.cm,"beforeChange");var loop=function(i){var change=event.changes[i];change.origin=type;if(filter&&!filterChange(doc,change,false)){source.length=0;return{}}antiChanges.push(historyChangeFromChange(doc,change));var after=i?computeSelAfterChange(doc,change):lst(source);makeChangeSingleDoc(doc,change,after,mergeOldSpans(doc,change));if(!i&&doc.cm){doc.cm.scrollIntoView({from:change.from,to:changeEnd(change)})}var rebased=[];linkedDocs(doc,function(doc,sharedHist){if(!sharedHist&&indexOf(rebased,doc.history)==-1){rebaseHist(doc.history,change);rebased.push(doc.history)}makeChangeSingleDoc(doc,change,null,mergeOldSpans(doc,change))})};for(var i$1=event.changes.length-1;i$1>=0;--i$1){var returned=loop(i$1);if(returned)return returned.v}}function shiftDoc(doc,distance){if(distance==0){return}doc.first+=distance;doc.sel=new Selection(map(doc.sel.ranges,function(range){return new Range(Pos(range.anchor.line+distance,range.anchor.ch),Pos(range.head.line+distance,range.head.ch))}),doc.sel.primIndex);if(doc.cm){regChange(doc.cm,doc.first,doc.first-distance,distance);for(var d=doc.cm.display,l=d.viewFrom;l<d.viewTo;l++){regLineChange(doc.cm,l,"gutter")}}}function makeChangeSingleDoc(doc,change,selAfter,spans){if(doc.cm&&!doc.cm.curOp){return operation(doc.cm,makeChangeSingleDoc)(doc,change,selAfter,spans)}if(change.to.line<doc.first){shiftDoc(doc,change.text.length-1-(change.to.line-change.from.line));return}if(change.from.line>doc.lastLine()){return}if(change.from.line<doc.first){var shift=change.text.length-1-(doc.first-change.from.line);shiftDoc(doc,shift);change={from:Pos(doc.first,0),to:Pos(change.to.line+shift,change.to.ch),text:[lst(change.text)],origin:change.origin}}var last=doc.lastLine();if(change.to.line>last){change={from:change.from,to:Pos(last,getLine(doc,last).text.length),text:[change.text[0]],origin:change.origin}}change.removed=getBetween(doc,change.from,change.to);if(!selAfter){selAfter=computeSelAfterChange(doc,change)}if(doc.cm){makeChangeSingleDocInEditor(doc.cm,change,spans)}else{updateDoc(doc,change,spans)}setSelectionNoUndo(doc,selAfter,sel_dontScroll)}function makeChangeSingleDocInEditor(cm,change,spans){var doc=cm.doc,display=cm.display,from=change.from,to=change.to;var recomputeMaxLength=false,checkWidthStart=from.line;if(!cm.options.lineWrapping){checkWidthStart=lineNo(visualLine(getLine(doc,from.line)));doc.iter(checkWidthStart,to.line+1,function(line){if(line==display.maxLine){recomputeMaxLength=true;return true}})}if(doc.sel.contains(change.from,change.to)>-1){signalCursorActivity(cm)}updateDoc(doc,change,spans,estimateHeight(cm));if(!cm.options.lineWrapping){doc.iter(checkWidthStart,from.line+change.text.length,function(line){var len=lineLength(line);if(len>display.maxLineLength){display.maxLine=line;display.maxLineLength=len;display.maxLineChanged=true;recomputeMaxLength=false}});if(recomputeMaxLength){cm.curOp.updateMaxLine=true}}retreatFrontier(doc,from.line);startWorker(cm,400);var lendiff=change.text.length-(to.line-from.line)-1;if(change.full){regChange(cm)}else if(from.line==to.line&&change.text.length==1&&!isWholeLineUpdate(cm.doc,change)){regLineChange(cm,from.line,"text")}else{regChange(cm,from.line,to.line+1,lendiff)}var changesHandler=hasHandler(cm,"changes"),changeHandler=hasHandler(cm,"change");if(changeHandler||changesHandler){var obj={from:from,to:to,text:change.text,removed:change.removed,origin:change.origin};if(changeHandler){signalLater(cm,"change",cm,obj)}if(changesHandler){(cm.curOp.changeObjs||(cm.curOp.changeObjs=[])).push(obj)}}cm.display.selForContextMenu=null}function replaceRange(doc,code,from,to,origin){if(!to){to=from}if(cmp(to,from)<0){var tmp=to;to=from;from=tmp}if(typeof code=="string"){code=doc.splitLines(code)}makeChange(doc,{from:from,to:to,text:code,origin:origin})}function rebaseHistSelSingle(pos,from,to,diff){if(to<pos.line){pos.line+=diff}else if(from<pos.line){pos.line=from;pos.ch=0}}function rebaseHistArray(array,from,to,diff){for(var i=0;i<array.length;++i){var sub=array[i],ok=true;if(sub.ranges){if(!sub.copied){sub=array[i]=sub.deepCopy();sub.copied=true}for(var j=0;j<sub.ranges.length;j++){rebaseHistSelSingle(sub.ranges[j].anchor,from,to,diff);rebaseHistSelSingle(sub.ranges[j].head,from,to,diff)}continue}for(var j$1=0;j$1<sub.changes.length;++j$1){var cur=sub.changes[j$1];if(to<cur.from.line){cur.from=Pos(cur.from.line+diff,cur.from.ch);cur.to=Pos(cur.to.line+diff,cur.to.ch)}else if(from<=cur.to.line){ok=false;break}}if(!ok){array.splice(0,i+1);i=0}}}function rebaseHist(hist,change){var from=change.from.line,to=change.to.line,diff=change.text.length-(to-from)-1;rebaseHistArray(hist.done,from,to,diff);rebaseHistArray(hist.undone,from,to,diff)}function changeLine(doc,handle,changeType,op){var no=handle,line=handle;if(typeof handle=="number"){line=getLine(doc,clipLine(doc,handle))}else{no=lineNo(handle)}if(no==null){return null}if(op(line,no)&&doc.cm){regLineChange(doc.cm,no,changeType)}return line}function LeafChunk(lines){var this$1=this;this.lines=lines;this.parent=null;var height=0;for(var i=0;i<lines.length;++i){lines[i].parent=this$1;height+=lines[i].height}this.height=height}LeafChunk.prototype={chunkSize:function chunkSize(){return this.lines.length},removeInner:function removeInner(at,n){var this$1=this;for(var i=at,e=at+n;i<e;++i){var line=this$1.lines[i];this$1.height-=line.height;cleanUpLine(line);signalLater(line,"delete")}this.lines.splice(at,n)},collapse:function collapse(lines){lines.push.apply(lines,this.lines)},insertInner:function insertInner(at,lines,height){var this$1=this;this.height+=height;this.lines=this.lines.slice(0,at).concat(lines).concat(this.lines.slice(at));for(var i=0;i<lines.length;++i){lines[i].parent=this$1}},iterN:function iterN(at,n,op){var this$1=this;for(var e=at+n;at<e;++at){if(op(this$1.lines[at])){return true}}}};function BranchChunk(children){var this$1=this;this.children=children;var size=0,height=0;for(var i=0;i<children.length;++i){var ch=children[i];size+=ch.chunkSize();height+=ch.height;ch.parent=this$1}this.size=size;this.height=height;this.parent=null}BranchChunk.prototype={chunkSize:function chunkSize(){return this.size},removeInner:function removeInner(at,n){var this$1=this;this.size-=n;for(var i=0;i<this.children.length;++i){var child=this$1.children[i],sz=child.chunkSize();if(at<sz){var rm=Math.min(n,sz-at),oldHeight=child.height;child.removeInner(at,rm);this$1.height-=oldHeight-child.height;if(sz==rm){this$1.children.splice(i--,1);child.parent=null}if((n-=rm)==0){break}at=0}else{at-=sz}}if(this.size-n<25&&(this.children.length>1||!(this.children[0]instanceof LeafChunk))){var lines=[];this.collapse(lines);this.children=[new LeafChunk(lines)];this.children[0].parent=this}},collapse:function collapse(lines){var this$1=this;for(var i=0;i<this.children.length;++i){this$1.children[i].collapse(lines)}},insertInner:function insertInner(at,lines,height){var this$1=this;this.size+=lines.length;this.height+=height;for(var i=0;i<this.children.length;++i){var child=this$1.children[i],sz=child.chunkSize();if(at<=sz){child.insertInner(at,lines,height);if(child.lines&&child.lines.length>50){var remaining=child.lines.length%25+25;for(var pos=remaining;pos<child.lines.length;){var leaf=new LeafChunk(child.lines.slice(pos,pos+=25));child.height-=leaf.height;this$1.children.splice(++i,0,leaf);leaf.parent=this$1}child.lines=child.lines.slice(0,remaining);this$1.maybeSpill()}break}at-=sz}},maybeSpill:function maybeSpill(){if(this.children.length<=10){return}var me=this;do{var spilled=me.children.splice(me.children.length-5,5);var sibling=new BranchChunk(spilled);if(!me.parent){var copy=new BranchChunk(me.children);copy.parent=me;me.children=[copy,sibling];me=copy}else{me.size-=sibling.size;me.height-=sibling.height;var myIndex=indexOf(me.parent.children,me);me.parent.children.splice(myIndex+1,0,sibling)}sibling.parent=me.parent}while(me.children.length>10);me.parent.maybeSpill()},iterN:function iterN(at,n,op){var this$1=this;for(var i=0;i<this.children.length;++i){var child=this$1.children[i],sz=child.chunkSize();if(at<sz){var used=Math.min(n,sz-at);if(child.iterN(at,used,op)){return true}if((n-=used)==0){break}at=0}else{at-=sz}}}};var LineWidget=function(doc,node,options){var this$1=this;if(options){for(var opt in options){if(options.hasOwnProperty(opt)){this$1[opt]=options[opt]}}}this.doc=doc;this.node=node};LineWidget.prototype.clear=function(){var this$1=this;var cm=this.doc.cm,ws=this.line.widgets,line=this.line,no=lineNo(line);if(no==null||!ws){return}for(var i=0;i<ws.length;++i){if(ws[i]==this$1){ws.splice(i--,1)}}if(!ws.length){line.widgets=null}var height=widgetHeight(this);updateLineHeight(line,Math.max(0,line.height-height));if(cm){runInOp(cm,function(){adjustScrollWhenAboveVisible(cm,line,-height);regLineChange(cm,no,"widget")});signalLater(cm,"lineWidgetCleared",cm,this,no)}};LineWidget.prototype.changed=function(){var this$1=this;var oldH=this.height,cm=this.doc.cm,line=this.line;this.height=null;var diff=widgetHeight(this)-oldH;if(!diff){return}updateLineHeight(line,line.height+diff);if(cm){runInOp(cm,function(){cm.curOp.forceUpdate=true;adjustScrollWhenAboveVisible(cm,line,diff);signalLater(cm,"lineWidgetChanged",cm,this$1,lineNo(line))})}};eventMixin(LineWidget);function adjustScrollWhenAboveVisible(cm,line,diff){if(heightAtLine(line)<(cm.curOp&&cm.curOp.scrollTop||cm.doc.scrollTop)){addToScrollTop(cm,diff)}}function addLineWidget(doc,handle,node,options){var widget=new LineWidget(doc,node,options);var cm=doc.cm;if(cm&&widget.noHScroll){cm.display.alignWidgets=true}changeLine(doc,handle,"widget",function(line){var widgets=line.widgets||(line.widgets=[]);if(widget.insertAt==null){widgets.push(widget)}else{widgets.splice(Math.min(widgets.length-1,Math.max(0,widget.insertAt)),0,widget)}widget.line=line;if(cm&&!lineIsHidden(doc,line)){var aboveVisible=heightAtLine(line)<doc.scrollTop;updateLineHeight(line,line.height+widgetHeight(widget));if(aboveVisible){addToScrollTop(cm,widget.height)}cm.curOp.forceUpdate=true}return true});signalLater(cm,"lineWidgetAdded",cm,widget,typeof handle=="number"?handle:lineNo(handle));return widget}var nextMarkerId=0;var TextMarker=function(doc,type){this.lines=[];this.type=type;this.doc=doc;this.id=++nextMarkerId};TextMarker.prototype.clear=function(){var this$1=this;if(this.explicitlyCleared){return}var cm=this.doc.cm,withOp=cm&&!cm.curOp;if(withOp){startOperation(cm)}if(hasHandler(this,"clear")){var found=this.find();if(found){signalLater(this,"clear",found.from,found.to)}}var min=null,max=null;for(var i=0;i<this.lines.length;++i){var line=this$1.lines[i];var span=getMarkedSpanFor(line.markedSpans,this$1);if(cm&&!this$1.collapsed){regLineChange(cm,lineNo(line),"text")}else if(cm){if(span.to!=null){max=lineNo(line)}if(span.from!=null){min=lineNo(line)}}line.markedSpans=removeMarkedSpan(line.markedSpans,span);if(span.from==null&&this$1.collapsed&&!lineIsHidden(this$1.doc,line)&&cm){updateLineHeight(line,textHeight(cm.display))}}if(cm&&this.collapsed&&!cm.options.lineWrapping){for(var i$1=0;i$1<this.lines.length;++i$1){var visual=visualLine(this$1.lines[i$1]),len=lineLength(visual);if(len>cm.display.maxLineLength){cm.display.maxLine=visual;cm.display.maxLineLength=len;cm.display.maxLineChanged=true}}}if(min!=null&&cm&&this.collapsed){regChange(cm,min,max+1)}this.lines.length=0;this.explicitlyCleared=true;if(this.atomic&&this.doc.cantEdit){this.doc.cantEdit=false;if(cm){reCheckSelection(cm.doc)}}if(cm){signalLater(cm,"markerCleared",cm,this,min,max)}if(withOp){endOperation(cm)}if(this.parent){this.parent.clear()}};TextMarker.prototype.find=function(side,lineObj){var this$1=this;if(side==null&&this.type=="bookmark"){side=1}var from,to;for(var i=0;i<this.lines.length;++i){var line=this$1.lines[i];var span=getMarkedSpanFor(line.markedSpans,this$1);if(span.from!=null){from=Pos(lineObj?line:lineNo(line),span.from);if(side==-1){return from}}if(span.to!=null){to=Pos(lineObj?line:lineNo(line),span.to);if(side==1){return to}}}return from&&{from:from,to:to}};TextMarker.prototype.changed=function(){var this$1=this;var pos=this.find(-1,true),widget=this,cm=this.doc.cm;if(!pos||!cm){return}runInOp(cm,function(){var line=pos.line,lineN=lineNo(pos.line);var view=findViewForLine(cm,lineN);if(view){clearLineMeasurementCacheFor(view);cm.curOp.selectionChanged=cm.curOp.forceUpdate=true}cm.curOp.updateMaxLine=true;if(!lineIsHidden(widget.doc,line)&&widget.height!=null){var oldHeight=widget.height;widget.height=null;var dHeight=widgetHeight(widget)-oldHeight;if(dHeight){updateLineHeight(line,line.height+dHeight)}}signalLater(cm,"markerChanged",cm,this$1)})};TextMarker.prototype.attachLine=function(line){if(!this.lines.length&&this.doc.cm){var op=this.doc.cm.curOp;if(!op.maybeHiddenMarkers||indexOf(op.maybeHiddenMarkers,this)==-1){(op.maybeUnhiddenMarkers||(op.maybeUnhiddenMarkers=[])).push(this)}}this.lines.push(line)};TextMarker.prototype.detachLine=function(line){this.lines.splice(indexOf(this.lines,line),1);if(!this.lines.length&&this.doc.cm){var op=this.doc.cm.curOp;(op.maybeHiddenMarkers||(op.maybeHiddenMarkers=[])).push(this)}};eventMixin(TextMarker);function markText(doc,from,to,options,type){if(options&&options.shared){return markTextShared(doc,from,to,options,type)}if(doc.cm&&!doc.cm.curOp){return operation(doc.cm,markText)(doc,from,to,options,type)}var marker=new TextMarker(doc,type),diff=cmp(from,to);if(options){copyObj(options,marker,false)}if(diff>0||diff==0&&marker.clearWhenEmpty!==false){return marker}if(marker.replacedWith){marker.collapsed=true;marker.widgetNode=eltP("span",[marker.replacedWith],"CodeMirror-widget");if(!options.handleMouseEvents){marker.widgetNode.setAttribute("cm-ignore-events","true")}if(options.insertLeft){marker.widgetNode.insertLeft=true}}if(marker.collapsed){if(conflictingCollapsedRange(doc,from.line,from,to,marker)||from.line!=to.line&&conflictingCollapsedRange(doc,to.line,from,to,marker)){throw new Error("Inserting collapsed marker partially overlapping an existing one")}seeCollapsedSpans()}if(marker.addToHistory){addChangeToHistory(doc,{from:from,to:to,origin:"markText"},doc.sel,NaN)}var curLine=from.line,cm=doc.cm,updateMaxLine;doc.iter(curLine,to.line+1,function(line){if(cm&&marker.collapsed&&!cm.options.lineWrapping&&visualLine(line)==cm.display.maxLine){updateMaxLine=true}if(marker.collapsed&&curLine!=from.line){updateLineHeight(line,0)}addMarkedSpan(line,new MarkedSpan(marker,curLine==from.line?from.ch:null,curLine==to.line?to.ch:null));++curLine});if(marker.collapsed){doc.iter(from.line,to.line+1,function(line){if(lineIsHidden(doc,line)){updateLineHeight(line,0)}})}if(marker.clearOnEnter){on(marker,"beforeCursorEnter",function(){return marker.clear()})}if(marker.readOnly){seeReadOnlySpans();if(doc.history.done.length||doc.history.undone.length){doc.clearHistory()}}if(marker.collapsed){marker.id=++nextMarkerId;marker.atomic=true}if(cm){if(updateMaxLine){cm.curOp.updateMaxLine=true}if(marker.collapsed){regChange(cm,from.line,to.line+1)}else if(marker.className||marker.title||marker.startStyle||marker.endStyle||marker.css){for(var i=from.line;i<=to.line;i++){regLineChange(cm,i,"text")}}if(marker.atomic){reCheckSelection(cm.doc)}signalLater(cm,"markerAdded",cm,marker)}return marker}var SharedTextMarker=function(markers,primary){var this$1=this;this.markers=markers;this.primary=primary;for(var i=0;i<markers.length;++i){markers[i].parent=this$1}};SharedTextMarker.prototype.clear=function(){var this$1=this;if(this.explicitlyCleared){return}this.explicitlyCleared=true;for(var i=0;i<this.markers.length;++i){this$1.markers[i].clear()}signalLater(this,"clear")};SharedTextMarker.prototype.find=function(side,lineObj){return this.primary.find(side,lineObj)};eventMixin(SharedTextMarker);function markTextShared(doc,from,to,options,type){options=copyObj(options);options.shared=false;var markers=[markText(doc,from,to,options,type)],primary=markers[0];var widget=options.widgetNode;linkedDocs(doc,function(doc){if(widget){options.widgetNode=widget.cloneNode(true)}markers.push(markText(doc,clipPos(doc,from),clipPos(doc,to),options,type));for(var i=0;i<doc.linked.length;++i){if(doc.linked[i].isParent){return}}primary=lst(markers)});return new SharedTextMarker(markers,primary)}function findSharedMarkers(doc){return doc.findMarks(Pos(doc.first,0),doc.clipPos(Pos(doc.lastLine())),function(m){return m.parent})}function copySharedMarkers(doc,markers){for(var i=0;i<markers.length;i++){var marker=markers[i],pos=marker.find();var mFrom=doc.clipPos(pos.from),mTo=doc.clipPos(pos.to);if(cmp(mFrom,mTo)){var subMark=markText(doc,mFrom,mTo,marker.primary,marker.primary.type);marker.markers.push(subMark);subMark.parent=marker}}}function detachSharedMarkers(markers){var loop=function(i){var marker=markers[i],linked=[marker.primary.doc];linkedDocs(marker.primary.doc,function(d){return linked.push(d)});for(var j=0;j<marker.markers.length;j++){var subMarker=marker.markers[j];if(indexOf(linked,subMarker.doc)==-1){subMarker.parent=null;marker.markers.splice(j--,1)}}};for(var i=0;i<markers.length;i++)loop(i)}var nextDocId=0;var Doc=function(text,mode,firstLine,lineSep,direction){if(!(this instanceof Doc)){return new Doc(text,mode,firstLine,lineSep,direction)}if(firstLine==null){firstLine=0}BranchChunk.call(this,[new LeafChunk([new Line("",null)])]);this.first=firstLine;this.scrollTop=this.scrollLeft=0;this.cantEdit=false;this.cleanGeneration=1;this.modeFrontier=this.highlightFrontier=firstLine;var start=Pos(firstLine,0);this.sel=simpleSelection(start);this.history=new History(null);this.id=++nextDocId;this.modeOption=mode;this.lineSep=lineSep;this.direction=direction=="rtl"?"rtl":"ltr";this.extend=false;if(typeof text=="string"){text=this.splitLines(text)}updateDoc(this,{from:start,to:start,text:text});setSelection(this,simpleSelection(start),sel_dontScroll)};Doc.prototype=createObj(BranchChunk.prototype,{constructor:Doc,iter:function(from,to,op){if(op){this.iterN(from-this.first,to-from,op)}else{this.iterN(this.first,this.first+this.size,from)}},insert:function(at,lines){var height=0;for(var i=0;i<lines.length;++i){height+=lines[i].height}this.insertInner(at-this.first,lines,height)},remove:function(at,n){this.removeInner(at-this.first,n)},getValue:function(lineSep){var lines=getLines(this,this.first,this.first+this.size);if(lineSep===false){return lines}return lines.join(lineSep||this.lineSeparator())},setValue:docMethodOp(function(code){var top=Pos(this.first,0),last=this.first+this.size-1;makeChange(this,{from:top,to:Pos(last,getLine(this,last).text.length),text:this.splitLines(code),origin:"setValue",full:true},true);if(this.cm){scrollToCoords(this.cm,0,0)}setSelection(this,simpleSelection(top),sel_dontScroll)}),replaceRange:function(code,from,to,origin){from=clipPos(this,from);to=to?clipPos(this,to):from;replaceRange(this,code,from,to,origin)},getRange:function(from,to,lineSep){var lines=getBetween(this,clipPos(this,from),clipPos(this,to));if(lineSep===false){return lines}return lines.join(lineSep||this.lineSeparator())},getLine:function(line){var l=this.getLineHandle(line);return l&&l.text},getLineHandle:function(line){if(isLine(this,line)){return getLine(this,line)}},getLineNumber:function(line){return lineNo(line)},getLineHandleVisualStart:function(line){if(typeof line=="number"){line=getLine(this,line)}return visualLine(line)},lineCount:function(){return this.size},firstLine:function(){return this.first},lastLine:function(){return this.first+this.size-1},clipPos:function(pos){return clipPos(this,pos)},getCursor:function(start){var range$$1=this.sel.primary(),pos;if(start==null||start=="head"){pos=range$$1.head}else if(start=="anchor"){pos=range$$1.anchor}else if(start=="end"||start=="to"||start===false){pos=range$$1.to()}else{pos=range$$1.from()}return pos},listSelections:function(){return this.sel.ranges},somethingSelected:function(){return this.sel.somethingSelected()},setCursor:docMethodOp(function(line,ch,options){setSimpleSelection(this,clipPos(this,typeof line=="number"?Pos(line,ch||0):line),null,options)}),setSelection:docMethodOp(function(anchor,head,options){setSimpleSelection(this,clipPos(this,anchor),clipPos(this,head||anchor),options)}),extendSelection:docMethodOp(function(head,other,options){extendSelection(this,clipPos(this,head),other&&clipPos(this,other),options)}),extendSelections:docMethodOp(function(heads,options){extendSelections(this,clipPosArray(this,heads),options)}),extendSelectionsBy:docMethodOp(function(f,options){var heads=map(this.sel.ranges,f);extendSelections(this,clipPosArray(this,heads),options)}),setSelections:docMethodOp(function(ranges,primary,options){var this$1=this;if(!ranges.length){return}var out=[];for(var i=0;i<ranges.length;i++){out[i]=new Range(clipPos(this$1,ranges[i].anchor),clipPos(this$1,ranges[i].head))}if(primary==null){primary=Math.min(ranges.length-1,this.sel.primIndex)}setSelection(this,normalizeSelection(out,primary),options)}),addSelection:docMethodOp(function(anchor,head,options){var ranges=this.sel.ranges.slice(0);ranges.push(new Range(clipPos(this,anchor),clipPos(this,head||anchor)));setSelection(this,normalizeSelection(ranges,ranges.length-1),options)}),getSelection:function(lineSep){var this$1=this;var ranges=this.sel.ranges,lines;for(var i=0;i<ranges.length;i++){var sel=getBetween(this$1,ranges[i].from(),ranges[i].to());lines=lines?lines.concat(sel):sel}if(lineSep===false){return lines}else{return lines.join(lineSep||this.lineSeparator())}},getSelections:function(lineSep){var this$1=this;var parts=[],ranges=this.sel.ranges;for(var i=0;i<ranges.length;i++){var sel=getBetween(this$1,ranges[i].from(),ranges[i].to());if(lineSep!==false){sel=sel.join(lineSep||this$1.lineSeparator())}parts[i]=sel}return parts},replaceSelection:function(code,collapse,origin){var dup=[];for(var i=0;i<this.sel.ranges.length;i++){dup[i]=code}this.replaceSelections(dup,collapse,origin||"+input")},replaceSelections:docMethodOp(function(code,collapse,origin){var this$1=this;var changes=[],sel=this.sel;for(var i=0;i<sel.ranges.length;i++){var range$$1=sel.ranges[i];changes[i]={from:range$$1.from(),to:range$$1.to(),text:this$1.splitLines(code[i]),origin:origin}}var newSel=collapse&&collapse!="end"&&computeReplacedSel(this,changes,collapse);for(var i$1=changes.length-1;i$1>=0;i$1--){makeChange(this$1,changes[i$1])}if(newSel){setSelectionReplaceHistory(this,newSel)}else if(this.cm){ensureCursorVisible(this.cm)}}),undo:docMethodOp(function(){makeChangeFromHistory(this,"undo")}),redo:docMethodOp(function(){makeChangeFromHistory(this,"redo")}),undoSelection:docMethodOp(function(){makeChangeFromHistory(this,"undo",true)}),redoSelection:docMethodOp(function(){makeChangeFromHistory(this,"redo",true)}),setExtending:function(val){this.extend=val},getExtending:function(){return this.extend},historySize:function(){var hist=this.history,done=0,undone=0;for(var i=0;i<hist.done.length;i++){if(!hist.done[i].ranges){++done}}for(var i$1=0;i$1<hist.undone.length;i$1++){if(!hist.undone[i$1].ranges){++undone}}return{undo:done,redo:undone}},clearHistory:function(){this.history=new History(this.history.maxGeneration)},markClean:function(){this.cleanGeneration=this.changeGeneration(true)},changeGeneration:function(forceSplit){if(forceSplit){this.history.lastOp=this.history.lastSelOp=this.history.lastOrigin=null}return this.history.generation},isClean:function(gen){return this.history.generation==(gen||this.cleanGeneration)},getHistory:function(){return{done:copyHistoryArray(this.history.done),undone:copyHistoryArray(this.history.undone)}},setHistory:function(histData){var hist=this.history=new History(this.history.maxGeneration);hist.done=copyHistoryArray(histData.done.slice(0),null,true);hist.undone=copyHistoryArray(histData.undone.slice(0),null,true)},setGutterMarker:docMethodOp(function(line,gutterID,value){return changeLine(this,line,"gutter",function(line){var markers=line.gutterMarkers||(line.gutterMarkers={});markers[gutterID]=value;if(!value&&isEmpty(markers)){line.gutterMarkers=null}return true})}),clearGutter:docMethodOp(function(gutterID){var this$1=this;this.iter(function(line){if(line.gutterMarkers&&line.gutterMarkers[gutterID]){changeLine(this$1,line,"gutter",function(){line.gutterMarkers[gutterID]=null;if(isEmpty(line.gutterMarkers)){line.gutterMarkers=null}return true})}})}),lineInfo:function(line){var n;if(typeof line=="number"){if(!isLine(this,line)){return null}n=line;line=getLine(this,line);if(!line){return null}}else{n=lineNo(line);if(n==null){return null}}return{line:n,handle:line,text:line.text,gutterMarkers:line.gutterMarkers,textClass:line.textClass,bgClass:line.bgClass,wrapClass:line.wrapClass,widgets:line.widgets}},addLineClass:docMethodOp(function(handle,where,cls){return changeLine(this,handle,where=="gutter"?"gutter":"class",function(line){var prop=where=="text"?"textClass":where=="background"?"bgClass":where=="gutter"?"gutterClass":"wrapClass";if(!line[prop]){line[prop]=cls}else if(classTest(cls).test(line[prop])){return false}else{line[prop]+=" "+cls}return true})}),removeLineClass:docMethodOp(function(handle,where,cls){return changeLine(this,handle,where=="gutter"?"gutter":"class",function(line){var prop=where=="text"?"textClass":where=="background"?"bgClass":where=="gutter"?"gutterClass":"wrapClass";var cur=line[prop];if(!cur){return false}else if(cls==null){line[prop]=null}else{var found=cur.match(classTest(cls));if(!found){return false}var end=found.index+found[0].length;line[prop]=cur.slice(0,found.index)+(!found.index||end==cur.length?"":" ")+cur.slice(end)||null}return true})}),addLineWidget:docMethodOp(function(handle,node,options){return addLineWidget(this,handle,node,options)}),removeLineWidget:function(widget){widget.clear()},markText:function(from,to,options){return markText(this,clipPos(this,from),clipPos(this,to),options,options&&options.type||"range")},setBookmark:function(pos,options){var realOpts={replacedWith:options&&(options.nodeType==null?options.widget:options),insertLeft:options&&options.insertLeft,clearWhenEmpty:false,shared:options&&options.shared,handleMouseEvents:options&&options.handleMouseEvents};pos=clipPos(this,pos);return markText(this,pos,pos,realOpts,"bookmark")},findMarksAt:function(pos){pos=clipPos(this,pos);var markers=[],spans=getLine(this,pos.line).markedSpans;if(spans){for(var i=0;i<spans.length;++i){var span=spans[i];if((span.from==null||span.from<=pos.ch)&&(span.to==null||span.to>=pos.ch)){markers.push(span.marker.parent||span.marker)}}}return markers},findMarks:function(from,to,filter){from=clipPos(this,from);to=clipPos(this,to);var found=[],lineNo$$1=from.line;this.iter(from.line,to.line+1,function(line){var spans=line.markedSpans;if(spans){for(var i=0;i<spans.length;i++){var span=spans[i];if(!(span.to!=null&&lineNo$$1==from.line&&from.ch>=span.to||span.from==null&&lineNo$$1!=from.line||span.from!=null&&lineNo$$1==to.line&&span.from>=to.ch)&&(!filter||filter(span.marker))){found.push(span.marker.parent||span.marker)}}}++lineNo$$1});return found},getAllMarks:function(){var markers=[];this.iter(function(line){var sps=line.markedSpans;if(sps){for(var i=0;i<sps.length;++i){if(sps[i].from!=null){markers.push(sps[i].marker)}}}});return markers},posFromIndex:function(off){var ch,lineNo$$1=this.first,sepSize=this.lineSeparator().length;this.iter(function(line){var sz=line.text.length+sepSize;if(sz>off){ch=off;return true}off-=sz;++lineNo$$1});return clipPos(this,Pos(lineNo$$1,ch))},indexFromPos:function(coords){coords=clipPos(this,coords);var index=coords.ch;if(coords.line<this.first||coords.ch<0){return 0}var sepSize=this.lineSeparator().length;this.iter(this.first,coords.line,function(line){index+=line.text.length+sepSize});return index},copy:function(copyHistory){var doc=new Doc(getLines(this,this.first,this.first+this.size),this.modeOption,this.first,this.lineSep,this.direction);doc.scrollTop=this.scrollTop;doc.scrollLeft=this.scrollLeft;doc.sel=this.sel;doc.extend=false;if(copyHistory){doc.history.undoDepth=this.history.undoDepth;doc.setHistory(this.getHistory())}return doc},linkedDoc:function(options){if(!options){options={}}var from=this.first,to=this.first+this.size;if(options.from!=null&&options.from>from){from=options.from}if(options.to!=null&&options.to<to){to=options.to}var copy=new Doc(getLines(this,from,to),options.mode||this.modeOption,from,this.lineSep,this.direction);if(options.sharedHist){copy.history=this.history}(this.linked||(this.linked=[])).push({doc:copy,sharedHist:options.sharedHist});copy.linked=[{doc:this,isParent:true,sharedHist:options.sharedHist}];copySharedMarkers(copy,findSharedMarkers(this));return copy},unlinkDoc:function(other){var this$1=this;if(other instanceof CodeMirror$1){other=other.doc}if(this.linked){for(var i=0;i<this.linked.length;++i){var link=this$1.linked[i];if(link.doc!=other){continue}this$1.linked.splice(i,1);other.unlinkDoc(this$1);detachSharedMarkers(findSharedMarkers(this$1));break}}if(other.history==this.history){var splitIds=[other.id];linkedDocs(other,function(doc){return splitIds.push(doc.id)},true);other.history=new History(null);other.history.done=copyHistoryArray(this.history.done,splitIds);other.history.undone=copyHistoryArray(this.history.undone,splitIds)}},iterLinkedDocs:function(f){linkedDocs(this,f)},getMode:function(){return this.mode},getEditor:function(){return this.cm},splitLines:function(str){if(this.lineSep){return str.split(this.lineSep)}return splitLinesAuto(str)},lineSeparator:function(){return this.lineSep||"\n"},setDirection:docMethodOp(function(dir){if(dir!="rtl"){dir="ltr"}if(dir==this.direction){return}this.direction=dir;this.iter(function(line){return line.order=null});if(this.cm){directionChanged(this.cm)}})});Doc.prototype.eachLine=Doc.prototype.iter;var lastDrop=0;function onDrop(e){var cm=this;clearDragCursor(cm);if(signalDOMEvent(cm,e)||eventInWidget(cm.display,e)){return}e_preventDefault(e);if(ie){lastDrop=+new Date}var pos=posFromMouse(cm,e,true),files=e.dataTransfer.files;if(!pos||cm.isReadOnly()){return}if(files&&files.length&&window.FileReader&&window.File){var n=files.length,text=Array(n),read=0;var loadFile=function(file,i){if(cm.options.allowDropFileTypes&&indexOf(cm.options.allowDropFileTypes,file.type)==-1){return}var reader=new FileReader;reader.onload=operation(cm,function(){var content=reader.result;if(/[\x00-\x08\x0e-\x1f]{2}/.test(content)){content=""}text[i]=content;if(++read==n){pos=clipPos(cm.doc,pos);var change={from:pos,to:pos,text:cm.doc.splitLines(text.join(cm.doc.lineSeparator())),origin:"paste"};makeChange(cm.doc,change);setSelectionReplaceHistory(cm.doc,simpleSelection(pos,changeEnd(change)))}});reader.readAsText(file)};for(var i=0;i<n;++i){loadFile(files[i],i)}}else{if(cm.state.draggingText&&cm.doc.sel.contains(pos)>-1){cm.state.draggingText(e);setTimeout(function(){return cm.display.input.focus()},20);return}try{var text$1=e.dataTransfer.getData("Text");if(text$1){var selected;if(cm.state.draggingText&&!cm.state.draggingText.copy){selected=cm.listSelections()}setSelectionNoUndo(cm.doc,simpleSelection(pos,pos));if(selected){for(var i$1=0;i$1<selected.length;++i$1){replaceRange(cm.doc,"",selected[i$1].anchor,selected[i$1].head,"drag")}}cm.replaceSelection(text$1,"around","paste");cm.display.input.focus()}}catch(e){}}}function onDragStart(cm,e){if(ie&&(!cm.state.draggingText||+new Date-lastDrop<100)){e_stop(e);return}if(signalDOMEvent(cm,e)||eventInWidget(cm.display,e)){return}e.dataTransfer.setData("Text",cm.getSelection());e.dataTransfer.effectAllowed="copyMove";if(e.dataTransfer.setDragImage&&!safari){var img=elt("img",null,null,"position: fixed; left: 0; top: 0;");img.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";if(presto){img.width=img.height=1;cm.display.wrapper.appendChild(img);img._top=img.offsetTop}e.dataTransfer.setDragImage(img,0,0);if(presto){img.parentNode.removeChild(img)}}}function onDragOver(cm,e){var pos=posFromMouse(cm,e);if(!pos){return}var frag=document.createDocumentFragment();drawSelectionCursor(cm,pos,frag);if(!cm.display.dragCursor){cm.display.dragCursor=elt("div",null,"CodeMirror-cursors CodeMirror-dragcursors");cm.display.lineSpace.insertBefore(cm.display.dragCursor,cm.display.cursorDiv)}removeChildrenAndAdd(cm.display.dragCursor,frag)}function clearDragCursor(cm){if(cm.display.dragCursor){cm.display.lineSpace.removeChild(cm.display.dragCursor);cm.display.dragCursor=null}}function forEachCodeMirror(f){if(!document.getElementsByClassName){return}var byClass=document.getElementsByClassName("CodeMirror");for(var i=0;i<byClass.length;i++){var cm=byClass[i].CodeMirror;if(cm){f(cm)}}}var globalsRegistered=false;function ensureGlobalHandlers(){if(globalsRegistered){return}registerGlobalHandlers();globalsRegistered=true}function registerGlobalHandlers(){var resizeTimer;on(window,"resize",function(){if(resizeTimer==null){resizeTimer=setTimeout(function(){resizeTimer=null;forEachCodeMirror(onResize)},100)}});on(window,"blur",function(){return forEachCodeMirror(onBlur)})}function onResize(cm){var d=cm.display;if(d.lastWrapHeight==d.wrapper.clientHeight&&d.lastWrapWidth==d.wrapper.clientWidth){return}d.cachedCharWidth=d.cachedTextHeight=d.cachedPaddingH=null;d.scrollbarsClipped=false;cm.setSize()}var keyNames={3:"Enter",8:"Backspace",9:"Tab",13:"Enter",16:"Shift",17:"Ctrl",18:"Alt",19:"Pause",20:"CapsLock",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"PrintScrn",45:"Insert",46:"Delete",59:";",61:"=",91:"Mod",92:"Mod",93:"Mod",106:"*",107:"=",109:"-",110:".",111:"/",127:"Delete",173:"-",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",63232:"Up",63233:"Down",63234:"Left",63235:"Right",63272:"Delete",63273:"Home",63275:"End",63276:"PageUp",63277:"PageDown",63302:"Insert"};for(var i=0;i<10;i++){keyNames[i+48]=keyNames[i+96]=String(i)}for(var i$1=65;i$1<=90;i$1++){keyNames[i$1]=String.fromCharCode(i$1)}for(var i$2=1;i$2<=12;i$2++){keyNames[i$2+111]=keyNames[i$2+63235]="F"+i$2}var keyMap={};keyMap.basic={Left:"goCharLeft",Right:"goCharRight",Up:"goLineUp",Down:"goLineDown",End:"goLineEnd",Home:"goLineStartSmart",PageUp:"goPageUp",PageDown:"goPageDown",Delete:"delCharAfter",Backspace:"delCharBefore","Shift-Backspace":"delCharBefore",Tab:"defaultTab","Shift-Tab":"indentAuto",Enter:"newlineAndIndent",Insert:"toggleOverwrite",Esc:"singleSelection"};keyMap.pcDefault={"Ctrl-A":"selectAll","Ctrl-D":"deleteLine","Ctrl-Z":"undo","Shift-Ctrl-Z":"redo","Ctrl-Y":"redo","Ctrl-Home":"goDocStart","Ctrl-End":"goDocEnd","Ctrl-Up":"goLineUp","Ctrl-Down":"goLineDown","Ctrl-Left":"goGroupLeft","Ctrl-Right":"goGroupRight","Alt-Left":"goLineStart","Alt-Right":"goLineEnd","Ctrl-Backspace":"delGroupBefore","Ctrl-Delete":"delGroupAfter","Ctrl-S":"save","Ctrl-F":"find","Ctrl-G":"findNext","Shift-Ctrl-G":"findPrev","Shift-Ctrl-F":"replace","Shift-Ctrl-R":"replaceAll","Ctrl-[":"indentLess","Ctrl-]":"indentMore","Ctrl-U":"undoSelection","Shift-Ctrl-U":"redoSelection","Alt-U":"redoSelection",fallthrough:"basic"};keyMap.emacsy={"Ctrl-F":"goCharRight","Ctrl-B":"goCharLeft","Ctrl-P":"goLineUp","Ctrl-N":"goLineDown","Alt-F":"goWordRight","Alt-B":"goWordLeft","Ctrl-A":"goLineStart","Ctrl-E":"goLineEnd","Ctrl-V":"goPageDown","Shift-Ctrl-V":"goPageUp","Ctrl-D":"delCharAfter","Ctrl-H":"delCharBefore","Alt-D":"delWordAfter","Alt-Backspace":"delWordBefore","Ctrl-K":"killLine","Ctrl-T":"transposeChars","Ctrl-O":"openLine"};keyMap.macDefault={"Cmd-A":"selectAll","Cmd-D":"deleteLine","Cmd-Z":"undo","Shift-Cmd-Z":"redo","Cmd-Y":"redo","Cmd-Home":"goDocStart","Cmd-Up":"goDocStart","Cmd-End":"goDocEnd","Cmd-Down":"goDocEnd","Alt-Left":"goGroupLeft","Alt-Right":"goGroupRight","Cmd-Left":"goLineLeft","Cmd-Right":"goLineRight","Alt-Backspace":"delGroupBefore","Ctrl-Alt-Backspace":"delGroupAfter","Alt-Delete":"delGroupAfter","Cmd-S":"save","Cmd-F":"find","Cmd-G":"findNext","Shift-Cmd-G":"findPrev","Cmd-Alt-F":"replace","Shift-Cmd-Alt-F":"replaceAll","Cmd-[":"indentLess","Cmd-]":"indentMore","Cmd-Backspace":"delWrappedLineLeft","Cmd-Delete":"delWrappedLineRight","Cmd-U":"undoSelection","Shift-Cmd-U":"redoSelection","Ctrl-Up":"goDocStart","Ctrl-Down":"goDocEnd",fallthrough:["basic","emacsy"]};keyMap["default"]=mac?keyMap.macDefault:keyMap.pcDefault;function normalizeKeyName(name){var parts=name.split(/-(?!$)/);name=parts[parts.length-1];var alt,ctrl,shift,cmd;for(var i=0;i<parts.length-1;i++){var mod=parts[i];if(/^(cmd|meta|m)$/i.test(mod)){cmd=true}else if(/^a(lt)?$/i.test(mod)){alt=true}else if(/^(c|ctrl|control)$/i.test(mod)){ctrl=true}else if(/^s(hift)?$/i.test(mod)){shift=true}else{throw new Error("Unrecognized modifier name: "+mod)}}if(alt){name="Alt-"+name}if(ctrl){name="Ctrl-"+name}if(cmd){name="Cmd-"+name}if(shift){name="Shift-"+name}return name}function normalizeKeyMap(keymap){var copy={};for(var keyname in keymap){if(keymap.hasOwnProperty(keyname)){var value=keymap[keyname];if(/^(name|fallthrough|(de|at)tach)$/.test(keyname)){continue}if(value=="..."){delete keymap[keyname];continue}var keys=map(keyname.split(" "),normalizeKeyName);for(var i=0;i<keys.length;i++){var val=void 0,name=void 0;if(i==keys.length-1){name=keys.join(" ");val=value}else{name=keys.slice(0,i+1).join(" ");val="..."}var prev=copy[name];if(!prev){copy[name]=val}else if(prev!=val){throw new Error("Inconsistent bindings for "+name)}}delete keymap[keyname]}}for(var prop in copy){keymap[prop]=copy[prop]}return keymap}function lookupKey(key,map$$1,handle,context){map$$1=getKeyMap(map$$1);var found=map$$1.call?map$$1.call(key,context):map$$1[key];if(found===false){return"nothing"}if(found==="..."){return"multi"}if(found!=null&&handle(found)){return"handled"}if(map$$1.fallthrough){if(Object.prototype.toString.call(map$$1.fallthrough)!="[object Array]"){return lookupKey(key,map$$1.fallthrough,handle,context)}for(var i=0;i<map$$1.fallthrough.length;i++){var result=lookupKey(key,map$$1.fallthrough[i],handle,context);if(result){return result}}}}function isModifierKey(value){var name=typeof value=="string"?value:keyNames[value.keyCode];return name=="Ctrl"||name=="Alt"||name=="Shift"||name=="Mod"}function addModifierNames(name,event,noShift){var base=name;if(event.altKey&&base!="Alt"){name="Alt-"+name}if((flipCtrlCmd?event.metaKey:event.ctrlKey)&&base!="Ctrl"){name="Ctrl-"+name}if((flipCtrlCmd?event.ctrlKey:event.metaKey)&&base!="Cmd"){name="Cmd-"+name}if(!noShift&&event.shiftKey&&base!="Shift"){name="Shift-"+name}return name}function keyName(event,noShift){if(presto&&event.keyCode==34&&event["char"]){return false}var name=keyNames[event.keyCode];if(name==null||event.altGraphKey){return false}return addModifierNames(name,event,noShift)}function getKeyMap(val){return typeof val=="string"?keyMap[val]:val}function deleteNearSelection(cm,compute){var ranges=cm.doc.sel.ranges,kill=[];for(var i=0;i<ranges.length;i++){var toKill=compute(ranges[i]);while(kill.length&&cmp(toKill.from,lst(kill).to)<=0){var replaced=kill.pop();if(cmp(replaced.from,toKill.from)<0){toKill.from=replaced.from;break}}kill.push(toKill)}runInOp(cm,function(){for(var i=kill.length-1;i>=0;i--){replaceRange(cm.doc,"",kill[i].from,kill[i].to,"+delete")}ensureCursorVisible(cm)})}var commands={selectAll:selectAll,singleSelection:function(cm){return cm.setSelection(cm.getCursor("anchor"),cm.getCursor("head"),sel_dontScroll)},killLine:function(cm){return deleteNearSelection(cm,function(range){if(range.empty()){var len=getLine(cm.doc,range.head.line).text.length;if(range.head.ch==len&&range.head.line<cm.lastLine()){return{from:range.head,to:Pos(range.head.line+1,0)}}else{return{from:range.head,to:Pos(range.head.line,len)}}}else{return{from:range.from(),to:range.to()}}})},deleteLine:function(cm){return deleteNearSelection(cm,function(range){return{from:Pos(range.from().line,0),to:clipPos(cm.doc,Pos(range.to().line+1,0))}})},delLineLeft:function(cm){return deleteNearSelection(cm,function(range){return{from:Pos(range.from().line,0),to:range.from()}})},delWrappedLineLeft:function(cm){return deleteNearSelection(cm,function(range){var top=cm.charCoords(range.head,"div").top+5;var leftPos=cm.coordsChar({left:0,top:top},"div");return{from:leftPos,to:range.from()}})},delWrappedLineRight:function(cm){return deleteNearSelection(cm,function(range){var top=cm.charCoords(range.head,"div").top+5;var rightPos=cm.coordsChar({left:cm.display.lineDiv.offsetWidth+100,top:top},"div");return{from:range.from(),to:rightPos}})},undo:function(cm){return cm.undo()},redo:function(cm){return cm.redo()},undoSelection:function(cm){return cm.undoSelection()},redoSelection:function(cm){return cm.redoSelection()},goDocStart:function(cm){return cm.extendSelection(Pos(cm.firstLine(),0))},goDocEnd:function(cm){return cm.extendSelection(Pos(cm.lastLine()))},goLineStart:function(cm){return cm.extendSelectionsBy(function(range){return lineStart(cm,range.head.line)},{origin:"+move",bias:1})},goLineStartSmart:function(cm){return cm.extendSelectionsBy(function(range){return lineStartSmart(cm,range.head)},{origin:"+move",bias:1})},goLineEnd:function(cm){return cm.extendSelectionsBy(function(range){return lineEnd(cm,range.head.line)},{origin:"+move",bias:-1})},goLineRight:function(cm){return cm.extendSelectionsBy(function(range){var top=cm.charCoords(range.head,"div").top+5;return cm.coordsChar({left:cm.display.lineDiv.offsetWidth+100,top:top},"div")},sel_move)},goLineLeft:function(cm){return cm.extendSelectionsBy(function(range){var top=cm.charCoords(range.head,"div").top+5;return cm.coordsChar({left:0,top:top},"div")},sel_move)},goLineLeftSmart:function(cm){return cm.extendSelectionsBy(function(range){var top=cm.charCoords(range.head,"div").top+5;var pos=cm.coordsChar({left:0,top:top},"div");if(pos.ch<cm.getLine(pos.line).search(/\S/)){return lineStartSmart(cm,range.head)}return pos},sel_move)},goLineUp:function(cm){return cm.moveV(-1,"line")},goLineDown:function(cm){return cm.moveV(1,"line")},goPageUp:function(cm){return cm.moveV(-1,"page")},goPageDown:function(cm){return cm.moveV(1,"page")},goCharLeft:function(cm){return cm.moveH(-1,"char")},goCharRight:function(cm){return cm.moveH(1,"char")},goColumnLeft:function(cm){return cm.moveH(-1,"column")},goColumnRight:function(cm){return cm.moveH(1,"column")},goWordLeft:function(cm){return cm.moveH(-1,"word")},goGroupRight:function(cm){return cm.moveH(1,"group")},goGroupLeft:function(cm){return cm.moveH(-1,"group")},goWordRight:function(cm){return cm.moveH(1,"word")},delCharBefore:function(cm){return cm.deleteH(-1,"char")},delCharAfter:function(cm){return cm.deleteH(1,"char")},delWordBefore:function(cm){return cm.deleteH(-1,"word")},delWordAfter:function(cm){return cm.deleteH(1,"word")},delGroupBefore:function(cm){return cm.deleteH(-1,"group")},delGroupAfter:function(cm){return cm.deleteH(1,"group")},indentAuto:function(cm){return cm.indentSelection("smart")},indentMore:function(cm){return cm.indentSelection("add")},indentLess:function(cm){return cm.indentSelection("subtract")},insertTab:function(cm){return cm.replaceSelection("\t")},insertSoftTab:function(cm){var spaces=[],ranges=cm.listSelections(),tabSize=cm.options.tabSize;for(var i=0;i<ranges.length;i++){var pos=ranges[i].from();var col=countColumn(cm.getLine(pos.line),pos.ch,tabSize);spaces.push(spaceStr(tabSize-col%tabSize))}cm.replaceSelections(spaces)},defaultTab:function(cm){if(cm.somethingSelected()){cm.indentSelection("add")}else{cm.execCommand("insertTab")}},transposeChars:function(cm){return runInOp(cm,function(){var ranges=cm.listSelections(),newSel=[];for(var i=0;i<ranges.length;i++){if(!ranges[i].empty()){continue}var cur=ranges[i].head,line=getLine(cm.doc,cur.line).text;if(line){if(cur.ch==line.length){cur=new Pos(cur.line,cur.ch-1)}if(cur.ch>0){cur=new Pos(cur.line,cur.ch+1);cm.replaceRange(line.charAt(cur.ch-1)+line.charAt(cur.ch-2),Pos(cur.line,cur.ch-2),cur,"+transpose")}else if(cur.line>cm.doc.first){var prev=getLine(cm.doc,cur.line-1).text;if(prev){cur=new Pos(cur.line,1);cm.replaceRange(line.charAt(0)+cm.doc.lineSeparator()+prev.charAt(prev.length-1),Pos(cur.line-1,prev.length-1),cur,"+transpose")}}}newSel.push(new Range(cur,cur))}cm.setSelections(newSel)})},newlineAndIndent:function(cm){return runInOp(cm,function(){var sels=cm.listSelections();for(var i=sels.length-1;i>=0;i--){cm.replaceRange(cm.doc.lineSeparator(),sels[i].anchor,sels[i].head,"+input")}sels=cm.listSelections();for(var i$1=0;i$1<sels.length;i$1++){cm.indentLine(sels[i$1].from().line,null,true)}ensureCursorVisible(cm)})},openLine:function(cm){return cm.replaceSelection("\n","start")},toggleOverwrite:function(cm){return cm.toggleOverwrite()}};function lineStart(cm,lineN){var line=getLine(cm.doc,lineN);var visual=visualLine(line);if(visual!=line){lineN=lineNo(visual)}return endOfLine(true,cm,visual,lineN,1)}function lineEnd(cm,lineN){var line=getLine(cm.doc,lineN);var visual=visualLineEnd(line);if(visual!=line){lineN=lineNo(visual)}return endOfLine(true,cm,line,lineN,-1)}function lineStartSmart(cm,pos){var start=lineStart(cm,pos.line);var line=getLine(cm.doc,start.line);var order=getOrder(line,cm.doc.direction);if(!order||order[0].level==0){var firstNonWS=Math.max(0,line.text.search(/\S/));var inWS=pos.line==start.line&&pos.ch<=firstNonWS&&pos.ch;return Pos(start.line,inWS?0:firstNonWS,start.sticky)}return start}function doHandleBinding(cm,bound,dropShift){if(typeof bound=="string"){bound=commands[bound];if(!bound){return false}}cm.display.input.ensurePolled();var prevShift=cm.display.shift,done=false;try{if(cm.isReadOnly()){cm.state.suppressEdits=true}if(dropShift){cm.display.shift=false}done=bound(cm)!=Pass}finally{cm.display.shift=prevShift;cm.state.suppressEdits=false}return done}function lookupKeyForEditor(cm,name,handle){for(var i=0;i<cm.state.keyMaps.length;i++){var result=lookupKey(name,cm.state.keyMaps[i],handle,cm);if(result){return result}}return cm.options.extraKeys&&lookupKey(name,cm.options.extraKeys,handle,cm)||lookupKey(name,cm.options.keyMap,handle,cm)}var stopSeq=new Delayed;function dispatchKey(cm,name,e,handle){var seq=cm.state.keySeq;if(seq){if(isModifierKey(name)){return"handled"}stopSeq.set(50,function(){if(cm.state.keySeq==seq){cm.state.keySeq=null;cm.display.input.reset()}});name=seq+" "+name}var result=lookupKeyForEditor(cm,name,handle);if(result=="multi"){cm.state.keySeq=name}if(result=="handled"){signalLater(cm,"keyHandled",cm,name,e)}if(result=="handled"||result=="multi"){e_preventDefault(e);restartBlink(cm)}if(seq&&!result&&/\'$/.test(name)){e_preventDefault(e);return true}return!!result}function handleKeyBinding(cm,e){var name=keyName(e,true);if(!name){return false}if(e.shiftKey&&!cm.state.keySeq){return dispatchKey(cm,"Shift-"+name,e,function(b){return doHandleBinding(cm,b,true)})||dispatchKey(cm,name,e,function(b){if(typeof b=="string"?/^go[A-Z]/.test(b):b.motion){return doHandleBinding(cm,b)}})}else{return dispatchKey(cm,name,e,function(b){return doHandleBinding(cm,b)})}}function handleCharBinding(cm,e,ch){return dispatchKey(cm,"'"+ch+"'",e,function(b){return doHandleBinding(cm,b,true)})}var lastStoppedKey=null;function onKeyDown(e){var cm=this;cm.curOp.focus=activeElt();if(signalDOMEvent(cm,e)){return}if(ie&&ie_version<11&&e.keyCode==27){e.returnValue=false}var code=e.keyCode;cm.display.shift=code==16||e.shiftKey;var handled=handleKeyBinding(cm,e);if(presto){lastStoppedKey=handled?code:null;if(!handled&&code==88&&!hasCopyEvent&&(mac?e.metaKey:e.ctrlKey)){cm.replaceSelection("",null,"cut")}}if(code==18&&!/\bCodeMirror-crosshair\b/.test(cm.display.lineDiv.className)){showCrossHair(cm)}}function showCrossHair(cm){var lineDiv=cm.display.lineDiv;addClass(lineDiv,"CodeMirror-crosshair");function up(e){if(e.keyCode==18||!e.altKey){rmClass(lineDiv,"CodeMirror-crosshair");off(document,"keyup",up);off(document,"mouseover",up)}}on(document,"keyup",up);on(document,"mouseover",up)}function onKeyUp(e){if(e.keyCode==16){this.doc.sel.shift=false}signalDOMEvent(this,e)}function onKeyPress(e){var cm=this;if(eventInWidget(cm.display,e)||signalDOMEvent(cm,e)||e.ctrlKey&&!e.altKey||mac&&e.metaKey){return}var keyCode=e.keyCode,charCode=e.charCode;if(presto&&keyCode==lastStoppedKey){lastStoppedKey=null;e_preventDefault(e);return}if(presto&&(!e.which||e.which<10)&&handleKeyBinding(cm,e)){return}var ch=String.fromCharCode(charCode==null?keyCode:charCode);if(ch=="\b"){return}if(handleCharBinding(cm,e,ch)){return}cm.display.input.onKeyPress(e)}var DOUBLECLICK_DELAY=400;var PastClick=function(time,pos,button){this.time=time;this.pos=pos;this.button=button};PastClick.prototype.compare=function(time,pos,button){return this.time+DOUBLECLICK_DELAY>time&&cmp(pos,this.pos)==0&&button==this.button};var lastClick;var lastDoubleClick;function clickRepeat(pos,button){var now=+new Date;if(lastDoubleClick&&lastDoubleClick.compare(now,pos,button)){lastClick=lastDoubleClick=null;return"triple"}else if(lastClick&&lastClick.compare(now,pos,button)){lastDoubleClick=new PastClick(now,pos,button);lastClick=null;return"double"}else{lastClick=new PastClick(now,pos,button);lastDoubleClick=null;return"single"}}function onMouseDown(e){var cm=this,display=cm.display;if(signalDOMEvent(cm,e)||display.activeTouch&&display.input.supportsTouch()){return}display.input.ensurePolled();display.shift=e.shiftKey;if(eventInWidget(display,e)){if(!webkit){display.scroller.draggable=false;setTimeout(function(){return display.scroller.draggable=true},100)}return}if(clickInGutter(cm,e)){return}var pos=posFromMouse(cm,e),button=e_button(e),repeat=pos?clickRepeat(pos,button):"single";window.focus();if(button==1&&cm.state.selectingText){cm.state.selectingText(e)}if(pos&&handleMappedButton(cm,button,pos,repeat,e)){return}if(button==1){if(pos){leftButtonDown(cm,pos,repeat,e)}else if(e_target(e)==display.scroller){e_preventDefault(e)}}else if(button==2){if(pos){extendSelection(cm.doc,pos)}setTimeout(function(){return display.input.focus()},20)}else if(button==3){if(captureRightClick){onContextMenu(cm,e)}else{delayBlurEvent(cm)}}}function handleMappedButton(cm,button,pos,repeat,event){var name="Click";if(repeat=="double"){name="Double"+name}else if(repeat=="triple"){name="Triple"+name}name=(button==1?"Left":button==2?"Middle":"Right")+name;return dispatchKey(cm,addModifierNames(name,event),event,function(bound){if(typeof bound=="string"){bound=commands[bound]}if(!bound){return false}var done=false;try{if(cm.isReadOnly()){cm.state.suppressEdits=true}done=bound(cm,pos)!=Pass}finally{cm.state.suppressEdits=false}return done})}function configureMouse(cm,repeat,event){var option=cm.getOption("configureMouse");var value=option?option(cm,repeat,event):{};if(value.unit==null){var rect=chromeOS?event.shiftKey&&event.metaKey:event.altKey;value.unit=rect?"rectangle":repeat=="single"?"char":repeat=="double"?"word":"line"}if(value.extend==null||cm.doc.extend){value.extend=cm.doc.extend||event.shiftKey}if(value.addNew==null){value.addNew=mac?event.metaKey:event.ctrlKey}if(value.moveOnDrag==null){value.moveOnDrag=!(mac?event.altKey:event.ctrlKey)}return value}function leftButtonDown(cm,pos,repeat,event){if(ie){setTimeout(bind(ensureFocus,cm),0)}else{cm.curOp.focus=activeElt()}var behavior=configureMouse(cm,repeat,event);var sel=cm.doc.sel,contained;if(cm.options.dragDrop&&dragAndDrop&&!cm.isReadOnly()&&repeat=="single"&&(contained=sel.contains(pos))>-1&&(cmp((contained=sel.ranges[contained]).from(),pos)<0||pos.xRel>0)&&(cmp(contained.to(),pos)>0||pos.xRel<0)){leftButtonStartDrag(cm,event,pos,behavior)}else{leftButtonSelect(cm,event,pos,behavior)}}function leftButtonStartDrag(cm,event,pos,behavior){var display=cm.display,moved=false;var dragEnd=operation(cm,function(e){if(webkit){display.scroller.draggable=false}cm.state.draggingText=false;off(document,"mouseup",dragEnd);off(document,"mousemove",mouseMove);off(display.scroller,"dragstart",dragStart);off(display.scroller,"drop",dragEnd);if(!moved){e_preventDefault(e);if(!behavior.addNew){extendSelection(cm.doc,pos,null,null,behavior.extend)}if(webkit||ie&&ie_version==9){setTimeout(function(){document.body.focus();display.input.focus()},20)}else{display.input.focus()}}});var mouseMove=function(e2){moved=moved||Math.abs(event.clientX-e2.clientX)+Math.abs(event.clientY-e2.clientY)>=10};var dragStart=function(){return moved=true};if(webkit){display.scroller.draggable=true}cm.state.draggingText=dragEnd;dragEnd.copy=!behavior.moveOnDrag;if(display.scroller.dragDrop){display.scroller.dragDrop()}on(document,"mouseup",dragEnd);on(document,"mousemove",mouseMove);on(display.scroller,"dragstart",dragStart);on(display.scroller,"drop",dragEnd);delayBlurEvent(cm);setTimeout(function(){return display.input.focus()},20)}function rangeForUnit(cm,pos,unit){if(unit=="char"){return new Range(pos,pos)}if(unit=="word"){return cm.findWordAt(pos)}if(unit=="line"){return new Range(Pos(pos.line,0),clipPos(cm.doc,Pos(pos.line+1,0)))}var result=unit(cm,pos);return new Range(result.from,result.to)}function leftButtonSelect(cm,event,start,behavior){var display=cm.display,doc=cm.doc;e_preventDefault(event);var ourRange,ourIndex,startSel=doc.sel,ranges=startSel.ranges;if(behavior.addNew&&!behavior.extend){ourIndex=doc.sel.contains(start);if(ourIndex>-1){ourRange=ranges[ourIndex]}else{ourRange=new Range(start,start)}}else{ourRange=doc.sel.primary();ourIndex=doc.sel.primIndex}if(behavior.unit=="rectangle"){if(!behavior.addNew){ourRange=new Range(start,start)}start=posFromMouse(cm,event,true,true);ourIndex=-1}else{var range$$1=rangeForUnit(cm,start,behavior.unit);if(behavior.extend){ourRange=extendRange(ourRange,range$$1.anchor,range$$1.head,behavior.extend)}else{ourRange=range$$1}}if(!behavior.addNew){ourIndex=0;setSelection(doc,new Selection([ourRange],0),sel_mouse);startSel=doc.sel}else if(ourIndex==-1){ourIndex=ranges.length;setSelection(doc,normalizeSelection(ranges.concat([ourRange]),ourIndex),{scroll:false,origin:"*mouse"})}else if(ranges.length>1&&ranges[ourIndex].empty()&&behavior.unit=="char"&&!behavior.extend){setSelection(doc,normalizeSelection(ranges.slice(0,ourIndex).concat(ranges.slice(ourIndex+1)),0),{scroll:false,origin:"*mouse"});startSel=doc.sel}else{replaceOneSelection(doc,ourIndex,ourRange,sel_mouse)}var lastPos=start;function extendTo(pos){if(cmp(lastPos,pos)==0){return}lastPos=pos;if(behavior.unit=="rectangle"){var ranges=[],tabSize=cm.options.tabSize;var startCol=countColumn(getLine(doc,start.line).text,start.ch,tabSize);var posCol=countColumn(getLine(doc,pos.line).text,pos.ch,tabSize);var left=Math.min(startCol,posCol),right=Math.max(startCol,posCol);for(var line=Math.min(start.line,pos.line),end=Math.min(cm.lastLine(),Math.max(start.line,pos.line));line<=end;line++){var text=getLine(doc,line).text,leftPos=findColumn(text,left,tabSize);if(left==right){ranges.push(new Range(Pos(line,leftPos),Pos(line,leftPos)))}else if(text.length>leftPos){ranges.push(new Range(Pos(line,leftPos),Pos(line,findColumn(text,right,tabSize))))}}if(!ranges.length){ranges.push(new Range(start,start))}setSelection(doc,normalizeSelection(startSel.ranges.slice(0,ourIndex).concat(ranges),ourIndex),{origin:"*mouse",scroll:false});cm.scrollIntoView(pos)}else{var oldRange=ourRange;var range$$1=rangeForUnit(cm,pos,behavior.unit);var anchor=oldRange.anchor,head;if(cmp(range$$1.anchor,anchor)>0){head=range$$1.head;anchor=minPos(oldRange.from(),range$$1.anchor)}else{head=range$$1.anchor;anchor=maxPos(oldRange.to(),range$$1.head)}var ranges$1=startSel.ranges.slice(0);ranges$1[ourIndex]=new Range(clipPos(doc,anchor),head);setSelection(doc,normalizeSelection(ranges$1,ourIndex),sel_mouse)}}var editorSize=display.wrapper.getBoundingClientRect();var counter=0;function extend(e){var curCount=++counter;var cur=posFromMouse(cm,e,true,behavior.unit=="rectangle");if(!cur){return}if(cmp(cur,lastPos)!=0){cm.curOp.focus=activeElt();extendTo(cur);var visible=visibleLines(display,doc);if(cur.line>=visible.to||cur.line<visible.from){setTimeout(operation(cm,function(){if(counter==curCount){extend(e)}}),150)}}else{var outside=e.clientY<editorSize.top?-20:e.clientY>editorSize.bottom?20:0;if(outside){setTimeout(operation(cm,function(){if(counter!=curCount){return}display.scroller.scrollTop+=outside;extend(e)}),50)}}}function done(e){cm.state.selectingText=false;counter=Infinity;e_preventDefault(e);display.input.focus();off(document,"mousemove",move);off(document,"mouseup",up);doc.history.lastSelOrigin=null}var move=operation(cm,function(e){if(!e_button(e)){done(e)}else{extend(e)}});var up=operation(cm,done);cm.state.selectingText=up;on(document,"mousemove",move);on(document,"mouseup",up)}function gutterEvent(cm,e,type,prevent){var mX,mY;try{mX=e.clientX;mY=e.clientY}catch(e){return false}if(mX>=Math.floor(cm.display.gutters.getBoundingClientRect().right)){return false}if(prevent){e_preventDefault(e)}var display=cm.display;var lineBox=display.lineDiv.getBoundingClientRect();if(mY>lineBox.bottom||!hasHandler(cm,type)){return e_defaultPrevented(e)}mY-=lineBox.top-display.viewOffset;for(var i=0;i<cm.options.gutters.length;++i){var g=display.gutters.childNodes[i];if(g&&g.getBoundingClientRect().right>=mX){var line=lineAtHeight(cm.doc,mY);var gutter=cm.options.gutters[i];signal(cm,type,cm,line,gutter,e);return e_defaultPrevented(e)}}}function clickInGutter(cm,e){return gutterEvent(cm,e,"gutterClick",true)}function onContextMenu(cm,e){if(eventInWidget(cm.display,e)||contextMenuInGutter(cm,e)){return}if(signalDOMEvent(cm,e,"contextmenu")){return}cm.display.input.onContextMenu(e)}function contextMenuInGutter(cm,e){if(!hasHandler(cm,"gutterContextMenu")){return false}return gutterEvent(cm,e,"gutterContextMenu",false)}function themeChanged(cm){cm.display.wrapper.className=cm.display.wrapper.className.replace(/\s*cm-s-\S+/g,"")+cm.options.theme.replace(/(^|\s)\s*/g," cm-s-");clearCaches(cm)}var Init={toString:function(){return"CodeMirror.Init"}};var defaults={};var optionHandlers={};function defineOptions(CodeMirror){var optionHandlers=CodeMirror.optionHandlers;function option(name,deflt,handle,notOnInit){CodeMirror.defaults[name]=deflt;if(handle){optionHandlers[name]=notOnInit?function(cm,val,old){if(old!=Init){handle(cm,val,old)}}:handle}}CodeMirror.defineOption=option;CodeMirror.Init=Init;option("value","",function(cm,val){return cm.setValue(val)},true);option("mode",null,function(cm,val){cm.doc.modeOption=val;loadMode(cm)},true);option("indentUnit",2,loadMode,true);option("indentWithTabs",false);option("smartIndent",true);option("tabSize",4,function(cm){resetModeState(cm);clearCaches(cm);regChange(cm)},true);option("lineSeparator",null,function(cm,val){cm.doc.lineSep=val;if(!val){return}var newBreaks=[],lineNo=cm.doc.first;cm.doc.iter(function(line){for(var pos=0;;){var found=line.text.indexOf(val,pos);if(found==-1){break}pos=found+val.length;newBreaks.push(Pos(lineNo,found))}lineNo++});for(var i=newBreaks.length-1;i>=0;i--){replaceRange(cm.doc,val,newBreaks[i],Pos(newBreaks[i].line,newBreaks[i].ch+val.length))}});option("specialChars",/[\u0000-\u001f\u007f-\u009f\u00ad\u061c\u200b-\u200f\u2028\u2029\ufeff]/g,function(cm,val,old){cm.state.specialChars=new RegExp(val.source+(val.test("\t")?"":"|\t"),"g");if(old!=Init){cm.refresh()}});option("specialCharPlaceholder",defaultSpecialCharPlaceholder,function(cm){return cm.refresh()},true);option("electricChars",true);option("inputStyle",mobile?"contenteditable":"textarea",function(){throw new Error("inputStyle can not (yet) be changed in a running editor")},true);option("spellcheck",false,function(cm,val){return cm.getInputField().spellcheck=val},true);option("rtlMoveVisually",!windows);option("wholeLineUpdateBefore",true);option("theme","default",function(cm){themeChanged(cm);guttersChanged(cm)},true);option("keyMap","default",function(cm,val,old){var next=getKeyMap(val);var prev=old!=Init&&getKeyMap(old);if(prev&&prev.detach){prev.detach(cm,next)}if(next.attach){next.attach(cm,prev||null)}});option("extraKeys",null);option("configureMouse",null);option("lineWrapping",false,wrappingChanged,true);option("gutters",[],function(cm){setGuttersForLineNumbers(cm.options);guttersChanged(cm)},true);option("fixedGutter",true,function(cm,val){cm.display.gutters.style.left=val?compensateForHScroll(cm.display)+"px":"0";cm.refresh()},true);option("coverGutterNextToScrollbar",false,function(cm){return updateScrollbars(cm)},true);option("scrollbarStyle","native",function(cm){initScrollbars(cm);updateScrollbars(cm);cm.display.scrollbars.setScrollTop(cm.doc.scrollTop);cm.display.scrollbars.setScrollLeft(cm.doc.scrollLeft)},true);option("lineNumbers",false,function(cm){setGuttersForLineNumbers(cm.options);guttersChanged(cm)},true);option("firstLineNumber",1,guttersChanged,true);option("lineNumberFormatter",function(integer){return integer},guttersChanged,true);option("showCursorWhenSelecting",false,updateSelection,true);option("resetSelectionOnContextMenu",true);option("lineWiseCopyCut",true);option("pasteLinesPerSelection",true);option("readOnly",false,function(cm,val){if(val=="nocursor"){onBlur(cm);cm.display.input.blur()}cm.display.input.readOnlyChanged(val)});option("disableInput",false,function(cm,val){if(!val){cm.display.input.reset()}},true);option("dragDrop",true,dragDropChanged);option("allowDropFileTypes",null);option("cursorBlinkRate",530);option("cursorScrollMargin",0);option("cursorHeight",1,updateSelection,true);option("singleCursorHeightPerLine",true,updateSelection,true);option("workTime",100);option("workDelay",100);option("flattenSpans",true,resetModeState,true);option("addModeClass",false,resetModeState,true);option("pollInterval",100);option("undoDepth",200,function(cm,val){return cm.doc.history.undoDepth=val});option("historyEventDelay",1250);option("viewportMargin",10,function(cm){return cm.refresh()},true);option("maxHighlightLength",1e4,resetModeState,true);option("moveInputWithCursor",true,function(cm,val){if(!val){cm.display.input.resetPosition()}});option("tabindex",null,function(cm,val){return cm.display.input.getField().tabIndex=val||""});option("autofocus",null);option("direction","ltr",function(cm,val){return cm.doc.setDirection(val)},true)}function guttersChanged(cm){updateGutters(cm);regChange(cm);alignHorizontally(cm)}function dragDropChanged(cm,value,old){var wasOn=old&&old!=Init;if(!value!=!wasOn){var funcs=cm.display.dragFunctions;var toggle=value?on:off;toggle(cm.display.scroller,"dragstart",funcs.start);toggle(cm.display.scroller,"dragenter",funcs.enter);toggle(cm.display.scroller,"dragover",funcs.over);toggle(cm.display.scroller,"dragleave",funcs.leave);toggle(cm.display.scroller,"drop",funcs.drop)}}function wrappingChanged(cm){if(cm.options.lineWrapping){addClass(cm.display.wrapper,"CodeMirror-wrap");cm.display.sizer.style.minWidth="";cm.display.sizerWidth=null}else{rmClass(cm.display.wrapper,"CodeMirror-wrap");findMaxLine(cm)}estimateLineHeights(cm);regChange(cm);clearCaches(cm);setTimeout(function(){return updateScrollbars(cm)},100)}function CodeMirror$1(place,options){var this$1=this;if(!(this instanceof CodeMirror$1)){return new CodeMirror$1(place,options)}this.options=options=options?copyObj(options):{};copyObj(defaults,options,false);setGuttersForLineNumbers(options);var doc=options.value;if(typeof doc=="string"){doc=new Doc(doc,options.mode,null,options.lineSeparator,options.direction)}this.doc=doc;var input=new CodeMirror$1.inputStyles[options.inputStyle](this);var display=this.display=new Display(place,doc,input);display.wrapper.CodeMirror=this;updateGutters(this);themeChanged(this);if(options.lineWrapping){this.display.wrapper.className+=" CodeMirror-wrap"}initScrollbars(this);this.state={keyMaps:[],overlays:[],modeGen:0,overwrite:false,delayingBlurEvent:false,focused:false,suppressEdits:false,pasteIncoming:false,cutIncoming:false,selectingText:false,draggingText:false,highlight:new Delayed,keySeq:null,specialChars:null};if(options.autofocus&&!mobile){display.input.focus()}if(ie&&ie_version<11){setTimeout(function(){return this$1.display.input.reset(true)},20)}registerEventHandlers(this);ensureGlobalHandlers();startOperation(this);this.curOp.forceUpdate=true;attachDoc(this,doc);if(options.autofocus&&!mobile||this.hasFocus()){setTimeout(bind(onFocus,this),20)}else{onBlur(this)}for(var opt in optionHandlers){if(optionHandlers.hasOwnProperty(opt)){optionHandlers[opt](this$1,options[opt],Init)}}maybeUpdateLineNumberWidth(this);if(options.finishInit){options.finishInit(this)}for(var i=0;i<initHooks.length;++i){initHooks[i](this$1)}endOperation(this);if(webkit&&options.lineWrapping&&getComputedStyle(display.lineDiv).textRendering=="optimizelegibility"){display.lineDiv.style.textRendering="auto"}}CodeMirror$1.defaults=defaults;CodeMirror$1.optionHandlers=optionHandlers;function registerEventHandlers(cm){var d=cm.display;on(d.scroller,"mousedown",operation(cm,onMouseDown));if(ie&&ie_version<11){on(d.scroller,"dblclick",operation(cm,function(e){if(signalDOMEvent(cm,e)){return}var pos=posFromMouse(cm,e);if(!pos||clickInGutter(cm,e)||eventInWidget(cm.display,e)){return}e_preventDefault(e);var word=cm.findWordAt(pos);extendSelection(cm.doc,word.anchor,word.head)}))}else{on(d.scroller,"dblclick",function(e){return signalDOMEvent(cm,e)||e_preventDefault(e)})}if(!captureRightClick){on(d.scroller,"contextmenu",function(e){return onContextMenu(cm,e)})}var touchFinished,prevTouch={end:0};function finishTouch(){if(d.activeTouch){touchFinished=setTimeout(function(){return d.activeTouch=null},1e3);prevTouch=d.activeTouch;prevTouch.end=+new Date}}function isMouseLikeTouchEvent(e){if(e.touches.length!=1){return false}var touch=e.touches[0];return touch.radiusX<=1&&touch.radiusY<=1}function farAway(touch,other){if(other.left==null){return true}var dx=other.left-touch.left,dy=other.top-touch.top;return dx*dx+dy*dy>20*20}on(d.scroller,"touchstart",function(e){if(!signalDOMEvent(cm,e)&&!isMouseLikeTouchEvent(e)){d.input.ensurePolled();clearTimeout(touchFinished);var now=+new Date;d.activeTouch={start:now,moved:false,prev:now-prevTouch.end<=300?prevTouch:null};if(e.touches.length==1){d.activeTouch.left=e.touches[0].pageX;d.activeTouch.top=e.touches[0].pageY}}});on(d.scroller,"touchmove",function(){if(d.activeTouch){d.activeTouch.moved=true}});on(d.scroller,"touchend",function(e){var touch=d.activeTouch;if(touch&&!eventInWidget(d,e)&&touch.left!=null&&!touch.moved&&new Date-touch.start<300){var pos=cm.coordsChar(d.activeTouch,"page"),range;if(!touch.prev||farAway(touch,touch.prev)){range=new Range(pos,pos)}else if(!touch.prev.prev||farAway(touch,touch.prev.prev)){range=cm.findWordAt(pos)}else{range=new Range(Pos(pos.line,0),clipPos(cm.doc,Pos(pos.line+1,0)))}cm.setSelection(range.anchor,range.head);cm.focus();e_preventDefault(e)}finishTouch()});on(d.scroller,"touchcancel",finishTouch);on(d.scroller,"scroll",function(){if(d.scroller.clientHeight){updateScrollTop(cm,d.scroller.scrollTop);setScrollLeft(cm,d.scroller.scrollLeft,true);signal(cm,"scroll",cm)}});on(d.scroller,"mousewheel",function(e){return onScrollWheel(cm,e)});on(d.scroller,"DOMMouseScroll",function(e){return onScrollWheel(cm,e)});on(d.wrapper,"scroll",function(){return d.wrapper.scrollTop=d.wrapper.scrollLeft=0});d.dragFunctions={enter:function(e){if(!signalDOMEvent(cm,e)){e_stop(e)}},over:function(e){if(!signalDOMEvent(cm,e)){onDragOver(cm,e);e_stop(e)}},start:function(e){return onDragStart(cm,e)},drop:operation(cm,onDrop),leave:function(e){if(!signalDOMEvent(cm,e)){clearDragCursor(cm)}}};var inp=d.input.getField();on(inp,"keyup",function(e){return onKeyUp.call(cm,e)});on(inp,"keydown",operation(cm,onKeyDown));on(inp,"keypress",operation(cm,onKeyPress));on(inp,"focus",function(e){return onFocus(cm,e)});on(inp,"blur",function(e){return onBlur(cm,e)})}var initHooks=[];CodeMirror$1.defineInitHook=function(f){return initHooks.push(f)};function indentLine(cm,n,how,aggressive){var doc=cm.doc,state;if(how==null){how="add"}if(how=="smart"){if(!doc.mode.indent){how="prev"}else{state=getContextBefore(cm,n).state}}var tabSize=cm.options.tabSize;var line=getLine(doc,n),curSpace=countColumn(line.text,null,tabSize);if(line.stateAfter){line.stateAfter=null}var curSpaceString=line.text.match(/^\s*/)[0],indentation;if(!aggressive&&!/\S/.test(line.text)){indentation=0;how="not"}else if(how=="smart"){indentation=doc.mode.indent(state,line.text.slice(curSpaceString.length),line.text);if(indentation==Pass||indentation>150){if(!aggressive){return}how="prev"}}if(how=="prev"){if(n>doc.first){indentation=countColumn(getLine(doc,n-1).text,null,tabSize)}else{indentation=0}}else if(how=="add"){indentation=curSpace+cm.options.indentUnit}else if(how=="subtract"){indentation=curSpace-cm.options.indentUnit}else if(typeof how=="number"){indentation=curSpace+how}indentation=Math.max(0,indentation);var indentString="",pos=0;if(cm.options.indentWithTabs){for(var i=Math.floor(indentation/tabSize);i;--i){pos+=tabSize;indentString+="\t"}}if(pos<indentation){indentString+=spaceStr(indentation-pos)}if(indentString!=curSpaceString){replaceRange(doc,indentString,Pos(n,0),Pos(n,curSpaceString.length),"+input");line.stateAfter=null;return true}else{for(var i$1=0;i$1<doc.sel.ranges.length;i$1++){var range=doc.sel.ranges[i$1];if(range.head.line==n&&range.head.ch<curSpaceString.length){var pos$1=Pos(n,curSpaceString.length);replaceOneSelection(doc,i$1,new Range(pos$1,pos$1));break}}}}var lastCopied=null;function setLastCopied(newLastCopied){lastCopied=newLastCopied}function applyTextInput(cm,inserted,deleted,sel,origin){var doc=cm.doc;cm.display.shift=false;if(!sel){sel=doc.sel}var paste=cm.state.pasteIncoming||origin=="paste";var textLines=splitLinesAuto(inserted),multiPaste=null;if(paste&&sel.ranges.length>1){if(lastCopied&&lastCopied.text.join("\n")==inserted){if(sel.ranges.length%lastCopied.text.length==0){multiPaste=[];for(var i=0;i<lastCopied.text.length;i++){multiPaste.push(doc.splitLines(lastCopied.text[i]))}}}else if(textLines.length==sel.ranges.length&&cm.options.pasteLinesPerSelection){multiPaste=map(textLines,function(l){return[l]})}}var updateInput;for(var i$1=sel.ranges.length-1;i$1>=0;i$1--){var range$$1=sel.ranges[i$1];var from=range$$1.from(),to=range$$1.to();if(range$$1.empty()){if(deleted&&deleted>0){from=Pos(from.line,from.ch-deleted)}else if(cm.state.overwrite&&!paste){to=Pos(to.line,Math.min(getLine(doc,to.line).text.length,to.ch+lst(textLines).length))}else if(lastCopied&&lastCopied.lineWise&&lastCopied.text.join("\n")==inserted){from=to=Pos(from.line,0)}}updateInput=cm.curOp.updateInput;var changeEvent={from:from,to:to,text:multiPaste?multiPaste[i$1%multiPaste.length]:textLines,origin:origin||(paste?"paste":cm.state.cutIncoming?"cut":"+input")};makeChange(cm.doc,changeEvent);signalLater(cm,"inputRead",cm,changeEvent)}if(inserted&&!paste){triggerElectric(cm,inserted)}ensureCursorVisible(cm);cm.curOp.updateInput=updateInput;cm.curOp.typing=true;cm.state.pasteIncoming=cm.state.cutIncoming=false}function handlePaste(e,cm){var pasted=e.clipboardData&&e.clipboardData.getData("Text");if(pasted){e.preventDefault();if(!cm.isReadOnly()&&!cm.options.disableInput){runInOp(cm,function(){return applyTextInput(cm,pasted,0,null,"paste")})}return true}}function triggerElectric(cm,inserted){if(!cm.options.electricChars||!cm.options.smartIndent){return}var sel=cm.doc.sel;for(var i=sel.ranges.length-1;i>=0;i--){var range$$1=sel.ranges[i];if(range$$1.head.ch>100||i&&sel.ranges[i-1].head.line==range$$1.head.line){continue}var mode=cm.getModeAt(range$$1.head);var indented=false;if(mode.electricChars){for(var j=0;j<mode.electricChars.length;j++){if(inserted.indexOf(mode.electricChars.charAt(j))>-1){indented=indentLine(cm,range$$1.head.line,"smart");break}}}else if(mode.electricInput){if(mode.electricInput.test(getLine(cm.doc,range$$1.head.line).text.slice(0,range$$1.head.ch))){indented=indentLine(cm,range$$1.head.line,"smart")}}if(indented){signalLater(cm,"electricInput",cm,range$$1.head.line)}}}function copyableRanges(cm){var text=[],ranges=[];for(var i=0;i<cm.doc.sel.ranges.length;i++){var line=cm.doc.sel.ranges[i].head.line;var lineRange={anchor:Pos(line,0),head:Pos(line+1,0)};ranges.push(lineRange);text.push(cm.getRange(lineRange.anchor,lineRange.head))}return{text:text,ranges:ranges}}function disableBrowserMagic(field,spellcheck){field.setAttribute("autocorrect","off");field.setAttribute("autocapitalize","off");field.setAttribute("spellcheck",!!spellcheck)}function hiddenTextarea(){var te=elt("textarea",null,null,"position: absolute; bottom: -1em; padding: 0; width: 1px; height: 1em; outline: none");var div=elt("div",[te],null,"overflow: hidden; position: relative; width: 3px; height: 0px;");if(webkit){te.style.width="1000px"}else{te.setAttribute("wrap","off")}if(ios){te.style.border="1px solid black"}disableBrowserMagic(te);return div}var addEditorMethods=function(CodeMirror){var optionHandlers=CodeMirror.optionHandlers;var helpers=CodeMirror.helpers={};CodeMirror.prototype={constructor:CodeMirror,focus:function(){window.focus();this.display.input.focus()},setOption:function(option,value){var options=this.options,old=options[option];if(options[option]==value&&option!="mode"){return}options[option]=value;if(optionHandlers.hasOwnProperty(option)){operation(this,optionHandlers[option])(this,value,old)}signal(this,"optionChange",this,option)},getOption:function(option){return this.options[option]},getDoc:function(){return this.doc},addKeyMap:function(map$$1,bottom){this.state.keyMaps[bottom?"push":"unshift"](getKeyMap(map$$1))},removeKeyMap:function(map$$1){var maps=this.state.keyMaps;for(var i=0;i<maps.length;++i){if(maps[i]==map$$1||maps[i].name==map$$1){maps.splice(i,1);return true}}},addOverlay:methodOp(function(spec,options){var mode=spec.token?spec:CodeMirror.getMode(this.options,spec);if(mode.startState){throw new Error("Overlays may not be stateful.")}insertSorted(this.state.overlays,{mode:mode,modeSpec:spec,opaque:options&&options.opaque,priority:options&&options.priority||0},function(overlay){return overlay.priority});this.state.modeGen++;regChange(this)}),removeOverlay:methodOp(function(spec){var this$1=this;var overlays=this.state.overlays;for(var i=0;i<overlays.length;++i){var cur=overlays[i].modeSpec;if(cur==spec||typeof spec=="string"&&cur.name==spec){overlays.splice(i,1);this$1.state.modeGen++;regChange(this$1);return}}}),indentLine:methodOp(function(n,dir,aggressive){if(typeof dir!="string"&&typeof dir!="number"){if(dir==null){dir=this.options.smartIndent?"smart":"prev"}else{dir=dir?"add":"subtract"}}if(isLine(this.doc,n)){indentLine(this,n,dir,aggressive)}}),indentSelection:methodOp(function(how){var this$1=this;var ranges=this.doc.sel.ranges,end=-1;for(var i=0;i<ranges.length;i++){var range$$1=ranges[i];if(!range$$1.empty()){var from=range$$1.from(),to=range$$1.to();var start=Math.max(end,from.line);end=Math.min(this$1.lastLine(),to.line-(to.ch?0:1))+1;for(var j=start;j<end;++j){indentLine(this$1,j,how)}var newRanges=this$1.doc.sel.ranges;if(from.ch==0&&ranges.length==newRanges.length&&newRanges[i].from().ch>0){replaceOneSelection(this$1.doc,i,new Range(from,newRanges[i].to()),sel_dontScroll)}}else if(range$$1.head.line>end){indentLine(this$1,range$$1.head.line,how,true);end=range$$1.head.line;if(i==this$1.doc.sel.primIndex){ensureCursorVisible(this$1)}}}}),getTokenAt:function(pos,precise){return takeToken(this,pos,precise)},getLineTokens:function(line,precise){return takeToken(this,Pos(line),precise,true)},getTokenTypeAt:function(pos){pos=clipPos(this.doc,pos);var styles=getLineStyles(this,getLine(this.doc,pos.line));var before=0,after=(styles.length-1)/2,ch=pos.ch;var type;if(ch==0){type=styles[2]}else{for(;;){var mid=before+after>>1;if((mid?styles[mid*2-1]:0)>=ch){after=mid}else if(styles[mid*2+1]<ch){before=mid+1}else{type=styles[mid*2+2];break}}}var cut=type?type.indexOf("overlay "):-1;return cut<0?type:cut==0?null:type.slice(0,cut-1)},getModeAt:function(pos){var mode=this.doc.mode;if(!mode.innerMode){return mode}return CodeMirror.innerMode(mode,this.getTokenAt(pos).state).mode},getHelper:function(pos,type){return this.getHelpers(pos,type)[0]},getHelpers:function(pos,type){var this$1=this;var found=[];if(!helpers.hasOwnProperty(type)){return found}var help=helpers[type],mode=this.getModeAt(pos);if(typeof mode[type]=="string"){if(help[mode[type]]){found.push(help[mode[type]])}}else if(mode[type]){for(var i=0;i<mode[type].length;i++){var val=help[mode[type][i]];if(val){found.push(val)}}}else if(mode.helperType&&help[mode.helperType]){found.push(help[mode.helperType])}else if(help[mode.name]){found.push(help[mode.name])}for(var i$1=0;i$1<help._global.length;i$1++){var cur=help._global[i$1];if(cur.pred(mode,this$1)&&indexOf(found,cur.val)==-1){found.push(cur.val)}}return found},getStateAfter:function(line,precise){var doc=this.doc;line=clipLine(doc,line==null?doc.first+doc.size-1:line);return getContextBefore(this,line+1,precise).state},cursorCoords:function(start,mode){var pos,range$$1=this.doc.sel.primary();if(start==null){pos=range$$1.head}else if(typeof start=="object"){pos=clipPos(this.doc,start)}else{pos=start?range$$1.from():range$$1.to()}return cursorCoords(this,pos,mode||"page")},charCoords:function(pos,mode){return charCoords(this,clipPos(this.doc,pos),mode||"page")},coordsChar:function(coords,mode){coords=fromCoordSystem(this,coords,mode||"page");return coordsChar(this,coords.left,coords.top)},lineAtHeight:function(height,mode){height=fromCoordSystem(this,{top:height,left:0},mode||"page").top;return lineAtHeight(this.doc,height+this.display.viewOffset)},heightAtLine:function(line,mode,includeWidgets){var end=false,lineObj;if(typeof line=="number"){var last=this.doc.first+this.doc.size-1;if(line<this.doc.first){line=this.doc.first}else if(line>last){line=last;end=true}lineObj=getLine(this.doc,line)}else{lineObj=line}return intoCoordSystem(this,lineObj,{top:0,left:0},mode||"page",includeWidgets||end).top+(end?this.doc.height-heightAtLine(lineObj):0)},defaultTextHeight:function(){return textHeight(this.display)},defaultCharWidth:function(){return charWidth(this.display)},getViewport:function(){return{from:this.display.viewFrom,to:this.display.viewTo}},addWidget:function(pos,node,scroll,vert,horiz){var display=this.display;pos=cursorCoords(this,clipPos(this.doc,pos));var top=pos.bottom,left=pos.left;node.style.position="absolute";node.setAttribute("cm-ignore-events","true");this.display.input.setUneditable(node);display.sizer.appendChild(node);if(vert=="over"){top=pos.top}else if(vert=="above"||vert=="near"){var vspace=Math.max(display.wrapper.clientHeight,this.doc.height),hspace=Math.max(display.sizer.clientWidth,display.lineSpace.clientWidth);if((vert=="above"||pos.bottom+node.offsetHeight>vspace)&&pos.top>node.offsetHeight){top=pos.top-node.offsetHeight}else if(pos.bottom+node.offsetHeight<=vspace){top=pos.bottom}if(left+node.offsetWidth>hspace){left=hspace-node.offsetWidth}}node.style.top=top+"px";node.style.left=node.style.right="";if(horiz=="right"){left=display.sizer.clientWidth-node.offsetWidth;node.style.right="0px"}else{if(horiz=="left"){left=0}else if(horiz=="middle"){left=(display.sizer.clientWidth-node.offsetWidth)/2}node.style.left=left+"px"}if(scroll){scrollIntoView(this,{left:left,top:top,right:left+node.offsetWidth,bottom:top+node.offsetHeight})}},triggerOnKeyDown:methodOp(onKeyDown),triggerOnKeyPress:methodOp(onKeyPress),triggerOnKeyUp:onKeyUp,triggerOnMouseDown:methodOp(onMouseDown),execCommand:function(cmd){if(commands.hasOwnProperty(cmd)){return commands[cmd].call(null,this)}},triggerElectric:methodOp(function(text){triggerElectric(this,text)}),findPosH:function(from,amount,unit,visually){var this$1=this;var dir=1;if(amount<0){dir=-1;amount=-amount}var cur=clipPos(this.doc,from);for(var i=0;i<amount;++i){cur=findPosH(this$1.doc,cur,dir,unit,visually);if(cur.hitSide){break}}return cur},moveH:methodOp(function(dir,unit){var this$1=this;this.extendSelectionsBy(function(range$$1){if(this$1.display.shift||this$1.doc.extend||range$$1.empty()){return findPosH(this$1.doc,range$$1.head,dir,unit,this$1.options.rtlMoveVisually)}else{return dir<0?range$$1.from():range$$1.to()}},sel_move)}),deleteH:methodOp(function(dir,unit){var sel=this.doc.sel,doc=this.doc;if(sel.somethingSelected()){doc.replaceSelection("",null,"+delete")}else{deleteNearSelection(this,function(range$$1){var other=findPosH(doc,range$$1.head,dir,unit,false);return dir<0?{from:other,to:range$$1.head}:{from:range$$1.head,to:other}})}}),findPosV:function(from,amount,unit,goalColumn){var this$1=this;var dir=1,x=goalColumn;if(amount<0){dir=-1;amount=-amount}var cur=clipPos(this.doc,from);for(var i=0;i<amount;++i){var coords=cursorCoords(this$1,cur,"div");if(x==null){x=coords.left}else{coords.left=x}cur=findPosV(this$1,coords,dir,unit);if(cur.hitSide){break}}return cur},moveV:methodOp(function(dir,unit){var this$1=this;var doc=this.doc,goals=[];var collapse=!this.display.shift&&!doc.extend&&doc.sel.somethingSelected();doc.extendSelectionsBy(function(range$$1){if(collapse){return dir<0?range$$1.from():range$$1.to()}var headPos=cursorCoords(this$1,range$$1.head,"div");if(range$$1.goalColumn!=null){headPos.left=range$$1.goalColumn}goals.push(headPos.left);var pos=findPosV(this$1,headPos,dir,unit);if(unit=="page"&&range$$1==doc.sel.primary()){addToScrollTop(this$1,charCoords(this$1,pos,"div").top-headPos.top)}return pos},sel_move);if(goals.length){for(var i=0;i<doc.sel.ranges.length;i++){doc.sel.ranges[i].goalColumn=goals[i]}}}),findWordAt:function(pos){var doc=this.doc,line=getLine(doc,pos.line).text;var start=pos.ch,end=pos.ch;if(line){var helper=this.getHelper(pos,"wordChars");if((pos.sticky=="before"||end==line.length)&&start){--start}else{++end}var startChar=line.charAt(start);var check=isWordChar(startChar,helper)?function(ch){return isWordChar(ch,helper)}:/\s/.test(startChar)?function(ch){return/\s/.test(ch)}:function(ch){return!/\s/.test(ch)&&!isWordChar(ch)};while(start>0&&check(line.charAt(start-1))){--start}while(end<line.length&&check(line.charAt(end))){++end}}return new Range(Pos(pos.line,start),Pos(pos.line,end))},toggleOverwrite:function(value){if(value!=null&&value==this.state.overwrite){return}if(this.state.overwrite=!this.state.overwrite){addClass(this.display.cursorDiv,"CodeMirror-overwrite")}else{rmClass(this.display.cursorDiv,"CodeMirror-overwrite")}signal(this,"overwriteToggle",this,this.state.overwrite)},hasFocus:function(){return this.display.input.getField()==activeElt()},isReadOnly:function(){return!!(this.options.readOnly||this.doc.cantEdit)},scrollTo:methodOp(function(x,y){scrollToCoords(this,x,y)}),getScrollInfo:function(){var scroller=this.display.scroller;return{left:scroller.scrollLeft,top:scroller.scrollTop,height:scroller.scrollHeight-scrollGap(this)-this.display.barHeight,width:scroller.scrollWidth-scrollGap(this)-this.display.barWidth,clientHeight:displayHeight(this),clientWidth:displayWidth(this)}},scrollIntoView:methodOp(function(range$$1,margin){if(range$$1==null){range$$1={from:this.doc.sel.primary().head,to:null};if(margin==null){margin=this.options.cursorScrollMargin}}else if(typeof range$$1=="number"){range$$1={from:Pos(range$$1,0),to:null}}else if(range$$1.from==null){range$$1={from:range$$1,to:null}}if(!range$$1.to){range$$1.to=range$$1.from}range$$1.margin=margin||0;if(range$$1.from.line!=null){scrollToRange(this,range$$1)}else{scrollToCoordsRange(this,range$$1.from,range$$1.to,range$$1.margin)}}),setSize:methodOp(function(width,height){var this$1=this;var interpret=function(val){return typeof val=="number"||/^\d+$/.test(String(val))?val+"px":val};if(width!=null){this.display.wrapper.style.width=interpret(width)}if(height!=null){this.display.wrapper.style.height=interpret(height)}if(this.options.lineWrapping){clearLineMeasurementCache(this)}var lineNo$$1=this.display.viewFrom;this.doc.iter(lineNo$$1,this.display.viewTo,function(line){if(line.widgets){for(var i=0;i<line.widgets.length;i++){if(line.widgets[i].noHScroll){regLineChange(this$1,lineNo$$1,"widget");break}}}++lineNo$$1});this.curOp.forceUpdate=true;signal(this,"refresh",this)}),operation:function(f){return runInOp(this,f)},refresh:methodOp(function(){var oldHeight=this.display.cachedTextHeight;regChange(this);this.curOp.forceUpdate=true;clearCaches(this);scrollToCoords(this,this.doc.scrollLeft,this.doc.scrollTop);updateGutterSpace(this);if(oldHeight==null||Math.abs(oldHeight-textHeight(this.display))>.5){estimateLineHeights(this)}signal(this,"refresh",this)}),swapDoc:methodOp(function(doc){var old=this.doc;old.cm=null;attachDoc(this,doc);clearCaches(this);this.display.input.reset();scrollToCoords(this,doc.scrollLeft,doc.scrollTop);this.curOp.forceScroll=true;signalLater(this,"swapDoc",this,old);return old}),getInputField:function(){return this.display.input.getField()},getWrapperElement:function(){return this.display.wrapper},getScrollerElement:function(){return this.display.scroller},getGutterElement:function(){return this.display.gutters}};eventMixin(CodeMirror);CodeMirror.registerHelper=function(type,name,value){if(!helpers.hasOwnProperty(type)){helpers[type]=CodeMirror[type]={_global:[]}}helpers[type][name]=value};CodeMirror.registerGlobalHelper=function(type,name,predicate,value){CodeMirror.registerHelper(type,name,value);helpers[type]._global.push({pred:predicate,val:value})}};function findPosH(doc,pos,dir,unit,visually){var oldPos=pos;var origDir=dir;var lineObj=getLine(doc,pos.line);function findNextLine(){var l=pos.line+dir;if(l<doc.first||l>=doc.first+doc.size){return false}pos=new Pos(l,pos.ch,pos.sticky);return lineObj=getLine(doc,l)}function moveOnce(boundToLine){var next;if(visually){next=moveVisually(doc.cm,lineObj,pos,dir)}else{next=moveLogically(lineObj,pos,dir)}if(next==null){if(!boundToLine&&findNextLine()){pos=endOfLine(visually,doc.cm,lineObj,pos.line,dir)}else{return false}}else{pos=next}return true}if(unit=="char"){moveOnce()}else if(unit=="column"){moveOnce(true)}else if(unit=="word"||unit=="group"){var sawType=null,group=unit=="group";var helper=doc.cm&&doc.cm.getHelper(pos,"wordChars");for(var first=true;;first=false){if(dir<0&&!moveOnce(!first)){break}var cur=lineObj.text.charAt(pos.ch)||"\n";var type=isWordChar(cur,helper)?"w":group&&cur=="\n"?"n":!group||/\s/.test(cur)?null:"p";if(group&&!first&&!type){type="s"}if(sawType&&sawType!=type){if(dir<0){dir=1;moveOnce();pos.sticky="after"}break}if(type){sawType=type}if(dir>0&&!moveOnce(!first)){break}}}var result=skipAtomic(doc,pos,oldPos,origDir,true);if(equalCursorPos(oldPos,result)){result.hitSide=true}return result}function findPosV(cm,pos,dir,unit){var doc=cm.doc,x=pos.left,y;if(unit=="page"){var pageSize=Math.min(cm.display.wrapper.clientHeight,window.innerHeight||document.documentElement.clientHeight);var moveAmount=Math.max(pageSize-.5*textHeight(cm.display),3);y=(dir>0?pos.bottom:pos.top)+dir*moveAmount}else if(unit=="line"){y=dir>0?pos.bottom+3:pos.top-3}var target;for(;;){target=coordsChar(cm,x,y);if(!target.outside){break}if(dir<0?y<=0:y>=doc.height){target.hitSide=true;break}y+=dir*5}return target}var ContentEditableInput=function(cm){this.cm=cm;this.lastAnchorNode=this.lastAnchorOffset=this.lastFocusNode=this.lastFocusOffset=null;this.polling=new Delayed;this.composing=null;this.gracePeriod=false;this.readDOMTimeout=null};ContentEditableInput.prototype.init=function(display){var this$1=this;var input=this,cm=input.cm;var div=input.div=display.lineDiv;disableBrowserMagic(div,cm.options.spellcheck);on(div,"paste",function(e){if(signalDOMEvent(cm,e)||handlePaste(e,cm)){return}if(ie_version<=11){setTimeout(operation(cm,function(){return this$1.updateFromDOM()}),20)}});on(div,"compositionstart",function(e){this$1.composing={data:e.data,done:false}});on(div,"compositionupdate",function(e){if(!this$1.composing){this$1.composing={data:e.data,done:false}}});on(div,"compositionend",function(e){if(this$1.composing){if(e.data!=this$1.composing.data){this$1.readFromDOMSoon()}this$1.composing.done=true}});on(div,"touchstart",function(){return input.forceCompositionEnd()});on(div,"input",function(){if(!this$1.composing){this$1.readFromDOMSoon()}});function onCopyCut(e){if(signalDOMEvent(cm,e)){return}if(cm.somethingSelected()){setLastCopied({lineWise:false,text:cm.getSelections()});if(e.type=="cut"){cm.replaceSelection("",null,"cut")}}else if(!cm.options.lineWiseCopyCut){return}else{var ranges=copyableRanges(cm);setLastCopied({lineWise:true,text:ranges.text});if(e.type=="cut"){cm.operation(function(){cm.setSelections(ranges.ranges,0,sel_dontScroll);cm.replaceSelection("",null,"cut")})}}if(e.clipboardData){e.clipboardData.clearData();var content=lastCopied.text.join("\n");e.clipboardData.setData("Text",content);if(e.clipboardData.getData("Text")==content){e.preventDefault();return}}var kludge=hiddenTextarea(),te=kludge.firstChild;cm.display.lineSpace.insertBefore(kludge,cm.display.lineSpace.firstChild);te.value=lastCopied.text.join("\n");var hadFocus=document.activeElement;selectInput(te);setTimeout(function(){cm.display.lineSpace.removeChild(kludge);hadFocus.focus();if(hadFocus==div){input.showPrimarySelection()}},50)}on(div,"copy",onCopyCut);on(div,"cut",onCopyCut)};ContentEditableInput.prototype.prepareSelection=function(){var result=prepareSelection(this.cm,false);result.focus=this.cm.state.focused;return result};ContentEditableInput.prototype.showSelection=function(info,takeFocus){if(!info||!this.cm.display.view.length){return}if(info.focus||takeFocus){this.showPrimarySelection()}this.showMultipleSelections(info)};ContentEditableInput.prototype.showPrimarySelection=function(){var sel=window.getSelection(),cm=this.cm,prim=cm.doc.sel.primary();var from=prim.from(),to=prim.to();if(cm.display.viewTo==cm.display.viewFrom||from.line>=cm.display.viewTo||to.line<cm.display.viewFrom){sel.removeAllRanges();return}var curAnchor=domToPos(cm,sel.anchorNode,sel.anchorOffset);var curFocus=domToPos(cm,sel.focusNode,sel.focusOffset);if(curAnchor&&!curAnchor.bad&&curFocus&&!curFocus.bad&&cmp(minPos(curAnchor,curFocus),from)==0&&cmp(maxPos(curAnchor,curFocus),to)==0){return}var view=cm.display.view;var start=from.line>=cm.display.viewFrom&&posToDOM(cm,from)||{node:view[0].measure.map[2],offset:0};var end=to.line<cm.display.viewTo&&posToDOM(cm,to);if(!end){var measure=view[view.length-1].measure;var map$$1=measure.maps?measure.maps[measure.maps.length-1]:measure.map;end={node:map$$1[map$$1.length-1],offset:map$$1[map$$1.length-2]-map$$1[map$$1.length-3]}}if(!start||!end){sel.removeAllRanges();return}var old=sel.rangeCount&&sel.getRangeAt(0),rng;try{rng=range(start.node,start.offset,end.offset,end.node)}catch(e){}if(rng){if(!gecko&&cm.state.focused){sel.collapse(start.node,start.offset);if(!rng.collapsed){sel.removeAllRanges();sel.addRange(rng)}}else{sel.removeAllRanges();sel.addRange(rng)}if(old&&sel.anchorNode==null){sel.addRange(old)}else if(gecko){this.startGracePeriod()}}this.rememberSelection()};ContentEditableInput.prototype.startGracePeriod=function(){var this$1=this;clearTimeout(this.gracePeriod);this.gracePeriod=setTimeout(function(){this$1.gracePeriod=false;if(this$1.selectionChanged()){this$1.cm.operation(function(){return this$1.cm.curOp.selectionChanged=true})}},20)};ContentEditableInput.prototype.showMultipleSelections=function(info){removeChildrenAndAdd(this.cm.display.cursorDiv,info.cursors);removeChildrenAndAdd(this.cm.display.selectionDiv,info.selection)};ContentEditableInput.prototype.rememberSelection=function(){var sel=window.getSelection();this.lastAnchorNode=sel.anchorNode;this.lastAnchorOffset=sel.anchorOffset;this.lastFocusNode=sel.focusNode;this.lastFocusOffset=sel.focusOffset};ContentEditableInput.prototype.selectionInEditor=function(){var sel=window.getSelection();if(!sel.rangeCount){return false}var node=sel.getRangeAt(0).commonAncestorContainer;return contains(this.div,node)};ContentEditableInput.prototype.focus=function(){if(this.cm.options.readOnly!="nocursor"){if(!this.selectionInEditor()){this.showSelection(this.prepareSelection(),true)}this.div.focus()}};ContentEditableInput.prototype.blur=function(){this.div.blur()};ContentEditableInput.prototype.getField=function(){return this.div};ContentEditableInput.prototype.supportsTouch=function(){return true};ContentEditableInput.prototype.receivedFocus=function(){var input=this;if(this.selectionInEditor()){this.pollSelection()}else{runInOp(this.cm,function(){return input.cm.curOp.selectionChanged=true})}function poll(){if(input.cm.state.focused){input.pollSelection();input.polling.set(input.cm.options.pollInterval,poll)}}this.polling.set(this.cm.options.pollInterval,poll)};ContentEditableInput.prototype.selectionChanged=function(){var sel=window.getSelection();return sel.anchorNode!=this.lastAnchorNode||sel.anchorOffset!=this.lastAnchorOffset||sel.focusNode!=this.lastFocusNode||sel.focusOffset!=this.lastFocusOffset};ContentEditableInput.prototype.pollSelection=function(){if(this.readDOMTimeout!=null||this.gracePeriod||!this.selectionChanged()){return}var sel=window.getSelection(),cm=this.cm;if(android&&chrome&&this.cm.options.gutters.length&&isInGutter(sel.anchorNode)){this.cm.triggerOnKeyDown({type:"keydown",keyCode:8,preventDefault:Math.abs});this.blur();this.focus();return}if(this.composing){return}this.rememberSelection();var anchor=domToPos(cm,sel.anchorNode,sel.anchorOffset);var head=domToPos(cm,sel.focusNode,sel.focusOffset);if(anchor&&head){runInOp(cm,function(){setSelection(cm.doc,simpleSelection(anchor,head),sel_dontScroll);if(anchor.bad||head.bad){cm.curOp.selectionChanged=true}})}};ContentEditableInput.prototype.pollContent=function(){if(this.readDOMTimeout!=null){clearTimeout(this.readDOMTimeout);this.readDOMTimeout=null}var cm=this.cm,display=cm.display,sel=cm.doc.sel.primary();var from=sel.from(),to=sel.to();if(from.ch==0&&from.line>cm.firstLine()){from=Pos(from.line-1,getLine(cm.doc,from.line-1).length)}if(to.ch==getLine(cm.doc,to.line).text.length&&to.line<cm.lastLine()){to=Pos(to.line+1,0)}if(from.line<display.viewFrom||to.line>display.viewTo-1){return false}var fromIndex,fromLine,fromNode;if(from.line==display.viewFrom||(fromIndex=findViewIndex(cm,from.line))==0){fromLine=lineNo(display.view[0].line);fromNode=display.view[0].node}else{fromLine=lineNo(display.view[fromIndex].line);fromNode=display.view[fromIndex-1].node.nextSibling}var toIndex=findViewIndex(cm,to.line);var toLine,toNode;if(toIndex==display.view.length-1){toLine=display.viewTo-1;toNode=display.lineDiv.lastChild}else{toLine=lineNo(display.view[toIndex+1].line)-1;toNode=display.view[toIndex+1].node.previousSibling}if(!fromNode){return false}var newText=cm.doc.splitLines(domTextBetween(cm,fromNode,toNode,fromLine,toLine));var oldText=getBetween(cm.doc,Pos(fromLine,0),Pos(toLine,getLine(cm.doc,toLine).text.length));while(newText.length>1&&oldText.length>1){if(lst(newText)==lst(oldText)){newText.pop();oldText.pop();toLine--}else if(newText[0]==oldText[0]){newText.shift();oldText.shift();fromLine++}else{break}}var cutFront=0,cutEnd=0;var newTop=newText[0],oldTop=oldText[0],maxCutFront=Math.min(newTop.length,oldTop.length);while(cutFront<maxCutFront&&newTop.charCodeAt(cutFront)==oldTop.charCodeAt(cutFront)){++cutFront}var newBot=lst(newText),oldBot=lst(oldText);var maxCutEnd=Math.min(newBot.length-(newText.length==1?cutFront:0),oldBot.length-(oldText.length==1?cutFront:0));while(cutEnd<maxCutEnd&&newBot.charCodeAt(newBot.length-cutEnd-1)==oldBot.charCodeAt(oldBot.length-cutEnd-1)){++cutEnd}if(newText.length==1&&oldText.length==1&&fromLine==from.line){while(cutFront&&cutFront>from.ch&&newBot.charCodeAt(newBot.length-cutEnd-1)==oldBot.charCodeAt(oldBot.length-cutEnd-1)){cutFront--;cutEnd++}}newText[newText.length-1]=newBot.slice(0,newBot.length-cutEnd).replace(/^\u200b+/,"");newText[0]=newText[0].slice(cutFront).replace(/\u200b+$/,"");var chFrom=Pos(fromLine,cutFront);var chTo=Pos(toLine,oldText.length?lst(oldText).length-cutEnd:0);if(newText.length>1||newText[0]||cmp(chFrom,chTo)){replaceRange(cm.doc,newText,chFrom,chTo,"+input");return true}};ContentEditableInput.prototype.ensurePolled=function(){this.forceCompositionEnd()};ContentEditableInput.prototype.reset=function(){this.forceCompositionEnd()};ContentEditableInput.prototype.forceCompositionEnd=function(){if(!this.composing){return}clearTimeout(this.readDOMTimeout);this.composing=null;this.updateFromDOM();this.div.blur();this.div.focus()};ContentEditableInput.prototype.readFromDOMSoon=function(){var this$1=this;if(this.readDOMTimeout!=null){return}this.readDOMTimeout=setTimeout(function(){this$1.readDOMTimeout=null;if(this$1.composing){if(this$1.composing.done){this$1.composing=null}else{return}}this$1.updateFromDOM()},80)};ContentEditableInput.prototype.updateFromDOM=function(){var this$1=this;if(this.cm.isReadOnly()||!this.pollContent()){runInOp(this.cm,function(){return regChange(this$1.cm)})}};ContentEditableInput.prototype.setUneditable=function(node){node.contentEditable="false"};ContentEditableInput.prototype.onKeyPress=function(e){if(e.charCode==0){return}e.preventDefault();if(!this.cm.isReadOnly()){operation(this.cm,applyTextInput)(this.cm,String.fromCharCode(e.charCode==null?e.keyCode:e.charCode),0)}};ContentEditableInput.prototype.readOnlyChanged=function(val){this.div.contentEditable=String(val!="nocursor")};ContentEditableInput.prototype.onContextMenu=function(){};ContentEditableInput.prototype.resetPosition=function(){};ContentEditableInput.prototype.needsContentAttribute=true;function posToDOM(cm,pos){var view=findViewForLine(cm,pos.line);if(!view||view.hidden){return null}var line=getLine(cm.doc,pos.line);var info=mapFromLineView(view,line,pos.line);var order=getOrder(line,cm.doc.direction),side="left";if(order){var partPos=getBidiPartAt(order,pos.ch);side=partPos%2?"right":"left"}var result=nodeAndOffsetInLineMap(info.map,pos.ch,side);result.offset=result.collapse=="right"?result.end:result.start;return result}function isInGutter(node){for(var scan=node;scan;scan=scan.parentNode){if(/CodeMirror-gutter-wrapper/.test(scan.className)){return true}}return false}function badPos(pos,bad){if(bad){pos.bad=true}return pos}function domTextBetween(cm,from,to,fromLine,toLine){var text="",closing=false,lineSep=cm.doc.lineSeparator();function recognizeMarker(id){return function(marker){return marker.id==id}}function close(){if(closing){text+=lineSep;closing=false}}function addText(str){if(str){close();text+=str}}function walk(node){if(node.nodeType==1){var cmText=node.getAttribute("cm-text");if(cmText!=null){addText(cmText||node.textContent.replace(/\u200b/g,""));return}var markerID=node.getAttribute("cm-marker"),range$$1;if(markerID){var found=cm.findMarks(Pos(fromLine,0),Pos(toLine+1,0),recognizeMarker(+markerID));if(found.length&&(range$$1=found[0].find())){addText(getBetween(cm.doc,range$$1.from,range$$1.to).join(lineSep))}return}if(node.getAttribute("contenteditable")=="false"){return}var isBlock=/^(pre|div|p)$/i.test(node.nodeName);if(isBlock){close()}for(var i=0;i<node.childNodes.length;i++){walk(node.childNodes[i])}if(isBlock){closing=true}}else if(node.nodeType==3){addText(node.nodeValue)}}for(;;){walk(from);if(from==to){break}from=from.nextSibling}return text}function domToPos(cm,node,offset){var lineNode;if(node==cm.display.lineDiv){lineNode=cm.display.lineDiv.childNodes[offset];if(!lineNode){return badPos(cm.clipPos(Pos(cm.display.viewTo-1)),true)}node=null;offset=0}else{for(lineNode=node;;lineNode=lineNode.parentNode){if(!lineNode||lineNode==cm.display.lineDiv){return null}if(lineNode.parentNode&&lineNode.parentNode==cm.display.lineDiv){break}}}for(var i=0;i<cm.display.view.length;i++){var lineView=cm.display.view[i];if(lineView.node==lineNode){return locateNodeInLineView(lineView,node,offset)}}}function locateNodeInLineView(lineView,node,offset){var wrapper=lineView.text.firstChild,bad=false;if(!node||!contains(wrapper,node)){return badPos(Pos(lineNo(lineView.line),0),true)}if(node==wrapper){bad=true;node=wrapper.childNodes[offset];offset=0;if(!node){var line=lineView.rest?lst(lineView.rest):lineView.line;return badPos(Pos(lineNo(line),line.text.length),bad)}}var textNode=node.nodeType==3?node:null,topNode=node;if(!textNode&&node.childNodes.length==1&&node.firstChild.nodeType==3){textNode=node.firstChild;if(offset){offset=textNode.nodeValue.length}}while(topNode.parentNode!=wrapper){topNode=topNode.parentNode}var measure=lineView.measure,maps=measure.maps;function find(textNode,topNode,offset){for(var i=-1;i<(maps?maps.length:0);i++){var map$$1=i<0?measure.map:maps[i];for(var j=0;j<map$$1.length;j+=3){var curNode=map$$1[j+2];if(curNode==textNode||curNode==topNode){var line=lineNo(i<0?lineView.line:lineView.rest[i]);var ch=map$$1[j]+offset;if(offset<0||curNode!=textNode){ch=map$$1[j+(offset?1:0)]}return Pos(line,ch)}}}}var found=find(textNode,topNode,offset);if(found){return badPos(found,bad)}for(var after=topNode.nextSibling,dist=textNode?textNode.nodeValue.length-offset:0;after;after=after.nextSibling){found=find(after,after.firstChild,0);if(found){return badPos(Pos(found.line,found.ch-dist),bad)}else{dist+=after.textContent.length}}for(var before=topNode.previousSibling,dist$1=offset;before;before=before.previousSibling){found=find(before,before.firstChild,-1);if(found){return badPos(Pos(found.line,found.ch+dist$1),bad)}else{dist$1+=before.textContent.length}}}var TextareaInput=function(cm){this.cm=cm;this.prevInput="";this.pollingFast=false;this.polling=new Delayed;this.inaccurateSelection=false;this.hasSelection=false;this.composing=null};TextareaInput.prototype.init=function(display){var this$1=this;var input=this,cm=this.cm;var div=this.wrapper=hiddenTextarea();var te=this.textarea=div.firstChild;display.wrapper.insertBefore(div,display.wrapper.firstChild);if(ios){te.style.width="0px"}on(te,"input",function(){if(ie&&ie_version>=9&&this$1.hasSelection){this$1.hasSelection=null}input.poll()});on(te,"paste",function(e){if(signalDOMEvent(cm,e)||handlePaste(e,cm)){return}cm.state.pasteIncoming=true;input.fastPoll()});function prepareCopyCut(e){if(signalDOMEvent(cm,e)){return}if(cm.somethingSelected()){setLastCopied({lineWise:false,text:cm.getSelections()});if(input.inaccurateSelection){input.prevInput="";input.inaccurateSelection=false;te.value=lastCopied.text.join("\n");selectInput(te)}}else if(!cm.options.lineWiseCopyCut){return}else{var ranges=copyableRanges(cm);setLastCopied({lineWise:true,text:ranges.text});if(e.type=="cut"){cm.setSelections(ranges.ranges,null,sel_dontScroll)}else{input.prevInput="";te.value=ranges.text.join("\n");selectInput(te)}}if(e.type=="cut"){cm.state.cutIncoming=true}}on(te,"cut",prepareCopyCut);on(te,"copy",prepareCopyCut);on(display.scroller,"paste",function(e){if(eventInWidget(display,e)||signalDOMEvent(cm,e)){return}cm.state.pasteIncoming=true;input.focus()});on(display.lineSpace,"selectstart",function(e){if(!eventInWidget(display,e)){e_preventDefault(e)}});on(te,"compositionstart",function(){var start=cm.getCursor("from");if(input.composing){input.composing.range.clear()}input.composing={start:start,range:cm.markText(start,cm.getCursor("to"),{className:"CodeMirror-composing"})}});on(te,"compositionend",function(){if(input.composing){input.poll();input.composing.range.clear();input.composing=null}})};TextareaInput.prototype.prepareSelection=function(){var cm=this.cm,display=cm.display,doc=cm.doc;var result=prepareSelection(cm);if(cm.options.moveInputWithCursor){var headPos=cursorCoords(cm,doc.sel.primary().head,"div");var wrapOff=display.wrapper.getBoundingClientRect(),lineOff=display.lineDiv.getBoundingClientRect();result.teTop=Math.max(0,Math.min(display.wrapper.clientHeight-10,headPos.top+lineOff.top-wrapOff.top));result.teLeft=Math.max(0,Math.min(display.wrapper.clientWidth-10,headPos.left+lineOff.left-wrapOff.left))}return result};TextareaInput.prototype.showSelection=function(drawn){var cm=this.cm,display=cm.display;removeChildrenAndAdd(display.cursorDiv,drawn.cursors);removeChildrenAndAdd(display.selectionDiv,drawn.selection);if(drawn.teTop!=null){this.wrapper.style.top=drawn.teTop+"px";this.wrapper.style.left=drawn.teLeft+"px"}};TextareaInput.prototype.reset=function(typing){if(this.contextMenuPending||this.composing){return}var minimal,selected,cm=this.cm,doc=cm.doc;if(cm.somethingSelected()){this.prevInput="";var range$$1=doc.sel.primary();minimal=hasCopyEvent&&(range$$1.to().line-range$$1.from().line>100||(selected=cm.getSelection()).length>1e3);var content=minimal?"-":selected||cm.getSelection();this.textarea.value=content;if(cm.state.focused){selectInput(this.textarea)}if(ie&&ie_version>=9){this.hasSelection=content}}else if(!typing){this.prevInput=this.textarea.value="";if(ie&&ie_version>=9){this.hasSelection=null}}this.inaccurateSelection=minimal};TextareaInput.prototype.getField=function(){return this.textarea};TextareaInput.prototype.supportsTouch=function(){return false};TextareaInput.prototype.focus=function(){if(this.cm.options.readOnly!="nocursor"&&(!mobile||activeElt()!=this.textarea)){try{this.textarea.focus()}catch(e){}}};TextareaInput.prototype.blur=function(){this.textarea.blur()};TextareaInput.prototype.resetPosition=function(){this.wrapper.style.top=this.wrapper.style.left=0};TextareaInput.prototype.receivedFocus=function(){this.slowPoll()};TextareaInput.prototype.slowPoll=function(){var this$1=this;if(this.pollingFast){return}this.polling.set(this.cm.options.pollInterval,function(){this$1.poll();if(this$1.cm.state.focused){this$1.slowPoll()}})};TextareaInput.prototype.fastPoll=function(){var missed=false,input=this;input.pollingFast=true;function p(){var changed=input.poll();if(!changed&&!missed){missed=true;input.polling.set(60,p)}else{input.pollingFast=false;input.slowPoll()}}input.polling.set(20,p)};TextareaInput.prototype.poll=function(){var this$1=this;var cm=this.cm,input=this.textarea,prevInput=this.prevInput;if(this.contextMenuPending||!cm.state.focused||hasSelection(input)&&!prevInput&&!this.composing||cm.isReadOnly()||cm.options.disableInput||cm.state.keySeq){return false}var text=input.value;if(text==prevInput&&!cm.somethingSelected()){return false}if(ie&&ie_version>=9&&this.hasSelection===text||mac&&/[\uf700-\uf7ff]/.test(text)){cm.display.input.reset();return false}if(cm.doc.sel==cm.display.selForContextMenu){var first=text.charCodeAt(0);if(first==8203&&!prevInput){prevInput="​"}if(first==8666){this.reset();return this.cm.execCommand("undo")}}var same=0,l=Math.min(prevInput.length,text.length);while(same<l&&prevInput.charCodeAt(same)==text.charCodeAt(same)){++same}runInOp(cm,function(){applyTextInput(cm,text.slice(same),prevInput.length-same,null,this$1.composing?"*compose":null);if(text.length>1e3||text.indexOf("\n")>-1){input.value=this$1.prevInput=""}else{this$1.prevInput=text}if(this$1.composing){this$1.composing.range.clear();this$1.composing.range=cm.markText(this$1.composing.start,cm.getCursor("to"),{className:"CodeMirror-composing"})}});return true};TextareaInput.prototype.ensurePolled=function(){if(this.pollingFast&&this.poll()){this.pollingFast=false}};TextareaInput.prototype.onKeyPress=function(){if(ie&&ie_version>=9){this.hasSelection=null}this.fastPoll()};TextareaInput.prototype.onContextMenu=function(e){var input=this,cm=input.cm,display=cm.display,te=input.textarea;var pos=posFromMouse(cm,e),scrollPos=display.scroller.scrollTop;if(!pos||presto){return}var reset=cm.options.resetSelectionOnContextMenu;if(reset&&cm.doc.sel.contains(pos)==-1){operation(cm,setSelection)(cm.doc,simpleSelection(pos),sel_dontScroll)}var oldCSS=te.style.cssText,oldWrapperCSS=input.wrapper.style.cssText;input.wrapper.style.cssText="position: absolute";var wrapperBox=input.wrapper.getBoundingClientRect();te.style.cssText="position: absolute; width: 30px; height: 30px;\n      top: "+(e.clientY-wrapperBox.top-5)+"px; left: "+(e.clientX-wrapperBox.left-5)+"px;\n      z-index: 1000; background: "+(ie?"rgba(255, 255, 255, .05)":"transparent")+";\n      outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);";var oldScrollY;if(webkit){oldScrollY=window.scrollY}display.input.focus();if(webkit){window.scrollTo(null,oldScrollY)}display.input.reset();if(!cm.somethingSelected()){te.value=input.prevInput=" "}input.contextMenuPending=true;display.selForContextMenu=cm.doc.sel;clearTimeout(display.detectingSelectAll);function prepareSelectAllHack(){if(te.selectionStart!=null){var selected=cm.somethingSelected();var extval="​"+(selected?te.value:"");te.value="⇚";te.value=extval;input.prevInput=selected?"":"​";te.selectionStart=1;te.selectionEnd=extval.length;display.selForContextMenu=cm.doc.sel}}function rehide(){input.contextMenuPending=false;input.wrapper.style.cssText=oldWrapperCSS;te.style.cssText=oldCSS;if(ie&&ie_version<9){display.scrollbars.setScrollTop(display.scroller.scrollTop=scrollPos)}if(te.selectionStart!=null){if(!ie||ie&&ie_version<9){prepareSelectAllHack()}var i=0,poll=function(){if(display.selForContextMenu==cm.doc.sel&&te.selectionStart==0&&te.selectionEnd>0&&input.prevInput=="​"){operation(cm,selectAll)(cm)}else if(i++<10){display.detectingSelectAll=setTimeout(poll,500)}else{display.selForContextMenu=null;display.input.reset()}};display.detectingSelectAll=setTimeout(poll,200)}}if(ie&&ie_version>=9){prepareSelectAllHack()}if(captureRightClick){e_stop(e);var mouseup=function(){off(window,"mouseup",mouseup);setTimeout(rehide,20)};on(window,"mouseup",mouseup)}else{setTimeout(rehide,50)}};TextareaInput.prototype.readOnlyChanged=function(val){if(!val){this.reset()}this.textarea.disabled=val=="nocursor"};TextareaInput.prototype.setUneditable=function(){};TextareaInput.prototype.needsContentAttribute=false;function fromTextArea(textarea,options){options=options?copyObj(options):{};options.value=textarea.value;if(!options.tabindex&&textarea.tabIndex){options.tabindex=textarea.tabIndex}if(!options.placeholder&&textarea.placeholder){options.placeholder=textarea.placeholder}if(options.autofocus==null){var hasFocus=activeElt();options.autofocus=hasFocus==textarea||textarea.getAttribute("autofocus")!=null&&hasFocus==document.body}function save(){textarea.value=cm.getValue()}var realSubmit;if(textarea.form){on(textarea.form,"submit",save);if(!options.leaveSubmitMethodAlone){var form=textarea.form;realSubmit=form.submit;try{var wrappedSubmit=form.submit=function(){save();form.submit=realSubmit;form.submit();form.submit=wrappedSubmit}}catch(e){}}}options.finishInit=function(cm){cm.save=save;cm.getTextArea=function(){return textarea};cm.toTextArea=function(){cm.toTextArea=isNaN;save();textarea.parentNode.removeChild(cm.getWrapperElement());textarea.style.display="";if(textarea.form){off(textarea.form,"submit",save);if(typeof textarea.form.submit=="function"){textarea.form.submit=realSubmit}}}};textarea.style.display="none";var cm=CodeMirror$1(function(node){return textarea.parentNode.insertBefore(node,textarea.nextSibling)},options);return cm}function addLegacyProps(CodeMirror){CodeMirror.off=off;CodeMirror.on=on;CodeMirror.wheelEventPixels=wheelEventPixels;CodeMirror.Doc=Doc;CodeMirror.splitLines=splitLinesAuto;CodeMirror.countColumn=countColumn;CodeMirror.findColumn=findColumn;CodeMirror.isWordChar=isWordCharBasic;CodeMirror.Pass=Pass;CodeMirror.signal=signal;CodeMirror.Line=Line;CodeMirror.changeEnd=changeEnd;CodeMirror.scrollbarModel=scrollbarModel;CodeMirror.Pos=Pos;CodeMirror.cmpPos=cmp;CodeMirror.modes=modes;CodeMirror.mimeModes=mimeModes;CodeMirror.resolveMode=resolveMode;CodeMirror.getMode=getMode;CodeMirror.modeExtensions=modeExtensions;CodeMirror.extendMode=extendMode;CodeMirror.copyState=copyState;CodeMirror.startState=startState;CodeMirror.innerMode=innerMode;CodeMirror.commands=commands;CodeMirror.keyMap=keyMap;CodeMirror.keyName=keyName;CodeMirror.isModifierKey=isModifierKey;CodeMirror.lookupKey=lookupKey;CodeMirror.normalizeKeyMap=normalizeKeyMap;CodeMirror.StringStream=StringStream;CodeMirror.SharedTextMarker=SharedTextMarker;CodeMirror.TextMarker=TextMarker;CodeMirror.LineWidget=LineWidget;CodeMirror.e_preventDefault=e_preventDefault;CodeMirror.e_stopPropagation=e_stopPropagation;CodeMirror.e_stop=e_stop;CodeMirror.addClass=addClass;CodeMirror.contains=contains;CodeMirror.rmClass=rmClass;CodeMirror.keyNames=keyNames}defineOptions(CodeMirror$1);addEditorMethods(CodeMirror$1);var dontDelegate="iter insert remove copy getEditor constructor".split(" ");for(var prop in Doc.prototype){if(Doc.prototype.hasOwnProperty(prop)&&indexOf(dontDelegate,prop)<0){CodeMirror$1.prototype[prop]=function(method){return function(){return method.apply(this.doc,arguments)}}(Doc.prototype[prop])}}eventMixin(Doc);CodeMirror$1.inputStyles={textarea:TextareaInput,contenteditable:ContentEditableInput};CodeMirror$1.defineMode=function(name){if(!CodeMirror$1.defaults.mode&&name!="null"){CodeMirror$1.defaults.mode=name}defineMode.apply(this,arguments)};CodeMirror$1.defineMIME=defineMIME;CodeMirror$1.defineMode("null",function(){return{token:function(stream){return stream.skipToEnd()}}});CodeMirror$1.defineMIME("text/plain","null");CodeMirror$1.defineExtension=function(name,func){CodeMirror$1.prototype[name]=func};CodeMirror$1.defineDocExtension=function(name,func){Doc.prototype[name]=func};CodeMirror$1.fromTextArea=fromTextArea;addLegacyProps(CodeMirror$1);CodeMirror$1.version="5.27.4";return CodeMirror$1});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){function dialogDiv(cm,template,bottom){var wrap=cm.getWrapperElement();var dialog;dialog=wrap.appendChild(document.createElement("div"));if(bottom)dialog.className="CodeMirror-dialog CodeMirror-dialog-bottom";else dialog.className="CodeMirror-dialog CodeMirror-dialog-top";if(typeof template=="string"){dialog.innerHTML=template}else{dialog.appendChild(template)}return dialog}function closeNotification(cm,newVal){if(cm.state.currentNotificationClose)cm.state.currentNotificationClose();cm.state.currentNotificationClose=newVal}CodeMirror.defineExtension("openDialog",function(template,callback,options){if(!options)options={};closeNotification(this,null);var dialog=dialogDiv(this,template,options.bottom);var closed=false,me=this;function close(newVal){if(typeof newVal=="string"){inp.value=newVal}else{if(closed)return;closed=true;dialog.parentNode.removeChild(dialog);me.focus();if(options.onClose)options.onClose(dialog)}}var inp=dialog.getElementsByTagName("input")[0],button;if(inp){inp.focus();if(options.value){inp.value=options.value;if(options.selectValueOnOpen!==false){inp.select()}}if(options.onInput)CodeMirror.on(inp,"input",function(e){options.onInput(e,inp.value,close)});if(options.onKeyUp)CodeMirror.on(inp,"keyup",function(e){options.onKeyUp(e,inp.value,close)});CodeMirror.on(inp,"keydown",function(e){if(options&&options.onKeyDown&&options.onKeyDown(e,inp.value,close)){return}if(e.keyCode==27||options.closeOnEnter!==false&&e.keyCode==13){inp.blur();CodeMirror.e_stop(e);close()}if(e.keyCode==13)callback(inp.value,e)});if(options.closeOnBlur!==false)CodeMirror.on(inp,"blur",close)}else if(button=dialog.getElementsByTagName("button")[0]){CodeMirror.on(button,"click",function(){close();me.focus()});if(options.closeOnBlur!==false)CodeMirror.on(button,"blur",close);button.focus()}return close});CodeMirror.defineExtension("openConfirm",function(template,callbacks,options){closeNotification(this,null);var dialog=dialogDiv(this,template,options&&options.bottom);var buttons=dialog.getElementsByTagName("button");var closed=false,me=this,blurring=1;function close(){if(closed)return;closed=true;dialog.parentNode.removeChild(dialog);me.focus()}buttons[0].focus();for(var i=0;i<buttons.length;++i){var b=buttons[i];(function(callback){CodeMirror.on(b,"click",function(e){CodeMirror.e_preventDefault(e);close();if(callback)callback(me)})})(callbacks[i]);CodeMirror.on(b,"blur",function(){--blurring;setTimeout(function(){if(blurring<=0)close()},200)});CodeMirror.on(b,"focus",function(){++blurring})}});CodeMirror.defineExtension("openNotification",function(template,options){closeNotification(this,close);var dialog=dialogDiv(this,template,options&&options.bottom);var closed=false,doneTimer;var duration=options&&typeof options.duration!=="undefined"?options.duration:5e3;function close(){if(closed)return;closed=true;clearTimeout(doneTimer);dialog.parentNode.removeChild(dialog)}CodeMirror.on(dialog,"click",function(e){CodeMirror.e_preventDefault(e);close()});if(duration)doneTimer=setTimeout(close,duration);return close})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("./searchcursor"),require("../dialog/dialog"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","./searchcursor","../dialog/dialog"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function searchOverlay(query,caseInsensitive){if(typeof query=="string")query=new RegExp(query.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"),caseInsensitive?"gi":"g");else if(!query.global)query=new RegExp(query.source,query.ignoreCase?"gi":"g");return{token:function(stream){query.lastIndex=stream.pos;var match=query.exec(stream.string);if(match&&match.index==stream.pos){stream.pos+=match[0].length||1;return"searching"}else if(match){stream.pos=match.index}else{stream.skipToEnd()}}}}function SearchState(){this.posFrom=this.posTo=this.lastQuery=this.query=null;this.overlay=null}function getSearchState(cm){return cm.state.search||(cm.state.search=new SearchState)}function queryCaseInsensitive(query){return typeof query=="string"&&query==query.toLowerCase()}function getSearchCursor(cm,query,pos){return cm.getSearchCursor(query,pos,{caseFold:queryCaseInsensitive(query),multiline:true})}function persistentDialog(cm,text,deflt,onEnter,onKeyDown){cm.openDialog(text,onEnter,{value:deflt,selectValueOnOpen:true,closeOnEnter:false,onClose:function(){clearSearch(cm)},onKeyDown:onKeyDown})}function dialog(cm,text,shortText,deflt,f){if(cm.openDialog)cm.openDialog(text,f,{value:deflt,selectValueOnOpen:true});else f(prompt(shortText,deflt))}function confirmDialog(cm,text,shortText,fs){if(cm.openConfirm)cm.openConfirm(text,fs);else if(confirm(shortText))fs[0]()}function parseString(string){return string.replace(/\\(.)/g,function(_,ch){if(ch=="n")return"\n";if(ch=="r")return"\r";return ch})}function parseQuery(query){var isRE=query.match(/^\/(.*)\/([a-z]*)$/);if(isRE){try{query=new RegExp(isRE[1],isRE[2].indexOf("i")==-1?"":"i")}catch(e){}}else{query=parseString(query)}if(typeof query=="string"?query=="":query.test(""))query=/x^/;return query}var queryDialog='<span class="CodeMirror-search-label">Search:</span> <input type="text" style="width: 10em" class="CodeMirror-search-field"/> <span style="color: #888" class="CodeMirror-search-hint">(Use /re/ syntax for regexp search)</span>';function startSearch(cm,state,query){state.queryText=query;state.query=parseQuery(query);cm.removeOverlay(state.overlay,queryCaseInsensitive(state.query));state.overlay=searchOverlay(state.query,queryCaseInsensitive(state.query));cm.addOverlay(state.overlay);if(cm.showMatchesOnScrollbar){if(state.annotate){state.annotate.clear();state.annotate=null}state.annotate=cm.showMatchesOnScrollbar(state.query,queryCaseInsensitive(state.query))}}function doSearch(cm,rev,persistent,immediate){var state=getSearchState(cm);if(state.query)return findNext(cm,rev);var q=cm.getSelection()||state.lastQuery;if(persistent&&cm.openDialog){var hiding=null;var searchNext=function(query,event){CodeMirror.e_stop(event);if(!query)return;if(query!=state.queryText){startSearch(cm,state,query);state.posFrom=state.posTo=cm.getCursor()}if(hiding)hiding.style.opacity=1;findNext(cm,event.shiftKey,function(_,to){var dialog;if(to.line<3&&document.querySelector&&(dialog=cm.display.wrapper.querySelector(".CodeMirror-dialog"))&&dialog.getBoundingClientRect().bottom-4>cm.cursorCoords(to,"window").top)(hiding=dialog).style.opacity=.4})};persistentDialog(cm,queryDialog,q,searchNext,function(event,query){var keyName=CodeMirror.keyName(event);var cmd=CodeMirror.keyMap[cm.getOption("keyMap")][keyName];if(!cmd)cmd=cm.getOption("extraKeys")[keyName];if(cmd=="findNext"||cmd=="findPrev"||cmd=="findPersistentNext"||cmd=="findPersistentPrev"){CodeMirror.e_stop(event);startSearch(cm,getSearchState(cm),query);cm.execCommand(cmd)}else if(cmd=="find"||cmd=="findPersistent"){CodeMirror.e_stop(event);searchNext(query,event)}});if(immediate&&q){startSearch(cm,state,q);findNext(cm,rev)}}else{dialog(cm,queryDialog,"Search for:",q,function(query){if(query&&!state.query)cm.operation(function(){startSearch(cm,state,query);state.posFrom=state.posTo=cm.getCursor();findNext(cm,rev)})})}}function findNext(cm,rev,callback){cm.operation(function(){var state=getSearchState(cm);var cursor=getSearchCursor(cm,state.query,rev?state.posFrom:state.posTo);if(!cursor.find(rev)){cursor=getSearchCursor(cm,state.query,rev?CodeMirror.Pos(cm.lastLine()):CodeMirror.Pos(cm.firstLine(),0));if(!cursor.find(rev))return}cm.setSelection(cursor.from(),cursor.to());cm.scrollIntoView({from:cursor.from(),to:cursor.to()},20);state.posFrom=cursor.from();state.posTo=cursor.to();if(callback)callback(cursor.from(),cursor.to())})}function clearSearch(cm){cm.operation(function(){var state=getSearchState(cm);state.lastQuery=state.query;if(!state.query)return;state.query=state.queryText=null;cm.removeOverlay(state.overlay);if(state.annotate){state.annotate.clear();state.annotate=null}})}var replaceQueryDialog=' <input type="text" style="width: 10em" class="CodeMirror-search-field"/> <span style="color: #888" class="CodeMirror-search-hint">(Use /re/ syntax for regexp search)</span>';var replacementQueryDialog='<span class="CodeMirror-search-label">With:</span> <input type="text" style="width: 10em" class="CodeMirror-search-field"/>';var doReplaceConfirm='<span class="CodeMirror-search-label">Replace?</span> <button>Yes</button> <button>No</button> <button>All</button> <button>Stop</button>';function replaceAll(cm,query,text){cm.operation(function(){for(var cursor=getSearchCursor(cm,query);cursor.findNext();){if(typeof query!="string"){var match=cm.getRange(cursor.from(),cursor.to()).match(query);cursor.replace(text.replace(/\$(\d)/g,function(_,i){return match[i]}))}else cursor.replace(text)}})}function replace(cm,all){if(cm.getOption("readOnly"))return;var query=cm.getSelection()||getSearchState(cm).lastQuery;var dialogText='<span class="CodeMirror-search-label">'+(all?"Replace all:":"Replace:")+"</span>";dialog(cm,dialogText+replaceQueryDialog,dialogText,query,function(query){if(!query)return;query=parseQuery(query);dialog(cm,replacementQueryDialog,"Replace with:","",function(text){text=parseString(text);if(all){replaceAll(cm,query,text)}else{clearSearch(cm);var cursor=getSearchCursor(cm,query,cm.getCursor("from"));var advance=function(){var start=cursor.from(),match;if(!(match=cursor.findNext())){cursor=getSearchCursor(cm,query);if(!(match=cursor.findNext())||start&&cursor.from().line==start.line&&cursor.from().ch==start.ch)return}cm.setSelection(cursor.from(),cursor.to());cm.scrollIntoView({from:cursor.from(),to:cursor.to()});confirmDialog(cm,doReplaceConfirm,"Replace?",[function(){doReplace(match)},advance,function(){replaceAll(cm,query,text)}])};var doReplace=function(match){cursor.replace(typeof query=="string"?text:text.replace(/\$(\d)/g,function(_,i){return match[i]}));advance()};advance()}})})}CodeMirror.commands.find=function(cm){clearSearch(cm);doSearch(cm)};CodeMirror.commands.findPersistent=function(cm){clearSearch(cm);doSearch(cm,false,true)};CodeMirror.commands.findPersistentNext=function(cm){doSearch(cm,false,true,true)};CodeMirror.commands.findPersistentPrev=function(cm){doSearch(cm,true,true,true)};CodeMirror.commands.findNext=doSearch;CodeMirror.commands.findPrev=function(cm){doSearch(cm,true)};CodeMirror.commands.clearSearch=clearSearch;CodeMirror.commands.replace=replace;CodeMirror.commands.replaceAll=function(cm){replace(cm,true)}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var Pos=CodeMirror.Pos;function regexpFlags(regexp){var flags=regexp.flags;return flags!=null?flags:(regexp.ignoreCase?"i":"")+(regexp.global?"g":"")+(regexp.multiline?"m":"")}function ensureGlobal(regexp){return regexp.global?regexp:new RegExp(regexp.source,regexpFlags(regexp)+"g")}function maybeMultiline(regexp){return/\\s|\\n|\n|\\W|\\D|\[\^/.test(regexp.source)}function searchRegexpForward(doc,regexp,start){regexp=ensureGlobal(regexp);for(var line=start.line,ch=start.ch,last=doc.lastLine();line<=last;line++,ch=0){regexp.lastIndex=ch;var string=doc.getLine(line),match=regexp.exec(string);if(match)return{from:Pos(line,match.index),to:Pos(line,match.index+match[0].length),match:match}}}function searchRegexpForwardMultiline(doc,regexp,start){if(!maybeMultiline(regexp))return searchRegexpForward(doc,regexp,start);regexp=ensureGlobal(regexp);var string,chunk=1;for(var line=start.line,last=doc.lastLine();line<=last;){for(var i=0;i<chunk;i++){var curLine=doc.getLine(line++);string=string==null?curLine:string+"\n"+curLine}chunk=chunk*2;regexp.lastIndex=start.ch;var match=regexp.exec(string);if(match){var before=string.slice(0,match.index).split("\n"),inside=match[0].split("\n");var startLine=start.line+before.length-1,startCh=before[before.length-1].length;return{from:Pos(startLine,startCh),to:Pos(startLine+inside.length-1,inside.length==1?startCh+inside[0].length:inside[inside.length-1].length),match:match}}}}function lastMatchIn(string,regexp){var cutOff=0,match;for(;;){regexp.lastIndex=cutOff;var newMatch=regexp.exec(string);if(!newMatch)return match;match=newMatch;cutOff=match.index+(match[0].length||1);if(cutOff==string.length)return match}}function searchRegexpBackward(doc,regexp,start){regexp=ensureGlobal(regexp);for(var line=start.line,ch=start.ch,first=doc.firstLine();line>=first;line--,ch=-1){var string=doc.getLine(line);if(ch>-1)string=string.slice(0,ch);var match=lastMatchIn(string,regexp);if(match)return{from:Pos(line,match.index),to:Pos(line,match.index+match[0].length),match:match}}}function searchRegexpBackwardMultiline(doc,regexp,start){regexp=ensureGlobal(regexp);var string,chunk=1;for(var line=start.line,first=doc.firstLine();line>=first;){for(var i=0;i<chunk;i++){var curLine=doc.getLine(line--);string=string==null?curLine.slice(0,start.ch):curLine+"\n"+string}chunk*=2;var match=lastMatchIn(string,regexp);if(match){var before=string.slice(0,match.index).split("\n"),inside=match[0].split("\n");var startLine=line+before.length,startCh=before[before.length-1].length;return{from:Pos(startLine,startCh),to:Pos(startLine+inside.length-1,inside.length==1?startCh+inside[0].length:inside[inside.length-1].length),match:match}}}}var doFold,noFold;if(String.prototype.normalize){doFold=function(str){return str.normalize("NFD").toLowerCase()};noFold=function(str){return str.normalize("NFD")}}else{doFold=function(str){return str.toLowerCase()};noFold=function(str){return str}}function adjustPos(orig,folded,pos,foldFunc){if(orig.length==folded.length)return pos;for(var pos1=Math.min(pos,orig.length);;){var len1=foldFunc(orig.slice(0,pos1)).length;if(len1<pos)++pos1;else if(len1>pos)--pos1;else return pos1}}function searchStringForward(doc,query,start,caseFold){if(!query.length)return null;var fold=caseFold?doFold:noFold;var lines=fold(query).split(/\r|\n\r?/);search:for(var line=start.line,ch=start.ch,last=doc.lastLine()+1-lines.length;line<=last;line++,ch=0){var orig=doc.getLine(line).slice(ch),string=fold(orig);if(lines.length==1){var found=string.indexOf(lines[0]);if(found==-1)continue search;var start=adjustPos(orig,string,found,fold)+ch;return{from:Pos(line,adjustPos(orig,string,found,fold)+ch),to:Pos(line,adjustPos(orig,string,found+lines[0].length,fold)+ch)}}else{var cutFrom=string.length-lines[0].length;if(string.slice(cutFrom)!=lines[0])continue search;for(var i=1;i<lines.length-1;i++)if(fold(doc.getLine(line+i))!=lines[i])continue search;var end=doc.getLine(line+lines.length-1),endString=fold(end),lastLine=lines[lines.length-1];if(end.slice(0,lastLine.length)!=lastLine)continue search;return{from:Pos(line,adjustPos(orig,string,cutFrom,fold)+ch),to:Pos(line+lines.length-1,adjustPos(end,endString,lastLine.length,fold))}}}}function searchStringBackward(doc,query,start,caseFold){if(!query.length)return null;var fold=caseFold?doFold:noFold;var lines=fold(query).split(/\r|\n\r?/);search:for(var line=start.line,ch=start.ch,first=doc.firstLine()-1+lines.length;line>=first;line--,ch=-1){var orig=doc.getLine(line);if(ch>-1)orig=orig.slice(0,ch);var string=fold(orig);if(lines.length==1){var found=string.lastIndexOf(lines[0]);if(found==-1)continue search;return{from:Pos(line,adjustPos(orig,string,found,fold)),to:Pos(line,adjustPos(orig,string,found+lines[0].length,fold))}}else{var lastLine=lines[lines.length-1];if(string.slice(0,lastLine.length)!=lastLine)continue search;for(var i=1,start=line-lines.length+1;i<lines.length-1;i++)if(fold(doc.getLine(start+i))!=lines[i])continue search;var top=doc.getLine(line+1-lines.length),topString=fold(top);if(topString.slice(topString.length-lines[0].length)!=lines[0])continue search;return{from:Pos(line+1-lines.length,adjustPos(top,topString,top.length-lines[0].length,fold)),to:Pos(line,adjustPos(orig,string,lastLine.length,fold))}}}}function SearchCursor(doc,query,pos,options){this.atOccurrence=false;this.doc=doc;pos=pos?doc.clipPos(pos):Pos(0,0);this.pos={from:pos,to:pos};var caseFold;if(typeof options=="object"){caseFold=options.caseFold}else{caseFold=options;options=null}if(typeof query=="string"){if(caseFold==null)caseFold=false;this.matches=function(reverse,pos){return(reverse?searchStringBackward:searchStringForward)(doc,query,pos,caseFold)}}else{query=ensureGlobal(query);if(!options||options.multiline!==false)this.matches=function(reverse,pos){return(reverse?searchRegexpBackwardMultiline:searchRegexpForwardMultiline)(doc,query,pos)};else this.matches=function(reverse,pos){return(reverse?searchRegexpBackward:searchRegexpForward)(doc,query,pos)}}}SearchCursor.prototype={findNext:function(){return this.find(false)},findPrevious:function(){return this.find(true)},find:function(reverse){var result=this.matches(reverse,this.doc.clipPos(reverse?this.pos.from:this.pos.to));while(result&&CodeMirror.cmpPos(result.from,result.to)==0){if(reverse){if(result.from.ch)result.from=Pos(result.from.line,result.from.ch-1);else if(result.from.line==this.doc.firstLine())result=null;else result=this.matches(reverse,this.doc.clipPos(Pos(result.from.line-1)))}else{if(result.to.ch<this.doc.getLine(result.to.line).length)result.to=Pos(result.to.line,result.to.ch+1);else if(result.to.line==this.doc.lastLine())result=null;else result=this.matches(reverse,Pos(result.to.line+1,0))}}if(result){this.pos=result;this.atOccurrence=true;return this.pos.match||true}else{var end=Pos(reverse?this.doc.firstLine():this.doc.lastLine()+1,0);this.pos={from:end,to:end};return this.atOccurrence=false}},from:function(){if(this.atOccurrence)return this.pos.from},to:function(){if(this.atOccurrence)return this.pos.to},replace:function(newText,origin){if(!this.atOccurrence)return;var lines=CodeMirror.splitLines(newText);this.doc.replaceRange(lines,this.pos.from,this.pos.to,origin);this.pos.to=Pos(this.pos.from.line+lines.length-1,lines[lines.length-1].length+(lines.length==1?this.pos.from.ch:0))}};CodeMirror.defineExtension("getSearchCursor",function(query,pos,caseFold){return new SearchCursor(this.doc,query,pos,caseFold)});CodeMirror.defineDocExtension("getSearchCursor",function(query,pos,caseFold){return new SearchCursor(this,query,pos,caseFold)});CodeMirror.defineExtension("selectMatches",function(query,caseFold){var ranges=[];var cur=this.getSearchCursor(query,this.getCursor("from"),caseFold);while(cur.findNext()){if(CodeMirror.cmpPos(cur.to(),this.getCursor("to"))>0)break;ranges.push({anchor:cur.from(),head:cur.to()})}if(ranges.length)this.setSelections(ranges,0)})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("../dialog/dialog"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","../dialog/dialog"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function dialog(cm,text,shortText,deflt,f){if(cm.openDialog)cm.openDialog(text,f,{value:deflt,selectValueOnOpen:true});else f(prompt(shortText,deflt))}var jumpDialog='Jump to line: <input type="text" style="width: 10em" class="CodeMirror-search-field"/> <span style="color: #888" class="CodeMirror-search-hint">(Use line:column or scroll% syntax)</span>';function interpretLine(cm,string){var num=Number(string);if(/^[-+]/.test(string))return cm.getCursor().line+num;else return num-1}CodeMirror.commands.jumpToLine=function(cm){var cur=cm.getCursor();dialog(cm,jumpDialog,"Jump to line:",cur.line+1+":"+cur.ch,function(posStr){if(!posStr)return;var match;if(match=/^\s*([\+\-]?\d+)\s*\:\s*(\d+)\s*$/.exec(posStr)){cm.setCursor(interpretLine(cm,match[1]),Number(match[2]))}else if(match=/^\s*([\+\-]?\d+(\.\d+)?)\%\s*/.exec(posStr)){var line=Math.round(cm.lineCount()*Number(match[1])/100);if(/^[-+]/.test(match[1]))line=cur.line+line+1;cm.setCursor(line-1,cur.ch)}else if(match=/^\s*\:?\s*([\+\-]?\d+)\s*/.exec(posStr)){cm.setCursor(interpretLine(cm,match[1]),cur.ch)}})};CodeMirror.keyMap["default"]["Alt-G"]="jumpToLine"});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("./searchcursor"),require("../scroll/annotatescrollbar"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","./searchcursor","../scroll/annotatescrollbar"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineExtension("showMatchesOnScrollbar",function(query,caseFold,options){if(typeof options=="string")options={className:options};if(!options)options={};return new SearchAnnotation(this,query,caseFold,options)});function SearchAnnotation(cm,query,caseFold,options){this.cm=cm;this.options=options;var annotateOptions={listenForChanges:false};for(var prop in options)annotateOptions[prop]=options[prop];if(!annotateOptions.className)annotateOptions.className="CodeMirror-search-match";this.annotation=cm.annotateScrollbar(annotateOptions);this.query=query;this.caseFold=caseFold;this.gap={from:cm.firstLine(),to:cm.lastLine()+1};this.matches=[];this.update=null;this.findMatches();this.annotation.update(this.matches);var self=this;cm.on("change",this.changeHandler=function(_cm,change){self.onChange(change)})}var MAX_MATCHES=1e3;SearchAnnotation.prototype.findMatches=function(){if(!this.gap)return;for(var i=0;i<this.matches.length;i++){var match=this.matches[i];if(match.from.line>=this.gap.to)break;if(match.to.line>=this.gap.from)this.matches.splice(i--,1)}var cursor=this.cm.getSearchCursor(this.query,CodeMirror.Pos(this.gap.from,0),this.caseFold);var maxMatches=this.options&&this.options.maxMatches||MAX_MATCHES;while(cursor.findNext()){var match={from:cursor.from(),to:cursor.to()};if(match.from.line>=this.gap.to)break;this.matches.splice(i++,0,match);if(this.matches.length>maxMatches)break}this.gap=null};function offsetLine(line,changeStart,sizeChange){if(line<=changeStart)return line;return Math.max(changeStart,line+sizeChange)}SearchAnnotation.prototype.onChange=function(change){var startLine=change.from.line;var endLine=CodeMirror.changeEnd(change).line;var sizeChange=endLine-change.to.line;if(this.gap){this.gap.from=Math.min(offsetLine(this.gap.from,startLine,sizeChange),change.from.line);this.gap.to=Math.max(offsetLine(this.gap.to,startLine,sizeChange),change.from.line)}else{this.gap={from:change.from.line,to:endLine+1}}if(sizeChange)for(var i=0;i<this.matches.length;i++){var match=this.matches[i];var newFrom=offsetLine(match.from.line,startLine,sizeChange);if(newFrom!=match.from.line)match.from=CodeMirror.Pos(newFrom,match.from.ch);var newTo=offsetLine(match.to.line,startLine,sizeChange);if(newTo!=match.to.line)match.to=CodeMirror.Pos(newTo,match.to.ch)}clearTimeout(this.update);var self=this;this.update=setTimeout(function(){self.updateAfterChange()},250)};SearchAnnotation.prototype.updateAfterChange=function(){this.findMatches();this.annotation.update(this.matches)};SearchAnnotation.prototype.clear=function(){this.cm.off("change",this.changeHandler);this.annotation.clear()}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("./matchesonscrollbar"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","./matchesonscrollbar"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var defaults={style:"matchhighlight",minChars:2,delay:100,wordsOnly:false,annotateScrollbar:false,showToken:false,trim:true};function State(options){this.options={};for(var name in defaults)this.options[name]=(options&&options.hasOwnProperty(name)?options:defaults)[name];this.overlay=this.timeout=null;this.matchesonscroll=null;this.active=false}CodeMirror.defineOption("highlightSelectionMatches",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){removeOverlay(cm);clearTimeout(cm.state.matchHighlighter.timeout);cm.state.matchHighlighter=null;cm.off("cursorActivity",cursorActivity);cm.off("focus",onFocus)}if(val){var state=cm.state.matchHighlighter=new State(val);if(cm.hasFocus()){state.active=true;highlightMatches(cm)}else{cm.on("focus",onFocus)}cm.on("cursorActivity",cursorActivity)}});function cursorActivity(cm){var state=cm.state.matchHighlighter;if(state.active||cm.hasFocus())scheduleHighlight(cm,state)}function onFocus(cm){var state=cm.state.matchHighlighter;if(!state.active){state.active=true;scheduleHighlight(cm,state)}}function scheduleHighlight(cm,state){clearTimeout(state.timeout);state.timeout=setTimeout(function(){highlightMatches(cm)},state.options.delay)}function addOverlay(cm,query,hasBoundary,style){var state=cm.state.matchHighlighter;cm.addOverlay(state.overlay=makeOverlay(query,hasBoundary,style));if(state.options.annotateScrollbar&&cm.showMatchesOnScrollbar){var searchFor=hasBoundary?new RegExp("\\b"+query+"\\b"):query;state.matchesonscroll=cm.showMatchesOnScrollbar(searchFor,false,{className:"CodeMirror-selection-highlight-scrollbar"})}}function removeOverlay(cm){var state=cm.state.matchHighlighter;if(state.overlay){cm.removeOverlay(state.overlay);state.overlay=null;if(state.matchesonscroll){state.matchesonscroll.clear();state.matchesonscroll=null}}}function highlightMatches(cm){cm.operation(function(){var state=cm.state.matchHighlighter;removeOverlay(cm);if(!cm.somethingSelected()&&state.options.showToken){var re=state.options.showToken===true?/[\w$]/:state.options.showToken;var cur=cm.getCursor(),line=cm.getLine(cur.line),start=cur.ch,end=start;while(start&&re.test(line.charAt(start-1)))--start;while(end<line.length&&re.test(line.charAt(end)))++end;if(start<end)addOverlay(cm,line.slice(start,end),re,state.options.style);return}var from=cm.getCursor("from"),to=cm.getCursor("to");if(from.line!=to.line)return;if(state.options.wordsOnly&&!isWord(cm,from,to))return;var selection=cm.getRange(from,to);if(state.options.trim)selection=selection.replace(/^\s+|\s+$/g,"");if(selection.length>=state.options.minChars)addOverlay(cm,selection,false,state.options.style)})}function isWord(cm,from,to){var str=cm.getRange(from,to);if(str.match(/^\w+$/)!==null){if(from.ch>0){var pos={line:from.line,ch:from.ch-1};var chr=cm.getRange(pos,from);if(chr.match(/\W/)===null)return false}if(to.ch<cm.getLine(from.line).length){var pos={line:to.line,ch:to.ch+1};var chr=cm.getRange(to,pos);if(chr.match(/\W/)===null)return false}return true}else return false}function boundariesAround(stream,re){return(!stream.start||!re.test(stream.string.charAt(stream.start-1)))&&(stream.pos==stream.string.length||!re.test(stream.string.charAt(stream.pos)))}function makeOverlay(query,hasBoundary,style){return{token:function(stream){if(stream.match(query)&&(!hasBoundary||boundariesAround(stream,hasBoundary)))return style;stream.next();stream.skipTo(query.charAt(0))||stream.skipToEnd()}}}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function doFold(cm,pos,options,force){if(options&&options.call){var finder=options;options=null}else{var finder=getOption(cm,options,"rangeFinder")}if(typeof pos=="number")pos=CodeMirror.Pos(pos,0);var minSize=getOption(cm,options,"minFoldSize");function getRange(allowFolded){var range=finder(cm,pos);if(!range||range.to.line-range.from.line<minSize)return null;var marks=cm.findMarksAt(range.from);for(var i=0;i<marks.length;++i){if(marks[i].__isFold&&force!=="fold"){if(!allowFolded)return null;range.cleared=true;marks[i].clear()}}return range}var range=getRange(true);if(getOption(cm,options,"scanUp"))while(!range&&pos.line>cm.firstLine()){pos=CodeMirror.Pos(pos.line-1,0);range=getRange(false)}if(!range||range.cleared||force==="unfold")return;var myWidget=makeWidget(cm,options);CodeMirror.on(myWidget,"mousedown",function(e){myRange.clear();CodeMirror.e_preventDefault(e)});var myRange=cm.markText(range.from,range.to,{replacedWith:myWidget,clearOnEnter:getOption(cm,options,"clearOnEnter"),__isFold:true});myRange.on("clear",function(from,to){CodeMirror.signal(cm,"unfold",cm,from,to)});CodeMirror.signal(cm,"fold",cm,range.from,range.to)}function makeWidget(cm,options){var widget=getOption(cm,options,"widget");if(typeof widget=="string"){var text=document.createTextNode(widget);widget=document.createElement("span");widget.appendChild(text);widget.className="CodeMirror-foldmarker"}return widget}CodeMirror.newFoldFunction=function(rangeFinder,widget){return function(cm,pos){doFold(cm,pos,{rangeFinder:rangeFinder,widget:widget})}};CodeMirror.defineExtension("foldCode",function(pos,options,force){doFold(this,pos,options,force)});CodeMirror.defineExtension("isFolded",function(pos){var marks=this.findMarksAt(pos);for(var i=0;i<marks.length;++i)if(marks[i].__isFold)return true});CodeMirror.commands.toggleFold=function(cm){cm.foldCode(cm.getCursor())};CodeMirror.commands.fold=function(cm){cm.foldCode(cm.getCursor(),null,"fold")};CodeMirror.commands.unfold=function(cm){cm.foldCode(cm.getCursor(),null,"unfold")};CodeMirror.commands.foldAll=function(cm){cm.operation(function(){for(var i=cm.firstLine(),e=cm.lastLine();i<=e;i++)cm.foldCode(CodeMirror.Pos(i,0),null,"fold")})};CodeMirror.commands.unfoldAll=function(cm){cm.operation(function(){for(var i=cm.firstLine(),e=cm.lastLine();i<=e;i++)cm.foldCode(CodeMirror.Pos(i,0),null,"unfold")})};CodeMirror.registerHelper("fold","combine",function(){var funcs=Array.prototype.slice.call(arguments,0);return function(cm,start){for(var i=0;i<funcs.length;++i){var found=funcs[i](cm,start);if(found)return found}}});CodeMirror.registerHelper("fold","auto",function(cm,start){var helpers=cm.getHelpers(start,"fold");for(var i=0;i<helpers.length;i++){var cur=helpers[i](cm,start);if(cur)return cur}});var defaultOptions={rangeFinder:CodeMirror.fold.auto,widget:"↔",minFoldSize:0,scanUp:false,clearOnEnter:true};CodeMirror.defineOption("foldOptions",null);function getOption(cm,options,name){if(options&&options[name]!==undefined)return options[name];var editorOptions=cm.options.foldOptions;if(editorOptions&&editorOptions[name]!==undefined)return editorOptions[name];return defaultOptions[name]}CodeMirror.defineExtension("foldOption",function(options,name){return getOption(this,options,name)})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("./foldcode"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","./foldcode"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineOption("foldGutter",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){cm.clearGutter(cm.state.foldGutter.options.gutter);cm.state.foldGutter=null;cm.off("gutterClick",onGutterClick);cm.off("change",onChange);cm.off("viewportChange",onViewportChange);cm.off("fold",onFold);cm.off("unfold",onFold);cm.off("swapDoc",onChange)}if(val){cm.state.foldGutter=new State(parseOptions(val));updateInViewport(cm);cm.on("gutterClick",onGutterClick);cm.on("change",onChange);cm.on("viewportChange",onViewportChange);cm.on("fold",onFold);cm.on("unfold",onFold);cm.on("swapDoc",onChange)}});var Pos=CodeMirror.Pos;function State(options){this.options=options;this.from=this.to=0}function parseOptions(opts){if(opts===true)opts={};if(opts.gutter==null)opts.gutter="CodeMirror-foldgutter";if(opts.indicatorOpen==null)opts.indicatorOpen="CodeMirror-foldgutter-open";if(opts.indicatorFolded==null)opts.indicatorFolded="CodeMirror-foldgutter-folded";return opts}function isFolded(cm,line){var marks=cm.findMarks(Pos(line,0),Pos(line+1,0));for(var i=0;i<marks.length;++i)if(marks[i].__isFold&&marks[i].find().from.line==line)return marks[i]}function marker(spec){if(typeof spec=="string"){var elt=document.createElement("div");elt.className=spec+" CodeMirror-guttermarker-subtle";return elt}else{return spec.cloneNode(true)}}function updateFoldInfo(cm,from,to){var opts=cm.state.foldGutter.options,cur=from;var minSize=cm.foldOption(opts,"minFoldSize");var func=cm.foldOption(opts,"rangeFinder");cm.eachLine(from,to,function(line){var mark=null;if(isFolded(cm,cur)){mark=marker(opts.indicatorFolded)}else{var pos=Pos(cur,0);var range=func&&func(cm,pos);if(range&&range.to.line-range.from.line>=minSize)mark=marker(opts.indicatorOpen)}cm.setGutterMarker(line,opts.gutter,mark);++cur})}function updateInViewport(cm){var vp=cm.getViewport(),state=cm.state.foldGutter;if(!state)return;cm.operation(function(){updateFoldInfo(cm,vp.from,vp.to)});state.from=vp.from;state.to=vp.to}function onGutterClick(cm,line,gutter){var state=cm.state.foldGutter;if(!state)return;var opts=state.options;if(gutter!=opts.gutter)return;var folded=isFolded(cm,line);if(folded)folded.clear();else cm.foldCode(Pos(line,0),opts.rangeFinder)}function onChange(cm){var state=cm.state.foldGutter;if(!state)return;var opts=state.options;state.from=state.to=0;clearTimeout(state.changeUpdate);state.changeUpdate=setTimeout(function(){updateInViewport(cm)},opts.foldOnChangeTimeSpan||600)}function onViewportChange(cm){var state=cm.state.foldGutter;if(!state)return;var opts=state.options;clearTimeout(state.changeUpdate);state.changeUpdate=setTimeout(function(){var vp=cm.getViewport();if(state.from==state.to||vp.from-state.to>20||state.from-vp.to>20){updateInViewport(cm)}else{cm.operation(function(){if(vp.from<state.from){updateFoldInfo(cm,vp.from,state.from);state.from=vp.from}if(vp.to>state.to){updateFoldInfo(cm,state.to,vp.to);state.to=vp.to}})}},opts.updateViewportTimeSpan||400)}function onFold(cm,from){var state=cm.state.foldGutter;if(!state)return;var line=from.line;if(line>=state.from&&line<state.to)updateFoldInfo(cm,line,line+1)}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.registerHelper("fold","brace",function(cm,start){var line=start.line,lineText=cm.getLine(line);var tokenType;function findOpening(openCh){for(var at=start.ch,pass=0;;){var found=at<=0?-1:lineText.lastIndexOf(openCh,at-1);if(found==-1){if(pass==1)break;pass=1;at=lineText.length;continue}if(pass==1&&found<start.ch)break;tokenType=cm.getTokenTypeAt(CodeMirror.Pos(line,found+1));if(!/^(comment|string)/.test(tokenType))return found+1;at=found-1}}var startToken="{",endToken="}",startCh=findOpening("{");if(startCh==null){startToken="[",endToken="]";startCh=findOpening("[")}if(startCh==null)return;var count=1,lastLine=cm.lastLine(),end,endCh;outer:for(var i=line;i<=lastLine;++i){var text=cm.getLine(i),pos=i==line?startCh:0;for(;;){var nextOpen=text.indexOf(startToken,pos),nextClose=text.indexOf(endToken,pos);if(nextOpen<0)nextOpen=text.length;if(nextClose<0)nextClose=text.length;pos=Math.min(nextOpen,nextClose);if(pos==text.length)break;if(cm.getTokenTypeAt(CodeMirror.Pos(i,pos+1))==tokenType){if(pos==nextOpen)++count;else if(!--count){end=i;endCh=pos;break outer}}++pos}}if(end==null||line==end&&endCh==startCh)return;return{from:CodeMirror.Pos(line,startCh),to:CodeMirror.Pos(end,endCh)}});CodeMirror.registerHelper("fold","import",function(cm,start){function hasImport(line){if(line<cm.firstLine()||line>cm.lastLine())return null;var start=cm.getTokenAt(CodeMirror.Pos(line,1));if(!/\S/.test(start.string))start=cm.getTokenAt(CodeMirror.Pos(line,start.end+1));if(start.type!="keyword"||start.string!="import")return null;for(var i=line,e=Math.min(cm.lastLine(),line+10);i<=e;++i){var text=cm.getLine(i),semi=text.indexOf(";");if(semi!=-1)return{startCh:start.end,end:CodeMirror.Pos(i,semi)}}}var startLine=start.line,has=hasImport(startLine),prev;if(!has||hasImport(startLine-1)||(prev=hasImport(startLine-2))&&prev.end.line==startLine-1)return null;for(var end=has.end;;){var next=hasImport(end.line+1);if(next==null)break;end=next.end}return{from:cm.clipPos(CodeMirror.Pos(startLine,has.startCh+1)),to:end}});CodeMirror.registerHelper("fold","include",function(cm,start){function hasInclude(line){if(line<cm.firstLine()||line>cm.lastLine())return null;var start=cm.getTokenAt(CodeMirror.Pos(line,1));if(!/\S/.test(start.string))start=cm.getTokenAt(CodeMirror.Pos(line,start.end+1));if(start.type=="meta"&&start.string.slice(0,8)=="#include")return start.start+8}var startLine=start.line,has=hasInclude(startLine);if(has==null||hasInclude(startLine-1)!=null)return null;for(var end=startLine;;){var next=hasInclude(end+1);if(next==null)break;++end}return{from:CodeMirror.Pos(startLine,has+1),to:cm.clipPos(CodeMirror.Pos(end))}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.registerGlobalHelper("fold","comment",function(mode){return mode.blockCommentStart&&mode.blockCommentEnd},function(cm,start){var mode=cm.getModeAt(start),startToken=mode.blockCommentStart,endToken=mode.blockCommentEnd;if(!startToken||!endToken)return;var line=start.line,lineText=cm.getLine(line);var startCh;for(var at=start.ch,pass=0;;){var found=at<=0?-1:lineText.lastIndexOf(startToken,at-1);if(found==-1){if(pass==1)return;pass=1;at=lineText.length;continue}if(pass==1&&found<start.ch)return;if(/comment/.test(cm.getTokenTypeAt(CodeMirror.Pos(line,found+1)))&&(found==0||lineText.slice(found-endToken.length,found)==endToken||!/comment/.test(cm.getTokenTypeAt(CodeMirror.Pos(line,found))))){startCh=found+startToken.length;break}at=found-1}var depth=1,lastLine=cm.lastLine(),end,endCh;outer:for(var i=line;i<=lastLine;++i){var text=cm.getLine(i),pos=i==line?startCh:0;for(;;){var nextOpen=text.indexOf(startToken,pos),nextClose=text.indexOf(endToken,pos);if(nextOpen<0)nextOpen=text.length;if(nextClose<0)nextClose=text.length;pos=Math.min(nextOpen,nextClose);if(pos==text.length)break;if(pos==nextOpen)++depth;else if(!--depth){end=i;endCh=pos;break outer}++pos}}if(end==null||line==end&&endCh==startCh)return;return{from:CodeMirror.Pos(line,startCh),to:CodeMirror.Pos(end,endCh)}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function lineIndent(cm,lineNo){var text=cm.getLine(lineNo);var spaceTo=text.search(/\S/);if(spaceTo==-1||/\bcomment\b/.test(cm.getTokenTypeAt(CodeMirror.Pos(lineNo,spaceTo+1))))return-1;return CodeMirror.countColumn(text,null,cm.getOption("tabSize"))}CodeMirror.registerHelper("fold","indent",function(cm,start){var myIndent=lineIndent(cm,start.line);if(myIndent<0)return;var lastLineInFold=null;for(var i=start.line+1,end=cm.lastLine();i<=end;++i){var indent=lineIndent(cm,i);if(indent==-1){}else if(indent>myIndent){lastLineInFold=i}else{break}}if(lastLineInFold)return{from:CodeMirror.Pos(start.line,cm.getLine(start.line).length),to:CodeMirror.Pos(lastLineInFold,cm.getLine(lastLineInFold).length)}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var Pos=CodeMirror.Pos;function cmp(a,b){return a.line-b.line||a.ch-b.ch}var nameStartChar="A-Z_a-z\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";var nameChar=nameStartChar+"-:.0-9\\u00B7\\u0300-\\u036F\\u203F-\\u2040";var xmlTagStart=new RegExp("<(/?)(["+nameStartChar+"]["+nameChar+"]*)","g");function Iter(cm,line,ch,range){this.line=line;this.ch=ch;this.cm=cm;this.text=cm.getLine(line);this.min=range?Math.max(range.from,cm.firstLine()):cm.firstLine();this.max=range?Math.min(range.to-1,cm.lastLine()):cm.lastLine()}function tagAt(iter,ch){var type=iter.cm.getTokenTypeAt(Pos(iter.line,ch));return type&&/\btag\b/.test(type)}function nextLine(iter){if(iter.line>=iter.max)return;iter.ch=0;iter.text=iter.cm.getLine(++iter.line);return true}function prevLine(iter){if(iter.line<=iter.min)return;iter.text=iter.cm.getLine(--iter.line);iter.ch=iter.text.length;return true}function toTagEnd(iter){for(;;){var gt=iter.text.indexOf(">",iter.ch);if(gt==-1){if(nextLine(iter))continue;else return}if(!tagAt(iter,gt+1)){iter.ch=gt+1;continue}var lastSlash=iter.text.lastIndexOf("/",gt);var selfClose=lastSlash>-1&&!/\S/.test(iter.text.slice(lastSlash+1,gt));iter.ch=gt+1;return selfClose?"selfClose":"regular"}}function toTagStart(iter){for(;;){var lt=iter.ch?iter.text.lastIndexOf("<",iter.ch-1):-1;if(lt==-1){if(prevLine(iter))continue;else return}if(!tagAt(iter,lt+1)){iter.ch=lt;continue}xmlTagStart.lastIndex=lt;iter.ch=lt;var match=xmlTagStart.exec(iter.text);if(match&&match.index==lt)return match}}function toNextTag(iter){for(;;){xmlTagStart.lastIndex=iter.ch;var found=xmlTagStart.exec(iter.text);if(!found){if(nextLine(iter))continue;else return}if(!tagAt(iter,found.index+1)){iter.ch=found.index+1;continue}iter.ch=found.index+found[0].length;return found}}function toPrevTag(iter){for(;;){var gt=iter.ch?iter.text.lastIndexOf(">",iter.ch-1):-1;if(gt==-1){if(prevLine(iter))continue;else return}if(!tagAt(iter,gt+1)){iter.ch=gt;continue}var lastSlash=iter.text.lastIndexOf("/",gt);var selfClose=lastSlash>-1&&!/\S/.test(iter.text.slice(lastSlash+1,gt));iter.ch=gt+1;return selfClose?"selfClose":"regular"}}function findMatchingClose(iter,tag){var stack=[];for(;;){var next=toNextTag(iter),end,startLine=iter.line,startCh=iter.ch-(next?next[0].length:0);if(!next||!(end=toTagEnd(iter)))return;if(end=="selfClose")continue;if(next[1]){for(var i=stack.length-1;i>=0;--i)if(stack[i]==next[2]){stack.length=i;break}if(i<0&&(!tag||tag==next[2]))return{tag:next[2],from:Pos(startLine,startCh),to:Pos(iter.line,iter.ch)}}else{stack.push(next[2])}}}function findMatchingOpen(iter,tag){var stack=[];for(;;){var prev=toPrevTag(iter);if(!prev)return;if(prev=="selfClose"){toTagStart(iter);continue}var endLine=iter.line,endCh=iter.ch;var start=toTagStart(iter);if(!start)return;if(start[1]){stack.push(start[2])}else{for(var i=stack.length-1;i>=0;--i)if(stack[i]==start[2]){stack.length=i;break}if(i<0&&(!tag||tag==start[2]))return{tag:start[2],from:Pos(iter.line,iter.ch),to:Pos(endLine,endCh)}}}}CodeMirror.registerHelper("fold","xml",function(cm,start){var iter=new Iter(cm,start.line,0);for(;;){var openTag=toNextTag(iter),end;if(!openTag||iter.line!=start.line||!(end=toTagEnd(iter)))return;if(!openTag[1]&&end!="selfClose"){var startPos=Pos(iter.line,iter.ch);var endPos=findMatchingClose(iter,openTag[2]);return endPos&&{from:startPos,to:endPos.from}}}});CodeMirror.findMatchingTag=function(cm,pos,range){var iter=new Iter(cm,pos.line,pos.ch,range);if(iter.text.indexOf(">")==-1&&iter.text.indexOf("<")==-1)return;var end=toTagEnd(iter),to=end&&Pos(iter.line,iter.ch);var start=end&&toTagStart(iter);if(!end||!start||cmp(iter,pos)>0)return;var here={from:Pos(iter.line,iter.ch),to:to,tag:start[2]};if(end=="selfClose")return{open:here,close:null,at:"open"};if(start[1]){return{open:findMatchingOpen(iter,start[2]),close:here,at:"close"}}else{iter=new Iter(cm,to.line,to.ch,range);return{open:here,close:findMatchingClose(iter,start[2]),at:"open"}}};CodeMirror.findEnclosingTag=function(cm,pos,range,tag){var iter=new Iter(cm,pos.line,pos.ch,range);for(;;){var open=findMatchingOpen(iter,tag);if(!open)break;var forward=new Iter(cm,pos.line,pos.ch,range);var close=findMatchingClose(forward,open.tag);if(close)return{open:open,close:close}}};CodeMirror.scanForClosingTag=function(cm,pos,name,end){var iter=new Iter(cm,pos.line,pos.ch,end?{from:0,to:end}:null);return findMatchingClose(iter,name)}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.registerHelper("fold","markdown",function(cm,start){var maxDepth=100;function isHeader(lineNo){var tokentype=cm.getTokenTypeAt(CodeMirror.Pos(lineNo,0));return tokentype&&/\bheader\b/.test(tokentype)}function headerLevel(lineNo,line,nextLine){var match=line&&line.match(/^#+/);if(match&&isHeader(lineNo))return match[0].length;match=nextLine&&nextLine.match(/^[=\-]+\s*$/);if(match&&isHeader(lineNo+1))return nextLine[0]=="="?1:2;return maxDepth}var firstLine=cm.getLine(start.line),nextLine=cm.getLine(start.line+1);var level=headerLevel(start.line,firstLine,nextLine);if(level===maxDepth)return undefined;var lastLineNo=cm.lastLine();var end=start.line,nextNextLine=cm.getLine(end+2);while(end<lastLineNo){if(headerLevel(end+1,nextLine,nextNextLine)<=level)break;++end;nextLine=nextNextLine;nextNextLine=cm.getLine(end+2)}return{from:CodeMirror.Pos(start.line,firstLine.length),to:CodeMirror.Pos(end,cm.getLine(end).length)}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){var ie_lt8=/MSIE \d/.test(navigator.userAgent)&&(document.documentMode==null||document.documentMode<8);var Pos=CodeMirror.Pos;var matching={"(":")>",")":"(<","[":"]>","]":"[<","{":"}>","}":"{<"};function findMatchingBracket(cm,where,config){var line=cm.getLineHandle(where.line),pos=where.ch-1;var afterCursor=config&&config.afterCursor;if(afterCursor==null)afterCursor=/(^| )cm-fat-cursor($| )/.test(cm.getWrapperElement().className);var match=!afterCursor&&pos>=0&&matching[line.text.charAt(pos)]||matching[line.text.charAt(++pos)];if(!match)return null;var dir=match.charAt(1)==">"?1:-1;if(config&&config.strict&&dir>0!=(pos==where.ch))return null;var style=cm.getTokenTypeAt(Pos(where.line,pos+1));var found=scanForBracket(cm,Pos(where.line,pos+(dir>0?1:0)),dir,style||null,config);if(found==null)return null;return{from:Pos(where.line,pos),to:found&&found.pos,match:found&&found.ch==match.charAt(0),forward:dir>0}}function scanForBracket(cm,where,dir,style,config){var maxScanLen=config&&config.maxScanLineLength||1e4;var maxScanLines=config&&config.maxScanLines||1e3;var stack=[];var re=config&&config.bracketRegex?config.bracketRegex:/[(){}[\]]/;var lineEnd=dir>0?Math.min(where.line+maxScanLines,cm.lastLine()+1):Math.max(cm.firstLine()-1,where.line-maxScanLines);for(var lineNo=where.line;lineNo!=lineEnd;lineNo+=dir){var line=cm.getLine(lineNo);if(!line)continue;var pos=dir>0?0:line.length-1,end=dir>0?line.length:-1;if(line.length>maxScanLen)continue;if(lineNo==where.line)pos=where.ch-(dir<0?1:0);for(;pos!=end;pos+=dir){var ch=line.charAt(pos);if(re.test(ch)&&(style===undefined||cm.getTokenTypeAt(Pos(lineNo,pos+1))==style)){var match=matching[ch];if(match.charAt(1)==">"==dir>0)stack.push(ch);else if(!stack.length)return{pos:Pos(lineNo,pos),ch:ch};else stack.pop()}}}return lineNo-dir==(dir>0?cm.lastLine():cm.firstLine())?false:null}function matchBrackets(cm,autoclear,config){var maxHighlightLen=cm.state.matchBrackets.maxHighlightLineLength||1e3;var marks=[],ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){var match=ranges[i].empty()&&findMatchingBracket(cm,ranges[i].head,config);if(match&&cm.getLine(match.from.line).length<=maxHighlightLen){var style=match.match?"CodeMirror-matchingbracket":"CodeMirror-nonmatchingbracket";marks.push(cm.markText(match.from,Pos(match.from.line,match.from.ch+1),{className:style}));if(match.to&&cm.getLine(match.to.line).length<=maxHighlightLen)marks.push(cm.markText(match.to,Pos(match.to.line,match.to.ch+1),{className:style}))}}if(marks.length){if(ie_lt8&&cm.state.focused)cm.focus();var clear=function(){cm.operation(function(){for(var i=0;i<marks.length;i++)marks[i].clear()})};if(autoclear)setTimeout(clear,800);else return clear}}var currentlyHighlighted=null;function doMatchBrackets(cm){cm.operation(function(){if(currentlyHighlighted){currentlyHighlighted();currentlyHighlighted=null}currentlyHighlighted=matchBrackets(cm,false,cm.state.matchBrackets)})}CodeMirror.defineOption("matchBrackets",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){cm.off("cursorActivity",doMatchBrackets);if(currentlyHighlighted){currentlyHighlighted();currentlyHighlighted=null}}if(val){cm.state.matchBrackets=typeof val=="object"?val:{};cm.on("cursorActivity",doMatchBrackets)}});CodeMirror.defineExtension("matchBrackets",function(){matchBrackets(this,true)});CodeMirror.defineExtension("findMatchingBracket",function(pos,config,oldConfig){if(oldConfig||typeof config=="boolean"){if(!oldConfig){config=config?{strict:true}:null}else{oldConfig.strict=config;config=oldConfig}}return findMatchingBracket(this,pos,config)});CodeMirror.defineExtension("scanForBracket",function(pos,dir,style,config){return scanForBracket(this,pos,dir,style,config)})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){var defaults={pairs:"()[]{}''\"\"",triples:"",explode:"[]{}"};var Pos=CodeMirror.Pos;CodeMirror.defineOption("autoCloseBrackets",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){cm.removeKeyMap(keyMap);cm.state.closeBrackets=null}if(val){cm.state.closeBrackets=val;cm.addKeyMap(keyMap)}});function getOption(conf,name){if(name=="pairs"&&typeof conf=="string")return conf;if(typeof conf=="object"&&conf[name]!=null)return conf[name];return defaults[name]}var bind=defaults.pairs+"`";var keyMap={Backspace:handleBackspace,Enter:handleEnter};for(var i=0;i<bind.length;i++)keyMap["'"+bind.charAt(i)+"'"]=handler(bind.charAt(i));function handler(ch){return function(cm){return handleChar(cm,ch)}}function getConfig(cm){var deflt=cm.state.closeBrackets;if(!deflt||deflt.override)return deflt;var mode=cm.getModeAt(cm.getCursor());return mode.closeBrackets||deflt}function handleBackspace(cm){var conf=getConfig(cm);if(!conf||cm.getOption("disableInput"))return CodeMirror.Pass;var pairs=getOption(conf,"pairs");var ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){if(!ranges[i].empty())return CodeMirror.Pass;var around=charsAround(cm,ranges[i].head);if(!around||pairs.indexOf(around)%2!=0)return CodeMirror.Pass}for(var i=ranges.length-1;i>=0;i--){var cur=ranges[i].head;cm.replaceRange("",Pos(cur.line,cur.ch-1),Pos(cur.line,cur.ch+1),"+delete")}}function handleEnter(cm){var conf=getConfig(cm);var explode=conf&&getOption(conf,"explode");if(!explode||cm.getOption("disableInput"))return CodeMirror.Pass;var ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){if(!ranges[i].empty())return CodeMirror.Pass;var around=charsAround(cm,ranges[i].head);if(!around||explode.indexOf(around)%2!=0)return CodeMirror.Pass}cm.operation(function(){cm.replaceSelection("\n\n",null);cm.execCommand("goCharLeft");ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){var line=ranges[i].head.line;cm.indentLine(line,null,true);cm.indentLine(line+1,null,true)}})}function contractSelection(sel){var inverted=CodeMirror.cmpPos(sel.anchor,sel.head)>0;return{anchor:new Pos(sel.anchor.line,sel.anchor.ch+(inverted?-1:1)),head:new Pos(sel.head.line,sel.head.ch+(inverted?1:-1))}}function handleChar(cm,ch){var conf=getConfig(cm);if(!conf||cm.getOption("disableInput"))return CodeMirror.Pass;var pairs=getOption(conf,"pairs");var pos=pairs.indexOf(ch);if(pos==-1)return CodeMirror.Pass;var triples=getOption(conf,"triples");var identical=pairs.charAt(pos+1)==ch;var ranges=cm.listSelections();var opening=pos%2==0;var type;for(var i=0;i<ranges.length;i++){var range=ranges[i],cur=range.head,curType;var next=cm.getRange(cur,Pos(cur.line,cur.ch+1));if(opening&&!range.empty()){curType="surround"}else if((identical||!opening)&&next==ch){if(identical&&stringStartsAfter(cm,cur))curType="both";else if(triples.indexOf(ch)>=0&&cm.getRange(cur,Pos(cur.line,cur.ch+3))==ch+ch+ch)curType="skipThree";else curType="skip"}else if(identical&&cur.ch>1&&triples.indexOf(ch)>=0&&cm.getRange(Pos(cur.line,cur.ch-2),cur)==ch+ch&&(cur.ch<=2||cm.getRange(Pos(cur.line,cur.ch-3),Pos(cur.line,cur.ch-2))!=ch)){curType="addFour"}else if(identical){if(!CodeMirror.isWordChar(next)&&enteringString(cm,cur,ch))curType="both";else return CodeMirror.Pass}else if(opening&&(cm.getLine(cur.line).length==cur.ch||isClosingBracket(next,pairs)||/\s/.test(next))){curType="both"}else{return CodeMirror.Pass}if(!type)type=curType;else if(type!=curType)return CodeMirror.Pass}var left=pos%2?pairs.charAt(pos-1):ch;var right=pos%2?ch:pairs.charAt(pos+1);cm.operation(function(){if(type=="skip"){cm.execCommand("goCharRight")}else if(type=="skipThree"){for(var i=0;i<3;i++)cm.execCommand("goCharRight")}else if(type=="surround"){var sels=cm.getSelections();for(var i=0;i<sels.length;i++)sels[i]=left+sels[i]+right;cm.replaceSelections(sels,"around");sels=cm.listSelections().slice();for(var i=0;i<sels.length;i++)sels[i]=contractSelection(sels[i]);cm.setSelections(sels)}else if(type=="both"){cm.replaceSelection(left+right,null);cm.triggerElectric(left+right);cm.execCommand("goCharLeft")}else if(type=="addFour"){cm.replaceSelection(left+left+left+left,"before");cm.execCommand("goCharRight")}})}function isClosingBracket(ch,pairs){var pos=pairs.lastIndexOf(ch);return pos>-1&&pos%2==1}function charsAround(cm,pos){var str=cm.getRange(Pos(pos.line,pos.ch-1),Pos(pos.line,pos.ch+1));return str.length==2?str:null}function enteringString(cm,pos,ch){var line=cm.getLine(pos.line);var token=cm.getTokenAt(pos);if(/\bstring2?\b/.test(token.type)||stringStartsAfter(cm,pos))return false;var stream=new CodeMirror.StringStream(line.slice(0,pos.ch)+ch+line.slice(pos.ch),4);stream.pos=stream.start=token.start;for(;;){var type1=cm.getMode().token(stream,token.state);if(stream.pos>=pos.ch+1)return/\bstring2?\b/.test(type1);stream.start=stream.pos}}function stringStartsAfter(cm,pos){var token=cm.getTokenAt(Pos(pos.line,pos.ch+1));return/\bstring/.test(token.type)&&token.start==pos.ch}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("../fold/xml-fold"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","../fold/xml-fold"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineOption("matchTags",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){cm.off("cursorActivity",doMatchTags);cm.off("viewportChange",maybeUpdateMatch);clear(cm)}if(val){cm.state.matchBothTags=typeof val=="object"&&val.bothTags;cm.on("cursorActivity",doMatchTags);cm.on("viewportChange",maybeUpdateMatch);doMatchTags(cm)}});function clear(cm){if(cm.state.tagHit)cm.state.tagHit.clear();if(cm.state.tagOther)cm.state.tagOther.clear();cm.state.tagHit=cm.state.tagOther=null}function doMatchTags(cm){cm.state.failedTagMatch=false;cm.operation(function(){clear(cm);if(cm.somethingSelected())return;var cur=cm.getCursor(),range=cm.getViewport();range.from=Math.min(range.from,cur.line);range.to=Math.max(cur.line+1,range.to);var match=CodeMirror.findMatchingTag(cm,cur,range);if(!match)return;if(cm.state.matchBothTags){var hit=match.at=="open"?match.open:match.close;if(hit)cm.state.tagHit=cm.markText(hit.from,hit.to,{className:"CodeMirror-matchingtag"})}var other=match.at=="close"?match.open:match.close;if(other)cm.state.tagOther=cm.markText(other.from,other.to,{className:"CodeMirror-matchingtag"});else cm.state.failedTagMatch=true})}function maybeUpdateMatch(cm){if(cm.state.failedTagMatch)doMatchTags(cm)}CodeMirror.commands.toMatchingTag=function(cm){var found=CodeMirror.findMatchingTag(cm,cm.getCursor());if(found){var other=found.at=="close"?found.open:found.close;if(other)cm.extendSelection(other.to,other.from)}}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("../fold/xml-fold"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","../fold/xml-fold"],mod);else mod(CodeMirror)})(function(CodeMirror){CodeMirror.defineOption("autoCloseTags",false,function(cm,val,old){if(old!=CodeMirror.Init&&old)cm.removeKeyMap("autoCloseTags");if(!val)return;var map={name:"autoCloseTags"};if(typeof val!="object"||val.whenClosing)map["'/'"]=function(cm){return autoCloseSlash(cm)};if(typeof val!="object"||val.whenOpening)map["'>'"]=function(cm){return autoCloseGT(cm)};cm.addKeyMap(map)});var htmlDontClose=["area","base","br","col","command","embed","hr","img","input","keygen","link","meta","param","source","track","wbr"];var htmlIndent=["applet","blockquote","body","button","div","dl","fieldset","form","frameset","h1","h2","h3","h4","h5","h6","head","html","iframe","layer","legend","object","ol","p","select","table","ul"];function autoCloseGT(cm){if(cm.getOption("disableInput"))return CodeMirror.Pass;var ranges=cm.listSelections(),replacements=[];for(var i=0;i<ranges.length;i++){if(!ranges[i].empty())return CodeMirror.Pass;var pos=ranges[i].head,tok=cm.getTokenAt(pos);var inner=CodeMirror.innerMode(cm.getMode(),tok.state),state=inner.state;if(inner.mode.name!="xml"||!state.tagName)return CodeMirror.Pass;var opt=cm.getOption("autoCloseTags"),html=inner.mode.configuration=="html";var dontCloseTags=typeof opt=="object"&&opt.dontCloseTags||html&&htmlDontClose;var indentTags=typeof opt=="object"&&opt.indentTags||html&&htmlIndent;var tagName=state.tagName;if(tok.end>pos.ch)tagName=tagName.slice(0,tagName.length-tok.end+pos.ch);var lowerTagName=tagName.toLowerCase();if(!tagName||tok.type=="string"&&(tok.end!=pos.ch||!/[\"\']/.test(tok.string.charAt(tok.string.length-1))||tok.string.length==1)||tok.type=="tag"&&state.type=="closeTag"||tok.string.indexOf("/")==tok.string.length-1||dontCloseTags&&indexOf(dontCloseTags,lowerTagName)>-1||closingTagExists(cm,tagName,pos,state,true))return CodeMirror.Pass;var indent=indentTags&&indexOf(indentTags,lowerTagName)>-1;replacements[i]={indent:indent,text:">"+(indent?"\n\n":"")+"</"+tagName+">",newPos:indent?CodeMirror.Pos(pos.line+1,0):CodeMirror.Pos(pos.line,pos.ch+1)}}for(var i=ranges.length-1;i>=0;i--){var info=replacements[i];cm.replaceRange(info.text,ranges[i].head,ranges[i].anchor,"+insert");var sel=cm.listSelections().slice(0);sel[i]={head:info.newPos,anchor:info.newPos};cm.setSelections(sel);if(info.indent){cm.indentLine(info.newPos.line,null,true);cm.indentLine(info.newPos.line+1,null,true)}}}function autoCloseCurrent(cm,typingSlash){var ranges=cm.listSelections(),replacements=[];var head=typingSlash?"/":"</";for(var i=0;i<ranges.length;i++){if(!ranges[i].empty())return CodeMirror.Pass;var pos=ranges[i].head,tok=cm.getTokenAt(pos);var inner=CodeMirror.innerMode(cm.getMode(),tok.state),state=inner.state;if(typingSlash&&(tok.type=="string"||tok.string.charAt(0)!="<"||tok.start!=pos.ch-1))return CodeMirror.Pass;var replacement;if(inner.mode.name!="xml"){if(cm.getMode().name=="htmlmixed"&&inner.mode.name=="javascript")replacement=head+"script";else if(cm.getMode().name=="htmlmixed"&&inner.mode.name=="css")replacement=head+"style";else return CodeMirror.Pass}else{if(!state.context||!state.context.tagName||closingTagExists(cm,state.context.tagName,pos,state))return CodeMirror.Pass;replacement=head+state.context.tagName}if(cm.getLine(pos.line).charAt(tok.end)!=">")replacement+=">";replacements[i]=replacement}cm.replaceSelections(replacements);ranges=cm.listSelections();for(var i=0;i<ranges.length;i++)if(i==ranges.length-1||ranges[i].head.line<ranges[i+1].head.line)cm.indentLine(ranges[i].head.line)}function autoCloseSlash(cm){if(cm.getOption("disableInput"))return CodeMirror.Pass;return autoCloseCurrent(cm,true)}CodeMirror.commands.closeTag=function(cm){return autoCloseCurrent(cm)};function indexOf(collection,elt){if(collection.indexOf)return collection.indexOf(elt);for(var i=0,e=collection.length;i<e;++i)if(collection[i]==elt)return i;return-1}function closingTagExists(cm,tagName,pos,state,newTag){if(!CodeMirror.scanForClosingTag)return false;var end=Math.min(cm.lastLine()+1,pos.line+500);var nextClose=CodeMirror.scanForClosingTag(cm,pos,null,end);if(!nextClose||nextClose.tag!=tagName)return false;var cx=state.context;for(var onCx=newTag?1:0;cx&&cx.tagName==tagName;cx=cx.prev)++onCx;pos=nextClose.to;for(var i=1;i<onCx;i++){var next=CodeMirror.scanForClosingTag(cm,pos,null,end);if(!next||next.tag!=tagName)return false;pos=next.to}return true}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var noOptions={};var nonWS=/[^\s\u00a0]/;var Pos=CodeMirror.Pos;function firstNonWS(str){var found=str.search(nonWS);return found==-1?0:found}CodeMirror.commands.toggleComment=function(cm){cm.toggleComment()};CodeMirror.defineExtension("toggleComment",function(options){if(!options)options=noOptions;var cm=this;var minLine=Infinity,ranges=this.listSelections(),mode=null;for(var i=ranges.length-1;i>=0;i--){var from=ranges[i].from(),to=ranges[i].to();if(from.line>=minLine)continue;if(to.line>=minLine)to=Pos(minLine,0);minLine=from.line;if(mode==null){if(cm.uncomment(from,to,options))mode="un";else{cm.lineComment(from,to,options);mode="line"}}else if(mode=="un"){cm.uncomment(from,to,options)}else{cm.lineComment(from,to,options)}}});function probablyInsideString(cm,pos,line){return/\bstring\b/.test(cm.getTokenTypeAt(Pos(pos.line,0)))&&!/^[\'\"\`]/.test(line)}function getMode(cm,pos){var mode=cm.getMode();return mode.useInnerComments===false||!mode.innerMode?mode:cm.getModeAt(pos)}CodeMirror.defineExtension("lineComment",function(from,to,options){if(!options)options=noOptions;var self=this,mode=getMode(self,from);var firstLine=self.getLine(from.line);if(firstLine==null||probablyInsideString(self,from,firstLine))return;var commentString=options.lineComment||mode.lineComment;if(!commentString){if(options.blockCommentStart||mode.blockCommentStart){options.fullLines=true;self.blockComment(from,to,options)}return}var end=Math.min(to.ch!=0||to.line==from.line?to.line+1:to.line,self.lastLine()+1);var pad=options.padding==null?" ":options.padding;var blankLines=options.commentBlankLines||from.line==to.line;self.operation(function(){if(options.indent){var baseString=null;for(var i=from.line;i<end;++i){var line=self.getLine(i);var whitespace=line.slice(0,firstNonWS(line));if(baseString==null||baseString.length>whitespace.length){baseString=whitespace}}for(var i=from.line;i<end;++i){var line=self.getLine(i),cut=baseString.length;if(!blankLines&&!nonWS.test(line))continue;if(line.slice(0,cut)!=baseString)cut=firstNonWS(line);self.replaceRange(baseString+commentString+pad,Pos(i,0),Pos(i,cut))}}else{for(var i=from.line;i<end;++i){if(blankLines||nonWS.test(self.getLine(i)))self.replaceRange(commentString+pad,Pos(i,0))}}})});CodeMirror.defineExtension("blockComment",function(from,to,options){if(!options)options=noOptions;var self=this,mode=getMode(self,from);var startString=options.blockCommentStart||mode.blockCommentStart;var endString=options.blockCommentEnd||mode.blockCommentEnd;if(!startString||!endString){if((options.lineComment||mode.lineComment)&&options.fullLines!=false)self.lineComment(from,to,options);return}if(/\bcomment\b/.test(self.getTokenTypeAt(Pos(from.line,0))))return;var end=Math.min(to.line,self.lastLine());if(end!=from.line&&to.ch==0&&nonWS.test(self.getLine(end)))--end;var pad=options.padding==null?" ":options.padding;if(from.line>end)return;self.operation(function(){if(options.fullLines!=false){var lastLineHasText=nonWS.test(self.getLine(end));self.replaceRange(pad+endString,Pos(end));self.replaceRange(startString+pad,Pos(from.line,0));var lead=options.blockCommentLead||mode.blockCommentLead;if(lead!=null)for(var i=from.line+1;i<=end;++i)if(i!=end||lastLineHasText)self.replaceRange(lead+pad,Pos(i,0))}else{self.replaceRange(endString,to);self.replaceRange(startString,from)}})});CodeMirror.defineExtension("uncomment",function(from,to,options){if(!options)options=noOptions;var self=this,mode=getMode(self,from);var end=Math.min(to.ch!=0||to.line==from.line?to.line:to.line-1,self.lastLine()),start=Math.min(from.line,end);var lineString=options.lineComment||mode.lineComment,lines=[];var pad=options.padding==null?" ":options.padding,didSomething;lineComment:{if(!lineString)break lineComment;for(var i=start;i<=end;++i){var line=self.getLine(i);var found=line.indexOf(lineString);if(found>-1&&!/comment/.test(self.getTokenTypeAt(Pos(i,found+1))))found=-1;if(found==-1&&nonWS.test(line))break lineComment;if(found>-1&&nonWS.test(line.slice(0,found)))break lineComment;lines.push(line)}self.operation(function(){for(var i=start;i<=end;++i){var line=lines[i-start];var pos=line.indexOf(lineString),endPos=pos+lineString.length;if(pos<0)continue;if(line.slice(endPos,endPos+pad.length)==pad)endPos+=pad.length;didSomething=true;self.replaceRange("",Pos(i,pos),Pos(i,endPos))}});if(didSomething)return true}var startString=options.blockCommentStart||mode.blockCommentStart;var endString=options.blockCommentEnd||mode.blockCommentEnd;if(!startString||!endString)return false;var lead=options.blockCommentLead||mode.blockCommentLead;var startLine=self.getLine(start),open=startLine.indexOf(startString);if(open==-1)return false;var endLine=end==start?startLine:self.getLine(end);var close=endLine.indexOf(endString,end==start?open+startString.length:0);if(close==-1&&start!=end){endLine=self.getLine(--end);close=endLine.indexOf(endString)}var insideStart=Pos(start,open+1),insideEnd=Pos(end,close+1);if(close==-1||!/comment/.test(self.getTokenTypeAt(insideStart))||!/comment/.test(self.getTokenTypeAt(insideEnd))||self.getRange(insideStart,insideEnd,"\n").indexOf(endString)>-1)return false;var lastStart=startLine.lastIndexOf(startString,from.ch);var firstEnd=lastStart==-1?-1:startLine.slice(0,from.ch).indexOf(endString,lastStart+startString.length);if(lastStart!=-1&&firstEnd!=-1&&firstEnd+endString.length!=from.ch)return false;firstEnd=endLine.indexOf(endString,to.ch);var almostLastStart=endLine.slice(to.ch).lastIndexOf(startString,firstEnd-to.ch);lastStart=firstEnd==-1||almostLastStart==-1?-1:to.ch+almostLastStart;if(firstEnd!=-1&&lastStart!=-1&&lastStart!=to.ch)return false;self.operation(function(){self.replaceRange("",Pos(end,close-(pad&&endLine.slice(close-pad.length,close)==pad?pad.length:0)),Pos(end,close+endString.length));var openEnd=open+startString.length;if(pad&&startLine.slice(openEnd,openEnd+pad.length)==pad)openEnd+=pad.length;self.replaceRange("",Pos(start,open),Pos(start,openEnd));if(lead)for(var i=start+1;i<=end;++i){var line=self.getLine(i),found=line.indexOf(lead);if(found==-1||nonWS.test(line.slice(0,found)))continue;var foundEnd=found+lead.length;if(pad&&line.slice(foundEnd,foundEnd+pad.length)==pad)foundEnd+=pad.length;self.replaceRange("",Pos(i,found),Pos(i,foundEnd))}});return true})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){var modes=["clike","css","javascript"];for(var i=0;i<modes.length;++i)CodeMirror.extendMode(modes[i],{blockCommentContinue:" * "});function continueComment(cm){if(cm.getOption("disableInput"))return CodeMirror.Pass;var ranges=cm.listSelections(),mode,inserts=[];for(var i=0;i<ranges.length;i++){var pos=ranges[i].head,token=cm.getTokenAt(pos);if(token.type!="comment")return CodeMirror.Pass;var modeHere=CodeMirror.innerMode(cm.getMode(),token.state).mode;if(!mode)mode=modeHere;else if(mode!=modeHere)return CodeMirror.Pass;var insert=null;if(mode.blockCommentStart&&mode.blockCommentContinue){var end=token.string.indexOf(mode.blockCommentEnd);var full=cm.getRange(CodeMirror.Pos(pos.line,0),CodeMirror.Pos(pos.line,token.end)),found;if(end!=-1&&end==token.string.length-mode.blockCommentEnd.length&&pos.ch>=end){}else if(token.string.indexOf(mode.blockCommentStart)==0){insert=full.slice(0,token.start);if(!/^\s*$/.test(insert)){insert="";for(var j=0;j<token.start;++j)insert+=" "}}else if((found=full.indexOf(mode.blockCommentContinue))!=-1&&found+mode.blockCommentContinue.length>token.start&&/^\s*$/.test(full.slice(0,found))){insert=full.slice(0,found)}if(insert!=null)insert+=mode.blockCommentContinue}if(insert==null&&mode.lineComment&&continueLineCommentEnabled(cm)){var line=cm.getLine(pos.line),found=line.indexOf(mode.lineComment);if(found>-1){insert=line.slice(0,found);if(/\S/.test(insert))insert=null;else insert+=mode.lineComment+line.slice(found+mode.lineComment.length).match(/^\s*/)[0]}}if(insert==null)return CodeMirror.Pass;inserts[i]="\n"+insert}cm.operation(function(){for(var i=ranges.length-1;i>=0;i--)cm.replaceRange(inserts[i],ranges[i].from(),ranges[i].to(),"+insert")})}function continueLineCommentEnabled(cm){var opt=cm.getOption("continueComments");if(opt&&typeof opt=="object")return opt.continueLineComment!==false;return true}CodeMirror.defineOption("continueComments",null,function(cm,val,prev){if(prev&&prev!=CodeMirror.Init)cm.removeKeyMap("continueComment");if(val){var key="Enter";if(typeof val=="string")key=val;else if(typeof val=="object"&&val.key)key=val.key;var map={name:"continueComment"};map[key]=continueComment;cm.addKeyMap(map)}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var WRAP_CLASS="CodeMirror-activeline";var BACK_CLASS="CodeMirror-activeline-background";var GUTT_CLASS="CodeMirror-activeline-gutter";CodeMirror.defineOption("styleActiveLine",false,function(cm,val,old){var prev=old==CodeMirror.Init?false:old;if(val==prev)return;if(prev){cm.off("beforeSelectionChange",selectionChange);clearActiveLines(cm);delete cm.state.activeLines}if(val){cm.state.activeLines=[];updateActiveLines(cm,cm.listSelections());cm.on("beforeSelectionChange",selectionChange)}});function clearActiveLines(cm){for(var i=0;i<cm.state.activeLines.length;i++){cm.removeLineClass(cm.state.activeLines[i],"wrap",WRAP_CLASS);cm.removeLineClass(cm.state.activeLines[i],"background",BACK_CLASS);cm.removeLineClass(cm.state.activeLines[i],"gutter",GUTT_CLASS)}}function sameArray(a,b){if(a.length!=b.length)return false;for(var i=0;i<a.length;i++)if(a[i]!=b[i])return false;return true}function updateActiveLines(cm,ranges){var active=[];for(var i=0;i<ranges.length;i++){var range=ranges[i];var option=cm.getOption("styleActiveLine");if(typeof option=="object"&&option.nonEmpty?range.anchor.line!=range.head.line:!range.empty())continue;var line=cm.getLineHandleVisualStart(range.head.line);if(active[active.length-1]!=line)active.push(line)}if(sameArray(cm.state.activeLines,active))return;cm.operation(function(){clearActiveLines(cm);for(var i=0;i<active.length;i++){cm.addLineClass(active[i],"wrap",WRAP_CLASS);cm.addLineClass(active[i],"background",BACK_CLASS);cm.addLineClass(active[i],"gutter",GUTT_CLASS)}cm.state.activeLines=active})}function selectionChange(cm,sel){updateActiveLines(cm,sel.ranges)}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineOption("styleSelectedText",false,function(cm,val,old){var prev=old&&old!=CodeMirror.Init;if(val&&!prev){cm.state.markedSelection=[];cm.state.markedSelectionStyle=typeof val=="string"?val:"CodeMirror-selectedtext";reset(cm);cm.on("cursorActivity",onCursorActivity);cm.on("change",onChange)}else if(!val&&prev){cm.off("cursorActivity",onCursorActivity);cm.off("change",onChange);clear(cm);cm.state.markedSelection=cm.state.markedSelectionStyle=null}});function onCursorActivity(cm){if(cm.state.markedSelection)cm.operation(function(){update(cm)})}function onChange(cm){if(cm.state.markedSelection&&cm.state.markedSelection.length)cm.operation(function(){clear(cm)})}var CHUNK_SIZE=8;var Pos=CodeMirror.Pos;var cmp=CodeMirror.cmpPos;function coverRange(cm,from,to,addAt){if(cmp(from,to)==0)return;var array=cm.state.markedSelection;var cls=cm.state.markedSelectionStyle;for(var line=from.line;;){var start=line==from.line?from:Pos(line,0);var endLine=line+CHUNK_SIZE,atEnd=endLine>=to.line;var end=atEnd?to:Pos(endLine,0);var mark=cm.markText(start,end,{className:cls});if(addAt==null)array.push(mark);else array.splice(addAt++,0,mark);if(atEnd)break;line=endLine}}function clear(cm){var array=cm.state.markedSelection;for(var i=0;i<array.length;++i)array[i].clear();array.length=0}function reset(cm){clear(cm);var ranges=cm.listSelections();for(var i=0;i<ranges.length;i++)coverRange(cm,ranges[i].from(),ranges[i].to())}function update(cm){if(!cm.somethingSelected())return clear(cm);if(cm.listSelections().length>1)return reset(cm);var from=cm.getCursor("start"),to=cm.getCursor("end");var array=cm.state.markedSelection;if(!array.length)return coverRange(cm,from,to);var coverStart=array[0].find(),coverEnd=array[array.length-1].find();if(!coverStart||!coverEnd||to.line-from.line<CHUNK_SIZE||cmp(from,coverEnd.to)>=0||cmp(to,coverStart.from)<=0)return reset(cm);while(cmp(from,coverStart.from)>0){array.shift().clear();coverStart=array[0].find()}if(cmp(from,coverStart.from)<0){if(coverStart.to.line-from.line<CHUNK_SIZE){array.shift().clear();coverRange(cm,from,coverStart.to,0)}else{coverRange(cm,from,coverStart.from,0)}}while(cmp(to,coverEnd.to)<0){array.pop().clear();coverEnd=array[array.length-1].find()}if(cmp(to,coverEnd.to)>0){if(to.line-coverEnd.from.line<CHUNK_SIZE){array.pop().clear();coverRange(cm,coverEnd.from,to)}else{coverRange(cm,coverEnd.to,to)}}}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var HINT_ELEMENT_CLASS="CodeMirror-hint";var ACTIVE_HINT_ELEMENT_CLASS="CodeMirror-hint-active";CodeMirror.showHint=function(cm,getHints,options){if(!getHints)return cm.showHint(options);if(options&&options.async)getHints.async=true;var newOpts={hint:getHints};if(options)for(var prop in options)newOpts[prop]=options[prop];return cm.showHint(newOpts)};CodeMirror.defineExtension("showHint",function(options){options=parseOptions(this,this.getCursor("start"),options);var selections=this.listSelections();if(selections.length>1)return;if(this.somethingSelected()){if(!options.hint.supportsSelection)return;for(var i=0;i<selections.length;i++)if(selections[i].head.line!=selections[i].anchor.line)return}if(this.state.completionActive)this.state.completionActive.close();var completion=this.state.completionActive=new Completion(this,options);if(!completion.options.hint)return;CodeMirror.signal(this,"startCompletion",this);completion.update(true)});function Completion(cm,options){this.cm=cm;this.options=options;this.widget=null;this.debounce=0;this.tick=0;this.startPos=this.cm.getCursor("start");this.startLen=this.cm.getLine(this.startPos.line).length-this.cm.getSelection().length;var self=this;cm.on("cursorActivity",this.activityFunc=function(){self.cursorActivity()})}var requestAnimationFrame=window.requestAnimationFrame||function(fn){return setTimeout(fn,1e3/60)};var cancelAnimationFrame=window.cancelAnimationFrame||clearTimeout;Completion.prototype={close:function(){if(!this.active())return;this.cm.state.completionActive=null;this.tick=null;this.cm.off("cursorActivity",this.activityFunc);if(this.widget&&this.data)CodeMirror.signal(this.data,"close");if(this.widget)this.widget.close();CodeMirror.signal(this.cm,"endCompletion",this.cm)},active:function(){return this.cm.state.completionActive==this},pick:function(data,i){var completion=data.list[i];if(completion.hint)completion.hint(this.cm,data,completion);else this.cm.replaceRange(getText(completion),completion.from||data.from,completion.to||data.to,"complete");CodeMirror.signal(data,"pick",completion);this.close()},cursorActivity:function(){if(this.debounce){cancelAnimationFrame(this.debounce);this.debounce=0}var pos=this.cm.getCursor(),line=this.cm.getLine(pos.line);if(pos.line!=this.startPos.line||line.length-pos.ch!=this.startLen-this.startPos.ch||pos.ch<this.startPos.ch||this.cm.somethingSelected()||pos.ch&&this.options.closeCharacters.test(line.charAt(pos.ch-1))){this.close()}else{var self=this;this.debounce=requestAnimationFrame(function(){self.update()});if(this.widget)this.widget.disable()}},update:function(first){if(this.tick==null)return;var self=this,myTick=++this.tick;fetchHints(this.options.hint,this.cm,this.options,function(data){if(self.tick==myTick)self.finishUpdate(data,first)})},finishUpdate:function(data,first){if(this.data)CodeMirror.signal(this.data,"update");var picked=this.widget&&this.widget.picked||first&&this.options.completeSingle;if(this.widget)this.widget.close();if(data&&this.data&&isNewCompletion(this.data,data))return;this.data=data;if(data&&data.list.length){if(picked&&data.list.length==1){this.pick(data,0)}else{this.widget=new Widget(this,data);CodeMirror.signal(data,"shown")}}}};function isNewCompletion(old,nw){var moved=CodeMirror.cmpPos(nw.from,old.from);return moved>0&&old.to.ch-old.from.ch!=nw.to.ch-nw.from.ch}function parseOptions(cm,pos,options){var editor=cm.options.hintOptions;var out={};for(var prop in defaultOptions)out[prop]=defaultOptions[prop];if(editor)for(var prop in editor)if(editor[prop]!==undefined)out[prop]=editor[prop];if(options)for(var prop in options)if(options[prop]!==undefined)out[prop]=options[prop];if(out.hint.resolve)out.hint=out.hint.resolve(cm,pos);return out}function getText(completion){if(typeof completion=="string")return completion;else return completion.text}function buildKeyMap(completion,handle){var baseMap={Up:function(){handle.moveFocus(-1)},Down:function(){handle.moveFocus(1)},PageUp:function(){handle.moveFocus(-handle.menuSize()+1,true)},PageDown:function(){handle.moveFocus(handle.menuSize()-1,true)},Home:function(){handle.setFocus(0)},End:function(){handle.setFocus(handle.length-1)},Enter:handle.pick,Tab:handle.pick,Esc:handle.close};var custom=completion.options.customKeys;var ourMap=custom?{}:baseMap;function addBinding(key,val){var bound;if(typeof val!="string")bound=function(cm){return val(cm,handle)};else if(baseMap.hasOwnProperty(val))bound=baseMap[val];else bound=val;ourMap[key]=bound}if(custom)for(var key in custom)if(custom.hasOwnProperty(key))addBinding(key,custom[key]);var extra=completion.options.extraKeys;if(extra)for(var key in extra)if(extra.hasOwnProperty(key))addBinding(key,extra[key]);return ourMap}function getHintElement(hintsElement,el){while(el&&el!=hintsElement){if(el.nodeName.toUpperCase()==="LI"&&el.parentNode==hintsElement)return el;el=el.parentNode}}function Widget(completion,data){this.completion=completion;this.data=data;this.picked=false;var widget=this,cm=completion.cm;var hints=this.hints=document.createElement("ul");hints.className="CodeMirror-hints";this.selectedHint=data.selectedHint||0;var completions=data.list;for(var i=0;i<completions.length;++i){var elt=hints.appendChild(document.createElement("li")),cur=completions[i];var className=HINT_ELEMENT_CLASS+(i!=this.selectedHint?"":" "+ACTIVE_HINT_ELEMENT_CLASS);if(cur.className!=null)className=cur.className+" "+className;elt.className=className;if(cur.render)cur.render(elt,data,cur);else elt.appendChild(document.createTextNode(cur.displayText||getText(cur)));elt.hintId=i}var pos=cm.cursorCoords(completion.options.alignWithWord?data.from:null);var left=pos.left,top=pos.bottom,below=true;hints.style.left=left+"px";hints.style.top=top+"px";var winW=window.innerWidth||Math.max(document.body.offsetWidth,document.documentElement.offsetWidth);var winH=window.innerHeight||Math.max(document.body.offsetHeight,document.documentElement.offsetHeight);(completion.options.container||document.body).appendChild(hints);var box=hints.getBoundingClientRect(),overlapY=box.bottom-winH;var scrolls=hints.scrollHeight>hints.clientHeight+1;var startScroll=cm.getScrollInfo();if(overlapY>0){var height=box.bottom-box.top,curTop=pos.top-(pos.bottom-box.top);if(curTop-height>0){hints.style.top=(top=pos.top-height)+"px";below=false}else if(height>winH){hints.style.height=winH-5+"px";hints.style.top=(top=pos.bottom-box.top)+"px";var cursor=cm.getCursor();if(data.from.ch!=cursor.ch){pos=cm.cursorCoords(cursor);hints.style.left=(left=pos.left)+"px";box=hints.getBoundingClientRect()}}}var overlapX=box.right-winW;if(overlapX>0){if(box.right-box.left>winW){hints.style.width=winW-5+"px";overlapX-=box.right-box.left-winW}hints.style.left=(left=pos.left-overlapX)+"px"}if(scrolls)for(var node=hints.firstChild;node;node=node.nextSibling)node.style.paddingRight=cm.display.nativeBarWidth+"px";cm.addKeyMap(this.keyMap=buildKeyMap(completion,{moveFocus:function(n,avoidWrap){widget.changeActive(widget.selectedHint+n,avoidWrap)},setFocus:function(n){widget.changeActive(n)},menuSize:function(){return widget.screenAmount()},length:completions.length,close:function(){completion.close()},pick:function(){widget.pick()},data:data}));if(completion.options.closeOnUnfocus){var closingOnBlur;cm.on("blur",this.onBlur=function(){closingOnBlur=setTimeout(function(){completion.close()},100)});cm.on("focus",this.onFocus=function(){clearTimeout(closingOnBlur)})}cm.on("scroll",this.onScroll=function(){var curScroll=cm.getScrollInfo(),editor=cm.getWrapperElement().getBoundingClientRect();var newTop=top+startScroll.top-curScroll.top;var point=newTop-(window.pageYOffset||(document.documentElement||document.body).scrollTop);if(!below)point+=hints.offsetHeight;if(point<=editor.top||point>=editor.bottom)return completion.close();hints.style.top=newTop+"px";hints.style.left=left+startScroll.left-curScroll.left+"px"});CodeMirror.on(hints,"dblclick",function(e){var t=getHintElement(hints,e.target||e.srcElement);if(t&&t.hintId!=null){widget.changeActive(t.hintId);widget.pick()}});CodeMirror.on(hints,"click",function(e){var t=getHintElement(hints,e.target||e.srcElement);if(t&&t.hintId!=null){widget.changeActive(t.hintId);if(completion.options.completeOnSingleClick)widget.pick()}});CodeMirror.on(hints,"mousedown",function(){setTimeout(function(){cm.focus()},20)});CodeMirror.signal(data,"select",completions[0],hints.firstChild);return true}Widget.prototype={close:function(){if(this.completion.widget!=this)return;this.completion.widget=null;this.hints.parentNode.removeChild(this.hints);this.completion.cm.removeKeyMap(this.keyMap);var cm=this.completion.cm;if(this.completion.options.closeOnUnfocus){cm.off("blur",this.onBlur);cm.off("focus",this.onFocus)}cm.off("scroll",this.onScroll)},disable:function(){this.completion.cm.removeKeyMap(this.keyMap);var widget=this;this.keyMap={Enter:function(){widget.picked=true}};this.completion.cm.addKeyMap(this.keyMap)},pick:function(){this.completion.pick(this.data,this.selectedHint)},changeActive:function(i,avoidWrap){if(i>=this.data.list.length)i=avoidWrap?this.data.list.length-1:0;else if(i<0)i=avoidWrap?0:this.data.list.length-1;if(this.selectedHint==i)return;var node=this.hints.childNodes[this.selectedHint];node.className=node.className.replace(" "+ACTIVE_HINT_ELEMENT_CLASS,"");node=this.hints.childNodes[this.selectedHint=i];node.className+=" "+ACTIVE_HINT_ELEMENT_CLASS;if(node.offsetTop<this.hints.scrollTop)this.hints.scrollTop=node.offsetTop-3;else if(node.offsetTop+node.offsetHeight>this.hints.scrollTop+this.hints.clientHeight)this.hints.scrollTop=node.offsetTop+node.offsetHeight-this.hints.clientHeight+3;CodeMirror.signal(this.data,"select",this.data.list[this.selectedHint],node)},screenAmount:function(){return Math.floor(this.hints.clientHeight/this.hints.firstChild.offsetHeight)||1}};function applicableHelpers(cm,helpers){if(!cm.somethingSelected())return helpers;var result=[];for(var i=0;i<helpers.length;i++)if(helpers[i].supportsSelection)result.push(helpers[i]);return result}function fetchHints(hint,cm,options,callback){if(hint.async){hint(cm,callback,options)}else{var result=hint(cm,options);if(result&&result.then)result.then(callback);else callback(result)}}function resolveAutoHints(cm,pos){var helpers=cm.getHelpers(pos,"hint"),words;if(helpers.length){var resolved=function(cm,callback,options){var app=applicableHelpers(cm,helpers);function run(i){if(i==app.length)return callback(null);fetchHints(app[i],cm,options,function(result){if(result&&result.list.length>0)callback(result);else run(i+1)})}run(0)};resolved.async=true;resolved.supportsSelection=true;return resolved}else if(words=cm.getHelper(cm.getCursor(),"hintWords")){return function(cm){return CodeMirror.hint.fromList(cm,{words:words})}}else if(CodeMirror.hint.anyword){return function(cm,options){return CodeMirror.hint.anyword(cm,options)}}else{return function(){}}}CodeMirror.registerHelper("hint","auto",{resolve:resolveAutoHints});CodeMirror.registerHelper("hint","fromList",function(cm,options){var cur=cm.getCursor(),token=cm.getTokenAt(cur);var to=CodeMirror.Pos(cur.line,token.end);if(token.string&&/\w/.test(token.string[token.string.length-1])){var term=token.string,from=CodeMirror.Pos(cur.line,token.start)}else{var term="",from=to}var found=[];for(var i=0;i<options.words.length;i++){var word=options.words[i];if(word.slice(0,term.length)==term)found.push(word)}if(found.length)return{list:found,from:from,to:to}});CodeMirror.commands.autocomplete=CodeMirror.showHint;var defaultOptions={hint:CodeMirror.hint.auto,completeSingle:true,alignWithWord:true,closeCharacters:/[\s()\[\]{};:>,]/,closeOnUnfocus:true,completeOnSingleClick:true,container:null,customKeys:null,extraKeys:null};CodeMirror.defineOption("hintOptions",null)});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var WORD=/[\w$]+/,RANGE=500;CodeMirror.registerHelper("hint","anyword",function(editor,options){var word=options&&options.word||WORD;var range=options&&options.range||RANGE;var cur=editor.getCursor(),curLine=editor.getLine(cur.line);var end=cur.ch,start=end;while(start&&word.test(curLine.charAt(start-1)))--start;var curWord=start!=end&&curLine.slice(start,end);var list=options&&options.list||[],seen={};var re=new RegExp(word.source,"g");for(var dir=-1;dir<=1;dir+=2){var line=cur.line,endLine=Math.min(Math.max(line+dir*range,editor.firstLine()),editor.lastLine())+dir;for(;line!=endLine;line+=dir){var text=editor.getLine(line),m;while(m=re.exec(text)){if(line==cur.line&&m[0]===curWord)continue;if((!curWord||m[0].lastIndexOf(curWord,0)==0)&&!Object.prototype.hasOwnProperty.call(seen,m[0])){seen[m[0]]=true;list.push(m[0])}}}}return{list:list,from:CodeMirror.Pos(cur.line,start),to:CodeMirror.Pos(cur.line,end)}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("../../mode/css/css"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","../../mode/css/css"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var pseudoClasses={link:1,visited:1,active:1,hover:1,focus:1,"first-letter":1,"first-line":1,"first-child":1,before:1,after:1,lang:1};CodeMirror.registerHelper("hint","css",function(cm){var cur=cm.getCursor(),token=cm.getTokenAt(cur);var inner=CodeMirror.innerMode(cm.getMode(),token.state);if(inner.mode.name!="css")return;if(token.type=="keyword"&&"!important".indexOf(token.string)==0)return{list:["!important"],from:CodeMirror.Pos(cur.line,token.start),to:CodeMirror.Pos(cur.line,token.end)};var start=token.start,end=cur.ch,word=token.string.slice(0,end-start);if(/[^\w$_-]/.test(word)){word="";start=end=cur.ch}var spec=CodeMirror.resolveMode("text/css");var result=[];function add(keywords){for(var name in keywords)if(!word||name.lastIndexOf(word,0)==0)result.push(name)}var st=inner.state.state;if(st=="pseudo"||token.type=="variable-3"){add(pseudoClasses)}else if(st=="block"||st=="maybeprop"){add(spec.propertyKeywords)}else if(st=="prop"||st=="parens"||st=="at"||st=="params"){add(spec.valueKeywords);add(spec.colorKeywords)}else if(st=="media"||st=="media_parens"){add(spec.mediaTypes);add(spec.mediaFeatures)}if(result.length)return{list:result,from:CodeMirror.Pos(cur.line,start),to:CodeMirror.Pos(cur.line,end)}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("./xml-hint"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","./xml-hint"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var langs="ab aa af ak sq am ar an hy as av ae ay az bm ba eu be bn bh bi bs br bg my ca ch ce ny zh cv kw co cr hr cs da dv nl dz en eo et ee fo fj fi fr ff gl ka de el gn gu ht ha he hz hi ho hu ia id ie ga ig ik io is it iu ja jv kl kn kr ks kk km ki rw ky kv kg ko ku kj la lb lg li ln lo lt lu lv gv mk mg ms ml mt mi mr mh mn na nv nb nd ne ng nn no ii nr oc oj cu om or os pa pi fa pl ps pt qu rm rn ro ru sa sc sd se sm sg sr gd sn si sk sl so st es su sw ss sv ta te tg th ti bo tk tl tn to tr ts tt tw ty ug uk ur uz ve vi vo wa cy wo fy xh yi yo za zu".split(" ");var targets=["_blank","_self","_top","_parent"];var charsets=["ascii","utf-8","utf-16","latin1","latin1"];var methods=["get","post","put","delete"];var encs=["application/x-www-form-urlencoded","multipart/form-data","text/plain"];var media=["all","screen","print","embossed","braille","handheld","print","projection","screen","tty","tv","speech","3d-glasses","resolution [>][<][=] [X]","device-aspect-ratio: X/Y","orientation:portrait","orientation:landscape","device-height: [X]","device-width: [X]"];var s={attrs:{}};var data={a:{attrs:{href:null,ping:null,type:null,media:media,target:targets,hreflang:langs}},abbr:s,acronym:s,address:s,applet:s,area:{attrs:{alt:null,coords:null,href:null,target:null,ping:null,media:media,hreflang:langs,type:null,shape:["default","rect","circle","poly"]}},article:s,aside:s,audio:{attrs:{src:null,mediagroup:null,crossorigin:["anonymous","use-credentials"],preload:["none","metadata","auto"],autoplay:["","autoplay"],loop:["","loop"],controls:["","controls"]}},b:s,base:{attrs:{href:null,target:targets}},basefont:s,bdi:s,bdo:s,big:s,blockquote:{attrs:{cite:null}},body:s,br:s,button:{attrs:{form:null,formaction:null,name:null,value:null,autofocus:["","autofocus"],disabled:["","autofocus"],formenctype:encs,formmethod:methods,formnovalidate:["","novalidate"],formtarget:targets,type:["submit","reset","button"]}},canvas:{attrs:{width:null,height:null}},caption:s,center:s,cite:s,code:s,col:{attrs:{span:null}},colgroup:{attrs:{span:null}},command:{attrs:{type:["command","checkbox","radio"],label:null,icon:null,radiogroup:null,command:null,title:null,disabled:["","disabled"],checked:["","checked"]}},data:{attrs:{value:null}},datagrid:{attrs:{disabled:["","disabled"],multiple:["","multiple"]}},datalist:{attrs:{data:null}},dd:s,del:{attrs:{cite:null,datetime:null}},details:{attrs:{open:["","open"]}},dfn:s,dir:s,div:s,dl:s,dt:s,em:s,embed:{attrs:{src:null,type:null,width:null,height:null}},eventsource:{attrs:{src:null}},fieldset:{attrs:{disabled:["","disabled"],form:null,name:null}},figcaption:s,figure:s,font:s,footer:s,form:{attrs:{action:null,name:null,"accept-charset":charsets,autocomplete:["on","off"],enctype:encs,method:methods,novalidate:["","novalidate"],target:targets}},frame:s,frameset:s,h1:s,h2:s,h3:s,h4:s,h5:s,h6:s,head:{attrs:{},children:["title","base","link","style","meta","script","noscript","command"]},header:s,hgroup:s,hr:s,html:{attrs:{manifest:null},children:["head","body"]},i:s,iframe:{attrs:{src:null,srcdoc:null,name:null,width:null,height:null,sandbox:["allow-top-navigation","allow-same-origin","allow-forms","allow-scripts"],seamless:["","seamless"]}},img:{attrs:{alt:null,src:null,ismap:null,usemap:null,width:null,height:null,crossorigin:["anonymous","use-credentials"]}},input:{attrs:{alt:null,dirname:null,form:null,formaction:null,height:null,list:null,max:null,maxlength:null,min:null,name:null,pattern:null,placeholder:null,size:null,src:null,step:null,value:null,width:null,accept:["audio/*","video/*","image/*"],autocomplete:["on","off"],autofocus:["","autofocus"],checked:["","checked"],disabled:["","disabled"],formenctype:encs,formmethod:methods,formnovalidate:["","novalidate"],formtarget:targets,multiple:["","multiple"],readonly:["","readonly"],required:["","required"],type:["hidden","text","search","tel","url","email","password","datetime","date","month","week","time","datetime-local","number","range","color","checkbox","radio","file","submit","image","reset","button"]}},ins:{attrs:{cite:null,datetime:null}},kbd:s,keygen:{attrs:{challenge:null,form:null,name:null,autofocus:["","autofocus"],disabled:["","disabled"],keytype:["RSA"]}},label:{attrs:{for:null,form:null}},legend:s,li:{attrs:{value:null}},link:{attrs:{href:null,type:null,hreflang:langs,media:media,sizes:["all","16x16","16x16 32x32","16x16 32x32 64x64"]}},map:{attrs:{name:null}},mark:s,menu:{attrs:{label:null,type:["list","context","toolbar"]}},meta:{attrs:{content:null,charset:charsets,name:["viewport","application-name","author","description","generator","keywords"],"http-equiv":["content-language","content-type","default-style","refresh"]}},meter:{attrs:{value:null,min:null,low:null,high:null,max:null,optimum:null}},nav:s,noframes:s,noscript:s,object:{attrs:{data:null,type:null,name:null,usemap:null,form:null,width:null,height:null,typemustmatch:["","typemustmatch"]}},ol:{attrs:{reversed:["","reversed"],start:null,type:["1","a","A","i","I"]}},optgroup:{attrs:{disabled:["","disabled"],label:null}},option:{attrs:{disabled:["","disabled"],label:null,selected:["","selected"],value:null}},output:{attrs:{for:null,form:null,name:null}},p:s,param:{attrs:{name:null,value:null}},pre:s,progress:{attrs:{value:null,max:null}},q:{attrs:{cite:null}},rp:s,rt:s,ruby:s,s:s,samp:s,script:{attrs:{type:["text/javascript"],src:null,async:["","async"],defer:["","defer"],charset:charsets}},section:s,select:{attrs:{form:null,name:null,size:null,autofocus:["","autofocus"],disabled:["","disabled"],multiple:["","multiple"]}},small:s,source:{attrs:{src:null,type:null,media:null}},span:s,strike:s,strong:s,style:{attrs:{type:["text/css"],media:media,scoped:null}},sub:s,summary:s,sup:s,table:s,tbody:s,td:{attrs:{colspan:null,rowspan:null,headers:null}},textarea:{attrs:{dirname:null,form:null,maxlength:null,name:null,placeholder:null,rows:null,cols:null,autofocus:["","autofocus"],disabled:["","disabled"],readonly:["","readonly"],required:["","required"],wrap:["soft","hard"]}},tfoot:s,th:{attrs:{colspan:null,rowspan:null,headers:null,scope:["row","col","rowgroup","colgroup"]}},thead:s,time:{attrs:{datetime:null}},title:s,tr:s,track:{attrs:{src:null,label:null,default:null,kind:["subtitles","captions","descriptions","chapters","metadata"],srclang:langs}},tt:s,u:s,ul:s,var:s,video:{attrs:{src:null,poster:null,width:null,height:null,crossorigin:["anonymous","use-credentials"],preload:["auto","metadata","none"],autoplay:["","autoplay"],mediagroup:["movie"],muted:["","muted"],controls:["","controls"]}},wbr:s};var globalAttrs={accesskey:["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","0","1","2","3","4","5","6","7","8","9"],class:null,contenteditable:["true","false"],contextmenu:null,dir:["ltr","rtl","auto"],draggable:["true","false","auto"],dropzone:["copy","move","link","string:","file:"],hidden:["hidden"],id:null,inert:["inert"],itemid:null,itemprop:null,itemref:null,itemscope:["itemscope"],itemtype:null,lang:["en","es"],spellcheck:["true","false"],style:null,tabindex:["1","2","3","4","5","6","7","8","9"],title:null,translate:["yes","no"],onclick:null,rel:["stylesheet","alternate","author","bookmark","help","license","next","nofollow","noreferrer","prefetch","prev","search","tag"]};function populate(obj){for(var attr in globalAttrs)if(globalAttrs.hasOwnProperty(attr))obj.attrs[attr]=globalAttrs[attr]}populate(s);for(var tag in data)if(data.hasOwnProperty(tag)&&data[tag]!=s)populate(data[tag]);CodeMirror.htmlSchema=data;function htmlHint(cm,options){var local={schemaInfo:data};if(options)for(var opt in options)local[opt]=options[opt];return CodeMirror.hint.xml(cm,local)}CodeMirror.registerHelper("hint","html",htmlHint)});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){var Pos=CodeMirror.Pos;function forEach(arr,f){for(var i=0,e=arr.length;i<e;++i)f(arr[i])}function arrayContains(arr,item){if(!Array.prototype.indexOf){var i=arr.length;while(i--){if(arr[i]===item){return true}}return false}return arr.indexOf(item)!=-1}function scriptHint(editor,keywords,getToken,options){var cur=editor.getCursor(),token=getToken(editor,cur);if(/\b(?:string|comment)\b/.test(token.type))return;token.state=CodeMirror.innerMode(editor.getMode(),token.state).state;if(!/^[\w$_]*$/.test(token.string)){token={start:cur.ch,end:cur.ch,string:"",state:token.state,type:token.string=="."?"property":null}}else if(token.end>cur.ch){token.end=cur.ch;token.string=token.string.slice(0,cur.ch-token.start)}var tprop=token;while(tprop.type=="property"){tprop=getToken(editor,Pos(cur.line,tprop.start));if(tprop.string!=".")return;tprop=getToken(editor,Pos(cur.line,tprop.start));if(!context)var context=[];context.push(tprop)}return{list:getCompletions(token,context,keywords,options),from:Pos(cur.line,token.start),to:Pos(cur.line,token.end)}}function javascriptHint(editor,options){return scriptHint(editor,javascriptKeywords,function(e,cur){return e.getTokenAt(cur)},options)}CodeMirror.registerHelper("hint","javascript",javascriptHint);function getCoffeeScriptToken(editor,cur){var token=editor.getTokenAt(cur);if(cur.ch==token.start+1&&token.string.charAt(0)=="."){token.end=token.start;token.string=".";token.type="property"}else if(/^\.[\w$_]*$/.test(token.string)){token.type="property";token.start++;token.string=token.string.replace(/\./,"")}return token}function coffeescriptHint(editor,options){return scriptHint(editor,coffeescriptKeywords,getCoffeeScriptToken,options)}CodeMirror.registerHelper("hint","coffeescript",coffeescriptHint);var stringProps=("charAt charCodeAt indexOf lastIndexOf substring substr slice trim trimLeft trimRight "+"toUpperCase toLowerCase split concat match replace search").split(" ");var arrayProps=("length concat join splice push pop shift unshift slice reverse sort indexOf "+"lastIndexOf every some filter forEach map reduce reduceRight ").split(" ");var funcProps="prototype apply call bind".split(" ");var javascriptKeywords=("break case catch continue debugger default delete do else false finally for function "+"if in instanceof new null return switch throw true try typeof var void while with").split(" ");var coffeescriptKeywords=("and break catch class continue delete do else extends false finally for "+"if in instanceof isnt new no not null of off on or return switch then throw true try typeof until void while with yes").split(" ");function forAllProps(obj,callback){if(!Object.getOwnPropertyNames||!Object.getPrototypeOf){for(var name in obj)callback(name)}else{for(var o=obj;o;o=Object.getPrototypeOf(o))Object.getOwnPropertyNames(o).forEach(callback)}}function getCompletions(token,context,keywords,options){var found=[],start=token.string,global=options&&options.globalScope||window;function maybeAdd(str){if(str.lastIndexOf(start,0)==0&&!arrayContains(found,str))found.push(str)}function gatherCompletions(obj){if(typeof obj=="string")forEach(stringProps,maybeAdd);else if(obj instanceof Array)forEach(arrayProps,maybeAdd);else if(obj instanceof Function)forEach(funcProps,maybeAdd);forAllProps(obj,maybeAdd)}if(context&&context.length){var obj=context.pop(),base;if(obj.type&&obj.type.indexOf("variable")===0){if(options&&options.additionalContext)base=options.additionalContext[obj.string];if(!options||options.useGlobalScope!==false)base=base||global[obj.string]}else if(obj.type=="string"){base=""}else if(obj.type=="atom"){base=1}else if(obj.type=="function"){if(global.jQuery!=null&&(obj.string=="$"||obj.string=="jQuery")&&typeof global.jQuery=="function")base=global.jQuery();else if(global._!=null&&obj.string=="_"&&typeof global._=="function")base=global._()}while(base!=null&&context.length)base=base[context.pop().string];if(base!=null)gatherCompletions(base)}else{for(var v=token.state.localVars;v;v=v.next)maybeAdd(v.name);for(var v=token.state.globalVars;v;v=v.next)maybeAdd(v.name);if(!options||options.useGlobalScope!==false)gatherCompletions(global);forEach(keywords,maybeAdd)}return found}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("../../mode/sql/sql"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","../../mode/sql/sql"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var tables;var defaultTable;var keywords;var identifierQuote;var CONS={QUERY_DIV:";",ALIAS_KEYWORD:"AS"};var Pos=CodeMirror.Pos,cmpPos=CodeMirror.cmpPos;function isArray(val){return Object.prototype.toString.call(val)=="[object Array]"}function getKeywords(editor){var mode=editor.doc.modeOption;if(mode==="sql")mode="text/x-sql";return CodeMirror.resolveMode(mode).keywords}function getIdentifierQuote(editor){var mode=editor.doc.modeOption;if(mode==="sql")mode="text/x-sql";return CodeMirror.resolveMode(mode).identifierQuote||"`"}function getText(item){return typeof item=="string"?item:item.text}function wrapTable(name,value){if(isArray(value))value={columns:value};if(!value.text)value.text=name;return value}function parseTables(input){var result={};if(isArray(input)){for(var i=input.length-1;i>=0;i--){var item=input[i];result[getText(item).toUpperCase()]=wrapTable(getText(item),item)}}else if(input){for(var name in input)result[name.toUpperCase()]=wrapTable(name,input[name])}return result}function getTable(name){return tables[name.toUpperCase()]}function shallowClone(object){var result={};for(var key in object)if(object.hasOwnProperty(key))result[key]=object[key];return result}function match(string,word){var len=string.length;var sub=getText(word).substr(0,len);return string.toUpperCase()===sub.toUpperCase()}function addMatches(result,search,wordlist,formatter){if(isArray(wordlist)){for(var i=0;i<wordlist.length;i++)if(match(search,wordlist[i]))result.push(formatter(wordlist[i]))}else{for(var word in wordlist)if(wordlist.hasOwnProperty(word)){var val=wordlist[word];if(!val||val===true)val=word;else val=val.displayText?{text:val.text,displayText:val.displayText}:val.text;if(match(search,val))result.push(formatter(val))}}}function cleanName(name){if(name.charAt(0)=="."){name=name.substr(1)}var nameParts=name.split(identifierQuote+identifierQuote);for(var i=0;i<nameParts.length;i++)nameParts[i]=nameParts[i].replace(new RegExp(identifierQuote,"g"),"");return nameParts.join(identifierQuote)}function insertIdentifierQuotes(name){var nameParts=getText(name).split(".");for(var i=0;i<nameParts.length;i++)nameParts[i]=identifierQuote+nameParts[i].replace(new RegExp(identifierQuote,"g"),identifierQuote+identifierQuote)+identifierQuote;var escaped=nameParts.join(".");if(typeof name=="string")return escaped;name=shallowClone(name);name.text=escaped;return name}function nameCompletion(cur,token,result,editor){var useIdentifierQuotes=false;var nameParts=[];var start=token.start;var cont=true;while(cont){cont=token.string.charAt(0)==".";useIdentifierQuotes=useIdentifierQuotes||token.string.charAt(0)==identifierQuote;start=token.start;nameParts.unshift(cleanName(token.string));token=editor.getTokenAt(Pos(cur.line,token.start));if(token.string=="."){cont=true;token=editor.getTokenAt(Pos(cur.line,token.start))}}var string=nameParts.join(".");addMatches(result,string,tables,function(w){return useIdentifierQuotes?insertIdentifierQuotes(w):w});addMatches(result,string,defaultTable,function(w){return useIdentifierQuotes?insertIdentifierQuotes(w):w});string=nameParts.pop();var table=nameParts.join(".");var alias=false;var aliasTable=table;if(!getTable(table)){var oldTable=table;table=findTableByAlias(table,editor);if(table!==oldTable)alias=true}var columns=getTable(table);if(columns&&columns.columns)columns=columns.columns;if(columns){addMatches(result,string,columns,function(w){var tableInsert=table;if(alias==true)tableInsert=aliasTable;if(typeof w=="string"){w=tableInsert+"."+w}else{w=shallowClone(w);w.text=tableInsert+"."+w.text}return useIdentifierQuotes?insertIdentifierQuotes(w):w})}return start}function eachWord(lineText,f){var words=lineText.split(/\s+/);for(var i=0;i<words.length;i++)if(words[i])f(words[i].replace(/[,;]/g,""))}function findTableByAlias(alias,editor){var doc=editor.doc;var fullQuery=doc.getValue();var aliasUpperCase=alias.toUpperCase();var previousWord="";var table="";var separator=[];var validRange={start:Pos(0,0),end:Pos(editor.lastLine(),editor.getLineHandle(editor.lastLine()).length)};var indexOfSeparator=fullQuery.indexOf(CONS.QUERY_DIV);while(indexOfSeparator!=-1){separator.push(doc.posFromIndex(indexOfSeparator));indexOfSeparator=fullQuery.indexOf(CONS.QUERY_DIV,indexOfSeparator+1)}separator.unshift(Pos(0,0));separator.push(Pos(editor.lastLine(),editor.getLineHandle(editor.lastLine()).text.length));var prevItem=null;var current=editor.getCursor();for(var i=0;i<separator.length;i++){if((prevItem==null||cmpPos(current,prevItem)>0)&&cmpPos(current,separator[i])<=0){validRange={start:prevItem,end:separator[i]};break}prevItem=separator[i]}var query=doc.getRange(validRange.start,validRange.end,false);for(var i=0;i<query.length;i++){var lineText=query[i];eachWord(lineText,function(word){var wordUpperCase=word.toUpperCase();if(wordUpperCase===aliasUpperCase&&getTable(previousWord))table=previousWord;if(wordUpperCase!==CONS.ALIAS_KEYWORD)previousWord=word});if(table)break}return table}CodeMirror.registerHelper("hint","sql",function(editor,options){tables=parseTables(options&&options.tables);var defaultTableName=options&&options.defaultTable;var disableKeywords=options&&options.disableKeywords;defaultTable=defaultTableName&&getTable(defaultTableName);keywords=getKeywords(editor);identifierQuote=getIdentifierQuote(editor);if(defaultTableName&&!defaultTable)defaultTable=findTableByAlias(defaultTableName,editor);defaultTable=defaultTable||[];if(defaultTable.columns)defaultTable=defaultTable.columns;var cur=editor.getCursor();var result=[];var token=editor.getTokenAt(cur),start,end,search;if(token.end>cur.ch){token.end=cur.ch;token.string=token.string.slice(0,cur.ch-token.start)}if(token.string.match(/^[.`"\w@]\w*$/)){search=token.string;start=token.start;end=token.end}else{start=end=cur.ch;search=""}if(search.charAt(0)=="."||search.charAt(0)==identifierQuote){start=nameCompletion(cur,token,result,editor)}else{addMatches(result,search,tables,function(w){return w});addMatches(result,search,defaultTable,function(w){return w});if(!disableKeywords)addMatches(result,search,keywords,function(w){return w.toUpperCase()})}return{list:result,from:Pos(cur.line,start),to:Pos(cur.line,end)}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var Pos=CodeMirror.Pos;function getHints(cm,options){var tags=options&&options.schemaInfo;var quote=options&&options.quoteChar||'"';if(!tags)return;var cur=cm.getCursor(),token=cm.getTokenAt(cur);if(token.end>cur.ch){token.end=cur.ch;token.string=token.string.slice(0,cur.ch-token.start)}var inner=CodeMirror.innerMode(cm.getMode(),token.state);if(inner.mode.name!="xml")return;var result=[],replaceToken=false,prefix;var tag=/\btag\b/.test(token.type)&&!/>$/.test(token.string);var tagName=tag&&/^\w/.test(token.string),tagStart;if(tagName){var before=cm.getLine(cur.line).slice(Math.max(0,token.start-2),token.start);var tagType=/<\/$/.test(before)?"close":/<$/.test(before)?"open":null;if(tagType)tagStart=token.start-(tagType=="close"?2:1)}else if(tag&&token.string=="<"){tagType="open"}else if(tag&&token.string=="</"){tagType="close"}if(!tag&&!inner.state.tagName||tagType){if(tagName)prefix=token.string;replaceToken=tagType;var cx=inner.state.context,curTag=cx&&tags[cx.tagName];var childList=cx?curTag&&curTag.children:tags["!top"];if(childList&&tagType!="close"){for(var i=0;i<childList.length;++i)if(!prefix||childList[i].lastIndexOf(prefix,0)==0)result.push("<"+childList[i])}else if(tagType!="close"){for(var name in tags)if(tags.hasOwnProperty(name)&&name!="!top"&&name!="!attrs"&&(!prefix||name.lastIndexOf(prefix,0)==0))result.push("<"+name)}if(cx&&(!prefix||tagType=="close"&&cx.tagName.lastIndexOf(prefix,0)==0))result.push("</"+cx.tagName+">")}else{var curTag=tags[inner.state.tagName],attrs=curTag&&curTag.attrs;var globalAttrs=tags["!attrs"];if(!attrs&&!globalAttrs)return;if(!attrs){attrs=globalAttrs}else if(globalAttrs){var set={};for(var nm in globalAttrs)if(globalAttrs.hasOwnProperty(nm))set[nm]=globalAttrs[nm];for(var nm in attrs)if(attrs.hasOwnProperty(nm))set[nm]=attrs[nm];attrs=set}if(token.type=="string"||token.string=="="){var before=cm.getRange(Pos(cur.line,Math.max(0,cur.ch-60)),Pos(cur.line,token.type=="string"?token.start:token.end));var atName=before.match(/([^\s\u00a0=<>\"\']+)=$/),atValues;if(!atName||!attrs.hasOwnProperty(atName[1])||!(atValues=attrs[atName[1]]))return;if(typeof atValues=="function")atValues=atValues.call(this,cm);if(token.type=="string"){prefix=token.string;var n=0;if(/['"]/.test(token.string.charAt(0))){quote=token.string.charAt(0);prefix=token.string.slice(1);n++}var len=token.string.length;if(/['"]/.test(token.string.charAt(len-1))){quote=token.string.charAt(len-1);prefix=token.string.substr(n,len-2)}replaceToken=true}for(var i=0;i<atValues.length;++i)if(!prefix||atValues[i].lastIndexOf(prefix,0)==0)result.push(quote+atValues[i]+quote)}else{if(token.type=="attribute"){prefix=token.string;replaceToken=true}for(var attr in attrs)if(attrs.hasOwnProperty(attr)&&(!prefix||attr.lastIndexOf(prefix,0)==0))result.push(attr)}}return{list:result,from:replaceToken?Pos(cur.line,tagStart==null?token.start:tagStart):cur,to:replaceToken?Pos(cur.line,token.end):cur}}CodeMirror.registerHelper("hint","xml",getHints)});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function Bar(cls,orientation,scroll){this.orientation=orientation;this.scroll=scroll;this.screen=this.total=this.size=1;this.pos=0;this.node=document.createElement("div");this.node.className=cls+"-"+orientation;this.inner=this.node.appendChild(document.createElement("div"));var self=this;CodeMirror.on(this.inner,"mousedown",function(e){if(e.which!=1)return;CodeMirror.e_preventDefault(e);var axis=self.orientation=="horizontal"?"pageX":"pageY";var start=e[axis],startpos=self.pos;function done(){CodeMirror.off(document,"mousemove",move);CodeMirror.off(document,"mouseup",done)}function move(e){if(e.which!=1)return done();self.moveTo(startpos+(e[axis]-start)*(self.total/self.size))}CodeMirror.on(document,"mousemove",move);CodeMirror.on(document,"mouseup",done)});CodeMirror.on(this.node,"click",function(e){CodeMirror.e_preventDefault(e);var innerBox=self.inner.getBoundingClientRect(),where;if(self.orientation=="horizontal")where=e.clientX<innerBox.left?-1:e.clientX>innerBox.right?1:0;else where=e.clientY<innerBox.top?-1:e.clientY>innerBox.bottom?1:0;self.moveTo(self.pos+where*self.screen)});function onWheel(e){var moved=CodeMirror.wheelEventPixels(e)[self.orientation=="horizontal"?"x":"y"];var oldPos=self.pos;self.moveTo(self.pos+moved);if(self.pos!=oldPos)CodeMirror.e_preventDefault(e)}CodeMirror.on(this.node,"mousewheel",onWheel);CodeMirror.on(this.node,"DOMMouseScroll",onWheel)}Bar.prototype.setPos=function(pos,force){if(pos<0)pos=0;if(pos>this.total-this.screen)pos=this.total-this.screen;if(!force&&pos==this.pos)return false;this.pos=pos;this.inner.style[this.orientation=="horizontal"?"left":"top"]=pos*(this.size/this.total)+"px";return true};Bar.prototype.moveTo=function(pos){if(this.setPos(pos))this.scroll(pos,this.orientation)};var minButtonSize=10;Bar.prototype.update=function(scrollSize,clientSize,barSize){var sizeChanged=this.screen!=clientSize||this.total!=scrollSize||this.size!=barSize;if(sizeChanged){this.screen=clientSize;this.total=scrollSize;this.size=barSize}var buttonSize=this.screen*(this.size/this.total);if(buttonSize<minButtonSize){this.size-=minButtonSize-buttonSize;buttonSize=minButtonSize}this.inner.style[this.orientation=="horizontal"?"width":"height"]=buttonSize+"px";this.setPos(this.pos,sizeChanged)};function SimpleScrollbars(cls,place,scroll){this.addClass=cls;this.horiz=new Bar(cls,"horizontal",scroll);place(this.horiz.node);this.vert=new Bar(cls,"vertical",scroll);place(this.vert.node);this.width=null}SimpleScrollbars.prototype.update=function(measure){if(this.width==null){var style=window.getComputedStyle?window.getComputedStyle(this.horiz.node):this.horiz.node.currentStyle;if(style)this.width=parseInt(style.height)}var width=this.width||0;var needsH=measure.scrollWidth>measure.clientWidth+1;var needsV=measure.scrollHeight>measure.clientHeight+1;this.vert.node.style.display=needsV?"block":"none";this.horiz.node.style.display=needsH?"block":"none";if(needsV){this.vert.update(measure.scrollHeight,measure.clientHeight,measure.viewHeight-(needsH?width:0));this.vert.node.style.bottom=needsH?width+"px":"0"}if(needsH){this.horiz.update(measure.scrollWidth,measure.clientWidth,measure.viewWidth-(needsV?width:0)-measure.barLeft);this.horiz.node.style.right=needsV?width+"px":"0";this.horiz.node.style.left=measure.barLeft+"px"}return{right:needsV?width:0,bottom:needsH?width:0}};SimpleScrollbars.prototype.setScrollTop=function(pos){this.vert.setPos(pos)};SimpleScrollbars.prototype.setScrollLeft=function(pos){this.horiz.setPos(pos)};SimpleScrollbars.prototype.clear=function(){var parent=this.horiz.node.parentNode;parent.removeChild(this.horiz.node);parent.removeChild(this.vert.node)};CodeMirror.scrollbarModel.simple=function(place,scroll){return new SimpleScrollbars("CodeMirror-simplescroll",place,scroll)};CodeMirror.scrollbarModel.overlay=function(place,scroll){return new SimpleScrollbars("CodeMirror-overlayscroll",place,scroll)}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineExtension("annotateScrollbar",function(options){if(typeof options=="string")options={className:options};return new Annotation(this,options)});CodeMirror.defineOption("scrollButtonHeight",0);function Annotation(cm,options){this.cm=cm;this.options=options;this.buttonHeight=options.scrollButtonHeight||cm.getOption("scrollButtonHeight");this.annotations=[];this.doRedraw=this.doUpdate=null;this.div=cm.getWrapperElement().appendChild(document.createElement("div"));this.div.style.cssText="position: absolute; right: 0; top: 0; z-index: 7; pointer-events: none";this.computeScale();function scheduleRedraw(delay){clearTimeout(self.doRedraw);self.doRedraw=setTimeout(function(){self.redraw()},delay)}var self=this;cm.on("refresh",this.resizeHandler=function(){clearTimeout(self.doUpdate);self.doUpdate=setTimeout(function(){if(self.computeScale())scheduleRedraw(20)},100)});cm.on("markerAdded",this.resizeHandler);cm.on("markerCleared",this.resizeHandler);if(options.listenForChanges!==false)cm.on("change",this.changeHandler=function(){scheduleRedraw(250)})}Annotation.prototype.computeScale=function(){var cm=this.cm;var hScale=(cm.getWrapperElement().clientHeight-cm.display.barHeight-this.buttonHeight*2)/cm.getScrollerElement().scrollHeight;if(hScale!=this.hScale){this.hScale=hScale;return true}};Annotation.prototype.update=function(annotations){this.annotations=annotations;this.redraw()};Annotation.prototype.redraw=function(compute){if(compute!==false)this.computeScale();var cm=this.cm,hScale=this.hScale;var frag=document.createDocumentFragment(),anns=this.annotations;var wrapping=cm.getOption("lineWrapping");var singleLineH=wrapping&&cm.defaultTextHeight()*1.5;var curLine=null,curLineObj=null;function getY(pos,top){if(curLine!=pos.line){curLine=pos.line;curLineObj=cm.getLineHandle(curLine)}if(curLineObj.widgets&&curLineObj.widgets.length||wrapping&&curLineObj.height>singleLineH)return cm.charCoords(pos,"local")[top?"top":"bottom"];var topY=cm.heightAtLine(curLineObj,"local");return topY+(top?0:curLineObj.height)}var lastLine=cm.lastLine();if(cm.display.barWidth)for(var i=0,nextTop;i<anns.length;i++){var ann=anns[i];if(ann.to.line>lastLine)continue;var top=nextTop||getY(ann.from,true)*hScale;var bottom=getY(ann.to,false)*hScale;while(i<anns.length-1){if(anns[i+1].to.line>lastLine)break;nextTop=getY(anns[i+1].from,true)*hScale;if(nextTop>bottom+.9)break;ann=anns[++i];bottom=getY(ann.to,false)*hScale}if(bottom==top)continue;var height=Math.max(bottom-top,3);var elt=frag.appendChild(document.createElement("div"));elt.style.cssText="position: absolute; right: 0px; width: "+Math.max(cm.display.barWidth-1,2)+"px; top: "+(top+this.buttonHeight)+"px; height: "+height+"px";elt.className=this.options.className;if(ann.id){elt.setAttribute("annotation-id",ann.id)}}this.div.textContent="";this.div.appendChild(frag)};Annotation.prototype.clear=function(){this.cm.off("refresh",this.resizeHandler);this.cm.off("markerAdded",this.resizeHandler);this.cm.off("markerCleared",this.resizeHandler);if(this.changeHandler)this.cm.off("change",this.changeHandler);this.div.parentNode.removeChild(this.div)}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var Pos=CodeMirror.Pos;function posEq(a,b){return a.line==b.line&&a.ch==b.ch}var killRing=[];function addToRing(str){killRing.push(str);if(killRing.length>50)killRing.shift()}function growRingTop(str){if(!killRing.length)return addToRing(str);killRing[killRing.length-1]+=str}function getFromRing(n){return killRing[killRing.length-(n?Math.min(n,1):1)]||""}function popFromRing(){if(killRing.length>1)killRing.pop();return getFromRing()}var lastKill=null;function kill(cm,from,to,mayGrow,text){if(text==null)text=cm.getRange(from,to);if(mayGrow&&lastKill&&lastKill.cm==cm&&posEq(from,lastKill.pos)&&cm.isClean(lastKill.gen))growRingTop(text);else addToRing(text);cm.replaceRange("",from,to,"+delete");if(mayGrow)lastKill={cm:cm,pos:from,gen:cm.changeGeneration()};else lastKill=null}function byChar(cm,pos,dir){return cm.findPosH(pos,dir,"char",true)}function byWord(cm,pos,dir){return cm.findPosH(pos,dir,"word",true)}function byLine(cm,pos,dir){return cm.findPosV(pos,dir,"line",cm.doc.sel.goalColumn)}function byPage(cm,pos,dir){return cm.findPosV(pos,dir,"page",cm.doc.sel.goalColumn)}function byParagraph(cm,pos,dir){var no=pos.line,line=cm.getLine(no);var sawText=/\S/.test(dir<0?line.slice(0,pos.ch):line.slice(pos.ch));var fst=cm.firstLine(),lst=cm.lastLine();for(;;){no+=dir;if(no<fst||no>lst)return cm.clipPos(Pos(no-dir,dir<0?0:null));line=cm.getLine(no);var hasText=/\S/.test(line);if(hasText)sawText=true;else if(sawText)return Pos(no,0)}}function bySentence(cm,pos,dir){var line=pos.line,ch=pos.ch;var text=cm.getLine(pos.line),sawWord=false;for(;;){var next=text.charAt(ch+(dir<0?-1:0));if(!next){if(line==(dir<0?cm.firstLine():cm.lastLine()))return Pos(line,ch);text=cm.getLine(line+dir);if(!/\S/.test(text))return Pos(line,ch);line+=dir;ch=dir<0?text.length:0;continue}if(sawWord&&/[!?.]/.test(next))return Pos(line,ch+(dir>0?1:0));if(!sawWord)sawWord=/\w/.test(next);ch+=dir}}function byExpr(cm,pos,dir){var wrap;if(cm.findMatchingBracket&&(wrap=cm.findMatchingBracket(pos,{strict:true}))&&wrap.match&&(wrap.forward?1:-1)==dir)return dir>0?Pos(wrap.to.line,wrap.to.ch+1):wrap.to;for(var first=true;;first=false){var token=cm.getTokenAt(pos);var after=Pos(pos.line,dir<0?token.start:token.end);if(first&&dir>0&&token.end==pos.ch||!/\w/.test(token.string)){var newPos=cm.findPosH(after,dir,"char");if(posEq(after,newPos))return pos;else pos=newPos}else{return after}}}function getPrefix(cm,precise){var digits=cm.state.emacsPrefix;if(!digits)return precise?null:1;clearPrefix(cm);return digits=="-"?-1:Number(digits)}function repeated(cmd){var f=typeof cmd=="string"?function(cm){cm.execCommand(cmd)}:cmd;return function(cm){var prefix=getPrefix(cm);f(cm);for(var i=1;i<prefix;++i)f(cm)}}function findEnd(cm,pos,by,dir){var prefix=getPrefix(cm);if(prefix<0){dir=-dir;prefix=-prefix}for(var i=0;i<prefix;++i){var newPos=by(cm,pos,dir);if(posEq(newPos,pos))break;pos=newPos}return pos}function move(by,dir){var f=function(cm){cm.extendSelection(findEnd(cm,cm.getCursor(),by,dir))};f.motion=true;return f}function killTo(cm,by,dir){var selections=cm.listSelections(),cursor;var i=selections.length;while(i--){cursor=selections[i].head;kill(cm,cursor,findEnd(cm,cursor,by,dir),true)}}function killRegion(cm){if(cm.somethingSelected()){var selections=cm.listSelections(),selection;var i=selections.length;while(i--){selection=selections[i];kill(cm,selection.anchor,selection.head)}return true}}function addPrefix(cm,digit){if(cm.state.emacsPrefix){if(digit!="-")cm.state.emacsPrefix+=digit;return}cm.state.emacsPrefix=digit;cm.on("keyHandled",maybeClearPrefix);cm.on("inputRead",maybeDuplicateInput)}var prefixPreservingKeys={"Alt-G":true,"Ctrl-X":true,"Ctrl-Q":true,"Ctrl-U":true};function maybeClearPrefix(cm,arg){if(!cm.state.emacsPrefixMap&&!prefixPreservingKeys.hasOwnProperty(arg))clearPrefix(cm)}function clearPrefix(cm){cm.state.emacsPrefix=null;cm.off("keyHandled",maybeClearPrefix);cm.off("inputRead",maybeDuplicateInput)}function maybeDuplicateInput(cm,event){var dup=getPrefix(cm);if(dup>1&&event.origin=="+input"){var one=event.text.join("\n"),txt="";for(var i=1;i<dup;++i)txt+=one;cm.replaceSelection(txt)}}function addPrefixMap(cm){cm.state.emacsPrefixMap=true;cm.addKeyMap(prefixMap);cm.on("keyHandled",maybeRemovePrefixMap);cm.on("inputRead",maybeRemovePrefixMap)}function maybeRemovePrefixMap(cm,arg){if(typeof arg=="string"&&(/^\d$/.test(arg)||arg=="Ctrl-U"))return;cm.removeKeyMap(prefixMap);cm.state.emacsPrefixMap=false;cm.off("keyHandled",maybeRemovePrefixMap);cm.off("inputRead",maybeRemovePrefixMap)}function setMark(cm){cm.setCursor(cm.getCursor());cm.setExtending(!cm.getExtending());cm.on("change",function(){cm.setExtending(false)})}function clearMark(cm){cm.setExtending(false);cm.setCursor(cm.getCursor())}function getInput(cm,msg,f){if(cm.openDialog)cm.openDialog(msg+': <input type="text" style="width: 10em"/>',f,{bottom:true});else f(prompt(msg,""))}function operateOnWord(cm,op){var start=cm.getCursor(),end=cm.findPosH(start,1,"word");cm.replaceRange(op(cm.getRange(start,end)),start,end);cm.setCursor(end)}function toEnclosingExpr(cm){var pos=cm.getCursor(),line=pos.line,ch=pos.ch;var stack=[];while(line>=cm.firstLine()){var text=cm.getLine(line);for(var i=ch==null?text.length:ch;i>0;){var ch=text.charAt(--i);if(ch==")")stack.push("(");else if(ch=="]")stack.push("[");else if(ch=="}")stack.push("{");else if(/[\(\{\[]/.test(ch)&&(!stack.length||stack.pop()!=ch))return cm.extendSelection(Pos(line,i))}--line;ch=null}}function quit(cm){cm.execCommand("clearSearch");clearMark(cm)}CodeMirror.emacs={kill:kill,killRegion:killRegion,repeated:repeated};var keyMap=CodeMirror.keyMap.emacs=CodeMirror.normalizeKeyMap({"Ctrl-W":function(cm){kill(cm,cm.getCursor("start"),cm.getCursor("end"))},"Ctrl-K":repeated(function(cm){var start=cm.getCursor(),end=cm.clipPos(Pos(start.line));var text=cm.getRange(start,end);if(!/\S/.test(text)){text+="\n";end=Pos(start.line+1,0)}kill(cm,start,end,true,text)}),"Alt-W":function(cm){addToRing(cm.getSelection());clearMark(cm)},"Ctrl-Y":function(cm){var start=cm.getCursor();cm.replaceRange(getFromRing(getPrefix(cm)),start,start,"paste");cm.setSelection(start,cm.getCursor())},"Alt-Y":function(cm){cm.replaceSelection(popFromRing(),"around","paste")},"Ctrl-Space":setMark,"Ctrl-Shift-2":setMark,"Ctrl-F":move(byChar,1),"Ctrl-B":move(byChar,-1),Right:move(byChar,1),Left:move(byChar,-1),"Ctrl-D":function(cm){killTo(cm,byChar,1)},Delete:function(cm){killRegion(cm)||killTo(cm,byChar,1)},"Ctrl-H":function(cm){killTo(cm,byChar,-1)},Backspace:function(cm){killRegion(cm)||killTo(cm,byChar,-1)},"Alt-F":move(byWord,1),"Alt-B":move(byWord,-1),"Alt-D":function(cm){killTo(cm,byWord,1)},"Alt-Backspace":function(cm){killTo(cm,byWord,-1)},"Ctrl-N":move(byLine,1),"Ctrl-P":move(byLine,-1),Down:move(byLine,1),Up:move(byLine,-1),"Ctrl-A":"goLineStart","Ctrl-E":"goLineEnd",End:"goLineEnd",Home:"goLineStart","Alt-V":move(byPage,-1),"Ctrl-V":move(byPage,1),PageUp:move(byPage,-1),PageDown:move(byPage,1),"Ctrl-Up":move(byParagraph,-1),"Ctrl-Down":move(byParagraph,1),"Alt-A":move(bySentence,-1),"Alt-E":move(bySentence,1),"Alt-K":function(cm){killTo(cm,bySentence,1)},"Ctrl-Alt-K":function(cm){killTo(cm,byExpr,1)},"Ctrl-Alt-Backspace":function(cm){killTo(cm,byExpr,-1)},"Ctrl-Alt-F":move(byExpr,1),"Ctrl-Alt-B":move(byExpr,-1),"Shift-Ctrl-Alt-2":function(cm){var cursor=cm.getCursor();cm.setSelection(findEnd(cm,cursor,byExpr,1),cursor)},"Ctrl-Alt-T":function(cm){var leftStart=byExpr(cm,cm.getCursor(),-1),leftEnd=byExpr(cm,leftStart,1);var rightEnd=byExpr(cm,leftEnd,1),rightStart=byExpr(cm,rightEnd,-1);cm.replaceRange(cm.getRange(rightStart,rightEnd)+cm.getRange(leftEnd,rightStart)+cm.getRange(leftStart,leftEnd),leftStart,rightEnd)},"Ctrl-Alt-U":repeated(toEnclosingExpr),"Alt-Space":function(cm){var pos=cm.getCursor(),from=pos.ch,to=pos.ch,text=cm.getLine(pos.line);while(from&&/\s/.test(text.charAt(from-1)))--from;while(to<text.length&&/\s/.test(text.charAt(to)))++to;cm.replaceRange(" ",Pos(pos.line,from),Pos(pos.line,to))},"Ctrl-O":repeated(function(cm){cm.replaceSelection("\n","start")}),"Ctrl-T":repeated(function(cm){cm.execCommand("transposeChars")}),"Alt-C":repeated(function(cm){operateOnWord(cm,function(w){var letter=w.search(/\w/);if(letter==-1)return w;return w.slice(0,letter)+w.charAt(letter).toUpperCase()+w.slice(letter+1).toLowerCase()})}),"Alt-U":repeated(function(cm){operateOnWord(cm,function(w){return w.toUpperCase()})}),"Alt-L":repeated(function(cm){operateOnWord(cm,function(w){return w.toLowerCase()})}),"Alt-;":"toggleComment","Ctrl-/":repeated("undo"),"Shift-Ctrl--":repeated("undo"),"Ctrl-Z":repeated("undo"),"Cmd-Z":repeated("undo"),"Shift-Alt-,":"goDocStart","Shift-Alt-.":"goDocEnd","Ctrl-S":"findNext","Ctrl-R":"findPrev","Ctrl-G":quit,"Shift-Alt-5":"replace","Alt-/":"autocomplete",Enter:"newlineAndIndent","Ctrl-J":repeated(function(cm){cm.replaceSelection("\n","end")}),Tab:"indentAuto","Alt-G G":function(cm){var prefix=getPrefix(cm,true);if(prefix!=null&&prefix>0)return cm.setCursor(prefix-1);getInput(cm,"Goto line",function(str){var num;if(str&&!isNaN(num=Number(str))&&num==(num|0)&&num>0)cm.setCursor(num-1)})},"Ctrl-X Tab":function(cm){cm.indentSelection(getPrefix(cm,true)||cm.getOption("indentUnit"))},"Ctrl-X Ctrl-X":function(cm){cm.setSelection(cm.getCursor("head"),cm.getCursor("anchor"))},"Ctrl-X Ctrl-S":"save","Ctrl-X Ctrl-W":"save","Ctrl-X S":"saveAll","Ctrl-X F":"open","Ctrl-X U":repeated("undo"),"Ctrl-X K":"close","Ctrl-X Delete":function(cm){kill(cm,cm.getCursor(),bySentence(cm,cm.getCursor(),1),true)},"Ctrl-X H":"selectAll","Ctrl-Q Tab":repeated("insertTab"),"Ctrl-U":addPrefixMap});var prefixMap={"Ctrl-G":clearPrefix};function regPrefix(d){prefixMap[d]=function(cm){addPrefix(cm,d)};keyMap["Ctrl-"+d]=function(cm){addPrefix(cm,d)};prefixPreservingKeys["Ctrl-"+d]=true}for(var i=0;i<10;++i)regPrefix(String(i));regPrefix("-")});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../lib/codemirror"),require("../addon/search/searchcursor"),require("../addon/edit/matchbrackets"));else if(typeof define=="function"&&define.amd)define(["../lib/codemirror","../addon/search/searchcursor","../addon/edit/matchbrackets"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var map=CodeMirror.keyMap.sublime={fallthrough:"default"};var cmds=CodeMirror.commands;var Pos=CodeMirror.Pos;var mac=CodeMirror.keyMap["default"]==CodeMirror.keyMap.macDefault;var ctrl=mac?"Cmd-":"Ctrl-";function findPosSubword(doc,start,dir){if(dir<0&&start.ch==0)return doc.clipPos(Pos(start.line-1));var line=doc.getLine(start.line);if(dir>0&&start.ch>=line.length)return doc.clipPos(Pos(start.line+1,0));var state="start",type;for(var pos=start.ch,e=dir<0?0:line.length,i=0;pos!=e;pos+=dir,i++){var next=line.charAt(dir<0?pos-1:pos);var cat=next!="_"&&CodeMirror.isWordChar(next)?"w":"o";if(cat=="w"&&next.toUpperCase()==next)cat="W";if(state=="start"){if(cat!="o"){state="in";type=cat}}else if(state=="in"){if(type!=cat){if(type=="w"&&cat=="W"&&dir<0)pos--;if(type=="W"&&cat=="w"&&dir>0){type="w";continue}break}}}return Pos(start.line,pos)}function moveSubword(cm,dir){cm.extendSelectionsBy(function(range){if(cm.display.shift||cm.doc.extend||range.empty())return findPosSubword(cm.doc,range.head,dir);else return dir<0?range.from():range.to()})}var goSubwordCombo=mac?"Ctrl-":"Alt-";cmds[map[goSubwordCombo+"Left"]="goSubwordLeft"]=function(cm){moveSubword(cm,-1)};cmds[map[goSubwordCombo+"Right"]="goSubwordRight"]=function(cm){moveSubword(cm,1)};if(mac)map["Cmd-Left"]="goLineStartSmart";var scrollLineCombo=mac?"Ctrl-Alt-":"Ctrl-";cmds[map[scrollLineCombo+"Up"]="scrollLineUp"]=function(cm){var info=cm.getScrollInfo();if(!cm.somethingSelected()){var visibleBottomLine=cm.lineAtHeight(info.top+info.clientHeight,"local");if(cm.getCursor().line>=visibleBottomLine)cm.execCommand("goLineUp")}cm.scrollTo(null,info.top-cm.defaultTextHeight())};cmds[map[scrollLineCombo+"Down"]="scrollLineDown"]=function(cm){var info=cm.getScrollInfo();if(!cm.somethingSelected()){var visibleTopLine=cm.lineAtHeight(info.top,"local")+1;if(cm.getCursor().line<=visibleTopLine)cm.execCommand("goLineDown")}cm.scrollTo(null,info.top+cm.defaultTextHeight())};cmds[map["Shift-"+ctrl+"L"]="splitSelectionByLine"]=function(cm){var ranges=cm.listSelections(),lineRanges=[];for(var i=0;i<ranges.length;i++){var from=ranges[i].from(),to=ranges[i].to();for(var line=from.line;line<=to.line;++line)if(!(to.line>from.line&&line==to.line&&to.ch==0))lineRanges.push({anchor:line==from.line?from:Pos(line,0),head:line==to.line?to:Pos(line)})}cm.setSelections(lineRanges,0)};map["Shift-Tab"]="indentLess";cmds[map["Esc"]="singleSelectionTop"]=function(cm){var range=cm.listSelections()[0];cm.setSelection(range.anchor,range.head,{scroll:false})};cmds[map[ctrl+"L"]="selectLine"]=function(cm){var ranges=cm.listSelections(),extended=[];for(var i=0;i<ranges.length;i++){var range=ranges[i];extended.push({anchor:Pos(range.from().line,0),head:Pos(range.to().line+1,0)})}cm.setSelections(extended)};map["Shift-Ctrl-K"]="deleteLine";function insertLine(cm,above){if(cm.isReadOnly())return CodeMirror.Pass;cm.operation(function(){var len=cm.listSelections().length,newSelection=[],last=-1;for(var i=0;i<len;i++){var head=cm.listSelections()[i].head;if(head.line<=last)continue;var at=Pos(head.line+(above?0:1),0);cm.replaceRange("\n",at,null,"+insertLine");cm.indentLine(at.line,null,true);newSelection.push({head:at,anchor:at});last=head.line+1}cm.setSelections(newSelection)});cm.execCommand("indentAuto")}cmds[map[ctrl+"Enter"]="insertLineAfter"]=function(cm){return insertLine(cm,false)};cmds[map["Shift-"+ctrl+"Enter"]="insertLineBefore"]=function(cm){return insertLine(cm,true)};function wordAt(cm,pos){var start=pos.ch,end=start,line=cm.getLine(pos.line);while(start&&CodeMirror.isWordChar(line.charAt(start-1)))--start;while(end<line.length&&CodeMirror.isWordChar(line.charAt(end)))++end;return{from:Pos(pos.line,start),to:Pos(pos.line,end),word:line.slice(start,end)}}cmds[map[ctrl+"D"]="selectNextOccurrence"]=function(cm){var from=cm.getCursor("from"),to=cm.getCursor("to");var fullWord=cm.state.sublimeFindFullWord==cm.doc.sel;if(CodeMirror.cmpPos(from,to)==0){var word=wordAt(cm,from);if(!word.word)return;cm.setSelection(word.from,word.to);fullWord=true}else{var text=cm.getRange(from,to);var query=fullWord?new RegExp("\\b"+text+"\\b"):text;var cur=cm.getSearchCursor(query,to);var found=cur.findNext();if(!found){cur=cm.getSearchCursor(query,Pos(cm.firstLine(),0));found=cur.findNext()}if(!found||isSelectedRange(cm.listSelections(),cur.from(),cur.to()))return CodeMirror.Pass;cm.addSelection(cur.from(),cur.to())}if(fullWord)cm.state.sublimeFindFullWord=cm.doc.sel};function isSelectedRange(ranges,from,to){for(var i=0;i<ranges.length;i++)if(ranges[i].from()==from&&ranges[i].to()==to)return true;return false}var mirror="(){}[]";function selectBetweenBrackets(cm){var ranges=cm.listSelections(),newRanges=[];for(var i=0;i<ranges.length;i++){var range=ranges[i],pos=range.head,opening=cm.scanForBracket(pos,-1);if(!opening)return false;for(;;){var closing=cm.scanForBracket(pos,1);if(!closing)return false;if(closing.ch==mirror.charAt(mirror.indexOf(opening.ch)+1)){newRanges.push({anchor:Pos(opening.pos.line,opening.pos.ch+1),head:closing.pos});break}pos=Pos(closing.pos.line,closing.pos.ch+1)}}cm.setSelections(newRanges);return true}cmds[map["Shift-"+ctrl+"Space"]="selectScope"]=function(cm){selectBetweenBrackets(cm)||cm.execCommand("selectAll")};cmds[map["Shift-"+ctrl+"M"]="selectBetweenBrackets"]=function(cm){if(!selectBetweenBrackets(cm))return CodeMirror.Pass};cmds[map[ctrl+"M"]="goToBracket"]=function(cm){cm.extendSelectionsBy(function(range){var next=cm.scanForBracket(range.head,1);if(next&&CodeMirror.cmpPos(next.pos,range.head)!=0)return next.pos;var prev=cm.scanForBracket(range.head,-1);return prev&&Pos(prev.pos.line,prev.pos.ch+1)||range.head})};var swapLineCombo=mac?"Cmd-Ctrl-":"Shift-Ctrl-";cmds[map[swapLineCombo+"Up"]="swapLineUp"]=function(cm){if(cm.isReadOnly())return CodeMirror.Pass;var ranges=cm.listSelections(),linesToMove=[],at=cm.firstLine()-1,newSels=[];for(var i=0;i<ranges.length;i++){var range=ranges[i],from=range.from().line-1,to=range.to().line;newSels.push({anchor:Pos(range.anchor.line-1,range.anchor.ch),head:Pos(range.head.line-1,range.head.ch)});if(range.to().ch==0&&!range.empty())--to;if(from>at)linesToMove.push(from,to);else if(linesToMove.length)linesToMove[linesToMove.length-1]=to;at=to}cm.operation(function(){for(var i=0;i<linesToMove.length;i+=2){var from=linesToMove[i],to=linesToMove[i+1];var line=cm.getLine(from);cm.replaceRange("",Pos(from,0),Pos(from+1,0),"+swapLine");if(to>cm.lastLine())cm.replaceRange("\n"+line,Pos(cm.lastLine()),null,"+swapLine");else cm.replaceRange(line+"\n",Pos(to,0),null,"+swapLine")}cm.setSelections(newSels);cm.scrollIntoView()})};cmds[map[swapLineCombo+"Down"]="swapLineDown"]=function(cm){if(cm.isReadOnly())return CodeMirror.Pass;var ranges=cm.listSelections(),linesToMove=[],at=cm.lastLine()+1;for(var i=ranges.length-1;i>=0;i--){var range=ranges[i],from=range.to().line+1,to=range.from().line;if(range.to().ch==0&&!range.empty())from--;if(from<at)linesToMove.push(from,to);else if(linesToMove.length)linesToMove[linesToMove.length-1]=to;at=to}cm.operation(function(){for(var i=linesToMove.length-2;i>=0;i-=2){var from=linesToMove[i],to=linesToMove[i+1];var line=cm.getLine(from);if(from==cm.lastLine())cm.replaceRange("",Pos(from-1),Pos(from),"+swapLine");else cm.replaceRange("",Pos(from,0),Pos(from+1,0),"+swapLine");cm.replaceRange(line+"\n",Pos(to,0),null,"+swapLine")}cm.scrollIntoView()})};cmds[map[ctrl+"/"]="toggleCommentIndented"]=function(cm){cm.toggleComment({indent:true})};cmds[map[ctrl+"J"]="joinLines"]=function(cm){var ranges=cm.listSelections(),joined=[];for(var i=0;i<ranges.length;i++){var range=ranges[i],from=range.from();var start=from.line,end=range.to().line;while(i<ranges.length-1&&ranges[i+1].from().line==end)end=ranges[++i].to().line;joined.push({start:start,end:end,anchor:!range.empty()&&from})}cm.operation(function(){var offset=0,ranges=[];for(var i=0;i<joined.length;i++){var obj=joined[i];var anchor=obj.anchor&&Pos(obj.anchor.line-offset,obj.anchor.ch),head;for(var line=obj.start;line<=obj.end;line++){var actual=line-offset;if(line==obj.end)head=Pos(actual,cm.getLine(actual).length+1);if(actual<cm.lastLine()){cm.replaceRange(" ",Pos(actual),Pos(actual+1,/^\s*/.exec(cm.getLine(actual+1))[0].length));++offset}}ranges.push({anchor:anchor||head,head:head})}cm.setSelections(ranges,0)})};cmds[map["Shift-"+ctrl+"D"]="duplicateLine"]=function(cm){cm.operation(function(){var rangeCount=cm.listSelections().length;for(var i=0;i<rangeCount;i++){var range=cm.listSelections()[i];if(range.empty())cm.replaceRange(cm.getLine(range.head.line)+"\n",Pos(range.head.line,0));else cm.replaceRange(cm.getRange(range.from(),range.to()),range.from())}cm.scrollIntoView()})};if(!mac)map[ctrl+"T"]="transposeChars";function sortLines(cm,caseSensitive){if(cm.isReadOnly())return CodeMirror.Pass;var ranges=cm.listSelections(),toSort=[],selected;for(var i=0;i<ranges.length;i++){var range=ranges[i];if(range.empty())continue;var from=range.from().line,to=range.to().line;while(i<ranges.length-1&&ranges[i+1].from().line==to)to=ranges[++i].to().line;if(!ranges[i].to().ch)to--;toSort.push(from,to)}if(toSort.length)selected=true;else toSort.push(cm.firstLine(),cm.lastLine());cm.operation(function(){var ranges=[];for(var i=0;i<toSort.length;i+=2){var from=toSort[i],to=toSort[i+1];var start=Pos(from,0),end=Pos(to);var lines=cm.getRange(start,end,false);if(caseSensitive)lines.sort();else lines.sort(function(a,b){var au=a.toUpperCase(),bu=b.toUpperCase();if(au!=bu){a=au;b=bu}return a<b?-1:a==b?0:1});cm.replaceRange(lines,start,end);if(selected)ranges.push({anchor:start,head:Pos(to+1,0)})}if(selected)cm.setSelections(ranges,0)})}cmds[map["F9"]="sortLines"]=function(cm){sortLines(cm,true)};cmds[map[ctrl+"F9"]="sortLinesInsensitive"]=function(cm){sortLines(cm,false)};cmds[map["F2"]="nextBookmark"]=function(cm){var marks=cm.state.sublimeBookmarks;if(marks)while(marks.length){var current=marks.shift();var found=current.find();if(found){marks.push(current);return cm.setSelection(found.from,found.to)}}};cmds[map["Shift-F2"]="prevBookmark"]=function(cm){var marks=cm.state.sublimeBookmarks;if(marks)while(marks.length){marks.unshift(marks.pop());var found=marks[marks.length-1].find();if(!found)marks.pop();else return cm.setSelection(found.from,found.to)}};cmds[map[ctrl+"F2"]="toggleBookmark"]=function(cm){var ranges=cm.listSelections();var marks=cm.state.sublimeBookmarks||(cm.state.sublimeBookmarks=[]);for(var i=0;i<ranges.length;i++){var from=ranges[i].from(),to=ranges[i].to();var found=cm.findMarks(from,to);for(var j=0;j<found.length;j++){if(found[j].sublimeBookmark){found[j].clear();for(var k=0;k<marks.length;k++)if(marks[k]==found[j])marks.splice(k--,1);break}}if(j==found.length)marks.push(cm.markText(from,to,{sublimeBookmark:true,clearWhenEmpty:false}))}};cmds[map["Shift-"+ctrl+"F2"]="clearBookmarks"]=function(cm){var marks=cm.state.sublimeBookmarks;if(marks)for(var i=0;i<marks.length;i++)marks[i].clear();marks.length=0};cmds[map["Alt-F2"]="selectBookmarks"]=function(cm){var marks=cm.state.sublimeBookmarks,ranges=[];if(marks)for(var i=0;i<marks.length;i++){var found=marks[i].find();if(!found)marks.splice(i--,0);else ranges.push({anchor:found.from,head:found.to})}if(ranges.length)cm.setSelections(ranges,0)};map["Alt-Q"]="wrapLines";var cK=ctrl+"K ";function modifyWordOrSelection(cm,mod){cm.operation(function(){var ranges=cm.listSelections(),indices=[],replacements=[];for(var i=0;i<ranges.length;i++){var range=ranges[i];if(range.empty()){indices.push(i);replacements.push("")}else replacements.push(mod(cm.getRange(range.from(),range.to())))}cm.replaceSelections(replacements,"around","case");for(var i=indices.length-1,at;i>=0;i--){var range=ranges[indices[i]];if(at&&CodeMirror.cmpPos(range.head,at)>0)continue;var word=wordAt(cm,range.head);at=word.from;cm.replaceRange(mod(word.word),word.from,word.to)}})}map[cK+ctrl+"Backspace"]="delLineLeft";cmds[map["Backspace"]="smartBackspace"]=function(cm){if(cm.somethingSelected())return CodeMirror.Pass;cm.operation(function(){var cursors=cm.listSelections();var indentUnit=cm.getOption("indentUnit");for(var i=cursors.length-1;i>=0;i--){var cursor=cursors[i].head;var toStartOfLine=cm.getRange({line:cursor.line,ch:0},cursor);var column=CodeMirror.countColumn(toStartOfLine,null,cm.getOption("tabSize"));var deletePos=cm.findPosH(cursor,-1,"char",false);if(toStartOfLine&&!/\S/.test(toStartOfLine)&&column%indentUnit==0){var prevIndent=new Pos(cursor.line,CodeMirror.findColumn(toStartOfLine,column-indentUnit,indentUnit));if(prevIndent.ch!=cursor.ch)deletePos=prevIndent}cm.replaceRange("",deletePos,cursor,"+delete")}})};cmds[map[cK+ctrl+"K"]="delLineRight"]=function(cm){cm.operation(function(){var ranges=cm.listSelections();for(var i=ranges.length-1;i>=0;i--)cm.replaceRange("",ranges[i].anchor,Pos(ranges[i].to().line),"+delete");cm.scrollIntoView()})};cmds[map[cK+ctrl+"U"]="upcaseAtCursor"]=function(cm){modifyWordOrSelection(cm,function(str){return str.toUpperCase()})};cmds[map[cK+ctrl+"L"]="downcaseAtCursor"]=function(cm){modifyWordOrSelection(cm,function(str){return str.toLowerCase()})};cmds[map[cK+ctrl+"Space"]="setSublimeMark"]=function(cm){if(cm.state.sublimeMark)cm.state.sublimeMark.clear();cm.state.sublimeMark=cm.setBookmark(cm.getCursor())};cmds[map[cK+ctrl+"A"]="selectToSublimeMark"]=function(cm){var found=cm.state.sublimeMark&&cm.state.sublimeMark.find();if(found)cm.setSelection(cm.getCursor(),found)};cmds[map[cK+ctrl+"W"]="deleteToSublimeMark"]=function(cm){var found=cm.state.sublimeMark&&cm.state.sublimeMark.find();if(found){var from=cm.getCursor(),to=found;if(CodeMirror.cmpPos(from,to)>0){var tmp=to;to=from;from=tmp}cm.state.sublimeKilled=cm.getRange(from,to);cm.replaceRange("",from,to)}};cmds[map[cK+ctrl+"X"]="swapWithSublimeMark"]=function(cm){var found=cm.state.sublimeMark&&cm.state.sublimeMark.find();if(found){cm.state.sublimeMark.clear();cm.state.sublimeMark=cm.setBookmark(cm.getCursor());cm.setCursor(found)}};cmds[map[cK+ctrl+"Y"]="sublimeYank"]=function(cm){if(cm.state.sublimeKilled!=null)cm.replaceSelection(cm.state.sublimeKilled,null,"paste")};map[cK+ctrl+"G"]="clearBookmarks";cmds[map[cK+ctrl+"C"]="showInCenter"]=function(cm){var pos=cm.cursorCoords(null,"local");cm.scrollTo(null,(pos.top+pos.bottom)/2-cm.getScrollInfo().clientHeight/2)};var selectLinesCombo=mac?"Ctrl-Shift-":"Ctrl-Alt-";cmds[map[selectLinesCombo+"Up"]="selectLinesUpward"]=function(cm){cm.operation(function(){var ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){var range=ranges[i];if(range.head.line>cm.firstLine())cm.addSelection(Pos(range.head.line-1,range.head.ch))}})};cmds[map[selectLinesCombo+"Down"]="selectLinesDownward"]=function(cm){cm.operation(function(){var ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){var range=ranges[i];if(range.head.line<cm.lastLine())cm.addSelection(Pos(range.head.line+1,range.head.ch))}})};function getTarget(cm){var from=cm.getCursor("from"),to=cm.getCursor("to");if(CodeMirror.cmpPos(from,to)==0){var word=wordAt(cm,from);if(!word.word)return;from=word.from;to=word.to}return{from:from,to:to,query:cm.getRange(from,to),word:word}}function findAndGoTo(cm,forward){var target=getTarget(cm);if(!target)return;var query=target.query;var cur=cm.getSearchCursor(query,forward?target.to:target.from);if(forward?cur.findNext():cur.findPrevious()){cm.setSelection(cur.from(),cur.to())}else{cur=cm.getSearchCursor(query,forward?Pos(cm.firstLine(),0):cm.clipPos(Pos(cm.lastLine())));if(forward?cur.findNext():cur.findPrevious())cm.setSelection(cur.from(),cur.to());else if(target.word)cm.setSelection(target.from,target.to)}}cmds[map[ctrl+"F3"]="findUnder"]=function(cm){findAndGoTo(cm,true)};cmds[map["Shift-"+ctrl+"F3"]="findUnderPrevious"]=function(cm){findAndGoTo(cm,false)};cmds[map["Alt-F3"]="findAllUnder"]=function(cm){var target=getTarget(cm);if(!target)return;var cur=cm.getSearchCursor(target.query);var matches=[];var primaryIndex=-1;while(cur.findNext()){matches.push({anchor:cur.from(),head:cur.to()});if(cur.from().line<=target.from.line&&cur.from().ch<=target.from.ch)primaryIndex++}cm.setSelections(matches,primaryIndex)};map["Shift-"+ctrl+"["]="fold";map["Shift-"+ctrl+"]"]="unfold";map[cK+ctrl+"0"]=map[cK+ctrl+"J"]="unfoldAll";map[ctrl+"I"]="findIncremental";map["Shift-"+ctrl+"I"]="findIncrementalReverse";map[ctrl+"H"]="replace";map["F3"]="findNext";map["Shift-F3"]="findPrev";CodeMirror.normalizeKeyMap(map)});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../lib/codemirror"),require("../addon/search/searchcursor"),require("../addon/dialog/dialog"),require("../addon/edit/matchbrackets.js"));else if(typeof define=="function"&&define.amd)define(["../lib/codemirror","../addon/search/searchcursor","../addon/dialog/dialog","../addon/edit/matchbrackets"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var defaultKeymap=[{keys:"<Left>",type:"keyToKey",toKeys:"h"},{keys:"<Right>",type:"keyToKey",toKeys:"l"},{keys:"<Up>",type:"keyToKey",toKeys:"k"},{keys:"<Down>",type:"keyToKey",toKeys:"j"},{keys:"<Space>",type:"keyToKey",toKeys:"l"},{keys:"<BS>",type:"keyToKey",toKeys:"h",context:"normal"},{keys:"<C-Space>",type:"keyToKey",toKeys:"W"},{keys:"<C-BS>",type:"keyToKey",toKeys:"B",context:"normal"},{keys:"<S-Space>",type:"keyToKey",toKeys:"w"},{keys:"<S-BS>",type:"keyToKey",toKeys:"b",context:"normal"},{keys:"<C-n>",type:"keyToKey",toKeys:"j"},{keys:"<C-p>",type:"keyToKey",toKeys:"k"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"s",type:"keyToKey",toKeys:"cl",context:"normal"},{keys:"s",type:"keyToKey",toKeys:"c",context:"visual"},{keys:"S",type:"keyToKey",toKeys:"cc",context:"normal"},{keys:"S",type:"keyToKey",toKeys:"VdO",context:"visual"},{keys:"<Home>",type:"keyToKey",toKeys:"0"},{keys:"<End>",type:"keyToKey",toKeys:"$"},{keys:"<PageUp>",type:"keyToKey",toKeys:"<C-b>"},{keys:"<PageDown>",type:"keyToKey",toKeys:"<C-f>"},{keys:"<CR>",type:"keyToKey",toKeys:"j^",context:"normal"},{keys:"<Ins>",type:"action",action:"toggleOverwrite",context:"insert"},{keys:"H",type:"motion",motion:"moveToTopLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"M",type:"motion",motion:"moveToMiddleLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"L",type:"motion",motion:"moveToBottomLine",motionArgs:{linewise:true,toJumplist:true}},{keys:"h",type:"motion",motion:"moveByCharacters",motionArgs:{forward:false}},{keys:"l",type:"motion",motion:"moveByCharacters",motionArgs:{forward:true}},{keys:"j",type:"motion",motion:"moveByLines",motionArgs:{forward:true,linewise:true}},{keys:"k",type:"motion",motion:"moveByLines",motionArgs:{forward:false,linewise:true}},{keys:"gj",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:true}},{keys:"gk",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:false}},{keys:"w",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:false}},{keys:"W",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:false,bigWord:true}},{keys:"e",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:true,inclusive:true}},{keys:"E",type:"motion",motion:"moveByWords",motionArgs:{forward:true,wordEnd:true,bigWord:true,inclusive:true}},{keys:"b",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false}},{keys:"B",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false,bigWord:true}},{keys:"ge",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:true,inclusive:true}},{keys:"gE",type:"motion",motion:"moveByWords",motionArgs:{forward:false,wordEnd:true,bigWord:true,inclusive:true}},{keys:"{",type:"motion",motion:"moveByParagraph",motionArgs:{forward:false,toJumplist:true}},{keys:"}",type:"motion",motion:"moveByParagraph",motionArgs:{forward:true,toJumplist:true}},{keys:"<C-f>",type:"motion",motion:"moveByPage",motionArgs:{forward:true}},{keys:"<C-b>",type:"motion",motion:"moveByPage",motionArgs:{forward:false}},{keys:"<C-d>",type:"motion",motion:"moveByScroll",motionArgs:{forward:true,explicitRepeat:true}},{keys:"<C-u>",type:"motion",motion:"moveByScroll",motionArgs:{forward:false,explicitRepeat:true}},{keys:"gg",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:false,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:"G",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:true,explicitRepeat:true,linewise:true,toJumplist:true}},{keys:"0",type:"motion",motion:"moveToStartOfLine"},{keys:"^",type:"motion",motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"+",type:"motion",motion:"moveByLines",motionArgs:{forward:true,toFirstChar:true}},{keys:"-",type:"motion",motion:"moveByLines",motionArgs:{forward:false,toFirstChar:true}},{keys:"_",type:"motion",motion:"moveByLines",motionArgs:{forward:true,toFirstChar:true,repeatOffset:-1}},{keys:"$",type:"motion",motion:"moveToEol",motionArgs:{inclusive:true}},{keys:"%",type:"motion",motion:"moveToMatchedSymbol",motionArgs:{inclusive:true,toJumplist:true}},{keys:"f<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:true,inclusive:true}},{keys:"F<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:false}},{keys:"t<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:true,inclusive:true}},{keys:"T<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:false}},{keys:";",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:true}},{keys:",",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:false}},{keys:"'<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:true,linewise:true}},{keys:"`<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:true}},{keys:"]`",type:"motion",motion:"jumpToMark",motionArgs:{forward:true}},{keys:"[`",type:"motion",motion:"jumpToMark",motionArgs:{forward:false}},{keys:"]'",type:"motion",motion:"jumpToMark",motionArgs:{forward:true,linewise:true}},{keys:"['",type:"motion",motion:"jumpToMark",motionArgs:{forward:false,linewise:true}},{keys:"]p",type:"action",action:"paste",isEdit:true,actionArgs:{after:true,isEdit:true,matchIndent:true}},{keys:"[p",type:"action",action:"paste",isEdit:true,actionArgs:{after:false,isEdit:true,matchIndent:true}},{keys:"]<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:true,toJumplist:true}},{keys:"[<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:false,toJumplist:true}},{keys:"|",type:"motion",motion:"moveToColumn"},{keys:"o",type:"motion",motion:"moveToOtherHighlightedEnd",context:"visual"},{keys:"O",type:"motion",motion:"moveToOtherHighlightedEnd",motionArgs:{sameLine:true},context:"visual"},{keys:"d",type:"operator",operator:"delete"},{keys:"y",type:"operator",operator:"yank"},{keys:"c",type:"operator",operator:"change"},{keys:">",type:"operator",operator:"indent",operatorArgs:{indentRight:true}},{keys:"<",type:"operator",operator:"indent",operatorArgs:{indentRight:false}},{keys:"g~",type:"operator",operator:"changeCase"},{keys:"gu",type:"operator",operator:"changeCase",operatorArgs:{toLower:true},isEdit:true},{keys:"gU",type:"operator",operator:"changeCase",operatorArgs:{toLower:false},isEdit:true},{keys:"n",type:"motion",motion:"findNext",motionArgs:{forward:true,toJumplist:true}},{keys:"N",type:"motion",motion:"findNext",motionArgs:{forward:false,toJumplist:true}},{keys:"x",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:true},operatorMotionArgs:{visualLine:false}},{keys:"X",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:false},operatorMotionArgs:{visualLine:true}},{keys:"D",type:"operatorMotion",operator:"delete",motion:"moveToEol",motionArgs:{inclusive:true},context:"normal"},{keys:"D",type:"operator",operator:"delete",operatorArgs:{linewise:true},context:"visual"},{keys:"Y",type:"operatorMotion",operator:"yank",motion:"expandToLine",motionArgs:{linewise:true},context:"normal"},{keys:"Y",type:"operator",operator:"yank",operatorArgs:{linewise:true},context:"visual"},{keys:"C",type:"operatorMotion",operator:"change",motion:"moveToEol",motionArgs:{inclusive:true},context:"normal"},{keys:"C",type:"operator",operator:"change",operatorArgs:{linewise:true},context:"visual"},{keys:"~",type:"operatorMotion",operator:"changeCase",motion:"moveByCharacters",motionArgs:{forward:true},operatorArgs:{shouldMoveCursor:true},context:"normal"},{keys:"~",type:"operator",operator:"changeCase",context:"visual"},{keys:"<C-w>",type:"operatorMotion",operator:"delete",motion:"moveByWords",motionArgs:{forward:false,wordEnd:false},context:"insert"},{keys:"<C-i>",type:"action",action:"jumpListWalk",actionArgs:{forward:true}},{keys:"<C-o>",type:"action",action:"jumpListWalk",actionArgs:{forward:false}},{keys:"<C-e>",type:"action",action:"scroll",actionArgs:{forward:true,linewise:true}},{keys:"<C-y>",type:"action",action:"scroll",actionArgs:{forward:false,linewise:true}},{keys:"a",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"charAfter"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"eol"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"endOfSelectedArea"},context:"visual"},{keys:"i",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"inplace"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"firstNonBlank"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{insertAt:"startOfSelectedArea"},context:"visual"},{keys:"o",type:"action",action:"newLineAndEnterInsertMode",isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:true},context:"normal"},{keys:"O",type:"action",action:"newLineAndEnterInsertMode",isEdit:true,interlaceInsertRepeat:true,actionArgs:{after:false},context:"normal"},{keys:"v",type:"action",action:"toggleVisualMode"},{keys:"V",type:"action",action:"toggleVisualMode",actionArgs:{linewise:true}},{keys:"<C-v>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:true}},{keys:"<C-q>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:true}},{keys:"gv",type:"action",action:"reselectLastSelection"},{keys:"J",type:"action",action:"joinLines",isEdit:true},{keys:"p",type:"action",action:"paste",isEdit:true,actionArgs:{after:true,isEdit:true}},{keys:"P",type:"action",action:"paste",isEdit:true,actionArgs:{after:false,isEdit:true}},{keys:"r<character>",type:"action",action:"replace",isEdit:true},{keys:"@<character>",type:"action",action:"replayMacro"},{keys:"q<character>",type:"action",action:"enterMacroRecordMode"},{keys:"R",type:"action",action:"enterInsertMode",isEdit:true,actionArgs:{replace:true}},{keys:"u",type:"action",action:"undo",context:"normal"},{keys:"u",type:"operator",operator:"changeCase",operatorArgs:{toLower:true},context:"visual",isEdit:true},{keys:"U",type:"operator",operator:"changeCase",operatorArgs:{toLower:false},context:"visual",isEdit:true},{keys:"<C-r>",type:"action",action:"redo"},{keys:"m<character>",type:"action",action:"setMark"},{keys:'"<character>',type:"action",action:"setRegister"},{keys:"zz",type:"action",action:"scrollToCursor",actionArgs:{position:"center"}},{keys:"z.",type:"action",action:"scrollToCursor",actionArgs:{position:"center"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"zt",type:"action",action:"scrollToCursor",actionArgs:{position:"top"}},{keys:"z<CR>",type:"action",action:"scrollToCursor",actionArgs:{position:"top"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"z-",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"}},{keys:"zb",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:".",type:"action",action:"repeatLastEdit"},{keys:"<C-a>",type:"action",action:"incrementNumberToken",isEdit:true,actionArgs:{increase:true,backtrack:false}},{keys:"<C-x>",type:"action",action:"incrementNumberToken",isEdit:true,actionArgs:{increase:false,backtrack:false}},{keys:"<C-t>",type:"action",action:"indent",actionArgs:{indentRight:true},context:"insert"},{keys:"<C-d>",type:"action",action:"indent",actionArgs:{indentRight:false},context:"insert"},{keys:"a<character>",type:"motion",motion:"textObjectManipulation"},{keys:"i<character>",type:"motion",motion:"textObjectManipulation",motionArgs:{textObjectInner:true}},{keys:"/",type:"search",searchArgs:{forward:true,querySrc:"prompt",toJumplist:true}},{keys:"?",type:"search",searchArgs:{forward:false,querySrc:"prompt",toJumplist:true}},{keys:"*",type:"search",searchArgs:{forward:true,querySrc:"wordUnderCursor",wholeWordOnly:true,toJumplist:true}},{keys:"#",type:"search",searchArgs:{forward:false,querySrc:"wordUnderCursor",wholeWordOnly:true,toJumplist:true}},{keys:"g*",type:"search",searchArgs:{forward:true,querySrc:"wordUnderCursor",toJumplist:true}},{keys:"g#",type:"search",searchArgs:{forward:false,querySrc:"wordUnderCursor",toJumplist:true}},{keys:":",type:"ex"}];var defaultExCommandMap=[{name:"colorscheme",shortName:"colo"},{name:"map"},{name:"imap",shortName:"im"},{name:"nmap",shortName:"nm"},{name:"vmap",shortName:"vm"},{name:"unmap"},{name:"write",shortName:"w"},{name:"undo",shortName:"u"},{name:"redo",shortName:"red"},{name:"set",shortName:"se"},{name:"set",shortName:"se"},{name:"setlocal",shortName:"setl"},{name:"setglobal",shortName:"setg"},{name:"sort",shortName:"sor"},{name:"substitute",shortName:"s",possiblyAsync:true},{name:"nohlsearch",shortName:"noh"},{name:"yank",shortName:"y"},{name:"delmarks",shortName:"delm"},{name:"registers",shortName:"reg",excludeFromCommandHistory:true},{name:"global",shortName:"g"}];var Pos=CodeMirror.Pos;var Vim=function(){function enterVimMode(cm){cm.setOption("disableInput",true);cm.setOption("showCursorWhenSelecting",false);CodeMirror.signal(cm,"vim-mode-change",{mode:"normal"});cm.on("cursorActivity",onCursorActivity);maybeInitVimState(cm);CodeMirror.on(cm.getInputField(),"paste",getOnPasteFn(cm))}function leaveVimMode(cm){cm.setOption("disableInput",false);cm.off("cursorActivity",onCursorActivity);CodeMirror.off(cm.getInputField(),"paste",getOnPasteFn(cm));cm.state.vim=null}function detachVimMap(cm,next){if(this==CodeMirror.keyMap.vim)CodeMirror.rmClass(cm.getWrapperElement(),"cm-fat-cursor");if(!next||next.attach!=attachVimMap)leaveVimMode(cm)}function attachVimMap(cm,prev){if(this==CodeMirror.keyMap.vim)CodeMirror.addClass(cm.getWrapperElement(),"cm-fat-cursor");if(!prev||prev.attach!=attachVimMap)enterVimMode(cm)}CodeMirror.defineOption("vimMode",false,function(cm,val,prev){if(val&&cm.getOption("keyMap")!="vim")cm.setOption("keyMap","vim");else if(!val&&prev!=CodeMirror.Init&&/^vim/.test(cm.getOption("keyMap")))cm.setOption("keyMap","default")});function cmKey(key,cm){if(!cm){return undefined}if(this[key]){return this[key]}var vimKey=cmKeyToVimKey(key);if(!vimKey){return false}var cmd=CodeMirror.Vim.findKey(cm,vimKey);if(typeof cmd=="function"){CodeMirror.signal(cm,"vim-keypress",vimKey)}return cmd}var modifiers={Shift:"S",Ctrl:"C",Alt:"A",Cmd:"D",Mod:"A"};var specialKeys={Enter:"CR",Backspace:"BS",Delete:"Del",Insert:"Ins"};function cmKeyToVimKey(key){if(key.charAt(0)=="'"){return key.charAt(1)}var pieces=key.split(/-(?!$)/);var lastPiece=pieces[pieces.length-1];if(pieces.length==1&&pieces[0].length==1){return false}else if(pieces.length==2&&pieces[0]=="Shift"&&lastPiece.length==1){return false}var hasCharacter=false;for(var i=0;i<pieces.length;i++){var piece=pieces[i];if(piece in modifiers){pieces[i]=modifiers[piece]}else{hasCharacter=true}if(piece in specialKeys){pieces[i]=specialKeys[piece]}}if(!hasCharacter){return false}if(isUpperCase(lastPiece)){pieces[pieces.length-1]=lastPiece.toLowerCase()}return"<"+pieces.join("-")+">"}function getOnPasteFn(cm){var vim=cm.state.vim;if(!vim.onPasteFn){vim.onPasteFn=function(){if(!vim.insertMode){cm.setCursor(offsetCursor(cm.getCursor(),0,1));actions.enterInsertMode(cm,{},vim)}}}return vim.onPasteFn}var numberRegex=/[\d]/;var wordCharTest=[CodeMirror.isWordChar,function(ch){return ch&&!CodeMirror.isWordChar(ch)&&!/\s/.test(ch)}],bigWordCharTest=[function(ch){return/\S/.test(ch)}];function makeKeyRange(start,size){var keys=[];for(var i=start;i<start+size;i++){keys.push(String.fromCharCode(i))}return keys}var upperCaseAlphabet=makeKeyRange(65,26);var lowerCaseAlphabet=makeKeyRange(97,26);var numbers=makeKeyRange(48,10);var validMarks=[].concat(upperCaseAlphabet,lowerCaseAlphabet,numbers,["<",">"]);var validRegisters=[].concat(upperCaseAlphabet,lowerCaseAlphabet,numbers,["-",'"',".",":","/"]);function isLine(cm,line){return line>=cm.firstLine()&&line<=cm.lastLine()}function isLowerCase(k){return/^[a-z]$/.test(k)}function isMatchableSymbol(k){return"()[]{}".indexOf(k)!=-1}function isNumber(k){return numberRegex.test(k)}function isUpperCase(k){return/^[A-Z]$/.test(k)}function isWhiteSpaceString(k){return/^\s*$/.test(k)}function inArray(val,arr){for(var i=0;i<arr.length;i++){if(arr[i]==val){return true}}return false}var options={};function defineOption(name,defaultValue,type,aliases,callback){if(defaultValue===undefined&&!callback){throw Error("defaultValue is required unless callback is provided")}if(!type){type="string"}options[name]={type:type,defaultValue:defaultValue,callback:callback};if(aliases){for(var i=0;i<aliases.length;i++){options[aliases[i]]=options[name]}}if(defaultValue){setOption(name,defaultValue)}}function setOption(name,value,cm,cfg){var option=options[name];cfg=cfg||{};var scope=cfg.scope;if(!option){return new Error("Unknown option: "+name)}if(option.type=="boolean"){if(value&&value!==true){return new Error("Invalid argument: "+name+"="+value)}else if(value!==false){value=true}}if(option.callback){if(scope!=="local"){option.callback(value,undefined)}if(scope!=="global"&&cm){option.callback(value,cm)}}else{if(scope!=="local"){option.value=option.type=="boolean"?!!value:value}if(scope!=="global"&&cm){cm.state.vim.options[name]={value:value}}}}function getOption(name,cm,cfg){var option=options[name];cfg=cfg||{};var scope=cfg.scope;if(!option){return new Error("Unknown option: "+name)}if(option.callback){var local=cm&&option.callback(undefined,cm);if(scope!=="global"&&local!==undefined){return local}if(scope!=="local"){return option.callback()}return}else{var local=scope!=="global"&&(cm&&cm.state.vim.options[name]);return(local||scope!=="local"&&option||{}).value}}defineOption("filetype",undefined,"string",["ft"],function(name,cm){if(cm===undefined){return}if(name===undefined){var mode=cm.getOption("mode");return mode=="null"?"":mode}else{var mode=name==""?"null":name;cm.setOption("mode",mode)}});var createCircularJumpList=function(){var size=100;var pointer=-1;var head=0;var tail=0;var buffer=new Array(size);function add(cm,oldCur,newCur){var current=pointer%size;var curMark=buffer[current];function useNextSlot(cursor){var next=++pointer%size;var trashMark=buffer[next];if(trashMark){trashMark.clear()}buffer[next]=cm.setBookmark(cursor)}if(curMark){var markPos=curMark.find();if(markPos&&!cursorEqual(markPos,oldCur)){useNextSlot(oldCur)}}else{useNextSlot(oldCur)}useNextSlot(newCur);head=pointer;tail=pointer-size+1;if(tail<0){tail=0}}function move(cm,offset){pointer+=offset;if(pointer>head){pointer=head}else if(pointer<tail){pointer=tail}var mark=buffer[(size+pointer)%size];if(mark&&!mark.find()){var inc=offset>0?1:-1;var newCur;var oldCur=cm.getCursor();do{pointer+=inc;mark=buffer[(size+pointer)%size];if(mark&&(newCur=mark.find())&&!cursorEqual(oldCur,newCur)){break}}while(pointer<head&&pointer>tail)}return mark}return{cachedCursor:undefined,add:add,move:move}};var createInsertModeChanges=function(c){if(c){return{changes:c.changes,expectCursorActivityForChange:c.expectCursorActivityForChange}}return{changes:[],expectCursorActivityForChange:false}};function MacroModeState(){this.latestRegister=undefined;this.isPlaying=false;this.isRecording=false;this.replaySearchQueries=[];this.onRecordingDone=undefined;this.lastInsertModeChanges=createInsertModeChanges()}MacroModeState.prototype={exitMacroRecordMode:function(){var macroModeState=vimGlobalState.macroModeState;if(macroModeState.onRecordingDone){macroModeState.onRecordingDone()}macroModeState.onRecordingDone=undefined;macroModeState.isRecording=false},enterMacroRecordMode:function(cm,registerName){var register=vimGlobalState.registerController.getRegister(registerName);if(register){register.clear();this.latestRegister=registerName;if(cm.openDialog){this.onRecordingDone=cm.openDialog("(recording)["+registerName+"]",null,{bottom:true})}this.isRecording=true}}};function maybeInitVimState(cm){if(!cm.state.vim){cm.state.vim={inputState:new InputState,lastEditInputState:undefined,lastEditActionCommand:undefined,lastHPos:-1,lastHSPos:-1,lastMotion:null,marks:{},fakeCursor:null,insertMode:false,insertModeRepeat:undefined,visualMode:false,visualLine:false,visualBlock:false,lastSelection:null,lastPastedText:null,sel:{},options:{}}}return cm.state.vim}var vimGlobalState;function resetVimGlobalState(){vimGlobalState={searchQuery:null,searchIsReversed:false,lastSubstituteReplacePart:undefined,jumpList:createCircularJumpList(),macroModeState:new MacroModeState,lastCharacterSearch:{increment:0,forward:true,selectedCharacter:""},registerController:new RegisterController({}),searchHistoryController:new HistoryController,exCommandHistoryController:new HistoryController};for(var optionName in options){var option=options[optionName];option.value=option.defaultValue}}var lastInsertModeKeyTimer;var vimApi={buildKeyMap:function(){},getRegisterController:function(){return vimGlobalState.registerController},resetVimGlobalState_:resetVimGlobalState,getVimGlobalState_:function(){return vimGlobalState},maybeInitVimState_:maybeInitVimState,suppressErrorLogging:false,InsertModeKey:InsertModeKey,map:function(lhs,rhs,ctx){exCommandDispatcher.map(lhs,rhs,ctx)},unmap:function(lhs,ctx){exCommandDispatcher.unmap(lhs,ctx)},setOption:setOption,getOption:getOption,defineOption:defineOption,defineEx:function(name,prefix,func){if(!prefix){prefix=name}else if(name.indexOf(prefix)!==0){throw new Error('(Vim.defineEx) "'+prefix+'" is not a prefix of "'+name+'", command not registered')}exCommands[name]=func;exCommandDispatcher.commandMap_[prefix]={name:name,shortName:prefix,type:"api"}},handleKey:function(cm,key,origin){var command=this.findKey(cm,key,origin);if(typeof command==="function"){return command()}},findKey:function(cm,key,origin){var vim=maybeInitVimState(cm);function handleMacroRecording(){var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isRecording){if(key=="q"){macroModeState.exitMacroRecordMode();clearInputState(cm);return true}if(origin!="mapping"){logKey(macroModeState,key)}}}function handleEsc(){if(key=="<Esc>"){clearInputState(cm);if(vim.visualMode){exitVisualMode(cm)}else if(vim.insertMode){exitInsertMode(cm)}return true}}function doKeyToKey(keys){var match;while(keys){match=/<\w+-.+?>|<\w+>|./.exec(keys);key=match[0];keys=keys.substring(match.index+key.length);CodeMirror.Vim.handleKey(cm,key,"mapping")}}function handleKeyInsertMode(){if(handleEsc()){return true}var keys=vim.inputState.keyBuffer=vim.inputState.keyBuffer+key;var keysAreChars=key.length==1;var match=commandDispatcher.matchCommand(keys,defaultKeymap,vim.inputState,"insert");while(keys.length>1&&match.type!="full"){var keys=vim.inputState.keyBuffer=keys.slice(1);var thisMatch=commandDispatcher.matchCommand(keys,defaultKeymap,vim.inputState,"insert");if(thisMatch.type!="none"){match=thisMatch}}if(match.type=="none"){clearInputState(cm);return false}else if(match.type=="partial"){if(lastInsertModeKeyTimer){window.clearTimeout(lastInsertModeKeyTimer)}lastInsertModeKeyTimer=window.setTimeout(function(){if(vim.insertMode&&vim.inputState.keyBuffer){clearInputState(cm)}},getOption("insertModeEscKeysTimeout"));return!keysAreChars}if(lastInsertModeKeyTimer){window.clearTimeout(lastInsertModeKeyTimer)}if(keysAreChars){var selections=cm.listSelections();for(var i=0;i<selections.length;i++){var here=selections[i].head;cm.replaceRange("",offsetCursor(here,0,-(keys.length-1)),here,"+input")}vimGlobalState.macroModeState.lastInsertModeChanges.changes.pop()}clearInputState(cm);return match.command}function handleKeyNonInsertMode(){if(handleMacroRecording()||handleEsc()){return true}var keys=vim.inputState.keyBuffer=vim.inputState.keyBuffer+key;if(/^[1-9]\d*$/.test(keys)){return true}var keysMatcher=/^(\d*)(.*)$/.exec(keys);if(!keysMatcher){clearInputState(cm);return false}var context=vim.visualMode?"visual":"normal";var match=commandDispatcher.matchCommand(keysMatcher[2]||keysMatcher[1],defaultKeymap,vim.inputState,context);if(match.type=="none"){clearInputState(cm);return false}else if(match.type=="partial"){return true}vim.inputState.keyBuffer="";var keysMatcher=/^(\d*)(.*)$/.exec(keys);if(keysMatcher[1]&&keysMatcher[1]!="0"){vim.inputState.pushRepeatDigit(keysMatcher[1])}return match.command}var command;if(vim.insertMode){command=handleKeyInsertMode()}else{command=handleKeyNonInsertMode()}if(command===false){return undefined}else if(command===true){return function(){return true}}else{return function(){return cm.operation(function(){cm.curOp.isVimOp=true;try{if(command.type=="keyToKey"){doKeyToKey(command.toKeys)}else{commandDispatcher.processCommand(cm,vim,command)}}catch(e){cm.state.vim=undefined;maybeInitVimState(cm);if(!CodeMirror.Vim.suppressErrorLogging){console["log"](e)}throw e}return true})}}},handleEx:function(cm,input){exCommandDispatcher.processCommand(cm,input)},defineMotion:defineMotion,defineAction:defineAction,defineOperator:defineOperator,mapCommand:mapCommand,_mapCommand:_mapCommand,defineRegister:defineRegister,exitVisualMode:exitVisualMode,exitInsertMode:exitInsertMode};function InputState(){this.prefixRepeat=[];this.motionRepeat=[];this.operator=null;this.operatorArgs=null;this.motion=null;this.motionArgs=null;this.keyBuffer=[];this.registerName=null}InputState.prototype.pushRepeatDigit=function(n){if(!this.operator){this.prefixRepeat=this.prefixRepeat.concat(n)}else{this.motionRepeat=this.motionRepeat.concat(n)}};InputState.prototype.getRepeat=function(){var repeat=0;if(this.prefixRepeat.length>0||this.motionRepeat.length>0){repeat=1;if(this.prefixRepeat.length>0){repeat*=parseInt(this.prefixRepeat.join(""),10)}if(this.motionRepeat.length>0){repeat*=parseInt(this.motionRepeat.join(""),10)}}return repeat};function clearInputState(cm,reason){cm.state.vim.inputState=new InputState;CodeMirror.signal(cm,"vim-command-done",reason)}function Register(text,linewise,blockwise){this.clear();this.keyBuffer=[text||""];this.insertModeChanges=[];this.searchQueries=[];this.linewise=!!linewise;this.blockwise=!!blockwise}Register.prototype={setText:function(text,linewise,blockwise){this.keyBuffer=[text||""];this.linewise=!!linewise;this.blockwise=!!blockwise},pushText:function(text,linewise){if(linewise){if(!this.linewise){this.keyBuffer.push("\n")}this.linewise=true}this.keyBuffer.push(text)},pushInsertModeChanges:function(changes){this.insertModeChanges.push(createInsertModeChanges(changes))},pushSearchQuery:function(query){this.searchQueries.push(query)},clear:function(){this.keyBuffer=[];this.insertModeChanges=[];this.searchQueries=[];this.linewise=false},toString:function(){return this.keyBuffer.join("")}};function defineRegister(name,register){var registers=vimGlobalState.registerController.registers;if(!name||name.length!=1){throw Error("Register name must be 1 character")}if(registers[name]){throw Error("Register already defined "+name)}registers[name]=register;validRegisters.push(name)}function RegisterController(registers){this.registers=registers;this.unnamedRegister=registers['"']=new Register;registers["."]=new Register;registers[":"]=new Register;registers["/"]=new Register}RegisterController.prototype={pushText:function(registerName,operator,text,linewise,blockwise){if(linewise&&text.charAt(text.length-1)!=="\n"){text+="\n"}var register=this.isValidRegister(registerName)?this.getRegister(registerName):null;if(!register){switch(operator){case"yank":this.registers["0"]=new Register(text,linewise,blockwise);break;case"delete":case"change":if(text.indexOf("\n")==-1){this.registers["-"]=new Register(text,linewise)}else{this.shiftNumericRegisters_();this.registers["1"]=new Register(text,linewise)}break}this.unnamedRegister.setText(text,linewise,blockwise);return}var append=isUpperCase(registerName);if(append){register.pushText(text,linewise)}else{register.setText(text,linewise,blockwise)}this.unnamedRegister.setText(register.toString(),linewise)},getRegister:function(name){if(!this.isValidRegister(name)){return this.unnamedRegister}name=name.toLowerCase();if(!this.registers[name]){this.registers[name]=new Register}return this.registers[name]},isValidRegister:function(name){return name&&inArray(name,validRegisters)},shiftNumericRegisters_:function(){for(var i=9;i>=2;i--){this.registers[i]=this.getRegister(""+(i-1))}}};function HistoryController(){this.historyBuffer=[];this.iterator=0;this.initialPrefix=null}HistoryController.prototype={nextMatch:function(input,up){var historyBuffer=this.historyBuffer;var dir=up?-1:1;if(this.initialPrefix===null)this.initialPrefix=input;for(var i=this.iterator+dir;up?i>=0:i<historyBuffer.length;i+=dir){var element=historyBuffer[i];for(var j=0;j<=element.length;j++){if(this.initialPrefix==element.substring(0,j)){this.iterator=i;return element}}}if(i>=historyBuffer.length){this.iterator=historyBuffer.length;return this.initialPrefix}if(i<0)return input},pushInput:function(input){var index=this.historyBuffer.indexOf(input);if(index>-1)this.historyBuffer.splice(index,1);if(input.length)this.historyBuffer.push(input)},reset:function(){this.initialPrefix=null;this.iterator=this.historyBuffer.length}};var commandDispatcher={matchCommand:function(keys,keyMap,inputState,context){var matches=commandMatches(keys,keyMap,context,inputState);if(!matches.full&&!matches.partial){return{type:"none"}}else if(!matches.full&&matches.partial){return{type:"partial"}}var bestMatch;for(var i=0;i<matches.full.length;i++){var match=matches.full[i];if(!bestMatch){bestMatch=match}}if(bestMatch.keys.slice(-11)=="<character>"){var character=lastChar(keys);if(!character)return{type:"none"};inputState.selectedCharacter=character}return{type:"full",command:bestMatch}},processCommand:function(cm,vim,command){vim.inputState.repeatOverride=command.repeatOverride;switch(command.type){case"motion":this.processMotion(cm,vim,command);break;case"operator":this.processOperator(cm,vim,command);break;case"operatorMotion":this.processOperatorMotion(cm,vim,command);break;case"action":this.processAction(cm,vim,command);break;case"search":this.processSearch(cm,vim,command);break;case"ex":case"keyToEx":this.processEx(cm,vim,command);break;default:break}},processMotion:function(cm,vim,command){vim.inputState.motion=command.motion;vim.inputState.motionArgs=copyArgs(command.motionArgs);this.evalInput(cm,vim)},processOperator:function(cm,vim,command){var inputState=vim.inputState;if(inputState.operator){if(inputState.operator==command.operator){inputState.motion="expandToLine";inputState.motionArgs={linewise:true};this.evalInput(cm,vim);return}else{clearInputState(cm)}}inputState.operator=command.operator;inputState.operatorArgs=copyArgs(command.operatorArgs);if(vim.visualMode){this.evalInput(cm,vim)}},processOperatorMotion:function(cm,vim,command){var visualMode=vim.visualMode;var operatorMotionArgs=copyArgs(command.operatorMotionArgs);if(operatorMotionArgs){if(visualMode&&operatorMotionArgs.visualLine){vim.visualLine=true}}this.processOperator(cm,vim,command);if(!visualMode){this.processMotion(cm,vim,command)}},processAction:function(cm,vim,command){var inputState=vim.inputState;var repeat=inputState.getRepeat();var repeatIsExplicit=!!repeat;var actionArgs=copyArgs(command.actionArgs)||{};if(inputState.selectedCharacter){actionArgs.selectedCharacter=inputState.selectedCharacter}if(command.operator){this.processOperator(cm,vim,command)}if(command.motion){this.processMotion(cm,vim,command)}if(command.motion||command.operator){this.evalInput(cm,vim)}actionArgs.repeat=repeat||1;actionArgs.repeatIsExplicit=repeatIsExplicit;actionArgs.registerName=inputState.registerName;clearInputState(cm);vim.lastMotion=null;if(command.isEdit){this.recordLastEdit(vim,inputState,command)}actions[command.action](cm,actionArgs,vim)},processSearch:function(cm,vim,command){if(!cm.getSearchCursor){return}var forward=command.searchArgs.forward;var wholeWordOnly=command.searchArgs.wholeWordOnly;getSearchState(cm).setReversed(!forward);var promptPrefix=forward?"/":"?";var originalQuery=getSearchState(cm).getQuery();var originalScrollPos=cm.getScrollInfo();function handleQuery(query,ignoreCase,smartCase){vimGlobalState.searchHistoryController.pushInput(query);vimGlobalState.searchHistoryController.reset();try{updateSearchQuery(cm,query,ignoreCase,smartCase)}catch(e){showConfirm(cm,"Invalid regex: "+query);clearInputState(cm);return}commandDispatcher.processMotion(cm,vim,{type:"motion",motion:"findNext",motionArgs:{forward:true,toJumplist:command.searchArgs.toJumplist}})}function onPromptClose(query){cm.scrollTo(originalScrollPos.left,originalScrollPos.top);handleQuery(query,true,true);var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isRecording){logSearchQuery(macroModeState,query)}}function onPromptKeyUp(e,query,close){var keyName=CodeMirror.keyName(e),up,offset;if(keyName=="Up"||keyName=="Down"){up=keyName=="Up"?true:false;offset=e.target?e.target.selectionEnd:0;query=vimGlobalState.searchHistoryController.nextMatch(query,up)||"";close(query);if(offset&&e.target)e.target.selectionEnd=e.target.selectionStart=Math.min(offset,e.target.value.length)}else{if(keyName!="Left"&&keyName!="Right"&&keyName!="Ctrl"&&keyName!="Alt"&&keyName!="Shift")vimGlobalState.searchHistoryController.reset()}var parsedQuery;try{parsedQuery=updateSearchQuery(cm,query,true,true)}catch(e){}if(parsedQuery){cm.scrollIntoView(findNext(cm,!forward,parsedQuery),30)}else{clearSearchHighlight(cm);cm.scrollTo(originalScrollPos.left,originalScrollPos.top)}}function onPromptKeyDown(e,query,close){var keyName=CodeMirror.keyName(e);if(keyName=="Esc"||keyName=="Ctrl-C"||keyName=="Ctrl-["||keyName=="Backspace"&&query==""){vimGlobalState.searchHistoryController.pushInput(query);vimGlobalState.searchHistoryController.reset();updateSearchQuery(cm,originalQuery);clearSearchHighlight(cm);cm.scrollTo(originalScrollPos.left,originalScrollPos.top);CodeMirror.e_stop(e);clearInputState(cm);close();cm.focus()}else if(keyName=="Up"||keyName=="Down"){CodeMirror.e_stop(e)}else if(keyName=="Ctrl-U"){CodeMirror.e_stop(e);close("")}}switch(command.searchArgs.querySrc){case"prompt":var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isPlaying){var query=macroModeState.replaySearchQueries.shift();handleQuery(query,true,false)}else{showPrompt(cm,{onClose:onPromptClose,prefix:promptPrefix,desc:searchPromptDesc,onKeyUp:onPromptKeyUp,onKeyDown:onPromptKeyDown})}break;case"wordUnderCursor":var word=expandWordUnderCursor(cm,false,true,false,true);var isKeyword=true;if(!word){word=expandWordUnderCursor(cm,false,true,false,false);isKeyword=false}if(!word){return}var query=cm.getLine(word.start.line).substring(word.start.ch,word.end.ch);if(isKeyword&&wholeWordOnly){query="\\b"+query+"\\b"}else{query=escapeRegex(query)}vimGlobalState.jumpList.cachedCursor=cm.getCursor();cm.setCursor(word.start);handleQuery(query,true,false);break}},processEx:function(cm,vim,command){function onPromptClose(input){vimGlobalState.exCommandHistoryController.pushInput(input);vimGlobalState.exCommandHistoryController.reset();exCommandDispatcher.processCommand(cm,input)}function onPromptKeyDown(e,input,close){var keyName=CodeMirror.keyName(e),up,offset;if(keyName=="Esc"||keyName=="Ctrl-C"||keyName=="Ctrl-["||keyName=="Backspace"&&input==""){vimGlobalState.exCommandHistoryController.pushInput(input);vimGlobalState.exCommandHistoryController.reset();CodeMirror.e_stop(e);clearInputState(cm);close();cm.focus()}if(keyName=="Up"||keyName=="Down"){CodeMirror.e_stop(e);up=keyName=="Up"?true:false;offset=e.target?e.target.selectionEnd:0;input=vimGlobalState.exCommandHistoryController.nextMatch(input,up)||"";close(input);if(offset&&e.target)e.target.selectionEnd=e.target.selectionStart=Math.min(offset,e.target.value.length)}else if(keyName=="Ctrl-U"){CodeMirror.e_stop(e);close("")}else{if(keyName!="Left"&&keyName!="Right"&&keyName!="Ctrl"&&keyName!="Alt"&&keyName!="Shift")vimGlobalState.exCommandHistoryController.reset()}}if(command.type=="keyToEx"){exCommandDispatcher.processCommand(cm,command.exArgs.input)}else{if(vim.visualMode){showPrompt(cm,{onClose:onPromptClose,prefix:":",value:"'<,'>",onKeyDown:onPromptKeyDown})}else{showPrompt(cm,{onClose:onPromptClose,prefix:":",onKeyDown:onPromptKeyDown})}}},evalInput:function(cm,vim){var inputState=vim.inputState;var motion=inputState.motion;var motionArgs=inputState.motionArgs||{};var operator=inputState.operator;var operatorArgs=inputState.operatorArgs||{};var registerName=inputState.registerName;var sel=vim.sel;var origHead=copyCursor(vim.visualMode?clipCursorToContent(cm,sel.head):cm.getCursor("head"));var origAnchor=copyCursor(vim.visualMode?clipCursorToContent(cm,sel.anchor):cm.getCursor("anchor"));var oldHead=copyCursor(origHead);var oldAnchor=copyCursor(origAnchor);var newHead,newAnchor;var repeat;if(operator){this.recordLastEdit(vim,inputState)}if(inputState.repeatOverride!==undefined){repeat=inputState.repeatOverride}else{repeat=inputState.getRepeat()}if(repeat>0&&motionArgs.explicitRepeat){motionArgs.repeatIsExplicit=true}else if(motionArgs.noRepeat||!motionArgs.explicitRepeat&&repeat===0){repeat=1;motionArgs.repeatIsExplicit=false}if(inputState.selectedCharacter){motionArgs.selectedCharacter=operatorArgs.selectedCharacter=inputState.selectedCharacter}motionArgs.repeat=repeat;clearInputState(cm);if(motion){var motionResult=motions[motion](cm,origHead,motionArgs,vim);vim.lastMotion=motions[motion];if(!motionResult){return}if(motionArgs.toJumplist){var jumpList=vimGlobalState.jumpList;var cachedCursor=jumpList.cachedCursor;if(cachedCursor){recordJumpPosition(cm,cachedCursor,motionResult);delete jumpList.cachedCursor}else{recordJumpPosition(cm,origHead,motionResult)}}if(motionResult instanceof Array){newAnchor=motionResult[0];newHead=motionResult[1]}else{newHead=motionResult}if(!newHead){newHead=copyCursor(origHead)}if(vim.visualMode){if(!(vim.visualBlock&&newHead.ch===Infinity)){newHead=clipCursorToContent(cm,newHead,vim.visualBlock)}if(newAnchor){newAnchor=clipCursorToContent(cm,newAnchor,true)}newAnchor=newAnchor||oldAnchor;sel.anchor=newAnchor;sel.head=newHead;updateCmSelection(cm);updateMark(cm,vim,"<",cursorIsBefore(newAnchor,newHead)?newAnchor:newHead);updateMark(cm,vim,">",cursorIsBefore(newAnchor,newHead)?newHead:newAnchor)}else if(!operator){newHead=clipCursorToContent(cm,newHead);cm.setCursor(newHead.line,newHead.ch)}}if(operator){if(operatorArgs.lastSel){newAnchor=oldAnchor;var lastSel=operatorArgs.lastSel;var lineOffset=Math.abs(lastSel.head.line-lastSel.anchor.line);var chOffset=Math.abs(lastSel.head.ch-lastSel.anchor.ch);if(lastSel.visualLine){newHead=Pos(oldAnchor.line+lineOffset,oldAnchor.ch)}else if(lastSel.visualBlock){newHead=Pos(oldAnchor.line+lineOffset,oldAnchor.ch+chOffset)}else if(lastSel.head.line==lastSel.anchor.line){newHead=Pos(oldAnchor.line,oldAnchor.ch+chOffset)}else{newHead=Pos(oldAnchor.line+lineOffset,oldAnchor.ch)}vim.visualMode=true;vim.visualLine=lastSel.visualLine;vim.visualBlock=lastSel.visualBlock;sel=vim.sel={anchor:newAnchor,head:newHead};updateCmSelection(cm)}else if(vim.visualMode){operatorArgs.lastSel={anchor:copyCursor(sel.anchor),head:copyCursor(sel.head),visualBlock:vim.visualBlock,visualLine:vim.visualLine}}var curStart,curEnd,linewise,mode;var cmSel;if(vim.visualMode){curStart=cursorMin(sel.head,sel.anchor);curEnd=cursorMax(sel.head,sel.anchor);linewise=vim.visualLine||operatorArgs.linewise;mode=vim.visualBlock?"block":linewise?"line":"char";cmSel=makeCmSelection(cm,{anchor:curStart,head:curEnd},mode);if(linewise){var ranges=cmSel.ranges;if(mode=="block"){for(var i=0;i<ranges.length;i++){ranges[i].head.ch=lineLength(cm,ranges[i].head.line)}}else if(mode=="line"){ranges[0].head=Pos(ranges[0].head.line+1,0)}}}else{curStart=copyCursor(newAnchor||oldAnchor);curEnd=copyCursor(newHead||oldHead);if(cursorIsBefore(curEnd,curStart)){var tmp=curStart;curStart=curEnd;curEnd=tmp}linewise=motionArgs.linewise||operatorArgs.linewise;if(linewise){expandSelectionToLine(cm,curStart,curEnd)}else if(motionArgs.forward){clipToLine(cm,curStart,curEnd)}mode="char";var exclusive=!motionArgs.inclusive||linewise;cmSel=makeCmSelection(cm,{anchor:curStart,head:curEnd},mode,exclusive)}cm.setSelections(cmSel.ranges,cmSel.primary);vim.lastMotion=null;operatorArgs.repeat=repeat;operatorArgs.registerName=registerName;operatorArgs.linewise=linewise;var operatorMoveTo=operators[operator](cm,operatorArgs,cmSel.ranges,oldAnchor,newHead);if(vim.visualMode){exitVisualMode(cm,operatorMoveTo!=null)}if(operatorMoveTo){cm.setCursor(operatorMoveTo)}}},recordLastEdit:function(vim,inputState,actionCommand){var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isPlaying){return}vim.lastEditInputState=inputState;vim.lastEditActionCommand=actionCommand;macroModeState.lastInsertModeChanges.changes=[];macroModeState.lastInsertModeChanges.expectCursorActivityForChange=false}};var motions={moveToTopLine:function(cm,_head,motionArgs){var line=getUserVisibleLines(cm).top+motionArgs.repeat-1;return Pos(line,findFirstNonWhiteSpaceCharacter(cm.getLine(line)))},moveToMiddleLine:function(cm){var range=getUserVisibleLines(cm);var line=Math.floor((range.top+range.bottom)*.5);return Pos(line,findFirstNonWhiteSpaceCharacter(cm.getLine(line)))},moveToBottomLine:function(cm,_head,motionArgs){var line=getUserVisibleLines(cm).bottom-motionArgs.repeat+1;return Pos(line,findFirstNonWhiteSpaceCharacter(cm.getLine(line)))},expandToLine:function(_cm,head,motionArgs){var cur=head;return Pos(cur.line+motionArgs.repeat-1,Infinity)},findNext:function(cm,_head,motionArgs){var state=getSearchState(cm);var query=state.getQuery();if(!query){return}var prev=!motionArgs.forward;prev=state.isReversed()?!prev:prev;highlightSearchMatches(cm,query);return findNext(cm,prev,query,motionArgs.repeat)},goToMark:function(cm,_head,motionArgs,vim){var pos=getMarkPos(cm,vim,motionArgs.selectedCharacter);if(pos){return motionArgs.linewise?{line:pos.line,ch:findFirstNonWhiteSpaceCharacter(cm.getLine(pos.line))}:pos}return null},moveToOtherHighlightedEnd:function(cm,_head,motionArgs,vim){if(vim.visualBlock&&motionArgs.sameLine){var sel=vim.sel;return[clipCursorToContent(cm,Pos(sel.anchor.line,sel.head.ch)),clipCursorToContent(cm,Pos(sel.head.line,sel.anchor.ch))]}else{return[vim.sel.head,vim.sel.anchor]}},jumpToMark:function(cm,head,motionArgs,vim){var best=head;for(var i=0;i<motionArgs.repeat;i++){var cursor=best;for(var key in vim.marks){if(!isLowerCase(key)){continue}var mark=vim.marks[key].find();var isWrongDirection=motionArgs.forward?cursorIsBefore(mark,cursor):cursorIsBefore(cursor,mark);if(isWrongDirection){continue}if(motionArgs.linewise&&mark.line==cursor.line){continue}var equal=cursorEqual(cursor,best);var between=motionArgs.forward?cursorIsBetween(cursor,mark,best):cursorIsBetween(best,mark,cursor);if(equal||between){best=mark}}}if(motionArgs.linewise){best=Pos(best.line,findFirstNonWhiteSpaceCharacter(cm.getLine(best.line)))}return best},moveByCharacters:function(_cm,head,motionArgs){var cur=head;var repeat=motionArgs.repeat;var ch=motionArgs.forward?cur.ch+repeat:cur.ch-repeat;return Pos(cur.line,ch)},moveByLines:function(cm,head,motionArgs,vim){var cur=head;var endCh=cur.ch;switch(vim.lastMotion){case this.moveByLines:case this.moveByDisplayLines:case this.moveByScroll:case this.moveToColumn:case this.moveToEol:endCh=vim.lastHPos;break;default:vim.lastHPos=endCh}var repeat=motionArgs.repeat+(motionArgs.repeatOffset||0);var line=motionArgs.forward?cur.line+repeat:cur.line-repeat;var first=cm.firstLine();var last=cm.lastLine();if(line<first&&cur.line==first){return this.moveToStartOfLine(cm,head,motionArgs,vim)}else if(line>last&&cur.line==last){return this.moveToEol(cm,head,motionArgs,vim)}if(motionArgs.toFirstChar){endCh=findFirstNonWhiteSpaceCharacter(cm.getLine(line));vim.lastHPos=endCh}vim.lastHSPos=cm.charCoords(Pos(line,endCh),"div").left;return Pos(line,endCh)},moveByDisplayLines:function(cm,head,motionArgs,vim){var cur=head;switch(vim.lastMotion){case this.moveByDisplayLines:case this.moveByScroll:case this.moveByLines:case this.moveToColumn:case this.moveToEol:break;default:vim.lastHSPos=cm.charCoords(cur,"div").left}var repeat=motionArgs.repeat;var res=cm.findPosV(cur,motionArgs.forward?repeat:-repeat,"line",vim.lastHSPos);if(res.hitSide){if(motionArgs.forward){var lastCharCoords=cm.charCoords(res,"div");var goalCoords={top:lastCharCoords.top+8,left:vim.lastHSPos};var res=cm.coordsChar(goalCoords,"div")}else{var resCoords=cm.charCoords(Pos(cm.firstLine(),0),"div");resCoords.left=vim.lastHSPos;res=cm.coordsChar(resCoords,"div")}}vim.lastHPos=res.ch;return res},moveByPage:function(cm,head,motionArgs){var curStart=head;var repeat=motionArgs.repeat;return cm.findPosV(curStart,motionArgs.forward?repeat:-repeat,"page")},moveByParagraph:function(cm,head,motionArgs){var dir=motionArgs.forward?1:-1;return findParagraph(cm,head,motionArgs.repeat,dir)},moveByScroll:function(cm,head,motionArgs,vim){var scrollbox=cm.getScrollInfo();var curEnd=null;var repeat=motionArgs.repeat;if(!repeat){repeat=scrollbox.clientHeight/(2*cm.defaultTextHeight())}var orig=cm.charCoords(head,"local");motionArgs.repeat=repeat;var curEnd=motions.moveByDisplayLines(cm,head,motionArgs,vim);if(!curEnd){return null}var dest=cm.charCoords(curEnd,"local");cm.scrollTo(null,scrollbox.top+dest.top-orig.top);return curEnd},moveByWords:function(cm,head,motionArgs){return moveToWord(cm,head,motionArgs.repeat,!!motionArgs.forward,!!motionArgs.wordEnd,!!motionArgs.bigWord)},moveTillCharacter:function(cm,_head,motionArgs){var repeat=motionArgs.repeat;var curEnd=moveToCharacter(cm,repeat,motionArgs.forward,motionArgs.selectedCharacter);var increment=motionArgs.forward?-1:1;recordLastCharacterSearch(increment,motionArgs);if(!curEnd)return null;curEnd.ch+=increment;return curEnd},moveToCharacter:function(cm,head,motionArgs){var repeat=motionArgs.repeat;recordLastCharacterSearch(0,motionArgs);return moveToCharacter(cm,repeat,motionArgs.forward,motionArgs.selectedCharacter)||head},moveToSymbol:function(cm,head,motionArgs){var repeat=motionArgs.repeat;return findSymbol(cm,repeat,motionArgs.forward,motionArgs.selectedCharacter)||head},moveToColumn:function(cm,head,motionArgs,vim){var repeat=motionArgs.repeat;vim.lastHPos=repeat-1;vim.lastHSPos=cm.charCoords(head,"div").left;return moveToColumn(cm,repeat)},moveToEol:function(cm,head,motionArgs,vim){var cur=head;vim.lastHPos=Infinity;var retval=Pos(cur.line+motionArgs.repeat-1,Infinity);var end=cm.clipPos(retval);end.ch--;vim.lastHSPos=cm.charCoords(end,"div").left;return retval},moveToFirstNonWhiteSpaceCharacter:function(cm,head){var cursor=head;return Pos(cursor.line,findFirstNonWhiteSpaceCharacter(cm.getLine(cursor.line)))},moveToMatchedSymbol:function(cm,head){var cursor=head;var line=cursor.line;var ch=cursor.ch;var lineText=cm.getLine(line);var symbol;for(;ch<lineText.length;ch++){symbol=lineText.charAt(ch);if(symbol&&isMatchableSymbol(symbol)){var style=cm.getTokenTypeAt(Pos(line,ch+1));if(style!=="string"&&style!=="comment"){break}}}if(ch<lineText.length){var matched=cm.findMatchingBracket(Pos(line,ch));return matched.to}else{return cursor}},moveToStartOfLine:function(_cm,head){return Pos(head.line,0)},moveToLineOrEdgeOfDocument:function(cm,_head,motionArgs){var lineNum=motionArgs.forward?cm.lastLine():cm.firstLine();if(motionArgs.repeatIsExplicit){lineNum=motionArgs.repeat-cm.getOption("firstLineNumber")}return Pos(lineNum,findFirstNonWhiteSpaceCharacter(cm.getLine(lineNum)))},textObjectManipulation:function(cm,head,motionArgs,vim){var mirroredPairs={"(":")",")":"(","{":"}","}":"{","[":"]","]":"["};var selfPaired={"'":true,'"':true};var character=motionArgs.selectedCharacter;if(character=="b"){character="("}else if(character=="B"){character="{"}var inclusive=!motionArgs.textObjectInner;var tmp;if(mirroredPairs[character]){tmp=selectCompanionObject(cm,head,character,inclusive)}else if(selfPaired[character]){tmp=findBeginningAndEnd(cm,head,character,inclusive)}else if(character==="W"){tmp=expandWordUnderCursor(cm,inclusive,true,true)}else if(character==="w"){tmp=expandWordUnderCursor(cm,inclusive,true,false)}else if(character==="p"){tmp=findParagraph(cm,head,motionArgs.repeat,0,inclusive);motionArgs.linewise=true;if(vim.visualMode){if(!vim.visualLine){vim.visualLine=true}}else{var operatorArgs=vim.inputState.operatorArgs;if(operatorArgs){operatorArgs.linewise=true}tmp.end.line--}}else{return null}if(!cm.state.vim.visualMode){return[tmp.start,tmp.end]}else{return expandSelection(cm,tmp.start,tmp.end)}},repeatLastCharacterSearch:function(cm,head,motionArgs){var lastSearch=vimGlobalState.lastCharacterSearch;var repeat=motionArgs.repeat;var forward=motionArgs.forward===lastSearch.forward;var increment=(lastSearch.increment?1:0)*(forward?-1:1);cm.moveH(-increment,"char");motionArgs.inclusive=forward?true:false;var curEnd=moveToCharacter(cm,repeat,forward,lastSearch.selectedCharacter);if(!curEnd){cm.moveH(increment,"char");return head}curEnd.ch+=increment;return curEnd}};function defineMotion(name,fn){motions[name]=fn}function fillArray(val,times){var arr=[];for(var i=0;i<times;i++){arr.push(val)}return arr}var operators={change:function(cm,args,ranges){var finalHead,text;var vim=cm.state.vim;vimGlobalState.macroModeState.lastInsertModeChanges.inVisualBlock=vim.visualBlock;if(!vim.visualMode){var anchor=ranges[0].anchor,head=ranges[0].head;text=cm.getRange(anchor,head);var lastState=vim.lastEditInputState||{};if(lastState.motion=="moveByWords"&&!isWhiteSpaceString(text)){var match=/\s+$/.exec(text);if(match&&lastState.motionArgs&&lastState.motionArgs.forward){head=offsetCursor(head,0,-match[0].length);text=text.slice(0,-match[0].length)}}var prevLineEnd=new Pos(anchor.line-1,Number.MAX_VALUE);var wasLastLine=cm.firstLine()==cm.lastLine();if(head.line>cm.lastLine()&&args.linewise&&!wasLastLine){cm.replaceRange("",prevLineEnd,head)}else{cm.replaceRange("",anchor,head)}if(args.linewise){if(!wasLastLine){cm.setCursor(prevLineEnd);CodeMirror.commands.newlineAndIndent(cm)}anchor.ch=Number.MAX_VALUE}finalHead=anchor}else{text=cm.getSelection();var replacement=fillArray("",ranges.length);cm.replaceSelections(replacement);finalHead=cursorMin(ranges[0].head,ranges[0].anchor)}vimGlobalState.registerController.pushText(args.registerName,"change",text,args.linewise,ranges.length>1);actions.enterInsertMode(cm,{head:finalHead},cm.state.vim)},delete:function(cm,args,ranges){var finalHead,text;var vim=cm.state.vim;if(!vim.visualBlock){var anchor=ranges[0].anchor,head=ranges[0].head;if(args.linewise&&head.line!=cm.firstLine()&&anchor.line==cm.lastLine()&&anchor.line==head.line-1){if(anchor.line==cm.firstLine()){anchor.ch=0}else{anchor=Pos(anchor.line-1,lineLength(cm,anchor.line-1))}}text=cm.getRange(anchor,head);cm.replaceRange("",anchor,head);finalHead=anchor;if(args.linewise){finalHead=motions.moveToFirstNonWhiteSpaceCharacter(cm,anchor)}}else{text=cm.getSelection();var replacement=fillArray("",ranges.length);cm.replaceSelections(replacement);finalHead=ranges[0].anchor}vimGlobalState.registerController.pushText(args.registerName,"delete",text,args.linewise,vim.visualBlock);return clipCursorToContent(cm,finalHead)},indent:function(cm,args,ranges){var vim=cm.state.vim;var startLine=ranges[0].anchor.line;var endLine=vim.visualBlock?ranges[ranges.length-1].anchor.line:ranges[0].head.line;var repeat=vim.visualMode?args.repeat:1;if(args.linewise){endLine--}for(var i=startLine;i<=endLine;i++){for(var j=0;j<repeat;j++){cm.indentLine(i,args.indentRight)}}return motions.moveToFirstNonWhiteSpaceCharacter(cm,ranges[0].anchor)},changeCase:function(cm,args,ranges,oldAnchor,newHead){var selections=cm.getSelections();var swapped=[];var toLower=args.toLower;for(var j=0;j<selections.length;j++){var toSwap=selections[j];var text="";if(toLower===true){text=toSwap.toLowerCase()}else if(toLower===false){text=toSwap.toUpperCase()}else{for(var i=0;i<toSwap.length;i++){var character=toSwap.charAt(i);text+=isUpperCase(character)?character.toLowerCase():character.toUpperCase()}}swapped.push(text)}cm.replaceSelections(swapped);if(args.shouldMoveCursor){return newHead}else if(!cm.state.vim.visualMode&&args.linewise&&ranges[0].anchor.line+1==ranges[0].head.line){return motions.moveToFirstNonWhiteSpaceCharacter(cm,oldAnchor)}else if(args.linewise){return oldAnchor}else{return cursorMin(ranges[0].anchor,ranges[0].head)}},yank:function(cm,args,ranges,oldAnchor){var vim=cm.state.vim;var text=cm.getSelection();var endPos=vim.visualMode?cursorMin(vim.sel.anchor,vim.sel.head,ranges[0].head,ranges[0].anchor):oldAnchor;vimGlobalState.registerController.pushText(args.registerName,"yank",text,args.linewise,vim.visualBlock);return endPos}};function defineOperator(name,fn){operators[name]=fn}var actions={jumpListWalk:function(cm,actionArgs,vim){if(vim.visualMode){return}var repeat=actionArgs.repeat;var forward=actionArgs.forward;var jumpList=vimGlobalState.jumpList;var mark=jumpList.move(cm,forward?repeat:-repeat);var markPos=mark?mark.find():undefined;markPos=markPos?markPos:cm.getCursor();cm.setCursor(markPos)},scroll:function(cm,actionArgs,vim){if(vim.visualMode){return}var repeat=actionArgs.repeat||1;var lineHeight=cm.defaultTextHeight();var top=cm.getScrollInfo().top;var delta=lineHeight*repeat;var newPos=actionArgs.forward?top+delta:top-delta;var cursor=copyCursor(cm.getCursor());var cursorCoords=cm.charCoords(cursor,"local");if(actionArgs.forward){if(newPos>cursorCoords.top){cursor.line+=(newPos-cursorCoords.top)/lineHeight;cursor.line=Math.ceil(cursor.line);cm.setCursor(cursor);cursorCoords=cm.charCoords(cursor,"local");cm.scrollTo(null,cursorCoords.top)}else{cm.scrollTo(null,newPos)}}else{var newBottom=newPos+cm.getScrollInfo().clientHeight;if(newBottom<cursorCoords.bottom){cursor.line-=(cursorCoords.bottom-newBottom)/lineHeight;cursor.line=Math.floor(cursor.line);cm.setCursor(cursor);cursorCoords=cm.charCoords(cursor,"local");cm.scrollTo(null,cursorCoords.bottom-cm.getScrollInfo().clientHeight)}else{cm.scrollTo(null,newPos)}}},scrollToCursor:function(cm,actionArgs){var lineNum=cm.getCursor().line;var charCoords=cm.charCoords(Pos(lineNum,0),"local");var height=cm.getScrollInfo().clientHeight;var y=charCoords.top;var lineHeight=charCoords.bottom-y;switch(actionArgs.position){case"center":y=y-height/2+lineHeight;break;case"bottom":y=y-height+lineHeight;break}cm.scrollTo(null,y)},replayMacro:function(cm,actionArgs,vim){var registerName=actionArgs.selectedCharacter;var repeat=actionArgs.repeat;var macroModeState=vimGlobalState.macroModeState;if(registerName=="@"){registerName=macroModeState.latestRegister}while(repeat--){executeMacroRegister(cm,vim,macroModeState,registerName)}},enterMacroRecordMode:function(cm,actionArgs){var macroModeState=vimGlobalState.macroModeState;var registerName=actionArgs.selectedCharacter;if(vimGlobalState.registerController.isValidRegister(registerName)){macroModeState.enterMacroRecordMode(cm,registerName)}},toggleOverwrite:function(cm){if(!cm.state.overwrite){cm.toggleOverwrite(true);cm.setOption("keyMap","vim-replace");CodeMirror.signal(cm,"vim-mode-change",{mode:"replace"})}else{cm.toggleOverwrite(false);cm.setOption("keyMap","vim-insert");CodeMirror.signal(cm,"vim-mode-change",{mode:"insert"})}},enterInsertMode:function(cm,actionArgs,vim){if(cm.getOption("readOnly")){return}vim.insertMode=true;vim.insertModeRepeat=actionArgs&&actionArgs.repeat||1;var insertAt=actionArgs?actionArgs.insertAt:null;var sel=vim.sel;var head=actionArgs.head||cm.getCursor("head");var height=cm.listSelections().length;if(insertAt=="eol"){head=Pos(head.line,lineLength(cm,head.line))}else if(insertAt=="charAfter"){head=offsetCursor(head,0,1)}else if(insertAt=="firstNonBlank"){head=motions.moveToFirstNonWhiteSpaceCharacter(cm,head)}else if(insertAt=="startOfSelectedArea"){if(!vim.visualBlock){if(sel.head.line<sel.anchor.line){head=sel.head}else{head=Pos(sel.anchor.line,0)}}else{head=Pos(Math.min(sel.head.line,sel.anchor.line),Math.min(sel.head.ch,sel.anchor.ch));height=Math.abs(sel.head.line-sel.anchor.line)+1}}else if(insertAt=="endOfSelectedArea"){if(!vim.visualBlock){if(sel.head.line>=sel.anchor.line){head=offsetCursor(sel.head,0,1)}else{head=Pos(sel.anchor.line,0)}}else{head=Pos(Math.min(sel.head.line,sel.anchor.line),Math.max(sel.head.ch+1,sel.anchor.ch));height=Math.abs(sel.head.line-sel.anchor.line)+1}}else if(insertAt=="inplace"){if(vim.visualMode){return}}cm.setOption("disableInput",false);if(actionArgs&&actionArgs.replace){cm.toggleOverwrite(true);cm.setOption("keyMap","vim-replace");CodeMirror.signal(cm,"vim-mode-change",{mode:"replace"})}else{cm.toggleOverwrite(false);cm.setOption("keyMap","vim-insert");CodeMirror.signal(cm,"vim-mode-change",{mode:"insert"})}if(!vimGlobalState.macroModeState.isPlaying){cm.on("change",onChange);CodeMirror.on(cm.getInputField(),"keydown",onKeyEventTargetKeyDown)}if(vim.visualMode){exitVisualMode(cm)}selectForInsert(cm,head,height)},toggleVisualMode:function(cm,actionArgs,vim){var repeat=actionArgs.repeat;var anchor=cm.getCursor();var head;if(!vim.visualMode){vim.visualMode=true;vim.visualLine=!!actionArgs.linewise;vim.visualBlock=!!actionArgs.blockwise;head=clipCursorToContent(cm,Pos(anchor.line,anchor.ch+repeat-1),true);vim.sel={anchor:anchor,head:head};CodeMirror.signal(cm,"vim-mode-change",{mode:"visual",subMode:vim.visualLine?"linewise":vim.visualBlock?"blockwise":""});updateCmSelection(cm);updateMark(cm,vim,"<",cursorMin(anchor,head));updateMark(cm,vim,">",cursorMax(anchor,head))}else if(vim.visualLine^actionArgs.linewise||vim.visualBlock^actionArgs.blockwise){vim.visualLine=!!actionArgs.linewise;vim.visualBlock=!!actionArgs.blockwise;CodeMirror.signal(cm,"vim-mode-change",{mode:"visual",subMode:vim.visualLine?"linewise":vim.visualBlock?"blockwise":""});updateCmSelection(cm)}else{exitVisualMode(cm)}},reselectLastSelection:function(cm,_actionArgs,vim){var lastSelection=vim.lastSelection;if(vim.visualMode){updateLastSelection(cm,vim)}if(lastSelection){var anchor=lastSelection.anchorMark.find();var head=lastSelection.headMark.find();if(!anchor||!head){return}vim.sel={anchor:anchor,head:head};vim.visualMode=true;vim.visualLine=lastSelection.visualLine;vim.visualBlock=lastSelection.visualBlock;updateCmSelection(cm);updateMark(cm,vim,"<",cursorMin(anchor,head));updateMark(cm,vim,">",cursorMax(anchor,head));CodeMirror.signal(cm,"vim-mode-change",{mode:"visual",subMode:vim.visualLine?"linewise":vim.visualBlock?"blockwise":""})}},joinLines:function(cm,actionArgs,vim){var curStart,curEnd;if(vim.visualMode){curStart=cm.getCursor("anchor");curEnd=cm.getCursor("head");if(cursorIsBefore(curEnd,curStart)){var tmp=curEnd;curEnd=curStart;curStart=tmp}curEnd.ch=lineLength(cm,curEnd.line)-1}else{var repeat=Math.max(actionArgs.repeat,2);curStart=cm.getCursor();curEnd=clipCursorToContent(cm,Pos(curStart.line+repeat-1,Infinity))}var finalCh=0;for(var i=curStart.line;i<curEnd.line;i++){finalCh=lineLength(cm,curStart.line);var tmp=Pos(curStart.line+1,lineLength(cm,curStart.line+1));var text=cm.getRange(curStart,tmp);text=text.replace(/\n\s*/g," ");cm.replaceRange(text,curStart,tmp)}var curFinalPos=Pos(curStart.line,finalCh);if(vim.visualMode){exitVisualMode(cm,false)}cm.setCursor(curFinalPos)},newLineAndEnterInsertMode:function(cm,actionArgs,vim){vim.insertMode=true;var insertAt=copyCursor(cm.getCursor());if(insertAt.line===cm.firstLine()&&!actionArgs.after){cm.replaceRange("\n",Pos(cm.firstLine(),0));cm.setCursor(cm.firstLine(),0)}else{insertAt.line=actionArgs.after?insertAt.line:insertAt.line-1;insertAt.ch=lineLength(cm,insertAt.line);cm.setCursor(insertAt);var newlineFn=CodeMirror.commands.newlineAndIndentContinueComment||CodeMirror.commands.newlineAndIndent;newlineFn(cm)}this.enterInsertMode(cm,{repeat:actionArgs.repeat},vim)},paste:function(cm,actionArgs,vim){var cur=copyCursor(cm.getCursor());var register=vimGlobalState.registerController.getRegister(actionArgs.registerName);var text=register.toString();if(!text){return}if(actionArgs.matchIndent){var tabSize=cm.getOption("tabSize");var whitespaceLength=function(str){var tabs=str.split("\t").length-1;var spaces=str.split(" ").length-1;return tabs*tabSize+spaces*1};var currentLine=cm.getLine(cm.getCursor().line);var indent=whitespaceLength(currentLine.match(/^\s*/)[0]);var chompedText=text.replace(/\n$/,"");var wasChomped=text!==chompedText;var firstIndent=whitespaceLength(text.match(/^\s*/)[0]);var text=chompedText.replace(/^\s*/gm,function(wspace){var newIndent=indent+(whitespaceLength(wspace)-firstIndent);if(newIndent<0){return""}else if(cm.getOption("indentWithTabs")){var quotient=Math.floor(newIndent/tabSize);return Array(quotient+1).join("\t")}else{return Array(newIndent+1).join(" ")}});text+=wasChomped?"\n":""}if(actionArgs.repeat>1){var text=Array(actionArgs.repeat+1).join(text)}var linewise=register.linewise;var blockwise=register.blockwise;if(linewise){if(vim.visualMode){text=vim.visualLine?text.slice(0,-1):"\n"+text.slice(0,text.length-1)+"\n"}else if(actionArgs.after){text="\n"+text.slice(0,text.length-1);cur.ch=lineLength(cm,cur.line)}else{cur.ch=0}}else{if(blockwise){text=text.split("\n");for(var i=0;i<text.length;i++){text[i]=text[i]==""?" ":text[i]}}cur.ch+=actionArgs.after?1:0}var curPosFinal;var idx;if(vim.visualMode){vim.lastPastedText=text;var lastSelectionCurEnd;var selectedArea=getSelectedAreaRange(cm,vim);var selectionStart=selectedArea[0];var selectionEnd=selectedArea[1];var selectedText=cm.getSelection();var selections=cm.listSelections();var emptyStrings=new Array(selections.length).join("1").split("1");if(vim.lastSelection){lastSelectionCurEnd=vim.lastSelection.headMark.find()}vimGlobalState.registerController.unnamedRegister.setText(selectedText);if(blockwise){cm.replaceSelections(emptyStrings);selectionEnd=Pos(selectionStart.line+text.length-1,selectionStart.ch);cm.setCursor(selectionStart);selectBlock(cm,selectionEnd);cm.replaceSelections(text);curPosFinal=selectionStart}else if(vim.visualBlock){cm.replaceSelections(emptyStrings);cm.setCursor(selectionStart);cm.replaceRange(text,selectionStart,selectionStart);curPosFinal=selectionStart}else{cm.replaceRange(text,selectionStart,selectionEnd);curPosFinal=cm.posFromIndex(cm.indexFromPos(selectionStart)+text.length-1)}if(lastSelectionCurEnd){vim.lastSelection.headMark=cm.setBookmark(lastSelectionCurEnd)}if(linewise){curPosFinal.ch=0}}else{if(blockwise){cm.setCursor(cur);for(var i=0;i<text.length;i++){var line=cur.line+i;if(line>cm.lastLine()){cm.replaceRange("\n",Pos(line,0))}var lastCh=lineLength(cm,line);if(lastCh<cur.ch){extendLineToColumn(cm,line,cur.ch)}}cm.setCursor(cur);selectBlock(cm,Pos(cur.line+text.length-1,cur.ch));cm.replaceSelections(text);curPosFinal=cur}else{cm.replaceRange(text,cur);if(linewise&&actionArgs.after){curPosFinal=Pos(cur.line+1,findFirstNonWhiteSpaceCharacter(cm.getLine(cur.line+1)))}else if(linewise&&!actionArgs.after){curPosFinal=Pos(cur.line,findFirstNonWhiteSpaceCharacter(cm.getLine(cur.line)))}else if(!linewise&&actionArgs.after){idx=cm.indexFromPos(cur);curPosFinal=cm.posFromIndex(idx+text.length-1)}else{idx=cm.indexFromPos(cur);curPosFinal=cm.posFromIndex(idx+text.length)}}}if(vim.visualMode){exitVisualMode(cm,false)}cm.setCursor(curPosFinal)},undo:function(cm,actionArgs){cm.operation(function(){repeatFn(cm,CodeMirror.commands.undo,actionArgs.repeat)();cm.setCursor(cm.getCursor("anchor"))})},redo:function(cm,actionArgs){repeatFn(cm,CodeMirror.commands.redo,actionArgs.repeat)()},setRegister:function(_cm,actionArgs,vim){vim.inputState.registerName=actionArgs.selectedCharacter},setMark:function(cm,actionArgs,vim){var markName=actionArgs.selectedCharacter;updateMark(cm,vim,markName,cm.getCursor())},replace:function(cm,actionArgs,vim){var replaceWith=actionArgs.selectedCharacter;var curStart=cm.getCursor();var replaceTo;var curEnd;var selections=cm.listSelections();if(vim.visualMode){curStart=cm.getCursor("start");curEnd=cm.getCursor("end")}else{var line=cm.getLine(curStart.line);replaceTo=curStart.ch+actionArgs.repeat;if(replaceTo>line.length){replaceTo=line.length}curEnd=Pos(curStart.line,replaceTo)}if(replaceWith=="\n"){if(!vim.visualMode)cm.replaceRange("",curStart,curEnd);(CodeMirror.commands.newlineAndIndentContinueComment||CodeMirror.commands.newlineAndIndent)(cm)}else{var replaceWithStr=cm.getRange(curStart,curEnd);replaceWithStr=replaceWithStr.replace(/[^\n]/g,replaceWith);if(vim.visualBlock){var spaces=new Array(cm.getOption("tabSize")+1).join(" ");replaceWithStr=cm.getSelection();replaceWithStr=replaceWithStr.replace(/\t/g,spaces).replace(/[^\n]/g,replaceWith).split("\n");cm.replaceSelections(replaceWithStr)}else{cm.replaceRange(replaceWithStr,curStart,curEnd)}if(vim.visualMode){curStart=cursorIsBefore(selections[0].anchor,selections[0].head)?selections[0].anchor:selections[0].head;cm.setCursor(curStart);exitVisualMode(cm,false)}else{cm.setCursor(offsetCursor(curEnd,0,-1))}}},incrementNumberToken:function(cm,actionArgs){var cur=cm.getCursor();var lineStr=cm.getLine(cur.line);var re=/-?\d+/g;var match;var start;var end;var numberStr;var token;while((match=re.exec(lineStr))!==null){token=match[0];start=match.index;end=start+token.length;if(cur.ch<end)break}if(!actionArgs.backtrack&&end<=cur.ch)return;if(token){var increment=actionArgs.increase?1:-1;var number=parseInt(token)+increment*actionArgs.repeat;var from=Pos(cur.line,start);var to=Pos(cur.line,end);numberStr=number.toString();cm.replaceRange(numberStr,from,to)}else{return}cm.setCursor(Pos(cur.line,start+numberStr.length-1))},repeatLastEdit:function(cm,actionArgs,vim){var lastEditInputState=vim.lastEditInputState;if(!lastEditInputState){return}var repeat=actionArgs.repeat;if(repeat&&actionArgs.repeatIsExplicit){vim.lastEditInputState.repeatOverride=repeat}else{repeat=vim.lastEditInputState.repeatOverride||repeat}repeatLastEdit(cm,vim,repeat,false)},indent:function(cm,actionArgs){cm.indentLine(cm.getCursor().line,actionArgs.indentRight)},exitInsertMode:exitInsertMode};function defineAction(name,fn){actions[name]=fn}function clipCursorToContent(cm,cur,includeLineBreak){var line=Math.min(Math.max(cm.firstLine(),cur.line),cm.lastLine());var maxCh=lineLength(cm,line)-1;maxCh=includeLineBreak?maxCh+1:maxCh;var ch=Math.min(Math.max(0,cur.ch),maxCh);return Pos(line,ch)}function copyArgs(args){var ret={};for(var prop in args){if(args.hasOwnProperty(prop)){ret[prop]=args[prop]}}return ret}function offsetCursor(cur,offsetLine,offsetCh){if(typeof offsetLine==="object"){offsetCh=offsetLine.ch;offsetLine=offsetLine.line}return Pos(cur.line+offsetLine,cur.ch+offsetCh)}function getOffset(anchor,head){return{line:head.line-anchor.line,ch:head.line-anchor.line}}function commandMatches(keys,keyMap,context,inputState){var match,partial=[],full=[];for(var i=0;i<keyMap.length;i++){var command=keyMap[i];if(context=="insert"&&command.context!="insert"||command.context&&command.context!=context||inputState.operator&&command.type=="action"||!(match=commandMatch(keys,command.keys))){continue}if(match=="partial"){partial.push(command)}if(match=="full"){full.push(command)}}return{partial:partial.length&&partial,full:full.length&&full}}function commandMatch(pressed,mapped){if(mapped.slice(-11)=="<character>"){var prefixLen=mapped.length-11;var pressedPrefix=pressed.slice(0,prefixLen);var mappedPrefix=mapped.slice(0,prefixLen);return pressedPrefix==mappedPrefix&&pressed.length>prefixLen?"full":mappedPrefix.indexOf(pressedPrefix)==0?"partial":false}else{return pressed==mapped?"full":mapped.indexOf(pressed)==0?"partial":false}}function lastChar(keys){var match=/^.*(<[^>]+>)$/.exec(keys);var selectedCharacter=match?match[1]:keys.slice(-1);if(selectedCharacter.length>1){switch(selectedCharacter){case"<CR>":selectedCharacter="\n";break;case"<Space>":selectedCharacter=" ";break;default:selectedCharacter="";break}}return selectedCharacter}function repeatFn(cm,fn,repeat){return function(){for(var i=0;i<repeat;i++){fn(cm)}}}function copyCursor(cur){return Pos(cur.line,cur.ch)}function cursorEqual(cur1,cur2){return cur1.ch==cur2.ch&&cur1.line==cur2.line}function cursorIsBefore(cur1,cur2){if(cur1.line<cur2.line){return true}if(cur1.line==cur2.line&&cur1.ch<cur2.ch){return true}return false}function cursorMin(cur1,cur2){if(arguments.length>2){cur2=cursorMin.apply(undefined,Array.prototype.slice.call(arguments,1))}return cursorIsBefore(cur1,cur2)?cur1:cur2}function cursorMax(cur1,cur2){if(arguments.length>2){cur2=cursorMax.apply(undefined,Array.prototype.slice.call(arguments,1))}return cursorIsBefore(cur1,cur2)?cur2:cur1}function cursorIsBetween(cur1,cur2,cur3){var cur1before2=cursorIsBefore(cur1,cur2);var cur2before3=cursorIsBefore(cur2,cur3);return cur1before2&&cur2before3}function lineLength(cm,lineNum){return cm.getLine(lineNum).length}function trim(s){if(s.trim){return s.trim()}return s.replace(/^\s+|\s+$/g,"")}function escapeRegex(s){return s.replace(/([.?*+$\[\]\/\\(){}|\-])/g,"\\$1")}function extendLineToColumn(cm,lineNum,column){var endCh=lineLength(cm,lineNum);var spaces=new Array(column-endCh+1).join(" ");cm.setCursor(Pos(lineNum,endCh));cm.replaceRange(spaces,cm.getCursor())}function selectBlock(cm,selectionEnd){var selections=[],ranges=cm.listSelections();var head=copyCursor(cm.clipPos(selectionEnd));var isClipped=!cursorEqual(selectionEnd,head);var curHead=cm.getCursor("head");var primIndex=getIndex(ranges,curHead);var wasClipped=cursorEqual(ranges[primIndex].head,ranges[primIndex].anchor);var max=ranges.length-1;var index=max-primIndex>primIndex?max:0;var base=ranges[index].anchor;var firstLine=Math.min(base.line,head.line);var lastLine=Math.max(base.line,head.line);var baseCh=base.ch,headCh=head.ch;var dir=ranges[index].head.ch-baseCh;var newDir=headCh-baseCh;if(dir>0&&newDir<=0){baseCh++;if(!isClipped){headCh--}}else if(dir<0&&newDir>=0){baseCh--;if(!wasClipped){headCh++}}else if(dir<0&&newDir==-1){baseCh--;headCh++}for(var line=firstLine;line<=lastLine;line++){var range={anchor:new Pos(line,baseCh),head:new Pos(line,headCh)};selections.push(range)}cm.setSelections(selections);selectionEnd.ch=headCh;base.ch=baseCh;return base}function selectForInsert(cm,head,height){var sel=[];for(var i=0;i<height;i++){var lineHead=offsetCursor(head,i,0);sel.push({anchor:lineHead,head:lineHead})}cm.setSelections(sel,0)}function getIndex(ranges,cursor,end){for(var i=0;i<ranges.length;i++){var atAnchor=end!="head"&&cursorEqual(ranges[i].anchor,cursor);var atHead=end!="anchor"&&cursorEqual(ranges[i].head,cursor);if(atAnchor||atHead){return i}}return-1}function getSelectedAreaRange(cm,vim){var lastSelection=vim.lastSelection;var getCurrentSelectedAreaRange=function(){var selections=cm.listSelections();var start=selections[0];var end=selections[selections.length-1];var selectionStart=cursorIsBefore(start.anchor,start.head)?start.anchor:start.head;var selectionEnd=cursorIsBefore(end.anchor,end.head)?end.head:end.anchor;return[selectionStart,selectionEnd]};var getLastSelectedAreaRange=function(){var selectionStart=cm.getCursor();var selectionEnd=cm.getCursor();var block=lastSelection.visualBlock;if(block){var width=block.width;var height=block.height;selectionEnd=Pos(selectionStart.line+height,selectionStart.ch+width);var selections=[];for(var i=selectionStart.line;i<selectionEnd.line;i++){var anchor=Pos(i,selectionStart.ch);var head=Pos(i,selectionEnd.ch);var range={anchor:anchor,head:head};selections.push(range)}cm.setSelections(selections)}else{var start=lastSelection.anchorMark.find();var end=lastSelection.headMark.find();var line=end.line-start.line;var ch=end.ch-start.ch;selectionEnd={line:selectionEnd.line+line,ch:line?selectionEnd.ch:ch+selectionEnd.ch};if(lastSelection.visualLine){selectionStart=Pos(selectionStart.line,0);selectionEnd=Pos(selectionEnd.line,lineLength(cm,selectionEnd.line))}cm.setSelection(selectionStart,selectionEnd)}return[selectionStart,selectionEnd]};if(!vim.visualMode){return getLastSelectedAreaRange()}else{return getCurrentSelectedAreaRange()}}function updateLastSelection(cm,vim){var anchor=vim.sel.anchor;var head=vim.sel.head;if(vim.lastPastedText){head=cm.posFromIndex(cm.indexFromPos(anchor)+vim.lastPastedText.length);vim.lastPastedText=null}vim.lastSelection={anchorMark:cm.setBookmark(anchor),headMark:cm.setBookmark(head),anchor:copyCursor(anchor),head:copyCursor(head),visualMode:vim.visualMode,visualLine:vim.visualLine,visualBlock:vim.visualBlock}}function expandSelection(cm,start,end){var sel=cm.state.vim.sel;var head=sel.head;var anchor=sel.anchor;var tmp;if(cursorIsBefore(end,start)){tmp=end;end=start;start=tmp}if(cursorIsBefore(head,anchor)){head=cursorMin(start,head);anchor=cursorMax(anchor,end)}else{anchor=cursorMin(start,anchor);head=cursorMax(head,end);head=offsetCursor(head,0,-1);if(head.ch==-1&&head.line!=cm.firstLine()){head=Pos(head.line-1,lineLength(cm,head.line-1))}}return[anchor,head]}function updateCmSelection(cm,sel,mode){var vim=cm.state.vim;sel=sel||vim.sel;var mode=mode||vim.visualLine?"line":vim.visualBlock?"block":"char";var cmSel=makeCmSelection(cm,sel,mode);cm.setSelections(cmSel.ranges,cmSel.primary);updateFakeCursor(cm)}function makeCmSelection(cm,sel,mode,exclusive){var head=copyCursor(sel.head);var anchor=copyCursor(sel.anchor);if(mode=="char"){var headOffset=!exclusive&&!cursorIsBefore(sel.head,sel.anchor)?1:0;var anchorOffset=cursorIsBefore(sel.head,sel.anchor)?1:0;head=offsetCursor(sel.head,0,headOffset);anchor=offsetCursor(sel.anchor,0,anchorOffset);return{ranges:[{anchor:anchor,head:head}],primary:0}}else if(mode=="line"){if(!cursorIsBefore(sel.head,sel.anchor)){anchor.ch=0;var lastLine=cm.lastLine();if(head.line>lastLine){head.line=lastLine}head.ch=lineLength(cm,head.line)}else{head.ch=0;anchor.ch=lineLength(cm,anchor.line)}return{ranges:[{anchor:anchor,head:head}],primary:0}}else if(mode=="block"){var top=Math.min(anchor.line,head.line),left=Math.min(anchor.ch,head.ch),bottom=Math.max(anchor.line,head.line),right=Math.max(anchor.ch,head.ch)+1;var height=bottom-top+1;var primary=head.line==top?0:height-1;var ranges=[];for(var i=0;i<height;i++){ranges.push({anchor:Pos(top+i,left),head:Pos(top+i,right)})}return{ranges:ranges,primary:primary}}}function getHead(cm){var cur=cm.getCursor("head");if(cm.getSelection().length==1){cur=cursorMin(cur,cm.getCursor("anchor"))}return cur}function exitVisualMode(cm,moveHead){var vim=cm.state.vim;if(moveHead!==false){cm.setCursor(clipCursorToContent(cm,vim.sel.head))}updateLastSelection(cm,vim);vim.visualMode=false;vim.visualLine=false;vim.visualBlock=false;CodeMirror.signal(cm,"vim-mode-change",{mode:"normal"});if(vim.fakeCursor){vim.fakeCursor.clear()}}function clipToLine(cm,curStart,curEnd){var selection=cm.getRange(curStart,curEnd);if(/\n\s*$/.test(selection)){var lines=selection.split("\n");lines.pop();var line;for(var line=lines.pop();lines.length>0&&line&&isWhiteSpaceString(line);line=lines.pop()){curEnd.line--;curEnd.ch=0}if(line){curEnd.line--;curEnd.ch=lineLength(cm,curEnd.line)}else{curEnd.ch=0}}}function expandSelectionToLine(_cm,curStart,curEnd){curStart.ch=0;curEnd.ch=0;curEnd.line++}function findFirstNonWhiteSpaceCharacter(text){if(!text){return 0}var firstNonWS=text.search(/\S/);return firstNonWS==-1?text.length:firstNonWS}function expandWordUnderCursor(cm,inclusive,_forward,bigWord,noSymbol){var cur=getHead(cm);var line=cm.getLine(cur.line);var idx=cur.ch;var test=noSymbol?wordCharTest[0]:bigWordCharTest[0];while(!test(line.charAt(idx))){idx++;if(idx>=line.length){return null}}if(bigWord){test=bigWordCharTest[0]}else{test=wordCharTest[0];if(!test(line.charAt(idx))){test=wordCharTest[1]}}var end=idx,start=idx;while(test(line.charAt(end))&&end<line.length){end++}while(test(line.charAt(start))&&start>=0){start--}start++;if(inclusive){var wordEnd=end;while(/\s/.test(line.charAt(end))&&end<line.length){end++}if(wordEnd==end){var wordStart=start;while(/\s/.test(line.charAt(start-1))&&start>0){start--}if(!start){start=wordStart}}}return{start:Pos(cur.line,start),end:Pos(cur.line,end)}}function recordJumpPosition(cm,oldCur,newCur){if(!cursorEqual(oldCur,newCur)){vimGlobalState.jumpList.add(cm,oldCur,newCur)}}function recordLastCharacterSearch(increment,args){vimGlobalState.lastCharacterSearch.increment=increment;vimGlobalState.lastCharacterSearch.forward=args.forward;vimGlobalState.lastCharacterSearch.selectedCharacter=args.selectedCharacter}var symbolToMode={"(":"bracket",")":"bracket","{":"bracket","}":"bracket","[":"section","]":"section","*":"comment","/":"comment",m:"method",M:"method","#":"preprocess"};var findSymbolModes={bracket:{isComplete:function(state){if(state.nextCh===state.symb){state.depth++;if(state.depth>=1)return true}else if(state.nextCh===state.reverseSymb){state.depth--}return false}},section:{init:function(state){state.curMoveThrough=true;state.symb=(state.forward?"]":"[")===state.symb?"{":"}"},isComplete:function(state){return state.index===0&&state.nextCh===state.symb}},comment:{isComplete:function(state){var found=state.lastCh==="*"&&state.nextCh==="/";state.lastCh=state.nextCh;return found}},method:{init:function(state){state.symb=state.symb==="m"?"{":"}";state.reverseSymb=state.symb==="{"?"}":"{"},isComplete:function(state){if(state.nextCh===state.symb)return true;return false}},preprocess:{init:function(state){state.index=0},isComplete:function(state){if(state.nextCh==="#"){var token=state.lineText.match(/#(\w+)/)[1];if(token==="endif"){if(state.forward&&state.depth===0){return true}state.depth++}else if(token==="if"){if(!state.forward&&state.depth===0){return true}state.depth--}if(token==="else"&&state.depth===0)return true}return false}}};function findSymbol(cm,repeat,forward,symb){var cur=copyCursor(cm.getCursor());var increment=forward?1:-1;var endLine=forward?cm.lineCount():-1;var curCh=cur.ch;var line=cur.line;var lineText=cm.getLine(line);var state={lineText:lineText,nextCh:lineText.charAt(curCh),lastCh:null,index:curCh,symb:symb,reverseSymb:(forward?{")":"(","}":"{"}:{"(":")","{":"}"})[symb],forward:forward,depth:0,curMoveThrough:false};var mode=symbolToMode[symb];if(!mode)return cur;var init=findSymbolModes[mode].init;var isComplete=findSymbolModes[mode].isComplete;if(init){init(state)}while(line!==endLine&&repeat){state.index+=increment;state.nextCh=state.lineText.charAt(state.index);if(!state.nextCh){line+=increment;state.lineText=cm.getLine(line)||"";if(increment>0){state.index=0}else{var lineLen=state.lineText.length;state.index=lineLen>0?lineLen-1:0}state.nextCh=state.lineText.charAt(state.index)}if(isComplete(state)){cur.line=line;cur.ch=state.index;repeat--}}if(state.nextCh||state.curMoveThrough){return Pos(line,state.index)}return cur}function findWord(cm,cur,forward,bigWord,emptyLineIsWord){var lineNum=cur.line;var pos=cur.ch;var line=cm.getLine(lineNum);var dir=forward?1:-1;var charTests=bigWord?bigWordCharTest:wordCharTest;if(emptyLineIsWord&&line==""){lineNum+=dir;line=cm.getLine(lineNum);if(!isLine(cm,lineNum)){return null}pos=forward?0:line.length}while(true){if(emptyLineIsWord&&line==""){return{from:0,to:0,line:lineNum}}var stop=dir>0?line.length:-1;var wordStart=stop,wordEnd=stop;while(pos!=stop){var foundWord=false;for(var i=0;i<charTests.length&&!foundWord;++i){if(charTests[i](line.charAt(pos))){wordStart=pos;while(pos!=stop&&charTests[i](line.charAt(pos))){pos+=dir}wordEnd=pos;foundWord=wordStart!=wordEnd;if(wordStart==cur.ch&&lineNum==cur.line&&wordEnd==wordStart+dir){continue}else{return{from:Math.min(wordStart,wordEnd+1),to:Math.max(wordStart,wordEnd),line:lineNum}}}}if(!foundWord){pos+=dir}}lineNum+=dir;if(!isLine(cm,lineNum)){return null}line=cm.getLine(lineNum);pos=dir>0?0:line.length}}function moveToWord(cm,cur,repeat,forward,wordEnd,bigWord){var curStart=copyCursor(cur);var words=[];if(forward&&!wordEnd||!forward&&wordEnd){repeat++}var emptyLineIsWord=!(forward&&wordEnd);for(var i=0;i<repeat;i++){var word=findWord(cm,cur,forward,bigWord,emptyLineIsWord);if(!word){var eodCh=lineLength(cm,cm.lastLine());words.push(forward?{line:cm.lastLine(),from:eodCh,to:eodCh}:{line:0,from:0,to:0});break}words.push(word);cur=Pos(word.line,forward?word.to-1:word.from)}var shortCircuit=words.length!=repeat;var firstWord=words[0];var lastWord=words.pop();if(forward&&!wordEnd){if(!shortCircuit&&(firstWord.from!=curStart.ch||firstWord.line!=curStart.line)){lastWord=words.pop()}return Pos(lastWord.line,lastWord.from)}else if(forward&&wordEnd){return Pos(lastWord.line,lastWord.to-1)}else if(!forward&&wordEnd){if(!shortCircuit&&(firstWord.to!=curStart.ch||firstWord.line!=curStart.line)){lastWord=words.pop()}return Pos(lastWord.line,lastWord.to)}else{return Pos(lastWord.line,lastWord.from)}}function moveToCharacter(cm,repeat,forward,character){var cur=cm.getCursor();var start=cur.ch;var idx;for(var i=0;i<repeat;i++){var line=cm.getLine(cur.line);idx=charIdxInLine(start,line,character,forward,true);if(idx==-1){return null}start=idx}return Pos(cm.getCursor().line,idx)}function moveToColumn(cm,repeat){var line=cm.getCursor().line;return clipCursorToContent(cm,Pos(line,repeat-1))}function updateMark(cm,vim,markName,pos){if(!inArray(markName,validMarks)){return}if(vim.marks[markName]){vim.marks[markName].clear()}vim.marks[markName]=cm.setBookmark(pos)}function charIdxInLine(start,line,character,forward,includeChar){var idx;if(forward){idx=line.indexOf(character,start+1);if(idx!=-1&&!includeChar){idx-=1}}else{idx=line.lastIndexOf(character,start-1);if(idx!=-1&&!includeChar){idx+=1}}return idx}function findParagraph(cm,head,repeat,dir,inclusive){var line=head.line;var min=cm.firstLine();var max=cm.lastLine();var start,end,i=line;function isEmpty(i){return!cm.getLine(i)}function isBoundary(i,dir,any){if(any){return isEmpty(i)!=isEmpty(i+dir)}return!isEmpty(i)&&isEmpty(i+dir)}if(dir){while(min<=i&&i<=max&&repeat>0){if(isBoundary(i,dir)){repeat--}i+=dir}return new Pos(i,0)}var vim=cm.state.vim;if(vim.visualLine&&isBoundary(line,1,true)){var anchor=vim.sel.anchor;if(isBoundary(anchor.line,-1,true)){if(!inclusive||anchor.line!=line){line+=1}}}var startState=isEmpty(line);for(i=line;i<=max&&repeat;i++){if(isBoundary(i,1,true)){if(!inclusive||isEmpty(i)!=startState){repeat--}}}end=new Pos(i,0);if(i>max&&!startState){startState=true}else{inclusive=false}for(i=line;i>min;i--){if(!inclusive||isEmpty(i)==startState||i==line){if(isBoundary(i,-1,true)){break}}}start=new Pos(i,0);return{start:start,end:end}}function selectCompanionObject(cm,head,symb,inclusive){var cur=head,start,end;var bracketRegexp={"(":/[()]/,")":/[()]/,"[":/[[\]]/,"]":/[[\]]/,"{":/[{}]/,"}":/[{}]/}[symb];var openSym={"(":"(",")":"(","[":"[","]":"[","{":"{","}":"{"}[symb];var curChar=cm.getLine(cur.line).charAt(cur.ch);var offset=curChar===openSym?1:0;start=cm.scanForBracket(Pos(cur.line,cur.ch+offset),-1,null,{bracketRegex:bracketRegexp});end=cm.scanForBracket(Pos(cur.line,cur.ch+offset),1,null,{bracketRegex:bracketRegexp});if(!start||!end){return{start:cur,end:cur}}start=start.pos;end=end.pos;if(start.line==end.line&&start.ch>end.ch||start.line>end.line){var tmp=start;start=end;end=tmp}if(inclusive){end.ch+=1}else{start.ch+=1}return{start:start,end:end}}function findBeginningAndEnd(cm,head,symb,inclusive){var cur=copyCursor(head);var line=cm.getLine(cur.line);var chars=line.split("");var start,end,i,len;var firstIndex=chars.indexOf(symb);if(cur.ch<firstIndex){cur.ch=firstIndex}else if(firstIndex<cur.ch&&chars[cur.ch]==symb){end=cur.ch;--cur.ch}if(chars[cur.ch]==symb&&!end){start=cur.ch+1}else{for(i=cur.ch;i>-1&&!start;i--){if(chars[i]==symb){start=i+1}}}if(start&&!end){for(i=start,len=chars.length;i<len&&!end;i++){if(chars[i]==symb){end=i}}}if(!start||!end){return{start:cur,end:cur}}if(inclusive){--start;++end}return{start:Pos(cur.line,start),end:Pos(cur.line,end)}}defineOption("pcre",true,"boolean");function SearchState(){}SearchState.prototype={getQuery:function(){return vimGlobalState.query},setQuery:function(query){vimGlobalState.query=query},getOverlay:function(){return this.searchOverlay},setOverlay:function(overlay){this.searchOverlay=overlay},isReversed:function(){return vimGlobalState.isReversed},setReversed:function(reversed){vimGlobalState.isReversed=reversed},getScrollbarAnnotate:function(){return this.annotate},setScrollbarAnnotate:function(annotate){this.annotate=annotate}};function getSearchState(cm){var vim=cm.state.vim;return vim.searchState_||(vim.searchState_=new SearchState)}function dialog(cm,template,shortText,onClose,options){if(cm.openDialog){cm.openDialog(template,onClose,{bottom:true,value:options.value,onKeyDown:options.onKeyDown,onKeyUp:options.onKeyUp,selectValueOnOpen:false})}else{onClose(prompt(shortText,""))}}function splitBySlash(argString){var slashes=findUnescapedSlashes(argString)||[];if(!slashes.length)return[];var tokens=[];if(slashes[0]!==0)return;for(var i=0;i<slashes.length;i++){if(typeof slashes[i]=="number")tokens.push(argString.substring(slashes[i]+1,slashes[i+1]))}return tokens}function findUnescapedSlashes(str){var escapeNextChar=false;var slashes=[];for(var i=0;i<str.length;i++){var c=str.charAt(i);if(!escapeNextChar&&c=="/"){slashes.push(i)}escapeNextChar=!escapeNextChar&&c=="\\"}return slashes}function translateRegex(str){var specials="|(){";var unescape="}";var escapeNextChar=false;var out=[];for(var i=-1;i<str.length;i++){var c=str.charAt(i)||"";var n=str.charAt(i+1)||"";var specialComesNext=n&&specials.indexOf(n)!=-1;if(escapeNextChar){if(c!=="\\"||!specialComesNext){out.push(c)}escapeNextChar=false}else{if(c==="\\"){escapeNextChar=true;if(n&&unescape.indexOf(n)!=-1){specialComesNext=true}if(!specialComesNext||n==="\\"){out.push(c)}}else{out.push(c);if(specialComesNext&&n!=="\\"){out.push("\\")}}}}return out.join("")}var charUnescapes={"\\n":"\n","\\r":"\r","\\t":"\t"};function translateRegexReplace(str){var escapeNextChar=false;var out=[];for(var i=-1;i<str.length;i++){var c=str.charAt(i)||"";var n=str.charAt(i+1)||"";if(charUnescapes[c+n]){out.push(charUnescapes[c+n]);i++}else if(escapeNextChar){out.push(c);escapeNextChar=false}else{if(c==="\\"){escapeNextChar=true;if(isNumber(n)||n==="$"){out.push("$")}else if(n!=="/"&&n!=="\\"){out.push("\\")}}else{if(c==="$"){out.push("$")}out.push(c);if(n==="/"){out.push("\\")}}}}return out.join("")}var unescapes={"\\/":"/","\\\\":"\\","\\n":"\n","\\r":"\r","\\t":"\t"};function unescapeRegexReplace(str){var stream=new CodeMirror.StringStream(str);var output=[];while(!stream.eol()){while(stream.peek()&&stream.peek()!="\\"){output.push(stream.next())}var matched=false;for(var matcher in unescapes){if(stream.match(matcher,true)){matched=true;output.push(unescapes[matcher]);break}}if(!matched){output.push(stream.next())}}return output.join("")}function parseQuery(query,ignoreCase,smartCase){var lastSearchRegister=vimGlobalState.registerController.getRegister("/");lastSearchRegister.setText(query);if(query instanceof RegExp){return query}var slashes=findUnescapedSlashes(query);var regexPart;var forceIgnoreCase;if(!slashes.length){regexPart=query}else{regexPart=query.substring(0,slashes[0]);var flagsPart=query.substring(slashes[0]);forceIgnoreCase=flagsPart.indexOf("i")!=-1}if(!regexPart){return null}if(!getOption("pcre")){regexPart=translateRegex(regexPart)}if(smartCase){ignoreCase=/^[^A-Z]*$/.test(regexPart)}var regexp=new RegExp(regexPart,ignoreCase||forceIgnoreCase?"i":undefined);return regexp}function showConfirm(cm,text){if(cm.openNotification){cm.openNotification('<span style="color: red">'+text+"</span>",{bottom:true,duration:5e3})}else{alert(text)}}function makePrompt(prefix,desc){var raw='<span style="font-family: monospace; white-space: pre">'+(prefix||"")+'<input type="text"></span>';if(desc)raw+=' <span style="color: #888">'+desc+"</span>";return raw}var searchPromptDesc="(Javascript regexp)";function showPrompt(cm,options){var shortText=(options.prefix||"")+" "+(options.desc||"");var prompt=makePrompt(options.prefix,options.desc);dialog(cm,prompt,shortText,options.onClose,options)}function regexEqual(r1,r2){if(r1 instanceof RegExp&&r2 instanceof RegExp){var props=["global","multiline","ignoreCase","source"];for(var i=0;i<props.length;i++){var prop=props[i];if(r1[prop]!==r2[prop]){return false}}return true}return false}function updateSearchQuery(cm,rawQuery,ignoreCase,smartCase){if(!rawQuery){return}var state=getSearchState(cm);var query=parseQuery(rawQuery,!!ignoreCase,!!smartCase);if(!query){return}highlightSearchMatches(cm,query);if(regexEqual(query,state.getQuery())){return query}state.setQuery(query);return query}function searchOverlay(query){if(query.source.charAt(0)=="^"){var matchSol=true}return{token:function(stream){if(matchSol&&!stream.sol()){stream.skipToEnd();return}var match=stream.match(query,false);if(match){if(match[0].length==0){stream.next();return"searching"}if(!stream.sol()){stream.backUp(1);if(!query.exec(stream.next()+match[0])){stream.next();return null}}stream.match(query);return"searching"}while(!stream.eol()){stream.next();if(stream.match(query,false))break}},query:query}}function highlightSearchMatches(cm,query){var searchState=getSearchState(cm);var overlay=searchState.getOverlay();if(!overlay||query!=overlay.query){if(overlay){cm.removeOverlay(overlay)}overlay=searchOverlay(query);cm.addOverlay(overlay);if(cm.showMatchesOnScrollbar){if(searchState.getScrollbarAnnotate()){searchState.getScrollbarAnnotate().clear()}searchState.setScrollbarAnnotate(cm.showMatchesOnScrollbar(query))}searchState.setOverlay(overlay)}}function findNext(cm,prev,query,repeat){if(repeat===undefined){repeat=1}return cm.operation(function(){var pos=cm.getCursor();var cursor=cm.getSearchCursor(query,pos);for(var i=0;i<repeat;i++){var found=cursor.find(prev);if(i==0&&found&&cursorEqual(cursor.from(),pos)){found=cursor.find(prev)}if(!found){cursor=cm.getSearchCursor(query,prev?Pos(cm.lastLine()):Pos(cm.firstLine(),0));if(!cursor.find(prev)){return}}}return cursor.from()})}function clearSearchHighlight(cm){var state=getSearchState(cm);cm.removeOverlay(getSearchState(cm).getOverlay());state.setOverlay(null);if(state.getScrollbarAnnotate()){state.getScrollbarAnnotate().clear();state.setScrollbarAnnotate(null)}}function isInRange(pos,start,end){if(typeof pos!="number"){pos=pos.line}if(start instanceof Array){return inArray(pos,start)}else{if(end){return pos>=start&&pos<=end}else{return pos==start}}}function getUserVisibleLines(cm){var scrollInfo=cm.getScrollInfo();var occludeToleranceTop=6;var occludeToleranceBottom=10;var from=cm.coordsChar({left:0,top:occludeToleranceTop+scrollInfo.top},"local");var bottomY=scrollInfo.clientHeight-occludeToleranceBottom+scrollInfo.top;var to=cm.coordsChar({left:0,top:bottomY},"local");return{top:from.line,bottom:to.line}}function getMarkPos(cm,vim,markName){if(markName=="'"){var history=cm.doc.history.done;var event=history[history.length-2];return event&&event.ranges&&event.ranges[0].head}var mark=vim.marks[markName];return mark&&mark.find()}var ExCommandDispatcher=function(){this.buildCommandMap_()};ExCommandDispatcher.prototype={processCommand:function(cm,input,opt_params){var that=this;cm.operation(function(){cm.curOp.isVimOp=true;that._processCommand(cm,input,opt_params)})},_processCommand:function(cm,input,opt_params){var vim=cm.state.vim;var commandHistoryRegister=vimGlobalState.registerController.getRegister(":");var previousCommand=commandHistoryRegister.toString();if(vim.visualMode){exitVisualMode(cm)}var inputStream=new CodeMirror.StringStream(input);commandHistoryRegister.setText(input);var params=opt_params||{};params.input=input;try{this.parseInput_(cm,inputStream,params)}catch(e){showConfirm(cm,e);throw e}var command;var commandName;if(!params.commandName){if(params.line!==undefined){commandName="move"}}else{command=this.matchCommand_(params.commandName);if(command){commandName=command.name;if(command.excludeFromCommandHistory){commandHistoryRegister.setText(previousCommand)}this.parseCommandArgs_(inputStream,params,command);if(command.type=="exToKey"){for(var i=0;i<command.toKeys.length;i++){CodeMirror.Vim.handleKey(cm,command.toKeys[i],"mapping")}return}else if(command.type=="exToEx"){this.processCommand(cm,command.toInput);return}}}if(!commandName){showConfirm(cm,'Not an editor command ":'+input+'"');return}try{exCommands[commandName](cm,params);if((!command||!command.possiblyAsync)&&params.callback){params.callback()}}catch(e){showConfirm(cm,e);throw e}},parseInput_:function(cm,inputStream,result){inputStream.eatWhile(":");if(inputStream.eat("%")){result.line=cm.firstLine();result.lineEnd=cm.lastLine()}else{result.line=this.parseLineSpec_(cm,inputStream);if(result.line!==undefined&&inputStream.eat(",")){result.lineEnd=this.parseLineSpec_(cm,inputStream)}}var commandMatch=inputStream.match(/^(\w+)/);if(commandMatch){result.commandName=commandMatch[1]}else{result.commandName=inputStream.match(/.*/)[0]}return result},parseLineSpec_:function(cm,inputStream){var numberMatch=inputStream.match(/^(\d+)/);if(numberMatch){return parseInt(numberMatch[1],10)-1}switch(inputStream.next()){case".":return this.parseLineSpecOffset_(inputStream,cm.getCursor().line);case"$":return this.parseLineSpecOffset_(inputStream,cm.lastLine());case"'":var markName=inputStream.next();var markPos=getMarkPos(cm,cm.state.vim,markName);if(!markPos)throw new Error("Mark not set");return this.parseLineSpecOffset_(inputStream,markPos.line);case"-":case"+":inputStream.backUp(1);return this.parseLineSpecOffset_(inputStream,cm.getCursor().line);default:inputStream.backUp(1);return undefined}},parseLineSpecOffset_:function(inputStream,line){var offsetMatch=inputStream.match(/^([+-])?(\d+)/);if(offsetMatch){var offset=parseInt(offsetMatch[2],10);if(offsetMatch[1]=="-"){line-=offset}else{line+=offset}}return line},parseCommandArgs_:function(inputStream,params,command){if(inputStream.eol()){return}params.argString=inputStream.match(/.*/)[0];var delim=command.argDelimiter||/\s+/;var args=trim(params.argString).split(delim);if(args.length&&args[0]){params.args=args}},matchCommand_:function(commandName){for(var i=commandName.length;i>0;i--){var prefix=commandName.substring(0,i);if(this.commandMap_[prefix]){var command=this.commandMap_[prefix];if(command.name.indexOf(commandName)===0){return command}}}return null},buildCommandMap_:function(){this.commandMap_={};for(var i=0;i<defaultExCommandMap.length;i++){var command=defaultExCommandMap[i];var key=command.shortName||command.name;this.commandMap_[key]=command}},map:function(lhs,rhs,ctx){if(lhs!=":"&&lhs.charAt(0)==":"){if(ctx){throw Error("Mode not supported for ex mappings")}var commandName=lhs.substring(1);if(rhs!=":"&&rhs.charAt(0)==":"){this.commandMap_[commandName]={name:commandName,type:"exToEx",toInput:rhs.substring(1),user:true}}else{this.commandMap_[commandName]={name:commandName,type:"exToKey",toKeys:rhs,user:true}}}else{if(rhs!=":"&&rhs.charAt(0)==":"){var mapping={keys:lhs,type:"keyToEx",exArgs:{input:rhs.substring(1)}};if(ctx){mapping.context=ctx}defaultKeymap.unshift(mapping)}else{var mapping={keys:lhs,type:"keyToKey",toKeys:rhs};if(ctx){mapping.context=ctx}defaultKeymap.unshift(mapping)}}},unmap:function(lhs,ctx){if(lhs!=":"&&lhs.charAt(0)==":"){if(ctx){throw Error("Mode not supported for ex mappings")}var commandName=lhs.substring(1);if(this.commandMap_[commandName]&&this.commandMap_[commandName].user){delete this.commandMap_[commandName];return}}else{var keys=lhs;for(var i=0;i<defaultKeymap.length;i++){if(keys==defaultKeymap[i].keys&&defaultKeymap[i].context===ctx){defaultKeymap.splice(i,1);return}}}throw Error("No such mapping.")}};var exCommands={colorscheme:function(cm,params){if(!params.args||params.args.length<1){showConfirm(cm,cm.getOption("theme"));return}cm.setOption("theme",params.args[0])},map:function(cm,params,ctx){var mapArgs=params.args;if(!mapArgs||mapArgs.length<2){if(cm){showConfirm(cm,"Invalid mapping: "+params.input)}return}exCommandDispatcher.map(mapArgs[0],mapArgs[1],ctx)},imap:function(cm,params){this.map(cm,params,"insert")},nmap:function(cm,params){this.map(cm,params,"normal")},vmap:function(cm,params){this.map(cm,params,"visual")},unmap:function(cm,params,ctx){var mapArgs=params.args;if(!mapArgs||mapArgs.length<1){if(cm){showConfirm(cm,"No such mapping: "+params.input)}return}exCommandDispatcher.unmap(mapArgs[0],ctx)},move:function(cm,params){commandDispatcher.processCommand(cm,cm.state.vim,{type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:false,explicitRepeat:true,linewise:true},repeatOverride:params.line+1})},set:function(cm,params){var setArgs=params.args;var setCfg=params.setCfg||{};if(!setArgs||setArgs.length<1){if(cm){showConfirm(cm,"Invalid mapping: "+params.input)}return}var expr=setArgs[0].split("=");var optionName=expr[0];var value=expr[1];var forceGet=false;if(optionName.charAt(optionName.length-1)=="?"){if(value){throw Error("Trailing characters: "+params.argString)}optionName=optionName.substring(0,optionName.length-1);forceGet=true}if(value===undefined&&optionName.substring(0,2)=="no"){optionName=optionName.substring(2);value=false}var optionIsBoolean=options[optionName]&&options[optionName].type=="boolean";if(optionIsBoolean&&value==undefined){value=true}if(!optionIsBoolean&&value===undefined||forceGet){var oldValue=getOption(optionName,cm,setCfg);if(oldValue instanceof Error){showConfirm(cm,oldValue.message)}else if(oldValue===true||oldValue===false){showConfirm(cm," "+(oldValue?"":"no")+optionName)}else{showConfirm(cm,"  "+optionName+"="+oldValue)}}else{var setOptionReturn=setOption(optionName,value,cm,setCfg);if(setOptionReturn instanceof Error){showConfirm(cm,setOptionReturn.message)}}},setlocal:function(cm,params){params.setCfg={scope:"local"};this.set(cm,params)},setglobal:function(cm,params){params.setCfg={scope:"global"};this.set(cm,params)},registers:function(cm,params){var regArgs=params.args;var registers=vimGlobalState.registerController.registers;var regInfo="----------Registers----------<br><br>";if(!regArgs){for(var registerName in registers){var text=registers[registerName].toString();if(text.length){regInfo+='"'+registerName+"    "+text+"<br>"}}}else{var registerName;regArgs=regArgs.join("");for(var i=0;i<regArgs.length;i++){registerName=regArgs.charAt(i);if(!vimGlobalState.registerController.isValidRegister(registerName)){continue}var register=registers[registerName]||new Register;regInfo+='"'+registerName+"    "+register.toString()+"<br>"}}showConfirm(cm,regInfo)},sort:function(cm,params){var reverse,ignoreCase,unique,number,pattern;function parseArgs(){if(params.argString){var args=new CodeMirror.StringStream(params.argString);if(args.eat("!")){reverse=true}if(args.eol()){return}if(!args.eatSpace()){return"Invalid arguments"}var opts=args.match(/([dinuox]+)?\s*(\/.+\/)?\s*/);if(!opts&&!args.eol()){return"Invalid arguments"}if(opts[1]){ignoreCase=opts[1].indexOf("i")!=-1;unique=opts[1].indexOf("u")!=-1;var decimal=opts[1].indexOf("d")!=-1||opts[1].indexOf("n")!=-1&&1;var hex=opts[1].indexOf("x")!=-1&&1;var octal=opts[1].indexOf("o")!=-1&&1;if(decimal+hex+octal>1){return"Invalid arguments"}number=decimal&&"decimal"||hex&&"hex"||octal&&"octal"}if(opts[2]){pattern=new RegExp(opts[2].substr(1,opts[2].length-2),ignoreCase?"i":"")}}}var err=parseArgs();if(err){showConfirm(cm,err+": "+params.argString);return}var lineStart=params.line||cm.firstLine();var lineEnd=params.lineEnd||params.line||cm.lastLine();if(lineStart==lineEnd){return}var curStart=Pos(lineStart,0);var curEnd=Pos(lineEnd,lineLength(cm,lineEnd));var text=cm.getRange(curStart,curEnd).split("\n");var numberRegex=pattern?pattern:number=="decimal"?/(-?)([\d]+)/:number=="hex"?/(-?)(?:0x)?([0-9a-f]+)/i:number=="octal"?/([0-7]+)/:null;var radix=number=="decimal"?10:number=="hex"?16:number=="octal"?8:null;var numPart=[],textPart=[];if(number||pattern){for(var i=0;i<text.length;i++){var matchPart=pattern?text[i].match(pattern):null;if(matchPart&&matchPart[0]!=""){numPart.push(matchPart)}else if(!pattern&&numberRegex.exec(text[i])){numPart.push(text[i])}else{textPart.push(text[i])}}}else{textPart=text}function compareFn(a,b){if(reverse){var tmp;tmp=a;a=b;b=tmp}if(ignoreCase){a=a.toLowerCase();b=b.toLowerCase()}var anum=number&&numberRegex.exec(a);var bnum=number&&numberRegex.exec(b);if(!anum){return a<b?-1:1}anum=parseInt((anum[1]+anum[2]).toLowerCase(),radix);bnum=parseInt((bnum[1]+bnum[2]).toLowerCase(),radix);return anum-bnum}function comparePatternFn(a,b){if(reverse){var tmp;tmp=a;a=b;b=tmp}if(ignoreCase){a[0]=a[0].toLowerCase();b[0]=b[0].toLowerCase()}return a[0]<b[0]?-1:1}numPart.sort(pattern?comparePatternFn:compareFn);if(pattern){for(var i=0;i<numPart.length;i++){numPart[i]=numPart[i].input}}else if(!number){textPart.sort(compareFn)}text=!reverse?textPart.concat(numPart):numPart.concat(textPart);if(unique){var textOld=text;var lastLine;text=[];for(var i=0;i<textOld.length;i++){if(textOld[i]!=lastLine){text.push(textOld[i])}lastLine=textOld[i]}}cm.replaceRange(text.join("\n"),curStart,curEnd)},global:function(cm,params){var argString=params.argString;if(!argString){showConfirm(cm,"Regular Expression missing from global");return}var lineStart=params.line!==undefined?params.line:cm.firstLine();var lineEnd=params.lineEnd||params.line||cm.lastLine();var tokens=splitBySlash(argString);var regexPart=argString,cmd;if(tokens.length){regexPart=tokens[0];cmd=tokens.slice(1,tokens.length).join("/")}if(regexPart){try{updateSearchQuery(cm,regexPart,true,true)}catch(e){showConfirm(cm,"Invalid regex: "+regexPart);return}}var query=getSearchState(cm).getQuery();var matchedLines=[],content="";for(var i=lineStart;i<=lineEnd;i++){var matched=query.test(cm.getLine(i));if(matched){matchedLines.push(i+1);content+=cm.getLine(i)+"<br>"}}if(!cmd){showConfirm(cm,content);return}var index=0;var nextCommand=function(){if(index<matchedLines.length){var command=matchedLines[index]+cmd;exCommandDispatcher.processCommand(cm,command,{callback:nextCommand})}index++};nextCommand()},substitute:function(cm,params){if(!cm.getSearchCursor){throw new Error("Search feature not available. Requires searchcursor.js or "+"any other getSearchCursor implementation.")}var argString=params.argString;var tokens=argString?splitBySlash(argString):[];var regexPart,replacePart="",trailing,flagsPart,count;var confirm=false;var global=false;if(tokens.length){regexPart=tokens[0];replacePart=tokens[1];if(regexPart&&regexPart[regexPart.length-1]==="$"){regexPart=regexPart.slice(0,regexPart.length-1)+"\\n";replacePart=replacePart?replacePart+"\n":"\n"}if(replacePart!==undefined){if(getOption("pcre")){replacePart=unescapeRegexReplace(replacePart)}else{replacePart=translateRegexReplace(replacePart)}vimGlobalState.lastSubstituteReplacePart=replacePart}trailing=tokens[2]?tokens[2].split(" "):[]}else{if(argString&&argString.length){showConfirm(cm,"Substitutions should be of the form "+":s/pattern/replace/");return}}if(trailing){flagsPart=trailing[0];count=parseInt(trailing[1]);if(flagsPart){if(flagsPart.indexOf("c")!=-1){confirm=true;flagsPart.replace("c","")}if(flagsPart.indexOf("g")!=-1){global=true;flagsPart.replace("g","")}regexPart=regexPart+"/"+flagsPart}}if(regexPart){try{updateSearchQuery(cm,regexPart,true,true)}catch(e){showConfirm(cm,"Invalid regex: "+regexPart);return}}replacePart=replacePart||vimGlobalState.lastSubstituteReplacePart;if(replacePart===undefined){showConfirm(cm,"No previous substitute regular expression");return}var state=getSearchState(cm);var query=state.getQuery();var lineStart=params.line!==undefined?params.line:cm.getCursor().line;var lineEnd=params.lineEnd||lineStart;if(lineStart==cm.firstLine()&&lineEnd==cm.lastLine()){lineEnd=Infinity}if(count){lineStart=lineEnd;lineEnd=lineStart+count-1}var startPos=clipCursorToContent(cm,Pos(lineStart,0));var cursor=cm.getSearchCursor(query,startPos);doReplace(cm,confirm,global,lineStart,lineEnd,cursor,query,replacePart,params.callback)},redo:CodeMirror.commands.redo,undo:CodeMirror.commands.undo,write:function(cm){if(CodeMirror.commands.save){CodeMirror.commands.save(cm)}else if(cm.save){cm.save()}},nohlsearch:function(cm){clearSearchHighlight(cm)},yank:function(cm){var cur=copyCursor(cm.getCursor());var line=cur.line;var lineText=cm.getLine(line);vimGlobalState.registerController.pushText("0","yank",lineText,true,true)},delmarks:function(cm,params){if(!params.argString||!trim(params.argString)){showConfirm(cm,"Argument required");return}var state=cm.state.vim;var stream=new CodeMirror.StringStream(trim(params.argString));while(!stream.eol()){stream.eatSpace();var count=stream.pos;if(!stream.match(/[a-zA-Z]/,false)){showConfirm(cm,"Invalid argument: "+params.argString.substring(count));return}var sym=stream.next();if(stream.match("-",true)){if(!stream.match(/[a-zA-Z]/,false)){showConfirm(cm,"Invalid argument: "+params.argString.substring(count));return}var startMark=sym;var finishMark=stream.next();if(isLowerCase(startMark)&&isLowerCase(finishMark)||isUpperCase(startMark)&&isUpperCase(finishMark)){var start=startMark.charCodeAt(0);var finish=finishMark.charCodeAt(0);if(start>=finish){showConfirm(cm,"Invalid argument: "+params.argString.substring(count));return}for(var j=0;j<=finish-start;j++){var mark=String.fromCharCode(start+j);delete state.marks[mark]}}else{showConfirm(cm,"Invalid argument: "+startMark+"-");return}}else{delete state.marks[sym]}}}};var exCommandDispatcher=new ExCommandDispatcher;function doReplace(cm,confirm,global,lineStart,lineEnd,searchCursor,query,replaceWith,callback){cm.state.vim.exMode=true;var done=false;var lastPos=searchCursor.from();function replaceAll(){cm.operation(function(){while(!done){replace();next()}stop()})}function replace(){var text=cm.getRange(searchCursor.from(),searchCursor.to());var newText=text.replace(query,replaceWith);searchCursor.replace(newText)}function next(){while(searchCursor.findNext()&&isInRange(searchCursor.from(),lineStart,lineEnd)){if(!global&&lastPos&&searchCursor.from().line==lastPos.line){continue}cm.scrollIntoView(searchCursor.from(),30);cm.setSelection(searchCursor.from(),searchCursor.to());lastPos=searchCursor.from();done=false;return}done=true}function stop(close){if(close){close()}cm.focus();if(lastPos){cm.setCursor(lastPos);var vim=cm.state.vim;vim.exMode=false;vim.lastHPos=vim.lastHSPos=lastPos.ch}if(callback){callback()}}function onPromptKeyDown(e,_value,close){CodeMirror.e_stop(e);var keyName=CodeMirror.keyName(e);switch(keyName){case"Y":replace();next();break;case"N":next();break;case"A":var savedCallback=callback;callback=undefined;cm.operation(replaceAll);callback=savedCallback;break;case"L":replace();case"Q":case"Esc":case"Ctrl-C":case"Ctrl-[":stop(close);break}if(done){stop(close)}return true}next();if(done){showConfirm(cm,"No matches for "+query.source);return}if(!confirm){replaceAll();if(callback){callback()}return}showPrompt(cm,{prefix:"replace with <strong>"+replaceWith+"</strong> (y/n/a/q/l)",onKeyDown:onPromptKeyDown})}CodeMirror.keyMap.vim={attach:attachVimMap,detach:detachVimMap,call:cmKey};function exitInsertMode(cm){var vim=cm.state.vim;var macroModeState=vimGlobalState.macroModeState;var insertModeChangeRegister=vimGlobalState.registerController.getRegister(".");var isPlaying=macroModeState.isPlaying;var lastChange=macroModeState.lastInsertModeChanges;var text=[];if(!isPlaying){var selLength=lastChange.inVisualBlock?vim.lastSelection.visualBlock.height:1;var changes=lastChange.changes;var text=[];var i=0;while(i<changes.length){text.push(changes[i]);if(changes[i]instanceof InsertModeKey){i++}else{i+=selLength}}lastChange.changes=text;cm.off("change",onChange);CodeMirror.off(cm.getInputField(),"keydown",onKeyEventTargetKeyDown)}if(!isPlaying&&vim.insertModeRepeat>1){repeatLastEdit(cm,vim,vim.insertModeRepeat-1,true);vim.lastEditInputState.repeatOverride=vim.insertModeRepeat}delete vim.insertModeRepeat;vim.insertMode=false;cm.setCursor(cm.getCursor().line,cm.getCursor().ch-1);cm.setOption("keyMap","vim");cm.setOption("disableInput",true);cm.toggleOverwrite(false);insertModeChangeRegister.setText(lastChange.changes.join(""));CodeMirror.signal(cm,"vim-mode-change",{mode:"normal"});if(macroModeState.isRecording){logInsertModeChange(macroModeState)}}function _mapCommand(command){defaultKeymap.unshift(command)}function mapCommand(keys,type,name,args,extra){var command={keys:keys,type:type};command[type]=name;command[type+"Args"]=args;for(var key in extra)command[key]=extra[key];_mapCommand(command)}defineOption("insertModeEscKeysTimeout",200,"number");CodeMirror.keyMap["vim-insert"]={fallthrough:["default"],attach:attachVimMap,detach:detachVimMap,call:cmKey};CodeMirror.keyMap["vim-replace"]={Backspace:"goCharLeft",fallthrough:["vim-insert"],attach:attachVimMap,detach:detachVimMap,call:cmKey};function executeMacroRegister(cm,vim,macroModeState,registerName){var register=vimGlobalState.registerController.getRegister(registerName);if(registerName==":"){if(register.keyBuffer[0]){exCommandDispatcher.processCommand(cm,register.keyBuffer[0])}macroModeState.isPlaying=false;return}var keyBuffer=register.keyBuffer;var imc=0;macroModeState.isPlaying=true;macroModeState.replaySearchQueries=register.searchQueries.slice(0);for(var i=0;i<keyBuffer.length;i++){var text=keyBuffer[i];var match,key;while(text){match=/<\w+-.+?>|<\w+>|./.exec(text);key=match[0];text=text.substring(match.index+key.length);CodeMirror.Vim.handleKey(cm,key,"macro");if(vim.insertMode){var changes=register.insertModeChanges[imc++].changes;vimGlobalState.macroModeState.lastInsertModeChanges.changes=changes;repeatInsertModeChanges(cm,changes,1);exitInsertMode(cm)}}}macroModeState.isPlaying=false}function logKey(macroModeState,key){if(macroModeState.isPlaying){return}var registerName=macroModeState.latestRegister;var register=vimGlobalState.registerController.getRegister(registerName);if(register){register.pushText(key)}}function logInsertModeChange(macroModeState){if(macroModeState.isPlaying){return}var registerName=macroModeState.latestRegister;var register=vimGlobalState.registerController.getRegister(registerName);if(register&&register.pushInsertModeChanges){register.pushInsertModeChanges(macroModeState.lastInsertModeChanges)}}function logSearchQuery(macroModeState,query){if(macroModeState.isPlaying){return}var registerName=macroModeState.latestRegister;var register=vimGlobalState.registerController.getRegister(registerName);if(register&&register.pushSearchQuery){register.pushSearchQuery(query)}}function onChange(cm,changeObj){var macroModeState=vimGlobalState.macroModeState;var lastChange=macroModeState.lastInsertModeChanges;if(!macroModeState.isPlaying){while(changeObj){lastChange.expectCursorActivityForChange=true;if(changeObj.origin=="+input"||changeObj.origin=="paste"||changeObj.origin===undefined){var text=changeObj.text.join("\n");if(lastChange.maybeReset){lastChange.changes=[];lastChange.maybeReset=false}if(cm.state.overwrite&&!/\n/.test(text)){lastChange.changes.push([text])}else{lastChange.changes.push(text)}}changeObj=changeObj.next}}}function onCursorActivity(cm){var vim=cm.state.vim;if(vim.insertMode){var macroModeState=vimGlobalState.macroModeState;if(macroModeState.isPlaying){return}var lastChange=macroModeState.lastInsertModeChanges;if(lastChange.expectCursorActivityForChange){lastChange.expectCursorActivityForChange=false}else{lastChange.maybeReset=true}}else if(!cm.curOp.isVimOp){handleExternalSelection(cm,vim)}if(vim.visualMode){updateFakeCursor(cm)}}function updateFakeCursor(cm){var vim=cm.state.vim;var from=clipCursorToContent(cm,copyCursor(vim.sel.head));var to=offsetCursor(from,0,1);if(vim.fakeCursor){vim.fakeCursor.clear()}vim.fakeCursor=cm.markText(from,to,{className:"cm-animate-fat-cursor"})}function handleExternalSelection(cm,vim){var anchor=cm.getCursor("anchor");var head=cm.getCursor("head");if(vim.visualMode&&!cm.somethingSelected()){exitVisualMode(cm,false)}else if(!vim.visualMode&&!vim.insertMode&&cm.somethingSelected()){vim.visualMode=true;vim.visualLine=false;CodeMirror.signal(cm,"vim-mode-change",{mode:"visual"})}if(vim.visualMode){var headOffset=!cursorIsBefore(head,anchor)?-1:0;var anchorOffset=cursorIsBefore(head,anchor)?-1:0;head=offsetCursor(head,0,headOffset);anchor=offsetCursor(anchor,0,anchorOffset);vim.sel={anchor:anchor,head:head};updateMark(cm,vim,"<",cursorMin(head,anchor));updateMark(cm,vim,">",cursorMax(head,anchor))}else if(!vim.insertMode){vim.lastHPos=cm.getCursor().ch}}function InsertModeKey(keyName){this.keyName=keyName}function onKeyEventTargetKeyDown(e){var macroModeState=vimGlobalState.macroModeState;var lastChange=macroModeState.lastInsertModeChanges;var keyName=CodeMirror.keyName(e);if(!keyName){return}function onKeyFound(){if(lastChange.maybeReset){lastChange.changes=[];lastChange.maybeReset=false}lastChange.changes.push(new InsertModeKey(keyName));return true}if(keyName.indexOf("Delete")!=-1||keyName.indexOf("Backspace")!=-1){CodeMirror.lookupKey(keyName,"vim-insert",onKeyFound)}}function repeatLastEdit(cm,vim,repeat,repeatForInsert){var macroModeState=vimGlobalState.macroModeState;macroModeState.isPlaying=true;var isAction=!!vim.lastEditActionCommand;var cachedInputState=vim.inputState;function repeatCommand(){if(isAction){commandDispatcher.processAction(cm,vim,vim.lastEditActionCommand)}else{commandDispatcher.evalInput(cm,vim)}}function repeatInsert(repeat){if(macroModeState.lastInsertModeChanges.changes.length>0){repeat=!vim.lastEditActionCommand?1:repeat;var changeObject=macroModeState.lastInsertModeChanges;repeatInsertModeChanges(cm,changeObject.changes,repeat)}}vim.inputState=vim.lastEditInputState;if(isAction&&vim.lastEditActionCommand.interlaceInsertRepeat){for(var i=0;i<repeat;i++){repeatCommand();repeatInsert(1)}}else{if(!repeatForInsert){repeatCommand()}repeatInsert(repeat)}vim.inputState=cachedInputState;if(vim.insertMode&&!repeatForInsert){exitInsertMode(cm)}macroModeState.isPlaying=false}function repeatInsertModeChanges(cm,changes,repeat){function keyHandler(binding){if(typeof binding=="string"){CodeMirror.commands[binding](cm)}else{binding(cm)}return true}var head=cm.getCursor("head");var inVisualBlock=vimGlobalState.macroModeState.lastInsertModeChanges.inVisualBlock;if(inVisualBlock){var vim=cm.state.vim;var lastSel=vim.lastSelection;var offset=getOffset(lastSel.anchor,lastSel.head);selectForInsert(cm,head,offset.line+1);repeat=cm.listSelections().length;cm.setCursor(head)}for(var i=0;i<repeat;i++){if(inVisualBlock){cm.setCursor(offsetCursor(head,i,0))}for(var j=0;j<changes.length;j++){var change=changes[j];if(change instanceof InsertModeKey){CodeMirror.lookupKey(change.keyName,"vim-insert",keyHandler)}else if(typeof change=="string"){var cur=cm.getCursor();cm.replaceRange(change,cur,cur)}else{var start=cm.getCursor();var end=offsetCursor(start,0,change[0].length);cm.replaceRange(change[0],start,end)}}}if(inVisualBlock){cm.setCursor(offsetCursor(head,0,1))}}resetVimGlobalState();return vimApi};CodeMirror.Vim=Vim()});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineOption("fullScreen",false,function(cm,val,old){if(old==CodeMirror.Init)old=false;if(!old==!val)return;if(val)setFullscreen(cm);else setNormal(cm)});function setFullscreen(cm){var wrap=cm.getWrapperElement();cm.state.fullScreenRestore={scrollTop:window.pageYOffset,scrollLeft:window.pageXOffset,width:wrap.style.width,height:wrap.style.height};wrap.style.width="";wrap.style.height="auto";wrap.className+=" CodeMirror-fullscreen";document.documentElement.style.overflow="hidden";cm.refresh()}function setNormal(cm){var wrap=cm.getWrapperElement();wrap.className=wrap.className.replace(/\s*CodeMirror-fullscreen\b/,"");document.documentElement.style.overflow="";var info=cm.state.fullScreenRestore;wrap.style.width=info.width;wrap.style.height=info.height;window.scrollTo(info.scrollLeft,info.scrollTop);cm.refresh()}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){CodeMirror.defineOption("placeholder","",function(cm,val,old){var prev=old&&old!=CodeMirror.Init;if(val&&!prev){cm.on("blur",onBlur);cm.on("change",onChange);cm.on("swapDoc",onChange);onChange(cm)}else if(!val&&prev){cm.off("blur",onBlur);cm.off("change",onChange);cm.off("swapDoc",onChange);clearPlaceholder(cm);var wrapper=cm.getWrapperElement();wrapper.className=wrapper.className.replace(" CodeMirror-empty","")}if(val&&!cm.hasFocus())onBlur(cm)});function clearPlaceholder(cm){if(cm.state.placeholder){cm.state.placeholder.parentNode.removeChild(cm.state.placeholder);cm.state.placeholder=null}}function setPlaceholder(cm){clearPlaceholder(cm);var elt=cm.state.placeholder=document.createElement("pre");elt.style.cssText="height: 0; overflow: visible";elt.className="CodeMirror-placeholder";var placeHolder=cm.getOption("placeholder");if(typeof placeHolder=="string")placeHolder=document.createTextNode(placeHolder);elt.appendChild(placeHolder);cm.display.lineSpace.insertBefore(elt,cm.display.lineSpace.firstChild)}function onBlur(cm){if(isEmpty(cm))setPlaceholder(cm)}function onChange(cm){var wrapper=cm.getWrapperElement(),empty=isEmpty(cm);wrapper.className=wrapper.className.replace(" CodeMirror-empty","")+(empty?" CodeMirror-empty":"");if(empty)setPlaceholder(cm);else clearPlaceholder(cm)}function isEmpty(cm){return cm.lineCount()===1&&cm.getLine(0)===""}});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineMode("sql",function(config,parserConfig){"use strict";var client=parserConfig.client||{},atoms=parserConfig.atoms||{false:true,true:true,null:true},builtin=parserConfig.builtin||{},keywords=parserConfig.keywords||{},operatorChars=parserConfig.operatorChars||/^[*+\-%<>!=&|~^]/,support=parserConfig.support||{},hooks=parserConfig.hooks||{},dateSQL=parserConfig.dateSQL||{date:true,time:true,timestamp:true};function tokenBase(stream,state){var ch=stream.next();if(hooks[ch]){var result=hooks[ch](stream,state);if(result!==false)return result}if(support.hexNumber&&(ch=="0"&&stream.match(/^[xX][0-9a-fA-F]+/)||(ch=="x"||ch=="X")&&stream.match(/^'[0-9a-fA-F]+'/))){return"number"}else if(support.binaryNumber&&((ch=="b"||ch=="B")&&stream.match(/^'[01]+'/)||ch=="0"&&stream.match(/^b[01]+/))){return"number"}else if(ch.charCodeAt(0)>47&&ch.charCodeAt(0)<58){stream.match(/^[0-9]*\.?[0-9]+([eE][-+]?[0-9]+)?/);support.decimallessFloat&&stream.eat(".");return"number"}else if(ch=="?"&&(stream.eatSpace()||stream.eol()||stream.eat(";"))){return"variable-3"}else if(ch=="'"||ch=='"'&&support.doubleQuote){state.tokenize=tokenLiteral(ch);return state.tokenize(stream,state)}else if((support.nCharCast&&(ch=="n"||ch=="N")||support.charsetCast&&ch=="_"&&stream.match(/[a-z][a-z0-9]*/i))&&(stream.peek()=="'"||stream.peek()=='"')){return"keyword"}else if(/^[\(\),\;\[\]]/.test(ch)){return null}else if(support.commentSlashSlash&&ch=="/"&&stream.eat("/")){stream.skipToEnd();return"comment"}else if(support.commentHash&&ch=="#"||ch=="-"&&stream.eat("-")&&(!support.commentSpaceRequired||stream.eat(" "))){stream.skipToEnd();return"comment"}else if(ch=="/"&&stream.eat("*")){state.tokenize=tokenComment(1);return state.tokenize(stream,state)}else if(ch=="."){if(support.zerolessFloat&&stream.match(/^(?:\d+(?:e[+-]?\d+)?)/i)){return"number"}if(support.ODBCdotTable&&stream.match(/^[a-zA-Z_]+/)){return"variable-2"}}else if(operatorChars.test(ch)){stream.eatWhile(operatorChars);return null}else if(ch=="{"&&(stream.match(/^( )*(d|D|t|T|ts|TS)( )*'[^']*'( )*}/)||stream.match(/^( )*(d|D|t|T|ts|TS)( )*"[^"]*"( )*}/))){return"number"}else{stream.eatWhile(/^[_\w\d]/);var word=stream.current().toLowerCase();if(dateSQL.hasOwnProperty(word)&&(stream.match(/^( )+'[^']*'/)||stream.match(/^( )+"[^"]*"/)))return"number";if(atoms.hasOwnProperty(word))return"atom";if(builtin.hasOwnProperty(word))return"builtin";if(keywords.hasOwnProperty(word))return"keyword";if(client.hasOwnProperty(word))return"string-2";return null}}function tokenLiteral(quote){return function(stream,state){var escaped=false,ch;while((ch=stream.next())!=null){if(ch==quote&&!escaped){state.tokenize=tokenBase;break}escaped=!escaped&&ch=="\\"}return"string"}}function tokenComment(depth){return function(stream,state){var m=stream.match(/^.*?(\/\*|\*\/)/);if(!m)stream.skipToEnd();else if(m[1]=="/*")state.tokenize=tokenComment(depth+1);else if(depth>1)state.tokenize=tokenComment(depth-1);else state.tokenize=tokenBase;return"comment"}}function pushContext(stream,state,type){state.context={prev:state.context,indent:stream.indentation(),col:stream.column(),type:type}}function popContext(state){state.indent=state.context.indent;state.context=state.context.prev}return{startState:function(){return{tokenize:tokenBase,context:null}},token:function(stream,state){if(stream.sol()){if(state.context&&state.context.align==null)state.context.align=false}if(state.tokenize==tokenBase&&stream.eatSpace())return null;var style=state.tokenize(stream,state);if(style=="comment")return style;if(state.context&&state.context.align==null)state.context.align=true;var tok=stream.current();if(tok=="(")pushContext(stream,state,")");else if(tok=="[")pushContext(stream,state,"]");else if(state.context&&state.context.type==tok)popContext(state);return style},indent:function(state,textAfter){var cx=state.context;if(!cx)return CodeMirror.Pass;var closing=textAfter.charAt(0)==cx.type;if(cx.align)return cx.col+(closing?0:1);else return cx.indent+(closing?0:config.indentUnit)},blockCommentStart:"/*",blockCommentEnd:"*/",lineComment:support.commentSlashSlash?"//":support.commentHash?"#":null}});(function(){"use strict";function hookIdentifier(stream){var ch;while((ch=stream.next())!=null){if(ch=="`"&&!stream.eat("`"))return"variable-2"}stream.backUp(stream.current().length-1);return stream.eatWhile(/\w/)?"variable-2":null}function hookIdentifierDoublequote(stream){var ch;while((ch=stream.next())!=null){if(ch=='"'&&!stream.eat('"'))return"variable-2"}stream.backUp(stream.current().length-1);return stream.eatWhile(/\w/)?"variable-2":null}function hookVar(stream){if(stream.eat("@")){stream.match(/^session\./);stream.match(/^local\./);stream.match(/^global\./)}if(stream.eat("'")){stream.match(/^.*'/);return"variable-2"}else if(stream.eat('"')){stream.match(/^.*"/);return"variable-2"}else if(stream.eat("`")){stream.match(/^.*`/);return"variable-2"}else if(stream.match(/^[0-9a-zA-Z$\.\_]+/)){return"variable-2"}return null}function hookClient(stream){if(stream.eat("N")){return"atom"}return stream.match(/^[a-zA-Z.#!?]/)?"variable-2":null}var sqlKeywords="alter and as asc between by count create delete desc distinct drop from group having in insert into is join like not on or order select set table union update values where limit ";function set(str){var obj={},words=str.split(" ");for(var i=0;i<words.length;++i)obj[words[i]]=true;return obj}CodeMirror.defineMIME("text/x-sql",{name:"sql",keywords:set(sqlKeywords+"begin"),builtin:set("bool boolean bit blob enum long longblob longtext medium mediumblob mediumint mediumtext time timestamp tinyblob tinyint tinytext text bigint int int1 int2 int3 int4 int8 integer float float4 float8 double char varbinary varchar varcharacter precision real date datetime year unsigned signed decimal numeric"),atoms:set("false true null unknown"),operatorChars:/^[*+\-%<>!=]/,dateSQL:set("date time timestamp"),support:set("ODBCdotTable doubleQuote binaryNumber hexNumber")});CodeMirror.defineMIME("text/x-mssql",{name:"sql",client:set("charset clear connect edit ego exit go help nopager notee nowarning pager print prompt quit rehash source status system tee"),keywords:set(sqlKeywords+"begin trigger proc view index for add constraint key primary foreign collate clustered nonclustered declare exec"),builtin:set("bigint numeric bit smallint decimal smallmoney int tinyint money float real char varchar text nchar nvarchar ntext binary varbinary image cursor timestamp hierarchyid uniqueidentifier sql_variant xml table "),atoms:set("false true null unknown"),operatorChars:/^[*+\-%<>!=]/,dateSQL:set("date datetimeoffset datetime2 smalldatetime datetime time"),hooks:{"@":hookVar}});CodeMirror.defineMIME("text/x-mysql",{name:"sql",client:set("charset clear connect edit ego exit go help nopager notee nowarning pager print prompt quit rehash source status system tee"),keywords:set(sqlKeywords+"accessible action add after algorithm all analyze asensitive at authors auto_increment autocommit avg avg_row_length before binary binlog both btree cache call cascade cascaded case catalog_name chain change changed character check checkpoint checksum class_origin client_statistics close coalesce code collate collation collations column columns comment commit committed completion concurrent condition connection consistent constraint contains continue contributors convert cross current current_date current_time current_timestamp current_user cursor data database databases day_hour day_microsecond day_minute day_second deallocate dec declare default delay_key_write delayed delimiter des_key_file describe deterministic dev_pop dev_samp deviance diagnostics directory disable discard distinctrow div dual dumpfile each elseif enable enclosed end ends engine engines enum errors escape escaped even event events every execute exists exit explain extended fast fetch field fields first flush for force foreign found_rows full fulltext function general get global grant grants group group_concat handler hash help high_priority hosts hour_microsecond hour_minute hour_second if ignore ignore_server_ids import index index_statistics infile inner innodb inout insensitive insert_method install interval invoker isolation iterate key keys kill language last leading leave left level limit linear lines list load local localtime localtimestamp lock logs low_priority master master_heartbeat_period master_ssl_verify_server_cert masters match max max_rows maxvalue message_text middleint migrate min min_rows minute_microsecond minute_second mod mode modifies modify mutex mysql_errno natural next no no_write_to_binlog offline offset one online open optimize option optionally out outer outfile pack_keys parser partition partitions password phase plugin plugins prepare preserve prev primary privileges procedure processlist profile profiles purge query quick range read read_write reads real rebuild recover references regexp relaylog release remove rename reorganize repair repeatable replace require resignal restrict resume return returns revoke right rlike rollback rollup row row_format rtree savepoint schedule schema schema_name schemas second_microsecond security sensitive separator serializable server session share show signal slave slow smallint snapshot soname spatial specific sql sql_big_result sql_buffer_result sql_cache sql_calc_found_rows sql_no_cache sql_small_result sqlexception sqlstate sqlwarning ssl start starting starts status std stddev stddev_pop stddev_samp storage straight_join subclass_origin sum suspend table_name table_statistics tables tablespace temporary terminated to trailing transaction trigger triggers truncate uncommitted undo uninstall unique unlock upgrade usage use use_frm user user_resources user_statistics using utc_date utc_time utc_timestamp value variables varying view views warnings when while with work write xa xor year_month zerofill begin do then else loop repeat"),builtin:set("bool boolean bit blob decimal double float long longblob longtext medium mediumblob mediumint mediumtext time timestamp tinyblob tinyint tinytext text bigint int int1 int2 int3 int4 int8 integer float float4 float8 double char varbinary varchar varcharacter precision date datetime year unsigned signed numeric"),atoms:set("false true null unknown"),operatorChars:/^[*+\-%<>!=&|^]/,dateSQL:set("date time timestamp"),support:set("ODBCdotTable decimallessFloat zerolessFloat binaryNumber hexNumber doubleQuote nCharCast charsetCast commentHash commentSpaceRequired"),hooks:{"@":hookVar,"`":hookIdentifier,"\\":hookClient}});CodeMirror.defineMIME("text/x-mariadb",{name:"sql",client:set("charset clear connect edit ego exit go help nopager notee nowarning pager print prompt quit rehash source status system tee"),keywords:set(sqlKeywords+"accessible action add after algorithm all always analyze asensitive at authors auto_increment autocommit avg avg_row_length before binary binlog both btree cache call cascade cascaded case catalog_name chain change changed character check checkpoint checksum class_origin client_statistics close coalesce code collate collation collations column columns comment commit committed completion concurrent condition connection consistent constraint contains continue contributors convert cross current current_date current_time current_timestamp current_user cursor data database databases day_hour day_microsecond day_minute day_second deallocate dec declare default delay_key_write delayed delimiter des_key_file describe deterministic dev_pop dev_samp deviance diagnostics directory disable discard distinctrow div dual dumpfile each elseif enable enclosed end ends engine engines enum errors escape escaped even event events every execute exists exit explain extended fast fetch field fields first flush for force foreign found_rows full fulltext function general generated get global grant grants group groupby_concat handler hard hash help high_priority hosts hour_microsecond hour_minute hour_second if ignore ignore_server_ids import index index_statistics infile inner innodb inout insensitive insert_method install interval invoker isolation iterate key keys kill language last leading leave left level limit linear lines list load local localtime localtimestamp lock logs low_priority master master_heartbeat_period master_ssl_verify_server_cert masters match max max_rows maxvalue message_text middleint migrate min min_rows minute_microsecond minute_second mod mode modifies modify mutex mysql_errno natural next no no_write_to_binlog offline offset one online open optimize option optionally out outer outfile pack_keys parser partition partitions password persistent phase plugin plugins prepare preserve prev primary privileges procedure processlist profile profiles purge query quick range read read_write reads real rebuild recover references regexp relaylog release remove rename reorganize repair repeatable replace require resignal restrict resume return returns revoke right rlike rollback rollup row row_format rtree savepoint schedule schema schema_name schemas second_microsecond security sensitive separator serializable server session share show shutdown signal slave slow smallint snapshot soft soname spatial specific sql sql_big_result sql_buffer_result sql_cache sql_calc_found_rows sql_no_cache sql_small_result sqlexception sqlstate sqlwarning ssl start starting starts status std stddev stddev_pop stddev_samp storage straight_join subclass_origin sum suspend table_name table_statistics tables tablespace temporary terminated to trailing transaction trigger triggers truncate uncommitted undo uninstall unique unlock upgrade usage use use_frm user user_resources user_statistics using utc_date utc_time utc_timestamp value variables varying view views virtual warnings when while with work write xa xor year_month zerofill begin do then else loop repeat"),builtin:set("bool boolean bit blob decimal double float long longblob longtext medium mediumblob mediumint mediumtext time timestamp tinyblob tinyint tinytext text bigint int int1 int2 int3 int4 int8 integer float float4 float8 double char varbinary varchar varcharacter precision date datetime year unsigned signed numeric"),atoms:set("false true null unknown"),operatorChars:/^[*+\-%<>!=&|^]/,dateSQL:set("date time timestamp"),support:set("ODBCdotTable decimallessFloat zerolessFloat binaryNumber hexNumber doubleQuote nCharCast charsetCast commentHash commentSpaceRequired"),hooks:{"@":hookVar,"`":hookIdentifier,"\\":hookClient}});CodeMirror.defineMIME("text/x-sqlite",{name:"sql",client:set("auth backup bail binary changes check clone databases dbinfo dump echo eqp exit explain fullschema headers help import imposter indexes iotrace limit lint load log mode nullvalue once open output print prompt quit read restore save scanstats schema separator session shell show stats system tables testcase timeout timer trace vfsinfo vfslist vfsname width"),keywords:set(sqlKeywords+"abort action add after all analyze attach autoincrement before begin cascade case cast check collate column commit conflict constraint cross current_date current_time current_timestamp database default deferrable deferred detach each else end escape except exclusive exists explain fail for foreign full glob if ignore immediate index indexed initially inner instead intersect isnull key left limit match natural no notnull null of offset outer plan pragma primary query raise recursive references regexp reindex release rename replace restrict right rollback row savepoint temp temporary then to transaction trigger unique using vacuum view virtual when with without"),builtin:set("bool boolean bit blob decimal double float long longblob longtext medium mediumblob mediumint mediumtext time timestamp tinyblob tinyint tinytext text clob bigint int int2 int8 integer float double char varchar date datetime year unsigned signed numeric real"),atoms:set("null current_date current_time current_timestamp"),operatorChars:/^[*+\-%<>!=&|/~]/,dateSQL:set("date time timestamp datetime"),support:set("decimallessFloat zerolessFloat"),identifierQuote:'"',hooks:{"@":hookVar,":":hookVar,"?":hookVar,$:hookVar,'"':hookIdentifierDoublequote,"`":hookIdentifier}});CodeMirror.defineMIME("text/x-cassandra",{name:"sql",client:{},keywords:set("add all allow alter and any apply as asc authorize batch begin by clustering columnfamily compact consistency count create custom delete desc distinct drop each_quorum exists filtering from grant if in index insert into key keyspace keyspaces level limit local_one local_quorum modify nan norecursive nosuperuser not of on one order password permission permissions primary quorum rename revoke schema select set storage superuser table three to token truncate ttl two type unlogged update use user users using values where with writetime"),builtin:set("ascii bigint blob boolean counter decimal double float frozen inet int list map static text timestamp timeuuid tuple uuid varchar varint"),atoms:set("false true infinity NaN"),operatorChars:/^[<>=]/,dateSQL:{},support:set("commentSlashSlash decimallessFloat"),hooks:{}});CodeMirror.defineMIME("text/x-plsql",{name:"sql",client:set("appinfo arraysize autocommit autoprint autorecovery autotrace blockterminator break btitle cmdsep colsep compatibility compute concat copycommit copytypecheck define describe echo editfile embedded escape exec execute feedback flagger flush heading headsep instance linesize lno loboffset logsource long longchunksize markup native newpage numformat numwidth pagesize pause pno recsep recsepchar release repfooter repheader serveroutput shiftinout show showmode size spool sqlblanklines sqlcase sqlcode sqlcontinue sqlnumber sqlpluscompatibility sqlprefix sqlprompt sqlterminator suffix tab term termout time timing trimout trimspool ttitle underline verify version wrap"),keywords:set("abort accept access add all alter and any array arraylen as asc assert assign at attributes audit authorization avg base_table begin between binary_integer body boolean by case cast char char_base check close cluster clusters colauth column comment commit compress connect connected constant constraint crash create current currval cursor data_base database date dba deallocate debugoff debugon decimal declare default definition delay delete desc digits dispose distinct do drop else elseif elsif enable end entry escape exception exception_init exchange exclusive exists exit external fast fetch file for force form from function generic goto grant group having identified if immediate in increment index indexes indicator initial initrans insert interface intersect into is key level library like limited local lock log logging long loop master maxextents maxtrans member minextents minus mislabel mode modify multiset new next no noaudit nocompress nologging noparallel not nowait number_base object of off offline on online only open option or order out package parallel partition pctfree pctincrease pctused pls_integer positive positiven pragma primary prior private privileges procedure public raise range raw read rebuild record ref references refresh release rename replace resource restrict return returning returns reverse revoke rollback row rowid rowlabel rownum rows run savepoint schema segment select separate session set share snapshot some space split sql start statement storage subtype successful synonym tabauth table tables tablespace task terminate then to trigger truncate type union unique unlimited unrecoverable unusable update use using validate value values variable view views when whenever where while with work"),builtin:set("abs acos add_months ascii asin atan atan2 average bfile bfilename bigserial bit blob ceil character chartorowid chr clob concat convert cos cosh count dec decode deref dual dump dup_val_on_index empty error exp false float floor found glb greatest hextoraw initcap instr instrb int integer isopen last_day least length lengthb ln lower lpad ltrim lub make_ref max min mlslabel mod months_between natural naturaln nchar nclob new_time next_day nextval nls_charset_decl_len nls_charset_id nls_charset_name nls_initcap nls_lower nls_sort nls_upper nlssort no_data_found notfound null number numeric nvarchar2 nvl others power rawtohex real reftohex round rowcount rowidtochar rowtype rpad rtrim serial sign signtype sin sinh smallint soundex sqlcode sqlerrm sqrt stddev string substr substrb sum sysdate tan tanh to_char text to_date to_label to_multi_byte to_number to_single_byte translate true trunc uid unlogged upper user userenv varchar varchar2 variance varying vsize xml"),operatorChars:/^[*+\-%<>!=~]/,dateSQL:set("date time timestamp"),support:set("doubleQuote nCharCast zerolessFloat binaryNumber hexNumber")});CodeMirror.defineMIME("text/x-hive",{name:"sql",keywords:set("select alter $elem$ $key$ $value$ add after all analyze and archive as asc before between binary both bucket buckets by cascade case cast change cluster clustered clusterstatus collection column columns comment compute concatenate continue create cross cursor data database databases dbproperties deferred delete delimited desc describe directory disable distinct distribute drop else enable end escaped exclusive exists explain export extended external false fetch fields fileformat first format formatted from full function functions grant group having hold_ddltime idxproperties if import in index indexes inpath inputdriver inputformat insert intersect into is items join keys lateral left like limit lines load local location lock locks mapjoin materialized minus msck no_drop nocompress not of offline on option or order out outer outputdriver outputformat overwrite partition partitioned partitions percent plus preserve procedure purge range rcfile read readonly reads rebuild recordreader recordwriter recover reduce regexp rename repair replace restrict revoke right rlike row schema schemas semi sequencefile serde serdeproperties set shared show show_database sort sorted ssl statistics stored streamtable table tables tablesample tblproperties temporary terminated textfile then tmp to touch transform trigger true unarchive undo union uniquejoin unlock update use using utc utc_tmestamp view when where while with"),builtin:set("bool boolean long timestamp tinyint smallint bigint int float double date datetime unsigned string array struct map uniontype"),atoms:set("false true null unknown"),operatorChars:/^[*+\-%<>!=]/,dateSQL:set("date timestamp"),support:set("ODBCdotTable doubleQuote binaryNumber hexNumber")});CodeMirror.defineMIME("text/x-pgsql",{name:"sql",client:set("source"),keywords:set(sqlKeywords+"a abort abs absent absolute access according action ada add admin after aggregate all allocate also always analyse analyze any are array array_agg array_max_cardinality asensitive assertion assignment asymmetric at atomic attribute attributes authorization avg backward base64 before begin begin_frame begin_partition bernoulli binary bit_length blob blocked bom both breadth c cache call called cardinality cascade cascaded case cast catalog catalog_name ceil ceiling chain characteristics characters character_length character_set_catalog character_set_name character_set_schema char_length check checkpoint class class_origin clob close cluster coalesce cobol collate collation collation_catalog collation_name collation_schema collect column columns column_name command_function command_function_code comment comments commit committed concurrently condition condition_number configuration conflict connect connection connection_name constraint constraints constraint_catalog constraint_name constraint_schema constructor contains content continue control conversion convert copy corr corresponding cost covar_pop covar_samp cross csv cube cume_dist current current_catalog current_date current_default_transform_group current_path current_role current_row current_schema current_time current_timestamp current_transform_group_for_type current_user cursor cursor_name cycle data database datalink datetime_interval_code datetime_interval_precision day db deallocate dec declare default defaults deferrable deferred defined definer degree delimiter delimiters dense_rank depth deref derived describe descriptor deterministic diagnostics dictionary disable discard disconnect dispatch dlnewcopy dlpreviouscopy dlurlcomplete dlurlcompleteonly dlurlcompletewrite dlurlpath dlurlpathonly dlurlpathwrite dlurlscheme dlurlserver dlvalue do document domain dynamic dynamic_function dynamic_function_code each element else empty enable encoding encrypted end end-exec end_frame end_partition enforced enum equals escape event every except exception exclude excluding exclusive exec execute exists exp explain expression extension external extract false family fetch file filter final first first_value flag float floor following for force foreign fortran forward found frame_row free freeze fs full function functions fusion g general generated get global go goto grant granted greatest grouping groups handler header hex hierarchy hold hour id identity if ignore ilike immediate immediately immutable implementation implicit import including increment indent index indexes indicator inherit inherits initially inline inner inout input insensitive instance instantiable instead integrity intersect intersection invoker isnull isolation k key key_member key_type label lag language large last last_value lateral lead leading leakproof least left length level library like_regex link listen ln load local localtime localtimestamp location locator lock locked logged lower m map mapping match matched materialized max maxvalue max_cardinality member merge message_length message_octet_length message_text method min minute minvalue mod mode modifies module month more move multiset mumps name names namespace national natural nchar nclob nesting new next nfc nfd nfkc nfkd nil no none normalize normalized nothing notify notnull nowait nth_value ntile null nullable nullif nulls number object occurrences_regex octets octet_length of off offset oids old only open operator option options ordering ordinality others out outer output over overlaps overlay overriding owned owner p pad parallel parameter parameter_mode parameter_name parameter_ordinal_position parameter_specific_catalog parameter_specific_name parameter_specific_schema parser partial partition pascal passing passthrough password percent percentile_cont percentile_disc percent_rank period permission placing plans pli policy portion position position_regex power precedes preceding prepare prepared preserve primary prior privileges procedural procedure program public quote range rank read reads reassign recheck recovery recursive ref references referencing refresh regr_avgx regr_avgy regr_count regr_intercept regr_r2 regr_slope regr_sxx regr_sxy regr_syy reindex relative release rename repeatable replace replica requiring reset respect restart restore restrict restricted result return returned_cardinality returned_length returned_octet_length returned_sqlstate returning returns revoke right role rollback rollup routine routine_catalog routine_name routine_schema row rows row_count row_number rule savepoint scale schema schema_name scope scope_catalog scope_name scope_schema scroll search second section security selective self sensitive sequence sequences serializable server server_name session session_user setof sets share show similar simple size skip snapshot some source space specific specifictype specific_name sql sqlcode sqlerror sqlexception sqlstate sqlwarning sqrt stable standalone start state statement static statistics stddev_pop stddev_samp stdin stdout storage strict strip structure style subclass_origin submultiset substring substring_regex succeeds sum symmetric sysid system system_time system_user t tables tablesample tablespace table_name temp template temporary then ties timezone_hour timezone_minute to token top_level_count trailing transaction transactions_committed transactions_rolled_back transaction_active transform transforms translate translate_regex translation treat trigger trigger_catalog trigger_name trigger_schema trim trim_array true truncate trusted type types uescape unbounded uncommitted under unencrypted unique unknown unlink unlisten unlogged unnamed unnest until untyped upper uri usage user user_defined_type_catalog user_defined_type_code user_defined_type_name user_defined_type_schema using vacuum valid validate validator value value_of varbinary variadic var_pop var_samp verbose version versioning view views volatile when whenever whitespace width_bucket window within work wrapper write xmlagg xmlattributes xmlbinary xmlcast xmlcomment xmlconcat xmldeclaration xmldocument xmlelement xmlexists xmlforest xmliterate xmlnamespaces xmlparse xmlpi xmlquery xmlroot xmlschema xmlserialize xmltable xmltext xmlvalidate year yes loop repeat attach path depends detach zone"),builtin:set("bigint int8 bigserial serial8 bit varying varbit boolean bool box bytea character char varchar cidr circle date double precision float8 inet integer int int4 interval json jsonb line lseg macaddr macaddr8 money numeric decimal path pg_lsn point polygon real float4 smallint int2 smallserial serial2 serial serial4 text time without zone with timetz timestamp timestamptz tsquery tsvector txid_snapshot uuid xml"),atoms:set("false true null unknown"),operatorChars:/^[*+\-%<>!=&|^\/#@?~]/,dateSQL:set("date time timestamp"),support:set("ODBCdotTable decimallessFloat zerolessFloat binaryNumber hexNumber nCharCast charsetCast")});CodeMirror.defineMIME("text/x-gql",{name:"sql",keywords:set("ancestor and asc by contains desc descendant distinct from group has in is limit offset on order select superset where"),atoms:set("false true"),builtin:set("blob datetime first key __key__ string integer double boolean null"),operatorChars:/^[*+\-%<>!=]/})})()});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.registerHelper("wordChars","r",/[\w.]/);CodeMirror.defineMode("r",function(config){function wordObj(str){var words=str.split(" "),res={};for(var i=0;i<words.length;++i)res[words[i]]=true;return res}var atoms=wordObj("NULL NA Inf NaN NA_integer_ NA_real_ NA_complex_ NA_character_");var builtins=wordObj("list quote bquote eval return call parse deparse");var keywords=wordObj("if else repeat while function for in next break");var blockkeywords=wordObj("if else repeat while function for");var opChars=/[+\-*\/^<>=!&|~$:]/;var curPunc;function tokenBase(stream,state){curPunc=null;var ch=stream.next();if(ch=="#"){stream.skipToEnd();return"comment"}else if(ch=="0"&&stream.eat("x")){stream.eatWhile(/[\da-f]/i);return"number"}else if(ch=="."&&stream.eat(/\d/)){stream.match(/\d*(?:e[+\-]?\d+)?/);return"number"}else if(/\d/.test(ch)){stream.match(/\d*(?:\.\d+)?(?:e[+\-]\d+)?L?/);return"number"}else if(ch=="'"||ch=='"'){state.tokenize=tokenString(ch);return"string"}else if(ch=="`"){stream.match(/[^`]+`/);return"variable-3"}else if(ch=="."&&stream.match(/.[.\d]+/)){return"keyword"}else if(/[\w\.]/.test(ch)&&ch!="_"){stream.eatWhile(/[\w\.]/);var word=stream.current();if(atoms.propertyIsEnumerable(word))return"atom";if(keywords.propertyIsEnumerable(word)){if(blockkeywords.propertyIsEnumerable(word)&&!stream.match(/\s*if(\s+|$)/,false))curPunc="block";return"keyword"}if(builtins.propertyIsEnumerable(word))return"builtin";return"variable"}else if(ch=="%"){if(stream.skipTo("%"))stream.next();return"operator variable-2"}else if(ch=="<"&&stream.eat("-")||ch=="<"&&stream.match("<-")||ch=="-"&&stream.match(/>>?/)){return"operator arrow"}else if(ch=="="&&state.ctx.argList){return"arg-is"}else if(opChars.test(ch)){if(ch=="$")return"operator dollar";stream.eatWhile(opChars);return"operator"}else if(/[\(\){}\[\];]/.test(ch)){curPunc=ch;if(ch==";")return"semi";return null}else{return null}}function tokenString(quote){return function(stream,state){if(stream.eat("\\")){var ch=stream.next();if(ch=="x")stream.match(/^[a-f0-9]{2}/i);else if((ch=="u"||ch=="U")&&stream.eat("{")&&stream.skipTo("}"))stream.next();else if(ch=="u")stream.match(/^[a-f0-9]{4}/i);else if(ch=="U")stream.match(/^[a-f0-9]{8}/i);else if(/[0-7]/.test(ch))stream.match(/^[0-7]{1,2}/);return"string-2"}else{var next;while((next=stream.next())!=null){if(next==quote){state.tokenize=tokenBase;break}if(next=="\\"){stream.backUp(1);break}}return"string"}}}var ALIGN_YES=1,ALIGN_NO=2,BRACELESS=4;function push(state,type,stream){state.ctx={type:type,indent:state.indent,flags:0,column:stream.column(),prev:state.ctx}}function setFlag(state,flag){var ctx=state.ctx;state.ctx={type:ctx.type,indent:ctx.indent,flags:ctx.flags|flag,column:ctx.column,prev:ctx.prev}}function pop(state){state.indent=state.ctx.indent;state.ctx=state.ctx.prev}return{startState:function(){return{tokenize:tokenBase,ctx:{type:"top",indent:-config.indentUnit,flags:ALIGN_NO},indent:0,afterIdent:false}},token:function(stream,state){if(stream.sol()){if((state.ctx.flags&3)==0)state.ctx.flags|=ALIGN_NO;if(state.ctx.flags&BRACELESS)pop(state);state.indent=stream.indentation()}if(stream.eatSpace())return null;var style=state.tokenize(stream,state);if(style!="comment"&&(state.ctx.flags&ALIGN_NO)==0)setFlag(state,ALIGN_YES);if((curPunc==";"||curPunc=="{"||curPunc=="}")&&state.ctx.type=="block")pop(state);if(curPunc=="{")push(state,"}",stream);else if(curPunc=="("){push(state,")",stream);if(state.afterIdent)state.ctx.argList=true}else if(curPunc=="[")push(state,"]",stream);else if(curPunc=="block")push(state,"block",stream);else if(curPunc==state.ctx.type)pop(state);else if(state.ctx.type=="block"&&style!="comment")setFlag(state,BRACELESS);state.afterIdent=style=="variable"||style=="keyword";return style},indent:function(state,textAfter){if(state.tokenize!=tokenBase)return 0;var firstChar=textAfter&&textAfter.charAt(0),ctx=state.ctx,closing=firstChar==ctx.type;if(ctx.flags&BRACELESS)ctx=ctx.prev;if(ctx.type=="block")return ctx.indent+(firstChar=="{"?0:config.indentUnit);else if(ctx.flags&ALIGN_YES)return ctx.column+(closing?0:1);else return ctx.indent+(closing?0:config.indentUnit)},lineComment:"#"}});CodeMirror.defineMIME("text/x-rsrc","r")});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineMode("julia",function(config,parserConf){function wordRegexp(words,end){if(typeof end==="undefined"){end="\\b"}return new RegExp("^(("+words.join(")|(")+"))"+end)}var octChar="\\\\[0-7]{1,3}";var hexChar="\\\\x[A-Fa-f0-9]{1,2}";var sChar="\\\\[abefnrtv0%?'\"\\\\]";var uChar="([^\\u0027\\u005C\\uD800-\\uDFFF]|[\\uD800-\\uDFFF][\\uDC00-\\uDFFF])";var operators=parserConf.operators||wordRegexp(["\\.?[\\\\%*+\\-<>!=\\/^]=?","\\.?[|&\\u00F7\\u2260\\u2264\\u2265]","\\u00D7","\\u2208","\\u2209","\\u220B","\\u220C","\\u2229","\\u222A","\\u2286","\\u2288","\\u228A","\\u22c5","\\?","~",":","\\$","\\.[<>]","<<=?",">>>?=?","\\.[<>=]=","->?","\\/\\/","=>","<:","\\bin\\b(?!\\()"],"");var delimiters=parserConf.delimiters||/^[;,()[\]{}]/;var identifiers=parserConf.identifiers||/^[_A-Za-z\u00A1-\uFFFF][\w\u00A1-\uFFFF]*!*/;var chars=wordRegexp([octChar,hexChar,sChar,uChar],"'");var openers=wordRegexp(["begin","function","type","immutable","let","macro","for","while","quote","if","else","elseif","try","finally","catch","do"]);var closers=wordRegexp(["end","else","elseif","catch","finally"]);var keywords=wordRegexp(["if","else","elseif","while","for","begin","let","end","do","try","catch","finally","return","break","continue","global","local","const","export","import","importall","using","function","macro","module","baremodule","type","immutable","quote","typealias","abstract","bitstype"]);var builtins=wordRegexp(["true","false","nothing","NaN","Inf"]);var macro=/^@[_A-Za-z][\w]*/;var symbol=/^:[_A-Za-z\u00A1-\uFFFF][\w\u00A1-\uFFFF]*!*/;var stringPrefixes=/^(`|([_A-Za-z\u00A1-\uFFFF]*"("")?))/;function inArray(state){return inGenerator(state,"[")}function inGenerator(state,bracket){var curr=currentScope(state),prev=currentScope(state,1);if(typeof bracket==="undefined"){bracket="("}if(curr===bracket||prev===bracket&&curr==="for"){return true}return false}function currentScope(state,n){if(typeof n==="undefined"){n=0}if(state.scopes.length<=n){return null}return state.scopes[state.scopes.length-(n+1)]}function tokenBase(stream,state){if(stream.match(/^#=/,false)){state.tokenize=tokenComment;return state.tokenize(stream,state)}var leavingExpr=state.leavingExpr;if(stream.sol()){leavingExpr=false}state.leavingExpr=false;if(leavingExpr){if(stream.match(/^'+/)){return"operator"}}if(stream.match(/^\.{2,3}/)){return"operator"}if(stream.eatSpace()){return null}var ch=stream.peek();if(ch==="#"){stream.skipToEnd();return"comment"}if(ch==="["){state.scopes.push("[")}if(ch==="("){state.scopes.push("(")}var scope=currentScope(state);if(inArray(state)&&ch==="]"){if(scope==="for"){state.scopes.pop()}state.scopes.pop();state.leavingExpr=true}if(inGenerator(state)&&ch===")"){if(scope==="for"){state.scopes.pop()}state.scopes.pop();state.leavingExpr=true}var match;if(match=stream.match(openers,false)){state.scopes.push(match[0])}if(stream.match(closers,false)){state.scopes.pop()}if(inArray(state)){if(state.lastToken=="end"&&stream.match(/^:/)){return"operator"}if(stream.match(/^end/)){return"number"}}if(stream.match(/^::(?![:\$])/)){state.tokenize=tokenAnnotation;return state.tokenize(stream,state)}if(!leavingExpr&&stream.match(symbol)||stream.match(/:\./)){return"builtin"}if(stream.match(/^{[^}]*}(?=\()/)){return"builtin"}if(stream.match(operators)){return"operator"}if(stream.match(/^[0-9\.]/,false)){var imMatcher=RegExp(/^im\b/);var numberLiteral=false;if(stream.match(/^\d*\.(?!\.)\d*([Eef][\+\-]?\d+)?/i)){numberLiteral=true}if(stream.match(/^\d+\.(?!\.)\d*/)){numberLiteral=true}if(stream.match(/^\.\d+/)){numberLiteral=true}if(stream.match(/^0x\.[0-9a-f]+p[\+\-]?\d+/i)){numberLiteral=true}if(stream.match(/^0x[0-9a-f]+/i)){numberLiteral=true}if(stream.match(/^0b[01]+/i)){numberLiteral=true}if(stream.match(/^0o[0-7]+/i)){numberLiteral=true}if(stream.match(/^[1-9]\d*(e[\+\-]?\d+)?/)){numberLiteral=true}if(stream.match(/^0(?![\dx])/i)){numberLiteral=true}if(numberLiteral){stream.match(imMatcher);state.leavingExpr=true;return"number"}}if(stream.match(/^'/)){state.tokenize=tokenChar;return state.tokenize(stream,state)}if(stream.match(stringPrefixes)){state.tokenize=tokenStringFactory(stream.current());return state.tokenize(stream,state)}if(stream.match(macro)){return"meta"}if(stream.match(delimiters)){return null}if(stream.match(keywords)){return"keyword"}if(stream.match(builtins)){return"builtin"}var isDefinition=state.isDefinition||state.lastToken=="function"||state.lastToken=="macro"||state.lastToken=="type"||state.lastToken=="immutable";if(stream.match(identifiers)){if(isDefinition){if(stream.peek()==="."){state.isDefinition=true;return"variable"}state.isDefinition=false;return"def"}if(stream.match(/^({[^}]*})*\(/,false)){return callOrDef(stream,state)}state.leavingExpr=true;return"variable"}stream.next();return"error"}function callOrDef(stream,state){var match=stream.match(/^(\(\s*)/);if(match){if(state.firstParenPos<0)state.firstParenPos=state.scopes.length;state.scopes.push("(");state.charsAdvanced+=match[1].length}if(currentScope(state)=="("&&stream.match(/^\)/)){state.scopes.pop();state.charsAdvanced+=1;if(state.scopes.length<=state.firstParenPos){var isDefinition=stream.match(/^\s*?=(?!=)/,false);stream.backUp(state.charsAdvanced);state.firstParenPos=-1;state.charsAdvanced=0;if(isDefinition)return"def";return"builtin"}}if(stream.match(/^$/g,false)){stream.backUp(state.charsAdvanced);while(state.scopes.length>state.firstParenPos)state.scopes.pop();state.firstParenPos=-1;state.charsAdvanced=0;return"builtin"}state.charsAdvanced+=stream.match(/^([^()]*)/)[1].length;return callOrDef(stream,state)}function tokenAnnotation(stream,state){stream.match(/.*?(?=,|;|{|}|\(|\)|=|$|\s)/);if(stream.match(/^{/)){state.nestedLevels++}else if(stream.match(/^}/)){state.nestedLevels--}if(state.nestedLevels>0){stream.match(/.*?(?={|})/)||stream.next()}else if(state.nestedLevels==0){state.tokenize=tokenBase}return"builtin"}function tokenComment(stream,state){if(stream.match(/^#=/)){state.nestedLevels++}if(!stream.match(/.*?(?=(#=|=#))/)){stream.skipToEnd()}if(stream.match(/^=#/)){state.nestedLevels--;if(state.nestedLevels==0)state.tokenize=tokenBase}return"comment"}function tokenChar(stream,state){var isChar=false,match;if(stream.match(chars)){isChar=true}else if(match=stream.match(/\\u([a-f0-9]{1,4})(?=')/i)){var value=parseInt(match[1],16);if(value<=55295||value>=57344){isChar=true;stream.next()}}else if(match=stream.match(/\\U([A-Fa-f0-9]{5,8})(?=')/)){var value=parseInt(match[1],16);if(value<=1114111){isChar=true;stream.next()}}if(isChar){state.leavingExpr=true;state.tokenize=tokenBase;return"string"}if(!stream.match(/^[^']+(?=')/)){stream.skipToEnd()}if(stream.match(/^'/)){state.tokenize=tokenBase}return"error"}function tokenStringFactory(delimiter){if(delimiter.substr(-3)==='"""'){delimiter='"""'}else if(delimiter.substr(-1)==='"'){delimiter='"'}function tokenString(stream,state){if(stream.eat("\\")){stream.next()}else if(stream.match(delimiter)){state.tokenize=tokenBase;state.leavingExpr=true;return"string"}else{stream.eat(/[`"]/)}stream.eatWhile(/[^\\`"]/);return"string"}return tokenString}var external={startState:function(){return{tokenize:tokenBase,scopes:[],lastToken:null,leavingExpr:false,isDefinition:false,nestedLevels:0,charsAdvanced:0,firstParenPos:-1}},token:function(stream,state){var style=state.tokenize(stream,state);var current=stream.current();if(current&&style){state.lastToken=current}if(current==="."){style=stream.match(identifiers,false)||stream.match(macro,false)||stream.match(/\(/,false)?"operator":"error"}return style},indent:function(state,textAfter){var delta=0;if(textAfter==="]"||textAfter===")"||textAfter==="end"||textAfter==="else"||textAfter==="catch"||textAfter==="elseif"||textAfter==="finally"){delta=-1}return(state.scopes.length+delta)*config.indentUnit},electricInput:/\b(end|else|catch|finally)\b/,blockCommentStart:"#=",blockCommentEnd:"=#",lineComment:"#",fold:"indent"};return external});CodeMirror.defineMIME("text/x-julia","julia")});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function wordRegexp(words){return new RegExp("^(("+words.join(")|(")+"))\\b")}var wordOperators=wordRegexp(["and","or","not","is"]);var commonKeywords=["as","assert","break","class","continue","def","del","elif","else","except","finally","for","from","global","if","import","lambda","pass","raise","return","try","while","with","yield","in"];var commonBuiltins=["abs","all","any","bin","bool","bytearray","callable","chr","classmethod","compile","complex","delattr","dict","dir","divmod","enumerate","eval","filter","float","format","frozenset","getattr","globals","hasattr","hash","help","hex","id","input","int","isinstance","issubclass","iter","len","list","locals","map","max","memoryview","min","next","object","oct","open","ord","pow","property","range","repr","reversed","round","set","setattr","slice","sorted","staticmethod","str","sum","super","tuple","type","vars","zip","__import__","NotImplemented","Ellipsis","__debug__"];CodeMirror.registerHelper("hintWords","python",commonKeywords.concat(commonBuiltins));function top(state){return state.scopes[state.scopes.length-1]}CodeMirror.defineMode("python",function(conf,parserConf){var ERRORCLASS="error";var singleDelimiters=parserConf.singleDelimiters||/^[\(\)\[\]\{\}@,:`=;\.]/;var doubleOperators=parserConf.doubleOperators||/^([!<>]==|<>|<<|>>|\/\/|\*\*)/;var doubleDelimiters=parserConf.doubleDelimiters||/^(\+=|\-=|\*=|%=|\/=|&=|\|=|\^=)/;var tripleDelimiters=parserConf.tripleDelimiters||/^(\/\/=|>>=|<<=|\*\*=)/;var hangingIndent=parserConf.hangingIndent||conf.indentUnit;var myKeywords=commonKeywords,myBuiltins=commonBuiltins;if(parserConf.extra_keywords!=undefined)myKeywords=myKeywords.concat(parserConf.extra_keywords);if(parserConf.extra_builtins!=undefined)myBuiltins=myBuiltins.concat(parserConf.extra_builtins);var py3=!(parserConf.version&&Number(parserConf.version)<3);if(py3){var singleOperators=parserConf.singleOperators||/^[\+\-\*\/%&|\^~<>!@]/;var identifiers=parserConf.identifiers||/^[_A-Za-z\u00A1-\uFFFF][_A-Za-z0-9\u00A1-\uFFFF]*/;myKeywords=myKeywords.concat(["nonlocal","False","True","None","async","await"]);myBuiltins=myBuiltins.concat(["ascii","bytes","exec","print"]);var stringPrefixes=new RegExp("^(([rbuf]|(br))?('{3}|\"{3}|['\"]))","i")}else{var singleOperators=parserConf.singleOperators||/^[\+\-\*\/%&|\^~<>!]/;var identifiers=parserConf.identifiers||/^[_A-Za-z][_A-Za-z0-9]*/;myKeywords=myKeywords.concat(["exec","print"]);myBuiltins=myBuiltins.concat(["apply","basestring","buffer","cmp","coerce","execfile","file","intern","long","raw_input","reduce","reload","unichr","unicode","xrange","False","True","None"]);var stringPrefixes=new RegExp("^(([rubf]|(ur)|(br))?('{3}|\"{3}|['\"]))","i")}var keywords=wordRegexp(myKeywords);var builtins=wordRegexp(myBuiltins);function tokenBase(stream,state){if(stream.sol())state.indent=stream.indentation();if(stream.sol()&&top(state).type=="py"){var scopeOffset=top(state).offset;if(stream.eatSpace()){var lineOffset=stream.indentation();if(lineOffset>scopeOffset)pushPyScope(state);else if(lineOffset<scopeOffset&&dedent(stream,state)&&stream.peek()!="#")state.errorToken=true;return null}else{var style=tokenBaseInner(stream,state);if(scopeOffset>0&&dedent(stream,state))style+=" "+ERRORCLASS;return style}}return tokenBaseInner(stream,state)}function tokenBaseInner(stream,state){if(stream.eatSpace())return null;var ch=stream.peek();if(ch=="#"){stream.skipToEnd();return"comment"}if(stream.match(/^[0-9\.]/,false)){var floatLiteral=false;if(stream.match(/^[\d_]*\.\d+(e[\+\-]?\d+)?/i)){floatLiteral=true}if(stream.match(/^[\d_]+\.\d*/)){floatLiteral=true}if(stream.match(/^\.\d+/)){floatLiteral=true}if(floatLiteral){stream.eat(/J/i);return"number"}var intLiteral=false;if(stream.match(/^0x[0-9a-f_]+/i))intLiteral=true;if(stream.match(/^0b[01_]+/i))intLiteral=true;if(stream.match(/^0o[0-7_]+/i))intLiteral=true;if(stream.match(/^[1-9][\d_]*(e[\+\-]?[\d_]+)?/)){stream.eat(/J/i);intLiteral=true}if(stream.match(/^0(?![\dx])/i))intLiteral=true;if(intLiteral){stream.eat(/L/i);return"number"}}if(stream.match(stringPrefixes)){state.tokenize=tokenStringFactory(stream.current());return state.tokenize(stream,state)}if(stream.match(tripleDelimiters)||stream.match(doubleDelimiters))return"punctuation";if(stream.match(doubleOperators)||stream.match(singleOperators))return"operator";if(stream.match(singleDelimiters))return"punctuation";if(state.lastToken=="."&&stream.match(identifiers))return"property";if(stream.match(keywords)||stream.match(wordOperators))return"keyword";if(stream.match(builtins))return"builtin";if(stream.match(/^(self|cls)\b/))return"variable-2";if(stream.match(identifiers)){if(state.lastToken=="def"||state.lastToken=="class")return"def";return"variable"}stream.next();return ERRORCLASS}function tokenStringFactory(delimiter){while("rubf".indexOf(delimiter.charAt(0).toLowerCase())>=0)delimiter=delimiter.substr(1);var singleline=delimiter.length==1;var OUTCLASS="string";function tokenString(stream,state){while(!stream.eol()){stream.eatWhile(/[^'"\\]/);if(stream.eat("\\")){stream.next();if(singleline&&stream.eol())return OUTCLASS}else if(stream.match(delimiter)){state.tokenize=tokenBase;return OUTCLASS}else{stream.eat(/['"]/)}}if(singleline){if(parserConf.singleLineStringErrors)return ERRORCLASS;else state.tokenize=tokenBase}return OUTCLASS}tokenString.isString=true;return tokenString}function pushPyScope(state){while(top(state).type!="py")state.scopes.pop();state.scopes.push({offset:top(state).offset+conf.indentUnit,type:"py",align:null})}function pushBracketScope(stream,state,type){var align=stream.match(/^([\s\[\{\(]|#.*)*$/,false)?null:stream.column()+1;state.scopes.push({offset:state.indent+hangingIndent,type:type,align:align})}function dedent(stream,state){var indented=stream.indentation();while(state.scopes.length>1&&top(state).offset>indented){if(top(state).type!="py")return true;state.scopes.pop()}return top(state).offset!=indented}function tokenLexer(stream,state){if(stream.sol())state.beginningOfLine=true;var style=state.tokenize(stream,state);var current=stream.current();if(state.beginningOfLine&&current=="@")return stream.match(identifiers,false)?"meta":py3?"operator":ERRORCLASS;if(/\S/.test(current))state.beginningOfLine=false;if((style=="variable"||style=="builtin")&&state.lastToken=="meta")style="meta";if(current=="pass"||current=="return")state.dedent+=1;if(current=="lambda")state.lambda=true;if(current==":"&&!state.lambda&&top(state).type=="py")pushPyScope(state);var delimiter_index=current.length==1?"[({".indexOf(current):-1;if(delimiter_index!=-1)pushBracketScope(stream,state,"])}".slice(delimiter_index,delimiter_index+1));delimiter_index="])}".indexOf(current);if(delimiter_index!=-1){if(top(state).type==current)state.indent=state.scopes.pop().offset-hangingIndent;else return ERRORCLASS}if(state.dedent>0&&stream.eol()&&top(state).type=="py"){if(state.scopes.length>1)state.scopes.pop();state.dedent-=1}return style}var external={startState:function(basecolumn){return{tokenize:tokenBase,scopes:[{offset:basecolumn||0,type:"py",align:null}],indent:basecolumn||0,lastToken:null,lambda:false,dedent:0}},token:function(stream,state){var addErr=state.errorToken;if(addErr)state.errorToken=false;var style=tokenLexer(stream,state);if(style&&style!="comment")state.lastToken=style=="keyword"||style=="punctuation"?stream.current():style;if(style=="punctuation")style=null;if(stream.eol()&&state.lambda)state.lambda=false;return addErr?style+" "+ERRORCLASS:style},indent:function(state,textAfter){if(state.tokenize!=tokenBase)return state.tokenize.isString?CodeMirror.Pass:0;var scope=top(state),closing=scope.type==textAfter.charAt(0);if(scope.align!=null)return scope.align-(closing?1:0);else return scope.offset-(closing?hangingIndent:0)},electricInput:/^\s*[\}\]\)]$/,closeBrackets:{triples:"'\""},lineComment:"#",fold:"indent"};return external});CodeMirror.defineMIME("text/x-python","python");var words=function(str){return str.split(" ")};CodeMirror.defineMIME("text/x-cython",{name:"python",extra_keywords:words("by cdef cimport cpdef ctypedef enum except "+"extern gil include nogil property public "+"readonly struct union DEF IF ELIF ELSE")})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function expressionAllowed(stream,state,backUp){return/^(?:operator|sof|keyword c|case|new|export|default|[\[{}\(,;:]|=>)$/.test(state.lastType)||state.lastType=="quasi"&&/\{\s*$/.test(stream.string.slice(0,stream.pos-(backUp||0)))}CodeMirror.defineMode("javascript",function(config,parserConfig){var indentUnit=config.indentUnit;var statementIndent=parserConfig.statementIndent;var jsonldMode=parserConfig.jsonld;var jsonMode=parserConfig.json||jsonldMode;var isTS=parserConfig.typescript;var wordRE=parserConfig.wordCharacters||/[\w$\xa1-\uffff]/;var keywords=function(){function kw(type){return{type:type,style:"keyword"}}var A=kw("keyword a"),B=kw("keyword b"),C=kw("keyword c");var operator=kw("operator"),atom={type:"atom",style:"atom"};var jsKeywords={if:kw("if"),while:A,with:A,else:B,do:B,try:B,finally:B,return:C,break:C,continue:C,new:kw("new"),delete:C,throw:C,debugger:C,var:kw("var"),const:kw("var"),let:kw("var"),function:kw("function"),catch:kw("catch"),for:kw("for"),switch:kw("switch"),case:kw("case"),default:kw("default"),in:operator,typeof:operator,instanceof:operator,true:atom,false:atom,null:atom,undefined:atom,NaN:atom,Infinity:atom,this:kw("this"),class:kw("class"),super:kw("atom"),yield:C,export:kw("export"),import:kw("import"),extends:C,await:C};if(isTS){var type={type:"variable",style:"type"};var tsKeywords={interface:kw("class"),implements:C,namespace:C,module:kw("module"),enum:kw("module"),public:kw("modifier"),private:kw("modifier"),protected:kw("modifier"),abstract:kw("modifier"),string:type,number:type,boolean:type,any:type};for(var attr in tsKeywords){jsKeywords[attr]=tsKeywords[attr]}}return jsKeywords}();var isOperatorChar=/[+\-*&%=<>!?|~^@]/;var isJsonldKeyword=/^@(context|id|value|language|type|container|list|set|reverse|index|base|vocab|graph)"/;function readRegexp(stream){var escaped=false,next,inSet=false;while((next=stream.next())!=null){if(!escaped){if(next=="/"&&!inSet)return;if(next=="[")inSet=true;else if(inSet&&next=="]")inSet=false}escaped=!escaped&&next=="\\"}}var type,content;function ret(tp,style,cont){type=tp;content=cont;return style}function tokenBase(stream,state){var ch=stream.next();if(ch=='"'||ch=="'"){state.tokenize=tokenString(ch);return state.tokenize(stream,state)}else if(ch=="."&&stream.match(/^\d+(?:[eE][+\-]?\d+)?/)){return ret("number","number")}else if(ch=="."&&stream.match("..")){return ret("spread","meta")}else if(/[\[\]{}\(\),;\:\.]/.test(ch)){return ret(ch)}else if(ch=="="&&stream.eat(">")){return ret("=>","operator")}else if(ch=="0"&&stream.eat(/x/i)){stream.eatWhile(/[\da-f]/i);return ret("number","number")}else if(ch=="0"&&stream.eat(/o/i)){stream.eatWhile(/[0-7]/i);return ret("number","number")}else if(ch=="0"&&stream.eat(/b/i)){stream.eatWhile(/[01]/i);return ret("number","number")}else if(/\d/.test(ch)){stream.match(/^\d*(?:\.\d*)?(?:[eE][+\-]?\d+)?/);return ret("number","number")}else if(ch=="/"){if(stream.eat("*")){state.tokenize=tokenComment;return tokenComment(stream,state)}else if(stream.eat("/")){stream.skipToEnd();return ret("comment","comment")}else if(expressionAllowed(stream,state,1)){readRegexp(stream);stream.match(/^\b(([gimyu])(?![gimyu]*\2))+\b/);return ret("regexp","string-2")}else{stream.eatWhile(isOperatorChar);return ret("operator","operator",stream.current())}}else if(ch=="`"){state.tokenize=tokenQuasi;return tokenQuasi(stream,state)}else if(ch=="#"){stream.skipToEnd();return ret("error","error")}else if(isOperatorChar.test(ch)){if(ch!=">"||!state.lexical||state.lexical.type!=">")stream.eatWhile(isOperatorChar);return ret("operator","operator",stream.current())}else if(wordRE.test(ch)){stream.eatWhile(wordRE);var word=stream.current();if(state.lastType!="."){if(keywords.propertyIsEnumerable(word)){var kw=keywords[word];return ret(kw.type,kw.style,word)}if(word=="async"&&stream.match(/^\s*[\(\w]/,false))return ret("async","keyword",word)}return ret("variable","variable",word)}}function tokenString(quote){return function(stream,state){var escaped=false,next;if(jsonldMode&&stream.peek()=="@"&&stream.match(isJsonldKeyword)){state.tokenize=tokenBase;return ret("jsonld-keyword","meta")}while((next=stream.next())!=null){if(next==quote&&!escaped)break;escaped=!escaped&&next=="\\"}if(!escaped)state.tokenize=tokenBase;return ret("string","string")}}function tokenComment(stream,state){var maybeEnd=false,ch;while(ch=stream.next()){if(ch=="/"&&maybeEnd){state.tokenize=tokenBase;break}maybeEnd=ch=="*"}return ret("comment","comment")}function tokenQuasi(stream,state){var escaped=false,next;while((next=stream.next())!=null){if(!escaped&&(next=="`"||next=="$"&&stream.eat("{"))){state.tokenize=tokenBase;break}escaped=!escaped&&next=="\\"}return ret("quasi","string-2",stream.current())}var brackets="([{}])";function findFatArrow(stream,state){if(state.fatArrowAt)state.fatArrowAt=null;var arrow=stream.string.indexOf("=>",stream.start);if(arrow<0)return;if(isTS){var m=/:\s*(?:\w+(?:<[^>]*>|\[\])?|\{[^}]*\})\s*$/.exec(stream.string.slice(stream.start,arrow));if(m)arrow=m.index}var depth=0,sawSomething=false;for(var pos=arrow-1;pos>=0;--pos){var ch=stream.string.charAt(pos);var bracket=brackets.indexOf(ch);if(bracket>=0&&bracket<3){if(!depth){++pos;break}if(--depth==0){if(ch=="(")sawSomething=true;break}}else if(bracket>=3&&bracket<6){++depth}else if(wordRE.test(ch)){sawSomething=true}else if(/["'\/]/.test(ch)){return}else if(sawSomething&&!depth){++pos;break}}if(sawSomething&&!depth)state.fatArrowAt=pos}var atomicTypes={atom:true,number:true,variable:true,string:true,regexp:true,this:true,"jsonld-keyword":true};function JSLexical(indented,column,type,align,prev,info){this.indented=indented;this.column=column;this.type=type;this.prev=prev;this.info=info;if(align!=null)this.align=align}function inScope(state,varname){for(var v=state.localVars;v;v=v.next)if(v.name==varname)return true;for(var cx=state.context;cx;cx=cx.prev){for(var v=cx.vars;v;v=v.next)if(v.name==varname)return true}}function parseJS(state,style,type,content,stream){var cc=state.cc;cx.state=state;cx.stream=stream;cx.marked=null,cx.cc=cc;cx.style=style;if(!state.lexical.hasOwnProperty("align"))state.lexical.align=true;while(true){var combinator=cc.length?cc.pop():jsonMode?expression:statement;if(combinator(type,content)){while(cc.length&&cc[cc.length-1].lex)cc.pop()();if(cx.marked)return cx.marked;if(type=="variable"&&inScope(state,content))return"variable-2";return style}}}var cx={state:null,column:null,marked:null,cc:null};function pass(){for(var i=arguments.length-1;i>=0;i--)cx.cc.push(arguments[i])}function cont(){pass.apply(null,arguments);return true}function register(varname){function inList(list){for(var v=list;v;v=v.next)if(v.name==varname)return true;return false}var state=cx.state;cx.marked="def";if(state.context){if(inList(state.localVars))return;state.localVars={name:varname,next:state.localVars}}else{if(inList(state.globalVars))return;if(parserConfig.globalVars)state.globalVars={name:varname,next:state.globalVars}}}var defaultVars={name:"this",next:{name:"arguments"}};function pushcontext(){cx.state.context={prev:cx.state.context,vars:cx.state.localVars};cx.state.localVars=defaultVars}function popcontext(){cx.state.localVars=cx.state.context.vars;cx.state.context=cx.state.context.prev}function pushlex(type,info){var result=function(){var state=cx.state,indent=state.indented;if(state.lexical.type=="stat")indent=state.lexical.indented;else for(var outer=state.lexical;outer&&outer.type==")"&&outer.align;outer=outer.prev)indent=outer.indented;state.lexical=new JSLexical(indent,cx.stream.column(),type,null,state.lexical,info)};result.lex=true;return result}function poplex(){var state=cx.state;if(state.lexical.prev){if(state.lexical.type==")")state.indented=state.lexical.indented;state.lexical=state.lexical.prev}}poplex.lex=true;function expect(wanted){function exp(type){if(type==wanted)return cont();else if(wanted==";")return pass();else return cont(exp)}return exp}function statement(type,value){if(type=="var")return cont(pushlex("vardef",value.length),vardef,expect(";"),poplex);if(type=="keyword a")return cont(pushlex("form"),parenExpr,statement,poplex);if(type=="keyword b")return cont(pushlex("form"),statement,poplex);if(type=="{")return cont(pushlex("}"),block,poplex);if(type==";")return cont();if(type=="if"){if(cx.state.lexical.info=="else"&&cx.state.cc[cx.state.cc.length-1]==poplex)cx.state.cc.pop()();return cont(pushlex("form"),parenExpr,statement,poplex,maybeelse)}if(type=="function")return cont(functiondef);if(type=="for")return cont(pushlex("form"),forspec,statement,poplex);if(type=="variable"){if(isTS&&value=="type"){cx.marked="keyword";return cont(typeexpr,expect("operator"),typeexpr,expect(";"))}else{return cont(pushlex("stat"),maybelabel)}}if(type=="switch")return cont(pushlex("form"),parenExpr,expect("{"),pushlex("}","switch"),block,poplex,poplex);if(type=="case")return cont(expression,expect(":"));if(type=="default")return cont(expect(":"));if(type=="catch")return cont(pushlex("form"),pushcontext,expect("("),funarg,expect(")"),statement,poplex,popcontext);if(type=="class")return cont(pushlex("form"),className,poplex);if(type=="export")return cont(pushlex("stat"),afterExport,poplex);if(type=="import")return cont(pushlex("stat"),afterImport,poplex);if(type=="module")return cont(pushlex("form"),pattern,expect("{"),pushlex("}"),block,poplex,poplex);if(type=="async")return cont(statement);if(value=="@")return cont(expression,statement);return pass(pushlex("stat"),expression,expect(";"),poplex)}function expression(type){return expressionInner(type,false)}function expressionNoComma(type){return expressionInner(type,true)}function parenExpr(type){if(type!="(")return pass();return cont(pushlex(")"),expression,expect(")"),poplex)}function expressionInner(type,noComma){if(cx.state.fatArrowAt==cx.stream.start){var body=noComma?arrowBodyNoComma:arrowBody;if(type=="(")return cont(pushcontext,pushlex(")"),commasep(pattern,")"),poplex,expect("=>"),body,popcontext);else if(type=="variable")return pass(pushcontext,pattern,expect("=>"),body,popcontext)}var maybeop=noComma?maybeoperatorNoComma:maybeoperatorComma;if(atomicTypes.hasOwnProperty(type))return cont(maybeop);if(type=="function")return cont(functiondef,maybeop);if(type=="class")return cont(pushlex("form"),classExpression,poplex);if(type=="keyword c"||type=="async")return cont(noComma?maybeexpressionNoComma:maybeexpression);if(type=="(")return cont(pushlex(")"),maybeexpression,expect(")"),poplex,maybeop);if(type=="operator"||type=="spread")return cont(noComma?expressionNoComma:expression);if(type=="[")return cont(pushlex("]"),arrayLiteral,poplex,maybeop);if(type=="{")return contCommasep(objprop,"}",null,maybeop);if(type=="quasi")return pass(quasi,maybeop);if(type=="new")return cont(maybeTarget(noComma));return cont()}function maybeexpression(type){if(type.match(/[;\}\)\],]/))return pass();return pass(expression)}function maybeexpressionNoComma(type){if(type.match(/[;\}\)\],]/))return pass();return pass(expressionNoComma)}function maybeoperatorComma(type,value){if(type==",")return cont(expression);return maybeoperatorNoComma(type,value,false)}function maybeoperatorNoComma(type,value,noComma){var me=noComma==false?maybeoperatorComma:maybeoperatorNoComma;var expr=noComma==false?expression:expressionNoComma;if(type=="=>")return cont(pushcontext,noComma?arrowBodyNoComma:arrowBody,popcontext);if(type=="operator"){if(/\+\+|--/.test(value))return cont(me);if(value=="?")return cont(expression,expect(":"),expr);return cont(expr)}if(type=="quasi"){return pass(quasi,me)}if(type==";")return;if(type=="(")return contCommasep(expressionNoComma,")","call",me);if(type==".")return cont(property,me);if(type=="[")return cont(pushlex("]"),maybeexpression,expect("]"),poplex,me);if(isTS&&value=="as"){cx.marked="keyword";return cont(typeexpr,me)}}function quasi(type,value){if(type!="quasi")return pass();if(value.slice(value.length-2)!="${")return cont(quasi);return cont(expression,continueQuasi)}function continueQuasi(type){if(type=="}"){cx.marked="string-2";cx.state.tokenize=tokenQuasi;return cont(quasi)}}function arrowBody(type){findFatArrow(cx.stream,cx.state);return pass(type=="{"?statement:expression)}function arrowBodyNoComma(type){findFatArrow(cx.stream,cx.state);return pass(type=="{"?statement:expressionNoComma)}function maybeTarget(noComma){return function(type){if(type==".")return cont(noComma?targetNoComma:target);else return pass(noComma?expressionNoComma:expression)}}function target(_,value){if(value=="target"){cx.marked="keyword";return cont(maybeoperatorComma)}}function targetNoComma(_,value){if(value=="target"){cx.marked="keyword";return cont(maybeoperatorNoComma)}}function maybelabel(type){if(type==":")return cont(poplex,statement);return pass(maybeoperatorComma,expect(";"),poplex)}function property(type){if(type=="variable"){cx.marked="property";return cont()}}function objprop(type,value){if(type=="async"){cx.marked="property";return cont(objprop)}else if(type=="variable"||cx.style=="keyword"){cx.marked="property";if(value=="get"||value=="set")return cont(getterSetter);return cont(afterprop)}else if(type=="number"||type=="string"){cx.marked=jsonldMode?"property":cx.style+" property";return cont(afterprop)}else if(type=="jsonld-keyword"){return cont(afterprop)}else if(type=="modifier"){return cont(objprop)}else if(type=="["){return cont(expression,expect("]"),afterprop)}else if(type=="spread"){return cont(expression,afterprop)}else if(type==":"){return pass(afterprop)}}function getterSetter(type){if(type!="variable")return pass(afterprop);cx.marked="property";return cont(functiondef)}function afterprop(type){if(type==":")return cont(expressionNoComma);if(type=="(")return pass(functiondef)}function commasep(what,end,sep){function proceed(type,value){if(sep?sep.indexOf(type)>-1:type==","){var lex=cx.state.lexical;if(lex.info=="call")lex.pos=(lex.pos||0)+1;return cont(function(type,value){if(type==end||value==end)return pass();return pass(what)},proceed)}if(type==end||value==end)return cont();return cont(expect(end))}return function(type,value){if(type==end||value==end)return cont();return pass(what,proceed)}}function contCommasep(what,end,info){for(var i=3;i<arguments.length;i++)cx.cc.push(arguments[i]);return cont(pushlex(end,info),commasep(what,end),poplex)}function block(type){if(type=="}")return cont();return pass(statement,block)}function maybetype(type,value){if(isTS){if(type==":")return cont(typeexpr);if(value=="?")return cont(maybetype)}}function typeexpr(type){if(type=="variable"){cx.marked="type";return cont(afterType)}if(type=="string"||type=="number"||type=="atom")return cont(afterType);if(type=="{")return cont(pushlex("}"),commasep(typeprop,"}",",;"),poplex,afterType);if(type=="(")return cont(commasep(typearg,")"),maybeReturnType)}function maybeReturnType(type){if(type=="=>")return cont(typeexpr)}function typeprop(type,value){if(type=="variable"||cx.style=="keyword"){cx.marked="property";return cont(typeprop)}else if(value=="?"){return cont(typeprop)}else if(type==":"){return cont(typeexpr)}else if(type=="["){return cont(expression,maybetype,expect("]"),typeprop)}}function typearg(type){if(type=="variable")return cont(typearg);else if(type==":")return cont(typeexpr)}function afterType(type,value){if(value=="<")return cont(pushlex(">"),commasep(typeexpr,">"),poplex,afterType);if(value=="|"||type==".")return cont(typeexpr);if(type=="[")return cont(expect("]"),afterType);if(value=="extends")return cont(typeexpr)}function vardef(){return pass(pattern,maybetype,maybeAssign,vardefCont)}function pattern(type,value){if(type=="modifier")return cont(pattern);if(type=="variable"){register(value);return cont()}if(type=="spread")return cont(pattern);if(type=="[")return contCommasep(pattern,"]");if(type=="{")return contCommasep(proppattern,"}")}function proppattern(type,value){if(type=="variable"&&!cx.stream.match(/^\s*:/,false)){register(value);return cont(maybeAssign)}if(type=="variable")cx.marked="property";if(type=="spread")return cont(pattern);if(type=="}")return pass();return cont(expect(":"),pattern,maybeAssign)}function maybeAssign(_type,value){if(value=="=")return cont(expressionNoComma)}function vardefCont(type){if(type==",")return cont(vardef)}function maybeelse(type,value){if(type=="keyword b"&&value=="else")return cont(pushlex("form","else"),statement,poplex)}function forspec(type){if(type=="(")return cont(pushlex(")"),forspec1,expect(")"),poplex)}function forspec1(type){if(type=="var")return cont(vardef,expect(";"),forspec2);if(type==";")return cont(forspec2);if(type=="variable")return cont(formaybeinof);return pass(expression,expect(";"),forspec2)}function formaybeinof(_type,value){if(value=="in"||value=="of"){cx.marked="keyword";return cont(expression)}return cont(maybeoperatorComma,forspec2)}function forspec2(type,value){if(type==";")return cont(forspec3);if(value=="in"||value=="of"){cx.marked="keyword";return cont(expression)}return pass(expression,expect(";"),forspec3)}function forspec3(type){if(type!=")")cont(expression)}function functiondef(type,value){if(value=="*"){cx.marked="keyword";return cont(functiondef)}if(type=="variable"){register(value);return cont(functiondef)}if(type=="(")return cont(pushcontext,pushlex(")"),commasep(funarg,")"),poplex,maybetype,statement,popcontext);if(isTS&&value=="<")return cont(pushlex(">"),commasep(typeexpr,">"),poplex,functiondef)}function funarg(type){if(type=="spread")return cont(funarg);return pass(pattern,maybetype,maybeAssign)}function classExpression(type,value){if(type=="variable")return className(type,value);return classNameAfter(type,value)}function className(type,value){if(type=="variable"){register(value);return cont(classNameAfter)}}function classNameAfter(type,value){if(value=="<")return cont(pushlex(">"),commasep(typeexpr,">"),poplex,classNameAfter);if(value=="extends"||value=="implements"||isTS&&type==",")return cont(isTS?typeexpr:expression,classNameAfter);if(type=="{")return cont(pushlex("}"),classBody,poplex)}function classBody(type,value){if(type=="variable"||cx.style=="keyword"){if((value=="async"||value=="static"||value=="get"||value=="set"||isTS&&(value=="public"||value=="private"||value=="protected"||value=="readonly"||value=="abstract"))&&cx.stream.match(/^\s+[\w$\xa1-\uffff]/,false)){cx.marked="keyword";return cont(classBody)}cx.marked="property";return cont(isTS?classfield:functiondef,classBody)}if(type=="[")return cont(expression,expect("]"),isTS?classfield:functiondef,classBody);if(value=="*"){cx.marked="keyword";return cont(classBody)}if(type==";")return cont(classBody);if(type=="}")return cont();if(value=="@")return cont(expression,classBody)}function classfield(type,value){if(value=="?")return cont(classfield);if(type==":")return cont(typeexpr,maybeAssign);if(value=="=")return cont(expressionNoComma);return pass(functiondef)}function afterExport(type,value){if(value=="*"){cx.marked="keyword";return cont(maybeFrom,expect(";"))}if(value=="default"){cx.marked="keyword";return cont(expression,expect(";"))}if(type=="{")return cont(commasep(exportField,"}"),maybeFrom,expect(";"));return pass(statement)}function exportField(type,value){if(value=="as"){cx.marked="keyword";return cont(expect("variable"))}if(type=="variable")return pass(expressionNoComma,exportField)}function afterImport(type){if(type=="string")return cont();return pass(importSpec,maybeMoreImports,maybeFrom)}function importSpec(type,value){if(type=="{")return contCommasep(importSpec,"}");if(type=="variable")register(value);if(value=="*")cx.marked="keyword";return cont(maybeAs)}function maybeMoreImports(type){if(type==",")return cont(importSpec,maybeMoreImports)}function maybeAs(_type,value){if(value=="as"){cx.marked="keyword";return cont(importSpec)}}function maybeFrom(_type,value){if(value=="from"){cx.marked="keyword";return cont(expression)}}function arrayLiteral(type){if(type=="]")return cont();return pass(commasep(expressionNoComma,"]"))}function isContinuedStatement(state,textAfter){return state.lastType=="operator"||state.lastType==","||isOperatorChar.test(textAfter.charAt(0))||/[,.]/.test(textAfter.charAt(0))}return{startState:function(basecolumn){var state={tokenize:tokenBase,lastType:"sof",cc:[],lexical:new JSLexical((basecolumn||0)-indentUnit,0,"block",false),localVars:parserConfig.localVars,context:parserConfig.localVars&&{vars:parserConfig.localVars},indented:basecolumn||0};if(parserConfig.globalVars&&typeof parserConfig.globalVars=="object")state.globalVars=parserConfig.globalVars;return state},token:function(stream,state){if(stream.sol()){if(!state.lexical.hasOwnProperty("align"))state.lexical.align=false;state.indented=stream.indentation();findFatArrow(stream,state)}if(state.tokenize!=tokenComment&&stream.eatSpace())return null;var style=state.tokenize(stream,state);if(type=="comment")return style;state.lastType=type=="operator"&&(content=="++"||content=="--")?"incdec":type;return parseJS(state,style,type,content,stream)},indent:function(state,textAfter){if(state.tokenize==tokenComment)return CodeMirror.Pass;if(state.tokenize!=tokenBase)return 0;var firstChar=textAfter&&textAfter.charAt(0),lexical=state.lexical,top;if(!/^\s*else\b/.test(textAfter))for(var i=state.cc.length-1;i>=0;--i){var c=state.cc[i];if(c==poplex)lexical=lexical.prev;else if(c!=maybeelse)break}while((lexical.type=="stat"||lexical.type=="form")&&(firstChar=="}"||(top=state.cc[state.cc.length-1])&&(top==maybeoperatorComma||top==maybeoperatorNoComma)&&!/^[,\.=+\-*:?[\(]/.test(textAfter)))lexical=lexical.prev;if(statementIndent&&lexical.type==")"&&lexical.prev.type=="stat")lexical=lexical.prev;var type=lexical.type,closing=firstChar==type;if(type=="vardef")return lexical.indented+(state.lastType=="operator"||state.lastType==","?lexical.info+1:0);else if(type=="form"&&firstChar=="{")return lexical.indented;else if(type=="form")return lexical.indented+indentUnit;else if(type=="stat")return lexical.indented+(isContinuedStatement(state,textAfter)?statementIndent||indentUnit:0);else if(lexical.info=="switch"&&!closing&&parserConfig.doubleIndentSwitch!=false)return lexical.indented+(/^(?:case|default)\b/.test(textAfter)?indentUnit:2*indentUnit);else if(lexical.align)return lexical.column+(closing?0:1);else return lexical.indented+(closing?0:indentUnit)},electricInput:/^\s*(?:case .*?:|default:|\{|\})$/,blockCommentStart:jsonMode?null:"/*",blockCommentEnd:jsonMode?null:"*/",lineComment:jsonMode?null:"//",fold:"brace",closeBrackets:"()[]{}''\"\"``",helperType:jsonMode?"json":"javascript",jsonldMode:jsonldMode,jsonMode:jsonMode,expressionAllowed:expressionAllowed,skipExpression:function(state){var top=state.cc[state.cc.length-1];if(top==expression||top==expressionNoComma)state.cc.pop()}}});CodeMirror.registerHelper("wordChars","javascript",/[\w$]/);CodeMirror.defineMIME("text/javascript","javascript");CodeMirror.defineMIME("text/ecmascript","javascript");CodeMirror.defineMIME("application/javascript","javascript");CodeMirror.defineMIME("application/x-javascript","javascript");CodeMirror.defineMIME("application/ecmascript","javascript");CodeMirror.defineMIME("application/json",{name:"javascript",json:true});CodeMirror.defineMIME("application/x-json",{name:"javascript",json:true});CodeMirror.defineMIME("application/ld+json",{name:"javascript",jsonld:true});CodeMirror.defineMIME("text/typescript",{name:"javascript",typescript:true});CodeMirror.defineMIME("application/typescript",{name:"javascript",typescript:true})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("../xml/xml"),require("../meta"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","../xml/xml","../meta"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineMode("markdown",function(cmCfg,modeCfg){var htmlMode=CodeMirror.getMode(cmCfg,"text/html");var htmlModeMissing=htmlMode.name=="null";function getMode(name){if(CodeMirror.findModeByName){var found=CodeMirror.findModeByName(name);if(found)name=found.mime||found.mimes[0]}var mode=CodeMirror.getMode(cmCfg,name);return mode.name=="null"?null:mode}if(modeCfg.highlightFormatting===undefined)modeCfg.highlightFormatting=false;if(modeCfg.maxBlockquoteDepth===undefined)modeCfg.maxBlockquoteDepth=0;if(modeCfg.taskLists===undefined)modeCfg.taskLists=false;if(modeCfg.strikethrough===undefined)modeCfg.strikethrough=false;if(modeCfg.tokenTypeOverrides===undefined)modeCfg.tokenTypeOverrides={};var tokenTypes={header:"header",code:"comment",quote:"quote",list1:"variable-2",list2:"variable-3",list3:"keyword",hr:"hr",image:"image",imageAltText:"image-alt-text",imageMarker:"image-marker",formatting:"formatting",linkInline:"link",linkEmail:"link",linkText:"link",linkHref:"string",em:"em",strong:"strong",strikethrough:"strikethrough"};for(var tokenType in tokenTypes){if(tokenTypes.hasOwnProperty(tokenType)&&modeCfg.tokenTypeOverrides[tokenType]){tokenTypes[tokenType]=modeCfg.tokenTypeOverrides[tokenType]}}var hrRE=/^([*\-_])(?:\s*\1){2,}\s*$/,listRE=/^(?:[*\-+]|^[0-9]+([.)]))\s+/,taskListRE=/^\[(x| )\](?=\s)/,atxHeaderRE=modeCfg.allowAtxHeaderWithoutSpace?/^(#+)/:/^(#+)(?: |$)/,setextHeaderRE=/^ *(?:\={1,}|-{1,})\s*$/,textRE=/^[^#!\[\]*_\\<>` "'(~]+/,fencedCodeRE=new RegExp("^("+(modeCfg.fencedCodeBlocks===true?"~~~+|```+":modeCfg.fencedCodeBlocks)+")[ \\t]*([\\w+#-]*)"),punctuation=/[!\"#$%&\'()*+,\-\.\/:;<=>?@\[\\\]^_`{|}~—]/;function switchInline(stream,state,f){state.f=state.inline=f;return f(stream,state)}function switchBlock(stream,state,f){state.f=state.block=f;return f(stream,state)}function lineIsEmpty(line){return!line||!/\S/.test(line.string)}function blankLine(state){state.linkTitle=false;state.em=false;state.strong=false;state.strikethrough=false;state.quote=0;state.indentedCode=false;if(state.f==htmlBlock){state.f=inlineNormal;state.block=blockNormal}state.trailingSpace=0;state.trailingSpaceNewLine=false;state.prevLine=state.thisLine;state.thisLine=null;return null}function blockNormal(stream,state){var sol=stream.sol();var prevLineIsList=state.list!==false,prevLineIsIndentedCode=state.indentedCode;state.indentedCode=false;if(prevLineIsList){if(state.indentationDiff>=0){if(state.indentationDiff<4){state.indentation-=state.indentationDiff}state.list=null}else if(state.indentation>0){state.list=null}else{state.list=false}}var match=null;if(state.indentationDiff>=4&&(prevLineIsIndentedCode||lineIsEmpty(state.prevLine))){stream.skipToEnd();state.indentation-=4;state.indentedCode=true;return tokenTypes.code}else if(stream.eatSpace()){return null}else if((match=stream.match(atxHeaderRE))&&match[1].length<=6){state.header=match[1].length;if(modeCfg.highlightFormatting)state.formatting="header";state.f=state.inline;return getType(state)}else if(!lineIsEmpty(state.prevLine)&&!state.quote&&!prevLineIsList&&!prevLineIsIndentedCode&&(match=stream.match(setextHeaderRE))){state.header=match[0].charAt(0)=="="?1:2;if(modeCfg.highlightFormatting)state.formatting="header";state.f=state.inline;return getType(state)}else if(stream.eat(">")){state.quote=sol?1:state.quote+1;if(modeCfg.highlightFormatting)state.formatting="quote";stream.eatSpace();return getType(state)}else if(stream.peek()==="["){return switchInline(stream,state,footnoteLink)}else if(stream.match(hrRE,true)){state.hr=true;return tokenTypes.hr}else if(match=stream.match(listRE)){var listType=match[1]?"ol":"ul";state.indentation=stream.column()+stream.current().length;state.list=true;while(state.listStack&&stream.column()<state.listStack[state.listStack.length-1]){state.listStack.pop()}state.listStack.push(state.indentation);if(modeCfg.taskLists&&stream.match(taskListRE,false)){state.taskList=true}state.f=state.inline;if(modeCfg.highlightFormatting)state.formatting=["list","list-"+listType];return getType(state)}else if(modeCfg.fencedCodeBlocks&&(match=stream.match(fencedCodeRE,true))){state.fencedChars=match[1];state.localMode=getMode(match[2]);if(state.localMode)state.localState=CodeMirror.startState(state.localMode);state.f=state.block=local;if(modeCfg.highlightFormatting)state.formatting="code-block";state.code=-1;return getType(state)}return switchInline(stream,state,state.inline)}function htmlBlock(stream,state){var style=htmlMode.token(stream,state.htmlState);if(!htmlModeMissing){var inner=CodeMirror.innerMode(htmlMode,state.htmlState);if(inner.mode.name=="xml"&&inner.state.tagStart===null&&(!inner.state.context&&inner.state.tokenize.isInText)||state.md_inside&&stream.current().indexOf(">")>-1){state.f=inlineNormal;state.block=blockNormal;state.htmlState=null}}return style}function local(stream,state){if(state.fencedChars&&stream.match(state.fencedChars)){if(modeCfg.highlightFormatting)state.formatting="code-block";var returnType=getType(state);state.localMode=state.localState=null;state.block=blockNormal;state.f=inlineNormal;state.fencedChars=null;state.code=0;return returnType}else if(state.fencedChars&&stream.skipTo(state.fencedChars)){return"comment"}else if(state.localMode){return state.localMode.token(stream,state.localState)}else{stream.skipToEnd();return tokenTypes.code}}function getType(state){var styles=[];if(state.formatting){styles.push(tokenTypes.formatting);if(typeof state.formatting==="string")state.formatting=[state.formatting];for(var i=0;i<state.formatting.length;i++){styles.push(tokenTypes.formatting+"-"+state.formatting[i]);if(state.formatting[i]==="header"){styles.push(tokenTypes.formatting+"-"+state.formatting[i]+"-"+state.header)}if(state.formatting[i]==="quote"){if(!modeCfg.maxBlockquoteDepth||modeCfg.maxBlockquoteDepth>=state.quote){styles.push(tokenTypes.formatting+"-"+state.formatting[i]+"-"+state.quote)}else{styles.push("error")}}}}if(state.taskOpen){styles.push("meta");return styles.length?styles.join(" "):null}if(state.taskClosed){styles.push("property");return styles.length?styles.join(" "):null}if(state.linkHref){styles.push(tokenTypes.linkHref,"url")}else{if(state.strong){styles.push(tokenTypes.strong)}if(state.em){styles.push(tokenTypes.em)}if(state.strikethrough){styles.push(tokenTypes.strikethrough)}if(state.linkText){styles.push(tokenTypes.linkText)}if(state.code){styles.push(tokenTypes.code)}if(state.image){styles.push(tokenTypes.image)}if(state.imageAltText){styles.push(tokenTypes.imageAltText,"link")}if(state.imageMarker){styles.push(tokenTypes.imageMarker)}}if(state.header){styles.push(tokenTypes.header,tokenTypes.header+"-"+state.header)}if(state.quote){styles.push(tokenTypes.quote);if(!modeCfg.maxBlockquoteDepth||modeCfg.maxBlockquoteDepth>=state.quote){styles.push(tokenTypes.quote+"-"+state.quote)}else{styles.push(tokenTypes.quote+"-"+modeCfg.maxBlockquoteDepth)}}if(state.list!==false){var listMod=(state.listStack.length-1)%3;if(!listMod){styles.push(tokenTypes.list1)}else if(listMod===1){styles.push(tokenTypes.list2)}else{styles.push(tokenTypes.list3)}}if(state.trailingSpaceNewLine){styles.push("trailing-space-new-line")}else if(state.trailingSpace){styles.push("trailing-space-"+(state.trailingSpace%2?"a":"b"))}return styles.length?styles.join(" "):null}function handleText(stream,state){if(stream.match(textRE,true)){return getType(state)}return undefined}function inlineNormal(stream,state){var style=state.text(stream,state);if(typeof style!=="undefined")return style;if(state.list){state.list=null;return getType(state)}if(state.taskList){var taskOpen=stream.match(taskListRE,true)[1]!=="x";if(taskOpen)state.taskOpen=true;else state.taskClosed=true;if(modeCfg.highlightFormatting)state.formatting="task";state.taskList=false;return getType(state)}state.taskOpen=false;state.taskClosed=false;if(state.header&&stream.match(/^#+$/,true)){if(modeCfg.highlightFormatting)state.formatting="header";return getType(state)}var ch=stream.next();if(state.linkTitle){state.linkTitle=false;var matchCh=ch;if(ch==="("){matchCh=")"}matchCh=(matchCh+"").replace(/([.?*+^\[\]\\(){}|-])/g,"\\$1");var regex="^\\s*(?:[^"+matchCh+"\\\\]+|\\\\\\\\|\\\\.)"+matchCh;if(stream.match(new RegExp(regex),true)){return tokenTypes.linkHref}}if(ch==="`"){var previousFormatting=state.formatting;if(modeCfg.highlightFormatting)state.formatting="code";stream.eatWhile("`");var count=stream.current().length;if(state.code==0){state.code=count;return getType(state)}else if(count==state.code){var t=getType(state);state.code=0;return t}else{state.formatting=previousFormatting;return getType(state)}}else if(state.code){return getType(state)}if(ch==="\\"){stream.next();if(modeCfg.highlightFormatting){var type=getType(state);var formattingEscape=tokenTypes.formatting+"-escape";return type?type+" "+formattingEscape:formattingEscape}}if(ch==="!"&&stream.match(/\[[^\]]*\] ?(?:\(|\[)/,false)){state.imageMarker=true;state.image=true;if(modeCfg.highlightFormatting)state.formatting="image";return getType(state)}if(ch==="["&&state.imageMarker&&stream.match(/[^\]]*\](\(.*?\)| ?\[.*?\])/,false)){state.imageMarker=false;state.imageAltText=true;if(modeCfg.highlightFormatting)state.formatting="image";return getType(state)}if(ch==="]"&&state.imageAltText){if(modeCfg.highlightFormatting)state.formatting="image";var type=getType(state);state.imageAltText=false;state.image=false;state.inline=state.f=linkHref;return type}if(ch==="["&&!state.image){state.linkText=true;if(modeCfg.highlightFormatting)state.formatting="link";return getType(state)}if(ch==="]"&&state.linkText){if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);state.linkText=false;state.inline=state.f=stream.match(/\(.*?\)| ?\[.*?\]/,false)?linkHref:inlineNormal;return type}if(ch==="<"&&stream.match(/^(https?|ftps?):\/\/(?:[^\\>]|\\.)+>/,false)){state.f=state.inline=linkInline;if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);if(type){type+=" "}else{type=""}return type+tokenTypes.linkInline}if(ch==="<"&&stream.match(/^[^> \\]+@(?:[^\\>]|\\.)+>/,false)){state.f=state.inline=linkInline;if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);if(type){type+=" "}else{type=""}return type+tokenTypes.linkEmail}if(ch==="<"&&stream.match(/^(!--|[a-z]+(?:\s+[a-z_:.\-]+(?:\s*=\s*[^ >]+)?)*\s*>)/i,false)){var end=stream.string.indexOf(">",stream.pos);if(end!=-1){var atts=stream.string.substring(stream.start,end);if(/markdown\s*=\s*('|"){0,1}1('|"){0,1}/.test(atts))state.md_inside=true}stream.backUp(1);state.htmlState=CodeMirror.startState(htmlMode);return switchBlock(stream,state,htmlBlock)}if(ch==="<"&&stream.match(/^\/\w*?>/)){state.md_inside=false;return"tag"}else if(ch==="*"||ch==="_"){var len=1,before=stream.pos==1?" ":stream.string.charAt(stream.pos-2);while(len<3&&stream.eat(ch))len++;var after=stream.peek()||" ";var leftFlanking=!/\s/.test(after)&&(!punctuation.test(after)||/\s/.test(before)||punctuation.test(before));var rightFlanking=!/\s/.test(before)&&(!punctuation.test(before)||/\s/.test(after)||punctuation.test(after));var setEm=null,setStrong=null;if(len%2){if(!state.em&&leftFlanking&&(ch==="*"||!rightFlanking||punctuation.test(before)))setEm=true;else if(state.em==ch&&rightFlanking&&(ch==="*"||!leftFlanking||punctuation.test(after)))setEm=false}if(len>1){if(!state.strong&&leftFlanking&&(ch==="*"||!rightFlanking||punctuation.test(before)))setStrong=true;else if(state.strong==ch&&rightFlanking&&(ch==="*"||!leftFlanking||punctuation.test(after)))setStrong=false}if(setStrong!=null||setEm!=null){if(modeCfg.highlightFormatting)state.formatting=setEm==null?"strong":setStrong==null?"em":"strong em";if(setEm===true)state.em=ch;if(setStrong===true)state.strong=ch;var t=getType(state);if(setEm===false)state.em=false;if(setStrong===false)state.strong=false;return t}}else if(ch===" "){if(stream.eat("*")||stream.eat("_")){if(stream.peek()===" "){return getType(state)}else{stream.backUp(1)}}}if(modeCfg.strikethrough){if(ch==="~"&&stream.eatWhile(ch)){if(state.strikethrough){if(modeCfg.highlightFormatting)state.formatting="strikethrough";var t=getType(state);state.strikethrough=false;return t}else if(stream.match(/^[^\s]/,false)){state.strikethrough=true;if(modeCfg.highlightFormatting)state.formatting="strikethrough";return getType(state)}}else if(ch===" "){if(stream.match(/^~~/,true)){if(stream.peek()===" "){return getType(state)}else{stream.backUp(2)}}}}if(ch===" "){if(stream.match(/ +$/,false)){state.trailingSpace++}else if(state.trailingSpace){state.trailingSpaceNewLine=true}}return getType(state)}function linkInline(stream,state){var ch=stream.next();if(ch===">"){state.f=state.inline=inlineNormal;if(modeCfg.highlightFormatting)state.formatting="link";var type=getType(state);if(type){type+=" "}else{type=""}return type+tokenTypes.linkInline}stream.match(/^[^>]+/,true);return tokenTypes.linkInline}function linkHref(stream,state){if(stream.eatSpace()){return null}var ch=stream.next();if(ch==="("||ch==="["){state.f=state.inline=getLinkHrefInside(ch==="("?")":"]");if(modeCfg.highlightFormatting)state.formatting="link-string";state.linkHref=true;return getType(state)}return"error"}var linkRE={")":/^(?:[^\\\(\)]|\\.|\((?:[^\\\(\)]|\\.)*\))*?(?=\))/,"]":/^(?:[^\\\[\]]|\\.|\[(?:[^\\\[\]]|\\.)*\])*?(?=\])/};function getLinkHrefInside(endChar){return function(stream,state){var ch=stream.next();if(ch===endChar){state.f=state.inline=inlineNormal;if(modeCfg.highlightFormatting)state.formatting="link-string";var returnState=getType(state);state.linkHref=false;return returnState}stream.match(linkRE[endChar]);state.linkHref=true;return getType(state)}}function footnoteLink(stream,state){if(stream.match(/^([^\]\\]|\\.)*\]:/,false)){state.f=footnoteLinkInside;stream.next();if(modeCfg.highlightFormatting)state.formatting="link";state.linkText=true;return getType(state)}return switchInline(stream,state,inlineNormal)}function footnoteLinkInside(stream,state){if(stream.match(/^\]:/,true)){state.f=state.inline=footnoteUrl;if(modeCfg.highlightFormatting)state.formatting="link";var returnType=getType(state);state.linkText=false;return returnType}stream.match(/^([^\]\\]|\\.)+/,true);return tokenTypes.linkText}function footnoteUrl(stream,state){if(stream.eatSpace()){return null}stream.match(/^[^\s]+/,true);if(stream.peek()===undefined){state.linkTitle=true}else{stream.match(/^(?:\s+(?:"(?:[^"\\]|\\\\|\\.)+"|'(?:[^'\\]|\\\\|\\.)+'|\((?:[^)\\]|\\\\|\\.)+\)))?/,true)}state.f=state.inline=inlineNormal;return tokenTypes.linkHref+" url"}var mode={startState:function(){return{f:blockNormal,prevLine:null,thisLine:null,block:blockNormal,htmlState:null,indentation:0,inline:inlineNormal,text:handleText,formatting:false,linkText:false,linkHref:false,linkTitle:false,code:0,em:false,strong:false,header:0,hr:false,taskList:false,list:false,listStack:[],quote:0,trailingSpace:0,trailingSpaceNewLine:false,strikethrough:false,fencedChars:null}},copyState:function(s){return{f:s.f,prevLine:s.prevLine,thisLine:s.thisLine,block:s.block,htmlState:s.htmlState&&CodeMirror.copyState(htmlMode,s.htmlState),indentation:s.indentation,localMode:s.localMode,localState:s.localMode?CodeMirror.copyState(s.localMode,s.localState):null,inline:s.inline,text:s.text,formatting:false,linkText:s.linkText,linkTitle:s.linkTitle,code:s.code,em:s.em,strong:s.strong,strikethrough:s.strikethrough,header:s.header,hr:s.hr,taskList:s.taskList,list:s.list,listStack:s.listStack.slice(0),quote:s.quote,indentedCode:s.indentedCode,trailingSpace:s.trailingSpace,trailingSpaceNewLine:s.trailingSpaceNewLine,md_inside:s.md_inside,fencedChars:s.fencedChars}},token:function(stream,state){state.formatting=false;if(stream!=state.thisLine){var forceBlankLine=state.header||state.hr;state.header=0;state.hr=false;if(stream.match(/^\s*$/,true)||forceBlankLine){blankLine(state);if(!forceBlankLine)return null;state.prevLine=null}state.prevLine=state.thisLine;state.thisLine=stream;state.taskList=false;state.trailingSpace=0;state.trailingSpaceNewLine=false;state.f=state.block;if(state.f!=htmlBlock){var indentation=stream.match(/^\s*/,true)[0].replace(/\t/g,"    ").length;state.indentationDiff=Math.min(indentation-state.indentation,4);state.indentation=state.indentation+state.indentationDiff;if(indentation>0)return null}}return state.f(stream,state)},innerMode:function(state){if(state.block==htmlBlock)return{state:state.htmlState,mode:htmlMode};if(state.localState)return{state:state.localState,mode:state.localMode};return{state:state,mode:mode}},indent:function(state,textAfter,line){if(state.block==htmlBlock)return htmlMode.indent(state.htmlState,textAfter,line);if(state.localState)return state.localMode.indent(state.localState,textAfter,line);return CodeMirror.Pass},blankLine:blankLine,getType:getType,closeBrackets:"()[]{}''\"\"``",fold:"markdown"};return mode},"xml");CodeMirror.defineMIME("text/x-markdown","markdown")});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineMode("css",function(config,parserConfig){var inline=parserConfig.inline;if(!parserConfig.propertyKeywords)parserConfig=CodeMirror.resolveMode("text/css");var indentUnit=config.indentUnit,tokenHooks=parserConfig.tokenHooks,documentTypes=parserConfig.documentTypes||{},mediaTypes=parserConfig.mediaTypes||{},mediaFeatures=parserConfig.mediaFeatures||{},mediaValueKeywords=parserConfig.mediaValueKeywords||{},propertyKeywords=parserConfig.propertyKeywords||{},nonStandardPropertyKeywords=parserConfig.nonStandardPropertyKeywords||{},fontProperties=parserConfig.fontProperties||{},counterDescriptors=parserConfig.counterDescriptors||{},colorKeywords=parserConfig.colorKeywords||{},valueKeywords=parserConfig.valueKeywords||{},allowNested=parserConfig.allowNested,lineComment=parserConfig.lineComment,supportsAtComponent=parserConfig.supportsAtComponent===true;var type,override;function ret(style,tp){type=tp;return style}function tokenBase(stream,state){var ch=stream.next();if(tokenHooks[ch]){var result=tokenHooks[ch](stream,state);if(result!==false)return result}if(ch=="@"){stream.eatWhile(/[\w\\\-]/);return ret("def",stream.current())}else if(ch=="="||(ch=="~"||ch=="|")&&stream.eat("=")){return ret(null,"compare")}else if(ch=='"'||ch=="'"){state.tokenize=tokenString(ch);return state.tokenize(stream,state)}else if(ch=="#"){stream.eatWhile(/[\w\\\-]/);return ret("atom","hash")}else if(ch=="!"){stream.match(/^\s*\w*/);return ret("keyword","important")}else if(/\d/.test(ch)||ch=="."&&stream.eat(/\d/)){stream.eatWhile(/[\w.%]/);return ret("number","unit")}else if(ch==="-"){if(/[\d.]/.test(stream.peek())){stream.eatWhile(/[\w.%]/);return ret("number","unit")}else if(stream.match(/^-[\w\\\-]+/)){stream.eatWhile(/[\w\\\-]/);if(stream.match(/^\s*:/,false))return ret("variable-2","variable-definition");return ret("variable-2","variable")}else if(stream.match(/^\w+-/)){return ret("meta","meta")}}else if(/[,+>*\/]/.test(ch)){return ret(null,"select-op")}else if(ch=="."&&stream.match(/^-?[_a-z][_a-z0-9-]*/i)){return ret("qualifier","qualifier")}else if(/[:;{}\[\]\(\)]/.test(ch)){return ret(null,ch)}else if(ch=="u"&&stream.match(/rl(-prefix)?\(/)||ch=="d"&&stream.match("omain(")||ch=="r"&&stream.match("egexp(")){stream.backUp(1);state.tokenize=tokenParenthesized;return ret("property","word")}else if(/[\w\\\-]/.test(ch)){stream.eatWhile(/[\w\\\-]/);return ret("property","word")}else{return ret(null,null)}}function tokenString(quote){return function(stream,state){var escaped=false,ch;while((ch=stream.next())!=null){if(ch==quote&&!escaped){if(quote==")")stream.backUp(1);break}escaped=!escaped&&ch=="\\"}if(ch==quote||!escaped&&quote!=")")state.tokenize=null;return ret("string","string")}}function tokenParenthesized(stream,state){stream.next();if(!stream.match(/\s*[\"\')]/,false))state.tokenize=tokenString(")");else state.tokenize=null;return ret(null,"(")}function Context(type,indent,prev){this.type=type;this.indent=indent;this.prev=prev}function pushContext(state,stream,type,indent){state.context=new Context(type,stream.indentation()+(indent===false?0:indentUnit),state.context);return type}function popContext(state){if(state.context.prev)state.context=state.context.prev;return state.context.type}function pass(type,stream,state){return states[state.context.type](type,stream,state)}function popAndPass(type,stream,state,n){for(var i=n||1;i>0;i--)state.context=state.context.prev;return pass(type,stream,state)}function wordAsValue(stream){var word=stream.current().toLowerCase();if(valueKeywords.hasOwnProperty(word))override="atom";else if(colorKeywords.hasOwnProperty(word))override="keyword";else override="variable"}var states={};states.top=function(type,stream,state){if(type=="{"){return pushContext(state,stream,"block")}else if(type=="}"&&state.context.prev){return popContext(state)}else if(supportsAtComponent&&/@component/.test(type)){return pushContext(state,stream,"atComponentBlock")}else if(/^@(-moz-)?document$/.test(type)){return pushContext(state,stream,"documentTypes")}else if(/^@(media|supports|(-moz-)?document|import)$/.test(type)){return pushContext(state,stream,"atBlock")}else if(/^@(font-face|counter-style)/.test(type)){state.stateArg=type;return"restricted_atBlock_before"}else if(/^@(-(moz|ms|o|webkit)-)?keyframes$/.test(type)){return"keyframes"}else if(type&&type.charAt(0)=="@"){return pushContext(state,stream,"at")}else if(type=="hash"){override="builtin"}else if(type=="word"){override="tag"}else if(type=="variable-definition"){return"maybeprop"}else if(type=="interpolation"){return pushContext(state,stream,"interpolation")}else if(type==":"){return"pseudo"}else if(allowNested&&type=="("){return pushContext(state,stream,"parens")}return state.context.type};states.block=function(type,stream,state){if(type=="word"){var word=stream.current().toLowerCase();if(propertyKeywords.hasOwnProperty(word)){override="property";return"maybeprop"}else if(nonStandardPropertyKeywords.hasOwnProperty(word)){override="string-2";return"maybeprop"}else if(allowNested){override=stream.match(/^\s*:(?:\s|$)/,false)?"property":"tag";return"block"}else{override+=" error";return"maybeprop"}}else if(type=="meta"){return"block"}else if(!allowNested&&(type=="hash"||type=="qualifier")){override="error";return"block"}else{return states.top(type,stream,state)}};states.maybeprop=function(type,stream,state){if(type==":")return pushContext(state,stream,"prop");return pass(type,stream,state)};states.prop=function(type,stream,state){if(type==";")return popContext(state);if(type=="{"&&allowNested)return pushContext(state,stream,"propBlock");if(type=="}"||type=="{")return popAndPass(type,stream,state);if(type=="(")return pushContext(state,stream,"parens");if(type=="hash"&&!/^#([0-9a-fA-f]{3,4}|[0-9a-fA-f]{6}|[0-9a-fA-f]{8})$/.test(stream.current())){override+=" error"}else if(type=="word"){wordAsValue(stream)}else if(type=="interpolation"){return pushContext(state,stream,"interpolation")}return"prop"};states.propBlock=function(type,_stream,state){if(type=="}")return popContext(state);if(type=="word"){override="property";return"maybeprop"}return state.context.type};states.parens=function(type,stream,state){if(type=="{"||type=="}")return popAndPass(type,stream,state);if(type==")")return popContext(state);if(type=="(")return pushContext(state,stream,"parens");if(type=="interpolation")return pushContext(state,stream,"interpolation");if(type=="word")wordAsValue(stream);return"parens"};states.pseudo=function(type,stream,state){if(type=="meta")return"pseudo";if(type=="word"){override="variable-3";return state.context.type}return pass(type,stream,state)};states.documentTypes=function(type,stream,state){if(type=="word"&&documentTypes.hasOwnProperty(stream.current())){override="tag";return state.context.type}else{return states.atBlock(type,stream,state)}};states.atBlock=function(type,stream,state){if(type=="(")return pushContext(state,stream,"atBlock_parens");if(type=="}"||type==";")return popAndPass(type,stream,state);if(type=="{")return popContext(state)&&pushContext(state,stream,allowNested?"block":"top");if(type=="interpolation")return pushContext(state,stream,"interpolation");if(type=="word"){var word=stream.current().toLowerCase();if(word=="only"||word=="not"||word=="and"||word=="or")override="keyword";else if(mediaTypes.hasOwnProperty(word))override="attribute";else if(mediaFeatures.hasOwnProperty(word))override="property";else if(mediaValueKeywords.hasOwnProperty(word))override="keyword";else if(propertyKeywords.hasOwnProperty(word))override="property";else if(nonStandardPropertyKeywords.hasOwnProperty(word))override="string-2";else if(valueKeywords.hasOwnProperty(word))override="atom";else if(colorKeywords.hasOwnProperty(word))override="keyword";else override="error"}return state.context.type};states.atComponentBlock=function(type,stream,state){if(type=="}")return popAndPass(type,stream,state);if(type=="{")return popContext(state)&&pushContext(state,stream,allowNested?"block":"top",false);if(type=="word")override="error";return state.context.type};states.atBlock_parens=function(type,stream,state){if(type==")")return popContext(state);if(type=="{"||type=="}")return popAndPass(type,stream,state,2);return states.atBlock(type,stream,state)};states.restricted_atBlock_before=function(type,stream,state){if(type=="{")return pushContext(state,stream,"restricted_atBlock");if(type=="word"&&state.stateArg=="@counter-style"){override="variable";return"restricted_atBlock_before"}return pass(type,stream,state)};states.restricted_atBlock=function(type,stream,state){if(type=="}"){state.stateArg=null;return popContext(state)}if(type=="word"){if(state.stateArg=="@font-face"&&!fontProperties.hasOwnProperty(stream.current().toLowerCase())||state.stateArg=="@counter-style"&&!counterDescriptors.hasOwnProperty(stream.current().toLowerCase()))override="error";else override="property";return"maybeprop"}return"restricted_atBlock"};states.keyframes=function(type,stream,state){if(type=="word"){override="variable";return"keyframes"}if(type=="{")return pushContext(state,stream,"top");return pass(type,stream,state)};states.at=function(type,stream,state){if(type==";")return popContext(state);if(type=="{"||type=="}")return popAndPass(type,stream,state);if(type=="word")override="tag";else if(type=="hash")override="builtin";return"at"};states.interpolation=function(type,stream,state){if(type=="}")return popContext(state);if(type=="{"||type==";")return popAndPass(type,stream,state);if(type=="word")override="variable";else if(type!="variable"&&type!="("&&type!=")")override="error";return"interpolation"};return{startState:function(base){return{tokenize:null,state:inline?"block":"top",stateArg:null,context:new Context(inline?"block":"top",base||0,null)}},token:function(stream,state){if(!state.tokenize&&stream.eatSpace())return null;var style=(state.tokenize||tokenBase)(stream,state);if(style&&typeof style=="object"){type=style[1];style=style[0]}override=style;state.state=states[state.state](type,stream,state);return override},indent:function(state,textAfter){var cx=state.context,ch=textAfter&&textAfter.charAt(0);var indent=cx.indent;if(cx.type=="prop"&&(ch=="}"||ch==")"))cx=cx.prev;if(cx.prev){if(ch=="}"&&(cx.type=="block"||cx.type=="top"||cx.type=="interpolation"||cx.type=="restricted_atBlock")){cx=cx.prev;indent=cx.indent}else if(ch==")"&&(cx.type=="parens"||cx.type=="atBlock_parens")||ch=="{"&&(cx.type=="at"||cx.type=="atBlock")){indent=Math.max(0,cx.indent-indentUnit)}}return indent},electricChars:"}",blockCommentStart:"/*",blockCommentEnd:"*/",lineComment:lineComment,fold:"brace"}});function keySet(array){var keys={};for(var i=0;i<array.length;++i){keys[array[i].toLowerCase()]=true}return keys}var documentTypes_=["domain","regexp","url","url-prefix"],documentTypes=keySet(documentTypes_);var mediaTypes_=["all","aural","braille","handheld","print","projection","screen","tty","tv","embossed"],mediaTypes=keySet(mediaTypes_);var mediaFeatures_=["width","min-width","max-width","height","min-height","max-height","device-width","min-device-width","max-device-width","device-height","min-device-height","max-device-height","aspect-ratio","min-aspect-ratio","max-aspect-ratio","device-aspect-ratio","min-device-aspect-ratio","max-device-aspect-ratio","color","min-color","max-color","color-index","min-color-index","max-color-index","monochrome","min-monochrome","max-monochrome","resolution","min-resolution","max-resolution","scan","grid","orientation","device-pixel-ratio","min-device-pixel-ratio","max-device-pixel-ratio","pointer","any-pointer","hover","any-hover"],mediaFeatures=keySet(mediaFeatures_);var mediaValueKeywords_=["landscape","portrait","none","coarse","fine","on-demand","hover","interlace","progressive"],mediaValueKeywords=keySet(mediaValueKeywords_);var propertyKeywords_=["align-content","align-items","align-self","alignment-adjust","alignment-baseline","anchor-point","animation","animation-delay","animation-direction","animation-duration","animation-fill-mode","animation-iteration-count","animation-name","animation-play-state","animation-timing-function","appearance","azimuth","backface-visibility","background","background-attachment","background-blend-mode","background-clip","background-color","background-image","background-origin","background-position","background-repeat","background-size","baseline-shift","binding","bleed","bookmark-label","bookmark-level","bookmark-state","bookmark-target","border","border-bottom","border-bottom-color","border-bottom-left-radius","border-bottom-right-radius","border-bottom-style","border-bottom-width","border-collapse","border-color","border-image","border-image-outset","border-image-repeat","border-image-slice","border-image-source","border-image-width","border-left","border-left-color","border-left-style","border-left-width","border-radius","border-right","border-right-color","border-right-style","border-right-width","border-spacing","border-style","border-top","border-top-color","border-top-left-radius","border-top-right-radius","border-top-style","border-top-width","border-width","bottom","box-decoration-break","box-shadow","box-sizing","break-after","break-before","break-inside","caption-side","caret-color","clear","clip","color","color-profile","column-count","column-fill","column-gap","column-rule","column-rule-color","column-rule-style","column-rule-width","column-span","column-width","columns","content","counter-increment","counter-reset","crop","cue","cue-after","cue-before","cursor","direction","display","dominant-baseline","drop-initial-after-adjust","drop-initial-after-align","drop-initial-before-adjust","drop-initial-before-align","drop-initial-size","drop-initial-value","elevation","empty-cells","fit","fit-position","flex","flex-basis","flex-direction","flex-flow","flex-grow","flex-shrink","flex-wrap","float","float-offset","flow-from","flow-into","font","font-feature-settings","font-family","font-kerning","font-language-override","font-size","font-size-adjust","font-stretch","font-style","font-synthesis","font-variant","font-variant-alternates","font-variant-caps","font-variant-east-asian","font-variant-ligatures","font-variant-numeric","font-variant-position","font-weight","grid","grid-area","grid-auto-columns","grid-auto-flow","grid-auto-rows","grid-column","grid-column-end","grid-column-gap","grid-column-start","grid-gap","grid-row","grid-row-end","grid-row-gap","grid-row-start","grid-template","grid-template-areas","grid-template-columns","grid-template-rows","hanging-punctuation","height","hyphens","icon","image-orientation","image-rendering","image-resolution","inline-box-align","justify-content","justify-items","justify-self","left","letter-spacing","line-break","line-height","line-stacking","line-stacking-ruby","line-stacking-shift","line-stacking-strategy","list-style","list-style-image","list-style-position","list-style-type","margin","margin-bottom","margin-left","margin-right","margin-top","marks","marquee-direction","marquee-loop","marquee-play-count","marquee-speed","marquee-style","max-height","max-width","min-height","min-width","move-to","nav-down","nav-index","nav-left","nav-right","nav-up","object-fit","object-position","opacity","order","orphans","outline","outline-color","outline-offset","outline-style","outline-width","overflow","overflow-style","overflow-wrap","overflow-x","overflow-y","padding","padding-bottom","padding-left","padding-right","padding-top","page","page-break-after","page-break-before","page-break-inside","page-policy","pause","pause-after","pause-before","perspective","perspective-origin","pitch","pitch-range","place-content","place-items","place-self","play-during","position","presentation-level","punctuation-trim","quotes","region-break-after","region-break-before","region-break-inside","region-fragment","rendering-intent","resize","rest","rest-after","rest-before","richness","right","rotation","rotation-point","ruby-align","ruby-overhang","ruby-position","ruby-span","shape-image-threshold","shape-inside","shape-margin","shape-outside","size","speak","speak-as","speak-header","speak-numeral","speak-punctuation","speech-rate","stress","string-set","tab-size","table-layout","target","target-name","target-new","target-position","text-align","text-align-last","text-decoration","text-decoration-color","text-decoration-line","text-decoration-skip","text-decoration-style","text-emphasis","text-emphasis-color","text-emphasis-position","text-emphasis-style","text-height","text-indent","text-justify","text-outline","text-overflow","text-shadow","text-size-adjust","text-space-collapse","text-transform","text-underline-position","text-wrap","top","transform","transform-origin","transform-style","transition","transition-delay","transition-duration","transition-property","transition-timing-function","unicode-bidi","user-select","vertical-align","visibility","voice-balance","voice-duration","voice-family","voice-pitch","voice-range","voice-rate","voice-stress","voice-volume","volume","white-space","widows","width","will-change","word-break","word-spacing","word-wrap","z-index","clip-path","clip-rule","mask","enable-background","filter","flood-color","flood-opacity","lighting-color","stop-color","stop-opacity","pointer-events","color-interpolation","color-interpolation-filters","color-rendering","fill","fill-opacity","fill-rule","image-rendering","marker","marker-end","marker-mid","marker-start","shape-rendering","stroke","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","text-rendering","baseline-shift","dominant-baseline","glyph-orientation-horizontal","glyph-orientation-vertical","text-anchor","writing-mode"],propertyKeywords=keySet(propertyKeywords_);var nonStandardPropertyKeywords_=["scrollbar-arrow-color","scrollbar-base-color","scrollbar-dark-shadow-color","scrollbar-face-color","scrollbar-highlight-color","scrollbar-shadow-color","scrollbar-3d-light-color","scrollbar-track-color","shape-inside","searchfield-cancel-button","searchfield-decoration","searchfield-results-button","searchfield-results-decoration","zoom"],nonStandardPropertyKeywords=keySet(nonStandardPropertyKeywords_);var fontProperties_=["font-family","src","unicode-range","font-variant","font-feature-settings","font-stretch","font-weight","font-style"],fontProperties=keySet(fontProperties_);var counterDescriptors_=["additive-symbols","fallback","negative","pad","prefix","range","speak-as","suffix","symbols","system"],counterDescriptors=keySet(counterDescriptors_);var colorKeywords_=["aliceblue","antiquewhite","aqua","aquamarine","azure","beige","bisque","black","blanchedalmond","blue","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dodgerblue","firebrick","floralwhite","forestgreen","fuchsia","gainsboro","ghostwhite","gold","goldenrod","gray","grey","green","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightsteelblue","lightyellow","lime","limegreen","linen","magenta","maroon","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","navy","oldlace","olive","olivedrab","orange","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","purple","rebeccapurple","red","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","silver","skyblue","slateblue","slategray","snow","springgreen","steelblue","tan","teal","thistle","tomato","turquoise","violet","wheat","white","whitesmoke","yellow","yellowgreen"],colorKeywords=keySet(colorKeywords_);var valueKeywords_=["above","absolute","activeborder","additive","activecaption","afar","after-white-space","ahead","alias","all","all-scroll","alphabetic","alternate","always","amharic","amharic-abegede","antialiased","appworkspace","arabic-indic","armenian","asterisks","attr","auto","auto-flow","avoid","avoid-column","avoid-page","avoid-region","background","backwards","baseline","below","bidi-override","binary","bengali","blink","block","block-axis","bold","bolder","border","border-box","both","bottom","break","break-all","break-word","bullets","button","button-bevel","buttonface","buttonhighlight","buttonshadow","buttontext","calc","cambodian","capitalize","caps-lock-indicator","caption","captiontext","caret","cell","center","checkbox","circle","cjk-decimal","cjk-earthly-branch","cjk-heavenly-stem","cjk-ideographic","clear","clip","close-quote","col-resize","collapse","color","color-burn","color-dodge","column","column-reverse","compact","condensed","contain","content","contents","content-box","context-menu","continuous","copy","counter","counters","cover","crop","cross","crosshair","currentcolor","cursive","cyclic","darken","dashed","decimal","decimal-leading-zero","default","default-button","dense","destination-atop","destination-in","destination-out","destination-over","devanagari","difference","disc","discard","disclosure-closed","disclosure-open","document","dot-dash","dot-dot-dash","dotted","double","down","e-resize","ease","ease-in","ease-in-out","ease-out","element","ellipse","ellipsis","embed","end","ethiopic","ethiopic-abegede","ethiopic-abegede-am-et","ethiopic-abegede-gez","ethiopic-abegede-ti-er","ethiopic-abegede-ti-et","ethiopic-halehame-aa-er","ethiopic-halehame-aa-et","ethiopic-halehame-am-et","ethiopic-halehame-gez","ethiopic-halehame-om-et","ethiopic-halehame-sid-et","ethiopic-halehame-so-et","ethiopic-halehame-ti-er","ethiopic-halehame-ti-et","ethiopic-halehame-tig","ethiopic-numeric","ew-resize","exclusion","expanded","extends","extra-condensed","extra-expanded","fantasy","fast","fill","fixed","flat","flex","flex-end","flex-start","footnotes","forwards","from","geometricPrecision","georgian","graytext","grid","groove","gujarati","gurmukhi","hand","hangul","hangul-consonant","hard-light","hebrew","help","hidden","hide","higher","highlight","highlighttext","hiragana","hiragana-iroha","horizontal","hsl","hsla","hue","icon","ignore","inactiveborder","inactivecaption","inactivecaptiontext","infinite","infobackground","infotext","inherit","initial","inline","inline-axis","inline-block","inline-flex","inline-grid","inline-table","inset","inside","intrinsic","invert","italic","japanese-formal","japanese-informal","justify","kannada","katakana","katakana-iroha","keep-all","khmer","korean-hangul-formal","korean-hanja-formal","korean-hanja-informal","landscape","lao","large","larger","left","level","lighter","lighten","line-through","linear","linear-gradient","lines","list-item","listbox","listitem","local","logical","loud","lower","lower-alpha","lower-armenian","lower-greek","lower-hexadecimal","lower-latin","lower-norwegian","lower-roman","lowercase","ltr","luminosity","malayalam","match","matrix","matrix3d","media-controls-background","media-current-time-display","media-fullscreen-button","media-mute-button","media-play-button","media-return-to-realtime-button","media-rewind-button","media-seek-back-button","media-seek-forward-button","media-slider","media-sliderthumb","media-time-remaining-display","media-volume-slider","media-volume-slider-container","media-volume-sliderthumb","medium","menu","menulist","menulist-button","menulist-text","menulist-textfield","menutext","message-box","middle","min-intrinsic","mix","mongolian","monospace","move","multiple","multiply","myanmar","n-resize","narrower","ne-resize","nesw-resize","no-close-quote","no-drop","no-open-quote","no-repeat","none","normal","not-allowed","nowrap","ns-resize","numbers","numeric","nw-resize","nwse-resize","oblique","octal","opacity","open-quote","optimizeLegibility","optimizeSpeed","oriya","oromo","outset","outside","outside-shape","overlay","overline","padding","padding-box","painted","page","paused","persian","perspective","plus-darker","plus-lighter","pointer","polygon","portrait","pre","pre-line","pre-wrap","preserve-3d","progress","push-button","radial-gradient","radio","read-only","read-write","read-write-plaintext-only","rectangle","region","relative","repeat","repeating-linear-gradient","repeating-radial-gradient","repeat-x","repeat-y","reset","reverse","rgb","rgba","ridge","right","rotate","rotate3d","rotateX","rotateY","rotateZ","round","row","row-resize","row-reverse","rtl","run-in","running","s-resize","sans-serif","saturation","scale","scale3d","scaleX","scaleY","scaleZ","screen","scroll","scrollbar","scroll-position","se-resize","searchfield","searchfield-cancel-button","searchfield-decoration","searchfield-results-button","searchfield-results-decoration","self-start","self-end","semi-condensed","semi-expanded","separate","serif","show","sidama","simp-chinese-formal","simp-chinese-informal","single","skew","skewX","skewY","skip-white-space","slide","slider-horizontal","slider-vertical","sliderthumb-horizontal","sliderthumb-vertical","slow","small","small-caps","small-caption","smaller","soft-light","solid","somali","source-atop","source-in","source-out","source-over","space","space-around","space-between","space-evenly","spell-out","square","square-button","start","static","status-bar","stretch","stroke","sub","subpixel-antialiased","super","sw-resize","symbolic","symbols","system-ui","table","table-caption","table-cell","table-column","table-column-group","table-footer-group","table-header-group","table-row","table-row-group","tamil","telugu","text","text-bottom","text-top","textarea","textfield","thai","thick","thin","threeddarkshadow","threedface","threedhighlight","threedlightshadow","threedshadow","tibetan","tigre","tigrinya-er","tigrinya-er-abegede","tigrinya-et","tigrinya-et-abegede","to","top","trad-chinese-formal","trad-chinese-informal","transform","translate","translate3d","translateX","translateY","translateZ","transparent","ultra-condensed","ultra-expanded","underline","unset","up","upper-alpha","upper-armenian","upper-greek","upper-hexadecimal","upper-latin","upper-norwegian","upper-roman","uppercase","urdu","url","var","vertical","vertical-text","visible","visibleFill","visiblePainted","visibleStroke","visual","w-resize","wait","wave","wider","window","windowframe","windowtext","words","wrap","wrap-reverse","x-large","x-small","xor","xx-large","xx-small"],valueKeywords=keySet(valueKeywords_);var allWords=documentTypes_.concat(mediaTypes_).concat(mediaFeatures_).concat(mediaValueKeywords_).concat(propertyKeywords_).concat(nonStandardPropertyKeywords_).concat(colorKeywords_).concat(valueKeywords_);CodeMirror.registerHelper("hintWords","css",allWords);function tokenCComment(stream,state){var maybeEnd=false,ch;while((ch=stream.next())!=null){if(maybeEnd&&ch=="/"){state.tokenize=null;break}maybeEnd=ch=="*"}return["comment","comment"]}CodeMirror.defineMIME("text/css",{documentTypes:documentTypes,mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,mediaValueKeywords:mediaValueKeywords,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,fontProperties:fontProperties,counterDescriptors:counterDescriptors,colorKeywords:colorKeywords,valueKeywords:valueKeywords,tokenHooks:{"/":function(stream,state){if(!stream.eat("*"))return false;state.tokenize=tokenCComment;return tokenCComment(stream,state)}},name:"css"});CodeMirror.defineMIME("text/x-scss",{mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,mediaValueKeywords:mediaValueKeywords,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,colorKeywords:colorKeywords,valueKeywords:valueKeywords,fontProperties:fontProperties,allowNested:true,lineComment:"//",tokenHooks:{"/":function(stream,state){if(stream.eat("/")){stream.skipToEnd();return["comment","comment"]}else if(stream.eat("*")){state.tokenize=tokenCComment;return tokenCComment(stream,state)}else{return["operator","operator"]}},":":function(stream){if(stream.match(/\s*\{/,false))return[null,null];return false},$:function(stream){stream.match(/^[\w-]+/);if(stream.match(/^\s*:/,false))return["variable-2","variable-definition"];return["variable-2","variable"]},"#":function(stream){if(!stream.eat("{"))return false;return[null,"interpolation"]}},name:"css",helperType:"scss"});CodeMirror.defineMIME("text/x-less",{mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,mediaValueKeywords:mediaValueKeywords,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,colorKeywords:colorKeywords,valueKeywords:valueKeywords,fontProperties:fontProperties,allowNested:true,lineComment:"//",tokenHooks:{"/":function(stream,state){if(stream.eat("/")){stream.skipToEnd();return["comment","comment"]}else if(stream.eat("*")){state.tokenize=tokenCComment;return tokenCComment(stream,state)}else{return["operator","operator"]}},"@":function(stream){if(stream.eat("{"))return[null,"interpolation"];if(stream.match(/^(charset|document|font-face|import|(-(moz|ms|o|webkit)-)?keyframes|media|namespace|page|supports)\b/,false))return false;stream.eatWhile(/[\w\\\-]/);if(stream.match(/^\s*:/,false))return["variable-2","variable-definition"];return["variable-2","variable"]},"&":function(){return["atom","atom"]}},name:"css",helperType:"less"});CodeMirror.defineMIME("text/x-gss",{documentTypes:documentTypes,mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,fontProperties:fontProperties,counterDescriptors:counterDescriptors,colorKeywords:colorKeywords,valueKeywords:valueKeywords,supportsAtComponent:true,tokenHooks:{"/":function(stream,state){if(!stream.eat("*"))return false;state.tokenize=tokenCComment;return tokenCComment(stream,state)}},name:"css",helperType:"gss"})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";function Context(indented,column,type,info,align,prev){this.indented=indented;this.column=column;this.type=type;this.info=info;this.align=align;this.prev=prev}function pushContext(state,col,type,info){var indent=state.indented;if(state.context&&state.context.type=="statement"&&type!="statement")indent=state.context.indented;return state.context=new Context(indent,col,type,info,null,state.context)}function popContext(state){var t=state.context.type;if(t==")"||t=="]"||t=="}")state.indented=state.context.indented;return state.context=state.context.prev}function typeBefore(stream,state,pos){if(state.prevToken=="variable"||state.prevToken=="type")return true;if(/\S(?:[^- ]>|[*\]])\s*$|\*$/.test(stream.string.slice(0,pos)))return true;if(state.typeAtEndOfLine&&stream.column()==stream.indentation())return true}function isTopScope(context){for(;;){if(!context||context.type=="top")return true;if(context.type=="}"&&context.prev.info!="namespace")return false;context=context.prev}}CodeMirror.defineMode("clike",function(config,parserConfig){var indentUnit=config.indentUnit,statementIndentUnit=parserConfig.statementIndentUnit||indentUnit,dontAlignCalls=parserConfig.dontAlignCalls,keywords=parserConfig.keywords||{},types=parserConfig.types||{},builtin=parserConfig.builtin||{},blockKeywords=parserConfig.blockKeywords||{},defKeywords=parserConfig.defKeywords||{},atoms=parserConfig.atoms||{},hooks=parserConfig.hooks||{},multiLineStrings=parserConfig.multiLineStrings,indentStatements=parserConfig.indentStatements!==false,indentSwitch=parserConfig.indentSwitch!==false,namespaceSeparator=parserConfig.namespaceSeparator,isPunctuationChar=parserConfig.isPunctuationChar||/[\[\]{}\(\),;\:\.]/,numberStart=parserConfig.numberStart||/[\d\.]/,number=parserConfig.number||/^(?:0x[a-f\d]+|0b[01]+|(?:\d+\.?\d*|\.\d+)(?:e[-+]?\d+)?)(u|ll?|l|f)?/i,isOperatorChar=parserConfig.isOperatorChar||/[+\-*&%=<>!?|\/]/,isIdentifierChar=parserConfig.isIdentifierChar||/[\w\$_\xa1-\uffff]/;var curPunc,isDefKeyword;function tokenBase(stream,state){var ch=stream.next();if(hooks[ch]){var result=hooks[ch](stream,state);if(result!==false)return result}if(ch=='"'||ch=="'"){state.tokenize=tokenString(ch);return state.tokenize(stream,state)}if(isPunctuationChar.test(ch)){curPunc=ch;return null}if(numberStart.test(ch)){stream.backUp(1);if(stream.match(number))return"number";stream.next()}if(ch=="/"){if(stream.eat("*")){state.tokenize=tokenComment;return tokenComment(stream,state)}if(stream.eat("/")){stream.skipToEnd();return"comment"}}if(isOperatorChar.test(ch)){while(!stream.match(/^\/[\/*]/,false)&&stream.eat(isOperatorChar)){}return"operator"}stream.eatWhile(isIdentifierChar);if(namespaceSeparator)while(stream.match(namespaceSeparator))stream.eatWhile(isIdentifierChar);var cur=stream.current();if(contains(keywords,cur)){if(contains(blockKeywords,cur))curPunc="newstatement";if(contains(defKeywords,cur))isDefKeyword=true;return"keyword"}if(contains(types,cur))return"type";if(contains(builtin,cur)){if(contains(blockKeywords,cur))curPunc="newstatement";return"builtin"}if(contains(atoms,cur))return"atom";return"variable"}function tokenString(quote){return function(stream,state){var escaped=false,next,end=false;while((next=stream.next())!=null){if(next==quote&&!escaped){end=true;break}escaped=!escaped&&next=="\\"}if(end||!(escaped||multiLineStrings))state.tokenize=null;return"string"}}function tokenComment(stream,state){var maybeEnd=false,ch;while(ch=stream.next()){if(ch=="/"&&maybeEnd){state.tokenize=null;break}maybeEnd=ch=="*"}return"comment"}function maybeEOL(stream,state){if(parserConfig.typeFirstDefinitions&&stream.eol()&&isTopScope(state.context))state.typeAtEndOfLine=typeBefore(stream,state,stream.pos)}return{startState:function(basecolumn){return{tokenize:null,context:new Context((basecolumn||0)-indentUnit,0,"top",null,false),indented:0,startOfLine:true,prevToken:null}},token:function(stream,state){var ctx=state.context;if(stream.sol()){if(ctx.align==null)ctx.align=false;state.indented=stream.indentation();state.startOfLine=true}if(stream.eatSpace()){maybeEOL(stream,state);return null}curPunc=isDefKeyword=null;var style=(state.tokenize||tokenBase)(stream,state);if(style=="comment"||style=="meta")return style;if(ctx.align==null)ctx.align=true;if(curPunc==";"||curPunc==":"||curPunc==","&&stream.match(/^\s*(?:\/\/.*)?$/,false))while(state.context.type=="statement")popContext(state);else if(curPunc=="{")pushContext(state,stream.column(),"}");else if(curPunc=="[")pushContext(state,stream.column(),"]");else if(curPunc=="(")pushContext(state,stream.column(),")");else if(curPunc=="}"){while(ctx.type=="statement")ctx=popContext(state);if(ctx.type=="}")ctx=popContext(state);while(ctx.type=="statement")ctx=popContext(state)}else if(curPunc==ctx.type)popContext(state);else if(indentStatements&&((ctx.type=="}"||ctx.type=="top")&&curPunc!=";"||ctx.type=="statement"&&curPunc=="newstatement")){pushContext(state,stream.column(),"statement",stream.current())}if(style=="variable"&&(state.prevToken=="def"||parserConfig.typeFirstDefinitions&&typeBefore(stream,state,stream.start)&&isTopScope(state.context)&&stream.match(/^\s*\(/,false)))style="def";if(hooks.token){var result=hooks.token(stream,state,style);if(result!==undefined)style=result}if(style=="def"&&parserConfig.styleDefs===false)style="variable";state.startOfLine=false;state.prevToken=isDefKeyword?"def":style||curPunc;maybeEOL(stream,state);return style},indent:function(state,textAfter){if(state.tokenize!=tokenBase&&state.tokenize!=null||state.typeAtEndOfLine)return CodeMirror.Pass;var ctx=state.context,firstChar=textAfter&&textAfter.charAt(0);if(ctx.type=="statement"&&firstChar=="}")ctx=ctx.prev;if(parserConfig.dontIndentStatements)while(ctx.type=="statement"&&parserConfig.dontIndentStatements.test(ctx.info))ctx=ctx.prev;if(hooks.indent){var hook=hooks.indent(state,ctx,textAfter);if(typeof hook=="number")return hook}var closing=firstChar==ctx.type;var switchBlock=ctx.prev&&ctx.prev.info=="switch";if(parserConfig.allmanIndentation&&/[{(]/.test(firstChar)){while(ctx.type!="top"&&ctx.type!="}")ctx=ctx.prev;return ctx.indented}if(ctx.type=="statement")return ctx.indented+(firstChar=="{"?0:statementIndentUnit);if(ctx.align&&(!dontAlignCalls||ctx.type!=")"))return ctx.column+(closing?0:1);if(ctx.type==")"&&!closing)return ctx.indented+statementIndentUnit;return ctx.indented+(closing?0:indentUnit)+(!closing&&switchBlock&&!/^(?:case|default)\b/.test(textAfter)?indentUnit:0)},electricInput:indentSwitch?/^\s*(?:case .*?:|default:|\{\}?|\})$/:/^\s*[{}]$/,blockCommentStart:"/*",blockCommentEnd:"*/",lineComment:"//",fold:"brace"}});function words(str){var obj={},words=str.split(" ");for(var i=0;i<words.length;++i)obj[words[i]]=true;return obj}function contains(words,word){if(typeof words==="function"){return words(word)}else{return words.propertyIsEnumerable(word)}}var cKeywords="auto if break case register continue return default do sizeof "+"static else struct switch extern typedef union for goto while enum const volatile";var cTypes="int long char short double float unsigned signed void size_t ptrdiff_t";function cppHook(stream,state){if(!state.startOfLine)return false;for(var ch,next=null;ch=stream.peek();){if(ch=="\\"&&stream.match(/^.$/)){next=cppHook;break}else if(ch=="/"&&stream.match(/^\/[\/\*]/,false)){break}stream.next()}state.tokenize=next;return"meta"}function pointerHook(_stream,state){if(state.prevToken=="type")return"type";return false}function cpp14Literal(stream){stream.eatWhile(/[\w\.']/);return"number"}function cpp11StringHook(stream,state){stream.backUp(1);if(stream.match(/(R|u8R|uR|UR|LR)/)){var match=stream.match(/"([^\s\\()]{0,16})\(/);if(!match){return false}state.cpp11RawStringDelim=match[1];state.tokenize=tokenRawString;return tokenRawString(stream,state)}if(stream.match(/(u8|u|U|L)/)){if(stream.match(/["']/,false)){return"string"}return false}stream.next();return false}function cppLooksLikeConstructor(word){var lastTwo=/(\w+)::~?(\w+)$/.exec(word);return lastTwo&&lastTwo[1]==lastTwo[2]}function tokenAtString(stream,state){var next;while((next=stream.next())!=null){if(next=='"'&&!stream.eat('"')){state.tokenize=null;break}}return"string"}function tokenRawString(stream,state){var delim=state.cpp11RawStringDelim.replace(/[^\w\s]/g,"\\$&");var match=stream.match(new RegExp(".*?\\)"+delim+'"'));if(match)state.tokenize=null;else stream.skipToEnd();return"string"}function def(mimes,mode){if(typeof mimes=="string")mimes=[mimes];var words=[];function add(obj){if(obj)for(var prop in obj)if(obj.hasOwnProperty(prop))words.push(prop)}add(mode.keywords);add(mode.types);add(mode.builtin);add(mode.atoms);if(words.length){mode.helperType=mimes[0];CodeMirror.registerHelper("hintWords",mimes[0],words)}for(var i=0;i<mimes.length;++i)CodeMirror.defineMIME(mimes[i],mode)}def(["text/x-csrc","text/x-c","text/x-chdr"],{name:"clike",keywords:words(cKeywords),types:words(cTypes+" bool _Complex _Bool float_t double_t intptr_t intmax_t "+"int8_t int16_t int32_t int64_t uintptr_t uintmax_t uint8_t uint16_t "+"uint32_t uint64_t"),blockKeywords:words("case do else for if switch while struct"),defKeywords:words("struct"),typeFirstDefinitions:true,atoms:words("null true false"),hooks:{"#":cppHook,"*":pointerHook},modeProps:{fold:["brace","include"]}});def(["text/x-c++src","text/x-c++hdr"],{name:"clike",keywords:words(cKeywords+" asm dynamic_cast namespace reinterpret_cast try explicit new "+"static_cast typeid catch operator template typename class friend private "+"this using const_cast inline public throw virtual delete mutable protected "+"alignas alignof constexpr decltype nullptr noexcept thread_local final "+"static_assert override"),types:words(cTypes+" bool wchar_t"),blockKeywords:words("catch class do else finally for if struct switch try while"),defKeywords:words("class namespace struct enum union"),typeFirstDefinitions:true,atoms:words("true false null"),dontIndentStatements:/^template$/,isIdentifierChar:/[\w\$_~\xa1-\uffff]/,hooks:{"#":cppHook,"*":pointerHook,u:cpp11StringHook,U:cpp11StringHook,L:cpp11StringHook,R:cpp11StringHook,0:cpp14Literal,1:cpp14Literal,2:cpp14Literal,3:cpp14Literal,4:cpp14Literal,5:cpp14Literal,6:cpp14Literal,7:cpp14Literal,8:cpp14Literal,9:cpp14Literal,token:function(stream,state,style){if(style=="variable"&&stream.peek()=="("&&(state.prevToken==";"||state.prevToken==null||state.prevToken=="}")&&cppLooksLikeConstructor(stream.current()))return"def"}},namespaceSeparator:"::",modeProps:{fold:["brace","include"]}});def("text/x-java",{name:"clike",keywords:words("abstract assert break case catch class const continue default "+"do else enum extends final finally float for goto if implements import "+"instanceof interface native new package private protected public "+"return static strictfp super switch synchronized this throw throws transient "+"try volatile while @interface"),types:words("byte short int long float double boolean char void Boolean Byte Character Double Float "+"Integer Long Number Object Short String StringBuffer StringBuilder Void"),blockKeywords:words("catch class do else finally for if switch try while"),defKeywords:words("class interface package enum @interface"),typeFirstDefinitions:true,atoms:words("true false null"),number:/^(?:0x[a-f\d_]+|0b[01_]+|(?:[\d_]+\.?\d*|\.\d+)(?:e[-+]?[\d_]+)?)(u|ll?|l|f)?/i,hooks:{"@":function(stream){if(stream.match("interface",false))return false;stream.eatWhile(/[\w\$_]/);return"meta"}},modeProps:{fold:["brace","import"]}});def("text/x-csharp",{name:"clike",keywords:words("abstract as async await base break case catch checked class const continue"+" default delegate do else enum event explicit extern finally fixed for"+" foreach goto if implicit in interface internal is lock namespace new"+" operator out override params private protected public readonly ref return sealed"+" sizeof stackalloc static struct switch this throw try typeof unchecked"+" unsafe using virtual void volatile while add alias ascending descending dynamic from get"+" global group into join let orderby partial remove select set value var yield"),types:words("Action Boolean Byte Char DateTime DateTimeOffset Decimal Double Func"+" Guid Int16 Int32 Int64 Object SByte Single String Task TimeSpan UInt16 UInt32"+" UInt64 bool byte char decimal double short int long object"+" sbyte float string ushort uint ulong"),blockKeywords:words("catch class do else finally for foreach if struct switch try while"),defKeywords:words("class interface namespace struct var"),typeFirstDefinitions:true,atoms:words("true false null"),hooks:{"@":function(stream,state){if(stream.eat('"')){state.tokenize=tokenAtString;return tokenAtString(stream,state)}stream.eatWhile(/[\w\$_]/);return"meta"}}});function tokenTripleString(stream,state){var escaped=false;while(!stream.eol()){if(!escaped&&stream.match('"""')){state.tokenize=null;break}escaped=stream.next()=="\\"&&!escaped}return"string"}def("text/x-scala",{name:"clike",keywords:words("abstract case catch class def do else extends final finally for forSome if "+"implicit import lazy match new null object override package private protected return "+"sealed super this throw trait try type val var while with yield _ "+"assert assume require print println printf readLine readBoolean readByte readShort "+"readChar readInt readLong readFloat readDouble"),types:words("AnyVal App Application Array BufferedIterator BigDecimal BigInt Char Console Either "+"Enumeration Equiv Error Exception Fractional Function IndexedSeq Int Integral Iterable "+"Iterator List Map Numeric Nil NotNull Option Ordered Ordering PartialFunction PartialOrdering "+"Product Proxy Range Responder Seq Serializable Set Specializable Stream StringBuilder "+"StringContext Symbol Throwable Traversable TraversableOnce Tuple Unit Vector "+"Boolean Byte Character CharSequence Class ClassLoader Cloneable Comparable "+"Compiler Double Exception Float Integer Long Math Number Object Package Pair Process "+"Runtime Runnable SecurityManager Short StackTraceElement StrictMath String "+"StringBuffer System Thread ThreadGroup ThreadLocal Throwable Triple Void"),multiLineStrings:true,blockKeywords:words("catch class enum do else finally for forSome if match switch try while"),defKeywords:words("class enum def object package trait type val var"),atoms:words("true false null"),indentStatements:false,indentSwitch:false,isOperatorChar:/[+\-*&%=<>!?|\/#:@]/,hooks:{"@":function(stream){stream.eatWhile(/[\w\$_]/);return"meta"},'"':function(stream,state){if(!stream.match('""'))return false;state.tokenize=tokenTripleString;return state.tokenize(stream,state)},"'":function(stream){stream.eatWhile(/[\w\$_\xa1-\uffff]/);return"atom"},"=":function(stream,state){var cx=state.context;if(cx.type=="}"&&cx.align&&stream.eat(">")){state.context=new Context(cx.indented,cx.column,cx.type,cx.info,null,cx.prev);return"operator"}else{return false}}},modeProps:{closeBrackets:{triples:'"'}}});function tokenKotlinString(tripleString){return function(stream,state){var escaped=false,next,end=false;while(!stream.eol()){if(!tripleString&&!escaped&&stream.match('"')){end=true;break}if(tripleString&&stream.match('"""')){end=true;break}next=stream.next();if(!escaped&&next=="$"&&stream.match("{"))stream.skipTo("}");escaped=!escaped&&next=="\\"&&!tripleString}if(end||!tripleString)state.tokenize=null;return"string"}}def("text/x-kotlin",{name:"clike",keywords:words("package as typealias class interface this super val "+"var fun for is in This throw return "+"break continue object if else while do try when !in !is as? "+"file import where by get set abstract enum open inner override private public internal "+"protected catch finally out final vararg reified dynamic companion constructor init "+"sealed field property receiver param sparam lateinit data inline noinline tailrec "+"external annotation crossinline const operator infix suspend"),types:words("Boolean Byte Character CharSequence Class ClassLoader Cloneable Comparable "+"Compiler Double Exception Float Integer Long Math Number Object Package Pair Process "+"Runtime Runnable SecurityManager Short StackTraceElement StrictMath String "+"StringBuffer System Thread ThreadGroup ThreadLocal Throwable Triple Void"),intendSwitch:false,indentStatements:false,multiLineStrings:true,number:/^(?:0x[a-f\d_]+|0b[01_]+|(?:[\d_]+\.?\d*|\.\d+)(?:e[-+]?[\d_]+)?)(u|ll?|l|f)?/i,blockKeywords:words("catch class do else finally for if where try while enum"),defKeywords:words("class val var object package interface fun"),atoms:words("true false null this"),hooks:{'"':function(stream,state){state.tokenize=tokenKotlinString(stream.match('""'));return state.tokenize(stream,state)}},modeProps:{closeBrackets:{triples:'"'}}});def(["x-shader/x-vertex","x-shader/x-fragment"],{name:"clike",keywords:words("sampler1D sampler2D sampler3D samplerCube "+"sampler1DShadow sampler2DShadow "+"const attribute uniform varying "+"break continue discard return "+"for while do if else struct "+"in out inout"),types:words("float int bool void "+"vec2 vec3 vec4 ivec2 ivec3 ivec4 bvec2 bvec3 bvec4 "+"mat2 mat3 mat4"),blockKeywords:words("for while do if else struct"),builtin:words("radians degrees sin cos tan asin acos atan "+"pow exp log exp2 sqrt inversesqrt "+"abs sign floor ceil fract mod min max clamp mix step smoothstep "+"length distance dot cross normalize ftransform faceforward "+"reflect refract matrixCompMult "+"lessThan lessThanEqual greaterThan greaterThanEqual "+"equal notEqual any all not "+"texture1D texture1DProj texture1DLod texture1DProjLod "+"texture2D texture2DProj texture2DLod texture2DProjLod "+"texture3D texture3DProj texture3DLod texture3DProjLod "+"textureCube textureCubeLod "+"shadow1D shadow2D shadow1DProj shadow2DProj "+"shadow1DLod shadow2DLod shadow1DProjLod shadow2DProjLod "+"dFdx dFdy fwidth "+"noise1 noise2 noise3 noise4"),atoms:words("true false "+"gl_FragColor gl_SecondaryColor gl_Normal gl_Vertex "+"gl_MultiTexCoord0 gl_MultiTexCoord1 gl_MultiTexCoord2 gl_MultiTexCoord3 "+"gl_MultiTexCoord4 gl_MultiTexCoord5 gl_MultiTexCoord6 gl_MultiTexCoord7 "+"gl_FogCoord gl_PointCoord "+"gl_Position gl_PointSize gl_ClipVertex "+"gl_FrontColor gl_BackColor gl_FrontSecondaryColor gl_BackSecondaryColor "+"gl_TexCoord gl_FogFragCoord "+"gl_FragCoord gl_FrontFacing "+"gl_FragData gl_FragDepth "+"gl_ModelViewMatrix gl_ProjectionMatrix gl_ModelViewProjectionMatrix "+"gl_TextureMatrix gl_NormalMatrix gl_ModelViewMatrixInverse "+"gl_ProjectionMatrixInverse gl_ModelViewProjectionMatrixInverse "+"gl_TexureMatrixTranspose gl_ModelViewMatrixInverseTranspose "+"gl_ProjectionMatrixInverseTranspose "+"gl_ModelViewProjectionMatrixInverseTranspose "+"gl_TextureMatrixInverseTranspose "+"gl_NormalScale gl_DepthRange gl_ClipPlane "+"gl_Point gl_FrontMaterial gl_BackMaterial gl_LightSource gl_LightModel "+"gl_FrontLightModelProduct gl_BackLightModelProduct "+"gl_TextureColor gl_EyePlaneS gl_EyePlaneT gl_EyePlaneR gl_EyePlaneQ "+"gl_FogParameters "+"gl_MaxLights gl_MaxClipPlanes gl_MaxTextureUnits gl_MaxTextureCoords "+"gl_MaxVertexAttribs gl_MaxVertexUniformComponents gl_MaxVaryingFloats "+"gl_MaxVertexTextureImageUnits gl_MaxTextureImageUnits "+"gl_MaxFragmentUniformComponents gl_MaxCombineTextureImageUnits "+"gl_MaxDrawBuffers"),indentSwitch:false,hooks:{"#":cppHook},modeProps:{fold:["brace","include"]}});def("text/x-nesc",{name:"clike",keywords:words(cKeywords+"as atomic async call command component components configuration event generic "+"implementation includes interface module new norace nx_struct nx_union post provides "+"signal task uses abstract extends"),types:words(cTypes),blockKeywords:words("case do else for if switch while struct"),atoms:words("null true false"),hooks:{"#":cppHook},modeProps:{fold:["brace","include"]}});def("text/x-objectivec",{name:"clike",keywords:words(cKeywords+"inline restrict _Bool _Complex _Imaginary BOOL Class bycopy byref id IMP in "+"inout nil oneway out Protocol SEL self super atomic nonatomic retain copy readwrite readonly"),types:words(cTypes),atoms:words("YES NO NULL NILL ON OFF true false"),hooks:{"@":function(stream){stream.eatWhile(/[\w\$]/);return"keyword"},"#":cppHook,indent:function(_state,ctx,textAfter){if(ctx.type=="statement"&&/^@\w/.test(textAfter))return ctx.indented}},modeProps:{fold:"brace"}});def("text/x-squirrel",{name:"clike",keywords:words("base break clone continue const default delete enum extends function in class"+" foreach local resume return this throw typeof yield constructor instanceof static"),types:words(cTypes),blockKeywords:words("case catch class else for foreach if switch try while"),defKeywords:words("function local class"),typeFirstDefinitions:true,atoms:words("true false null"),hooks:{"#":cppHook},modeProps:{fold:["brace","include"]}});var stringTokenizer=null;function tokenCeylonString(type){return function(stream,state){var escaped=false,next,end=false;while(!stream.eol()){if(!escaped&&stream.match('"')&&(type=="single"||stream.match('""'))){end=true;break}if(!escaped&&stream.match("``")){stringTokenizer=tokenCeylonString(type);end=true;break}next=stream.next();escaped=type=="single"&&!escaped&&next=="\\"}if(end)state.tokenize=null;return"string"}}def("text/x-ceylon",{name:"clike",keywords:words("abstracts alias assembly assert assign break case catch class continue dynamic else"+" exists extends finally for function given if import in interface is let module new"+" nonempty object of out outer package return satisfies super switch then this throw"+" try value void while"),types:function(word){var first=word.charAt(0);return first===first.toUpperCase()&&first!==first.toLowerCase()},blockKeywords:words("case catch class dynamic else finally for function if interface module new object switch try while"),defKeywords:words("class dynamic function interface module object package value"),builtin:words("abstract actual aliased annotation by default deprecated doc final formal late license"+" native optional sealed see serializable shared suppressWarnings tagged throws variable"),isPunctuationChar:/[\[\]{}\(\),;\:\.`]/,isOperatorChar:/[+\-*&%=<>!?|^~:\/]/,numberStart:/[\d#$]/,number:/^(?:#[\da-fA-F_]+|\$[01_]+|[\d_]+[kMGTPmunpf]?|[\d_]+\.[\d_]+(?:[eE][-+]?\d+|[kMGTPmunpf]|)|)/i,multiLineStrings:true,typeFirstDefinitions:true,atoms:words("true false null larger smaller equal empty finished"),indentSwitch:false,styleDefs:false,hooks:{"@":function(stream){stream.eatWhile(/[\w\$_]/);return"meta"},'"':function(stream,state){state.tokenize=tokenCeylonString(stream.match('""')?"triple":"single");return state.tokenize(stream,state)},"`":function(stream,state){if(!stringTokenizer||!stream.match("`"))return false;state.tokenize=stringTokenizer;stringTokenizer=null;return state.tokenize(stream,state)},"'":function(stream){stream.eatWhile(/[\w\$_\xa1-\uffff]/);return"atom"},token:function(_stream,state,style){if((style=="variable"||style=="type")&&state.prevToken=="."){return"variable-2"}}},modeProps:{fold:["brace","import"],closeBrackets:{triples:'"'}}})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineMode("shell",function(){var words={};function define(style,string){var split=string.split(" ");for(var i=0;i<split.length;i++){words[split[i]]=style}}define("atom","true false");define("keyword","if then do else elif while until for in esac fi fin "+"fil done exit set unset export function");define("builtin","ab awk bash beep cat cc cd chown chmod chroot clear cp "+"curl cut diff echo find gawk gcc get git grep hg kill killall ln ls make "+"mkdir openssl mv nc node npm ping ps restart rm rmdir sed service sh "+"shopt shred source sort sleep ssh start stop su sudo svn tee telnet top "+"touch vi vim wall wc wget who write yes zsh");function tokenBase(stream,state){if(stream.eatSpace())return null;var sol=stream.sol();var ch=stream.next();if(ch==="\\"){stream.next();return null}if(ch==="'"||ch==='"'||ch==="`"){state.tokens.unshift(tokenString(ch,ch==="`"?"quote":"string"));return tokenize(stream,state)}if(ch==="#"){if(sol&&stream.eat("!")){stream.skipToEnd();return"meta"}stream.skipToEnd();return"comment"}if(ch==="$"){state.tokens.unshift(tokenDollar);return tokenize(stream,state)}if(ch==="+"||ch==="="){return"operator"}if(ch==="-"){stream.eat("-");stream.eatWhile(/\w/);return"attribute"}if(/\d/.test(ch)){stream.eatWhile(/\d/);if(stream.eol()||!/\w/.test(stream.peek())){return"number"}}stream.eatWhile(/[\w-]/);var cur=stream.current();if(stream.peek()==="="&&/\w+/.test(cur))return"def";return words.hasOwnProperty(cur)?words[cur]:null}function tokenString(quote,style){var close=quote=="("?")":quote=="{"?"}":quote;return function(stream,state){var next,end=false,escaped=false;while((next=stream.next())!=null){if(next===close&&!escaped){end=true;break}if(next==="$"&&!escaped&&quote!=="'"){escaped=true;stream.backUp(1);state.tokens.unshift(tokenDollar);break}if(!escaped&&next===quote&&quote!==close){state.tokens.unshift(tokenString(quote,style));return tokenize(stream,state)}escaped=!escaped&&next==="\\"}if(end||!escaped)state.tokens.shift();return style}}var tokenDollar=function(stream,state){if(state.tokens.length>1)stream.eat("$");var ch=stream.next();if(/['"({]/.test(ch)){state.tokens[0]=tokenString(ch,ch=="("?"quote":ch=="{"?"def":"string");return tokenize(stream,state)}if(!/\d/.test(ch))stream.eatWhile(/\w/);state.tokens.shift();return"def"};function tokenize(stream,state){return(state.tokens[0]||tokenBase)(stream,state)}return{startState:function(){return{tokens:[]}},token:function(stream,state){return tokenize(stream,state)},closeBrackets:"()[]{}''\"\"``",lineComment:"#",fold:"brace"}});CodeMirror.defineMIME("text/x-sh","shell")});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var htmlConfig={autoSelfClosers:{area:true,base:true,br:true,col:true,command:true,embed:true,frame:true,hr:true,img:true,input:true,keygen:true,link:true,meta:true,param:true,source:true,track:true,wbr:true,menuitem:true},implicitlyClosed:{dd:true,li:true,optgroup:true,option:true,p:true,rp:true,rt:true,tbody:true,td:true,tfoot:true,th:true,tr:true},contextGrabbers:{dd:{dd:true,dt:true},dt:{dd:true,dt:true},li:{li:true},option:{option:true,optgroup:true},optgroup:{optgroup:true},p:{address:true,article:true,aside:true,blockquote:true,dir:true,div:true,dl:true,fieldset:true,footer:true,form:true,h1:true,h2:true,h3:true,h4:true,h5:true,h6:true,header:true,hgroup:true,hr:true,menu:true,nav:true,ol:true,p:true,pre:true,section:true,table:true,ul:true},rp:{rp:true,rt:true},rt:{rp:true,rt:true},tbody:{tbody:true,tfoot:true},td:{td:true,th:true},tfoot:{tbody:true},th:{td:true,th:true},thead:{tbody:true,tfoot:true},tr:{tr:true}},doNotIndent:{pre:true},allowUnquoted:true,allowMissing:true,caseFold:true};var xmlConfig={autoSelfClosers:{},implicitlyClosed:{},contextGrabbers:{},doNotIndent:{},allowUnquoted:false,allowMissing:false,caseFold:false};CodeMirror.defineMode("xml",function(editorConf,config_){var indentUnit=editorConf.indentUnit;var config={};var defaults=config_.htmlMode?htmlConfig:xmlConfig;for(var prop in defaults)config[prop]=defaults[prop];for(var prop in config_)config[prop]=config_[prop];var type,setStyle;function inText(stream,state){function chain(parser){state.tokenize=parser;return parser(stream,state)}var ch=stream.next();if(ch=="<"){if(stream.eat("!")){if(stream.eat("[")){if(stream.match("CDATA["))return chain(inBlock("atom","]]>"));else return null}else if(stream.match("--")){return chain(inBlock("comment","--\x3e"))}else if(stream.match("DOCTYPE",true,true)){stream.eatWhile(/[\w\._\-]/);return chain(doctype(1))}else{return null}}else if(stream.eat("?")){stream.eatWhile(/[\w\._\-]/);state.tokenize=inBlock("meta","?>");return"meta"}else{type=stream.eat("/")?"closeTag":"openTag";state.tokenize=inTag;return"tag bracket"}}else if(ch=="&"){var ok;if(stream.eat("#")){if(stream.eat("x")){ok=stream.eatWhile(/[a-fA-F\d]/)&&stream.eat(";")}else{ok=stream.eatWhile(/[\d]/)&&stream.eat(";")}}else{ok=stream.eatWhile(/[\w\.\-:]/)&&stream.eat(";")}return ok?"atom":"error"}else{stream.eatWhile(/[^&<]/);return null}}inText.isInText=true;function inTag(stream,state){var ch=stream.next();if(ch==">"||ch=="/"&&stream.eat(">")){state.tokenize=inText;type=ch==">"?"endTag":"selfcloseTag";return"tag bracket"}else if(ch=="="){type="equals";return null}else if(ch=="<"){state.tokenize=inText;state.state=baseState;state.tagName=state.tagStart=null;var next=state.tokenize(stream,state);return next?next+" tag error":"tag error"}else if(/[\'\"]/.test(ch)){state.tokenize=inAttribute(ch);state.stringStartCol=stream.column();return state.tokenize(stream,state)}else{stream.match(/^[^\s\u00a0=<>\"\']*[^\s\u00a0=<>\"\'\/]/);return"word"}}function inAttribute(quote){var closure=function(stream,state){while(!stream.eol()){if(stream.next()==quote){state.tokenize=inTag;break}}return"string"};closure.isInAttribute=true;return closure}function inBlock(style,terminator){return function(stream,state){while(!stream.eol()){if(stream.match(terminator)){state.tokenize=inText;break}stream.next()}return style}}function doctype(depth){return function(stream,state){var ch;while((ch=stream.next())!=null){if(ch=="<"){state.tokenize=doctype(depth+1);return state.tokenize(stream,state)}else if(ch==">"){if(depth==1){state.tokenize=inText;break}else{state.tokenize=doctype(depth-1);return state.tokenize(stream,state)}}}return"meta"}}function Context(state,tagName,startOfLine){this.prev=state.context;this.tagName=tagName;this.indent=state.indented;this.startOfLine=startOfLine;if(config.doNotIndent.hasOwnProperty(tagName)||state.context&&state.context.noIndent)this.noIndent=true}function popContext(state){if(state.context)state.context=state.context.prev}function maybePopContext(state,nextTagName){var parentTagName;while(true){if(!state.context){return}parentTagName=state.context.tagName;if(!config.contextGrabbers.hasOwnProperty(parentTagName)||!config.contextGrabbers[parentTagName].hasOwnProperty(nextTagName)){return}popContext(state)}}function baseState(type,stream,state){if(type=="openTag"){state.tagStart=stream.column();return tagNameState}else if(type=="closeTag"){return closeTagNameState}else{return baseState}}function tagNameState(type,stream,state){if(type=="word"){state.tagName=stream.current();setStyle="tag";return attrState}else{setStyle="error";return tagNameState}}function closeTagNameState(type,stream,state){if(type=="word"){var tagName=stream.current();if(state.context&&state.context.tagName!=tagName&&config.implicitlyClosed.hasOwnProperty(state.context.tagName))popContext(state);if(state.context&&state.context.tagName==tagName||config.matchClosing===false){setStyle="tag";return closeState}else{setStyle="tag error";return closeStateErr}}else{setStyle="error";return closeStateErr}}function closeState(type,_stream,state){if(type!="endTag"){setStyle="error";return closeState}popContext(state);return baseState}function closeStateErr(type,stream,state){setStyle="error";return closeState(type,stream,state)}function attrState(type,_stream,state){if(type=="word"){setStyle="attribute";return attrEqState}else if(type=="endTag"||type=="selfcloseTag"){var tagName=state.tagName,tagStart=state.tagStart;state.tagName=state.tagStart=null;if(type=="selfcloseTag"||config.autoSelfClosers.hasOwnProperty(tagName)){maybePopContext(state,tagName)}else{maybePopContext(state,tagName);state.context=new Context(state,tagName,tagStart==state.indented)}return baseState}setStyle="error";return attrState}function attrEqState(type,stream,state){if(type=="equals")return attrValueState;if(!config.allowMissing)setStyle="error";return attrState(type,stream,state)}function attrValueState(type,stream,state){if(type=="string")return attrContinuedState;if(type=="word"&&config.allowUnquoted){setStyle="string";return attrState}setStyle="error";return attrState(type,stream,state)}function attrContinuedState(type,stream,state){if(type=="string")return attrContinuedState;return attrState(type,stream,state)}return{startState:function(baseIndent){var state={tokenize:inText,state:baseState,indented:baseIndent||0,tagName:null,tagStart:null,context:null};if(baseIndent!=null)state.baseIndent=baseIndent;return state},token:function(stream,state){if(!state.tagName&&stream.sol())state.indented=stream.indentation();if(stream.eatSpace())return null;type=null;var style=state.tokenize(stream,state);if((style||type)&&style!="comment"){setStyle=null;state.state=state.state(type||style,stream,state);if(setStyle)style=setStyle=="error"?style+" error":setStyle}return style},indent:function(state,textAfter,fullLine){var context=state.context;if(state.tokenize.isInAttribute){if(state.tagStart==state.indented)return state.stringStartCol+1;else return state.indented+indentUnit}if(context&&context.noIndent)return CodeMirror.Pass;if(state.tokenize!=inTag&&state.tokenize!=inText)return fullLine?fullLine.match(/^(\s*)/)[0].length:0;if(state.tagName){if(config.multilineTagIndentPastTag!==false)return state.tagStart+state.tagName.length+2;else return state.tagStart+indentUnit*(config.multilineTagIndentFactor||1)}if(config.alignCDATA&&/<!\[CDATA\[/.test(textAfter))return 0;var tagAfter=textAfter&&/^<(\/)?([\w_:\.-]*)/.exec(textAfter);if(tagAfter&&tagAfter[1]){while(context){if(context.tagName==tagAfter[2]){context=context.prev;break}else if(config.implicitlyClosed.hasOwnProperty(context.tagName)){context=context.prev}else{break}}}else if(tagAfter){while(context){var grabbers=config.contextGrabbers[context.tagName];if(grabbers&&grabbers.hasOwnProperty(tagAfter[2]))context=context.prev;else break}}while(context&&context.prev&&!context.startOfLine)context=context.prev;if(context)return context.indent+indentUnit;else return state.baseIndent||0},electricInput:/<\/[\s\w:]+>$/,blockCommentStart:"\x3c!--",blockCommentEnd:"--\x3e",configuration:config.htmlMode?"html":"xml",helperType:config.htmlMode?"html":"xml",skipAttribute:function(state){if(state.state==attrValueState)state.state=attrState}}});CodeMirror.defineMIME("text/xml","xml");CodeMirror.defineMIME("application/xml","xml");if(!CodeMirror.mimeModes.hasOwnProperty("text/html"))CodeMirror.defineMIME("text/html",{name:"xml",htmlMode:true})});(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"),require("../xml/xml"),require("../javascript/javascript"),require("../css/css"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror","../xml/xml","../javascript/javascript","../css/css"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var defaultTags={script:[["lang",/(javascript|babel)/i,"javascript"],["type",/^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^module$|^$/i,"javascript"],["type",/./,"text/plain"],[null,null,"javascript"]],style:[["lang",/^css$/i,"css"],["type",/^(text\/)?(x-)?(stylesheet|css)$/i,"css"],["type",/./,"text/plain"],[null,null,"css"]]};function maybeBackup(stream,pat,style){var cur=stream.current(),close=cur.search(pat);if(close>-1){stream.backUp(cur.length-close)}else if(cur.match(/<\/?$/)){stream.backUp(cur.length);if(!stream.match(pat,false))stream.match(cur)}return style}var attrRegexpCache={};function getAttrRegexp(attr){var regexp=attrRegexpCache[attr];if(regexp)return regexp;return attrRegexpCache[attr]=new RegExp("\\s+"+attr+"\\s*=\\s*('|\")?([^'\"]+)('|\")?\\s*")}function getAttrValue(text,attr){var match=text.match(getAttrRegexp(attr));return match?/^\s*(.*?)\s*$/.exec(match[2])[1]:""}function getTagRegexp(tagName,anchored){return new RegExp((anchored?"^":"")+"</s*"+tagName+"s*>","i")}function addTags(from,to){for(var tag in from){var dest=to[tag]||(to[tag]=[]);var source=from[tag];for(var i=source.length-1;i>=0;i--)dest.unshift(source[i])}}function findMatchingMode(tagInfo,tagText){for(var i=0;i<tagInfo.length;i++){var spec=tagInfo[i];if(!spec[0]||spec[1].test(getAttrValue(tagText,spec[0])))return spec[2]}}CodeMirror.defineMode("htmlmixed",function(config,parserConfig){var htmlMode=CodeMirror.getMode(config,{name:"xml",htmlMode:true,multilineTagIndentFactor:parserConfig.multilineTagIndentFactor,multilineTagIndentPastTag:parserConfig.multilineTagIndentPastTag});var tags={};var configTags=parserConfig&&parserConfig.tags,configScript=parserConfig&&parserConfig.scriptTypes;addTags(defaultTags,tags);if(configTags)addTags(configTags,tags);if(configScript)for(var i=configScript.length-1;i>=0;i--)tags.script.unshift(["type",configScript[i].matches,configScript[i].mode]);function html(stream,state){var style=htmlMode.token(stream,state.htmlState),tag=/\btag\b/.test(style),tagName;if(tag&&!/[<>\s\/]/.test(stream.current())&&(tagName=state.htmlState.tagName&&state.htmlState.tagName.toLowerCase())&&tags.hasOwnProperty(tagName)){state.inTag=tagName+" "}else if(state.inTag&&tag&&/>$/.test(stream.current())){var inTag=/^([\S]+) (.*)/.exec(state.inTag);state.inTag=null;var modeSpec=stream.current()==">"&&findMatchingMode(tags[inTag[1]],inTag[2]);var mode=CodeMirror.getMode(config,modeSpec);var endTagA=getTagRegexp(inTag[1],true),endTag=getTagRegexp(inTag[1],false);state.token=function(stream,state){if(stream.match(endTagA,false)){state.token=html;state.localState=state.localMode=null;return null}return maybeBackup(stream,endTag,state.localMode.token(stream,state.localState))};state.localMode=mode;state.localState=CodeMirror.startState(mode,htmlMode.indent(state.htmlState,""))}else if(state.inTag){state.inTag+=stream.current();if(stream.eol())state.inTag+=" "}return style}return{startState:function(){var state=CodeMirror.startState(htmlMode);return{token:html,inTag:null,localMode:null,localState:null,htmlState:state}},copyState:function(state){var local;if(state.localState){local=CodeMirror.copyState(state.localMode,state.localState)}return{token:state.token,inTag:state.inTag,localMode:state.localMode,localState:local,htmlState:CodeMirror.copyState(htmlMode,state.htmlState)}},token:function(stream,state){return state.token(stream,state)},indent:function(state,textAfter,line){if(!state.localMode||/^\s*<\//.test(textAfter))return htmlMode.indent(state.htmlState,textAfter);else if(state.localMode.indent)return state.localMode.indent(state.localState,textAfter,line);else return CodeMirror.Pass},innerMode:function(state){return{state:state.localState||state.htmlState,mode:state.localMode||htmlMode}}}},"xml","javascript","css");CodeMirror.defineMIME("text/html","htmlmixed")});(function(){"use strict";function set(str){var obj={},words=str.split(" ");for(var i=0;i<words.length;++i)obj[words[i]]=true;return obj}CodeMirror.defineMIME("text/x-hivesql",{name:"sql",keywords:set("analyze show database describe add delete jar file archive temporary function sort distribute cluster overwrite alter and as asc between by count create desc distinct drop from having in insert into is join like not on or order group select set table union where "),builtin:set("tinyint smallint int bigint float double decimal timestamp date string varchar char boolean binary array map struct uniontype"),atoms:set("false true null"),operatorChars:/^[*+\-%<>!=]/,dateSQL:set("date timestamp"),support:set("zerolessFloat")});function hookDKUVar(stream){if(stream.peek()=="{"&&stream.match(/{[^}]*}/)){return"variable-2"}return null}CodeMirror.defineMIME("text/x-sql2",{name:"sql",keywords:set("alter and as asc between by count create delete desc distinct drop from having in insert into is join like not on or order select set table union update values where begin commit group"),builtin:set("bool boolean bit blob enum long longblob longtext medium mediumblob mediumint mediumtext time timestamp tinyblob tinyint tinytext text bigint int int1 int2 int3 int4 int8 integer float float4 float8 double char varbinary varchar varcharacter precision real date datetime year unsigned signed decimal numeric"),atoms:set("false true null unknown"),operatorChars:/^[*+\-%<>!=]/,dateSQL:set("date time timestamp"),support:set("ODBCdotTable doubleQuote binaryNumber hexNumber"),hooks:{$:hookDKUVar}})})();(function(){"use strict";var pigKeywords="VOID IMPORT RETURNS DEFINE FILTER FOREACH ORDER CUBE DISTINCT COGROUP "+"JOIN CROSS UNION SPLIT INTO IF OTHERWISE ALL AS BY USING INNER OUTER ONSCHEMA PARALLEL "+"PARTITION GROUP AND OR NOT GENERATE FLATTEN ASC DESC IS STREAM THROUGH MAPREDUCE "+"SHIP CACHE INPUT OUTPUT STDERROR STDIN STDOUT DKUSTORE LIMIT SAMPLE LEFT RIGHT FULL EQ GT LT GTE LTE "+"NEQ MATCHES TRUE FALSE";var pigKeywordsU=pigKeywords.split(" ");var pigTypes="BOOLEAN INT LONG FLOAT DOUBLE CHARARRAY BYTEARRAY BAG TUPLE MAP";var pigTypesU=pigTypes.split(" ");var pigTypesL=pigTypes.toLowerCase().split(" ");var pigBuiltins="ABS ACOS ARITY ASIN ATAN AVG BAGSIZE BINSTORAGE BLOOM BUILDBLOOM CBRT CEIL "+"CONCAT COR COS COSH COUNT COUNT_STAR COV CONSTANTSIZE CUBEDIMENSIONS DIFF DISTINCT DOUBLEABS "+"DOUBLEAVG DOUBLEBASE DOUBLEMAX DOUBLEMIN DOUBLEROUND DOUBLESUM EXP FLOOR FLOATABS FLOATAVG "+"FLOATMAX FLOATMIN FLOATROUND FLOATSUM GENERICINVOKER INDEXOF INTABS INTAVG INTMAX INTMIN "+"INTSUM INVOKEFORDOUBLE INVOKEFORFLOAT INVOKEFORINT INVOKEFORLONG INVOKEFORSTRING INVOKER "+"ISEMPTY JSONLOADER JSONMETADATA JSONSTORAGE LAST_INDEX_OF LCFIRST LOG LOG10 LOWER LONGABS "+"LONGAVG LONGMAX LONGMIN LONGSUM MAX MIN MAPSIZE MONITOREDUDF NONDETERMINISTIC OUTPUTSCHEMA  "+"PIGSTORAGE PIGSTREAMING RANDOM REGEX_EXTRACT REGEX_EXTRACT_ALL REPLACE ROUND SIN SINH SIZE "+"SQRT STRSPLIT SUBSTRING SUM STRINGCONCAT STRINGMAX STRINGMIN STRINGSIZE TAN TANH TOBAG "+"TOKENIZE TOMAP TOP TOTUPLE TRIM TEXTLOADER TUPLESIZE UCFIRST UPPER UTF8STORAGECONVERTER";var pigBuiltinsU=pigBuiltins.split(" ").join("() ").split(" ");var pigBuiltinsC=("BagSize BinStorage Bloom BuildBloom ConstantSize CubeDimensions DoubleAbs "+"DoubleAvg DoubleBase DoubleMax DoubleMin DoubleRound DoubleSum FloatAbs FloatAvg FloatMax "+"FloatMin FloatRound FloatSum GenericInvoker IntAbs IntAvg IntMax IntMin IntSum "+"InvokeForDouble InvokeForFloat InvokeForInt InvokeForLong InvokeForString Invoker "+"IsEmpty JsonLoader JsonMetadata JsonStorage LongAbs LongAvg LongMax LongMin LongSum MapSize "+"MonitoredUDF Nondeterministic OutputSchema PigStorage PigStreaming StringConcat StringMax "+"StringMin StringSize TextLoader TupleSize Utf8StorageConverter").split(" ").join("() ").split(" ");function maybeAdd(str,tkstr,list){tkstr=(tkstr||"").trim().toLowerCase();var chkstr=(str||"").trim().toLowerCase();if(chkstr.indexOf(tkstr)==0&&list.indexOf(str)==-1){list.push(str)}}function extractAllNamesRecursive(relations){var out=[];if(!relations){return out}for(var k in relations){var field=relations[k];if(field.name){out.push(field.name)}if(field.fields){out=out.concat(extractAllNamesRecursive(field.fields))}}return out.filter(function(elm,idx){return out.indexOf(elm)==idx})}function extractRootNames(relations){var out=[];if(!relations){return out}for(var k in relations){var field=relations[k];out.push(field.name)}return out}function extractNonRootNames(relations){var root=extractRootNames(relations);var all=extractAllNamesRecursive(relations);return all.filter(function(elm){return root.indexOf(elm)==-1})}function namedToken(val){var fn=function(tok){var tokval=tok.string;return(tokval||"").toLowerCase()===(val||"").toLowerCase()};fn.ruleName='token "'+val+'"';return fn}function typedToken(type){var fn=function(tok){var toktype=tok.type;return(toktype||"").toLowerCase()===(type||"").toLowerCase()};fn.ruleName='type is "'+type+'"';return fn}function anyToken(){var fn=function(tok){return true};fn.ruleName="any";return fn}function nonSpaceToken(){var fn=function(tok){return!(tok.string.trim()=="")};fn.ruleName="non-space";return fn}function spaceToken(){var fn=function(tok){return tok.string.trim()==""};fn.ruleName="space";return fn}function hasAll(predicates){var fn=function(tok){for(var k in predicates){if(!predicates[k](tok)){return false}}return true};fn.ruleName="(";for(var k in predicates){if(fn.ruleName=="("){fn.ruleName+=predicates[k].ruleName}else{fn.ruleName+=" and "+predicates[k].ruleName}}fn.ruleName+=")";return fn}function isNot(predicate){var fn=function(tok){return!predicate(tok)};fn.ruleName="not ("+predicate.ruleName+")";return fn}function atLeastOneOf(predicates){var fn=function(tok){for(var k in predicates){if(predicates[k](tok)){return true}}return false};fn.ruleName="(";for(var k in predicates){if(fn.ruleName=="("){fn.ruleName+=predicates[k].ruleName}else{fn.ruleName+=" or "+predicates[k].ruleName}}fn.ruleName+=")";return fn}function addFixes(arr,prefix,suffix){var out=[];for(var k in arr){out.push(prefix+arr[k]+suffix)}return out}var suggestDatabase=[];suggestDatabase.push({pattern:[namedToken("DKULOAD"),spaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(context.inputs,replace+"'","';\n")}}});suggestDatabase.push({pattern:[namedToken("DKULOAD"),spaceToken(),nonSpaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(context.inputs,"'","';\n")}}});suggestDatabase.push({pattern:[namedToken("DKULOAD")],suggest:{group:1,values:function(context,replace){return addFixes(context.inputs,"DKULOAD '","';\n")}}});suggestDatabase.push({pattern:[nonSpaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(context.inputs,"DKULOAD '","';\n")}}});suggestDatabase.push({pattern:[namedToken("DKUSTORE"),spaceToken(),nonSpaceToken(),spaceToken(),namedToken("INTO"),spaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(context.outputs,replace+"'","';\n")}}});suggestDatabase.push({pattern:[namedToken("DKUSTORE"),spaceToken(),nonSpaceToken(),spaceToken(),nonSpaceToken()],suggest:{group:1,values:function(context){return addFixes(context.outputs,"INTO '","';\n")}}});suggestDatabase.push({pattern:[namedToken("DKUSTORE")],suggest:{group:1,values:function(context){return addFixes(extractRootNames(context.relations),"DKUSTORE "," INTO ")}}});suggestDatabase.push({pattern:[namedToken("DKUSTORE"),spaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(extractRootNames(context.relations),replace," INTO ")}}});suggestDatabase.push({pattern:[namedToken("DKUSTORE"),spaceToken(),nonSpaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(extractRootNames(context.relations),""," INTO ")}}});var followedByAlias=atLeastOneOf([namedToken("COGROUP"),namedToken("DISTINCT"),namedToken("CROSS"),namedToken("FILTER"),namedToken("FOREACH"),namedToken("GROUP"),namedToken("JOIN"),namedToken("LIMIT"),namedToken("ORDER"),namedToken("SPLIT"),namedToken("STORE"),namedToken("SAMPLE"),namedToken("STREAM"),namedToken("UNION"),namedToken(","),namedToken("DUMP"),namedToken("ILLUSTRATE")]);suggestDatabase.push({pattern:[followedByAlias],suggest:{group:0,values:function(context,replace){return addFixes(extractRootNames(context.relations),replace+" "," ")}}});suggestDatabase.push({pattern:[followedByAlias,spaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(extractRootNames(context.relations)," "," ")}}});function addUsualStatement(w1,w2){suggestDatabase.push({pattern:[namedToken(w1),spaceToken(),nonSpaceToken(),spaceToken()],suggest:{group:1,values:function(context,replace){return[replace+w2+" "]}}})}addUsualStatement("FOREACH","GENERATE");addUsualStatement("ORDER","BY");addUsualStatement("JOIN","BY");addUsualStatement("FILTER","BY");addUsualStatement("UNION",",");suggestDatabase.push({pattern:[namedToken(".")],suggest:{group:0,values:function(context,replace){return addFixes(extractNonRootNames(context.relations),replace,"")}}});suggestDatabase.push({pattern:[namedToken("."),nonSpaceToken()],suggest:{group:0,values:function(context,replace){return addFixes(extractNonRootNames(context.relations),"","")}}});suggestDatabase.push({pattern:[hasAll([namedToken(":"),isNot(typedToken("error"))])],suggest:{group:2,values:function(context,replace){return addFixes(pigTypesL,replace,"")}}});suggestDatabase.push({pattern:[namedToken("=")],suggest:{group:2,values:function(context,replace){return addFixes([].concat(pigBuiltinsU,pigBuiltinsC,pigTypesU,pigKeywordsU),replace+" "," ")}}});suggestDatabase.push({pattern:[anyToken()],suggest:{group:2,values:function(){return addFixes([].concat(pigBuiltinsU,pigBuiltinsC,pigTypesU,pigKeywordsU),""," ")}}});suggestDatabase.push({pattern:[nonSpaceToken()],suggest:{group:1,values:function(context,replace){return addFixes(extractAllNamesRecursive(context.relations),""," ")}}});suggestDatabase.push({pattern:[atLeastOneOf([namedToken(","),spaceToken()])],suggest:{group:2,values:function(context,replace){return addFixes(extractAllNamesRecursive(context.relations),replace," ")}}});function pigHintWithContext(editor,ctx){var context={inputs:[],outputs:[],relations:[]};if(ctx){context=ctx}var cur=editor.getCursor();var tokens=[];var ch=cur.ch;var lastAddedTokenLine=-1;var lastAddedTokenCh=-1;var stop=false;for(var l=cur.line;!stop&&l>=0;l--){for(let i=ch;!stop&&i>=0;i--){var currentToken=editor.getTokenAt({line:l,ch:i});if(currentToken.string.length>0&&currentToken.string[0]==";"){stop=true}if(!stop&&(currentToken.start!=lastAddedTokenCh||l!=lastAddedTokenLine)){var nextTokenIsSpace=false;if(tokens.length>0&&spaceToken()(tokens[0])){nextTokenIsSpace=true}if(spaceToken()(currentToken)&&!nextTokenIsSpace||!spaceToken()(currentToken)){tokens.unshift(currentToken)}lastAddedTokenLine=l;lastAddedTokenCh=currentToken.start}}if(l>0){ch=editor.getLine(l-1).length}}tokens.unshift({string:"",type:"begin",start:0,end:0});var producedCompletions=[];for(var k in suggestDatabase){while(suggestDatabase[k].suggest.group+1>producedCompletions.length){producedCompletions.push([])}}var matchedRules=0;for(let k in suggestDatabase){var suggestion=suggestDatabase[k];var ok=suggestion.pattern.length<=tokens.length;for(let i=tokens.length-1,j=suggestion.pattern.length-1;ok&&i>=0&&j>=0;i--,j--){if(!suggestion.pattern[j](tokens[i],context)){ok=false}}if(ok){var production=suggestion.suggest.values(context,tokens[tokens.length-1].string,tokens);producedCompletions[suggestion.suggest.group]=producedCompletions[suggestion.suggest.group].concat(production);matchedRules++}}for(let i=0;i<producedCompletions.length;i++){producedCompletions[i].sort()}var hasEmptyGroup=true;while(hasEmptyGroup){for(let i=0;i<producedCompletions.length;i++){if(producedCompletions[i].length==0){producedCompletions.splice(i,1);break}}hasEmptyGroup=false}var filteredCompletionList=[];for(let i=0;i<producedCompletions.length;i++){var completions=producedCompletions[i];for(var j in completions){maybeAdd(completions[j],tokens[tokens.length-1].string,filteredCompletionList)}}var set={};var finalCompletionList=[];for(let i=0;i<filteredCompletionList.length;i++){var str=filteredCompletionList[i];if(set[str]){continue}finalCompletionList.push(str);set[str]=true}return{list:finalCompletionList,from:{line:cur.line,ch:tokens[tokens.length-1].start},to:{line:cur.line,ch:tokens[tokens.length-1].end}}}CodeMirror.pigHintWithContext=pigHintWithContext})();CodeMirror.defineMode("dkupig",function(_config,parserConfig){var keywords=parserConfig.keywords,builtins=parserConfig.builtins,types=parserConfig.types,multiLineStrings=parserConfig.multiLineStrings;var isOperatorChar=/[*+\-%<>=&?:/!|]/;function chain(stream,state,f){state.tokenize=f;return f(stream,state)}var type;function ret(tp,style){type=tp;return style}function tokenComment(stream,state){var isEnd=false;var ch;while(ch=stream.next()){if(ch=="/"&&isEnd){state.tokenize=tokenBase;break}isEnd=ch=="*"}return ret("comment","comment")}function tokenString(quote){return function(stream,state){var escaped=false,next,end=false;while((next=stream.next())!=null){if(next==quote&&!escaped){end=true;break}escaped=!escaped&&next=="\\"}if(end||!(escaped||multiLineStrings))state.tokenize=tokenBase;return ret("string","error")}}function tokenBase(stream,state){var ch=stream.next();if(ch=='"'||ch=="'")return chain(stream,state,tokenString(ch));else if(/[[\]{}(),;.]/.test(ch))return ret(ch);else if(/\d/.test(ch)){stream.eatWhile(/[\w.]/);return ret("number","number")}else if(ch=="/"){if(stream.eat("*")){return chain(stream,state,tokenComment)}else{stream.eatWhile(isOperatorChar);return ret("operator","operator")}}else if(ch=="-"){if(stream.eat("-")){stream.skipToEnd();return ret("comment","comment")}else{stream.eatWhile(isOperatorChar);return ret("operator","operator")}}else if(isOperatorChar.test(ch)){stream.eatWhile(isOperatorChar);return ret("operator","operator")}else{stream.eatWhile(/[\w$_]/);if(keywords&&keywords.propertyIsEnumerable(stream.current().toUpperCase())){if(stream.eat(")")||stream.eat(".")){}else{return"keyword","keyword"}}if(builtins&&builtins.propertyIsEnumerable(stream.current().toUpperCase())){return"keyword","variable-2"}if(types&&types.propertyIsEnumerable(stream.current().toUpperCase()))return"keyword","variable-3";return ret("variable","pig-word")}}return{startState:function(){return{tokenize:tokenBase,startOfLine:true}},token:function(stream,state){if(stream.eatSpace())return null;var style=state.tokenize(stream,state);return style}}});(function(){function keywords(str){var obj={},words=str.split(" ");for(var i=0;i<words.length;++i)obj[words[i]]=true;return obj}var pBuiltins="ABS ACOS ARITY ASIN ATAN AVG BAGSIZE BINSTORAGE BLOOM BUILDBLOOM CBRT CEIL "+"CONCAT COR COS COSH COUNT COUNT_STAR COV CONSTANTSIZE CUBEDIMENSIONS DIFF DISTINCT DOUBLEABS "+"DOUBLEAVG DOUBLEBASE DOUBLEMAX DOUBLEMIN DOUBLEROUND DOUBLESUM EXP FLOOR FLOATABS FLOATAVG "+"FLOATMAX FLOATMIN FLOATROUND FLOATSUM GENERICINVOKER INDEXOF INTABS INTAVG INTMAX INTMIN "+"INTSUM INVOKEFORDOUBLE INVOKEFORFLOAT INVOKEFORINT INVOKEFORLONG INVOKEFORSTRING INVOKER "+"ISEMPTY JSONLOADER JSONMETADATA JSONSTORAGE LAST_INDEX_OF LCFIRST LOG LOG10 LOWER LONGABS "+"LONGAVG LONGMAX LONGMIN LONGSUM MAX MIN MAPSIZE MONITOREDUDF NONDETERMINISTIC OUTPUTSCHEMA  "+"PIGSTORAGE PIGSTREAMING RANDOM REGEX_EXTRACT REGEX_EXTRACT_ALL REPLACE ROUND SIN SINH SIZE "+"SQRT STRSPLIT SUBSTRING SUM STRINGCONCAT STRINGMAX STRINGMIN STRINGSIZE TAN TANH TOBAG "+"TOKENIZE TOMAP TOP TOTUPLE TRIM TEXTLOADER TUPLESIZE UCFIRST UPPER UTF8STORAGECONVERTER ";var pKeywords="VOID IMPORT RETURNS DEFINE LOAD FILTER FOREACH ORDER CUBE DISTINCT COGROUP "+"JOIN CROSS UNION SPLIT INTO IF OTHERWISE ALL AS BY USING INNER OUTER ONSCHEMA PARALLEL "+"PARTITION GROUP AND OR NOT GENERATE FLATTEN ASC DESC IS STREAM THROUGH STORE MAPREDUCE "+"SHIP CACHE INPUT OUTPUT STDERROR STDIN STDOUT LIMIT SAMPLE LEFT RIGHT FULL EQ GT LT GTE LTE "+"NEQ MATCHES TRUE FALSE DKULOAD DKUSTORE ";var pTypes="BOOLEAN INT LONG FLOAT DOUBLE CHARARRAY BYTEARRAY BAG TUPLE MAP ";CodeMirror.defineMIME("text/x-dkupig",{name:"dkupig",builtins:keywords(pBuiltins),keywords:keywords(pKeywords),types:keywords(pTypes)})})();(function(){"use strict";const GENERIC_QUERY_KEYWORDS="SELECT FROM ".split(" ");const GENERIC_KEYWORDS_AFTER_TABLES="HAVING IS IN NOT LIKE UNION INNER JOIN ON WHERE GROUP BY LIMIT ORDER ASC DESC BETWEEN ".split(" ");const HIVE_FUNCTIONS="ROUND FLOOR CEIL CEILING RAND EXP LN LOG10 LOG2 LOG POW POWER SQRT BIN HEX UNHEX CONV ABS PMOD SIN ASIN COS ACOS TAN ATAN DEGREES RADIANS POSITIVE NEGATIVE SIGN E PI SIZE MAP_KEYS MAP_VALUES ARRAY_CONTAINS SORT_ARRAY BINARY CAST FROM_UNIXTIME UNIX_TIMESTAMP TO_DATE YEAR MONTH DAY HOUR MINUTE SECOND WEEKOFYEAR DATEDIFF DATE_ADD DATE_SUB FROM_UTC_TIMESTAMP TO_UTC_TIMESTAMP ASCII CONCAT CONTEXT_NGRAMS CONCAT_WS FIND_IN_SET FORMAT_NUMBER GET_JSON_OBJECT IN_FILE INSTR LENGTH LOCATE LOWER LCASE LPAD LTRIM NGRAMS PARSE_URL PRINTF REGEXP_EXTRACT REGEXP_REPLACE REPEAT REVERSE RPAD RTRIM SENTENCES SPACE SPLIT STR_TO_MAP SUBSTR SUBSTRING TRANSLATE TRIM UPPER UCASE JAVA_METHOD REFLECT XPATH XPATH_SHORT XPATH_INT XPATH_LONG XPATH_FLOAT XPATH_DOUBLE XPATH_NUMBER XPATH_STRING COUNT SUM AVG MIN MAX VARIANCE VAR_SAMP STDEV_POP STDEV_SAMP COVAR_POP COVAR_SAMP CORR PERCENTILE PERCENTILE_APPROX HISTOGRAM_NUMERIC COLLECT_SET INLINE EXPLODE JSON_TUPLE PARSE_URL_TUPLE GET_JSON_OBJECT".split(" ");const IMPALA_FUNCTIONS=HIVE_FUNCTIONS;const GENERIC_FUNCTIONS="ROUND FLOOR CEIL EXP SUM COUNT AVG MIN MAX SQRT SIN COS ASIN ACOS TAN ATAN".split(" ");const GENERIC_KEYWORDS="AND DISTINCT OR false true".split(" ");const NON_QUERY_SQL_KEYWORDS="DELETE UPDATE ALTER CREATE DROP INSERT INTO SET TABLE".split(" ");const NON_QUERY_HIVE_KEYWORDS="ANALYZE SHOW DATABASE DESCRIBE DELETE ALTER CREATE DROP INSERT INTO SET TABLE ADD JAR FILE ARCHIVE TEMPORARY FUNCTION SORT DISTRIBUTE CLUSTER OVERWRITE".split(" ");const QUERY_HIVE_KEYWORDS="ANALYZE SHOW DATABASE DESCRIBE".split(" ");const NON_QUERY_IMPALA_KEYWORDS=NON_QUERY_HIVE_KEYWORDS;const QUERY_IMPALA_KEYWORDS=QUERY_HIVE_KEYWORDS;function forEach(arr,f){for(var i=0,e=arr.length;i<e;++i){f(arr[i])}}function maybeAdd(str,tkstr,list,prefix,suffix){if(str.toLowerCase().indexOf(tkstr.toLowerCase())==0&&list.indexOf(str)==-1){list.push((prefix||"")+str+(suffix||""))}}function maybeAddIfToken(str,curToken,list,prefix,suffix){if(curToken&&curToken.string&&curToken.string.length&&!curToken.string.match(/^\s*$/)){maybeAdd(str,curToken.string,list,prefix,suffix)}else if(curToken&&curToken.string&&curToken.string.length==0){list.push((prefix||"")+str+(suffix||""))}else{list.push(" "+(prefix||"")+str+(suffix||""))}}function maybeAddListIfToken(inList,curToken,list,prefix,suffix){forEach(inList,function(str){maybeAddIfToken(str,curToken,list,prefix,suffix)})}function tablesAutocomplete(textBefore){var u=textBefore.toUpperCase();return u.search(/\sFROM\s/)>-1&&u.search(/\sON\s/)==-1&&u.search(/\sWHERE\s/)==-1}function tablesPlusFromAutocomplete(textBefore){var u=textBefore.toUpperCase();return u.search(/SELECT\s/)>-1&&u.search(/\sFROM\s/)==-1}function fieldsAutocomplete(text,tablesList){var u=text.toUpperCase();if(u.search(/\sFROM\s/)>-1){var ret=[];var tokensBefore=text.split(/[\s,]+/);for(var i=0;i<tokensBefore.length;i++){var tb=tokensBefore[i].toUpperCase();for(var k=0;k<tablesList.length;k++){var tableName=tablesList[k].table;var matches=tableName.toUpperCase()==tb;matches=matches||tb.endsWith("."+tableName.toUpperCase());['"',"`"].forEach(function(q){matches=matches||tb.endsWith(q+tableName.toUpperCase()+q)});if(matches&&ret.indexOf(tablesList[k])==-1){ret.push(tablesList[k])}}}return ret}else{return null}}CodeMirror.sqlNotebookHint=function(editor,type,tablesList,sqlFields){var cursor=editor.getCursor();var curToken=editor.getTokenAt(cursor);var textBefore=editor.getRange({line:0,ch:0},{line:editor.getCursor().line,ch:editor.getCursor().ch}).replace(/(\r\n|\n|\r)/gm," ");if(curToken.string.endsWith("(")){let off=curToken.string.lastIndexOf("(");curToken.start+=off+1;curToken.string=curToken.string.substring(off+1)}else if(curToken.string.endsWith(".")){let off=curToken.string.lastIndexOf(".");curToken.start+=off+1;curToken.string=curToken.string.substring(off+1)}var normalCompletionList=[],beginCompletionList=[];if(tablesAutocomplete(textBefore)){var tableToken=curToken;var startQuote=null;var endQuote=null;['"',"`"].forEach(function(q){if(startQuote==null&&endQuote==null&&tableToken.string.charAt(0)==q){tableToken.string=tableToken.string.substring(1);startQuote=q}if((startQuote==null||startQuote==q)&&endQuote==null&&tableToken.string.charAt(tableToken.string.length-1)==q){tableToken.string=tableToken.string.substring(0,tableToken.string.length-1);endQuote=q}});maybeAddListIfToken(tablesList,tableToken,beginCompletionList,startQuote,endQuote||startQuote)}if(sqlFields){forEach(sqlFields,function(str){maybeAddIfToken(str.name,curToken,beginCompletionList)})}if(type.toLowerCase().indexOf("hive")!=-1){maybeAddListIfToken(HIVE_FUNCTIONS,curToken,normalCompletionList)}else if(type.toLowerCase().indexOf("impala")!=-1){maybeAddListIfToken(IMPALA_FUNCTIONS,curToken,normalCompletionList)}else{maybeAddListIfToken(GENERIC_FUNCTIONS,curToken,normalCompletionList)}if(type.toLowerCase().indexOf("recipe")!=-1){if(type.toLowerCase().indexOf("hive")!=-1){maybeAddListIfToken(NON_QUERY_HIVE_KEYWORDS,curToken,normalCompletionList);maybeAddListIfToken(QUERY_HIVE_KEYWORDS,curToken,normalCompletionList)}else if(type.toLowerCase().indexOf("impala")!=-1){maybeAddListIfToken(NON_QUERY_IMPALA_KEYWORDS,curToken,normalCompletionList);maybeAddListIfToken(QUERY_IMPALA_KEYWORDS,curToken,normalCompletionList)}else{maybeAddListIfToken(NON_QUERY_SQL_KEYWORDS,curToken,normalCompletionList)}}else{if(type.toLowerCase().indexOf("hive")!=-1){maybeAddListIfToken(QUERY_HIVE_KEYWORDS,curToken,normalCompletionList)}else if(type.toLowerCase().indexOf("impala")!=-1){maybeAddListIfToken(QUERY_IMPALA_KEYWORDS,curToken,normalCompletionList)}}if(textBefore.toUpperCase().indexOf("FROM")>-1){maybeAddListIfToken(GENERIC_KEYWORDS_AFTER_TABLES,curToken,normalCompletionList)}if(textBefore.toUpperCase().indexOf("SELECT")==-1){maybeAddIfToken("SELECT",curToken,beginCompletionList)}if(textBefore.toUpperCase().indexOf("FROM")==-1){maybeAddIfToken("FROM",curToken,beginCompletionList)}maybeAddListIfToken(GENERIC_KEYWORDS,curToken,normalCompletionList);let completionList=beginCompletionList.sort().concat(normalCompletionList.sort());return{list:completionList,from:{line:cursor.line,ch:curToken.start},to:{line:cursor.line,ch:curToken.end}}};CodeMirror.sqlFieldsAutocomplete=function(editor,tablesList){var cursor=editor.getCursor();var curToken=editor.getTokenAt(cursor);var textBefore=editor.getRange({line:0,ch:0},{line:editor.getCursor().line,ch:editor.getCursor().ch}).replace(/(\r\n|\n|\r)/gm," ");return fieldsAutocomplete(editor.getValue(),tablesList)}})();(function(){"use strict";const app=angular.module("dataiku.services");app.factory("GrelMode",["CachedAPICalls",function(CachedAPICalls){CachedAPICalls.customFormulasFunctions.then(function(functionList){defineMode("grel",functionList)});CachedAPICalls.udafCustomFormulasFunctions.then(function(functionList){defineMode("udaf",functionList)});function defineMode(name,functionList){const Pos=CodeMirror.Pos;const OPERATORS=["+","-","%","+","*","/",".","==","<=",">=","<",">","!=","&&","||","!"];const FUNCTIONS=functionList;CodeMirror.defineMode(name,function(config){const QUOTES="\"'";const numLiteralPtn=/\b^-?\d+(\.\d+)?\b/;const namePtn=/\w+/;const variablesAltPtn=/\${[^}]*}/;const variablesPtn=/variables/;const variablesAndNamePtn=/variables\.\w+/;const regExpPtn=/\/(\\.|[^\\/])*\//;function neutral(stream,state){if(stream.match(numLiteralPtn)){return"number"}if(stream.match(variablesAndNamePtn)||stream.match(variablesPtn)||stream.match(variablesAltPtn)){return"variable"}if(stream.match(namePtn)){if(config.variables){const name=stream.string.substr(stream.start,stream.pos-stream.start);if(FUNCTIONS.indexOf(name)>=0){return"builtin"}const variables=config.variables();if(!variables||variables.length==0||variables.indexOf(name)>=0){return"column"}return"error"}return"column"}if(stream.match(regExpPtn)){return"regex"}const c=stream.next();if(QUOTES.indexOf(c)!=-1){state.ctx.curquote=c;state.token=inString;return inString(stream,state)}else if(c=="("){state.ctx.bra+=1;return"bracket"}else if(c==")"){if(state.ctx.bra==0){return"error"}else{state.ctx.bra-=1;return"bracket"}}else if(c=="["){state.ctx.sqbra+=1;return"sqbracket"}else if(c=="]"){if(state.ctx.sqbra==0){return"error"}else{state.ctx.sqbra-=1;return"sqbracket"}}else if(OPERATORS.indexOf(c+stream.peek())!=-1){stream.next();return"symbol"}else if(OPERATORS.indexOf(c)!=-1){return"symbol"}else if(c=="\\"){return"symbol"}else if(state.ctx.bra+state.ctx.sqbra>0&&c==","){return"comma"}return"error"}function inString(stream,state){var c=undefined;while(c!=state.ctx.curquote){if(c=="\\"){stream.next()}c=stream.next();if(!c){break}}state.token=neutral;return"string"}return{startState:function(){return{ctx:{bra:0,sqbra:0},token:neutral}},copyState:function(state){return angular.copy(state)},token:function(stream,state){if(stream.eatSpace()){return null}return state.token(stream,state)}}});function grelHint(cm,options){var noColumn=function(){return[]};var columns=options.columns||noColumn;var variables=options.variables||[];var cur=cm.getCursor();var token=cm.getTokenAt(cur);var suggestions=[];var start,end;var token_str=token.string;if(token_str.startsWith("${")&&token_str.endsWith("}")){if(token.end===cur.ch){return{list:[],from:start,to:end}}token_str=token_str.substr(0,token.length-1)}const makeSuggestions=(candidates,candidateType,prefixFilter)=>(candidates||[]).filter(c=>c?.toLowerCase().startsWith((prefixFilter||"").toLowerCase())).map(c=>({text:c,type:candidateType}));if(token.type=="string"){const leftPart=cm.getLine(cur.line).substr(0,cur.ch);if(leftPart.endsWith('val("')||leftPart.endsWith("val('")){suggestions=makeSuggestions(columns(),"column")}else if(token_str.length>1){suggestions=makeSuggestions(columns(),"column",token_str.substr(1))}}else if(token.type=="bracket"||token.type=="sqbracket"||token.type=="symbol"){}else if(token.type==null&&token.string==""){}else{suggestions=[...makeSuggestions(columns(),"column",token_str),...makeSuggestions(variables,"variable",token_str),...token_str?.length?makeSuggestions(FUNCTIONS,"function",token_str):[]]}start=Pos(cur.line,token.start);end=Pos(cur.line,token.end);return{list:suggestions,from:start,to:end}}CodeMirror.registerHelper("hint",name,grelHint);CodeMirror.defineMIME("text/"+name,name)}return{}}])})();"use strict";angular.module("ui.codemirror",[]).constant("uiCodemirrorConfig",{}).directive("uiCodemirror",uiCodemirrorDirective);function uiCodemirrorDirective($timeout,uiCodemirrorConfig){return{restrict:"EA",require:"?ngModel",compile:function compile(){if(angular.isUndefined(window.CodeMirror)){throw new Error("ui-codemirror needs CodeMirror to work... (o rly?)")}return postLink}};function postLink(scope,iElement,iAttrs,ngModel){var codemirrorOptions=angular.extend({value:iElement.text()},uiCodemirrorConfig.codemirror||{},scope.$eval(iAttrs.uiCodemirror),scope.$eval(iAttrs.uiCodemirrorOpts));var codemirror=newCodemirrorEditor(iElement,codemirrorOptions);configOptionsWatcher(codemirror,iAttrs.uiCodemirror||iAttrs.uiCodemirrorOpts,scope);configNgModelLink(codemirror,ngModel,scope);configUiRefreshAttribute(codemirror,iAttrs.uiRefresh,scope);scope.$on("CodeMirror",function(event,callback){if(angular.isFunction(callback)){callback(codemirror)}else{throw new Error("the CodeMirror event requires a callback function")}});if(angular.isFunction(codemirrorOptions.onLoad)){codemirrorOptions.onLoad(codemirror)}}function newCodemirrorEditor(iElement,codemirrorOptions){var codemirrot;if(iElement[0].tagName==="TEXTAREA"){codemirrot=window.CodeMirror.fromTextArea(iElement[0],codemirrorOptions)}else{iElement.html("");codemirrot=new window.CodeMirror(function(cm_el){iElement.append(cm_el)},codemirrorOptions)}return codemirrot}function configOptionsWatcher(codemirrot,uiCodemirrorAttr,scope){if(!uiCodemirrorAttr){return}var codemirrorDefaultsKeys=Object.keys(window.CodeMirror.defaults);scope.$watch(uiCodemirrorAttr,updateOptions,true);function updateOptions(newValues,oldValue){if(!angular.isObject(newValues)){return}codemirrorDefaultsKeys.forEach(function(key){if(newValues.hasOwnProperty(key)){if(oldValue&&newValues[key]===oldValue[key]){return}codemirrot.setOption(key,newValues[key])}})}}function configNgModelLink(codemirror,ngModel,scope){if(!ngModel){return}ngModel.$formatters.push(function(value){if(angular.isUndefined(value)||value===null){return""}else if(angular.isObject(value)||angular.isArray(value)){throw new Error("ui-codemirror cannot use an object or an array as a model")}return value});ngModel.$render=function(){var safeViewValue=ngModel.$viewValue||"";codemirror.setValue(safeViewValue)};codemirror.on("change",function(instance){var newValue=instance.getValue();if(newValue!==ngModel.$viewValue){scope.$evalAsync(function(){ngModel.$setViewValue(newValue)})}})}function configUiRefreshAttribute(codeMirror,uiRefreshAttr,scope){if(!uiRefreshAttr){return}scope.$watch(uiRefreshAttr,function(newVal,oldVal){if(newVal!==oldVal){$timeout(function(){codeMirror.refresh()})}})}}uiCodemirrorDirective.$inject=["$timeout","uiCodemirrorConfig"];
//# sourceMappingURL=dkucodemirrorpack.js.map