(function(){
'use strict';

    const app = angular.module('dataiku.services');

    app.directive('grelReference', function (CachedAPICalls, $filter, translate) {
        return {
            templateUrl : '/templates/widgets/grel-reference.html',
            link : function($scope, element, attrs) {
                const formulasReference = attrs.mode === 'udaf' ? CachedAPICalls.udafCustomFormulasReference :  CachedAPICalls.customFormulasReference;
                $scope.hideDocLink = angular.isDefined(attrs.hideDocLink);
                formulasReference.then(function(data) {
                    const columnAccessType = translate('GREL.REFERENCE.COLUMNS_ACCESS', 'Columns access');
                    const functionAccessType = translate('GREL.REFERENCE.FUNCTIONS', 'Functions');
                    $scope.grelSyntax = [];
                    $scope.grelSyntax.push({type: columnAccessType, name:'column_name',unrealFunction:true,
                        returns:translate('GREL.REFERENCE.COLUMN_NAME.RETURN', 'the value of a given cell'),
                        description:translate('GREL.REFERENCE.COLUMN_NAME.DESCRIPTION', 'column_name must be a valid identifier') });
                    $scope.grelSyntax.push({type: columnAccessType, name:'numval',params:'column',
                        returns:translate('GREL.REFERENCE.NUMVAL.RETURN', 'the numerical value of a given cell'),
                        description:''});
                    $scope.grelSyntax.push({type: columnAccessType, name:'strval',params:'column',
                        returns:translate('GREL.REFERENCE.STRVAL.RETURN', 'the String value of a given cell'),
                        description:translate('GREL.REFERENCE.STRVAL.DESCRIPTION', 'strval returns an empty string for cells with no value.')});
                    $scope.grelSyntax.push({type: columnAccessType, name:'strval',params:'column, defaultValue',
                        returns:translate('GREL.REFERENCE.STRVAL.MULTI_PARAMS.RETURN', 'the String value of a given cell or defaultValue if the cell is empty'),
                        description:''});
                    data.forEach(function(f) {
                        if (!f.hidden) {
                            f.type = functionAccessType;
                            $scope.grelSyntax.push(f);
                        }
                    });
                    $scope.refreshFilteredGrelFunctions();
                }).catch(setErrorInScope.bind($scope));

                $scope.editing = {grelFilter : ''};
                $scope.refreshFilteredGrelFunctions = function() {
                    var filteredSyntax = $scope.grelSyntax;
                    $scope.filteredGrelFunctions = [];
                    if ( $scope.grelSyntax == null ) {
                        return;
                    }
                    if ( $scope.editing.grelFilter != null && $scope.editing.grelFilter.length > 0 ) {
                        filteredSyntax = $filter('filter')($scope.grelSyntax, $scope.editing.grelFilter);
                    }
                    // group by type
                    var lastGroup = null;
                    filteredSyntax.forEach(function(f) {
                        if ( lastGroup == null || lastGroup.name != f.type ) {
                            if ( lastGroup != null ) {
                                $scope.filteredGrelFunctions.push(lastGroup);
                            }
                            lastGroup = {name:f.type, functions:[]};
                        }
                        lastGroup.functions.push(f);
                    });
                    if ( lastGroup != null ) {
                        $scope.filteredGrelFunctions.push(lastGroup);
                    }

                };
                $scope.$watch('editing.grelFilter', function() {
                    $scope.refreshFilteredGrelFunctions();
                }, true);
            }
        };
    });
    app.directive('grelExamples', function (CachedAPICalls, $filter) {
        return {
            templateUrl : '/templates/widgets/grel-examples.html',
            link : function($scope, element, attrs) {
                // nothing here (yet?)
            }
        };
    });
    app.directive('grelReferenceAndExamples', function (CachedAPICalls, $filter) {
        return {
            templateUrl : '/templates/widgets/grel-reference-and-examples.html',
            link : function($scope, element, attrs) {
                // nothing here (yet?)
            }
        };
    });

})();
