(function() {
'use strict';

const app = angular.module('dataiku.recipes');


app.controller("NLPLLMSummarizationRecipeCreationController", function(
    $scope, $stateParams, $controller, DataikuAPI, RecipesUtils,
    RecipeDescService, RecipeComputablesService, PromptUtils) {

    $scope.recipeType = 'nlp_llm_summarization';

    $controller("SingleOutputDatasetRecipeCreationController", {$scope:$scope});
    $scope.showOutputPane = _ => !!$scope.io.inputDataset;

    $scope.autosetName = function() {
        if ($scope.io.inputDataset) {
            const niceInputName = $scope.io.inputDataset.replace(/[A-Z]*\./, "");
            $scope.maybeSetNewDatasetName(niceInputName + "_summarized");
        }
    };

    $scope.getCreationSettings = function() {
        const inputs = [];
        if ($scope.io.inputDataset) {
            inputs.push($scope.io.inputDataset);
        }
        const creationSettings = { virtualInputs: inputs };

        if ($scope.initialPayload) {
            creationSettings.initialPayload = $scope.initialPayload;
        }

        return creationSettings;
    };

    addDatasetUniquenessCheck($scope, DataikuAPI, $stateParams.projectKey);
    fetchManagedDatasetConnections($scope, DataikuAPI);
});


app.controller("NLPLLMSummarizationRecipeEditor", function($scope, $controller, $state, $stateParams, DataikuAPI, CreateModalFromTemplate) {
    $controller("_NLPLLMRecipeControllerBase", {$scope: $scope});

    $scope.loadLLMs("SUMMARIZATION");

    $scope.targetLengthUnitOptions = [
        ['WORD', 'Words'],
        ['SENTENCE', 'Sentences'],
    ];

    $scope.openConvertToPromptModal = function() {
        if (!$scope.recipe || !$scope.recipe.name) return;
        $scope.saveRecipe().then(function() {
            CreateModalFromTemplate("/templates/recipes/nlp/convert-to-prompt-recipe.html", $scope, "NLPRecipeConvertToPromptRecipeModal", function(modalScope) {
            });
        });
    };
});

}());
