(function () {
    'use strict';

    const app = angular.module('dataiku.flow.assistant',[]);

    app.service('FlowAssistantSelectionService', function() {
        let subscribers = []
        let pending = []

        const publishDataset = (node) => {
            if (subscribers.length === 0) { // angular component has not mounted yet
                pending.push(node);
                return;
            }

            subscribers.forEach(sub => sub(node));
        };

        this.subscribe = (callback) => {
            subscribers.push(callback);

            // replay pending events
            pending.forEach(node => callback(node));
            pending = [];

            // return an unsubscribe function
            return () => {
                const index = subscribers.findIndex((subscriber) => subscriber === callback);
                if (index !== -1) {
                    subscribers.splice(index, 1);
                }
            };
        };


        this.addDatasetToChatContext = (selectedNodes, clickedObject) => {
            // If right clicking on a dataset that's not selected
            const nodesToAdd = selectedNodes?.includes(clickedObject) ? selectedNodes : [clickedObject];
            nodesToAdd.filter(node =>
                node.nodeType === "LOCAL_DATASET" || node.nodeType === "FOREIGN_DATASET"
            ).forEach(node => publishDataset(node));
        }

    });
})();
