(function(){"use strict";angular.module("dataiku.shared",["platypus.utils","dataiku.charts"])})();(function(){"use strict";const alertDismissible={transclude:true,bindings:{severity:"@",dismissButtonSize:"@?",localStorageKey:"@?",onDismiss:"&?"},templateUrl:"/static/dataiku/shared/components/alert-dismissible/alert-dismissible.component.html",controller:function(LocalStorage){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.isShown=$ctrl.localStorageKey?!LocalStorage.get($ctrl.localStorageKey):true};$ctrl.dismiss=function(){$ctrl.isShown=false;if($ctrl.localStorageKey){LocalStorage.set($ctrl.localStorageKey,true)}if($ctrl.onDismiss){$ctrl.onDismiss()}}}};angular.module("dataiku.shared").component("alertDismissible",alertDismissible)})();(function(){"use strict";const cellValuePopupComponent={bindings:{cellValue:"<",sanitizedHtmlContent:"<",searchValue:"=",highlightTagName:"<",columnMeaning:"<",popupContainer:"="},templateUrl:"/static/dataiku/shared/components/cell-value-popup-component/cell-value-popup.component.html",controller:function($element,ClipboardUtils,$timeout){const $ctrl=this;$ctrl.$onInit=()=>{if(["GeometryMeaning","BagOfWordsMeaning","JSONObjectMeaning","JSONArrayMeaning"].indexOf($ctrl.columnMeaning)>=0&&isNaN(parseInt($ctrl.cellValue))){try{$ctrl.jsonValue=JSON.parse($ctrl.cellValue);$ctrl.jsonDetails={};if($ctrl.jsonValue.constructor===Array){$ctrl.jsonDetails.type="array";$ctrl.jsonDetails.length=$ctrl.jsonValue.length;$ctrl.jsonDetails.strLength=$ctrl.cellValue.length}else if(typeof $ctrl.jsonValue==="object"){$ctrl.jsonDetails.type="object";$ctrl.jsonDetails.nbKeys=Object.keys($ctrl.jsonValue).length;$ctrl.jsonDetails.strLength=$ctrl.cellValue.length}$ctrl.jsonEnabled=true}catch(e){}}else{$ctrl.jsonEnabled=false}$ctrl.copyCellValue=function(){ClipboardUtils.copyToClipboard($ctrl.cellValue,`Copied to clipboard.`)};$ctrl.selection=null;if($ctrl.searchValue){$element.mouseup(function(evt){if($ctrl.selection){window.getSelection().removeAllRanges()}evt.stopPropagation();const selection=getSelectionInElement($element.find("#shaker-cell-complete-value-content")[0],$ctrl.highlightTagName);$timeout(()=>{$ctrl.selection=selection})})}};$ctrl.$postLink=()=>$ctrl.popupContainer.onPopupCreated()}};angular.module("dataiku.shared").component("cellValuePopupComponent",cellValuePopupComponent)})();(function(){"use strict";angular.module("dataiku.shared").component("chartAlphanumFacet",{templateUrl:"/static/dataiku/shared/components/chart-alphanum-facet/chart-alphanum-facet.component.html",bindings:{values:"<",folded:"<",filterSelectionType:"<",uniqueRowCount:"<?",disableCount:"<?",hideZeroCountValues:"<?",onChange:"&?"},controller:function($rootScope,Debounce,ChartFormatting){const ctrl=this;ctrl.filteredValues=[];ctrl.selectedValue="";ctrl.query="";ctrl.$onChanges=changes=>{if(changes.values){if(!ctrl.values){return}reloadValues();updateWidgetHeight(Math.min(Math.max(50,22*ctrl.values.length),220)+5)}if(changes.folded){$rootScope.$broadcast("reflow")}};ctrl.setAll=function(val){for(let k in ctrl.filteredValues){let item=ctrl.filteredValues[k];item.included=val}ctrl.changed()};ctrl.changed=function(){ctrl.allSelected=true;ctrl.someSelected=false;for(let k in ctrl.filteredValues){let item=ctrl.filteredValues[k];ctrl.allSelected=ctrl.allSelected&&item.included;ctrl.someSelected=ctrl.someSelected||item.included}if(ctrl.onChange){ctrl.onChange({$values:ctrl.values})}};ctrl.formatLabel=function(label){return ChartFormatting.getFormattedSpecialLabel(label)};ctrl.singleSelectChanged=function(id){for(let item of ctrl.filteredValues){item.included=item.id===id}if(ctrl.onChange){ctrl.onChange({$values:ctrl.values})}};ctrl.onQueryChange=Debounce().withDelay(50,200).wrap(()=>reloadValues());function updateWidgetHeight(widgetHeight){ctrl.widgetHeight=widgetHeight;$rootScope.$broadcast("reflow")}function reloadValues(){ctrl.selectedValue=undefined;ctrl.filteredValues=[];let q=(ctrl.query||"").toLowerCase();if(ctrl.values){for(const k in ctrl.values){const v=ctrl.values[k];if(ctrl.hideZeroCountValues&&v.count===0){continue}if(!v.label){v.label=""}if(v.label.toLowerCase().indexOf(q)!==-1){ctrl.filteredValues.push(v)}}ctrl.allSelected=true;ctrl.someSelected=false;for(const k in ctrl.filteredValues){const item=ctrl.filteredValues[k];ctrl.allSelected=ctrl.allSelected&&item.included;ctrl.someSelected=ctrl.someSelected||item.included;if(item.included&&!ctrl.selectedValue){ctrl.selectedValue=item.id}}if(ctrl.uniqueRowCount){const unusedCount=ctrl.uniqueRowCount-ctrl.values.length;if(unusedCount>0){ctrl.filteredValues.push({unusedCount:unusedCount})}}}}}})})();(function(){"use strict";const DATE_PART_LABELS={YEAR:"Year",QUARTER_OF_YEAR:"Quarter",MONTH_OF_YEAR:"Month",WEEK_OF_YEAR:"Week",DAY_OF_MONTH:"Day",HOUR_OF_DAY:"Hour"};const customRelativeDateFacetComponent={templateUrl:"/static/dataiku/shared/components/custom-relative-date-facet/custom-relative-date-facet.component.html",bindings:{relativeOption:"<",datePart:"<",onChange:"&"},controller:function(translate,ChartFilterUtils){const $ctrl=this;$ctrl.hasNext=false;$ctrl.hasLast=false;$ctrl.currentNext=1;$ctrl.currentLast=1;$ctrl.$onChanges=changes=>{if(changes.relativeOption||changes.datePart){updateFacetWithRelativeOption($ctrl.relativeOption);updateDatePartLabels()}};$ctrl.onContainsCurrentDatePartChange=()=>{if(!$ctrl.relativeOption.containsCurrentDatePart){$ctrl.relativeOption.isUntilNow=false}emitOnChange()};$ctrl.onIsUntilNowChange=()=>{if($ctrl.relativeOption.isUntilNow){$ctrl.relativeOption.next=0;$ctrl.hasNext=false}emitOnChange()};$ctrl.onHasLastChange=()=>{if($ctrl.hasLast){$ctrl.relativeOption.last=$ctrl.currentLast;if($ctrl.hasNext){$ctrl.relativeOption.containsCurrentDatePart=true}}else{$ctrl.relativeOption.last=0}emitOnChange()};$ctrl.onHasNextChange=()=>{if($ctrl.hasNext){$ctrl.relativeOption.next=$ctrl.currentNext;if($ctrl.hasLast){$ctrl.relativeOption.containsCurrentDatePart=true}}else{$ctrl.relativeOption.next=0}emitOnChange()};$ctrl.onLastChange=()=>{if($ctrl.currentLast!=null){$ctrl.relativeOption.last=$ctrl.currentLast;emitOnChange()}};$ctrl.onNextChange=()=>{if($ctrl.currentNext!=null){$ctrl.relativeOption.next=$ctrl.currentNext;emitOnChange()}};$ctrl.focusInputNumberOnArrowClick=event=>{event.currentTarget.focus()};function emitOnChange(){updateFacetWithRelativeOption($ctrl.relativeOption);updateDatePartLabels();$ctrl.onChange({$relativeOption:$ctrl.relativeOption})}function updateFacetWithRelativeOption(relativeOption){if(relativeOption==null){$ctrl.relativeOption=ChartFilterUtils.getEmptyRelativeDateFilterOption();$ctrl.onChange({$relativeOption:$ctrl.relativeOption})}else{$ctrl.relativeOption=relativeOption}$ctrl.hasLast=!!$ctrl.relativeOption.last;$ctrl.hasNext=!!$ctrl.relativeOption.next;if($ctrl.hasLast){$ctrl.currentLast=$ctrl.relativeOption.last}else{$ctrl.currentLast=1}if($ctrl.hasNext){$ctrl.currentNext=$ctrl.relativeOption.next}else{$ctrl.currentNext=1}}function updateDatePartLabels(){const partLabelEn=DATE_PART_LABELS[$ctrl.datePart];const last=$ctrl.currentLast;const next=$ctrl.currentNext;$ctrl.dateRelativeFilterPartsLabelThis=translate("SHAKER.PROCESSOR.FilterOnDate.FORM.THIS."+$ctrl.datePart,"This "+partLabelEn);$ctrl.dateRelativeFilterPartsLabelLast=translate("SHAKER.PROCESSOR.FilterOnDate.FORM.NEXT_LAST."+$ctrl.datePart,partLabelEn+(last>1?"s":""),{count:last});$ctrl.dateRelativeFilterPartsLabelNext=translate("SHAKER.PROCESSOR.FilterOnDate.FORM.NEXT_LAST."+$ctrl.datePart,partLabelEn+(next>1?"s":""),{count:next});$ctrl.dateRelativeFilterPartsLabelToDate=translate("SHAKER.PROCESSOR.FilterOnDate.FORM.TO_DATE.UNTIL_NOW")}}};angular.module("dataiku.shared").component("customRelativeDateFacet",customRelativeDateFacetComponent)})();(function(){"use strict";const dssObjectLink={bindings:{item:"<",moveToTargetProject:"<",hook:"<",showLocation:"<",reload:"=",options:"<"},templateUrl:"static/dataiku/shared/components/dss-object-link/dss-object-link.component.html",controller:function(StateUtils,$scope,$state,SmartId,TAGGABLE_TYPES,$stateParams,$sanitize,$filter,MLUtilsService){this.$onInit=()=>{if(this.reload){this.objectSref=item=>this.refFunction(item,StateUtils.uiSref)}else{this.objectLink=item=>this.refFunction(item,StateUtils.href)}};this.isExternalLink=()=>false;this.isLinkableDssObject=item=>item&&(TAGGABLE_TYPES.includes(item.objectType)||item.objectType=="APP"||item.objectType=="PLUGIN"||item.isInstalledCodeEnv);this.isTensorboardFuture=item=>item&&item.objectType==="WEB_APP"&&item.objectId.startsWith("TENSORBOARD_");this.getSubTypeFromItem=item=>item.details.datasetType||item.details.streamingType||item.details.recipeType||item.details.webappType||item.details.insightType||item.details.mesFlavor||item.details.modelTaskType;this.getIconClass=item=>{let subtype;if(item.objectType==="SAVED_MODEL"){if(item.details&&item.details.savedModelMLCategory){subtype=item.details.savedModelMLCategory}else{subtype=item&&item.details&&MLUtilsService.getMLCategory(item.details.taskType,item.details.backendType,item.details.predictionType,item.details.savedModelType,item.details.proxyModelProtocol||item.details.externalSavedModelType)}}else{subtype=item&&item.details&&this.getSubTypeFromItem(item)}return $filter("toModernIcon")($filter("subTypeToIcon")(subtype,item.objectType,16),16)};this.getColorClass=item=>{if(item&&item.objectType==="SAVED_MODEL"&&item.details){if(item.details.savedModelMLCategory){return $filter("savedModelMLCategoryToClassColor")(item.details.savedModelMLCategory,true)}else{return $filter("savedModelTypeToClassColor")(item.details.savedModelType,true)}}return item&&item.details&&$filter("subTypeToColor")(this.getSubTypeFromItem(item),item.objectType)};this.$onChanges=changes=>{if(changes&&changes.hook&&changes.hook.currentValue){this.isLinkableDssObject=this.hook.isLinkableDssObject(this.isLinkableDssObject);this.isExternalLink=this.hook.isExternalLink(this.isExternalLink);if(this.reload){this.objectSref=this.hook.objectLink(this.objectSref)}else{this.objectLink=this.hook.objectLink(this.objectLink)}}};this.refFunction=(item,util)=>{if(!item)return;if(item.objectType=="PLUGIN"){if(item.pluginsList){for(let i=0;i<item.pluginsList.plugins.length;i++){let plugin=item.pluginsList.plugins[i];if(plugin.id===item.objectId&&plugin.installed){let updateAvailable=plugin.storeDesc&&plugin.storeDesc.storeVersion>plugin.installedDesc.desc.version;return updateAvailable?util.pluginStore(item.objectId):util.pluginSummary(item.objectId)}}return util.pluginStore(item.objectId)}else{return util.pluginStore(item.objectId)}}else if(item.objectType==="CODE_ENV"){return util.codeEnvEdit(item.targetName||item.objectId,item.envLang)}if(item.workspaceKey){if(item.projectKey){return util.workspaceObject(item.workspaceKey,item.projectKey,item.objectType,item.objectId,{discussionId:item.discussionId})}return util.workspace(item.workspaceKey,{discussionId:item.discussionId})}return util.dssObject(item.objectType,SmartId.fromRef(item,$stateParams.projectKey),null,{moveToTargetProject:this.moveToTargetProject,discussionId:item.discussionId,subType:item.subType||this.getSubTypeFromItem(item),...this.options})};this.itemDisplayName=item=>{const name=item&&(item.details&&$sanitize(item.details.objectDisplayName)||$sanitize(item.name||item.objectId));return $filter("unescapeHtml")(name)}}};angular.module("dataiku.shared").component("dssObjectLink",dssObjectLink)})();(function(){"use strict";const geoPreviewMapContent={bindings:{onPopupCreated:"=",cellValue:"<",popupContainer:"="},templateUrl:"static/dataiku/shared/components/geo-preview-component/geo-preview.component.html",controller:function($element,DataikuAPI,ChartsStaticData,ColorUtils,WT1,BuiltinMapBackgrounds){const $ctrl=this;$ctrl.$onInit=()=>{WT1.event("geo-preview-popup-displayed");$ctrl.failure=false;DataikuAPI.shakers.convertCellValueToGeoJSON($ctrl.cellValue).then(res=>{$ctrl.failure=false;const cellGeometry=JSON.parse(res.data);const background=BuiltinMapBackgrounds.getBackgrounds().find(b=>b.id==="cartodb-positron");const pointToLayer=(feature,coordinates)=>{return new L.circleMarker(coordinates)};const singleColor=ColorUtils.toRgba(ChartsStaticData.DEFAULT_COLOR_OPTIONS.singleColor,ChartsStaticData.DEFAULT_COLOR_OPTIONS.transparency);const previewMapStyle={weight:ChartsStaticData.DEFAULT_STROKE_WIDTH,color:singleColor,fillColor:singleColor,fillOpacity:ChartsStaticData.DEFAULT_FILL_OPACITY,opacity:1};const dataLayer=L.geoJson(cellGeometry,{style:previewMapStyle,pointToLayer:pointToLayer});$element.find(".geo-preview-component__map-content").css("display","block");const mapContainer=$element.find(".map-container");const map=L.map(mapContainer[0]).setView([0,0],0);const tileLayer=background.getTileLayer();map.addLayer(tileLayer);map.addLayer(dataLayer);map.fitBounds(dataLayer,{animate:false,padding:[20,20]});if(cellGeometry&&cellGeometry.type==="Point"){map.setZoom(15,{animate:false})}if($ctrl.popupContainer.setPopupClosable&&$ctrl.popupContainer.setPopupNotClosable){map.on("movestart",$ctrl.popupContainer.setPopupNotClosable);map.on("moveend",()=>{setTimeout($ctrl.popupContainer.setPopupClosable,50)})}}).catch(err=>{$ctrl.failure=true;const warningMessageTemplate="No preview : {0}";if(!err.data){$ctrl.warningMessage=warningMessageTemplate.format("an unknown error occured")}else{$ctrl.warningMessage=warningMessageTemplate.format(err.data.message)}}).finally(()=>{$ctrl.popupContainer.onPopupCreated&&$ctrl.popupContainer.onPopupCreated()})}}};angular.module("dataiku.shared").component("geoPreviewMapContent",geoPreviewMapContent)})();(function(){"use strict";angular.module("dataiku.shared").component("lottie",{bindings:{animationData:"@",autoplay:"<?",loop:"<?",animationCb:"<?"},templateUrl:"/static/dataiku/shared/components/lottie/lottie.component.html",controller:function($scope,$element,AssetsUtils){const ctrl=this;ctrl.$onInit=()=>{ctrl.initialized=true;if(ctrl.animationData){loadAnimation()}};ctrl.$onChanges=changesObj=>{if(!ctrl.initialized){return}if(changesObj.animationData&&changesObj.animationData.previousValue!==changesObj.animationData.currentValue){const innerDiv=$element.find("div");const svgDimensions=getDimensions(innerDiv.find("svg"));destroyAnimation();if(ctrl.animationData){if(svgDimensions.width&&svgDimensions.height){innerDiv.width(svgDimensions.width).height(svgDimensions.height)}loadAnimation();if(svgDimensions.width&&svgDimensions.height){ctrl.mutationObserver=createMutationObserver(innerDiv,function(){if(innerDiv.find("svg").length){innerDiv.width("").height("");ctrl.mutationObserver.disconnect();ctrl.mutationObserver=null}})}}}};$scope.$on("$destroy",()=>{destroyAnimation()});function loadAnimation(){if(ctrl.animationData){const innerDiv=$element.find("div");ctrl.animation=bodymovin.loadAnimation({container:innerDiv.get(0),path:AssetsUtils.appendAssetsHash(ctrl.animationData),renderer:"svg",loop:ctrl.loop!==false,autoplay:ctrl.autoplay!==false});if(typeof ctrl.animationCb==="function"){ctrl.animation.addEventListener("data_ready",()=>{ctrl.animationCb(ctrl.animation)})}}}function destroyAnimation(){if(ctrl.animation){ctrl.animation.destroy();ctrl.animation=null}if(ctrl.mutationObserver){ctrl.mutationObserver.disconnect();ctrl.mutationObserver=null}}function getDimensions(element){return{width:element.attr("width"),height:element.attr("height")}}function createMutationObserver(innerDiv,callback){const MutationObserver=window.MutationObserver||window.WebKitMutationObserver;if(MutationObserver){let observer=new MutationObserver(callback);observer.observe(innerDiv.get(0),{childList:true});return observer}}}})})();(function(){"use strict";angular.module("dataiku.shared").component("objectEditionButtons",{bindings:{save:"<",navigateToView:"<",canSave:"<",isDirty:"<",objectId:"<",objectType:"<",canWriteOverride:"<",dropdownAlignRight:"<"},templateUrl:"/static/dataiku/shared/components/object-edition-buttons/object-edition-buttons.component.html",controller:function(CreateModalFromTemplate,$rootScope,translate){const ctrl=this;ctrl.translate=translate;let unwatchProjectSummary;ctrl.$onInit=function(){unwatchProjectSummary=$rootScope.$watch("projectSummary",function(newVal){if(newVal){ctrl.updateButtonStates()}})};ctrl.$onDestroy=function(){if(unwatchProjectSummary){unwatchProjectSummary()}};ctrl.$onChanges=function(){ctrl.updateButtonStates()};ctrl.updateButtonStates=function(){if(!$rootScope.projectSummary){ctrl.canSaveWithCustomCommitMessage=false;ctrl.canCommit=false;ctrl.canWrite=ctrl.canWriteOverride||false;return}ctrl.canSaveWithCustomCommitMessage=$rootScope.projectSummary.commitMode!=="ALL_EXPLICIT"&&(ctrl.objectType!=="RECIPE"||$rootScope.projectSummary.commitMode!=="RECIPES_EXPLICIT");ctrl.canCommit=$rootScope.projectSummary.commitMode==="ALL_EXPLICIT"||ctrl.objectType==="RECIPE"&&$rootScope.projectSummary.commitMode==="RECIPES_EXPLICIT";ctrl.canWrite=$rootScope.projectSummary.canWriteProjectContent||ctrl.canWriteOverride};ctrl.saveWithCustomCommitMessage=function(){CreateModalFromTemplate("/templates/git/commit-message-only-modal.html",$rootScope.$new(),null,function(newScope){newScope.commitData={};if(ctrl.currentSaveCommitMessage){newScope.commitData.message=ctrl.currentSaveCommitMessage}newScope.commit=function(){newScope.resolveModal(newScope.commitData)}},true).then(function(commitData){ctrl.currentSaveCommitMessage=commitData.message;ctrl.save(commitData.message)})};ctrl.commit=function(){CreateModalFromTemplate("/templates/git/commit-object-modal.html",$rootScope.$new(),null,function(newScope){newScope.object={objectType:ctrl.objectType,objectId:ctrl.objectId}},true)}}})})();(function(){"use strict";angular.module("dataiku.shared").component("pivotFilterAlphanumericalFacet",{bindings:{filterTmpData:"<",folded:"<",filterTmpDataChange:"&"},templateUrl:"/static/dataiku/shared/components/pivot-filter-alphanumerical-facet/pivot-filter-alphanumerical-facet.component.html",controller:function(){const ctrl=this;ctrl.onValuesSelectionChange=function(values){ctrl.filterTmpDataChange({$filterTmpData:{...ctrl.filterTmpData,values:values}})}}})})();(function(){"use strict";angular.module("dataiku.shared").component("pivotFilterCustomFacet",{bindings:{filterTmpData:"<",folded:"<",filterTmpDataChange:"&",filterFacet:"<"},templateUrl:"/static/dataiku/shared/components/pivot-filter-custom-facet/pivot-filter-custom-facet.component.html",controller:function(){const ctrl=this;ctrl.onValuesSelectionChange=function(options){ctrl.filterTmpDataChange({$filterTmpData:{...ctrl.filterTmpData,...options}})}}})})();(function(){"use strict";angular.module("dataiku.shared").component("pivotFilterDateFacet",{bindings:{filterTmpData:"<",filterFacet:"<",facetUiState:"<",filters:"<",index:"<",getFiltersRequestOptions:"<",dateFilterTypeChange:"&",filterTmpDataChange:"&"},templateUrl:"/static/dataiku/shared/components/pivot-filter-date-facet/pivot-filter-date-facet.component.html",controller:function(CHART_FILTERS,ChartFilterUtils,ChartFilters){const ctrl=this;ctrl.DATE_FILTER_PARTS=ChartFilterUtils.getDateChartFilterParts();ctrl.DATE_TYPES=CHART_FILTERS.DATE_TYPES;ctrl.isDateRangeFilter=ChartFilterUtils.isDateRangeFilter.bind(ChartFilterUtils);ctrl.isRelativeDateFilter=ChartFilterUtils.isRelativeDateFilter.bind(ChartFilterUtils);ctrl.isDatePartFilter=ChartFilterUtils.isDatePartFilter.bind(ChartFilterUtils);ctrl.switchedType=true;ctrl.$onChanges=changesObj=>{if(changesObj.facetUiState!=null&&changesObj.facetUiState.isFirstChange()){ctrl.switchedType=changesObj.facetUiState.fromDateRangeModel&&changesObj.facetUiState.toDateRangeModel}};ctrl.switchDateFilterType=function(dateFilterType){ctrl.switchedType=true;ctrl.dateFilterTypeChange({$dateFilterType:dateFilterType})};ctrl.switchDateFilterPart=function(dateFilterPart){ctrl.switchedType=false;const newFilterTmpData=_.cloneDeep(ctrl.filterTmpData);ChartFilters.switchDateFilterPart(dateFilterPart,newFilterTmpData);ChartFilters.switchFilterSelectionType(CHART_FILTERS.FILTER_SELECTION_TYPES.MULTI_SELECT,newFilterTmpData,ctrl.filters,ctrl.index,ctrl.getFiltersRequestOptions()).then(()=>ctrl.filterTmpDataChange({$filterTmpData:newFilterTmpData}))};ctrl.onDateRangeChange=function(event,facetUiState,filterTmpData){ctrl.switchedType=false;facetUiState.fromDateRangeModel=event.from;facetUiState.toDateRangeModel=event.to;facetUiState.timezoneDateRangeModel=event.tz;if(!facetUiState.fromDateRangeModel||!facetUiState.toDateRangeModel||!ChartFilters.hasDateRangeChanged(facetUiState,filterTmpData)){return}ChartFilters.updateDateRange(facetUiState,filterTmpData);ctrl.filterTmpDataChange({$filterTmpData:ctrl.filterTmpData})};ctrl.onRelativeDateChange=function(facet){ctrl.switchedType=false;const{datePart,relativeOption,relativePreset}=facet;const filterTmpData={...ctrl.filterTmpData,dateFilterPart:datePart,dateFilterOption:relativeOption,dateFilterRelativePreset:relativePreset};ctrl.filterTmpDataChange({$filterTmpData:filterTmpData})};ctrl.onValuesSelectionChange=function(values){ctrl.switchedType=false;ctrl.filterTmpDataChange({$filterTmpData:{...ctrl.filterTmpData,values:values}})}}})})();(function(){"use strict";angular.module("dataiku.shared").component("pivotFilterFacet",{bindings:{filterTmpData:"<",filterFacet:"<",facetUiState:"<",filters:"<",index:"<",getFiltersRequestOptions:"<",dateFilterTypeChange:"&",filterTmpDataChange:"&"},templateUrl:"/static/dataiku/shared/components/pivot-filter-facet/pivot-filter-facet.component.html",controller:function(ChartFilterUtils){const ctrl=this;ctrl.isDateFilter=ChartFilterUtils.isDateFilter.bind(ChartFilterUtils);ctrl.isNumericalFilter=ChartFilterUtils.isNumericalFilter.bind(ChartFilterUtils);ctrl.isNumericalRangeFilter=ChartFilterUtils.isNumericalRangeFilter.bind(ChartFilterUtils);ctrl.isTrueAlphanumericalFilter=ChartFilterUtils.isTrueAlphanumericalFilter.bind(ChartFilterUtils);ctrl.isCustomFilter=ChartFilterUtils.isCustomFilter.bind(ChartFilterUtils);ctrl.isRelativeDateFilter=ChartFilterUtils.isRelativeDateFilter.bind(ChartFilterUtils);ctrl.handleFilterTmpDataChange=function(filterTmpData){ctrl.filterTmpDataChange({$filterTmpData:filterTmpData})};ctrl.handleDateFilterTypeChange=function(dateFilterType){ctrl.dateFilterTypeChange({$dateFilterType:dateFilterType})}}})})();(function(){"use strict";angular.module("dataiku.shared").component("pivotFilterList",{bindings:{datasetLoadingError:"<",filters:"<",filterFacets:"<",filterFacetsLoadingError:"<",nameOnly:"<",getFiltersRequestOptions:"<",readOnly:"<",samplingParams:"<",listClasses:"<",isInChartContext:"<",reorderingContainer:"<",direction:"<",theme:"<",canAllBeClearedChange:"&",filtersInit:"&",filtersChange:"&",reorderingStart:"&?",reorderingStop:"&?"},templateUrl:"/static/dataiku/shared/components/pivot-filter-list/pivot-filter-list.component.html",controller:function($timeout,Debounce,FiltersPanelDirection,translate){const BASE_FILTER_SORT_OPTIONS={cursor:"move",handle:".box-header",items:"> li",update(){$timeout(()=>ctrl.filtersChange({$currentValue:ctrl.filters,$previousValue:previousFilters}))},start(){$timeout(()=>{ctrl.reordering=true});if(ctrl.reorderingStart){ctrl.reorderingStart()}},stop(){$timeout(()=>{ctrl.reordering=false});if(ctrl.reorderingStop){ctrl.reorderingStop()}}};const ctrl=this;ctrl.FiltersPanelDirection=FiltersPanelDirection;ctrl.translate=translate;const canFiltersBeClearedById=new Map;let canAllFiltersBeCleared;let tmpFilters=null;const filterApisById=new Map;let previousFilters;ctrl.filterSortOptions=null;ctrl.reordering=false;ctrl.$onInit=function(){ctrl.filtersInit({$api:{clearAllFilters:clearAllFilters}})};ctrl.$onChanges=function(changes){if(!ctrl.direction){ctrl.direction=FiltersPanelDirection.Vertical}if(changes.filters&&changes.filters.currentValue){const currentFilterIds=new Set(changes.filters.currentValue.map(({id})=>id));let shouldRecomputeCanAllBeCleared=false;for(const previousFilterId of canFiltersBeClearedById.keys()){if(!currentFilterIds.has(previousFilterId)){shouldRecomputeCanAllBeCleared=true;canFiltersBeClearedById.delete(previousFilterId);filterApisById.delete(previousFilterId)}}if(shouldRecomputeCanAllBeCleared){computeCanAllBeClearedState()}previousFilters=angular.copy(ctrl.filters)}if(changes.readOnly||changes.isInChartContext||changes.filters||changes.reorderingContainer||changes.direction){const disabled=ctrl.readOnly||ctrl.filters==null||ctrl.filters.length<=1;const containment=ctrl.reorderingContainer||undefined;const axis=ctrl.direction===FiltersPanelDirection.Horizontal?"x":"y";ctrl.filterSortOptions={...BASE_FILTER_SORT_OPTIONS,containment:containment,disabled:disabled,axis:axis}}};ctrl.handleFilterChange=function(filter,canPropagageBeforeFacetUpdate,filterId,needAggregationRequest=true){const oldFilters=tmpFilters||ctrl.filters;const filterIndex=oldFilters.findIndex(({id})=>id===filterId);const newFilters=[...oldFilters.slice(0,filterIndex),...filter?[filter]:[],...oldFilters.slice(filterIndex+1)];tmpFilters=newFilters;emitFiltersChange(newFilters,ctrl.filters,canPropagageBeforeFacetUpdate,needAggregationRequest)};ctrl.handleCanBeClearedChange=function(filterId,canBeCleared){canFiltersBeClearedById.set(filterId,canBeCleared);if(canFiltersBeClearedById.size!==ctrl.filters.length){return}computeCanAllBeClearedState()};ctrl.handleFilterInit=function(filterId,filterApi){filterApisById.set(filterId,filterApi)};const emitFiltersChange=Debounce().withDelay(100,100).wrap((currentValue,previousValue,canPropagageBeforeFacetUpdate,needAggregationRequest)=>{tmpFilters=null;ctrl.filtersChange({$currentValue:currentValue,$previousValue:previousValue,$canPropagageBeforeFacetUpdate:canPropagageBeforeFacetUpdate,needAggregationRequest:needAggregationRequest})});function clearAllFilters(){for(const filterApi of filterApisById.values()){filterApi.clearFilter()}}function computeCanAllBeClearedState(){const newCanAllBeCleared=Array.from(canFiltersBeClearedById.values()).some(canBeCleared=>canBeCleared===true);if(newCanAllBeCleared!==canAllFiltersBeCleared){canAllFiltersBeCleared=newCanAllBeCleared;ctrl.canAllBeClearedChange({$canAllBeCleared:newCanAllBeCleared})}}}})})();(function(){"use strict";angular.module("dataiku.shared").component("pivotFilterNumericalFacet",{bindings:{filterTmpData:"<",facetUiState:"<",filterTmpDataChange:"&"},templateUrl:"/static/dataiku/shared/components/pivot-filter-numerical-facet/pivot-filter-numerical-facet.component.html",controller:function($timeout){const ctrl=this;ctrl.slideEnd=function(){$timeout(function(){if(!ctrl.filterTmpData||!ctrl.facetUiState){return}const minValue=ctrl.facetUiState.sliderModelMin;const maxValue=ctrl.facetUiState.sliderModelMax<minValue?minValue:ctrl.facetUiState.sliderModelMax;ctrl.filterTmpDataChange({$filterTmpData:{...ctrl.filterTmpData,minValue:minValue,maxValue:maxValue}})})}}})})();(function(){"use strict";const projectRightColumnSummary={templateUrl:"static/dataiku/shared/components/project-right-column-summary/project-right-column-summary.component.html",bindings:{summary:"<",canWriteProject:"<",activeTab:"<",clickTabFrom:"<",displayedTabs:"<",editCustomFields:"<",featureFlagEnabled:"<"},controller:function($scope,$rootScope,$state,DataikuAPI,ActivityIndicator,ProjectActionsService,translate){const ctrl=this;$scope.translate=translate;ctrl.$onInit=function(){ctrl.projectHref=$state.href("projects.project.home.summary",{projectKey:ctrl.summary.projectKey})};$scope.$on("objectSummaryEdited",function(){DataikuAPI.projects.saveSummary(ctrl.summary.projectKey,ctrl.summary).success(ActivityIndicator.success.bind(null,"Saved")).error(setErrorInScope.bind($scope))});ctrl.duplicateThisProject=()=>ProjectActionsService.duplicateThisProject($scope,ctrl.summary);ctrl.exportThisProject=()=>ProjectActionsService.exportThisProject($scope,ctrl.summary);ctrl.deleteThisProject=()=>ProjectActionsService.deleteThisProject($scope,ctrl.summary);ctrl.moveThisProject=()=>ProjectActionsService.moveThisProject($scope,ctrl.summary);ctrl.explainThisProject=()=>ProjectActionsService.explainThisProject($scope,ctrl.summary);ctrl.saveCustomFields=function(customFields){$scope.$emit("customFieldsSummaryEdited",customFields)};ctrl.isProjectAdmin=()=>ctrl.summary&&ctrl.summary.isProjectAdmin;ctrl.isProjectAnalystRW=()=>ctrl.summary&&ctrl.summary.canWriteProjectContent;ctrl.canManageBundles=()=>$rootScope.appConfig&&ctrl.summary&&($rootScope.appConfig.requireProjectAdminPermissionToExportAndBundleProjects&&ctrl.summary.isProjectAdmin)||!$rootScope.appConfig.requireProjectAdminPermissionToExportAndBundleProjects&&ctrl.summary.canWriteProjectContent;ctrl.showActionsSection=()=>ctrl.canManageBundles()||$rootScope.appConfig.aiExplanationsEnabled;ctrl.$onChanges=()=>{ctrl.currentCustomFieldsTabData=(ctrl.displayedTabs||[]).find(t=>t.name===ctrl.activeTab)?.customFieldsData}}};angular.module("dataiku.shared").component("projectRightColumnSummary",projectRightColumnSummary)})();(function(){"use strict";const projectSummaryList={bindings:{summary:"<"},templateUrl:"static/dataiku/shared/components/project-summary-list-component/project-summary-list.component.html",controller:function(){const $ctrl=this;$ctrl.notebookCount=0;$ctrl.$onChanges=changes=>{if(changes&&changes.summary&&changes.summary.currentValue){$ctrl.notebookCount=$ctrl.summary.jupyterNotebooks+$ctrl.summary.sqlNotebooks+$ctrl.summary.searchNotebooks}}}};angular.module("dataiku.shared").component("projectSummaryList",projectSummaryList)})();(function(){"use strict";const promptChat={bindings:{initialMessages:"<",lastMessageId:"<",context:"<",sessionId:"<",availableLlms:"<",hasActiveLlm:"<",warnAboutRaLlmSearchMode:"<",activeLlmIcon:"<",emptyStateMessage:"<",customAssistantMessageSettings:"<?",showContextSelector:"<?",settingsComparator:"&?",onBeforeSendMessage:"&?",onSendMessage:"&",onForkMessage:"&?",onStopStreaming:"&",onChatCompletion:"&",onSetContext:"&",processResponse:"&?"},templateUrl:"/static/dataiku/shared/components/prompt-chat/prompt-chat.component.html",controller:function($rootScope,$scope,$timeout,PromptUtils,PromptChatService,TraceExplorerService,ClipboardUtils,Logger,CreateModalFromTemplate,CodeMirrorSettingService,$dkuSanitize){const $ctrl=this;const entryElId="prompt-chat-entry";$ctrl.chatSessions={};$ctrl.message="";$ctrl.messageBranch=[];$ctrl.messages={};$ctrl.iconSize=16;$ctrl.editedMessage="";$ctrl.editedMessageId="";$ctrl.toolValidations=null;$ctrl.$onChanges=changes=>{if(changes.initialMessages){const activeSession=$ctrl.chatSessions[$ctrl.sessionId];if(activeSession?.currentlyStreaming){$ctrl.initialMessages[activeSession.lastUserMessage.id]=activeSession.lastUserMessage;$ctrl.lastMessageId=activeSession.lastUserMessage.id}if(changes.lastMessageId?.currentValue!==changes.lastMessageId?.previousValue){prepareMessages($ctrl.initialMessages,$ctrl.lastMessageId)}}if(changes.sessionId){clearMessage()}};$scope.$on("prompt-chat--resetChat",function(event,data){resetChat()});function getChatHandler(runData,isRerun){const activeSessionId=$ctrl.sessionId;$ctrl.chatSessions[activeSessionId]={...$ctrl.chatSessions[activeSessionId]||{},streamedMessage:"",rawMessage:"",streamedParts:[],rawReasoning:"",reasoning:"",currentlyStreaming:true,useMarkdown:true,streamingSupported:true,streamingNotSupportedMessage:"",lastCustomAssistantMessageSettings:angular.copy($ctrl.customAssistantMessageSettings),abortController:new AbortController,runData:runData,isRerun:isRerun};const activeSession=$ctrl.chatSessions[activeSessionId];const CHAR_LIMIT_FOR_MARKDOWN=500;const THROTTLE_MIN_LENGTH=1e4;let previousLength=0;let currentReasoningIndex;let currentReasoningId;const callback=chunk=>{scrollChat(activeSessionId,false);const event=chunk["event"];const data=chunk["data"];switch(event){case"completion-chunk":{if(data.artifacts&&data.artifacts.length){data.artifacts.forEach(artifact=>{if(artifact.type==="REASONING"&&artifact.parts&&artifact.parts.length){if(currentReasoningId==null){currentReasoningId=artifact.id}if(currentReasoningId!==artifact.id){activeSession.rawReasoning+="\n\n";currentReasoningId=artifact.id}artifact.parts.forEach(artifactPart=>{if(artifactPart.type==="TEXT"){if(currentReasoningIndex==null){currentReasoningIndex=artifactPart.index}if(currentReasoningIndex!==artifactPart.index){currentReasoningIndex=artifactPart.index;activeSession.rawReasoning+="\n\n"}activeSession.rawReasoning+=artifactPart.text;if(activeSession.useMarkdown){try{activeSession.reasoning=$dkuSanitize(marked(activeSession.rawReasoning,{breaks:true}))}catch(e){Logger.error("Error parsing markdown HTML, switching to plain text",e);activeSession.useMarkdown=false}}if(!activeSession.useMarkdown){activeSession.reasoning=activeSession.rawReasoning}$scope.$apply();scrollChat(activeSessionId,false)}})}})}if(data.text){activeSession.rawMessage+=data.text;let currentLength=activeSession.rawMessage.length;const convertToMarkdown=currentLength<THROTTLE_MIN_LENGTH||currentLength>THROTTLE_MIN_LENGTH&&currentLength>previousLength+CHAR_LIMIT_FOR_MARKDOWN;const textPart=getOrCreateTextPart();textPart.raw+=data.text;if(activeSession.useMarkdown&&convertToMarkdown){try{textPart.html=$dkuSanitize(marked(textPart.raw,{breaks:true}));previousLength=currentLength}catch(e){Logger.error("Error parsing markdown HTML, switching to plain text",e);activeSession.useMarkdown=false}}if(!activeSession.useMarkdown){textPart.html=textPart.raw}combineStreamedParts();$scope.$apply();scrollChat(activeSessionId,false)}if(data.type==="event"&&activeSession.lastCustomAssistantMessageSettings?.toolsUsingAgentSettings?.debugMode){const text='<code class="prompt-chat__output-text--event">EVENT: '+data.eventKind+": "+JSON.stringify(data.eventData).replace("_","&lowbar;")+"</code>\n\n";const debugHtml=$dkuSanitize(text);activeSession.streamedParts.push({type:"debug",html:debugHtml});combineStreamedParts();$scope.$apply();scrollChat(activeSessionId,false)}break}case"completion-response":{const streamedMessage=activeSession.streamedMessage;activeSession.streamedMessage="";activeSession.currentlyStreaming=false;activeSession.isRerun=false;if($ctrl.sessionId===activeSessionId){onChatCompletion($ctrl.processResponse?$ctrl.processResponse({response:data}):data,activeSessionId,streamedMessage);$timeout(()=>{scrollChat(activeSessionId,true)})}break}case"no-streaming":{activeSession.streamingSupported=false;activeSession.streamingNotSupportedMessage=data["text"];$scope.$apply();break}case"completion-end":{break}default:{Logger.error("Unknown chunk event: "+event)}}};$timeout(()=>{scrollChat(activeSessionId,true)});function combineStreamedParts(){activeSession.streamedMessage=activeSession.streamedParts.map(part=>part.html||"").join("")}function getOrCreateTextPart(){const parts=activeSession.streamedParts;const lastPart=parts.length?parts[parts.length-1]:null;if(lastPart&&lastPart.type==="text"){return lastPart}const newPart={type:"text",raw:"",html:""};parts.push(newPart);return newPart}return{callback:callback,activeSession:activeSession}}function onSendMessage(newMessage,chatHandlerParams,isRerun,isEdit){const isEditOrRerun=isRerun||isEdit;if(isEditOrRerun&&$ctrl.onBeforeSendMessage){$ctrl.onBeforeSendMessage({isEditOrRerun:isEditOrRerun})}$ctrl.chatSessions[$ctrl.sessionId]={...$ctrl.chatSessions[$ctrl.sessionId]||{},lastUserMessage:newMessage,defaultMessage:""};const{callback,activeSession}=getChatHandler(chatHandlerParams,isRerun);$ctrl.onSendMessage({newMessage:newMessage,abortController:activeSession.abortController,messages:PromptChatService.cleanChatMesssages($ctrl.messages),callback:callback})}function setMessageField(el,message){el.parentNode.dataset.replicatedValue=message}$ctrl.sendMessage=()=>{if($ctrl.onBeforeSendMessage){$ctrl.onBeforeSendMessage()}if(!$ctrl.lastMessageId){const rootMessage={id:generateRandomId(7),version:0,error:false};$ctrl.lastMessageId=rootMessage.id;$ctrl.messages[rootMessage.id]=rootMessage;$ctrl.messageBranch.push(rootMessage)}const newMessage={parentId:$ctrl.lastMessageId,id:generateRandomId(7),runBy:$rootScope.appConfig.login,message:{role:"user",content:$ctrl.message},version:0};$ctrl.messages[newMessage.id]=newMessage;$ctrl.messageBranch.push(newMessage);$ctrl.streamParentId=$ctrl.lastMessageId;onSendMessage(newMessage,{version:0,parentId:newMessage.id});clearMessage()};$ctrl.sendToolValidationResponses=()=>{const newMessage={parentId:$ctrl.lastMessageId,id:generateRandomId(7),runBy:$rootScope.appConfig.login,message:{role:"toolValidationResponses",toolValidationResponses:$ctrl.toolValidations.map(tv=>({validationRequestId:tv.id,validated:tv.validated,arguments:tv.arguments}))},version:0};$ctrl.messages[newMessage.id]=newMessage;$ctrl.messageBranch.push(newMessage);$ctrl.streamParentId=$ctrl.lastMessageId;onSendMessage(newMessage,{version:0,parentId:newMessage.id});clearMessage()};$ctrl.sendEditedMessage=parentId=>{const newMessage={parentId:parentId,id:generateRandomId(7),runBy:$rootScope.appConfig.login,message:{role:"user",content:$ctrl.editedMessage}};$ctrl.messageBranch=buildBranch(parentId);$ctrl.messageBranch.push(newMessage);$ctrl.streamParentId=parentId;onSendMessage(newMessage,null,false,true);$ctrl.clearEditedMessage()};$ctrl.forkMessage=userMessage=>{$ctrl.onForkMessage({sessionId:$ctrl.sessionId,userMessage:userMessage}).then(newSessionId=>{$ctrl.chatSessions[newSessionId]={...$ctrl.chatSessions[newSessionId]||{},defaultMessage:userMessage.message.content};clearMessage()})};$ctrl.rerunResponse=message=>{let parentId=message.parentId;while($ctrl.messages[parentId]&&!["user","toolValidationResponses"].includes($ctrl.messages[parentId].message.role)){const hiddenMessage=$ctrl.messages[parentId];parentId=hiddenMessage.parentId}const newMessage=$ctrl.messages[parentId];$ctrl.messageBranch=buildBranch(parentId);onSendMessage(newMessage,{version:message.version+1,parentId:parentId},true)};$ctrl.clearEditedMessage=()=>{$ctrl.editedMessage="";$ctrl.editedMessageId=""};$ctrl.cannotSendMessage=()=>{return $ctrl.cannotRunChat()||$ctrl.message.trim()===""||$ctrl.hasError()||$ctrl.editedMessageId||$ctrl.pendingToolValidations()};$ctrl.hasError=()=>{return $ctrl.messageBranch.some(x=>x.error)};$ctrl.cannotSendEditedMessage=()=>{return $ctrl.cannotRunChat()||$ctrl.editedMessage.trim()===""};$ctrl.cannotRerunMessage=()=>{return $ctrl.cannotRunChat()};$ctrl.isStreaming=()=>{return $ctrl.chatSessions[$ctrl.sessionId]&&$ctrl.chatSessions[$ctrl.sessionId].currentlyStreaming};$ctrl.pendingToolValidations=()=>{return $ctrl.messages&&$ctrl.messages[$ctrl.lastMessageId]&&$ctrl.messages[$ctrl.lastMessageId].message&&$ctrl.messages[$ctrl.lastMessageId].message["role"]==="toolValidationRequests"};$ctrl.setToolValidations=()=>{if($ctrl.pendingToolValidations()){$ctrl.toolValidations=$ctrl.messages[$ctrl.lastMessageId].message.toolValidationRequests}else{$ctrl.toolValidations=null}};$ctrl.cannotRunChat=()=>{return!$ctrl.hasActiveLlm||$ctrl.isStreaming()};$ctrl.switchBranch=(message,position)=>{const parent=$ctrl.messages[message.parentId];let nextMessage=$ctrl.messages[parent.childrenIds[position]];while(nextMessage.childrenIds&&nextMessage.childrenIds.length){nextMessage=$ctrl.messages[nextMessage.childrenIds[0]]}$ctrl.lastMessageId=nextMessage.id;$ctrl.messageBranch=buildBranch($ctrl.lastMessageId)};$ctrl.onKeydown=(event,sendEdited,parentId)=>{if(event.key==="Enter"){if(!event.shiftKey){event.preventDefault();if(sendEdited){!$ctrl.cannotSendEditedMessage()&&$ctrl.sendEditedMessage(parentId)}else{!$ctrl.cannotSendMessage()&&$ctrl.sendMessage()}}}};$ctrl.editMessage=message=>{$ctrl.editedMessageId=message.id;$ctrl.editedMessage=message.message.content;$timeout(()=>{const editEl=document.getElementById("prompt-chat-edit-entry");editEl.focus();setMessageField(editEl,editEl.value)})};$ctrl.getLLMIconName=llmStructuredRef=>{return PromptUtils.getLLMIcon(llmStructuredRef.type,$ctrl.iconSize)};$ctrl.getLLMIconStyle=llmStructuredRef=>{return PromptUtils.getLLMColorStyle(llmStructuredRef.id,$ctrl.availableLlms)};$ctrl.getLLMFriendlyName=llmStructuredRef=>{return llmStructuredRef.friendlyName||($ctrl.availableLlms||[]).find(llm=>llm.id===llmStructuredRef.id)?.friendlyName};$ctrl.copyTraceToClipboard=function(message){ClipboardUtils.copyToClipboard(JSON.stringify(message.fullTrace,null,2),"Trace copied to clipboard")};$ctrl.copyMessageToClipboard=function(message){ClipboardUtils.copyToClipboard(message.error?message.llmError:message.message.content,"Message copied to clipboard")};$ctrl.openTraceExplorer=function(message){TraceExplorerService.openTraceExplorer(message.fullTrace)};$ctrl.openEditContextModal=()=>{CreateModalFromTemplate("/templates/widgets/edit-context-modal.html",$scope,null,function(modalScope){modalScope.codeMirrorSettings={...CodeMirrorSettingService.get("application/json",{onLoad:editor=>{$timeout(function(){editor.focus()},50)}})};modalScope.uiState=modalScope.uiState||{};modalScope.uiState.showContextSelector=$ctrl.showContextSelector;const currentContext=PromptChatService.getChatContext($ctrl.sessionId);modalScope.uiState.contextWrapper={context:currentContext?angular.copy(currentContext):{}};modalScope.setTemplate=template=>{modalScope.uiState.contextWrapper={context:template}};modalScope.confirm=()=>{const newContext=modalScope.uiState.contextWrapper?.context;if($ctrl.onSetContext){$ctrl.onSetContext({context:newContext})}modalScope.dismiss()}})};$ctrl.stopStreaming=function(){const sessionId=$ctrl.sessionId;$ctrl.chatSessions[sessionId]?.abortController.abort();$timeout(function(){const promise=$ctrl.onStopStreaming({sessionId:sessionId,activeSession:$ctrl.chatSessions[sessionId],messages:$ctrl.messages})||Promise.resolve();promise.then(response=>{if(response){onChatCompletion(response,$ctrl.sessionId,$ctrl.sessionId in $ctrl.chatSessions?$ctrl.chatSessions[$ctrl.sessionId].streamedMessage:"");$timeout(()=>{scrollChat(sessionId,false)});$ctrl.chatSessions[$ctrl.sessionId]={...$ctrl.chatSessions[sessionId]||{},streamedMessage:"",currentlyStreaming:false}}}).catch(setErrorInScope.bind($scope))},600)};const llmStopDevKernelUnsubscribe=$rootScope.$on("llmStopDevKernel",(_,sessionId)=>{if($ctrl.chatSessions[sessionId]?.currentlyStreaming){$ctrl.stopStreaming()}});$scope.$on("$destroy",llmStopDevKernelUnsubscribe);function onChatCompletion(response,sessionId,lastMessageUIRepresentation){$ctrl.lastMessageId=response.lastMessageId;const customAssistantMessageSettings=$ctrl.chatSessions[$ctrl.sessionId]?.lastCustomAssistantMessageSettings;if($ctrl.lastMessageId in response.chatMessages){response.chatMessages[$ctrl.lastMessageId].message.uiRepresentation=lastMessageUIRepresentation}prepareMessages(response.chatMessages,response.lastMessageId,customAssistantMessageSettings);if(response.log){PromptChatService.setLog($ctrl.sessionId,response.log)}if(response.contextUpsert){Logger.info("Upserting in context",response.contextUpsert);PromptChatService.upsertChatContext($ctrl.sessionId,response.contextUpsert)}$ctrl.onChatCompletion({lastMessageId:response.lastMessageId,messages:response.chatMessages,enrichedMessages:$ctrl.messages})}function clearMessage(){$ctrl.message=$ctrl.chatSessions[$ctrl.sessionId]?.defaultMessage||"";setMessageField(document.getElementById(entryElId),"")}function resetChat(){$ctrl.messages={};$ctrl.messageBranch=[];$ctrl.lastMessageId=null;$ctrl.toolValidations=null;PromptChatService.setLog($ctrl.sessionId)}function scrollChat(activeSessionId,forceScroll){if($ctrl.sessionId===activeSessionId){const containerEl=document.getElementById("prompt-chat");if(containerEl){const SCROLL_BUFFER=50;if(forceScroll||containerEl.scrollTop>=containerEl.scrollHeight-containerEl.offsetHeight-SCROLL_BUFFER){containerEl.scrollTop=containerEl.scrollHeight}}}}function buildBranch(lastMessageId){return PromptChatService.buildCurrentChatBranch($ctrl.messages,lastMessageId,$ctrl.settingsComparator?(newMessage,oldMessage)=>$ctrl.settingsComparator({newMessage:newMessage,oldMessage:oldMessage}):undefined)}function prepareMessages(messages,lastMessageId,customAssistantMessageSettings){if(customAssistantMessageSettings){let _lastAssistantMessageId=lastMessageId;let _lastAssistantMessage=messages[_lastAssistantMessageId];if(_lastAssistantMessage&&_lastAssistantMessage.message?.role==="toolValidationRequests"){const memoryFragmentMessage=messages[_lastAssistantMessage.parentId];const beforeMemoryFragmentMessage=messages[memoryFragmentMessage.parentId];if(beforeMemoryFragmentMessage.message?.role==="assistant"){_lastAssistantMessage=beforeMemoryFragmentMessage;_lastAssistantMessageId=beforeMemoryFragmentMessage.id}}$ctrl.messages[_lastAssistantMessageId]={...$ctrl.messages[_lastAssistantMessageId]||{},$customSettings:customAssistantMessageSettings}}$ctrl.messages=PromptChatService.enrichChatMessages(messages,$ctrl.messages);$ctrl.messageBranch=buildBranch(lastMessageId);$ctrl.setToolValidations();document.getElementById(entryElId).focus();$timeout(()=>{const containerEl=document.getElementById("prompt-chat");containerEl.scrollTop=containerEl.scrollHeight})}}};angular.module("dataiku.shared").component("promptChat",promptChat)})();(function(){"use strict";const radioButtonAdminSetting={bindings:{options:"<",ngModel:"=",label:"@",ngChange:"&"},templateUrl:"static/dataiku/shared/components/radio-button-admin-setting/radio-button-admin-setting.component.html"};angular.module("dataiku.shared").component("radioButtonAdminSetting",radioButtonAdminSetting)})();(function(){"use strict";const relativeDateFacetComponent={templateUrl:"/static/dataiku/shared/components/relative-date-facet/relative-date-facet.component.html",bindings:{datePart:"<",relativePreset:"<",relativeOption:"<",last:"<",next:"<",onChange:"&"},controller:function(DataikuAPI,Debounce,ChartFilterUtils,CHART_FILTERS,$element,translate){const $ctrl=this;const CUSTOM=translate("CHARTS.FILTERS.SETTINGS.CUSTOM","Custom");$ctrl.element=$element.find("div");$ctrl.presetDateRelativeFilterParts=[...ChartFilterUtils.getPresetDateRelativeFilterParts(),[CUSTOM,CUSTOM]];$ctrl.displayCustomDateRelativeFilterParts=false;$ctrl.customDateRelativeFilterParts=ChartFilterUtils.getCustomDateRelativeFilterParts();$ctrl.dateRelativeFilterComputedStart="-";$ctrl.dateRelativeFilterComputedEnd="-";$ctrl.isFilterEffective=false;$ctrl.hasNext=false;$ctrl.hasLast=false;$ctrl.currentNext=1;$ctrl.currentLast=1;$ctrl.facet={datePart:undefined,relativeOption:getDefaultRelativeOption(),relativePreset:undefined};$ctrl.selectDateRangeText=translate("COMPONENT.DATE_FACET.SELECT.PLACEHOLDER","Select a date range");$ctrl.$onChanges=changes=>{if(changes.datePart){$ctrl.facet.datePart=$ctrl.datePart}if(changes.relativeOption){$ctrl.facet.relativeOption=$ctrl.relativeOption;$ctrl.selectedRelativePreset=$ctrl.relativeOption==null?undefined:$ctrl.selectedRelativePreset;$ctrl.displayCustomDateRelativeFilterParts=$ctrl.selectedRelativePreset===CUSTOM}if(changes.relativePreset){$ctrl.facet.relativePreset=$ctrl.relativePreset;if($ctrl.relativePreset==null){$ctrl.selectedRelativePreset=$ctrl.relativeOption==null?undefined:CUSTOM}else{$ctrl.selectedRelativePreset=$ctrl.relativePreset}$ctrl.displayCustomDateRelativeFilterParts=$ctrl.selectedRelativePreset===CUSTOM}if(changes.datePart||changes.relativeOption){updateFacetWithRelativeOption($ctrl.datePart,$ctrl.relativeOption);if($ctrl.relativeOption==null){$ctrl.selectedRelativePreset=undefined;$ctrl.displayCustomDateRelativeFilterParts=false}}};$ctrl.onPresetDatePartChange=()=>{if($ctrl.selectedRelativePreset===CUSTOM){$ctrl.facet.relativePreset=undefined;$ctrl.facet.datePart=$ctrl.facet.datePart==null?CHART_FILTERS.DATE_PARTS.YEAR:$ctrl.facet.datePart;$ctrl.displayCustomDateRelativeFilterParts=true}else{$ctrl.facet={...ChartFilterUtils.presetRelativeToCustomRelativeDatePartMap[$ctrl.selectedRelativePreset],relativePreset:$ctrl.selectedRelativePreset};$ctrl.displayCustomDateRelativeFilterParts=false}emitOnChange()};$ctrl.handleCustomRelativeDateOptionChange=relativeOption=>{$ctrl.facet.relativeOption=relativeOption;emitOnChange()};$ctrl.onDatePartChange=()=>{emitOnChange()};$ctrl.computeRelativeDateInterval=Debounce().withDelay(100,100).wrap(function(){DataikuAPI.shakers.computeRelativeDateInterval({part:$ctrl.facet.datePart,option:$ctrl.facet.relativeOption}).success(function(interval){$ctrl.dateRelativeFilterComputedStart=interval.start;$ctrl.dateRelativeFilterComputedEnd=interval.end}).error(function(){$ctrl.dateRelativeFilterComputedStart="-";$ctrl.dateRelativeFilterComputedEnd="-"})});$ctrl.stopEventPropagation=function(event){event&&event.stopPropagation()};function emitOnChange(){updateFacetWithRelativeOption($ctrl.facet.datePart,$ctrl.facet.relativeOption);$ctrl.onChange({$facet:$ctrl.facet})}function updateFacetWithRelativeOption(datePart,relativeOption){$ctrl.facet.datePart=datePart;$ctrl.facet.relativeOption=relativeOption==null?getDefaultRelativeOption():relativeOption;$ctrl.isFilterEffective=ChartFilterUtils.isRelativeDateFilterEffective($ctrl.facet.datePart,$ctrl.facet.relativeOption);if($ctrl.isFilterEffective){$ctrl.computeRelativeDateInterval()}}function getDefaultRelativeOption(){return{containsCurrentDatePart:false,isUntilNow:false,last:0,next:0}}}};angular.module("dataiku.shared").component("relativeDateFacet",relativeDateFacetComponent)})();(function(){"use strict";const buildStepAddItemsModal={bindings:{canDataset:"=",canManagedFolder:"=",canSavedModel:"=",canModelEvaluationStore:"=",canRetrievableKnowledge:"=",canFlowZone:"="},templateUrl:"static/dataiku/shared/components/scenario-add-items-modal/scenario-add-items-modal.component.html"};function addItemsModalController($scope,DataikuAPI,$stateParams,$filter){$scope.displaySelection="DATASET";$scope.newPartition=[];$scope.isAllFlowDatasets=false;$scope.setDisplaySelection=function(itemType){$scope.displaySelection=itemType;$scope.flowItemPartitioning=undefined;if(itemType==="DATASET"&&$scope.newDataset){$scope.flowItemPartitioning=$scope.partitioning[$scope.getDatasetLoc($scope.newDataset)]}else if(itemType==="MANAGED_FOLDER"&&$scope.newManagedFolder){$scope.flowItemPartitioning=$scope.partitioning[$scope.getManagedFolderLoc($scope.newManagedFolder)]}else if(itemType==="SAVED_MODEL"&&$scope.newSavedModel){$scope.flowItemPartitioning=$scope.partitioning[$scope.getSavedModelLoc($scope.newSavedModel)]}else if(itemType==="MODEL_EVALUATION_STORE"&&$scope.newModelEvaluationStore){$scope.flowItemPartitioning=$scope.partitioning[$scope.getModelEvaluationStoreLoc($scope.newModelEvaluationStore)]}};$scope.addDatasetToList=function(){let idx=-1;for(let i=0;i<$scope.items.length;i++){if($scope.getItemLoc($scope.items[i])==$scope.getDatasetLoc($scope.newDataset)&&$scope.items[i].partition==$scope.newPartition){idx=i}}if(idx==-1){$scope.items.push({type:"DATASET",projectKey:$scope.getProjectKeyIfNeeded($scope.newDataset.projectKey),itemId:$scope.newDataset.name,partitionsSpec:$scope.newPartition.join("|")})}$scope.dismiss()};$scope.addManagedFolderToList=function(){var idx=-1;for(var i=0;i<$scope.items.length;i++){if($scope.getItemLoc($scope.items[i])==$scope.getManagedFolderLoc($scope.newManagedFolder)&&$scope.items[i].partition==$scope.newPartition){idx=i}}if(idx==-1){$scope.items.push({type:"MANAGED_FOLDER",projectKey:$scope.getProjectKeyIfNeeded($scope.newManagedFolder.projectKey),itemId:$scope.newManagedFolder.id,partitionsSpec:$scope.newPartition.join("|")})}$scope.dismiss()};$scope.addSavedModelToList=function(){var idx=-1;for(var i=0;i<$scope.items.length;i++){if($scope.getItemLoc($scope.items[i])==$scope.getSavedModelLoc($scope.newSavedModel)){idx=i}}if(idx==-1){$scope.items.push({type:"SAVED_MODEL",projectKey:$scope.getProjectKeyIfNeeded($scope.newSavedModel.projectKey),itemId:$scope.newSavedModel.id,partitionsSpec:$scope.newPartition.join("|")})}$scope.dismiss()};$scope.addEvaluationStoreToList=function(){var idx=-1;for(var i=0;i<$scope.items.length;i++){if($scope.getItemLoc($scope.items[i])==$scope.getModelEvaluationStoreLoc($scope.newModelEvaluationStore)){idx=i}}if(idx==-1){$scope.items.push({type:"MODEL_EVALUATION_STORE",projectKey:$scope.getProjectKeyIfNeeded($scope.newModelEvaluationStore.projectKey),itemId:$scope.newModelEvaluationStore.id,partitionsSpec:$scope.newPartition.join("|")})}$scope.dismiss()};$scope.addRetrievableKnowledgeToList=function(){const alreadyListedRK=$scope.items.some(item=>$scope.getItemLoc(item)===$scope.getRetrievableKnowledgeLoc($scope.newRetrievableKnowledge));if(!alreadyListedRK){$scope.items.push({type:"RETRIEVABLE_KNOWLEDGE",projectKey:$scope.getProjectKeyIfNeeded($scope.newRetrievableKnowledge.projectKey),itemId:$scope.newRetrievableKnowledge.id})}$scope.dismiss()};$scope.addFlowZoneContentToList=function(){angular.forEach($scope.computables,function(computable){let userDefinedPartitioning=Object.values(computable.buildPartitions).join("|");let alreadyListed;if(computable.removed){return}switch(computable.type){case"DATASET":alreadyListed=$scope.items.some(item=>$scope.getItemLoc(item)===$scope.getDatasetLoc(computable)&&item.partitionsSpec===userDefinedPartitioning);if(!alreadyListed){$scope.items.push({type:"DATASET",projectKey:$scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),itemId:computable.name,partitionsSpec:userDefinedPartitioning})}$scope.dismiss();break;case"MANAGED_FOLDER":alreadyListed=$scope.items.some(item=>$scope.getItemLoc(item)===$scope.getManagedFolderLoc(computable)&&item.partitionsSpec===userDefinedPartitioning);if(!alreadyListed){$scope.items.push({type:"MANAGED_FOLDER",projectKey:$scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),itemId:computable.id,partitionsSpec:userDefinedPartitioning})}$scope.dismiss();break;case"SAVED_MODEL":alreadyListed=$scope.items.some(item=>$scope.getItemLoc(item)===$scope.getSavedModelLoc(computable));if(!alreadyListed){$scope.items.push({type:"SAVED_MODEL",projectKey:$scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),itemId:computable.id,partitionsSpec:userDefinedPartitioning})}$scope.dismiss();break;case"MODEL_EVALUATION_STORE":alreadyListed=$scope.items.some(item=>$scope.getItemLoc(item)===$scope.getModelEvaluationStoreLoc(computable));if(!alreadyListed){$scope.items.push({type:"MODEL_EVALUATION_STORE",projectKey:$scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),itemId:computable.id,partitionsSpec:userDefinedPartitioning})}$scope.dismiss();break;case"RETRIEVABLE_KNOWLEDGE":alreadyListed=$scope.items.some(item=>$scope.getItemLoc(item)===$scope.getRetrievableKnowledgeLoc(computable));if(!alreadyListed){$scope.items.push({type:"RETRIEVABLE_KNOWLEDGE",projectKey:$scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),itemId:computable.id})}$scope.dismiss();break}})};$scope.setDataset=function(selectedDataset){$scope.newDataset=selectedDataset};$scope.setManagedFolder=function(selectedManagedFolder){$scope.newManagedFolder=selectedManagedFolder};$scope.setSavedModel=function(selectedSavedModel){$scope.newSavedModel=selectedSavedModel};$scope.setEvaluationStore=function(selectedEvaluationStore){$scope.newModelEvaluationStore=selectedEvaluationStore};$scope.updateComputables=function(selectedFlowZone){$scope.newFlowZone=selectedFlowZone;DataikuAPI.flow.listDownstreamComputables($stateParams.projectKey,{zoneId:$scope.newFlowZone.id}).success(result=>{$scope.computables=result;$scope.isAllFlowDatasets=result.length>0&&result.filter(computable=>computable.type==="DATASET").length===result.length}).error(setErrorInScope.bind($scope))};$scope.setRetrievableKnowledge=function(selectedRetrievableKnowledge){$scope.newRetrievableKnowledge=selectedRetrievableKnowledge};$scope.$watch("newDataset",function(){$scope.flowItemPartitioning=$scope.partitioning[$scope.getDatasetLoc($scope.newDataset)]});$scope.$watch("newManagedFolder",function(){$scope.flowItemPartitioning=$scope.partitioning[$scope.getManagedFolderLoc($scope.newManagedFolder)]});$scope.$watch("newSavedModel",function(){$scope.flowItemPartitioning=$scope.partitioning[$scope.getSavedModelLoc($scope.newSavedModel)]});$scope.$watch("newModelEvaluationStore",function(){$scope.flowItemPartitioning=$scope.partitioning[$scope.getModelEvaluationStoreLoc($scope.newModelEvaluationStore)]});$scope.addToList=function(){switch($scope.displaySelection){case"DATASET":$scope.addDatasetToList();break;case"MANAGED_FOLDER":$scope.addManagedFolderToList();break;case"SAVED_MODEL":$scope.addSavedModelToList();break;case"MODEL_EVALUATION_STORE":$scope.addEvaluationStoreToList();break;case"RETRIEVABLE_KNOWLEDGE":$scope.addRetrievableKnowledgeToList();break;case"FLOW_ZONE":$scope.addFlowZoneContentToList();break}};$scope.getPartitioning=function(computable){if(computable.type==="DATASET"){return computable.serializedDataset.partitioning}if(computable.type==="MANAGED_FOLDER"){return computable.box.partitioning}if(computable.type==="SAVED_MODEL"){return computable.model.partitioning}};$scope.getIcon=function(computable){switch(computable.type){case"DATASET":return"dataset "+$filter("toModernIcon")($filter("datasetTypeToIcon")(computable.serializedDataset.type,16),16);case"MANAGED_FOLDER":return"dku-icon-dataset-files-in-folder-16";case"SAVED_MODEL":return"dku-icon-machine-learning-regression-16";case"RETRIEVABLE_KNOWLEDGE":return"retrievable-knowledge dku-icon-cards-stack-16";case"MODEL_EVALUATION_STORE":return"dku-icon-model-evaluation-store-16"}};$scope.removeRestore=function(index,isRemove){$scope.computables[index].removed=isRemove;$scope.validateForm()};$scope.validateForm=function(){$scope.theform.$invalid=$scope.computables.find(i=>!i.removed)==undefined}}angular.module("dataiku.shared").component("buildStepAddItemsModal",buildStepAddItemsModal).controller("BuildStepAddItemsModalController",addItemsModalController)})();(function(){"use strict";const sharedPagination={bindings:{pageSize:"<",listSize:"<",selectedPage:"<",pageRangeDisplayed:"<",marginpageDisplayed:"<",showBreaking:"<",onPageSelect:"&"},transclude:true,templateUrl:"static/dataiku/shared/components/shared-pagination/shared-pagination.component.html",controller:function(){this.pages=[];this.displayedPages=[];function createRange(length){return[...Array(length).keys()]}this.selectPage=function(pageIndex){this.onPageSelect({$event:{pageIndex:pageIndex,pageSize:this.pageSize}})};this.selectPreviousPage=function(){this.onPageSelect({$event:{pageIndex:this.selectedPage-1,pageSize:this.pageSize}})};this.selectNextPage=function(){this.onPageSelect({$event:{pageIndex:this.selectedPage+1,pageSize:this.pageSize}})};this.$onChanges=function(){if(angular.isUndefined(this.pageRangeDisplayed)){this.pageRangeDisplayed=7}if(angular.isUndefined(this.marginpageDisplayed)){this.marginPageDisplayed=0}if(angular.isUndefined(this.showBreaking)){this.showBreaking=false}if(this.listSize){this.displayedPages=[];this.pages=createRange(Math.floor(this.listSize/this.pageSize)+(this.listSize%this.pageSize!==0?1:0));const pageCount=this.pages.length;if(pageCount<=this.pageRangeDisplayed){for(let index=0;index<pageCount;index++){this.displayedPages.push({type:"page",index:this.pages[index]})}}else{let leftSide=this.pageRangeDisplayed/2;let rightSide=this.pageRangeDisplayed-leftSide;if(this.selectedPage>pageCount-this.pageRangeDisplayed/2){rightSide=pageCount-this.selectedPage;leftSide=this.pageRangeDisplayed-rightSide}else if(this.selectedPage<this.pageRangeDisplayed/2){leftSide=this.selectedPage;rightSide=this.pageRangeDisplayed-leftSide}this.displayedPages=this.pages.reduce((previousValue,newPage)=>{const page=newPage+1;if(page<=this.marginPageDisplayed){return[...previousValue,{type:"page",index:newPage}]}if(page>pageCount-this.marginPageDisplayed){return[...previousValue,{type:"page",index:newPage}]}const adjustedRightSide=this.selectedPage===0&&this.pageRangeDisplayed>1?rightSide-1:rightSide;if(newPage>=this.selectedPage-leftSide&&newPage<=this.selectedPage+adjustedRightSide){return[...previousValue,{type:"page",index:newPage}]}if(this.showBreaking&&previousValue.length>0&&previousValue[previousValue.length-1].type!=="break"&&(this.pageRangeDisplayed>0||this.marginPageDisplayed>0)){return[...previousValue,{type:"break",index:newPage}]}return previousValue},[])}}}}};angular.module("dataiku.shared").component("sharedPagination",sharedPagination)})();(function(){"use strict";angular.module("dataiku.shared").factory("BuiltinMapBackgrounds",builtinMapBackgrounds);function builtinMapBackgrounds($window,translate,$rootScope){const backgrounds=[];function _addCustom({background,atTheEnd=true,withLog=false}){const existingIndex=backgrounds.findIndex(b=>b.id===background.id);if(existingIndex!==-1){withLog&&console.warn("Map background '"+background.id+"' already exists, it will be overriden.");backgrounds.splice(existingIndex,1,background)}else{atTheEnd?backgrounds.push(background):backgrounds.unshift(background)}}function addCustom(background){_addCustom({background:background,atTheEnd:true,withLog:true})}function addMapbox(mapId,label,accessToken){let name;if(!label){name=mapId.split(".")[mapId.split(".").length-1];name=name.charAt(0).toUpperCase()+name.slice(1).toLowerCase()}else{name=label}addCustom({id:mapId,name:name,category:"Mapbox",getTileLayer:function(){return L.tileLayer("https://api.mapbox.com/v4/"+mapId+"/{z}/{x}/{y}.png?access_token="+accessToken,{attribution:'© <a href="https://www.mapbox.com/feedback/">Mapbox</a> © <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'})}})}function addWMS(id,name,category,wmsURL,layerId){addCustom({id:id,name:name,category:category,getTileLayer:function(){return L.tileLayer.wms(wmsURL,{layers:layerId})}})}function _getDefaultMapBackgrounds(){return[{id:"cartodb-positron",name:translate("BUILTIN_MAP_BACKGROUNDS.CARTODB_POSITRON","Black & White (light)"),getTileLayer:function(){return new L.tileLayer("http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png",{attribution:'&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="http://cartodb.com/attributions">CartoDB</a>'})},fadeColor:"#333"},{id:"cartodb-dark",name:translate("BUILTIN_MAP_BACKGROUNDS.CARTODB_DARK","Black & White (dark)"),getTileLayer:function(){return new L.tileLayer("http://{s}.basemaps.cartocdn.com/dark_all/{z}/{x}/{y}.png",{attribution:'&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="http://cartodb.com/attributions">CartoDB</a>'})},fadeColor:"#EEE"}]}const dkuMapBackgrounds={};dkuMapBackgrounds.addCustom=addCustom;dkuMapBackgrounds.addMapbox=addMapbox;dkuMapBackgrounds.addWMS=addWMS;dkuMapBackgrounds.backgrounds=backgrounds;$window.dkuMapBackgrounds=dkuMapBackgrounds;let isBound=false;function bindOnTranslateChangeSuccess(){if(!isBound){$rootScope.$on("$translateChangeSuccess",function(){const defaultBackgrounds=_getDefaultMapBackgrounds();defaultBackgrounds.forEach(defaultBackground=>_addCustom({background:defaultBackground,atTheEnd:false,withLog:false}))});isBound=true}}return{getBackgrounds:()=>[...dkuMapBackgrounds.backgrounds],bindOnTranslateChangeSuccess:bindOnTranslateChangeSuccess,addCustom:addCustom,addMapbox:addMapbox,addWMS:addWMS}}})();(function(){"use strict";angular.module("dataiku.shared").factory("FilterFacetsService",FilterFacetsService);function FilterFacetsService(DataikuAPI,Logger,MonoFuture){function getFilterFacets(projectKey,dataSpec,request,requestedSampleId,monoFuture=MonoFuture(),visualAnalysisFullModelId=null){Logger.info("Filter request is",request);const getFiltersExecutePromise=()=>{if(!request){return Promise.resolve()}if(visualAnalysisFullModelId){return DataikuAPI.analysis.predicted.chartsGetPivotResponse(visualAnalysisFullModelId,request,requestedSampleId).noSpinner()}return DataikuAPI.shakers.charts.getPivotResponse(projectKey,dataSpec,request,requestedSampleId).noSpinner()};const executeFiltersPivotRequestFuture=monoFuture.wrap(getFiltersExecutePromise);return executeFiltersPivotRequestFuture().update(data=>{Logger.info("Waiting for filter facets",data.jobId)})}return{getFilterFacets:getFilterFacets}}})();(function(){"use strict";angular.module("dataiku.shared").factory("PromptChatService",PromptChatService);function PromptChatService($dkuSanitize,$rootScope,Logger,CreateModalFromTemplate,CodeMirrorSettingService,ClipboardUtils,ConnectionsService,PromptUtils,ReasoningEffortCompletionSetting){const svc={};svc.buildCurrentChatBranch=function(messages,lastMessageId,settingsComparator=compareLlmSettings){let currentBranch=[];if(!messages||Object.keys(messages).length===0){return currentBranch}let currentMessage=messages[lastMessageId];while(currentMessage&&currentMessage.parentId){currentBranch.push(currentMessage);try{if(currentMessage.message.uiRepresentation){currentMessage.message.$markdownContent=currentMessage.message.uiRepresentation}else if(currentMessage.message.content){currentMessage.message.$markdownContent=$dkuSanitize(marked(currentMessage.message.content,{breaks:true}))}}catch(e){Logger.error("Error parsing markdown HTML, switching to plain text",e);currentMessage.message.$markdownContent=null}if(currentMessage.error&&currentMessage.llmError){currentMessage.credentialsError=ConnectionsService.getCredentialsError(currentMessage.llmError)}currentMessage=messages[currentMessage.parentId]}let previousAssistantMessage;currentBranch=currentBranch.reverse();Object.entries(currentBranch).forEach(([key,message])=>{if(message.message&&["assistant","toolValidationRequests"].includes(message.message.role)&&message.$customSettings!=null){if(previousAssistantMessage){message.$changedSettings=settingsComparator(message,previousAssistantMessage);message.$contextChanged=!angular.equals(message.context,previousAssistantMessage.context)}previousAssistantMessage=message}});return currentBranch};svc.enrichChatMessages=function(messages,preEnrichedMessages){if(!messages)return{};const enrichedMessages=angular.copy(messages);Object.entries(enrichedMessages).forEach(([key,message])=>{message.statusClass=getChatOutputClass(message);if(preEnrichedMessages&&preEnrichedMessages[message.id]?.$customSettings){message.$customSettings=preEnrichedMessages[message.id].$customSettings}const parentId=message.parentId;if(parentId){const parentMessage=enrichedMessages[parentId];if(!parentMessage.childrenIds){parentMessage.childrenIds=[]}parentMessage.childrenIds[message.version]=message.id;if(message.message&&message.message.toolValidationResponses&&parentMessage&&parentMessage.message.toolValidationRequests){const tvrMap=new Map;parentMessage.message.toolValidationRequests.forEach(tvreq=>tvrMap.set(tvreq.id,tvreq));message.message.toolValidationResponses.forEach(tvresp=>{const tvreq=tvrMap.get(tvresp.validationRequestId);tvreq.validated=tvresp.validated;tvreq.arguments=tvresp.arguments})}}});return enrichedMessages};svc.openConversationHistoryModal=function($scope,chatMessages,lastMessageId,llmSettings,chatSystemMessage){CreateModalFromTemplate("/templates/promptstudios/conversation-history-modal.html",$scope,null,function(modalScope){modalScope.uiState={activeTab:"json"};modalScope.pythonReadOnlyOptions=CodeMirrorSettingService.get("text/x-python");modalScope.pythonReadOnlyOptions["readOnly"]="nocursor";modalScope.jsonReadOnlyOptions=CodeMirrorSettingService.get("application/json");modalScope.jsonReadOnlyOptions["readOnly"]="nocursor";function getJsonMessages(){let messages=svc.buildCurrentChatBranch(chatMessages,lastMessageId).filter(item=>!item.error).map(item=>{const{$markdownContent,...rest}=item.message;return rest});if(chatSystemMessage){let systemMessage={role:"system",content:chatSystemMessage};messages.unshift(systemMessage)}return messages}function getPythonMessages(){let messages=getJsonMessages();let pythonMessages="import dataiku\n";pythonMessages+=`LLM_ID = "${$scope.activeLLM.id}"\n`;pythonMessages+=`llm = dataiku.api_client().get_default_project().get_llm(LLM_ID)\n`;pythonMessages+=`# Create and run a completion query with your chat history\n`;pythonMessages+=`chat = llm.new_completion()\n\n`;if(llmSettings["reasoningEffort"]&&PromptUtils.isReasoningModel($scope.activeLLM)){pythonMessages+=`chat.settings["reasoningEffort"] = "${llmSettings["reasoningEffort"]}"\n`;if(llmSettings["reasoningEffort"]==="CUSTOM"&&llmSettings["customReasoningEffort"]){pythonMessages+=`chat.settings["customReasoningEffort"] = "${llmSettings["customReasoningEffort"]}"\n`}}if(llmSettings["temperature"]){pythonMessages+=`chat.settings["temperature"] = ${llmSettings["temperature"]}\n`}if(llmSettings["topK"]){pythonMessages+=`chat.settings["topK"] = ${llmSettings["topK"]}\n`}if(llmSettings["topP"]){pythonMessages+=`chat.settings["topP"] = ${llmSettings["topP"]}\n`}if(llmSettings["maxOutputTokens"]){pythonMessages+=`chat.settings["maxOutputTokens"] = ${llmSettings["maxOutputTokens"]}\n`}if(llmSettings["stopSequences"]&&llmSettings["stopSequences"].length>0){pythonMessages+=`chat.settings["stopSequences"] = ${llmSettings["stopSequences"]}\n`}if(llmSettings["presencePenalty"]){pythonMessages+=`chat.settings["presencePenalty"] = ${llmSettings["presencePenalty"]}\n`}if(llmSettings["frequencyPenalty"]){pythonMessages+=`chat.settings["frequencyPenalty"] = ${llmSettings["frequencyPenalty"]}\n`}if(llmSettings["responseFormat"]){pythonMessages+=`chat.with_json_output()\n`}const pythoniseBoolean=function(s){s=s.replaceAll(`"allowEditingInputs":false`,`"allowEditingInputs":False`);return s.replaceAll(`"allowEditingInputs":true`,`"allowEditingInputs":True`)};pythonMessages+="\n";messages.forEach(message=>{if(message["role"]==="memoryFragment"){pythonMessages+=`chat.with_memory_fragment(${JSON.stringify(message["memoryFragment"])})\n`}else if(message["role"]==="toolValidationRequests"){pythonMessages+=`chat.with_tool_validation_requests(${pythoniseBoolean(JSON.stringify(message["toolValidationRequests"]))})\n`}else if(message["role"]==="toolValidationResponses"){for(const tvresp of message["toolValidationResponses"]){const validated=tvresp.validated?"True":"False";pythonMessages+=`chat.with_tool_validation_response(${JSON.stringify(tvresp.validationRequestId)}, ${validated}`;if(tvresp.arguments!=null){pythonMessages+=`, ${JSON.stringify(tvresp.arguments)}`}pythonMessages+=`)\n`}}else{pythonMessages+=`chat.with_message(${JSON.stringify(message["content"])}, role=${JSON.stringify(message["role"])})\n`}});pythonMessages+="\n";pythonMessages+=`response = chat.execute()`;return pythonMessages}modalScope.jsonMessages=getJsonMessages();modalScope.pythonMessages=getPythonMessages();modalScope.copyConversationHistory=function(){if(modalScope.uiState.activeTab==="json"){ClipboardUtils.copyToClipboard(JSON.stringify(modalScope.jsonMessages,null,2),"Conversation copied to clipboard")}if(modalScope.uiState.activeTab==="python"){ClipboardUtils.copyToClipboard(modalScope.pythonMessages,"Conversation copied to clipboard")}}})};const logs={};svc.getLog=function(sessionId){return logs[sessionId]};svc.setLog=(sessionId,log)=>{logs[sessionId]=log};svc.clearLogs=()=>{Object.keys(logs).forEach(sessionId=>delete logs[sessionId])};const chatCache={};svc.getChat=sessionId=>{return chatCache[sessionId]};svc.setChat=(sessionId,lastMessageId,messages)=>{chatCache[sessionId]={...chatCache[sessionId]||{},lastMessageId:lastMessageId,messages:messages}};svc.setChatContext=(sessionId,context)=>{chatCache[sessionId]={...chatCache[sessionId]||{},context:context}};svc.resetChat=sessionId=>{svc.setChat(sessionId);svc.setChatContext(sessionId,null)};svc.getChatContext=sessionId=>{return chatCache[sessionId]?.context};svc.getChatContextInitializeIfNeeded=sessionId=>{let context=chatCache[sessionId]?.context;if(!context){context={conversationId:"conv-"+Math.random().toString(36).substring(2,15)+Math.random().toString(36).substring(2,15),dkuOnBehalfOf:$rootScope.appConfig.login};svc.setChatContext(sessionId,context)}return context};svc.upsertChatContext=(sessionId,contextUpsert)=>{let previousContext=svc.getChatContext(sessionId);const mergedContext={...previousContext};for(const key in contextUpsert){if(Object.prototype.hasOwnProperty.call(contextUpsert,key)){const upsertValue=contextUpsert[key];if(upsertValue!=null){mergedContext[key]=upsertValue}else if(Object.prototype.hasOwnProperty.call(mergedContext,key)){delete mergedContext[key]}}}svc.setChatContext(sessionId,mergedContext)};svc.cleanChatMesssages=function(messages){const cleanedMessages={};Object.entries(messages).forEach(([key,message])=>{const{statusClass,credentialsError,$changedSettings,$customSettings,$contextChanged,message:{$markdownContent,...restMessage}={},...rest}=message;cleanedMessages[key]={...rest,...message.message&&{message:restMessage}}});return cleanedMessages};svc.compareCompletionSettings=(newCompletionSettings,oldCompletionSettings,changes)=>{const settings={temperature:"Temperature",topK:"TopK",topP:"TopP",maxOutputTokens:"Max Output Tokens",frequencyPenalty:"Frequency Penalty",presencePenalty:"Presence Penalty"};Object.entries(settings).forEach(([key,label])=>{compareAndPush(newCompletionSettings?.[key],oldCompletionSettings?.[key],label,changes)});compareAndPush(newCompletionSettings.responseFormat?.type,oldCompletionSettings.responseFormat?.type,"Response Format",changes);compareAndPushReasoning(newCompletionSettings,oldCompletionSettings,changes)};return svc;function compareAndPush(newVal,oldVal,label,changes){if(newVal!==oldVal){if(["System message","Response Format"].includes(label)){changes.push(`${label} has changed`)}else{changes.push(`${label} has changed from ${oldVal??"not defined"} to ${newVal??"not defined"}`)}}}function compareAndPushReasoning(newSettings,oldSettings,changes){let newReasoningEffort=ReasoningEffortCompletionSetting.find(function(reasoningEffort){return reasoningEffort.rawValue===newSettings.reasoningEffort});let oldReasoningEffort=ReasoningEffortCompletionSetting.find(function(reasoningEffort){return reasoningEffort.rawValue===oldSettings.reasoningEffort});if(newReasoningEffort!==oldReasoningEffort){if(newReasoningEffort.rawValue==="CUSTOM"){changes.push(`Reasoning Effort has changed from ${oldReasoningEffort.displayName} to custom value ${newSettings.customReasoningEffort}`)}else if(oldReasoningEffort.rawValue==="CUSTOM"){changes.push(`Reasoning Effort has changed from custom value ${oldSettings.customReasoningEffort} to ${newReasoningEffort.displayName}`)}else{changes.push(`Reasoning Effort has changed from ${oldReasoningEffort.displayName} to ${newReasoningEffort.displayName}`)}}if(oldReasoningEffort.rawValue==="CUSTOM"&&newReasoningEffort.rawValue==="CUSTOM"&&oldSettings.customReasoningEffort!==newSettings.customReasoningEffort){changes.push(`Reasoning Effort has changed from custom value ${oldSettings.customReasoningEffort} to custom value ${newSettings.customReasoningEffort}`)}}function compareLlmSettings(newMessage,oldMessage){let changes=[];compareAndPush(newMessage.llmStructuredRef.id,oldMessage.llmStructuredRef.id,"Model",changes);compareAndPush(newMessage.systemMessage,oldMessage.systemMessage,"System message",changes);svc.compareCompletionSettings(newMessage.completionSettings,oldMessage.completionSettings,changes);return changes}function getChatOutputClass(message){let status="";if(message.error){status="invalid"}else{status="valid"}return"prompt-chat__assistant-message--"+status}}})();
//# sourceMappingURL=sharedpack.js.map