(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('SingleColorSelectorController', function($scope, ChartColorSelection) {
        $scope.colors = [
            '#F03334', '#FF7703', '#F6C762', '#ECD941', '#82D96B', '#63E9C3',
            '#69CEF0', '#1EA8FC', '#2678B1', '#7638AF', '#BE66BF', '#EA3596',
            '#000000', '#8A8A8A', '#BABBBB', '#D2D2D2', '#E8E8E8', '#FFFFFF'
        ];

        $scope.grayBlock = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9].map(function(x) {
            const c = x / 10 * 255;
            return d3.rgb(c, c, c).toString();
        });

        $scope.getColorOptions = function(geoLayer) {
            return ChartColorSelection.getOptions($scope.chart.def, geoLayer);
        };
    });
})();
