(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    app.controller('PivotChartDefController', function($scope, ChartTypeChangeHandler, ChartColumnTypeUtils) {
        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasureWithAlphanumResults(data);
        };
        $scope.acceptDimensionOrHierarchy = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptDimensionOrHierarchy(data);
        };
        $scope.acceptColor = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data);
        };
        $scope.getXDimList = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.xHierarchyDimension : $scope.chart.def.xDimension;
        $scope.getYDimList = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.yHierarchyDimension : $scope.chart.def.yDimension;
    });
})();
