(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This directive previously was in static/dataiku/js/simple_report/config_ui.js
    app.directive('monovaluedStdAggrDimensionZone', function($parse, ChartsStaticData, ChartLabels, ChartColumnTypeUtils, ChartHierarchyDimension, Ng2MenuOrchestratorService) {
        return {
            templateUrl: '/static/dataiku/js/simple_report/directives/drag-drop/drop-zones/monovalued-std-aggr-dimension-zone/monovalued-std-aggr-dimension-zone.directive.html',
            scope: true,
            link: function($scope, element, attrs) {
                $scope.$watch(attrs.list, newList => $scope.list = newList);
                $scope.getList = $parse(attrs.getList)($scope);
                attrs.$observe('chartStoreId', (nv) => {
                    $scope.chartStoreId = nv;
                });
                attrs.$observe('chartDefKey', (nv) => {
                    $scope.chartDefKey = nv;
                });
                attrs.$observe('axisName', (nv) => {
                    $scope.axisName = nv;
                });
                $scope.isSecondDimension = $parse(attrs.isSecondDimension)($scope);
                $scope.hideOneTickPerBin = $scope.isSecondDimension;
                $scope.acceptCallback = $parse(attrs.acceptCallback)($scope);
                $scope.dateModes = ChartsStaticData.dateModes;
                $scope.ChartLabels = ChartLabels;
                $scope.isHierarchy = ChartColumnTypeUtils.isHierarchy;
                $scope.hasHierarchyWarning = ChartHierarchyDimension.hasHierarchyMissingColumns;
                $scope.getHierarchyWarningTooltip = ChartHierarchyDimension.getMissingColumnsTooltipForHierarchy;

                $scope.openMatMenu = function(menuIdx, event) {
                    Ng2MenuOrchestratorService.triggerMenuOpen($scope.chartDefKey, menuIdx, event);
                };
            }
        };
    });
})();
