(function() {
    'use strict';

    angular.module('dataiku.charts')
        .directive('discreteColorLegend', discreteColorLegend);

    /**
     * (!) This directive previously was in static/dataiku/js/simple_report/common/legends.js
     */
    function discreteColorLegend() {
        return {
            scope: true,
            templateUrl: '/static/dataiku/js/simple_report/directives/legends/discrete-color-legend/discrete-color-legend.directive.html',
            link: function($scope, element, attrs) {
                $scope.$watch(attrs.legend, function(nv, ov) {
                    $scope.legend = $scope.$eval(attrs.legend);
                });
                const defaultMaxValue = 101; // Because by default dimension.maxValues is 100 (+ room for the others bin)
                $scope.maxValues = angular.isDefined(attrs.maxValues) ? $scope.$eval(attrs.maxValues) : defaultMaxValue;

                const setStyle = function(style) {
                    const lineHeightRatio = 1.3; //  To avoid a text to be cropped in its container, we should set a lineHeight which is, in average, 33% bigger
                    const defaultFontSize = style && style.fontSize ? `${style.fontSize}px` : '13px';
                    const defaultHeight = style && style.fontSize ? `${Math.round(style.fontSize * lineHeightRatio)}px` : '13px';

                    const defaultStyle = {
                        height: defaultHeight,
                        lineHeight: defaultHeight,
                        fontSize: defaultFontSize
                    };

                    $scope.itemStyle = {
                        minHeight: defaultHeight
                    };

                    $scope.legendShapeStyle = {
                        ...defaultStyle,
                        width: defaultHeight,
                        minWidth: defaultHeight
                    };

                    $scope.legendStyle = {
                        ...defaultStyle,
                        color: style && style.fontColor ? style.fontColor : 'inherit'
                    };
                };

                setStyle($scope.chart.def.legendFormatting);

                $scope.hasFocused = false;

                $scope.showMore = function(more = defaultMaxValue) {
                    $scope.maxValues += more;
                };

                const unfocusAll = function() {
                    if ($scope.tooltips.resetColors) {
                        $scope.tooltips.resetColors();
                    }
                    if ($scope.legend.unfocusFnList) {
                        $scope.legend.unfocusFnList.forEach(currentUnFocusFn => currentUnFocusFn());
                    }
                    $scope.legend.items.forEach(function(it) {
                        if (it.focused && it.unfocusFn) {
                            it.unfocusFn();
                        }
                        it.focused = false;
                    });
                };

                let lastHoveredIndex = null;

                $scope.onLegendMouseMove = function($event) {
                    const hoveredEl = document.elementFromPoint($event.clientX, $event.clientY);
                    const legendItemEl = hoveredEl?.closest('[data-legend-index]');
                    if (!legendItemEl) {
                        return;
                    }

                    const index = parseInt(legendItemEl.getAttribute('data-legend-index'));
                    if (index === lastHoveredIndex) {
                        return;
                    }

                    lastHoveredIndex = index;
                    unfocusAll();

                    const item = $scope.legend.items[index];
                    if ($scope.tooltips.focusColor) {
                        $scope.tooltips.focusColor(index);
                    }
                    item.focused = true;
                    item.focusFn?.();
                    $scope.legend.focusFnList?.forEach(currentFocusFn => currentFocusFn(index, { displayPoints: false }));
                    $scope.hasFocused = true;
                };

                $scope.clearLegendFocus = function() {
                    lastHoveredIndex = null;
                    unfocusAll();
                    $scope.hasFocused = false;
                    if ($scope.tooltips.resetColors) {
                        $scope.tooltips.resetColors();
                    }
                };
            }
        };
    }
})();
