(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    /**
     * This filters is intended to improve readability in arrays containing large numbers (such as status display)
     * - a thousand separator is introduce to make differences between large integers, such as counters, more distinguishable.
     * - the thousand separator used is short space, to make it more neutral across regions than a US style comma
     * - the number of digits displayed is controlled by lowering accordingly the number decimals (maximum 9, with a progressive reduction to a minimum of 2).
     *
     * (!) This filter previously was in static/dataiku/js/simple_report/chart_view_commons.js
     *
     * Used for metrics and probs
     */
    app.filter('longReadableNumber', function(NumberFormatter) {
        return NumberFormatter.longReadableNumberFilter();
    });

    /**
     * This method is now defined in number-formatter.service.ts
     */
    app.filter('longSmartNumber', function(NumberFormatter) {
        return NumberFormatter.longSmartNumberFilter();
    });

    /**
     * (!) This filter previously was in static/dataiku/js/simple_report/chart_view_commons.js
     * This method is now defined in number-formatter.service.ts
     */
    app.filter('smartNumber', function(NumberFormatter) {
        return NumberFormatter.smartNumberFilter();
    });

    /**
     * (!) This filter previously was in static/dataiku/js/simple_report/chart_view_commons.js
     * This method is now defined in number-formatter.service.ts
     */
    app.filter('percentageNumber', (NumberFormatter) => {
        return NumberFormatter.percentageNumberFilter();
    });
})();
