(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('ScatterPlotChart', ScatterPlotChart);

    // (!) This service previously was in static/dataiku/js/simple_report/scatter/scatterplot.js
    function ScatterPlotChart(ChartManager, ChartDataWrapperFactory, ScatterPlotChartDrawerWebGl, ChartDataUtils, ChartAxesUtils, ReferenceLines, ColumnAvailability, ChartUsableColumns, ChartYAxisPosition, ChartCustomMeasures) {
        return function($container, chartDef, chartHandler, axesDef, data, uiDisplayState) {

            const chartData = ChartDataWrapperFactory.chartScatterDataWrapper(data, axesDef);

            const drawFrame = function(frameIdx, chartBase) {
                ReferenceLines.removeReferenceLines($container[0]);
                ScatterPlotChartDrawerWebGl($container[0], chartDef, chartHandler, chartData, chartBase, uiDisplayState);
            };

            const xDimension = chartDef.uaXDimension[0];
            const xData = data.xAxis;
            const yDimension = chartDef.uaYDimension[0];
            const yData = data.yAxis;

            const xExtent = ChartDataUtils.getUnaggregatedAxisExtent(xDimension, xData);
            const yExtent = ChartDataUtils.getUnaggregatedAxisExtent(yDimension, yData);

            const xSpec = { type: 'UNAGGREGATED', mode: 'POINTS', extent: xExtent, dimension: xDimension, customExtent: chartDef.xAxisFormatting.customExtent };
            const yAxisID = ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);
            const ySpecs = { [yAxisID]: { id: yAxisID, type: 'UNAGGREGATED', mode: 'POINTS', extent: yExtent, dimension: yDimension, customExtent: ChartAxesUtils.getYAxisCustomExtent(chartDef.yAxesFormatting, yAxisID), position: ChartYAxisPosition.LEFT } };

            const dataSpec = chartHandler.getDataSpec();
            const customMeasures = ChartCustomMeasures.getMeasuresLikeCustomMeasures(dataSpec.datasetProjectKey, dataSpec.datasetName, chartHandler.getCurrentChartsContext());
            const allMeasures = ChartUsableColumns.getUsableColumns(dataSpec.datasetProjectKey, dataSpec.datasetName, chartHandler.getCurrentChartsContext()).filter(m => ['NUMERICAL', 'ALPHANUM', 'DATE'].includes(m.type));

            ColumnAvailability.updateAvailableColumns([xDimension, yDimension], allMeasures, customMeasures);
            const displayedReferenceLines = ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines, xSpec, ySpecs),
                referenceLinesValues = ReferenceLines.getReferenceLinesValues(displayedReferenceLines, chartData, allMeasures, [xDimension, yDimension], customMeasures, false),
                referenceLinesExtents = ReferenceLines.getReferenceLinesExtents(displayedReferenceLines, referenceLinesValues);

            if (!_.isNil(xExtent.min) && !_.isNil(xExtent.max)) {
                //  Adding reference lines extent on X axis
                const xExtentWithReferenceLines = ReferenceLines.getExtentWithReferenceLines([xExtent.min, xExtent.max], referenceLinesExtents.x);
                xSpec.extent.min = xExtentWithReferenceLines[0];
                xSpec.extent.max = xExtentWithReferenceLines[1];
            }

            if (!_.isNil(yExtent.min) && !_.isNil(yExtent.max)) {
                //  Adding reference lines extent on Y axis
                const yAxisID = ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);
                const yExtentWithReferenceLines = ReferenceLines.getExtentWithReferenceLines([yExtent.min, yExtent.max], referenceLinesExtents[yAxisID]);
                ySpecs[yAxisID].extent.min = yExtentWithReferenceLines[0];
                ySpecs[yAxisID].extent.max = yExtentWithReferenceLines[1];
            }

            ReferenceLines.updateAvailableAxisOptions([
                { axis: 'X_AXIS', isDisplayed: true, isContinuousDate: ChartAxesUtils.isContinuousDate(xSpec), isNumerical: ChartAxesUtils.isNumerical(xSpec), isPercentScale: false },
                { axis: 'LEFT_Y_AXIS', isDisplayed: true, isContinuousDate: ChartAxesUtils.isContinuousDate(ySpecs[yAxisID]), isNumerical: ChartAxesUtils.isNumerical(ySpecs[yAxisID]), isPercentScale: false }
            ]);

            ChartManager.initChart(chartDef, chartHandler, chartData, $container, drawFrame,
                {
                    x: xSpec,
                    ...ySpecs
                },
                { type: 'UNAGGREGATED', dimension: chartDef.uaColor[0], data: data.values.color, withRgba: true });
        };
    }
})();
