(function () {
    'use strict';

    const app = angular.module('dataiku.webapps');

    app.controller('NewGenAIWebAppModalController', function ($scope, $controller) {
        $controller('NewWebAppModalController', { $scope: $scope });
        $scope.modalTitle = 'New Webapp';
    });

    app.controller('_GenAIWebAppsListController', function ($scope, $controller, $stateParams, DataikuAPI, $q, CreateModalFromTemplate, $state, $filter, Dialogs, WT1, PluginsService) {
        $controller('_TaggableObjectsListPageCommon', { $scope: $scope });
        $controller('WebAppsCommonController', { $scope: $scope });

        $scope.componentIds = [];

        $scope.isPluginInstalled = function (pluginId) {
            return PluginsService.checkInstalledStatus(pluginId).catch(setErrorInScope.bind($scope));
        };

        $scope.createWebappModal = function (componentId, modalTitle) {
            $scope.webappCategory = 'visual';

            CreateModalFromTemplate('/templates/webapps/new-genai-webapp-modal.html', $scope, null, function (modalScope) {
                modalScope.preselectedType = componentId;
                if (modalTitle) {
                    modalScope.modalTitle = modalTitle;
                }
                modalScope.app.configFromRole = modalScope.app.configFromRole || {};
                modalScope.app.config = modalScope.app.config || {};
            }).then(function (webapp) {
                if (webapp.backendReadyOrNoBackend) {
                    // backend up and running, go directly to view
                    $state.go('projects.project.webapps.webapp.view', { projectKey: $stateParams.projectKey, webAppId: webapp.id, webAppName: $filter('slugify')(webapp.name) });
                } else {
                    $state.go('projects.project.webapps.webapp.edit', { projectKey: $stateParams.projectKey, webAppId: webapp.id, webAppName: $filter('slugify')(webapp.name) });
                }
            });
        };

        $scope.listHeads = function (projectKey, tagsFilter) {
            const deferred = $q.defer();
            deferred.promise.success = function (callback) {
                deferred.promise.then((resp) => {
                    return callback(resp.data, resp.status, resp.headers, resp.config, resp.statusText, resp.xhrStatus);
                });
                return deferred.promise;
            };
            deferred.promise.error = function (callback) {
                deferred.promise.then(null, (resp) => callback(resp.data, resp.status, resp.headers, resp.config, resp.statusText, resp.xhrStatus));
                return deferred.promise;
            };
            DataikuAPI.webapps
                .listHeads(projectKey, tagsFilter)
                .success(function (data) {
                    data.items = data.items.filter((w) => $scope.componentIds.includes(w.type) && (!w.config || w.config.isInstalled || w.config.isInstalled == null));
                    deferred.resolve({ data: data });
                })
                .error(setErrorInScope.bind($scope));
            return deferred.promise;
        };

        $scope.sortBy = [
            { value: 'name', label: 'Name' },
            { value: '-lastModifiedOn', label: 'Last modified' },
        ];
        $scope.selection = $.extend(
            {
                filterQuery: {
                    userQuery: '',
                    tags: [],
                    interest: {
                        starred: '',
                    },
                },
                filterParams: {
                    userQueryTargets: ['name', 'tags'],
                    propertyRules: { tag: 'tags' },
                },
                orderQuery: '-lastModifiedOn',
                orderReversed: false,
            },
            $scope.selection || {}
        );

        $scope.sortCookieKey = 'webapps';
        $scope.maxItems = 20;

        // override because there is no meaningfull sharedState
        $scope.stopBackendInList = function (webapp) {
            Dialogs.confirm($scope, 'Stop webapp backend', 'Are you sure you want to stop the backend?').then(function () {
                WT1.event('webapp-stop', { webAppId: $stateParams.id, type: webapp.type });
                return DataikuAPI.webapps
                    .stopBackend(webapp)
                    .success(function () {
                        $scope.list();
                    })
                    .error(setErrorInScope.bind($scope));
            });
        };
    });

    app.controller('ChatUIsListController', function ($scope, $controller, TopNav, StateUtils) {
        $controller('_GenAIWebAppsListController', { $scope: $scope });

        const answersPluginId = 'document-question-answering';
        const answersComponentId = 'webapp_document-question-answering_document-intelligence-explorer';

        const agentConnectPluginId = 'agent-connect';
        const agentConnectComponentId = 'webapp_agent-connect_portal';
        $scope.agentConnectComponentId = agentConnectComponentId;

        const agentHubPluginId = 'agent-hub';
        const agentHubComponentId = 'webapp_agent-hub_agent-hub';

        $scope.componentIds = [answersComponentId, agentConnectComponentId, agentHubComponentId];

        $scope.isPluginInstalled(answersPluginId).then((result) => {
            $scope.answersPluginInstalled = result;
        });
        $scope.isPluginInstalled(agentConnectPluginId).then((result) => {
            $scope.agentConnectPluginInstalled = result;
        });
        $scope.isPluginInstalled(agentHubPluginId).then((result) => {
            $scope.agentHubPluginInstalled = result;
        });

        $scope.agentHubPluginUrl = StateUtils.href.pluginStore() + agentHubPluginId;

        $scope.showCreateAnswersModal = function () {
            $scope.createWebappModal(answersComponentId, 'New Dataiku Answers');
        };
        $scope.showCreateAgentConnectModal = function () {
            $scope.createWebappModal(agentConnectComponentId, 'New Agent Connect');
        };
        $scope.showCreateAgentHubModal = function () {
            $scope.createWebappModal(agentHubComponentId, 'New Agent Hub');
        };

        TopNav.setLocation(TopNav.TOP_AGENT_HUB, TopNav.LEFT_AGENT_HUB, TopNav.TABS_NONE, null);
        TopNav.setNoItem();
        $scope.list();
    });

    app.controller('TraceExplorerWebAppsListController', function ($scope, $controller, TopNav, StateUtils) {
        $controller('_GenAIWebAppsListController', { $scope: $scope });

        const traceExplorerPluginId = 'traces-explorer';
        const traceExplorerComponentId = 'webapp_traces-explorer_traces-explorer';
        $scope.componentIds = [traceExplorerComponentId];

        $scope.isPluginInstalled(traceExplorerPluginId).then((result) => {
            $scope.traceExplorerPluginInstalled = result;
        });

        $scope.traceExplorerPluginUrl = StateUtils.href.pluginStore() + traceExplorerPluginId;

        $scope.showCreateTraceExplorerModal = function (webappCategory, loadedWebApp, targetKey, targetValue, defaultName) {
            $scope.createWebappModal(traceExplorerComponentId, 'New Trace Explorer');
        };

        TopNav.setLocation(TopNav.TOP_TRACE_EXPLORERS, TopNav.LEFT_TRACE_EXPLORERS, TopNav.TABS_NONE, null);
        TopNav.setNoItem();
        $scope.list();
    });
})();
