(function() {
    "use strict";

    angular.module("dataiku.scheduleScenario")
        .controller("ScheduleScenarioModalController", ScheduleScenarioModalController);

    function ScheduleScenarioModalController(
        $scope,
        $rootScope,
        $state,
        ScheduleScenarioService,
        DataikuAPI,
        WT1,
        translate
    ) {
        const ctrl = this
        WT1.event("schedule-scenario-modal");
        const now = new Date()
        now.setSeconds(0, 0);

        $scope.warningUnusableChannelMessage = translate('SCENARIO.INTEGRATIONS.UNUSABLE_CHANNEL_WARNING', 'You are not authorized to use this channel. Sending will fail when the scenario is run by users without this authorization');

        ctrl.scenarioName = "";

        ctrl.step = {
            buildMode: "RECURSIVE_BUILD"
        };

        ctrl.buildModes = [
            ['RECURSIVE_BUILD', translate("FLOW.BUILD_SINGLE.MODE_BUTTONS.RECURSIVE_UPSTREAM", 'Build Upstream')],
            ['NON_RECURSIVE_FORCED_BUILD', translate("FLOW.BUILD_SINGLE.MODE_BUTTONS.BUILD_SINGLE_COMPUTABLE", 'Build only this')],
            ['REVERSE_FORCED_BUILD', translate("FLOW.BUILD_SINGLE.RECURSIVE_DOWNSTREAM.MODE_CHOICE.REVERSE_BUILD", 'Build all downstream')],
            ['FIND_OUTPUTS_RECURSIVE_BUILD', translate("FLOW.BUILD_SINGLE.RECURSIVE_DOWNSTREAM.MODE_CHOICE.FIND_OUTPUTS", 'Find outputs and build recursively')]
        ]

        // has to be added to the scope for TemporalTriggerController to work.
        $scope.trigger = {
            params: {
                repeatFrequency: 1,
                frequency: "Daily",
                daysOfWeek: [getDayLabels(now.getDay())],
                startingFrom: now,
                hour: now.getHours(),
                minute: now.getMinutes(),
                timezone: "SERVER"
            }
        };
        ctrl.trigger = $scope.trigger;
        ctrl.mail = {
            channelId: $rootScope.appConfig.emailChannelId,
            recipient: $rootScope.appConfig.user.email,
            send: Boolean($rootScope.appConfig.emailChannelId)
        };

        $scope.initModal = function() {
            ctrl.objectType = $scope.objectType;
            ctrl.selectedObjects = $scope.selectedObjects;
            ctrl.scenarioName = ScheduleScenarioService.createInitialScenarioName(ctrl.objectType, ctrl.selectedObjects);
            ctrl.type = ScheduleScenarioService.typeToDescription[ctrl.objectType]
        }

        ctrl.scheduleScenario = function() {
            WT1.event("schedule-scenario-create");

            const projectKey = $state.params.projectKey

            ScheduleScenarioService.createScheduledScenario(projectKey, {
                scenarioName: ctrl.scenarioName,
                triggerParams: ctrl.trigger.params,
                mail: ctrl.mail.send ? ctrl.mail : null,
                selectedObjects: ctrl.objectType !== "FLOW_ZONE" ?
                    ctrl.selectedObjects.map(object => ScheduleScenarioService.selectedObjectToTaggableObject(object))
                    : [],
                stepJob: ScheduleScenarioService.createJobDef(ctrl.step.buildMode, projectKey),
                flowZone: ctrl.objectType === "FLOW_ZONE" && ctrl.selectedObjects[0] ? ctrl.selectedObjects[0].id : null
            })
            .then(data => {
                $scope.resolveModal('Scenario created');
                $state.go('projects.project.scenarios.scenario.settings', { scenarioId: data.data.id });
            })
            .catch(setErrorInScope.bind($scope));


        }
    }
})();
