(function() {
    'use strict';

    angular.module('dataiku.shared').component('pivotFilterAlphanumericalFacet', {
        bindings: {
            filterTmpData: '<', // FilterTmpData
            folded: '<', // boolean
            filterTmpDataChange: '&', // ({ $filterTmpData }) => void
        },
        templateUrl: '/static/dataiku/shared/components/pivot-filter-alphanumerical-facet/pivot-filter-alphanumerical-facet.component.html',
        controller: function() {
            const ctrl = this;

            ctrl.onValuesSelectionChange = function(values) {
                ctrl.filterTmpDataChange({ $filterTmpData: { ...ctrl.filterTmpData, values } });
            };
        }
    });
})();
