(function() {
    'use strict';


    const relativeDateFacetComponent = {
        templateUrl: '/static/dataiku/shared/components/relative-date-facet/relative-date-facet.component.html',
        bindings: {
            datePart: '<',
            relativePreset: '<',
            relativeOption: '<',
            last: '<',
            next: '<',
            onChange: '&'
        },
        controller: function(DataikuAPI, Debounce, ChartFilterUtils, CHART_FILTERS, $element, translate) {
            const $ctrl = this;
            const CUSTOM = translate("CHARTS.FILTERS.SETTINGS.CUSTOM", "Custom");
            $ctrl.element = $element.find('div');
            $ctrl.presetDateRelativeFilterParts = [...ChartFilterUtils.getPresetDateRelativeFilterParts(), [CUSTOM, CUSTOM]];
            $ctrl.displayCustomDateRelativeFilterParts = false;
            $ctrl.customDateRelativeFilterParts = ChartFilterUtils.getCustomDateRelativeFilterParts();
            $ctrl.dateRelativeFilterComputedStart = '-';
            $ctrl.dateRelativeFilterComputedEnd = '-';
            $ctrl.isFilterEffective = false;
            $ctrl.hasNext = false;
            $ctrl.hasLast = false;
            $ctrl.currentNext = 1;
            $ctrl.currentLast = 1;
            $ctrl.facet = { 
                datePart: undefined, 
                relativeOption: getDefaultRelativeOption(), 
                relativePreset: undefined
            };
            $ctrl.selectDateRangeText = translate("COMPONENT.DATE_FACET.SELECT.PLACEHOLDER", "Select a date range");

            $ctrl.$onChanges = (changes) => {
                if (changes.datePart) {
                    $ctrl.facet.datePart = $ctrl.datePart;
                }
                if (changes.relativeOption) {
                    $ctrl.facet.relativeOption = $ctrl.relativeOption;
                    $ctrl.selectedRelativePreset = $ctrl.relativeOption == null ? undefined : $ctrl.selectedRelativePreset;
                    $ctrl.displayCustomDateRelativeFilterParts = $ctrl.selectedRelativePreset === CUSTOM; 
                }
                if (changes.relativePreset) {
                    $ctrl.facet.relativePreset = $ctrl.relativePreset;
                    if ($ctrl.relativePreset == null) {
                        $ctrl.selectedRelativePreset = $ctrl.relativeOption == null ? undefined : CUSTOM; 
                    } else {
                        $ctrl.selectedRelativePreset = $ctrl.relativePreset
                    }
                    $ctrl.displayCustomDateRelativeFilterParts = $ctrl.selectedRelativePreset === CUSTOM;
                }
                if (changes.datePart || changes.relativeOption) { 
                    updateFacetWithRelativeOption($ctrl.datePart, $ctrl.relativeOption);
                    if ($ctrl.relativeOption == null) {
                        $ctrl.selectedRelativePreset = undefined;
                        $ctrl.displayCustomDateRelativeFilterParts = false;
                    }
                }
            };

            $ctrl.onPresetDatePartChange = () => {
                if ($ctrl.selectedRelativePreset === CUSTOM) {
                    $ctrl.facet.relativePreset = undefined;
                    $ctrl.facet.datePart = $ctrl.facet.datePart == null ? CHART_FILTERS.DATE_PARTS.YEAR : $ctrl.facet.datePart;
                    $ctrl.displayCustomDateRelativeFilterParts = true;
                } else {
                    $ctrl.facet = {
                        ...ChartFilterUtils.presetRelativeToCustomRelativeDatePartMap[$ctrl.selectedRelativePreset],
                        relativePreset: $ctrl.selectedRelativePreset
                    };
                    $ctrl.displayCustomDateRelativeFilterParts = false;

                }
                emitOnChange();

            }

            $ctrl.handleCustomRelativeDateOptionChange = (relativeOption) => {
                $ctrl.facet.relativeOption = relativeOption;
                emitOnChange();
            }

            $ctrl.onDatePartChange = () => {
                emitOnChange();
            };

            $ctrl.computeRelativeDateInterval = Debounce().withDelay(100, 100).wrap(function() {
                DataikuAPI.shakers.computeRelativeDateInterval({
                    part: $ctrl.facet.datePart,
                    option: $ctrl.facet.relativeOption,
                }).success(function(interval) {
                    $ctrl.dateRelativeFilterComputedStart = interval.start;
                    $ctrl.dateRelativeFilterComputedEnd = interval.end;
                }).error(function() {
                    $ctrl.dateRelativeFilterComputedStart = '-';
                    $ctrl.dateRelativeFilterComputedEnd = '-';
                });
            });

            $ctrl.stopEventPropagation = function(event) {
                event && event.stopPropagation()
            }

            function emitOnChange() {
                updateFacetWithRelativeOption($ctrl.facet.datePart, $ctrl.facet.relativeOption);
                $ctrl.onChange({ $facet: $ctrl.facet });
            }

            function updateFacetWithRelativeOption(datePart, relativeOption) {
                $ctrl.facet.datePart =  datePart;
                $ctrl.facet.relativeOption = relativeOption == null ? getDefaultRelativeOption() : relativeOption;
                $ctrl.isFilterEffective =  ChartFilterUtils.isRelativeDateFilterEffective($ctrl.facet.datePart, $ctrl.facet.relativeOption);
                if ($ctrl.isFilterEffective) {
                    $ctrl.computeRelativeDateInterval();
                }
            }

            function getDefaultRelativeOption() {
                return {
                    containsCurrentDatePart: false,
                    isUntilNow: false,
                    last: 0,
                    next: 0
                };
            }
        }
    };

    angular.module('dataiku.shared').component('relativeDateFacet', relativeDateFacetComponent);
})();
