(function () {
    "use strict";
  
    angular.module("dataiku.shared").factory("FilterFacetsService", FilterFacetsService);

    function FilterFacetsService(DataikuAPI, Logger, MonoFuture) {
        /**
         * @param {string} projectKey
         * @param {Record<String, unknown>} dataSpec
         * @param {Record<String, unknown>} request
         * @param {string} requestedSampleId
         * @param {MonoFuture} monoFuture
         */
        function getFilterFacets(projectKey, dataSpec, request, requestedSampleId, monoFuture = MonoFuture(), visualAnalysisFullModelId = null) {
            Logger.info('Filter request is', request);

            const getFiltersExecutePromise = () => {
                if (!request) {
                    return Promise.resolve();
                }
                // If visualAnalysisFullModelId is defined it means we are in a visual analysis chart, which uses a different API endpoint than other charts.
                if (visualAnalysisFullModelId) {
                    return DataikuAPI.analysis.predicted.chartsGetPivotResponse(
                        visualAnalysisFullModelId,
                        request,
                        requestedSampleId
                    ).noSpinner();
                }
                return DataikuAPI.shakers.charts.getPivotResponse(
                    projectKey,
                    dataSpec,
                    request,
                    requestedSampleId
                ).noSpinner();
            };

            const executeFiltersPivotRequestFuture = monoFuture.wrap(getFiltersExecutePromise);

            return executeFiltersPivotRequestFuture().update(data => {
                Logger.info('Waiting for filter facets', data.jobId);
            });
        }

        return {
            getFilterFacets
        };
    }

})();
