/* global describe beforeEach, module, inject, it, expect */

function runWithGlobalHash(hash, testFn) {
    const prevHash = window._dkuAssetsHash;
    window._dkuAssetsHash = hash;
    try {
        testFn();
    } finally {
        window._dkuAssetsHash = prevHash;
    }
}

describe("assets utils", function () {
    beforeEach(module("dataiku.assetsutils"));

    it("does nothing when there is no hash (dev)", inject(function (AssetsUtils) {
        runWithGlobalHash(null, () => {
            expect(AssetsUtils.appendAssetsHash("static/dataiku/angularpack.js")).toEqual("static/dataiku/angularpack.js");
            expect(AssetsUtils.appendAssetsHash("/ngxdist/main.js")).toEqual("/ngxdist/main.js");
            expect(AssetsUtils.appendAssetsHash("image.svg.svg")).toEqual("image.svg.svg");
            expect(AssetsUtils.appendAssetsHash("/asset.css")).toEqual("/asset.css");
            expect(AssetsUtils.appendAssetsHash("/templates.js")).toEqual("/templates.js");
            expect(AssetsUtils.appendAssetsHash("image.svg")).toEqual("image.svg");
        });
    }));

    it("adds a hash when a hash is available (prod)", inject(function (AssetsUtils) {
        runWithGlobalHash("__HASH__", () => {
            expect(AssetsUtils.appendAssetsHash("static/dataiku/angularpack.js")).toEqual("static/dataiku/angularpack.hashed.__HASH__.js");
            expect(AssetsUtils.appendAssetsHash("/ngxdist/main.js")).toEqual("/ngxdist/main.hashed.__HASH__.js");
            expect(AssetsUtils.appendAssetsHash("image.svg.svg")).toEqual("image.svg.hashed.__HASH__.svg");
            expect(AssetsUtils.appendAssetsHash("/asset.css")).toEqual("/asset.hashed.__HASH__.css");
            expect(AssetsUtils.appendAssetsHash("/templates.js")).toEqual("/templates.hashed.__HASH__.js");
            expect(AssetsUtils.appendAssetsHash("image.svg")).toEqual("image.hashed.__HASH__.svg");
            expect(AssetsUtils.appendAssetsHash("image.ico")).toEqual("image.hashed.__HASH__.ico");
            expect(AssetsUtils.appendAssetsHash("templates/feature.html")).toEqual("templates/feature.hashed.__HASH__.html");

            // Except for full URLs
            expect(AssetsUtils.appendAssetsHash("http://google.com/asset.html")).toEqual("http://google.com/asset.html");
            expect(AssetsUtils.appendAssetsHash("data:text/plain,pouet")).toEqual("data:text/plain,pouet");

            // Except for URLs already containing a hash
            expect(AssetsUtils.appendAssetsHash("/dataiku/angularpack.hashed.__HASH__.js")).toEqual("/dataiku/angularpack.hashed.__HASH__.js");
            expect(AssetsUtils.appendAssetsHash("/asset.hashed.__HASH__.js")).toEqual("/asset.hashed.__HASH__.js");

            // Except for URLs containing query strings
            expect(AssetsUtils.appendAssetsHash("image.svg?version=1")).toEqual("image.svg?version=1");

            // Except for non-whitelisted extensions
            expect(AssetsUtils.appendAssetsHash("path/to/asset.txt")).toEqual("path/to/asset.txt");
        });
    }));
});
