/* global describe, it, xit, beforeEach, ChartFeaturesTestUtils */

describe('chart features scatter', function () {

    const chartType = 'scatter';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        ChartFeaturesTestUtils.setAxisSpecs(chartType);
    });

    it('has left menu filters dropzone', function () {
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');
    })

    it('has left menu dimensions options', function () {
        renderTemplate('/templates/simple_report/left-column/dimensions.html');

        expectIdToBeVisible('qa_charts_tooltip-submenu-header');
        expectIdToBeHidden('qa_charts_animation-submenu-header');
        expectIdToBeHidden('qa_charts_animation-dropzone');
        expectIdToBeHidden('qa_charts_subchart-submenu-header');
        expectIdToBeHidden('qa_charts_subcharts-dropzone');
    })

});
