from .code_studio_block import CodeStudioBlock
from .code_studio_template import CodeStudioTemplate

import os
import os.path as osp
import logging
import re

logging.basicConfig(level=logging.INFO, format='%(asctime)s %(levelname)s %(message)s')

# keep in sync with the method in build-images.py
def _get_container_property_from_config(property_name, default_value):
    DIP_HOME = os.environ["DIP_HOME"]
    try:
        path = osp.join(DIP_HOME, "config/dip.properties")
        if not os.path.exists(path):
            return default_value
        with open(path, "r") as f:
            for line in f.readlines():
                match = re.match(f"^dku.container.dataiku.{property_name}\s*=\s*(\w+)$", line)
                if match:
                    return match.group(1)
    except Exception as e:
        logging.error("Could not read dip properties json file", exc_info=e)
    return default_value

def get_dataiku_user_uid():
    return _get_container_property_from_config("uid", "500")

def get_dataiku_user_uid_gid():
    uid = get_dataiku_user_uid()
    gid = _get_container_property_from_config("gid", None)
    return f"{uid}:{gid}" if gid is not None else uid
