from dataiku.base import remoterun
from dataiku.base.utils import is_os_windows
from dataiku.doctor.exception import DoctorException

if is_os_windows():
    # We need to import joblib here so its backend is properly set on the Windows platform
    # so even the libs internally using joblib would have the backend properly set
    from dataiku.doctor.utils.skcompat import joblib

def is_global_embedding_cache_enabled():
    return remoterun.get_env_var("DKU_ENABLE_GLOBAL_EMBEDDING_CACHE", d="false").lower() == "true"
