

class DeepHubRegistry(object):

    def __init__(self):
        self.__registry = {}

    @staticmethod
    def __get_key(element_type, dummy):
        if not dummy:
            return element_type
        return "{}__dummy".format(element_type)

    def register(self, element_type, dummy, element_value):
        self.__registry[self.__get_key(element_type, dummy)] = element_value

    def get(self, element_type, dummy):
        return self.__registry[self.__get_key(element_type, dummy)]