import logging

from dataiku.core.percentage_progress import PercentageProgress
from dataiku.doctor.posttraining.model_information_handler import build_model_handler

logger = logging.getLogger(__name__)


def compute(job_id, split_desc, core_params, preprocessing_folder, model_folder, split_folder, fmi,
            train_split_desc=None):

    model_handler = build_model_handler(
        split_desc,
        core_params,
        preprocessing_folder,
        model_folder,
        split_folder,
        fmi,
        train_split_desc=train_split_desc
    )
    progress = PercentageProgress(job_id)

    if model_handler.use_full_df():
        testset, _ = model_handler.get_full_df()
    else:
        testset, _ = model_handler.get_test_df()
    model_handler.compute_global_explanations(
        testset,
        progress=progress
    )
