from enum import Enum


class ProcessingStep(Enum):
    # Preprocessing steps
    STEP_LOADING_SRC = "Loading source dataset"
    STEP_LOADING_TRAIN = "Loading train set"
    STEP_LOADING_TEST = "Loading test set"
    STEP_LOADING_EVALUATION = "Loading evaluation set"
    STEP_COLLECTING = "Collecting statistics"
    STEP_COLLECTING_PREPROCESSING_DATA = "Collecting preprocessing data"
    STEP_PREPROCESS_TRAIN = "Preprocessing train set"
    STEP_PREPROCESS_TEST = "Preprocessing test set"
    STEP_PREPROCESS_FULL = "Preprocessing full set"
    STEP_PREPROCESS_SRC = "Preprocessing data"
    STEP_PREPARE_SPLITS = "Preparing splits"
    STEP_HYPERPARAMETER_SEARCHING = "Hyperparameter searching"
    STEP_FITTING_FOR_EVAL = "Fitting for evaluation"
    STEP_FITTING = "Fitting model"
    STEP_SAVING = "Saving model"
    STEP_SAVING_DATA = "Saving data"
    STEP_SCORING = "Scoring model"
    STEP_POSTTRAINING = "Preparing explainability"
    STEP_ENSEMBLING = "Creating ensemble"
    STEP_EVAL_PROCESSING = "Running evaluation"
    STEP_EVAL_COMPUTING_METRICS_DATASET = "Computing metrics dataset"

    KFOLD_STEP_PREPROCESS_GLOBAL = "Preprocessing input"
    KFOLD_STEP_FITTING_GLOBAL = "Fitting global model"
    KFOLD_STEP_SAVING_GLOBAL = "Saving global model"  # Unused
    KFOLD_STEP_SCORING_GLOBAL = "Computing global stats"
    KFOLD_STEP_PROCESSING_FOLD = "Fitting folds"

    KERAS_STEP_FIT_NORMAL_PREPROCESSING = "Fitting preprocessors"
    KERAS_STEP_FIT_CUSTOM_PREPROCESSING = "Fitting custom preprocessors"  # Unused

    DEEPHUB_TRAINING_LOOP = "Fine-tuning model"

    STEP_TIMESERIES_RESAMPLING = "Time series resampling"
    STEP_TIMESERIES_FEATURE_GENERATION = "Time series feature generation"
    STEP_TIMESERIES_FITTING_GLOBAL = "Fitting model on full data"
    STEP_TIMESERIES_RESIDUALS = "Computing residuals"
    STEP_TIMESERIES_PERMUTATION_IMPORTANCE = "Computing permutation importance"


PRED_REGULAR_PREPROCESSING_STEPS = [
    ProcessingStep.STEP_LOADING_TRAIN,
    ProcessingStep.STEP_LOADING_TEST,
    ProcessingStep.STEP_COLLECTING,
    ProcessingStep.STEP_PREPROCESS_TRAIN,
    ProcessingStep.STEP_PREPROCESS_TEST
]

PRED_REGULAR_TRAIN_STEPS = [
    ProcessingStep.STEP_FITTING,
    ProcessingStep.STEP_SAVING,
    ProcessingStep.STEP_SCORING,
    ProcessingStep.STEP_POSTTRAINING
]

TIMESERIES_LOAD_AND_RESAMPLE_STEPS = [
    ProcessingStep.STEP_LOADING_SRC,
    ProcessingStep.STEP_TIMESERIES_RESAMPLING,
]

TIMESERIES_PREPROCESSING_STEPS = [
    ProcessingStep.STEP_COLLECTING,
    ProcessingStep.STEP_PREPROCESS_FULL,
]

TIMESERIES_REGULAR_TRAIN_STEPS = [
    ProcessingStep.STEP_FITTING_FOR_EVAL,
    ProcessingStep.STEP_SCORING,
    ProcessingStep.STEP_TIMESERIES_FITTING_GLOBAL,
]

TIMESERIES_KFOLD_TRAIN_STEPS = [
    ProcessingStep.KFOLD_STEP_PROCESSING_FOLD,
    ProcessingStep.STEP_TIMESERIES_FITTING_GLOBAL,
]

TIMESERIES_SCORING_SAVING_STEPS = [
    ProcessingStep.STEP_SAVING,
    ProcessingStep.STEP_SAVING_DATA,
]

DEEPHUB_TRAIN_STEPS = [
    ProcessingStep.STEP_LOADING_TRAIN,
    ProcessingStep.DEEPHUB_TRAINING_LOOP,
    ProcessingStep.STEP_LOADING_TEST,
    ProcessingStep.STEP_SCORING
]

PRED_KFOLD_PREPROCESSING_STEPS = [
    ProcessingStep.STEP_LOADING_SRC,
    ProcessingStep.STEP_COLLECTING,
    ProcessingStep.KFOLD_STEP_PREPROCESS_GLOBAL,
]

PRED_KFOLD_TRAIN_STEPS = [
    ProcessingStep.KFOLD_STEP_FITTING_GLOBAL,
    ProcessingStep.STEP_SAVING,
    ProcessingStep.KFOLD_STEP_SCORING_GLOBAL,
    ProcessingStep.KFOLD_STEP_PROCESSING_FOLD,
    ProcessingStep.STEP_POSTTRAINING
]

PRED_KERAS_PREPROCESSING_STEPS = [
    ProcessingStep.STEP_LOADING_TRAIN,
    ProcessingStep.STEP_LOADING_TEST,
    ProcessingStep.STEP_COLLECTING,
    ProcessingStep.STEP_PREPROCESS_TRAIN,
    ProcessingStep.STEP_PREPROCESS_TEST,
    ProcessingStep.KERAS_STEP_FIT_NORMAL_PREPROCESSING
    # KERAS_STEP_FIT_CUSTOM_PREPROCESSING
]
PRED_KERAS_TRAIN_STEPS = [
    ProcessingStep.STEP_FITTING,
    ProcessingStep.STEP_SAVING,
    ProcessingStep.STEP_SCORING
]


CLUSTERING_REGULAR_PREPROCESSING_STEPS = [
    ProcessingStep.STEP_LOADING_SRC,
    ProcessingStep.STEP_COLLECTING,
    ProcessingStep.STEP_PREPROCESS_SRC
]

ALL_CLUSTERING_TRAIN_STEPS = [
    ProcessingStep.STEP_FITTING,
    ProcessingStep.STEP_SAVING,
    ProcessingStep.STEP_SCORING
]

ENSEMBLE_STEPS = [
    ProcessingStep.STEP_ENSEMBLING,
    ProcessingStep.STEP_SAVING,
    ProcessingStep.STEP_SCORING
]
