from numpy import isnan
from math import isinf

def build_coefficient_dict():
    return {
        "values": {},
        "pvalues": {},
        "tvalues": {},
        "stderrs": {},
    }


def sanitized_stats_value(value):
    if isnan(value) or isinf(value):
        return None
    # avoid extremely small values like 1e-108
    return round(value, 16)
