def get_feature_names(preprocessor):
    """
    Handles different ways of getting the feature names of a preprocessor in scikit-learn,
    The parameter has known a deprecation cycle between 1.0 and 1.2 so the function isn't version specific but try
    to handle all cases.
    """
    if hasattr(preprocessor, 'get_feature_names_out'):
        return preprocessor.get_feature_names_out()
    else:
        return preprocessor.get_feature_names()


def get_n_stop_words_and_remove(preprocessor):
    if hasattr(preprocessor, "stop_words_"):
        # scikit-learn<1.5
        n_stop_words = len(preprocessor.stop_words_)
        preprocessor.stop_words_ = None
    else:
        # sklearn>=1.5.0 removed stop_words_ from CountVectorizer and TfidfVectorizer
        n_stop_words = -1
    return n_stop_words