from dataiku.dsscli.utils import add_formatting_args, p_format_arr, print_error, print_success
import time

def code_studio_templates_list(cmdargs, apiclient):
    all_templates = apiclient.list_code_studio_templates()
    if len(all_templates) == 0 and cmdargs.output == "fancy":
        print("no code studio templates found")
    else:
        retrieved_cols = ["template_id", "label"]
        header_cols = ["Id", "Label"]
        rows = [[tpl.id, tpl.label] for tpl in all_templates]
        p_format_arr(rows, retrieved_cols, header_cols, cmdargs)

def declare_code_studio_templates_list(subparsers):
    p = subparsers.add_parser("code-studio-templates-list", help="List available code studio templates")
    add_formatting_args(p)
    p.set_defaults(func=code_studio_templates_list)

def build_template(template):
    print("> Building %s " % template.template_id, end="")
    future = template.build()
    while not future.has_result():
        print(".", end="", flush=True)
        time.sleep(2)
    print(" ", end="")
    return future.get_result()

def code_studio_templates_build(cmdargs, apiclient):
    all_templates = apiclient.list_code_studio_templates(as_type='object')
    build = True
    if len(cmdargs.template_ids) == 0:
        templates = all_templates
    else:
        templates = []
        for template_id in cmdargs.template_ids:
            template = next((tpl for tpl in all_templates if tpl.template_id == template_id), None)
            if template is None:
                print_error("template %s not found" % template_id)
                build = False
            else:
                templates.append(template)
    if build:
        if len(templates) == 0:
            print("No code studio template to build")
        else:
            print("> Building %d code studio templates" % len(templates))
            failed = []
            for template in templates:
                ret = build_template(template)
                builds = ret.get("builds", [])
                if len(builds) > 0:
                    print_success("done")
                else:
                    print_error("failed")
                    failed.append(template.template_id)
                    logs = ret.get('futureLog', {}).get('lines', [])
                    for log in logs:
                        print("  %s" % log)
            print("\n> %d successfully built, %d failed %s" % (
                len(templates) - len(failed),
                len(failed),
                '(' + ",".join(failed) + ')' if len(failed) > 0 else ""
            ))

def declare_code_studio_templates_build(subparsers):
    p = subparsers.add_parser("code-studio-templates-build", help="List available code studio templates")
    p.add_argument("template_ids", help="Build these code studio template ids only (by default: all)", nargs='*')
    p.set_defaults(func=code_studio_templates_build)
