from dataiku.eda.types import Literal

from dataiku.eda.computations.computation import Computation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.types import CountModel, CountResultModel


class Count(Computation):
    @staticmethod
    def get_type() -> Literal["count"]:
        return "count"

    @staticmethod
    def build(params: CountModel) -> 'Count':
        return Count()

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> CountResultModel:
        return {"type": Count.get_type(), "count": len(idf)}
