from typing import Optional
from dataiku.eda.types import Literal

from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.filtering.filter import Filter
from dataiku.eda.types import NotFilterModel


class NotFilter(Filter):
    def __init__(self, sub_filter: Filter, name: Optional[str] = None):
        self.filter = sub_filter
        self.name = name

    @staticmethod
    def get_type() -> Literal["not"]:
        return "not"

    @staticmethod
    def build(params: NotFilterModel) -> 'NotFilter':
        return NotFilter(Filter.build(params["filter"]))

    def apply(self, idf: ImmutableDataFrame, inverse: bool = False) -> ImmutableDataFrame:
        return self.filter.apply(idf, inverse=not inverse)

    def serialize(self) -> NotFilterModel:
        return {"type": self.get_type(), "filter": self.filter.serialize(), "name": self.name}
