from dataiku.external_ml.proxy_model.deploy_anywhere.inputformat import DeployAnywhereWriter
from dataiku.external_ml.proxy_model.deploy_anywhere.outputformat import DeployAnywhereReader


# ##################### SAGEMAKER ###########################

def decode_sagemaker_input_logs(logs_input_data, feature_dtypes, input_format):
    if input_format == DeployAnywhereWriter.NAME:
        return DeployAnywhereWriter.decode_input_logs(logs_input_data, feature_dtypes)
    else:
        raise NotImplementedError(
            "The log input format %s is not handled by the Evaluate Recipe. "
            % input_format
            + "Please use a prepare recipe to make your input dataset compatible."
        )


def decode_sagemaker_output_logs(logs_output_data, prediction_type, value_to_class, output_format):
    if output_format == DeployAnywhereReader.NAME:
        reader = DeployAnywhereReader(prediction_type, value_to_class)
        return reader.decode_output_logs(logs_output_data)
    else:
        raise NotImplementedError(
            "The log output format %s is not handled by the Evaluate Recipe. "
            % output_format
            + "Please use a prepare recipe to make your input dataset compatible."
        )
