from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .context_compression_block import ContextCompressionBlock, _ContextCompressionBlock
    from .custom_block import CustomBlock, _CustomBlock
    from .delegate_to_other_agent_block import DelegateToOtherAgentBlock, _DelegateToOtherAgentBlock
    from .edit_last_user_message_block import EditLastUserMessageBlock, _EditLastUserMessageBlock
    from .emit_output_block import EmitOutputBlock, _EmitOutputBlock
    from .for_each_block import ForEachBlock, _ForEachBlock
    from .generate_artifact_block import GenerateArtifactBlock, _GenerateArtifactBlock
    from .llm_request_block import LLMRequestBlock, _LLMRequestBlock
    from .mandatory_tool_call_block import MandatoryToolCallBlock, _MandatoryToolCallBlock
    from .manual_tool_call_block import ManualToolCallBlock, _ManualToolCallBlock
    from .parallel_block import ParallelBlock, _ParallelBlock
    from .python_code_block import PythonCodeBlock, _PythonCodeBlock
    from .reflection_block import ReflectionBlock, _ReflectionBlock
    from .routing_block import RoutingBlock, _RoutingBlock
    from .set_scratchpad_entries_block import SetScratchpadEntriesBlock, _SetScratchpadEntriesBlock
    from .set_state_entries_block import SetStateEntriesBlock, _SetStateEntriesBlock
    from .standard_react_block import StandardReactBlock, _StandardReactBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
Via: com.dataiku.dip.dao.SavedModel$ToolsUsingAgentSettings
'''


class _BlocksGraphBlock(TypedDict):
    description: str
    id: str


# List of all concrete subclasses of com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
BlocksGraphBlock = Union[
    'ContextCompressionBlock',
    'CustomBlock',
    'DelegateToOtherAgentBlock',
    'EditLastUserMessageBlock',
    'EmitOutputBlock',
    'ForEachBlock',
    'GenerateArtifactBlock',
    'LLMRequestBlock',
    'MandatoryToolCallBlock',
    'ManualToolCallBlock',
    'ParallelBlock',
    'PythonCodeBlock',
    'ReflectionBlock',
    'RoutingBlock',
    'SetScratchpadEntriesBlock',
    'SetStateEntriesBlock',
    'StandardReactBlock',
]

# Types of class com.dataiku.dip.dao.SavedModel$BlocksGraphBlock in PolyJSON mappings (as literal type)
BlocksGraphBlockTypeLiteral = Literal["CONTEXT_COMPRESSION", "CUSTOM", "DELEGATE_TO_OTHER_AGENT", "EDIT_LAST_USER_MESSAGE", "EMIT_OUTPUT", "FOR_EACH", "GENERATE_ARTIFACT", "LLM_REQUEST", "MANDATORY_TOOL_CALL", "MANUAL_TOOL_CALL", "PARALLEL", "PYTHON_CODE", "REFLECTION", "ROUTING", "SET_SCRATCHPAD_ENTRIES", "SET_STATE_ENTRIES", "STANDARD_REACT", ]


# EOF
