from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...coremodel.simple_key_value.simple_key_value import SimpleKeyValue, _SimpleKeyValue
    from .routing_clause_based_decision import RoutingClauseBasedDecision, _RoutingClauseBasedDecision
    from .routing_mode import RoutingMode
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$RoutingBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _RoutingBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["ROUTING"]
    clausesBasedDecisions: List['RoutingClauseBasedDecision']
    defaultNextBlockIfNoClauseMatch: str
    expression: str
    llmId: str
    prompt: str
    resultDispatch: List['SimpleKeyValue']
    routingMode: 'RoutingMode'
    validNextBlocksFromExpression: List[str]


RoutingBlock = _RoutingBlock


# EOF
