from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..beta.fitted_beta import FittedBeta, _FittedBeta
    from ..binomial.fitted_binomial import FittedBinomial, _FittedBinomial
    from ..exponential.fitted_exponential import FittedExponential, _FittedExponential
    from ..laplace.fitted_laplace import FittedLaplace, _FittedLaplace
    from ..log_normal.fitted_log_normal import FittedLogNormal, _FittedLogNormal
    from ..normal.fitted_normal import FittedNormal, _FittedNormal
    from ..normal_mixture.fitted_normal_mixture import FittedNormalMixture, _FittedNormalMixture
    from ..pareto.fitted_pareto import FittedPareto, _FittedPareto
    from ..poisson.fitted_poisson import FittedPoisson, _FittedPoisson
    from ..triangular.fitted_triangular import FittedTriangular, _FittedTriangular
    from ..weibull.fitted_weibull import FittedWeibull, _FittedWeibull
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.distributions.Distribution$FittedDistribution
Via: com.dataiku.dip.eda.compute.computations.univariate.FitDistribution$FitDistributionResult
'''


class _FittedDistribution(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.distributions.Distribution$FittedDistribution
FittedDistribution = Union[
    'FittedBeta',
    'FittedBinomial',
    'FittedExponential',
    'FittedLaplace',
    'FittedLogNormal',
    'FittedNormal',
    'FittedNormalMixture',
    'FittedPareto',
    'FittedPoisson',
    'FittedTriangular',
    'FittedWeibull',
]

# Types of class com.dataiku.dip.eda.compute.distributions.Distribution$FittedDistribution in PolyJSON mappings (as literal type)
FittedDistributionTypeLiteral = Literal["beta", "binomial", "exponential", "laplace", "lognormal", "normal", "normal_mixture", "pareto", "poisson", "triangular", "weibull", ]


# EOF
