from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....agents.tools.agent_tool_runner.source import Source, _Source
    from .chat_message import ChatMessage, _ChatMessage

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$MemoryFragment
Via: com.dataiku.dip.llm.online.LLMClient$SimpleCompletionResponse
'''


class _MemoryFragment(TypedDict):
    agentLoopIteration: NotRequired[Optional[int]]
    data: NotRequired[Optional[Dict[str, Any]]]
    llmReasoning: NotRequired[Optional[Dict[str, Any]]]
    messages: List['ChatMessage']
    stashedSources: NotRequired[Optional[List['Source']]]


MemoryFragment = _MemoryFragment


# EOF
