from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...governance.guardrails_pipeline_settings.guardrails_pipeline_settings import GuardrailsPipelineSettings, _GuardrailsPipelineSettings
    from ...online.llm_client.completion_settings import CompletionSettings, _CompletionSettings
    from .guardrails_settings import GuardrailsSettings, _GuardrailsSettings
    from .rag_output_format import RAGOutputFormat
    from .retrieval_source import RetrievalSource
    from .search_input_strategy_settings import SearchInputStrategySettings, _SearchInputStrategySettings
from ..base_vector_store_query_settings.base_vector_store_query_settings import BaseVectorStoreQuerySettings, _BaseVectorStoreQuerySettings

'''
Translated from class com.dataiku.dip.llm.retrieval.RAGLLMSettings
Via: PyModel annotation in the class hierarchy
'''


class _RAGLLMSettings(_BaseVectorStoreQuerySettings, TypedDict):
    completionSettings: 'CompletionSettings'
    contextMessage: str
    guardrailsPipelineSettings: 'GuardrailsPipelineSettings'
    includeContentInSources: bool
    kbRef: str
    llmId: str
    minimumRetentionTimeSeconds: NotRequired[Optional[int]]
    outputFormat: 'RAGOutputFormat'
    printSources: bool
    ragSpecificGuardrails: 'GuardrailsSettings'
    retrievalSource: 'RetrievalSource'
    searchInputStrategySettings: 'SearchInputStrategySettings'


RAGLLMSettings = _RAGLLMSettings


# EOF
