from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....code.code_env_selection.code_env_selection import CodeEnvSelection, _CodeEnvSelection
    from ....containers.exec.container_exec_selection.container_exec_selection import ContainerExecSelection, _ContainerExecSelection
    from ....coremodel.schema_column.schema_column import SchemaColumn, _SchemaColumn
    from ....coremodel.serialized_dataset.rebuild_behavior import RebuildBehavior
    from .filter_capabilities import FilterCapabilities, _FilterCapabilities
    from .retriever_type import RetrieverType
    from .vector_store_type import VectorStoreType
from ....server.services.taggable_objects_service.taggable_object import TaggableObject, _TaggableObject

'''
Translated from class com.dataiku.dip.llm.retrieval.RetrievableKnowledge
Via: PyModel annotation in the class hierarchy
'''


class _RetrievableKnowledge(_TaggableObject, TypedDict):
    connection: str
    containerExecSelection: 'ContainerExecSelection'
    embeddingLLMId: str
    envSelection: 'CodeEnvSelection'
    filterCapabilities: 'FilterCapabilities'
    id: str
    indexName: str
    managedFolderId: NotRequired[Optional[str]]
    metadataColumnsSchema: List['SchemaColumn']
    multimodalColumn: NotRequired[Optional[str]]
    name: str
    pineconeIndexName: str
    projectKey: str
    rebuildBehavior: 'RebuildBehavior'
    resolvedIndexName: str
    retrieverType: 'RetrieverType'
    sourceIdColumn: str
    vectorStoreType: 'VectorStoreType'


RetrievableKnowledge = _RetrievableKnowledge


# EOF
