import json
import logging
from typing import Any
from typing import Dict
from typing import Optional

logger = logging.getLogger(__name__)

PROMPT_RECIPE_RAW_QUERY_NAME = 'llm_raw_query'   # Keep in sync with PromptRecipeSchemaComputer.java
PROMPT_RECIPE_RAW_RESPONSE_NAME = 'llm_raw_response'   # Keep in sync with PromptRecipeSchemaComputer.java


def _get_trajectory(prompt_recipe_raw_response: str) -> Optional[Dict[str, Any]]:
    try:
        raw_json = json.loads(prompt_recipe_raw_response)
        return raw_json["additionalInformation"]["trajectory"]
    except Exception as e:
        logger.warning(f"Can't read trajectory {prompt_recipe_raw_response}, it won't be available: {e}")
        return None
